/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/rta/command/BaseCommand","sap/ui/rta/ControlTreeModifier","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Utils","sap/base/Log","sap/base/util/merge"],function(B,R,J,F,f,L,m){"use strict";var a=B.extend("sap.ui.rta.command.FlexCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string"},jsOnly:{type:"boolean"},selector:{type:"object"}},associations:{},events:{}}});a.prototype.getElementId=function(){var e=this.getElement();return e?e.getId():this.getSelector().id;};a.prototype.getAppComponent=function(){var e=this.getElement();return e?f.getAppComponentForControl(e):this.getSelector().appComponent;};a.prototype.prepare=function(b,v){var s;if(!this.getSelector()&&b&&b.templateSelector){s={id:b.templateSelector,appComponent:this.getAppComponent(),controlType:f.getControlType(sap.ui.getCore().byId(b.templateSelector))};this.setSelector(s);}else if(!this.getSelector()&&this.getElement()){s={id:this.getElement().getId(),appComponent:this.getAppComponent(),controlType:f.getControlType(this.getElement())};this.setSelector(s);}try{this._oPreparedChange=this._createChange(b,v);}catch(e){L.error(e.message||e.name);return false;}return true;};a.prototype.getPreparedChange=function(){if(!this._oPreparedChange){this.prepare();}return this._oPreparedChange;};a.prototype.execute=function(){var c=this.getPreparedChange();return this._applyChange(c);};a.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),selector:{id:this.getElementId()}};};a.prototype._createChange=function(b,v){return this._createChangeFromData(this._getChangeSpecificData(),b,v);};a.prototype._createChangeFromData=function(c,b,v){if(b){c=m({},c,b);}c.jsOnly=this.getJsOnly();var M=this.getAppComponent().getModel(f.VARIANT_MODEL_NAME);var V;if(M&&v){V=M.getCurrentVariantReference(v);}var o=F.createForControl(this.getAppComponent());var d={variantManagementReference:v,variantReference:V};if(V){c=Object.assign({},c,d);}var C=o.createChange(c,this._validateControlForChange(b));if(b&&b.originalSelector){C.addDependentControl(b.originalSelector,"originalSelector",{modifier:J,appComponent:this.getAppComponent()});C.getDefinition().selector=J.getSelector(this.getSelector().id,this.getSelector().appComponent);C.setContent(Object.assign({},C.getContent(),b.content));}return C;};a.prototype.undo=function(){function e(M,c){var C=c.controlType?c.controlType:J.getControlType(c);var E="Undo is not possible for control type: "+C+". Reason: "+M;return E;}return Promise.resolve().then(function(){var c=this.getElement()||this.getSelector();var C=this.getPreparedChange();if(C.getRevertData()){var o=F.createForControl(this.getAppComponent());var r=o.isChangeHandlerRevertible(C,c,undefined);if(!r){L.error(e("No revert change function available to handle revert data.",c));return;}return o.revertChangesOnControl([C],this.getAppComponent(true));}else if(this._aRecordedUndo){R.performUndo(this._aRecordedUndo);}else{L.error(e("Undo is not available.",c));}}.bind(this));};a.prototype._applyChange=function(c,n){var C=c.change||c;var A=this.getAppComponent();var s=R.bySelector(C.getSelector(),A);var o=F.createForControl(A);var b=o._getControlIfTemplateAffected(C,s,s.getMetadata().getName(),{modifier:J,appComponent:A});var r=o.isChangeHandlerRevertible(C,b.control);var p={modifier:r?J:R,appComponent:A,view:f.getViewForControl(s)};if(!r){R.startRecordingUndo();}return Promise.resolve().then(function(){if(o.checkForOpenDependenciesForControl(C.getSelector(),p.modifier,A)){throw Error("The following Change cannot be applied because of a dependency: "+C.getId());}}).then(function(){return o.checkTargetAndApplyChange(C,s,p);}).then(function(d){if(d.success){if(n){o.removeFromAppliedChangesOnControl(C,A,s);}}return d;}).then(function(d){if(!r){if(!C.getUndoOperations()){this._aRecordedUndo=R.stopRecordingUndo();}else{this._aRecordedUndo=C.getUndoOperations();C.resetUndoOperations();}}if(!d.success){return Promise.reject(d.error);}}.bind(this));};a.prototype._validateControlForChange=function(b){if(b&&b.originalSelector&&b.content&&b.content.boundAggregation){return{id:b.originalSelector,appComponent:this.getAppComponent(),controlType:f.getControlType(sap.ui.getCore().byId(b.originalSelector))};}return this.getElement()||this.getSelector();};return a;},true);
