/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/theming/Parameters','sap/ui/Device','./library',"./Column",'./TableUtils',"./TableExtension",'sap/ui/core/Renderer','sap/ui/core/IconPool',"sap/base/Log"],function(C,P,D,a,b,T,c,R,I,L){"use strict";var S=a.SelectionMode;var V=a.VisibleRowCountMode;var d=a.SortOrder;var f={Begin:"flex-start",End:"flex-end",Left:undefined,Right:undefined,Center:"center"};var e={};e.render=function(r,t){delete t._iHeaderRowCount;f.Left=t._bRtlMode?"flex-end":"flex-start";f.Right=t._bRtlMode?"flex-start":"flex-end";T.getResourceBundle();r.write("<div");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROOT");r.writeControlData(t);r.addClass("sapUiTable");if(D.browser.chrome&&window.devicePixelRatio<1){r.addClass("sapUiTableZoomout");}if('ontouchstart'in document){r.addClass("sapUiTableTouch");}r.addClass("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.addClass("sapUiTableCHdr");}if(T.hasRowHeader(t)){r.addClass("sapUiTableRowSelectors");}if(T.hasRowHighlights(t)){r.addClass("sapUiTableRowHighlights");}var s=a.TableHelper.addTableClass();if(s){r.addClass(s);}var o=t._getScrollExtension();if(o.isVerticalScrollbarRequired()&&!o.isVerticalScrollbarExternal()){r.addClass("sapUiTableVScr");}if(t.getEditable()){r.addClass("sapUiTableEdt");}if(T.hasRowActions(t)){var i=T.getRowActionCount(t);r.addClass(i==1?"sapUiTableRActS":"sapUiTableRAct");}if(T.isNoDataVisible(t)&&!T.hasPendingRequests(t)){r.addClass("sapUiTableEmpty");}if(t.getShowOverlay()){r.addClass("sapUiTableOverlay");}var m=T.Grouping.getModeCssClass(t);if(m){r.addClass(m);}if(t.getWidth()){r.addStyle("width",t.getWidth());}if(t.getVisibleRowCountMode()==V.Auto){r.addStyle("height","0px");if(t._bFirstRendering){r.addClass("sapUiTableNoOpacity");}}r.writeClasses();r.writeStyles();r.write(">");this.renderTabElement(r,"sapUiTableOuterBefore");if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCnt");r.addClass("sapUiTableCnt");r.writeClasses();r.writeAttribute("data-sap-ui-fastnavgroup","true");r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableGridCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTENT");r.write(">");this.renderColRsz(r,t);this.renderColHdr(r,t);this.renderTable(r,t);r.write("</div>");var g=t.getCreationRow();if(g){r.renderControl(g);this.renderHSbBackground(r,t);this.renderHSb(r,t);}t._getAccRenderExtension().writeHiddenAccTexts(r,t);r.write("<div");r.addClass("sapUiTableOverlayArea");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-overlay");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"OVERLAY");r.write("></div>");r.write("</div>");if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==V.Interactive){this.renderVariableHeight(r,t);}this.renderTabElement(r,"sapUiTableOuterAfter");r.write("</div>");};e.renderHeader=function(r,t,o){r.write("<div");r.addClass("sapUiTableHdr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEHEADER");r.write(">");r.renderControl(o);r.write("</div>");};e.renderToolbar=function(r,t,o){if(!T.isA(o,"sap.ui.core.Toolbar")){return;}r.write("<div");r.addClass("sapUiTableTbr");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}if(o.isA("sap.m.Toolbar")){o.setDesign("Transparent",true);o.addStyleClass("sapMTBHeader-CTX");r.addClass("sapUiTableMTbr");}r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");r.renderControl(o);r.write("</div>");};e.renderExtensions=function(r,t,E){for(var i=0,l=E.length;i<l;i++){this.renderExtension(r,t,E[i]);}};e.renderExtension=function(r,t,E){r.write("<div");r.addClass("sapUiTableExt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");r.renderControl(E);r.write("</div>");};e.renderTable=function(r,t){this.renderTabElement(r,"sapUiTableCtrlBefore");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCCnt");r.addClass("sapUiTableCCnt");r.writeClasses();r.write(">");this.renderTableCCnt(r,t);r.write("</div>");this.renderTabElement(r,"sapUiTableCtrlAfter");if(!t._getScrollExtension().isVerticalScrollbarExternal()){this.renderVSbBackground(r,t);this.renderVSb(r,t);}var o=t.getCreationRow();if(!o){this.renderHSbBackground(r,t);this.renderHSb(r,t);}};e.renderTableCCnt=function(r,t){this.renderTableCtrl(r,t);this.renderRowHdr(r,t);this.renderRowActions(r,t);r.write("<div");r.addClass("sapUiTableCtrlEmpty");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-noDataCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"NODATA");r.write(">");if(t.getNoData()instanceof C){r.renderControl(t.getNoData());}else{r.write("<span");r.writeAttribute("id",t.getId()+"-noDataMsg");r.addClass("sapUiTableCtrlEmptyMsg");r.writeClasses();r.write(">");r.writeEscaped(T.getNoDataText(t));r.write("</span>");}r.write("</div>");};e.renderFooter=function(r,t,F){r.write("<div");r.addClass("sapUiTableFtr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEFOOTER");r.write(">");r.renderControl(F);r.write("</div>");};e.renderVariableHeight=function(r,t){r.write('<div id="'+t.getId()+'-sb" tabindex="-1"');r.addClass("sapUiTableHeightResizer");r.addStyle("height","5px");r.writeClasses();r.writeStyles();r.write(">");r.write("</div>");};e.renderColHdr=function(r,t){var n=T.getHeaderRowCount(t);var g=t.getColumns();var F=t.getComputedFixedColumnCount();r.write("<div");r.addClass("sapUiTableColHdrCnt");r.writeClasses();r.write(">");this.renderColRowHdr(r,t);if(F>0){r.write("<div");r.addClass("sapUiTableCHA");r.addClass("sapUiTableCtrlScrFixed");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");this.renderTableControlCnt(r,t,true,0,F,true,false,0,n,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableColHdrScr");r.addClass("sapUiTableCHA");r.addClass("sapUiTableCtrlScr");if(g.length==0){r.addClass("sapUiTableHasNoColumns");}r.writeClasses();if(F>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");this.renderTableControlCnt(r,t,false,F,g.length,false,false,0,n,true);r.write("</div>");if(T.hasRowActions(t)){r.write("<div");r.writeAttribute("id",t.getId()+"-rowacthdr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWACTIONHEADER");r.addClass("sapUiTableCell");r.addClass("sapUiTableHeaderCell");r.addClass("sapUiTableRowActionHeaderCell");r.writeClasses();r.write(">");r.write("<span>");r.writeEscaped(T.getResourceText("TBL_ROW_ACTION_COLUMN_LABEL"));r.write("</span>");r.write("</div>");}r.write("</div>");};e.renderColRowHdr=function(r,t){var E=false;var s=false;var m=t._oSelectionPlugin.getRenderConfig();r.write("<div");r.writeAttribute("id",t.getId()+"-selall");r.addClass("sapUiTableCell");r.addClass("sapUiTableHeaderCell");r.addClass("sapUiTableRowSelectionHeaderCell");if(T.hasSelectAll(t)){var A=T.areAllRowsSelected(t);if(t._getShowStandardTooltips()&&m.headerSelector.visible){var g;if(m.headerSelector.type==="toggle"){g=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(m.headerSelector.type==="clear"){g="TBL_DESELECT_ALL";}if(g){r.writeAttributeEscaped("title",T.getResourceText(g));}}if(!A){r.addClass("sapUiTableSelAll");}else{s=true;}r.addClass("sapUiTableSelAllEnabled");E=true;}else{r.addClass("sapUiTableSelAllDisabled");}r.writeClasses();r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNROWHEADER",{enabled:E,checked:s});r.write(">");if(t.getSelectionMode()!==S.Single&&m.headerSelector.visible){if(m.headerSelector.type==="clear"&&m.headerSelector.icon){r.renderControl(m.headerSelector.icon);}else{r.write("<div");r.addClass("sapUiTableSelectAllCheckBox");r.writeClasses();r.write("></div>");}}r.write("</div>");};e.renderCol=function(r,t,o,h,n,i,g,j,k){var l,m=!n,p=o.getIndex(),q=o.getMultiLabels();if(q.length>0){l=q[h];}else if(h==0){l=o.getLabel();}r.write("<td");var H=o.getId();if(h===0){r.writeElementData(o);}else{H=H+"_"+h;r.writeAttribute('id',H);}r.writeAttribute('data-sap-ui-colid',o.getId());r.writeAttribute("data-sap-ui-colindex",p);r.writeAttribute("tabindex","-1");var A={column:o,headerId:H,index:p};if(n>1){r.writeAttribute("colspan",n);A.colspan=true;}if(k){var F=o.getFiltered();var s=o.getSorted();if(F){r.addClass("sapUiTableColFiltered");}if(s){r.addClass("sapUiTableColSorted");if(o.getSortOrder()===d.Ascending){r.addClass("sapUiTableColSortedD");}}}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER",A);r.addClass("sapUiTableCell");r.addClass("sapUiTableHeaderCell");r.addClass("sapUiTableHeaderDataCell");if(t.getEnableColumnReordering()||t.hasListeners("columnSelect")||o._menuHasItems()){r.addClass("sapUiTableHeaderCellActive");}if(i){r.addClass("sapUiTableCellFirst");}if(g){r.addClass("sapUiTableCellLastFixed");}if(j){r.addClass("sapUiTableCellLast");}if(m){r.addClass("sapUiTableHidden");}r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}r.writeStyles();var u=o.getTooltip_AsString();if(u){r.writeAttributeEscaped("title",u);}r.write("><div");r.addClass("sapUiTableCellInner");r.writeAttribute("id",H+"-inner");r.writeClasses();var v=o.getHAlign();var w=R.getTextAlign(v);if(w){r.addStyle("text-align",w);}r.writeStyles();r.write(">");r.write("<div");r.addStyle("justify-content",f[v]);r.writeStyles();r.write(">");if(l){r.renderControl(l);}r.write("</div>");r.write("</div></td>");};e.renderColRsz=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-rsz");r.addClass("sapUiTableColRsz");r.writeClasses();r.write("></div>");};e.renderRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowHdrScr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.addClass("sapUiTableRowHdrScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_COL");r.write(">");for(var g=0,h=t.getRows().length;g<h;g++){this.renderRowAddon(r,t,t.getRows()[g],g,true);}r.write("</div>");};e.renderRowActions=function(r,t){if(!T.hasRowActions(t)){return;}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowActionScr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.addClass("sapUiTableRowActionScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");for(var g=0,h=t.getRows().length;g<h;g++){this.renderRowAddon(r,t,t.getRows()[g],g,false);}r.write("</div>");};e.addRowCSSClasses=function(r,t,i){var F=t.getFixedRowCount();var g=T.getFirstFixedBottomRowIndex(t);if(i===0){r.addClass("sapUiTableFirstRow");}else if(i===t.getRows().length-1){r.addClass("sapUiTableLastRow");}if(F>0){if(i==F-1){r.addClass("sapUiTableRowLastFixedTop");}}if(g>=0&&g===i){r.addClass("sapUiTableRowFirstFixedBottom");}else if(g>=1&&g-1===i){r.addClass("sapUiTableRowLastScrollable");}};e.renderRowAddon=function(r,t,o,i,h){var g=t.isIndexSelected(o.getIndex());r.write("<div");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i,rowHidden:o._bHidden});r.writeAttribute("data-sap-ui-related",o.getId());r.writeAttribute("data-sap-ui-rowindex",i);r.addClass("sapUiTableRow");r.addClass("sapUiTableContentRow");if(o._bHidden){r.addClass("sapUiTableRowHidden");}else if(g){r.addClass("sapUiTableRowSel");}if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.addClass("sapUiTableRowAlternate");}this.addRowCSSClasses(r,t,i);r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+(h?"-rowsel":"-rowact")+i);r.addClass("sapUiTableCell");r.addClass("sapUiTableContentCell");r.addClass(h?"sapUiTableRowSelectionCell":"sapUiTableRowActionCell");r.writeClasses();if(t.getRowHeight()>0){r.addStyle("height",t._getDefaultRowHeight()+"px");}r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"ROWHEADER":"ROWACTION",{rowSelected:g,rowHidden:o._bHidden});r.writeStyles();r.write(">");if(h){this.writeRowHighlightContent(r,t,o,i);this.writeRowSelectorContent(r,t,o,i);}else{var A=o.getRowAction();if(A){r.renderControl(A);}}r.write("</div>");r.write("</div>");};e.renderTableCtrl=function(r,t){if(t.getComputedFixedColumnCount()>0){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScrFixed");r.addClass("sapUiTableCtrlScrFixed");r.writeClasses();r.write(">");this.renderTableControl(r,t,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScr");r.addClass("sapUiTableCtrlScr");r.writeClasses();if(t.getComputedFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCtrlCnt");r.addClass("sapUiTableCtrlCnt");r.writeClasses();if(!T.isVariableRowHeightEnabled(t)){var v=t.getVisibleRowCountMode();if(t._iTableRowContentHeight&&(v==V.Fixed||v==V.Interactive)){var s="height";if(t.getVisibleRowCountMode()==V.Fixed){s="min-height";}r.addStyle(s,t._iTableRowContentHeight+"px");r.writeStyles();}}r.write(">");this.renderTableControl(r,t,false);r.write("</div></div>");};e.renderTableControl=function(r,t,F){var s,E;if(F){s=0;E=t.getComputedFixedColumnCount();}else{s=t.getComputedFixedColumnCount();E=t.getColumns().length;}var i=t.getFixedRowCount();var g=t.getFixedBottomRowCount();var h=t.getRows();if(i>0){this.renderTableControlCnt(r,t,F,s,E,true,false,0,i);}this.renderTableControlCnt(r,t,F,s,E,false,false,i,h.length-g);if(g>0&&h.length>0){this.renderTableControlCnt(r,t,F,s,E,false,true,h.length-g,h.length);}};e.renderTableControlCnt=function(r,t,F,s,E,g,h,i,j,H){r.write("<table");var k=H?"-header":"-table";var l=t.getId()+k;if(F){l+="-fixed";r.addClass("sapUiTableCtrlFixed");}else{r.addClass("sapUiTableCtrlScroll");}if(g){l+="-fixrow";r.addClass("sapUiTableCtrlRowFixed");}else if(h){l+="-fixrow-bottom";r.addClass("sapUiTableCtrlRowFixedBottom");}else{r.addClass("sapUiTableCtrlRowScroll");}r.writeAttribute("id",l);t._getAccRenderExtension().writeAriaAttributesFor(r,t,H?"COLUMNHEADER_TABLE":"TABLE");r.addClass("sapUiTableCtrl");if(H){r.addClass("sapUiTableCHT");}r.writeClasses();r.addStyle(F?"width":"min-width",t._getColumnsWidth(s,E)+"px");r.writeStyles();r.write(">");r.write("<thead>");r.write("<tr");r.addClass("sapUiTableCtrlCol");if(i==0){r.addClass("sapUiTableCtrlFirstCol");}if(H){r.addClass("sapUiTableCHTHR");}r.writeClasses();r.write(">");var m=t.getColumns();var n=new Array(E);var o;var p;var q=!F&&E>s;for(o=s;o<E;o++){p=m[o];var u={shouldRender:!!(p&&p.shouldRender())};if(u.shouldRender){var w=p.getWidth();if(T.isVariableWidth(w)){q=false;if(F){p._iFixWidth=p._iFixWidth||160;w=p._iFixWidth+"px";}}else if(F){delete p._iFixWidth;}u.width=w;}n[o]=u;}if(m.length===0){r.write("<th></th>");}for(o=s;o<E;o++){k=H?"_hdr":"_col";p=m[o];u=n[o];if(u.shouldRender){r.write("<th");if(u.width){r.addStyle("width",u.width);r.writeStyles();}if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH",{column:p});r.writeAttribute("id",t.getId()+k+o);}r.writeAttribute("data-sap-ui-headcolindex",o);r.writeAttribute("data-sap-ui-colid",p.getId());r.write(">");if(i==0&&T.getHeaderRowCount(t)==0&&!H){if(p.getMultiLabels().length>0){r.renderControl(p.getMultiLabels()[0]);}else{r.renderControl(p.getLabel());}}r.write("</th>");}}if(q){r.write("<th");if(H){r.writeAttribute("id",t.getId()+"-dummycolhdr");}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write("></th>");}r.write("</tr>");r.write("</thead>");r.write("<tbody>");var v=t._getVisibleColumns();var x=t.getRows();var y;var z;if(H){for(y=i,z=j;y<z;y++){this.renderColumnHeaderRow(r,t,y,F,s,E,q,y===z-1);}}else{var A=t._getAccExtension().getAriaTextsForSelectionMode(true);var B=T.isRowSelectionAllowed(t);var G=t.getDragDropConfig().some(function(J){return J.getMetadata().isInstanceOf("sap.ui.core.dnd.IDragInfo")&&J.getSourceAggregation()==="rows";});for(y=i,z=j;y<z;y++){this.renderTableRow(r,t,x[y],y,F,s,E,false,v,q,A,B,G);}}r.write("</tbody>");r.write("</table>");};e.writeRowSelectorContent=function(r,t,o,i){t._getAccRenderExtension().writeAccRowSelectorText(r,t,o,i);if(T.Grouping.isGroupMode(t)){r.write("<div");r.writeAttribute("class","sapUiTableGroupShield");r.write("></div>");r.write("<div");r.writeAttribute("id",o.getId()+"-groupHeader");r.writeAttribute("class","sapUiTableGroupIcon");r.write("></div>");if(T.Grouping.showGroupMenuButton(t)){var g=I.getIconInfo("sap-icon://drop-down-list");r.write("<div class='sapUiTableGroupMenuButton'>");r.writeEscaped(g.content);r.write("</div>");}}};e.writeRowHighlightContent=function(r,t,o,i){if(!T.hasRowHighlights(t)){return;}var g=o.getAggregation("_settings");var h=g._getHighlightCSSClassName();r.write("<div");r.writeAttribute("id",o.getId()+"-highlight");r.addClass("sapUiTableRowHighlight");r.addClass(h);r.writeClasses();r.write(">");t._getAccRenderExtension().writeAccRowHighlightText(r,t,o,i);r.write("</div>");};e.renderColumnHeaderRow=function(r,t,i,F,s,E,h,l){r.write("<tr");r.addClass("sapUiTableRow");r.addClass("sapUiTableHeaderRow");r.addClass("sapUiTableColHdrTr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER_ROW");r.write(">");var g,n=0,j=-1;g=t.getColumns().slice(s,E).filter(function(o){return o&&o.shouldRender();});function k(o,p,q){var u=T.Column.getHeaderSpan(o,i),v;if(n<1){if(u>1){v=o.getIndex();u=q.slice(p+1,p+u).reduce(function(w,x){return x.getIndex()-v<u?w+1:w;},1);}o._nSpan=n=u;j=p;}else{o._nSpan=0;}n--;}g.forEach(k);function m(o,p){this.renderCol(r,t,o,i,o._nSpan,p===0,F&&(p==j),!F&&(p==j),o._nSpan===1&&!o._bIconsRendered);o._bIconsRendered=o._bIconsRendered||o._nSpan===1;delete o._nSpan;if(l){delete o._bIconsRendered;}}g.forEach(m.bind(this));if(!F&&h&&g.length>0){r.write('<td class="sapUiTableCellDummy"');t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write('></td>');}r.write("</tr>");};e.renderTableRow=function(r,t,o,i,F,s,E,g,v,h,m,j,k){if(!o){return;}r.write("<tr");if(o._bDummyRow){r.addStyle("opacity","0");}r.addClass("sapUiTableRow");r.addClass("sapUiTableContentRow");r.addClass("sapUiTableTr");if(F){r.writeAttribute("id",o.getId()+"-fixed");r.writeAttribute("data-sap-ui-related",o.getId());}else{r.writeElementData(o);}if(o._bHidden){r.addClass("sapUiTableRowHidden");}else{if(k&&F){r.writeAttribute("draggable",true);}if(t.isIndexSelected(o.getIndex())){r.addClass("sapUiTableRowSel");}}if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.addClass("sapUiTableRowAlternate");}this.addRowCSSClasses(r,t,i);r.writeClasses();r.writeAttribute("data-sap-ui-rowindex",i);if(t.getRowHeight()>0){r.addStyle("height",t._getDefaultRowHeight()+"px");}r.writeStyles();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i,rowHidden:o._bHidden});r.write(">");var l=!o._bHidden&&t.isIndexSelected(o.getIndex());var n=o.getCells();for(var p=0,q=n.length;p<q;p++){this.renderTableCell(r,t,o,n[p],p,F,s,E,v,l);}if(!F&&h&&n.length>0){r.write('<td class="sapUiTableCellDummy"');t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write('></td>');}r.write("</tr>");};e.renderTableCell=function(r,t,o,g,i,F,s,E,v,h){var j=b.ofCell(g);var k=j.getIndex();var l=t.getColumns()[t.getFixedColumnCount()-1];if(j.shouldRender()&&s<=k&&E>k){r.write("<td");var m=o.getId()+"-col"+i;r.writeAttribute("id",m);r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-ui-colid",j.getId());var n=v.length;var p=n>0&&v[0]===j;var q=n>0&&v[n-1]===j;var u=F&l===j;t._getAccRenderExtension().writeAriaAttributesFor(r,t,"DATACELL",{index:k,column:j,row:o,fixed:F,rowSelected:h});var w=R.getTextAlign(j.getHAlign());if(w){r.addStyle("text-align",w);}r.writeStyles();r.addClass("sapUiTableCell");r.addClass("sapUiTableContentCell");r.addClass("sapUiTableDataCell");if(p){r.addClass("sapUiTableCellFirst");}if(u){r.addClass("sapUiTableCellLastFixed");}if(q){r.addClass("sapUiTableCellLast");}var B=t.getBinding("rows");if(B&&j.getLeadingProperty&&B.isMeasure(j.getLeadingProperty())){r.addClass("sapUiTableMeasureCell");}r.writeClasses();r.write("><div");r.addClass("sapUiTableCellInner");if(p&&T.Grouping.isTreeMode(t)){r.addClass("sapUiTableCellFlex");}r.writeClasses();if(t.getRowHeight()>0&&(t.getVisibleRowCountMode()==V.Auto||t.hasStyleClass("sapUiTableFixedRowHeights"))){r.addStyle("max-height",t.getRowHeight()+"px");}r.writeStyles();r.write(">");this.renderTableCellControl(r,t,g,p);r.write("</div></td>");}};e.renderTableCellControl=function(r,t,o,i){if(i&&T.Grouping.isTreeMode(t)&&!t._bFlatMode){var g=o.getParent();r.write("<span class='sapUiTableTreeIcon' tabindex='-1' id='"+g.getId()+"-treeicon'");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TREEICON",{row:g});r.write("></span>");}r.renderControl(o);};e.renderVSb=function(r,t,m){m=Object.assign({cssClass:"sapUiTableVSb",tabIndex:true,hidden:true},m);m.id=t.getId()+"-vsb";var s=t._getScrollExtension();r.write("<div");r.addClass(m.cssClass);if(m.hidden){r.addClass("sapUiTableHidden");}r.writeClasses();r.writeAttribute("id",m.id);if(m.tabIndex){r.writeAttribute("tabindex","-1");}r.addStyle("max-height",s.getVerticalScrollbarHeight()+"px");if(t.getFixedRowCount()>0){t._iVsbTop=(t.getFixedRowCount()*t._getDefaultRowHeight())-1;r.addStyle("top",t._iVsbTop+'px');}r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",m.id+"-content");r.addClass("sapUiTableVSbContent");r.writeClasses();r.addStyle("height",s.getVerticalScrollHeight()+"px");r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");};e.renderVSbExternal=function(r,t){if(c.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){this.renderVSb(r,t,{cssClass:"sapUiTableVSbExternal",tabIndex:false});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};e.renderVSbBackground=function(r,t){r.write("<div");r.addClass("sapUiTableVSbBg");r.writeAttribute("id",t.getId()+"-vsb-bg");r.writeClasses();r.write("></div>");};e.renderHSb=function(r,t,m){m=Object.assign({id:t.getId()+"-hsb",cssClass:"sapUiTableHSb",tabIndex:true,hidden:true,scrollWidth:0},m);r.write("<div");r.addClass(m.cssClass);if(m.hidden){r.addClass("sapUiTableHidden");}r.writeClasses();r.writeAttribute("id",m.id);if(m.tabIndex){r.writeAttribute("tabindex","-1");}r.write(">");r.write("<div");r.writeAttribute("id",m.id+"-content");r.addClass("sapUiTableHSbContent");r.writeClasses();if(m.scrollWidth>0){r.addStyle("width",m.scrollWidth+"px");}r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");};e.renderHSbExternal=function(r,t,i,s){if(c.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){this.renderHSb(r,t,{id:i,cssClass:"sapUiTableHSbExternal",tabIndex:false,hidden:false,scrollWidth:s});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};e.renderHSbBackground=function(r,t){r.write("<div");r.addClass("sapUiTableHSbBg");r.writeAttribute("id",t.getId()+"-hsb-bg");r.writeClasses();r.write("></div>");};e.renderTabElement=function(r,s){r.write("<div");if(s){r.addClass(s);r.writeClasses();}r.writeAttribute("tabindex","0");r.write("></div>");};return e;},true);
