/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/CalendarDate','./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale','sap/ui/events/KeyCodes',"./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,D,H,M,b,Y,c,l,d,e,R,f,K,g,h,j,k,q){"use strict";var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var s=sap.ui.getCore().getConfiguration().getLocale().getLanguage();var m=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});m.prototype.init=function(){this._iBreakPointTablet=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._iColumns=1;this._oYearFormat=e.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var z=this._createMonth(this.getId()+"--Month0");z.attachEvent("focus",this._handleFocus,this);z.attachEvent("select",u,this);z.attachEvent("_renderMonth",t,this);z.attachEvent("_bindMousemove",v,this);z.attachEvent("_unbindMousemove",w,this);z._bNoThemeChange=true;this.addAggregation("month",z);this._initilizeMonthPicker();this._initilizeYearPicker();this._resizeProxy=q.proxy(x,this);this._oSelectedMonth;};m.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};m.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);i.attachEvent("pressButton3",this._handleButton1,this);i.attachEvent("pressButton4",this._handleButton2,this);this.setAggregation("header",i);};m.prototype._initializeSecondMonthHeader=function(){var S=new H(this.getId()+"--SecondMonthHead");S.addStyleClass("sapUiCalHeadSecondMonth");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);S.attachEvent("pressButton1",this._handleButton1,this);S.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("secondMonthHeader",S);};m.prototype._initilizeMonthPicker=function(){var i=new b(this.getId()+"--MP");i.attachEvent("select",this._selectMonth,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);};m.prototype._initilizeYearPicker=function(){var i=new Y(this.getId()+"--YP");i.attachEvent("select",this._selectYear,this);this.setAggregation("yearPicker",i);};m.prototype._createMonth=function(i){var z=new M(i,{width:"100%"});z.attachEvent("datehovered",this._handleDateHovered,this);z.attachEvent("weekNumberSelect",this._handleWeekNumberSelect,this);return z;};m.prototype._handleWeekNumberSelect=function(E){var i=this.fireWeekNumberSelect({weekNumber:E.getParameter("weekNumber"),weekDays:E.getParameter("weekDays")});if(!i){E.preventDefault();}return this;};m.prototype._handleDateHovered=function(E){var z=this.getAggregation("month"),A=E.getParameter("date1"),B=E.getParameter("date2"),i;for(i=0;i<z.length;i++){z[i]._markDatesBetweenStartAndHoveredDate(A,B);}};m.prototype.onBeforeRendering=function(){var z=this.getAggregation("month");var A;var B=z[0].getDate();var F=this._getFocusedDate();if(z.length>1&&B){A=c.fromLocalJSDate(B,this.getPrimaryCalendarType());}else if(z.length>1){A=y.call(this,this._getFocusedDate());}else{A=F;}for(var i=0;i<z.length;i++){B=new c(A);if(i>0){B.setDate(1);B.setMonth(B.getMonth()+i);}var E=B;if(F.getYear()===B.getYear()&&F.getMonth()===B.getMonth()){E=F;}z[i].displayDate(E.toLocalJSDate());z[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(A);this._iSize=0;};m.prototype.onAfterRendering=function(E){if(!this._getSucessorsPickerPopup()){n.call(this);}if(r.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};x.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};m.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof D))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=setTimeout(this._invalidateMonth.bind(this,O),0);}};m.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};m.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};m.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};m.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};m.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};m.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};m.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};m.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};m.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};m.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};m.prototype._getFocusedDate=function(){if(!this._oFocusedDate){_.call(this);}return this._oFocusedDate;};m.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new c(i,this.getPrimaryCalendarType());};m.prototype.focusDate=function(i){p.call(this,i,false);return this;};m.prototype.displayDate=function(i){p.call(this,i,true);return this;};m.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=c.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new c(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};m.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};m.prototype.setMonths=function(z){this._bDateRangeChanged=undefined;this.setProperty("months",z,false);z=r.call(this);var A=this.getAggregation("month");var i=0;var B;if(A.length<z){for(i=A.length;i<z;i++){B=this._createMonth(this.getId()+"--Month"+i);B.attachEvent("focus",this._handleFocus,this);B.attachEvent("select",u,this);B.attachEvent("_renderMonth",t,this);B.attachEvent("_bindMousemove",v,this);B.attachEvent("_unbindMousemove",w,this);B._bNoThemeChange=true;this.addAggregation("month",B);}}else if(A.length>z){for(i=A.length;i>z;i--){B=this.removeAggregation("month",i-1);B.destroy();}if(z==1){this._bInitMonth=true;}}if(z>1&&A[0].getDate()){A[0].setProperty("date",null,true);}return this;};m.prototype.setPrimaryCalendarType=function(z){var A=this.getAggregation("month");var B=false;if(A.length>1){B=true;}this.setProperty("primaryCalendarType",z,!B);this._oYearFormat=e.getDateInstance({format:"y",calendarType:z});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,z);}this._oMinDate=new c(this._oMinDate,z);this._oMaxDate=new c(this._oMaxDate,z);for(var i=0;i<A.length;i++){var E=A[i];E.setPrimaryCalendarType(z);}if(!this._getSucessorsPickerPopup()){var F=this.getAggregation("monthPicker");F.setPrimaryCalendarType(z);var G=this.getAggregation("yearPicker");G.setPrimaryCalendarType(z);}if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(!this._getSucessorsPickerPopup()){if(this.iMode!=1&&F.getDomRef()){F.$().remove();}if(this.iMode!=2&&G.getDomRef()){G.$().remove();}}}return this;};m.prototype.setSecondaryCalendarType=function(z){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",z,true);this._oYearFormatSecondary=e.getDateInstance({format:"y",calendarType:z});var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];B.setSecondaryCalendarType(z);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};m.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};m.prototype.setMinDate=function(i){if(j(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var z=this._oMinDate.getYear();a._checkYearInValidRange(z);if(this._oMaxDate.isBefore(this._oMinDate)){k.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){var A=this.getAggregation("yearPicker");A._oMinDate.setYear(this._oMinDate.getYear());}return this;};m.prototype.setMaxDate=function(i){if(j(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var z=this._oMaxDate.getYear();a._checkYearInValidRange(z);if(this._oMinDate.isAfter(this._oMaxDate)){k.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){var A=this.getAggregation("yearPicker");A._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};m.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){k.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};m.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var z=new f(i);this._oLocaleData=L.getInstance(z);}return this._oLocaleData;};m.prototype._getShowMonthHeader=function(){var i=r.call(this);if(i>2){return true;}else{return false;}};m.prototype.setWidth=function(W){this.setProperty("width",W,true);if(this.getDomRef()){W=this.getWidth();this.$().css("width",W);if(W){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};m.prototype.onclick=function(E){var i=E.target;if(E.isMarked("delayedMouseEvent")){return;}if(i.id==this.getId()+"-cancel"){this.onsapescape(E);}};m.prototype.onmousedown=function(E){if(E.cancelable){E.preventDefault();}E.setMark("cancelAutoClose");};m.prototype.onsapescape=function(E){this.fireCancel();this._closedPickers();};m.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};m.prototype.onkeydown=function(E){var i=E.which||E.keyCode,S=E.shiftKey;if(this._getSucessorsPickerPopup()||i!==K.F4){return;}E.preventDefault();S?this._showYearPicker():this._showMonthPicker();};m.prototype.onsaphide=m.prototype.onsapshow;m.prototype.onsaptabnext=function(E){var z=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabNext(E)){var A=z.getDomRef("B2");if(A){A.focus();}}else{var B=z.getDomRef("B1");if(B){B.focus();}}if(!this._bPoupupMode){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var I=this.getAggregation("monthPicker");var J=this.getAggregation("yearPicker");if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(J.getDomRef()){q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}E.preventDefault();}else if(this._shouldFocusB2OnTabNext(E)){var A=z.getDomRef("B2");if(A){A.focus();}E.preventDefault();}};m.prototype._shouldFocusB2OnTabNext=function(E){var i=this.getAggregation("header");return(E.target.id==i.getId()+"-B1");};m.prototype._shouldFocusB2OnTabPrevious=function(E){return this._bPoupupMode;};m.prototype.onsaptabprevious=function(E){var z=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabPrevious()){var A=z.getDomRef("B2");if(A){A.focus();}E.preventDefault();}}else if(E.target.id==z.getId()+"-B1"){var B=this.getAggregation("month");var F;switch(this._iMode){case 0:F=this._getFocusedDate();for(var i=0;i<B.length;i++){var G=B[i];var I=c.fromLocalJSDate(G.getDate(),this.getPrimaryCalendarType());if(F.isSame(I)){G._oItemNavigation.focusItem(G._oItemNavigation.getFocusedIndex());}else{q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){var J=this.getAggregation("monthPicker");J._oItemNavigation.focusItem(J._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){var N=this.getAggregation("yearPicker");N._oItemNavigation.focusItem(N._oItemNavigation.getFocusedIndex());}break;}E.preventDefault();}else if(E.target.id==z.getId()+"-B2"){var O=z.getDomRef("B1");if(O){O.focus();}E.preventDefault();}};m.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var z=this.getAggregation("month");this._focusOnShiftTab();if(!this._bPoupupMode){for(var i=0;i<z.length;i++){var A=z[i];q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var B=this.getAggregation("monthPicker");var F=this.getAggregation("yearPicker");if(B.getDomRef()){q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};m.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header");var z=i.getDomRef("B2");if(z){z.focus();}};m.prototype.onsapfocusleave=function(E){var z,A,B,F;if(!E.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){z=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<z.length;i++){A=z[i];q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:if(!this._getSucessorsPickerPopup()){B=this.getAggregation("monthPicker");q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){F=this.getAggregation("yearPicker");q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};m.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0];return i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()];};m.prototype.onThemeChanged=function(){var z;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){z=this.getAggregation("monthPicker");this._showMonthPicker(true);z._bNoThemeChange=false;z.onThemeChanged(arguments);z._bNoThemeChange=true;this._bLongMonth=z._bLongMonth;this._hideMonthPicker(true);}var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];B._bNoThemeChange=false;B.onThemeChanged(arguments);B._bNoThemeChange=true;}var E;if(A.length>1){E=c.fromLocalJSDate(A[0].getDate(),this.getPrimaryCalendarType());}else{E=this._getFocusedDate();}this._setHeaderText(E);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!this._getSucessorsPickerPopup()){n.call(this);}};m.prototype._updateHeader=function(i){this._setHeaderText(i);this._togglePrevNext(i,true);};m.prototype._togglePrevNext=function(i,z){var A=this._oMaxDate.getYear();var B=this._oMinDate.getYear();var E=this._oMaxDate.getMonth();var F=this._oMinDate.getMonth();var G=this.getAggregation("header");var I=r.call(this);var J=new c(i,this.getPrimaryCalendarType());if(this._iMode==0&&I>1){J=y.call(this,i);J.setMonth(J.getMonth()+I-1);J.setDate(a._daysInMonth(J));}else{J.setDate(a._daysInMonth(J));}var N=J.getYear();var O=J.getMonth();if(N>A||(N==A&&(!z||O>=E))||(this._iMode==1&&this._getSucessorsPickerPopup())){G.setEnabledNext(false);}else{G.setEnabledNext(true);}if(this._iMode==0&&I>1){J.setMonth(J.getMonth()-I+1);J.setDate(1);}else{J.setDate(1);}N=J.getYear();O=J.getMonth();if(N<B||(N==B&&(!z||O<=F))||(this._iMode==1&&this._getSucessorsPickerPopup())){G.setEnabledPrevious(false);}else{G.setEnabledPrevious(true);}};m.prototype._togglePrevNexYearPicker=function(){var i=this.getAggregation("yearPicker");var z=i.getYears();var A=c.fromLocalJSDate(i.getFirstRenderedDate());A.setYear(A.getYear()+Math.floor(z/2));var B=this.getAggregation("header");var E=new c(this._oMaxDate,this.getPrimaryCalendarType());E.setYear(E.getYear()-Math.ceil(z/2));E.setMonth(11);E.setDate(31);var F=new c(this._oMinDate,this.getPrimaryCalendarType());F.setYear(F.getYear()+Math.floor(z/2)+1);F.setMonth(0);F.setDate(1);B.setEnabledNext(A.isSameOrBefore(E));B.setEnabledPrevious(A.isSameOrAfter(F));};m.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var i=this.getAggregation("yearPicker");var z=r.call(this);var A;var B;var S=false;switch(this._iMode){case 0:if(z>1){A=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());A.setDate(1);this._setFocusedDate(A);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,true);break;case 1:F.setYear(F.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var G=this._getSecondaryCalendarType();if(G){B=new c(F,G);B.setMonth(0);B.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(B.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:i.previousPage();this._togglePrevNexYearPicker();break;}};m.prototype._handleNext=function(E){var F=this._getFocusedDate();var i=this.getAggregation("yearPicker");var z=r.call(this);var A;var B;switch(this._iMode){case 0:if(z>1){A=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(A);F=this._getFocusedDate();}F.setDate(1);F.setMonth(F.getMonth()+z);this._renderMonth();break;case 1:F.setYear(F.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){B=new c(F,S);B.setMonth(0);B.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(B.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:i.nextPage();this._togglePrevNexYearPicker();break;}};m.prototype._getDisplayedMonths=function(z){var A=[];var B=z.getMonth();var E=r.call(this);if(E>1){for(var i=0;i<E;i++){A.push((B+i)%12);}}else{A.push(B);}return A;};m.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=c.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new c(F,S);var z=F.getMonth();var A=c.fromLocalJSDate(i[i.length-1].getDate(),P);A.setDate(a._daysInMonth(A));A=new c(A,S);var E=A.getMonth();return{start:z,end:E};};m.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker();break;}};m.prototype._setDisabledMonths=function(i,z){var A=0;var B=11;if(i==this._oMinDate.getYear()){A=this._oMinDate.getMonth();}if(i==this._oMaxDate.getYear()){B=this._oMaxDate.getMonth();}if(!z){z=this.getAggregation("monthPicker");}z.setMinMax(A,B);};m.prototype._handleFocus=function(E){var i=c.fromLocalJSDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var z=E.getParameter("restoreOldDate");if(z){if(!j(this._getFocusedDate(),i)){this._renderMonth(false,false,true);}}else{this._focusDate(i,O);}};m.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};m.prototype._renderMonth=function(S,I,N){var z=this._getFocusedDate();var A=this.getAggregation("month");var F=false;var B;var E;var G;var i=0;for(i=0;i<A.length;i++){B=A[i];if(B.checkDateFocusable(z.toLocalJSDate())){F=true;}if(F||A.length==1){if(!S){B.setDate(z.toLocalJSDate());}else{B.displayDate(z.toLocalJSDate());}break;}}if(!F){G=new c(z,this.getPrimaryCalendarType());if(A.length>1){G=y.call(this,G);for(i=0;i<A.length;i++){B=A[i];E=new c(G,this.getPrimaryCalendarType());E.setMonth(G.getMonth()+i);if(!S&&a._isSameMonthAndYear(E,z)){B.setDate(z.toLocalJSDate());}else{B.displayDate(E.toLocalJSDate());}}}this._updateHeader(G);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!N){this.fireStartDateChange();}}};function _(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=c.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,i);}}m.prototype._showMonthPicker=function(S){if(this._iMode==2){this._hideYearPicker(true);}var z=this._getFocusedDate();var A=this.getAggregation("monthPicker");if(A.getDomRef()){A.$().css("display","");}else{var B=sap.ui.getCore().createRenderManager();var $=this.$("content");B.renderControl(A);B.flush($[0],false,true);B.destroy();}this._showOverlay();if(!S){A.setMonth(z.getMonth());this._setDisabledMonths(z.getYear(),A);if(this._iMode==0){var E=this.getAggregation("month");for(var i=0;i<E.length;i++){var F=E[i];q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(z,false);};m.prototype._hideMonthPicker=function(S){this._iMode=0;var z=this.getAggregation("monthPicker");z.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(r.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};m.prototype._showYearPicker=function(){if(this._iMode==1){this._hideMonthPicker(true);}var z=this._getFocusedDate();var A=this.getAggregation("yearPicker");if(A.getDomRef()){A.$().css("display","");}else{var B=sap.ui.getCore().createRenderManager();var $=this.$("content");B.renderControl(A);B.flush($[0],false,true);B.destroy();}this._showOverlay();A.setDate(z.toLocalJSDate());var E;if(r.call(this)==1){E=this.getAggregation("month")[0];var F=E.$("days").find(".sapUiCalItem");if(F.length==28){A.$().addClass("sapUiCalYearNoTop");}else{A.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){E=G[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;};m.prototype._hideYearPicker=function(S){this._iMode=0;var z=this.getAggregation("yearPicker");z.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(r.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};function n(){if(!this._bNamesLengthChecked){this._showMonthPicker(true);this._hideMonthPicker(true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var z=this.getAggregation("month");var A;if(z.length>1){A=c.fromLocalJSDate(z[0].getDate(),this.getPrimaryCalendarType());}else{A=this._getFocusedDate();}this._setHeaderText(A);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}}else if(r.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}m.prototype._focusDate=function(i,O,N){var F;var z=false;var A=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;z=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;z=true;}else{F=i;}if(this._focusDateExtend){A=this._focusDateExtend(i,O,N);}var I=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(z||O){this._renderMonth(false,I,N);}if(A){this.fireStartDateChange();}};m.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var z=this.getAggregation("month");if(z){for(var i=0;i<z.length;i++){var A=z[i];A._bDateRangeChanged=true;A._bInvalidateSync=true;A._bNoFocus=true;A.invalidate(O);A._bInvalidateSync=undefined;}}this._bDateRangeChanged=undefined;};m.prototype._setHeaderText=function(i){var z=this.getAggregation("header");var S=this.getAggregation("secondMonthHeader");var A=this._getLocaleData();var B=[];var E=[];var F=[];var G=[];var I;var J=false;var N;var O;var T;var P;var Q;var U=this.getPrimaryCalendarType();var V=this._getSecondaryCalendarType();var W="";if(this._bLongMonth||!this._bNamesLengthChecked){B=A.getMonthsStandAlone("wide",U);}else{J=true;B=A.getMonthsStandAlone("abbreviated",U);E=A.getMonthsStandAlone("wide",U);}if(V){F=A.getMonthsStandAlone("abbreviated",V);G=A.getMonthsStandAlone("wide",V);var X=this._getDisplayedSecondaryMonths(U,V);if(X.start==X.end){T=F[X.start];W=G[X.start];}else{Q=A.getIntervalPattern();T=Q.replace(/\{0\}/,F[X.start]).replace(/\{1\}/,F[X.end]);W=Q.replace(/\{0\}/,G[X.start]).replace(/\{1\}/,G[X.end]);}}z.setAdditionalTextButton1(T);z._setAdditionalTextButton3(T);S.setAdditionalTextButton1(T);var Z=this._getDisplayedMonths(i);this._sFirstMonthName=N=B[Z[0]];O=B[Z[Z.length-1]];if(Z.length>1&&!this._bShowOneMonth){if(!Q){Q=A.getIntervalPattern();}T=Q.replace(/\{0\}/,N).replace(/\{1\}/,O);I=E.length?Q.replace(/\{0\}/,E[Z[0]]).replace(/\{1\}/,E[Z[Z.length-1]]):T;}else{T=N;I=E[Z[0]]||T;}if(!this._getSucessorsPickerPopup()){if(W){I+=", "+W;}I+=". "+o.getText("CALENDAR_MONTH_PICKER_OPEN_HINT");}z.setTextButton1(T);z.setAriaLabelButton1(I);z._setTextButton3(O);z._setAriaLabelButton3(O);S.setTextButton1(O);S.setAriaLabelButton1(O);var $=new c(i,U);$.setDate(1);P=this._oYearFormat.format($.toUTCJSDate(),true);this._updateHeadersYearPrimaryText(P);if(V){$=new c($,V);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format($.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}return{sMonth:T,sYear:P,sAriaLabel:I,bShort:J};};function p(i,S){if(!i){return;}var z=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var A=z.getYear();a._checkYearInValidRange(A);if(a._isOutside(z,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(z);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,false,true);}}function r(){if(d.system.phone){return 1;}else{return this.getMonths();}}m.prototype._handleButton1=function(E){if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}};m.prototype._handleButton2=function(E){if(this._iMode!=2){this._showYearPicker();}else{this._hideYearPicker();}};function t(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function u(E){if(r.call(this)>1){var z=this.getAggregation("month");for(var i=0;i<z.length;i++){var A=z[i];if(A.getId()!=E.oSource.getId()){A._updateSelection();}}}this._oSelectedMonth=E.oSource;this.fireSelect();}function v(E){if(r.call(this)>1){var z=this.getAggregation("month");for(var i=0;i<z.length;i++){var A=z[i];if(A.getId()!=E.oSource.getId()){A._bindMousemove();}}}}function w(E){if(r.call(this)>1){var z=this.getAggregation("month");for(var i=0;i<z.length;i++){var A=z[i];if(A.getId()!=E.oSource.getId()){A._unbindMousemove();}}}}m.prototype._selectMonth=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),z=i.getMonth();F.setMonth(z);if(z!=F.getMonth()){F.setDate(0);}this._focusDate(F,true);this._hideMonthPicker();};m.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};m.prototype._selectYear=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());var i=this.getAggregation("yearPicker");var z=c.fromLocalJSDate(i.getDate(),this.getPrimaryCalendarType());z.setMonth(F.getMonth());z.setDate(F.getDate());F=z;this._focusDate(F,true);this._hideYearPicker();};m.prototype._showOverlay=function(){this.$("contentOver").css("display","");};m.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};m.prototype._setColumns=function(i){this._iColumns=i;return this;};m.prototype._getColumns=function(){return this._iColumns;};m.prototype._updateHeadersButtons=function(){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){S.setVisible(true);i._setVisibleButton3(false);i._setVisibleButton4(false);}else if(this._isTwoMonthsInTwoColumns()){S.setVisible(false);i._setVisibleButton3(true);i._setVisibleButton4(true);}else{S.setVisible(false);i._setVisibleButton3(false);i._setVisibleButton4(false);}};m.prototype._setPrimaryHeaderMonthButtonText=function(){var i=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){i.setTextButton1(this._sFirstMonthName);}};m.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){if(s.toLowerCase()==="ja"||s.toLowerCase()==="zh"){this.addStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}else{this.addStyleClass("sapUiCalTwoMonthsTwoColumns");}}else{if(s.toLowerCase()==="ja"||s.toLowerCase()==="zh"){this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}}};m.prototype._isTwoMonthsInOneColumn=function(){var i=r.call(this);return this._getColumns()===1&&i===2;};m.prototype._isTwoMonthsInTwoColumns=function(){var i=r.call(this);return this._getColumns()===2&&i===2;};m.prototype._updateHeadersYearPrimaryText=function(i){var z=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader"),A=i;if(!this._getSecondaryCalendarType()){A+=(this._getSucessorsPickerPopup()?"":". "+o.getText("CALENDAR_YEAR_PICKER_OPEN_HINT"));}z.setTextButton2(i);z.setAriaLabelButton2(A);z._setTextButton4(i);z._setAriaLabelButton4(i);S.setTextButton2(i);S.setAriaLabelButton2(i);};m.prototype._updateHeadersYearAdditionalText=function(i){var z=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader"),A=z.getAriaLabelButton2();if(i){A+=", "+i+(this._getSucessorsPickerPopup()?"":". "+o.getText("CALENDAR_YEAR_PICKER_OPEN_HINT"));z.setAriaLabelButton2(A);}z.setAdditionalTextButton2(i);z._setAdditionalTextButton4(i);S.setAdditionalTextButton2(i);};function x(E){var W=E.size.width;if(W<=0){return;}var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var z=r.call(this);if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break;}if(z<this._getColumns()){this._setColumns(z);}if(this._getColumns()>2&&z>this._getColumns()){var A=this._getColumns();var U=0.0;var B=this._getColumns();while(A>=2){var F=z%A;if(F==0){B=A;break;}else{var N=F/A;if(N>U){U=N;B=A;}}A--;}this._setColumns(B);}var G;var I=this.getAggregation("month");if(this._getColumns()>1){G=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{G="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<I.length;i++){var J=I[i];J.setWidth(G);}}this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}function y(i){var F=new c(i,this.getPrimaryCalendarType());F.setDate(1);var z=r.call(this);if(z<=12){var A=i.getMonth();A=A-A%z;if(12%z>0&&A+z>11){A=12-z;}F.setMonth(A);}return F;}return m;});
