/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/Renderer','sap/ui/core/format/DateFormat','./calendar/CalendarUtils','./calendar/Header','./calendar/MonthsRow','./calendar/YearPicker','./calendar/CalendarDate','./Calendar','./CalendarRenderer',"./CalendarMonthIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery"],function(D,C,L,a,R,b,c,H,M,Y,d,e,f,g,h,i,P,j,q){"use strict";var k=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});k.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=b.getDateInstance({format:"y"});this._oMinDate=c._minDate();this._oMaxDate=c._maxDate();this._initializeHeader();this._initializeMonthsRow();this._initilizeYearPicker();this._iDaysMonthsHead=15;};k.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};k.prototype.onBeforeRendering=function(){var O=this.getAggregation("monthsRow");var Q=this._getFocusedDate();r.call(this);O.displayDate(Q.toLocalJSDate());};k.prototype._setAriaRole=function(O){var Q=this.getAggregation("monthsRow");Q._setAriaRole(O);Q.invalidate();return this;};k.prototype._initializeHeader=function(){var O=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});O.attachEvent("pressPrevious",this._handlePrevious,this);O.attachEvent("pressNext",this._handleNext,this);O.attachEvent("pressButton2",x,this);this.setAggregation("header",O);};k.prototype._initializeMonthsRow=function(){var O=new M(this.getId()+"--MonthsRow");O.attachEvent("focus",A,this);O.attachEvent("select",z,this);O._bNoThemeChange=true;this.setAggregation("monthsRow",O);};k.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};k.prototype._createYearPicker=function(){var O=new Y(this.getId()+"--YP",{columns:0,years:6});O.attachEvent("select",E,this);O.attachEvent("pageChange",K,this);O._oMinDate.setYear(this._oMinDate.getYear());O._oMaxDate.setYear(this._oMaxDate.getYear());return O;};k.prototype._getCalendarPicker=function(){var O=this.getAggregation("calendarPicker");if(!O){O=new N(this.getId()+"--Cal");O.setPopupMode(true);O.attachEvent("select",B,this);O.attachEvent("cancel",function(Q){this._oPopup.close();var S=this.getAggregation("header").getDomRef("B2");if(S){S.focus();}},this);this.setAggregation("calendarPicker",O);}return O;};k.prototype.setStartDate=function(S){c._checkJSDateObject(S);if(i(this.getStartDate(),S)){return this;}var O=S.getFullYear();c._checkYearInValidRange(O);this.setProperty("startDate",S,true);this._oStartDate=d.fromLocalJSDate(S);this._oStartDate.setDate(1);var Q=this.getAggregation("monthsRow");Q.setStartDate(S);r.call(this);var T=this._getFocusedDate().toLocalJSDate();if(!Q.checkDateFocusable(T)){this._setFocusedDate(this._oStartDate);Q.displayDate(S);}return this;};k.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(F.bind(this),0);}};k.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var O=this.removeAllAggregation("selectedDates");return O;};k.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var O=this.destroyAggregation("selectedDates");return O;};k.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var O=this.removeAllAggregation("specialDates");return O;};k.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var O=this.destroyAggregation("specialDates");return O;};k.prototype.setLocale=function(O){if(this._sLocale!=O){this._sLocale=O;this._oLocaleData=undefined;this.invalidate();}return this;};k.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};k.prototype._getFocusedDate=function(){if(!this._oFocusedDate){n.call(this);}return this._oFocusedDate;};k.prototype._setFocusedDate=function(O){c._checkCalendarDate(O);this._oFocusedDate=new d(O);};k.prototype.focusDate=function(O){var Q=false;var S=this.getAggregation("monthsRow");if(O&&!S.checkDateFocusable(O)){G.call(this,d.fromLocalJSDate(O));Q=true;}w.call(this,O,false);if(Q){this.fireStartDateChange();}return this;};k.prototype.displayDate=function(O){w.call(this,O,true);return this;};k.prototype.setMonths=function(O){this.setProperty("months",O,true);O=this._getMonths();var Q=this.getAggregation("monthsRow");Q.setMonths(O);if(!Q.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=l.call(this);this._setFocusedDate(this._oStartDate);Q.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var T=this.getAggregation("yearPicker");var U=Math.floor(O/2);if(U>20){U=20;}T.setYears(U);}r.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};k.prototype._getMonths=function(){var O=this.getMonths();if(D.system.phone&&O>6){return 6;}else{return O;}};k.prototype._getLocaleData=function(){if(!this._oLocaleData){var O=this.getLocale();var Q=new L(O);this._oLocaleData=a.getInstance(Q);}return this._oLocaleData;};k.prototype.setPickerPopup=function(O){var Q;this.setProperty("pickerPopup",O,true);if(O){if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}Q=this.getAggregation("yearPicker");Q.setColumns(0);Q.setYears(6);}return this;};k.prototype.setMinDate=function(O){if(i(O,this.getMinDate())){return this;}if(!O){this._oMinDate=c._minDate();}else{c._checkJSDateObject(O);this._oMinDate=d.fromLocalJSDate(O);this._oMinDate.setDate(1);var Q=this._oMinDate.getYear();c._checkYearInValidRange(Q);if(this._oMaxDate.isBefore(this._oMinDate)){j.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=d.fromLocalJSDate(O);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){j.warning("focused date < minDate -> minDate focused",this);this.focusDate(O);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){j.warning("start date < minDate -> minDate set as start date",this);_.call(this,new d(this._oMinDate),true,true);}}this.setProperty("minDate",O,false);if(this.getPickerPopup()){var S=this._getCalendarPicker();S.setMinDate(O);}else{var T=this.getAggregation("yearPicker");T._oMinDate.setYear(this._oMinDate.getYear());}return this;};k.prototype.setMaxDate=function(O){if(i(O,this.getMaxDate())){return this;}if(!O){this._oMaxDate=c._maxDate();}else{c._checkJSDateObject(O);this._oMaxDate=d.fromLocalJSDate(O);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));var Q=this._oMaxDate.getYear();c._checkYearInValidRange(Q);if(this._oMinDate.isAfter(this._oMaxDate)){j.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=d.fromLocalJSDate(O);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){j.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(O);}}if(this._oStartDate){var S=new d(this._oStartDate);S.setDate(1);S.setMonth(S.getMonth()+this._getMonths());S.setDate(0);if(S.isAfter(this._oMaxDate)){var T=new d(this._oMaxDate);T.setDate(1);T.setMonth(T.getMonth()-this._getMonths()+1);if(T.isSameOrAfter(this._oMinDate)){j.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,T,true,true);}}}}this.setProperty("maxDate",O,false);if(this.getPickerPopup()){var U=this._getCalendarPicker();U.setMaxDate(O);}else{var V=this.getAggregation("yearPicker");V._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};k.prototype.onclick=function(O){if(O.isMarked("delayedMouseEvent")){return;}if(O.target.id==this.getId()+"-cancel"){this.onsapescape(O);}};k.prototype.onmousedown=function(O){O.preventDefault();O.setMark("cancelAutoClose");};k.prototype.onsapescape=function(O){if(this.getPickerPopup()){y.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:p.call(this);break;}}};k.prototype.onsaptabnext=function(O){var Q=this.getAggregation("header"),S,T;if(h(this.getDomRef("content"),O.target)){if(Q.getDomRef("B2")){Q.getDomRef("B2").focus();}if(!this._bPoupupMode){T=this.getAggregation("monthsRow");q(T._oItemNavigation.getItemDomRefs()[T._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");if(S.getDomRef()){q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}O.preventDefault();}};k.prototype.onsaptabprevious=function(O){var Q=this.getAggregation("header"),S,T;if(h(this.getDomRef("content"),O.target)){if(this._bPoupupMode){if(Q.getDomRef("B2")){Q.getDomRef("B2").focus();}O.preventDefault();}}else if(O.target.id==Q.getId()+"-B2"){switch(this._iMode){case 0:S=this.getAggregation("monthsRow");S._oItemNavigation.focusItem(S._oItemNavigation.getFocusedIndex());break;case 1:if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");T._oItemNavigation.focusItem(T._oItemNavigation.getFocusedIndex());}break;}O.preventDefault();}};k.prototype.onfocusin=function(O){if(O.target.id==this.getId()+"-end"){var Q=this.getAggregation("header"),S,T;if(Q.getDomRef("B2")){Q.getDomRef("B2").focus();}if(!this._bPoupupMode){S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");if(T.getDomRef()){q(T._oItemNavigation.getItemDomRefs()[T._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};k.prototype.onsapfocusleave=function(O){var Q,S;if(!O.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(O.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){switch(this._iMode){case 0:Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};k.prototype._handlePrevious=function(O){var Q,S,T,U;switch(this._iMode){case 0:Q=this._getFocusedDate();S=this._getMonths();T=new d(l.call(this));T.setMonth(T.getMonth()-S);Q.setMonth(Q.getMonth()-S);this._setFocusedDate(Q);_.call(this,T,true);break;case 1:if(!this.getPickerPopup()){U=this.getAggregation("yearPicker");U.previousPage();t.call(this);}break;}};k.prototype._handleNext=function(O){var Q,S,T,U;switch(this._iMode){case 0:Q=this._getFocusedDate();S=this._getMonths();T=new d(l.call(this));T.setMonth(T.getMonth()+S);Q.setMonth(Q.getMonth()+S);this._setFocusedDate(Q);_.call(this,T,true);break;case 1:if(!this.getPickerPopup()){U=this.getAggregation("yearPicker");U.nextPage();t.call(this);}break;}};k.prototype._showOverlay=function(){this.$("contentOver").css("display","");};k.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};k.prototype._getShowItemHeader=function(){var O=this.getMonths();if(O>this._iDaysMonthsHead){return true;}else{return false;}};function _(S,O,Q){var T=new d(this._oMaxDate);T.setDate(1);T.setMonth(T.getMonth()-this._getMonths()+1);if(T.isBefore(this._oMinDate)){T=new d(this._oMinDate);T.setMonth(T.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new d(this._oMinDate);}else if(S.isAfter(T)){S=T;}S.setDate(1);var U=S.toLocalJSDate();this.setProperty("startDate",U,true);this._oStartDate=S;var V=this.getAggregation("monthsRow");V.setStartDate(U);r.call(this);if(O){var W=this._getFocusedDate().toLocalJSDate();if(!V.checkDateFocusable(W)){this._setFocusedDate(S);V.setDate(U);}else{V.setDate(W);}}if(!Q){this.fireStartDateChange();}}function l(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}function m(O){var Q=this._getFocusedDate();var S=this.getAggregation("monthsRow");if(!O){S.setDate(Q.toLocalJSDate());}else{S.displayDate(Q.toLocalJSDate());}r.call(this);}function n(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=d.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new d();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new d(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new d(this._oMaxDate);}}function o(){var O=this._getFocusedDate();var Q=this.getAggregation("yearPicker");if(Q.getDomRef()){Q.$().css("display","");}else{var S=sap.ui.getCore().createRenderManager();var $=this.$("content");S.renderControl(Q);S.flush($[0],false,true);S.destroy();}this._showOverlay();Q.setDate(O.toLocalJSDate());if(this._iMode==0){var T=this.getAggregation("monthsRow");q(T._oItemNavigation.getItemDomRefs()[T._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}t.call(this);this._iMode=1;}function p(O){this._iMode=0;var Q=this.getAggregation("yearPicker");Q.$().css("display","none");this._hideOverlay();if(!O){m.call(this);var S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function r(){u.call(this);s.call(this);}function s(){var O=new d(l.call(this));var Q=this._getMonths();var S=O.getYear();var T=this._oMaxDate.getYear();var U=this._oMinDate.getYear();var V=O.getMonth();var W=this._oMaxDate.getMonth();var X=this._oMinDate.getMonth();var Z=this.getAggregation("header");if(S<U||(S==U&&V<=X)){Z.setEnabledPrevious(false);}else{Z.setEnabledPrevious(true);}O.setMonth(O.getMonth()+Q-1);S=O.getYear();V=O.getMonth();if(S>T||(S==T&&V>=W)){Z.setEnabledNext(false);}else{Z.setEnabledNext(true);}}function t(){var O=this.getAggregation("yearPicker");var Q=O.getYears();var S=d.fromLocalJSDate(O.getFirstRenderedDate());S.setYear(S.getYear()+Math.floor(Q/2));var T=this.getAggregation("header");var U=new d(this._oMaxDate);U.setYear(U.getYear()-Math.ceil(Q/2));U.setMonth(11,31);var V=new d(this._oMinDate);V.setYear(V.getYear()+Math.floor(Q/2)+1);V.setMonth(0,1);T.setEnabledNext(!S.isAfter(U));T.setEnabledPrevious(!S.isBefore(V));}function u(){var T;var S=l.call(this);var O=this._oYearFormat.format(S.toUTCJSDate(),true);var Q=new d(S);Q.setMonth(Q.getMonth()+this._getMonths()-1);var U=this._oYearFormat.format(Q.toUTCJSDate(),true);if(O!=U){var V=this._getLocaleData();var W=V.getIntervalPattern();T=W.replace(/\{0\}/,O).replace(/\{1\}/,U);}else{T=O;}var X=this.getAggregation("header");X.setTextButton2(T);}function v(O,Q){var S;var T=false;if(O.isBefore(this._oMinDate)){S=this._oMinDate;T=true;}else if(O.isAfter(this._oMaxDate)){S=this._oMaxDate;T=true;}else{S=O;}this._setFocusedDate(S);if(T||Q){G.call(this,S);m.call(this,false);this.fireStartDateChange();}}function w(O,S){if(!O){return;}var Q=d.fromLocalJSDate(O);if(this._oFocusedDate&&this._oFocusedDate.isSame(Q)){return;}var T=Q.getYear();c._checkYearInValidRange(T);if(c._isOutside(Q,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(Q);if(this.getDomRef()&&this._iMode==0){m.call(this,S);}}function x(O){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){o.call(this);}else{p.call(this);}}}k.prototype._showCalendarPicker=function(){var O=this._getFocusedDate(true).toLocalJSDate();var Q=this._getCalendarPicker();var S=new sap.ui.unified.DateRange({startDate:O});Q.displayDate(O,false);Q.removeAllSelectedDates();Q.addSelectedDate(S);Q.setMinDate(this.getMinDate());Q.setMaxDate(this.getMaxDate());I.call(this,Q);this._showOverlay();};function y(O){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!O){m.call(this);var Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function z(O){this.fireSelect();}function A(O){var Q=d.fromLocalJSDate(O.getParameter("date"));var S=O.getParameter("notVisible");v.call(this,Q,S);}function B(O){var Q=new d(this._getFocusedDate());var S=this._getCalendarPicker();var T=S.getSelectedDates()[0].getStartDate();var U=d.fromLocalJSDate(T);U.setMonth(Q.getMonth());U.setDate(Q.getDate());v.call(this,U,true);y.call(this);}function E(O){var Q=new d(this._getFocusedDate());var S=this.getAggregation("yearPicker");var T=d.fromLocalJSDate(S.getDate());T.setMonth(Q.getMonth());T.setDate(Q.getDate());Q=T;v.call(this,Q,true);p.call(this);}function F(){this._sInvalidateContent=undefined;var O=this.getAggregation("monthsRow");if(O){O._bDateRangeChanged=true;O._bInvalidateSync=true;O.invalidate();O._bInvalidateSync=undefined;}this._bDateRangeChanged=undefined;}function G(O){var Q=this.getAggregation("monthsRow");var S=l.call(this);var T=Q._oItemNavigation.getFocusedIndex();S=new d(O);S.setMonth(S.getMonth()-T);_.call(this,S,false,true);}function I(O){if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(J,this);this._oPopup.onsapescape=function(T){this._oCalendar.onsapescape(T);};}this._oPopup.setContent(O);var Q=this.getAggregation("header");var S=P.Dock;this._oPopup.open(0,S.CenterTop,S.CenterTop,Q,null,"flipfit",true);}function J(O){y.call(this);}function K(O){t.call(this);}var N=e.extend("CustomYearPicker",{renderer:R.extend(f)});N.prototype._initializeHeader=function(){var O=new H(this.getId()+"--Head",{visibleButton1:false});O.attachEvent("pressPrevious",this._handlePrevious,this);O.attachEvent("pressNext",this._handleNext,this);O.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",O);};N.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);var O=this.getAggregation("header");O.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");this._showYearPicker();};N.prototype.onThemeChanged=function(){e.prototype.onThemeChanged.apply(this,arguments);var O=this.getAggregation("header");O.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");};N.prototype._selectYear=function(){var O=this.getAggregation("yearPicker");var Q=this.getSelectedDates()[0];if(!Q){Q=new sap.ui.unified.DateRange();}Q.setStartDate(O.getDate());this.addSelectedDate(Q);this.fireSelect();};N.prototype.onsapescape=function(O){this.fireCancel();};N.prototype._shouldFocusB2OnTabPrevious=function(O){return false;};return k;});
