/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/Device","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/m/ScrollBar","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/ui/events/KeyCodes"],function(q,M,R,C,a,D,S,O,b,c,d,L,A,T,e,f,l,g,h,i,j,K){"use strict";var k=f.TitleLevel;var m=f.AccessibleLandmarkRole;var n=l.ObjectPageSubSectionLayout;var o=a.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:n.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:k.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.uxap.ObjectPageAccessibleLandmarkInfo",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"}});o.HEADER_CALC_DELAY=350;o.DOM_CALC_DELAY=200;o.MAX_SNAP_POSITION_OFFSET=20;o.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;o.TITLE_LEVEL_AS_ARRAY=Object.keys(k);o.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};o.BREAK_POINTS={TABLET:1024,PHONE:600};o.MEDIA={PHONE:"sapUxAPObjectPageLayout-Std-Phone",TABLET:"sapUxAPObjectPageLayout-Std-Tablet",DESKTOP:"sapUxAPObjectPageLayout-Std-Desktop"};o.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};o.DIV="div";o.HEADER="header";o.FOOTER="section";o.SHOW_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterShow";o.HIDE_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterHide";o._getNextTitleLevelEntry=function(t){var r=o.TITLE_LEVEL_AS_ARRAY.indexOf(t),s=r!==-1,H=s&&(r!==o.TITLE_LEVEL_AS_ARRAY.length-1);if(!s){return k.Auto;}return o.TITLE_LEVEL_AS_ARRAY[H?r+1:r];};o._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};o.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollTop=0;this._oStoredScrolledSubSectionInfo={};this._bAllContentFitsContainer=false;this._bIsFooterAanimationGoing=false;this._bInternalAnchorBarVisible=true;this._$footerWrapper=[];this._$opWrapper=[];this._$anchorBar=[];this._$headerTitle=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iFooterHeight=0;this.iTotalHeaderSize=0;this._iREMSize=parseInt(q("body").css("font-size"));this._iOffset=parseInt(0.25*this._iREMSize);this._iResizeId=null;this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);this._initializeScroller();};o.prototype.onBeforeRendering=function(){var H,P;this._deregisterScreenSizeListener();if(this._oLazyLoading){this._oLazyLoading.destroy();}this._oLazyLoading=new L(this);this._deregisterCustomEvents();if(!this.getVisible()){return;}if(!this.getSelectedSection()){this._bHeaderExpanded=true;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();this._getCustomScrollBar().setScrollPosition(0);if(!q.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){P=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(P);if(P){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);if(this.getFooter()&&this._bIsFooterAanimationGoing){this._onToggleFooterAnimationEnd(this.getFooter());}};o.prototype.setBackgroundDesignAnchorBar=function(B){var s=this.getBackgroundDesignAnchorBar(),r="sapUxAPObjectPageNavigation";if(s===B){return this;}this.setProperty("backgroundDesignAnchorBar",B,true);this._oABHelper._getAnchorBar().setBackgroundDesign(B);if(p(this._$anchorBar)){this._$anchorBar.removeClass(r+s);this._$anchorBar.addClass(r+B);}if(p(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass(r+s);this._$stickyAnchorBar.addClass(r+B);}return this;};o.prototype.setToggleHeaderOnTitleClick=function(t){var r=this.getHeaderTitle(),v=this.setProperty("toggleHeaderOnTitleClick",t,true);if(!r||!r.supportsToggleHeaderOnTitleClick()){h.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return v;}t=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return v;};o.prototype._attachTitlePressHandler=function(){var t=this.getHeaderTitle();if(p(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(o.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};o.prototype._toggleHeaderVisibility=function(s){var H=this._getHeaderContent();if(p(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!s);}};o.prototype._snapHeader=function(r){var I,H=this._getHeaderContent();if(H&&H.supportsPinUnpin()&&this._bPinned){this._unPin();H.getAggregation("_pinButton").setPressed(false);r=true;}this._toggleHeaderTitle(false,true);this._moveAnchorBarToTitleArea();if(r){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._toggleHeaderVisibility(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};o.prototype._expandHeader=function(r){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(r){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();if(p(this._$stickyAnchorBar)){this._$stickyAnchorBar.addClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();if(p(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}};o.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return;}var E=!this._bHeaderExpanded,I,r,s;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));r=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!I);this._expandHeader(r);if(!r){this._scrollTo(0,0);}}else{s=!this._shouldPreserveHeaderInTitleArea()&&(!this._bAllContentFitsContainer||this._headerBiggerThanAllowedToBeExpandedInTitleArea());this._snapHeader(s);}this.getHeaderTitle()._getFocusSpan().$().focus();};o.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(p(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(o.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};o.prototype._handleExpandButtonPressEventLifeCycle=function(r){var H=this.getHeaderTitle(),E;if(H){E=H.getAggregation("_expandButton");if(E){E[r?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};o.prototype._adjustSelectedSectionByUXRules=function(){var s=this.oCore.byId(this.getSelectedSection()),v=s&&this._sectionCanBeRenderedByUXRules(s);if(!v){if(this._oFirstVisibleSection){s=this._oFirstVisibleSection;this.setAssociation("selectedSection",s.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}};o.prototype._sectionCanBeRenderedByUXRules=function(s){var r=s.getBindingInfo("subSections");if((!s||!s.getVisible()||!s._getInternalVisible())&&!r){return false;}var t=this._aSectionBases.map(function(u){return u.getId();});return(t.indexOf(s.getId())>-1);};o.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var s=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&s){return[s];}else{return this.getSections();}};o.prototype._preloadSectionsOnBeforeFirstRendering=function(){var t=this._getSectionsToPreloadOnBeforeFirstRendering();this._connectModelsForSections(t);if(this.getEnableLazyLoading()){t.forEach(function(s){this.fireEvent("subSectionPreload",{subSection:s});},this);}};o.prototype._getSectionsToPreloadOnBeforeFirstRendering=function(){var s,r,I;if(!this.getEnableLazyLoading()){return this._getSectionsToRender();}if(this.getUseIconTabBar()){return this._oLazyLoading.getSubsectionsToPreload(this._grepCurrentTabSectionBases());}this._adjustSelectedSectionByUXRules();r=this.oCore.byId(this.getSelectedSection());if(!r||(r===this._oFirstVisibleSection)){return this._oLazyLoading.getSubsectionsToPreload(this._aSectionBases);}I=this.indexOfSection(r);var F=function(t){var u=t.isA("sap.uxap.ObjectPageSection")?t:t.getParent();return this.indexOfSection(u)>=I;}.bind(this);s=this._aSectionBases.filter(F);return this._oLazyLoading.getSubsectionsToPreload(s);};o.prototype._grepCurrentTabSectionBases=function(){var F=[],s,r;this._adjustSelectedSectionByUXRules();s=this.oCore.byId(this.getSelectedSection());if(s){var t=s.getId();this._aSectionBases.forEach(function(u){r=u.getParent();if(r&&r.getId()===t){F.push(u);}});}return F;};o.prototype.onAfterRendering=function(){var H=this._getHeaderContent(),F=this.getFooter(),s,w=this._getWidth(this);this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._ensureCorrectParentHeight();this._cacheDomElements();if(this._hasDynamicTitle()){this.addStyleClass("sapUxAPObjectPageHasDynamicTitle");}if(w>0){this._updateMedia(w,o.MEDIA);}this._$opWrapper.on("scroll.OPL",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());}if(H&&H.supportsPinUnpin()){this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",H.getPinnable());}if(F){s=o._getLibraryResourceBundle().getText("FOOTER_ARIA_LABEL");F.$().attr("aria-label",s);}this._handleExpandButtonPressEventLifeCycle(true);};o.prototype._onAfterRenderingDomReady=function(){var s,r,t;if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();r=this.oCore.byId(s);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(s){if(this.getUseIconTabBar()){this._setSelectedSectionId(s);this._setCurrentTabSection(r);}else{this.scrollToSection(s,0);}}this._toggleScrolling(!this._bAllContentFitsContainer);if(D.system.desktop){this._$opWrapper.on("scroll.OPL",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){t=!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer;this._snapHeader(t);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);this._updateMedia(this._getWidth(this),o.MEDIA);if(this._hasDynamicTitle()){this._updateMedia(this._getWidth(this),o.DYNAMIC_HEADERS_MEDIA);}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady");};o.prototype._toggleScrolling=function(E){if(this._$opWrapper.length){this._$opWrapper.get(0).style.overflow=E?"hidden auto":"hidden";}};o.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),s=this._calculateShiftOffset();$.css(s.sStyleAttribute,s.iMarginalsOffset+"px");};o.prototype._calculateShiftOffset=function(){var H=0,s=this.oCore.getConfiguration().getRTL()?"left":"right",r=this._hasVerticalScrollBar(),t=this._iOffset,u;if(D.system.desktop){u=i().width;H=u;if(!r){H=0;t+=u;}}return{"sStyleAttribute":s,"iActionsOffset":t,"iMarginalsOffset":H};};o.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?o.HEADER_CALC_DELAY:0;};o.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}this._deregisterScreenSizeListener();if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}this._deregisterCustomEvents();this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};o.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var v=new e(this.getId()+"-vertSB",{scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this),visible:false});this.setAggregation("_customScrollBar",v,true);}return this.getAggregation("_customScrollBar");};o.prototype.onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(s);}};o.prototype.onCustomScrollerScroll=function(E){var s=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(s);};o.prototype.setShowOnlyHighImportance=function(v){var r=this.getShowOnlyHighImportance();if(r!==v){this.setProperty("showOnlyHighImportance",v,true);this.getSections().forEach(function(s){s._updateImportance();});}return this;};o.prototype.setIsHeaderContentAlwaysExpanded=function(v){var r=this.getAlwaysShowContentHeader();var s=(D.system.phone||D.system.tablet);if(r!==v){this.setProperty("alwaysShowContentHeader",v,s);}return this;};o.prototype.setShowEditHeaderButton=function(v){var r=this.getShowEditHeaderButton(),H=this.getAggregation("_headerContent");if(r!==v){this.setProperty("showEditHeaderButton",v,true);H&&H.invalidate();}return this;};o.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});};o.prototype.setSelectedSection=function(I){var v,s;if(I instanceof O){I=I.getId();}else if(I!=null&&typeof I!=="string"){j(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this;}if(I===this.getSelectedSection()){return this;}if(I===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._requestAdjustLayoutAndUxRules(true);return this;}this.scrollToSection(I);v=b._getClosestSection(I);s=(v instanceof b)?v.getId():v;return this.setAssociation("selectedSection",s,true);};o.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};o.prototype._cacheDomElements=function(){this._$footerWrapper=q(document.getElementById(this.getId()+"-footerWrapper"));this._$headerTitle=q(document.getElementById(this.getId()+"-headerTitle"));this._$anchorBar=q(document.getElementById(this.getId()+"-anchorBar"));this._$stickyAnchorBar=q(document.getElementById(this.getId()+"-stickyAnchorBar"));this._$opWrapper=q(document.getElementById(this.getId()+"-opwrapper"));this._$spacer=q(document.getElementById(this.getId()+"-spacer"));this._$headerContent=q(document.getElementById(this.getId()+"-headerContent"));this._$stickyHeaderContent=q(document.getElementById(this.getId()+"-stickyHeaderContent"));this._$contentContainer=q(document.getElementById(this.getId()+"-scroll"));this._$sectionsContainer=q(document.getElementById(this.getId()+"-sectionsContainer"));this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true;};o.prototype._handleExpandButtonPress=function(E){if(this._bStickyAnchorBar){this._moveHeaderToTitleArea();this._toggleHeaderTitle(true);}};o.prototype._toggleHeaderTitle=function(E,u){var H=this.getHeaderTitle();this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied",!E);this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderSnappedTitleOnMobile",this._hasDynamicTitleWithSnappedTitleOnMobile()&&!E);if(E){H&&H.unSnap(u);}else{H&&H.snap(u);}};o.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this._bSupressModifyOnScrollOnce=true;};o.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;}};o.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};o.prototype._applyUxRules=function(I){var s,r,v,V,t,u,U,F,w,x,y,z,B={},E;s=this.getSections()||[];V=0;u=this.getShowAnchorBar();U=this.getUseIconTabBar();E=s.length<=1;F=null;this._cleanMemory();s.forEach(function(G){if(!G.getVisible()){return true;}this._registerSectionBaseInfo(G);r=G.getSubSections()||[];v=0;w=null;r.forEach(function(H){if(!H.getVisible()){return true;}this._registerSectionBaseInfo(H);t=H.getVisibleBlocksCount();if(t===0){H._setInternalVisible(false,I);h.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+H.getTitle()+" forced to hidden");}else{H._setInternalVisible(true,I);B[H.getId()]=true;v++;if(!w){w=H;}if(this._shouldApplySectionTitleLevel(H)){H._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(H));}}},this);if(v==0){G._setInternalVisible(false,I);h.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+G.getTitle()+" forced to hidden");}else{G._setInternalVisible(true,I);B[G.getId()]=true;if(!F){F=G;z=v;}if(this.getSubSectionLayout()===n.TitleOnTop&&v===1&&w.getTitle().trim()!==""){h.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+G.getTitle()+" is taking its single subsection title "+w.getTitle());G._setInternalTitle(w.getTitle(),I);B[w.getId()]=false;w._setBorrowedTitleDomId(G.getId()+"-title");}else{G._setInternalTitle("",I);}if(v===1&&!w.getTitle().trim()){w._setBorrowedTitleDomId(G.getId()+"-title");}if(this._shouldApplySectionTitleLevel(G)){G._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(G));}V++;}if(U){B[G.getId()]=E;}},this);if(V<=1){u=false;h.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");}else if(F&&u){x=true;B[F.getId()]=false;h.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+F.getTitle()+" title forced to hidden");}Object.keys(B).forEach(function(G){this.oCore.byId(G)._setInternalTitleVisible(B[G],I);}.bind(this));if(u){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(u,I);this._oFirstVisibleSection=F;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(F);this._bAllContentFitsContainer=(V===1)&&(v===1)&&this._oFirstVisibleSubSection.hasStyleClass(c.FIT_CONTAINER_CLASS);if(x&&(z===1)){y=this.getAggregation("_anchorBar").getContent();if(y.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(y[0].getId()+"-content");}}};o.prototype.setUseIconTabBar=function(v){var r=this.getUseIconTabBar();if(v!=r){this._applyUxRules();}this.setProperty("useIconTabBar",v);return this;};o.prototype._setCurrentTabSection=function(s,I){if(!s){return;}var r;if(s instanceof sap.uxap.ObjectPageSubSection){r=s;s=s.getParent();}else{r=this._getFirstVisibleSubSection(s);}if(this._oCurrentTabSection!==s){this._renderSection(s);this._oCurrentTabSection=s;}this._oCurrentTabSubSection=r;};o.prototype._renderSection=function(s){var $=this.$().find(".sapUxAPObjectPageContainer"),r;if(s&&$.length){r=this.oCore.createRenderManager();this.getSections().forEach(function(t){if((t.getId()===s.getId())){r.renderControl(s);}else{r.cleanupControlWithoutRendering(t);}});r.flush($[0]);r.destroy();}};o.prototype.setShowAnchorBarPopover=function(v,s){var r=this.getProperty("showAnchorBarPopover"),v=this.validateProperty("showAnchorBarPopover",v),t=this.getSelectedSection();if(v===r){return this;}this._oABHelper._getAnchorBar().setShowPopover(v);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(t);return this.setProperty("showAnchorBarPopover",v,true);};o.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};o.prototype._setInternalAnchorBarVisible=function(v,I){if(v!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=v;if(I===true){this.invalidate();}}};o.prototype.setUpperCaseAnchorBar=function(v){this._oABHelper._getAnchorBar().setProperty("upperCase",v);return this.setProperty("upperCaseAnchorBar",v,true);};o.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,o.DOM_CALC_DELAY,this);}if(!I){h.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+o.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(r){});};o.prototype._requestAdjustLayoutAndUxRules=function(I){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,o.DOM_CALC_DELAY,this);}if(!I){h.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+o.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(r){});};o.prototype._adjustLayoutAndUxRules=function(){var s,r;h.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();r=this.oCore.byId(s);if(r){this._setSelectedSectionId(s);if(this.getUseIconTabBar()){this._setCurrentTabSection(r);}this._requestAdjustLayout(true).then(function(t){if(t){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();if(!this._isClosestScrolledSection(s)||this._oScroller._$Container.is(":animated")){this.scrollToSection(s,null,0,false,true);}}.bind(this));}};o.prototype._isClosestScrolledSection=function(s){var r=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,P=this.iScreenHeight,t=this._getClosestScrolledSectionId(r,P);return t&&(s===t);};o.prototype._setSelectedSectionId=function(s){var r=this.getAggregation("_anchorBar"),t=s&&this._oSectionInfo[s];if(!t){return;}if(r&&t.buttonId){r.setSelectedButton(t.buttonId);this.setAssociation("selectedSection",s,true);}};o.prototype.isFirstRendering=function(){return this._bFirstRendering;};o.prototype._cleanMemory=function(){var r=this.getAggregation("_anchorBar");if(r){r._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};o.prototype._registerSectionBaseInfo=function(s){this._oSectionInfo[s.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:"",isSection:(s instanceof b),sectionReference:s};this._aSectionBases.push(s);};o.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};o.prototype.scrollToSection=function(I,r,s,t,u){var v=this.oCore.byId(I);if(!this.getDomRef()){h.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!v){h.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]){h.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){h.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var w=b._getClosestSection(v);if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}w._allowPropagationToLoadedViews(true);this._setCurrentTabSection(v);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[w.getId()].buttonId);this.setAssociation("selectedSection",w.getId(),true);}if(t){this.fireNavigate({section:b._getClosestSection(v),subSection:v instanceof c?v:v.getSubSections()[0]});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();}s=s||0;v._expandSection();this._requestAdjustLayout(true);r=this._computeScrollDuration(r,v);var x=this._computeScrollPosition(v);if(this._sCurrentScrollId!=I||u){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),r);}this._preloadSectionsOnBeforeScroll(v);this.getHeaderTitle()&&this._shiftHeaderTitle();x+=s;if(!this._bStickyAnchorBar&&this._shouldSnapHeaderOnScroll(x)){this._scrollTo(this._getSnapPosition(),0);}this._scrollTo(x,r);}};o.prototype._computeScrollDuration=function(r,t){var s=parseInt(r);s=s>=0?s:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((t instanceof b)||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){s=0;}return s;};o.prototype._computeScrollPosition=function(t){var F=t&&(t instanceof b),I=t.getId(),s=this._bMobileScenario||F?this._oSectionInfo[I].positionTopMobile:this._oSectionInfo[I].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(t)){s=0;}return s;};o.prototype._preloadSectionsOnBeforeScroll=function(t){var I=t.getId(),r;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){r=(t instanceof b)?t:t.getParent();this._connectModelsForSections([r]);}if(this.getEnableLazyLoading()){var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;r=this._oLazyLoading.getSubsectionsToPreload(s,I);if(D.system.desktop){setTimeout(function(){this._connectModelsForSections(r);}.bind(this),50);}else{this._connectModelsForSections(r);}r.forEach(function(u){this.fireEvent("subSectionEnteredViewPort",{subSection:u});},this);}};o.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};o.prototype.setDirectScrollingToSection=function(s){this.sDirectSectionId=s;};o.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};o.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};o.prototype._scrollTo=function(y,t){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){h.debug("ObjectPageLayout :: scrolling to "+y);if((t===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}this._oScroller.scrollTo(0,y,t);}return this;};o.prototype._scrollBelowCollapseVisualIndicator=function(){var H=this._getHeaderContent(),$,r,v,s;if(!p(H)||!p(this._$opWrapper)){return;}$=H._getCollapseButton().getDomRef();r=$.getBoundingClientRect().height;v=this._$opWrapper[0].getBoundingClientRect().height;s=$.offsetTop+r-v;this._scrollTo(s);};o.prototype._updateMedia=function(w,r){var u=function(s){Object.keys(r).forEach(function(t){var v=r[t],E=s===v;this.toggleStyleClass(v,E);},this);}.bind(this),B=o.BREAK_POINTS;if(w<=B.PHONE){u(r.PHONE);}else if(w<=B.TABLET){u(r.TABLET);}else{u(r.DESKTOP);}};o.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var r,s,t,P,u,v,w=!this._bHeaderExpanded,I,x,y,z=this.getDomRef(),U=this.getUseIconTabBar();if(!z||!this._bDomReady){return false;}h.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(z);if(this.iScreenHeight===0){return;}this.iFooterHeight=this._getFooterHeight();var B=-1;this._aSectionBases.forEach(function(E){var F=this._oSectionInfo[E.getId()],$=E.$(),G,H=false;if(!F||!$.length){return;}if(!F.isSection){B++;}F.$dom=$;var J=$.position().top;F.positionTop=Math.ceil(J);if(F.isSection){G=E.$("header");}else{G=E.$("headerTitle");}H=G.length===0;if(!H){F.positionTopMobile=Math.ceil(G.position().top)+G.outerHeight();}else{F.positionTopMobile=F.positionTop;}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){F.positionTopMobile-=this.iAnchorBarHeight;F.positionTop-=this.iAnchorBarHeight;}F.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",H);if(this._bMobileScenario){var N=this.oCore.byId(E.getId()).getParent();if(N instanceof b&&N._getIsHidden()){return;}if(u){this._oSectionInfo[u].positionBottom=F.positionTop;}u=E.getId();s=E;}else{if(F.isSection){if(u){this._oSectionInfo[u].positionBottom=F.positionTop;if(P){this._oSectionInfo[P].positionBottom=F.positionTop;}}u=E.getId();P=null;}else{if(P){this._oSectionInfo[P].positionBottom=F.positionTop;}P=E.getId();s=E;}}if(!F.isSection){x=U||(E.getParent()===this._oFirstVisibleSection);I=x&&(B===0);y=E.hasStyleClass(c.FIT_CONTAINER_CLASS);E._setHeight(this._computeSubSectionHeight(I,y,F.positionTop));}},this);if(s){r=this._computeLastVisibleHeight(s);if(this._bMobileScenario&&u){this._oSectionInfo[u].positionBottom=this._oSectionInfo[u].positionTop+r;}else{if(P){this._oSectionInfo[P].positionBottom=this._oSectionInfo[P].positionTop+r;}if(u&&P){this._oSectionInfo[u].positionBottom=this._oSectionInfo[P].positionTop+r;}}v=this._bStickyAnchorBar||(B>0)||this._checkContentBottomRequiresSnap(s);if(this._bAllContentFitsContainer){v=false;}if(v&&!this._shouldPreserveHeaderInTitleArea()){w=true;}t=this._computeSpacerHeight(s,r,v,w);this._$spacer.height(t+"px");h.debug("ObjectPageLayout :: bottom spacer is now "+t+"px");}this._updateCustomScrollerHeight(w);this._setSectionInfoIsDirty(false);return true;};o.prototype._computeSubSectionHeight=function(F,r,s){var t,u;if(!r){return"";}var I=(this._bAllContentFitsContainer)?this._bHeaderExpanded:F;t=this._getSectionsContainerHeight(!I);if(this._bAllContentFitsContainer){u=(s-this.iHeaderContentHeight)+this.iFooterHeight;t-=u;}return t+"px";};o.prototype._updateCustomScrollerHeight=function(r){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var s=this._computeScrollableContentSize(r);s+=this._getStickyAreaHeight(r);this._getCustomScrollBar().setContentSize(s+"px");var t=(s>Math.ceil(this.iScreenHeight)),v=(t!==this._getCustomScrollBar().getVisible());if(v){this._getCustomScrollBar().setVisible(t);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};o.prototype._computeScrollableContentSize=function(s){var r=0;if(this._$contentContainer&&this._$contentContainer.length){r=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&s){r-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!s){r+=this.iAnchorBarHeight;}return r;};o.prototype._computeLastVisibleHeight=function(r){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var s=this._getSectionPositionTop(r,I);return this._$spacer.position().top-s;};o.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};o.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};o.prototype._getSectionsContainerHeight=function(I){var s=this._getScrollableViewportHeight(I);if(!I){s-=(this.iHeaderContentHeight+this.iAnchorBarHeight);}return s;};o.prototype._getSectionPositionTop=function(s,r){var P=s.$().position().top;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea&&r){P-=this.iAnchorBarHeight;}return P;};o.prototype._getSectionPositionBottom=function(s,r){var P=this._oSectionInfo[s.getId()].positionBottom;if(!r){P+=this.iAnchorBarHeight;}return P;};o.prototype._determineSectionBaseInternalTitleLevel=function(s){var r=this.getSectionTitleLevel(),I=s instanceof b;if(r===k.Auto){return I?k.H3:k.H4;}return I?r:o._getNextTitleLevelEntry(r);};o.prototype._shouldApplySectionTitleLevel=function(s){return s.getTitleLevel()===k.Auto;};o.prototype._checkContentBottomRequiresSnap=function(s){var r=false;return this._getSectionPositionBottom(s,r)>(this._getScrollableViewportHeight(r)+this._getSnapPosition());};o.prototype._computeSpacerHeight=function(r,s,t,u){var v,w;w=this._getScrollableViewportHeight(u);if(!t){s=this._getSectionPositionBottom(r,false);}if(s<w){v=w-s;if(this._bMobileScenario){v+=(this._oSectionInfo[r.getId()].positionTopMobile-this._oSectionInfo[r.getId()].positionTop);}}else{v=0;}if((this.iFooterHeight>v)){v+=this.iFooterHeight;}return v;};o.prototype._isFirstVisibleSectionBase=function(s){var r,t,F,u=this.getSelectedSection(),U=this.getUseIconTabBar();if(!s||!s.getParent()){return;}r=s.getId();if(U&&(r===u)){return true;}if(U&&(s.getParent().getId()===u)){t=sap.ui.getCore().byId(u);F=this._getFirstVisibleSubSection(t);return F&&(F.getId()===r);}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return r===this._oFirstVisibleSection.getId()||r===this._oFirstVisibleSubSection.getId();}return false;};o.prototype._getFirstVisibleSubSection=function(s){if(!s){return;}var F;this._aSectionBases.every(function(r){if(r.getParent()&&(r.getParent().getId()===s.getId())){F=r;return false;}return true;});return F;};o.prototype._initAnchorBarScroll=function(){var s=this.oCore.byId(this.getSelectedSection()),r;this._requestAdjustLayout(true);r=s?this._computeScrollPosition(s):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:r}},true);};o.prototype._setAsCurrentSection=function(s){var r,t,u;if(this._sScrolledSectionId===s){return;}h.debug("ObjectPageLayout :: current section is "+s);this._sScrolledSectionId=s;r=this.getAggregation("_anchorBar");if(r&&this._getInternalAnchorBarVisible()){t=this.oCore.byId(s);u=t&&t instanceof c&&(t.getTitle().trim()===""||!t._getInternalTitleVisible()||t.getParent()._getIsHidden());if(u){s=t.getParent().getId();h.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+s);}if(t&&this._oSectionInfo[s]){r.setSelectedButton(this._oSectionInfo[s].buttonId);this.setAssociation("selectedSection",b._getClosestSection(s).getId(),true);this._setSectionsFocusValues(s);}}};o.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};o.prototype._onUpdateContentSize=function(E){var s;if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(this._hasDynamicTitle()){this._adjustHeaderHeights();}this._requestAdjustLayout().then(function(){s=this._$opWrapper.scrollTop();this._updateSelectionOnScroll(s);}.bind(this));};o.prototype._onUpdateScreenSize=function(E){var t=this.getHeaderTitle(),H=this._getHeaderContent(),r=E.size.width,s=E.size.height,u=E.oldSize.height,v=(s!==u),w,I=H&&H.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(E.size.height===0||E.size.width===0){h.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){h.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();setTimeout(function(){this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(I&&(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader())){this.invalidate();}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._scrollTo(0,0);}if(t&&t.isDynamic()){t._onResize(r);this._updateMedia(r,o.DYNAMIC_HEADERS_MEDIA);}this._updateMedia(r,o.MEDIA);this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}w=this.getSelectedSection();if((u===0)&&v&&!this._isClosestScrolledSection(w)){this.scrollToSection(w,0);}this._scrollTo(this._$opWrapper.scrollTop(),0);if((u===0)&&v&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading();}}.bind(this),this._getDOMCalculationDelay());};o.prototype._onUpdateHeaderTitleSize=function(E){if(E.size.height===0||E.size.width===0){h.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){h.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return;}this._adjustHeaderHeights();this._requestAdjustLayout();};o.prototype._shouldSnapHeaderOnScroll=function(s){return(s>0)&&(s>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};o.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0;};o.prototype._isContentScrolledToBottom=function(){return this._oLastScrollState.iScrollableContentLength<=(this._oLastScrollState.iScrollTop+this._oLastScrollState.iScrollableViewportHeight);};o.prototype._isContentLengthDecreased=function(P){if(P){return((P.iScrollableContentLength>this._oLastScrollState.iScrollableContentLength)&&(P.iSpacerHeight===this._oLastScrollState.iSpacerHeight));}};o.prototype._canReachScrollTop=function(r,E){var s;E=E||0;s=this._oLastScrollState.iScrollableContentLength+E-this._oLastScrollState.iScrollableViewportHeight;return s>=r;};o.prototype._deregisterCustomEvents=function(){if(this._$opWrapper.length){this._$opWrapper.off(".OPL");}};o.prototype._deregisterScreenSizeListener=function(){if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}};o.prototype._onScroll=function(E,I){var s=Math.max(Math.ceil(E.target.scrollTop),0),$=this._$opWrapper.length&&this._$opWrapper[0],r=this._$spacer.length&&this._$spacer[0],t=r.offsetHeight,P,H=this.getHeaderTitle(),u=this._shouldSnapHeaderOnScroll(s),v=this._shouldPreserveHeaderInTitleArea(),w=false,x=this._oLastScrollState;this._oLastScrollState={iScrollTop:s,iScrollableContentLength:Math.ceil(this._getScrollableContentLength()),iScrollableViewportHeight:$.offsetHeight,iSpacerHeight:t};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}if(!$||!r){return;}P=this.iScreenHeight;if(P===0){return;}if(this._getSectionInfoIsDirty()){return;}if(x&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(x)){var y=x.iScrollableContentLength-this._oLastScrollState.iScrollableContentLength;if(!this._canReachScrollTop(x.iScrollTop)&&this._canReachScrollTop(x.iScrollTop,y)){var N=t+y;this._$spacer.height(N+"px");this._scrollTo(x.iScrollTop);return;}}if(u&&!v){P-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!v){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!v&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(u,!!(E&&E.type==="scroll"));}if(!v){this._adjustHeaderTitleBackgroundPosition(s);}h.debug("ObjectPageLayout :: lazy loading : Scrolling at "+s,"----------------------------------------");this._updateSelectionOnScroll(s);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(I,s,E.timeStamp,P);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(s===0){q(document.getElementById(this.getId()+"-scroll")).css("z-index","1000");w=false;}else if(!w){w=true;q(document.getElementById(this.getId()+"-scroll")).css("z-index","0");}}};o.prototype._updateSelectionOnScroll=function(s){var P=this.iScreenHeight,r,t;if(P===0){return;}r=this._getClosestScrolledSectionId(s,P);t=this._getClosestScrolledSectionId(s,P,true);if(r){var u=this.getDirectScrollingToSection();if(r!==this._sScrolledSectionId){h.debug("ObjectPageLayout :: closest id "+r,"----------------------------------------");var u=this.getDirectScrollingToSection();if(u&&u!==r){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(r);}else if(r===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(t!==this._sScrolledSubSectionId){this._sScrolledSubSectionId=t;this.fireEvent("_sectionChange",{section:this.oCore.byId(r),subSection:this.oCore.byId(t)});}}};o.prototype._getSnapPosition=function(){var s=this.iHeaderContentHeight,t=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;if(t<o.MAX_SNAP_POSITION_OFFSET){s-=t;}return s;};o.prototype._getClosestScrolledSectionId=function(s,P,r){r=!!r;s=Math.ceil(s);var t=s+P,u,v=r||this._bMobileScenario;q.each(this._oSectionInfo,function(I,w){var x,y,z,B,E,F=this.getSelectedSection();x=this.oCore.byId(I);if(!x){return;}y=x.getParent();z=y instanceof b&&y._getIsHidden();if(this.getUseIconTabBar()&&F){E=this.oCore.byId(F);if(!E){return;}if(w.isSection&&w.sectionReference!=E){return true;}if(!w.isSection&&E.indexOfSubSection(w.sectionReference)<0){return true;}}if(w.isSection||(v&&!z)){if(!u&&(w.sectionReference._getInternalVisible()===true)){B=this._getFirstVisibleSubSection(w.sectionReference);if(w.isSection&&r&&B){u=B.getId();}else{u=I;}}if(w.isSection&&r){return true;}if(w.positionTop<=t&&s<=w.positionBottom){if(w.positionTop<=s&&w.positionBottom>s){u=I;return false;}}}}.bind(this));return u;};o.prototype._toggleHeader=function(s,u){var H;if(s===this._bStickyAnchorBar){return;}H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!s,u);}if(!this._bStickyAnchorBar&&s){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!s){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(p(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}}};o.prototype._restoreFocusAfter=function(r){var s=this.oCore.byId(this.oCore.getCurrentFocusedControlId());r.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){s&&s.$().focus();}}return this;};o.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};o.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var s=this._$opWrapper.scrollTop();this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(s);this._toggleHeaderStyleRules(false);}return this;};o.prototype._toggleHeaderStyleRules=function(s){s=!!s;var v=s?"hidden":"inherit";this._bStickyAnchorBar=s;this._$headerContent.css("overflow",v);this._$headerContent.toggleClass("sapContrastPlus",!s);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",s);this._$anchorBar.css("visibility",v);this._$anchorBar.toggleClass("sapUxAPObjectPageNavigationHidden",s);if(p(this._$stickyAnchorBar)){this._$stickyAnchorBar.attr("aria-hidden",!s);}this.fireToggleAnchorBar({fixed:s});if(!s&&!this.iAnchorBarHeight){this._requestAdjustLayout();}};o.prototype.getScrollDelegate=function(){return this._oScroller;};o.prototype.setHeaderTitle=function(H,s){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._adjustHeaderHeights.bind(this)});}this.setAggregation("headerTitle",H,s);this._oObserver&&this._oObserver.disconnect();this._oObserver=new M(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(H,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(H){this._createHeaderContent();}return this;};o.prototype._onModifyHeaderTitle=function(r){var H=this.getAggregation("_headerContent");H&&r.current&&H.setBackgroundDesign(r.current);};o.prototype.invalidate=function(r){if(this.getUseIconTabBar()&&r&&(r instanceof b)&&!r.isActive()){return;}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}a.prototype.invalidate.apply(this,arguments);};o.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),s=H&&H.supportsBackgroundDesign()&&H.getBackgroundDesign(),r=this.getAggregation("_headerContent"),t,N;var u=H?H.getCompatibleHeaderContentClass():d;if(!(r instanceof u)){t=this.getAggregation("_headerContent");if(t){t.destroy();}N=u.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");s&&N.setBackgroundDesign(s);this.setAggregation("_headerContent",N,true);}};o.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};o.prototype._adjustHeaderTitleBackgroundPosition=function(s){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-s)+"px");}}}};o.prototype._adjustHeaderHeights=function(){var t=this.getHeaderTitle(),P=true;if(t&&!t.supportsAdaptLayoutForDomElement()){P=false;}if(this._$headerTitle.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.ceil(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.height():this._$anchorBar.height();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$headerTitle.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(P);}else{this.iHeaderTitleHeight=this._$headerTitle.is(":visible")?this._$headerTitle.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(P);}this._adjustHeaderBackgroundSize();h.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{h.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};o.prototype._appendTitleCloneToDOM=function(E){var $=this._$headerTitle.clone();$.css({left:"-10000px",top:"-10000px",width:this._$headerTitle.width()+"px"});$.toggleClass("sapUxAPObjectPageHeaderStickied",E);$.appendTo(this._$headerTitle.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptLayoutForDomElement($);}return $;};o.prototype._obtainSnappedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;var s=this._$opWrapper.css("overflow-y");this._$opWrapper.css("overflow-y","hidden");if(v){$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();}else if(t&&t.snap){t.snap(false);H=t.$().outerHeight();t.unSnap(false);}this._$opWrapper.css("overflow-y",s);return H;};o.prototype._obtainExpandedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H,s,r;if(v){var u=this._$opWrapper.css("overflow-y");this._$opWrapper.css("overflow-y","hidden");$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();this._$opWrapper.css("overflow-y",u);}else if(t&&t.unSnap){s=this._$sectionsContainer.height();t.unSnap(false);H=t.$().outerHeight();t.snap(false);r=this._$sectionsContainer.height();this._adjustSpacerHeightUponUnsnapping(s,r);}return H;};o.prototype._adjustSpacerHeightUponUnsnapping=function(s,r){var t;if(s!=r){t=this._$spacer.height()-(r-s);this._$spacer.height(t);}};o.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),s=l.ObjectPageHeaderDesign.Light;if(H!=null){s=H.getHeaderDesign();}return s;};o.prototype._getVisibleSections=function(){return this.getSections().filter(function(s){return s.getVisible()&&s._getInternalVisible();});};o.prototype._setSectionsFocusValues=function(s){var r=this._getVisibleSections()||[],$,F='0',N='-1',t="tabindex",u,v=r[0];r.forEach(function(w){$=w.$();if(s===w.sId){$.attr(t,F);u=w;w._setSubSectionsFocusValues();}else{$.attr(t,N);w._disableSubSectionsFocus();}});if(!u&&r.length>0){v.$().attr(t,F);v._setSubSectionsFocusValues();u=v;}return u;};o.prototype.setShowHeaderContent=function(s){var r=this.getShowHeaderContent(),H;if(r!==s){if(r&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",s);H=this._getHeaderContent();if(H){H.setProperty("visible",s);}}return this;};o.prototype._headerTitleChangeHandler=function(I){var r;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}r=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(r,this);this._getHeaderContent().invalidate();r.destroy();};o.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};o.prototype.insertHeaderContent=function(r,I,s){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",r,I,s);}return this._getHeaderContent().insertAggregation("content",r,I,s);};o.prototype.addHeaderContent=function(r,s){if(!this._getHeaderContent()){return this.addAggregation("headerContent",r,s);}return this._getHeaderContent().addAggregation("content",r,s);};o.prototype.removeAllHeaderContent=function(s){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",s);}return this._getHeaderContent().removeAllAggregation("content",s);};o.prototype.removeHeaderContent=function(r,s){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",r,s);}return this._getHeaderContent().removeAggregation("content",r,s);};o.prototype.destroyHeaderContent=function(s){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",s);}return this._getHeaderContent().destroyAggregation("content",s);};o.prototype.indexOfHeaderContent=function(r){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",r);}return this._getHeaderContent().indexOfAggregation("content",r);};o.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};o.prototype._connectModelsForSections=function(s){s=s||[];s.forEach(function(r){r.connectToModels();});};o.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};o.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};o.prototype._shiftHeaderTitle=function(){var s=this._calculateShiftOffset(),r=s.sStyleAttribute,P=s.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+r,P+"px");};o.prototype._isFirstSection=function(s){var r=this._getVisibleSections();if(s===r[0]){return true;}return false;};o.prototype._isValidStoredSubSectionInfo=function(){var s=this.getSelectedSection(),r=this.oCore.byId(s),t;if(!r||!this._oStoredScrolledSubSectionInfo){return false;}t=this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId);return t&&this._sectionCanBeRenderedByUXRules(t)&&(r.indexOfSubSection(t)>=0);};o.prototype._restoreScrollPosition=function(){var v=this._isValidStoredSubSectionInfo(),r;if(v){r=this._computeScrollPosition(this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId))+this._oStoredScrolledSubSectionInfo.iOffset;this._scrollTo(r,0);}else{this.scrollToSection(this.getSelectedSection(),0);}};o.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady||!this._oScroller){return;}var s=this._oScroller.getScrollTop(),r=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true),t;if(r){t=s-this._computeScrollPosition(this.oCore.byId(r));}this._iStoredScrollTop=s;this._oStoredScrolledSubSectionInfo={sSubSectionId:r,iOffset:t};this._oCurrentTabSection=null;};o.prototype.onkeyup=function(E){var F,r;if(E.which===K.TAB){F=this.oCore.getCurrentFocusedControlId();r=F&&this.oCore.byId(F);if(r&&this._isFirstSection(r)){this._scrollTo(0,0);}}};o.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};o.prototype._toggleFooter=function(s){var u,F=this.getFooter();if(!p(F)||!p(this._$footerWrapper)){return;}u=this.oCore.getConfiguration().getAnimationMode()!==C.AnimationMode.none;if(u){this._toggleFooterAnimation(s,F);}else{this._$footerWrapper.toggleClass("sapUiHidden",!s);}this._requestAdjustLayout();};o.prototype._toggleFooterAnimation=function(s,F){this._$footerWrapper.bind("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,F));this._bIsFooterAanimationGoing=true;if(s){this._$footerWrapper.removeClass("sapUiHidden");}F.toggleStyleClass(o.SHOW_FOOTER_CLASS_NAME,s);F.toggleStyleClass(o.HIDE_FOOTER_CLASS_NAME,!s);};o.prototype._onToggleFooterAnimationEnd=function(F){this._$footerWrapper.unbind("webkitAnimationEnd animationend");if(F.hasStyleClass(o.HIDE_FOOTER_CLASS_NAME)){this._$footerWrapper.addClass("sapUiHidden");F.removeStyleClass(o.HIDE_FOOTER_CLASS_NAME);}else{F.removeStyleClass(o.SHOW_FOOTER_CLASS_NAME);}this._bIsFooterAanimationGoing=false;};o.prototype.clone=function(){var r,H,s;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);r=a.prototype.clone.apply(this,arguments);H=this._getHeaderContent();s=r._getHeaderContent();if(s){s.destroy();}if(H){r.setAggregation("_headerContent",H.clone(),true);}return r;};o.prototype._cloneProxiedAggregations=function(s){var r=this.mAggregations[s];if(Array.isArray(r)&&r.length===0){r=this["get"+s.charAt(0).toUpperCase()+s.slice(1)]();}this.mAggregations[s]=r;};o.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};o.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};o.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed();};o.prototype._headerBiggerThanAllowedToBeFixed=function(){var r=this._getOwnHeight();return this._getEntireHeaderHeight()>o.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*r;};o.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight();};o.prototype._getOwnHeight=function(){return this._getHeight(this);};o.prototype._getHeight=function(r){return!(r instanceof a)?0:r.$().outerHeight()||0;};o.prototype._getEntireHeaderHeight=function(){var t=0,H=0,r=this.getHeaderTitle(),s=this._getHeaderContent();if(p(r)){t=r.$().outerHeight();}if(p(s)){H=s.$().outerHeight();}return t+H;};o.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();this._restorePinButtonFocus();}};o.prototype._restorePinButtonFocus=function(){var H=this._getHeaderContent();if(p(H)&&H.supportsPinUnpin()){H._focusPinButton();}};o.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._togglePinButtonARIAState(this._bPinned);this._updateToggleHeaderVisualIndicators();if(p($)){$.addClass("sapUxAPObjectPageLayoutHeaderPinned");}if(p(this._$stickyAnchorBar)){this._$stickyAnchorBar.addClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}};o.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(p($)){$.removeClass("sapUxAPObjectPageLayoutHeaderPinned");}};o.prototype._togglePinButtonARIAState=function(P){var H=this._getHeaderContent();if(p(H)&&H.supportsPinUnpin()){H._updateARIAPinButtonState(P);}};o.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};o.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._bHeaderBiggerThanAllowedHeight=false;return;}this._bHeaderBiggerThanAllowedHeight=true;if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};o.prototype._hasDynamicTitle=function(){var t=this.getHeaderTitle();return t&&t.isDynamic();};o.prototype._attachVisualIndicatorsPressHandlers=function(P,r){var t=this.getHeaderTitle(),H=this._getHeaderContent();if(p(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(o.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){P.call(r);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(p(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(o.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){P.call(r);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};o.prototype._hasVisibleDynamicTitleAndHeader=function(){var t=this.getHeaderTitle(),H=this.getHeaderContent();return p(t)&&t.isDynamic()&&t.getVisible()&&p(H)&&H.length>0;};o.prototype._hasDynamicTitleWithSnappedTitleOnMobile=function(){var t=this.getHeaderTitle();return p(t)&&t.isDynamic()&&!!t.getSnappedTitleOnMobile()&&D.system.phone;};o.prototype._updateToggleHeaderVisualIndicators=function(){var H,r,E,s=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!s){r=false;E=false;}else{H=this._bHeaderExpanded;r=H;E=!H&&!this._hasDynamicTitleWithSnappedTitleOnMobile();}this._toggleCollapseVisualIndicator(r);this._toggleExpandVisualIndicator(E);};o.prototype._updateTitleVisualState=function(){var t=this.getHeaderTitle(),r=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick()&&!this._hasDynamicTitleWithSnappedTitleOnMobile();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",r);if(p(t)){t._toggleFocusableState(r);}};o.prototype._focusCollapseVisualIndicator=function(){var r=this._getHeaderContent();if(p(r)){r._focusCollapseButton();}};o.prototype._focusExpandVisualIndicator=function(){var r=this.getHeaderTitle();if(p(r)){r._focusExpandButton();}};o.prototype._toggleExpandVisualIndicator=function(t){var r=this.getHeaderTitle();if(p(r)){r._toggleExpandButton(t);}};o.prototype._toggleCollapseVisualIndicator=function(t){var r=this._getHeaderContent();if(p(r)){r._toggleCollapseButton(t);}};o.prototype._attachVisualIndicatorMouseOverHandlers=function(r,s,t){var H=this._getHeaderContent();if(p(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(o.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,r,t);H.attachEvent(o.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,s,t);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};o.prototype._attachTitleMouseOverHandlers=function(r,s,t){var u=this.getHeaderTitle();if(p(u)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){u.attachEvent(o.EVENTS.TITLE_MOUSE_OVER,r,t);u.attachEvent(o.EVENTS.TITLE_MOUSE_OUT,s,t);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};o.prototype._suppressScroll=function(){this._bSuppressScroll=true;};o.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollTop){this._scrollTo(this._iStoredScrollTop,0);}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}});}};o.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};o.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};o.prototype._getHeight=function(r){return!(r instanceof a)?0:r.$().outerHeight()||0;};o.prototype._getWidth=function(r){var s=r.getDomRef();return!(r instanceof a)?0:(s&&s.offsetWidth)||0;};o.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty;};o.prototype._setSectionInfoIsDirty=function(r){this.bSectionInfoIsDirty=r;};o.prototype._getAriaLabelText=function(E){var H=this.getHeaderTitle(),t=H?H.getTitleText():null,s;if(H&&t){s=t+" "+o._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITH_TITLE");}else{s=o._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITHOUT_TITLE");}return s;};o.prototype._getFooterHeight=function(){if(this.getFooter()&&this.getShowFooter()){return this._getDOMRefHeight(this.$("footerWrapper").get(0));}return 0;};o.prototype._getDOMRefHeight=function(r){return r.parentElement?r.getBoundingClientRect().height:0;};o.prototype._updateAriaLabels=function(){var r=this.getLandmarkInfo(),s=this._getAriaLabelText("ROOT"),H=this._getAriaLabelText("HEADER"),N=this._getAriaLabelText("NAVIGATION"),t=this._getAriaLabelText("NAVTOOLBAR"),u=r&&r.getHeaderLabel(),v=r&&r.getRootLabel(),w=r&&r.getNavigationLabel();if(!v){this.$().attr("aria-label",s);}if(!u){this.$("headerTitle").attr("aria-label",H);}if(!w){this.$("anchorBar").attr("aria-label",N);this.$("stickyAnchorBar").attr("aria-label",N);}this.$("anchBar").attr("aria-label",t);};o.prototype._formatLandmarkInfo=function(r,P){if(r){var s=r["get"+P+"Role"]()||"",t=r["get"+P+"Label"]()||"";if(s===m.None){s='';}return{role:s.toLowerCase(),label:t};}return{};};o.prototype._getHeaderTag=function(r){if(r&&r.getHeaderRole()!==m.None){return o.DIV;}return o.HEADER;};o.prototype._getFooterTag=function(r){if(r&&r.getFooterRole()!==m.None){return o.DIV;}return o.FOOTER;};function p(v){if(arguments.length===1){return Array.isArray(v)?v.length>0:!!v;}return Array.prototype.slice.call(arguments).every(function(r){return p(r);});}return o;});
