/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','./InputBase','./DateTimeField','sap/ui/core/date/UniversalDate','./library','sap/ui/core/Control','sap/ui/core/library',"./DatePickerRenderer","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/IconPool","sap/ui/core/Popup","./InstanceManager","sap/ui/unified/Calendar","sap/ui/unified/DateRange","sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CustomYearPicker","sap/ui/dom/jquery/cursorPos"],function(q,D,I,a,U,l,C,c,b,d,e,L,f,P,g,h,i,j,k){"use strict";var T=c.TextAlign;var m=c.CalendarType;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var n=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"},afterPopupOpened:{type:"boolean"}}}},designtime:"sap/m/designtime/DatePicker.designtime",dnd:{draggable:false,droppable:true}}});n.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,999);var z=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,tooltip:r.getText("OPEN_PICKER_TEXT")});this._bShouldClosePicker=false;z.addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=!!this.isOpen();}},this);z.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);this._popupFollowOf=o.bind(this);};n.prototype.isValidValue=function(){return this._bValid;};n.prototype.isOpen=function(){return this._oPopup&&this._oPopup.isOpen();};n.prototype.toggleOpen=function(O){if(this.getEditable()&&this.getEnabled()){if(O){s.call(this);}else{_.call(this);}}};n.prototype.getIconSrc=function(){return f.getIconURI("appointment-2");};n.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}if(this._iInvalidateCalendar){clearTimeout(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};n.prototype.invalidate=function(O){if(!O||O!=this._oCalendar){C.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=setTimeout(y.bind(this),0);}};n.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();var V=this._getValueHelpIcon();if(V){V.setProperty("visible",this.getEditable(),true);}};n.prototype.setWidth=function(W){return I.prototype.setWidth.call(this,W||"100%");};n.prototype.getWidth=function(W){return this.getProperty("width")||"100%";};n.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;I.prototype.applyFocusInfo.apply(this,arguments);};n.prototype.onfocusin=function(E){if(!q(E.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};n.prototype.onsapshow=function(E){this.toggleOpen(this.isOpen());E.preventDefault();};n.prototype.onsaphide=n.prototype.onsapshow;n.prototype.onsappageup=function(E){t.call(this,1,"day");E.preventDefault();};n.prototype.onsappageupmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){t.call(this,1,"month");}else{t.call(this,1,"year");}E.preventDefault();};n.prototype.onsappagedown=function(E){t.call(this,-1,"day");E.preventDefault();};n.prototype.onsappagedownmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){t.call(this,-1,"month");}else{t.call(this,-1,"year");}E.preventDefault();};n.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=this._getFormatter(true);var z=String.fromCharCode(E.charCode);if(z&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(z)<0){E.preventDefault();}};n.prototype._getValueHelpIcon=function(){var V=this.getAggregation("_endIcon");return V&&V[0];};n.prototype._dateValidation=function(z){this._bValid=true;if(z&&(z.getTime()<this._oMinDate.getTime()||z.getTime()>this._oMaxDate.getTime())){this._bValid=false;e(this._bValid,"Date must be in valid range");}this.setProperty("dateValue",z);return z;};n.prototype.setMinDate=function(z){if(this._isValidDate(z)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMinDate(),z)){return this;}if(z){var Y=z.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(z.getTime());var A=this.getDateValue();if(A&&A.getTime()<z.getTime()){this._bValid=false;L.warning("DateValue not in valid date range",this);}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",z);if(this._oCalendar){this._oCalendar.setMinDate(z);}this._oMinDate.setHours(0,0,0,0);return this;};n.prototype.setMaxDate=function(z){if(this._isValidDate(z)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMaxDate(),z)){return this;}if(z){var Y=z.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(z.getTime());var A=this.getDateValue();if(A&&A.getTime()>z.getTime()){this._bValid=false;L.warning("DateValue not in valid date",this);}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,999);}this.setProperty("maxDate",z);if(this._oCalendar){this._oCalendar.setMaxDate(z);}this._oMaxDate.setHours(23,59,59,999);return this;};n.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){L.warning("minDate > MaxDate -> dates switched",this);var M=new Date(this._oMinDate.getTime());var z=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(z.getTime());this._oMaxDate=new Date(M.getTime());this.setProperty("minDate",z,true);this.setProperty("maxDate",M,true);if(this._oCalendar){this._oCalendar.setMinDate(z);this._oCalendar.setMaxDate(M);}}var A=this.getDateValue();if(A&&(A.getTime()<this._oMinDate.getTime()||A.getTime()>this._oMaxDate.getTime())){this._bValid=false;L.error("dateValue "+A.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this);}};n.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};n.prototype._handleDateValidation=function(z){this._bValid=true;if(!z||z.getTime()<this._oMinDate.getTime()||z.getTime()>this._oMaxDate.getTime()){this._bValid=false;L.warning("Value can not be converted to a valid date",this);}this.setProperty("dateValue",z);};n.prototype.setDisplayFormatType=function(z){if(z){var F=false;for(var A in m){if(A==z){F=true;break;}}if(!F){throw new Error(z+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",z,true);this.setDisplayFormat(this.getDisplayFormat());return this;};n.prototype.setSecondaryCalendarType=function(z){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",z,true);if(this._oCalendar){this._oCalendar.setSecondaryCalendarType(z);}return this;};n.prototype.addSpecialDate=function(S){x.call(this,S);this.addAggregation("specialDates",S,true);y.call(this);return this;};n.prototype.insertSpecialDate=function(S,z){x.call(this,S);this.insertAggregation("specialDates",S,z,true);y.call(this);return this;};n.prototype.removeSpecialDate=function(S){var R=this.removeAggregation("specialDates",S,true);y.call(this);return R;};n.prototype.removeAllSpecialDates=function(){var R=this.removeAllAggregation("specialDates",true);y.call(this);return R;};n.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);y.call(this);return this;};n.prototype.setLegend=function(z){this.setAssociation("legend",z,true);var A=this.getLegend();if(A){var B=sap.ui.require("sap/ui/unified/CalendarLegend");z=sap.ui.getCore().byId(A);if(z&&!(typeof B=="function"&&z instanceof B)){throw new Error(z+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._oCalendar){this._oCalendar.setLegend(A);}return this;};n.prototype.onChange=function(E){if(!this.getEditable()||!this.getEnabled()){return;}var V=this._$input.val();var O=this._formatValue(this.getDateValue());if(V==O&&this._bValid){return;}var z;this._bValid=true;if(V!=""){z=this._parseValue(V,true);if(!z||z.getTime()<this._oMinDate.getTime()||z.getTime()>this._oMaxDate.getTime()){this._bValid=false;z=undefined;}else{V=this._formatValue(z);}}if(this.getDomRef()&&(this._$input.val()!==V)){this._$input.val(V);this._curpos=this._$input.cursorPos();}if(z){V=this._formatValue(z,true);}if(this._lastValue!==V||(z&&this.getDateValue()&&z.getFullYear()!==this.getDateValue().getFullYear())){this._lastValue=V;this.setProperty("value",V,true);var N=this.getValue();if(this._bValid&&V==N){this.setProperty("dateValue",z,true);}V=N;if(this.isOpen()){if(this._bValid){z=this.getDateValue();}this._oCalendar.focusDate(z);var S=this._oDateRange.getStartDate();if((!S&&z)||(S&&z&&S.getTime()!=z.getTime())){this._oDateRange.setStartDate(new Date(z.getTime()));}else if(S&&!z){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(V,{valid:this._bValid});}};n.prototype._getInputValue=function(V){V=(typeof V=="undefined")?this._$input.val():V.toString();var z=this._parseValue(V,true);V=this._formatValue(z,true);return V;};n.prototype.updateDomValue=function(V){if(this.isActive()&&(this._$input.val()!==V)){this._bCheckDomValue=true;V=(typeof V=="undefined")?this._$input.val():V.toString();this._curpos=this._$input.cursorPos();var z=this._parseValue(V,true);V=this._formatValue(z);this._$input.val(V);this._$input.cursorPos(this._curpos);}return this;};n.prototype._storeInputSelection=function(z){if((D.browser.msie||D.browser.edge)&&!D.support.touch){this._oInputSelBeforePopupOpen={iStart:z.selectionStart,iEnd:z.selectionEnd};z.selectionStart=0;z.selectionEnd=0;}};n.prototype._restoreInputSelection=function(z){if((D.browser.msie||D.browser.edge)&&!D.support.touch){z.selectionStart=this._oInputSelBeforePopupOpen.iStart;z.selectionEnd=this._oInputSelBeforePopupOpen.iEnd;}};function _(){this._createPopup();this._createPopupContent();var z;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){z=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){z=B.oType.oFormat.oFormatOptions.calendarType;}if(!z){z=this.getDisplayFormatType();}if(z){this._oCalendar.setPrimaryCalendarType(z);}var V=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(V!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar),afterPopupOpened:true});}n.prototype._createPopup=function(){if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setDurations(0,0);this._oPopup.attachOpened(u,this);this._oPopup.attachClosed(v,this);}};n.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));this._oPopup.setAutoCloseAreas([this.getDomRef()]);var z=P.Dock;var A;if(this.getTextAlign()==T.End){A=z.EndBottom+"-4";this._oPopup.open(0,z.EndTop,A,this,null,"fit",this._popupFollowOf);}else{A=z.BeginBottom+"-4";this._oPopup.open(0,z.BeginTop,A,this,null,"fit",this._popupFollowOf);}};function o(z){var O=this.getDomRef();if(!O||!q(O).is(":visible")||!p(O)){this._oPopup.close();}else{this._oPopup._applyPosition(z.lastPosition);}}function p(z){var R;if(!z){return false;}if(z instanceof q){z=z.get(0);}R=z.getBoundingClientRect();return(R.top>=0&&R.left>=0&&R.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&R.right<=(window.innerWidth||document.documentElement.clientWidth));}n.prototype._getVisibleDatesRange=function(z){var V=z._getVisibleDays();return new i({startDate:V[0].toLocalJSDate(),endDate:V[V.length-1].toLocalJSDate()});};n.prototype._createPopupContent=function(){var z=this._getFormatter(true).aFormatArray.map(function(E){return E.type;}),A=z.indexOf("day")>=0?true:false,M=z.indexOf("month")>=0?true:false,Y=z.indexOf("year")>=0?true:false,B;if(!this._oCalendar){if(A&&M&&Y){B=h;}else if(M&&Y){B=j;}else if(Y){B=k;}this._oCalendar=new B(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}.bind(this)});this._oDateRange=new i();this._oCalendar.addSelectedDate(this._oDateRange);if(this.$().closest(".sapUiSizeCompact").length>0){this._oCalendar.addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._oCalendar.setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._oCalendar.attachSelect(this._selectDate,this);this._oCalendar.attachCancel(s,this);this._oCalendar.attachEvent("_renderMonth",w,this);this._oCalendar.setPopupMode(true);this._oCalendar.setParent(this,undefined,true);this._oPopup.setContent(this._oCalendar);}}};n.prototype._fillDateRange=function(){var z=this.getDateValue();if(z&&z.getTime()>=this._oMinDate.getTime()&&z.getTime()<=this._oMaxDate.getTime()){this._oCalendar.focusDate(new Date(z.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=z.getTime()){this._oDateRange.setStartDate(new Date(z.getTime()));}}else{var A=this.getInitialFocusedDateValue();var F=A?A:new Date();var M=this._oMaxDate.getTime();if(F.getTime()<this._oMinDate.getTime()||F.getTime()>M){F=this._oMinDate;}this._oCalendar.focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};n.prototype.getAccessibilityInfo=function(){var R=this.getRenderer();var z=I.prototype.getAccessibilityInfo.apply(this,arguments);var V=this.getValue()||"";if(this._bValid){var A=this.getDateValue();if(A){V=this._formatValue(A);}}z.type=r.getText("ACC_CTR_TYPE_DATEINPUT");z.description=[V,R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this)].join(" ").trim();return z;};n.prototype._selectDate=function(E){var z=this.getDateValue();var A=this._getSelectedDate();var V="";if(!d(A,z)){this.setDateValue(new Date(A.getTime()));V=this.getValue();this.fireChangeEvent(V,{valid:true});this._focusInput();}else if(!this._bValid){V=this._formatValue(A);if(V!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(V);this._lastValue=V;}V=this._formatValue(A,true);this.setProperty("value",V,true);this.fireChangeEvent(V,{valid:true});this._focusInput();}}else if(D.system.desktop||!D.support.touch){this.focus();}this._oPopup.close();};n.prototype._focusInput=function(){if(this.getDomRef()&&(D.system.desktop||!D.support.touch)){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}return this;};n.prototype._getSelectedDate=function(){var S=this._oCalendar.getSelectedDates();var z;if(S.length>0){z=S[0].getStartDate();}return z;};function s(E){if(this.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)){this.focus();}}}function t(N,z){var O=this.getDateValue();var A=this._$input.cursorPos();if(O&&this.getEditable()&&this.getEnabled()){var B;var E=this.getBinding("value");if(E&&E.oType&&E.oType.oOutputFormat){B=E.oType.oOutputFormat.oFormatOptions.calendarType;}else if(E&&E.oType&&E.oType.oFormat){B=E.oType.oFormat.oFormatOptions.calendarType;}if(!B){B=this.getDisplayFormatType();}var F=U.getInstance(new Date(O.getTime()),B);O=U.getInstance(new Date(O.getTime()),B);switch(z){case"day":F.setDate(F.getDate()+N);break;case"month":F.setMonth(F.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(F.getMonth()!=M){F.setDate(F.getDate()-1);}break;case"year":F.setFullYear(F.getFullYear()+N);while(F.getMonth()!=O.getMonth()){F.setDate(F.getDate()-1);}break;default:break;}if(F.getTime()<this._oMinDate.getTime()){F=new U(this._oMinDate.getTime());}else if(F.getTime()>this._oMaxDate.getTime()){F=new U(this._oMaxDate.getTime());}if(!d(this.getDateValue(),F.getJSDate())){this.setDateValue(new Date(F.getTime()));this._curpos=A;this._$input.cursorPos(this._curpos);var V=this.getValue();this.fireChangeEvent(V,{valid:true});}}}function u(E){this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._renderedDays=this._oCalendar.$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);g.addPopoverInstance(this._oPopup);}function v(E){this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));g.removePopoverInstance(this._oPopup);}function w(E){var z=E.getParameter("days");if(z>this._renderedDays){this._renderedDays=z;this._oPopup._applyPosition(this._oPopup._oLastPosition);}}function x(S){var z=sap.ui.require("sap/ui/unified/DateTypeRange");if(S&&!(z&&S instanceof z)){throw new Error(S+"is not valid for aggregation \"specialDates\" of "+this);}}function y(){if(this.isOpen()){this._oCalendar._bDateRangeChanged=true;this._oCalendar.invalidate();}}return n;});
