/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/IconPool','sap/ui/core/delegate/ScrollEnablement','./IconTabBarSelectList','./Button','./ResponsivePopover','./IconTabFilter','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/Icon','./IconTabBarDragAndDropUtil','./IconTabHeaderRenderer',"sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/events/KeyCodes"],function(l,C,E,I,a,S,b,B,R,c,D,d,e,f,g,q,L,K){"use strict";var t=l.touch;var h=l.ImageHelper;var P=l.PlacementType;var j=l.ButtonType;var k=l.BackgroundDesign;var m=l.IconTabHeaderMode;var n=l.IconTabDensityMode;var o=C.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:m.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:k.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:n.Cozy}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:{draggable:true,droppable:true,layout:"Horizontal"}},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"}}}}}});E.apply(o.prototype,[true]);o.SCROLL_STEP=264;o.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iCurrentScrollLeft=0;this.startScrollX=0;this.startTouchX=0;this._scrollable=null;this._aTabKeys=[];this._oItemNavigation=new I().setCycling(false);this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);this._oScroller=new S(this,this.getId()+"-head",{horizontal:true,vertical:false,nonTouchScrolling:true});};o.prototype.isTouchScrollingDisabled=function(){return this.getShowOverflowSelectList()&&this.getParent().getMetadata().getName()=='sap.tnt.ToolHeader';};o.prototype._getSelectList=function(){var i=this;if(!this._oSelectList){this._oSelectList=new b({selectionChange:function(p){var T=p.getParameter('selectedItem');i.setSelectedItem(T._tabFilter);}});this._oSelectList._iconTabHeader=this;}return this._oSelectList;};o.prototype._getOverflowButton=function(){var O=this.getAggregation("_overflowButton");if(!O){O=new B({id:this.getId()+'-overflow',icon:"sap-icon://slim-arrow-down",type:j.Transparent,press:this._overflowButtonPress.bind(this)});O.addEventDelegate(this._onOverflowButtonEventDelegate);this.setAggregation("_overflowButton",O);}return O;};o.prototype._overflowButtonPress=function(i){if(!this._oPopover){this._oPopover=new R({showArrow:false,showHeader:false,placement:P.Vertical,offsetX:0,offsetY:0}).addStyleClass('sapMITBPopover');if(D.system.phone){this._oPopover._oControl.addButton(this._createPopoverCloseButton());}this.addDependent(this._oPopover);this._oPopover._oControl._adaptPositionParams=function(){var p=q("body").hasClass("sapUiSizeCompact");this._arrowOffset=0;if(p){this._offsets=["0 0","0 0","0 2","0 0"];}else{this._offsets=["0 0","0 0","0 3","0 0"];}this._myPositions=["end bottom","begin top","end top","end top"];this._atPositions=["end top","end top","end bottom","begin top"];};}var s=this._getSelectList();this._setSelectListItems();this._oPopover.removeAllContent();this._oPopover.addContent(s);this._oPopover.setInitialFocus(s.getSelectedItem());this._oPopover.openBy(this._getOverflowButton());};o.prototype._createPopoverCloseButton=function(){var i=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("SELECT_CANCEL_BUTTON"),press:function(){i._closeOverflow();}});};o.prototype._closeOverflow=function(){if(!D.system.desktop){this._oPopover.close();}if(this.oSelectedItem){this.oSelectedItem.$().focus();}};o.prototype._setSelectListItems=function(){if(!this.getShowOverflowSelectList()){return;}var s,T,p=this._getSelectList(),r=this.getTabFilters();p.destroyItems();for(var i=0;i<r.length;i++){T=r[i];s=T.clone(undefined,undefined,{bCloneChildren:false,bCloneBindings:true});s._tabFilter=T;p.addItem(s);if(T==this.oSelectedItem){p.setSelectedItem(s);}}};o.prototype._findSelectItem=function(T){var s=this._getSelectList(),p=s.getItems(),r;for(var i=0;i<p.length;i++){r=p[i];if(r._tabFilter==T){return r;}}};o.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var p=this.getItems();var r=-1;var s;for(var i=0;i<p.length;i++){s=p[i];if(s instanceof c==false){continue;}r++;if(this.oSelectedItem==s){break;}}this._oItemNavigation.setFocusedIndex(r);};o.prototype._onItemNavigationAfterFocus=function(i){var H=this.getDomRef("head"),p=i.getParameter("index"),$=i.getParameter('event');if($.keyCode===undefined){return;}this._iCurrentScrollLeft=H.scrollLeft;this._checkOverflow();if(p!==null&&p!==undefined){this._scrollIntoView(this.getTabFilters()[p],0);}};o.prototype.getTabFilters=function(){var i=this.getItems();var T=[];i.forEach(function(p){if(p instanceof c){T.push(p);}});return T;};o.prototype.exit=function(){if(this._oArrowLeft){this._oArrowLeft.destroy();}if(this._oArrowRight){this._oArrowRight.destroy();}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._sResizeListenerId){d.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};o.prototype._handleOnLongDragOver=function(){if(!this._oPopover||!this._oPopover.isOpen()){this._overflowButtonPress();}};o.prototype._handleOnDragOver=function(i){this._getOverflowButton().addStyleClass("sapMBtnDragOver");i.preventDefault();};o.prototype._handleOnDrop=function(){this._getOverflowButton().removeStyleClass("sapMBtnDragOver");};o.prototype._handleOnDragLeave=function(){this._getOverflowButton().removeStyleClass("sapMBtnDragOver");};o.prototype._setsDragAndDropConfigurations=function(){if(!this.getEnableTabReordering()&&this.getDragDropConfig().length){this.destroyDragDropConfig();}else if(this.getEnableTabReordering()&&!this.getDragDropConfig().length){f.setDragDropAggregations(this,"Horizontal");}};o.prototype.onBeforeRendering=function(){this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._onOverflowButtonEventDelegate={onlongdragover:this._handleOnLongDragOver.bind(this),ondragover:this._handleOnDragOver.bind(this),ondragleave:this._handleOnDragLeave.bind(this),ondrop:this._handleOnDrop.bind(this)};if(this._sResizeListenerId){d.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this._updateSelection();this._isTouchScrollingDisabled=this.isTouchScrollingDisabled();this._oScroller.setHorizontal(!this._isTouchScrollingDisabled&&(!this.getEnableTabReordering()||!D.system.desktop));this._setsDragAndDropConfigurations();};o.prototype.setSelectedKey=function(s){var p=this.getTabFilters(),i=0,r=this._isInsideIconTabBar(),u;if(p.length>0){s=s||p[0]._getNonEmptyKey();}if(this.$().length){for(;i<p.length;i++){if(p[i]._getNonEmptyKey()===s){this.setSelectedItem(p[i],true);u=true;break;}}if(!u&&!r&&s){this.setSelectedItem(null);}}this.setProperty("selectedKey",s,true);return this;};o.prototype.setSelectedItem=function(i,A){if(!i){if(this.oSelectedItem){this.oSelectedItem.$().removeClass("sapMITBSelected");this.oSelectedItem=null;}return this;}if(!i.getEnabled()){return this;}if(this.getShowOverflowSelectList()){var s=this._findSelectItem(i);if(s){this._getSelectList().setSelectedItem(s);}}var p=this.getParent();var r=this._isInsideIconTabBar();var u=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){u=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!A&&r&&p.getExpandable()||this.oSelectedItem!==i)){this.oSelectedItem.$().removeClass("sapMITBSelected").attr('aria-selected',false).removeAttr('aria-expanded');}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&r&&p.getExpandable()){p._toggleExpandCollapse();}}else{if(r){p.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(!r){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}if(r&&(p.getExpandable()||p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});var v=this.oSelectedItem.getContent();if(v.length>0){p._rerenderContent(v);}else{if(!u){p._rerenderContent(p.getContent());}}if(!A&&p.getExpandable()&&!p.getExpanded()){p._toggleExpandCollapse(true);}}}if(this.oSelectedItem.$().length>0){this._scrollIntoView(i,500);}else{this._scrollAfterRendering=true;}}this.oSelectedItem=i;var w=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",w,true);if(r){p.setProperty("selectedKey",w,true);}if(!A){if(r){p.fireSelect({selectedItem:this.oSelectedItem,selectedKey:w,item:this.oSelectedItem,key:w});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:w,item:this.oSelectedItem,key:w});}}return this;};o.prototype.getVisibleTabFilters=function(){var p=this.getTabFilters(),v=[],r;for(var i=0;i<p.length;i++){r=p[i];if(r.getVisible()){v.push(r);}}return v;};o.prototype._getFirstVisibleItem=function(p){for(var i=0;i<p.length;i++){if(p[i].getVisible()){return p[i];}}return null;};o.prototype._initItemNavigation=function(){var i=this,H=this.getDomRef("head"),p=this.getItems(),T=[],s=-1;p.forEach(function(r){if(r instanceof c){var u=i.getFocusDomRef(r);q(u).attr("tabindex","-1");T.push(u);if(r===i.oSelectedItem){s=T.indexOf(u);}}});if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(H);this._oItemNavigation.setItemDomRefs(T);this._oItemNavigation.setPageSize(T.length);this._oItemNavigation.setSelectedIndex(s);};o.prototype.onThemeChanged=function(){this._applyTabDensityMode();};o.prototype._applyTabDensityMode=function(){var T=this.getTabDensityMode();this.$().removeClass("sapUiSizeCompact");switch(T){case n.Compact:this.$().addClass("sapUiSizeCompact");break;case n.Inherit:if(this.$().closest(".sapUiSizeCompact").length){this.$().addClass("sapUiSizeCompact");}break;}};o.prototype.onAfterRendering=function(){this._applyTabDensityMode();if(this._oScroller){this._oScroller.setIconTabBar(this,q.proxy(this._afterIscroll,this),q.proxy(this._scrollPreparation,this));}var p=this.getParent();var i=this._isInsideIconTabBar();if(this.oSelectedItem&&(!i||i&&p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}setTimeout(this["_checkOverflow"].bind(this),350);if(this.oSelectedItem){this._scrollIntoView(this.oSelectedItem,500);}this._initItemNavigation();if(this.getShowOverflowSelectList()){this.$('overflow').attr('tabindex',-1);}this._sResizeListenerId=d.register(this.getDomRef(),q.proxy(this._fnResize,this));this._bCheckIfIntoView=true;};o.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");return this;};o.prototype.addItem=function(i){if(!(i instanceof sap.m.IconTabSeparator)){var s=i.getKey();if(this._aTabKeys.indexOf(s)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+s+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(s);}this.addAggregation("items",i);this._invalidateParentIconTabBar();};o.prototype.insertItem=function(i,p){if(!(i instanceof sap.m.IconTabSeparator)){var s=i.getKey();if(this._aTabKeys.indexOf(s)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+s+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(s);}this.insertAggregation("items",i,p);this._invalidateParentIconTabBar();};o.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items");this._aTabKeys=[];this.oSelectedItem=null;this._invalidateParentIconTabBar();return r;};o.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof sap.m.IconTabSeparator)){var s=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(s),1);}if(this.oSelectedItem===i){this.oSelectedItem=null;}this._invalidateParentIconTabBar();return i;};o.prototype.updateAggregation=function(){this.oSelectedItem=null;C.prototype.updateAggregation.apply(this,arguments);this.invalidate();};o.prototype.removeAggregation=function(A,O,s){var i=this.getTabFilters();var p=C.prototype.removeAggregation.apply(this,arguments);if(s){return p;}if(p&&p==this.oSelectedItem&&A=='items'){var r=(i?Array.prototype.indexOf.call(i,p):-1);i=this.getTabFilters();r=Math.max(0,Math.min(r,i.length-1));var u=i[r];if(u){this.setSelectedItem(u,true);}else{var v=this.getParent();if(this._isInsideIconTabBar()&&v.getExpanded()){v.$("content").children().remove();}}}return p;};o.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(this._isInsideIconTabBar()&&i.getExpanded()){i.$("content").children().remove();}}return C.prototype.removeAllAggregation.apply(this,arguments);};o.prototype._getDisplayText=function(i){var T=i.getText();if(this.isInlineMode()){var s=i.getCount();if(s){if(this._bRtl){T='('+s+') '+T;}else{T+=' ('+s+')';}}}return T;};o.prototype.isInlineMode=function(){return this._bTextOnly&&this.getMode()==m.Inline;};o.prototype._checkTextOnly=function(p){if(p.length>0){for(var i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)){if(p[i].getIcon()){this._bTextOnly=false;return false;}}}}this._bTextOnly=true;return true;};o.prototype._checkNoText=function(p){if(p.length>0){for(var i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)){if(p[i].getText().length>0){return false;}}}}return true;};o.prototype._checkInLine=function(p){var r;if(p.length>0){for(var i=0;i<p.length;i++){r=p[i];if(!(r instanceof sap.m.IconTabSeparator)){if(r.getIcon()||r.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};o.prototype._checkScrolling=function(H){var $=this.$();var s=false;var i=this.getDomRef("scrollContainer");var p=this.getDomRef("head");if(p&&i){if(p.offsetWidth>i.offsetWidth){s=true;}}if(this._scrollable!==s){$.toggleClass("sapMITBScrollable",s);$.toggleClass("sapMITBNotScrollable",!s);this._scrollable=s;}this._setTabsVisibility();return s;};o.prototype._getScrollingArrow=function(N){var s=a.getIconURI("slim-arrow-"+N);var p={src:s,useIconTooltip:false};var i=this._bTextOnly?"TextOnly":"";var r="sapMITBArrowScrollLeft"+i;var u="sapMITBArrowScrollRight"+i;var v=["sapMITBArrowScroll",r,"sapMITHVerticallyCenteredArrow"];var w=["sapMITBArrowScroll",u,"sapMITHVerticallyCenteredArrow"];if(this._bInLine||this.isInlineMode()){v.push('sapMITBArrowScrollLeftInLine');w.push('sapMITBArrowScrollRightInLine');}if(N==="left"){if(!this._oArrowLeft){this._oArrowLeft=h.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p,v);}return this._oArrowLeft;}if(N==="right"){if(!this._oArrowRight){this._oArrowRight=h.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p,w);}return this._oArrowRight;}};o.prototype._checkOverflow=function(){if(this.bIsDestroyed){return;}var i=this.getDomRef("head");var $=this.$();if(this._checkScrolling(i)&&i){var s=false;var p=false;var r=this.getDomRef("scrollContainer");var u=this.getDomRef("head");if(this._oScroller.getScrollLeft()>0){s=true;}if((this._oScroller.getScrollLeft()+r.offsetWidth)<u.offsetWidth){p=true;}if((p!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){this._bPreviousScrollForward=p;this._bPreviousScrollBack=s;$.toggleClass("sapMITBScrollBack",s);$.toggleClass("sapMITBNoScrollBack",!s);$.toggleClass("sapMITBScrollForward",p);$.toggleClass("sapMITBNoScrollForward",!p);}}else{this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;}};o.prototype._handleActivation=function(i){var T=i.target.id,p=i.srcControl,s,$=q(i.target);if(p instanceof B){return;}var r=q(document.getElementById(T));if(r.parents()&&Array.prototype.indexOf.call(r.parents(),this.$("content")[0])>-1){}else{if(T){var u=this.getId();i.preventDefault();if(T==u+"-arrowScrollLeft"&&D.system.desktop){var v=this._oScroller.getScrollLeft()-o.SCROLL_STEP;if(v<0){v=0;}this._scrollPreparation();setTimeout(this._oScroller["scrollTo"].bind(this._oScroller,v,0,500),0);setTimeout(this["_afterIscroll"].bind(this),500);}else if(T==u+"-arrowScrollRight"&&D.system.desktop){var v=this._oScroller.getScrollLeft()+o.SCROLL_STEP;var w=this.$("scrollContainer").width();var H=this.$("head").width();if(v>(H-w)){v=H-w;}this._scrollPreparation();setTimeout(this._oScroller["scrollTo"].bind(this._oScroller,v,0,500),0);setTimeout(this["_afterIscroll"].bind(this),500);}else{if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){s=i.srcControl.getId().replace(/-icon$/,"");p=sap.ui.getCore().byId(s);if(p.getMetadata().isInstanceOf("sap.m.IconTab")&&!(p instanceof sap.m.IconTabSeparator)){this.setSelectedItem(p);}}else if(p.getMetadata().isInstanceOf("sap.m.IconTab")&&!(p instanceof sap.m.IconTabSeparator)){this.setSelectedItem(p);}}}else{if(p.getMetadata().isInstanceOf("sap.m.IconTab")&&!(p instanceof sap.m.IconTabSeparator)){this.setSelectedItem(p);}}}};o.prototype._scrollIntoView=function(i,p){if(this.bIsDestroyed){return;}var $=i.$(),s,N,r;if($.length>0){var u=this.$('head');var H=u.innerWidth()-u.width();var v=$.outerWidth(true);var w=$.position().left-H/2;s=this._oScroller.getScrollLeft();r=this.$("scrollContainer").width();N=0;if(w-s<0||w-s>r-v){if(w-s<0){N+=w;}else{N+=Math.min(w,w+v-r);N=Math.round(N);}this._scrollPreparation();this._iCurrentScrollLeft=N;setTimeout(this._oScroller["scrollTo"].bind(this._oScroller,N,0,p),0);setTimeout(this["_afterIscroll"].bind(this),p);}}return this;};o.prototype._scroll=function(i,p){this._scrollPreparation();var r=this.getDomRef("head");var s=r.scrollLeft;var u=D.browser.msie||D.browser.edge;if(!u&&this._bRtl){i=-i;}var v=s+i;q(r).stop(true,true).animate({scrollLeft:v},p,q.proxy(this._adjustAndShowArrow,this));this._iCurrentScrollLeft=v;};o.prototype._adjustAndShowArrow=function(){this._$bar&&this._$bar.toggleClass("sapMITBScrolling",false);this._$bar=null;if(D.system.desktop){this._checkOverflow();}};o.prototype._scrollPreparation=function(){if(!this._$bar){this._$bar=this.$().toggleClass("sapMITBScrolling",true);}};o.prototype._afterIscroll=function(){this._checkOverflow();this._adjustAndShowArrow();this._setTabsVisibility();};o.prototype._fnResize=function(){this._checkOverflow();if(this.oSelectedItem&&this._bCheckIfIntoView){this._scrollIntoView(this.oSelectedItem,0);if(!this._isTouchScrollingDisabled){this._bCheckIfIntoView=false;}}this._setTabsVisibility();};o.prototype._isInsideIconTabBar=function(){var p=this.getParent();return p instanceof C&&p.isA('sap.m.IconTabBar');};o.prototype._invalidateParentIconTabBar=function(){if(this._isInsideIconTabBar()){this.getParent().invalidate();}};o.prototype._setTabsVisibility=function(){if(!this._isTouchScrollingDisabled){return;}var T=this.getItems(),p,$,H,i;for(i=0;i<T.length;i++){p=T[i];$=p.$();if(!$.hasClass('sapMITBSelected')&&!this._isTabIntoView($)){$.addClass('sapMITBFilterHidden');}else{H=true;$.removeClass('sapMITBFilterHidden');}}if(!H){for(i=0;i<T.length;i++){p=T[i];$=p.$();if(this._isTabIntoView($,true)){$.removeClass('sapMITBFilterHidden');break;}}}this._moveVisibleTabs();};o.prototype._isTabIntoView=function($,s){if(!$.length){return false;}var i=this._oScroller.getScrollLeft(),p=this.$("scrollContainer").width(),r=this.$('head'),H=r.innerWidth()-r.width(),u=$.css('padding-left'),v=$.width()+parseFloat(u),w=Math.ceil($.position().left-H/2);if(w-i<0||(!s&&(w+v-i>p))){return false;}return true;};o.prototype._moveVisibleTabs=function(){if(!this._oScroller){return;}var s=this._oScroller.getScrollLeft(),$=this.$('head'),H=$.innerWidth()-$.width(),i=this.$().find('.sapMITBFilter:not(.sapMITBFilterHidden)').first(),p,r;if(!i.length){return;}r=i.position().left-H/2;if(!this._bRtl&&r-s>2){p=s-r;$.css('transform','translate('+p+'px)');}else{$.css('transform','');}return true;};o.prototype.getFocusDomRef=function(F){var T=F||this.oSelectedItem;if(!T){return null;}return T.getDomRef();};o.prototype.applyFocusInfo=function(F){if(F.focusDomRef){q(F.focusDomRef).focus();}};o.prototype._updateSelection=function(){var p=this.getItems(),s=this.getSelectedKey(),i=0,r=this.getParent(),u=this._isInsideIconTabBar(),v=r&&r.getMetadata().getName()=='sap.tnt.ToolHeader';if(p.length>0){if(!this.oSelectedItem||s&&s!==this.oSelectedItem._getNonEmptyKey()){if(s){for(;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)&&p[i]._getNonEmptyKey()===s){this.oSelectedItem=p[i];break;}}}if(!this.oSelectedItem&&(u||!s)){for(i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)&&p[i].getVisible()){this.oSelectedItem=p[i];break;}}}}if(!v&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)&&p[i].getVisible()){this.oSelectedItem=p[i];break;}}}if(this.oSelectedItem){this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);}}};o.prototype.ontouchstart=function(i){var T=i.targetTouches[0];this._iActiveTouch=T.identifier;this._iTouchStartPageX=T.pageX;this._iTouchStartPageY=T.pageY;this._iTouchDragX=0;this._iTouchDragY=0;var $=q(i.target);if($.hasClass('sapMITBArrowScroll')){i.preventDefault();}};o.prototype.ontouchmove=function(i){if(this._iActiveTouch===undefined){return;}var T=t.find(i.changedTouches,this._iActiveTouch);if(!T||T.pageX===this._iTouchStartPageX){return;}this._iTouchDragX+=Math.abs(this._iTouchStartPageX-T.pageX);this._iTouchDragY+=Math.abs(this._iTouchStartPageY-T.pageY);this._iTouchStartPageX=T.pageX;this._iTouchStartPageY=T.pageY;};o.prototype.ontouchend=function(i){if(this._iActiveTouch===undefined){return;}var M=D.system.desktop?5:15;if((this._scrollable&&this._iTouchDragX>M)||this._iTouchDragY>M){return;}var p=0;var r=1;var s;if(i.which===s||i.which===p||i.which===r){this._handleActivation(i);}this._iActiveTouch=undefined;};o.prototype.ontouchcancel=o.prototype.ontouchend;o.prototype.onkeydown=function(i){switch(i.which){case K.ENTER:this._handleActivation(i);i.preventDefault();break;case K.SPACE:i.preventDefault();break;}};o.prototype.onkeyup=function(i){if(i.which===K.SPACE){this._handleActivation(i);i.preventDefault();}};o.prototype._handleDragAndDrop=function(i){var s=i.getParameter("dropPosition"),p=i.getParameter("draggedControl"),r=i.getParameter("droppedControl"),u=p.getParent().getMetadata().getName()==="sap.m.IconTabBarSelectList";if(u){this._handleDragAndDropBetweenHeaderAndList(s,r,p);}else{f.handleDrop(this,s,p,r,false);}this._initItemNavigation();p.$().focus();};o.prototype._handleDragAndDropBetweenHeaderAndList=function(s,i,p){var r=this._getSelectList(),u=f.getDraggedDroppedItemsFromList(r.getAggregation("items"),p,i);if(!u){return;}f.handleDrop(this,s,p._tabFilter,i,false);f.handleDrop(r,s,p,u.oDroppedControlFromList,false);r._initItemNavigation();};o.prototype._moveTab=function(T,i){var r=f.moveItem.call(this,T,i);this._initItemNavigation();if(r){this._scrollIntoView(T,0);}};o.prototype.ondragrearranging=function(i){if(!this.getEnableTabReordering()){return;}var T=i.srcControl;this._moveTab(T,i.keyCode);T.$().focus();};o.prototype.onsaphomemodifiers=o.prototype.ondragrearranging;o.prototype.onsapendmodifiers=o.prototype.ondragrearranging;o.prototype.onsapincreasemodifiers=o.prototype.ondragrearranging;o.prototype.onsapdecreasemodifiers=o.prototype.ondragrearranging;return o;});
