/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','./RadioButtonGroup','./Label','sap/ui/core/library','sap/base/strings/capitalize','./RadioButtonRenderer'],function(l,C,E,R,L,c,a,b){"use strict";var T=c.TextAlign;var V=c.ValueState;var d=c.TextDirection;var e=C.extend("sap.m.RadioButton",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},selected:{type:"boolean",group:"Data",defaultValue:false},groupName:{type:"string",group:"Behavior",defaultValue:'sapMRbDefaultGroup'},text:{type:"string",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},useEntireWidth:{type:"boolean",group:"Appearance",defaultValue:false},activeHandling:{type:"boolean",group:"Appearance",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},editableParent:{type:"boolean",group:"Behavior",defaultValue:true,visibility:"hidden"},posinset:{type:"string",group:"Data",defaultValue:"",visibility:"hidden"},setsize:{type:"string",group:"Data",defaultValue:"",visibility:"hidden"}},events:{select:{parameters:{selected:{type:"boolean"}}}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},dnd:{draggable:true,droppable:false},designtime:"sap/m/designtime/RadioButton.designtime"}});E.call(e.prototype);e.prototype._groupNames={};var K={HOME:"first",END:"last",NEXT:"next",PREV:"prev"};e.prototype.ontap=function(o){if(!this.getEnabled()||!this.getEditable()){return;}var p=this.getParent();if(p instanceof R&&(!p.getEnabled()||!p.getEditable())){return;}o&&o.setMarked();this.applyFocusInfo();if(!this.getSelected()){this.setSelected(true);var t=this;setTimeout(function(){t.fireSelect({selected:true});},0);}};e.prototype.ontouchstart=function(o){o.originalEvent._sapui_handledByControl=true;if(this.getEnabled()&&this.getActiveHandling()){this.$().toggleClass("sapMRbBTouched",true);}};e.prototype.ontouchend=function(o){this.$().toggleClass("sapMRbBTouched",false);};e.prototype.onsapnext=function(o){this._keyboardHandler(K.NEXT,true);o.setMarked();return this;};e.prototype.onsapnextmodifiers=function(o){this._keyboardHandler(K.NEXT,!o.ctrlKey);o.setMarked();return this;};e.prototype.onsapprevious=function(o){this._keyboardHandler(K.PREV,true);o.setMarked();return this;};e.prototype.onsappreviousmodifiers=function(o){this._keyboardHandler(K.PREV,!o.ctrlKey);o.setMarked();return this;};e.prototype.onsaphome=function(o){this._keyboardHandler(K.HOME,true);o.setMarked();return this;};e.prototype.onsaphomemodifiers=function(o){this._keyboardHandler(K.HOME,!o.ctrlKey);o.setMarked();return this;};e.prototype.onsapend=function(o){this._keyboardHandler(K.END,true);o.setMarked();return this;};e.prototype.onsapendmodifiers=function(o){this._keyboardHandler(K.END,!o.ctrlKey);o.setMarked();return this;};e.prototype._keyboardHandler=function(p,s){if(this.getParent()instanceof R){return;}var n=this._getNextFocusItem(p);n.focus();if(s&&!n.getSelected()&&n.getEditable()&&n.getEnabled()){n.setSelected(true);setTimeout(function(){n.fireSelect({selected:true});},0);}};e.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{role:"radio",type:B.getText("ACC_CTR_TYPE_RADIO"),description:(this.getText()||"")+(this.getSelected()?(" "+B.getText("ACC_CTR_STATE_CHECKED")):""),enabled:this.getEnabled(),editable:this.getEditable()};};e.prototype.getFormDoNotAdjustWidth=function(){return this.getText()?false:true;};e.prototype._getNextFocusItem=function(n){var v=this._groupNames[this.getGroupName()].filter(function(r){return(r.getDomRef()&&r.getEnabled());});var B=v.indexOf(this),i=B,f=v.length;switch(n){case K.NEXT:i=B===f-1?B:B+1;break;case K.PREV:i=B===0?0:i-1;break;case K.HOME:i=0;break;case K.END:i=f-1;break;}return v[i]||this;};e.prototype.onsapselect=function(o){o.preventDefault();this.ontap(o);};e.prototype.setEnabled=function(f){this.setProperty("enabled",f,false);return this;};e.prototype.setSelected=function(s){var o,S=this.getSelected(),g=this.getGroupName(),f=this._groupNames[g],h=f&&f.length;this.setProperty("selected",s,true);this._changeGroupName(this.getGroupName());if(!!s&&g&&g!==""){for(var i=0;i<h;i++){o=f[i];if(o instanceof e&&o!==this&&o.getSelected()){o.fireSelect({selected:false});o.setSelected(false);}}}if((S!==!!s)&&this.getDomRef()){this.$().toggleClass("sapMRbSel",s);if(s){this.getDomRef().setAttribute("aria-checked","true");this.getDomRef("RB").checked=true;this.getDomRef("RB").setAttribute("checked","checked");}else{this.getDomRef().removeAttribute("aria-checked");this.getDomRef("RB").checked=false;this.getDomRef("RB").removeAttribute("checked");}}return this;};e.prototype.setText=function(t){this.setProperty("text",t,true);if(this._oLabel){this._oLabel.setText(this.getText());}else{this._createLabel("text",this.getText());}this.toggleStyleClass("sapMRbHasLabel",!!t);return this;};e.prototype._setWidth=function(u){if(!u){this._setLableWidth();}else{this._setLableWidth("auto");}};e.prototype._setLableWidth=function(w){w=w||this.getWidth();if(this._oLabel){this._oLabel.setWidth(w);}else{this._createLabel("width",w);}};e.prototype.setTextDirection=function(D){this.setProperty("textDirection",D,true);if(this._oLabel){this._oLabel.setTextDirection(this.getTextDirection());}else{this._createLabel("textDirection",this.getTextDirection());}return this;};e.prototype.setGroupName=function(g){this._changeGroupName(g,this.getGroupName());return this.setProperty("groupName",g,true);};e.prototype.onBeforeRendering=function(){this._setWidth(this.getUseEntireWidth());return this._changeGroupName(this.getGroupName());};e.prototype.onAfterRendering=function(){var g=this.getGroupName();this._setAriaPositionAttributes(g);};e.prototype.exit=function(){var g=this.getGroupName(),f=this._groupNames[g],G=f&&f.indexOf(this);this._iTabIndex=null;if(this._oLabel){this._oLabel.destroy();}if(G>=-1){f.splice(G,1);}};e.prototype._createLabel=function(p,v){this._oLabel=new L(this.getId()+"-label").addStyleClass("sapMRbBLabel").setParent(this,null,true);this._oLabel.setProperty(p,v,false);};e.prototype.setTabIndex=function(t){var f=this.getFocusDomRef();this._iTabIndex=t;if(f){f.setAttribute("tabindex",t);}return this;};e.prototype.setTextAlign=function(A){this.setProperty("textAlign",A,true);if(this._oLabel){this._oLabel.setTextAlign(this.getTextAlign());}else{this._createLabel("textAlign",this.getTextAlign());}return this;};e.prototype._changeGroupName=function(n,o){var N=this._groupNames[n],O=this._groupNames[o];if(O&&O.indexOf(this)!==-1){O.splice(O.indexOf(this),1);this._setAriaPositionAttributes(o);}if(!N){N=this._groupNames[n]=[];}if(N.indexOf(this)===-1){N.push(this);this._setAriaPositionAttributes(n);}};e.prototype._setAriaPositionAttributes=function(g){var G=this._groupNames[g],r=0,i;if(!G.length||!this.getDomRef()){return;}i=G.reduce(function(i,o){return o.getDomRef()?++i:i;},0);G.forEach(function(o){var f=o.getDomRef();if(f){f.setAttribute("aria-posinset",++r);f.setAttribute("aria-setsize",i);}});};["editableParent","posinset","setsize"].forEach(function(p){e.prototype["_set"+a(p)]=function(v){return this.setProperty(p,v,true);};});return e;});
