/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/base/DataType','sap/ui/base/ManagedObject','sap/ui/core/CustomData','./mvc/View','./mvc/EventHandlerResolver','./ExtensionPoint','./StashedControlSupport','sap/ui/base/SyncPromise','sap/base/Log','sap/base/util/ObjectPath','sap/base/assert','sap/base/security/encodeXML','sap/base/util/LoaderExtensions'],function(q,D,M,C,V,E,a,S,b,L,O,c,d,f){"use strict";function p(t,v,n,o){var B=M.bindingParser(v,o,true);if(B&&typeof B==="object"){return B;}var e=v=B||v;var T=D.getType(t);if(T){if(T instanceof D){e=T.parseValue(v,{context:o});if(!T.isValid(e)){L.error("Value '"+v+"' is not valid for type '"+T.getName()+"'.");}}}else{throw new Error("Property "+n+" has unknown type "+t);}return typeof e==="string"?M.bindingParser.escape(e):e;}function l(x){return x.localName||x.baseName||x.nodeName;}function u(e){if(e.isRejected()){throw e.getResult();}return e.getResult();}function g(A,e){function s(n,o,m){var j,v,k=[];for(j=n.firstChild;j;j=j.nextSibling){v=e(n,o,m,j);if(v){k.push(u(v));}}return b.resolve(k);}function i(n,o,m){var j,k=Promise.resolve(),r=[];for(j=n.firstChild;j;j=j.nextSibling){k=k.then(e.bind(null,n,o,m,j));r.push(k);}return Promise.all(r);}return A?i:s;}var X={};X.loadTemplate=function(t,e){var r=t.replace(/\./g,"/")+("."+(e||"view")+".xml");return f.loadResource(r).documentElement;};X.loadTemplatePromise=function(t,e){var r=t.replace(/\./g,"/")+("."+(e||"view")+".xml");return f.loadResource(r,{async:true}).then(function(R){return R.documentElement;});};X.parseViewAttributes=function(x,v,s){var A=v.getMetadata().getAllProperties();for(var i=0;i<x.attributes.length;i++){var e=x.attributes[i];if(e.name==='controllerName'){v._controllerName=e.value;}else if(e.name==='resourceBundleName'){v._resourceBundleName=e.value;}else if(e.name==='resourceBundleUrl'){v._resourceBundleUrl=e.value;}else if(e.name==='resourceBundleLocale'){v._resourceBundleLocale=e.value;}else if(e.name==='resourceBundleAlias'){v._resourceBundleAlias=e.value;}else if(e.name==='class'){v.addStyleClass(e.value);}else if(!s[e.name]&&A[e.name]){s[e.name]=p(A[e.name].type,e.value,e.name,v._oContainingView.oController);}}};X.enrichTemplateIds=function(x,v){X.enrichTemplateIdsPromise(x,v,false);return x;};X.enrichTemplateIdsPromise=function(x,v,A){return h(x,v,true,A).then(function(){return x;});};X.parseTemplate=function(x,v){return u(X.parseTemplatePromise(x,v,false));};X.parseTemplatePromise=function(x,v,A,P){return h(x,v,false,A,P);};function h(x,v,k,A,P){var r=[],m=b.resolve();A=A&&v._sProcessingMode==="sequential";L.debug("XML processing mode is "+(A?"sequential":"default"),"","XMLTemplateProcessor");var n=sap.ui.getCore().getConfiguration().getDesignMode();if(n){v._sapui_declarativeSourceInfo={xmlNode:x,xmlRootNode:v._oContainingView===v?x:v._oContainingView._sapui_declarativeSourceInfo.xmlRootNode};}var s=v.sViewName||v._sFragmentName;if(!s){var t=v;var o=0;while(++o<1000&&t&&t!==t._oContainingView){t=t._oContainingView;}s=t.sViewName;}if(v.isSubView()){F(x,true);}else{if(x.localName==="View"&&x.namespaceURI!=="sap.ui.core.mvc"){L.warning("XMLView root node must have the 'sap.ui.core.mvc' namespace, not '"+x.namespaceURI+"'"+(s?" (View name: "+s+")":""));}G(x);}var i=0;function w(){for(;i<r.length;i++){var e=r[i];if(e&&typeof e.then==='function'){return e.then(y).then(w);}}return r;}function y(e){var j=[i,1].concat(e);Array.prototype.splice.apply(r,j);}return m.then(w);function z(e){return e;}function B(e){return v._oContainingView.createId(e);}function F(x,R,e){if(x.nodeType===1){var j=l(x);if(x.namespaceURI==="http://www.w3.org/1999/xhtml"||x.namespaceURI==="http://www.w3.org/2000/svg"){r.push("<"+j+" ");var T=false;for(var i=0;i<x.attributes.length;i++){var U=x.attributes[i];var W=U.value;if(U.name==="id"){T=true;W=N(v,x);}r.push(U.name+"=\""+d(W)+"\" ");}if(R===true){r.push("data-sap-ui-preserve"+"=\""+v.getId()+"\" ");if(!T){r.push("id"+"=\""+v.getId()+"\" ");}}r.push(">");var Y=x;if(window.HTMLTemplateElement&&x instanceof HTMLTemplateElement&&x.content instanceof DocumentFragment){Y=x.content;}G(Y);r.push("</"+j+">");}else if(j==="FragmentDefinition"&&x.namespaceURI==="sap.ui.core"){G(x,false,true);}else{m=m.then(function(){return J(x).then(function(_){for(var i=0;i<_.length;i++){var a1=_[i];if(v.getMetadata().hasAggregation("content")){v.addAggregation("content",a1);}else if(v.getMetadata().hasAssociation(("content"))){v.addAssociation("content",a1);}}return _;});});r.push(m);}}else if(x.nodeType===3&&!e){var Z=x.textContent||x.text,$=l(x.parentNode);if(Z){if($!="style"){Z=d(Z);}r.push(Z);}}}function G(x,R,e){var j=x.childNodes;for(var i=0;i<j.length;i++){F(j[i],R,e);}}function H(e,j){var R;var T=sap.ui.getCore().getLoadedLibraries();q.each(T,function(Z,$){if(e===$.namespace||e===$.name){R=$.name+"."+(($.tagNames&&$.tagNames[j])||j);}});R=R||e+"."+j;function U(Y){if(!Y){L.error("Control '"+R+"' did not return a class definition from sap.ui.define.","","XMLTemplateProcessor");Y=O.get(R);}if(!Y){L.error("Can't find object class '"+R+"' for XML-view","","XMLTemplateProcessor");}return Y;}var W=R.replace(/\./g,"/");var Y=sap.ui.require(W);if(!Y){if(A){return new Promise(function(Z){sap.ui.require([W],function(Y){Y=U(Y);Z(Y);});});}else{Y=sap.ui.requireSync(W);Y=U(Y);}}return Y;}function I(e){if(e.namespaceURI==="http://www.w3.org/1999/xhtml"||e.namespaceURI==="http://www.w3.org/2000/svg"){var j=e.attributes['id']?e.attributes['id'].textContent||e.attributes['id'].text:null;if(k){return X.enrichTemplateIdsPromise(e,v,A).then(function(){return[];});}else{var R=function(U){var W={id:j?N(v,e,j):undefined,xmlNode:e,containingView:v._oContainingView,processingMode:v._sProcessingMode};if(v.fnScopedRunWithOwner){return v.fnScopedRunWithOwner(function(){return new U(W);});}return new U(W);};if(A){return new Promise(function(U,W){sap.ui.require(["sap/ui/core/mvc/XMLView"],function(T){U([R(T)]);});});}else{var T=sap.ui.requireSync("sap/ui/core/mvc/XMLView");return b.resolve([R(T)]);}}}else{return J(e);}}function J(e){if(l(e)==="ExtensionPoint"&&e.namespaceURI==="sap.ui.core"){if(k){return b.resolve([]);}else{var j=v instanceof V?v._oContainingView:v;var R=a._factory.bind(null,j,e.getAttribute("name"),function(){var U=b.resolve();var W=[];var Y=e.childNodes;for(var i=0;i<Y.length;i++){var Z=Y[i];if(Z.nodeType===1){U=U.then(I.bind(null,Z));W.push(U);}}return b.all(W).then(function($){var _=[];$.forEach(function(a1){_=_.concat(a1);});return _;});});return b.resolve(v.fnScopedRunWithOwner?v.fnScopedRunWithOwner(R):R());}}else{var T=H(e.namespaceURI,l(e));if(T&&typeof T.then==='function'){return T.then(function(U){return K(e,U);});}else{return K(e,T);}}}function K(R,T){var U=R.namespaceURI,W={},Y="",Z=[],$=null,_=null;if(!T){return b.resolve([]);}var a1=T.getMetadata();var b1=a1.getAllSettings();if(!k){for(var i=0;i<R.attributes.length;i++){var c1=R.attributes[i],d1=c1.name,e1=b1[d1],f1=c1.value;if(d1==="id"){W[d1]=N(v,R,f1);}else if(d1==="class"){Y+=f1;}else if(d1==="viewName"){W[d1]=f1;}else if(d1==="fragmentName"){W[d1]=f1;W['containingView']=v._oContainingView;}else if((d1==="binding"&&!e1)||d1==='objectBindings'){var g1=M.bindingParser(f1,v._oContainingView.oController);if(g1){W.objectBindings=W.objectBindings||{};W.objectBindings[g1.model||undefined]=g1;}}else if(d1==='metadataContexts'){var h1=null;try{h1=X._calculatedModelMapping(f1,v._oContainingView.oController,true);}catch(e){L.error(v+":"+e.message);}if(h1){W.metadataContexts=h1;if(X._preprocessMetadataContexts){X._preprocessMetadataContexts(T.getMetadata().getName(),W,v._oContainingView.oController);}}}else if(d1.indexOf(":")>-1){if(c1.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"){var i1=l(c1);Z.push(new C({key:i1,value:p("any",f1,i1,v._oContainingView.oController)}));}else if(c1.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.support.Support.info/1"){_=f1;}else if(c1.namespaceURI&&c1.namespaceURI.indexOf("http://schemas.sap.com/sapui5/preprocessorextension/")===0){L.debug(v+": XMLView parser ignored preprocessor attribute '"+d1+"' (value: '"+f1+"')");}else if(d1.indexOf("xmlns:")!==0){if(!$){$={};}if(!$.hasOwnProperty(c1.namespaceURI)){$[c1.namespaceURI]={};}$[c1.namespaceURI][l(c1)]=c1.nodeValue;L.debug(v+": XMLView parser encountered unknown attribute '"+d1+"' (value: '"+f1+"') with unknown namespace, stored as sap-ui-custom-settings of customData");}}else if(e1&&e1._iKind===0){W[d1]=p(e1.type,f1,d1,v._oContainingView.oController);}else if(e1&&e1._iKind===1&&e1.altTypes){W[d1]=p(e1.altTypes[0],f1,d1,v._oContainingView.oController);}else if(e1&&e1._iKind===2){var g1=M.bindingParser(f1,v._oContainingView.oController);if(g1){W[d1]=g1;}else{L.error(v+": aggregations with cardinality 0..n only allow binding paths as attribute value (wrong value: "+d1+"='"+f1+"')");}}else if(e1&&e1._iKind===3){W[d1]=B(f1);}else if(e1&&e1._iKind===4){W[d1]=f1.split(/[\s,]+/g).filter(z).map(B);}else if(e1&&e1._iKind===5){var j1=[];E.parse(f1).forEach(function(j){var o1=E.resolveEventHandler(j,v._oContainingView.oController);if(o1){j1.push(o1);}else{L.warning(v+": event handler function \""+j+"\" is not a function or does not exist in the controller.");}});if(j1.length){W[d1]=j1;}}else if(e1&&e1._iKind===-1){if(V.prototype.isPrototypeOf(T.prototype)&&d1=="async"){W[d1]=p(e1.type,f1,d1,v._oContainingView.oController);}else{L.warning(v+": setting '"+d1+"' for class "+a1.getName()+" (value:'"+f1+"') is not supported");}}else{c(d1==='xmlns',v+": encountered unknown setting '"+d1+"' for class "+a1.getName()+" (value:'"+f1+"')");if(X._supportInfo){X._supportInfo({context:R,env:{caller:"createRegularControls",error:true,info:"unknown setting '"+d1+"' for class "+a1.getName()}});}}}if($){Z.push(new C({key:"sap-ui-custom-settings",value:$}));}if(Z.length>0){W.customData=Z;}}var k1=g(A,l1);function l1(R,m1,n1,o1,p1){var q1;if(o1.nodeType===1){if(o1.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1"){W[l(o1)]=o1.querySelector("*");return;}q1=o1.namespaceURI===U&&n1&&n1[l(o1)];if(q1){return k1(o1,q1);}else if(m1){if(!p1&&o1.getAttribute("stashed")==="true"&&!k){S.createStashedControl(N(v,o1),{sParentId:W["id"],sParentAggregationName:m1.name,fnCreate:function(){var j=A;A=false;try{return u(l1(R,m1,n1,o1,true));}finally{A=j;}}});return;}return I(o1).then(function(r1){for(var j=0;j<r1.length;j++){var s1=r1[j];var t1=m1.name;if(m1.multiple){if(!W[t1]){W[t1]=[];}if(typeof W[t1].path==="string"){c(!W[t1].template,"list bindings support only a single template object");W[t1].template=s1;}else{W[t1].push(s1);}}else{c(!W[t1],"multiple aggregates defined for aggregation with cardinality 0..1");W[t1]=s1;}}return r1;});}else if(l(R)!=="FragmentDefinition"||R.namespaceURI!=="sap.ui.core"){throw new Error("Cannot add direct child without default aggregation defined for control "+a1.getElementName());}}else if(o1.nodeType===3){if(q.trim(o1.textContent||o1.text)){throw new Error("Cannot add text nodes as direct child of an aggregation. For adding text to an aggregation, a surrounding html tag is needed: "+q.trim(o1.textContent||o1.text));}}}var m1=a1.getDefaultAggregation();var n1=a1.getAllAggregations();return k1(R,m1,n1).then(function(){var j;if(k&&R.hasAttribute("id")){Q(v,R);}else if(!k){if(V.prototype.isPrototypeOf(T.prototype)&&typeof T._sType==="string"){var o1=function(){if(T.getMetadata().isA("sap.ui.core.mvc.XMLView")&&v._sProcessingMode==="sequential"){W.processingMode="sequential";}return V._legacyCreate(W,undefined,T._sType);};if(v.fnScopedRunWithOwner){j=v.fnScopedRunWithOwner(o1);}else{j=o1();}}else{var p1=function(){if(T.getMetadata().isA("sap.ui.core.Fragment")&&R.getAttribute("type")!=="JS"&&v._sProcessingMode==="sequential"){W.processingMode="sequential";}if(v.fnScopedRunWithOwner){return v.fnScopedRunWithOwner(function(){return new T(W);});}else{return new T(W);}};if(P&&P.fnRunWithPreprocessor){j=P.fnRunWithPreprocessor(p1);}else{j=p1();}}if(Y&&j.addStyleClass){j.addStyleClass(Y);}}if(!j){j=[];}else if(!Array.isArray(j)){j=[j];}if(X._supportInfo&&j){for(var i=0,q1=j.length;i<q1;i++){var r1=j[i];if(r1&&r1.getId()){var s1=X._supportInfo({context:R,env:{caller:"createRegularControls",nodeid:R.getAttribute("id"),controlid:r1.getId()}}),t1=_?_+",":"";t1+=s1;X._supportInfo.addSupportInfo(r1.getId(),t1);}}}if(n){j.forEach(function(r1){if(a1.getCompositeAggregationName){var u1=R.getElementsByTagName(r1.getMetadata().getCompositeAggregationName());for(var i=0;i<u1.length;i++){R.removeChild(u1[0]);}}r1._sapui_declarativeSourceInfo={xmlNode:R,xmlRootNode:v._sapui_declarativeSourceInfo.xmlRootNode,fragmentName:a1.getName()==='sap.ui.core.Fragment'?W['fragmentName']:null};});}return j;});}function N(v,x,e){if(x.getAttributeNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1","id")){return x.getAttribute("id");}else{return B(e?e:x.getAttribute("id"));}}function Q(v,x){x.setAttribute("id",B(x.getAttribute("id")));x.setAttributeNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1","id",true);}}X._preprocessMetadataContexts=null;X._calculatedModelMapping=function(B,o,A){var e,m={},j=M.bindingParser(B,o);function k(F){if(F.length%2===0){throw new Error("The last entry is no binding");}for(var i=1;i<=F.length;i=i+2){if(typeof F[i-1]=='string'){throw new Error("Binding expected not a string");}if(F[i]){if((typeof F[i]!='string')||(F[i]!=",")){throw new Error("Missing delimiter ','");}}}}if(j){if(!j.formatter){e=j;j={parts:[e]};}else{k(j.formatter.textFragments);}for(var i=0;i<j.parts.length;i++){e=j.parts[i];m[e.model]=m[e.model]||(A?[]:null);if(Array.isArray(m[e.model])){m[e.model].push(e);}else{m[e.model]=e;}}}return m;};return X;},true);
