/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/base/util/deepEqual","sap/m/library","sap/m/Popover","sap/m/VBox","sap/m/HBox","sap/m/Button","sap/m/FlexItemData","sap/ui/dt/OverlayRegistry","sap/ui/dt/DOMUtil"],function(q,M,D,m,P,V,H,B,F,O,a){"use strict";var b=m.PlacementType;var C=M.extend("sap.ui.dt.ContextMenuControl",{metadata:{properties:{maxButtonsDisplayed:{type:"int",defaultValue:4},buttons:{type:"object[]",defaultValue:[]},styleClass:{type:"string",defaultValue:""}},events:{Opened:{},Closed:{},OverflowButtonPressed:{}}},init:function(){var p=this.getId()+"-popover";var o=new P(p,{showHeader:false,verticalScrolling:false,placement:"Top",showArrow:true,horizontalScrolling:false,content:new H(p+"ContentBox",{renderType:"Bare"})});o._getAnimationDuration=function(){return 0;};o.attachBrowserEvent("keydown",this._changeFocusOnKeyStroke,this);o.oPopup.attachClosed(this._popupClosed,this);this._oPopover=o;o.addStyleClass("sapUiDtContextMenu");var s=this.getId()+"-popoverExp";var c=new P(s,{showHeader:false,showArrow:false,verticalScrolling:false,horizontalScrolling:false,content:new V(s+"ContentBox",{renderType:"Bare"})});c._getAnimationDuration=function(){return 0;};c.attachBrowserEvent("keydown",this._changeFocusOnKeyStroke,this);c.oPopup.attachClosed(this._popupClosed,this);this._oExpandedPopover=c;c.addStyleClass("sapUiDtContextMenu");o.attachBrowserEvent("contextmenu",this._onContextMenu,this);c.attachBrowserEvent("contextmenu",this._onContextMenu,this);this.bOnInit=true;this._oLastSourceOverlay=this._oLastSourceClientRects=this._oLastPosition=null;},exit:function(){this.getPopover(true).oPopup.detachClosed(this._popupClosed,this);this.getPopover(false).oPopup.detachClosed(this._popupClosed,this);this.getPopover(true).detachBrowserEvent("contextmenu",this._onContextMenu,this);this.getPopover(false).detachBrowserEvent("contextmenu",this._onContextMenu,this);this.getPopover(true).destroy();this.getPopover(false).destroy();},show:function(s,c,o){if(this._bUseExpPop===undefined){this._bUseExpPop=!!c;}this._bCompactMode=q(s.getDomRef()).closest(".sapUiSizeCompact").length>0;this._bOpenAsContextMenu=c;this._oContextMenuPosition=o;this.getPopover(true).addStyleClass(this.getStyleClass());this.getPopover(false).addStyleClass(this.getStyleClass());var d=this.getButtons();this._oTarget=s;if(!this._bOpenAsContextMenu){this._setButtonsForContextMenu(d,s);}else{this._makeAllButtonsVisible(d);}if(this.bOnInit||!this.getPopover().isOpen()){this.finalizeOpening();this.bOnInit=false;}},finalizeOpening:function(){if(this._bOpenAsContextMenu&&this._oContextMenuPosition.x===null&&this._oContextMenuPosition.y===null){this._bOpenAsContextMenu=false;}this.getPopover().attachAfterOpen(this._handleAfterOpen,this);this.getPopover().attachBeforeClose(this._handleBeforeClose,this);this.getPopover().attachAfterClose(this._handleAfterClose,this);this._oTarget=this._placeContextMenu(this._oTarget,this._bOpenAsContextMenu);this.getPopover().setVisible(true);this.bOpen=true;this.bOpenNew=false;},_setButtonsForContextMenu:function(c){var i=this._getNumberOfEnabledButtons(c);if(i!==0){this._hideDisabledButtons(c);}this._iButtonsVisible=this._hideButtonsInOverflow(c);if(this._iButtonsVisible===this.getMaxButtonsDisplayed()&&this._iButtonsVisible!==c.length){this._replaceLastVisibleButtonWithOverflowButton(c);}else if(i<c.length-1&&i!==0){this.addOverflowButton();}i=null;},_makeAllButtonsVisible:function(c){this._iFirstVisibleButtonIndex=0;c.forEach(function(o){o.setVisible(true);o._bInOverflow=true;});},_getNumberOfEnabledButtons:function(c){var d=0;for(var i=0;i<c.length;i++){if(c[i].getEnabled()){d++;if(!this._iFirstVisibleButtonIndex){this._iFirstVisibleButtonIndex=i;}}}return d;},_hideDisabledButtons:function(c){var v=0;c.forEach(function(o){o.setVisible(o.getEnabled());if(o.getEnabled()){v++;}});return v;},_hideButtonsInOverflow:function(c){var v=0;for(var i=0;i<c.length;i++){if(v<this.getMaxButtonsDisplayed()&&c[i].getVisible()){v++;}else{c[i].setVisible(false);}}return v;},_replaceLastVisibleButtonWithOverflowButton:function(c){for(var i=c.length-1;i>=0;i--){if(c[i].getVisible()){c[i].setVisible(false);this.addOverflowButton();return;}}},_placeContextMenu:function(s,c){var o=(s.getId&&s.getId())||s.getAttribute("overlay");var f="contextMenuFakeDiv";var d=this._getOverlayDimensions(o);var v=this._getViewportDimensions();var i=d.top-50>v.top?0:v.top-(d.top-50);q("#"+f).remove();q("#"+o).append("<div id=\""+f+"\" overlay=\""+o+"\" style = \"position: absolute; top: "+i+"px; left: 0px;\" />");o=null;var e=document.getElementById(f);this.getPopover().setContentWidth(undefined);this.getPopover().setContentHeight(undefined);this.getPopover().openBy(e);var p=this._getPopoverDimensions(!c);if(p.height>=v.height*2/3){this.getPopover().setVerticalScrolling(true);p.height=(v.height*2/3).toFixed(0);this.getPopover().setContentHeight(p.height+"px");}else{this.getPopover().setVerticalScrolling(false);this.getPopover().setContentHeight(undefined);}if(p.width>400){p.width=400;this.getPopover().setContentWidth("400px");}else{this.getPopover().setContentWidth(undefined);}var I=(this._oLastSourceOverlay?this._oLastSourceOverlay===s:false);var g=(this._oLastSourceClientRects?D(JSON.parse(JSON.stringify(this._oLastSourceClientRects)),JSON.parse(JSON.stringify(s.getDomRef().getClientRects()))):false);if(this._oContextMenuPosition.x==="not set"&&this._oContextMenuPosition.y==="not set"&&I&&g){this._oContextMenuPosition.x=this._oLastPosition.x;this._oContextMenuPosition.y=this._oLastPosition.y;}else{this._oContextMenuPosition.x=this._oContextMenuPosition.x||parseInt(d.left+20);this._oContextMenuPosition.y=this._oContextMenuPosition.y||parseInt(d.top+20);}var h={};if(c){h=this._placeAsExpandedContextMenu(this._oContextMenuPosition,p,v);}else{h=this._placeAsCompactContextMenu(this._oContextMenuPosition,p,v);}h.top-=d.top;h.left-=d.left;h.top=(h.top<0)?0:h.top;h.left=(h.left<0)?0:h.left;e.style.top=h.top.toFixed(0)+"px";e.style.left=h.left.toFixed(0)+"px";return e;},_placeAsExpandedContextMenu:function(c,p,v){this.getPopover().setShowArrow(false);var o={};if(v.height-10-c.y>=p.height){o.top=c.y;this.getPopover().setPlacement("Bottom");}else if(c.y>=p.height){o.top=c.y;this.getPopover().setPlacement("Top");}else{o.top=v.height-p.height;this.getPopover().setPlacement("Bottom");}if(v.width-c.x>=p.width){o.left=c.x;}else if(c.x>=p.width){o.left=c.x-p.width/2;}else{o.left=v.width-p.width;}return o;},_placeAsCompactContextMenu:function(c,p,v){this.getPopover().setShowArrow(true);var o={};this.getPopover().setPlacement(b.PreferredTopOrFlip);var i=p.width/this._iButtonsVisible;var f=sap.ui.getCore().getConfiguration().getRTL()?-1:1;o.left=c.x+(f*((this._iButtonsVisible-1)*i)/2+(this._getBaseFontSize()*1/2));o.top=c.y-(this._getBaseFontSize()*1/2);o.left=(o.left<32)?32:o.left;o.top=(o.top-v.top<0)?v.top:o.top;if(v.width-o.left<32){o.left=v.width-32;this.getPopover().addStyleClass("sapUiDtContextMenuRightArrow");}else{this.getPopover().removeStyleClass("sapUiDtContextMenuRightArrow");}var d=this._bCompactMode?0:15;if(o.top<(100+d)){this.getPopover().setPlacement(b.Bottom);o.top+=16;}return o;},_getPopoverDimensions:function(w){var p={};var c=this._bCompactMode;var A=this._getArrowHeight(c);var i=this._getBaseFontSize();this._iFirstVisibleButtonIndex=null;p.height=parseInt(q("#"+this.getPopover().getId()).css("height"))||40;p.width=parseInt(q("#"+this.getPopover().getId()).css("width"))||80;if(w){var d=i*A;if(d){p.height+=d;p.width+=d;}}return p;},_getArrowHeight:function(c){if(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge){return c?0.5:0.5;}return c?0.5625:0.5625;},_getBaseFontSize:function(){return parseInt(q(document.documentElement).css("fontSize"));},_getOverlayDimensions:function(o){var c=q("#"+o).rect();c.right=c.left+c.width;c.bottom=c.top+c.height;return c;},_getViewportDimensions:function(){var v={};v.width=window.innerWidth;v.height=window.innerHeight;v.top=parseInt(q(".type_standalone").css("height"))||0;v.bottom=v.top+v.height;return v;},_getIcon:function(i){if(i===undefined||i===null||typeof i!=="string"){return"sap-icon://incident";}if(i==="blank"){return" ";}return i;},addOverflowButton:function(){var o="OVERFLOW_BUTTON",c={icon:"sap-icon://overflow",type:"Transparent",enabled:true,press:this._onOverflowPress.bind(this),layoutData:new F({})};return this._addButton(o,c);},addMenuButton:function(o,c,e){function h(){this.bOpen=false;this.bOpenNew=false;c(this);}var t=typeof o.text==="function"?o.text(e[0]):o.text;var E=typeof o.enabled==="function"?o.enabled(e):o.enabled;var d={icon:this._getIcon(o.icon),text:t,tooltip:t,type:"Transparent",enabled:E,press:h,layoutData:new F({})};return this._addButton(o.id,d);},_addButton:function(s,o){this.setProperty("buttons",this.getProperty("buttons").concat(o));var c={id:s,key:s};var e=new B(o);e.data(c);delete o.text;var d=new B(o);d.data(c);this.getFlexbox(true).addItem(e);this.getFlexbox(false).addItem(d);return this;},close:function(e){if(this.getPopover()){if(e){this.getPopover(true).close();this.getPopover(false).close();}if(this.getProperty("buttons").length>this.getProperty("maxButtonsDisplayed")){this.setProperty("buttons",this.getProperty("buttons").splice(0,this.getProperty("buttons").length-1));this.getFlexbox().removeItem(this.getButtons().length-1);}}return this;},removeButton:function(i){this.setProperty("buttons",this.getProperty("buttons").splice(i,1));this.getFlexbox(true).removeItem(i);return this.getFlexbox(false).removeItem(i);},removeAllButtons:function(){this.setProperty("buttons",[]);this.getFlexbox(true).removeAllItems();return this.getFlexbox(false).removeAllItems();},getButtons:function(){return this.getFlexbox().getItems();},insertButton:function(o,i){this.getFlexbox().insertItem(o,i);return this;},setButtons:function(_,c,e){this.removeAllButtons();_.forEach(function(o){this.addMenuButton(o,c,e);}.bind(this));},setMaxButtonsDisplayed:function(i){if(i<2){throw Error("maxButtonsDisplayed can't be less than two!");}this.setProperty("maxButtonsDisplayed",i);},getPopover:function(e){if(e===undefined){if(this._bUseExpPop){return this._oExpandedPopover;}return this._oPopover;}else if(e){return this._oExpandedPopover;}return this._oPopover;},getFlexbox:function(e){return this.getPopover(e).getContent()[0];},setOpenNew:function(v){this.bOpenNew=v;},_onOverflowPress:function(e){this.fireOverflowButtonPressed({oButton:e.oSource});},_popupClosed:function(){if(this.getPopover()){this.fireClosed();if(this.bOpenNew){this.bOpenNew=false;this.finalizeOpening();return;}}this.bOpen=false;},_setFocusOnButton:function(o){if(o.getEnabled()&&o.getVisible()){o.focus();return true;}},_changeFocusOnKeyStroke:function(e){if(document.activeElement){var i=document.activeElement.id;switch(e.key){case"ArrowRight":this._changeFocusOnButtons(i);break;case"ArrowLeft":this._changeFocusOnButtons(i,true);break;case"ArrowUp":this._changeFocusOnButtons(i,true);break;case"ArrowDown":this._changeFocusOnButtons(i);break;default:break;}}},_changeFocusOnButtons:function(i,p){this.getButtons().some(function(o,I,A){if(i===o.getId()){if(p){this._setFocusOnPreviousButton(A,I);}else{this._setFocusOnNextButton(A,I);}return true;}}.bind(this));},_setFocusOnNextButton:function(c,i){for(var d=i+1;d<c.length;d++){if(this._setFocusOnButton(c[d])){return;}}for(var e=0;e<i;e++){if(this._setFocusOnButton(c[e])){return;}}},_setFocusOnPreviousButton:function(c,i){for(var d=i-1;d>=0;d--){if(this._setFocusOnButton(c[d])){return;}}for(var e=c.length-1;e>=i;e--){if(this._setFocusOnButton(c[e])){return;}}},_onContextMenu:function(e){if(e.preventDefault){e.preventDefault();}},_handleAfterOpen:function(){this.getPopover().detachAfterOpen(this._handleAfterOpen,this);this.getPopover().addStyleClass("sapUiDtContextMenuVisible");this.fireOpened();},_handleBeforeClose:function(){this.getPopover().detachBeforeClose(this._handleBeforeClose,this);this.getPopover().removeStyleClass("sapUiDtContextMenuVisible");document.activeElement.blur();},_handleAfterClose:function(){if(document.activeElement.localName!=="body"){return;}this.getPopover().detachAfterClose(this._handleAfterClose,this);var n=document.getElementById(this._oTarget.getAttribute("overlay"));if(n){a.focusWithoutScrolling(n);this._oLastSourceOverlay=O.getOverlay(n.id);this._oLastSourceClientRects=this._oLastSourceOverlay.getDomRef().getClientRects();}else{this._oLastSourceClientRects=null;}this._oLastPosition={x:this._oContextMenuPosition.x,y:this._oContextMenuPosition.y};},setStyleClass:function(s){this.setProperty("styleClass",s);}});return C;},true);
