/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject"],function(M){"use strict";var P=M.extend("sap.ui.dt.Plugin",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{designTime:{type:"object",multiple:false},busy:{type:"boolean",defaultValue:false}},events:{processingStatusChange:{parameters:{processing:{type:"boolean"}}}}}});P.prototype._bProcessingCounter=0;P.prototype.init=function(){};P.prototype.exit=function(){this.setDesignTime(null);};P.prototype.setDesignTime=function(d){var o=this.getDesignTime();if(o){this._deregisterOverlays(o);}this.setProperty("designTime",d);if(d){this._registerOverlays(d);}return this;};P.prototype._registerOverlays=function(d){if(this.registerElementOverlay||this.registerAggregationOverlay){var e=d.getElementOverlays();this.setProcessingStatus(true);e.forEach(this.callElementOverlayRegistrationMethods.bind(this));this.setProcessingStatus(false);}};P.prototype._deregisterOverlays=function(d){if(this.deregisterElementOverlay||this.deregisterAggregationOverlay){var o=d.getElementOverlays();o.forEach(this._callElementOverlayDeregestrationMethods.bind(this));}};P.prototype.callAggregationOverlayRegistrationMethods=function(e){if(this.registerAggregationOverlay){var a=e.getAggregationOverlays();a.forEach(this.registerAggregationOverlay.bind(this));}};P.prototype.callElementOverlayRegistrationMethods=function(e){if(this.registerElementOverlay){this.registerElementOverlay(e);}this.callAggregationOverlayRegistrationMethods(e);};P.prototype._callElementOverlayDeregestrationMethods=function(e){if(this.deregisterElementOverlay){this.deregisterElementOverlay(e);}if(this.deregisterAggregationOverlay){var a=e.getAggregationOverlays();a.forEach(this.deregisterAggregationOverlay.bind(this));}};P.prototype._onElementOverlayCreated=function(e){var o=e.getParameter("elementOverlay");this.callElementOverlayRegistrationMethods(o);};P.prototype.getMenuItems=function(){return[];};P.prototype.getActionName=function(){};P.prototype.isBusy=P.prototype.getBusy;P.prototype.setProcessingStatus=function(p){this._bProcessingCounter=p?this._bProcessingCounter+1:this._bProcessingCounter-1;if((p===true&&this._bProcessingCounter===1)||(p===false&&this._bProcessingCounter===0)){this.fireProcessingStatusChange({processing:p});}};P.prototype.getAction=function(o){return o.getDesignTimeMetadata()?o.getDesignTimeMetadata().getAction(this.getActionName(),o.getElement()):null;};P.prototype.getSelectedOverlays=function(){return this.getDesignTime().getSelectionManager().get();};P.prototype.getActionText=function(o,a,p){var n=a.name;var e=o.getElement();if(n){if(typeof n==="function"){return n.call(null,e);}return o.getDesignTimeMetadata()?o.getDesignTimeMetadata().getLibraryText(e,n):"";}return sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText(p);};P.prototype.isAvailable=function(){return false;};P.prototype.handler=function(){};P.prototype.isEnabled=function(){return false;};P.prototype._getMenuItems=function(e,p){var E=e[0];var a=this.getAction(E);if(!a||!this.isAvailable(e)){return[];}return[{id:p.pluginId,text:this.getActionText(E,a,p.pluginId),handler:this.handler.bind(this),enabled:this.isEnabled.bind(this),rank:p.rank,icon:p.icon,group:p.group}];};return P;},true);
