//@ui5-bundle sap/ui/dt/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/dt/ContextMenuControl',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/base/util/deepEqual","sap/m/library","sap/m/Popover","sap/m/VBox","sap/m/HBox","sap/m/Button","sap/m/FlexItemData","sap/ui/dt/OverlayRegistry","sap/ui/dt/DOMUtil"],function(q,M,D,m,P,V,H,B,F,O,a){"use strict";var b=m.PlacementType;
var C=M.extend("sap.ui.dt.ContextMenuControl",{
metadata:{properties:{maxButtonsDisplayed:{type:"int",defaultValue:4},buttons:{type:"object[]",defaultValue:[]},styleClass:{type:"string",defaultValue:""}},events:{Opened:{},Closed:{},OverflowButtonPressed:{}}},
init:function(){var p=this.getId()+"-popover";var o=new P(p,{showHeader:false,verticalScrolling:false,placement:"Top",showArrow:true,horizontalScrolling:false,content:new H(p+"ContentBox",{renderType:"Bare"})});o._getAnimationDuration=function(){return 0;};o.attachBrowserEvent("keydown",this._changeFocusOnKeyStroke,this);o.oPopup.attachClosed(this._popupClosed,this);this._oPopover=o;o.addStyleClass("sapUiDtContextMenu");var s=this.getId()+"-popoverExp";var c=new P(s,{showHeader:false,showArrow:false,verticalScrolling:false,horizontalScrolling:false,content:new V(s+"ContentBox",{renderType:"Bare"})});c._getAnimationDuration=function(){return 0;};c.attachBrowserEvent("keydown",this._changeFocusOnKeyStroke,this);c.oPopup.attachClosed(this._popupClosed,this);this._oExpandedPopover=c;c.addStyleClass("sapUiDtContextMenu");o.attachBrowserEvent("contextmenu",this._onContextMenu,this);c.attachBrowserEvent("contextmenu",this._onContextMenu,this);this.bOnInit=true;this._oLastSourceOverlay=this._oLastSourceClientRects=this._oLastPosition=null;},
exit:function(){this.getPopover(true).oPopup.detachClosed(this._popupClosed,this);this.getPopover(false).oPopup.detachClosed(this._popupClosed,this);this.getPopover(true).detachBrowserEvent("contextmenu",this._onContextMenu,this);this.getPopover(false).detachBrowserEvent("contextmenu",this._onContextMenu,this);this.getPopover(true).destroy();this.getPopover(false).destroy();},
show:function(s,c,o){if(this._bUseExpPop===undefined){this._bUseExpPop=!!c;}this._bCompactMode=q(s.getDomRef()).closest(".sapUiSizeCompact").length>0;this._bOpenAsContextMenu=c;this._oContextMenuPosition=o;this.getPopover(true).addStyleClass(this.getStyleClass());this.getPopover(false).addStyleClass(this.getStyleClass());var d=this.getButtons();this._oTarget=s;if(!this._bOpenAsContextMenu){this._setButtonsForContextMenu(d,s);}else{this._makeAllButtonsVisible(d);}if(this.bOnInit||!this.getPopover().isOpen()){this.finalizeOpening();this.bOnInit=false;}},
finalizeOpening:function(){if(this._bOpenAsContextMenu&&this._oContextMenuPosition.x===null&&this._oContextMenuPosition.y===null){this._bOpenAsContextMenu=false;}this.getPopover().attachAfterOpen(this._handleAfterOpen,this);this.getPopover().attachBeforeClose(this._handleBeforeClose,this);this.getPopover().attachAfterClose(this._handleAfterClose,this);this._oTarget=this._placeContextMenu(this._oTarget,this._bOpenAsContextMenu);this.getPopover().setVisible(true);this.bOpen=true;this.bOpenNew=false;},
_setButtonsForContextMenu:function(c){var i=this._getNumberOfEnabledButtons(c);if(i!==0){this._hideDisabledButtons(c);}this._iButtonsVisible=this._hideButtonsInOverflow(c);if(this._iButtonsVisible===this.getMaxButtonsDisplayed()&&this._iButtonsVisible!==c.length){this._replaceLastVisibleButtonWithOverflowButton(c);}else if(i<c.length-1&&i!==0){this.addOverflowButton();}i=null;},
_makeAllButtonsVisible:function(c){this._iFirstVisibleButtonIndex=0;c.forEach(function(o){o.setVisible(true);o._bInOverflow=true;});},
_getNumberOfEnabledButtons:function(c){var d=0;for(var i=0;i<c.length;i++){if(c[i].getEnabled()){d++;if(!this._iFirstVisibleButtonIndex){this._iFirstVisibleButtonIndex=i;}}}return d;},
_hideDisabledButtons:function(c){var v=0;c.forEach(function(o){o.setVisible(o.getEnabled());if(o.getEnabled()){v++;}});return v;},
_hideButtonsInOverflow:function(c){var v=0;for(var i=0;i<c.length;i++){if(v<this.getMaxButtonsDisplayed()&&c[i].getVisible()){v++;}else{c[i].setVisible(false);}}return v;},
_replaceLastVisibleButtonWithOverflowButton:function(c){for(var i=c.length-1;i>=0;i--){if(c[i].getVisible()){c[i].setVisible(false);this.addOverflowButton();return;}}},
_placeContextMenu:function(s,c){var o=(s.getId&&s.getId())||s.getAttribute("overlay");var f="contextMenuFakeDiv";var d=this._getOverlayDimensions(o);var v=this._getViewportDimensions();var i=d.top-50>v.top?0:v.top-(d.top-50);q("#"+f).remove();q("#"+o).append("<div id=\""+f+"\" overlay=\""+o+"\" style = \"position: absolute; top: "+i+"px; left: 0px;\" />");o=null;var e=document.getElementById(f);this.getPopover().setContentWidth(undefined);this.getPopover().setContentHeight(undefined);this.getPopover().openBy(e);var p=this._getPopoverDimensions(!c);if(p.height>=v.height*2/3){this.getPopover().setVerticalScrolling(true);p.height=(v.height*2/3).toFixed(0);this.getPopover().setContentHeight(p.height+"px");}else{this.getPopover().setVerticalScrolling(false);this.getPopover().setContentHeight(undefined);}if(p.width>400){p.width=400;this.getPopover().setContentWidth("400px");}else{this.getPopover().setContentWidth(undefined);}var I=(this._oLastSourceOverlay?this._oLastSourceOverlay===s:false);var g=(this._oLastSourceClientRects?D(JSON.parse(JSON.stringify(this._oLastSourceClientRects)),JSON.parse(JSON.stringify(s.getDomRef().getClientRects()))):false);if(this._oContextMenuPosition.x==="not set"&&this._oContextMenuPosition.y==="not set"&&I&&g){this._oContextMenuPosition.x=this._oLastPosition.x;this._oContextMenuPosition.y=this._oLastPosition.y;}else{this._oContextMenuPosition.x=this._oContextMenuPosition.x||parseInt(d.left+20);this._oContextMenuPosition.y=this._oContextMenuPosition.y||parseInt(d.top+20);}var h={};if(c){h=this._placeAsExpandedContextMenu(this._oContextMenuPosition,p,v);}else{h=this._placeAsCompactContextMenu(this._oContextMenuPosition,p,v);}h.top-=d.top;h.left-=d.left;h.top=(h.top<0)?0:h.top;h.left=(h.left<0)?0:h.left;e.style.top=h.top.toFixed(0)+"px";e.style.left=h.left.toFixed(0)+"px";return e;},
_placeAsExpandedContextMenu:function(c,p,v){this.getPopover().setShowArrow(false);var o={};if(v.height-10-c.y>=p.height){o.top=c.y;this.getPopover().setPlacement("Bottom");}else if(c.y>=p.height){o.top=c.y;this.getPopover().setPlacement("Top");}else{o.top=v.height-p.height;this.getPopover().setPlacement("Bottom");}if(v.width-c.x>=p.width){o.left=c.x;}else if(c.x>=p.width){o.left=c.x-p.width/2;}else{o.left=v.width-p.width;}return o;},
_placeAsCompactContextMenu:function(c,p,v){this.getPopover().setShowArrow(true);var o={};this.getPopover().setPlacement(b.PreferredTopOrFlip);var i=p.width/this._iButtonsVisible;var f=sap.ui.getCore().getConfiguration().getRTL()?-1:1;o.left=c.x+(f*((this._iButtonsVisible-1)*i)/2+(this._getBaseFontSize()*1/2));o.top=c.y-(this._getBaseFontSize()*1/2);o.left=(o.left<32)?32:o.left;o.top=(o.top-v.top<0)?v.top:o.top;if(v.width-o.left<32){o.left=v.width-32;this.getPopover().addStyleClass("sapUiDtContextMenuRightArrow");}else{this.getPopover().removeStyleClass("sapUiDtContextMenuRightArrow");}var d=this._bCompactMode?0:15;if(o.top<(100+d)){this.getPopover().setPlacement(b.Bottom);o.top+=16;}return o;},
_getPopoverDimensions:function(w){var p={};var c=this._bCompactMode;var A=this._getArrowHeight(c);var i=this._getBaseFontSize();this._iFirstVisibleButtonIndex=null;p.height=parseInt(q("#"+this.getPopover().getId()).css("height"))||40;p.width=parseInt(q("#"+this.getPopover().getId()).css("width"))||80;if(w){var d=i*A;if(d){p.height+=d;p.width+=d;}}return p;},
_getArrowHeight:function(c){if(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge){return c?0.5:0.5;}return c?0.5625:0.5625;},
_getBaseFontSize:function(){return parseInt(q(document.documentElement).css("fontSize"));},
_getOverlayDimensions:function(o){var c=q("#"+o).rect();c.right=c.left+c.width;c.bottom=c.top+c.height;return c;},
_getViewportDimensions:function(){var v={};v.width=window.innerWidth;v.height=window.innerHeight;v.top=parseInt(q(".type_standalone").css("height"))||0;v.bottom=v.top+v.height;return v;},
_getIcon:function(i){if(i===undefined||i===null||typeof i!=="string"){return"sap-icon://incident";}if(i==="blank"){return" ";}return i;},
addOverflowButton:function(){var o="OVERFLOW_BUTTON",c={icon:"sap-icon://overflow",type:"Transparent",enabled:true,press:this._onOverflowPress.bind(this),layoutData:new F({})};return this._addButton(o,c);},
addMenuButton:function(o,c,e){function h(){this.bOpen=false;this.bOpenNew=false;c(this);}var t=typeof o.text==="function"?o.text(e[0]):o.text;var E=typeof o.enabled==="function"?o.enabled(e):o.enabled;var d={icon:this._getIcon(o.icon),text:t,tooltip:t,type:"Transparent",enabled:E,press:h,layoutData:new F({})};return this._addButton(o.id,d);},
_addButton:function(s,o){this.setProperty("buttons",this.getProperty("buttons").concat(o));var c={id:s,key:s};var e=new B(o);e.data(c);delete o.text;var d=new B(o);d.data(c);this.getFlexbox(true).addItem(e);this.getFlexbox(false).addItem(d);return this;},
close:function(e){if(this.getPopover()){if(e){this.getPopover(true).close();this.getPopover(false).close();}if(this.getProperty("buttons").length>this.getProperty("maxButtonsDisplayed")){this.setProperty("buttons",this.getProperty("buttons").splice(0,this.getProperty("buttons").length-1));this.getFlexbox().removeItem(this.getButtons().length-1);}}return this;},
removeButton:function(i){this.setProperty("buttons",this.getProperty("buttons").splice(i,1));this.getFlexbox(true).removeItem(i);return this.getFlexbox(false).removeItem(i);},
removeAllButtons:function(){this.setProperty("buttons",[]);this.getFlexbox(true).removeAllItems();return this.getFlexbox(false).removeAllItems();},
getButtons:function(){return this.getFlexbox().getItems();},
insertButton:function(o,i){this.getFlexbox().insertItem(o,i);return this;},
setButtons:function(_,c,e){this.removeAllButtons();_.forEach(function(o){this.addMenuButton(o,c,e);}.bind(this));},
setMaxButtonsDisplayed:function(i){if(i<2){throw Error("maxButtonsDisplayed can't be less than two!");}this.setProperty("maxButtonsDisplayed",i);},
getPopover:function(e){if(e===undefined){if(this._bUseExpPop){return this._oExpandedPopover;}return this._oPopover;}else if(e){return this._oExpandedPopover;}return this._oPopover;},
getFlexbox:function(e){return this.getPopover(e).getContent()[0];},
setOpenNew:function(v){this.bOpenNew=v;},
_onOverflowPress:function(e){this.fireOverflowButtonPressed({oButton:e.oSource});},
_popupClosed:function(){if(this.getPopover()){this.fireClosed();if(this.bOpenNew){this.bOpenNew=false;this.finalizeOpening();return;}}this.bOpen=false;},
_setFocusOnButton:function(o){if(o.getEnabled()&&o.getVisible()){o.focus();return true;}},
_changeFocusOnKeyStroke:function(e){if(document.activeElement){var i=document.activeElement.id;switch(e.key){case"ArrowRight":this._changeFocusOnButtons(i);break;case"ArrowLeft":this._changeFocusOnButtons(i,true);break;case"ArrowUp":this._changeFocusOnButtons(i,true);break;case"ArrowDown":this._changeFocusOnButtons(i);break;default:break;}}},
_changeFocusOnButtons:function(i,p){this.getButtons().some(function(o,I,A){if(i===o.getId()){if(p){this._setFocusOnPreviousButton(A,I);}else{this._setFocusOnNextButton(A,I);}return true;}}.bind(this));},
_setFocusOnNextButton:function(c,i){for(var d=i+1;d<c.length;d++){if(this._setFocusOnButton(c[d])){return;}}for(var e=0;e<i;e++){if(this._setFocusOnButton(c[e])){return;}}},
_setFocusOnPreviousButton:function(c,i){for(var d=i-1;d>=0;d--){if(this._setFocusOnButton(c[d])){return;}}for(var e=c.length-1;e>=i;e--){if(this._setFocusOnButton(c[e])){return;}}},
_onContextMenu:function(e){if(e.preventDefault){e.preventDefault();}},
_handleAfterOpen:function(){this.getPopover().detachAfterOpen(this._handleAfterOpen,this);this.getPopover().addStyleClass("sapUiDtContextMenuVisible");this.fireOpened();},
_handleBeforeClose:function(){this.getPopover().detachBeforeClose(this._handleBeforeClose,this);this.getPopover().removeStyleClass("sapUiDtContextMenuVisible");document.activeElement.blur();},
_handleAfterClose:function(){if(document.activeElement.localName!=="body"){return;}this.getPopover().detachAfterClose(this._handleAfterClose,this);var n=document.getElementById(this._oTarget.getAttribute("overlay"));if(n){a.focusWithoutScrolling(n);this._oLastSourceOverlay=O.getOverlay(n.id);this._oLastSourceClientRects=this._oLastSourceOverlay.getDomRef().getClientRects();}else{this._oLastSourceClientRects=null;}this._oLastPosition={x:this._oContextMenuPosition.x,y:this._oContextMenuPosition.y};},
setStyleClass:function(s){this.setProperty("styleClass",s);}
});
return C;},true);
sap.ui.predefine('sap/ui/dt/ManagedObjectObserver',["sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/base/util/includes"],function(M,E,i){"use strict";
var a=M.extend("sap.ui.dt.ManagedObjectObserver",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{aggregations:{type:"array",defaultValue:null}},associations:{target:{type:"sap.ui.base.ManagedObject"}},events:{modified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},destroyed:{}}}});
a.prototype.init=function(){this._fnFireModified=function(e){var p=e.getParameters();if(e.sId==="_change"){e.sId="propertyChanged";}this.fireModified({type:e.sId,name:p.name,value:p.newValue,oldValue:p.oldValue,target:e.getSource()});}.bind(this);};
a.prototype.exit=function(){this.unobserve();delete this._fnFireModified;};
a.prototype.setTarget=function(t){this.unobserve();this.setAssociation("target",t);var T=this.getTargetInstance();if(T){this.observe(T);}return this;};
a.prototype.observe=function(t){this._bIsObserved=true;t.attachEvent("_change",this._fnFireModified,this);this._fnOriginalDestroy=t.destroy;t.destroy=function(){this.unobserve();var o=t.destroy.apply(t,arguments);this.fireDestroyed();return o;}.bind(this);this._fnOriginalBindProperty=t.bindProperty;t.bindProperty=function(){var o=this._fnOriginalBindProperty.apply(t,arguments);this.fireModified();return o;}.bind(this);this._fnOriginalUnBindProperty=t.unbindProperty;t.unbindProperty=function(){var o=this._fnOriginalUnBindProperty.apply(t,arguments);this.fireModified();return o;}.bind(this);this._fnOriginalBindAggregation=t.bindAggregation;t.bindAggregation=function(s){var o=this._fnOriginalBindAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified();}return o;}.bind(this);this._fnOriginalUnBindAggregation=t.unbindAggregation;t.unbindAggregation=function(s){var o=this._fnOriginalUnBindAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified();}return o;}.bind(this);this._fnOriginalSetParent=t.setParent;t.setParent=function(p,s){var f=false;if(!t._bInSetParent){f=true;t._bInSetParent=true;}var c=t.getParent();var o=this._fnOriginalSetParent.apply(t,arguments);if(f){t._bInSetParent=false;if(!t.__bSapUiDtSupressParentChangeEvent&&(c!==p||s==="dependents")){this.fireModified({type:"setParent",value:p,oldValue:c,target:t});}}return o;}.bind(this);this._fnOriginalAddAggregation=t.addAggregation;t.addAggregation=function(s,o){this._sAddOrSetAggregationCall=s;var O=this._fnOriginalAddAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalSetAggregation=t.setAggregation;t.setAggregation=function(s,o){this._sAddOrSetAggregationCall=s;var O=this._fnOriginalSetAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalRemoveAggregation=t.removeAggregation;t.removeAggregation=function(s,o){this._sRemoveAggregationCall=s;var O=this._fnOriginalRemoveAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"removeAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalInsertAggregation=t.insertAggregation;t.insertAggregation=function(s,o){this._sInsertAggregationCall=s;var O=this._fnOriginalInsertAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"insertAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalRemoveAllAggregation=t.removeAllAggregation;t.removeAllAggregation=function(s){this._sRemoveAllAggregationCall=s;var r=t.getAggregation(s);var o=this._fnOriginalRemoveAllAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"removeAllAggregation",name:s,value:r,target:t});}return o;}.bind(this);this._fnOriginalDestroyAggregation=t.destroyAggregation;t.destroyAggregation=function(s){this._sDestroyAggregationCall=s;var r=t.getAggregation(s);var o=this._fnOriginalDestroyAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"destroyAggregation",name:s,value:r,target:t});}return o;}.bind(this);this._fnOriginalAddAssociation=t.addAssociation;t.addAssociation=function(s,o){this._sAddOrSetAssociationCall=s;var O=this._fnOriginalAddAssociation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalSetAssociation=t.setAssociation;t.setAssociation=function(s,o){this._sAddOrSetAssociationCall=s;var O=this._fnOriginalSetAssociation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalRemoveAssociation=t.removeAssociation;t.removeAssociation=function(s,o){this._sRemoveAssociationCall=s;var O=this._fnOriginalRemoveAssociation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"removeAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalRemoveAllAssociation=t.removeAllAssociation;t.removeAllAssociation=function(s){this._sRemoveAllAssociationCall=s;var r=t.getAssociation(s);var o=this._fnOriginalRemoveAllAssociation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"removeAllAggregation",name:s,value:r,target:t});}return o;}.bind(this);this._aOriginalAddMutators={};this._aOriginalInsertMutators={};this._aOriginalRemoveMutators={};this._aOriginalRemoveAllMutators={};this._aOriginalDestructors={};var A=t.getMetadata().getAllAggregations();Object.keys(A).forEach(function(s){var o=A[s];var _=t[o._sMutator];this._aOriginalAddMutators[o.name]=_;t[o._sMutator]=function(O){delete this._sAddOrSetAggregationCall;var v=_.apply(t,arguments);if((!this._sAddOrSetAggregationCall||this._sAddOrSetAggregationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"addOrSetAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var b=t[o._sInsertMutator];this._aOriginalInsertMutators[o.name]=b;t[o._sInsertMutator]=function(O){delete this._sInsertAggregationCall;var v=b.apply(t,arguments);if((!this._sInsertAggregationCall||this._sInsertAggregationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"insertAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var c=t[o._sRemoveMutator];this._aOriginalRemoveMutators[o.name]=c;t[o._sRemoveMutator]=function(O){delete this._sRemoveAggregationCall;var v=c.apply(t,arguments);if((!this._sRemoveAggregationCall||this._sRemoveAggregationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"removeAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var d=t[o._sRemoveAllMutator];this._aOriginalRemoveAllMutators[o.name]=d;t[o._sRemoveAllMutator]=function(){delete this._sRemoveAllAggregationCall;var r=this.getAggregation(s);var O=d.apply(t,arguments);if((!this._sRemoveAllAggregationCall||this._sRemoveAllAggregationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"removeAllAggregation",name:o.name,value:r,target:t});}return O;}.bind(this);var e=t[o._sDestructor];this._aOriginalDestructors[o.name]=e;t[o._sDestructor]=function(){delete this._sDestroyAggregationCall;var r=this.getAggregation(s);var O=e.apply(t,arguments);if((!this._sDestroyAggregationCall||this._sDestroyAggregationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"destroyAggregation",name:o.name,value:r,target:t});}return O;}.bind(this);}.bind(this),this);var m=t.getMetadata().getAllAssociations();Object.keys(m).forEach(function(s){var o=m[s];var _=t[o._sMutator];this._aOriginalAddMutators[o.name]=_;t[o._sMutator]=function(O){delete this._sAddOrSetAssociationCall;var v;v=_.apply(t,arguments);if((!this._sAddOrSetAssociationCall||this._sAddOrSetAssociationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"addOrSetAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var b=t[o._sRemoveMutator];this._aOriginalRemoveMutators[o.name]=b;t[o._sRemoveMutator]=function(O){delete this._sRemoveAssociationCall;var v=b.apply(t,arguments);if((!this._sRemoveAssociationCall||this._sRemoveAssociationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"removeAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var c=t[o._sRemoveAllMutator];this._aOriginalRemoveAllMutators[o.name]=c;t[o._sRemoveAllMutator]=function(){delete this._sRemoveAllAssociationCall;var r=this.getAssociation(s);var O=c.apply(t,arguments);if((!this._sRemoveAllAssociationCall||this._sRemoveAllAssociationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"removeAllAggregation",name:o.name,value:r,target:t});}return O;}.bind(this);}.bind(this),this);};
a.prototype.unobserve=function(){var t=this.getTargetInstance();if(this._bIsObserved&&t){this._bIsObserved=false;t.destroy=this._fnOriginalDestroy;t.bindProperty=this._fnOriginalBindProperty;t.unbindProperty=this._fnOriginalUnBindProperty;t.bindAggregation=this._fnOriginalBindAggregation;t.unbindAggregation=this._fnOriginalUnBindAggregation;t.setParent=this._fnOriginalSetParent;t.addAggregation=this._fnOriginalAddAggregation;t.removeAggregation=this._fnOriginalRemoveAggregation;t.insertAggregation=this._fnOriginalInsertAggregation;t.setAggregation=this._fnOriginalSetAggregation;t.removeAllAggregation=this._fnOriginalRemoveAllAggregation;t.destroyAggregation=this._fnOriginalDestroyAggregation;t.addAssociation=this._fnOriginalAddAssociation;t.removeAssociation=this._fnOriginalRemoveAssociation;t.setAssociation=this._fnOriginalSetAssociation;t.removeAllAssociation=this._fnOriginalRemoveAllAssociation;var A=t.getMetadata().getAllAggregations();Object.keys(A).forEach(function(s){var o=A[s];t[o._sMutator]=this._aOriginalAddMutators[o.name];t[o._sInsertMutator]=this._aOriginalInsertMutators[o.name];t[o._sRemoveMutator]=this._aOriginalRemoveMutators[o.name];t[o._sRemoveAllMutator]=this._aOriginalRemoveAllMutators[o.name];t[o._sDestructor]=this._aOriginalDestructors[o.name];},this);var m=t.getMetadata().getAllAssociations();Object.keys(m).forEach(function(s){var o=m[s];t[o._sMutator]=this._aOriginalAddMutators[o.name];t[o._sRemoveMutator]=this._aOriginalRemoveMutators[o.name];t[o._sRemoveAllMutator]=this._aOriginalRemoveAllMutators[o.name];},this);t.detachEvent("_change",this._fnFireModified,this);}delete this._fnOriginalDestroy;delete this._fnOriginalBindProperty;delete this._fnOriginalUnBindProperty;delete this._fnOriginalBindAggregation;delete this._fnOriginalUnBindAggregation;delete this._fnOriginalSetParent;delete this._fnOriginalAddAggregation;delete this._fnOriginalRemoveAggregation;delete this._fnOriginalInsertAggregation;delete this._fnOriginalSetAggregation;delete this._fnOriginalRemoveAllAggregations;delete this._fnOriginalDestroyAggregation;delete this._aOriginalAddMutators;delete this._aOriginalInsertMutators;delete this._aOriginalRemoveMutators;delete this._aOriginalRemoveAllMutators;delete this._aOriginalDestructors;};
a.prototype.getTargetInstance=function(){return E.getElementInstance(this.getTarget());};
a.prototype._isAggregationObservable=function(A){return(this.getAggregations()===null||i(this.getAggregations(),A));};
return a;},true);
sap.ui.predefine('sap/ui/dt/MetadataPropagationUtil',["sap/ui/thirdparty/jquery","sap/ui/dt/Util","sap/base/util/merge"],function(q,U,m){"use strict";var M={};
M._getParentPropagationInfo=function(a){if(!a||!a["propagationInfos"]){return false;}return Object.assign([],a["propagationInfos"]);};
M._getCurrentRelevantContainerPropagation=function(e,E){var n={};if(!e.propagateRelevantContainer){return n;}else if(typeof e.propagateRelevantContainer==="function"){n.relevantContainerFunction=e.propagateRelevantContainer;n.relevantContainerElement=E;}else if(typeof e.propagateRelevantContainer==="boolean"&&e.propagateRelevantContainer){n.relevantContainerFunction=function(){return true;};n.relevantContainerElement=E;}else{var o=U.wrapError("Wrong type: it should be either a function or a boolean value and it is:"+typeof e.propagateRelevantContainer);var l='sap.ui.dt.MetadataPropagationUtil#_getCurrentRelevantContainerPropagation';o.name='Error in '+l;o.message=U.printf("{0} / {1}",l,o.message);throw o;}return n;};
M._getCurrentDesigntimePropagation=function(e,E){var n={};if(!e.propagateMetadata){return n;}else if(typeof e.propagateMetadata==="function"){n.relevantContainerElement=E;n.metadataFunction=e.propagateMetadata;}else{var o=U.wrapError("Wrong type: it should be a function and it is:"+typeof e.propagateRelevantContainer);var l='sap.ui.dt.MetadataPropagationUtil#_getCurrentDesigntimePropagation';o.name='Error in '+l;o.message=U.printf("{0} / {1}",l,o.message);throw o;}return n;};
M._setPropagationInfo=function(a,n,p){if(!p&&q.isEmptyObject(n)){return false;}a.propagationInfos=p||[];if(!q.isEmptyObject(n)){a.propagationInfos.push(n);}return a;};
M.propagateMetadataToAggregationOverlay=function(o,e,p){var n,a,r,b=Object.assign({},o);var P=M._getParentPropagationInfo(p);if(b&&!q.isEmptyObject(b)){r=M._getCurrentRelevantContainerPropagation(b,e);a=M._getCurrentDesigntimePropagation(b,e);}if(P||!q.isEmptyObject(r)||!q.isEmptyObject(a)){n=Object.assign({},r,a);return M._setPropagationInfo(b,n,P);}return b;};
M.getRelevantContainerForPropagation=function(p,e){var P=false;if(!p||!p.propagationInfos){return false;}p.propagationInfos.some(function(o){if(o.relevantContainerFunction&&o.relevantContainerFunction(e)){P=o.relevantContainerElement;return true;}});return P||false;};
M.getMetadataForPropagation=function(p,e){var r={};if(!p||!p.propagationInfos){return false;}var R=p.propagationInfos.slice().reverse();r=R.reduce(function(r,P){if(P.metadataFunction){var c=P.metadataFunction(e,P.relevantContainerElement);return m(r,c);}return r;},r);return q.isEmptyObject(r)?false:r;};
M.propagateMetadataToElementOverlay=function(t,p,e){var P=M.getRelevantContainerForPropagation(p,e);var v=M.getMetadataForPropagation(p,e);if(!P&&!v){return t;}var r=m({},t);if(P){r.relevantContainer=P;}if(v){if(v.actions===null||v.actions==="not-adaptable"){var a=e.getMetadata().getAllAggregations();var A=Object.keys(a);if(r.aggregations){A=A.concat(Object.keys(r.aggregations).filter(function(s){return A.indexOf(s)<0;}));}else{r.aggregations={};}A.forEach(function(s){if(r.aggregations[s]&&r.aggregations[s].actions){r.aggregations[s].actions=v.actions;}});}return m(r,v);}return r;};
return M;},true);
sap.ui.predefine('sap/ui/dt/MutationObserver',["sap/ui/thirdparty/jquery","sap/ui/dt/OverlayUtil","sap/ui/base/ManagedObject","sap/ui/dt/DOMUtil","sap/ui/dt/Util"],function(q,O,M,D,U){"use strict";
var a=M.extend("sap.ui.dt.MutationObserver",{metadata:{library:"sap.ui.dt",events:{domChanged:{parameters:{type:{type:"string"},targetNodes:{type:"element[]"}}}}}});
a.prototype.init=function(){this._fireDomChangeOnTransitionEnd=this._fireDomChangeOnTransitionEnd.bind(this);this._fireDomChangeOnAnimationEnd=this._fireDomChangeOnAnimationEnd.bind(this);this._fireDomChangeOnResize=this._fireDomChangeOnResize.bind(this);this._fireDomChangeOnScroll=this._fireDomChangeOnScroll.bind(this);window.addEventListener("transitionend",this._fireDomChangeOnTransitionEnd,true);window.addEventListener("animationend",this._fireDomChangeOnAnimationEnd,true);window.addEventListener("scroll",this._fireDomChangeOnScroll,true);q(window).on("resize",this._fireDomChangeOnResize);this._aIgnoredMutations=[];this._aWhiteList=[];this._startMutationObserver();};
a.prototype.exit=function(){this._stopMutationObserver();window.removeEventListener("transitionend",this._fireDomChangeOnTransitionEnd,true);window.removeEventListener("animationend",this._fireDomChangeOnAnimationEnd,true);window.removeEventListener("scroll",this._fireDomChangeOnScroll,true);q(window).off("resize",this._fireDomChangeOnResize);};
a.prototype.ignoreOnce=function(p){this._aIgnoredMutations.push(p);};
a.prototype.addToWhiteList=function(i){this._aWhiteList.push(i);};
a.prototype.removeFromWhiteList=function(i){this._aWhiteList=this._aWhiteList.filter(function(c){return c!==i;});};
a.prototype._isRelevantNode=function(n){return(document.body.contains(n)&&n.getAttribute('id')!=='sap-ui-static'&&!D.contains('sap-ui-preserve',n)&&(this._aWhiteList.some(function(i){return(D.contains(i,n)||n.contains(document.getElementById(i)));})));};
a.prototype._isRelevantMutation=function(m){return(this._isRelevantNode(this._getTargetNode(m))||(m.target.id==='sap-ui-static'&&U.intersection([].concat(Array.prototype.slice.call(m.addedNodes),Array.prototype.slice.call(m.removedNodes)).map(function(n){return n.id;}),this._aWhiteList).length>0));};
a.prototype._getTargetNode=function(m){return(m.type==="characterData"?m.target.parentNode:m.target);};
a.prototype._startMutationObserver=function(){this._oMutationObserver=new window.MutationObserver(function(m){var t=[];m.forEach(function(o){if(this._isRelevantMutation(o)){var T=this._getTargetNode(o);var i=this._aIgnoredMutations.some(function(I,b,s){if(I.target===o.target&&(!I.type||I.type===o.type)){s.splice(b,1);return true;}});if(!i){t.push(T);}}}.bind(this));if(t.length){this.fireDomChanged({type:"mutation",targetNodes:t});}}.bind(this));this._oMutationObserver.observe(window.document,{childList:true,subtree:true,attributes:true,attributeFilter:["style","class","width","height","border"],characterData:true});};
a.prototype._stopMutationObserver=function(){if(this._oMutationObserver){this._oMutationObserver.disconnect();delete this._oMutationObserver;}};
a.prototype._fireDomChangeOnTransitionEnd=function(){this.fireDomChanged({type:"transitionend"});};
a.prototype._fireDomChangeOnAnimationEnd=function(){this.fireDomChanged({type:"animationend"});};
a.prototype._fireDomChangeOnResize=function(){this.fireDomChanged({type:"resize"});};
a.prototype._fireDomChangeOnScroll=function(e){var t=e.target;if(this._isRelevantNode(t)&&!O.getClosestOverlayForNode(t)&&t!==document){this.fireDomChanged({type:"scroll"});}};
return a;},true);
sap.ui.predefine('sap/ui/dt/OverlayUtil',["sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementUtil"],function(O,E){"use strict";var c={};
c.isInTargetZoneAggregation=function(e){var a=e.getParent();return!!a&&a.isTargetZone();};
c.getParentInformation=function(e){var p=e.getParentElementOverlay();if(p){var P=p.getElement();var s=e.getParentAggregationOverlay().getAggregationName();var C=E.getAggregation(P,s);var o=e.getElement();var i=C.indexOf(o);return{parent:P,aggregation:s,index:i};}return{parent:null,aggregation:"",index:-1};};
c.getClosestOverlayFor=function(e){if(!e){return null;}var p=e;var P=O.getOverlay(p);while(p&&!P){p=p.getParent();P=O.getOverlay(p);}return P;};
c.getGeometry=function(g){var m,a,b,d;g.forEach(function(e){if(e){if(!m||e.position.left<m){m=e.position.left;}if(!b||e.position.top<b){b=e.position.top;}var r=e.position.left+e.size.width;if(!a||r>a){a=r;}var B=e.position.top+e.size.height;if(!d||B>d){d=B;}}});if(typeof m==="number"){return{size:{width:a-m,height:d-b},position:{left:m,top:b},visible:true};}};
c.getFirstDescendantByCondition=function(o,C){if(!C){throw new Error("expected condition is 'undefined' or not a function");}var a=c.getAllChildOverlays(o);for(var i=0,n=a.length;i<n;i++){var b=a[i];if(C(b)){return b;}var d=this.getFirstDescendantByCondition(b,C);if(d){return d;}}return undefined;};
c.getLastDescendantByCondition=function(o,C){if(!C){throw new Error("expected condition is 'undefined' or not a function");}var a=c.getAllChildOverlays(o);for(var i=a.length-1,n=-1;i>n;i--){var b=a[i];if(C(b)){return b;}var d=this.getLastDescendantByCondition(b,C);if(d){return d;}}return undefined;};
c.getAllChildOverlays=function(e){var C=[],a=[];if(!e){return C;}var A=e.getChildren();for(var i=0;i<A.length;i++){a=A[i].getChildren();if(a&&a.length>0){C=C.concat(a);}}return C;};
c.getFirstChildOverlay=function(o){var C=this.getAllChildOverlays(o);if(C.length){return C[0];}return undefined;};
c.getLastChildOverlay=function(o){var C=this.getAllChildOverlays(o);if(C.length){return C[C.length-1];}return undefined;};
c.getNextSiblingOverlay=function(o){if(!o){return undefined;}var p=o.getParentAggregationOverlay();if(p){var a=p.getChildren();var i=a.indexOf(o);if(i!==a.length-1){return a[i+1];}else if(i===a.length-1){var P=o.getParentElementOverlay();a=P.getAggregationOverlays();for(i=a.indexOf(p)+1;i<a.length;i++){var b=a[i].getChildren();if(b.length){return b[0];}}}}};
c.getPreviousSiblingOverlay=function(o){if(!o){return undefined;}var p=o.getParentAggregationOverlay();if(p){var a=p.getChildren();var i=a.indexOf(o);if(i>0){return a[i-1];}else if(i===0){var P=o.getParentElementOverlay();a=P.getAggregationOverlays();for(i=a.indexOf(p)-1;i>=0;i--){var b=a[i].getChildren();if(b.length){return b[b.length-1];}}}}};
c.getNextOverlay=function(o){if(!o){return undefined;}var f=this.getFirstChildOverlay(o);if(f){return f;}var n=this.getNextSiblingOverlay(o);if(n){return n;}do{o=o.getParentElementOverlay();n=this.getNextSiblingOverlay(o);}while(o&&!n);return n;};
c.getPreviousOverlay=function(o){if(!o){return undefined;}var p=o.getParentAggregationOverlay();if(!p){return undefined;}var P=this.getPreviousSiblingOverlay(o);if(P){var l=P;do{P=l;l=this.getLastChildOverlay(P);}while(l);return P;}return o.getParentElementOverlay();};
c.iterateOverlayElementTree=function(e,C){C(e);e.getAggregationOverlays().forEach(function(a){a.getChildren().forEach(function(o){this.iterateOverlayElementTree(o,C);},this);},this);};
c.getClosestOverlayForNode=function(n){var e=E.getClosestElementForNode(n);return c.getClosestOverlayFor(e);};
c.findAllSiblingOverlaysInContainer=function(o,r){var p=o.getParentElementOverlay();var R=[];if(p){if(p!==r){var P=c.findAllSiblingOverlaysInContainer(p,r);R=P.map(function(p){var a=p.getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName());return a?a.getChildren():[];}).reduce(function(f,C){return f.concat(C);},[]);}else{R=o.getParentElementOverlay().getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName()).getChildren();}}R=R.filter(function(o){return o.getDesignTimeMetadata();});return R;};
c.findAllOverlaysInContainer=function(o){var r=o.getRelevantContainer()||o.getElement();var R=O.getOverlay(r);var a=[];if(!R){return a;}var m=c._findAllSiblingsAndParents(o,R,0);if(m[0]){for(var l in m){a=a.concat(m[l]);}var C=[];m[0].forEach(function(o){C=C.concat(c._findAllChildrenInContainer(o,r));});a=a.concat(C);}else{a=c._findAllChildrenInContainer(o,r);}a.push(R);a=a.filter(function(o){return o.getDesignTimeMetadata();});return a;};
c._findAllSiblingsAndParents=function(o,r,l){var p=o.getParentElementOverlay();if(!p){return[];}if(p!==r){var P=c._findAllSiblingsAndParents(p,r,l+1);var d=P[l+1].map(function(p){var a=p.getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName());return a?a.getChildren():[];}).reduce(function(a,b){return a.concat(b);},[]);P[l]=d;return P;}var C=o.getParentElementOverlay().getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName()).getChildren();var R={};R[l]=C;return R;};
c._findAllChildrenInContainer=function(e,r,_){_=_||[];if(e.getChildren().length>0){e.getChildren().forEach(function(a){a.getChildren().forEach(function(C){if(C.getRelevantContainer()===r){_.push(C);c._findAllChildrenInContainer(C,r,_);}});});}return _;};
c.findAllUniqueAggregationOverlaysInContainer=function(o,r){var a=c.findAllSiblingOverlaysInContainer(o,r);return a.map(function(o){return o.getParentAggregationOverlay();}).filter(function(o,p,A){return A.indexOf(o)===p;});};
c.getAggregationInformation=function(e){var s=[];return this._evaluateBinding(e,s);};
c._evaluateBinding=function(e,s){var o=e.getElement();var a;var i;var p;if(e.getParentAggregationOverlay()){i=e.getParentAggregationOverlay().getChildren().indexOf(e);a=e.getParentAggregationOverlay().getAggregationName();p=e.getParentElementOverlay().getElement();}else{i=-1;}s.push({element:o.getId(),type:o.getMetadata().getName(),aggregation:a,index:i});if(a&&p.getBinding(a)){var b=p.getBindingInfo(a);var t=b&&b.template;return{elementId:p.getId(),aggregation:a,templateId:t?t.getId():undefined,stack:s};}return e.isRoot()?{elementId:undefined,aggregation:undefined,templateId:undefined,stack:s}:(this._evaluateBinding(e.getParentElementOverlay(),s));};
return c;},true);
sap.ui.predefine('sap/ui/dt/plugin/ContextMenu',["sap/ui/thirdparty/jquery","sap/ui/dt/Plugin","sap/ui/dt/ContextMenuControl","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/Device","sap/base/assert","sap/ui/events/KeyCodes"],function(q,P,C,D,O,a,b,K){"use strict";
var c=P.extend("sap.ui.dt.plugin.ContextMenu",{metadata:{properties:{contextElement:{type:"object"},styleClass:{type:"string"},openOnHover:{type:"boolean",defaultValue:true},openOnClick:{type:"boolean",defaultValue:true}},events:{openedContextMenu:{},closedContextMenu:{}}}});
c.prototype.init=function(){this.iMenuHoverOpeningDelay=500;this.iMenuHoverClosingDelay=250;this.oContextMenuControl=new C({maxButtonsDisplayed:4});this.oContextMenuControl.attachClosed(this._contextMenuClosed,this);this.oContextMenuControl.attachOverflowButtonPressed(this._pressedOverflowButton,this);this._aMenuItems=[];this._aGroupedItems=[];this._aSubMenus=[];};
c.prototype.exit=function(){this._clearHoverTimeout();delete this._aMenuItems;if(this.oContextMenuControl){this.oContextMenuControl.detachClosed(this._contextMenuClosed,this);this.oContextMenuControl.detachOverflowButtonPressed(this._pressedOverflowButton,this);this.oContextMenuControl.destroy();delete this.oContextMenuControl;}};
c.prototype.addMenuItem=function(m,r,p){var M={menuItem:m,fromPlugin:!!r,bPersistOneTime:p};this._aMenuItems.push(M);};
c.prototype.registerElementOverlay=function(o){o.attachBrowserEvent("click",this._onContextMenuOrClick,this);o.attachBrowserEvent("touchstart",this._onContextMenuOrClick,this);o.attachBrowserEvent("contextmenu",this._onContextMenuOrClick,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);o.attachBrowserEvent("keyup",this._onKeyUp,this);};
c.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._onContextMenuOrClick,this);o.detachBrowserEvent("touchstart",this._onContextMenuOrClick,this);o.detachBrowserEvent("contextmenu",this._onContextMenuOrClick,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);o.detachBrowserEvent("keyup",this._onKeyUp,this);};
c.prototype.open=function(p,o,d,i){this._bContextMenu=!!d;this.setContextElement(o.getElement());this.getDesignTime().getSelectionManager().attachChange(this._onSelectionChanged,this);var s=this.getSelectedOverlays().filter(function(E){return E!==o;});s.unshift(o);if(document.activeElement){document.activeElement.blur();}this._aMenuItems=this._aMenuItems.filter(function(m){if(m.bPersistOneTime){m.bPersistOneTime=false;return true;}return!m.fromPlugin;});var e=Promise.resolve();if(!i){e=D.waitForSynced(this.getDesignTime())().then(function(){this._aGroupedItems=[];this._aSubMenus=[];var f=[];var g=this.getDesignTime().getPlugins();g.forEach(function(h){var m=h.getMenuItems(s);if(!(m instanceof Promise)){m=Promise.resolve(m);}f.push(m);});return Promise.all(f);}.bind(this)).then(function(f){return f.reduce(function(g,m){return g.concat(m);});}).then(function(f){f.forEach(function(m){if(m.group!==undefined&&!d){this._addMenuItemToGroup(m);}else if(m.submenu!==undefined){this._addSubMenu(m,p,o);}else{this.addMenuItem(m,true);}}.bind(this));this._addItemGroupsToMenu(p,o);}.bind(this));}e.then(function(){var m=this._aMenuItems.map(function(M){return M.menuItem;});if(m.length>0){this.oContextMenuControl._bUseExpPop=!!d;m=this._sortMenuItems(m);this.oContextMenuControl.setButtons(m,this._onItemSelected.bind(this),s);this.oContextMenuControl.setStyleClass(this.getStyleClass());if(i){this.oContextMenuControl.setOpenNew(true);}this.oContextMenuControl.show(o,d,{x:p.clientX,y:p.clientY});}this.fireOpenedContextMenu();}.bind(this)).catch(function(E){throw D.createError("ContextMenu#open","An error occured during calling getMenuItems: "+E);});};
c.prototype._sortMenuItems=function(m){return m.sort(function(f,s){if(!f.rank&&!s.rank){return 0;}if(!f.rank&&s.rank){return-1;}if(f.rank&&!s.rank){return 1;}return f.rank-s.rank;});};
c.prototype._onContextMenu=function(e){var o=O.getOverlay(e.currentTarget.id);var p={clientX:e.clientX,clientY:e.clientY};this._openContextMenu(e,o,p);};
c.prototype._onItemSelected=function(e){this.oContextMenuControl.close(true);this._ensureSelection(this._oCurrentOverlay);this.setFocusLock(true);var s=[],o=this.getContextElement(),S=e.data("id");this._aMenuItems.some(function(m){if(S===m.menuItem.id){var i=m.menuItem;s=this.getSelectedOverlays();b(s.length>0,"sap.ui.rta - Opening context menu, with empty selection - check event order");var p={};p.eventItem=e;p.contextElement=o;i.handler(s,p);i=null;return true;}},this);};
c.prototype._onContextMenuOrClick=function(e){if(!this.fnDebounced){this.fnDebounced=D.debounce(function(){if(this._oCurrentEvent.type==="contextmenu"){this._onContextMenu(this._oCurrentEvent);}else{this._onClickorTouch(this._oCurrentEvent);}this._oCurrentEvent=undefined;this.fnDebounced=undefined;}.bind(this),50);}var o=O.getOverlay(e.currentTarget.id);if(o&&o.isSelectable()&&o.getSelected()){this._oCurrentEvent=e;e.stopPropagation();this.fnDebounced();}};
c.prototype._onClickorTouch=function(e){if(this.getOpenOnClick()){if(this.isMenuOpeningLocked()){this.unlockMenuOpening();this.oContextMenuControl.close();}this._startOpening(e);}};
c.prototype._startOpening=function(e,l){clearTimeout(this.hoverTimeout);this._bOpenedByHover=false;this._oTempTarget=e.currentTarget.id;var o=O.getOverlay(e.currentTarget.id);var t=e.target.className;if(o&&o.isSelectable()&&t.indexOf("sapUiDtOverlay")>-1&&(!this.isMenuOpeningLocked())){e.stopPropagation();if(this._shouldContextMenuOpen(e)){this._ensureSelection(o);if(this._oCurrentOverlay.isSelected()||a.os.android){if(l){this.lockMenuOpening();}this.oContextMenuControl.setOpenNew(true);this.open({clientX:e.clientX,clientY:e.clientY},o);return true;}}}};
c.prototype._onHover=function(e){var o=O.getOverlay(e.currentTarget.id);if(o&&o.isSelectable()&&!e.ctrlKey&&this.getOpenOnHover()){e.stopPropagation();if(this._shouldContextMenuOpen(e,true)){if(this.iMenuHoverClosingDelay>=this.iMenuHoverOpeningDelay){q.error("sap.ui.dt ContextMenu iMenuHoverClosingDelay is bigger or equal to iMenuHoverOpeningDelay!");}if(this.oContextMenuControl.getPopover().isOpen()){this._closingTimeout=setTimeout(function(){if(this.oContextMenuControl.getPopover().isOpen()){this.oContextMenuControl.close();}}.bind(this),this.iMenuHoverClosingDelay);}this.hoverTimeout=setTimeout(function(){O.getOverlay(e.currentTarget.id).focus();this._startOpening(e);this._bOpenedByHover=true;}.bind(this),this.iMenuHoverOpeningDelay);}}};
c.prototype._clearHoverTimeout=function(){if(this.hoverTimeout){clearTimeout(this.hoverTimeout);this.hoverTimeout=null;}if(this._closingTimeout){clearTimeout(this._closingTimeout);this._closingTimeout=null;}};
c.prototype._onKeyUp=function(e){var o=O.getOverlay(e.currentTarget.id);if((e.keyCode===K.SPACE||e.keyCode===K.ENTER)&&(e.shiftKey===false)&&(e.altKey===false)&&(e.ctrlKey===false)){if(o&&o.isSelectable()&&!this._checkForPluginLock()){this._startOpening(e,true);e.stopPropagation();e.preventDefault();}}if((e.keyCode===K.F10)&&(e.shiftKey===true)&&(e.altKey===false)&&(e.ctrlKey===false)){if(o&&o.isSelectable()){e.preventDefault();var p={clientX:"not set",clientY:"not set"};this._openContextMenu(e,o,p);}}};
c.prototype._onKeyDown=function(e){var o=O.getOverlay(e.currentTarget.id);if((e.keyCode===K.SPACE)&&(e.shiftKey===false)&&(e.altKey===false)&&(e.ctrlKey===false)){if(o&&o.isSelectable()&&!this._checkForPluginLock()){e.stopPropagation();e.preventDefault();}}};
c.prototype._shouldContextMenuOpen=function(e,o){if((!this._checkForPluginLock()&&!this.isMenuOpeningLocked())){if(!o){this._oCurrentOverlay=O.getOverlay(e.currentTarget.id);}return true;}return false;};
c.prototype._pressedOverflowButton=function(e){this.lockMenuOpening();var o=O.getOverlay(e.oSource._oTarget.getAttribute("overlay"));var p={clientX:e.mParameters.oButton.$().offset().left,clientY:e.mParameters.oButton.$().offset().top};this._openContextMenu(e,o,p);this.setFocusLock(true);};
c.prototype._openContextMenu=function(e,o,p){if(o&&o.isSelectable()){e.preventDefault();this._oCurrentOverlay=o;this.oContextMenuControl.close(true);this._bOpenedByHover=false;clearTimeout(this.hoverTimeout);this._ensureSelection(o);this.lockMenuOpening();this.oContextMenuControl.setOpenNew(true);this.open(p,o,true);if(e.stopPropagation){e.stopPropagation();}}};
c.prototype._contextMenuClosed=function(){this.unlockMenuOpening();this.setFocusLock(false);};
c.prototype._onSelectionChanged=function(){this.oContextMenuControl.close(true);this.getDesignTime().getSelectionManager().detachChange(this._onSelectionChanged,this);};
c.prototype.lockMenuOpening=function(o){if((this.oContextMenuControl.getPopover(true).isOpen()||this.oContextMenuControl.getPopover(false).isOpen())&&o!==true){this._bAsyncLock=true;}else{this._bOpeningLocked=true;}};
c.prototype.unlockMenuOpening=function(){this._bOpeningLocked=false;if(this._bAsyncLock){this.lockMenuOpening(true);}this._bAsyncLock=false;};
c.prototype.isMenuOpeningLocked=function(){return this._bOpeningLocked;};
c.prototype.setFocusLock=function(i){this._bFocusLocked=i;};
c.prototype._ensureSelection=function(o){if(o&&!o.isSelected()){o.setSelected(true);}};
c.prototype._checkForPluginLock=function(){if(a.os.ios){return false;}if(this.getDesignTime().getBusyPlugins().length){return true;}this.setFocusLock(false);return false;};
c.prototype._addMenuItemToGroup=function(m){var g=this._aGroupedItems.some(function(_){if(_.sGroupName===m.group){_.aGroupedItems.push(m);return true;}});if(!g){this._aGroupedItems.push({sGroupName:m.group,aGroupedItems:[m]});}};
c.prototype._addSubMenu=function(m,p,o){m.submenu.forEach(function(s){s.handler=m.handler;});m.handler=function(M,p,o){this._aSubMenus.some(function(_){if(_.sSubMenuId===M){_.aSubMenuItems.forEach(function(s){this.addMenuItem(s,true,true);}.bind(this));return true;}}.bind(this));if(!this._bContextMenu){p.clientX=null;p.clientY=null;}this.oContextMenuControl.close();setTimeout(function(){this.open(p,o,true,true);}.bind(this),0);this.lockMenuOpening();}.bind(this,m.id,p,o);this._aSubMenus.push({sSubMenuId:m.id,aSubMenuItems:m.submenu});this.addMenuItem(m,true);};
c.prototype._addItemGroupsToMenu=function(p,o){this._aGroupedItems.forEach(function(g,i){if(g.aGroupedItems.length===1){this.addMenuItem(g.aGroupedItems[0],true,false);}else{var h=function(i,p,o){this._aGroupedItems[i].aGroupedItems.forEach(function(m){this.addMenuItem(m,true,true);}.bind(this));p.clientX=null;p.clientY=null;this.oContextMenuControl.close();setTimeout(function(){this.open(p,o,true,true);}.bind(this),0);this.lockMenuOpening();};this.addMenuItem({id:g.sGroupName+"-groupButton",enabled:true,text:g.sGroupName,icon:g.aGroupedItems[0].icon,rank:g.aGroupedItems[0].rank,handler:h.bind(this,i,p,o)},true);}}.bind(this));};
return c;},true);
sap.ui.predefine('sap/ui/dt/plugin/ControlDragDrop',["sap/ui/dt/plugin/DragDrop","sap/ui/dt/plugin/ElementMover"],function(D,E){"use strict";
var C=D.extend("sap.ui.dt.plugin.ControlDragDrop",{metadata:{library:"sap.ui.dt",properties:{draggableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]},elementMover:{type:"any"}},associations:{}}});
var d="sapUiDtOverlayDropZone";
C.prototype.init=function(){D.prototype.init.apply(this,arguments);this.setElementMover(new E());};
C.prototype.setElementMover=function(n){var o=this.getElementMover();if(o!==n){if(o){o.destroy();}this.setProperty("elementMover",n);}};
C.prototype.setDraggableTypes=function(a){this.getElementMover().setMovableTypes(a);return this.setProperty("draggableTypes",a);};
C.prototype.registerElementOverlay=function(o){var e=o.getElement();this.getElementMover().checkMovable(o).then(function(m){if(this.getElementMover().isMovableType(e)&&m){o.setMovable(true);}if(this.oDraggedElement){this.getElementMover().activateTargetZonesFor(o,d);}D.prototype.registerElementOverlay.call(this,o);}.bind(this));};
C.prototype.deregisterElementOverlay=function(o){D.prototype.deregisterElementOverlay.apply(this,arguments);o.setMovable(false);if(this.oDraggedElement){this.getElementMover().deactivateTargetZonesFor(o,d);}};
C.prototype.getDraggedOverlay=function(){return this._oDraggedOverlay;};
C.prototype.onDragStart=function(o){this._oDraggedOverlay=o;this.getElementMover().setMovedOverlay(o);this.getElementMover().activateAllValidTargetZones(this.getDesignTime(),d);};
C.prototype.onDragEnd=function(){delete this._oPreviousTarget;this.getElementMover().deactivateAllTargetZones(this.getDesignTime(),d);delete this._oDraggedOverlay;this.getElementMover().setMovedOverlay(null);};
C.prototype.onDragEnter=function(t){var o=this.getDraggedOverlay();if(t.getElement()!==o.getElement()&&t!==this._oPreviousTarget){this.getElementMover().repositionOn(o,t);}this._oPreviousTarget=t;};
C.prototype.onAggregationDragEnter=function(a){delete this._oPreviousTarget;var o=this.getDraggedOverlay();this.getElementMover().insertInto(o,a);};
return C;},true);
sap.ui.predefine('sap/ui/dt/plugin/CutPaste',["sap/ui/dt/Plugin","sap/ui/dt/plugin/ElementMover","sap/ui/dt/OverlayUtil","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes"],function(P,E,O,D,a,K){"use strict";var I=true;
var C=P.extend("sap.ui.dt.plugin.CutPaste",{metadata:{library:"sap.ui.dt",properties:{movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]},elementMover:{type:"any"}},associations:{}}});
C.prototype.init=function(){this.setElementMover(new E());};
C.prototype.registerElementOverlay=function(o){var e=o.getElement();this.getElementMover().checkMovable(o).then(function(m){o.attachBrowserEvent("keydown",this._onKeyDown,this);if(this.getElementMover().isMovableType(e)&&m){o.setMovable(true);}if(this.getElementMover().getMovedOverlay()){this.getElementMover().activateTargetZonesFor(this.getElementMover().getMovedOverlay());}}.bind(this)).catch(function(b){throw D.createError("CutPaste#registerElementOverlay","An error occured during checkMovable: "+b);});};
C.prototype.deregisterElementOverlay=function(o){o.setMovable(false);o.detachBrowserEvent("keydown",this._onKeyDown,this);if(this.getElementMover().getMovedOverlay()){this.getElementMover().deactivateTargetZonesFor(this.getElementMover().getMovedOverlay());}};
C.prototype.setMovableTypes=function(m){this.getElementMover().setMovableTypes(m);return this.setProperty("movableTypes",m);};
C.prototype.setElementMover=function(e){e.setMovableTypes(this.getMovableTypes());return this.setProperty("elementMover",e);};
C.prototype.getCuttedOverlay=function(){return this.getElementMover().getMovedOverlay();};
C.prototype.isElementPasteable=function(t){var T=this._getTargetZoneAggregation(t);if((T)||(O.isInTargetZoneAggregation(t))){return true;}return false;};
C.prototype._onKeyDown=function(e){var o=a.getOverlay(e.currentTarget.id);var c=sap.ui.Device.os.macintosh?e.metaKey:e.ctrlKey;if((e.keyCode===K.X)&&(e.shiftKey===false)&&(e.altKey===false)&&(c===true)){this.cut(o);e.stopPropagation();}else if((e.keyCode===K.V)&&(e.shiftKey===false)&&(e.altKey===false)&&(c===true)){if(this.getElementMover().getMovedOverlay()){this.paste(o);}e.stopPropagation();}else if(e.keyCode===K.ESCAPE){this.stopCutAndPaste();e.stopPropagation();}};
C.prototype.cut=function(o){this.stopCutAndPaste();if(o.isMovable()){this.getElementMover().setMovedOverlay(o);o.addStyleClass("sapUiDtOverlayCutted");return this.getElementMover().activateAllValidTargetZones(this.getDesignTime()).then(function(){o.focus();});}return Promise.resolve(undefined);};
C.prototype._executePaste=function(t){var c=this.getElementMover().getMovedOverlay();if(!c){return false;}var r=false;if(!this._isForSameElement(c,t)){var T=this._getTargetZoneAggregation(t);if(T){this.getElementMover().insertInto(c,T);r=true;}else if(O.isInTargetZoneAggregation(t)){this.getElementMover().repositionOn(c,t,I);r=true;}}if(r){c.setSelected(true);setTimeout(function(){c.focus();},0);}return r;};
C.prototype.paste=function(t){var p=this._executePaste(t);if(p===true){this.stopCutAndPaste();}};
C.prototype.stopCutAndPaste=function(){var c=this.getElementMover().getMovedOverlay();if(c){c.removeStyleClass("sapUiDtOverlayCutted");this.getElementMover().setMovedOverlay(null);this.getElementMover().deactivateAllTargetZones(this.getDesignTime());}};
C.prototype._isForSameElement=function(c,t){return t.getElement()===c.getElement();};
C.prototype._getTargetZoneAggregation=function(t){var A=t.getAggregationOverlays();var p=A.filter(function(o){return o.isTargetZone();});if(p.length>0){return p[0];}return null;};
return C;},true);
sap.ui.predefine('sap/ui/dt/plugin/ElementMover',["sap/ui/base/Object","sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/Util"],function(B,M,E,D,O,a){"use strict";
var b=M.extend("sap.ui.dt.plugin.ElementMover",{metadata:{library:"sap.ui.dt",properties:{movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]}},associations:{},events:{validTargetZonesActivated:{}}}});
b.prototype._getMovableTypes=function(){return this.getProperty("movableTypes")||[];};
b.prototype.isMovableType=function(e){var m=this._getMovableTypes();return m.some(function(t){return B.isA(e,t);});};
b.prototype.checkMovable=function(){return Promise.resolve(true);};
b.prototype.getMovedOverlay=function(){return this._oMovedOverlay;};
b.prototype.setMovedOverlay=function(m){if(m){this._source=O.getParentInformation(m);}else{delete this._source;}this._oMovedOverlay=m;};
b.prototype._getSource=function(){return this._source;};
b.prototype.activateAllValidTargetZones=function(d,A){return this._iterateAllAggregations(d,this._activateValidTargetZone.bind(this),A,true).then(function(){this.fireValidTargetZonesActivated();}.bind(this));};
b.prototype._activateValidTargetZone=function(A,s){return this.checkTargetZone(A).then(function(v){if(v){A.setTargetZone(true);if(s){A.addStyleClass(s);}}}).catch(function(e){throw a.createError("ElementMover#_activateValidTargetZone","An error occured during activation of valid target zones: "+e);});};
b.prototype.checkTargetZone=function(A,o,c){var m=o||this.getMovedOverlay();var g=A.getGeometry();var G=g&&g.size.height>0&&g.size.width>0;if((c&&!G)||!c&&!D.isVisible(A.getDomRef())||!(A.getElement().getVisible&&A.getElement().getVisible())){return Promise.resolve(false);}var p=A.getElement();if(!p.getParent()){return Promise.resolve(false);}var d=m.getElement();var s=A.getAggregationName();if(E.isValidForAggregation(p,s,d)){return Promise.resolve(true);}return Promise.resolve(false);};
b.prototype._deactivateTargetZone=function(A,s){A.setTargetZone(false);if(s){A.removeStyleClass(s);}};
b.prototype.activateTargetZonesFor=function(o,A){return this._iterateOverlayAggregations(o,this._activateValidTargetZone.bind(this),A,true).then(function(){this.fireValidTargetZonesActivated();}.bind(this));};
b.prototype.deactivateTargetZonesFor=function(o,A){this._iterateOverlayAggregations(o,this._deactivateTargetZone.bind(this),A);};
b.prototype.deactivateAllTargetZones=function(d,A){this._iterateAllAggregations(d,this._deactivateTargetZone.bind(this),A);};
b.prototype._iterateAllAggregations=function(d,s,A,c){var o=d.getElementOverlays();var r=o.map(function(e){return this._iterateOverlayAggregations(e,s,A,c);},this);if(c){return Promise.all(r);}};
b.prototype._iterateOverlayAggregations=function(o,s,A,c){var d=o.getAggregationOverlays();var r=d.map(function(e){return s(e,A);});if(c){return Promise.all(r);}};
b.prototype.repositionOn=function(m,t,i){var o=m.getElement();var T=O.getParentInformation(t);var s=O.getParentInformation(m);var A;var p=m.getParentAggregationOverlay();var r=m.getRelevantContainer();var P=m.getParentElementOverlay();if(p&&P){var c=p.getAggregationName();A=P.getDesignTimeMetadata().getAggregation(c);}if(T.index!==-1){if(A&&A.beforeMove){A.beforeMove(r,o);}if(i){T.index++;if(s.aggregation===T.aggregation){T.index=E.adjustIndexForMove(s.parent,T.parent,s.index,T.index);}}E.insertAggregation(T.parent,T.aggregation,o,T.index);if(A&&A.afterMove){A.afterMove(r,o);}}};
b.prototype.insertInto=function(m,t){var o=m.getElement();var T=t.getElement();var A;var p=m.getParentAggregationOverlay();var r=m.getRelevantContainer();var P=m.getParentElementOverlay();if(p&&P){var s=p.getAggregationName();A=P.getDesignTimeMetadata().getAggregation(s);}var c=E.getAggregation(t.getElement(),t.getAggregationName());var i=c.indexOf(o);if(!(i>-1&&i===0)){if(A&&A.beforeMove){A.beforeMove(r,o);}var d=t.getAggregationName();E.insertAggregation(T,d,o,0);if(A&&A.afterMove){A.afterMove(r,o);}}};
b.prototype._compareSourceAndTarget=function(s,t){var p;for(p in s){switch(typeof(s[p])){case'object':if(s[p].getId()!==t[p].getId()){return false;}break;default:if(s[p]!==t[p]){return false;}}}return true;};
return b;},true);
sap.ui.predefine('sap/ui/dt/plugin/TabHandling',["sap/ui/thirdparty/jquery","sap/ui/dt/Plugin","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dom/jquery/Selectors"],function(q,P,O,a){"use strict";
var T=P.extend("sap.ui.dt.plugin.TabHandling",{metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}}});
T.prototype.registerElementOverlay=function(o){if(o.isRoot()){this.removeTabIndex();}};
T.prototype.deregisterElementOverlay=function(o){if(o.isRoot()){this.restoreTabIndex();}};
T.prototype.setDesignTime=function(d){P.prototype.setDesignTime.apply(this,arguments);if(d){if(!this._oMutationObserver){this._oMutationObserver=O.getMutationObserver();this._oMutationObserver.attachDomChanged(this._onDomChanged,this);}}else{this._oMutationObserver.detachDomChanged(this._onDomChanged,this);delete this._oMutationObserver;this.restoreTabIndex();}};
T.prototype.removeTabIndex=function(){var d=this.getDesignTime();var r=d.getRootElements();r.forEach(function(R){var o=a.getOverlay(R);var $=o&&o.getAssociatedDomRef();if($){$.find(":focusable:not([tabIndex=-1], #overlay-container *)").each(function(i,n){n.setAttribute("data-sap-ui-dt-tabindex",n.tabIndex);n.setAttribute("tabindex",-1);});}});};
T.prototype.restoreTabIndex=function(){q("[data-sap-ui-dt-tabindex]").each(function(i,n){n.setAttribute("tabindex",n.getAttribute("data-sap-ui-dt-tabindex"));n.removeAttribute("data-sap-ui-dt-tabindex");});};
T.prototype._onDomChanged=function(){if(this.getDesignTime().getEnabled()){this.removeTabIndex();}};
return T;},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/dt/AggregationDesignTimeMetadata',["sap/ui/dt/DesignTimeMetadata"],function(D){"use strict";
var A=D.extend("sap.ui.dt.AggregationDesignTimeMetadata",{metadata:{library:"sap.ui.dt"}});
A.prototype.getLabel=function(e,a){return D.prototype.getLabel.apply(this,arguments)||a;};
return A;},true);
sap.ui.predefine('sap/ui/dt/AggregationOverlay',["sap/ui/thirdparty/jquery","sap/ui/dt/Overlay","sap/ui/dt/ElementUtil","sap/ui/dt/Util","sap/base/util/merge"],function(q,O,E,U,m){"use strict";
var A=O.extend("sap.ui.dt.AggregationOverlay",{metadata:{library:"sap.ui.dt",properties:{aggregationName:{type:"string"},targetZone:{type:"boolean",defaultValue:false},scrollContainerId:{type:"int"}},events:{targetZoneChange:{parameters:{targetZone:{type:"boolean"}}}}}});
A.prototype._getAttributes=function(){return m({},O.prototype._getAttributes.apply(this,arguments),{"data-sap-ui-dt-aggregation":this.getAggregationName()});};
A.prototype._getChildIndex=function(c){var C=this.getChildren();var p;var P=C.indexOf(c)-1;while(P>0){p=C[P];if(p.isRendered()){break;}P--;}return P<0?0:P+1;};
A.prototype.insertChild=function(p,c){if(!(U.isInteger(p))){p=E[this.isAssociation()?'getIndexInAssociation':'getIndexInAggregation'](c.getElement(),this.getElement(),this.getAggregationName());}var P=this.indexOfAggregation('children',c);if(P!==p){if(P>-1){this.removeAggregation('children',c);}this.insertAggregation('children',c,p);if(this.isRendered()){var i=this._getChildIndex(c);var C=c.isRendered();var $=C?c.$():c.render(true);var a=q(this.getChildrenDomRef());var b=a.find('>').index($);var I;if(b!==i){if(i>0){I=b>-1&&b<i?i:i-1;a.find('>').eq(I).after($);}else{I=i;a.prepend($);}}if(!C){c.fireAfterRendering({domRef:$.get(0)});}}this.fireChildAdded();}};
A.prototype.addChild=function(c,s){this.insertChild(this.getChildren().length,c);if(!s){this.fireChildAdded();}};
A.prototype.render=function(){if(this.getChildren().length>0||this.getDesignTimeMetadata().getDomRef()){this.addStyleClass('sapUiDtAggregationOverlay');return O.prototype.render.apply(this,arguments);}};
A.prototype._getRenderingParent=function(){if(U.isInteger(this.getScrollContainerId())){return this.getParent().getScrollContainerById(this.getScrollContainerId());}return O.prototype._getRenderingParent.apply(this,arguments);};
A.prototype._setPosition=function(t,g,p,f){O.prototype._setPosition.apply(this,arguments);if(g.domRef&&!U.isInteger(this.getScrollContainerId())){this._handleOverflowScroll(g,this.$(),this.getParent(),f);}};
A.prototype.getAssociatedDomRef=function(){var e=this.getElement();var a=this.getAggregationName();var d=this.getDesignTimeMetadata();return d.getAssociatedDomRef(e,d.getDomRef(),a);};
A.prototype.setTargetZone=function(t){if(this.getTargetZone()!==t){this.setProperty("targetZone",t);this.toggleStyleClass("sapUiDtOverlayTargetZone",t);this.fireTargetZoneChange({targetZone:t});}return this;};
A.prototype.isTargetZone=function(){return this.getTargetZone();};
A.prototype.isAssociation=function(){return!!this.getDesignTimeMetadata().getData().aggregationLike;};
return A;},true);
sap.ui.predefine('sap/ui/dt/ControlObserver',["sap/ui/dt/ManagedObjectObserver"],function(M){"use strict";
var C=M.extend("sap.ui.dt.ControlObserver",{metadata:{library:"sap.ui.dt",properties:{},associations:{target:{type:"sap.ui.core.Control"}}}});
C.prototype.init=function(){M.prototype.init.apply(this,arguments);this._oControlDelegate={onAfterRendering:this._onAfterRendering};};
C.prototype.observe=function(c){M.prototype.observe.apply(this,arguments);c.addEventDelegate(this._oControlDelegate,this);};
C.prototype.unobserve=function(){var c=this.getTargetInstance();if(c){c.removeDelegate(this._oControlDelegate,this);}M.prototype.unobserve.apply(this,arguments);};
C.prototype._onAfterRendering=function(){this.fireModified({type:"afterRendering"});};
return C;},true);
sap.ui.predefine('sap/ui/dt/DOMUtil',["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/dt/Util","sap/ui/dom/jquery/zIndex"],function(q,D,U){"use strict";var a={};
a.getSize=function(d){var c=d.getBoundingClientRect();return{width:c.width,height:c.height};};
a.getOffsetFromParent=function(g,p){var P=p?q(p):null;var s=P?P.scrollTop():null;var S=p?a.getScrollLeft(p):null;var m=P?P.offset():null;var o={left:g.position.left,top:g.position.top};if(m){o.left-=(m.left-(S||0));o.top-=(m.top-(s||0));}if(sap.ui.getCore().getConfiguration().getRTL()){var i=P?P.width():q(window).width();if((D.browser.blink||U.isWebkit())&&a.hasVerticalScrollBar(P)){o.left-=a.getScrollbarWidth();}o.left=o.left-(i-g.size.width);}return o;};
a.getScrollLeft=function(e){var s=e.scrollLeft;if(!sap.ui.getCore().getConfiguration().getRTL()||!a.hasHorizontalScrollBar(e)){return s;}if(D.browser.blink){var m=e.scrollWidth-e.clientWidth;return s-m;}else if(D.browser.msie||D.browser.edge){return-s;}return s;};
a.getZIndex=function(d){var z;var e=q(d);if(e.length){z=e.zIndex()||e.css("z-index");}return z;};
a.hasVerticalScrollBar=function(d){var $=q(d);var o=$.css("overflow-y")==="auto"||$.css("overflow-y")==="scroll";return o&&$.get(0).scrollHeight>$.height();};
a.hasHorizontalScrollBar=function(d){var $=q(d);var o=$.css("overflow-x")==="auto"||$.css("overflow-x")==="scroll";return o&&$.get(0).scrollWidth>$.width();};
a.hasScrollBar=function(d){return a.hasVerticalScrollBar(d)||a.hasHorizontalScrollBar(d);};
a.getScrollbarWidth=function(){if(typeof a.getScrollbarWidth._cache==='undefined'){var o=q('<div/>').css({position:'absolute',top:'-9999px',left:'-9999px',width:'100px'}).appendTo('body');var w=o.width();o.css('overflow','scroll');var i=q('<div/>').css('width','100%').appendTo(o);var W=i.width();o.remove();a.getScrollbarWidth._cache=w-W;}return a.getScrollbarWidth._cache;};
a.getOverflows=function(d){var $=q(d);return{overflowX:$.css("overflow-x"),overflowY:$.css("overflow-y")};};
a.getGeometry=function(d,u){if(d){var o=q(d).offset();if(u){o.left=o.left-q(window).scrollLeft();o.top=o.top-q(window).scrollTop();}return{domRef:d,size:this.getSize(d),position:o,visible:this.isVisible(d)};}};
a.syncScroll=function(s,t){var $=q(t);var T=$.scrollTop();var o=$.scrollLeft();var b=q(s);var S=b.scrollTop();var c=b.scrollLeft();if(S!==T){$.scrollTop(S);}if(c!==o){$.scrollLeft(c);}};
a.getDomRefForCSSSelector=function(d,c){if(c&&d){var $=q(d);if(c===":sap-domref"){return $;}if(c.indexOf(":sap-domref")>-1){return $.find(c.replace(/:sap-domref/g,""));}return $.find(c);}return q();};
a.isVisible=function(d){return d?d.offsetWidth>0&&d.offsetHeight>0:false;};
a.setDraggable=function(n,v){n.setAttribute("draggable",v);};
a.getDraggable=function(n){switch(n.getAttribute("draggable")){case"true":return true;case"false":return false;default:return;}};
a._copyStylesTo=function(s,d){var S="";var b="";var l=s.length;for(var i=0;i<l;i++){b=s[i];S=S+b+":"+s.getPropertyValue(b)+";";}d.style.cssText=S;};
a._copyPseudoElement=function(p,s,d){var S=window.getComputedStyle(s,p);var c=S.getPropertyValue("content");if(c&&c!=="none"){c=String(c).trim();if(c.indexOf("attr(")===0){c=c.replace("attr(","");if(c.length){c=c.substring(0,c.length-1);}c=s.getAttribute(c)||"";}var P=q("<span></span>");if(p===":after"){P.appendTo(d);}else{P.prependTo(d);}P.text(c.replace(/(^['"])|(['"]$)/g,""));a._copyStylesTo(S,P.get(0));P.css("display","inline");}};
a.copyComputedStyle=function(s,d){s=q(s).get(0);d=q(d).get(0);var S=window.getComputedStyle(s);if(S.getPropertyValue("display")==="none"){d.style.display="none";return;}a._copyStylesTo(S,d);this._copyPseudoElement(":after",s,d);this._copyPseudoElement(":before",s,d);};
a.copyComputedStyles=function(s,d){s=q(s).get(0);d=q(d).get(0);for(var i=0;i<s.children.length;i++){this.copyComputedStyles(s.children[i],d.children[i]);}q(d).removeClass();q(d).attr("id","");q(d).attr("role","");q(d).attr("data-sap-ui","");q(d).attr("for","");q(d).attr("tabindex",-1);this.copyComputedStyle(s,d);};
a.cloneDOMAndStyles=function(n,t){n=q(n).get(0);var c=n.cloneNode(true);this.copyComputedStyles(n,c);q(t).append(c);};
a.insertStyles=function(s,t){var S=document.createElement('style');S.type='text/css';S.appendChild(document.createTextNode(s));t.appendChild(S);};
a.contains=function(i,t){var n=document.getElementById(i);return!!n&&n.contains(t);};
a.appendChild=function(t,c){var s=c.scrollTop;var S=c.scrollLeft;t.appendChild(c);c.scrollTop=s;c.scrollLeft=S;};
a.focusWithoutScrolling=function(t){if(D.browser.name!=="ie"){t.focus({preventScroll:true});return;}var s=[];var p=t.parentNode;while(p){s.push([p,p.scrollLeft,p.scrollTop]);p=p.parentNode;}t.focus();s.forEach(function(i){var e=i[0];if(e.scrollLeft!==i[1]){e.scrollLeft=i[1];}if(e.scrollTop!==i[2]){e.scrollTop=i[2];}});};
return a;},true);
sap.ui.predefine('sap/ui/dt/DesignTime',["sap/ui/base/ManagedObject","sap/ui/dt/ElementOverlay","sap/ui/dt/AggregationOverlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/SelectionManager","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/AggregationDesignTimeMetadata","sap/ui/dt/ElementUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayUtil","sap/ui/dt/MetadataPropagationUtil","sap/ui/dt/Util","sap/ui/dt/TaskManager","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/merge","sap/ui/dt/SelectionMode","sap/base/util/includes","sap/ui/dt/DesignTimeStatus"],function(M,E,A,O,S,a,b,c,d,e,f,U,T,L,i,m,g,h,D){"use strict";
var j=M.extend("sap.ui.dt.DesignTime",{
metadata:{library:"sap.ui.dt",properties:{designTimeMetadata:{type:"object"},enabled:{type:"boolean",defaultValue:true},scope:{type:"string",defaultValue:"default"}},associations:{rootElements:{type:"sap.ui.core.Element",multiple:true}},aggregations:{plugins:{type:"sap.ui.dt.Plugin",multiple:true}},events:{addRootElement:{parameters:{element:{type:"sap.ui.core.Element"}}},addPlugin:{parameters:{plugin:{type:"sap.ui.dt.Plugin"}}},enabledChanged:{parameters:{value:{type:"boolean"}}},elementOverlayCreated:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayDestroyed:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayAdded:{parameters:{id:{type:"string"},targetIndex:{type:"integer"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayMoved:{parameters:{id:{type:"string"},targetIndex:{type:"integer"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayEditableChanged:{parameters:{id:{type:"string"},elementId:{type:"string"},editable:{type:"boolean"}}},elementPropertyChanged:{parameters:{id:{type:"string"},name:{type:"string"},oldValue:{type:"any"},value:{type:"any"}}},syncing:{},synced:{},syncFailed:{}}},
constructor:function(){this._sStatus=D.SYNCED;this._mPendingOverlays={};this._oTaskManager=new T({complete:function(o){if(o.getSource().isEmpty()){this._registerElementOverlays();if(this._oTaskManager.isEmpty()&&this._sStatus!==D.SYNCED){this._sStatus=D.SYNCED;setTimeout(function(){this.fireSynced();}.bind(this),0);}}}.bind(this),add:function(o){if(o.getSource().count()===1){this._sStatus=D.SYNCING;this.fireSyncing();}}.bind(this)});this._oSelectionManager=new S();this._onElementOverlayDestroyed=this._onElementOverlayDestroyed.bind(this);this._aOverlaysCreatedInLastBatch=[];M.apply(this,arguments);this.getRootElements().forEach(this._createOverlaysForRootElement,this);this.attachEvent("addRootElement",function(o){this._createOverlaysForRootElement(o.getParameter('element'));},this);this.getPlugins().forEach(function(p){p.attachEvent("processingStatusChange",this._onProcessingStatusChange,this);},this);this.attachEvent("addPlugin",function(o){var p=o.getParameter('plugin');p.attachEvent("processingStatusChange",this._onProcessingStatusChange,this);},this);this.attachEvent("enabledChanged",function(o){var v=o.getParameter('value');var $=d.getOverlayContainer();$[v?'show':'hide']();this.getRootElements().forEach(function(r){var R=O.getOverlay(r);R.setVisible(v);if(v){R.applyStyles(true);}});},this);}
});
j.prototype._onProcessingStatusChange=function(o){if(o.getParameter("processing")){this._oTaskManager.add({type:"pluginInProcess",plugin:o.getSource().getMetadata().getName()});}else{this._oTaskManager.completeBy({type:"pluginInProcess",plugin:o.getSource().getMetadata().getName()});}};
j.prototype._removeOverlayFromSyncingBatch=function(o){var I=this._aOverlaysCreatedInLastBatch.indexOf(o);if(I!==-1){this._aOverlaysCreatedInLastBatch.splice(I,1);}};
j.prototype._registerElementOverlays=function(){var k=this._aOverlaysCreatedInLastBatch.slice();if(!k.length){return;}var t=this._oTaskManager.add({type:"registerElementOverlays"});var p=this.getPlugins();k.forEach(function(o){O.register(o);o.attachBeforeDestroy(function(l){O.deregister(l.getSource());});});k.forEach(function(o){p.forEach(function(P){try{P.callElementOverlayRegistrationMethods(o);}catch(v){var l=U.propagateError(v,"DesignTime#_registerElementOverlays",U.printf('registerElementOverlay() method of the plugin {0} has failed for overlay with id="{1}" (element id="{2}")',P.getMetadata().getName(),o.getId(),o.getElement().getId()));L.error(U.errorToString(l));}});},this);k.forEach(function(o){try{this.fireElementOverlayCreated({elementOverlay:o});}catch(v){var l=U.propagateError(v,"DesignTime#_registerElementOverlays",U.printf('One of the listeners of elementOverlayCreated event failed while precessing the overlay with id="{0}" for element with id="{1}"',o.getId(),o.getElement().getId()));L.error(U.errorToString(l));}},this);this._aOverlaysCreatedInLastBatch=[];this._oTaskManager.complete(t);};
j.prototype.exit=function(){this._bDestroyPending=true;this.getPlugins().forEach(function(p){p.destroy();});this._oSelectionManager.destroy();this._oTaskManager.destroy();this._destroyAllOverlays();this._aOverlaysCreatedInLastBatch=[];delete this._bDestroyPending;};
j.prototype.getSelection=function(){return this.getSelectionManager().get();};
j.prototype.getSelectionManager=function(){return this._oSelectionManager;};
j.prototype.getPlugins=function(){return this.getAggregation("plugins")||[];};
j.prototype.getBusyPlugins=function(){return this.getPlugins().filter(function(p){return p.isBusy();});};
j.prototype.addPlugin=function(p){this.addAggregation("plugins",p);this.fireAddPlugin({plugin:p});p.setDesignTime(this);return this;};
j.prototype.insertPlugin=function(p,I){this.insertAggregation("plugins",p,I);this.fireAddPlugin({plugin:p});p.setDesignTime(this);return this;};
j.prototype.removePlugin=function(p){this.getPlugins().forEach(function(C){if(C===p){p.setDesignTime(null);p.detachEvent("processingStatusChange",this._onProcessingStatusChange,this);}}.bind(this));this.removeAggregation("plugins",p);return this;};
j.prototype.removeAllPlugins=function(){this.getPlugins().forEach(function(p){p.setDesignTime(null);p.detachEvent("processingStatusChange",this._onProcessingStatusChange,this);}.bind(this));this.removeAllAggregation("plugins");return this;};
j.prototype.getRootElements=function(){return(this.getAssociation("rootElements")||[]).map(function(s){return c.getElementInstance(s);});};
j.prototype.getDesignTimeMetadataFor=function(o){var C;if(typeof o==='string'){C=o;L.error('sap.ui.dt.DesignTime#getDesignTimeMetadataFor / Function getDesignTimeMetadataFor() should be called with element instance');}else{C=o.getMetadata().getName();}return(this.getDesignTimeMetadata()||{})[C];};
j.prototype.addRootElement=function(r){this.addAssociation("rootElements",r);this.fireAddRootElement({element:r});};
j.prototype._createOverlaysForRootElement=function(r){var t=this._oTaskManager.add({type:"createOverlay",element:r,root:true});this.createOverlay({element:c.getElementInstance(r),root:true,visible:this.getEnabled()}).then(function(o){d.getOverlayContainer().append(o.render());o.applyStyles();this._oTaskManager.complete(t);return o;}.bind(this),function(v){var o=U.propagateError(v,"DesignTime#_createOverlaysForRootElement",U.printf('Root element with id = "{0}" initialization is failed',r.getId()));L.error(U.errorToString(o));this._oTaskManager.cancel(t);}.bind(this));};
j.prototype.removeRootElement=function(r){this.removeAssociation("rootElements",r);this._destroyOverlaysForElement(c.getElementInstance(r));return this;};
j.prototype.removeAllRootElement=function(){this.removeAssociation("rootElements");this._destroyAllOverlays();return this;};
j.prototype.getElementOverlays=function(){var k=[];this._iterateRootElements(function(r){k=k.concat(this._getAllElementOverlaysIn(r));},this);return k;};
j.prototype.createOverlay=function(v){var p=Object.assign({},i(v)?v:{element:v});var t=this._oTaskManager.add({type:'createOverlay'});if(!p.element||!c.isElementValid(p.element)){this._oTaskManager.cancel(t);return this._rejectCreateOverlay(p.element);}var s=p.element.getId();var o=O.getOverlay(s);if(o){this._oTaskManager.complete(t);return Promise.resolve(o);}else if(s in this._mPendingOverlays){this._oTaskManager.complete(t);return this._mPendingOverlays[s];}if(typeof p.root==="undefined"){p.root=true;}this._mPendingOverlays[s]=this._createElementOverlay(p).then(function(o){return this._createChildren(o,p.parentMetadata).then(function(){this.attachEventOnce("synced",function(){delete this._mPendingOverlays[s];},this);if(this.bIsDestroyed){o.detachEvent('destroyed',this._onElementOverlayDestroyed);o.destroy();this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating overlay, DesignTime instance has been destroyed"));}else if(o.bIsDestroyed){this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating children overlays, its parent overlay has been destroyed"));}this._aOverlaysCreatedInLastBatch.push(o);this._oTaskManager.complete(t);return o;}.bind(this));}.bind(this),function(k){throw k;}).catch(function(k){var l=U.propagateError(k,'DesignTime#createOverlay',U.printf("Failed attempt to create overlay for '{0}'",s));delete this._mPendingOverlays[s];this.fireSyncFailed({error:l});this._oTaskManager.cancel(t);return Promise.reject(l);}.bind(this));return this._mPendingOverlays[s];};
j.prototype._rejectCreateOverlay=function(o){var r;if(!o){r="Cannot create overlay — no element is specified.";}else if(o.bIsDestroyed){r="Cannot create overlay — the element is already destroyed.";}else{r=U.printf("Cannot create overlay without a valid element. Expected a descendant of sap.ui.core.Element or sap.ui.core.Component, but {0} was given",U.getObjectType(o));}return Promise.reject(U.createError("DesignTime#createOverlay",r));};
j.prototype._createElementOverlay=function(p){var o=p.element;function k(P){return new E(P);}return new Promise(function(r,R){k({element:o,isRoot:p.root,visible:typeof p.visible!=="boolean"||p.visible,metadataScope:this.getScope(),designTimeMetadata:(this.getDesignTimeMetadataFor(o)instanceof a?this.getDesignTimeMetadataFor(o):U.curry(function(l,P,o,n){n=m({},n,l);this._mMetadataOriginal=n;if(P){n=f.propagateMetadataToElementOverlay(n,P,o);}return n;})(this.getDesignTimeMetadataFor(o),p.parentMetadata,o)),init:function(l){r(l.getSource());},initFailed:function(s,l){var n=l.getSource();var q=U.propagateError(l.getParameter('error'),'DesignTime#_createElementOverlay',U.printf("Can't create overlay properly (id='{0}') for '{1}'",n.getId(),s));n.detachEvent('destroyed',this._onElementOverlayDestroyed);n.detachEvent('elementDestroyed',this._onElementDestroyed);n.destroy();R(q);}.bind(this,o.getId()),destroyed:this._onElementOverlayDestroyed,elementDestroyed:this._onElementDestroyed.bind(this),selectionChange:this._onElementOverlaySelectionChange.bind(this),elementModified:this._onElementModified.bind(this),editableChange:this._onEditableChanged.bind(this)});}.bind(this));};
j.prototype._createChildren=function(o,p){return Promise.all(o.getAggregationNames().map(function(s){var k=o.getElement();var l=k.getMetadata().getName();var n=f.propagateMetadataToAggregationOverlay(o.getDesignTimeMetadata().getAggregation(s),k,p);var q=new A({aggregationName:s,element:k,designTimeMetadata:new b({data:n}),beforeDestroy:function(r){O.deregister(r.getSource());},destroyed:this._onAggregationOverlayDestroyed});O.register(q);return Promise.all(c[q.isAssociation()?'getAssociationInstances':'getAggregation'](k,s).map(function(P,k){return this.createOverlay({element:k,root:false,parentMetadata:n}).catch(function(r){var t=this._enrichChildCreationError(r,k,P,s);L[t.severity](t.message);return t.errorObject;}.bind(this));}.bind(this,l))).then(function(C){C.map(function(r){if(r instanceof E&&!r.bIsDestroyed){q.addChild(r,true);}},this);return q;}.bind(this));},this)).then(function(k){k.forEach(function(l){if(o.bIsDestroyed){l.destroy();}else{o.addChild(l,true);}});});};
j.prototype._enrichChildCreationError=function(o,k,p,s){var l="error";var n=U.errorToString(o);if(o.message.includes("Cannot create overlay without a valid element")){l="warning";o=U.createError("DesignTime#_createChildren",U.printf(["Child element in aggregation '{0}' of {1} must be a descendant of sap.ui.core.Element or ","sap.ui.core.Component, but {2} was give. Consider ignoring the aggregation '{0}' ","in the .designtime configuration of the control."].join(''),s,p,U.getObjectType(k)));n=o.toString();}return{errorObject:o,severity:l,message:n};};
j.prototype._destroyOverlaysForElement=function(o){var k=O.getOverlay(o);if(k){k.destroy();}};
j.prototype._destroyAllOverlays=function(){this._iterateRootElements(function(r){this._destroyOverlaysForElement(r);},this);};
j.prototype._onElementOverlayDestroyed=function(o){if(this._bDestroyPending){return;}var k=o.getSource();var s=k.getAssociation('element');if(s in this._mPendingOverlays){this._removeOverlayFromSyncingBatch(k);return;}if(!O.hasOverlays()){d.destroyMutationObserver();d.removeOverlayContainer();}if(k.isSelected()){this.getSelectionManager().remove(k);}this.fireElementOverlayDestroyed({elementOverlay:k});};
j.prototype._onElementDestroyed=function(o){var s=o.getParameter("targetId");this.removeRootElement(s);};
j.prototype._onAggregationOverlayDestroyed=function(){if(!O.hasOverlays()){d.removeOverlayContainer();}};
j.prototype._onElementOverlaySelectionChange=function(o){var k=o.getSource();var s=o.getParameter("selected");if(s){if(this.getSelectionManager().getSelectionMode()===g.Multi){this.getSelectionManager().add(k);}else{this.getSelectionManager().set(k);}if(!h(this.getSelectionManager().get(),k)){k.setSelected(false);}}else{this.getSelectionManager().remove(k);}};
j.prototype._onElementModified=function(o){var p=m({},o.getParameters());p.type=!p.type?o.getId():p.type;switch(p.type){case"addOrSetAggregation":case"insertAggregation":if(this.getStatus()===D.SYNCING){this.attachEventOnce("synced",function(p){if(!this.bIsDestroyed){this._onAddAggregation(p.value,p.target,p.name);}}.bind(this,p));}else{this._onAddAggregation(p.value,p.target,p.name);}break;case"setParent":setTimeout(function(){if(!this.bIsDestroyed){this._checkIfOverlayShouldBeDestroyed(p.target);}}.bind(this),0);break;case"propertyChanged":p.id=o.getSource().getId();delete p.type;delete p.target;if(this.getStatus()===D.SYNCING){this.attachEventOnce("synced",function(p){this.fireElementPropertyChanged(p);}.bind(this,p));}else{this.fireElementPropertyChanged(p);}break;}};
j.prototype._onEditableChanged=function(o){var p=m({},o.getParameters());p.id=o.getSource().getId();if(this.getStatus()===D.SYNCING){this.attachEventOnce("synced",function(){this.fireElementOverlayEditableChanged(p);},this);}else{this.fireElementOverlayEditableChanged(p);}};
j.prototype._onAddAggregation=function(o,p,s){if(c.isElementValid(o)){var P=O.getOverlay(p);var k=P.getAggregationOverlay(s);var l=O.getOverlay(o);if(!l){var t=this._oTaskManager.add({type:'createChildOverlay',element:o});l=this.createOverlay({element:o,root:false,parentMetadata:k.getDesignTimeMetadata().getData()}).then(function(l){k.insertChild(null,l);l.applyStyles();var n=k.indexOfAggregation('children',l);this.attachEventOnce("synced",function(){this.fireElementOverlayAdded({id:l.getId(),targetIndex:n,targetId:k.getId(),targetAggregation:k.getAggregationName()});},this);this._oTaskManager.complete(t);}.bind(this),function(v){throw v;}).catch(function(n,q,v){this._oTaskManager.cancel(t);var r=U.propagateError(v,"DesignTime#_onAddAggregation",U.printf("Failed to add new element overlay (elementId='{0}') into aggregation overlay (id='{1}')",n,q));if(!o.bIsDestroyed){L.error(U.errorToString(r));}}.bind(this,o.getId(),k.getId()));}else{if(l&&!this._isElementInRootElements(l)&&l.isRoot()){l.setIsRoot(false);}k.insertChild(null,l);l.setDesignTimeMetadata(f.propagateMetadataToElementOverlay(l._mMetadataOriginal,k.getDesignTimeMetadata().getData(),o));this.fireElementOverlayMoved({id:l.getId(),targetIndex:k.indexOfAggregation('children',l),targetId:k.getId(),targetAggregation:k.getAggregationName()});}}};
j.prototype._checkIfOverlayShouldBeDestroyed=function(o){var k=O.getOverlay(o);if(!o.bIsDestroyed&&k&&(!this._isElementInRootElements(o)||o.sParentAggregationName==="dependents")){k.destroy();}};
j.prototype._isElementInRootElements=function(o){var F=false;this._iterateRootElements(function(r){if(c.hasAncestor(o,r)){F=true;return false;}});return F;};
j.prototype._iterateRootElements=function(s,o){var r=this.getRootElements();r.forEach(function(R){var k=c.getElementInstance(R);s.call(o||this,k);},this);};
j.prototype._getAllElementOverlaysIn=function(o){var k=[];var l=O.getOverlay(o);if(l){e.iterateOverlayElementTree(l,function(C){if(C.getDesignTimeMetadata()){k.push(C);}});}return k;};
j.prototype.setEnabled=function(v){v=!!v;if(this.getEnabled()!==v){this.setProperty('enabled',v);this.fireEnabledChanged({value:v});}};
j.prototype.getStatus=function(){return this._sStatus;};
return j;},true);
sap.ui.predefine('sap/ui/dt/DesignTimeMetadata',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/base/util/merge"],function(q,M,E,D,m){"use strict";
var a=M.extend("sap.ui.dt.DesignTimeMetadata",{metadata:{library:"sap.ui.dt",properties:{data:{type:"any",defaultValue:{}}}}});
a.prototype.setData=function(d){this.setProperty("data",m({},this.getDefaultData(),d));return this;};
a.prototype.getDefaultData=function(){return{ignore:false,domRef:undefined};};
a.prototype.isIgnored=function(e){var i=this.getData().ignore;if(!i||(i&&typeof i==="function"&&!i(e))){return false;}return true;};
a.prototype.markedAsNotAdaptable=function(){var A=this.getData().actions;return A==="not-adaptable";};
a.prototype.getDomRef=function(){return this.getData().domRef;};
a.prototype.getAssociatedDomRef=function(e,d,A){if(e){var o=E.getDomRef(e);var b=[];b.push(e);if(A){b.push(A);}if(typeof(d)==="function"){var r=d.apply(null,b);return r?q(r):r;}else if(o&&typeof(d)==="string"){return D.getDomRefForCSSSelector(o,d);}}};
a.prototype.getAction=function(A,e){var d=this.getData();if(d.actions&&d.actions[A]){var v=d.actions[A];if(typeof(v)==="function"){v=v.call(null,e);}if(typeof(v)==="string"){return{changeType:v};}return v;}};
a.prototype.getLibraryText=function(e,k,A){var o=e.getMetadata();return this._lookForLibraryTextInHierarchy(o,k,A);};
a.prototype._lookForLibraryTextInHierarchy=function(o,k,A){var l;var p;var r;l=o.getLibraryName();r=this._getTextFromLibrary(l,k,A);if(!r){p=o.getParent();if(p&&p.getLibraryName){r=this._lookForLibraryTextInHierarchy(p,k,A);}else{r=k;}}return r;};
a.prototype._getTextFromLibrary=function(l,k,A){var L=sap.ui.getCore().getLibraryResourceBundle(l+".designtime");if(L&&L.hasText(k)){return L.getText(k,A);}L=sap.ui.getCore().getLibraryResourceBundle(l);if(L&&L.hasText(k)){return L.getText(k,A);}};
a.prototype.getLabel=function(){var l=this.getData().getLabel;return typeof l==="function"?l.apply(this,arguments):undefined;};
a.prototype.getControllerExtensionTemplate=function(){return this.getData().controllerExtensionTemplate;};
return a;},true);
sap.ui.predefine('sap/ui/dt/DesignTimeStatus',[],function(){"use strict";return{SYNCING:'syncing',SYNCED:'synced'};});
sap.ui.predefine('sap/ui/dt/ElementDesignTimeMetadata',["sap/ui/dt/DesignTimeMetadata","sap/ui/dt/AggregationDesignTimeMetadata","sap/ui/dt/ElementUtil"],function(D,A,E){"use strict";
var a=D.extend("sap.ui.dt.ElementDesignTimeMetadata",{metadata:{library:"sap.ui.dt"}});
a.prototype.getDefaultData=function(){var d=D.prototype.getDefaultData.apply(this,arguments);d.aggregations={layout:{ignore:true},dependents:{ignore:true},customData:{ignore:true},layoutData:{ignore:true},tooltip:{ignore:true},dragDropConfig:{ignore:true}};return d;};
a.prototype.hasAggregation=function(s){return!!this.getAggregations()[s];};
a.prototype.getAggregation=function(s){return this.getAggregations()[s];};
a.prototype.createAggregationDesignTimeMetadata=function(m){return new A({data:m});};
a.prototype.getAggregations=function(){var m=this.getData().aggregations||{};var b=this.getData().associations||{};Object.keys(b).forEach(function(s){var c=b[s];if(c.aggregationLike){m[s]=c;}});return m;};
a.prototype.getAggregationNamesWithAction=function(s){var m=this.getAggregations();return Object.keys(m).filter(function(b){return m[b].actions&&m[b].actions[s];});};
a.prototype.getActionDataFromAggregations=function(s,e,b,S){var v;var m=this.getAggregations();var c=[];for(var d in m){if(m[d].actions&&m[d].actions[s]){v=m[d].actions[s];if(S){v=v[S];}if(typeof v==="function"){var f=[e];if(b){f=f.concat(b);}v=v.apply(null,f);}if(typeof(v)==="string"){v={changeType:v};}if(v){v.aggregation=d;c.push(v);}}}return c;};
a.prototype._getText=function(e,n){if(typeof n==="function"){return n();}return this.getLibraryText(e,n);};
a.prototype.getAggregationDescription=function(s,e){var c=this.getAggregation(s).childNames;if(typeof c==="function"){c=c.call(null,e);}if(c){return{singular:this._getText(e,c.singular),plural:this._getText(e,c.plural)};}};
a.prototype.getName=function(e){var n=this.getData().name;if(typeof n==="function"){n=n.call(null,e);}if(n){return{singular:this._getText(e,n.singular),plural:this._getText(e,n.plural)};}};
a.prototype.getToolHooks=function(){return this.getData().tool||{start:function(){},stop:function(){}};};
a.prototype.isAggregationIgnored=function(e,s){var m=this.getAggregations();var o=m[s];var i=(o)?o.ignore:false;if(!i||(i&&typeof i==="function"&&!i(e))){return false;}return true;};
a.prototype.getScrollContainers=function(e){var s=this.getData().scrollContainers||[];s.forEach(function(S){if(typeof S.aggregations==="function"){S.aggregations=S.aggregations.call(null,e);}});return s;};
a.prototype.getLabel=function(e){return D.prototype.getLabel.apply(this,arguments)||E.getLabelForElement(e);};
a.prototype.getStableElements=function(o){var e=o.getElement();var s;var g=this.getData().getStableElements;if(g){s=g(e);}else{s=[e];}if(!s||!Array.isArray(s)){s=[];}return s;};
return a;},true);
sap.ui.predefine('sap/ui/dt/ElementOverlay',["sap/ui/dt/Overlay","sap/ui/dt/ControlObserver","sap/ui/dt/ManagedObjectObserver","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/dt/Util","sap/ui/core/Control","sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/merge"],function(O,C,M,E,a,D,U,b,q,L,i,m){"use strict";var S='sapUiDtOverlayScrollContainer';
var c=O.extend("sap.ui.dt.ElementOverlay",{
metadata:{library:"sap.ui.dt",associations:{editableByPlugins:{type:"any[]",multiple:true,singularName:"editableByPlugin"}},properties:{selected:{type:"boolean",defaultValue:false},selectable:{type:"boolean",defaultValue:false},movable:{type:"boolean",defaultValue:false},editable:{type:"boolean",defaultValue:false},relevantOverlays:{type:"any[]",defaultValue:[]},metadataScope:{type:"string"}},events:{selectionChange:{parameters:{selected:{type:"boolean"}}},movableChange:{parameters:{movable:{type:"boolean"}}},selectableChange:{parameters:{selectable:{type:"boolean"}}},editableChange:{parameters:{editable:{type:"boolean"}}},elementModified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},elementDestroyed:{parameters:{targetId:"string"}}}},
constructor:function(){this._aMetadataEnhancers=[];O.apply(this,arguments);}
});
c.prototype.asyncInit=function(){return(this.getDesignTimeMetadata()?Promise.resolve():this._loadDesignTimeMetadata()).then(function(){this.attachEvent("elementModified",function(e){var p=e.getParameters();var n=p.name;if(p.type==="propertyChanged"){if(n==="visible"){this.setRelevantOverlays([]);}}else if(n){this.setRelevantOverlays([]);}},this);this._initMutationObserver();this._initControlObserver();}.bind(this));};
c.prototype._initMutationObserver=function(){if(this.isRoot()){this._subscribeToMutationObserver();}this.attachEvent('isRootChanged',function(e){if(e.getParameter('value')){this._subscribeToMutationObserver();}else{this._unsubscribeFromMutationObserver();}},this);};
c.prototype._subscribeToMutationObserver=function(){var o=O.getMutationObserver();var d=this.getAssociatedDomRef();this._sObservableNodeId=d&&d.get(0).id;if(this._sObservableNodeId){o.addToWhiteList(this._sObservableNodeId);o.attachDomChanged(this._onDomChanged,this);}else{throw U.createError('ElementOverlay#_subscribeToMutationObserver','Please provide a root control with proper domRef and id to ensure that DesignTime is working properly');}};
c.prototype._unsubscribeFromMutationObserver=function(){if(this._sObservableNodeId){var o=O.getMutationObserver();o.removeFromWhiteList(this._sObservableNodeId);o.detachDomChanged(this._onDomChanged,this);delete this._sObservableNodeId;}};
c.prototype._initControlObserver=function(){if(this.getElement()instanceof b){this._oObserver=new C({target:this.getElement(),aggregations:this.getAggregationNames()});}else{this._oObserver=new M({target:this.getElement(),aggregations:this.getAggregationNames()});}this._oObserver.attachModified(this._onElementModified,this);this._oObserver.attachDestroyed(this._onElementDestroyed,this);};
c.prototype._destroyControlObserver=function(){if(this._oObserver){this._oObserver.destroy();}};
c.prototype._getAttributes=function(){return m({},O.prototype._getAttributes.apply(this,arguments),{"data-sap-ui-dt-for":this.getElement().getId(),draggable:this.getMovable()});};
c.prototype.render=function(){this.addStyleClass('sapUiDtElementOverlay');return O.prototype.render.apply(this,arguments);};
c.prototype.exit=function(){if(this.isRoot()){this._unsubscribeFromMutationObserver();}this._destroyControlObserver();if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}O.prototype.exit.apply(this,arguments);};
c.prototype._loadDesignTimeMetadata=function(){return this.getElement().getMetadata().loadDesignTime(this.getElement(),this.getMetadataScope()).then(function(d){var e=this.getElement();if(!e||e.bIsDestroyed){throw U.createError("ElementOverlay#loadDesignTimeMetadata","Can't set metadata to overlay which element has been destroyed already");}this.setDesignTimeMetadata(d);}.bind(this)).catch(function(e){throw U.propagateError(e,"ElementOverlay#loadDesignTimeMetadata",U.printf("Can't load designtime metadata data for overlay with id='{1}', element id='{2}': {3}",this.getId(),this.getAssociation('element'),U.wrapError(e).message));}.bind(this));};
c.prototype._setPosition=function(t,g,p,f){O.prototype._setPosition.apply(this,arguments);this.getScrollContainers().forEach(function(s,I){var $=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),s.domRef)||q();var d=this.getScrollContainerById(I);if($.length){var o=$.get(0);var e=D.getGeometry(o);this._setSize(d,e);O.prototype._setPosition.call(this,d,e,this.$());this._handleOverflowScroll(e,d,this,f);this._setZIndex(e,d);}else{d.css("display","none");}},this);};
c.prototype._applySizes=function(){var p=this.getChildren().filter(function(o){return o.isRendered();}).map(function(o){return new Promise(function(r){o.attachEventOnce('geometryChanged',r);});});O.prototype._applySizes.apply(this,arguments);Promise.all(p).then(function(){this._sortChildren(this.getChildrenDomRef());if(!this.bIsDestroyed){this.getScrollContainers().forEach(function(s,I){var $=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),s.domRef)||q();var d=this.getScrollContainerById(I);if($.length){this._sortChildren(d.get(0));}},this);}}.bind(this));};
c.prototype._sortChildren=function(o){var f=function(g,h){var G=D.getGeometry(g);var j=D.getGeometry(h);var p=G&&G.position;var P=j&&j.position;if(p&&P){var B=p.top+G.size.height;var k=P.top+j.size.height;if(p.top<P.top){if(B>=k&&P.left<p.left){return 1;}return-1;}else if(p.top===P.top){if(p.left===P.left){if(G.size.height<j.size.height||G.size.width<j.size.width){return-1;}else if(G.size.height>j.size.height||G.size.width>j.size.width){return 1;}return 0;}else if(p.left<P.left){return-1;}return 1;}else if(B<=k&&P.left>p.left){return-1;}return 1;}return 0;};var d=q(o).find('>:not(.sapUiDtDummyScrollContainer)').toArray();var s=d.slice().sort(f);var e=d.some(function(g,I){return g!==s[I];});if(e){s.forEach(function(g){D.appendChild(o,g);});}};
c.prototype.placeInOverlayContainer=function(){if(this._bInit){if(this.isRoot()){if(!this.isRendered()){O.getOverlayContainer().append(this.render());this.applyStyles();}else{L.error('sap.ui.dt.ElementOverlay: overlay is already rendered and can\'t be placed in overlay container. Isn\'t it already there?');}}else{L.error('sap.ui.dt.ElementOverlay: it\'s not possible to place overlay inside overlay container while it\'s part of some hierarchy');}}else{L.error('sap.ui.dt.ElementOverlay: overlay is not ready yet. Please wait until "init" event happens');}};
c.prototype.setDesignTimeMetadata=function(d){var o=this.getDesignTimeMetadata();var e;if(q.isFunction(d)){if(!o){this._aMetadataEnhancers=this._aMetadataEnhancers.concat(d);}else{o.setData(d(m({},o.getData())));return;}}else if(d instanceof E){o=d;}else if(i(d)){e=d;var f;while(f=this._aMetadataEnhancers.shift()){e=f.call(this,e);}o=new E({data:e});}if(o){O.prototype.setDesignTimeMetadata.call(this,o);}};
c.prototype.getScrollContainers=function(){return this.getDesignTimeMetadata().getScrollContainers(this.getElement());};
c.prototype._renderChildren=function(){var d=O.prototype._renderChildren.apply(this,arguments);this.getScrollContainers().forEach(function(s,I){var $=q("<div/>",{"class":S,"data-sap-ui-dt-scrollContainerIndex":I});if(s.aggregations){U.intersection(s.aggregations,this.getAggregationNames()).forEach(function(A){var o=this.getAggregationOverlay(A);var e=d.indexOf(o.$());o.setScrollContainerId(I);$.append(d[e]);d.splice(e,1);},this);}d.push($);},this);return d;};
c.prototype.getScrollContainerById=function(I){return q(this.getChildrenDomRef()).find('>.'+S+'[data-sap-ui-dt-scrollcontainerindex="'+I+'"]');};
c.prototype.getAssociatedDomRef=function(){var d=this.getDesignTimeMetadata();var v=d.getDomRef();var o=d.getAssociatedDomRef(this.getElement(),v);if(!o){o=a.getDomRef(this.getElement());}if(o){return q(o);}return undefined;};
c.prototype.setSelectable=function(s){s=!!s;if(s!==this.isSelectable()){if(!s){this.setSelected(false);}this.toggleStyleClass("sapUiDtOverlaySelectable",s);this.setProperty("selectable",s);this.fireSelectableChange({selectable:s});}this.setFocusable(s);return this;};
c.prototype.setSelected=function(s){s=!!s;if(this.isSelectable()&&s!==this.isSelected()){this.setProperty("selected",s);this.toggleStyleClass("sapUiDtOverlaySelected",s);this.fireSelectionChange({selected:s});}return this;};
c.prototype.setMovable=function(d){d=!!d;if(this.getMovable()!==d){this.toggleStyleClass("sapUiDtOverlayMovable",d);this.setProperty("movable",d);this.fireMovableChange({movable:d});this.$()[d?'attr':'removeAttr']('draggable',d);}return this;};
c.prototype.setEditable=function(e){e=!!e;if(this.getEditable()!==e){this.toggleStyleClass("sapUiDtOverlayEditable",e);this.setProperty("editable",e);this.fireEditableChange({editable:e});}return this;};
c.prototype.getAggregationNames=function(){var e=this.getElement();var d=this.getDesignTimeMetadata();var A=e.getMetadata().getAllAggregations();return[].concat(Object.keys(A),Object.keys(d.getAggregations())).filter(function(s,I,f){return(I===f.indexOf(s)&&!d.isAggregationIgnored(e,s));});};
c.prototype._onChildAdded=function(e){var A=e.getSource();if(this.isRendered()&&!A.isRendered()){var t=(U.isInteger(A.getScrollContainerId())?this.getScrollContainerById(A.getScrollContainerId()):q(this.getChildrenDomRef()));t.append(A.render());}};
c.prototype.addChild=function(A){A.detachChildAdded(this._onChildAdded,this);A.attachChildAdded(this._onChildAdded,this);O.prototype.addChild.apply(this,arguments);};
c.prototype._onElementModified=function(e){this.fireElementModified(e.getParameters());};
c.prototype._onDomChanged=function(){if(this.isReady()&&this.isRoot()){if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}this._iApplyStylesRequest=window.requestAnimationFrame(function(){this.applyStyles();delete this._iApplyStylesRequest;}.bind(this));}};
c.prototype._onElementDestroyed=function(e){var s=e.getSource().getTarget();this.fireElementDestroyed({targetId:s});if(this._bInit){this.destroy();}else{this._bShouldBeDestroyed=true;}};
c.prototype.getAggregationOverlays=function(){return this.getAggregation("children")||[];};
c.prototype.getAggregationOverlay=function(A){return this.getChildren().filter(function(o){return o.getAggregationName()===A;}).pop();};
c.prototype.getParentElementOverlay=function(){var p=this.getParentAggregationOverlay();if(p){return p.getParent();}};
c.prototype.getParentAggregationOverlay=function(){var p=this.getParent();return p instanceof sap.ui.dt.AggregationOverlay?p:null;};
c.prototype.isSelected=function(){return this.getSelected();};
c.prototype.isSelectable=function(){return this.getSelectable();};
c.prototype.isMovable=function(){return this.getMovable();};
c.prototype.isEditable=function(){return this.getEditable();};
c.prototype._getElementInstanceVisible=function(){var e=this.getElement();if(e){var g=this.getGeometry();return g&&g.visible;}return false;};
c.prototype.getElementVisibility=function(){var e=this.getElement();if(e instanceof sap.ui.core.Control){return e.getVisible();}var d=this.getDesignTimeMetadata();var f=d&&d.getData().isVisible;if(!f){return undefined;}return f(this.getElement());};
c.prototype.isElementVisible=function(){var e=this.getElement();var v=false;var d=this.getDesignTimeMetadata();var o=d.getData();if(d.isIgnored(e)){v=false;}else if(typeof o.isVisible==="function"){v=o.isVisible(e);}else{var g=this.getGeometry(true);if(g){v=g.visible;}else if(e instanceof b){v=!!e.getDomRef()&&e.getVisible();}}return v;};
c.prototype.isVisible=function(){return(O.prototype.isVisible.apply(this,arguments)&&this.isElementVisible());};
c.prototype.getRelevantContainer=function(f){var d=this.getDesignTimeMetadata();if(d&&d.getData().relevantContainer){return d.getData().relevantContainer;}else if(f){return this.getElement();}var p=this.getParentElementOverlay();return p?p.getElement():undefined;};
c.prototype._hasSameSize=function(s,t){var d=this.getScrollContainers();var e;if(d.length){e=U.max(d.map(function(f,I){var g=D.getGeometry(this.getScrollContainerById(I).get(0));return g.size[t];},this));}else{e=this.getGeometry().size[t];}return s.size[t]===e;};
return c;},true);
sap.ui.predefine('sap/ui/dt/ElementUtil',["sap/ui/thirdparty/jquery","sap/ui/base/Object","sap/ui/dt/Util","sap/ui/core/Element","sap/ui/core/Component"],function(q,B,U,E,C){"use strict";var c={};
c.iterateOverAllPublicAggregations=function(e,f){var a=e.getMetadata().getAllAggregations();var A=Object.keys(a);A.forEach(function(s){var o=a[s];var v=this.getAggregation(e,s);f(o,v);},this);};
c.getElementInstance=function(e){if(typeof e==="string"){var o=sap.ui.getCore().byId(e);return o||C.get(e);}return e;};
c.hasAncestor=function(e,a){a=this.fixComponentContainerElement(a);var f;while(e&&e!==a){f=this.fixComponentParent(e);if(e===f){e=e.getParent();}else{e=f;}}return!!e;};
c.getClosestElementForNode=function(n){var $=q(n).closest("[data-sap-ui]");return $.length?sap.ui.getCore().byId($.attr("data-sap-ui")):undefined;};
c.fixComponentParent=function(e){if(B.isA(e,"sap.ui.core.UIComponent")){var o=e.oContainer;if(o){return o.getParent();}}else{return e;}};
c.fixComponentContainerElement=function(e){if(B.isA(e,"sap.ui.core.ComponentContainer")){if(!e.getComponentInstance()){return undefined;}return e.getComponentInstance().getRootControl();}return e;};
c.getDomRef=function(e){if(e){var d;if(e.getDomRef){d=e.getDomRef();}if(!d&&e.getRenderedDomRef){d=e.getRenderedDomRef();}return d;}};
c.findAllSiblingsInContainer=function(e,o){var p=e&&e.getParent();if(!p){return[];}if(p!==o){var P=c.findAllSiblingsInContainer(p,o);return P.map(function(p){return c.getAggregation(p,e.sParentAggregationName);}).reduce(function(a,b){return a.concat(b);},[]);}return c.getAggregation(p,e.sParentAggregationName);};
c.getAggregationAccessors=function(e,a){var m=e.getMetadata();m.getJSONKeys();var A=m.getAggregation(a);if(A){var g=A._sGetter;if(A.altTypes&&A.altTypes.length&&e[A._sGetter+"Control"]){g=A._sGetter+"Control";}return{get:g,add:A._sMutator,remove:A._sRemoveMutator,insert:A._sInsertMutator,removeAll:A._sRemoveAllMutator};}return{};};
c.getAggregation=function(e,a){var v;var g=this.getAggregationAccessors(e,a).get;if(g){v=e[g]();}else{v=e.getAggregation(a);}v=v&&v.splice?v:(v?[v]:[]);return v;};
c.getIndexInAggregation=function(e,p,a){return this.getAggregation(p,a).indexOf(e);};
c.addAggregation=function(p,a,e){if(this.hasAncestor(p,e)){throw new Error("Trying to add an element to itself or its successors");}var A=this.getAggregationAccessors(p,a).add;if(A){p[A](e);}else{p.addAggregation(a,e);}};
c.removeAggregation=function(p,a,e,s){var A=this.getAggregationAccessors(p,a).remove;if(A){p[A](e,s);}else{p.removeAggregation(a,e,s);}};
c.insertAggregation=function(p,a,e,i){if(this.hasAncestor(p,e)){throw new Error("Trying to add an element to itself or its successors");}if(this.getIndexInAggregation(e,p,a)!==-1){e.__bSapUiDtSupressParentChangeEvent=true;try{this.removeAggregation(p,a,e,true);}finally{delete e.__bSapUiDtSupressParentChangeEvent;}}var A=this.getAggregationAccessors(p,a).insert;if(A){p[A](e,i);}else{p.insertAggregation(a,e,i);}};
c.isValidForAggregation=function(p,a,e){var A=p.getMetadata().getAggregation(a);if(this.hasAncestor(p,e)){return false;}if(A){var t=A.type;if(A.multiple===false&&this.getAggregation(p,a)&&this.getAggregation(p,a).length>0){return false;}return B.isA(e,t)||this.hasInterface(e,t);}};
c.getAssociationAccessors=function(e,a){var m=e.getMetadata();m.getJSONKeys();var A=m.getAssociation(a);if(A){return{get:A._sGetter,add:A._sMutator,remove:A._sRemoveMutator,insert:A._sInsertMutator,removeAll:A._sRemoveAllMutator};}return{};};
c.getAssociation=function(e,a){var v;var g=this.getAssociationAccessors(e,a).get;if(g){v=e[g]();}return v;};
c.getIndexInAssociation=function(e,p,a){return this.getAssociationInstances(p,a).indexOf(e);};
c.getAssociationInstances=function(e,a){var v=U.castArray(this.getAssociation(e,a));return v.map(function(i){return this.getElementInstance(i);},this);};
c.hasInterface=function(e,i){var I=e.getMetadata().getInterfaces();return I.indexOf(i)!==-1;};
c.isElementValid=function(o){var v=((o instanceof E||o instanceof C)&&!o.bIsDestroyed);return v;};
c.getParent=function(e){return B.isA(e,'sap.ui.core.Component')?e.oContainer:e.getParent();};
c.getLabelForElement=function(e,f){if(!c.isElementValid(e)){throw U.createError("ElementUtil#getLabelForElement","A valid managed object instance should be passed as parameter","sap.ui.dt");}if(typeof f==="function"){return f(e);}function a(e){var F=(typeof e.getText==="function"&&e.getText()||typeof e.getLabelText==="function"&&e.getLabelText()||typeof e.getLabel==="function"&&e.getLabel()||typeof e.getTitle==="function"&&e.getTitle()||typeof e.getHeading==="function"&&e.getHeading());if(c.isElementValid(F)){return a(F);}return F;}var v=a(e);return typeof v!=="string"?e.getId():v;};
c.extractTemplateId=function(b){if(b.templateId){if(b.stack.length>1){var r;var a=sap.ui.getCore().byId(b.templateId);var A;var I;for(var i=b.stack.length-2;i>=0;i--){A=b.stack[i].aggregation;I=b.stack[i].index;r=c.getAggregation(a,A)[I];a=r;}return a.getId();}else if(b.stack.length===1){return b.templateId;}}else{return undefined;}};
c.adjustIndexForMove=function(s,t,S,T){if(s===t&&S<T&&S>-1){return T-1;}return T;};
return c;},true);
sap.ui.predefine('sap/ui/dt/Overlay',["sap/ui/thirdparty/jquery","sap/ui/core/Element","sap/ui/dt/MutationObserver","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/DOMUtil","sap/ui/dt/ScrollbarSynchronizer","sap/ui/dt/Util","sap/base/Log","sap/ui/dt/util/ZIndexManager"],function(q,E,M,a,O,D,S,U,L,Z){"use strict";var b="overlay-container";var o;var m;
var c=E.extend("sap.ui.dt.Overlay",{
metadata:{library:"sap.ui.dt",properties:{visible:{type:"boolean",defaultValue:true},focusable:{type:"boolean",defaultValue:false},isRoot:{type:"boolean",defaultValue:false}},associations:{element:{type:"sap.ui.base.ManagedObject"}},aggregations:{children:{type:"sap.ui.dt.Overlay",multiple:true},designTimeMetadata:{type:"sap.ui.dt.DesignTimeMetadata",altTypes:["function","object"],multiple:false}},events:{init:{},initFailed:{},afterRendering:{},beforeDestroy:{},destroyed:{parameters:{}},visibleChanged:{parameters:{visible:"boolean"}},geometryChanged:{},childAdded:{},scrollSynced:{},isRootChanged:{parameters:{value:{type:"boolean"}}},beforeGeometryChanged:{}}},
constructor:function(){this._aStyleClasses=this._aStyleClasses.slice(0);this._oScrollbarSynchronizers=new Map();this._aBindParameters=[];E.apply(this,arguments);if(!this.getElement()){throw U.createError("Overlay#constructor",U.printf("Cannot create overlay without a valid element. Expected a descendant of sap.ui.core.Element or sap.ui.core.Component, but {0} was given",U.getObjectType(arguments[0].element)));}this.asyncInit().then(function(){if(this._bShouldBeDestroyed){this.fireInitFailed({error:U.createError("Overlay#asyncInit","ElementOverlay is destroyed during initialization ('"+this.getId()+"')")});}else{this._bInit=true;this.fireInit();}}.bind(this)).catch(function(e){var d=U.propagateError(e,"Overlay#asyncInit",U.printf("Can't initialize overlay (id='{0}') properly. Original error: {1}",this.getId(),U.wrapError(e).message));this.fireInitFailed({error:d});}.bind(this));this.attachEventOnce('afterRendering',function(e){var d=q(e.getParameter('domRef'));this._aBindParameters.forEach(function(B){d.on(B.sEventType,B.fnProxy);});},this);},
_bInit:false,
_bRendered:false,
_$DomRef:null,
_aStyleClasses:['sapUiDtOverlay'],
_bShouldBeDestroyed:false,
_aBindParameters:null
});
c.getOverlayContainer=function(){if(!o){o=q("<div/>").attr('id',b).appendTo("body");}return o;};
c.removeOverlayContainer=function(){if(o){o.remove();}o=undefined;};
c.getMutationObserver=function(){if(!m){m=new M();}return m;};
c.destroyMutationObserver=function(){if(m){m.destroy();m=null;}};
c.prototype.asyncInit=function(){return Promise.resolve();};
c.prototype._getAttributes=function(){return{id:this.getId(),"data-sap-ui":this.getId(),"class":this._aStyleClasses.join(" "),tabindex:this.isFocusable()?0:null};};
c.prototype._renderChildren=function(){return this.getChildren().map(function(C){return C.isRendered()?C.$():C.render();});};
c.prototype.render=function(s){if(this.isRendered()){return this.getDomRef();}this._$DomRef=q('<div/>').attr(this._getAttributes());this._$Children=q('<div/>').attr({"class":"sapUiDtOverlayChildren"}).appendTo(this._$DomRef);this._$Children.append(this._renderChildren());this._bRendered=true;if(!s){this.fireAfterRendering({domRef:this._$DomRef.get(0)});}return this._$DomRef;};
c.prototype.isInit=function(){return this._bInit;};
c.prototype.isRendered=function(){return this._bRendered;};
c.prototype.isReady=function(){return this.isInit()&&this.isRendered();};
c.prototype.addStyleClass=function(C){if(!this.hasStyleClass(C)){this._aStyleClasses.push(C);if(this.isReady()){this.$().addClass(C);}}};
c.prototype.hasStyleClass=function(C){return this._aStyleClasses.indexOf(C)!==-1;};
c.prototype.removeStyleClass=function(C){if(this.hasStyleClass(C)){this._aStyleClasses=this._aStyleClasses.filter(function(i){return i!==C;});if(this.isReady()){this.$().removeClass(C);}}};
c.prototype.toggleStyleClass=function(C){this[(this.hasStyleClass(C)?'remove':'add')+'StyleClass'](C);};
c.prototype.setElement=function(e){if(!this.getElement()){this.setAssociation("element",e);if(this._designTimeMetadataCache){this.setDesignTimeMetadata(this._designTimeMetadataCache);delete this._designTimeMetadataCache;}}};
c.prototype.destroy=function(){if(this.bIsDestroyed){L.error('FIXME: Do not destroy overlay twice (overlayId = '+this.getId()+')!');return;}this.fireBeforeDestroy();E.prototype.destroy.apply(this,arguments);};
c.prototype.exit=function(){this._oScrollbarSynchronizers.forEach(function(s){s.destroy();});this._oScrollbarSynchronizers.clear();this.$().remove();delete this._bInit;delete this._bShouldBeDestroyed;delete this._$DomRef;delete this._oScrollbarSynchronizers;this.fireDestroyed();};
c.prototype.setDesignTimeMetadata=function(v){if(!this.getElement()){this._designTimeMetadataCache=v;}else{this.setAggregation('designTimeMetadata',v);}};
c.prototype.getDomRef=function(){return this.$().get(0);};
c.prototype.getChildrenDomRef=function(){return this._$Children.get(0);};
c.prototype.$=function(){return this._$DomRef||q();};
c.prototype.getAssociatedDomRef=function(){throw new Error("This method is abstract and needs to be implemented");};
c.prototype.getElementInstance=function(){return this.getElement();};
c.prototype.getElement=function(){return a.getElementInstance(this.getAssociation('element'));};
c.prototype.hasFocus=function(){return document.activeElement===this.getDomRef();};
c.prototype.focus=function(){this.$().focus();};
c.prototype.setFocusable=function(f){f=!!f;if(this.getFocusable()!==f){this.setProperty("focusable",f);this.toggleStyleClass("sapUiDtOverlayFocusable");this.$().attr("tabindex",f?0:null);}};
c.prototype.isFocusable=function(){return this.getFocusable();};
c.prototype._getRenderingParent=function(){return this.isRoot()?null:this.getParent().$();};
c.prototype.applyStyles=function(f){this.fireBeforeGeometryChanged();if(!this.isRendered()){return;}if(this.isVisible()){var g=this.getGeometry(true);if(g&&g.visible){this._setSize(this.$(),g);var r=this._getRenderingParent();if(!this.isRoot()){var p=[];this.getParent()._oScrollbarSynchronizers.forEach(function(s){if(s._bSyncing){p.push(new Promise(function(R){s.attachEventOnce('synced',R);}));}});if(p.length){Promise.all(p).then(function(){this._applySizes(g,r,f);this.fireGeometryChanged();}.bind(this));}else{this._applySizes(g,r,f);}}else{this._applySizes(g,r,f);}}else{this.$().css("display","none");}}else{this.$().css("display","none");}if(!p||!p.length){this.fireGeometryChanged();}};
c.prototype._applySizes=function(g,r,f){this._setPosition(this.$(),g,r,f);if(g.domRef){this._setZIndex(g,this.$());}this.getChildren().forEach(function(C){C.applyStyles(f);});};
c.prototype._setZIndex=function(g,$){var d=g.domRef;var z=D.getZIndex(d);if(U.isInteger(z)){$.css("z-index",z);}else if(this.isRoot()){this._iZIndex=this._iZIndex||Z.getZIndexBelowPopups();$.css("z-index",this._iZIndex);}};
c.prototype._setSize=function(t,g){t.css("display","block");var s=g.size;t.css("width",s.width+"px");t.css("height",s.height+"px");};
c.prototype._setPosition=function(t,g,p){var P=D.getOffsetFromParent(g,p?p.get(0):null);t.css("transform","translate("+P.left+"px, "+P.top+"px)");};
c.prototype.attachBrowserEvent=function(e,h,l){if(e&&(typeof(e)==="string")){if(typeof h==="function"){if(!this._aBindParameters){this._aBindParameters=[];}l=l||this;var p=h.bind(l);this._aBindParameters.push({sEventType:e,fnHandler:h,oListener:l,fnProxy:p});this.$().on(e,p);}}return this;};
c.prototype.detachBrowserEvent=function(e,h,l){if(e&&(typeof(e)==="string")){if(typeof(h)==="function"){var $=this.$(),i,p;l=l||this;if(this._aBindParameters){for(i=this._aBindParameters.length-1;i>=0;i--){p=this._aBindParameters[i];if(p.sEventType===e&&p.fnHandler===h&&p.oListener===l){this._aBindParameters.splice(i,1);$.unbind(e,p.fnProxy);}}}}}return this;};
c.prototype._deleteDummyContainer=function(t,T){var d=t.find(">.sapUiDtDummyScrollContainer");if(d.length){d.remove();this._oScrollbarSynchronizers.get(t.get(0)).destroy();this._oScrollbarSynchronizers.delete(t.get(0));if(T._oScrollbarSynchronizers.size===0&&!T.getChildren().some(function(A){return A._oScrollbarSynchronizers.size>0;})){T.removeStyleClass("sapUiDtOverlayWithScrollBar");T.removeStyleClass("sapUiDtOverlayWithScrollBarVertical");T.removeStyleClass("sapUiDtOverlayWithScrollBarHorizontal");}}};
c.prototype._handleOverflowScroll=function(g,t,T,f){var d=g.domRef;var s=g.size;var e=D.getOverflows(d);t.css("overflow-x",e.overflowX);t.css("overflow-y",e.overflowY);var i=d.scrollHeight;var h=d.scrollWidth;if(i>Math.ceil(s.height)||h>Math.ceil(s.width)){var j=t.find("> .sapUiDtDummyScrollContainer");var k;if(!j.length){j=q("<div/>",{css:{height:i+"px",width:h+"px"}});j=q("<div class='sapUiDtDummyScrollContainer' style='height: "+i+"px; width: "+h+"px;'></div>");if(T&&D.hasVerticalScrollBar(d)&&T._hasSameSize(g,'height')){T.addStyleClass("sapUiDtOverlayWithScrollBar");T.addStyleClass("sapUiDtOverlayWithScrollBarVertical");}if(T&&D.hasHorizontalScrollBar(d)&&T._hasSameSize(g,'width')){T.addStyleClass("sapUiDtOverlayWithScrollBar");T.addStyleClass("sapUiDtOverlayWithScrollBarHorizontal");}t.append(j);k=new S({synced:this.fireScrollSynced.bind(this)});k.addTarget(d,t.get(0));this._oScrollbarSynchronizers.set(t.get(0),k);}else{j.css({height:i,width:h});k=this._oScrollbarSynchronizers.get(t.get(0));if(!k.hasTarget(d)){k.addTarget(d);}}if(f){k.sync(d,true);}}else{this._deleteDummyContainer(t,T);}};
c.prototype.getGeometry=function(f){if(f||!this._mGeometry){var d=this.getAssociatedDomRef();var C;if(d){var i=this.isRoot();C=q.makeArray(d).map(function($){return D.getGeometry($,i);});}else{C=this.getChildren().map(function(e){return e.getGeometry(true);});}if(C.length){this._mGeometry=C.length>1?O.getGeometry(C):C[0];}else{delete this._mGeometry;}}return this._mGeometry;};
c.prototype.setVisible=function(v){v=!!v;if(this.getVisible()!==v){this.setProperty("visible",v);this.fireVisibleChanged({visible:v});}};
c.prototype.isVisible=function(){return(this.getVisible()&&(this.isRoot()?true:this.getParent().isVisible()));};
c.prototype.setIsRoot=function(v){v=!!v;if(this.getIsRoot()!==v){this.setProperty('isRoot',v);this.fireIsRootChanged({value:v});}};
c.prototype.isRoot=function(){return this.getIsRoot();};
c.prototype.getShouldBeDestroyed=function(){return this._bShouldBeDestroyed;};
return c;},true);
sap.ui.predefine('sap/ui/dt/OverlayRegistry',["sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/Util"],function(M,E,U){"use strict";var O={};var S='sap.ui.dt.ElementOverlay';var a='sap.ui.dt.AggregationOverlay';var o={};var A={};
O.getOverlay=function(e){var I=(typeof e==="string"?e:E.getElementInstance(e)&&E.getElementInstance(e).getId());return o[I]||A[I];};
O.getOverlays=function(){return U.objectValues(o);};
O.register=function(b){if(!i(b)){var l='sap.ui.dt.OverlayRegistry#register';var e=new Error(l+' / Attempt to register illegal overlay');e.name=l;throw e;}o[b.getId()]=b;if(b.getMetadata().getName()===S){A[b.getAssociation('element')]=b;}};
O.deregister=function(b){if(!i(b)){var l='sap.ui.dt.OverlayRegistry#deregister';var e=new Error(l+' / Attempt to deregister illegal overlay');e.name=l;throw e;}delete o[b.getId()];if(b.getMetadata().getName()===S){delete A[b.getAssociation('element')];}};
O.hasOverlays=function(){return!jQuery.isEmptyObject(o);};
function i(b){return(b instanceof M&&[S,a].indexOf(b.getMetadata().getName())>-1);}
return O;},true);
sap.ui.predefine('sap/ui/dt/Plugin',["sap/ui/base/ManagedObject"],function(M){"use strict";
var P=M.extend("sap.ui.dt.Plugin",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{designTime:{type:"object",multiple:false},busy:{type:"boolean",defaultValue:false}},events:{processingStatusChange:{parameters:{processing:{type:"boolean"}}}}}});
P.prototype._bProcessingCounter=0;
P.prototype.init=function(){};
P.prototype.exit=function(){this.setDesignTime(null);};
P.prototype.setDesignTime=function(d){var o=this.getDesignTime();if(o){this._deregisterOverlays(o);}this.setProperty("designTime",d);if(d){this._registerOverlays(d);}return this;};
P.prototype._registerOverlays=function(d){if(this.registerElementOverlay||this.registerAggregationOverlay){var e=d.getElementOverlays();this.setProcessingStatus(true);e.forEach(this.callElementOverlayRegistrationMethods.bind(this));this.setProcessingStatus(false);}};
P.prototype._deregisterOverlays=function(d){if(this.deregisterElementOverlay||this.deregisterAggregationOverlay){var o=d.getElementOverlays();o.forEach(this._callElementOverlayDeregestrationMethods.bind(this));}};
P.prototype.callAggregationOverlayRegistrationMethods=function(e){if(this.registerAggregationOverlay){var a=e.getAggregationOverlays();a.forEach(this.registerAggregationOverlay.bind(this));}};
P.prototype.callElementOverlayRegistrationMethods=function(e){if(this.registerElementOverlay){this.registerElementOverlay(e);}this.callAggregationOverlayRegistrationMethods(e);};
P.prototype._callElementOverlayDeregestrationMethods=function(e){if(this.deregisterElementOverlay){this.deregisterElementOverlay(e);}if(this.deregisterAggregationOverlay){var a=e.getAggregationOverlays();a.forEach(this.deregisterAggregationOverlay.bind(this));}};
P.prototype._onElementOverlayCreated=function(e){var o=e.getParameter("elementOverlay");this.callElementOverlayRegistrationMethods(o);};
P.prototype.getMenuItems=function(){return[];};
P.prototype.getActionName=function(){};
P.prototype.isBusy=P.prototype.getBusy;
P.prototype.setProcessingStatus=function(p){this._bProcessingCounter=p?this._bProcessingCounter+1:this._bProcessingCounter-1;if((p===true&&this._bProcessingCounter===1)||(p===false&&this._bProcessingCounter===0)){this.fireProcessingStatusChange({processing:p});}};
P.prototype.getAction=function(o){return o.getDesignTimeMetadata()?o.getDesignTimeMetadata().getAction(this.getActionName(),o.getElement()):null;};
P.prototype.getSelectedOverlays=function(){return this.getDesignTime().getSelectionManager().get();};
P.prototype.getActionText=function(o,a,p){var n=a.name;var e=o.getElement();if(n){if(typeof n==="function"){return n.call(null,e);}return o.getDesignTimeMetadata()?o.getDesignTimeMetadata().getLibraryText(e,n):"";}return sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText(p);};
P.prototype.isAvailable=function(){return false;};
P.prototype.handler=function(){};
P.prototype.isEnabled=function(){return false;};
P.prototype._getMenuItems=function(e,p){var E=e[0];var a=this.getAction(E);if(!a||!this.isAvailable(e)){return[];}return[{id:p.pluginId,text:this.getActionText(E,a,p.pluginId),handler:this.handler.bind(this),enabled:this.isEnabled.bind(this),rank:p.rank,icon:p.icon,group:p.group}];};
return P;},true);
sap.ui.predefine('sap/ui/dt/ScrollbarSynchronizer',["sap/ui/base/ManagedObject","sap/ui/dt/DOMUtil","sap/ui/thirdparty/jquery"],function(M,D,q){"use strict";
var S=M.extend("sap.ui.dt.ScrollbarSynchronizer",{
metadata:{library:"sap.ui.dt",properties:{scrollTop:{type:"float"},scrollLeft:{type:"float"},targets:{type:"any[]",defaultValue:[]}},events:{synced:{}}},
_bSyncing:false,
constructor:function(){this._scrollEventHandler=this._scrollEventHandler.bind(this);M.apply(this,arguments);}
});
S.prototype.getTargets=function(){return this.getProperty('targets').slice(0);};
S.prototype.setTargets=function(t){var T=Array.isArray(t)?t:[t];this.getTargets().forEach(this.removeTarget.bind(this));this.addTarget.apply(this,T);};
S.prototype.removeTarget=function(d){this._detachScrollEvent(d);this.setProperty('targets',this.getTargets().filter(function(t){return t!==d;}));};
S.prototype.addTarget=function(){var t=Array.prototype.slice.call(arguments);if(!t.length){return;}this._removeDeadNodes();t.forEach(this._attachScrollEvent,this);var n=this.getTargets().concat(t);this.setProperty('targets',n);this.sync(n[0]);};
S.prototype.hasTarget=function(d){return this.getTargets().indexOf(d)>-1;};
S.prototype._removeDeadNodes=function(){this.getTargets().forEach(function(d){if(!document.body.contains(d)){this.removeTarget(d);}},this);};
S.prototype._attachScrollEvent=function(d){q(d).on("scroll",this._scrollEventHandler);};
S.prototype._detachScrollEvent=function(d){q(d).off("scroll",this._scrollEventHandler);};
S.prototype._scrollEventHandler=function(e){this.sync(e.target);};
S.prototype.sync=function(s,f){if(f||this.getScrollTop()!==s.scrollTop||this.getScrollLeft()!==s.scrollLeft){this.setScrollTop(s.scrollTop);this.setScrollLeft(s.scrollLeft);if(!this._bSyncing){this._bSyncing=true;this.animationFrame=window.requestAnimationFrame(function(){this.getTargets().filter(function(d){return s!==d;}).forEach(function(d){D.syncScroll(s,d);});this.fireSynced();this._bSyncing=false;}.bind(this));}}};
S.prototype.destroy=function(){this.getTargets().forEach(function(d){this.removeTarget(d);},this);M.prototype.destroy.apply(this,arguments);};
S.prototype.isSyncing=function(){return this._bSyncing;};
return S;},true);
sap.ui.predefine('sap/ui/dt/SelectionManager',["sap/ui/base/ManagedObject","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/dt/SelectionMode","sap/ui/dt/ElementOverlay","sap/base/util/includes"],function(M,O,U,S,E,i){"use strict";
var a=M.extend("sap.ui.dt.SelectionManager",{metadata:{events:{change:{parameters:{selection:{type:"sap.ui.dt.ElementOverlay[]"}}}}}});
function g(o){return U.castArray(o).map(function(b){if(b instanceof E){return b;}var e=O.getOverlay(b);if(e){return e;}}).filter(function(e,I,b){return e&&b.indexOf(e)===I;});}
function s(e){return e.every(function(o){return o.isSelectable();});}
a.prototype.init=function(){this._aSelection=[];this._aValidators=[];this.addValidator(s);};
a.prototype.exit=function(){delete this._aSelection;delete this._aValidators;};
a.prototype.getSelectionMode=function(){return this._aSelection.length>1?S.Multi:S.Single;};
a.prototype.get=function(){return this._aSelection.slice();};
a.prototype.set=function(o){var e=g(o);var r=false;if(this._validate(e)){var b=this.get().filter(function(c){return!i(e,c);});r=this._remove(b)||r;r=this._add(e)||r;if(r){this.fireChange({selection:this.get()});}}return r;};
a.prototype._validate=function(e){return this.getValidators().every(function(v){return v(e);});};
a.prototype._add=function(e){var c=this.get();e=e.filter(function(o){return!i(c,o);});if(e.length){var n=c.concat(e);if(this._validate(n)){this._aSelection=n;e.forEach(function(o){o.setSelected(true);},this);return true;}}return false;};
a.prototype.add=function(o){if(this._add(g(o))){this.fireChange({selection:this.get()});return true;}return false;};
a.prototype._remove=function(e){var c=this.get();var n=c.filter(function(o){return!i(e,o);});if(n.length!==c.length){this._aSelection=n;e.forEach(function(o){o.setSelected(false);});return true;}return false;};
a.prototype.remove=function(o){if(this._remove(g(o))){this.fireChange({selection:this.get()});return true;}return false;};
a.prototype.reset=function(){return this.remove(this.get());};
a.prototype.addValidator=function(v){if(typeof v==="function"&&!i(this._aValidators,v)){this._aValidators=this._aValidators.concat(v);}};
a.prototype.removeValidator=function(v){this._aValidators=this._aValidators.filter(function(c){return v!==c;});};
a.prototype.getValidators=function(){return this._aValidators.slice();};
return a;});
sap.ui.predefine('sap/ui/dt/SelectionMode',function(){"use strict";return{Multi:"Multi",Single:"Single"};},true);
sap.ui.predefine('sap/ui/dt/TaskManager',["sap/ui/base/ManagedObject","sap/base/util/isPlainObject"],function(M,i){"use strict";
var T=M.extend("sap.ui.dt.TaskManager",{
metadata:{library:"sap.ui.dt",properties:{suppressEvents:{type:"boolean",defaultValue:false}},events:{add:{parameters:{taskId:"int"}},complete:{parameters:{taskId:"array"}}}},
constructor:function(){M.apply(this,arguments);this._aList=[];},
_iNextId:0
});
T.prototype._validateTask=function(t){if(!i(t)||!t.type){throw new Error('Invalid task specified');}};
T.prototype.add=function(t){this._validateTask(t);var a=this._iNextId++;this._aList.push(Object.assign({},t,{id:a}));if(!this.getSuppressEvents()){this.fireAdd({taskId:a});}return a;};
T.prototype.complete=function(t){this._aList=this._aList.filter(function(m){return m.id!==t;});if(!this.getSuppressEvents()){this.fireComplete({taskId:[t]});}};
T.prototype.completeBy=function(t){this._validateTask(t);var c=[];this._aList=this._aList.filter(function(l){var C=Object.keys(t).every(function(k){return l[k]&&l[k]===t[k];});if(C){c.push(l.id);return false;}return true;});if(!this.getSuppressEvents()){this.fireComplete({taskId:c});}};
T.prototype.cancel=function(t){this.complete(t);};
T.prototype.isEmpty=function(){return this.count()===0;};
T.prototype.count=function(){return this._aList.length;};
T.prototype.getList=function(){return this._aList.slice(0);};
T.prototype.destroy=function(){this.setSuppressEvents(true);this.getList().forEach(function(t){this.cancel(t.id);},this);};
return T;});
sap.ui.predefine('sap/ui/dt/Util',["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/base/ManagedObject","sap/base/util/includes","sap/base/util/isPlainObject","sap/ui/dt/DesignTimeStatus"],function(q,D,M,a,b,c){"use strict";var U={};var S='sap.ui.dt';
U.wrapError=function(e){var E=e instanceof Error&&e||new Error();if(typeof e==='string'){E.message=e;}return E;};
U.isForeignError=function(e,l){if(e instanceof Error){return e.name.indexOf(l||S)===-1;}throw U.createError('Util#isForeignError','Wrong parameter specified');};
U.createError=function(l,m,L){var e=new Error();var s=(L||S)+(l?'.'+l:'');e.name='Error in '+s;e.message=m;return e;};
U.errorToString=function(e){if(typeof e==='string'){return e;}else if(e instanceof Error){var E=e.toString();if(e.stack){E+='\n'+e.stack.replace(E,'').trim();}return E;}throw U.createError('Util#errorToString','Wrong parameter specified');};
U.propagateError=function(e,l,m,L){var E=U.wrapError(e);if(U.isForeignError(E,L)){var s=(L||S)+'.'+l;var o=[E.name,E.message].join(" - ");E.name='Error in '+s;E.message=U.printf('{0}. Original error: {1}',m,o||'¯\\_(ツ)_/¯');}return E;};
U.getObjectType=function(o){return((o instanceof M&&U.printf('{0} (id = "{1}")',o.getMetadata().getName(),o.getId()))||typeof o);};
U.printf=function(s){var A=Array.prototype.slice.call(arguments,1);return s.replace(/{(\d+)}/g,function(m,i){return typeof A[i]!=='undefined'?A[i]:m;});};
U.curry=function(o){var A=o.length;var r=function(){var d=Array.prototype.slice.call(arguments);if(d.length>=A){return o.apply(this,d);}return function(){return r.apply(this,d.concat(Array.prototype.slice.call(arguments)));};};return r;};
U.objectValues=function(o){return q.map(o,function(v){return v;});};
U.intersection=function(A,d){return A.filter(function(v){return d.indexOf(v)>-1;});};
U.isInteger=function(v){return q.isNumeric(v)&&Math.ceil(v)===v;};
U.castArray=function(v){var r=[];if(v){if(!Array.isArray(v)){r.push(v);}else{r=v;}}return r;};
U.wrapIntoPromise=function(h){if(!q.isFunction(h)){throw U.createError("Util#wrapIntoPromise",U.printf("Invalid argument specified. Function is expected, but '{0}' is given",typeof h),"sap.ui.dt");}return function(){var A=Array.prototype.slice.call(arguments);return Promise.resolve().then(function(){return h.apply(null,A);});};};
U.isWebkit=function(){return D.browser.webkit&&(D.browser.safari||D.browser.chrome&&D.browser.mobile);};
U.pick=function(s,p){s=b(s)?s:{};var P=(Array.isArray(p)?p:(arguments.length>1?[p]:[]));P=P.map(function(v){return String(v);});return Object.keys(s).reduce(function(r,d){if(a(P,d)){r[d]=s[d];}return r;},{});};
U.debounce=function(f,w){w=w||0;var t;return function(){if(t){clearTimeout(t);}t=setTimeout(f,w);};};
U.waitForSynced=function(d,o){return function(){o=o||function(){};var A=arguments;return new Promise(function(r,R){if(d.getStatus()===c.SYNCING){d.attachEventOnce("synced",function(){r(o.apply(null,A));});d.attachEventOnce("syncFailed",R);}else{r(o.apply(null,A));}});};};
U.max=function(s){if(Array.isArray(s)&&s.length>0){var r=s[0];for(var i=1,l=s.length;i<l;i++){if(s[i]>r){r=s[i];}}return r;}};
return U;},true);
sap.ui.predefine('sap/ui/dt/enablement/ElementEnablementTest',["sap/ui/thirdparty/jquery","sap/ui/dt/enablement/Test","sap/ui/dt/DesignTime","sap/ui/dt/enablement/Util","sap/base/util/ObjectPath","sap/ui/dt/ElementOverlay","sap/ui/qunit/utils/waitForThemeApplied","sap/ui/thirdparty/sinon-4"],function(q,T,D,E,O,a,w,s){"use strict";
var b=T.extend("sap.ui.dt.test.ElementEnablementTest",{metadata:{library:"sap.ui.dt",properties:{type:{type:"string"},create:{type:"any"},timeout:{type:"int",defaultValue:0},groupPostfix:{type:"string"}}}});
var S=0;var m;
b.prototype.init=function(){this._aAggregatedTestResult=null;this._aAggregatedInfoResult=null;this._sAggregation=null;this._$TestAreaDomRef=null;if(S===0){m=s.stub(a.prototype,"_subscribeToMutationObserver");}S++;};
b.prototype.exit=function(){if(this._oDesignTime){this._oDesignTime.destroy();}S--;if(S===0){m.restore();}window.clearTimeout(this._iTimeout);this._oElement.destroy();if(this._$TestAreaDomRef){this._$TestAreaDomRef.remove();delete this._$TestAreaDomRef;}};
b.prototype.run=function(){return this._setup().then(function(){this._mResult=this.createSuite("Element Enablement Test");var e=this.addGroup(this._mResult.children,this.getType(),"Given that a DesignTime is created for "+this.getType());this._testAggregations(e.children);this._mResult=this.aggregate(this._mResult);return this._mResult;}.bind(this));};
b.prototype._createElement=function(){var t=this.getType();var c=this.getCreate();var d=O.get(t||"");var e;if(c){e=c();}else{e=new d();}if(e.addStyleClass){e.addStyleClass("minSize");}return e;};
b.prototype._getTestArea=function(){if(!this._$TestAreaDomRef){this._$TestAreaDomRef=q("<div id='"+this.getId()+"--testArea"+"'></div>").css({height:"500px",width:"1000px"}).appendTo("body");}return this._$TestAreaDomRef;};
b.prototype._setup=function(){window.clearTimeout(this._iTimeout);this._bNoRenderer=false;this._bErrorDuringRendering=false;return new Promise(function(r){w().then(function(){this._oElement=this._createElement();try{this._oElement.getRenderer();}catch(e){this._bNoRenderer=true;}if(!this._bNoRenderer){try{this._oElement.placeAt(this._getTestArea().get(0));sap.ui.getCore().applyChanges();}catch(e){this._bErrorDuringRendering=true;}if(!this._bErrorDuringRendering){this._oDesignTime=new D({rootElements:[this._oElement]});this._oDesignTime.attachEventOnce("synced",function(){if(this.getTimeout()){this._iTimeout=window.setTimeout(function(){r();},this.getTimeout());}else{r();}},this);}else{r();}}else{r();}}.bind(this));}.bind(this));};
b.prototype._testAggregations=function(t){var A=this.addGroup(t,"Aggregations","Each aggregation needs to be ignored or has a visible domRef maintained in the metadata",this.getGroupPostfix());if(this._bNoRenderer){this.addTest(A.children,true,"Control has no renderer","Control has no renderer, not supported by the element test (requires a special element test)",T.STATUS.UNKNOWN);}else if(this._bErrorDuringRendering){this.addTest(A.children,true,"Error during rendering","Element can't be rendered, not supported by the DesignTime (please, provide a create method for this element)",T.STATUS.ERROR);}else{var c=E.getAggregationsInfo(this._oElement);for(var d in c){var e=c[d];var f=this.addGroup(A.children,d,(e.ignored?"Aggregation ignored":"Aggregation tests"));if(!e.ignored){this.addTest(f.children,e.overlayVisible,"Overlay Visible","Overlay domRef is visible in DOM");if(e.domRefDeclared){this.addTest(f.children,e.domRefDeclared,"Dom Ref Declared","DomRef is declared in design time metadata");this.addTest(f.children,e.domRefFound,"Dom Ref Found","Declared DomRef is found in DOM");this.addTest(f.children,e.domRefVisible,"Dom Ref Visible","Declared DomRef is visible");}else if(e.overlayVisible){this.addTest(f.children,e.overlayGeometryCalculatedByChildren,"Overlay Geometry calculated by children","Control might work based on DT Heuristic, but safer with domRefDeclared",T.STATUS.PARTIAL_SUPPORTED);}else{this.addTest(f.children,false,"Overlay Dom Ref","Overlay domRef is not declared and aggregation overlay is not visible (please, declare domRef for this aggregation)",T.STATUS.PARTIAL_SUPPORTED);}if(e.overlayTooSmall){this.addTest(f.children,false,"Overlay too small","Aggregation Overlay is too small to be accessible, please ensure to render it big enough that it can be reach by a user. If content is needed, provide a create method for this element",T.STATUS.PARTIAL_SUPPORTED);}}}}};
return b;});
sap.ui.predefine('sap/ui/dt/enablement/Test',["sap/ui/base/ManagedObject"],function(M){"use strict";
var T=M.extend("sap.ui.dt.test.Test",{metadata:{"abstract":true}});
T.STATUS={SUPPORTED:{key:"SUPPORTED",text:"supported",value:3},PARTIAL_SUPPORTED:{key:"PARTIAL_SUPPORTED",text:"partial supported",value:2},NOT_SUPPORTED:{key:"NOT_SUPPORTED",text:"not supported",value:1},ERROR:{key:"ERROR",text:"error",value:0},UNKNOWN:{key:"UNKNOWN",text:"unknown",value:0}};T.TYPE={TEST:"Test",GROUP:"Group",SUITE:"Suite"};
T.prototype.createSuite=function(n,m){return this.add(null,false,n,m,null,T.TYPE.SUITE);};
T.prototype.addGroup=function(p,n,m,N){return this.add(p,true,n+(N?(" ("+N+")"):""),m,null,T.TYPE.GROUP);};
T.prototype.addTest=function(p,r,n,m,s){return this.add(p,r,n,m,s,T.TYPE.TEST);};
T.prototype.add=function(p,r,n,m,s,t){if(!s){if(r){s=T.STATUS.SUPPORTED;}else{s=T.STATUS.NOT_SUPPORTED;}}var e={name:n,message:m,result:r,status:s,type:t,statistic:{},children:[]};if(p){p.push(e);}return e;};
T.prototype.run=function(){throw new Error("Abstract method");};
T.prototype.aggregate=function(r){if(r.type!==T.TYPE.TEST&&r.children.length>0){var c=r.children;var m=c.map(function(e){var C=this.aggregate(e);return{result:C.result,status:C.status};},this);if(m.length===1){m.push(m[0]);}var R=m.reduce(function(p,C){return{result:this._getResult(p,C),status:this._getStatus(p,C),statistic:this._getStatistic(p,C)};}.bind(this));r.result=R.result;r.status=R.status;r.statistic=R.statistic;}return r;};
T.prototype._getResult=function(p,c){return!p.result?false:c.result;};
T.prototype._getStatus=function(p,c){return p.status.value<c.status.value?p.status:c.status;};
T.prototype._getStatistic=function(p,c){var s=this._getStatisticObjectForEntry(p);if(p!==c){s[c.status.key]++;}return s;};
T.prototype._getStatisticObjectForEntry=function(e){var s={};if(!e.statistic){for(var S in T.STATUS){s[S]=0;}s[e.status.key]++;}else{s=e.statistic;}return s;};
return T;},true);
sap.ui.predefine('sap/ui/dt/enablement/Util',["sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayRegistry"],function(E,D,O){"use strict";var M=5;var a={};
a.getInfo=function(e){var m=e.getMetadata();var o=O.getOverlay(e);return{metadata:m,overlay:o};};
a.getAggregationInfo=function(e,A){var m={ignored:true,domRefDeclared:false,domRefFound:false,domRefVisible:false,overlayTooSmall:false,overlayGeometryCalculatedByChildren:false,overlayVisible:false};var d;var b=this.getInfo(e);var o=b.overlay.getAggregationOverlay(A);if(o){d=o.getDesignTimeMetadata();}if(d&&!d.isIgnored(e)){m.ignored=false;m.domRefDeclared=!!d.getDomRef();var $=o.getAssociatedDomRef();if($){m.domRefFound=true;m.domRefVisible=D.isVisible($.get(0));}var g=o.getGeometry();if(g){var s=g.size;m.overlayTooSmall=(s.width<=M||s.height<=M);m.overlayGeometryCalculatedByChildren=!g.domRef;m.overlayVisible=g.visible;}}return m;};
a.getAggregationsInfo=function(e){var A={};E.iterateOverAllPublicAggregations(e,function(o){A[o.name]=this.getAggregationInfo(e,o.name);}.bind(this));return A;};
return a;},true);
sap.ui.predefine('sap/ui/dt/enablement/elementDesigntimeTest',["sap/ui/dt/enablement/report/QUnitReport","sap/ui/dt/enablement/ElementEnablementTest"],function(Q,E){"use strict";var e=function(p){var o=new E(p);return o.run().then(function(d){var q=new Q({data:d});o.destroy();q.destroy();});};return e;});
sap.ui.predefine('sap/ui/dt/enablement/libraryTest',["sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel","sap/ui/thirdparty/jquery"],function(R,J,q){"use strict";var d=[],m=[],b={},l;
function h(k,B){return B.hasText(k)||B.getText(k,[],true)!==undefined;}
var L=function(t){return new Promise(function(r){sap.ui.getCore().loadLibraries([t]).then(function(){var c=sap.ui.getCore().getLoadedLibraries()[t],E=c.controls.concat(c.elements);l=t;sap.ui.require(E.map(function(s){return q.sap.getResourceName(s,"");}),function(){var f=sap.ui.getCore().getLoadedLibraries();try{var g=new R({bundleUrl:sap.ui.resource(t,"messagebundle.properties"),bundleLocale:"en"}),D=new R({bundleUrl:sap.ui.resource(t+".designtime","messagebundle.properties"),bundleLocale:"en"});b.runtime=g.getResourceBundle();b.designtime=D.getResourceBundle();Object.keys(f).forEach(function(s){if(t!==s){g.enhance({bundleUrl:sap.ui.resource(s,"messagebundle.properties"),bundleLocale:"en"});D.enhance({bundleUrl:sap.ui.resource(s+".designtime","messagebundle.properties"),bundleLocale:"en"});}});}catch(e){}var j=[],C=[];for(var i=0;i<arguments.length;i++){if(arguments[i].getMetadata()._oDesignTime){j.push(arguments[i].getMetadata().loadDesignTime());C.push(arguments[i].getMetadata());}}Promise.all(j).then(function(E){var i=0;d=E;m=d.map(function(o){var k=new J(o);k._oControlMetadata=C[i];i++;return k;});a();r();});});});});};L.version=2.0;var M={"/":{optional:false,check:function(c,o,C){c.strictEqual(typeof o,"object",C+" is an object");}},"/designtimeModule":{optional:false,check:function(c,s,C){c.strictEqual(typeof s,"string",C+" defines /designtimeModule : "+s);}},"/actions":{optional:true,check:function(c,A,C){Object.keys(A).forEach(function(s){if(A[s].changeType){c.strictEqual(typeof A[s].changeType,"string",C+" defines "+s+" with changetype:"+A[s].changeType);}else if(typeof A[s]==="string"){c.strictEqual(typeof A[s],"string",C+" defines "+s+" as string");}else{c.strictEqual(typeof A[s],"function",C+" defines "+s+" as function");}});}},"/name":{optional:true,check:function(c,e,C){if(typeof e==="string"&&e.indexOf("{")===0&&e.indexOf("}")===e.length-1){return true;}var k=["singular","plural"];k.forEach(function(K){if(typeof e[K]==="function"){c.strictEqual(typeof e[K],"function",C+" defines mandatory entry /name/"+K);}else{c.strictEqual(typeof e[K],"string",C+" defines mandatory entry /name/"+K);}});k.forEach(function(K){var D=false;if(typeof e[K]==="function"){c.strictEqual(typeof e[K],"function",C+" defines function for translation of entry /name/"+K);c.strictEqual(typeof e[K](),"string","Assuming that "+K+" with "+e[K].toString()+" returns a translation at runtime");return;}if(e[K].toUpperCase()!==e[K]){c.ok(true,"Assuming that "+K+" with "+e[K]+" needs currently no translation");return;}if(b.designtime){D=h(e[K],b.designtime);c.strictEqual(D,true,e[K]+" found in designtime message bundle");}if(b.runtime){if(D){c.strictEqual(h(e[K],b.runtime),false,e[K]+" found in runtime message bundle and designtime message bundle, please delete the entry from the runtime message bundle (messagebundle.properties + messagebundle_en.properties)");}else{c.strictEqual(h(e[K],b.runtime),true,e[K]+" found in runtime message bundle only, consider to move this text to the designtime message bundle");}}});}},"/palette":{optional:true,check:function(c,e,C){var v=["ACTION","DISPLAY","LAYOUT","LIST","INPUT","CONTAINER","CHART","TILE","DIALOG"];c.strictEqual(typeof e,"object",C+" defines optional entry /palette/");c.strictEqual(v.indexOf(e.group)>-1,true,"palette entry defines valid group "+e.group);if(e.icons){Object.keys(e.icons).forEach(function(k){var i=e.icons[k];c.strictEqual(typeof i,"string","palette/icons/"+k+" entry defines icon path "+i);var r=q.sap.sjax({url:sap.ui.require.toUrl(i)+""});c.ok(r.status==="success","File "+i+" does exist. Check entry palette/icons/"+k);if(i.indexOf(".svg")===i.length-4){c.ok(r.data.documentElement&&r.data.documentElement.tagName==="svg","File "+i+" starts with a svg node");}});}}},"/templates":{optional:true,check:function(c,e){if(e.create){var C=e.create;c.strictEqual(typeof C,"string","templates/create entry defines fragment path to "+C);var D=q.sap.sjax({url:sap.ui.require.toUrl(C)+""});c.ok(D.data.documentElement&&D.data.documentElement.localName==="FragmentDefinition","File "+C+" exists and starts with a FragmentDefinition node");}}}};
function a(){QUnit.test("Checking library.designtime.js",function(c){var e=sap.ui.getCore().getLoadedLibraries()[l];if(e.designtime){var f=c.async();sap.ui.require([e.designtime],function(o){c.ok(o!==null,e.designtime+" loaded successfully");f();});}else{c.ok(true,"No library.designtime.js "+l);}});QUnit.test("Checking loaded designtime data",function(c){d.forEach(function(D){c.strictEqual(D!==null,true,"Designtime data found and loaded successful");c.strictEqual(typeof D,"object","Designtime data returned an object");});});m.forEach(function(o){var c=o._oControlMetadata,C=c.getName();QUnit.test(C+": Checking entries in designtime data",function(e){Object.keys(M).forEach(function(p){var f=M[p];var v=o.getProperty(p);if(v===undefined&&!f.optional){e.equal(false,true,C+" does not define mandatory entry "+p);}else if(v!==undefined&&f.optional){e.equal(true,true,C+" does define optional entry "+p);f.check(e,v,C);}else if(v!==undefined&&!f.optional){e.equal(true,true,C+" does define mandatory entry "+p);f.check(e,v,C);}});});});}
return L;},true);
sap.ui.predefine('sap/ui/dt/enablement/report/LibraryReport',["sap/ui/dt/enablement/Test","sap/ui/dt/enablement/ElementEnablementTest"],function(T,E){"use strict";
var L=T.extend("sap.ui.dt.enablement.report.LibraryReport",{metadata:{library:"sap.ui.dt",properties:{libraryName:{type:"string"},testData:{type:"object"}}}});
L.prototype.run=function(){this._aResult=[];var t=this.getTestData()||{};var l=this.getLibraryName();var e=[];var o=sap.ui.getCore().getLoadedLibraries()[l];if(o){var a=o.controls;a.forEach(function(s){var b=t[s];if(!b&&b!==false){b={};}if(b!==false){b.type=s;var c=null;if(b.create){c=Object.assign({},b);delete c.create;b.groupPostfix="with create method";}e.push(new E(b));if(c){e.push(new E(c));}}});}var r=[];var i=function(R){if(R){r.push(R);}var b=e.shift();if(b){return b.run().then(function(R){b.destroy();return i(R);});}return Promise.resolve(r);};return i().then(function(r){var R=this.createSuite("Library Enablement Test");r.forEach(function(m){var c=m.children[0];var p=R.children[R.children.length-1];if(p&&c.name===p.name){p.children=p.children.concat(c.children);}else{R.children.push(c);}});R=this.aggregate(R);return R;}.bind(this));};
return L;});
sap.ui.predefine('sap/ui/dt/enablement/report/QUnitReport',["sap/ui/base/ManagedObject"],function(M){"use strict";
var Q=M.extend("sap.ui.dt.enablement.report.QUnitReport",{
metadata:{library:"sap.ui.dt",properties:{data:{type:"object"}}},
init:function(){if(!QUnit){throw new Error("QUnit is required for this report.");}},
setData:function(d){if(d){var c=d.children;c.forEach(function(g){this._createModule(g);},this);}this.setProperty("data",d);},
_createModule:function(g){QUnit.module(g.message);g.children.forEach(function(g){this._createTest(g);},this);},
_createTest:function(g){QUnit.test(g.name+": "+g.message,function(a){g.children.forEach(function(g){this._createAssertion(a,g);},this);}.bind(this));},
_createAssertion:function(a,g){if(g.children.length>0){g.children.forEach(function(t){a.ok(t.result,g.name+": "+t.message);});}else{a.ok(true,g.name+": "+g.message);}}
});
return Q;});
sap.ui.predefine('sap/ui/dt/enablement/report/Statistic',["sap/ui/core/Control","sap/ui/model/json/JSONModel","sap/ui/layout/form/SimpleForm","sap/m/Label","sap/m/Text"],function(C,J,S,L,T){"use strict";
var s=C.extend("sap.ui.dt.enablement.report.Statistic",{
metadata:{properties:{data:{type:"object"}},aggregations:{_form:{type:"sap.ui.layout.form.SimpleForm",hidden:true,multiple:false}}},
init:function(){this._oModel=null;this.setAggregation("_form",this._createForm());},
exit:function(){this.setData(null);},
setData:function(d){if(this._oModel){this._oModel.destroy();delete this._oModel;}if(d){this._oModel=new J(d);this._getForm().setModel(this._oModel);}else{this._getForm().setModel(null);}this.setProperty("data",d);},
_createForm:function(){var f=new S(this.getId()+"--form",{editable:false,title:"Statistics",content:[new L(this.getId()+"--form-supported-label",{text:"Supported"}),new T(this.getId()+"--form-supported-value",{text:"{/statistic/SUPPORTED}"}),new L(this.getId()+"--form-partial-supported-label",{text:"Partial Supported"}),new T(this.getId()+"--form-partial-supported-value",{text:"{/statistic/PARTIAL_SUPPORTED}"}),new L(this.getId()+"--form-not-supported-label",{text:"Not Supported"}),new T(this.getId()+"--form-not-supported-value",{text:"{/statistic/NOT_SUPPORTED}"}),new L(this.getId()+"--form-unknown-label",{text:"Unknown"}),new T(this.getId()+"--form-unknown-value",{text:"{/statistic/UNKNOWN}"}),new L(this.getId()+"--form-error-label",{text:"Error"}),new T(this.getId()+"--form-error-value",{text:"{/statistic/ERROR}"})]});return f;},
_getForm:function(){return this.getAggregation("_form");}
});
return s;});
sap.ui.predefine('sap/ui/dt/enablement/report/StatisticRenderer',function(){"use strict";var S={};
S.render=function(r,s){r.addClass("sapUiDtStatisticReport");r.write("<div");r.writeControlData(s);r.writeStyles();r.writeClasses();r.write(">");r.renderControl(s._getForm());r.write("</div>");};
return S;});
sap.ui.predefine('sap/ui/dt/enablement/report/Table',["sap/ui/core/Control","sap/ui/model/json/JSONModel","sap/ui/table/TreeTable","sap/ui/table/Column","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/m/SearchField","sap/m/Text","sap/m/RatingIndicator"],function(C,J,T,a,b,c,B,S,d,R){"use strict";
var t=C.extend("sap.ui.dt.enablement.report.Table",{
metadata:{properties:{data:{type:"object"}},aggregations:{_table:{type:"sap.ui.table.TreeTable",hidden:true,multiple:false}}},
init:function(){this.setAggregation("_table",this._createTable());},
exit:function(){clearTimeout(this._iFilterTimeout);this.setData(null);},
setData:function(D){if(this._oModel){this._oModel.destroy();delete this._oModel;}if(D){this._oModel=new J(D);this._getTable().setModel(this._oModel);}else{this._getTable().setModel(null);}this.setProperty("data",D);},
filter:function(f){var m=this._getTable().getModel();if(m){if(f.length>0){var D=this.getData();var F=D.children.filter(function(e){if(f.indexOf("status=")!==-1){return e.status.value===f.substring(f.indexOf("=")+1);}return e.name.toLowerCase().indexOf(f.toLowerCase())!==-1;});m.setData(F);}else{m.setData(this.getData());}}},
_createTable:function(){var t=new T(this.getId()+"--table",{selectionMode:"MultiToggle",visibleRowCount:20,enableSelectAll:false,ariaLabelledBy:"title",toolbar:this._createToolbar(),rows:"{path:'/', parameters: {arrayNames:['children']}}",columns:[this._createTextColumn("name","Name","{name}"),this._createRatingIndicatorColumn("value","Status Values","{status/value}","{status/text} ({status/value})"),this._createTextColumn("status","Status","{status/text}"),this._createTextColumn("message","Message","{message}")]});return t;},
_createToolbar:function(){return new b(this.getId()+"--toolbar",{content:[new c(this.getId()+"--toolbar-spacer"),new B(this.getId()+"--toolbar-collapse-button",{text:"Collapse all",press:this._onCollapseAll.bind(this)}),new B(this.getId()+"--toolbar-expand-button",{text:"Expand",press:this._onExpandSecondLevel.bind(this)}),new S(this.getId()+"--toolbar-search-field",{liveChange:this._onSearch.bind(this)})]});},
_onSearch:function(e){var f=e.getParameter('newValue');clearTimeout(this._iFilterTimeout);this._iFilterTimeout=setTimeout(function(){this.filter(f);}.bind(this),100);},
_createTextColumn:function(i,s,r){return this._createColumn(i,s,new d({text:r}));},
_createRatingIndicatorColumn:function(i,s,r,e){return this._createColumn(i,s,new R({maxValue:3,value:r,enabled:false,tooltip:e}));},
_createColumn:function(i,s,o){return new a(this.getId()+"--table-column-"+i,{label:s,width:"13em",template:o});},
_getTable:function(){return this.getAggregation("_table");},
_onCollapseAll:function(){var t=this._getTable();t.collapseAll();},
_onExpandSecondLevel:function(){var t=this._getTable();t.expandToLevel(2);}
});
return t;});
sap.ui.predefine('sap/ui/dt/enablement/report/TableRenderer',function(){"use strict";var T={};
T.render=function(r,t){r.addClass("sapUiDtTableReport");r.write("<div");r.writeControlData(t);r.writeStyles();r.writeClasses();r.write(">");r.renderControl(t._getTable());r.write("</div>");};
return T;});
sap.ui.predefine('sap/ui/dt/library',["sap/ui/base/ManagedObjectMetadata","sap/ui/dt/SelectionMode","sap/ui/core/library"],function(M){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.dt",version:"1.68.0",dependencies:["sap.ui.core"],types:["sap.ui.dt.SelectionMode"],interfaces:[],controls:[],elements:[]});M.setDesignTimeDefaultMapping({"not-adaptable":"sap/ui/dt/designtime/notAdaptable.designtime","not-removable":"sap/ui/dt/designtime/notRemovable.designtime"});return sap.ui.dt;},true);
sap.ui.predefine('sap/ui/dt/plugin/DragDrop',["sap/ui/base/Object","sap/ui/dt/Plugin","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/OverlayRegistry","sap/ui/thirdparty/jquery","sap/ui/qunit/QUnitUtils"],function(B,P,D,O,a,q){"use strict";
var b=P.extend("sap.ui.dt.plugin.DragDrop",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{},associations:{},events:{}}});
var I=7;var p=false;var o;
b.prototype._preventScrollOnTouch=function(E){if(p){E.preventDefault();}};
b.prototype.init=function(){P.prototype.init.apply(this,arguments);document.addEventListener('touchmove',this._preventScrollOnTouch,true);this._dragScrollHandler=this._dragScroll.bind(this);this._dragLeaveHandler=this._dragLeave.bind(this);this._mScrollIntervals={};};
b.prototype.exit=function(){P.prototype.exit.apply(this,arguments);document.removeEventListener('touchmove',this._preventScrollOnTouch);delete this._mElementOverlayDelegate;delete this._mAggregationOverlayDelegate;delete this._dragScrollHandler;};
b.prototype.registerElementOverlay=function(f){f.attachEvent("movableChange",this._onMovableChange,this);if(f.isMovable()){this._attachDragEvents(f);}f.attachBrowserEvent("dragover",this._onDragOver,this);f.attachBrowserEvent("dragenter",this._onDragEnter,this);f.attachBrowserEvent("dragleave",this._onDragLeave,this);};
b.prototype.registerAggregationOverlay=function(A){A.attachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!sap.ui.Device.browser.webkit){this._attachDragScrollHandler(A);}};
b.prototype.deregisterElementOverlay=function(f){f.detachEvent("movableChange",this._onMovableChange,this);this._detachDragEvents(f);f.detachBrowserEvent("dragover",this._onDragOver,this);f.detachBrowserEvent("dragenter",this._onDragEnter,this);f.detachBrowserEvent("dragleave",this._onDragLeave,this);};
b.prototype.deregisterAggregationOverlay=function(A){A.detachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!sap.ui.Device.browser.webkit){this._removeDragScrollHandler(A);this._clearScrollIntervalFor(A.$().attr("id"));}};
b.prototype._attachDragEvents=function(f){f.attachBrowserEvent("dragstart",this._onDragStart,this);f.attachBrowserEvent("drag",this._onDrag,this);f.attachBrowserEvent("dragend",this._onDragEnd,this);f.attachBrowserEvent("touchstart",this._onTouchStart,this);};
b.prototype._detachDragEvents=function(f){f.detachBrowserEvent("dragstart",this._onDragStart,this);f.detachBrowserEvent("drag",this._onDrag,this);f.detachBrowserEvent("dragend",this._onDragEnd,this);f.detachBrowserEvent("touchstart",this._onTouchStart,this);};
b.prototype.onMovableChange=function(){};
b.prototype.onDragStart=function(){};
b.prototype.onDragEnd=function(){};
b.prototype.onDrag=function(){};
b.prototype.onDragEnter=function(){};
b.prototype.onDragLeave=function(){};
b.prototype.onDragOver=function(){};
b.prototype.onAggregationDragEnter=function(){};
b.prototype.onAggregationDragOver=function(){};
b.prototype.onAggregationDragLeave=function(){};
b.prototype.onAggregationDrop=function(){};
b.prototype._checkMovable=function(f){if(f.isMovable()||D.getDraggable(f.$())!==undefined){D.setDraggable(f.$(),f.isMovable());}};
b.prototype._onMovableChange=function(E){var f=E.getSource();if(f.isMovable()){this._attachDragEvents(f);}else{this._detachDragEvents(f);}this.onMovableChange(f);};
b.prototype._onDragStart=function(E){var f=a.getOverlay(E.currentTarget.id);E.stopPropagation();if(sap.ui.Device.browser.firefox&&E&&E.originalEvent&&E.originalEvent.dataTransfer&&E.originalEvent.dataTransfer.setData){E.originalEvent.dataTransfer.setData('text/plain','');}this.setBusy(true);this.showGhost(f,E);this.onDragStart(f);};
b.prototype._attachTouchDragEvents=function(f){f.attachBrowserEvent("touchmove",this._onTouchMove,this);f.attachBrowserEvent("touchend",this._onTouchEnd,this);};
b.prototype._detachTouchDragEvents=function(f){f.detachBrowserEvent("touchmove",this._onTouchMove,this);f.detachBrowserEvent("touchend",this._onTouchEnd,this);};
b.prototype._onTouchStart=function(E){var t=E.touches[0].pageX;var f=E.touches[0].pageY;var T=a.getOverlay(E.currentTarget.id);function g(){T.detachBrowserEvent("touchmove",i,this);T.detachBrowserEvent("touchend",j,this);T.detachBrowserEvent("contextmenu",j,this);}function h(k,l){var m=t-k;var n=f-l;return Math.sqrt((m*m)+(n*n));}function i(E){var k=E.touches[0].pageX;var l=E.touches[0].pageY;var m=h(k,l);if(m>I){this.onDragStart(T);g.call(this);this._attachTouchDragEvents(T);}}function j(){g.call(this);p=false;}p=true;E.stopPropagation();T.attachBrowserEvent("touchmove",i,this);T.attachBrowserEvent("contextmenu",j,this);T.attachBrowserEvent("touchend",j,this);};
b.prototype._getTargetOverlay=function(E){if(B.isA(E,"sap.ui.dt.Overlay")){var t;if(B.isA(E,"sap.ui.dt.AggregationOverlay")&&E.getTargetZone()){t=E;}else if(B.isA(E,"sap.ui.dt.ElementOverlay")&&O.isInTargetZoneAggregation(E)){t=E;}return t||this._getTargetOverlay(E.getParent());}};
b.prototype._findTargetOverlayFromCoordinates=function(f,g){var h=document.elementFromPoint(f,g);var E=h?sap.ui.getCore().byId(h.id):undefined;return this._getTargetOverlay(E);};
b.prototype._onTouchMove=function(E){var f=a.getOverlay(E.currentTarget.id);this.onDrag(f);var t=E.touches||E.changedTouches;var g=t[0].pageX;var h=t[0].pageY;var T=this._findTargetOverlayFromCoordinates(g,h);if(!T){return;}if(T!==o){if(o){if(B.isA(o,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragLeave(o);}else{this.onDragLeave(o);}}o=T;if(B.isA(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragEnter(T);}else{this.onDragEnter(T);}}if(B.isA(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragOver(T);}else{this.onDragOver(T);}E.stopPropagation();};
b.prototype._getValidTargetZoneAggregationOverlay=function(f){if(B.isA(f,"sap.ui.dt.AggregationOverlay")&&f.getTargetZone()){return f;}return this._getValidTargetZoneAggregationOverlay(f.getParent());};
b.prototype._onTouchEnd=function(E){var f=a.getOverlay(E.currentTarget.id);var A=this._getValidTargetZoneAggregationOverlay(f);if(A){this.onAggregationDrop(A);}this.onDragEnd(f);this._detachTouchDragEvents(f);o=undefined;p=false;};
b.prototype.showGhost=function(f,E){if(E&&E.originalEvent&&E.originalEvent.dataTransfer){E.originalEvent.dataTransfer.effectAllowed="move";E.originalEvent.dataTransfer.dropEffect="move";if(!sap.ui.Device.browser.msie&&!sap.ui.Device.browser.edge&&!sap.ui.Device.browser.msie&&E.originalEvent.dataTransfer.setDragImage){this._$ghost=this.createGhost(f,E);this._$ghost.appendTo("#overlay-container");setTimeout(function(){this._removeGhost();}.bind(this),0);E.originalEvent.dataTransfer.setDragImage(this._$ghost.get(0),E.originalEvent.pageX-f.$().offset().left,E.originalEvent.pageY-f.$().offset().top);}}};
b.prototype._removeGhost=function(){this.removeGhost();delete this._$ghost;};
b.prototype.removeGhost=function(){var $=this.getGhost();if($){$.remove();}};
b.prototype.createGhost=function(f){var g=f.getAssociatedDomRef();var $;if(!g){g=this._getAssociatedDomCopy(f);$=g;}else{$=q("<div></div>");q.makeArray(g).forEach(function(n){D.cloneDOMAndStyles(n,$);});}var h=q("<div></div>").addClass("sapUiDtDragGhostWrapper");return h.append($.addClass("sapUiDtDragGhost"));};
b.prototype._getAssociatedDomCopy=function(f){var $=q("<div></div>");f.getAggregationOverlays().forEach(function(A){A.getChildren().forEach(function(C){var g=C.getAssociatedDomRef();if(g){D.cloneDOMAndStyles(g,$);}else{D.cloneDOMAndStyles(this._getAssociatedDomCopy(C),$);}},this);},this);return $;};
b.prototype.getGhost=function(){return this._$ghost;};
b.prototype._onDragEnd=function(E){this.setBusy(false);var f=a.getOverlay(E.currentTarget.id);this._removeGhost();this._clearAllScrollIntervals();this.onDragEnd(f);E.stopPropagation();};
b.prototype._onDrag=function(E){var f=a.getOverlay(E.currentTarget.id);this.onDrag(f);E.stopPropagation();};
b.prototype._onDragEnter=function(E){var f=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(f)){if(!this.onDragEnter(f)){E.stopPropagation();}}E.preventDefault();};
b.prototype._onDragLeave=function(E){var f=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(f)){if(!this.onDragLeave(f)){E.stopPropagation();}}E.preventDefault();};
b.prototype._onDragOver=function(E){var f=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(f)){if(!this.onDragOver(f)){E.stopPropagation();}}E.preventDefault();};
b.prototype._onAggregationTargetZoneChange=function(E){var A=E.getSource();var t=E.getParameter("targetZone");if(t){this._attachAggregationOverlayEvents(A);}else{this._detachAggregationOverlayEvents(A);}};
b.prototype._attachAggregationOverlayEvents=function(A){A.attachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.attachBrowserEvent("dragover",this._onAggregationDragOver,this);A.attachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.attachBrowserEvent("drop",this._onAggregationDrop,this);};
b.prototype._detachAggregationOverlayEvents=function(A){A.detachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.detachBrowserEvent("dragover",this._onAggregationDragOver,this);A.detachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.detachBrowserEvent("drop",this._onAggregationDrop,this);};
b.prototype._onAggregationDragEnter=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragEnter(A);E.preventDefault();E.stopPropagation();};
b.prototype._onAggregationDragOver=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragOver(A);E.preventDefault();E.stopPropagation();};
b.prototype._onAggregationDragLeave=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragLeave(A);E.preventDefault();E.stopPropagation();};
b.prototype._onAggregationDrop=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDrop(A);E.preventDefault();E.stopPropagation();};
var c=100;var d=20;var e=50;
b.prototype._clearScrollInterval=function(E,s){if(this._mScrollIntervals[E]){window.clearInterval(this._mScrollIntervals[E][s]);delete this._mScrollIntervals[E][s];}};
b.prototype._clearScrollIntervalFor=function(E){if(this._mScrollIntervals[E]){Object.keys(this._mScrollIntervals[E]).forEach(function(s){this._clearScrollInterval(E,s);},this);}};
b.prototype._clearAllScrollIntervals=function(){Object.keys(this._mScrollIntervals).forEach(this._clearScrollIntervalFor.bind(this));};
b.prototype._checkScroll=function($,s,E){var S;var f;var i=1;if(s==="top"||s==="bottom"){S=$.height();f=$.scrollTop.bind($);}else{S=$.width();f=$.scrollLeft.bind($);}if(s==="top"||s==="left"){i=-1;}var g=Math.floor(S/4);var t=c;if(g<c){t=g;}if(E<t){this._mScrollIntervals[$.attr("id")]=this._mScrollIntervals[$.attr("id")]||{};if(!this._mScrollIntervals[$.attr("id")][s]){this._mScrollIntervals[$.attr("id")][s]=window.setInterval(function(){var h=f();f(h+i*d);},e);}}else{this._clearScrollInterval($.attr("id"),s);}};
b.prototype._dragLeave=function(E){var A=a.getOverlay(E.currentTarget.id);this._clearScrollIntervalFor(A.$().attr("id"));};
b.prototype._dragScroll=function(E){var A=a.getOverlay(E.currentTarget.id);var $=A.$();var i=E.clientX;var f=E.clientY;var g=$.offset();var h=$.height();var w=$.width();var t=g.top;var l=g.left;var j=t+h;var r=l+w;this._checkScroll($,"bottom",j-f);this._checkScroll($,"top",f-t);this._checkScroll($,"right",r-i);this._checkScroll($,"left",i-l);};
b.prototype._attachDragScrollHandler=function(E){var A;if(B.isA(E,"sap.ui.dt.AggregationOverlay")){A=E;}else{A=E.srcControl;}if(D.hasScrollBar(A.$())){A.getDomRef().addEventListener("dragover",this._dragScrollHandler,true);A.getDomRef().addEventListener("dragleave",this._dragLeaveHandler,true);}};
b.prototype._removeDragScrollHandler=function(E){var A;if(B.isA(E,"sap.ui.dt.AggregationOverlay")){A=E;}else{A=E.srcControl;}var f=A.getDomRef();if(f){f.removeEventListener("dragover",this._dragScrollHandler,true);}};
return b;},true);
sap.ui.predefine('sap/ui/dt/plugin/MouseSelection',["sap/ui/dt/Plugin"],function(P){"use strict";
var M=P.extend("sap.ui.dt.plugin.MouseSelection",{metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}}});
M.prototype.init=function(){P.prototype.init.apply(this,arguments);};
M.prototype.registerElementOverlay=function(o){o.setSelectable(true);o.attachBrowserEvent('click',this._onClick,o);};
M.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent('click',this._onClick,o);};
M.prototype._onClick=function(e){this.setSelected(!this.getSelected());e.preventDefault();e.stopPropagation();};
return M;},true);
sap.ui.predefine('sap/ui/dt/plugin/ToolHooks',["sap/ui/dt/Plugin"],function(P){"use strict";
var T=P.extend("sap.ui.dt.plugin.ToolHooks",{metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}}});
T.prototype.registerElementOverlay=function(o){o.getDesignTimeMetadata().getToolHooks().start(o.getElement());};
T.prototype.deregisterElementOverlay=function(o){o.getDesignTimeMetadata().getToolHooks().stop(o.getElement());};
return T;},true);
sap.ui.predefine('sap/ui/dt/util/ZIndexManager',["sap/ui/core/Popup","sap/ui/core/BusyIndicator","sap/base/Log","sap/ui/dt/Util","sap/m/InstanceManager","sap/base/util/includes"],function(P,B,L,U,I,i){"use strict";var Z=10;var a=3;var A=[];var _=[];
function g(){return I.getOpenDialogs().concat(I.getOpenPopovers(),B.oPopup&&B.oPopup.isOpen()?[B.oPopup]:[]);}
function b(C,m,e){if(++C<=m){if(i(e,C)){return b(C,m,e);}return C;}L.error('sap.ui.dt.util.ZIndexManager: z-index limit has been exceeded, therefore all following calls receive the same z-Index = '+m);return m;}
function c(p){return p.map(function(o){return o._iZIndex||o.oPopup._iZIndex;});}
var d={getNextZIndex:function(){var e=g();var v=[];var f=[];e.forEach(function(o){var V=_.every(function(F){return F(o);});V&&_.length>0?v.push(o):f.push(o);});var m=v.length>0?Math.max.apply(null,c(v)):-1;var M=f.length>0?Math.min.apply(null,c(f)):-1;if(m<M){return this._getNextMinZIndex(M);}return P.getNextZIndex();},getZIndexBelowPopups:function(){var o=g();var l;if(o.length>0){l=Math.min.apply(null,c(o));}if(!U.isInteger(l)){return P.getNextZIndex();}return this._getNextMinZIndex(l);},addPopupFilter:function(f){if(typeof f==="function"){_=_.concat([f]);}},removePopupFilter:function(f){_=_.filter(function(e){return e===f;});},_getNextMinZIndex:function(C){var m=C-a;var M=C-Z;var n=b(M,m,A);A.push(n);return n;}};return d;});
sap.ui.require.preload({
	"sap/ui/dt/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.dt","type":"library","embeds":[],"applicationVersion":{"version":"1.68.0"},"title":"SAP UI library: sap.ui.dt (by SAP, Author)","description":"SAP UI library: sap.ui.dt (by SAP, Author)","ach":"CA-UI5-FL-RTA","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.68","libs":{"sap.ui.core":{"minVersion":"1.68.0"}}},"library":{"i18n":false,"content":{"controls":[],"elements":[],"types":["sap.ui.dt.SelectionMode"],"interfaces":[]}}}}'
},"sap/ui/dt/library-preload"
);
//# sourceMappingURL=library-preload.js.map