/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/dt/Plugin","sap/ui/dt/ContextMenuControl","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/Device","sap/base/assert","sap/ui/events/KeyCodes"],function(q,P,C,D,O,a,b,K){"use strict";var c=P.extend("sap.ui.dt.plugin.ContextMenu",{metadata:{properties:{contextElement:{type:"object"},styleClass:{type:"string"},openOnHover:{type:"boolean",defaultValue:true},openOnClick:{type:"boolean",defaultValue:true}},events:{openedContextMenu:{},closedContextMenu:{}}}});c.prototype.init=function(){this.iMenuHoverOpeningDelay=500;this.iMenuHoverClosingDelay=250;this.oContextMenuControl=new C({maxButtonsDisplayed:4});this.oContextMenuControl.attachClosed(this._contextMenuClosed,this);this.oContextMenuControl.attachOverflowButtonPressed(this._pressedOverflowButton,this);this._aMenuItems=[];this._aGroupedItems=[];this._aSubMenus=[];};c.prototype.exit=function(){this._clearHoverTimeout();delete this._aMenuItems;if(this.oContextMenuControl){this.oContextMenuControl.detachClosed(this._contextMenuClosed,this);this.oContextMenuControl.detachOverflowButtonPressed(this._pressedOverflowButton,this);this.oContextMenuControl.destroy();delete this.oContextMenuControl;}};c.prototype.addMenuItem=function(m,r,p){var M={menuItem:m,fromPlugin:!!r,bPersistOneTime:p};this._aMenuItems.push(M);};c.prototype.registerElementOverlay=function(o){o.attachBrowserEvent("click",this._onContextMenuOrClick,this);o.attachBrowserEvent("touchstart",this._onContextMenuOrClick,this);o.attachBrowserEvent("contextmenu",this._onContextMenuOrClick,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);o.attachBrowserEvent("keyup",this._onKeyUp,this);};c.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._onContextMenuOrClick,this);o.detachBrowserEvent("touchstart",this._onContextMenuOrClick,this);o.detachBrowserEvent("contextmenu",this._onContextMenuOrClick,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);o.detachBrowserEvent("keyup",this._onKeyUp,this);};c.prototype.open=function(p,o,d,i){this._bContextMenu=!!d;this.setContextElement(o.getElement());this.getDesignTime().getSelectionManager().attachChange(this._onSelectionChanged,this);var s=this.getSelectedOverlays().filter(function(E){return E!==o;});s.unshift(o);if(document.activeElement){document.activeElement.blur();}this._aMenuItems=this._aMenuItems.filter(function(m){if(m.bPersistOneTime){m.bPersistOneTime=false;return true;}return!m.fromPlugin;});var e=Promise.resolve();if(!i){e=D.waitForSynced(this.getDesignTime())().then(function(){this._aGroupedItems=[];this._aSubMenus=[];var f=[];var g=this.getDesignTime().getPlugins();g.forEach(function(h){var m=h.getMenuItems(s);if(!(m instanceof Promise)){m=Promise.resolve(m);}f.push(m);});return Promise.all(f);}.bind(this)).then(function(f){return f.reduce(function(g,m){return g.concat(m);});}).then(function(f){f.forEach(function(m){if(m.group!==undefined&&!d){this._addMenuItemToGroup(m);}else if(m.submenu!==undefined){this._addSubMenu(m,p,o);}else{this.addMenuItem(m,true);}}.bind(this));this._addItemGroupsToMenu(p,o);}.bind(this));}e.then(function(){var m=this._aMenuItems.map(function(M){return M.menuItem;});if(m.length>0){this.oContextMenuControl._bUseExpPop=!!d;m=this._sortMenuItems(m);this.oContextMenuControl.setButtons(m,this._onItemSelected.bind(this),s);this.oContextMenuControl.setStyleClass(this.getStyleClass());if(i){this.oContextMenuControl.setOpenNew(true);}this.oContextMenuControl.show(o,d,{x:p.clientX,y:p.clientY});}this.fireOpenedContextMenu();}.bind(this)).catch(function(E){throw D.createError("ContextMenu#open","An error occured during calling getMenuItems: "+E);});};c.prototype._sortMenuItems=function(m){return m.sort(function(f,s){if(!f.rank&&!s.rank){return 0;}if(!f.rank&&s.rank){return-1;}if(f.rank&&!s.rank){return 1;}return f.rank-s.rank;});};c.prototype._onContextMenu=function(e){var o=O.getOverlay(e.currentTarget.id);var p={clientX:e.clientX,clientY:e.clientY};this._openContextMenu(e,o,p);};c.prototype._onItemSelected=function(e){this.oContextMenuControl.close(true);this._ensureSelection(this._oCurrentOverlay);this.setFocusLock(true);var s=[],o=this.getContextElement(),S=e.data("id");this._aMenuItems.some(function(m){if(S===m.menuItem.id){var i=m.menuItem;s=this.getSelectedOverlays();b(s.length>0,"sap.ui.rta - Opening context menu, with empty selection - check event order");var p={};p.eventItem=e;p.contextElement=o;i.handler(s,p);i=null;return true;}},this);};c.prototype._onContextMenuOrClick=function(e){if(!this.fnDebounced){this.fnDebounced=D.debounce(function(){if(this._oCurrentEvent.type==="contextmenu"){this._onContextMenu(this._oCurrentEvent);}else{this._onClickorTouch(this._oCurrentEvent);}this._oCurrentEvent=undefined;this.fnDebounced=undefined;}.bind(this),50);}var o=O.getOverlay(e.currentTarget.id);if(o&&o.isSelectable()&&o.getSelected()){this._oCurrentEvent=e;e.stopPropagation();this.fnDebounced();}};c.prototype._onClickorTouch=function(e){if(this.getOpenOnClick()){if(this.isMenuOpeningLocked()){this.unlockMenuOpening();this.oContextMenuControl.close();}this._startOpening(e);}};c.prototype._startOpening=function(e,l){clearTimeout(this.hoverTimeout);this._bOpenedByHover=false;this._oTempTarget=e.currentTarget.id;var o=O.getOverlay(e.currentTarget.id);var t=e.target.className;if(o&&o.isSelectable()&&t.indexOf("sapUiDtOverlay")>-1&&(!this.isMenuOpeningLocked())){e.stopPropagation();if(this._shouldContextMenuOpen(e)){this._ensureSelection(o);if(this._oCurrentOverlay.isSelected()||a.os.android){if(l){this.lockMenuOpening();}this.oContextMenuControl.setOpenNew(true);this.open({clientX:e.clientX,clientY:e.clientY},o);return true;}}}};c.prototype._onHover=function(e){var o=O.getOverlay(e.currentTarget.id);if(o&&o.isSelectable()&&!e.ctrlKey&&this.getOpenOnHover()){e.stopPropagation();if(this._shouldContextMenuOpen(e,true)){if(this.iMenuHoverClosingDelay>=this.iMenuHoverOpeningDelay){q.error("sap.ui.dt ContextMenu iMenuHoverClosingDelay is bigger or equal to iMenuHoverOpeningDelay!");}if(this.oContextMenuControl.getPopover().isOpen()){this._closingTimeout=setTimeout(function(){if(this.oContextMenuControl.getPopover().isOpen()){this.oContextMenuControl.close();}}.bind(this),this.iMenuHoverClosingDelay);}this.hoverTimeout=setTimeout(function(){O.getOverlay(e.currentTarget.id).focus();this._startOpening(e);this._bOpenedByHover=true;}.bind(this),this.iMenuHoverOpeningDelay);}}};c.prototype._clearHoverTimeout=function(){if(this.hoverTimeout){clearTimeout(this.hoverTimeout);this.hoverTimeout=null;}if(this._closingTimeout){clearTimeout(this._closingTimeout);this._closingTimeout=null;}};c.prototype._onKeyUp=function(e){var o=O.getOverlay(e.currentTarget.id);if((e.keyCode===K.SPACE||e.keyCode===K.ENTER)&&(e.shiftKey===false)&&(e.altKey===false)&&(e.ctrlKey===false)){if(o&&o.isSelectable()&&!this._checkForPluginLock()){this._startOpening(e,true);e.stopPropagation();e.preventDefault();}}if((e.keyCode===K.F10)&&(e.shiftKey===true)&&(e.altKey===false)&&(e.ctrlKey===false)){if(o&&o.isSelectable()){e.preventDefault();var p={clientX:"not set",clientY:"not set"};this._openContextMenu(e,o,p);}}};c.prototype._onKeyDown=function(e){var o=O.getOverlay(e.currentTarget.id);if((e.keyCode===K.SPACE)&&(e.shiftKey===false)&&(e.altKey===false)&&(e.ctrlKey===false)){if(o&&o.isSelectable()&&!this._checkForPluginLock()){e.stopPropagation();e.preventDefault();}}};c.prototype._shouldContextMenuOpen=function(e,o){if((!this._checkForPluginLock()&&!this.isMenuOpeningLocked())){if(!o){this._oCurrentOverlay=O.getOverlay(e.currentTarget.id);}return true;}return false;};c.prototype._pressedOverflowButton=function(e){this.lockMenuOpening();var o=O.getOverlay(e.oSource._oTarget.getAttribute("overlay"));var p={clientX:e.mParameters.oButton.$().offset().left,clientY:e.mParameters.oButton.$().offset().top};this._openContextMenu(e,o,p);this.setFocusLock(true);};c.prototype._openContextMenu=function(e,o,p){if(o&&o.isSelectable()){e.preventDefault();this._oCurrentOverlay=o;this.oContextMenuControl.close(true);this._bOpenedByHover=false;clearTimeout(this.hoverTimeout);this._ensureSelection(o);this.lockMenuOpening();this.oContextMenuControl.setOpenNew(true);this.open(p,o,true);if(e.stopPropagation){e.stopPropagation();}}};c.prototype._contextMenuClosed=function(){this.unlockMenuOpening();this.setFocusLock(false);};c.prototype._onSelectionChanged=function(){this.oContextMenuControl.close(true);this.getDesignTime().getSelectionManager().detachChange(this._onSelectionChanged,this);};c.prototype.lockMenuOpening=function(o){if((this.oContextMenuControl.getPopover(true).isOpen()||this.oContextMenuControl.getPopover(false).isOpen())&&o!==true){this._bAsyncLock=true;}else{this._bOpeningLocked=true;}};c.prototype.unlockMenuOpening=function(){this._bOpeningLocked=false;if(this._bAsyncLock){this.lockMenuOpening(true);}this._bAsyncLock=false;};c.prototype.isMenuOpeningLocked=function(){return this._bOpeningLocked;};c.prototype.setFocusLock=function(i){this._bFocusLocked=i;};c.prototype._ensureSelection=function(o){if(o&&!o.isSelected()){o.setSelected(true);}};c.prototype._checkForPluginLock=function(){if(a.os.ios){return false;}if(this.getDesignTime().getBusyPlugins().length){return true;}this.setFocusLock(false);return false;};c.prototype._addMenuItemToGroup=function(m){var g=this._aGroupedItems.some(function(_){if(_.sGroupName===m.group){_.aGroupedItems.push(m);return true;}});if(!g){this._aGroupedItems.push({sGroupName:m.group,aGroupedItems:[m]});}};c.prototype._addSubMenu=function(m,p,o){m.submenu.forEach(function(s){s.handler=m.handler;});m.handler=function(M,p,o){this._aSubMenus.some(function(_){if(_.sSubMenuId===M){_.aSubMenuItems.forEach(function(s){this.addMenuItem(s,true,true);}.bind(this));return true;}}.bind(this));if(!this._bContextMenu){p.clientX=null;p.clientY=null;}this.oContextMenuControl.close();setTimeout(function(){this.open(p,o,true,true);}.bind(this),0);this.lockMenuOpening();}.bind(this,m.id,p,o);this._aSubMenus.push({sSubMenuId:m.id,aSubMenuItems:m.submenu});this.addMenuItem(m,true);};c.prototype._addItemGroupsToMenu=function(p,o){this._aGroupedItems.forEach(function(g,i){if(g.aGroupedItems.length===1){this.addMenuItem(g.aGroupedItems[0],true,false);}else{var h=function(i,p,o){this._aGroupedItems[i].aGroupedItems.forEach(function(m){this.addMenuItem(m,true,true);}.bind(this));p.clientX=null;p.clientY=null;this.oContextMenuControl.close();setTimeout(function(){this.open(p,o,true,true);}.bind(this),0);this.lockMenuOpening();};this.addMenuItem({id:g.sGroupName+"-groupButton",enabled:true,text:g.sGroupName,icon:g.aGroupedItems[0].icon,rank:g.aGroupedItems[0].rank,handler:h.bind(this,i,p,o)},true);}}.bind(this));};return c;},true);
