/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/registry/ChangeHandlerRegistration","sap/ui/fl/Utils","sap/ui/fl/FlexCustomData","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/registry/Settings","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/context/ContextManager","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/util/reflection/XmlTreeModifier","sap/ui/core/Component","sap/ui/core/Element"],function(C,a,U,F,b,V,c,d,e,J,X,f,E){"use strict";var g=function(s,A){this._oChangePersistence=undefined;this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;if(this._sComponentName&&this._sAppVersion){this._createChangePersistence();}};g.PENDING="sap.ui.fl:PendingChange";g.variantTechnicalParameterName="sap-ui-fl-control-variant-id";g.prototype.setComponentName=function(s){this._sComponentName=s;this._createChangePersistence();};g.prototype.getComponentName=function(){return this._sComponentName;};g.prototype.getAppVersion=function(){return this._sAppVersion;};g.prototype.getVariantModelData=function(){var D;if(this._oChangePersistence&&this._oChangePersistence._oVariantController._mVariantManagement&&Object.keys(this._oChangePersistence._oVariantController._mVariantManagement).length>0){D=this._oChangePersistence._oVariantController.fillVariantModel();}return D;};g.prototype.setVariantSwitchPromise=function(p){this._oVariantSwitchPromise=p;};g.prototype.waitForVariantSwitch=function(){if(!this._oVariantSwitchPromise){this._oVariantSwitchPromise=Promise.resolve();}return this._oVariantSwitchPromise;};g.prototype.createBaseChange=function(o,A){var h,i;var j=e._getContextIdsFromUrl();if(j.length>1){throw new Error("More than one DesignTime Context is currently active.");}if(!A){throw new Error("No application component found. To offer flexibility a valid relation to its owning component must be present.");}o.reference=this.getComponentName();o.packageName="$TMP";o.context=j.length===1?j[0]:"";o.validAppVersions=U.getValidAppVersions({appVersion:this.getAppVersion(),developerMode:o.developerMode,scenario:o.scenario});h=b.createInitialFileContent(o);i=new b(h);if(o.variantReference){i.setVariantReference(o.variantReference);}return i;};g.prototype.createChange=function(o,h){var i,j;if(!h){throw new Error("A flexibility change cannot be created without a targeted control.");}var s=h.id||h.getId();if(!o.selector){o.selector={};}var A=h.appComponent||U.getAppComponentForControl(h);if(!A){throw new Error("No application component found. To offer flexibility, the control with the ID '"+s+"' has to have a valid relation to its owning application component.");}Object.assign(o.selector,J.getSelector(s,A));i=this.createBaseChange(o,A);var k=h.controlType||U.getControlType(h);if(!k){throw new Error("No control type found - the change handler can not be retrieved.");}j=this._getChangeHandler(i,k,h,J);if(j){j.completeChangeContent(i,o,{modifier:J,appComponent:A});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(o)+".");}return i;};g.prototype.createVariant=function(v,A){var o,h;if(!A){throw new Error("No Application Component found - to offer flexibility the variant has to have a valid relation to its owning application component.");}if(v.content.variantManagementReference){var i=J.checkControlId(v.content.variantManagementReference,A);if(!i){throw new Error("Generated ID attribute found - to offer flexibility a stable VariantManagement ID is needed to assign the changes to, but for this VariantManagement control the ID was generated by SAPUI5 "+v.content.variantManagementReference);}}v.content.reference=this.getComponentName();v.content.packageName="$TMP";v.content.validAppVersions=U.getValidAppVersions(this.getAppVersion(),v.developerMode,v.scenario);h=V.createInitialFileContent(v);o=new V(h);return o;};g.prototype.addChange=function(o,h){var i=this.createChange(o,h);var A=U.getAppComponentForControl(h);this.addPreparedChange(i,A);return i;};g.prototype.addPreparedChange=function(o,A){if(o.getVariantReference()){var m=A.getModel(U.VARIANT_MODEL_NAME);m.addChange(o);}this._oChangePersistence.addChange(o,A);return o;};g.prototype.deleteChange=function(o,A){this._oChangePersistence.deleteChange(o);if(o.getVariantReference()){A.getModel(U.VARIANT_MODEL_NAME).removeChange(o);}};g.prototype.createAndApplyChange=function(o,h){var i;return Promise.resolve().then(function(){i=this.addChange(o,h);var p={modifier:J,appComponent:U.getAppComponentForControl(h),view:U.getViewForControl(h)};i.setQueuedForApply();return this.checkTargetAndApplyChange(i,h,p);}.bind(this)).then(function(r){if(!r.success){var j=r.error||new Error("The change could not be applied.");this._oChangePersistence.deleteChange(i,true);throw j;}return i;}.bind(this));};g.prototype._checkDependencies=function(o,D,m,A,r){var R=this._canChangePotentiallyBeApplied(o,A);if(!R){return[];}r.push(o);var s=o.getId();var h=D[s]&&D[s].dependencies||[];for(var i=0,n=h.length;i<n;i++){var j=U.getChangeFromChangesMap(m,h[i]);R=this._checkDependencies(j,D,m,A,r);if(R.length===0){r=[];break;}delete D[s];}return r;};g.prototype._canChangePotentiallyBeApplied=function(o,A){var s=o.getDependentControlSelectorList();s.push(o.getSelector());return!s.some(function(S){return!J.bySelector(S,A);});};g.prototype.waitForChangesToBeApplied=function(o){var m=this._oChangePersistence.getChangesMapForComponent();var p=[];var D=Object.assign({},m.mDependencies);var h=m.mChanges;var i=h[o.getId()]||[];var n=i.filter(function(j){return!j.isCurrentProcessFinished();},this);var A=U.getAppComponentForControl(o);var r=[];n.forEach(function(j){var k=this._checkDependencies(j,D,m.mChanges,A,[]);r=r.concat(k);},this);r=r.filter(function(j,P,k){return k.indexOf(j)===P;});r.forEach(function(j){p=p.concat(j.addChangeProcessingPromises());},this);p.push(this.waitForVariantSwitch());return Promise.all(p).then(function(){return undefined;});};g.prototype.saveAll=function(s){return this._oChangePersistence.saveDirtyChanges(s);};g.prototype.processXmlView=function(v,p){var o=f.get(p.componentId);var A=U.getAppComponentForControl(o);var m=A.getManifest();p.appComponent=A;p.appDescriptor=m;p.modifier=X;p.view=v;return this.processViewByModifier(p);};g.prototype.processViewByModifier=function(p){p.siteId=U.getSiteId(p.appComponent);return this._oChangePersistence.getChangesForView(p.viewId,p).then(this._resolveGetChangesForView.bind(this,p),this._handlePromiseChainError.bind(this,p.view));};g.prototype._checkForDependentSelectorControls=function(o,p){var D=o.getDependentControlSelectorList();D.forEach(function(s){var h=p.modifier.bySelector(s,p.appComponent,p.view);if(!h){throw new Error("A dependent selector control of the flexibility change is not available.");}});};g.prototype._resolveGetChangesForView=function(p,h){var P=[];if(!Array.isArray(h)){var s="No list of changes was passed for processing the flexibility on view: "+p.view+".";U.log.error(s,undefined,"sap.ui.fl.FlexController");return[];}h.forEach(function(o){try{var S=this._getSelectorOfChange(o);if(!S||!S.id){throw new Error("No selector in change found or no selector ID.");}var i=p.modifier.bySelector(S,p.appComponent,p.view);if(!i){throw new Error("A flexibility change tries to change a nonexistent control.");}this._checkForDependentSelectorControls(o,p);o.setQueuedForApply();P.push(function(){var I=this._isChangeCurrentlyApplied(i,o,p.modifier);var k=o.isApplyProcessFinished();if(k&&!I){o.setInitialApplyState();}else if(!k&&I){o.markFinished();return new U.FakePromise();}return this.checkTargetAndApplyChange(o,i,p).then(function(r){if(!r.success){this._logApplyChangeError(r.error||{},o);}}.bind(this));}.bind(this));}catch(j){this._logApplyChangeError(j,o);}}.bind(this));return U.execPromiseQueueSequentially(P).then(function(){return p.view;});};g.prototype._logApplyChangeError=function(o,h){var D=h.getDefinition();var s=D.changeType;var t=D.selector.id;var i=D.namespace+D.fileName+"."+D.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(o.message){w+="\n   occurred error message: '"+o.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+i;w+="\n   id of targeted control: '"+t+"'.";U.log.warning(w,undefined,"sap.ui.fl.FlexController");};g.prototype._isXmlModifier=function(p){return p.modifier.targets==="xmlTree";};g.prototype.checkTargetAndApplyChange=function(o,h,p){var x=this._isXmlModifier(p);var m=p.modifier;var s=m.getControlType(h);var i=this._getControlIfTemplateAffected(o,h,s,p);var S,r,R;var l=m.getLibraryName(i.control);var w=new U.FakePromise();if(a.isChangeHandlerRegistrationInProgress(l)){w=a.waitForChangeHandlerRegistration(l);}return w.then(function(){var j=this._getChangeHandler(o,i.controlType,i.control,m);if(!j){var k="Change handler implementation for change not found or change type not enabled for current layer - Change ignored";U.log.warning(k);R={success:false,error:new Error(k)};o.setInitialApplyState();return new U.FakePromise(R);}if(x&&o.getDefinition().jsOnly){R={success:false,error:new Error("Change cannot be applied in XML. Retrying in JS.")};o.setInitialApplyState();return new U.FakePromise(R);}if(o.hasApplyProcessStarted()){return o.addPromiseForApplyProcessing().then(function(R){o.markFinished();return R;});}else if(!o.isApplyProcessFinished()){var n=this.isChangeHandlerRevertible(o,i.control,j);return new U.FakePromise().then(function(){S=c.getInstanceOrUndef();if(!n&&S&&S._oSettings.recordUndo){if(x){throw new Error();}return new Promise(function(q){sap.ui.require(["sap/ui/rta/ControlTreeModifier"],function(t){if(!t){U.log.error("Please load 'sap/ui/rta' library if you want to record undo");}else{p.modifier=t;t.startRecordingUndo();r=t;}q();});});}}).then(function(){o.startApplying();return j.applyChange(o,i.control,p);}).then(function(I){if(I instanceof E){i.control=I;}if(i.control){m.updateAggregation(h,o.getContent().boundAggregation);}if(!n&&S&&S._oSettings.recordUndo&&r){o.setUndoOperations(r.stopRecordingUndo());}F.addAppliedCustomData(i.control,o,p,n&&x);R={success:true};o.markFinished(R);return R;}).catch(function(q){this._logErrorAndWriteCustomData(q,o,p,i.control,x);R={success:false,error:q};if(x){o.setInitialApplyState();}else{o.markFinished(R);}return R;}.bind(this));}R={success:true};o.markFinished(R);return new U.FakePromise(R);}.bind(this));};g.prototype._removeFromAppliedChangesAndMaybeRevert=function(o,h,p,r){var m=p.modifier;var s=m.getControlType(h);var i=this._getControlIfTemplateAffected(o,h,s,p);var j=this._getChangeHandler(o,i.controlType,i.control,m);var R;var S;if(r&&!j){var M="Change handler implementation for change not found or change type not enabled for current layer - Change ignored";U.log.warning(M);o.markRevertFinished(new Error(M));return new U.FakePromise(false);}if(o.getChangeType()==="stashControl"&&s==="sap.ui.core._StashedControl"){S=true;if(r&&!o.getRevertData()){j.setChangeRevertData(o,false);}}var I=o.isApplyProcessFinished();if(!I&&o.hasApplyProcessStarted()){R=o.addPromiseForApplyProcessing().then(function(k){if(k&&k.error){o.markRevertFinished(k.error);throw Error(k.error);}return true;});}else{R=new U.FakePromise(false);}return R.then(function(P){if(r&&(P||(!P&&I))||r&&S){if(!o.getRevertData()){o.setRevertData(F.getParsedRevertDataFromCustomData(h,o,m));}o.startReverting();return j.revertChange(o,i.control,p);}else if(r){throw Error("Change was never applied");}}).then(function(){i.control=p.modifier.bySelector(o.getSelector(),p.appComponent,p.view);if(i.bTemplateAffected){m.updateAggregation(i.control,o.getContent().boundAggregation);}F.destroyAppliedCustomData(h,o,p.modifier);o.markRevertFinished();return true;}).catch(function(k){var l="Change could not be reverted: "+k.message;U.log.error(l);o.markRevertFinished(l);return false;});};g.prototype._logErrorAndWriteCustomData=function(r,o,p,h,x){var s=o.getId(),l="Change ''{0}'' could not be applied.",i=r instanceof Error,j=F.getCustomDataIdentifier(false,i,x);switch(j){case F.notApplicableChangesCustomDataKey:U.formatAndLogMessage("info",[l,r.message],[s]);break;case F.failedChangesCustomDataKeyXml:this._setMergeError(true);U.formatAndLogMessage("warning",[l,"Merge error detected while processing the XML tree."],[s],r.stack);break;case F.failedChangesCustomDataKeyJs:this._setMergeError(true);U.formatAndLogMessage("error",[l,"Merge error detected while processing the JS control tree."],[s],r.stack);break;}F.addFailedCustomData(h,o,p,j);};g.prototype._isChangeCurrentlyApplied=function(o,h,m){return F.hasChangeApplyFinishedCustomData(o,h,m);};g.prototype._handlePromiseChainError=function(v,o){U.log.error("Error processing view "+o+".");return v;};g.prototype._getSelectorOfChange=function(o){if(!o||!o.getSelector){return undefined;}return o.getSelector();};g.prototype._getChangeHandler=function(o,s,h,m){var i=o.getChangeType();var l=o.getLayer();return this._getChangeRegistry().getChangeHandler(i,s,h,m,l);};g.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings();return i;};g.prototype._getControlIfTemplateAffected=function(o,h,s,p){var i=o.getDefinition();var m={};if(o.getContent().boundAggregation&&i.dependentSelector.originalSelector){var M=p.modifier;m.control=M.bySelector(i.dependentSelector.originalSelector,p.appComponent,p.view);m.controlType=M.getControlType(m.control);m.bTemplateAffected=true;}else{m.control=h;m.controlType=s;m.bTemplateAffected=false;}return m;};g.prototype.getComponentChanges=function(p,i){return this._oChangePersistence.getChangesForComponent(p,i);};g.prototype.checkForOpenDependenciesForControl=function(s,m,o){return this._oChangePersistence.checkForOpenDependenciesForControl(s,m,o);};g.prototype.hasHigherLayerChanges=function(p){p=p||{};var s=p.upToLayer||U.getCurrentLayer(false);p.includeVariants=true;p.includeCtrlVariants=true;return this.getComponentChanges(p).then(function(v){var h=v===this._oChangePersistence.HIGHER_LAYER_CHANGES_EXIST||v.some(function(o){return U.compareAgainstCurrentLayer(o.getLayer(),s)>0;});return!!h;}.bind(this));};g.prototype._createChangePersistence=function(){this._oChangePersistence=d.getChangePersistenceForComponent(this.getComponentName(),this.getAppVersion());return this._oChangePersistence;};g.prototype.resetChanges=function(l,G,o,s,h){return this._oChangePersistence.resetChanges(l,G,s,h).then(function(i){if(i.length!==0){return this.revertChangesOnControl(i,o);}}.bind(this)).then(function(){if(o){var m=o.getModel(U.VARIANT_MODEL_NAME);if(m){m.updateHasherEntry({parameters:[],updateURL:true,component:o});}}});};g.prototype.discardChanges=function(h,D){var A=U.getCurrentLayer(!!D);var i=0;var l;var o;l=h.length;while(i<h.length){o=h[i];if(o&&o.getLayer&&o.getLayer()===A){this._oChangePersistence.deleteChange(o);}if(l===h.length){i++;}else{l=h.length;}}return this._oChangePersistence.saveDirtyChanges();};g.prototype.discardChangesForId=function(i,D){if(!i){return Promise.resolve();}var o=this._oChangePersistence.getChangesMapForComponent();var h=o.mChanges[i]||[];return this.discardChanges(h,D);};g.prototype._setMergeError=function(){return c.getInstance().then(function(s){s.setMergeErrorOccured(true);});};g.prototype._checkIfDependencyIsStillValid=function(A,m,s){var o=U.getChangeFromChangesMap(this._oChangePersistence._mChanges.mChanges,s);var h=m.bySelector(o.getSelector(),A);if(this._isChangeCurrentlyApplied(h,o,m)||o.hasApplyProcessStarted()){return false;}return true;};g.prototype._applyChangesOnControl=function(G,A,o){var p=[];var m=G();var h=m.mChanges;var D=m.mDependencies;var i=m.mDependentChangesOnMe;var j=h[o.getId()]||[];var P={modifier:J,appComponent:A,view:U.getViewForControl(o)};j.forEach(function(k){var s=J.getControlType(o);var l=this._getControlIfTemplateAffected(k,o,s,P);var I=this._isChangeCurrentlyApplied(l.control,k,P.modifier);var n=k.isApplyProcessFinished();if(n&&!I){m=this._oChangePersistence.copyDependenciesFromInitialChangesMap(k,this._checkIfDependencyIsStillValid.bind(this,A,P.modifier));D=m.mDependencies;i=m.mDependentChangesOnMe;k.setInitialApplyState();}else if(!n&&I){k.markFinished();}k.setQueuedForApply();if(!D[k.getId()]){p.push(function(){return this.checkTargetAndApplyChange(k,o,P).then(function(){this._updateDependencies(D,i,k.getId());}.bind(this));}.bind(this));}else{D[k.getId()][g.PENDING]=this.checkTargetAndApplyChange.bind(this,k,o,P);}}.bind(this));return U.execPromiseQueueSequentially(p).then(function(){return this._processDependentQueue(D,i,A);}.bind(this));};g.prototype.getBoundApplyChangesOnControl=function(G,o){var B=this._applyChangesOnControl.bind(this,G,o);B._bIsSapUiFlFlexControllerApplyChangesOnControl=true;return B;};g.prototype.revertChangesOnControl=function(h,A){var p=[];h.forEach(function(o){o.setQueuedForRevert();p.push(function(){var s=this._getSelectorOfChange(o);var i=J.bySelector(s,A);var P={modifier:J,appComponent:A,view:U.getViewForControl(i)};return this._removeFromAppliedChangesAndMaybeRevert(o,i,P,true).then(function(S){if(S){this._oChangePersistence._deleteChangeInMap(o);}}.bind(this));}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};g.prototype.isChangeHandlerRevertible=function(o,v,h){if(!h){var s=v.controlType?v.controlType:J.getControlType(v);h=this._getChangeHandler(o,s,v,J);}return!!(h&&typeof h.revertChange==="function");};g.prototype.applyVariantChanges=function(h,A){var p=[];h.forEach(function(o){this._oChangePersistence._addChangeAndUpdateDependencies(A,o);p.push(function(){var m=J;var s=this._getSelectorOfChange(o);var i=m.bySelector(s,A);if(!i){U.log.error("A flexibility change tries to change a nonexistent control.");return new U.FakePromise();}return this._applyChangesOnControl(this._oChangePersistence.getChangesMapForComponent.bind(this._oChangePersistence),A,i);}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};g.prototype.removeFromAppliedChangesOnControl=function(o,A,h){var p={modifier:J,appComponent:A,view:U.getViewForControl(h)};return this._removeFromAppliedChangesAndMaybeRevert(o,h,p,false);};g.prototype._updateControlsDependencies=function(D,A){var o;Object.keys(D).forEach(function(s){var h=D[s];if(h.controlsDependencies&&h.controlsDependencies.length>0){var l=h.controlsDependencies.length;while(l--){var S=h.controlsDependencies[l];o=J.bySelector(S,A);if(o){h.controlsDependencies.splice(l,1);}}}});};g.prototype._updateDependencies=function(D,m,s){if(m[s]){m[s].forEach(function(k){var o=D[k];var i=o?o.dependencies.indexOf(s):-1;if(i>-1){o.dependencies.splice(i,1);}});delete m[s];}};g.prototype._iterateDependentQueue=function(D,m,A){var h=[],i=[],p=[];this._updateControlsDependencies(D,A);Object.keys(D).forEach(function(s){var o=D[s];if(o[g.PENDING]&&o.dependencies.length===0&&!(o.controlsDependencies&&o.controlsDependencies.length>0)){p.push(function(){return o[g.PENDING]().then(function(){i.push(s);h.push(o.changeObject.getId());});});}});return U.execPromiseQueueSequentially(p).then(function(){for(var j=0;j<i.length;j++){delete D[i[j]];}for(var k=0;k<h.length;k++){this._updateDependencies(D,m,h[k]);}return h;}.bind(this));};g.prototype._processDependentQueue=function(D,m,A){return this._iterateDependentQueue(D,m,A).then(function(h){if(h.length>0){return this._processDependentQueue(D,m,A);}}.bind(this));};g.prototype.saveSequenceOfDirtyChanges=function(D){return this._oChangePersistence.saveSequenceOfDirtyChanges(D);};return g;},true);
