/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Control","sap/ui/integration/util/CardManifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/f/cards/DataProviderFactory","sap/f/cards/NumericHeader","sap/f/cards/Header","sap/f/cards/BaseContent","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/m/Text",'sap/ui/model/json/JSONModel',"sap/ui/model/resource/ResourceModel","sap/f/CardRenderer","sap/f/library","sap/ui/integration/library"],function(q,C,a,b,S,L,D,N,H,B,c,V,I,T,J,R,d,l,e){"use strict";var M={TYPE:"/sap.card/type",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters"};var f=l.cards.HeaderPosition;var g=e.CardDataMode;var h=a.extend("sap.ui.integration.widgets.Card",{metadata:{library:"sap.ui.integration",interfaces:["sap.f.ICard"],properties:{manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:g.Active}},aggregations:{_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{action:{parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}}},associations:{hostConfigurationId:{}}},renderer:d});h.prototype.init=function(){this.setModel(new J(),"parameters");this._initReadyState();this.setBusyIndicatorDelay(0);};h.prototype._initReadyState=function(){this._aReadyPromises=[];this._awaitEvent("_headerReady");this._awaitEvent("_contentReady");this._awaitEvent("_cardReady");this._oReadyPromise=Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};h.prototype._clearReadyState=function(){this._bReady=false;this._aReadyPromises=[];this._oReadyPromise=null;};h.prototype.onBeforeRendering=function(){var s=this.getHostConfigurationId(),p=this.getParameters();if(this.getDataMode()!==g.Active){return;}if(s){this.addStyleClass(s.replace(/-/g,"_"));}if(this._oCardManifest&&this._bApplyManifest){this._oCardManifest.processParameters(p);this._applyManifestSettings();this._bApplyManifest=false;}};h.prototype._awaitEvent=function(E){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(E,function(){r();});}.bind(this)));};h.prototype.isReady=function(){return this._bReady;};h.prototype.refresh=function(){if(this._oCardManifest&&this.getDataMode()===g.Active){this._clearReadyState();this._initReadyState();this._bApplyManifest=true;this.invalidate();}};h.prototype.exit=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null;}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null;}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null;}if(this._oTemporaryContent){this._oTemporaryContent.destroy();this._oTemporaryContent=null;}this._aReadyPromises=null;};h.prototype.setManifest=function(v){this.setBusy(true);this.setProperty("manifest",v);if(typeof v==="string"&&v!==""){this._oCardManifest=new b();this._oCardManifest.load({manifestUrl:v}).then(function(){if(this._oCardManifest&&this._oCardManifest.getResourceBundle()){var r=new R({bundle:this._oCardManifest.getResourceBundle()});r.enhance(C.getLibraryResourceBundle("sap.ui.integration"));this.setModel(r,"i18n");}this._bApplyManifest=true;this.invalidate();}.bind(this));}else if(typeof v==="object"&&!q.isEmptyObject(v)){this._bApplyManifest=true;this._oCardManifest=new b(v);}return this;};h.prototype.getManifest=function(){var v=this.getProperty("manifest");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};h.prototype.setParameters=function(v){this._bApplyManifest=true;this.setBusy(true);this.setProperty("parameters",v);return this;};h.prototype.getParameters=function(){var v=this.getProperty("parameters");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};h.prototype._applyManifestSettings=function(){var A=this._oCardManifest.get(M.APP_TYPE);if(A&&A!=="card"){L.error("sap.app/type entry in manifest is not 'card'");}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();}this._oDataProviderFactory=new D();this._applyServiceManifestSettings();this._applyDataManifestSettings();this._applyHeaderManifestSettings();this._applyContentManifestSettings();};h.prototype._applyDataManifestSettings=function(){var o=this._oCardManifest.get(M.DATA);if(!o){this.fireEvent("_cardReady");return;}if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(o,this._oServiceManager);if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataChanged(function(E){this.getModel().setData(E.getParameter("data"));}.bind(this));this._oDataProvider.attachError(function(E){this._handleError("Data service unavailable. "+E.getParameter("message"));}.bind(this));this._oDataProvider.triggerDataUpdate().then(function(){this.fireEvent("_cardReady");}.bind(this));}};h.prototype._applyServiceManifestSettings=function(){var s=this._oCardManifest.get(M.SERVICES);if(!s){return;}if(!this._oServiceManager){this._oServiceManager=new S(s,this);}};h.prototype.getCardHeader=function(){return this.getAggregation("_header");};h.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top";}return this._oCardManifest.get(M.HEADER_POSITION)||f.Top;};h.prototype.getCardContent=function(){return this.getAggregation("_content");};h.prototype._applyHeaderManifestSettings=function(){var m=this._oCardManifest.get(M.HEADER);if(!m){this.fireEvent("_headerReady");return;}var o=H;if(m.type==="Numeric"){o=N;}this._setCardHeader(o);};h.prototype._applyContentManifestSettings=function(){var s=this._oCardManifest.get(M.TYPE),i=s&&s.toLowerCase()==="component",m=this._oCardManifest.get(M.CONTENT),j=!!m;if(j&&!s){L.error("Card type property is mandatory!");this.fireEvent("_contentReady");return;}if(!j&&!i){this.setBusy(false);this.fireEvent("_contentReady");return;}if(!m&&i){m=this._oCardManifest.getJson();}this._setTemporaryContent();B.create(s,m,this._oServiceManager,this._oDataProviderFactory).then(function(o){this._setCardContent(o);}.bind(this)).catch(function(E){this._handleError(E);}.bind(this)).finally(function(){this.setBusy(false);}.bind(this));};h.prototype._setCardHeader=function(i){var s=this._oCardManifest.get(M.HEADER),o=i.create(s,this._oServiceManager,this._oDataProviderFactory);o.attachEvent("action",function(E){this.fireEvent("action",{manifestParameters:E.getParameter("manifestParameters"),actionSource:E.getParameter("actionSource"),type:E.getParameter("type")});}.bind(this));var p=this.getAggregation("_header");if(p){p.destroy();}this.setAggregation("_header",o);if(o.isReady()){this.fireEvent("_headerReady");}else{o.attachEvent("_ready",function(){this.fireEvent("_headerReady");}.bind(this));}};h.prototype._fireReady=function(o,r){if(o.isReady()){this.fireEvent(r);}else{o.attachEvent("_ready",function(){this.fireEvent(r);this.setBusy(false);}.bind(this));}};h.prototype.onAfterRendering=function(){var s;if(this._oCardManifest&&this._oCardManifest.get(M.TYPE)){s=this._oCardManifest.get(M.TYPE).toLowerCase();}if(s==="analytical"){this.$().addClass("sapFCardAnalytical");}};h.prototype._setCardContent=function(o){o.attachEvent("action",function(E){this.fireEvent("action",{actionSource:E.getParameter("actionSource"),manifestParameters:E.getParameter("manifestParameters"),type:E.getParameter("type")});}.bind(this));o.attachEvent("_error",function(E){this._handleError(E.getParameter("logMessage"),E.getParameter("displayMessage"));}.bind(this));o.setBusyIndicatorDelay(0);var p=this.getAggregation("_content");if(p&&p!==this._oTemporaryContent){p.destroy();}this.setAggregation("_content",o);if(o.isReady()){this.fireEvent("_contentReady");}else{o.attachEvent("_ready",function(){this.fireEvent("_contentReady");}.bind(this));}};h.prototype._setTemporaryContent=function(){var t=this._getTemporaryContent(),p=this.getAggregation("_content");if(p&&p!==t){p.destroy();}this.setAggregation("_content",t);};h.prototype._handleError=function(s,i){L.error(s);this.setBusy(false);this.fireEvent("_error",{message:s});var j="Unable to load the data.",E=i||j,t=this._getTemporaryContent(),p=this.getAggregation("_content");var o=new V({justifyContent:"Center",alignItems:"Center",items:[new I({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new T({text:E})]});if(p&&p!==t){p.destroy();this.fireEvent("_contentReady");}t.setBusy(false);t.addItem(o);this.setAggregation("_content",t);};h.prototype._getTemporaryContent=function(){if(!this._oTemporaryContent){this._oTemporaryContent=new c({height:"100%",justifyContent:"Center",busyIndicatorDelay:0,busy:true});this._oTemporaryContent.addStyleClass("sapFCardContentBusy");this._oTemporaryContent.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var t=this._oCardManifest.get(M.TYPE)+"Content",o=this._oCardManifest.get(M.CONTENT),s=B.getMinHeight(t,o);if(this.getHeight()==="auto"){this._oTemporaryContent.$().css({"min-height":s});}}},this);}this._oTemporaryContent.destroyItems();return this._oTemporaryContent;};h.prototype.setDataMode=function(m){if(this._oDataProviderFactory&&m===g.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;}this.setProperty("dataMode",m,true);if(this.getProperty("dataMode")===g.Active){this.refresh();}return this;};return h;});
