/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/Stretch","sap/ui/rta/plugin/ControlVariant","sap/ui/dt/plugin/ToolHooks","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/dt/ElementUtil","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry","sap/base/strings/capitalize","sap/base/util/UriParameters","sap/ui/performance/Measurement","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/fl/write/api/PersistenceWriteAPI"],function(q,M,F,S,P,D,O,C,a,L,R,b,c,d,e,f,A,g,h,i,j,k,l,m,n,T,o,p,U,r,E,s,t,u,v,w,B,x,y,z,G,H,I,J,K,N,Q,V,W,X){"use strict";var Y="sap-ui-fl-max-layer";var Z="STARTING";var $="STARTED";var _="STOPPED";var a1="FAILED";var b1="SERVICE_STARTING";var c1="SERVICE_STARTED";var d1="SERVICE_FAILED";var e1=M.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{customFieldUrl:"string",showCreateCustomField:"boolean",showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},plugins:{type:"any",defaultValue:{}},flexSettings:{type:"object",defaultValue:{layer:"CUSTOMER",developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"},validateAppVersion:{type:"boolean",defaultValue:false}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},_sAppTitle:null,_dependents:null,_sStatus:_,constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this.iEditableOverlaysCount=0;this.addDependent(new w(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}if(window.parent!==window){this.startService('receiver');}},_RESTART:{NOT_NEEDED:"no restart",VIA_HASH:"without max layer",RELOAD_PAGE:"reload"}});e1.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var i1=new a({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new k({commandFactory:i1,multiSelectionRequiredPlugins:[i.getMetadata().getName(),e.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var j1=new c({commandFactory:i1});this._mDefaultPlugins["dragDrop"]=new b({elementMover:j1,commandFactory:i1,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:i1,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:i1,analyzer:h,dialog:new g()});this._mDefaultPlugins["createContainer"]=new f({commandFactory:i1});this._mDefaultPlugins["remove"]=new e({commandFactory:i1});this._mDefaultPlugins["cutPaste"]=new d({elementMover:j1,commandFactory:i1});this._mDefaultPlugins["settings"]=new l({commandFactory:i1});this._mDefaultPlugins["combine"]=new i({commandFactory:i1});this._mDefaultPlugins["split"]=new j({commandFactory:i1});this._mDefaultPlugins["contextMenu"]=new o();this._mDefaultPlugins["tabHandling"]=new p();this._mDefaultPlugins["stretch"]=new m();this._mDefaultPlugins["controlVariant"]=new n({commandFactory:i1});this._mDefaultPlugins["toolHooks"]=new T();}return q.extend({},this._mDefaultPlugins);};e1.prototype.addDependent=function(i1,j1,k1){k1=typeof k1==='undefined'?true:!!k1;if(!(j1 in this._dependents)){if(j1&&k1){this['get'+K(j1,0)]=this.getDependent.bind(this,j1);}this._dependents[j1||i1.getId()]=i1;}else{throw r.createError("RuntimeAuthoring#addDependent",r.printf("Can't add dependency with same key '{0}'",j1),"sap.ui.rta");}};e1.prototype.getDependent=function(i1){return this._dependents[i1];};e1.prototype.getDependents=function(){return this._dependents;};e1.prototype.removeDependent=function(i1){delete this._dependents[i1];};e1.prototype._destroyDefaultPlugins=function(i1){for(var j1 in this._mDefaultPlugins){var k1=this._mDefaultPlugins[j1];if(k1&&!k1.bIsDestroyed){if(!i1||i1[j1]!==k1){k1.destroy();}}}if(!i1){this._mDefaultPlugins=null;}};e1.prototype.onPopupOpen=function(i1){if(i1.getParameters()instanceof sap.m.Dialog&&this.getToolbar()instanceof F){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};e1.prototype.onPopupClose=function(i1){if(i1.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};e1.prototype.setPlugins=function(i1){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",i1);};e1.prototype.setFlexSettings=function(i1){var j1=new N(window.location.href);var k1=j1.get("sap-ui-layer");i1=q.extend({},this.getFlexSettings(),i1);if(k1){i1.layer=k1.toUpperCase();}if(i1.scenario||i1.baseId){var l1=s.buildLrepRootNamespace(i1.baseId,i1.scenario,i1.projectId);i1.rootNamespace=l1;i1.namespace=l1+"changes/";}U.setRtaStyleClassName(i1.layer);this.setProperty("flexSettings",i1);};e1.prototype.getLayer=function(){return this.getFlexSettings().layer;};e1.prototype.getRootControlInstance=function(){if(!this._oRootControl){this._oRootControl=E.getElementInstance(this.getRootControl());}return this._oRootControl;};e1.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};e1.prototype.start=function(){this._sStatus=Z;var i1;var j1;var k1=this.getRootControlInstance();if(!this._oDesignTime){if(!k1){j1=new Error("Root control not found");s.log.error(j1);return Promise.reject(j1);}if(this.getValidateAppVersion()&&!s.isCorrectAppVersionFormat(s.getAppVersionFromManifest(s.getAppComponentForControl(k1).getManifest()))){j1=this._getTextResources().getText("MSG_INCORRECT_APP_VERSION_ERROR");s.log.error(j1);return Promise.reject(j1);}return this._handleHigherLayerChangesOnStart().then(function(l1){if(l1){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(o1){if(this.getPlugins()[o1].attachElementModified){this.getPlugins()[o1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var m1=Object.keys(this.getPlugins());var n1=m1.map(function(o1){return this.getPlugins()[o1];},this);i1=new Promise(function(o1,p1){Q.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:n1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()==="USER"){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}else{q("body").addClass("sapUiRtaMode");}this._oDesignTime.getSelectionManager().attachChange(function(q1){this.fireSelectionChange({selection:q1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){o1();Q.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(q1){p1(q1.getParameter("error"));});}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getPublishAndAppVariantSupportVisibility().then(function(l1){var m1=l1[0];var n1=l1[1];this._createToolsMenu(m1,n1);}.bind(this));}}.bind(this)).then(function(){this._onStackModified();}.bind(this)).then(function(){y.loadStyles('InPageStyles').then(function(l1){var m1=l1.replace(/%scrollWidth%/g,x.getScrollbarWidth()+'px');x.insertStyles(m1,O.getOverlayContainer().get(0));});}).then(function(){return i1;}).then(function(){this.getPopupManager().setRta(this);if(this.getShowToolbars()){return this.getToolbar().show();}}.bind(this)).then(function(){if(G.browser.name==="ff"){q(document).on('contextmenu',f1);}}).then(function(){this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);var l1=J.getOverlay(this.getRootControl());this._$RootControl=l1.getAssociatedDomRef();if(this._$RootControl){this._$RootControl.addClass("sapUiRtaRoot");}}.bind(this)).then(function(){this._sStatus=$;this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});}.bind(this)).catch(function(j1){if(j1!=="Reload triggered"){this._sStatus=a1;this.fireFailed(j1);}if(j1){return Promise.reject(j1);}}.bind(this));}};function f1(){return false;}e1.prototype._getPublishAndAppVariantSupportVisibility=function(){return t.getInstance().then(function(i1){var j1=z.isPlatFormEnabled(this.getRootControlInstance(),this.getLayer(),this._oSerializer);return[!i1.isProductiveSystem()&&!i1.hasMergeErrorOccured(),!i1.isProductiveSystem()&&j1];}.bind(this)).catch(function(){return false;});};var g1=function(i1){B.hide();var j1="";if(i1.messages&&Array.isArray(i1.messages)&&i1.messages.length>0){j1=i1.messages.reduce(function(m1,n1){return m1.concat(n1.severity==="Error"?n1.text+"\n":"");},j1);}if(!j1){j1=i1.stack||i1.message||i1.status||i1;}var k1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");V.error("Failed to transfer runtime adaptation changes to layered repository",j1);var l1=k1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+k1.getText("MSG_ERROR_REASON",j1);u.error(l1,{styleClass:U.getRtaStyleClassName()});};e1.prototype.setCommandStack=function(i1){var j1=this.getProperty("commandStack");if(j1){j1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var k1=this.setProperty("commandStack",i1);if(i1){i1.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(i1);}return k1;};e1.prototype.getCommandStack=function(){var i1=this.getProperty("commandStack");if(!i1){i1=new C();this._oInternalCommandStack=i1;this.setCommandStack(i1);}return i1;};e1.prototype._onStackModified=function(){var i1=this.getCommandStack();var j1=i1.canUndo();var k1=i1.canRedo();if(this.getShowToolbars()){this.getToolbar().setUndoRedoEnabled(j1,k1);this.getToolbar().setPublishEnabled(this._bChangesExist||j1);this.getToolbar().setRestoreEnabled(this._bChangesExist||j1);}this.fireUndoRedoStackModified();};e1.prototype._closeToolbar=function(){if(this.getShowToolbars()&&this.getToolbar){return this.getToolbar().hide();}};e1.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}return[];};e1.prototype.stop=function(i1,j1){return((j1)?Promise.resolve(this._RESTART.NOT_NEEDED):this._handleReloadOnExit()).then(function(k1){return((i1)?Promise.resolve():this._serializeToLrep(this)).then(this._closeToolbar.bind(this)).then(function(){this.fireStop();if(k1!==this._RESTART.NOT_NEEDED){this._removeMaxLayerParameter();if(k1===this._RESTART.RELOAD_PAGE){this._reloadPage();}}}.bind(this));}.bind(this)).catch(g1).then(function(){this._sStatus=_;q("body").removeClass("sapUiRtaMode");}.bind(this));};e1.prototype.restore=function(){this._onRestore();};e1.prototype.transport=function(){return this._onTransport();};e1.prototype.undo=function(){return this._onUndo();};e1.prototype.redo=function(){return this._onRedo();};e1.prototype.canUndo=function(){return this.getCommandStack().canUndo();};e1.prototype.canRedo=function(){return this.getCommandStack().canRedo();};e1.prototype._onKeyDown=function(i1){var j1=G.os.macintosh;var k1=O.getOverlayContainer().get(0).contains(document.activeElement);var l1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var m1=false;q(".sapUiDtContextMenu").each(function(q1,r1){if(r1.contains(document.activeElement)){m1=true;}});var n1=document.body===document.activeElement;var o1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if((k1||l1||m1||n1)&&!o1){var p1=j1?i1.metaKey:i1.ctrlKey;if(i1.keyCode===W.Z&&i1.shiftKey===false&&i1.altKey===false&&p1===true){this._onUndo().then(i1.stopPropagation.bind(i1));}else if(((j1&&i1.keyCode===W.Z&&i1.shiftKey===true)||(!j1&&i1.keyCode===W.Y&&i1.shiftKey===false))&&i1.altKey===false&&p1===true){this._onRedo().then(i1.stopPropagation.bind(i1));}}};e1.prototype._onUnload=function(){var i1=this.getCommandStack();var j1=i1.canUndo()||i1.canRedo();if(j1&&this.getShowWindowUnloadDialog()){var k1=this._getTextResources().getText("MSG_UNSAVED_CHANGES");return k1;}window.onbeforeunload=this._oldUnloadHandler;};e1.prototype._serializeToLrep=function(){return this._oSerializer.saveCommands().then(this._invalidateCache.bind(this));};e1.prototype._invalidateCache=function(){return X.getUIChanges({invalidateCache:true,managedObject:this.getRootControlInstance()});};e1.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};e1.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};e1.prototype._createToolsMenu=function(i1,j1){if(!this.getDependent('toolbar')){var k1;if(this.getLayer()==="USER"){k1=P;}else if(U.getFiori2Renderer()){k1=F;}else{k1=S;}if(this.getLayer()==="USER"){this.addDependent(new k1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,true),restore:this._onRestore.bind(this)}),'toolbar');}else{this.addDependent(new k1({modeSwitcher:this.getMode(),publishVisible:i1,textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:z.onGetOverview.bind(null,true),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:z.onSaveAsFromRtaToolbar.bind(null,true,true)}),'toolbar');}var l1;if(j1){this.getToolbar().getControl('saveAs').setVisible(j1);l1=z.isOverviewExtended();if(l1){this.getToolbar().getControl('appVariantOverview').setVisible(j1);}else{this.getToolbar().getControl('manageApps').setVisible(j1);}z.isManifestSupported().then(function(m1){if(l1){this.getToolbar().getControl('appVariantOverview').setEnabled(m1);}else{this.getToolbar().getControl('manageApps').setEnabled(m1);}this.getToolbar().getControl('saveAs').setEnabled(m1);}.bind(this));}this._checkChangesExist().then(function(m1){if(!this.bIsDestroyed){this._bChangesExist=m1;this.getToolbar().setPublishEnabled(m1);this.getToolbar().setRestoreEnabled(m1);}}.bind(this));}};e1.prototype._onGetAppVariantOverview=function(i1){var j1=i1.getParameter("item");var k1=j1.getId()==='keyUser';return z.onGetOverview(k1);};e1.prototype.destroy=function(){q.map(this._dependents,function(i1,j1){this.removeDependent(j1);i1.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(i1){this.stopService(i1);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._$RootControl){this._$RootControl.removeClass("sapUiRtaRoot");}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy();}if(G.browser.name==="ff"){q(document).off("contextmenu",f1);}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};e1.prototype._onTransport=function(){this._handleStopCutPaste();B.show(500);return this._serializeToLrep().then(function(){B.hide();var i1=s.isApplicationVariant(this._oRootControl)&&!s.isVariantByStartupParameter(this._oRootControl);return((i1)?z.getAppVariantDescriptor(this._oRootControl):Promise.resolve()).then(function(j1){var k1=[];if(j1){k1.push(j1);}return X._transportChanges(this._oRootControl,U.getRtaStyleClassName(),this.getLayer(),k1).then(function(l1){if(l1!=="Error"&&l1!=="Cancel"){this._showMessageToast("MSG_TRANSPORT_SUCCESS");}}.bind(this));}.bind(this));}.bind(this))['catch'](g1);};e1.prototype._deleteChanges=function(){var i1=this.getRootControlInstance();var j1=s.getAppComponentForControl(i1);return X.resetChanges(this.getLayer(),"Change.createInitialFileContent",j1).then(function(){this._reloadPage();}.bind(this)).catch(function(k1){return U._showMessageBox(u.Icon.ERROR,"HEADER_RESTORE_FAILED","MSG_RESTORE_FAILED",k1);});};e1.prototype._reloadPage=function(){window.location.reload();};e1.prototype._showMessageToast=function(i1){var j1=this._getTextResources().getText(i1);v.show(j1);};e1.needsRestart=function(i1){var j1=!!window.sessionStorage.getItem("sap.ui.rta.restart."+i1);return j1;};e1.enableRestart=function(i1){window.sessionStorage.setItem("sap.ui.rta.restart."+i1,true);};e1.disableRestart=function(i1){window.sessionStorage.removeItem("sap.ui.rta.restart."+i1);};e1.prototype._onRestore=function(){var i1=this.getLayer()==="USER"?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var j1=this.getLayer()==="USER"?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");var k1=function(l1){if(l1==="OK"){e1.enableRestart(this.getLayer());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this);this._handleStopCutPaste();u.confirm(i1,{icon:u.Icon.WARNING,title:j1,onClose:k1,styleClass:U.getRtaStyleClassName()});};e1.prototype._scheduleRenameOnCreatedContainer=function(i1,j1){var k1=function(o1){var p1=this.getPlugins()["createContainer"].getCreatedContainerId(i1,o1.getElement().getId());var q1=J.getOverlay(p1);q1.setSelected(true);this.getPlugins()["rename"].startEdit(q1);};var l1=function(o1){var p1=o1.getSource();if(p1.getGeometry()&&p1.getGeometry().visible){k1.call(this,p1);p1.detachEvent('geometryChanged',l1,this);}};var m1=function(o1){if(!o1.getGeometry()||!o1.getGeometry().visible){o1.attachEvent('geometryChanged',l1,this);}else{k1.call(this,o1);}};var n1=function(o1){var p1=o1.getParameter("elementOverlay");if(p1.getElement().getId()===j1){this._oDesignTime.detachEvent("elementOverlayCreated",n1,this);if(p1.isRendered()){m1.call(this,p1);}else{p1.attachEventOnce('afterRendering',function(o1){m1.call(this,o1.getSource());},this);}}};this._oDesignTime.attachEvent("elementOverlayCreated",n1,this);};e1.prototype._handleElementModified=function(i1){this._handleStopCutPaste();var j1=i1.getParameter("action");var k1=i1.getParameter("newControlId");var l1=i1.getParameter("command");if(l1 instanceof sap.ui.rta.command.BaseCommand){if(j1&&k1){this._scheduleRenameOnCreatedContainer(j1,k1);}return this.getCommandStack().pushAndExecute(l1).catch(function(m1){if(m1&&m1.message&&m1.message.indexOf("The following Change cannot be applied because of a dependency")>-1){U._showMessageBox(u.Icon.ERROR,"HEADER_DEPENDENCY_ERROR","MSG_DEPENDENCY_ERROR",m1);}s.log.error("sap.ui.rta: "+m1.message);});}return Promise.resolve();};e1.prototype._onElementEditableChange=function(i1){var j1=i1.getParameter("editable");if(j1){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};e1.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};e1.prototype._checkChangesExist=function(){var i1=this.getRootControlInstance();var j1=s.getAppComponentForControl(i1);if(s.getComponentName(j1).length>0){return X.getUIChanges({currentLayer:this.getLayer(),includeCtrlVariants:true,invalidateCache:false,managedObject:j1}).then(function(k1){return k1.length>0;});}return Promise.resolve(false);};e1.prototype._buildNavigationArguments=function(i1){return{target:{semanticObject:i1.semanticObject,action:i1.action,context:i1.contextRaw},params:i1.params,appSpecificRoute:i1.appSpecificRoute,writeHistory:false};};e1.prototype._hasMaxLayerParameter=function(i1){var j1=this.getLayer();return i1.params&&i1.params[Y]&&i1.params[Y][0]===j1;};e1.prototype._reloadWithoutHigherLayerChangesOnStart=function(i1,j1){var k1=this.getLayer();if(!this._hasMaxLayerParameter(i1)){if(!i1.params){i1.params={};}i1.params[Y]=[k1];e1.enableRestart(k1);j1.toExternal(this._buildNavigationArguments(i1));return Promise.resolve(true);}};e1.prototype._removeMaxLayerParameter=function(){if(s.getUshellContainer()&&this.getLayer()!=="USER"){var i1=s.getUshellContainer().getService("CrossApplicationNavigation");var j1=s.getParsedURLHash();if(i1.toExternal&&j1){if(this._hasMaxLayerParameter(j1)){delete j1.params[Y];i1.toExternal(this._buildNavigationArguments(j1));}}}};e1.prototype._handleReloadWithoutHigherLayerChangesMessageBoxOnStart=function(){var i1=this.getLayer();var j1=i1==="CUSTOMER"?"MSG_PERSONALIZATION_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST";return U._showMessageBox(u.Icon.INFORMATION,"HEADER_PERSONALIZATION_EXISTS",j1);};e1.prototype._handleReloadMessageBox=function(i1){return U._showMessageBox(u.Icon.INFORMATION,"HEADER_RELOAD_NEEDED",i1,undefined,"BUTTON_RELOAD_NEEDED");};e1.prototype._handleHigherLayerChangesOnStart=function(){var i1=s.getUshellContainer();if(i1&&this.getLayer()!=="USER"){var j1=s.getParsedURLHash();return X.hasHigherLayerChanges(this.getRootControlInstance(),{ignoreMaxLayerParameter:false}).then(function(k1){if(k1){return this._handleReloadWithoutHigherLayerChangesMessageBoxOnStart().then(function(){var l1=i1.getService("CrossApplicationNavigation");if(l1.toExternal&&j1){return this._reloadWithoutHigherLayerChangesOnStart(j1,l1);}}.bind(this));}}.bind(this));}return Promise.resolve(false);};e1.prototype._handleReloadOnExit=function(){return Promise.all([this._oSerializer.needsReload(),X.hasHigherLayerChanges(this.getRootControlInstance(),{ignoreMaxLayerParameter:true})]).then(function(i1){var j1=i1[0],k1=i1[1];if(j1||k1){var l1=this._RESTART.RELOAD_PAGE;var m1,n1;if(k1){var o1=this.getLayer();m1=o1==="CUSTOMER"?"MSG_RELOAD_WITH_PERSONALIZATION":"MSG_RELOAD_WITH_ALL_CHANGES";n1=s.getUshellContainer();if(!j1&&n1){l1=this._RESTART.VIA_HASH;}}else if(j1){m1="MSG_RELOAD_NEEDED";}return this._handleReloadMessageBox(m1).then(function(){return l1;});}return this._RESTART.NOT_NEEDED;}.bind(this));};e1.prototype._onModeChange=function(i1){this.setMode(i1.getParameter("item").getKey());};e1.prototype.setMode=function(i1){if(this.getProperty('mode')!==i1){var j1=this.getShowToolbars()&&this.getToolbar().getControl('modeSwitcher');var k1=i1==='adaptation';if(j1){j1.setSelectedButton(j1.getItems().filter(function(l1){return l1.getKey()===i1;}).pop().getId());}this._oDesignTime.setEnabled(k1);this.getPlugins()['tabHandling'][k1?'removeTabIndex':'restoreTabIndex']();this.setProperty('mode',i1);this.fireModeChanged({mode:i1});}};e1.prototype.setMetadataScope=function(i1){if(this._oDesignTime){V.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',i1);};function h1(i1){if(H.hasOwnProperty(i1)){return H[i1].replace(/\./g,'/');}}e1.prototype.startService=function(i1){if(this._sStatus!==$){return new Promise(function(l1,m1){this.attachEventOnce('start',l1);this.attachEventOnce('failed',m1);}.bind(this)).then(function(){return this.startService(i1);}.bind(this),function(){return Promise.reject(r.createError("RuntimeAuthoring#startService",r.printf("Can't start the service '{0}' while RTA has been failed during a startup",i1),"sap.ui.rta"));});}var j1=h1(i1);var k1;if(!j1){return Promise.reject(r.createError("RuntimeAuthoring#startService",r.printf("Unknown service. Can't find any registered service by name '{0}'",i1),"sap.ui.rta"));}k1=this._mServices[i1];if(k1){switch(k1.status){case c1:{return Promise.resolve(k1.exports);}case b1:{return k1.initPromise;}case d1:{return k1.initPromise;}default:{return Promise.reject(r.createError("RuntimeAuthoring#startService",r.printf("Unknown service status. Service name = '{0}'",i1),"sap.ui.rta"));}}}else{this._mServices[i1]=k1={status:b1,location:j1,initPromise:new Promise(function(l1,m1){sap.ui.require([j1],function(n1){k1.factory=n1;if(!this._oServiceEventBus){this._oServiceEventBus=new I();}r.wrapIntoPromise(n1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,i1)).then(function(o1){if(this.bIsDestroyed){throw r.createError("RuntimeAuthoring#startService",r.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",i1),"sap.ui.rta");}if(!q.isPlainObject(o1)){throw r.createError("RuntimeAuthoring#startService",r.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",i1),"sap.ui.rta");}k1.service=o1;k1.exports={};if(Array.isArray(o1.events)&&o1.events.length>0){q.extend(k1.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,i1),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,i1),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,i1)});}var p1=o1.exports||{};q.extend(k1.exports,Object.keys(p1).reduce(function(q1,r1){var s1=p1[r1];q1[r1]=typeof s1==="function"?r.waitForSynced(this._oDesignTime,s1):s1;return q1;}.bind(this),{}));k1.status=c1;l1(Object.freeze(k1.exports));}.bind(this)).catch(m1);}.bind(this),function(n1){k1.status=d1;m1(r.propagateError(n1,"RuntimeAuthoring#startService",r.printf("Can't load service '{0}' by its name: {1}",i1,j1),"sap.ui.rta"));});}.bind(this)).catch(function(l1){k1.status=d1;return Promise.reject(r.propagateError(l1,"RuntimeAuthoring#startService",r.printf("Error during service '{0}' initialisation.",i1),"sap.ui.rta"));})};return k1.initPromise;}};e1.prototype.stopService=function(i1){var j1=this._mServices[i1];if(j1){if(j1.status===c1){if(typeof j1.service.destroy==="function"){j1.service.destroy();}}delete this._mServices[i1];}else{throw r.createError("RuntimeAuthoring#stopService",r.printf("Can't destroy service: unable to find service with name '{0}'",i1),"sap.ui.rta");}};e1.prototype.getService=function(i1){return this.startService(i1);};return e1;},true);
