/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/rta/appVariant/AppVariantDialog","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Feature","sap/ui/rta/appVariant/S4HanaCloudBackend","sap/ui/core/BusyIndicator"],function(M,A,a,R,S,B){"use strict";var b=M.extend("sap.ui.rta.appVariant.AppVariantManager",{metadata:{library:"sap.ui.rta",properties:{rootControl:{type:"sap.ui.core.Control"},commandSerializer:{type:"object"}}}});b.prototype._openDialog=function(c,C){var d=new A("appVariantDialog");d.attachCreate(c);d.attachCancel(C);d.attachAfterClose(function(){this.destroy();});d.open();return d;};b.prototype._prepareAppVariantData=function(d,p){return{idRunningApp:d["sap.app"].id,title:p.title,subTitle:p.subTitle,description:p.description,icon:p.icon,inbounds:d["sap.app"].crossNavigation&&d["sap.app"].crossNavigation.inbounds?d["sap.app"].crossNavigation.inbounds:null};};b.prototype.createAllInlineChanges=function(o){var s,c=[],p;s=a.getId(o.idRunningApp);var d={id:s,reference:o.idRunningApp};c.push(a.createDescriptorVariant(d));p=a.getInlinePropertyChange("title",o.title);c.push(a.createInlineChange(p,"title"));p=a.getInlinePropertyChange("subtitle",o.subTitle);c.push(a.createInlineChange(p,"subtitle"));p=a.getInlinePropertyChange("description",o.description);c.push(a.createInlineChange(p,"description"));p=a.getInlineChangeInputIcon(o.icon);c.push(a.createInlineChange(p,"icon"));var i=a.getInboundInfo(o.inbounds);var C=i.currentRunningInbound;var e=i.addNewInboundRequired;if(C==="customer.savedAsAppVariant"&&e){p=a.getInlineChangeCreateInbound(C);c.push(a.createInlineChange(p,"createInbound"));}p=a.getInlineChangeForInboundPropertySaveAs(C);c.push(a.createInlineChange(p,"inbound"));p=a.getInlineChangeRemoveInbounds(C);c.push(a.createInlineChange(p,"removeInbound"));p=a.getInlineChangesForInboundProperties(C,s,"title",o.title);c.push(a.createInlineChange(p,"inboundTitle"));p=a.getInlineChangesForInboundProperties(C,s,"subTitle",o.subTitle);c.push(a.createInlineChange(p,"inboundSubtitle"));p=a.getInlineChangesForInboundProperties(C,s,"icon",o.icon);c.push(a.createInlineChange(p,"inboundIcon"));return c;};b.prototype.createDescriptor=function(o){var i=this.createAllInlineChanges(o);var c;return Promise.all(i).then(function(r){c=r.shift();i=[];r.forEach(function(I){i.push(c.addDescriptorInlineChange(I));});return Promise.all(i);}).then(function(){var n=c.getNamespace();var s=c.getSettings();if(a.isS4HanaCloud(s)){var t=a.getTransportInput("",n,"manifest","appdescr_variant");return a.openTransportSelection(t);}return Promise.resolve({packageName:"$TMP",transport:""});}).then(function(t){return a.onTransportInDialogSelected(c,t);}).catch(function(e){var E=a.buildErrorInfo("MSG_CREATE_DESCRIPTOR_FAILED",e,c.getId());B.hide();return a.showRelevantDialog(E,false);});};b.prototype.processSaveAsDialog=function(d,s){return new Promise(function(r){var c=function(o){var p=o.getParameters();var e=this._prepareAppVariantData(d,p);r(e);}.bind(this);var C=function(){if(!s){return R.onGetOverview(true);}};return this._openDialog(c,C);}.bind(this));};b.prototype.saveAppVariantToLREP=function(o){return o.submit().catch(function(e){return a.catchErrorDialog(e,"MSG_SAVE_APP_VARIANT_FAILED",o.getId());});};b.prototype._takeOverDirtyChangesByAppVariant=function(r){return this.getCommandSerializer().saveAsCommands(r);};b.prototype._deleteAppVariantFromLREP=function(s){return a.triggerDeleteAppVariantFromLREP(s);};b.prototype.copyUnsavedChangesToLREP=function(s,c){var C=this.getCommandSerializer().getCommandStack();if(c&&C.getAllExecutedCommands().length){return this._takeOverDirtyChangesByAppVariant(s).catch(function(e){return this._deleteAppVariantFromLREP(s).catch(function(e){return a.catchErrorDialog(e,"SAVE_AS_MSG_DELETE_APP_VARIANT",s);}).then(function(){return a.catchErrorDialog(e,"MSG_COPY_UNSAVED_CHANGES_FAILED");});}.bind(this));}return Promise.resolve();};b.prototype.triggerCatalogPublishing=function(o,s){var t=s?a.triggerCatalogAssignment:a.triggerCatalogUnAssignment;return t(o.getId(),o.getReference()).catch(function(e){var m=s?"MSG_CATALOG_ASSIGNMENT_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";return a.catchErrorDialog(e,m,o.getId());});};b.prototype.notifyKeyUserWhenPublishingIsReady=function(i,s,c){var o=new S();return o.notifyFlpCustomizingIsReady(i,c).catch(function(e){B.hide();var m=c?"MSG_TILE_CREATION_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";if(!c&&e.error==="locked"){m="MSG_CATALOGS_LOCKED";}return a.catchErrorDialog(e,m,s);});};b.prototype.showSuccessMessage=function(s){B.hide();return a.showRelevantDialog(s,true);};return b;},true);
