/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/dt/Plugin","sap/ui/fl/Utils","sap/ui/fl/registry/ChangeRegistry","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/ElementOverlay","sap/ui/fl/changeHandler/JsControlTreeModifier"],function(P,F,C,O,a,E,J){"use strict";E.prototype._bElementHasStableId=undefined;E.prototype.getElementHasStableId=function(){return this._bElementHasStableId;};E.prototype.setElementHasStableId=function(h){this._bElementHasStableId=h;};E.prototype.hasElementStableId=function(){return!!this._bElementHasStableId;};var B=P.extend("sap.ui.rta.plugin.Plugin",{metadata:{"abstract":true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});B.prototype._isEditable=function(){};var e=function(o,c){var g=function(d){if(d.getSource().getGeometry()&&d.getSource().getGeometry().visible){o.detachEvent('geometryChanged',g,this);c();}};if(!o.getGeometry()||!o.getGeometry().visible){o.attachEvent('geometryChanged',g,this);}else{c();}};var _=function(o){var p=o.getParameters();var r;var c=o.getSource();if(p.type==="propertyChanged"&&p.name==="visible"){r=this._getRelevantOverlays(c);if(p.value===true){e(c,function(){this.evaluateEditable(r,{onRegistration:false});}.bind(this));}else{this.evaluateEditable(r,{onRegistration:false});}}else if(p.type==="afterRendering"){if(this.getDesignTime().getStatus()==='synced'){this.evaluateEditable([c],{onRegistration:false});}else{this.getDesignTime().attachEventOnce("synced",function(){this.evaluateEditable([c],{onRegistration:false});},this);}}else if(p.type==="insertAggregation"||p.type==="removeAggregation"){r=this._getRelevantOverlays(c,p.name);this.evaluateEditable(r,{onRegistration:false});}};B.prototype._getRelevantOverlays=function(o,A){var c=o.getRelevantOverlays();if(c.length===0){var r=a.findAllOverlaysInContainer(o);if(A){var d=o.getAggregationOverlay(A).getChildren();d=d.filter(function(f){return r.indexOf(f)===-1;});r=r.concat(d);}o.setRelevantOverlays(r);return r;}return c;};B.prototype.evaluateEditable=function(o,p){var c=[];if(!p.onRegistration&&this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){return;}this.setProcessingStatus(true);o.forEach(function(d){var v=d.getElement()&&d.getDesignTimeMetadata()&&!d.getDesignTimeMetadata().markedAsNotAdaptable()&&this._isEditable(d,p);if(v instanceof Promise){v.then(function(f){this._handleModifyPluginList(d,f);}.bind(this));c.push(v);}else{this._handleModifyPluginList(d,v);}}.bind(this));if(c.length){Promise.all(c).then(function(){this.setProcessingStatus(false);}.bind(this)).catch(function(){this.setProcessingStatus(false);});}else{this.setProcessingStatus(false);}};B.prototype._handleModifyPluginList=function(o,v){if(v!==undefined&&v!==null){if(typeof v==="boolean"){this._modifyPluginList(o,v);}else{this._modifyPluginList(o,v.asChild,false);this._modifyPluginList(o,v.asSibling,true);}}};B.prototype._modifyPluginList=function(o,i,c){if(i){this.addToPluginsList(o,c);}else{this.removeFromPluginsList(o,c);}};B.prototype._retrievePluginName=function(s){var n=this.getMetadata().getName();if(s!==undefined){n+=s?".asSibling":".asChild";}return n;};B.prototype._isEditableByPlugin=function(o,s){var p=this._retrievePluginName(s);var c=o.getEditableByPlugins();return c.indexOf(p)>-1;};B.prototype.registerElementOverlay=function(o){e(o,function(){this.evaluateEditable([o],{onRegistration:true});o.attachElementModified(_,this);}.bind(this));};B.prototype.deregisterElementOverlay=function(o){this.removeFromPluginsList(o);this.removeFromPluginsList(o,true);this.removeFromPluginsList(o,false);o.detachElementModified(_,this);};B.prototype.hasStableId=function(o){if(!o||o._bIsBeingDestroyed){return false;}if(!o.getDesignTimeMetadata()){return false;}if(o.getElementHasStableId()===undefined){var s=o.getDesignTimeMetadata().getStableElements(o);var u=s.length>0?s.some(function(S){var c=S.id||S;if(!F.checkControlId(c,S.appComponent)){return b(o,S);}}):true;o.setElementHasStableId(!u);}return o.hasElementStableId();};function b(o,s){var A=a.getAggregationInformation(o,o.getElement().sParentAggregationName);if(!A.templateId){return true;}return!F.checkControlId(A.templateId,s.appComponent);}B.prototype.getVariantManagementReference=function(o,A,f,s){var c;if(!s){c=o.getElement();}else{c=s;}var r;if((A.changeOnRelevantContainer||f)&&!s){r=o.getRelevantContainer();}else{r=c;}var v;if(o.getVariantManagement&&this._hasVariantChangeHandler(A.changeType,r)){v=o.getVariantManagement();}return v;};B.prototype._hasVariantChangeHandler=function(c,o){var d=this._getChangeHandler(c,o);return(d&&d.revertChange);};B.prototype.checkAggregationsOnSelf=function(o,A,p){var d=o.getDesignTimeMetadata();var c=o.getElement();var i=false;var f=d.getActionDataFromAggregations(A,o.getElement());var g=f.filter(function(j){if(j&&p){return j.aggregation===p;}return true;})[0];var s=g?g.changeType:null;var h=g&&g.changeOnRelevantContainer;if(h){c=o.getRelevantContainer();var r=O.getOverlay(c);if(!this.hasStableId(r)){return false;}}if(s&&this.hasChangeHandler(s,c)){i=true;}return i;};B.prototype.removeFromPluginsList=function(o,s){var n=this._retrievePluginName(s);o.removeEditableByPlugin(n);if(!o.getEditableByPlugins().length){o.setEditable(false);}};B.prototype.addToPluginsList=function(o,s){var n=this._retrievePluginName(s);var p=o.getEditableByPlugins();if(p.indexOf(n)===-1){o.addEditableByPlugin(n);o.setEditable(true);}};B.prototype.hasChangeHandler=function(c,o,A){if(A===true){return Promise.resolve().then(this._getChangeHandler.bind(this,c,o)).then(function(d){return!!d;});}return!!this._getChangeHandler(c,o);};B.prototype._getChangeHandler=function(c,o,s){if(!s){s=o.getMetadata().getName();}var l=this.getCommandFactory().getFlexSettings().layer;return C.getInstance().getChangeHandler(c,s,o,J,l);};B.prototype.isAvailable=function(c){return c.every(function(o){return this._isEditableByPlugin(o);},this);};B.prototype._checkRelevantContainerStableID=function(A,o){if(A.changeOnRelevantContainer){var r=o.getRelevantContainer();var R=O.getOverlay(r);if(!this.hasStableId(R)){return false;}}return true;};return B;},true);
