/*!
* OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Component","sap/ui/support/supportRules/Analyzer","sap/ui/support/supportRules/CoreFacade","sap/ui/support/supportRules/ExecutionScope","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/History","sap/ui/support/supportRules/report/DataCollector","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/RuleSetLoader","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/library"],function(q,M,E,C,A,a,b,H,c,I,d,D,f,g,R,h,l){"use strict";var j=null;var m=null;var k=M.extend("sap.ui.support.Main",{constructor:function(){if(!m){this._oCore=null;this._oAnalyzer=new A();this._oAnalyzer.onNotifyProgress=function(i){c.publish(f.ON_PROGRESS_UPDATE,{currentProgress:i});};M.apply(this,arguments);var e=document.createEvent("CustomEvent");e.initCustomEvent("supportToolLoaded",true,true,{});}else{q.sap.log.warning("Only one support tool allowed");return m;}}});k.prototype._isInIframe=function(){try{return window.self!==window.top;}catch(e){return true;}};k.prototype.startPlugin=function(s){if(this._pluginStarted){return;}this._pluginStarted=true;var t=this;sap.ui.getCore().registerPlugin({startPlugin:function(o){t._supportModeConfig=s=s||o.getConfiguration().getSupportMode();c.bSilentMode=s.indexOf("silent")>-1;t._setCommunicationSubscriptions();var F=t._isInIframe()&&s.indexOf("frame-force-ui")!==-1;t._oCore=o;t._oDataCollector=new D(o);t._oCoreFacade=a(o);t._oExecutionScope=null;t._createElementSpies();o.attachLibraryChanged(R._onLibraryChanged);if(!s||s.indexOf("silent")===-1||F){sap.ui.require(["sap/ui/support/supportRules/ui/IFrameController"],function(e){j=e;j.injectFrame(s);c.onMessageChecks.push(function(i){return i.origin===j.getFrameOrigin();});c.onMessageChecks.push(function(i){return i.data._frameIdentifier===j.getFrameIdentifier();});c.onMessageChecks.push(function(i){var n=j.getFrameUrl();n=n.replace(/\.\.\//g,'');return i.data._origin.indexOf(n)>-1;});});}else{R.updateRuleSets(function(){t.fireEvent("ready");});}},stopPlugin:function(){j._stop();t._pluginStarted=false;t._oCore=null;t._oCoreFacade=null;t._oDataCollector=null;t._oExecutionScope=null;}});};k.prototype._createElementSpies=function(){var t=this,n=500;this._fnDirtyTimeoutHandle=null;var s=function(N){var o=E.prototype[N];E.prototype[N]=function(){o.apply(this,arguments);clearTimeout(t._fnDirtyTimeoutHandle);t._fnDirtyTimeoutHandle=setTimeout(function(){c.publish(f.ON_CORE_STATE_CHANGE);},n);};};s("register");s("deregister");};k.prototype._setCommunicationSubscriptions=function(){c.subscribe(f.VERIFY_CREATE_RULE,function(t){var T=h.deserialize(t),o=R.getRuleSet(g.TEMP_RULESETS_NAME).ruleset,r=o.addRule(T);c.publish(f.VERIFY_RULE_CREATE_RESULT,{result:r,newRule:h.serialize(T)});},this);c.subscribe(f.VERIFY_UPDATE_RULE,function(e){var t=h.deserialize(e.updateObj),T=R.getRuleSet(g.TEMP_RULESETS_NAME).ruleset,r=T.updateRule(e.oldId,t);c.publish(f.VERIFY_RULE_UPDATE_RESULT,{result:r,updateRule:h.serialize(t)});},this);c.subscribe(f.DELETE_RULE,function(e){var t=h.deserialize(e),T=R.getRuleSet(g.TEMP_RULESETS_NAME).ruleset;T.removeRule(t);},this);c.subscribe(f.OPEN_URL,function(u){var w=window.open(u,"_blank");w.focus();},this);c.subscribe(f.ON_DOWNLOAD_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.downloadReportZip(e);});},this);c.subscribe(f.HIGHLIGHT_ELEMENT,function(i){var $=sap.ui.getCore().byId(i).$();$.css("background-color","red");},this);c.subscribe(f.TREE_ELEMENT_MOUSE_ENTER,function(e){H.highlight(e);},this);c.subscribe(f.TREE_ELEMENT_MOUSE_OUT,function(){H.hideHighLighter();},this);c.subscribe(f.TOGGLE_FRAME_HIDDEN,function(e){j.toggleHide(e);},this);c.subscribe(f.POST_UI_INFORMATION,function(e){this._oDataCollector.setSupportAssistantLocation(e.location);this._oDataCollector.setSupportAssistantVersion(e.version);},this);c.subscribe(f.GET_AVAILABLE_COMPONENTS,function(){c.publish(f.POST_AVAILABLE_COMPONENTS,Object.keys(C.registry.all()));},this);c.subscribe(f.ON_ANALYZE_REQUEST,function(e){this.analyze(e.executionContext,e.rulePreset);},this);c.subscribe(f.ON_INIT_ANALYSIS_CTRL,function(){R.updateRuleSets(function(){c.publish(f.POST_APPLICATION_INFORMATION,{versionInfo:sap.ui.getVersionInfo()});this.fireEvent("ready");}.bind(this));},this);c.subscribe(f.ON_SHOW_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.openReport(e);});},this);c.subscribe(f.LOAD_RULESETS,function(e){R.loadAdditionalRuleSets(e.aLibNames);},this);c.subscribe(f.REQUEST_RULES_MODEL,function(e){if(e){c.publish(f.GET_RULES_MODEL,I.getTreeTableViewModel(e));}},this);c.subscribe(f.REQUEST_ISSUES,function(i){if(i){var e=I.groupIssues(i),n=I.getIssuesViewModel(e);c.publish(f.GET_ISSUES,{groupedIssues:e,issuesModel:n});}},this);c.subscribe(f.GET_NON_LOADED_RULE_SETS,function(e){R.fetchNonLoadedRuleSets(e.loadedRulesets);},this);};k.prototype.analyze=function(e,p,o){var t=this;if(this._oAnalyzer&&this._oAnalyzer.running()){return;}if(typeof p==="string"){p=l.SystemPresets[p];if(!p){q.sap.log.error("System preset ID is not valid");return;}}e=e||{type:"global"};if(o){this._oAnalysisMetadata=JSON.parse(JSON.stringify(o));}else{this._oAnalysisMetadata=null;}var r;if(p&&p.selections){this._oSelectedRulePreset=p;r=p.selections;if(!p.id||!p.title){q.sap.log.error("The preset must have an ID and a title");return;}}else{this._oSelectedRulePreset=null;r=p;}r=r||R.getAllRuleDescriptors();if(!this._isExecutionScopeValid(e)){c.publish(f.POST_MESSAGE,{message:"Set a valid element ID."});return;}c.publish(f.ON_ANALYZE_STARTED);if(e.selectors){this._mapExecutionScope(e);}this._oAnalyzer.reset();this.setExecutionScope(e);I.clearIssues();this._setSelectedRules(r);return this._oAnalyzer.start(this._aSelectedRules,this._oCoreFacade,this._oExecutionScope).then(function(){t._done();});};k.prototype._isExecutionScopeValid=function(e){var o=sap.ui.getCore(),s=[],n=false,i;if(b.possibleScopes.indexOf(e.type)===-1){q.sap.log.error("Invalid execution scope type. Type must be one of the following: "+b.possibleScopes.join(", "));return false;}if(e.type==="subtree"){if(e.parentId){s.push(e.parentId);}else if(q.isArray(e.selectors)){q.merge(s,e.selectors);}else if(e.selectors){s.push(e.selectors);}for(i=0;i<s.length;i++){if(o.byId(s[i])){n=true;break;}}if(!n){return false;}}return true;};k.prototype.setExecutionScope=function(s){this._oExecutionScope=b(this._oCore,s);};k.prototype._setSelectedRules=function(r){this._aSelectedRules=[];this._oSelectedRulesIds={};if(!r){return;}if(!Array.isArray(r)){r=[r];}r.forEach(function(o){var e,i;if(!o.libName||!o.ruleId){q.sap.log.error("["+g.SUPPORT_ASSISTANT_NAME+"] Invalid Rule Descriptor.");return;}e=R.getRuleSet(o.libName);if(!e||!e.ruleset){q.sap.log.error("["+g.SUPPORT_ASSISTANT_NAME+"] Could not find Ruleset for library "+o.libName);return;}i=e.ruleset.getRules();if(!i||!i[o.ruleId]){q.sap.log.error("["+g.SUPPORT_ASSISTANT_NAME+"] Could not find Rule with id "+o.ruleId+" for library "+o.libName);return;}this._aSelectedRules.push(i[o.ruleId]);this._oSelectedRulesIds[o.ruleId]=true;},this);};k.prototype._mapExecutionScope=function(e){if(e.type==="subtree"){if(typeof e.selectors==="string"){e.parentId=e.selectors;}else if(Array.isArray(e.selectors)){e.parentId=e.selectors[0];}}else if(e.type==="components"){if(typeof e.selectors==="string"){e.components=[e.selectors];}else if(Array.isArray(e.selectors)){e.components=e.selectors;}}delete e.selectors;};k.prototype._done=function(){c.publish(f.ON_ANALYZE_FINISH,{issues:I.getIssuesModel(),elementTree:this._createElementTree(),elapsedTime:this._oAnalyzer.getElapsedTimeString()});d.saveAnalysis(this);};k.prototype._createElementTree=function(){var e=this._copyElementsStructure(),n=[];this._setContextElementReferences(e);for(var i in e){if(e[i].skip){continue;}n.push(e[i]);}return[{content:n,id:"WEBPAGE",name:"WEBPAGE"}];};k.prototype._setContextElementReferences=function(o){var e=E.registry.all();for(var i in o){var n=o[i],p=e[i]==undefined?undefined:e[i].getParent();if(e[i]instanceof sap.ui.core.ComponentContainer){var r=e[i],s=r.getComponent();if(s){n.content.push(o[s]);o[s].skip=true;}}if(p){var t=p.getId();if(!o[t]){continue;}o[t].content.push(o[i]);o[i].skip=true;}}};k.prototype._copyElementsStructure=function(){var e={};var n=function(r,s){for(var i in r){if(Object.prototype.hasOwnProperty.call(r,i)){var t=r[i];var u={content:[],id:t.getId(),name:(s==undefined)?t.getMetadata().getName():s};e[t.getId()]=u;}}};n(this._oExecutionScope.getElements());this._oExecutionScope.getElements().forEach(function(i){if(i instanceof sap.ui.core.ComponentContainer){var r=i.getComponent(),s=C.registry.get(r);if(s){n([s],"sap-ui-component");}}});switch(this._oExecutionScope.getType()){case"global":n(this._oCoreFacade.getUIAreas(),"sap-ui-area");n(this._oCoreFacade.getComponents(),"sap-ui-component");break;case"subtree":var p=this._oExecutionScope._getContext().parentId;n([E.registry.get(p)]);break;case"components":var o=this._oExecutionScope._getContext().components;o.forEach(function(i){n([C.registry.get(i)],"sap-ui-component");});break;}return e;};k.prototype._getReportData=function(r){var i=I.groupIssues(I.getIssuesModel()),e=R.getRuleSets(),s=this._oSelectedRulesIds,S=this._oSelectedRulePreset||null;return{issues:i,technical:this._oDataCollector.getTechInfoJSON(),application:this._oDataCollector.getAppInfo(),rules:I.getRulesViewModel(e,s,i),rulePreset:S,scope:{executionScope:this._oExecutionScope,scopeDisplaySettings:{executionScopes:r.executionScopes,executionScopeTitle:r.executionScopeTitle}},analysisDuration:this._oAnalyzer.getElapsedTimeString(),analysisDurationTitle:r.analysisDurationTitle,abap:d.getFormattedHistory(sap.ui.support.HistoryFormats.Abap),name:g.SUPPORT_ASSISTANT_NAME};};k.prototype.getAnalysisHistory=function(){if(this._oAnalyzer.running()){return null;}return d.getHistory();};k.prototype.getFormattedAnalysisHistory=function(F){if(this._oAnalyzer.running()){return"";}return d.getFormattedHistory(F);};k.prototype.getLastAnalysisHistory=function(){var e=this.getAnalysisHistory();if(q.isArray(e)&&e.length>0){return e[e.length-1];}else{return null;}};k.prototype.addRule=function(r){if(!r){return"No rule provided.";}r.selected=r.selected!==undefined?r.selected:true;r.async=r.async||false;var s=R.getRuleSet(g.TEMP_RULESETS_NAME).ruleset.addRule(r);c.publish(f.VERIFY_RULE_CREATE_RESULT,{result:s,newRule:h.serialize(r)});return s;};var m=new k();return m;},true);
