/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./CreationRowRenderer","./Column","./TableUtils","sap/ui/core/Control","sap/m/library","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button"],function(R,C,T,a,M,O,b,B){"use strict";var c=a.extend("sap.ui.table.CreationRow",{metadata:{library:"sap.ui.table",properties:{applyEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},toolbar:{type:"sap.ui.core.Toolbar",multiple:false}},events:{apply:{allowPreventDefault:true}}}});c.prototype.setApplyEnabled=function(e){this.setProperty("applyEnabled",e,true);this._updateDefaultToolbar();return this;};c.prototype.setParent=function(p){a.prototype.setParent.apply(this,arguments);this._update();return this;};c.prototype.resetFocus=function(){var i=this._getFirstInteractiveElement();if(i){i.focus();T.selectElementText(i);return true;}return false;};c.prototype.getFocusDomRef=function(){var i=this._getFirstInteractiveElement();if(i){return i;}return a.prototype.getFocusDomRef.apply(this,arguments);};c.prototype._fireApply=function(){var f=false;if(this.fireApply()){f=this.resetFocus();}return f;};c.prototype.onkeydown=function(e){if(this.getApplyEnabled()&&e.ctrlKey&&e.keyCode===13){var f=document.activeElement;f.blur();window.setTimeout(function(){if(!this._fireApply()){f.focus();}}.bind(this),0);}};function d(o){return new O({content:[new b(),new B({text:T.getResourceText("TBL_CREATIONROW_APPLY"),type:M.ButtonType.Emphasized,enabled:o.getApplyEnabled(),press:function(){o._fireApply();}})],style:M.ToolbarStyle.Clear,ariaLabelledBy:[o.getId()+"-label"]});}c.prototype._getToolbar=function(){var t=this.getToolbar();if(!t){if(!this._oDefaultToolbar){this._oDefaultToolbar=d(this);this.addDependent(this._oDefaultToolbar);}t=this._oDefaultToolbar;if(t.data("sap-ui-invalid")){this._updateDefaultToolbar();}}return t;};c.prototype._updateDefaultToolbar=function(){if(this.getToolbar()){if(this._oDefaultToolbar){this._oDefaultToolbar.data("sap-ui-invalid",true);}return;}if(!this._oDefaultToolbar){return;}var A=this._oDefaultToolbar.getContent()[1];A.setEnabled(this.getApplyEnabled());this._oDefaultToolbar.data("sap-ui-invalid",null);};c.prototype._getFirstInteractiveElement=function(){var e=this.getCells();for(var i=0;i<e.length;i++){var o=e[i].getDomRef();var $=T.getCell(this._getTable(),o,true);var I=T.getInteractiveElements($);if(I){return I[0];}}return null;};c.prototype._getCell=function(i){var e=this.getCells();var o=e.filter(function(o){return C.ofCell(o).getIndex()===i;})[0];if(!o){return null;}return o;};c.prototype._getCellDomRef=function(i){var o=this._getCell(i);var e=o?o.getDomRef():null;var $=T.getCell(this._getTable(),e,true);if(!$){return null;}return $;};c.prototype._focusCell=function(i){var o=this._getCellDomRef(i);var I=T.getInteractiveElements(o);if(I){I[0].focus();T.selectElementText(I[0]);return true;}return false;};c.prototype._takeOverKeyboardHandling=function(e){var t=this._getTable();var o=t?t.getDomRef():null;if(!o||!o.contains(document.activeElement)){return false;}var f=T.getCell(this._getTable(),document.activeElement);var g=T.getCellInfo(f);var F=false;if(g.columnIndex!=null&&g.columnIndex>=0){F=this._focusCell(g.columnIndex);}else{F=this.resetFocus();}if(F&&e){e.preventDefault();}return F;};c.prototype._update=function(){var t=this._getTable();if(!t){this.removeAllCells();return;}var e=t.getColumns();this.removeAllCells();for(var i=0,l=e.length;i<l;i++){if(e[i].getVisible()){this.addCell(e[i].getTemplateClone(i,"Creation"));}}};c.prototype._getTable=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Table")?p:null;};return c;});
