/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control',"sap/ui/table/TableUtils",'./library','sap/ui/core/Icon','sap/ui/unified/Menu','sap/ui/core/Popup',"./RowActionRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,T,l,I,M,P,R,K,q){"use strict";var a=C.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}}});a.prototype.init=function(){var s=function(v){this.setAggregation("tooltip",v,true);this.setSrc(this.getSrc());return this;};var o=function(e){this._bKeyboard=e.which===K.SPACE||e.which===K.ENTER;I.prototype.onkeyup.apply(this,arguments);};var t=this;var i=new I(this.getId()+"-icon0",{decorative:false,press:function(e){t._handlePress(e,true);}});i.addStyleClass("sapUiTableActionIcon");i.setTooltip=s;i.onkeyup=o;this.addAggregation("_icons",i);i=new I(this.getId()+"-icon1",{decorative:false,press:function(e){t._handlePress(e,false);}});i.addStyleClass("sapUiTableActionIcon");i.setTooltip=s;i.onkeyup=o;this.addAggregation("_icons",i);this._iLen=0;this._iCount=2;this._aActions=["",""];this._iLastCloseTime=0;};a.prototype.onAfterRendering=function(){this._updateIcons();};a.prototype.setVisible=function(v){this.setProperty("visible",v,true);this.$().toggleClass("sapUiTableActionHidden",!v);return this;};a.prototype.setTooltip=function(t){this.setAggregation("tooltip",t,true);var s=this.getTooltip_AsString();if(!s){this.$().removeAttr("title");}else{this.$().attr("title",s);}return this;};a.prototype.insertItem=function(i,b){this.insertAggregation("items",i,b,true);this._updateIcons(true);return this;};a.prototype.addItem=function(i){this.addAggregation("items",i,true);this._updateIcons(true);return this;};a.prototype.removeItem=function(i){var r=this.removeAggregation("items",i,true);this._updateIcons(true);return r;};a.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",true);this._updateIcons(true);return r;};a.prototype.destroyItems=function(){this.destroyAggregation("items",true);this._updateIcons(true);return this;};a.prototype.getAccessibilityInfo=function(){var p=this.$().parent();var A=this.getVisible()&&this._iLen>0&&this._iCount>0&&!p.hasClass("sapUiTableRowHidden")&&!p.hasClass("sapUiTableGroupHeader")&&!p.hasClass("sapUiAnalyticalTableSum");var t;if(A){t=T.getResourceText(this._iLen==1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[this._iLen]);}else{t=T.getResourceText("TBL_ROW_ACTION_NO_ACTION");}return{focusable:A,enabled:A,description:t};};a.prototype._getVisibleItems=function(f){if(!this._aVisibleItems||f){this._aVisibleItems=[];this._iLen=0;var b=this.getItems();for(var i=0;i<b.length;i++){if(b[i].getVisible()){this._aVisibleItems.push(b[i]);this._iLen++;}}}return this._aVisibleItems;};a.prototype._getRow=function(){return this.getParent();};a.prototype._getCount=function(){return this._iCount;};a.prototype._setCount=function(c){if(c<0){this._iCount=0;}else if(c>=0){this._iCount=Math.min(c,2);}this._updateIcons();};a.prototype._setFixedLayout=function(f){this._bFixedLayout=!!f;this._updateIcons();};a.prototype._setIconLabel=function(L){var b=this.getAggregation("_icons");for(var i=0;i<b.length;i++){b[i].removeAllAriaLabelledBy();if(L){b[i].addAriaLabelledBy(L);}}};a.prototype._handlePress=function(e,f){var b=f?0:1;var o=this.getAggregation("_icons")[b];var A=this._aActions[b];var k=o._bKeyboard;o._bKeyboard=false;if(A=="action"){this._getVisibleItems()[b]._doFirePress();}else if(A=="action_fixed"){this._getVisibleItems()[0]._doFirePress();}else if(A=="menu"){var m=this.getAggregation("_menu");if(!m){m=new M();this.setAggregation("_menu",m,true);m.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now();},this);}m.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return;}var c=this.getItems();for(var i=f?0:1;i<c.length;i++){m.addItem(c[i]._getMenuItem());}m.open(!!k,o,P.Dock.EndTop,P.Dock.EndBottom,o);}};a.prototype._updateIcons=function(f){var i=this._getVisibleItems(f);var b=this.getAggregation("_icons");var $=this.$().children();function s(c){b[0].$()[c==0?"attr":"removeAttr"]("aria-haspopup",c==0?"true":undefined);b[1].$()[c==1?"attr":"removeAttr"]("aria-haspopup",c==1?"true":undefined);}if(this._bFixedLayout&&this._iLen==1&&this._iCount==2){var A=this.getItems();if(A.length>1&&i[0]===A[1]){i[0]._syncIcon(b[1]);q($.get(0)).toggleClass("sapUiTableActionHidden",true);q($.get(1)).toggleClass("sapUiTableActionHidden",false);s(-1);this._aActions=["","action_fixed"];return;}}if(this._iLen==0||this._iCount==0){$.toggleClass("sapUiTableActionHidden",true);s(-1);this._aActions=["",""];}else if(this._iLen==1&&this._iCount>0){i[0]._syncIcon(b[0]);q($.get(0)).toggleClass("sapUiTableActionHidden",false);q($.get(1)).toggleClass("sapUiTableActionHidden",true);s(-1);this._aActions=["action",""];}else if(this._iLen==2&&this._iCount==2){i[0]._syncIcon(b[0]);i[1]._syncIcon(b[1]);$.toggleClass("sapUiTableActionHidden",false);s(-1);this._aActions=["action","action"];}else if(this._iLen>2&&this._iCount==2){i[0]._syncIcon(b[0]);b[1].setSrc("sap-icon://overflow");b[1].setTooltip(T.getResourceText("TBL_ROW_ACTION_MORE"));$.toggleClass("sapUiTableActionHidden",false);s(1);this._aActions=["action","menu"];}else{b[0].setSrc("sap-icon://overflow");b[0].setTooltip(T.getResourceText("TBL_ROW_ACTION_MORE"));q($.get(0)).toggleClass("sapUiTableActionHidden",false);q($.get(1)).toggleClass("sapUiTableActionHidden",true);s(0);this._aActions=["menu",""];}};return a;});
