/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/util/PasteHelper','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/Sorter','sap/ui/model/BindingMode','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','./TableScrollExtension','./TableDragAndDropExtension',"./TableRenderer","./plugins/SelectionModelPlugin","sap/ui/thirdparty/jquery","sap/base/Log"],function(D,C,E,I,P,a,F,S,B,b,R,c,T,d,e,f,g,h,j,k,m,q,L){"use strict";var G=c.GroupEventType,N=c.NavigationMode,n=c.SelectionMode,o=c.SelectionBehavior,p=c.SortOrder,V=c.VisibleRowCountMode;var M=5;var r=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:n.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:o.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar,deprecated:true},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},creationRow:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},plugins:{type:"sap.ui.table.plugins.SelectionPlugin",multiple:true,singularName:"plugin"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}}},designtime:"sap/ui/table/designtime/Table.designtime"}});I.insertFontFaceStyle();r.prototype.init=function(){this.mSkipPropagation={rowActionTemplate:true,rowSettingsTemplate:true};if(!this._SelectionAdapterClass){this._SelectionAdapterClass=m;}this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._bIsFlexItem=false;this._attachExtensions();this._initSelectionPlugin();this._bRowsBeingBound=false;this._bContextsAvailable=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._bHideStandardTooltips=false;this._aRowHeights=[];this._iRenderedFirstVisibleRow=0;this._aSortedColumns=[];this._performUpdateRows=T.throttle(function(s){this._updateBindingContexts();if(this._bInvalid){return;}this._updateTableContent();this._updateSelection();this._getAccExtension().updateAccForCurrentCell(s);this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._collectRowHeights(true),true);this._updateRowHeights(this._aRowHeights,false);this._iRenderedFirstVisibleRow=this._getFirstRenderedRowIndex();this._getScrollExtension().updateVerticalScrollbarVisibility();this._fireRowsUpdated(s);},{wait:50,asyncLeading:true});this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iBindingLength=null;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(sap.ui.getCore().isThemeApplied()){T.readThemeParameters();}this._bInvalid=true;};r.prototype._initSelectionPlugin=function(){var s=this.getPlugin("sap.ui.table.plugins.SelectionPlugin");if(s){if(this._oSelectionPlugin instanceof this._SelectionAdapterClass){this._oSelectionPlugin.destroy();}this._oSelectionPlugin=s;this._oSelectionPlugin.attachSelectionChange(this._onSelectionChanged,this);this._oSelectionPlugin._setBinding(this.getBinding("rows"));}else if(!(this._oSelectionPlugin instanceof this._SelectionAdapterClass)){this._oSelectionPlugin=new this._SelectionAdapterClass();this._oSelectionPlugin.attachSelectionChange(this._onSelectionChanged,this);this._oSelectionPlugin._setBinding(this.getBinding("rows"));}};r.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}d.enrich(this,g);d.enrich(this,h);d.enrich(this,f);d.enrich(this,e);d.enrich(this,j);this._bExtensionsInitialized=true;};r.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();if(this._dataReceivedHandlerId){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._cleanUpTimers();this._detachEvents();if(this._oSelectionPlugin){this._oSelectionPlugin.destroy();}delete this._aTableHeaders;};r.prototype._detachExtensions=function(){d.cleanup(this);};r.prototype.onpaste=function(i){if(i.isMarked()||/^(input|textarea)$/i.test(i.target.tagName)||!this.getDomRef("sapUiTableCnt").contains(i.target)){return;}var l=P.getPastedDataAs2DArray(i.originalEvent);if(l.length===0||l[0].length===0){return;}this.firePaste({data:l});};r.prototype.onThemeChanged=function(){T.readThemeParameters();if(this.getDomRef()){this.invalidate();}};r.prototype.onlocalizationChanged=function(i){var l=i.changes||{};var s=l.hasOwnProperty("rtl");var t=l.hasOwnProperty("language");this._adaptLocalization(s,t).then(function(){this.invalidate();}.bind(this));};r.prototype._adaptLocalization=function(i,l){if(!i&&!l){return Promise.reject();}var s=Promise.resolve();if(i){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){s=T.getResourceBundle({async:true,reload:true});}return s.then(function(){if(l){T.Menu.cleanupDataCellContextMenu(this);this._invalidateColumnMenus();}}.bind(this));};r.prototype._collectRowHeights=function(H){var l=this.getDomRef();if(!l){return[];}var s=this._getDefaultRowHeight();var t=H?".sapUiTableColHdrTr":".sapUiTableTr";var u=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+t);var v=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+t);var w=this.getRows().length;var x=[];var y=D.browser.chrome&&window.devicePixelRatio!=1;if(H&&this.getColumnHeaderHeight()>0){s=this.getColumnHeaderHeight();}for(var i=0;i<w;i++){var z=u[i]?u[i].getBoundingClientRect().height:0;var A=v[i]?v[i].getBoundingClientRect().height:0;var J=Math.max(z,A);if(y){var K=s-J;if(K>0&&K<1){x.push(Math.max(J,s-1));continue;}}x.push(Math.max(J,s));}if(x.length>0&&!H){T.dynamicCall(this._getSyncExtension,function(O){var Q=O.syncRowHeights(x.slice());if(Q&&Q.length===x.length){x=Q.slice();}});}return x;};r.prototype._resetRowHeights=function(){var l=this._getDefaultRowHeight();var s="";if(l){s=l+"px";}var t=this.getDomRef();if(t){var u=t.querySelectorAll(".sapUiTableTr");for(var i=0;i<u.length;i++){u[i].style.height=s;}}};r.prototype._resetColumnHeaderHeights=function(){var l=this.getDomRef();if(l){var s=l.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<s.length;i++){s[i].style.height=null;}}};r.prototype._determineAvailableSpace=function(){var l=this.getDomRef();if(l&&l.parentNode){var s=l.querySelector(".sapUiTableCCnt");if(s){var u=0;if(this._bIsFlexItem){var t=l.childNodes;for(var i=0;i<t.length;i++){u+=t[i].offsetHeight;}u-=s.clientHeight;}else{u=l.scrollHeight-s.clientHeight;}var v=this._getScrollExtension();if(!v.isHorizontalScrollbarVisible()){var w={};w[D.browser.BROWSER.CHROME]=16;w[D.browser.BROWSER.FIREFOX]=16;w[D.browser.BROWSER.INTERNET_EXPLORER]=18;w[D.browser.BROWSER.EDGE]=16;w[D.browser.BROWSER.SAFARI]=16;w[D.browser.BROWSER.ANDROID]=8;u+=w[D.browser.name];}if(this._iLastAvailableSpace==null){this._iLastAvailableSpace=0;}var x=this._bIsFlexItem?l:l.parentNode;var y=Math.floor(q(x).height()-u);var A=Math.abs(y-this._iLastAvailableSpace);if(A>=5){this._iLastAvailableSpace=y;}return this._iLastAvailableSpace;}}return 0;};r.prototype._collectTableSizes=function(){var s={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var l=this.getDomRef();if(!l){return s;}var t=l.querySelector(".sapUiTableCnt");if(t){s.tableCntHeight=t.clientHeight;s.tableCntWidth=t.clientWidth;}var u=l.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(u){s.tableCtrlScrollWidth=u.clientWidth;}var v=l.querySelector(".sapUiTableRowHdrScr");if(v){s.tableRowHdrScrWidth=v.clientWidth;}var w=l.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(w){s.tableCtrlScrWidth=w.clientWidth;}var H=this._getScrollExtension().getHorizontalScrollbar();if(H){s.tableHSbScrollLeft=H.scrollLeft;}var x=l.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(x){s.tableCtrlFixedWidth=x.clientWidth;}var y=this.getFixedColumnCount();var z=0;if(y){var A=this.getColumns();var J=l.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<J.length;i++){var K=parseInt(J[i].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(K)&&(K<y)){var O=A[K];var W;if(O._iFixWidth!=null){W=O._iFixWidth;}else{W=J[i].getBoundingClientRect().width;}z+=W;}}}if(z>0){var Q=this._getScrollExtension();var U=s.tableRowHdrScrWidth;var X=Q.getVerticalScrollbar();if(X&&!Q.isVerticalScrollbarExternal()){U+=X.offsetWidth;}if(T.hasRowActions(this)){var Y=this.getDomRef("sapUiTableRowActionScr");if(Y){U+=Y.offsetWidth;}}U+=T.Column.getMinColumnWidth();var Z=s.tableCntWidth-U;var $=Z>z;var _=!$;if(this._bIgnoreFixedColumnCount!==_){this._bIgnoreFixedColumnCount=_;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}this.invalidate();}}return s;};r.prototype._updateRowHeights=function(i,H){var l=this.getDomRef();if(!l){return;}function u(y,z){var A=i[z];if(A){y.style.height=A+"px";}}var s=H?".sapUiTableColHdrTr":".sapUiTableTr";var t=H?[]:l.querySelectorAll(".sapUiTableRowSelectionCell");var v=H?[]:l.querySelectorAll(".sapUiTableRowActionCell");var w=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+s);var x=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+s);Array.prototype.forEach.call(t,u);Array.prototype.forEach.call(v,u);Array.prototype.forEach.call(w,u);Array.prototype.forEach.call(x,u);};r.prototype.onBeforeRendering=function(i){if(i&&i.isMarked("renderRows")){return;}if(this._performUpdateRows.pending()){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var v=this.getVisibleRowCountMode();var l=this.getRows();this.getBinding("rows");if(v==V.Interactive||v==V.Fixed||(v==V.Auto&&this._iTableRowContentHeight&&l.length==0)){this._updateRows(this._calculateRowsToDisplay(),T.RowsUpdateReason.Render);}else if(this._bRowAggregationInvalid&&l.length>0){this._updateRows(this.getVisibleRowCount(),T.RowsUpdateReason.Render);}this._aTableHeaders=[];};r.prototype.onAfterRendering=function(i){var l=i&&i.isMarked("renderRows");var v=this.getVisibleRowCountMode();var O=this.getVisibleRowCount();var $=this.$();this._bInvalid=false;this._attachEvents();this._initRowDomRefs();if(!this._bAllowColumnHeaderTextSelection&&!l){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._updateTableContent();this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!l){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");}if(this._bFirstRendering&&v===V.Auto){Promise.resolve().then(this._updateTableSizes.bind(this,T.RowsUpdateReason.Render,{forceUpdate:true,skipResetRowHeights:true}));}else{var s={skipHandleRowCountMode:l,skipResetRowHeights:true};var t=function(){if(l||this.getBinding("rows")==null){return;}if(v===V.Auto){if(O===this.getVisibleRowCount()){this._fireRowsUpdated(T.RowsUpdateReason.Render);}}else{this._fireRowsUpdated(T.RowsUpdateReason.Render);}}.bind(this);if(l){if(T.isVariableRowHeightEnabled(this)){s.rowContentHeight="reset";}else if(this.getRows().length===0&&v!==V.Interactive){s.rowContentHeight="recalculate";}}if(!l&&v===V.Auto&&this._bIsFlexItem){Promise.resolve().then(this._updateTableSizes.bind(this,T.RowsUpdateReason.Render,s)).then(t);}else{this._updateTableSizes(T.RowsUpdateReason.Render,s);t();}}this._bFirstRendering=false;};r.prototype.invalidate=function(){this._bInvalid=true;T.Column.invalidateColumnUtils(this);return C.prototype.invalidate.call(this);};r.prototype._initRowDomRefs=function(){var l=this.getRows();for(var i=0;i<l.length;i++){l[i].initDomRefs();}};r.prototype._updateTableSizes=function(s,O){var l=this.getDomRef();var t=this;function u(){T.registerResizeHandler(t,"",t._onTableResize.bind(t),!t._bIsFlexItem);}function v(){T.deregisterResizeHandler(t,"");}if(this._bInvalid||!l||!sap.ui.getCore().isThemeApplied()){return;}O=Object.assign({forceUpdate:false,skipHandleRowCountMode:false,skipResetRowHeights:false,rowContentHeight:undefined},O);this._bIsFlexItem=window.getComputedStyle(l.parentNode).display==="flex";if(l.offsetWidth===0){u();return;}if(!O.skipResetRowHeights){this._resetRowHeights();this._resetColumnHeaderHeights();}this._aRowHeights=this._collectRowHeights(false);var w=this._collectRowHeights(true);if(T.isVariableRowHeightEnabled(this)&&!T.isNoDataVisible(this)){this._getScrollExtension().updateInnerVerticalScrollPosition();}var x=null;if(!O.skipHandleRowCountMode&&this.getVisibleRowCountMode()==V.Auto){x=this._determineAvailableSpace();var y=this._calculateRowsToDisplay(x);if(this._updateRows(y,s)&&!O.forceUpdate){return;}}if(!this._bIsFlexItem){v();}function z(b1){var c1=b1.getDomRef();var d1=T.Column.getMinColumnWidth();var e1=[];var f1=b1.getColumnHeaderVisible();function g1(j1,k1){if(j1<=k1){return Math.max(j1,k1-5,d1)+"px";}return-1;}function h1(k1){var l1=Math.max(k1._minWidth||0,d1,k1.getMinWidth());var m1=k1.getWidth();var n1;var o1;var p1;if(T.isVariableWidth(m1)&&!T.isFixedColumn(b1,k1.getIndex())){n1=c1.querySelectorAll('th[data-sap-ui-colid="'+k1.getId()+'"]');o1=n1[f1?0:1];p1=o1?o1.offsetWidth:null;if(p1!==null){if(p1<=l1){return{headers:n1,newWidth:g1(p1,l1)};}else if(o1&&o1.style.width!=m1){e1.push({col:k1,header:o1,minWidth:l1,headers:n1});return{headers:n1,newWidth:m1};}e1.push({col:k1,header:o1,minWidth:l1,headers:n1});}}return null;}function i1(k1){if(k1){Array.prototype.forEach.call(k1.headers,function(l1){l1.style.width=k1.newWidth;});}}b1._getVisibleColumns().map(h1).forEach(i1);if(e1.length){var j1;for(var i=0;i<e1.length;i++){j1=e1[i].header&&e1[i].header.offsetWidth;e1[i].newWidth=g1(j1,e1[i].minWidth);if(parseInt(e1[i].newWidth)>=0){i1(e1[i]);}}}}z(this);var A=this._collectTableSizes();this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(w,true);if(!O.skipHandleRowCountMode||O.rowContentHeight==="reset"){this._setRowContentHeight(x);}else if(O.rowContentHeight==="recalculate"){this._setRowContentHeight(this._determineAvailableSpace());}if(this.getVisibleRowCountMode()==V.Auto){var H=this._calculateRowsToDisplay(x!=null?x:this._determineAvailableSpace());if(H==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}}T.dynamicCall(this._getSyncExtension,function(i){i.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height});},this);var J=this._getScrollExtension();J.updateHorizontalScrollbar(A);J.updateVerticalScrollbarPosition();J.updateVerticalScrollbarVisibility();var $=this.$();if(T.hasRowActions(this)){var K=$.hasClass("sapUiTableRActFlexible");var Q=this.getDomRef("dummycolhdr");if(Q){var U=this.getDomRef("header");var W=U.clientWidth;var X=this.getColumns().reduce(function(X,i){if(i.getDomRef()&&i.getIndex()>=this.getComputedFixedColumnCount()){return X+T.convertCSSSizeToPixel(i.getWidth());}return X;}.bind(this),0);var Y=Q.clientWidth;var Z=W>X;if(!K&&Z){var _=A.tableCtrlScrWidth+A.tableRowHdrScrWidth+A.tableCtrlFixedWidth-Y;var a1={width:"auto"};a1[this._bRtlMode?"right":"left"]=_;this.$("sapUiTableRowActionScr").css(a1);this.$("rowacthdr").css(a1);$.toggleClass("sapUiTableRActFlexible",true);}else if(K&&!Z){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");$.toggleClass("sapUiTableRActFlexible",false);}}}$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");if(this._bIsFlexItem){u();}else{Promise.resolve().then(function(){if(t.getVisibleRowCountMode()===V.Auto){var i=t._calculateRowsToDisplay(t._determineAvailableSpace());if(t.getVisibleRowCount()!==i){t._iRenderingLoopCount=t._iRenderingLoopCount?t._iRenderingLoopCount+1:1;if(t._iRenderingLoopCount>M){L.error("Rendering has been re-started too many times ("+t._iRenderingLoopCount+")."+" Please run the Support Assistant to detect possible configuration issues.",t);return;}t._updateRows(i,s);}else{delete t._iRenderingLoopCount;u();}}else{u();}});}};r.prototype.setShowOverlay=function(s){s=!!s;this.setProperty("showOverlay",s,true);if(this.getDomRef()){var i=document.activeElement;this.$().toggleClass("sapUiTableOverlay",s);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);}return this;};r.prototype._updateFixedBottomRows=function(){var i=this.getFixedBottomRowCount();var l=this.getDomRef();if(l&&i>0){var $=q(l).find(".sapUiTableRowLastScrollable");$.removeClass("sapUiTableRowLastScrollable");var s=q(l).find(".sapUiTableRowFirstFixedBottom");s.removeClass("sapUiTableRowFirstFixedBottom");var t=T.getFirstFixedBottomRowIndex(this);var u=this.getRows();var v;if(t>=0&&t<u.length){v=u[t].getDomRefs(true);v.row.addClass("sapUiTableRowFirstFixedBottom",true);}if(t>=1&&t<u.length){v=u[t-1].getDomRefs(true);v.row.addClass("sapUiTableRowLastScrollable",true);}}};r.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};r.prototype.applyFocusInfo=function(i){if(i&&i.customId){q(document.getElementById(i.customId)).focus();}else{E.prototype.applyFocusInfo.apply(this,arguments);}return this;};r.prototype.setTitle=function(t){var i=t;if(typeof(t)==="string"||t instanceof String){i=c.TableHelper.createTextView({text:t,width:"100%"});i.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",i);return this;};r.prototype.setFooter=function(v){var i=v;if(typeof(v)==="string"||v instanceof String){i=c.TableHelper.createTextView({text:v,width:"100%"});}this.setAggregation("footer",i);return this;};r.prototype.setSelectionMode=function(s){if(s===n.Multi){s=n.MultiToggle;L.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'",this);}if(this._oSelectionPlugin.isA("sap.ui.table.plugins.SelectionModelPlugin")||this._oSelectionPlugin.isA("sap.ui.table.plugins.BindingSelectionPlugin")){this.setProperty("selectionMode",s);this._oSelectionPlugin.setSelectionMode(s);}else{L.warning("When the MultiSelectionPlugin is applied to the table, the selection mode is controlled by the plugin and cannot be"+" changed manually.",this);}return this;};r.prototype.setFirstVisibleRow=function(i,O,s){if(parseInt(i)<0){L.error("The index of the first visible row must be greater than or equal to 0. The value has been set to 0.",this);i=0;}if(this._getTotalRowCount()>0){var l=this._getMaxFirstVisibleRowIndex();if(l<i){L.warning("The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count."+" The value has been set to "+l+".",this);i=l;}}var t=this.getFirstVisibleRow()!=i;var u=this._getScrollExtension();if(t){var v=this._getFirstRenderedRowIndex();this.setProperty("firstVisibleRow",i,true);var w=this._getFirstRenderedRowIndex()!==v;if(this.getBinding("rows")){if(w){var x=O===true?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange;this.updateRows(x);}if(!O){u.updateVerticalScrollPosition();}}if(!s){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}}else if(!O){u.updateVerticalScrollPosition();}return this;};r.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;r.prototype.bindAggregation=function(s){if(s==="rows"){return this.bindRows.apply(this,[].slice.call(arguments,1));}return C.prototype.bindAggregation.apply(this,arguments);};r.prototype.bindRows=function(i){this._bRowsBeingBound=true;this._bContextsAvailable=false;if(this.getEnableBusyIndicator()){this.setBusy(false);}this._iPendingRequests=0;this._bPendingRequest=false;this._iBindingLength=null;return C.prototype.bindAggregation.call(this,"rows",r._getSanitizedBindingInfo(arguments));};r.prototype._bindAggregation=function(s,i){if(s==="rows"){this._bRowsBeingBound=true;this._bContextsAvailable=false;r._addBindingListener(i,"change",this._onBindingChange.bind(this));r._addBindingListener(i,"dataRequested",this._onBindingDataRequested.bind(this));r._addBindingListener(i,"dataReceived",this._onBindingDataReceived.bind(this));}E.prototype._bindAggregation.call(this,s,i);if(s==="rows"){var l=this.getBinding("rows");var t=l?l.getModel():null;this._oSelectionPlugin._setBinding(l);if(t&&t.getDefaultBindingMode()===B.OneTime){L.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}this._bRowsBeingBound=false;}};r.prototype.destroyAggregation=function(A,s){var v=C.prototype.destroyAggregation.apply(this,arguments);if(A==="rows"){this._aRowClones.forEach(function(i){i.destroy();});this._aRowClones=[];}return v;};r._getSanitizedBindingInfo=function(i){var l;if(i==null||i[0]==null){l=null;}else if(typeof i[0]==="string"){var s=i[0];var t=i[1];var u=i[2];var v=i[3];if(t instanceof S||Array.isArray(u)&&u[0]instanceof F){v=u;u=t;t=undefined;}l={path:s,sorter:u,filters:v,template:t};}else{l=i[0];}return l;};r._addBindingListener=function(i,s,H){if(!i.events){i.events={};}if(!i.events[s]){i.events[s]=H;}else{var O=i.events[s];i.events[s]=function(){H.apply(this,arguments);O.apply(this,arguments);};}};r.prototype._onBindingChange=function(i){var s=typeof(i)==="object"?i.getParameter("reason"):i;if(s==="sort"||s==="filter"){this.setFirstVisibleRow(0);}};r.prototype.unbindAggregation=function(s,i){var l=this.getBinding("rows");if(s==="rows"&&this.isBound("rows")){i=true;}var v=E.prototype.unbindAggregation.call(this,s,i);if(s==="rows"&&l){this._invalidateColumnMenus();if(!this._bRowsBeingBound){this._oSelectionPlugin._setBinding(null);this._adjustToTotalRowCount();this._updateRows(this.getVisibleRowCount(),T.RowsUpdateReason.Unbind);this.updateRows(T.RowsUpdateReason.Unbind);}}return v;};r.prototype.setVisibleRowCount=function(v){if(v!=null&&!isFinite(v)){return this;}var s=this.getVisibleRowCountMode();if(s==V.Auto){L.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var i=this.getFixedRowCount()+this.getFixedBottomRowCount();if(v<=i&&i>0){L.error("Table: "+this.getId()+" visibleRowCount('"+v+"') must be bigger than number of"+" fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}v=this.validateProperty("visibleRowCount",v);if(this.getBinding("rows")&&this._getTotalRowCount()<=v){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",v);this._setRowContentHeight(v*this._getDefaultRowHeight());T.dynamicCall(this._getSyncExtension,function(l){l.syncRowCount(v);});return this;};r.prototype.setMinAutoRowCount=function(i){if(parseInt(i)<1){L.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);i=1;}this.setProperty("minAutoRowCount",i);return this;};r.prototype.setRowHeight=function(i){this.setProperty("rowHeight",i);this._iTableRowContentHeight=undefined;return this;};r.prototype.setTooltip=function(t){L.warning("The aggregation tooltip is not supported for sap.ui.table.Table",this);return this.setAggregation("tooltip",t,true);};r.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);L.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this;};r.prototype._getFixedBottomRowContexts=function(i,l){var s=this.getBinding("rows");var t=[];if(!s){return t;}i=i||this.getFixedBottomRowCount();l=l||this._getTotalRowCount();var v=this.getVisibleRowCount();if(i>0&&(v-i)<l){t=this._getContexts(l-i,i);}return t;};r.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};r.prototype._getContexts=function(s,l,t){var i=this.getBinding("rows");if(i){return i.getContexts(s,l,t);}else{return[];}};r.prototype._computeRequestLength=function(l){if(this.getVisibleRowCountMode()===V.Fixed){var i=this.getBindingInfo("rows");if(i&&i.length){return Math.min(l,i.length);}}if(this.getVisibleRowCountMode()===V.Auto&&!this._bContextsAvailable){var s=Math.ceil(D.resize.height/T.DefaultRowHeight.sapUiSizeCondensed);return Math.max(l,s);}return l;};r.prototype._getRowContexts=function(v,s,l){var t=this.getBinding("rows");var u=v==null?this.getRows().length:v;if(!t||u<=0){return[];}s=s===true;l=l===true;var w=this._getFirstRenderedRowIndex();var x=this.getFixedRowCount();var y=this.getFixedBottomRowCount();var z=[];var A;var H=u-y;var J=0;var K=H;var O=this.getThreshold();O=O?Math.max(u,O):0;var Q=w;var U=function(Y,Z,Q){for(var i=0;i<Z.length;i++){Y[Q+i]=Z[i];}};if(x>0&&w>0){Q=w+x;H-=x;J=x;A=this._getFixedRowContexts(x);z=z.concat(A);}A=this._getContexts(Q,this._computeRequestLength(H),O);if(!s){this._adjustToTotalRowCount();}var W=this._getTotalRowCount();U(z,A,J);K=Math.min(K,Math.max(W-y,0));if(y>0){A=this._getFixedBottomRowContexts(y,W);U(z,A,K);}var X=this._getMaxFirstRenderedRowIndex();if(X<w&&this._bContextsAvailable&&!l){this.setProperty("firstVisibleRow",X,true);z=this._getRowContexts(u,s,true);}return z;};r.prototype._adjustToTotalRowCount=function(){var i=this.getBinding("rows");var t=this._getTotalRowCount();var s=this._getScrollExtension();if(this._iBindingLength!==t){this._iBindingLength=t;this._updateFixedBottomRows();s.updateVerticalScrollbarVisibility();s.updateVerticalScrollHeight();s.updateVerticalScrollPosition();if(!i||!T.hasPendingRequests(this)){this._updateNoData();}}};r.prototype.refreshRows=function(v){var i=this.getBinding("rows");if(!i){L.error("RefreshRows must not be called without a binding",this);return;}this._bContextsAvailable=false;var t=this;var s=typeof(v)==="object"?v.getParameter("reason"):v;var l=this.getVisibleRowCountMode();var A=l===V.Auto;var u=A&&this.bOutput;if(!A||u){if(this.bOutput&&this.getRows().length===0){i.attachEventOnce("dataRequested",function(){if(t._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(t._mTimeouts.refreshRowsAdjustRows);}t._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){t._updateRows(t._calculateRowsToDisplay(),s,false);},0);});}if(s===a.Filter||s===a.Sort){this.setFirstVisibleRow(0);}var w=s!=null;this._updateBindingContexts(this._calculateRowsToDisplay(),w);}};r.prototype.updateRows=function(s){if(this.bIsDestroyed||this._bIsBeingDestroyed){return;}if(!this._bRowsBeingBound||this._getTotalRowCount(true)>0){this._bContextsAvailable=true;}var v=this.getVisibleRowCountMode();var i=this.getRows().length===0||this._bRowAggregationInvalid;var A=v===V.Auto;var l=A&&this.bOutput;if(i&&(!A||l)){if(this._iTableRowContentHeight){var u=this._updateRows(this._calculateRowsToDisplay(),s);if(u){return;}}}this._performUpdateRows(s);};r.prototype.insertRow=function(){L.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);return this;};r.prototype.addRow=function(){L.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);return this;};r.prototype.removeRow=function(){L.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);return null;};r.prototype.removeAllRows=function(){L.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);return[];};r.prototype.destroyRows=function(){L.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);return this;};r.prototype.setCreationRow=function(i){if(!T.isA(i,"sap.ui.table.CreationRow")){i=null;}return this.setAggregation("creationRow",i);};r.prototype.getCreationRow=function(){return this.getAggregation("creationRow");};r.prototype.destroyCreationRow=function(){return this.destroyAggregation("creationRow");};r.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};r.prototype._attachEvents=function(){var $=this.$();if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd transitionend",function(i){if(q(i.target).has($).length>0){this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}D.resize.attachHandler(this._onWindowResize,this);d.attachEvents(this);};r.prototype._detachEvents=function(){q(document.body).off('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);D.resize.detachHandler(this._onWindowResize,this);d.detachEvents(this);};r.prototype._cleanUpTimers=function(){var K;for(K in this._mTimeouts){if(this._mTimeouts[K]){window.clearTimeout(this._mTimeouts[K]);delete this._mTimeouts[K];}}for(K in this._mAnimationFrames){if(this._mAnimationFrames[K]){window.cancelAnimationFrame(this._mAnimationFrames[K]);delete this._mAnimationFrames[K];}}this._performUpdateRows.cancel();};r.prototype._updateBindingContexts=function(i,s){var l=this.getBinding("rows");var t;s=s===true;if(l){t=this._getRowContexts(i,s);}if(!s){this._resetRowHeights();var u=this.getRows(),v=this.mBindingInfos["rows"],w=v&&v.model;for(var x=u.length-1;x>=0;x--){var y=t?t[x]:undefined;var z=u[x];if(z){z.setRowBindingContext(y,w,l);}}}};r.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var i=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);};r.prototype.removeColumn=function(i,s){var l=this.removeAggregation('columns',i,s);if(typeof i==="number"&&i>-1){i=this.getColumns()[i];}var t=this._aSortedColumns.indexOf(i);if(!this._bReorderInProcess&&t>=0){this._aSortedColumns.splice(t,1);}this.invalidateRowsAggregation();var u=this.getCreationRow();if(u){u._update();}return l;};r.prototype.removeAllColumns=function(){var i=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();var l=this.getCreationRow();if(l){l._update();}return i;};r.prototype.destroyColumns=function(){var i=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();var l=this.getCreationRow();if(l){l._update();}return i;};r.prototype.addColumn=function(i,s){this.addAggregation('columns',i,s);this.invalidateRowsAggregation();var l=this.getCreationRow();if(l){l._update();}return this;};r.prototype.insertColumn=function(i,l,s){this.insertAggregation('columns',i,l,s);this.invalidateRowsAggregation();var t=this.getCreationRow();if(t){t._update();}return this;};r.prototype._getTotalRowCount=function(){if(this.getVisibleRowCountMode()===V.Fixed){var i=this.getBindingInfo("rows");if(i&&i.length){return i.length;}}var l=this.getBinding("rows");return l?l.getLength():0;};r.prototype._getSelectableRowCount=function(){return this._oSelectionPlugin.getSelectableCount();};r.prototype._getMaxFirstVisibleRowIndex=function(){var i;if(T.isVariableRowHeightEnabled(this)){i=this._getTotalRowCount(true)-1;}else{i=this._getTotalRowCount(true)-this.getVisibleRowCount();}return Math.max(0,i);};r.prototype._getMaxFirstRenderedRowIndex=function(){var i;if(T.isVariableRowHeightEnabled(this)){i=this._getTotalRowCount(true)-this.getVisibleRowCount()-1;}else{i=this._getTotalRowCount(true)-this.getVisibleRowCount();}return Math.max(0,i);};r.prototype._getFirstRenderedRowIndex=function(){var i=this.getFirstVisibleRow();if(T.isVariableRowHeightEnabled(this)&&i>this._getMaxFirstRenderedRowIndex()){return this._getMaxFirstRenderedRowIndex();}else{return i;}};r.prototype._getVisibleColumns=function(){var s=[];var t=this.getColumns();for(var i=0,l=t.length;i<l;i++){if(t[i].shouldRender()){s.push(t[i]);}}return s;};r.prototype._getColumnsWidth=function(s,t){var u=this.getColumns();var v=0;if(s!==0&&!s){s=0;}if(t!==0&&!t){t=u.length;}for(var i=s,l=t;i<l;i++){if(u[i]&&u[i].shouldRender()){var w=T.convertCSSSizeToPixel(u[i].getWidth());if(w==null){w=T.Column.getMinColumnWidth();}v+=w;}}return v;};r.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};r.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return;}if(D.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(T.RowsUpdateReason.Zoom);this._adjustOutlineOffset();}};r.prototype._adjustOutlineOffset=function(){if(window.devicePixelRatio<1){this.addStyleClass("sapUiTableZoomout");}else{this.removeStyleClass("sapUiTableZoomout");}};r.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(l){l.preventDefault();return false;});};r.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};r.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(i){}}};r.prototype._findAndfireCellEvent=function(i,l,s){var $=q(l.target);var t=$.closest(".sapUiTableDataCell");var u=t.attr("id");var v=/.*-row(\d*)-col(\d*)/i.exec(u);var w=false;if(v){var x=v[1];var y=v[2];var z=this.getRows()[x];var A=z&&z.getCells()[y];var H=z&&z.getIndex();var J=b.ofCell(A).getId();var K;if(this.getBindingInfo("rows")){K=z.getBindingContext(this.getBindingInfo("rows").model);}var O={rowIndex:H,columnIndex:y,columnId:J,cellControl:A,rowBindingContext:K,cellDomRef:t.get(0)};w=!i.call(this,O);if(!w&&typeof s==="function"){O.cellDomRef=t[0];w=s.call(this,O);}}return w;};r.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var i=T.getFocusedItemInfo(this);if(i){return i.domRef||C.prototype.getFocusDomRef.apply(this,arguments);}return null;};r.prototype._isRowSelectable=function(i){return this._oSelectionPlugin.isIndexSelectable(i);};r.prototype.pushSortedColumn=function(i,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(i);};r.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};r.prototype.sort=function(l,s,A){if(!l){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var t=this.getBinding("rows");if(t){t.sort();}this._aSortedColumns=[];}if(this.getColumns().indexOf(l)>=0){l.sort(s===p.Descending,A);}};r.prototype.filter=function(i,v){if(this.getColumns().indexOf(i)>=0){i.filter(v);}};r.prototype._updateSelection=function(){var s=this.getSelectionMode();if(s===n.None){return;}var t=this._getAccExtension().getAriaTextsForSelectionMode(true);var l=T.isRowSelectionAllowed(this);var u=this.getRows();for(var i=0;i<u.length;i++){var v=u[i];v._updateSelection(this,t,l);}if(T.hasSelectAll(this)){var $=this.$("selall");var A=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!A);this._getAccExtension().setSelectAllState(A);var w=this._oSelectionPlugin.getRenderConfig();var x;if(w.headerSelector.type==="toggle"){x=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(w.headerSelector.type==="clear"){x="TBL_DESELECT_ALL";}var y=T.getResourceText(x);if(this._getShowStandardTooltips()){$.attr('title',y);}else if(w.headerSelector.type==="toggle"){this.getDomRef("ariaselectall").innerText=y;}}};r.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};r.prototype._onSelectionChanged=function(i){var l=i.getParameter("rowIndices");var s=i.getParameter("selectAll");var t=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();var u=i.getParameter("limitReached");if(u){this.setFirstVisibleRow(Math.max(0,this.getSelectedIndex()-this.getVisibleRowCount()+1));}this._updateSelection();if(this._oSelectionPlugin.isA("sap.ui.table.plugins.SelectionModelPlugin")||this._oSelectionPlugin.isA("sap.ui.table.plugins.BindingSelectionPlugin")){this.fireRowSelectionChange({rowIndex:t,rowContext:this.getContextByIndex(t),rowIndices:l,selectAll:s,userInteraction:this._iSourceRowIndex!==undefined});}};r.prototype.getContextByIndex=function(i){var l=this.getBinding("rows");return i>=0&&l?l.getContexts(i,1)[0]:null;};r.prototype.getSelectedIndex=function(){return this._oSelectionPlugin.getSelectedIndex();};r.prototype.setSelectedIndex=function(i){this._oSelectionPlugin.setSelectedIndex(i);return this;};r.prototype.clearSelection=function(){this._oSelectionPlugin.clearSelection();return this;};r.prototype.selectAll=function(){if(T.hasSelectAll(this)){this._oSelectionPlugin.selectAll();}return this;};r.prototype.getSelectedIndices=function(){return this._oSelectionPlugin.getSelectedIndices();};r.prototype.addSelectionInterval=function(i,l){this._oSelectionPlugin.addSelectionInterval(i,l);return this;};r.prototype.setSelectionInterval=function(i,l){this._oSelectionPlugin.setSelectionInterval(i,l);return this;};r.prototype.removeSelectionInterval=function(i,l){this._oSelectionPlugin.removeSelectionInterval(i,l);return this;};r.prototype.isIndexSelected=function(i){return this._oSelectionPlugin.isIndexSelected(i);};r.prototype.setGroupBy=function(v){var i=v;var O=sap.ui.getCore().byId(this.getGroupBy());if(typeof i==="string"){i=sap.ui.getCore().byId(i);}var l=false;if(i instanceof b&&i!==O){if(this.getColumns().indexOf(i)===-1){throw new Error("Column has to be part of the columns aggregation!");}var s=this.fireGroup({column:i,groupedColumns:[i.getId()],type:G.group});if(O){O.setGrouped(false);l=true;}if(s&&this.getEnableGrouping()){i.setGrouped(true);}}if(!i||l){if(O){O.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}return this.setAssociation("groupBy",i);};r.prototype.getBinding=function(s){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[s||"rows"]);};r.prototype.setEnableGrouping=function(i){var l=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",i);if(l){l.setGrouped(i);}T.Grouping.resetExperimentalGrouping(this);this._invalidateColumnMenus();return this;};r.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};r.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};r.prototype.setShowColumnVisibilityMenu=function(s){this.setProperty("showColumnVisibilityMenu",s);this._invalidateColumnMenus();return this;};r.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}return this.getFixedColumnCount();};r.prototype.setFixedColumnCount=function(l,s){var t=this.getColumns();var u,i;for(i=l-1;i>=0;i--){u=t[i];if(u&&u.getVisible()){l=Math.max(l,u.getIndex()+T.Column.getHeaderSpan(u));break;}}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(i=l-1;i>=0;i--){u=t[i];if(u&&T.isVariableWidth(u.getWidth())){u._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+u.getIndex()+"']").width();}}this.setProperty("fixedColumnCount",l,s);this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}return this;};r.prototype.setFixedRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};r.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};r.prototype.setThreshold=function(t){this.setProperty("threshold",t,true);return this;};r.prototype._invalidateColumnMenus=function(){var s=this.getColumns();for(var i=0,l=s.length;i<l;i++){s[i].invalidateMenu();}};r.prototype._isTouchEvent=function(i){return!!(i&&i.originalEvent&&i.originalEvent.touches);};r.prototype._getRowClone=function(s){var t=this._aRowClones[s];if(t&&!t.bIsDestroyed){return t;}t=new R(this.getId()+"-rows"+"-row"+s);this._aRowClones[s]=t;var u=this.getColumns();for(var i=0,l=u.length;i<l;i++){if(u[i].getVisible()){var v=u[i].getTemplateClone(i);if(v){t.addCell(v);}}}if(T.hasRowActions(this)){var w=this.getRowActionTemplate().clone();w._setFixedLayout(true);w._setCount(this.getRowActionCount());w._setIconLabel(this.getId()+"-rowacthdr");t.setAggregation("_rowAction",w,true);}var x=this.getRowSettingsTemplate();if(x){var y=x.clone();t.setAggregation("_settings",y,true);}return t;};r.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};r.prototype._updateRows=function(l,s,u){if(isNaN(l)||this.bIsDestroyed||this._bIsBeingDestroyed){return false;}if(u==null){u=true;}var t=this.getBinding("rows");var v=this.getRows();var i;this.setProperty("visibleRowCount",l,true);if(T.isNoDataVisible(this)&&!t){l=0;}else if(T.isVariableRowHeightEnabled(this)){l=l+1;}T.dynamicCall(this._getSyncExtension,function(H){H.syncRowCount(l);},this);if(this._bRowAggregationInvalid){this.destroyAggregation("rows",this._bInvalid?"KeepDom":true);v=[];}if(l===v.length){return false;}for(i=v.length-1;i>=l;i--){this.removeAggregation("rows",i,true);}v.splice(l);var w;var x;var y;if(u){x=this.getBindingInfo("rows");y=x&&x.model;w=this._getRowContexts(l);for(i=0;i<v.length;i++){v[i].setRowBindingContext(w[i],y,t);}}if(v.length<l){for(i=v.length;i<l;i++){var z=this._getRowClone(i);if(u){z.setRowBindingContext(w[i],y,t);}this.addAggregation("rows",z,true);this._bRowAggregationInvalid=false;if(u){z._updateTableCells(w[i]);}}}this._iRenderedFirstVisibleRow=this._getFirstRenderedRowIndex();var A=u&&w.length>0;return this._renderRows(s,A);};r.prototype._renderRows=function(s,i){var l=false;i=i===true;if(!this._bInvalid){var t=this.getDomRef("tableCCnt");if(!t){return false;}this._detachEvents();if(this.getVisibleRowCountMode()===V.Auto){var u=this.getDomRef();if(u){u.style.height="0px";}}var v=q.Event("BeforeRendering");v.setMarked("renderRows");v.srcControl=this;this._handleEvent(v);var w=sap.ui.getCore().createRenderManager(),x=this.getRenderer();x.renderTableCCnt(w,this);w.flush(t,false,false);w.destroy();v=q.Event("AfterRendering");v.setMarked("renderRows");v.srcControl=this;this._handleEvent(v);l=true;}if(i&&!this._bInvalid&&this.getBinding("rows")){var y=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){y._fireRowsUpdated(s);},0);}return l;};r.prototype._getDefaultRowHeight=function(){var i=this.getRowHeight();if(i>0){return i+T.RowHorizontalFrameSize;}else{var s=T.getContentDensity(this);return T.DefaultRowHeight[s];}};r.prototype._setRowContentHeight=function(H){H=H||0;var v=this.getVisibleRowCountMode();var i=this.getVisibleRowCount();var l=this._getDefaultRowHeight();var s=this.getMinAutoRowCount();var t;if(v==V.Interactive||v==V.Fixed){if(this._iTableRowContentHeight&&v==V.Interactive){t=s*l;if(!H){H=this._iTableRowContentHeight;}}else{t=i*l;H=t;}}else if(v==V.Auto){t=s*l;}var u=Math.max(H,t);if((v==V.Fixed&&this.getRows().length==0)||v!=V.Fixed){this._iTableRowContentHeight=Math.floor(u/l)*l;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){q(this.getDomRef("tableCCnt")).css("height",l*i+"px");}else{if((v==V.Fixed||v==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}};r.prototype._determineMinAutoRowCount=function(){var i=this.getMinAutoRowCount();if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){i=this.getVisibleRowCount()||i;}return i;};r.prototype._calculateRowsToDisplay=function(t){this._iRowsToDisplayHeight=t||this._iRowsToDisplayHeight||this._iTableRowContentHeight;t=this._iRowsToDisplayHeight;var v=this.getVisibleRowCountMode();var i=0;if(v==V.Fixed){i=this.getVisibleRowCount()||0;}else if(v==V.Interactive||v==V.Auto){var l=this._determineMinAutoRowCount();var s=this._getDefaultRowHeight();if(!s||!t){i=l;}else{var A=Math.min(t,50000);var u=Math.floor(A/s);i=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(l,u));}}return Math.max(i,0);};r.prototype.setShowNoData=function(s){this.setProperty('showNoData',s,true);this._updateNoData();return this;};r.prototype.setNoData=function(v){var O=T.getNoDataText(this);this.setAggregation("noData",v,true);var s=T.getNoDataText(this);if(O!=null&&s!=null){if(O!==s){this.$("noDataMsg").text(s);}}else{this.invalidate();}return this;};r.prototype.exportData=function(s){var t=sap.ui.requireSync("sap/ui/core/util/Export");s=s||{};if(!s.rows){var u=this.getBinding("rows"),v=this.getBindingInfo("rows");var w=u.aFilters.concat(u.aApplicationFilters);s.rows={path:v.path,model:v.model,sorter:u.aSorters,filters:w,parameters:v.parameters};}if(!s.exportType){var x=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");s.exportType=new x();}var y=s.rows.model;if(!y){var z=s.rows.path;var A=z.indexOf(">");if(A>0){y=z.substr(0,A);}}if(!s.columns){s.columns=[];var H=this.getColumns();for(var i=0,l=H.length;i<l;i++){var J=H[i];if(J.getSortProperty()){s.columns.push({name:J.getLabel().getText(),template:{content:{path:J.getSortProperty(),model:y}}});}}}var K=new t(s);this.addDependent(K);return K;};r.prototype._onPersoApplied=function(){var s=this.getColumns();var t=[];for(var i=0,l=s.length;i<l;i++){var u=s[i];if(u.getSorted()){t.push(new S(u.getSortProperty(),u.getSortOrder()===p.Descending));}}var v=this.getBinding("rows");if(v){if(t.length>0){v.sort(t);}this.refreshRows();}};r.prototype._toggleSelectAll=function(){if(!T.hasData(this)||this.getSelectionMode()!==n.MultiToggle){return;}if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}this._iSourceRowIndex=undefined;};r.prototype.setBusy=function(i,s){var l=this.getBusy()!=i;s="sapUiTableGridCnt";var v=C.prototype.setBusy.call(this,i,s);if(l){this.fireBusyStateChanged({busy:i});}return v;};r.prototype.setEnableBusyIndicator=function(v){this.setProperty("enableBusyIndicator",v,true);if(!v){this.setBusy(false);}return this;};r.prototype._onBindingDataRequested=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests++;this._bPendingRequest=true;var l=T.canUsePendingRequestsCounter(this);if(this.getEnableBusyIndicator()&&(l&&this._iPendingRequests===1||!l)){this.setBusy(true);}if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};r.prototype._onBindingDataReceived=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests--;this._bPendingRequest=false;if(this._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(this._mTimeouts.refreshRowsAdjustRows);}this._adjustToTotalRowCount();if(!T.hasPendingRequests(this)){this._dataReceivedHandlerId=setTimeout(function(){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._updateNoData();delete this._dataReceivedHandlerId;}.bind(this),0);}};r.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};r.prototype._getSelectedIndicesCount=function(){return this._oSelectionPlugin.getSelectedCount();};r.prototype._updateTableContent=function(){T.Grouping.updateGroups(this);};r.prototype.setRowActionTemplate=function(t){this.setAggregation("rowActionTemplate",t);t=this.getRowActionTemplate();if(t){t._setCount(this.getRowActionCount());}this.invalidateRowsAggregation();return this;};r.prototype.setRowActionCount=function(l){this.setProperty("rowActionCount",l);l=this.getRowActionCount();var s=this.getRowActionTemplate();if(s){s._setCount(l);}for(var i=0;i<this._aRowClones.length;i++){s=this._aRowClones[i].getRowAction();if(s){s._setCount(l);}}return this;};r.prototype.setRowSettingsTemplate=function(t){this.setAggregation("rowSettingsTemplate",t);this.invalidateRowsAggregation();return this;};r.prototype.addPlugin=function(i){this.addAggregation("plugins",i);this._initSelectionPlugin();return this;};r.prototype.insertPlugin=function(i,l){this.insertAggregation("plugins",i,l);this._initSelectionPlugin();return this;};r.prototype.removePlugin=function(i){var v=this.removeAggregation("plugins",i);this._initSelectionPlugin();return v;};r.prototype.removeAllPlugins=function(){var v=this.removeAllAggregation("plugins");this._initSelectionPlugin();return v;};r.prototype.getPlugin=function(t){if(typeof t!=="string"){return null;}var l=this.getPlugins();for(var i=0;i<l.length;i++){if(l[i].isA(t)){return l[i];}}return null;};r.prototype.destroyPlugins=function(){var i=this.destroyAggregation('plugins');this._initSelectionPlugin();return i;};r.prototype.getCellControl=function(i,l,v){var s=T.getRowColCell(this,i,l,!v);return s.cell;};r.prototype._fireRowsUpdated=function(s){if(s==null){s=T.RowsUpdateReason.Unknown;}this.fireEvent("_rowsUpdated",{reason:s});};r.prototype._enableSynchronization=function(){var t=this;return new Promise(function(i,l){sap.ui.require(["sap/ui/table/TableSyncExtension"],function(s){i(d.enrich(t,s).getInterface());},function(s){l(s);});});};r.prototype._enableLegacyMultiSelection=function(){this._legacyMultiSelection=function(i,l){var A=!!(l.metaKey||l.ctrlKey);if(!this.isIndexSelected(i)){if(A){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else if(A||this._getSelectedIndicesCount()===1){this.removeSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}.bind(this);};return r;});
