/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./TableExtension","./TableUtils","sap/ui/Device","./library","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/thirdparty/jquery"],function(T,c,D,l,I,L,q){"use strict";var S=l.SharedDomRef;var M=1000000;var V=2;var d={HORIZONAL:"HORIZONTAL",VERTICAL:"VERTICAL",BOTH:"BOTH"};var e={SCROLLBAR:"Scrollbar",KEYBOARD:"Keyboard",MOUSEWHEEL:"MouseWheel",TOUCH:"Touch",FOCUS:"Focus",EXTENSION:"Extension",TABLE:"Table"};function f(s,t){L.debug("sap.ui.table.TableScrollExtension",s,t);}function g(o){return typeof o.isConnected==="boolean"&&o.isConnected||document.body.contains(o);}var h=new window.WeakMap();var j=function(t){if(!t){return{};}if(!h.has(t)){h.set(t,{oHorizontalScrollbar:null,iHorizontalScrollPosition:null,bVerticalScrollingSuspended:false,oVerticalScrollbar:null,oExternalVerticalScrollbar:null,nVerticalScrollPosition:null,iVerticalScrollHeight:null,iVerticalScrollbarHeight:null,iFirstVisibleRowInBuffer:null,bIsScrolledVerticallyByWheel:false,bIsScrolledVerticallyByKeyboard:false,mTouchSessionData:null,bIsVerticalScrollbarExternal:false,fnOnRowsUpdatedPreprocessor:null});}return h.get(t);};j.destroy=function(t){delete h.delete(t);};var H={onScroll:function(o){var N=o.target.scrollLeft;var O=o.target._scrollLeft;I.notifyScrollEvent&&I.notifyScrollEvent(o);if(N!==O){var s=H.getScrollAreas(this);o.target._scrollLeft=N;for(var i=0;i<s.length;i++){var a=s[i];if(a!==o.target&&a.scrollLeft!==N){a.scrollLeft=N;a._scrollLeft=N;}}j(this).iHorizontalScrollPosition=N;}},restoreScrollPosition:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();if(o&&j(t).iHorizontalScrollPosition!==null){var a=H.getScrollAreas(t);for(var i=0;i<a.length;i++){var b=a[i];delete b._scrollLeft;}if(o.scrollLeft!==j(t).iHorizontalScrollPosition){o.scrollLeft=j(t).iHorizontalScrollPosition;}else{var p=q.Event("scroll");p.target=o;H.onScroll.call(t,p);}}},onScrollbarMouseDown:function(o){this._getKeyboardExtension().setActionMode(false);},addEventListeners:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();var a=H.getScrollAreas(t);if(!s._onHorizontalScrollEventHandler){s._onHorizontalScrollEventHandler=H.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onHorizontalScrollEventHandler);}if(o){if(!s._onHorizontalScrollbarMouseDownEventHandler){s._onHorizontalScrollbarMouseDownEventHandler=H.onScrollbarMouseDown.bind(t);}o.addEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();var a=H.getScrollAreas(t);if(s._onHorizontalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onHorizontalScrollEventHandler);delete a[i]._scrollLeft;}delete s._onHorizontalScrollEventHandler;}if(o&&s._onHorizontalScrollbarMouseDownEventHandler){o.removeEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);delete s._onHorizontalScrollbarMouseDownEventHandler;}},getScrollAreas:function(t){var o=t.getDomRef();var s;if(o){s=Array.prototype.slice.call(t.getDomRef().querySelectorAll(".sapUiTableCtrlScr"));}var a=[t._getScrollExtension().getHorizontalScrollbar()].concat(s);return a.filter(function(b){return b!=null;});}};var k={updateScrollPosition:function(t,a,s,p){s=s==null?e.EXTENSION:s;var o=t?t._getScrollExtension():null;var v=o?o.getVerticalScrollbar(true):null;if(!t||!v||!o.isVerticalScrollbarRequired()||j(t).bVerticalScrollingSuspended){f("VerticalScrollingHelper#updateScrollPosition: Not executed - Guard clause not passed",t);return;}var b=j(t).nVerticalScrollPosition;var i=k.getScrollRange(t);if(a==null){var F=t.getFirstVisibleRow();var r=t._getMaxFirstRenderedRowIndex();if(F>r){a=i;j(t).iFirstVisibleRowInBuffer=F-r;}else{a=F*k.getScrollRangeRowFraction(t);j(t).iFirstVisibleRowInBuffer=null;}}else{j(t).iFirstVisibleRowInBuffer=null;}j(t).nVerticalScrollPosition=Math.min(Math.max(0,a),i);f("VerticalScrollingHelper#updateScrollPosition: From "+b+" to "+j(t).nVerticalScrollPosition+" (diff: "+(j(t).nVerticalScrollPosition-b)+", trigger: "+s+")",t);if(p===true){f("VerticalScrollingHelper#updateScrollPosition: Scrolling prevented",t);return;}if(!g(v)){f("VerticalScrollingHelper#updateScrollPosition: Scrollbar is not connected with the DOM",t);return;}window.cancelAnimationFrame(t._mAnimationFrames.verticalScrollUpdate);delete t._mAnimationFrames.verticalScrollUpdate;switch(s){case e.SCROLLBAR:clearTimeout(t._mTimeouts.largeDataScrolling);delete t._mTimeouts.largeDataScrolling;if(t._bLargeDataScrolling&&!j(t).bIsScrolledVerticallyByWheel){t._mTimeouts.largeDataScrolling=setTimeout(function(){delete t._mTimeouts.largeDataScrolling;k.updateFirstVisibleRow(t);},300);}else{k.updateFirstVisibleRow(t);}break;case e.KEYBOARD:case e.MOUSEWHEEL:case e.TOUCH:case e.EXTENSION:case e.TABLE:var N=0;var u=k.getScrollRange(t);if(j(t).nVerticalScrollPosition>0&&j(t).nVerticalScrollPosition<0.5){N=1;}else if(j(t).nVerticalScrollPosition>=u-0.5&&j(t).nVerticalScrollPosition<u){N=u-1;}else{N=Math.round(j(t).nVerticalScrollPosition);}if(v.scrollTop!==N){f("VerticalScrollingHelper#updateScrollPosition: scrollTop will be set asynchronously",t);t._mAnimationFrames.verticalScrollUpdate=window.requestAnimationFrame(function(){var w=v.scrollTop;delete t._mAnimationFrames.verticalScrollUpdate;f("VerticalScrollingHelper#updateScrollPosition: (async) Set scrollTop from "+w+" to "+N,t);v.scrollTop=N;v._scrollTop=v.scrollTop;k.updateFirstVisibleRow(t);});}else if(j(t).nVerticalScrollPosition!==b){f("VerticalScrollingHelper#updateScrollPosition: firstVisibleRow will be set asynchronously",t);t._mAnimationFrames.verticalScrollUpdate=window.requestAnimationFrame(function(){delete t._mAnimationFrames.verticalScrollUpdate;k.updateFirstVisibleRow(t);});}else{f("VerticalScrollingHelper#updateScrollPosition: scrollTop and nVerticalScrollPosition not changed"+" -> update inner vertical scroll position",t);o.updateInnerVerticalScrollPosition();}break;default:}},onScroll:function(o){I.notifyScrollEvent&&I.notifyScrollEvent(o);if(j(this).bIsScrolledVerticallyByKeyboard){f("Vertical scroll event handler: Aborted - Scrolled by keyboard",this);return;}this._getKeyboardExtension().setActionMode(false);var a=o.target.scrollTop;var b=o.target._scrollTop;var s=a!==b;if(a===0&&!g(o.target)){f("Vertical scroll event handler: Scrollbar is not connected with the DOM",this);}else if(s){f("Vertical scroll event handler: Scroll position changed by scrolling with the scrollbar:"+" From "+j(this).nVerticalScrollPosition+" to "+a,this);delete o.target._scrollTop;k.updateScrollPosition(this,a,e.SCROLLBAR);}else{f("Vertical scroll event handler: Scroll position changed by scrolling with VerticalScrollingHelper#updateScrollPosition",this);}j(this).bIsScrolledVerticallyByWheel=false;},updateFirstVisibleRow:function(t){var s=t._getScrollExtension();var i=t._getMaxFirstRenderedRowIndex();var N=k.getRowIndexAtCurrentScrollPosition(t);var o=t.getFirstVisibleRow();var b=N<0;var O=o>=i;var F=N!==o;var r=F&&!(b&&O);if(r){var a=!O||N!==i;if(b){N=i;}f("updateFirstVisibleRow: From "+o+" to "+N,t);t.setFirstVisibleRow(N,true,b);if(a){k.setOnRowsUpdatedPreprocessor(t,function(p){f("updateFirstVisibleRow - onRowsUpdatedPreprocessor: Reason "+p.getParameters().reason,this);s.updateInnerVerticalScrollPosition();if(b){var C=this.getFirstVisibleRow();var u=N===C;if(u){this.setProperty("firstVisibleRow",-1,true);this.setFirstVisibleRow(C,true);}}return false;});}else{f("updateFirstVisibleRow: Update inner vertical scroll position",t);s.updateInnerVerticalScrollPosition();}}else if(c.isVariableRowHeightEnabled(t)){f("updateFirstVisibleRow: Update inner vertical scroll position",t);s.updateInnerVerticalScrollPosition();}},getRowIndexAtCurrentScrollPosition:function(t){var s=t._getScrollExtension();var i=t._getMaxFirstVisibleRowIndex();if(i===0){return 0;}else{var a=k.getScrollPosition(t);var b=k.getScrollRange(t);var o=k.getScrollRangeRowFraction(t);if(c.isVariableRowHeightEnabled(t)){if(k.isScrollPositionInBuffer(t)){return-1;}else{return Math.min(i,Math.floor(a/o));}}else{var r=Math.floor(a/o);var p=b-a;var u=s.getVerticalScrollbar(true)._scrollTop==null||j(t).bIsScrolledVerticallyByWheel;var v=p<1&&u||p<0.01;if(v){k.updateScrollPosition(t,b,null,true);}return v?i:Math.min(i,r);}}},getScrollRange:function(t){var s=t._getScrollExtension();var v=s.getVerticalScrollHeight()-s.getVerticalScrollbarHeight();return Math.max(0,v);},getScrollRangeBuffer:function(t){if(!c.isVariableRowHeightEnabled(t)){return 0;}return V*t._getDefaultRowHeight();},getScrollPosition:function(t){var s=t._getScrollExtension();if(j(t).nVerticalScrollPosition!=null){return j(t).nVerticalScrollPosition;}else if(s.isVerticalScrollbarVisible()){return s.getVerticalScrollbar().scrollTop;}else{return 0;}},getScrollRangeRowFraction:function(t){var s=t._getScrollExtension();var v=t._getTotalRowCount()-t.getVisibleRowCount();var i;if(c.isVariableRowHeightEnabled(t)){i=k.getScrollRange(t)-k.getScrollRangeBuffer(t);var b=s.getVerticalScrollHeight()===M;if(!b){i+=t._getDefaultRowHeight();}}else{i=k.getScrollRange(t);}return i/Math.max(1,v);},isScrollPositionInBuffer:function(t){if(!c.isVariableRowHeightEnabled(t)){return false;}var s=k.getScrollRange(t);var a=k.getScrollPosition(t);var i=k.getScrollRangeBuffer(t);return s-a<=i;},getInnerScrollRange:function(t){if(!t||!t._aRowHeights){return 0;}var r=t._aRowHeights;var i=t._getDefaultRowHeight()*t.getVisibleRowCount();if(t.getVisibleRowCount()>=t._getTotalRowCount()){r=r.slice(0,t._getTotalRowCount());}var o=r.reduce(function(a,b){return a+b;},0)-i;if(o>0){o=Math.ceil(o);}return Math.max(0,o);},onScrollbarMouseDown:function(o){j(this).bIsScrolledVerticallyByWheel=false;j(this).bIsScrolledVerticallyByKeyboard=false;},setOnRowsUpdatedPreprocessor:function(t,p){j(t).fnOnRowsUpdatedPreprocessor=p;},runOnRowsUpdatedPreprocessor:function(t,o){var b=true;if(j(t).fnOnRowsUpdatedPreprocessor!=null){b=j(t).fnOnRowsUpdatedPreprocessor.call(t,o)!==false;}j(t).fnOnRowsUpdatedPreprocessor=null;return b;},onRowsUpdated:function(o){var s=this._getScrollExtension();var b=k.runOnRowsUpdatedPreprocessor(this,o);if(!c.isVariableRowHeightEnabled(this)||!b){return;}var r=o.getParameters().reason;var R=r===c.RowsUpdateReason.Expand||r===c.RowsUpdateReason.Collapse;var F=this.getFirstVisibleRow()-this._getMaxFirstRenderedRowIndex();f("onRowsUpdated: Reason "+r,this);if(F>=0&&R){j(this).iFirstVisibleRowInBuffer=F;s.updateInnerVerticalScrollPosition();}},restoreScrollPosition:function(t){k.updateScrollPosition(t,j(t).nVerticalScrollPosition);},addEventListeners:function(t){var s=t._getScrollExtension();var a=k.getScrollAreas(t);var v=s.getVerticalScrollbar();if(!s._onVerticalScrollEventHandler){s._onVerticalScrollEventHandler=k.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onVerticalScrollEventHandler);}if(v){if(!s._onVerticalScrollbarMouseDownEventHandler){s._onVerticalScrollbarMouseDownEventHandler=k.onScrollbarMouseDown.bind(t);}v.addEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);}t.attachEvent("_rowsUpdated",k.onRowsUpdated);},removeEventListeners:function(t){var s=t._getScrollExtension();var a=k.getScrollAreas(t);var v=s.getVerticalScrollbar();if(s._onVerticalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onVerticalScrollEventHandler);}delete s._onVerticalScrollEventHandler;}if(v&&s._onVerticalScrollbarMouseDownEventHandler){v.removeEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);delete s._onVerticalScrollbarMouseDownEventHandler;}t.detachEvent("_rowsUpdated",k.onRowsUpdated);},isUpdatePending:function(t){return!!(t&&t._mAnimationFrames.verticalScrollUpdate);},getScrollAreas:function(t){var s=[t._getScrollExtension().getVerticalScrollbar()];return s.filter(function(o){return o!=null;});}};var m={onMouseWheelScrolling:function(o,a){var s=this._getScrollExtension();var v=Math.abs(a.deltaY)>Math.abs(a.deltaX);var i=v?a.deltaY:a.deltaX;var b=v&&a.shiftKey||!v;var p=i>0;var r=false;if(i===0){return;}if(b&&(o.scrollDirection===d.HORIZONAL||o.scrollDirection===d.BOTH)){var t=s.getHorizontalScrollbar();if(a.deltaMode>0){var u=c.Column.getMinColumnWidth();i=p?u:-u;}if(p){r=t.scrollLeft===t.scrollWidth-t.offsetWidth;}else{r=t.scrollLeft===0;}if(s.isHorizontalScrollbarVisible()&&!r){a.preventDefault();a.stopPropagation();this._getKeyboardExtension().setActionMode(false);t.scrollLeft=t.scrollLeft+i;}}else if(!b&&(o.scrollDirection===d.VERTICAL||o.scrollDirection===d.BOTH)){var w=s.getVerticalScrollbar();var x=this._getMaxFirstRenderedRowIndex();var y=c.isVariableRowHeightEnabled(this)&&this._getFirstRenderedRowIndex()===x;var z=k.getScrollRangeRowFraction(this);var A=y?this._getDefaultRowHeight():z;if(a.deltaMode===1){i*=A;}else if(a.deltaMode===2){i*=A*this.getVisibleRowCount();}if(p){r=w.scrollTop===w.scrollHeight-w.offsetHeight;}else{r=w.scrollTop===0;}if(s.isVerticalScrollbarVisible()&&!r){a.preventDefault();a.stopPropagation();var B=k.getScrollPosition(this);var C=B-(x*z);var F=i;if(!y||(y&&C===0&&!p)){var G=i/(a.deltaMode===0?this._getDefaultRowHeight():z);if(G>1){G=Math.floor(G);}else if(G<-1){G=Math.ceil(G);}F=G*z;}else if(!p){if(C+F<0){F=-C;}}j(this).bIsScrolledVerticallyByWheel=true;j(this).bIsScrolledVerticallyByKeyboard=false;this._getKeyboardExtension().setActionMode(false);k.updateScrollPosition(this,B+F,e.MOUSEWHEEL);}}},onTouchStart:function(o,a){if(a.type==="touchstart"||a.pointerType==="touch"){var s=this._getScrollExtension();var b=s.getHorizontalScrollbar();var v=s.getVerticalScrollbar();var t=a.touches?a.touches[0]:a;j(this).mTouchSessionData={initialPageX:t.pageX,initialPageY:t.pageY,initialScrollTop:v?v.scrollTop:0,initialScrollLeft:b?b.scrollLeft:0,initialScrolledToEnd:null,touchMoveDirection:null};}},onTouchMoveScrolling:function(o,a){if(a.type!=="touchmove"&&a.pointerType!=="touch"){return;}var s=this._getScrollExtension();var t=j(this).mTouchSessionData;if(!t){return;}var b=a.touches?a.touches[0]:a;var i=(b.pageX-t.initialPageX);var p=(b.pageY-t.initialPageY);var r=false;if(!t.touchMoveDirection){if(i===0&&p===0){return;}t.touchMoveDirection=Math.abs(i)>Math.abs(p)?"horizontal":"vertical";}switch(t.touchMoveDirection){case"horizontal":var u=s.getHorizontalScrollbar();if(u&&(o.scrollDirection===d.HORIZONAL||o.scrollDirection===d.BOTH)){this._getKeyboardExtension().setActionMode(false);if(t.initialScrolledToEnd==null){if(i<0){t.initialScrolledToEnd=u.scrollLeft===u.scrollWidth-u.offsetWidth;}else{t.initialScrolledToEnd=u.scrollLeft===0;}}if(!t.initialScrolledToEnd){u.scrollLeft=t.initialScrollLeft-i;r=true;}}break;case"vertical":var v=s.getVerticalScrollbar();if(v&&(o.scrollDirection===d.VERTICAL||o.scrollDirection===d.BOTH)){this._getKeyboardExtension().setActionMode(false);if(t.initialScrolledToEnd==null){if(p<0){t.initialScrolledToEnd=v.scrollTop===v.scrollHeight-v.offsetHeight;}else{t.initialScrolledToEnd=v.scrollTop===0;}}if(!t.initialScrolledToEnd){k.updateScrollPosition(this,t.initialScrollTop-p,e.TOUCH);r=true;}}break;default:}if(r){a.preventDefault();}},addEventListeners:function(t){var s=t._getScrollExtension();var a=m.getEventListenerTargets(t);s._mMouseWheelEventListener=this.addMouseWheelEventListener(a,t,{scrollDirection:d.BOTH});s._mTouchEventListener=this.addTouchEventListener(a,t,{scrollDirection:d.BOTH});},addMouseWheelEventListener:function(a,t,o){var O=m.onMouseWheelScrolling.bind(t,o);for(var i=0;i<a.length;i++){a[i].addEventListener("wheel",O);}return{wheel:O};},addTouchEventListener:function(a,t,o){var O=m.onTouchStart.bind(t,o);var b=m.onTouchMoveScrolling.bind(t,o);var p={};for(var i=0;i<a.length;i++){if(D.support.pointer&&D.system.desktop){a[i].addEventListener("pointerdown",O);a[i].addEventListener("pointermove",b,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].addEventListener("touchstart",O);a[i].addEventListener("touchmove",b);}}if(D.support.pointer&&D.system.desktop){p={pointerdown:O,pointermove:b};}else if(D.support.touch){p={touchstart:O,touchmove:b};}return p;},removeEventListeners:function(t){var s=t._getScrollExtension();var a=m.getEventListenerTargets(t);function r(o,b){for(var p in b){var u=b[p];if(u){o.removeEventListener(p,u);}}}for(var i=0;i<a.length;i++){r(a[i],s._mMouseWheelEventListener);r(a[i],s._mTouchEventListener);}delete s._mMouseWheelEventListener;delete s._mTouchEventListener;},getEventListenerTargets:function(t){var a=[t.getDomRef("tableCCnt")];return a.filter(function(o){return o!=null;});}};var E={onBeforeRendering:function(o){var s=this._getScrollExtension();var r=o!=null&&o.isMarked("renderRows");s._clearCache();if(!r){j(this).bVerticalScrollingSuspended=true;this.attachEventOnce("_rowsUpdated",function(){j(this).bVerticalScrollingSuspended=false;k.restoreScrollPosition(this);});}},onAfterRendering:function(o){var s=this._getScrollExtension();var r=o!=null&&o.isMarked("renderRows");if(r){s.updateVerticalScrollbarHeight();s.updateVerticalScrollHeight();}H.restoreScrollPosition(this);},onfocusin:function(o){var r;var C=c.getCellInfo(o.target);if(C.isOfType(c.CELLTYPE.DATACELL)){r=this.getDomRef("sapUiTableCtrlScr");}else if(C.isOfType(c.CELLTYPE.COLUMNHEADER)){r=this.getDomRef("sapUiTableColHdrScr");}if(r&&C.columnIndex>=this.getComputedFixedColumnCount()){var a=this._getScrollExtension().getHorizontalScrollbar();var $=q(a);var b=C.cell[0];var i=this._bRtlMode?$.scrollLeftRTL():a.scrollLeft;var R=r.clientWidth;var p=b.offsetLeft;var s=p+b.offsetWidth;var O=p-i;var t=s-R-i;var N;if(O<0&&t<0){N=i+O;}else if(t>0&&O>0){N=i+t;}if(N!=null){if(this._bRtlMode){$.scrollLeftRTL(N);}else{a.scrollLeft=N;}}}var P=c.getParentCell(this,o.target);if(P){var u=this;var v=function(){var w=P.find(".sapUiTableCellInner");if(w.length>0){if(u._bRtlMode){w.scrollLeftRTL(w[0].scrollWidth-w[0].clientWidth);}else{w[0].scrollLeft=0;}w[0].scrollTop=0;}};Promise.resolve().then(function(){if(D.browser.safari){window.setTimeout(v,0);}else{v();}});}}};var n=T.extend("sap.ui.table.TableScrollExtension",{_init:function(t,s,a){this._delegate=E;t.addEventDelegate(this._delegate,t);return"ScrollExtension";},_attachEvents:function(){var t=this.getTable();H.addEventListeners(t);k.addEventListeners(t);m.addEventListeners(t);},_detachEvents:function(){var t=this.getTable();H.removeEventListeners(t);k.removeEventListeners(t);m.removeEventListeners(t);},_debug:function(){this._ScrollingHelper=m;this._ExtensionDelegate=E;this._HorizontalScrollingHelper=H;this._VerticalScrollingHelper=k;},destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;this._clearCache();j.destroy(t);T.prototype.destroy.apply(this,arguments);}});n.prototype.scrollVertically=function(b,p,i,a,B){var t=this.getTable();if(!t){return false;}b=b===true;p=p===true;i=i===true;a=a===true;var s=false;var r=t._getTotalRowCount();var v=t.getVisibleRowCount();var o=v-t.getFixedRowCount()-t.getFixedBottomRowCount();var F=t.getFirstVisibleRow();var u=p?o:1;if(b){if(F+v<r){if(B){B();}if(a){setTimeout(function(){t.setFirstVisibleRow(Math.min(F+u,r-v));},0);}else{t.setFirstVisibleRow(Math.min(F+u,r-v));}s=true;}}else if(F>0){if(B){B();}if(a){setTimeout(function(){t.setFirstVisibleRow(Math.max(F-u,0));},0);}else{t.setFirstVisibleRow(Math.max(F-u,0));}s=true;}if(s&&i){j(t).bIsScrolledVerticallyByKeyboard=true;}return s;};n.prototype.scrollVerticallyMax=function(b,i){var t=this.getTable();if(!t){return false;}if(b==null){b=false;}if(i==null){i=false;}var s=false;var F=t.getFirstVisibleRow();if(b){var a=t._getTotalRowCount()-c.getNonEmptyVisibleRowCount(t);if(F<a){t.setFirstVisibleRow(a);s=true;}}else if(F>0){t.setFirstVisibleRow(0);s=true;}if(s&&i){j(t).bIsScrolledVerticallyByKeyboard=true;}return s;};n.prototype.getHorizontalScrollbar=function(){var t=this.getTable();if(t&&!t._bInvalid&&!j(t).oHorizontalScrollbar){j(t).oHorizontalScrollbar=t.getDomRef(S.HorizontalScrollBar);}return j(t).oHorizontalScrollbar||null;};n.prototype.getVerticalScrollbar=function(i){var t=this.getTable();var b=this.isVerticalScrollbarExternal();if(t&&!t._bInvalid&&!j(t).oVerticalScrollbar){j(t).oVerticalScrollbar=t.getDomRef(S.VerticalScrollBar);if(!j(t).oVerticalScrollbar&&b){j(t).oVerticalScrollbar=j(t).oExternalVerticalScrollbar;}}var s=j(t).oVerticalScrollbar;if(s&&!b&&!i&&!g(s)){return null;}return s||null;};n.prototype.isHorizontalScrollbarVisible=function(){var o=this.getHorizontalScrollbar();return o!=null&&!o.classList.contains("sapUiTableHidden");};n.prototype.isVerticalScrollbarVisible=function(){var v=this.getVerticalScrollbar();return v!=null&&!v.classList.contains("sapUiTableHidden");};n.prototype.isVerticalScrollbarExternal=function(){return j(this.getTable()).bIsVerticalScrollbarExternal;};n.prototype.markVerticalScrollbarAsExternal=function(s){if(s){j(this.getTable()).bIsVerticalScrollbarExternal=true;j(this.getTable()).oExternalVerticalScrollbar=s;}};n.prototype.updateHorizontalScrollbar=function(t){var o=this.getTable();var a=this.getHorizontalScrollbar();if(!o||!a||!t){return;}var $=o.$();var C=t.tableCtrlScrollWidth;if(D.browser.safari){C=Math.max(C,o._getColumnsWidth(o.getComputedFixedColumnCount()));}var b=C>t.tableCtrlScrWidth;if(b){if(!this.isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");a.classList.remove("sapUiTableHidden");if(D.browser.safari){var i=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");i.outerWidth(C);}}var s=t.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){s+=t.tableRowHdrScrWidth;}if(o._bRtlMode){a.style.marginRight=s+"px";a.style.marginLeft="";}else{a.style.marginLeft=s+"px";a.style.marginRight="";}var p=o.getDomRef("hsb-content");if(p){p.style.width=C+"px";}}if(!b&&this.isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");a.classList.add("sapUiTableHidden");if(D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}};n.prototype.updateVerticalScrollbarHeight=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}var N=this.getVerticalScrollbarHeight();v.style.maxHeight=N+"px";if(j(t).iVerticalScrollbarHeight!==N){j(t).iVerticalScrollbarHeight=N;k.updateScrollPosition(t);}};n.prototype.getVerticalScrollbarHeight=function(){var t=this.getTable();if(!t){return 0;}var s=Math.max(1,t.getVisibleRowCount()-t.getFixedRowCount()-t.getFixedBottomRowCount());return s*t._getDefaultRowHeight();};n.prototype.updateVerticalScrollbarPosition=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}var o=t.getDomRef("tableCCnt");if(o){var i=o.offsetTop;var a=t.getDomRef("vsb-bg");if(a){a.style.top=i+"px";}var F=t.getFixedRowCount();if(F>0){i+=t._iVsbTop;}v.style.top=i+"px";}};n.prototype.updateVerticalScrollPosition=function(){k.updateScrollPosition(this.getTable(),undefined,e.TABLE);};n.prototype.restoreVerticalScrollPosition=function(){k.restoreScrollPosition(this.getTable());};n.prototype.updateVerticalScrollHeight=function(){var v=this.getVerticalScrollbar();var o=v?v.firstChild:null;if(!o){return;}var N=this.getVerticalScrollHeight(true);o.style.height=this.getVerticalScrollHeight()+"px";if(j(this.getTable()).iVerticalScrollHeight!==N){j(this.getTable()).iVerticalScrollHeight=N;k.updateScrollPosition(this.getTable());}};n.prototype.getVerticalScrollHeight=function(b){var t=this.getTable();if(!t){return 0;}var i=t._getTotalRowCount();var v=t.getVisibleRowCount();var a=t._getDefaultRowHeight();var r;var s;if(c.isVariableRowHeightEnabled(t)){r=Math.max(i,v+1);s=a*(r-1)+k.getScrollRangeBuffer(t);}else{r=Math.max(i,v);s=a*r;}if(b===true){return s;}else{return Math.min(M,s);}};n.prototype.updateVerticalScrollbarVisibility=function(){var t=this.getTable();var o=t?t.getDomRef():null;var v=this.getVerticalScrollbar();if(!o||!v){return;}var b=this.isVerticalScrollbarRequired();if(b&&!this.isVerticalScrollbarVisible()){if(!this.isVerticalScrollbarExternal()){o.classList.add("sapUiTableVScr");}v.classList.remove("sapUiTableHidden");}if(!b&&this.isVerticalScrollbarVisible()){o.classList.remove("sapUiTableVScr");v.classList.add("sapUiTableHidden");}};n.prototype.isVerticalScrollbarRequired=function(){var t=this.getTable();if(!t){return false;}return c.isVariableRowHeightEnabled(t)&&k.getInnerScrollRange(t)>0||(t._getTotalRowCount()>t.getVisibleRowCount());};n.prototype.updateInnerVerticalScrollPosition=function(){var t=this.getTable();var C=t?t.getDomRef("tableCCnt"):null;if(!c.isVariableRowHeightEnabled(t)||!C||k.isUpdatePending(t)){return;}if(t._getFirstRenderedRowIndex()!==t._iRenderedFirstVisibleRow){f("updateInnerVerticalScrollPosition: Skipped, because rows will be updated",t);return;}var a=k.getInnerScrollRange(t);if(a===0){f("updateInnerVerticalScrollPosition: 0",t);t.setFirstVisibleRow(0,true);this._nVerticalScrollPosition=0;C.scrollTop=0;return;}var F=t.getFirstVisibleRow();var b=k.getScrollPosition(t);var s=k.isScrollPositionInBuffer(t);var o=0;var p;var r;var u=null;var R=t._aRowHeights;if(!s){var v=k.getScrollRangeRowFraction(t);o=b-(F*v);p=R[0];r=Math.max(0,Math.min(o/v,1));u=Math.round(p*r);}else{var w=0;var x=0;var i;for(i=0;i<R.length&&x<a;i++){w++;x+=R[i];}var y=k.getScrollRange(t);var B=k.getScrollRangeBuffer(t);var z=B/w;if(j(t).iFirstVisibleRowInBuffer==null){o=b-y+B;var A=o/z;var G;if(Math.ceil(A)-A<0.00001){G=Math.ceil(o/z);}else{G=Math.floor(o/z);}G=Math.min(G,w);p=R[G]||0;r=Math.max(0,Math.min((o-(z*G))/z,1));for(i=0;i<G;i++){u+=R[i];}u+=p*r;u=Math.min(u,a);var N=t._getMaxFirstRenderedRowIndex()+G;if(N!==F){f("updateInnerVerticalScrollPosition: Set firstVisibleRow from "+F+" to "+N,t);t.setFirstVisibleRow(N,true);}}else{var J=y-B;o=j(t).iFirstVisibleRowInBuffer*z;var K=J+o;r=0;f("updateInnerVerticalScrollPosition: Set scroll position to "+K,t);k.updateScrollPosition(t,K);return;}}f("updateInnerVerticalScrollPosition: "+u+" of "+p+" ("+(r*100)+"%)"+" (in buffer: "+s+")",t);C.scrollTop=u;};n.prototype.registerForMouseWheel=function(a,o){var t=this.getTable();if(T.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){return m.addMouseWheelEventListener(a,t,o);}else{L.error("This method can only be used with synchronization enabled.",t,"TableScrollExtension#registerForMouseWheel");return null;}};n.prototype.registerForTouch=function(a,o){var t=this.getTable();if(T.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){return m.addTouchEventListener(a,t,o);}else{L.error("This method can only be used with synchronization enabled.",t,"TableScrollExtension#registerForTouch");return null;}};n.prototype._clearCache=function(){j(this.getTable()).oVerticalScrollbar=null;j(this.getTable()).oHorizontalScrollbar=null;};n.ScrollDirection=d;return n;});
