/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/CalendarDate','./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale','sap/ui/events/KeyCodes',"./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,D,H,M,b,Y,c,l,d,e,R,f,K,g,h,j,k,q){"use strict";var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var s=sap.ui.getCore().getConfiguration().getLocale().getLanguage();var m=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});m.prototype.init=function(){this._iBreakPointTablet=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._iColumns=1;this._oYearFormat=e.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var A=this._createMonth(this.getId()+"--Month0");A.attachEvent("focus",this._handleFocus,this);A.attachEvent("select",v,this);A.attachEvent("_renderMonth",u,this);A.attachEvent("_bindMousemove",w,this);A.attachEvent("_unbindMousemove",x,this);A._bNoThemeChange=true;this.addAggregation("month",A);this._initilizeMonthPicker();this._initilizeYearPicker();this._resizeProxy=q.proxy(y,this);this._oSelectedMonth;};m.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};m.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);i.attachEvent("pressButton3",this._handleButton1,this);i.attachEvent("pressButton4",this._handleButton2,this);this.setAggregation("header",i);};m.prototype._initializeSecondMonthHeader=function(){var S=new H(this.getId()+"--SecondMonthHead");S.addStyleClass("sapUiCalHeadSecondMonth");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);S.attachEvent("pressButton1",this._handleButton1,this);S.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("secondMonthHeader",S);};m.prototype._initilizeMonthPicker=function(){var i=new b(this.getId()+"--MP");i.attachEvent("select",this._selectMonth,this);i.attachEvent("pageChange",_,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);};m.prototype._initilizeYearPicker=function(){var i=new Y(this.getId()+"--YP");i.attachEvent("select",this._selectYear,this);this.setAggregation("yearPicker",i);};m.prototype._createMonth=function(i){var A=new M(i,{width:"100%"});A.attachEvent("datehovered",this._handleDateHovered,this);A.attachEvent("weekNumberSelect",this._handleWeekNumberSelect,this);return A;};m.prototype._handleWeekNumberSelect=function(E){var i=this.fireWeekNumberSelect({weekNumber:E.getParameter("weekNumber"),weekDays:E.getParameter("weekDays")});if(!i){E.preventDefault();}return this;};function _(E){var O=E.getParameter("offset");if(O>0){this._handleNext(E);}if(O<0){this._handlePrevious(E);}}m.prototype._handleDateHovered=function(E){var A=this.getAggregation("month"),B=E.getParameter("date1"),F=E.getParameter("date2"),i;for(i=0;i<A.length;i++){A[i]._markDatesBetweenStartAndHoveredDate(B,F);}};m.prototype.onBeforeRendering=function(){var A=this.getAggregation("month");var B;var E=A[0].getDate();var F=this._getFocusedDate();if(A.length>1&&E){B=c.fromLocalJSDate(E,this.getPrimaryCalendarType());}else if(A.length>1){B=z.call(this,this._getFocusedDate());}else{B=F;}for(var i=0;i<A.length;i++){E=new c(B);if(i>0){E.setDate(1);E.setMonth(E.getMonth()+i);}var G=E;if(F.getYear()===E.getYear()&&F.getMonth()===E.getMonth()){G=F;}A[i].displayDate(G.toLocalJSDate());A[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(B);this._iSize=0;};m.prototype.onAfterRendering=function(E){if(!this._getSucessorsPickerPopup()){p.call(this);}if(t.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};y.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};m.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof D))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=setTimeout(this._invalidateMonth.bind(this,O),0);}};m.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};m.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};m.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};m.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};m.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};m.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};m.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};m.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};m.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};m.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};m.prototype._getFocusedDate=function(){if(!this._oFocusedDate){n.call(this);}return this._oFocusedDate;};m.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new c(i,this.getPrimaryCalendarType());};m.prototype.focusDate=function(i){r.call(this,i,false);return this;};m.prototype.displayDate=function(i){r.call(this,i,true);return this;};m.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=c.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new c(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};m.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};m.prototype.setMonths=function(A){this._bDateRangeChanged=undefined;this.setProperty("months",A,false);A=t.call(this);var B=this.getAggregation("month");var i=0;var E;if(B.length<A){for(i=B.length;i<A;i++){E=this._createMonth(this.getId()+"--Month"+i);E.attachEvent("focus",this._handleFocus,this);E.attachEvent("select",v,this);E.attachEvent("_renderMonth",u,this);E.attachEvent("_bindMousemove",w,this);E.attachEvent("_unbindMousemove",x,this);E._bNoThemeChange=true;this.addAggregation("month",E);}}else if(B.length>A){for(i=B.length;i>A;i--){E=this.removeAggregation("month",i-1);E.destroy();}if(A==1){this._bInitMonth=true;}}if(A>1&&B[0].getDate()){B[0].setProperty("date",null,true);}return this;};m.prototype.setPrimaryCalendarType=function(A){var B=this.getAggregation("month");var E=false;if(B.length>1){E=true;}this.setProperty("primaryCalendarType",A,!E);this._oYearFormat=e.getDateInstance({format:"y",calendarType:A});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,A);}this._oMinDate=new c(this._oMinDate,A);this._oMaxDate=new c(this._oMaxDate,A);for(var i=0;i<B.length;i++){var F=B[i];F.setPrimaryCalendarType(A);}if(!this._getSucessorsPickerPopup()){var G=this.getAggregation("monthPicker");G.setPrimaryCalendarType(A);var I=this.getAggregation("yearPicker");I.setPrimaryCalendarType(A);}if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(!this._getSucessorsPickerPopup()){if(this.iMode!=1&&G.getDomRef()){G.$().remove();}if(this.iMode!=2&&I.getDomRef()){I.$().remove();}}}return this;};m.prototype.setSecondaryCalendarType=function(A){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",A,true);this._oYearFormatSecondary=e.getDateInstance({format:"y",calendarType:A});var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];E.setSecondaryCalendarType(A);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};m.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};m.prototype.setMinDate=function(i){if(j(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var A=this._oMinDate.getYear();a._checkYearInValidRange(A);if(this._oMaxDate.isBefore(this._oMinDate)){k.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){var B=this.getAggregation("yearPicker");B._oMinDate.setYear(this._oMinDate.getYear());}return this;};m.prototype.setMaxDate=function(i){if(j(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var A=this._oMaxDate.getYear();a._checkYearInValidRange(A);if(this._oMinDate.isAfter(this._oMaxDate)){k.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){var B=this.getAggregation("yearPicker");B._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};m.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){k.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};m.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var A=new f(i);this._oLocaleData=L.getInstance(A);}return this._oLocaleData;};m.prototype._getShowMonthHeader=function(){var i=t.call(this);if(i>2){return true;}else{return false;}};m.prototype.setWidth=function(W){this.setProperty("width",W,true);if(this.getDomRef()){W=this.getWidth();this.$().css("width",W);if(W){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};m.prototype.onclick=function(E){var i=E.target;if(E.isMarked("delayedMouseEvent")){return;}if(i.id==this.getId()+"-cancel"){this.onsapescape(E);}};m.prototype.onmousedown=function(E){if(E.cancelable){E.preventDefault();}E.setMark("cancelAutoClose");};m.prototype.onsapescape=function(E){this.fireCancel();this._closedPickers();};m.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};m.prototype.onkeydown=function(E){var i=E.which||E.keyCode,S=E.shiftKey;if(this._getSucessorsPickerPopup()||i!==K.F4){return;}E.preventDefault();S?this._showYearPicker():this._showMonthPicker();};m.prototype.onsaphide=m.prototype.onsapshow;m.prototype.onsaptabnext=function(E){var A=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabNext(E)){var B=A.getDomRef("B2");if(B){B.focus();}}else{var F=A.getDomRef("B1");if(F){F.focus();}}if(!this._bPoupupMode){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var J=this.getAggregation("monthPicker");var N=this.getAggregation("yearPicker");if(J.getDomRef()){q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(N.getDomRef()){q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}E.preventDefault();}else if(this._shouldFocusB2OnTabNext(E)){var B=A.getDomRef("B2");if(B){B.focus();}E.preventDefault();}};m.prototype._shouldFocusB2OnTabNext=function(E){var i=this.getAggregation("header");return(E.target.id==i.getId()+"-B1");};m.prototype._shouldFocusB2OnTabPrevious=function(E){return this._bPoupupMode;};m.prototype.onsaptabprevious=function(E){var A=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabPrevious()){var B=A.getDomRef("B2");if(B){B.focus();}E.preventDefault();}}else if(E.target.id==A.getId()+"-B1"){var F=this.getAggregation("month");var G;switch(this._iMode){case 0:G=this._getFocusedDate();for(var i=0;i<F.length;i++){var I=F[i];var J=c.fromLocalJSDate(I.getDate(),this.getPrimaryCalendarType());if(G.isSame(J)){I._oItemNavigation.focusItem(I._oItemNavigation.getFocusedIndex());}else{q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){var N=this.getAggregation("monthPicker");N._oItemNavigation.focusItem(N._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){var O=this.getAggregation("yearPicker");O._oItemNavigation.focusItem(O._oItemNavigation.getFocusedIndex());}break;}E.preventDefault();}else if(E.target.id==A.getId()+"-B2"){var P=A.getDomRef("B1");if(P){P.focus();}E.preventDefault();}};m.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var A=this.getAggregation("month");this._focusOnShiftTab();if(!this._bPoupupMode){for(var i=0;i<A.length;i++){var B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};m.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header");var A=i.getDomRef("B2");if(A){A.focus();}};m.prototype.onsapfocusleave=function(E){var A,B,F,G;if(!E.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){A=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<A.length;i++){B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:if(!this._getSucessorsPickerPopup()){F=this.getAggregation("monthPicker");q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){G=this.getAggregation("yearPicker");q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};m.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0];return i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()];};m.prototype.onThemeChanged=function(){var A;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){A=this.getAggregation("monthPicker");this._showMonthPicker(true);A._bNoThemeChange=false;A.onThemeChanged(arguments);A._bNoThemeChange=true;this._bLongMonth=A._bLongMonth;this._hideMonthPicker(true);}var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];E._bNoThemeChange=false;E.onThemeChanged(arguments);E._bNoThemeChange=true;}var F;if(B.length>1){F=c.fromLocalJSDate(B[0].getDate(),this.getPrimaryCalendarType());}else{F=this._getFocusedDate();}this._setHeaderText(F);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!this._getSucessorsPickerPopup()){p.call(this);}};m.prototype._updateHeader=function(i){this._setHeaderText(i);this._togglePrevNext(i,true);};m.prototype._togglePrevNext=function(i,A){var B=this._oMaxDate.getYear();var E=this._oMinDate.getYear();var F=this._oMaxDate.getMonth();var G=this._oMinDate.getMonth();var I=this.getAggregation("header");var J=t.call(this);var N=new c(i,this.getPrimaryCalendarType());if(this._iMode==0&&J>1){N=z.call(this,i);N.setMonth(N.getMonth()+J-1);N.setDate(a._daysInMonth(N));}else{N.setDate(a._daysInMonth(N));}var O=N.getYear();var P=N.getMonth();if(O>B||(O==B&&(!A||P>=F))||(this._iMode==1&&this._getSucessorsPickerPopup())){I.setEnabledNext(false);}else{I.setEnabledNext(true);}if(this._iMode==0&&J>1){N.setMonth(N.getMonth()-J+1);N.setDate(1);}else{N.setDate(1);}O=N.getYear();P=N.getMonth();if(O<E||(O==E&&(!A||P<=G))||(this._iMode==1&&this._getSucessorsPickerPopup())){I.setEnabledPrevious(false);}else{I.setEnabledPrevious(true);}};m.prototype._togglePrevNexYearPicker=function(){var i=this.getAggregation("yearPicker");var A=i.getYears();var B=c.fromLocalJSDate(i.getFirstRenderedDate());B.setYear(B.getYear()+Math.floor(A/2));var E=this.getAggregation("header");var F=new c(this._oMaxDate,this.getPrimaryCalendarType());F.setYear(F.getYear()-Math.ceil(A/2));F.setMonth(11);F.setDate(31);var G=new c(this._oMinDate,this.getPrimaryCalendarType());G.setYear(G.getYear()+Math.floor(A/2)+1);G.setMonth(0);G.setDate(1);E.setEnabledNext(B.isSameOrBefore(F));E.setEnabledPrevious(B.isSameOrAfter(G));};m.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var i=this.getAggregation("yearPicker");var A=t.call(this);var B;var G;var S=false;switch(this._iMode){case 0:if(A>1){B=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());B.setDate(1);this._setFocusedDate(B);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,true);break;case 1:F.setYear(F.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var I=this._getSecondaryCalendarType();if(I){G=new c(F,I);G.setMonth(0);G.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(G.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:i.previousPage();this._togglePrevNexYearPicker();break;}};m.prototype._handleNext=function(E){var F=this._getFocusedDate();var i=this.getAggregation("yearPicker");var A=t.call(this);var B;var G;switch(this._iMode){case 0:if(A>1){B=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(B);F=this._getFocusedDate();}F.setDate(1);F.setMonth(F.getMonth()+A);this._renderMonth();break;case 1:F.setYear(F.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){G=new c(F,S);G.setMonth(0);G.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(G.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:i.nextPage();this._togglePrevNexYearPicker();break;}};m.prototype._getDisplayedMonths=function(A){var B=[];var E=A.getMonth();var F=t.call(this);if(F>1){for(var i=0;i<F;i++){B.push((E+i)%12);}}else{B.push(E);}return B;};m.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=c.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new c(F,S);var A=F.getMonth();var B=c.fromLocalJSDate(i[i.length-1].getDate(),P);B.setDate(a._daysInMonth(B));B=new c(B,S);var E=B.getMonth();return{start:A,end:E};};m.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker();break;}};m.prototype._setDisabledMonths=function(i,A){var B=0;var E=11;if(i==this._oMinDate.getYear()){B=this._oMinDate.getMonth();}if(i==this._oMaxDate.getYear()){E=this._oMaxDate.getMonth();}if(!A){A=this.getAggregation("monthPicker");}A.setMinMax(B,E);};m.prototype._handleFocus=function(E){var i=c.fromLocalJSDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var A=E.getParameter("restoreOldDate");if(A){if(!j(this._getFocusedDate(),i)){this._renderMonth(false,false,true);}}else{this._focusDate(i,O);}};m.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};m.prototype._renderMonth=function(S,I,N){var A=this._getFocusedDate();var B=this.getAggregation("month");var F=false;var E;var G;var J;var i=0;for(i=0;i<B.length;i++){E=B[i];if(E.checkDateFocusable(A.toLocalJSDate())){F=true;}if(F||B.length==1){if(!S){E.setDate(A.toLocalJSDate());}else{E.displayDate(A.toLocalJSDate());}break;}}if(!F){J=new c(A,this.getPrimaryCalendarType());if(B.length>1){J=z.call(this,J);for(i=0;i<B.length;i++){E=B[i];G=new c(J,this.getPrimaryCalendarType());G.setMonth(J.getMonth()+i);if(!S&&a._isSameMonthAndYear(G,A)){E.setDate(A.toLocalJSDate());}else{E.displayDate(G.toLocalJSDate());}}}this._updateHeader(J);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!N){this.fireStartDateChange();}}};function n(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=c.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,i);}}m.prototype._showMonthPicker=function(S){if(this._iMode==2){this._hideYearPicker(true);}var A=this._getFocusedDate();var B=this.getAggregation("monthPicker");if(B.getDomRef()){B.$().css("display","");}else{var E=sap.ui.getCore().createRenderManager();var $=this.$("content");E.renderControl(B);E.flush($[0],false,true);E.destroy();}this._showOverlay();if(!S){B.setMonth(A.getMonth());this._setDisabledMonths(A.getYear(),B);if(this._iMode==0){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(A,false);};m.prototype._hideMonthPicker=function(S){this._iMode=0;var A=this.getAggregation("monthPicker");A.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(t.call(this)>1){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};m.prototype._showYearPicker=function(){if(this._iMode==1){this._hideMonthPicker(true);}var A=this._getFocusedDate();var B=this.getAggregation("yearPicker");if(B.getDomRef()){B.$().css("display","");}else{var E=sap.ui.getCore().createRenderManager();var $=this.$("content");E.renderControl(B);E.flush($[0],false,true);E.destroy();}this._showOverlay();B.setDate(A.toLocalJSDate());var F;if(t.call(this)==1){F=this.getAggregation("month")[0];var G=F.$("days").find(".sapUiCalItem");if(G.length==28){B.$().addClass("sapUiCalYearNoTop");}else{B.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var I=this.getAggregation("month");for(var i=0;i<I.length;i++){F=I[i];q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;};m.prototype._hideYearPicker=function(S){this._iMode=0;var A=this.getAggregation("yearPicker");A.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(t.call(this)>1){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};function p(){if(!this._bNamesLengthChecked){this._showMonthPicker(true);this._hideMonthPicker(true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var A=this.getAggregation("month");var B;if(A.length>1){B=c.fromLocalJSDate(A[0].getDate(),this.getPrimaryCalendarType());}else{B=this._getFocusedDate();}this._setHeaderText(B);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}}else if(t.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}m.prototype._focusDate=function(i,O,N){var F;var A=false;var B=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;A=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;A=true;}else{F=i;}if(this._focusDateExtend){B=this._focusDateExtend(i,O,N);}var I=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(A||O){this._renderMonth(false,I,N);}if(B){this.fireStartDateChange();}};m.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var A=this.getAggregation("month");if(A){for(var i=0;i<A.length;i++){var B=A[i];B._bDateRangeChanged=true;B._bInvalidateSync=true;B._bNoFocus=true;B.invalidate(O);B._bInvalidateSync=undefined;}}this._bDateRangeChanged=undefined;};m.prototype._setHeaderText=function(i){var A=this.getAggregation("header");var S=this.getAggregation("secondMonthHeader");var B=this._getLocaleData();var E=[];var F=[];var G=[];var I=[];var J;var N=false;var O;var P;var T;var Q;var U;var V=this.getPrimaryCalendarType();var W=this._getSecondaryCalendarType();var X="";if(this._bLongMonth||!this._bNamesLengthChecked){E=B.getMonthsStandAlone("wide",V);}else{N=true;E=B.getMonthsStandAlone("abbreviated",V);F=B.getMonthsStandAlone("wide",V);}if(W){G=B.getMonthsStandAlone("abbreviated",W);I=B.getMonthsStandAlone("wide",W);var Z=this._getDisplayedSecondaryMonths(V,W);if(Z.start==Z.end){T=G[Z.start];X=I[Z.start];}else{U=B.getIntervalPattern();T=U.replace(/\{0\}/,G[Z.start]).replace(/\{1\}/,G[Z.end]);X=U.replace(/\{0\}/,I[Z.start]).replace(/\{1\}/,I[Z.end]);}}A.setAdditionalTextButton1(T);A._setAdditionalTextButton3(T);S.setAdditionalTextButton1(T);var $=this._getDisplayedMonths(i);this._sFirstMonthName=O=E[$[0]];P=E[$[$.length-1]];if($.length>1&&!this._bShowOneMonth){if(!U){U=B.getIntervalPattern();}T=U.replace(/\{0\}/,O).replace(/\{1\}/,P);J=F.length?U.replace(/\{0\}/,F[$[0]]).replace(/\{1\}/,F[$[$.length-1]]):T;}else{T=O;J=F[$[0]]||T;}if(!this._getSucessorsPickerPopup()){if(X){J+=", "+X;}J+=". "+o.getText("CALENDAR_MONTH_PICKER_OPEN_HINT");}A.setTextButton1(T);A.setAriaLabelButton1(J);A._setTextButton3(P);A._setAriaLabelButton3(P);S.setTextButton1(P);S.setAriaLabelButton1(P);var a1=new c(i,V);a1.setDate(1);Q=this._oYearFormat.format(a1.toUTCJSDate(),true);this._updateHeadersYearPrimaryText(Q);if(W){a1=new c(a1,W);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(a1.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}return{sMonth:T,sYear:Q,sAriaLabel:J,bShort:N};};function r(i,S){if(!i){return;}var A=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var B=A.getYear();a._checkYearInValidRange(B);if(a._isOutside(A,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(A);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,false,true);}}function t(){if(d.system.phone){return 1;}else{return this.getMonths();}}m.prototype._handleButton1=function(E){if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}};m.prototype._handleButton2=function(E){if(this._iMode!=2){this._showYearPicker();}else{this._hideYearPicker();}};function u(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function v(E){if(t.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._updateSelection();}}}this._oSelectedMonth=E.oSource;this.fireSelect();}function w(E){if(t.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._bindMousemove();}}}}function x(E){if(t.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._unbindMousemove();}}}}m.prototype._selectMonth=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),A=i.getMonth();F.setMonth(A);if(A!=F.getMonth()){F.setDate(0);}this._focusDate(F,true);this._hideMonthPicker();};m.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};m.prototype._selectYear=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());var i=this.getAggregation("yearPicker");var A=c.fromLocalJSDate(i.getDate(),this.getPrimaryCalendarType());A.setMonth(F.getMonth());A.setDate(F.getDate());F=A;this._focusDate(F,true);this._hideYearPicker();};m.prototype._showOverlay=function(){this.$("contentOver").css("display","");};m.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};m.prototype._setColumns=function(i){this._iColumns=i;return this;};m.prototype._getColumns=function(){return this._iColumns;};m.prototype._updateHeadersButtons=function(){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){S.setVisible(true);i._setVisibleButton3(false);i._setVisibleButton4(false);}else if(this._isTwoMonthsInTwoColumns()){S.setVisible(false);i._setVisibleButton3(true);i._setVisibleButton4(true);}else{S.setVisible(false);i._setVisibleButton3(false);i._setVisibleButton4(false);}};m.prototype._setPrimaryHeaderMonthButtonText=function(){var i=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){i.setTextButton1(this._sFirstMonthName);}};m.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){if(s.toLowerCase()==="ja"||s.toLowerCase()==="zh"){this.addStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}else{this.addStyleClass("sapUiCalTwoMonthsTwoColumns");}}else{if(s.toLowerCase()==="ja"||s.toLowerCase()==="zh"){this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}}};m.prototype._isTwoMonthsInOneColumn=function(){var i=t.call(this);return this._getColumns()===1&&i===2;};m.prototype._isTwoMonthsInTwoColumns=function(){var i=t.call(this);return this._getColumns()===2&&i===2;};m.prototype._updateHeadersYearPrimaryText=function(i){var A=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader"),B=i;if(!this._getSecondaryCalendarType()){B+=(this._getSucessorsPickerPopup()?"":". "+o.getText("CALENDAR_YEAR_PICKER_OPEN_HINT"));}A.setTextButton2(i);A.setAriaLabelButton2(B);A._setTextButton4(i);A._setAriaLabelButton4(i);S.setTextButton2(i);S.setAriaLabelButton2(i);};m.prototype._updateHeadersYearAdditionalText=function(i){var A=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader"),B=A.getAriaLabelButton2();if(i){B+=", "+i+(this._getSucessorsPickerPopup()?"":". "+o.getText("CALENDAR_YEAR_PICKER_OPEN_HINT"));A.setAriaLabelButton2(B);}A.setAdditionalTextButton2(i);A._setAdditionalTextButton4(i);S.setAdditionalTextButton2(i);};function y(E){var W=E.size.width;if(W<=0){return;}var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var A=t.call(this);if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break;}if(A<this._getColumns()){this._setColumns(A);}if(this._getColumns()>2&&A>this._getColumns()){var B=this._getColumns();var U=0.0;var F=this._getColumns();while(B>=2){var G=A%B;if(G==0){F=B;break;}else{var N=G/B;if(N>U){U=N;F=B;}}B--;}this._setColumns(F);}var I;var J=this.getAggregation("month");if(this._getColumns()>1){I=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{I="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<J.length;i++){var P=J[i];P.setWidth(I);}}this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}function z(i){var F=new c(i,this.getPrimaryCalendarType());F.setDate(1);var A=t.call(this);if(A<=12){var B=i.getMonth();B=B-B%A;if(12%A>0&&B+A>11){B=12-A;}F.setMonth(B);}return F;}return m;});
