//@ui5-bundle sap/ui/unified/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/unified/Calendar',['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/CalendarDate','./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale','sap/ui/events/KeyCodes',"./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,D,H,M,b,Y,c,l,d,e,R,f,K,g,h,j,k,q){"use strict";var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var s=sap.ui.getCore().getConfiguration().getLocale().getLanguage();
var m=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});
m.prototype.init=function(){this._iBreakPointTablet=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._iColumns=1;this._oYearFormat=e.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var A=this._createMonth(this.getId()+"--Month0");A.attachEvent("focus",this._handleFocus,this);A.attachEvent("select",v,this);A.attachEvent("_renderMonth",u,this);A.attachEvent("_bindMousemove",w,this);A.attachEvent("_unbindMousemove",x,this);A._bNoThemeChange=true;this.addAggregation("month",A);this._initilizeMonthPicker();this._initilizeYearPicker();this._resizeProxy=q.proxy(y,this);this._oSelectedMonth;};
m.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};
m.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);i.attachEvent("pressButton3",this._handleButton1,this);i.attachEvent("pressButton4",this._handleButton2,this);this.setAggregation("header",i);};
m.prototype._initializeSecondMonthHeader=function(){var S=new H(this.getId()+"--SecondMonthHead");S.addStyleClass("sapUiCalHeadSecondMonth");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);S.attachEvent("pressButton1",this._handleButton1,this);S.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("secondMonthHeader",S);};
m.prototype._initilizeMonthPicker=function(){var i=new b(this.getId()+"--MP");i.attachEvent("select",this._selectMonth,this);i.attachEvent("pageChange",_,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);};
m.prototype._initilizeYearPicker=function(){var i=new Y(this.getId()+"--YP");i.attachEvent("select",this._selectYear,this);this.setAggregation("yearPicker",i);};
m.prototype._createMonth=function(i){var A=new M(i,{width:"100%"});A.attachEvent("datehovered",this._handleDateHovered,this);A.attachEvent("weekNumberSelect",this._handleWeekNumberSelect,this);return A;};
m.prototype._handleWeekNumberSelect=function(E){var i=this.fireWeekNumberSelect({weekNumber:E.getParameter("weekNumber"),weekDays:E.getParameter("weekDays")});if(!i){E.preventDefault();}return this;};
function _(E){var O=E.getParameter("offset");if(O>0){this._handleNext(E);}if(O<0){this._handlePrevious(E);}}
m.prototype._handleDateHovered=function(E){var A=this.getAggregation("month"),B=E.getParameter("date1"),F=E.getParameter("date2"),i;for(i=0;i<A.length;i++){A[i]._markDatesBetweenStartAndHoveredDate(B,F);}};
m.prototype.onBeforeRendering=function(){var A=this.getAggregation("month");var B;var E=A[0].getDate();var F=this._getFocusedDate();if(A.length>1&&E){B=c.fromLocalJSDate(E,this.getPrimaryCalendarType());}else if(A.length>1){B=z.call(this,this._getFocusedDate());}else{B=F;}for(var i=0;i<A.length;i++){E=new c(B);if(i>0){E.setDate(1);E.setMonth(E.getMonth()+i);}var G=E;if(F.getYear()===E.getYear()&&F.getMonth()===E.getMonth()){G=F;}A[i].displayDate(G.toLocalJSDate());A[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(B);this._iSize=0;};
m.prototype.onAfterRendering=function(E){if(!this._getSucessorsPickerPopup()){p.call(this);}if(t.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};y.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};
m.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof D))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=setTimeout(this._invalidateMonth.bind(this,O),0);}};
m.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};
m.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};
m.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
m.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};
m.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
m.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
m.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};
m.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};
m.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};
m.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
m.prototype._getFocusedDate=function(){if(!this._oFocusedDate){n.call(this);}return this._oFocusedDate;};
m.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new c(i,this.getPrimaryCalendarType());};
m.prototype.focusDate=function(i){r.call(this,i,false);return this;};
m.prototype.displayDate=function(i){r.call(this,i,true);return this;};
m.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=c.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new c(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};
m.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};
m.prototype.setMonths=function(A){this._bDateRangeChanged=undefined;this.setProperty("months",A,false);A=t.call(this);var B=this.getAggregation("month");var i=0;var E;if(B.length<A){for(i=B.length;i<A;i++){E=this._createMonth(this.getId()+"--Month"+i);E.attachEvent("focus",this._handleFocus,this);E.attachEvent("select",v,this);E.attachEvent("_renderMonth",u,this);E.attachEvent("_bindMousemove",w,this);E.attachEvent("_unbindMousemove",x,this);E._bNoThemeChange=true;this.addAggregation("month",E);}}else if(B.length>A){for(i=B.length;i>A;i--){E=this.removeAggregation("month",i-1);E.destroy();}if(A==1){this._bInitMonth=true;}}if(A>1&&B[0].getDate()){B[0].setProperty("date",null,true);}return this;};
m.prototype.setPrimaryCalendarType=function(A){var B=this.getAggregation("month");var E=false;if(B.length>1){E=true;}this.setProperty("primaryCalendarType",A,!E);this._oYearFormat=e.getDateInstance({format:"y",calendarType:A});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,A);}this._oMinDate=new c(this._oMinDate,A);this._oMaxDate=new c(this._oMaxDate,A);for(var i=0;i<B.length;i++){var F=B[i];F.setPrimaryCalendarType(A);}if(!this._getSucessorsPickerPopup()){var G=this.getAggregation("monthPicker");G.setPrimaryCalendarType(A);var I=this.getAggregation("yearPicker");I.setPrimaryCalendarType(A);}if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(!this._getSucessorsPickerPopup()){if(this.iMode!=1&&G.getDomRef()){G.$().remove();}if(this.iMode!=2&&I.getDomRef()){I.$().remove();}}}return this;};
m.prototype.setSecondaryCalendarType=function(A){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",A,true);this._oYearFormatSecondary=e.getDateInstance({format:"y",calendarType:A});var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];E.setSecondaryCalendarType(A);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};
m.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};
m.prototype.setMinDate=function(i){if(j(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var A=this._oMinDate.getYear();a._checkYearInValidRange(A);if(this._oMaxDate.isBefore(this._oMinDate)){k.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){var B=this.getAggregation("yearPicker");B._oMinDate.setYear(this._oMinDate.getYear());}return this;};
m.prototype.setMaxDate=function(i){if(j(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var A=this._oMaxDate.getYear();a._checkYearInValidRange(A);if(this._oMinDate.isAfter(this._oMaxDate)){k.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){var B=this.getAggregation("yearPicker");B._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};
m.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){k.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};
m.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var A=new f(i);this._oLocaleData=L.getInstance(A);}return this._oLocaleData;};
m.prototype._getShowMonthHeader=function(){var i=t.call(this);if(i>2){return true;}else{return false;}};
m.prototype.setWidth=function(W){this.setProperty("width",W,true);if(this.getDomRef()){W=this.getWidth();this.$().css("width",W);if(W){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};
m.prototype.onclick=function(E){var i=E.target;if(E.isMarked("delayedMouseEvent")){return;}if(i.id==this.getId()+"-cancel"){this.onsapescape(E);}};
m.prototype.onmousedown=function(E){if(E.cancelable){E.preventDefault();}E.setMark("cancelAutoClose");};
m.prototype.onsapescape=function(E){this.fireCancel();this._closedPickers();};
m.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};
m.prototype.onkeydown=function(E){var i=E.which||E.keyCode,S=E.shiftKey;if(this._getSucessorsPickerPopup()||i!==K.F4){return;}E.preventDefault();S?this._showYearPicker():this._showMonthPicker();};
m.prototype.onsaphide=m.prototype.onsapshow;
m.prototype.onsaptabnext=function(E){var A=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabNext(E)){var B=A.getDomRef("B2");if(B){B.focus();}}else{var F=A.getDomRef("B1");if(F){F.focus();}}if(!this._bPoupupMode){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var J=this.getAggregation("monthPicker");var N=this.getAggregation("yearPicker");if(J.getDomRef()){q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(N.getDomRef()){q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}E.preventDefault();}else if(this._shouldFocusB2OnTabNext(E)){var B=A.getDomRef("B2");if(B){B.focus();}E.preventDefault();}};
m.prototype._shouldFocusB2OnTabNext=function(E){var i=this.getAggregation("header");return(E.target.id==i.getId()+"-B1");};
m.prototype._shouldFocusB2OnTabPrevious=function(E){return this._bPoupupMode;};
m.prototype.onsaptabprevious=function(E){var A=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabPrevious()){var B=A.getDomRef("B2");if(B){B.focus();}E.preventDefault();}}else if(E.target.id==A.getId()+"-B1"){var F=this.getAggregation("month");var G;switch(this._iMode){case 0:G=this._getFocusedDate();for(var i=0;i<F.length;i++){var I=F[i];var J=c.fromLocalJSDate(I.getDate(),this.getPrimaryCalendarType());if(G.isSame(J)){I._oItemNavigation.focusItem(I._oItemNavigation.getFocusedIndex());}else{q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){var N=this.getAggregation("monthPicker");N._oItemNavigation.focusItem(N._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){var O=this.getAggregation("yearPicker");O._oItemNavigation.focusItem(O._oItemNavigation.getFocusedIndex());}break;}E.preventDefault();}else if(E.target.id==A.getId()+"-B2"){var P=A.getDomRef("B1");if(P){P.focus();}E.preventDefault();}};
m.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var A=this.getAggregation("month");this._focusOnShiftTab();if(!this._bPoupupMode){for(var i=0;i<A.length;i++){var B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};
m.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header");var A=i.getDomRef("B2");if(A){A.focus();}};
m.prototype.onsapfocusleave=function(E){var A,B,F,G;if(!E.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){A=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<A.length;i++){B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:if(!this._getSucessorsPickerPopup()){F=this.getAggregation("monthPicker");q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){G=this.getAggregation("yearPicker");q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};
m.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0];return i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()];};
m.prototype.onThemeChanged=function(){var A;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){A=this.getAggregation("monthPicker");this._showMonthPicker(true);A._bNoThemeChange=false;A.onThemeChanged(arguments);A._bNoThemeChange=true;this._bLongMonth=A._bLongMonth;this._hideMonthPicker(true);}var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];E._bNoThemeChange=false;E.onThemeChanged(arguments);E._bNoThemeChange=true;}var F;if(B.length>1){F=c.fromLocalJSDate(B[0].getDate(),this.getPrimaryCalendarType());}else{F=this._getFocusedDate();}this._setHeaderText(F);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!this._getSucessorsPickerPopup()){p.call(this);}};
m.prototype._updateHeader=function(i){this._setHeaderText(i);this._togglePrevNext(i,true);};
m.prototype._togglePrevNext=function(i,A){var B=this._oMaxDate.getYear();var E=this._oMinDate.getYear();var F=this._oMaxDate.getMonth();var G=this._oMinDate.getMonth();var I=this.getAggregation("header");var J=t.call(this);var N=new c(i,this.getPrimaryCalendarType());if(this._iMode==0&&J>1){N=z.call(this,i);N.setMonth(N.getMonth()+J-1);N.setDate(a._daysInMonth(N));}else{N.setDate(a._daysInMonth(N));}var O=N.getYear();var P=N.getMonth();if(O>B||(O==B&&(!A||P>=F))||(this._iMode==1&&this._getSucessorsPickerPopup())){I.setEnabledNext(false);}else{I.setEnabledNext(true);}if(this._iMode==0&&J>1){N.setMonth(N.getMonth()-J+1);N.setDate(1);}else{N.setDate(1);}O=N.getYear();P=N.getMonth();if(O<E||(O==E&&(!A||P<=G))||(this._iMode==1&&this._getSucessorsPickerPopup())){I.setEnabledPrevious(false);}else{I.setEnabledPrevious(true);}};
m.prototype._togglePrevNexYearPicker=function(){var i=this.getAggregation("yearPicker");var A=i.getYears();var B=c.fromLocalJSDate(i.getFirstRenderedDate());B.setYear(B.getYear()+Math.floor(A/2));var E=this.getAggregation("header");var F=new c(this._oMaxDate,this.getPrimaryCalendarType());F.setYear(F.getYear()-Math.ceil(A/2));F.setMonth(11);F.setDate(31);var G=new c(this._oMinDate,this.getPrimaryCalendarType());G.setYear(G.getYear()+Math.floor(A/2)+1);G.setMonth(0);G.setDate(1);E.setEnabledNext(B.isSameOrBefore(F));E.setEnabledPrevious(B.isSameOrAfter(G));};
m.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var i=this.getAggregation("yearPicker");var A=t.call(this);var B;var G;var S=false;switch(this._iMode){case 0:if(A>1){B=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());B.setDate(1);this._setFocusedDate(B);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,true);break;case 1:F.setYear(F.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var I=this._getSecondaryCalendarType();if(I){G=new c(F,I);G.setMonth(0);G.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(G.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:i.previousPage();this._togglePrevNexYearPicker();break;}};
m.prototype._handleNext=function(E){var F=this._getFocusedDate();var i=this.getAggregation("yearPicker");var A=t.call(this);var B;var G;switch(this._iMode){case 0:if(A>1){B=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(B);F=this._getFocusedDate();}F.setDate(1);F.setMonth(F.getMonth()+A);this._renderMonth();break;case 1:F.setYear(F.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){G=new c(F,S);G.setMonth(0);G.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(G.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:i.nextPage();this._togglePrevNexYearPicker();break;}};
m.prototype._getDisplayedMonths=function(A){var B=[];var E=A.getMonth();var F=t.call(this);if(F>1){for(var i=0;i<F;i++){B.push((E+i)%12);}}else{B.push(E);}return B;};
m.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=c.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new c(F,S);var A=F.getMonth();var B=c.fromLocalJSDate(i[i.length-1].getDate(),P);B.setDate(a._daysInMonth(B));B=new c(B,S);var E=B.getMonth();return{start:A,end:E};};
m.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker();break;}};
m.prototype._setDisabledMonths=function(i,A){var B=0;var E=11;if(i==this._oMinDate.getYear()){B=this._oMinDate.getMonth();}if(i==this._oMaxDate.getYear()){E=this._oMaxDate.getMonth();}if(!A){A=this.getAggregation("monthPicker");}A.setMinMax(B,E);};
m.prototype._handleFocus=function(E){var i=c.fromLocalJSDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var A=E.getParameter("restoreOldDate");if(A){if(!j(this._getFocusedDate(),i)){this._renderMonth(false,false,true);}}else{this._focusDate(i,O);}};
m.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};
m.prototype._renderMonth=function(S,I,N){var A=this._getFocusedDate();var B=this.getAggregation("month");var F=false;var E;var G;var J;var i=0;for(i=0;i<B.length;i++){E=B[i];if(E.checkDateFocusable(A.toLocalJSDate())){F=true;}if(F||B.length==1){if(!S){E.setDate(A.toLocalJSDate());}else{E.displayDate(A.toLocalJSDate());}break;}}if(!F){J=new c(A,this.getPrimaryCalendarType());if(B.length>1){J=z.call(this,J);for(i=0;i<B.length;i++){E=B[i];G=new c(J,this.getPrimaryCalendarType());G.setMonth(J.getMonth()+i);if(!S&&a._isSameMonthAndYear(G,A)){E.setDate(A.toLocalJSDate());}else{E.displayDate(G.toLocalJSDate());}}}this._updateHeader(J);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!N){this.fireStartDateChange();}}};
function n(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=c.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,i);}}
m.prototype._showMonthPicker=function(S){if(this._iMode==2){this._hideYearPicker(true);}var A=this._getFocusedDate();var B=this.getAggregation("monthPicker");if(B.getDomRef()){B.$().css("display","");}else{var E=sap.ui.getCore().createRenderManager();var $=this.$("content");E.renderControl(B);E.flush($[0],false,true);E.destroy();}this._showOverlay();if(!S){B.setMonth(A.getMonth());this._setDisabledMonths(A.getYear(),B);if(this._iMode==0){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(A,false);};
m.prototype._hideMonthPicker=function(S){this._iMode=0;var A=this.getAggregation("monthPicker");A.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(t.call(this)>1){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};
m.prototype._showYearPicker=function(){if(this._iMode==1){this._hideMonthPicker(true);}var A=this._getFocusedDate();var B=this.getAggregation("yearPicker");if(B.getDomRef()){B.$().css("display","");}else{var E=sap.ui.getCore().createRenderManager();var $=this.$("content");E.renderControl(B);E.flush($[0],false,true);E.destroy();}this._showOverlay();B.setDate(A.toLocalJSDate());var F;if(t.call(this)==1){F=this.getAggregation("month")[0];var G=F.$("days").find(".sapUiCalItem");if(G.length==28){B.$().addClass("sapUiCalYearNoTop");}else{B.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var I=this.getAggregation("month");for(var i=0;i<I.length;i++){F=I[i];q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;};
m.prototype._hideYearPicker=function(S){this._iMode=0;var A=this.getAggregation("yearPicker");A.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(t.call(this)>1){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};
function p(){if(!this._bNamesLengthChecked){this._showMonthPicker(true);this._hideMonthPicker(true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var A=this.getAggregation("month");var B;if(A.length>1){B=c.fromLocalJSDate(A[0].getDate(),this.getPrimaryCalendarType());}else{B=this._getFocusedDate();}this._setHeaderText(B);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}}else if(t.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}
m.prototype._focusDate=function(i,O,N){var F;var A=false;var B=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;A=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;A=true;}else{F=i;}if(this._focusDateExtend){B=this._focusDateExtend(i,O,N);}var I=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(A||O){this._renderMonth(false,I,N);}if(B){this.fireStartDateChange();}};
m.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var A=this.getAggregation("month");if(A){for(var i=0;i<A.length;i++){var B=A[i];B._bDateRangeChanged=true;B._bInvalidateSync=true;B._bNoFocus=true;B.invalidate(O);B._bInvalidateSync=undefined;}}this._bDateRangeChanged=undefined;};
m.prototype._setHeaderText=function(i){var A=this.getAggregation("header");var S=this.getAggregation("secondMonthHeader");var B=this._getLocaleData();var E=[];var F=[];var G=[];var I=[];var J;var N=false;var O;var P;var T;var Q;var U;var V=this.getPrimaryCalendarType();var W=this._getSecondaryCalendarType();var X="";if(this._bLongMonth||!this._bNamesLengthChecked){E=B.getMonthsStandAlone("wide",V);}else{N=true;E=B.getMonthsStandAlone("abbreviated",V);F=B.getMonthsStandAlone("wide",V);}if(W){G=B.getMonthsStandAlone("abbreviated",W);I=B.getMonthsStandAlone("wide",W);var Z=this._getDisplayedSecondaryMonths(V,W);if(Z.start==Z.end){T=G[Z.start];X=I[Z.start];}else{U=B.getIntervalPattern();T=U.replace(/\{0\}/,G[Z.start]).replace(/\{1\}/,G[Z.end]);X=U.replace(/\{0\}/,I[Z.start]).replace(/\{1\}/,I[Z.end]);}}A.setAdditionalTextButton1(T);A._setAdditionalTextButton3(T);S.setAdditionalTextButton1(T);var $=this._getDisplayedMonths(i);this._sFirstMonthName=O=E[$[0]];P=E[$[$.length-1]];if($.length>1&&!this._bShowOneMonth){if(!U){U=B.getIntervalPattern();}T=U.replace(/\{0\}/,O).replace(/\{1\}/,P);J=F.length?U.replace(/\{0\}/,F[$[0]]).replace(/\{1\}/,F[$[$.length-1]]):T;}else{T=O;J=F[$[0]]||T;}if(!this._getSucessorsPickerPopup()){if(X){J+=", "+X;}J+=". "+o.getText("CALENDAR_MONTH_PICKER_OPEN_HINT");}A.setTextButton1(T);A.setAriaLabelButton1(J);A._setTextButton3(P);A._setAriaLabelButton3(P);S.setTextButton1(P);S.setAriaLabelButton1(P);var a1=new c(i,V);a1.setDate(1);Q=this._oYearFormat.format(a1.toUTCJSDate(),true);this._updateHeadersYearPrimaryText(Q);if(W){a1=new c(a1,W);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(a1.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}return{sMonth:T,sYear:Q,sAriaLabel:J,bShort:N};};
function r(i,S){if(!i){return;}var A=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var B=A.getYear();a._checkYearInValidRange(B);if(a._isOutside(A,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(A);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,false,true);}}
function t(){if(d.system.phone){return 1;}else{return this.getMonths();}}
m.prototype._handleButton1=function(E){if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}};
m.prototype._handleButton2=function(E){if(this._iMode!=2){this._showYearPicker();}else{this._hideYearPicker();}};
function u(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}
function v(E){if(t.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._updateSelection();}}}this._oSelectedMonth=E.oSource;this.fireSelect();}
function w(E){if(t.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._bindMousemove();}}}}
function x(E){if(t.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._unbindMousemove();}}}}
m.prototype._selectMonth=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),A=i.getMonth();F.setMonth(A);if(A!=F.getMonth()){F.setDate(0);}this._focusDate(F,true);this._hideMonthPicker();};
m.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};
m.prototype._selectYear=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());var i=this.getAggregation("yearPicker");var A=c.fromLocalJSDate(i.getDate(),this.getPrimaryCalendarType());A.setMonth(F.getMonth());A.setDate(F.getDate());F=A;this._focusDate(F,true);this._hideYearPicker();};
m.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
m.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
m.prototype._setColumns=function(i){this._iColumns=i;return this;};
m.prototype._getColumns=function(){return this._iColumns;};
m.prototype._updateHeadersButtons=function(){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){S.setVisible(true);i._setVisibleButton3(false);i._setVisibleButton4(false);}else if(this._isTwoMonthsInTwoColumns()){S.setVisible(false);i._setVisibleButton3(true);i._setVisibleButton4(true);}else{S.setVisible(false);i._setVisibleButton3(false);i._setVisibleButton4(false);}};
m.prototype._setPrimaryHeaderMonthButtonText=function(){var i=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){i.setTextButton1(this._sFirstMonthName);}};
m.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){if(s.toLowerCase()==="ja"||s.toLowerCase()==="zh"){this.addStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}else{this.addStyleClass("sapUiCalTwoMonthsTwoColumns");}}else{if(s.toLowerCase()==="ja"||s.toLowerCase()==="zh"){this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}}};
m.prototype._isTwoMonthsInOneColumn=function(){var i=t.call(this);return this._getColumns()===1&&i===2;};
m.prototype._isTwoMonthsInTwoColumns=function(){var i=t.call(this);return this._getColumns()===2&&i===2;};
m.prototype._updateHeadersYearPrimaryText=function(i){var A=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader"),B=i;if(!this._getSecondaryCalendarType()){B+=(this._getSucessorsPickerPopup()?"":". "+o.getText("CALENDAR_YEAR_PICKER_OPEN_HINT"));}A.setTextButton2(i);A.setAriaLabelButton2(B);A._setTextButton4(i);A._setAriaLabelButton4(i);S.setTextButton2(i);S.setAriaLabelButton2(i);};
m.prototype._updateHeadersYearAdditionalText=function(i){var A=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader"),B=A.getAriaLabelButton2();if(i){B+=", "+i+(this._getSucessorsPickerPopup()?"":". "+o.getText("CALENDAR_YEAR_PICKER_OPEN_HINT"));A.setAriaLabelButton2(B);}A.setAdditionalTextButton2(i);A._setAdditionalTextButton4(i);S.setAdditionalTextButton2(i);};
function y(E){var W=E.size.width;if(W<=0){return;}var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var A=t.call(this);if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break;}if(A<this._getColumns()){this._setColumns(A);}if(this._getColumns()>2&&A>this._getColumns()){var B=this._getColumns();var U=0.0;var F=this._getColumns();while(B>=2){var G=A%B;if(G==0){F=B;break;}else{var N=G/B;if(N>U){U=N;F=B;}}B--;}this._setColumns(F);}var I;var J=this.getAggregation("month");if(this._getColumns()>1){I=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{I="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<J.length;i++){var P=J[i];P.setWidth(I);}}this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}
function z(i){var F=new c(i,this.getPrimaryCalendarType());F.setDate(1);var A=t.call(this);if(A<=12){var B=i.getMonth();B=B-B%A;if(12%A>0&&B+A>11){B=12-A;}F.setMonth(B);}return F;}
return m;});
sap.ui.predefine('sap/ui/unified/CalendarAppointment',['./DateTypeRange','sap/ui/core/format/DateFormat','./library',"sap/base/Log"],function(D,a,l,L){"use strict";
var C=D.extend("sap.ui.unified.CalendarAppointment",{metadata:{library:"sap.ui.unified",properties:{title:{type:"string",group:"Data"},text:{type:"string",group:"Data"},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},tentative:{type:"boolean",group:"Data",defaultValue:false},selected:{type:"boolean",group:"Data",defaultValue:false},key:{type:"string",group:"Data",defaultValue:null},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});
C.prototype.applyFocusInfo=function(f){var p=this.getParent();if(p){p.applyFocusInfo(f);}return this;};
C.prototype._getDateRangeIntersectionText=function(c){var s=this.getStartDate(),e=this.getEndDate()?this.getEndDate():new Date(864000000000000),t,o=new Date(c.getFullYear(),c.getMonth(),c.getDate(),0,0,0),n=new Date(o.getTime()+24*60*60*1000),T=a.getTimeInstance({pattern:"HH:mm"}),r=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(s.getTime()>n.getTime()||e.getTime()<o.getTime()){t="";}else if(s.getTime()<o.getTime()&&e.getTime()>n.getTime()){t=r.getText("PLANNINGCALENDAR_ALLDAY");}else if(s.getTime()<o.getTime()){t=r.getText("PLANNINGCALENDAR_UNTIL",[T.format(e)]);}else if(e.getTime()>n.getTime()){t=T.format(s);}else{t=T.format(s)+" - "+T.format(e);}return t;};
C._getComparer=function(d){var O=24*60*60*1000,c=new Date(d.getFullYear(),d.getMonth(),d.getDate(),0,0,0).getTime(),n=c+O;return function(A,o){var s=A.appointment.getStartDate().getTime(),S=o.appointment.getStartDate().getTime(),e=A.appointment.getEndDate()?A.appointment.getEndDate().getTime():864000000000000,E=o.appointment.getEndDate()?o.appointment.getEndDate().getTime():864000000000000,w=s<=c&&e>=n,W=S<=c&&E>=n,r;if((w&&W)||(!w&&!W)){r=s-S;if(r===0){r=E-e;}}else if(w){r=-1;}else{r=1;}return r;};};
C.prototype.setColor=function(c){if(c&&c.match(/^#[0-9a-f]{6}$/i)){L.warning("setColor accepts only full hex color value with pound symbol.");}return this.setProperty("color",c);};
C.prototype._getCSSColorForBackground=function(h){return"rgba("+[parseInt(h.substr(1,2),16),parseInt(h.substr(3,2),16),parseInt(h.substr(5,2),16)].join(",")+", 0.2)";};
return C;});
sap.ui.predefine('sap/ui/unified/CalendarDateInterval',['sap/ui/unified/calendar/CalendarUtils','./Calendar','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/Device',"./CalendarDateIntervalRenderer","sap/base/util/deepEqual","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,a,D,M,Y,b,l,c,d,e,P,L,q){"use strict";
var f=a.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},designtime:"sap/ui/unified/designtime/CalendarDateInterval.designtime"}});
f.prototype.init=function(){a.prototype.init.apply(this,arguments);this._iDaysMonthHead=35;};
f.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};
f.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};
f.prototype.setPickerPopup=function(p){this.setProperty("pickerPopup",p,true);var h=this.getAggregation("header"),m,y;if(p){if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}h.setVisibleButton2(false);h.detachEvent("pressButton2",this._handleButton2,this);this._setHeaderText(this._getFocusedDate(true));}else{if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}m=this.getAggregation("monthPicker");y=this.getAggregation("yearPicker");m.setColumns(0);m.setMonths(6);y.setColumns(0);y.setYears(6);y._oMinDate.setYear(this._oMinDate.getYear());y._oMaxDate.setYear(this._oMaxDate.getYear());h.setVisibleButton2(true);h.detachEvent("pressButton2",this._handleButton2,this);h.attachEvent("pressButton2",this._handleButton2,this);}return this;};
f.prototype._createMonthPicker=function(){var m=new M(this.getId()+"--MP");m.attachEvent("select",this._selectMonth,this);m._bNoThemeChange=true;m.setColumns(0);m.setMonths(3);m.attachEvent("pageChange",_,this);return m;};
f.prototype._createYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);y.setColumns(0);y.setYears(3);y.attachEvent("pageChange",g,this);return y;};
f.prototype._getCalendarPicker=function(){var o=this.getAggregation("calendarPicker");if(!o){o=new a(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",this._handleCalendarPickerDateSelect,this);o.attachEvent("cancel",function(E){this._closeCalendarPicker();var h=this.getAggregation("header").getDomRef("B1");if(h){h.focus();}},this);this.setAggregation("calendarPicker",o);}return o;};
f.prototype._setAriaRole=function(r){var o=this.getAggregation("month")[0];o._setAriaRole(r);o.invalidate();return this;};
f.prototype._handleButton1=function(E){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}}};
f.prototype._setHeaderText=function(o){var t=a.prototype._setHeaderText.apply(this,arguments);var T,A=t.sAriaLabel,h=this.getAggregation("header");var i=this._getLocaleData();var E=b.fromLocalJSDate(new Date(o.toLocalJSDate().getTime()+(this._getDays()-1)*24*60*60*1000),this.getPrimaryCalendarType());E.setDate(1);var s=i.getIntervalPattern().replace("{0}","").replace("{1}","");var j=this._oYearFormat.format(E.toUTCJSDate(),true);var m=t.sMonth;if(this.getPickerPopup()){if(i.oLocale.sLanguage.toLowerCase()==="ja"||i.oLocale.sLanguage.toLowerCase()==="zh"){if(j!=t.sYear){m=m.replace(s,s+j+" ");A=A.replace(s,s+j+" ");}T=t.sYear+" "+m;A=t.sYear+" "+A;}else{if(j!=t.sYear){m=m.replace(s," "+t.sYear+s);A=A.replace(s," "+t.sYear+s);}T=m+" "+j;A=A+" "+j;}h.setTextButton1(T,true);h.setAriaLabelButton1(A);}};
f.prototype._showCalendarPicker=function(){var s=this.getStartDate(),o=this._getCalendarPicker(),S=new sap.ui.unified.DateRange(),E=new Date(s.getTime());E.setDate(E.getDate()+this._getDays()-1);S.setStartDate(s);S.setEndDate(E);o.displayDate(this._getFocusedDate().toLocalJSDate());o.removeAllSelectedDates();o.addSelectedDate(S);o.setMinDate(this.getMinDate());o.setMaxDate(this.getMaxDate());this._openPickerPopup(o);this._showOverlay();};
f.prototype._handleCalendarPickerDateSelect=function(E){var o=this._getCalendarPicker(),s=o.getSelectedDates()[0].getStartDate(),n=new b.fromLocalJSDate(s);this._setStartDate(n);this._setFocusedDate(n);this._closeCalendarPicker();};
f.prototype._closeCalendarPicker=function(s){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!s){this._renderMonth();var m=this.getAggregation("month");for(var i=0;i<m.length;i++){var o=m[i];q(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}};
f.prototype._getDaysLarge=function(){return 10;};
f.prototype._createMonth=function(i){var m=new D(i);return m;};
f.prototype.setStartDate=function(s){C._checkJSDateObject(s);if(e(this.getStartDate(),s)){return this;}var y=s.getFullYear();C._checkYearInValidRange(y);var o=b.fromLocalJSDate(s,this.getPrimaryCalendarType());if(C._isOutside(o,this._oMinDate,this._oMaxDate)){throw new Error("Date must be in valid range (minDate and maxDate); "+this);}var m=this.getMinDate();if(m&&s.getTime()<m.getTime()){L.warning("startDate < minDate -> minDate as startDate set",this);s=new Date(m.getTime());}var h=this.getMaxDate();if(h&&s.getTime()>h.getTime()){L.warning("startDate > maxDate -> maxDate as startDate set",this);s=new Date(h.getTime());}this.setProperty("startDate",s,true);o=b.fromLocalJSDate(s,this.getPrimaryCalendarType());this._oStartDate=o;var i=this.getAggregation("month")[0];i.setStartDate(s);this._updateHeader(o);var j=this._getFocusedDate(true).toLocalJSDate();if(!i.checkDateFocusable(j)){this._setFocusedDate(o);i.displayDate(s);}return this;};
f.prototype.getStartDate=function(){return this.getProperty("startDate");};
f.prototype.setDays=function(i){this.setProperty("days",i,true);i=this._getDays();var o=this.getAggregation("month")[0];o.setDays(i);if(!this.getPickerPopup()){var m=this.getAggregation("monthPicker");var h=Math.ceil(i/3);if(h>12){h=12;}m.setMonths(h);var y=this.getAggregation("yearPicker");var j=Math.floor(i/2);if(j>20){j=20;}y.setYears(j);}var s=this._getStartDate();this._updateHeader(s);if(this.getDomRef()){if(i>this._getDaysLarge()){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(i>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
f.prototype._getDays=function(){var i=this.getDays();if(c.system.phone&&i>8){return 8;}else{return i;}};
f.prototype.setShowDayNamesLine=function(s){this.setProperty("showDayNamesLine",s,true);var o=this.getAggregation("month")[0];o.setShowDayNamesLine(s);return this;};
f.prototype._getShowMonthHeader=function(){var i=this._getDays();if(i>this._iDaysMonthHead){return true;}else{return false;}};
f.prototype._getFocusedDate=function(F){if(!this._oFocusedDate||F){this._oFocusedDate=null;a.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){this._setStartDate(this._oFocusedDate,false,true);}else if(!o.checkDateFocusable(this._oFocusedDate.toLocalJSDate())){this._oFocusedDate=b.fromLocalJSDate(s,this.getPrimaryCalendarType());}}return this._oFocusedDate;};
f.prototype.setMonths=function(m){if(m==1){return this.setProperty("months",m,false);}else{throw new Error("Property months not supported "+this);}};
f.prototype.setFirstDayOfWeek=function(F){if(F==-1){return this.setProperty("firstDayOfWeek",F,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};
f.prototype.focusDate=function(o){var h=this.getAggregation("month")[0];if(!h.checkDateFocusable(o)){this._focusDateExtend(b.fromLocalJSDate(o,this.getPrimaryCalendarType()),true,true);}a.prototype.focusDate.apply(this,arguments);return this;};
f.prototype._shouldFocusB2OnTabNext=function(E){var h=this.getAggregation("header");return(!this.getPickerPopup()&&E.target.id==h.getId()+"-B1");};
f.prototype._focusOnShiftTab=function(){var h=this.getAggregation("header");if(this.getPickerPopup()&&h.getDomRef("B1")){h.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&h.getDomRef("B2")){h.getDomRef("B2").focus();}};
f.prototype.onsapescape=function(E){if(this.getPickerPopup()){this._closeCalendarPicker();this.fireCancel();}else{if(this._iMode===0){this.fireCancel();}this._closedPickers();}};
f.prototype._focusDateExtend=function(o,O,n){if(O){var h=this._getFocusedDate();var i=this._getStartDate();var j=C._daysBetween(h,i);var N=new b(o,this.getPrimaryCalendarType());N.setDate(N.getDate()-j);this._setStartDate(N,false,true);if(!n){return true;}}return false;};
f.prototype._setMinMaxDateExtend=function(o){if(this._oStartDate){if(this._oStartDate.isBefore(this._oMinDate)){L.warning("start date < minDate -> minDate will be start date",this);this._setStartDate(new b(this._oMinDate,this.getPrimaryCalendarType()),true,true);}else{var E=new b(this._oStartDate);E.setDate(E.getDate()+this._getDays()-1);if(E.isAfter(this._oMaxDate)){L.warning("end date > maxDate -> start date will be changed",this);var s=new b(this._oMaxDate);s.setDate(s.getDate()-this._getDays()+1);this._setStartDate(s,true,true);}}}};
f.prototype._togglePrevNext=function(o,h){if(this._iMode>1||(this._iMode==1&&this.getPickerPopup())){return a.prototype._togglePrevNext.apply(this,arguments);}var y=this._oMaxDate.getYear();var i=this._oMinDate.getYear();var m=this._oMaxDate.getMonth();var j=this._oMinDate.getMonth();var k=this._oMinDate.getDate();var n=this._oMaxDate.getDate();var H=this.getAggregation("header");var p=this._getDays();var r;var s;var E;var t;var u;if(this._iMode==1&&!h){var v=this.getAggregation("monthPicker");var w=v.getMonths();var S=v.getStartMonth();var x=S+w-1;r=o.getYear();if(S==0||(r==i&&S<=j)){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}if(x>10||(r==y&&x>=m)){H.setEnabledNext(false);}else{H.setEnabledNext(true);}return;}s=this._getStartDate();E=new b(s,this.getPrimaryCalendarType());E.setDate(E.getDate()+p-1);if(C._isOutside(o,s,E)){s=new b(o,this.getPrimaryCalendarType());E=new b(s,this.getPrimaryCalendarType());E.setDate(E.getDate()+p-1);}r=s.getYear();t=s.getMonth();u=s.getDate();if(r<i||(r==i&&(!h||t<j||(t==j&&u<=k)))){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}r=E.getYear();t=E.getMonth();u=E.getDate();if(r>y||(r==y&&(!h||t>m||(t==m&&u>=n)))){H.setEnabledNext(false);}else{H.setEnabledNext(true);}};
f.prototype._shiftStartFocusDates=function(s,F,i){s.setDate(s.getDate()+i);F.setDate(F.getDate()+i);this._setFocusedDate(F);this._setStartDate(s,true);};
f.prototype._handlePrevious=function(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType()),m,y,s,i;switch(this._iMode){case 0:s=new b(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,(i*-1));break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.previousPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()-1);var h=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(h){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){y=this.getAggregation("yearPicker");y.previousPage();this._togglePrevNexYearPicker();}break;}};
f.prototype._handleNext=function(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType()),m,y,s,i;switch(this._iMode){case 0:s=new b(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,i);break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.nextPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()+1);var h=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(h){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){y=this.getAggregation("yearPicker");y.nextPage();this._togglePrevNexYearPicker();}break;}};
f.prototype._getDisplayedMonths=function(o){var m=[];var i=o.getMonth();var h=this._getDays();m.push(i);if(h>this._getDaysLarge()){var E=new b(o,this.getPrimaryCalendarType());E.setDate(E.getDate()+h-1);var j=E.getMonth();while(i!=j){i=(i+1)%12;m.push(i);}}return m;};
f.prototype._getDisplayedSecondaryMonths=function(p,s){var i=this._getDays();var S=new b(this._getStartDate(),s);var h=S.getMonth();var E=new b(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+i-1);E=new b(E,s);var j=E.getMonth();return{start:h,end:j};};
f.prototype._openPickerPopup=function(p){if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(function(){this._closeCalendarPicker(true);},this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(p);var h=this.getAggregation("header");var i=P.Dock;this._oPopup.open(0,i.CenterTop,i.CenterTop,h,null,"flipfit",true);};
f.prototype._getMaxDateAlignedToMinDate=function(m,o){var n=new b(m,this.getPrimaryCalendarType());if(n.isBefore(o)){n=new b(o);n.setDate(n.getDate()+this._getDays()-1);}return n;};
f.prototype._getStartDateAlignedToMinAndMaxDate=function(m,o,s){var n=new b(s,this.getPrimaryCalendarType());if(n.isBefore(o)){n=new b(o,this.getPrimaryCalendarType());}else if(n.isAfter(m)){n=m;}return n;};
f.prototype._calculateStartDate=function(m,o,s){var n=new b(m,this.getPrimaryCalendarType());n.setDate(n.getDate()-this._getDays()+1);n=this._getMaxDateAlignedToMinDate(n,o);s=this._getStartDateAlignedToMinAndMaxDate(n,o,s);return s;};
f.prototype._setStartDate=function(s,S,n){s=this._calculateStartDate(this._oMaxDate,this._oMinDate,s);var o=s.toLocalJSDate();this.setProperty("startDate",o,true);this._oStartDate=s;var h=this.getAggregation("month")[0];h.setStartDate(o);this._updateHeader(s);if(S){var i=this._getFocusedDate().toLocalJSDate();if(!h.checkDateFocusable(i)){this._setFocusedDate(s);h.setDate(o);}else{h.setDate(i);}}if(!n){this.fireStartDateChange();}};
f.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();}return this._oStartDate;};
function _(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType());this._togglePrevNext(F);}
function g(E){this._togglePrevNexYearPicker();}
return f;});
sap.ui.predefine('sap/ui/unified/CalendarDateIntervalRenderer',['sap/ui/core/Renderer','./CalendarRenderer'],function(R,C){"use strict";var a=R.extend(C);
a.renderCalContentOverlay=function(){};
a.renderCalContentAndArrowsOverlay=function(r,c,i){if(c.getPickerPopup()){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\"");if(!c._oPopup||!c._oPopup.isOpen()){r.write("style=\"display:none;\"");}r.write(">");r.write("</div>");}};
a.addAttributes=function(r,c){r.addClass("sapUiCalInt");r.addClass("sapUiCalDateInt");var d=c._getDays();if(d>c._getDaysLarge()){r.addClass("sapUiCalIntLarge");}if(d>c._iDaysMonthHead){r.addClass("sapUiCalIntHead");}};
return a;},true);
sap.ui.predefine('sap/ui/unified/CalendarLegend',['sap/ui/core/Control','./library','sap/ui/Device','./CalendarLegendRenderer',"sap/base/Log","sap/ui/thirdparty/jquery"],function(C,l,D,a,L,q){"use strict";var b=l.CalendarDayType;var S=l.StandardCalendarLegendItem;
var c=C.extend("sap.ui.unified.CalendarLegend",{
metadata:{library:"sap.ui.unified",properties:{standardItems:{type:"string[]",group:"Misc",defaultValue:['Today','Selected','WorkingDay','NonWorkingDay']},columnWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'120px'}},aggregations:{items:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,singularName:"item"},_standardItems:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,visibility:"hidden"}},designtime:"sap/ui/unified/designtime/CalendarLegend.designtime"},
constructor:function(i,s){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){s=i;}if(!s||(s&&!s.standardItems)){this._addStandardItems(this.getStandardItems());}this._bShouldRenderStandardItems=true;}
});
c.prototype.setStandardItems=function(v){var i;if(v&&v.length===1&&v[0]===""){v=[];}if(v&&v.length){v=this.validateProperty("standardItems",v);for(i=0;i<v.length;i++){if(!S[v[i]]){throw new Error("Invalid value '"+v[i]+"'. Property standardItems must contain values from sap.ui.unified.StandardCalendarLegendItem.");}}}this.setProperty("standardItems",v);this._addStandardItems(this.getStandardItems(),true);return this;};
c.prototype._addStandardItems=function(s,r){var i,d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),I=this.getId();if(r){this.destroyAggregation("_standardItems");}for(i=0;i<s.length;i++){var o=new sap.ui.unified.CalendarLegendItem(I+"-"+s[i],{text:d.getText(c._Standard_Items_TextKeys[s[i]])});this.addAggregation("_standardItems",o);}};
c._Standard_Items_TextKeys={"Today":"LEGEND_TODAY","Selected":"LEGEND_SELECTED","WorkingDay":"LEGEND_NORMAL_DAY","NonWorkingDay":"LEGEND_NON_WORKING_DAY"};
c.prototype._getItemType=function(i,I){var t=i.getType(),n,f;if(t&&t!==b.None){return t;}f=this._getUnusedItemTypes(I);n=I.filter(function(d){return!d.getType()||d.getType()===b.None;}).indexOf(i);if(n<0){L.error('Legend item is not in the legend',this);return t;}if(f[n]){t=f[n];}else{t="Type"+(Object.keys(b).length+n-f.length-1);}return t;};
c.prototype._getItemByType=function(t){var I,d=this.getItems(),i;for(i=0;i<d.length;i++){if(this._getItemType(d[i],d)===t){I=d[i];break;}}return I;};
c.prototype._getUnusedItemTypes=function(I){var f=q.extend({},b),t,i;delete f[b.None];delete f[b.NonWorking];for(i=0;i<I.length;i++){t=I[i].getType();if(f[t]){delete f[t];}}return Object.keys(f);};
return c;});
sap.ui.predefine('sap/ui/unified/CalendarLegendItem',['sap/ui/core/Element','./library'],function(E,l){"use strict";var C=l.CalendarDayType;
var a=E.extend("sap.ui.unified.CalendarLegendItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:C.None},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});
return a;});
sap.ui.predefine('sap/ui/unified/CalendarLegendRenderer',['sap/ui/core/InvisibleText'],function(I){"use strict";var C={};
C.render=function(r,l){var s=l.getAggregation("_standardItems"),c=l.getItems(),i,a,b;r.write("<div");r.writeControlData(l);r.addClass("sapUiUnifiedLegend");r.writeClasses();r.write(">");this.renderItemsHeader(r,l);if(s||c){r.write("<div");r.addClass("sapUiUnifiedLegendItems");r.writeClasses();b=l.getColumnWidth();r.writeAttribute("style","column-width:"+b+";-moz-column-width:"+b+";-webkit-column-width:"+b+";");r.writeStyles();r.write(">");if(s){a=l.getId().length+1;for(i=0;i<s.length;++i){var d="sapUiUnifiedLegend"+s[i].getId().slice(a);this.renderLegendItem(r,d,s[i],["sapUiUnifiedLegendSquareColor"]);}}if(c){for(i=0;i<c.length;i++){this.renderLegendItem(r,"sapUiCalLegDayType"+l._getItemType(c[i],c).slice(4),c[i],["sapUiUnifiedLegendSquareColor"]);}}r.write("</div>");}this.renderAdditionalContent(r,l);r.write("</div>");};
C.renderLegendItem=function(r,c,i,a){var t=i.getText();var T=i.getTooltip_AsString();r.write("<div");r.writeElementData(i);if(T){r.writeAttributeEscaped('title',T);}r.addClass("sapUiUnifiedLegendItem");r.addClass(c);r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiUnifiedLegendSquare");r.writeClasses();r.write(">");this.renderColor(r,i.getColor(),a);r.write("</div>");r.write("<div");r.writeAttribute("id",i.getId()+"-Text");r.addClass("sapUiUnifiedLegendDescription");r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</div></div>");};
C.renderItemsHeader=function(r,l){};
C.renderAdditionalContent=function(r,l){};
C.renderColor=function(r,c,a){r.write("<div");for(var i=0;i<a.length;i++){r.addClass(a[i]);}if(c){r.addStyle("background-color",c);r.writeStyles();}r.writeClasses();r.write("></div>");};
C.addCalendarTypeAccInfo=function(a,t,l){var T,s;if(l){var L=l._getItemByType(t);if(L){T=L.getText();}}if(T){a["label"]=a["label"]?a["label"]+"; "+T:T;}else{s=C.getTypeAriaText(t);if(s){a["describedby"]=a["describedby"]?a["describedby"]+" "+s.getId():s.getId();}}};
C.typeARIATexts={};
C.getTypeAriaText=function(t){var r,T;if(t.indexOf("Type")!==0){return;}if(!C.typeARIATexts[t]){r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");T=r.getText("LEGEND_UNNAMED_TYPE",parseInt(t.slice(4)).toString());C.typeARIATexts[t]=new I({text:T});C.typeARIATexts[t].toStatic();}return C.typeARIATexts[t];};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarMonthInterval',['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/Renderer','sap/ui/core/format/DateFormat','./calendar/CalendarUtils','./calendar/CustomYearPicker','./calendar/Header','./calendar/MonthsRow','./calendar/YearPicker','./calendar/CalendarDate','./CalendarMonthIntervalRenderer',"sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery"],function(D,C,L,a,R,b,c,d,H,M,Y,e,f,g,h,P,i,q){"use strict";
var j=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
j.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=b.getDateInstance({format:"y"});this._oMinDate=c._minDate();this._oMaxDate=c._maxDate();this._initializeHeader();this._initializeMonthsRow();this._initilizeYearPicker();this._iDaysMonthsHead=15;};
j.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};
j.prototype.onBeforeRendering=function(){var K=this.getAggregation("monthsRow");var N=this._getFocusedDate();p.call(this);K.displayDate(N.toLocalJSDate());};
j.prototype._setAriaRole=function(K){var N=this.getAggregation("monthsRow");N._setAriaRole(K);N.invalidate();return this;};
j.prototype._initializeHeader=function(){var K=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});K.attachEvent("pressPrevious",this._handlePrevious,this);K.attachEvent("pressNext",this._handleNext,this);K.attachEvent("pressButton2",w,this);this.setAggregation("header",K);};
j.prototype._initializeMonthsRow=function(){var K=new M(this.getId()+"--MonthsRow");K.attachEvent("focus",z,this);K.attachEvent("select",y,this);K._bNoThemeChange=true;this.setAggregation("monthsRow",K);};
j.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};
j.prototype._createYearPicker=function(){var K=new Y(this.getId()+"--YP",{columns:0,years:6});K.attachEvent("select",B,this);K.attachEvent("pageChange",J,this);K._oMinDate.setYear(this._oMinDate.getYear());K._oMaxDate.setYear(this._oMaxDate.getYear());return K;};
j.prototype._getCalendarPicker=function(){var K=this.getAggregation("calendarPicker");if(!K){K=new d(this.getId()+"--Cal");K.setPopupMode(true);K.attachEvent("select",A,this);K.attachEvent("cancel",function(N){this._oPopup.close();var O=this.getAggregation("header").getDomRef("B2");if(O){O.focus();}},this);this.setAggregation("calendarPicker",K);}return K;};
j.prototype.setStartDate=function(S){c._checkJSDateObject(S);if(h(this.getStartDate(),S)){return this;}var K=S.getFullYear();c._checkYearInValidRange(K);this.setProperty("startDate",S,true);this._oStartDate=e.fromLocalJSDate(S);this._oStartDate.setDate(1);var N=this.getAggregation("monthsRow");N.setStartDate(S);p.call(this);var O=this._getFocusedDate().toLocalJSDate();if(!N.checkDateFocusable(O)){this._setFocusedDate(this._oStartDate);N.displayDate(S);}return this;};
j.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(E.bind(this),0);}};
j.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var K=this.removeAllAggregation("selectedDates");return K;};
j.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var K=this.destroyAggregation("selectedDates");return K;};
j.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var K=this.removeAllAggregation("specialDates");return K;};
j.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var K=this.destroyAggregation("specialDates");return K;};
j.prototype.setLocale=function(K){if(this._sLocale!=K){this._sLocale=K;this._oLocaleData=undefined;this.invalidate();}return this;};
j.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
j.prototype._getFocusedDate=function(){if(!this._oFocusedDate){m.call(this);}return this._oFocusedDate;};
j.prototype._setFocusedDate=function(K){c._checkCalendarDate(K);this._oFocusedDate=new e(K);};
j.prototype.focusDate=function(K){var N=false;var O=this.getAggregation("monthsRow");if(K&&!O.checkDateFocusable(K)){F.call(this,e.fromLocalJSDate(K));N=true;}v.call(this,K,false);if(N){this.fireStartDateChange();}return this;};
j.prototype.displayDate=function(K){v.call(this,K,true);return this;};
j.prototype.setMonths=function(K){this.setProperty("months",K,true);K=this._getMonths();var N=this.getAggregation("monthsRow");N.setMonths(K);if(!N.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=k.call(this);this._setFocusedDate(this._oStartDate);N.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var O=this.getAggregation("yearPicker");var Q=Math.floor(K/2);if(Q>20){Q=20;}O.setYears(Q);}p.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
j.prototype._getMonths=function(){var K=this.getMonths();if(D.system.phone&&K>6){return 6;}else{return K;}};
j.prototype._getLocaleData=function(){if(!this._oLocaleData){var K=this.getLocale();var N=new L(K);this._oLocaleData=a.getInstance(N);}return this._oLocaleData;};
j.prototype.setPickerPopup=function(K){var N;this.setProperty("pickerPopup",K,true);if(K){if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}N=this.getAggregation("yearPicker");N.setColumns(0);N.setYears(6);}return this;};
j.prototype.setMinDate=function(K){if(h(K,this.getMinDate())){return this;}if(!K){this._oMinDate=c._minDate();}else{c._checkJSDateObject(K);this._oMinDate=e.fromLocalJSDate(K);this._oMinDate.setDate(1);var N=this._oMinDate.getYear();c._checkYearInValidRange(N);if(this._oMaxDate.isBefore(this._oMinDate)){i.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=e.fromLocalJSDate(K);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){i.warning("focused date < minDate -> minDate focused",this);this.focusDate(K);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){i.warning("start date < minDate -> minDate set as start date",this);_.call(this,new e(this._oMinDate),true,true);}}this.setProperty("minDate",K,false);if(this.getPickerPopup()){var O=this._getCalendarPicker();O.setMinDate(K);}else{var Q=this.getAggregation("yearPicker");Q._oMinDate.setYear(this._oMinDate.getYear());}return this;};
j.prototype.setMaxDate=function(K){if(h(K,this.getMaxDate())){return this;}if(!K){this._oMaxDate=c._maxDate();}else{c._checkJSDateObject(K);this._oMaxDate=e.fromLocalJSDate(K);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));var N=this._oMaxDate.getYear();c._checkYearInValidRange(N);if(this._oMinDate.isAfter(this._oMaxDate)){i.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=e.fromLocalJSDate(K);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){i.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(K);}}if(this._oStartDate){var O=new e(this._oStartDate);O.setDate(1);O.setMonth(O.getMonth()+this._getMonths());O.setDate(0);if(O.isAfter(this._oMaxDate)){var S=new e(this._oMaxDate);S.setDate(1);S.setMonth(S.getMonth()-this._getMonths()+1);if(S.isSameOrAfter(this._oMinDate)){i.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,S,true,true);}}}}this.setProperty("maxDate",K,false);if(this.getPickerPopup()){var Q=this._getCalendarPicker();Q.setMaxDate(K);}else{var T=this.getAggregation("yearPicker");T._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};
j.prototype.onclick=function(K){if(K.isMarked("delayedMouseEvent")){return;}if(K.target.id==this.getId()+"-cancel"){this.onsapescape(K);}};
j.prototype.onmousedown=function(K){K.preventDefault();K.setMark("cancelAutoClose");};
j.prototype.onsapescape=function(K){if(this.getPickerPopup()){x.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:o.call(this);break;}}};
j.prototype.onsaptabnext=function(K){var N=this.getAggregation("header"),O,Q;if(g(this.getDomRef("content"),K.target)){if(N.getDomRef("B2")){N.getDomRef("B2").focus();}if(!this._bPoupupMode){Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){O=this.getAggregation("yearPicker");if(O.getDomRef()){q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}K.preventDefault();}};
j.prototype.onsaptabprevious=function(K){var N=this.getAggregation("header"),O,Q;if(g(this.getDomRef("content"),K.target)){if(this._bPoupupMode){if(N.getDomRef("B2")){N.getDomRef("B2").focus();}K.preventDefault();}}else if(K.target.id==N.getId()+"-B2"){switch(this._iMode){case 0:O=this.getAggregation("monthsRow");O._oItemNavigation.focusItem(O._oItemNavigation.getFocusedIndex());break;case 1:if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");Q._oItemNavigation.focusItem(Q._oItemNavigation.getFocusedIndex());}break;}K.preventDefault();}};
j.prototype.onfocusin=function(K){if(K.target.id==this.getId()+"-end"){var N=this.getAggregation("header"),O,Q;if(N.getDomRef("B2")){N.getDomRef("B2").focus();}if(!this._bPoupupMode){O=this.getAggregation("monthsRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");if(Q.getDomRef()){q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};
j.prototype.onsapfocusleave=function(K){var N,O;if(!K.relatedControlId||!g(this.getDomRef(),sap.ui.getCore().byId(K.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){switch(this._iMode){case 0:N=this.getAggregation("monthsRow");q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:if(!this.getPickerPopup()){O=this.getAggregation("yearPicker");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};
j.prototype._handlePrevious=function(K){var N,O,S,Q;switch(this._iMode){case 0:N=this._getFocusedDate();O=this._getMonths();S=new e(k.call(this));S.setMonth(S.getMonth()-O);N.setMonth(N.getMonth()-O);this._setFocusedDate(N);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");Q.previousPage();s.call(this);}break;}};
j.prototype._handleNext=function(K){var N,O,S,Q;switch(this._iMode){case 0:N=this._getFocusedDate();O=this._getMonths();S=new e(k.call(this));S.setMonth(S.getMonth()+O);N.setMonth(N.getMonth()+O);this._setFocusedDate(N);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");Q.nextPage();s.call(this);}break;}};
j.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
j.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
j.prototype._getShowItemHeader=function(){var K=this.getMonths();if(K>this._iDaysMonthsHead){return true;}else{return false;}};
function _(S,K,N){var O=new e(this._oMaxDate);O.setDate(1);O.setMonth(O.getMonth()-this._getMonths()+1);if(O.isBefore(this._oMinDate)){O=new e(this._oMinDate);O.setMonth(O.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new e(this._oMinDate);}else if(S.isAfter(O)){S=O;}S.setDate(1);var Q=S.toLocalJSDate();this.setProperty("startDate",Q,true);this._oStartDate=S;var T=this.getAggregation("monthsRow");T.setStartDate(Q);p.call(this);if(K){var U=this._getFocusedDate().toLocalJSDate();if(!T.checkDateFocusable(U)){this._setFocusedDate(S);T.setDate(Q);}else{T.setDate(U);}}if(!N){this.fireStartDateChange();}}
function k(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}
function l(N){var K=this._getFocusedDate();var O=this.getAggregation("monthsRow");if(!N){O.setDate(K.toLocalJSDate());}else{O.displayDate(K.toLocalJSDate());}p.call(this);}
function m(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=e.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new e();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new e(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new e(this._oMaxDate);}}
function n(){var K=this._getFocusedDate();var N=this.getAggregation("yearPicker");if(N.getDomRef()){N.$().css("display","");}else{var O=sap.ui.getCore().createRenderManager();var $=this.$("content");O.renderControl(N);O.flush($[0],false,true);O.destroy();}this._showOverlay();N.setDate(K.toLocalJSDate());if(this._iMode==0){var Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}s.call(this);this._iMode=1;}
function o(N){this._iMode=0;var K=this.getAggregation("yearPicker");K.$().css("display","none");this._hideOverlay();if(!N){l.call(this);var O=this.getAggregation("monthsRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function p(){t.call(this);r.call(this);}
function r(){var K=new e(k.call(this));var N=this._getMonths();var O=K.getYear();var Q=this._oMaxDate.getYear();var S=this._oMinDate.getYear();var T=K.getMonth();var U=this._oMaxDate.getMonth();var V=this._oMinDate.getMonth();var W=this.getAggregation("header");if(O<S||(O==S&&T<=V)){W.setEnabledPrevious(false);}else{W.setEnabledPrevious(true);}K.setMonth(K.getMonth()+N-1);O=K.getYear();T=K.getMonth();if(O>Q||(O==Q&&T>=U)){W.setEnabledNext(false);}else{W.setEnabledNext(true);}}
function s(){var K=this.getAggregation("yearPicker");var N=K.getYears();var O=e.fromLocalJSDate(K.getFirstRenderedDate());O.setYear(O.getYear()+Math.floor(N/2));var Q=this.getAggregation("header");var S=new e(this._oMaxDate);S.setYear(S.getYear()-Math.ceil(N/2));S.setMonth(11,31);var T=new e(this._oMinDate);T.setYear(T.getYear()+Math.floor(N/2)+1);T.setMonth(0,1);Q.setEnabledNext(!O.isAfter(S));Q.setEnabledPrevious(!O.isBefore(T));}
function t(){var T;var S=k.call(this);var K=this._oYearFormat.format(S.toUTCJSDate(),true);var N=new e(S);N.setMonth(N.getMonth()+this._getMonths()-1);var O=this._oYearFormat.format(N.toUTCJSDate(),true);if(K!=O){var Q=this._getLocaleData();var U=Q.getIntervalPattern();T=U.replace(/\{0\}/,K).replace(/\{1\}/,O);}else{T=K;}var V=this.getAggregation("header");V.setTextButton2(T);}
function u(K,N){var O;var Q=false;if(K.isBefore(this._oMinDate)){O=this._oMinDate;Q=true;}else if(K.isAfter(this._oMaxDate)){O=this._oMaxDate;Q=true;}else{O=K;}this._setFocusedDate(O);if(Q||N){F.call(this,O);l.call(this,false);this.fireStartDateChange();}}
function v(K,S){if(!K){return;}var N=e.fromLocalJSDate(K);if(this._oFocusedDate&&this._oFocusedDate.isSame(N)){return;}var O=N.getYear();c._checkYearInValidRange(O);if(c._isOutside(N,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(N);if(this.getDomRef()&&this._iMode==0){l.call(this,S);}}
function w(K){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){n.call(this);}else{o.call(this);}}}
j.prototype._showCalendarPicker=function(){var K=this._getFocusedDate(true).toLocalJSDate();var N=this._getCalendarPicker();var S=new sap.ui.unified.DateRange({startDate:K});N.displayDate(K,false);N.removeAllSelectedDates();N.addSelectedDate(S);N.setMinDate(this.getMinDate());N.setMaxDate(this.getMaxDate());G.call(this,N);this._showOverlay();};
function x(N){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!N){l.call(this);var K=this.getAggregation("monthsRow");q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function y(K){this.fireSelect();}
function z(K){var N=e.fromLocalJSDate(K.getParameter("date"));var O=K.getParameter("notVisible");u.call(this,N,O);}
function A(K){var N=new e(this._getFocusedDate());var O=this._getCalendarPicker();var S=O.getSelectedDates()[0].getStartDate();var Q=e.fromLocalJSDate(S);Q.setMonth(N.getMonth());Q.setDate(N.getDate());u.call(this,Q,true);x.call(this);}
function B(K){var N=new e(this._getFocusedDate());var O=this.getAggregation("yearPicker");var Q=e.fromLocalJSDate(O.getDate());Q.setMonth(N.getMonth());Q.setDate(N.getDate());N=Q;u.call(this,N,true);o.call(this);}
function E(){this._sInvalidateContent=undefined;var K=this.getAggregation("monthsRow");if(K){K._bDateRangeChanged=true;K._bInvalidateSync=true;K.invalidate();K._bInvalidateSync=undefined;}this._bDateRangeChanged=undefined;}
function F(K){var N=this.getAggregation("monthsRow");var S=k.call(this);var O=N._oItemNavigation.getFocusedIndex();S=new e(K);S.setMonth(S.getMonth()-O);_.call(this,S,false,true);}
function G(K){if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(I,this);this._oPopup.onsapescape=function(Q){this._oCalendar.onsapescape(Q);};}this._oPopup.setContent(K);var N=this.getAggregation("header");var O=P.Dock;this._oPopup.open(0,O.CenterTop,O.CenterTop,N,null,"flipfit",true);}
function I(K){x.call(this);}
function J(K){s.call(this);}
return j;});
sap.ui.predefine('sap/ui/unified/CalendarMonthIntervalRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var i=c.getId();var t=c.getTooltip_AsString();var m=c.getAggregation("monthsRow");r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");r.addClass("sapUiCalInt");r.addClass("sapUiCalMonthInt");if(c._getShowItemHeader()){r.addClass("sapUiCalIntHead");}var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}var w=c.getWidth();if(w&&w!=''){r.addStyle("width",w);r.writeStyles();}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);r.write("<div id=\""+i+"-content\" class=\"sapUiCalContent\">");r.renderControl(m);r.write("</div>");r.write("<button id=\""+i+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+i+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");if(c.getPickerPopup()){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\"");if(!c._oPopup||!c._oPopup.isOpen()){r.write("style=\"display:none;\"");}r.write(">");r.write("</div>");}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarOneMonthInterval',['sap/ui/unified/calendar/CustomMonthPicker','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/Calendar','./library','sap/ui/unified/CalendarDateInterval','sap/ui/unified/calendar/OneMonthDatesRow'],function(C,a,b,c,l,d,O){"use strict";
var e=d.extend("sap.ui.unified.CalendarOneMonthInterval",{});
e.prototype.init=function(){d.prototype.init.apply(this,arguments);this._bShowOneMonth=true;};
e.prototype._getCalendarPicker=function(){var o=this.getAggregation("calendarPicker");if(!o){o=new C(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",function(){var o=this._getCalendarPicker(),f=o._getFocusedDate(),n=a._getFirstDateOfMonth(f);var g=this.getAggregation("month")[0];this._setStartDate(n);if(g.getMode()<2){n=this._getStartDate();}this._adjustSelectedDate(n,false);this._oFocusDateOneMonth=n;this._closeCalendarPicker(true);this._focusDate(f,false,true);},this);o.attachEvent("cancel",function(E){var o=this._getCalendarPicker(),f=o._getFocusedDate();this._closeCalendarPicker(true);this._oFocusDateOneMonth=f;this._focusDate(f,true);var D=this.getAggregation("header").getDomRef("B1");if(D){D.focus();}},this);this.setAggregation("calendarPicker",o);}return o;};
e.prototype._createMonth=function(i){return new O(i);};
e.prototype._handleFocus=function(E){var o=!!E.getParameter("_outsideBorder"),D=E.getParameter("date"),f=b.fromLocalJSDate(D),g=b.fromLocalJSDate(this.getStartDate()),i=!a._isSameMonthAndYear(f,g),h,F,s;if(o||i){if(a._isLastDateInMonth(f)){this._oFocusDateOneMonth=f;}else{this._oFocusDateOneMonth=a._getFirstDateOfMonth(f);}h=f.isBefore(g)?-1:1;F=new b(this._getFocusedDate(),this.getPrimaryCalendarType());s=new b(this._getStartDate(),this.getPrimaryCalendarType());d.prototype._shiftStartFocusDates.call(this,F,s,h);}return d.prototype._handleFocus.apply(this,arguments);};
e.prototype._focusDateExtend=function(D,o,n){var f,L;if(!this._oFocusDateOneMonth){return d.prototype._focusDateExtend.apply(this,arguments);}f=this.getAggregation("month")[0];L=this._oFocusDateOneMonth.toLocalJSDate();this._setFocusedDate(this._oFocusDateOneMonth);f._bNoRangeCheck=true;f.setDate(L);f._bNoRangeCheck=false;this._oFocusDateOneMonth=null;return!n;};
e.prototype._setDisplayMode=function(m){this.getAggregation("month")[0].setMode(m);};
e.prototype._shiftStartFocusDates=function(s,f,D){var S=D,o=this.getAggregation("month")[0],L,g;if(S!==0){S=S>0?1:-1;}s.setMonth(s.getMonth()+S);f.setYear(s.getYear());f.setMonth(s.getMonth(),s.getDate());this._setFocusedDate(f);this._setStartDate(s,true);L=this.getStartDate();g=b.fromLocalJSDate(L,this.getPrimaryCalendarType());if(this.getMinDate()&&this.getMinDate().getTime()>L.getTime()){g=b.fromLocalJSDate(this.getMinDate(),this.getPrimaryCalendarType());}if(this.getMaxDate()&&this.getMaxDate().getTime()<L.getTime()){g=b.fromLocalJSDate(this.getMaxDate(),this.getPrimaryCalendarType());}o.selectDate(g.toLocalJSDate());if(o.getMode()<2){this.fireSelect();}};
e.prototype._adjustSelectedDate=function(D,u){var m=this.getAggregation("month")[0],s;s=u?a._getFirstDateOfMonth(D):D;if(m.getMode&&m.getMode()<2){this._selectDate(s);}};
e.prototype._selectDate=function(D){var m=this.getAggregation("month")[0],L=D.toLocalJSDate();this.removeAllSelectedDates();this.addSelectedDate(new sap.ui.unified.DateRange({startDate:L}));m.selectDate(L);this._bDateRangeChanged=undefined;};
e.prototype._dateMatchesVisibleRange=function(D){return a._isSameMonthAndYear(b.fromLocalJSDate(this.getStartDate()),b.fromLocalJSDate(D));};
e.prototype._togglePrevNext=function(D,f){var h=this.getAggregation("header");var y=this._oMaxDate.getYear();var Y=this._oMinDate.getYear();var m=this._oMaxDate.getMonth();var M=this._oMinDate.getMonth();var F=a._getFirstDateOfMonth(D);var o=new b(F),i,g;o.setMonth(o.getMonth()+1);i=F.getYear();g=F.getMonth();if(i<Y||(i==Y&&(!f||g<=M))){h.setEnabledPrevious(false);}else{h.setEnabledPrevious(true);}i=o.getYear();g=o.getMonth();if(i>y||(i==y&&(!f||g>m))){h.setEnabledNext(false);}else{h.setEnabledNext(true);}};
e.prototype._setMinMaxDateExtend=function(D){return c.prototype._setMinMaxDateExtend.apply(this,arguments);};
return e;});
sap.ui.predefine('sap/ui/unified/CalendarOneMonthIntervalRenderer',['sap/ui/core/Renderer','./CalendarDateIntervalRenderer'],function(R,C){"use strict";var a=R.extend(C);
a.addAttributes=function(r,c){C.addAttributes.apply(this,arguments);r.addClass("sapUiCalOneMonthInt");};
return a;},true);
sap.ui.predefine('sap/ui/unified/CalendarRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var I=c.getId();var t=c.getTooltip_AsString();var m=c.getAggregation("month");var w=c.getWidth();r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");if(m.length>1){r.addClass("sapUiCalMulti");}var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}if(w){r.addClass("sapUiCalWidth");r.addStyle("width",w);r.writeStyles();}if(c._getSecondaryCalendarType()){r.addClass("sapUiCalSecType");}if(this.addAttributes){this.addAttributes(r,c);}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);var M=m.length;r.write("<div id=\""+I+"-content\" class=\"sapUiCalContent\">");for(var i=0;i<M;i++){var o=m[i];r.renderControl(o);if(M===2&&i===0){r.renderControl(c.getAggregation("secondMonthHeader"));}}this.renderCalContentOverlay(r,c,I);if(!c._bNamesLengthChecked){var b=c.getAggregation("monthPicker");r.renderControl(b);}r.write("</div>");r.write("<button id=\""+I+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+I+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");this.renderCalContentAndArrowsOverlay(r,c,I);r.write("</div>");};
C.renderCalContentOverlay=function(r,c,i){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");};
C.renderCalContentAndArrowsOverlay=function(r,c,i){};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarRow',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(C,D,L,a,U,l,I,b,R,c,d,e,q){"use strict";var f=l.CalendarDayType;var g=l.CalendarAppointmentVisualization;var G=l.GroupAppointmentsMode;var h=l.CalendarIntervalType;
var m=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:h.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:g.Standard}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});
m.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatAria=b.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);this.aSelectedAppointments=[];this._fnCustomSortedAppointments=undefined;};
m.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._fnCustomSortedAppointments=undefined;};
m.prototype.onBeforeRendering=function(){p.call(this);t.call(this);x.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};
m.prototype.onAfterRendering=function(){y.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}};
m.prototype.onThemeChanged=function(j){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var k=this._aVisibleAppointments[i];k.level=-1;}this.handleResize(j);}};
m.prototype.invalidate=function(O){if(O&&O instanceof sap.ui.unified.CalendarAppointment){var j=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==O){j=true;break;}}if(j){this._aVisibleAppointments=[];}this._updateSelectedAppointmentsArray(O);}C.prototype.invalidate.apply(this,arguments);};
m.prototype.setStartDate=function(S){if(!S){S=new Date();}a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);this.setProperty("startDate",S);return this;};
m.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};
m.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};
m.prototype.setGroupAppointmentsMode=function(i){this.setProperty("groupAppointmentsMode",i);this._aVisibleAppointments=[];return this;};
m.prototype.setAppointmentsReducedHeight=function(i){this.setProperty("appointmentsReducedHeight",i);this._aVisibleAppointments=[];return this;};
m.prototype._getAppointmentReducedHeight=function(i){var j=false;if(!D.system.phone&&this.getAppointmentsReducedHeight()&&!i.getText()){j=true;}return j;};
m.prototype.onfocusin=function(j){if(q(j.target).hasClass("sapUiCalendarApp")){F.call(this,j.target.id);}else{var V=this._getVisibleAppointments();var k=false;var N;for(var i=0;i<V.length;i++){N=V[i].appointment;if(e(N.getDomRef(),j.target)){k=true;N.focus();break;}}if(!k){N=this.getFocusedAppointment();if(N){N.focus();}}}};
m.prototype.applyFocusInfo=function(i){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};
m.prototype.onsapleft=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){H.call(this,this._bRTL,1);}i.preventDefault();i.stopPropagation();};
m.prototype.onsapright=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){H.call(this,!this._bRTL,1);}i.preventDefault();i.stopPropagation();};
m.prototype.onsapup=function(i){this.fireLeaveRow({type:i.type});};
m.prototype.onsapdown=function(i){this.fireLeaveRow({type:i.type});};
m.prototype.onsaphome=function(i){J.call(this,i);i.preventDefault();i.stopPropagation();};
m.prototype.onsapend=function(i){J.call(this,i);i.preventDefault();i.stopPropagation();};
m.prototype.onsapselect=function(j){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var k=V[i].appointment;if(e(k.getDomRef(),j.target)){z.call(this,k,!(j.ctrlKey||j.metaKey));break;}}j.stopPropagation();j.preventDefault();};
m.prototype.ontap=function(i){var j=this.$("Apps").children(".sapUiCalendarRowAppsInt");var k=0;var N=false;for(k=0;k<j.length;k++){var O=j[k];if(!this._isOneMonthIntervalOnSmallSizes()&&e(O,i.target)){N=true;break;}}if(N){K.call(this,k,i.target);}else{this.onsapselect(i);}};
m.prototype.onsapselectmodifiers=function(i){this.onsapselect(i);};
m.prototype.handleResize=function(i){if(i&&i.size&&i.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");y.call(this);return this;};
m.prototype.updateCurrentTimeVisualization=function(){var N=this.$("Now");var i=a._createUniversalUTCDate(new Date(),undefined,true);var j=this.getIntervals();var k=this.getIntervalType();var S=this._getStartDate();var O=S.getTime();var P=this._oUTCEndDate;var Q=P.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=Q&&i.getTime()>=O){var T=v.call(this,k,j,S,P,O,i);var V=0;if(this._bRTL){N.css("right",T+"%");}else{N.css("left",T+"%");}N.css("display","");if(this.getUpdateCurrentTime()){switch(k){case h.Hour:V=60000;break;case h.Day:case h.Week:case h.OneMonth:V=1800000;break;default:V=-1;break;}if(V>0){this._sUpdateCurrentTime=setTimeout(this.updateCurrentTimeVisualization.bind(this),V);}}}else{N.css("display","none");}return this;};
m.prototype.getFocusedAppointment=function(){var j=this._getAppointmentsSorted();var k=this.getAggregation("groupAppointments",[]);var N;var i=0;for(i=0;i<k.length;i++){if(k[i].getId()==this._sFocusedAppointmentId){N=k[i];break;}}if(!N){for(i=0;i<j.length;i++){if(j[i].getId()==this._sFocusedAppointmentId){N=j[i];break;}}}return N;};
m.prototype.focusAppointment=function(i){if(!i||!(i instanceof sap.ui.unified.CalendarAppointment)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var j=i.getId();if(this._sFocusedAppointmentId!=j){F.call(this,j);}else{i.focus();}return this;};
m.prototype.focusNearestAppointment=function(j){a._checkJSDateObject(j);var k=this._getAppointmentsSorted();var N;var P;var O;for(var i=0;i<k.length;i++){N=k[i];if(N.getStartDate()>j){if(i>0){P=k[i-1];}else{P=N;}break;}}if(N){if(P&&Math.abs(N.getStartDate()-j)>=Math.abs(P.getStartDate()-j)){O=P;}else{O=N;}this.focusAppointment(O);}return this;};
m.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};
m.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};
m.prototype._getNonWorkingDays=function(){var N=this.getNonWorkingDays();if(!N){var j=o.call(this);var W=j.getWeekendStart();var k=j.getWeekendEnd();N=[];for(var i=0;i<=6;i++){if((W<=k&&i>=W&&i<=k)||(W>k&&(i>=W||i<=k))){N.push(i);}}}else if(!Array.isArray(N)){N=[];}return N;};
m.prototype._isOneMonthIntervalOnSmallSizes=function(){return this.getIntervalType()===h.OneMonth&&this.getIntervals()===1;};
m.prototype._getAppointmentsSorted=function(){var i=this.getAppointments(),j=M;i.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:j);return i;};
m.prototype._setCustomAppointmentsSorterCallback=function(S){this._fnCustomSortedAppointments=S;this.invalidate();};
m.prototype._calculateAppoitnmentVisualCue=function(i){if(_(this,i)){return{appTimeUnitsDifRowStart:0,appTimeUnitsDifRowEnd:0};}var j=i.getStartDate(),k=i.getEndDate(),N=new U(j.getFullYear(),j.getMonth(),j.getDate(),j.getHours(),j.getMinutes()),O=new U(k.getFullYear(),k.getMonth(),k.getDate(),k.getHours(),k.getMinutes()),P=this.getIntervalType(),T=this.getStartDate(),Q=P==="Hour"?new U(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours()):new U(T.getFullYear(),T.getMonth(),T.getDate()),S=this.getIntervals(),V;switch(P){case"Hour":V=new U(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours()+S);break;case"Day":case"Week":case"One Month":V=new U(T.getFullYear(),T.getMonth(),T.getDate()+S);break;case"Month":V=new U(T.getFullYear(),T.getMonth()+S,T.getDate());break;default:break;}return{appTimeUnitsDifRowStart:Q.getTime()-N.getTime(),appTimeUnitsDifRowEnd:O.getTime()-V.getTime()};};
m.prototype._updateSelectedAppointmentsArray=function(i){if(i.getSelected()){if(this.aSelectedAppointments.indexOf(i.getId())===-1){this.aSelectedAppointments.push(i.getId());}}else{this.aSelectedAppointments=this.aSelectedAppointments.filter(function(j){return j!==i.getId();});}};
function _(j,k){var N=j.getAggregation("groupAppointments",[]);var i;for(i=0;i<N.length;++i){if(k===N[i]){return true;}}return false;}
function n(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}
function o(){if(!this._oLocaleData){var i=n.call(this);var j=new c(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}
function p(){var S=this.getStartDate();var i;var j=this.getIntervals();var k=this.getIntervalType();this._oUTCStartDate=r.call(this,S);switch(k){case h.Hour:i=new U(this._oUTCStartDate.getTime());i.setUTCHours(i.getUTCHours()+j);this._iMinDelta=this._iHoursMinDelta;break;case h.Day:case h.Week:case h.OneMonth:i=new U(this._oUTCStartDate.getTime());i.setUTCDate(i.getUTCDate()+j);this._iMinDelta=this._iDaysMinDelta;break;case h.Month:i=new U(this._oUTCStartDate.getTime());i.setUTCMonth(i.getUTCMonth()+j);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}i.setUTCMilliseconds(-1);this._iRowSize=i.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/j);this._oUTCEndDate=i;}
function r(i){var j=this.getIntervalType();var k=a._createUniversalUTCDate(i,undefined,true);switch(j){case h.Hour:k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case h.Day:case h.Week:case h.OneMonth:k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case h.Month:k.setUTCDate(1);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+j+"; "+this);}return k;}
function s(){return D.system.phone||(this.getGroupAppointmentsMode()===G.Collapsed);}
function t(){var N=this._getAppointmentsSorted();var O;var P;var Q;var S=this.getIntervals();var T=this.getIntervalType();var V=this._getStartDate();var W=V.getTime();var X=this._oUTCEndDate;var Y=X.getTime();var Z=[];var $=false;var i=0;var j=0;var a1=s.call(this);this.destroyAggregation("groupAppointments",true);for(i=0;i<N.length;i++){O=N[i];var b1=a._createUniversalUTCDate(O.getStartDate(),undefined,true);b1.setUTCSeconds(0);b1.setUTCMilliseconds(0);var c1=O.getEndDate()?a._createUniversalUTCDate(O.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);c1.setUTCSeconds(0);c1.setUTCMilliseconds(0);var d1=false;if(b1.getTime()<W&&c1.getTime()>=W){b1=new U(W);d1=true;}if(c1.getTime()>Y&&b1.getTime()<=Y){c1=new U(Y);d1=true;}var e1=b1.getUTCHours()*60+b1.getUTCMinutes();b1.setUTCMinutes(b1.getUTCMinutes()-(e1%this._iMinDelta));var f1=(c1.getTime()-b1.getTime())/60000;if(d1&&f1==0){continue;}var g1=0;var h1=0;var i1=-1;P=undefined;Q=undefined;if(b1&&b1.getTime()<=Y&&c1&&c1.getTime()>=W){if(a1&&(T==h.Month)&&((c1.getTime()-b1.getTime())<604800000)){P=u.call(this,b1,O,T,S,V,X,W,Z);var j1=a._createUniversalUTCDate(P.getEndDate(),undefined,true);if(c1.getTime()>j1.getTime()){Q=u.call(this,c1,O,T,S,V,X,W,Z);}}g1=v.call(this,T,S,V,X,W,b1);h1=w.call(this,T,S,V,X,W,c1);if(P){P._iBegin=g1;P._iEnd=h1;P._iLevel=i1;if(Q){Q._iBegin=g1;Q._iEnd=h1;Q._iLevel=i1;}continue;}Z.push({appointment:O,begin:g1,end:h1,calculatedEnd:h1,level:i1});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==O.getId()){$=true;}}}var k1=this.getAggregation("groupAppointments",[]);if(k1.length>0){for(i=0;i<Z.length;i++){O=Z[i];if(O.appointment._aAppointments&&O.appointment._aAppointments.length<=1){P=O.appointment;var l1=false;if(P._aAppointments.length==0){l1=true;}else{for(j=0;j<Z.length;j++){if(Z[j].appointment==P._aAppointments[0]){l1=true;break;}}}if(!l1){for(j=0;j<k1.length;j++){Q=k1[j];if(P!=Q){for(var k=0;k<Q._aAppointments.length;k++){if(P._aAppointments[0]==Q._aAppointments[k]){Q._aAppointments.splice(k,1);if(Q._aAppointments.length==1){this.removeAggregation("groupAppointments",Q);Q.destroy();k1=this.getAggregation("groupAppointments",[]);}else{Q.setProperty("title",Q._aAppointments.length,true);}break;}}}}O.begin=P._iBegin;O.end=P._iEnd;O.calculatedEnd=P._iEnd;O.level=P._iLevel;O.appointment=P._aAppointments[0];}else{Z.splice(i,1);i--;}this.removeAggregation("groupAppointments",P);P.destroy();k1=this.getAggregation("groupAppointments",[]);}}}if(!$){if(Z.length>0){this._sFocusedAppointmentId=Z[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=Z;return this._aVisibleAppointments;}
function u(i,k,N,O,S,P,Q,V){var T=this.getAggregation("groupAppointments",[]);var W;var X=o.call(this);var Y=X.getFirstDayOfWeek();var Z=i.getUTCDay();var $=new U(i.getTime());$.setUTCHours(0);$.setUTCMinutes(0);$.setUTCSeconds(0);$.setUTCMilliseconds(0);if(Y<=Z){$.setDate($.getDate()-(Z-Y));}else{$.setDate($.getDate()-(7-Z-Y));}for(var j=0;j<T.length;j++){W=T[j];var a1=a._createUniversalUTCDate(W.getStartDate(),undefined,true);if(a1.getTime()==$.getTime()){break;}W=undefined;}if(!W){var b1=new U($.getTime());b1.setDate(b1.getDate()+7);b1.setMilliseconds(-1);W=new sap.ui.unified.CalendarAppointment(this.getId()+"-Group"+T.length,{type:k.getType(),startDate:a._createLocalDate(new Date($.getTime()),true),endDate:a._createLocalDate(new Date(b1.getTime()),true)});W._aAppointments=[];this.addAggregation("groupAppointments",W,true);var c1=v.call(this,N,O,S,P,Q,$);var d1=w.call(this,N,O,S,P,Q,b1);V.push({appointment:W,begin:c1,end:d1,calculatedEnd:d1,level:-1});}W._aAppointments.push(k);if(W.getType()!=f.None&&W.getType()!=k.getType()){W.setType(f.None);}W.setProperty("title",W._aAppointments.length,true);return W;}
function v(i,j,S,k,N,O){var P=0;if(i!=h.Month){P=100*(O.getTime()-N)/this._iRowSize;}else{var Q=new U(O.getTime());Q.setUTCDate(1);Q.setUTCHours(0);Q.setUTCMinutes(0);Q.setUTCSeconds(0);Q.setUTCMilliseconds(0);var T=new U(Q.getTime());T.setUTCMonth(T.getUTCMonth()+1);T.setMilliseconds(-1);var V=T.getTime()-Q.getTime();var W=(Q.getUTCFullYear()-S.getUTCFullYear())*12+Q.getUTCMonth()-S.getUTCMonth();P=(100*W/j)+(100*(O.getTime()-Q.getTime())/V)/j;}if(P<0){P=0;}P=Math.round(P*100000)/100000;return P;}
function w(i,j,S,k,N,O){var P=0;if(i!=h.Month){P=100-(100*(O.getTime()-N)/this._iRowSize);}else{var Q=new U(O.getTime());Q.setUTCDate(1);Q.setUTCHours(0);Q.setUTCMinutes(0);Q.setUTCSeconds(0);Q.setUTCMilliseconds(0);var T=new U(Q.getTime());T.setUTCMonth(T.getUTCMonth()+1);T.setMilliseconds(-1);var V=T.getTime()-Q.getTime();var W=(Q.getUTCFullYear()-S.getUTCFullYear())*12+Q.getUTCMonth()-S.getUTCMonth();P=100-((100*W/j)+(100*(O.getTime()-Q.getTime())/V)/j);}if(P<0){P=0;}P=Math.round(P*100000)/100000;return P;}
function x(){var V=[];if(this.getShowIntervalHeaders()){var k=this.getIntervalHeaders();var N;var O=this.getIntervals();var P=this.getIntervalType();var S=this._getStartDate();var Q=S.getTime();var T=this._oUTCEndDate;var W=T.getTime();var i=0;var j=0;for(i=0;i<k.length;i++){N=k[i];var X=a._createUniversalUTCDate(N.getStartDate(),undefined,true);X.setUTCSeconds(0);X.setUTCMilliseconds(0);var Y=N.getEndDate()?a._createUniversalUTCDate(N.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);Y.setUTCSeconds(0);Y.setUTCMilliseconds(0);if(X&&X.getTime()<=W&&Y&&Y.getTime()>=Q){var Z=new U(S.getTime());var $=new U(S.getTime());$.setUTCMinutes($.getUTCMinutes()-1);var a1=-1;var b1=-1;for(j=0;j<O;j++){switch(P){case h.Hour:$.setUTCHours($.getUTCHours()+1);if(j>0){Z.setUTCHours(Z.getUTCHours()+1);}break;case h.Day:case h.Week:case h.OneMonth:$.setUTCDate($.getUTCDate()+1);if(j>0){Z.setUTCDate(Z.getUTCDate()+1);}break;case h.Month:$.setUTCDate(1);$.setUTCMonth($.getUTCMonth()+2);$.setUTCDate(0);if(j>0){Z.setUTCMonth(Z.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+P+"; "+this);}if(X&&X.getTime()<=Z.getTime()&&Y&&Y.getTime()>=$.getTime()){if(a1<0){a1=j;}b1=j;}}if(a1>=0){V.push({interval:a1,appointment:N,last:b1});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}
function y(){if(this._isOneMonthIntervalOnSmallSizes()){return;}var $=this.$("Apps");var k=$.innerWidth();if(k<=0){return;}var N=this.$("DummyApp");var O=N.outerHeight(true);if(O<=0){return;}var P=N.outerWidth();var Q=P/k*100;var S=Math.ceil(1000*Q)/1000;var T;var V;var W=0;var X=0;var i=0;var Y=!D.system.phone&&this.getAppointmentsReducedHeight();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){W=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);}for(i=0;i<this._aVisibleAppointments.length;i++){T=this._aVisibleAppointments[i];V=T.appointment.$();var Z=Math.floor(1000*(100-T.calculatedEnd-T.begin))/1000;var a1=false;if(Z<S){T.end=100-T.begin-Q;if(T.end<0){T.end=0;}T.level=-1;a1=true;V.addClass("sapUiCalendarAppSmall");}else if(V.hasClass("sapUiCalendarAppSmall")){T.end=T.calculatedEnd;a1=true;V.removeClass("sapUiCalendarAppSmall");}if(a1){if(this._bRTL){V.css("left",T.end+"%");}else{V.css("right",T.end+"%");}}}for(i=0;i<this._aVisibleAppointments.length;i++){T=this._aVisibleAppointments[i];V=T.appointment.$();var b1={};var c1=Y&&!this._getAppointmentReducedHeight(T.appointment);if(T.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var d1=this._aVisibleAppointments[j];if(T!=d1&&T.begin<(Math.floor(1000*(100-d1.end))/1000)&&(Math.floor(1000*(100-T.end))/1000)>d1.begin&&d1.level>=0){if(b1[d1.level]){b1[d1.level]++;}else{b1[d1.level]=1;}if(Y&&!this._getAppointmentReducedHeight(d1.appointment)){if(b1[d1.level+1]){b1[d1.level+1]++;}else{b1[d1.level+1]=1;}}}}T.level=0;while(b1[T.level]||(c1&&b1[T.level+1])){T.level++;}V.attr("data-sap-level",T.level);}V.css("top",(O*T.level+W)+"px");var e1=T.level;if(c1){e1++;}if(X<e1){X=e1;}}X++;O=O*X+W;if(!this.getHeight()){$.outerHeight(O);}else{var f1=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<f1.length;i++){var g1=q(f1[i]);g1.outerHeight(O);}}N.css("display","none");}
function z(j,k){var i=0;var O;var N;var P;var Q;var S=I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");if(k){var T=this.getAppointments();var V=this.getAggregation("groupAppointments",[]);q.merge(T,V);for(i=0;i<T.length;i++){O=T[i];if(O.getId()!==j.getId()&&O.getSelected()){O.setProperty("selected",false,true);O.$().removeClass("sapUiCalendarAppSel");for(var i=0;i<this.aSelectedAppointments.length;i++){if(this.aSelectedAppointments[i]!==O.getId()){this.aSelectedAppointments.splice(i);}}N=O.$().attr("aria-labelledby");P=N?N.replace(S,""):"";O.$().attr("aria-labelledby",P);}}}if(j.getSelected()){j.setProperty("selected",false,true);j.$().removeClass("sapUiCalendarAppSel");B(this,k);}else{j.setProperty("selected",true,true);j.$().addClass("sapUiCalendarAppSel");B(this,k);}this._updateSelectedAppointmentsArray(j);Q=j.$().attr("aria-labelledby")+" "+S;j.$().attr("aria-labelledby",Q);if(j._aAppointments){for(i=0;i<j._aAppointments.length;i++){O=j._aAppointments[i];O.setProperty("selected",true,true);Q=O.$().attr("aria-labelledby")+" "+S;O.$().attr("aria-labelledby",Q);}this.fireSelect({appointments:j._aAppointments,multiSelect:!k,domRefId:j.getId()});}else{this.fireSelect({appointment:j,multiSelect:!k,domRefId:j.getId()});}}
function A(i){var P=this._getPlanningCalendar();if(P){P["_onRow"+i]();}}
m.prototype._getPlanningCalendar=function(){var P=this;while(P.getParent()!==null){if(P.getMetadata().getName()==="sap.m.PlanningCalendar"){return P;}P=P.getParent();}};
function B(i,j){if(j){A.call(i,"DeselectAppointment");}}
function E(k){var N=this.getAggregation("groupAppointments",[]);var O;var P=false;for(var i=0;i<N.length;i++){var Q=N[i]._aAppointments;for(var j=0;j<Q.length;j++){if(Q[j].getId()==k){O=N[i];P=true;break;}}if(P){break;}}return O;}
function F(j){if(this._sFocusedAppointmentId!=j){var k=this._getAppointmentsSorted();var V=this._aVisibleAppointments;var N;var i=0;N=E.call(this,j);if(N){j=N.getId();N=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==j){N=V[i].appointment;break;}}if(N){var O=this.getFocusedAppointment().$();var $=N.$();this._sFocusedAppointmentId=N.getId();O.attr("tabindex","-1");$.attr("tabindex","0");$.focus();}else{for(i=0;i<k.length;i++){if(k[i].getId()==j){N=k[i];break;}}if(N){this._sFocusedAppointmentId=N.getId();var P=r.call(this,N.getStartDate());this.setStartDate(a._createLocalDate(P,true));if(!e(this.getDomRef(),document.activeElement)){setTimeout(function(){this.getFocusedAppointment().focus();}.bind(this),0);}this.fireStartDateChange();}}}}
function H(j,S){var k=this._sFocusedAppointmentId;var N=this._getAppointmentsSorted();var O=this.getAggregation("groupAppointments",[]);var P;var Q=0;var i=0;for(i=0;i<O.length;i++){if(O[i].getId()==k){var T=O[i]._aAppointments;if(j){k=T[T.length-1].getId();}else{k=T[0].getId();}break;}}for(i=0;i<N.length;i++){if(N[i].getId()==k){Q=i;break;}}if(j){Q=Q+S;}else{Q=Q-S;}if(Q<0){Q=0;}else if(Q>=N.length){Q=N.length-1;}P=N[Q];F.call(this,P.getId());}
function J(j){var k=this._getAppointmentsSorted();var N;var S=new U(this._getStartDate());var O=new U(this._oUTCEndDate);var P=this.getIntervalType();var Q;var T;S.setUTCHours(0);O.setUTCHours(0);O.setUTCMinutes(0);O.setUTCSeconds(0);switch(P){case h.Hour:O.setUTCDate(O.getUTCDate()+1);O.setUTCMilliseconds(-1);break;case h.Day:case h.Week:case h.OneMonth:S.setUTCDate(1);O.setUTCMonth(O.getUTCMonth()+1);O.setUTCDate(1);O.setUTCMilliseconds(-1);break;case h.Month:S.setUTCMonth(0);S.setUTCDate(1);O.setUTCFullYear(O.getUTCFullYear()+1);O.setUTCMonth(1);O.setUTCDate(1);O.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+P+"; "+this);}var V=a._createLocalDate(S,true);var W=a._createLocalDate(O,true);for(var i=0;i<k.length;i++){if(k[i].getStartDate()>=V&&k[i].getStartDate()<=W){N=k[i];Q=N.getId();if(j.type=="saphome"){break;}}else if(k[i].getStartDate()>W){break;}}T=E.call(this,Q);if(T){N=T;Q=N.getId();}if(Q&&Q!=this._sFocusedAppointmentId){F.call(this,Q);}else if(j._bPlanningCalendar&&N){N.focus();}else{this.fireLeaveRow({type:j.type});}}
function K(i,j){var k=this.getIntervalType();var S=this._getStartDate();var N=new U(S.getTime());var O;var P=false;var Q=0;var T=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){P=true;var V=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");T=V.length;for(Q=0;Q<T;Q++){var W=V[Q];if(W==j){break;}}}switch(k){case h.Hour:N.setUTCHours(N.getUTCHours()+i);if(P){N.setUTCMinutes(N.getUTCMinutes()+Q*60/T);O=new U(N.getTime());O.setUTCMinutes(O.getUTCMinutes()+60/T);}else{O=new U(N.getTime());O.setUTCHours(O.getUTCHours()+1);}break;case h.Day:case h.Week:case h.OneMonth:N.setUTCDate(N.getUTCDate()+i);if(P){N.setUTCHours(N.getUTCHours()+Q*24/T);O=new U(N.getTime());O.setUTCHours(O.getUTCHours()+24/T);}else{O=new U(N.getTime());O.setUTCDate(O.getUTCDate()+1);}break;case h.Month:N.setUTCMonth(N.getUTCMonth()+i);if(P){N.setUTCDate(N.getUTCDate()+Q);O=new U(N.getTime());O.setUTCDate(O.getUTCDate()+1);}else{O=new U(N.getTime());O.setUTCMonth(O.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}O.setUTCMilliseconds(O.getUTCMilliseconds()-1);N=a._createLocalDate(N,true);O=a._createLocalDate(O,true);this.fireIntervalSelect({startDate:N,endDate:O,subInterval:P});}
function M(i,j){var k=i.getStartDate()-j.getStartDate();if(k==0){k=j.getEndDate()-i.getEndDate();}return k;}
return m;});
sap.ui.predefine('sap/ui/unified/CalendarRowRenderer',['sap/ui/core/date/UniversalDate','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarLegendRenderer','sap/ui/Device','sap/ui/unified/library','sap/ui/core/InvisibleText',"sap/base/Log"],function(U,C,a,D,l,I,L){"use strict";var b=l.CalendarDayType;var c=l.CalendarIntervalType;var d=l.CalendarAppointmentVisualization;var e={};
e.render=function(r,R){var t=R.getTooltip_AsString();var v=R.getAppointmentsVisualization();var T=this.getLegendItems(R);r.write("<div");r.writeControlData(R);r.addClass("sapUiCalendarRow");if(!D.system.phone&&R.getAppointmentsReducedHeight()){r.addClass("sapUiCalendarRowAppsRedHeight");}if(v!=d.Standard){r.addClass("sapUiCalendarRowVis"+v);}if(t){r.writeAttributeEscaped("title",t);}var w=R.getWidth();if(w){r.addStyle("width",w);}var h=R.getHeight();if(h){r.addStyle("height",h);}r.writeAccessibilityState(R);r.writeClasses();r.writeStyles();r.write(">");this.renderAppointmentsRow(r,R,T);r.write("</div>");};
e.renderAppointmentsRow=function(r,R,t){var i=R.getId();r.write("<div id=\""+i+"-Apps\" class=\"sapUiCalendarRowApps\">");this.renderBeforeAppointments(r,R);this.renderAppointments(r,R,t);this.renderAfterAppointments(r,R);r.write("</div>");};
e.renderBeforeAppointments=function(r,R){};
e.renderAfterAppointments=function(r,R){};
e.renderResizeHandle=function(r,R,A){};
e.renderAppointments=function(r,R,t){var A=R._getVisibleAppointments();var f=R._getVisibleIntervalHeaders();var s=R._getStartDate();var n=[];var S=0;var N=0;var g=[];var h=0;var j=0;var k=R.getIntervals();var m=R.getIntervalType();var w=100/k;var i=0;var o=new U(s);var F=false;var p=false;switch(m){case c.Hour:n=R.getNonWorkingHours()||[];S=s.getUTCHours();N=24;break;case c.Day:case c.Week:case c.OneMonth:n=R._getNonWorkingDays();S=s.getUTCDay();N=7;g=R.getNonWorkingHours()||[];h=s.getUTCHours();j=24;break;case c.Month:g=R._getNonWorkingDays();h=s.getUTCDay();j=7;break;default:break;}if(R._isOneMonthIntervalOnSmallSizes()){this.renderSingleDayInterval(r,R,A,t,f,n,S,N,g,h,j,true,true);}else{for(i=0;i<k;i++){if(p){F=true;}else{F=false;}p=false;switch(m){case c.Hour:o.setUTCHours(o.getUTCHours()+1);if(o.getUTCHours()==0){p=true;}break;case c.Day:case c.Week:case c.OneMonth:o.setUTCDate(o.getUTCDate()+1);if(o.getUTCDate()==1){p=true;}break;case c.Month:o.setUTCMonth(o.getUTCMonth()+1);if(o.getUTCMonth()==0){p=true;}break;default:break;}this.renderInterval(r,R,i,w,f,n,S,N,g,h,j,F,p);}this.renderIntervalHeaders(r,R,w,f,k);r.write("<div id=\""+R.getId()+"-Now\" class=\"sapUiCalendarRowNow\"></div>");for(i=0;i<A.length;i++){var q=A[i];this.renderAppointment(r,R,q,t);}r.write("<div id=\""+R.getId()+"-DummyApp\" class=\"sapUiCalendarApp sapUiCalendarAppTitleOnly sapUiCalendarAppDummy\"></div>");}};
e.writeCustomAttributes=function(r,R){};
e.renderInterval=function(r,R,f,w,g,n,s,N,h,S,k,F,m){var o=R.getId()+"-AppsInt"+f;var i;var p=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||g.length>0);var M=R.getStartDate().getMonth();var q=new Date(R.getStartDate().getFullYear(),M+1,0).getDate();r.write("<div id=\""+o+"\"");r.addClass("sapUiCalendarRowAppsInt");r.addStyle("width",w+"%");if(f>=q&&R.getIntervalType()===c.OneMonth){r.addClass("sapUiCalItemOtherMonth");}for(i=0;i<n.length;i++){if((f+s)%N==n[i]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}if(!p){r.addClass("sapUiCalendarRowAppsIntNoHead");}if(F){r.addClass("sapUiCalendarRowAppsIntFirst");}if(m){r.addClass("sapUiCalendarRowAppsIntLast");}r.writeClasses();r.writeStyles();this.writeCustomAttributes(r,R);r.write(">");if(p){r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");r.writeClasses();r.write(">");r.write("</div>");}if(R.getShowSubIntervals()){var t=R.getIntervalType();var u=0;switch(t){case c.Hour:u=4;break;case c.Day:case c.Week:case c.OneMonth:u=24;break;case c.Month:var v=R._getStartDate();var x=new U(v);x.setUTCMonth(x.getUTCMonth()+f+1,0);u=x.getUTCDate();x.setUTCDate(1);s=x.getUTCDay();break;default:break;}var y=100/u;for(i=0;i<u;i++){r.write("<div");r.addClass("sapUiCalendarRowAppsSubInt");r.addStyle("width",y+"%");for(var j=0;j<h.length;j++){if((i+S)%k==h[j]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}r.writeStyles();r.writeClasses();r.write(">");r.write("</div>");}}r.write("</div>");};
e.renderIntervalHeaders=function(r,R,w,f,g){var s=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||f.length>0);if(s){for(var i=0;i<f.length;i++){var o=f[i],h,j;if(R._bRTL){j=w*o.interval;h=w*(g-o.last-1);}else{h=w*o.interval;j=w*(g-o.last-1);}this.renderIntervalHeader(r,R,o,R._bRTL,h,j);}}};
e.renderIntervalHeader=function(r,R,i,f,g,h){var s=i.appointment.getId();var A=R._calculateAppoitnmentVisualCue(i.appointment);r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");if(g!==undefined){r.addStyle("left",g+"%");}if(h!==undefined){r.addStyle("right",h+"%");}r.writeElementData(i.appointment);r.addClass("sapUiCalendarRowAppsIntHeadFirst");if(i.appointment.getSelected()){r.addClass("sapUiCalendarRowAppsIntHeadSel");}if(i.appointment.getTentative()){r.addClass("sapUiCalendarRowAppsIntHeadTent");}var t=i.appointment.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}var T=i.appointment.getType();var j=i.appointment.getColor();if(!j&&T&&T!=b.None){r.addClass("sapUiCalendarRowAppsIntHead"+T);}if(j){if(f){r.addStyle("border-right-color",j);}else{r.addStyle("border-left-color",j);}}r.writeStyles();r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiCalendarIntervalHeaderCont");r.writeClasses();if(j){r.addStyle("background-color",i.appointment._getCSSColorForBackground(j));r.writeStyles();}r.write(">");if(A.appTimeUnitsDifRowStart>0){r.writeIcon("sap-icon://arrow-left",["sapUiCalendarAppArrowIconLeft"],{title:null});}var k=i.appointment.getIcon();if(k){var m=["sapUiCalendarRowAppsIntHeadIcon"];var n={};n["id"]=s+"-Icon";n["title"]=null;r.writeIcon(k,m,n);}var o=i.appointment.getTitle();if(o){r.write("<span");r.writeAttribute("id",s+"-Title");r.addClass("sapUiCalendarRowAppsIntHeadTitle");r.writeClasses();r.write(">");r.writeEscaped(o,true);r.write("</span>");}var p=i.appointment.getText();if(p){r.write("<span");r.writeAttribute("id",s+"-Text");r.addClass("sapUiCalendarRowAppsIntHeadText");r.writeClasses();r.write(">");r.writeEscaped(p,true);r.write("</span>");}if(A.appTimeUnitsDifRowEnd>0){r.writeIcon("sap-icon://arrow-right",["sapUiCalendarAppArrowIconRight"],{title:null});}r.write("</div>");r.write("</div>");};
e.renderAppointment=function(r,R,A,t,f){var o=A.appointment;var T=o.getTooltip_AsString();var s=o.getType();var g=o.getColor();var h=o.getTitle();var i=o.getText();var j=o.getIcon();var k=o.getId();var m={labelledby:{value:I.getStaticId("sap.ui.unified","APPOINTMENT")+" "+k+"-Descr",append:true}};var n=R.getAriaLabelledBy();var p=R._calculateAppoitnmentVisualCue(o);if(n.length>0){m["labelledby"].value=m["labelledby"].value+" "+n.join(" ");}if(h){m["labelledby"].value=m["labelledby"].value+" "+k+"-Title";}if(i){m["labelledby"].value=m["labelledby"].value+" "+k+"-Text";}r.write("<div");r.writeElementData(o);r.addClass("sapUiCalendarApp");if(o.getSelected()){r.addClass("sapUiCalendarAppSel");m["labelledby"].value=m["labelledby"].value+" "+I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");}if(o.getTentative()){r.addClass("sapUiCalendarAppTent");m["labelledby"].value=m["labelledby"].value+" "+I.getStaticId("sap.ui.unified","APPOINTMENT_TENTATIVE");}if(!i){r.addClass("sapUiCalendarAppTitleOnly");}if(j){r.addClass("sapUiCalendarAppWithIcon");}if(!f){if(R._bRTL){r.addStyle("right",A.begin+"%");r.addStyle("left",A.end+"%");}else{r.addStyle("left",A.begin+"%");r.addStyle("right",A.end+"%");}}r.writeAttribute("data-sap-level",A.level);if(R._sFocusedAppointmentId==k){r.writeAttribute("tabindex","0");}else{r.writeAttribute("tabindex","-1");}if(T){r.writeAttributeEscaped("title",T);}if(!g&&s&&s!=b.None){r.addClass("sapUiCalendarApp"+s);}if(g){if(R._bRTL){r.addStyle("border-right-color",g);}else{r.addStyle("border-left-color",g);}}r.writeAccessibilityState(o,m);r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapUiCalendarAppCont");if(g&&R.getAppointmentsVisualization()===d.Filled){r.addStyle("background-color",o._getCSSColorForBackground(g));r.writeStyles();}r.writeClasses();r.write(">");if(p.appTimeUnitsDifRowStart>0){r.writeIcon("sap-icon://arrow-left",["sapUiCalendarAppArrowIconLeft"],{title:null});}if(j){var q=["sapUiCalendarAppIcon"];var u={};u["id"]=k+"-Icon";u["title"]=null;r.writeIcon(j,q,u);}r.write("<div");r.addClass("sapUiCalendarAppTitleWrapper");r.writeClasses();r.write(">");if(h){r.write("<span");r.writeAttribute("id",k+"-Title");r.addClass("sapUiCalendarAppTitle");r.writeClasses();r.write(">");r.writeEscaped(h,true);r.write("</span>");}if(i){r.write("<span");r.writeAttribute("id",k+"-Text");r.addClass("sapUiCalendarAppText");r.writeClasses();r.write(">");r.writeEscaped(i,true);r.write("</span>");}r.write("</div>");if(p.appTimeUnitsDifRowEnd>0){r.writeIcon("sap-icon://arrow-right",["sapUiCalendarAppArrowIconRight"],{title:null});}var v=R._oRb.getText("CALENDAR_START_TIME")+": "+R._oFormatAria.format(o.getStartDate());v=v+"; "+R._oRb.getText("CALENDAR_END_TIME")+": "+R._oFormatAria.format(o.getEndDate());if(s&&s!=b.None){v=v+"; "+this.getAriaTextForType(s,t);}r.write("<span id=\""+k+"-Descr\" class=\"sapUiInvisibleText\">"+v+"</span>");r.write("</div>");this.renderResizeHandle(r,R,o);r.write("</div>");};
e.renderSingleDayInterval=function(r,R,A,t,f,n,s,N,g,S,h,F,k){var m=1,w=100,o=R.getId()+"-AppsInt"+m,i,p=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||f.length>0),q=R.getStartDate(),M=q.getMonth(),u=new Date(q.getFullYear(),M+1,0).getDate(),v,P=R._getPlanningCalendar(),x=A.concat(R.getIntervalHeaders().filter(function(J){var K=J.getStartDate().getTime(),O=J.getEndDate().getTime(),Q=q.getTime(),T=Q+1000*60*60*24;return!(K>=T||O<=Q);}).map(function(J){return{appointment:J,isHeader:true};})).sort(C._getComparer(q)),y,z=[];if(P){z=P._getSelectedDates();}r.write("<div id=\""+o+"\"");r.addClass("sapUiCalendarRowAppsInt");r.addClass("sapUiCalendarMonthRowAppsS");r.addStyle("width",w+"%");if(m>=u&&R.getIntervalType()===c.OneMonth){r.addClass("sapUiCalItemOtherMonth");}for(i=0;i<n.length;i++){if((m+s)%N==n[i]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}if(!p){r.addClass("sapUiCalendarRowAppsIntNoHead");}if(F){r.addClass("sapUiCalendarRowAppsIntFirst");}if(k){r.addClass("sapUiCalendarRowAppsIntLast");}r.writeClasses();r.writeStyles();r.write(">");if(p){r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");r.writeClasses();r.write(">");r.write("</div>");}if(z.length>0){for(i=0;i<x.length;i++){y=x[i];r.write("<div class=\"sapUiCalendarAppContainer\">");r.write("<div class=\"sapUiCalendarAppContainerLeft\">");r.write("<div>"+y.appointment._getDateRangeIntersectionText(q)+"</div>");r.write("</div>");r.write("<div class=\"sapUiCalendarAppContainerRight\">");if(y.isHeader){this.renderIntervalHeader(r,R,y);}else{this.renderAppointment(r,R,y,t,true);}r.write("</div>");r.write("</div>");}}if(A.length===0||z.length===0){r.write("<div class=\"sapUiCalendarNoApps\">");v=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PLANNINGCALENDAR_ROW_NO_APPOINTMENTS");r.write(v);r.write("</div>");}r.write("<div id=\""+R.getId()+"-Now\" class=\"sapUiCalendarRowNow\"></div>");r.write("<div id=\""+R.getId()+"-DummyApp\" class=\"sapUiCalendarApp sapUiCalendarAppTitleOnly sapUiCalendarAppDummy\" style='margin:0; height:0px;'></div>");if(R.getShowSubIntervals()){var B=R.getIntervalType();var E=0;switch(B){case c.Hour:E=4;break;case c.Day:case c.Week:case c.OneMonth:E=24;break;case c.Month:var G=new U(q);G.setUTCMonth(G.getUTCMonth()+m+1,0);E=G.getUTCDate();G.setUTCDate(1);s=G.getUTCDay();break;default:break;}var H=100/E;for(i=0;i<E;i++){r.write("<div");r.addClass("sapUiCalendarRowAppsSubInt");r.addStyle("width",H+"%");for(var j=0;j<g.length;j++){if((i+S)%h==g[j]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}r.writeStyles();r.writeClasses();r.write(">");r.write("</div>");}}r.write("</div>");};
e.getLegendItems=function(o){var r=[],f,s=o.getLegend();if(s){f=sap.ui.getCore().byId(s);if(f){r=f.getItems();}else{L.error("CalendarLegend with id '"+s+"' does not exist!",o);}}return r;};
e.getAriaTextForType=function(t,f){var T,s,o,i;if(f&&f.length){for(var i=0;i<f.length;i++){o=f[i];if(o.getType()===t){T=o.getText();break;}}}if(!T){s=a.getTypeAriaText(t);if(s){T=s.getText();}}return T;};
return e;},true);
sap.ui.predefine('sap/ui/unified/CalendarTimeInterval',['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/TimesRow','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library','sap/ui/core/format/DateFormat','sap/ui/Device','sap/ui/core/Locale','sap/ui/core/library',"./CalendarTimeIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,H,T,D,M,Y,U,l,b,c,d,e,f,g,h,P,i,q){"use strict";
var j=C.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
j.prototype.init=function(){this._iMode=0;this._oYearFormat=b.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new U(new Date(Date.UTC(9999,11,31,23,59,59)));this._initializeHeader();this._initializeTimesRow();this._initilizeMonthPicker();this._initilizeYearPicker();this.setPickerPopup(false);this._iItemsHead=15;};
j.prototype._initializeHeader=function(){var c1=new H(this.getId()+"--Head");c1.attachEvent("pressPrevious",this._handlePrevious,this);c1.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",c1);};
j.prototype._initializeTimesRow=function(){var c1=new T(this.getId()+"--TimesRow");c1.attachEvent("focus",J,this);c1.attachEvent("select",I,this);c1._bNoThemeChange=true;this.setAggregation("timesRow",c1);};
j.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};
j.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};
j.prototype._createDatesRow=function(){var c1=new D(this.getId()+"--DatesRow",{days:18,selectedDates:[new sap.ui.unified.DateRange(this.getId()+"--Range")]});c1.attachEvent("focus",O,this);c1.attachEvent("select",N,this);c1._bNoThemeChange=true;c1.getIntervalSelection=function(){return this.getProperty("intervalSelection");};c1.getSingleSelection=function(){return this.getProperty("singleSelection");};c1.getSelectedDates=function(){return this.getAggregation("selectedDates",[]);};c1.getSpecialDates=function(){return this.getAggregation("specialDates",[]);};c1.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[]);};return c1;};
j.prototype._createMonthPicker=function(){var c1=new M(this.getId()+"--MP",{columns:0,months:6});c1.attachEvent("select",Q,this);c1._bNoThemeChange=true;c1.attachEvent("pageChange",a1,this);return c1;};
j.prototype._createYearPicker=function(){var c1=new Y(this.getId()+"--YP",{columns:0,years:6});c1.attachEvent("select",R,this);c1.attachEvent("pageChange",b1,this);c1._oMinDate.setYear(this._oMinDate.getUTCFullYear());c1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return c1;};
j.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};
j.prototype.onBeforeRendering=function(){var c1=this.getAggregation("timesRow");var d1=this._getFocusedDate();w.call(this);c1.displayDate(a._createLocalDate(d1,true));};
j.prototype._setAriaRole=function(c1){var d1=this.getAggregation("timesRow");d1._setAriaRole(c1);d1.invalidate();return this;};
j.prototype._getCalendarPicker=function(){var c1=this.getAggregation("calendarPicker");if(!c1){c1=new sap.ui.unified.Calendar(this.getId()+"--Cal",{});c1.setPopupMode(true);c1.attachEvent("select",K,this);c1.attachEvent("cancel",function(d1){this._oPopup.close();var e1=this.getAggregation("header").getDomRef("B1");if(e1){e1.focus();}},this);this.setAggregation("calendarPicker",c1);}return c1;};
j.prototype.setStartDate=function(c1){a._checkJSDateObject(c1);if(h(this.getStartDate(),c1)){return this;}var d1=c1.getFullYear();a._checkYearInValidRange(d1);var e1=this.getMinDate();if(e1&&c1.getTime()<e1.getTime()){i.warning("startDate < minDate -> minDate as startDate set",this);c1=new Date(e1);}var f1=this.getMaxDate();if(f1&&c1.getTime()>f1.getTime()){i.warning("startDate > maxDate -> maxDate as startDate set",this);c1=new Date(f1);}this.setProperty("startDate",c1,true);var g1=this.getAggregation("timesRow");g1.setStartDate(c1);this._oUTCStartDate=new U(g1._getStartDate().getTime());w.call(this);var h1=a._createLocalDate(this._getFocusedDate(),true);if(!g1.checkDateFocusable(h1)){this._setFocusedDate(this._oUTCStartDate);g1.displayDate(c1);}return this;};
j.prototype.invalidate=function(c1){if(!this._bDateRangeChanged&&(!c1||!(c1 instanceof sap.ui.unified.DateRange))){if(!c1||(!(c1 instanceof D||c1 instanceof M||c1 instanceof Y||c1 instanceof H))){C.prototype.invalidate.apply(this,arguments);}}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(S.bind(this),0);}};
j.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var c1=this.removeAllAggregation("selectedDates");return c1;};
j.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var c1=this.destroyAggregation("selectedDates");return c1;};
j.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var c1=this.removeAllAggregation("specialDates");return c1;};
j.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var c1=this.destroyAggregation("specialDates");return c1;};
j.prototype.setIntervalMinutes=function(c1){if(c1>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%c1>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",c1,false);var d1=this.getAggregation("timesRow");var e1=a._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(e1)){var f1=k.call(this);this._setFocusedDate(f1);d1.setDate(a._createLocalDate(f1,true));}return this;};
j.prototype.setLocale=function(c1){if(this._sLocale!=c1){this._sLocale=c1;this._oLocaleData=undefined;this.invalidate();}return this;};
j.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
j.prototype._getFocusedDate=function(){if(!this._oFocusedDate){n.call(this);}return this._oFocusedDate;};
j.prototype._setFocusedDate=function(c1){if(!(c1 instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(c1.getTime());};
j.prototype.focusDate=function(c1){var d1=false;var e1=this.getAggregation("timesRow");if(!e1.checkDateFocusable(c1)){var f1=a._createUniversalUTCDate(c1,undefined,true);V.call(this,f1);d1=true;}B.call(this,c1,false);if(d1){this.fireStartDateChange();}return this;};
j.prototype.displayDate=function(c1){B.call(this,c1,true);return this;};
j.prototype.setItems=function(c1){this.setProperty("items",c1,true);c1=this._getItems();var d1=this.getAggregation("timesRow");d1.setItems(c1);var e1=a._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(e1)){var f1=k.call(this);this._setFocusedDate(f1);d1.setDate(a._createLocalDate(f1,true));}if(!this.getPickerPopup()){var g1=this.getAggregation("datesRow");var h1=Math.floor(c1*1.5);if(h1>31){h1=31;}g1.setDays(h1);var i1=this.getAggregation("monthPicker");var j1=Math.floor(c1/2);if(j1>12){j1=12;}i1.setMonths(j1);var k1=this.getAggregation("yearPicker");var l1=Math.floor(c1/2);if(l1>20){l1=20;}k1.setYears(l1);}w.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
j.prototype._getItems=function(){var c1=this.getItems();if(c.system.phone&&c1>6){return 6;}else{return c1;}};
j.prototype._getLocaleData=function(){if(!this._oLocaleData){var c1=this.getLocale();var d1=new d(c1);this._oLocaleData=L.getInstance(d1);}return this._oLocaleData;};
j.prototype.setPickerPopup=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;this.setProperty("pickerPopup",c1,true);if(e1){e1.destroy();}if(c1){d1.setVisibleButton0(false);d1.setVisibleButton1(true);d1.setVisibleButton2(false);d1.detachEvent("pressButton1",F,this);d1.attachEvent("pressButton1",F,this);if(this.getAggregation("datesRow")){this.getAggregation("datesRow").destroy();}if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{d1.setVisibleButton0(true);d1.setVisibleButton1(true);d1.setVisibleButton2(true);d1.detachEvent("pressButton0",E,this);d1.attachEvent("pressButton0",E,this);d1.detachEvent("pressButton1",F,this);d1.attachEvent("pressButton1",F,this);d1.detachEvent("pressButton2",G,this);d1.attachEvent("pressButton2",G,this);if(!this.getAggregation("datesRow")){this.setAggregation("datesRow",this._createDatesRow());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}f1=this.getAggregation("monthPicker");g1=this.getAggregation("yearPicker");f1.setColumns(0);f1.setMonths(6);g1.setColumns(0);g1.setYears(6);}return this;};
j.prototype.setMinDate=function(c1){var d1,e1,f1,g1;if(h(c1,this.getMinDate())){return this;}if(!c1){a._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0);}else{a._checkJSDateObject(c1);this._oMinDate=a._createUniversalUTCDate(c1,undefined,true);d1=this.getAggregation("timesRow");this._oMinDate=d1._getIntervalStart(this._oMinDate);e1=this._oMinDate.getUTCFullYear();a._checkYearInValidRange(e1);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){i.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=a._createUniversalUTCDate(c1,undefined,true);a._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",a._createLocalDate(this._oMaxDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){i.warning("focused date < minDate -> minDate focused",this);this.focusDate(c1);}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){i.warning("start date < minDate -> minDate set as start date",this);_.call(this,new U(this._oMinDate.getTime()),true,true);}}this.setProperty("minDate",c1,false);if(this.getPickerPopup()){g1=this._getCalendarPicker();g1.setMinDate(c1);}else{f1=this.getAggregation("yearPicker");f1._oMinDate.setYear(this._oMinDate.getUTCFullYear());}return this;};
j.prototype.setMaxDate=function(c1){var d1,e1,f1,g1,h1,i1;if(h(c1,this.getMaxDate())){return this;}if(!c1){a._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0);}else{a._checkJSDateObject(c1);this._oMaxDate=a._createUniversalUTCDate(c1,undefined,true);d1=this.getAggregation("timesRow");this._oMaxDate=d1._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);e1=this._oMaxDate.getUTCFullYear();a._checkYearInValidRange(e1);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){i.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=a._createUniversalUTCDate(c1,undefined,true);a._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",a._createLocalDate(this._oMinDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){i.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(c1);}}if(this._oUTCStartDate){f1=new U(this._oUTCStartDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(f1.getTime()>this._oMaxDate.getTime()){g1=new U(this._oMaxDate.getTime());g1.setUTCMinutes(g1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(g1.getTime()>=this._oMinDate.getTime()){i.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,g1,true,true);}}}}this.setProperty("maxDate",c1,false);if(this.getPickerPopup()){i1=this._getCalendarPicker();i1.setMaxDate(c1);}else{h1=this.getAggregation("yearPicker");h1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());}return this;};
j.prototype.onclick=function(c1){if(c1.isMarked("delayedMouseEvent")){return;}if(c1.target.id==this.getId()+"-cancel"){this.onsapescape(c1);}};
j.prototype.onmousedown=function(c1){c1.preventDefault();c1.setMark("cancelAutoClose");};
j.prototype.onsapescape=function(c1){if(this.getPickerPopup()){o.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:r.call(this);break;case 2:t.call(this);break;case 3:v.call(this);break;}}};
j.prototype.onsaptabnext=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;if(g(this.getDomRef("content"),c1.target)){if(this.getPickerPopup()&&d1.getDomRef("B1")){d1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&d1.getDomRef("B0")){d1.getDomRef("B0").focus();}if(!this._bPoupupMode){g1=this.getAggregation("timesRow");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){e1=this.getAggregation("monthPicker");f1=this.getAggregation("yearPicker");if(e1.getDomRef()){q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(f1.getDomRef()){q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B0"){if(d1.getDomRef("B1")){d1.getDomRef("B1").focus();}c1.preventDefault();}else if(!this.getPickerPopup()&&(c1.target.id==d1.getId()+"-B1")){if(d1.getDomRef("B2")){d1.getDomRef("B2").focus();}c1.preventDefault();}};
j.prototype.onsaptabprevious=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;if(g(this.getDomRef("content"),c1.target)){if(this._bPoupupMode){if(d1.getDomRef("B2")){d1.getDomRef("B2").focus();}c1.preventDefault();}}else if(c1.target.id==d1.getId()+"-B0"){g1=this.getAggregation("timesRow");switch(this._iMode){case 0:g1._oItemNavigation.focusItem(g1._oItemNavigation.getFocusedIndex());break;case 2:if(!this.getPickerPopup()){e1=this.getAggregation("monthPicker");e1._oItemNavigation.focusItem(e1._oItemNavigation.getFocusedIndex());}break;case 3:if(!this.getPickerPopup()){f1=this.getAggregation("yearPicker");f1._oItemNavigation.focusItem(f1._oItemNavigation.getFocusedIndex());}break;}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B2"){if(d1.getDomRef("B1")){d1.getDomRef("B1").focus();}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B1"){if(!this.getPickerPopup()){if(d1.getDomRef("B0")){d1.getDomRef("B0").focus();}}else{g1=this.getAggregation("timesRow");g1._oItemNavigation.focusItem(g1._oItemNavigation.getFocusedIndex());}c1.preventDefault();}};
j.prototype.onfocusin=function(c1){if(c1.target.id==this.getId()+"-end"){var d1=this.getAggregation("header"),e1,f1,g1;if(this.getPickerPopup()&&d1.getDomRef("B1")){d1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&d1.getDomRef("B2")){d1.getDomRef("B2").focus();}if(!this._bPoupupMode){e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){f1=this.getAggregation("monthPicker");g1=this.getAggregation("yearPicker");if(f1.getDomRef()){q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(g1.getDomRef()){q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};
j.prototype.onsapfocusleave=function(c1){if(!c1.relatedControlId||!g(this.getDomRef(),sap.ui.getCore().byId(c1.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var d1,e1,f1;switch(this._iMode){case 0:d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:if(!this.getPickerPopup()){e1=this.getAggregation("monthPicker");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 3:if(!this.getPickerPopup()){f1=this.getAggregation("yearPicker");q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};
j.prototype._handlePrevious=function(c1){var d1=this._getFocusedDate(),e1,f1,g1,h1,i1,j1,k1,l1;switch(this._iMode){case 0:e1=this._getItems();f1=new U(k.call(this).getTime());g1=this.getIntervalMinutes();f1.setUTCMinutes(f1.getUTCMinutes()-e1*g1);d1.setUTCMinutes(d1.getUTCMinutes()-e1*g1);this._setFocusedDate(d1);_.call(this,f1,true);break;case 1:if(!this.getPickerPopup()){h1=this.getAggregation("datesRow");i1=a._createUniversalUTCDate(h1.getDate());j1=h1.getDays();if(i1.getUTCDate()<=j1){i1.setUTCDate(1);}else{i1.setUTCDate(i1.getUTCDate()-j1);}W.call(this,i1);}break;case 2:if(!this.getPickerPopup()){k1=this.getAggregation("monthPicker");if(k1.getMonths()<12){k1.previousPage();x.call(this);}else{d1.setUTCFullYear(d1.getUTCFullYear()-1);V.call(this,d1);this._setFocusedDate(d1);w.call(this);$.call(this,d1.getUTCFullYear(),k1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){l1=this.getAggregation("yearPicker");l1.previousPage();y.call(this);}break;}};
j.prototype._handleNext=function(c1){var d1=this._getFocusedDate();switch(this._iMode){case 0:var e1=this._getItems();var f1=new U(k.call(this).getTime());var g1=this.getIntervalMinutes();f1.setUTCMinutes(f1.getUTCMinutes()+e1*g1);d1.setUTCMinutes(d1.getUTCMinutes()+e1*g1);this._setFocusedDate(d1);_.call(this,f1,true);break;case 1:if(!this.getPickerPopup()){var h1=this.getAggregation("datesRow");var i1=a._createUniversalUTCDate(h1.getDate());var j1=new U(i1.getTime());j1.setUTCDate(1);j1.setUTCMonth(j1.getUTCMonth()+1);j1.setUTCDate(0);var k1=h1.getDays();if(i1.getUTCDate()+k1>j1.getUTCDate()){i1.setUTCDate(j1.getUTCDate());}else{i1.setUTCDate(i1.getUTCDate()+k1);}W.call(this,i1);}break;case 2:if(!this.getPickerPopup()){var l1=this.getAggregation("monthPicker");if(l1.getMonths()<12){l1.nextPage();x.call(this);}else{d1.setUTCFullYear(d1.getUTCFullYear()+1);V.call(this,d1);this._setFocusedDate(d1);w.call(this);$.call(this,d1.getUTCFullYear(),l1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){var m1=this.getAggregation("yearPicker");m1.nextPage();y.call(this);}break;}};
j.prototype._getShowItemHeader=function(){var c1=this.getItems();if(c1>this._iItemsHead){return true;}else{return false;}};
function _(c1,d1,e1){var f1=new U(this._oMaxDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(f1.getTime()<this._oMinDate.getTime()){f1=new U(this._oMinDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));}if(c1.getTime()<this._oMinDate.getTime()){c1=new U(this._oMinDate.getTime());}else if(c1.getTime()>f1.getTime()){c1=f1;}var g1=this.getAggregation("timesRow");var h1=a._createLocalDate(c1,true);g1.setStartDate(h1);this._oUTCStartDate=new U(g1._getStartDate().getTime());h1=a._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",h1,true);w.call(this);if(d1){var i1=a._createLocalDate(this._getFocusedDate(),true);if(!g1.checkDateFocusable(i1)){this._setFocusedDate(c1);g1.setDate(h1);}else{g1.setDate(i1);}}if(!e1){this.fireStartDateChange();}}
function k(){if(!this._oUTCStartDate){var c1=this.getAggregation("timesRow");c1.setStartDate(a._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new U(c1._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate);}return this._oUTCStartDate;}
function m(c1){var d1=this._getFocusedDate();var e1=this.getAggregation("timesRow");if(!c1){e1.setDate(a._createLocalDate(d1,true));}else{e1.displayDate(a._createLocalDate(d1,true));}w.call(this);}
function n(){var c1=this.getSelectedDates();if(c1&&c1[0]&&c1[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(c1[0].getStartDate(),undefined,true);}else{var d1=new Date();this._oFocusedDate=a._createUniversalUTCDate(d1,undefined,true);}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new U(this._oMinDate.getTime());}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new U(this._oMaxDate.getTime());}}
j.prototype._showCalendarPicker=function(){var c1=a._createLocalDate(this._getFocusedDate(),true);var d1=this._getCalendarPicker();var e1=new sap.ui.unified.DateRange({startDate:c1});d1.displayDate(c1,false);d1.removeAllSelectedDates();d1.addSelectedDate(e1);d1.setMinDate(this.getMinDate());d1.setMaxDate(this.getMaxDate());X.call(this,d1);this._showOverlay();};
j.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
j.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
function o(c1){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!c1){m.call(this);var d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function p(){if(this._iMode==3){v.call(this,true);}else if(this._iMode==2){t.call(this,true);}var c1=this._getFocusedDate();var d1=this._getItems();var e1=this.getAggregation("datesRow");var f1=e1.getSelectedDates()[0];f1.setStartDate(a._createLocalDate(c1,true));var g1=new U(c1.getTime());g1.setUTCDate(1);g1.setUTCMonth(g1.getUTCMonth()+1);g1.setUTCDate(0);var h1=g1.getUTCDate();var i1=Math.floor(d1*1.5);if(i1>h1){i1=h1;}e1.setDays(i1);if(e1.getDomRef()){e1.$().css("display","");}else{var j1=sap.ui.getCore().createRenderManager();var k1=this.$("content");j1.renderControl(e1);j1.flush(k1[0],false,true);j1.destroy();}this._showOverlay();W.call(this,c1);if(this._iMode==0){var l1=this.getAggregation("timesRow");q(l1._oItemNavigation.getItemDomRefs()[l1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;}
function r(c1){this._iMode=0;var d1=this.getAggregation("datesRow");d1.$().css("display","none");this._hideOverlay();if(!c1){m.call(this);var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function s(){if(this._iMode==1){r.call(this,true);}else if(this._iMode==3){v.call(this,true);}var c1=this._getFocusedDate();var d1=this.getAggregation("monthPicker");if(d1.getDomRef()){d1.$().css("display","");}else{var e1=sap.ui.getCore().createRenderManager();var f1=this.$("content");e1.renderControl(d1);e1.flush(f1[0],false,true);e1.destroy();}this._showOverlay();d1.setMonth(c1.getUTCMonth());$.call(this,c1.getUTCFullYear(),d1);if(this._iMode==0){var g1=this.getAggregation("timesRow");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=2;x.call(this);}
function t(c1){this._iMode=0;var d1=this.getAggregation("monthPicker");d1.$().css("display","none");this._hideOverlay();if(!c1){m.call(this);var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function u(){if(this._iMode==1){r.call(this,true);}else if(this._iMode==2){t.call(this,true);}var c1=this._getFocusedDate();var d1=this.getAggregation("yearPicker");if(d1.getDomRef()){d1.$().css("display","");}else{var e1=sap.ui.getCore().createRenderManager();var f1=this.$("content");e1.renderControl(d1);e1.flush(f1[0],false,true);e1.destroy();}this._showOverlay();d1.setDate(c1.getJSDate());if(this._iMode==0){var g1=this.getAggregation("timesRow");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}y.call(this);this._iMode=3;}
function v(c1){this._iMode=0;var d1=this.getAggregation("yearPicker");d1.$().css("display","none");this._hideOverlay();if(!c1){m.call(this);var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function w(){z.call(this);x.call(this,true);}
function x(c1){var d1=new U(k.call(this).getTime());var e1=this._getItems();var f1=d1.getJSDate().getUTCFullYear();var g1=this._oMaxDate.getJSDate().getUTCFullYear();var h1=this._oMinDate.getJSDate().getUTCFullYear();var i1=d1.getJSDate().getUTCMonth();var j1=this._oMaxDate.getJSDate().getUTCMonth();var k1=this._oMinDate.getJSDate().getUTCMonth();var l1=d1.getJSDate().getUTCDate();var m1=this._oMaxDate.getJSDate().getUTCDate();var n1=this._oMinDate.getJSDate().getUTCDate();var o1=d1.getJSDate().getUTCHours();var p1=this._oMaxDate.getJSDate().getUTCHours();var q1=this._oMinDate.getJSDate().getUTCHours();var r1=d1.getJSDate().getUTCMinutes();var s1=this._oMaxDate.getJSDate().getUTCMinutes();var t1=this._oMinDate.getJSDate().getUTCMinutes();var u1=this.getAggregation("header");if(this._iMode==2&&!c1){var v1=this.getAggregation("monthPicker");var w1=v1.getMonths();var x1=v1.getStartMonth();var y1=x1+w1-1;if(x1==0||(f1==h1&&x1<=k1)){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}if(y1>10||(f1==g1&&y1>=j1)){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}return;}if((f1<h1||(f1==h1&&(!c1||(i1<k1||(i1==k1&&(l1<n1||(l1==n1&&(o1<q1||(o1==q1&&r1<=t1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}d1.setUTCMinutes(d1.getUTCMinutes()+(e1)*this.getIntervalMinutes()-1);f1=d1.getJSDate().getUTCFullYear();i1=d1.getJSDate().getUTCMonth();l1=d1.getJSDate().getUTCDate();o1=d1.getJSDate().getUTCHours();r1=d1.getJSDate().getUTCMinutes();if((f1>g1||(f1==g1&&(!c1||(i1>j1||(i1==j1&&(l1>m1||(l1==m1&&(o1>p1||(o1==p1&&r1>=s1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}}
function y(){var c1=this.getAggregation("yearPicker");var d1=c1.getYears();var e1=a._createUniversalUTCDate(c1.getFirstRenderedDate());e1.setUTCFullYear(e1.getUTCFullYear()+Math.floor(d1/2));var f1=this.getAggregation("header");var g1=new U(this._oMaxDate);g1.setUTCFullYear(g1.getUTCFullYear()-Math.ceil(d1/2));g1.setUTCMonth(11,31);var h1=new U(this._oMinDate);h1.setUTCFullYear(h1.getUTCFullYear()+Math.floor(d1/2)+1);h1.setUTCMonth(0,1);if(e1.getTime()>g1.getTime()){f1.setEnabledNext(false);}else{f1.setEnabledNext(true);}if(e1.getTime()<h1.getTime()){f1.setEnabledPrevious(false);}else{f1.setEnabledPrevious(true);}}
function z(){var c1=this.getAggregation("header");var d1;var e1=k.call(this);var f1;var g1=this._getLocaleData();var h1=[];var i1=[];var j1;var k1=false;var l1;var m1=false;if(g1.oLocale.sLanguage.toLowerCase()==="ja"||g1.oLocale.sLanguage.toLowerCase()==="zh"){l1=b.getDateInstance({format:"d"}).format(e1,true);}else{l1=(e1.getUTCDate()).toString();}if(this._bLongMonth||!this._bNamesLengthChecked){h1=g1.getMonthsStandAlone("wide");}else{k1=true;h1=g1.getMonthsStandAlone("abbreviated");i1=g1.getMonthsStandAlone("wide");}var n1=e1.getUTCMonth();d1=h1[n1];if(k1){j1=i1[h1[n1]];}if(!this.getPickerPopup()){c1.setTextButton0(l1);c1.setTextButton1(d1);c1.setTextButton2(this._oYearFormat.format(e1,true));}else{f1=b.getInstance({style:"long",strictParsing:true,relative:m1},g1.oLocale);j1=l1=f1.format(a._createLocalDate(e1,true));c1.setTextButton1(l1);}if(k1){c1.setAriaLabelButton1(j1);}}
function A(c1,d1){var e1;var f1=false;if(c1.getTime()<this._oMinDate.getTime()){e1=this._oMinDate;f1=true;}else if(c1.getTime()>this._oMaxDate.getTime()){e1=this._oMaxDate;f1=true;}else{e1=c1;}this._setFocusedDate(e1);if(f1||d1){V.call(this,e1);m.call(this,false);this.fireStartDateChange();}}
function B(c1,d1){if(c1&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=c1.getTime())){a._checkJSDateObject(c1);c1=a._createUniversalUTCDate(c1,undefined,true);var e1=c1.getUTCFullYear();a._checkYearInValidRange(e1);if(c1.getTime()<this._oMinDate.getTime()||c1.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(c1);if(this.getDomRef()&&this._iMode==0){m.call(this,d1);}}}
function E(c1){if(this._iMode!=1){p.call(this);}else{r.call(this);}}
function F(c1){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=2){s.call(this);}else{t.call(this);}}}
function G(c1){if(this._iMode!=3){u.call(this);}else{v.call(this);}}
function I(c1){this.fireSelect();}
function J(c1){var d1=a._createUniversalUTCDate(c1.getParameter("date"),undefined,true);var e1=c1.getParameter("notVisible");A.call(this,d1,e1);}
function K(c1){var d1=c1.getSource(),e1=d1.getSelectedDates()[0].getStartDate();var f1=new U(this._getFocusedDate().getTime());var g1=a._createUniversalUTCDate(e1);f1.setUTCFullYear(g1.getUTCFullYear());f1.setUTCMonth(g1.getUTCMonth(),g1.getUTCDate());A.call(this,f1,true);o.call(this);}
function N(c1){var d1=new U(this._getFocusedDate().getTime());var e1=c1.oSource;var f1=e1.getSelectedDates()[0];var g1=a._createUniversalUTCDate(f1.getStartDate());if(!this.getPickerPopup()||g1.getUTCMonth()==d1.getUTCMonth()){d1.setUTCDate(g1.getUTCDate());d1.setUTCMonth(g1.getUTCMonth());d1.setUTCFullYear(g1.getUTCFullYear());A.call(this,d1,true);r.call(this);}}
function O(c1){var d1=new U(this._getFocusedDate().getTime());var e1=a._createUniversalUTCDate(c1.getParameter("date"),undefined,true);var f1=c1.getParameter("otherMonth");if(f1&&e1.getUTCMonth()==d1.getUTCMonth()&&e1.getUTCFullYear()==d1.getUTCFullYear()){W.call(this,e1);}}
function Q(c1){var d1=new U(this._getFocusedDate().getTime());var e1=this.getAggregation("monthPicker");var f1=e1.getMonth();d1.setUTCMonth(f1);if(f1!=d1.getUTCMonth()){d1.setUTCDate(0);}A.call(this,d1,true);t.call(this);}
function R(c1){var d1=new U(this._getFocusedDate().getTime());var e1=this.getAggregation("yearPicker");var f1=a._createUniversalUTCDate(e1.getDate());var g1=d1.getUTCMonth();f1.setUTCMonth(d1.getUTCMonth(),d1.getUTCDate());f1.setUTCHours(d1.getUTCHours());f1.setUTCMinutes(d1.getUTCMinutes());d1=f1;if(g1!=d1.getUTCMonth()){d1.setUTCDate(0);}A.call(this,d1,true);v.call(this);}
function S(){this._sInvalidateContent=undefined;var c1=this.getAggregation("timesRow");c1._bDateRangeChanged=true;c1._bInvalidateSync=true;c1.invalidate();c1._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}
function V(c1){var d1=this.getAggregation("timesRow");var e1=k.call(this);var f1=d1._oItemNavigation.getFocusedIndex();e1=new U(c1.getTime());e1.setUTCMinutes(e1.getUTCMinutes()-f1*this.getIntervalMinutes());_.call(this,e1,false,true);}
function W(c1){var d1=this.getAggregation("datesRow");var e1=this.getAggregation("header");if(!this.getPickerPopup()){var f1=new U(c1.getTime());f1.setUTCDate(1);f1.setUTCMonth(f1.getUTCMonth()+1);f1.setUTCDate(0);var g1=d1.getDays();var h1=new U(c1.getTime());h1.setUTCDate(1+(Math.ceil(c1.getUTCDate()/g1)-1)*g1);if(f1.getUTCDate()-h1.getUTCDate()<g1){h1.setUTCDate(f1.getUTCDate()-g1+1);}d1.setStartDate(a._createLocalDate(h1,true));var i1=h1.getJSDate().getUTCFullYear();var j1=this._oMaxDate.getJSDate().getUTCFullYear();var k1=this._oMinDate.getJSDate().getUTCFullYear();var l1=h1.getJSDate().getUTCMonth();var m1=this._oMaxDate.getJSDate().getUTCMonth();var n1=this._oMinDate.getJSDate().getUTCMonth();var o1=h1.getJSDate().getUTCDate();var p1=this._oMaxDate.getJSDate().getUTCDate();var q1=this._oMinDate.getJSDate().getUTCDate();if(o1<=1||(i1==k1&&l1==n1&&o1<=q1)){e1.setEnabledPrevious(false);}else{e1.setEnabledPrevious(true);}if((o1+g1)>=f1.getUTCDate()||(i1==j1&&l1==m1&&o1>=p1)){e1.setEnabledNext(false);}else{e1.setEnabledNext(true);}}else{e1.setEnabledPrevious(false);e1.setEnabledNext(false);}d1.setDate(a._createLocalDate(c1,true));}
function X(c1){if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(Z,this);this._oPopup.onsapescape=function(f1){this._oCalendar.onsapescape(f1);};}this._oPopup.setContent(c1);var d1=this.getAggregation("header");var e1=P.Dock;this._oPopup.open(0,e1.CenterTop,e1.CenterTop,d1,null,"flipfit",true);}
function Z(c1){o.call(this);}
function $(c1,d1){var e1=0;var f1=11;if(c1==this._oMinDate.getUTCFullYear()){e1=this._oMinDate.getUTCMonth();}if(c1==this._oMaxDate.getUTCFullYear()){f1=this._oMaxDate.getUTCMonth();}d1.setMinMax(e1,f1);}
function a1(c1){x.call(this);}
function b1(c1){y.call(this);}
return j;});
sap.ui.predefine('sap/ui/unified/CalendarTimeIntervalRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var i=c.getId();var t=c.getTooltip_AsString();var T=c.getAggregation("timesRow");r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");r.addClass("sapUiCalInt");r.addClass("sapUiCalTimeInt");if(c._getShowItemHeader()){r.addClass("sapUiCalIntHead");}if(c.getPickerPopup()){r.addClass("sapUiCalIntLarge");}var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}var w=c.getWidth();if(w&&w!=''){r.addStyle("width",w);r.writeStyles();}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);r.write("<div id=\""+i+"-content\" class=\"sapUiCalContent\">");r.renderControl(T);r.write("</div>");r.write("<button id=\""+i+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+i+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");if(c.getPickerPopup()){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\"");if(!c._oPopup||!c._oPopup.isOpen()){r.write("style=\"display:none;\"");}r.write(">");r.write("</div>");}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarWeekInterval',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarDateIntervalRenderer'],function(C,a,l,b,c){"use strict";
var d=b.extend("sap.ui.unified.CalendarWeekInterval",{renderer:c});
d.prototype._getDaysLarge=function(){return 6;};
d.prototype._handleFocus=function(e){var o=!!e.getParameter("_outsideBorder"),D,f,g;if(o){D=e.getParameter("date");this._oFocusDateWeek=a.fromLocalJSDate(D);f=C._getFirstDateOfWeek(this._oFocusDateWeek);g=this.getAggregation("month")[0];if(g.getDomRef()){this._setStartDate(f,false,true);}}return b.prototype._handleFocus.apply(this,arguments);};
d.prototype._focusDateExtend=function(D,o,n){var e,L;if(!this._oFocusDateWeek){return b.prototype._focusDateExtend.apply(this,arguments);}e=this.getAggregation("month")[0];L=this._oFocusDateWeek.toLocalJSDate();this._setFocusedDate(this._oFocusDateWeek);e.setDate(L);this._oFocusDateWeek=null;return!n;};
d.prototype._dateMatchesVisibleRange=function(D){var i=this.getDays(),o=a.fromLocalJSDate(D),s=a.fromLocalJSDate(this.getStartDate()),e=a.fromLocalJSDate(this.getStartDate());e.setDate(e.getDate()+i);return o.isSameOrAfter(s)&&o.isBefore(e);};
d.prototype._showCalendarPicker=function(){var o=this._getFocusedDate(),e=this._getStartDate(),f=this._getCalendarPicker(),s=new sap.ui.unified.DateRange(),g;g=new a(e);g.setDate(g.getDate()+this._getDays()-1);s.setStartDate(e.toLocalJSDate());s.setEndDate(g.toLocalJSDate());f.displayDate(o.toLocalJSDate(),false);f.removeAllSelectedDates();f.addSelectedDate(s);f.setMinDate(this.getMinDate());f.setMaxDate(this.getMaxDate());this._openPickerPopup(f);this._showOverlay();};
d.prototype._handleCalendarPickerDateSelect=function(e){var o=this._getCalendarPicker(),s=o.getSelectedDates()[0].getStartDate(),f=new a.fromLocalJSDate(s),F;if(this._dateMatchesVisibleRange(f.toLocalJSDate())){this._oFocusDateWeek=f;this._focusDate(this._oFocusDateWeek,false,true);}else{F=C._getFirstDateOfWeek(f);this._setStartDate(F);this._oFocusDateWeek=f;this._focusDate(this._oFocusDateWeek,false,true);}this._closeCalendarPicker(true);};
d.prototype._calculateStartDate=function(m,M,s){var m=new a(this._oMaxDate,this.getPrimaryCalendarType());m=this._getMaxDateAlignedToMinDate(m,this._oMinDate);s=this._getStartDateAlignedToMinAndMaxDate(m,this._oMinDate,s);return s;};
return d;});
sap.ui.predefine('sap/ui/unified/ColorPicker',["./library","sap/ui/core/Control","sap/ui/core/HTML","sap/ui/core/ResizeHandler","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/ui/core/Icon","sap/ui/core/theming/Parameters","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/core/library","./ColorPickerRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/Global"],function(L,a,H,R,G,b,V,c,I,P,e,D,f,g,h,q){"use strict";var j=f.ValueState,k=L.ColorPickerMode,l=L.ColorPickerDisplayMode;
var m=a.extend("sap.ui.unified.ColorPicker",{metadata:{library:"sap.ui.unified",properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.unified.ColorPickerMode",group:"Appearance",defaultValue:k.HSV},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:l.Default}},aggregations:{_grid:{type:"sap.ui.layout.Grid",group:"Appearance",multiple:false,visibility:"hidden"},_invisibleTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"},_oCPBox:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oSlider:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oAlphaSlider:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oHexField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oRedField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oGreenField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oBlueField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oHueField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oSatField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oLitField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oValField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oAlphaField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oAlphaField2:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oRGBorHSLRBUnifiedGroup:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oButton:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}}});
var B="",s=sap.ui.resource('sap.ui.unified','img/ColorPicker/Alphaslider_BG.png'),r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),n={};Object.defineProperties(n,{RGB:{value:"RGB"},CPResponsiveClass:{value:"sapUnifiedColorPicker"},CPMatrixClass:{value:"sapUiColorPicker-ColorPickerMatrix"},HSLClass:{value:"sapUiColorPickerHSL"},LabelClass:{value:"sapUiColorPicker-ColorPickerLabels"},UnitLabelClass:{value:"sapUiCPUnitLabel"},HEXClass:{value:"sapUiColorPicker-ColorPickerHexField"},LeftColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsLeft"},RightColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsRight"},SliderClass:{value:"sapUiColorPicker-ColorPickerSlider"},AlphaSliderClass:{value:"sapUiColorPicker-ColorPickerAlphaSlider"},OutputSelectorClass:{value:"sapUiColorPickerHSL-RB"},OutputSelectorRowClass:{value:"sapUiColorPicker-RBRow"},CPBoxClass:{value:"sapUiColorPicker-ColorPickerBox"},CPCircleClass:{value:"sapUiColorPicker-ColorPickerCircle"},LastColumnClass:{value:"sapUiColorPicker-ColorPickerLastColumn"},HideForHSVClass:{value:"hideForHSV"},HideForHSLClass:{value:"hideForHSL"},OldColorClass:{value:"sapUiColorPicker-ColorPickerOldColor"},NewColorClass:{value:"sapUiColorPicker-ColorPickerNewColor"},SwatchesClass:{value:"sapUiColorPicker-swatches"},Colors:{value:{aliceblue:'f0f8ff',antiquewhite:'faebd7',aqua:'00ffff',aquamarine:'7fffd4',azure:'f0ffff',beige:'f5f5dc',bisque:'ffe4c4',black:'000000',blanchedalmond:'ffebcd',blue:'0000ff',blueviolet:'8a2be2',brown:'a52a2a',burlywood:'deb887',cadetblue:'5f9ea0',chartreuse:'7fff00',chocolate:'d2691e',coral:'ff7f50',cornflowerblue:'6495ed',cornsilk:'fff8dc',crimson:'dc143c',cyan:'00ffff',darkblue:'00008b',darkcyan:'008b8b',darkgoldenrod:'b8860b',darkgray:'a9a9a9',darkgrey:'a9a9a9',darkgreen:'006400',darkkhaki:'bdb76b',darkmagenta:'8b008b',darkolivegreen:'556b2f',darkorange:'ff8c00',darkorchid:'9932cc',darkred:'8b0000',darksalmon:'e9967a',darkseagreen:'8fbc8f',darkslateblue:'483d8b',darkslategray:'2f4f4f',darkslategrey:'2f4f4f',darkturquoise:'00ced1',darkviolet:'9400d3',deeppink:'ff1493',deepskyblue:'00bfff',dimgray:'696969',dimgrey:'696969',dodgerblue:'1e90ff',firebrick:'b22222',floralwhite:'fffaf0',forestgreen:'228b22',fuchsia:'ff00ff',gainsboro:'dcdcdc',ghostwhite:'f8f8ff',gold:'ffd700',goldenrod:'daa520',gray:'808080',grey:'808080',green:'008000',greenyellow:'adff2f',honeydew:'f0fff0',hotpink:'ff69b4',indianred:'cd5c5c',indigo:'4b0082',ivory:'fffff0',khaki:'f0e68c',lavender:'e6e6fa',lavenderblush:'fff0f5',lawngreen:'7cfc00',lemonchiffon:'fffacd',lightblue:'add8e6',lightcoral:'f08080',lightcyan:'e0ffff',lightgoldenrodyellow:'fafad2',lightgray:'d3d3d3',lightgrey:'d3d3d3',lightgreen:'90ee90',lightpink:'ffb6c1',lightsalmon:'ffa07a',lightseagreen:'20b2aa',lightskyblue:'87cefa',lightslategray:'778899',lightslategrey:'778899',lightsteelblue:'b0c4de',lightyellow:'ffffe0',lime:'00ff00',limegreen:'32cd32',linen:'faf0e6',magenta:'ff00ff',maroon:'800000',mediumaquamarine:'66cdaa',mediumblue:'0000cd',mediumorchid:'ba55d3',mediumpurple:'9370db',mediumseagreen:'3cb371',mediumslateblue:'7b68ee',mediumspringgreen:'00fa9a',mediumturquoise:'48d1cc',mediumvioletred:'c71585',midnightblue:'191970',mintcream:'f5fffa',mistyrose:'ffe4e1',moccasin:'ffe4b5',navajowhite:'ffdead',navy:'000080',oldlace:'fdf5e6',olive:'808000',olivedrab:'6b8e23',orange:'ffa500',orangered:'ff4500',orchid:'da70d6',palegoldenrod:'eee8aa',palegreen:'98fb98',paleturquoise:'afeeee',palevioletred:'db7093',papayawhip:'ffefd5',peachpuff:'ffdab9',peru:'cd853f',pink:'ffc0cb',plum:'dda0dd',powderblue:'b0e0e6',purple:'800080',red:'ff0000',rosybrown:'bc8f8f',royalblue:'4169e1',saddlebrown:'8b4513',salmon:'fa8072',sandybrown:'f4a460',seagreen:'2e8b57',seashell:'fff5ee',sienna:'a0522d',silver:'c0c0c0',skyblue:'87ceeb',slateblue:'6a5acd',slategray:'708090',slategrey:'708090',snow:'fffafa',springgreen:'00ff7f',steelblue:'4682b4',tan:'d2b48c',teal:'008080',thistle:'d8bfd8',tomato:'ff6347',turquoise:'40e0d0',violet:'ee82ee',wheat:'f5deb3',white:'ffffff',whitesmoke:'f5f5f5',yellow:'ffff00',yellowgreen:'9acd32',transparent:'00000000'}}});
m.prototype.init=function(){if(D.browser.firefox){B="-moz-linear-gradient";}else if(D.browser.msie){B="-ms-linear-gradient";}else if(D.browser.webkit){B="-webkit-linear-gradient";}else{B="linear-gradient";}this.Color={r:255,g:255,b:255,h:0,s:0,l:100,v:100,a:1,oldA:1,hex:"#ffffff",old:"#ffffff"};this.sHexString="ffffff";this.$CPBox=null;this.$CPCur=null;this.RGB={r:0,g:0,b:0};this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this.data("sap-ui-fastnavgroup","true",true);this.bResponsive=L.ColorPickerHelper.isResponsive();var d=this.bResponsive?"_sap_ui_unified_ColorPicker_CircleSize":"_sap_ui_commons_ColorPicker_CircleSize";this._iCPCursorSize=parseInt(P.get(d));this._processChanges=this._processHSVChanges;this._bHSLMode=false;if(this.getDisplayMode()===l.Simplified){n.HideForDisplay.value=".hideDisplay";}this.bPressed=false;};
var o=a.extend("sap.ui.unified._ColorPickerBox",{
metadata:{events:{select:{parameters:{value:{type:"int"},saturation:{type:"int"}}},resize:{parameters:{size:{type:"int"}}}}},
init:function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();},
exit:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},
getWidth:function(){return this.$().width();},
getOffset:function(){return this.$().offset();},
onBeforeRendering:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},
onAfterRendering:function(){this._handle=this.$().find("> div."+n.CPCircleClass);this._sResizeListener=R.register(this.getDomRef(),this.handleResize.bind(this));},
handleResize:function(E){this.fireResize({size:E.size.width});},
getHandle:function(){return this._handle;},
ontouchstart:function(E){this.handleTouch(E);},
ontouchend:function(E){this.handleTouch(E);},
ontouchmove:function(E){this.handleTouch(E);},
handleTouch:function(E){var v=this.calculateValuesFromEvent(E);if(v){this.fireSelect(v);}},
calculateValuesFromEvent:function(E){var x=E.offsetX,y=E.offsetY,i,d=i=this.getWidth(),p,O;E.preventDefault&&E.preventDefault();if(!x){p=E.targetTouches?E.targetTouches[0]:E;if(!p||!p.pageX){p=E;if((!p||!p.pageX)&&E.changedTouches){p=E.changedTouches[0];}}if(!p.pageX){return false;}O=this.getOffset();x=p.pageX-O.left;y=p.pageY-O.top;}x=Math.min(Math.max(x,0),d);y=Math.min(Math.max(y,0),i);if(this.bRtl){x=d-x;}return{value:x/d*100,saturation:(1-y/i)*100};},
renderer:function(d,C){d.write("<div");d.addClass(n.CPBoxClass);d.writeControlData(C);d.writeClasses();d.write(">");d.write("<div");d.writeAttribute("id",C.getId()+"-cpCur");d.addClass(n.CPCircleClass);d.writeClasses();d.write("></div>");d.write("</div>");}
});
m.prototype._createRowFromInput=function(i,t,d,u){var T=r.getText(t),p;p=new c({content:[L.ColorPickerHelper.factory.createLabel({text:d,tooltip:T,labelFor:i}).addStyleClass(n.LabelClass),i.setTooltip(T)]});if(u){p.addContent(L.ColorPickerHelper.factory.createLabel({text:u,labelFor:i}).addStyleClass(n.UnitLabelClass).addStyleClass(n.LabelClass));}return p;};
m.prototype._updateColorStringProperty=function(F,d){var i=this._getCSSColorString();this.setProperty('colorString',i,true);if(d){this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:i});}if(F){this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:i});}};
m.prototype._handleCPBoxSelectEvent=function(E){var v=E.getParameter("value"),d=E.getParameter("saturation");this.oSatField.setValue(d);if(this._bHSLMode){this.oLitField.setValue(v);}else{this.oValField.setValue(v);}this._processChanges();this._updateColorStringProperty(false,true);};
m.prototype._handleCPBoxResizeEvent=function(E){this._iCPBoxSize=E.getParameter("size");this._updateCursorPosition();};
m.prototype._handleCPBoxTouchEndEvent=function(E){this._updateColorStringProperty(true,false);};
m.prototype._createInteractionControls=function(){var i=this.getId();this.oCPBox=new o(i+"-cpBox",{select:this._handleCPBoxSelectEvent.bind(this),resize:this._handleCPBoxResizeEvent.bind(this)});this.oCPBox.addDelegate({ontouchend:this._handleCPBoxTouchEndEvent.bind(this)});this.oHexField=L.ColorPickerHelper.factory.createInput(i+"-hxF",{value:this.Color.hex.substr(1),change:this._handleHexValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_HEX")}).addStyleClass(n.HEXClass);this.oRedField=L.ColorPickerHelper.factory.createInput(i+"-rF",{value:this.Color.r,change:this._handleRedValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_RED")}).addStyleClass(n.LeftColumnInputClass);this.oGreenField=L.ColorPickerHelper.factory.createInput(i+"-gF",{value:this.Color.g,change:this._handleGreenValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_GREEN")}).addStyleClass(n.LeftColumnInputClass);this.oBlueField=L.ColorPickerHelper.factory.createInput(i+"-bF",{value:this.Color.b,change:this._handleBlueValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_BLUE")}).addStyleClass(n.LeftColumnInputClass);this.oHueField=L.ColorPickerHelper.factory.createInput(i+"-hF",{value:this.Color.h,change:this._handleHueValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_HUE")}).addStyleClass(n.RightColumnInputClass);this.oSatField=L.ColorPickerHelper.factory.createInput(i+"-sF",{value:this.Color.s,change:this._handleSatValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_SAT")+" "+e.getStaticId("sap.ui.unified","COLORPICKER_PERCENTAGE")}).addStyleClass(n.RightColumnInputClass);this.oLitField=L.ColorPickerHelper.factory.createInput(i+"-lF",{value:this.Color.l,change:this._handleLitValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_LIGHTNESS")+" "+e.getStaticId("sap.ui.unified","COLORPICKER_PERCENTAGE")}).addStyleClass(n.RightColumnInputClass).addStyleClass(n.HideForHSVClass);this.oAlphaField=L.ColorPickerHelper.factory.createInput(i+"-aF",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_ALPHA")}).addStyleClass(n.RightColumnInputClass).addStyleClass(n.HideForHSVClass).addStyleClass("sapUnifiedA");this.oAlphaField2=L.ColorPickerHelper.factory.createInput(i+"-aF2",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_ALPHA")}).addStyleClass(n.RightColumnInputClass).addStyleClass(n.HideForHSVClass).addStyleClass("sapUnifiedA");this.oValField=L.ColorPickerHelper.factory.createInput(i+"-vF",{value:this.Color.v,change:this._handleValValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_VALUE")}).addStyleClass(n.RightColumnInputClass).addStyleClass(n.HideForHSLClass);this.oRGBorHSLRBGroup=L.ColorPickerHelper.factory.createRadioButtonGroup({columns:2,buttons:[L.ColorPickerHelper.factory.createRadioButtonItem({text:n.RGB}),L.ColorPickerHelper.factory.createRadioButtonItem({text:L.ColorPickerMode.HSL})],select:this._handleRGBorHSLValueChange.bind(this),selectedIndex:(this.Color.formatHSL?1:0)}).addStyleClass(n.OutputSelectorClass);this.oHueInvisibleText=new e({text:r.getText("COLORPICKER_HUE_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",this.oHueInvisibleText,true);this.oSlider=L.ColorPickerHelper.factory.createSlider(i+"-hSLD",{max:360,step:1,tooltip:r.getText("COLORPICKER_HUE"),value:parseInt(this.oHueField.getValue())}).addStyleClass(n.SliderClass).addAriaLabelledBy(this.oHueInvisibleText);this.oSlider.attachEvent("liveChange","liveChange",this._handleSliderChange.bind(this));this.oSlider.attachEvent("change","change",this._handleSliderChange.bind(this));this.oAlphaInvisibleText=new e({text:r.getText("COLORPICKER_ALPHA_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",this.oAlphaInvisibleText,true);this.oAlphaSlider=L.ColorPickerHelper.factory.createSlider(i+"-aSLD",{max:1,value:1,step:0.01,tooltip:r.getText("COLORPICKER_ALPHA")}).addStyleClass(n.AlphaSliderClass).addAriaLabelledBy(this.oAlphaInvisibleText);this.oAlphaSlider.attachEvent("liveChange","liveChange",this._handleAlphaSliderChange.bind(this));this.oAlphaSlider.attachEvent("change","change",this._handleAlphaSliderChange.bind(this));};
m.prototype._createLayout=function(){var i=this.getId(),d;if(this._bLayoutControlsCreated){return;}this._createInteractionControls();this.oCPBoxGD=new b({span:"L6 M6 S12"});this.icOne=new b({span:"L3 M3 S6"});this.icTwo=new b({span:"L3 M3 S6"});this.swatches=new b({span:"L3 M3 S12"});this.rbg=new b({span:"L6 M8 S12"});if(this.bResponsive){this._createUnifiedColorPicker(i);}else{d=this._createCommonsColorPicker(d,i);this.setAggregation("_grid",d,true);}this._bLayoutControlsCreated=true;if(!this.bResponsive){this._adaptControlToLibrary();}};
m.prototype._adaptControlToLibrary=function(){var d;if(!this._bLayoutControlsCreated){return;}d=this.getAggregation("_grid");if(this.bResponsive){if(!D.system.phone&&!q('html').hasClass("sapUiMedia-Std-Phone")){d._setBreakPointTablet(400);}d.addStyleClass(n.CPResponsiveClass);}else{d.setProperty("hSpacing",0,true);d.setProperty("vSpacing",0,true);this.oCPBoxGD.setSpanS(5);this.icOne.setSpanS(4);this.icTwo.setSpanS(3);this.rbg.setSpanS(8);}};
m.prototype._updateControlVisualState=function(){var d=this.getAggregation("_grid");if(!d){return;}if(this.bResponsive){if(this._bHSLMode){d.addStyleClass(n.HSLClass);this.swatches.setSpanM(4).setLinebreak(true);}else{d.removeStyleClass(n.HSLClass);this.swatches.setSpanM(3).setLinebreak(false);}}else{if(this._bHSLMode){d.addStyleClass(n.HSLClass);this.swatches.setSpanS(4).setLinebreak(true);}else{d.removeStyleClass(n.HSLClass);this.swatches.setSpanS(3).setLinebreak(false);}}};
m.prototype._processChanges=function(){};
m.prototype.setMode=function(M,S){this._bLayoutControlsCreated=false;switch(M){case L.ColorPickerMode.HSL:this._processChanges=this._processHSLChanges;break;case L.ColorPickerMode.HSV:this._processChanges=this._processHSVChanges;break;default:h.error("Control must have a valid mode set to work correct");break;}this._bHSLMode=M===L.ColorPickerMode.HSL;return this.setProperty("mode",M,S);};
m.prototype.setDisplayMode=function(d){this._bLayoutControlsCreated=false;return this.setProperty("displayMode",d,false);};
m.prototype._cleanup=function(){var C=[this.getAggregation("_grid"),this.getAggregation("_oCPBox"),this.getAggregation("_oHexField"),this.getAggregation("_oRedField"),this.getAggregation("_oGreenField"),this.getAggregation("_oBlueField"),this.getAggregation("_oHueField"),this.getAggregation("_oSatField"),this.getAggregation("_oLitField"),this.getAggregation("_oAlphaField"),this.getAggregation("_oAlphaField2"),this.getAggregation("_oValField"),this.getAggregation("_oSlider"),this.getAggregation("_oAlphaSlider"),this.oRGBorHSLRBUnifiedGroup,this.oCPBoxGD,this.icOne,this.icTwo,this.rbg,this.swatches,this.oAlphaInvisibleText,this.oHueInvisibleText,this.getAggregation("_oButton"),this.getAggregation("_oRGBorHSLRBUnifiedGroup"),this.oRGBorHSLRBGroup];C.forEach(function(d){if(d){d.destroy();}},this);this._bLayoutControlsCreated=false;};
m.prototype.exit=function(){this._cleanup();};
m.prototype.onBeforeRendering=function(){this._cleanup();this._createLayout();this._updateControlVisualState();this._updateColorString();};
m.prototype._updateColorString=function(){this._parseColorString(this.getColorString());this.oHexField.setValue(this.Color.hex.substr(1));this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(this.Color.a);this.oAlphaField2.setValue(this.Color.a);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);if(this.bResponsive){this.oRGBorHSLRBUnifiedGroup.setSelectedIndex(this.Color.formatHSL?1:0);}else{this.oRGBorHSLRBGroup.setSelectedIndex(this.Color.formatHSL?1:0);}}else{this.oValField.setValue(this.Color.v);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);this.oAlphaField.setValue(this.Color.a);this.oAlphaField2.setValue(this.Color.a);}this._updateColorStringProperty(true,true);};
m.prototype.isColor=function(C){return this._parseColorString(C,true);};
m.prototype._handleSliderChange=function(E,d){var i=parseInt(this.oSlider.getValue());this.oHueField.setValue(i);this._processChanges();this._updateColorStringProperty(d==="change",d==="liveChange");};
m.prototype._handleAlphaSliderChange=function(E,d){this.Color.a=this.oAlphaSlider.getValue();if(this._bHSLMode){this.oAlphaField.setValue(this.Color.a);this.oAlphaField2.setValue(this.Color.a);}if(!this.Color.formatHSL){this._processRGBChanges();}else{this._processChanges();}this._updateColorStringProperty(d==="change",d==="liveChange");};
m.prototype._getValueInRange=function(v,M,i){if(isNaN(v)){v=0;}return Math.min(Math.max(v,M),i);};
m.prototype._handleAlphaValueChange=function(E){var d=(E.getParameter("id")=="cp-aF2")?parseFloat(this.oAlphaField2.getValue(),10):parseFloat(this.oAlphaField.getValue(),10);d=this._getValueInRange(d,0,1);this.Color.a=d;this.oAlphaField.setValue(d);this.oAlphaField2.setValue(d);this.oAlphaSlider.setValue(d);if(!this.Color.formatHSL){this._processRGBChanges();}else{this._processChanges();}this._updateColorStringProperty(true,true);};
m.prototype._handleRGBorHSLValueChange=function(){var u=this.oRGBorHSLRBUnifiedGroup;this.Color.formatHSL=u?u.getSelectedIndex()===1:this.oRGBorHSLRBGroup.getSelectedIndex()===1;this._updateColorStringProperty(true,true);};
m.prototype._handleHueValueChange=function(){var d=parseInt(this.oHueField.getValue());d=this._getValueInRange(d,0,360);this.oHueField.setValue(d);this.oSlider.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleSatValueChange=function(){var d=parseInt(this.oSatField.getValue());d=this._getValueInRange(d,0,100);this.oSatField.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleValValueChange=function(){var v=parseInt(this.oValField.getValue());v=this._getValueInRange(v,0,100);this.oValField.setValue(v);this._processHSVChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleLitValueChange=function(){var d=parseInt(this.oLitField.getValue());d=this._getValueInRange(d,0,100);this.oLitField.setValue(d);this._processHSLChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleRedValueChange=function(){var d=parseInt(this.oRedField.getValue());d=this._getValueInRange(d,0,255);this.oRedField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleGreenValueChange=function(){var d=parseInt(this.oGreenField.getValue());d=this._getValueInRange(d,0,255);this.oGreenField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleBlueValueChange=function(){var d=parseInt(this.oBlueField.getValue());d=this._getValueInRange(d,0,255);this.oBlueField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
m.prototype._processHSVChanges=function(){var d=parseInt(this.oHueField.getValue());var i=parseInt(this.oSatField.getValue());var v=parseInt(this.oValField.getValue());this._calculateRGB(d,i,v);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=d;this.Color.s=i;this.Color.v=v;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oValField.setValue(this.Color.v);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};
m.prototype._processHSLChanges=function(){var i=parseInt(this.oHueField.getValue()),S=parseInt(this.oSatField.getValue()),d=parseInt(this.oLitField.getValue());if(i>360){i%=360;}this._calculateRGB(i,S,d);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=i;this.Color.s=S;this.Color.l=d;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oLitField.setValue(this.Color.l);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground();};
m.prototype._processRGBChanges=function(){var d=Math.round(parseInt(this.oRedField.getValue())),i=Math.round(parseInt(this.oGreenField.getValue())),p=Math.round(parseInt(this.oBlueField.getValue())),t=(d+i+p)===765;this._calculateHEX(d,i,p);this.oHexField.setValue(this.sHexString);if(this._bHSLMode){this._calculateHSL(d,i,p);this.oLitField.setValue(this.Color.l);}else{if(!t){this._calculateHSV(d,i,p);}this.oValField.setValue(this.Color.v);}if(!t){this.oHueField.setValue(this.Color.h);}this.oSatField.setValue(this.Color.s);this.oSlider.setValue(parseInt(this.oHueField.getValue()));this.Color.r=d;this.Color.g=i;this.Color.b=p;this.Color.hex="#"+this.oHexField.getValue();this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};
m.prototype._handleHexValueChange=function(){var d=this.oHexField.getValue().toLowerCase(),i=1,p;if(d.substr(0,1)==='#'){d=d.substr(1);}p=/^([0-9a-fA-F]{8})$/;if(p.test(d)!==false){i=Number((parseInt(d.substr(6,2),16)/255).toFixed(2));d=d.substr(0,6);}p=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;if(p.test(d)===false){this.oHexField.setValueState(j.Error);this.oSlider.setEnabled(false);this.oAlphaSlider.setEnabled(false);this.oHueField.setEnabled(false);this.oRedField.setEnabled(false);this.oGreenField.setEnabled(false);this.oBlueField.setEnabled(false);this.oSatField.setEnabled(false);this.oAlphaField.setEnabled(false);this.oAlphaField2.setEnabled(false);if(this._bHSLMode){this.oLitField.setEnabled(false);}else{this.oValField.setEnabled(false);}return;}else if(this.oHexField.getValueState()===j.Error){this.oHexField.setValueState(j.None);this.oSlider.setEnabled(true);this.oAlphaSlider.setEnabled(true);this.oHueField.setEnabled(true);this.oRedField.setEnabled(true);this.oGreenField.setEnabled(true);this.oBlueField.setEnabled(true);this.oSatField.setEnabled(true);this.oAlphaField.setEnabled(true);this.oAlphaField2.setEnabled(true);if(this._bHSLMode){this.oLitField.setEnabled(true);}else{this.oValField.setEnabled(true);}}if(d.length===3){d=d.charAt(0)+d.charAt(0)+d.charAt(1)+d.charAt(1)+d.charAt(2)+d.charAt(2);}this._processHexChanges(d);this.oHexField.setValue(d);this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(1);this.oAlphaField2.setValue(1);}else{this.oValField.setValue(this.Color.v);}this.oSlider.setValue(parseInt(this.oHueField.getValue()));this.oAlphaSlider.setValue(i);this.Color.a=i;if(this._bHSLMode){this.oAlphaField.setValue(i);this.oAlphaField2.setValue(i);}this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();this._updateColorStringProperty(true,true);};
m.prototype._processHexChanges=function(d){this._convertRGB(d);if(this._bHSLMode){this._calculateHSL(this.Color.r,this.Color.g,this.Color.b);}else{this._calculateHSV(this.Color.r,this.Color.g,this.Color.b);}this.Color.hex="#"+d.toLowerCase();};
m.prototype._updateAlphaBackground=function(){var d=[this.Color.r,this.Color.g,this.Color.b].join(","),i=B+"(left,rgba("+d+",0),rgba("+d+",1)),url("+s+")";if(this.lastAlphaSliderGradient!==i){this.oAlphaSlider.$().find(this.bResponsive?".sapMSliderInner":".sapUiSliBar").css("background-image",i);this.lastAlphaSliderGradient=i;}};
m.prototype._updateCursorPosition=function(){var x,y;if(!this._iCPBoxSize){return;}if(this._bHSLMode){x=Math.round(this.oLitField.getValue()*this._iCPBoxSize/100.0);}else{x=Math.round(this.oValField.getValue()*this._iCPBoxSize/100.0);}if(sap.ui.getCore().getConfiguration().getRTL()){x=this._iCPBoxSize-x;}y=Math.round((1-this.oSatField.getValue()/100.0)*this._iCPBoxSize);x=Math.round(Math.max(x,0)-this._iCPCursorSize/2.0-1.0);y=Math.round(Math.max(y,0)-this._iCPCursorSize/2.0-1.0);this.$CPCur.css("left",x).css("top",y);};
m.prototype._calculateRGB=function(d,S,v){var p,t,u,M,x,C,i;if(this._bHSLMode){this._calculateRGBAdvanced(d,S,v);return;}d%=360;d/=60;S/=100;v/=100;C=v*S;x=C*(1-Math.abs(d%2-1));M=v-C;p=0;t=0;u=0;i=Math.floor(d);switch(i){case 0:p=C;t=x;break;case 1:p=x;t=C;break;case 2:t=C;u=x;break;case 3:t=x;u=C;break;case 4:p=x;u=C;break;case 5:p=C;u=x;break;default:p=0;u=0;t=0;break;}this.RGB.r=Math.floor((p+M)*255);this.RGB.g=Math.floor((t+M)*255);this.RGB.b=Math.floor((u+M)*255);};
m.prototype._calculateRGBAdvanced=function(d,S,p){var t,u,v,M,w,x,y,z,i;d=this._getValueInRange(d,0,360);d%=360;if(S>100){S=1;}else if(S<0){S=0;}else{S=S/100;}if(p>100){p=1;}else if(p<0){p=0;}else{p=p/100;}z=S*(1-Math.abs(2*p-1));y=255*(p-0.5*z);x=z*(1-Math.abs((d/60)%2-1));i=Math.floor(d/60);w=y+255*x;M=y+255*z;switch(i){case 0:t=M;u=w;v=y;break;case 1:t=w;u=M;v=y;break;case 2:t=y;u=M;v=w;break;case 3:t=y;u=w;v=M;break;case 4:t=w;u=y;v=M;break;case 5:t=M;u=y;v=w;break;default:t=0;u=0;v=0;break;}this.RGB.r=Math.round(t);this.RGB.g=Math.round(u);this.RGB.b=Math.round(v);};
m.prototype._getCSSColorString=function(){if(this.Color.formatHSL){if(this.Color.a<1){return"hsla("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%, "+this.Color.a+")";}else{return"hsl("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%)";}}if(this.Color.a<1){return"rgba("+this.Color.r+","+this.Color.g+","+this.Color.b+", "+this.Color.a+")";}else{return"rgb("+this.Color.r+","+this.Color.g+","+this.Color.b+")";}};
m.prototype._calculateHEX=function(i,d,p){var t=i.toString(16),u=d.toString(16),v=p.toString(16);if(t.length===1){t='0'+t;}if(u.length===1){u='0'+u;}if(v.length===1){v='0'+v;}this.sHexString=(t+u+v).toLowerCase();};
m.prototype._calculateHSV=function(i,d,p){var t=Math.max(Math.max(i,d),p),u=Math.min(Math.min(i,d),p),v=t-u,w=Math.round(t*100/255),x=t===0.0?0:(100*v/t),y=0;if(x===0){y=0;}else if(i===t){y=60.0*(d-p)/v;}else if(d===t){y=120.0+60.0*(p-i)/v;}else if(p===t){y=240.0+60.0*(i-d)/v;}if(y<0.0){y+=359.9;}y=Math.round(y);x=Math.round(x);this.Color.h=y;this.Color.s=x;this.Color.v=w;};
m.prototype._calculateHSL=function(i,p,t){var u=Math.max(i,p,t),v=Math.min(i,p,t),d=(u-v)/255,w=(u+v)/510,x=1-Math.abs(2*w-1),y=(w===0.0)?0:d/x,z=(x!==0)?y:0,A=0;w=Math.round(w*100);z=Math.round(z*100);if(w===0||z===0||(i+p+t===765)){A=0;}else{var C=u-v;if(u===i){A=((p-t)/C)%6;}if(u===p){A=(t-i)/C+2;}if(u===t){A=(i-p)/C+4;}if(C===0){A=0;}A*=60;if(A<0){A+=360;}}if(A!==0||this.Color.h!==360){this.Color.h=Math.round(A);}this.Color.s=z;this.Color.l=w;};
m.prototype._convertRGB=function(d){this.Color.r=parseInt(d.substr(0,2),16);this.Color.g=parseInt(d.substr(2,2),16);this.Color.b=parseInt(d.substr(4,2),16);};
m.prototype._updateGradientBoxBackground=function(i){if(this._bHSLMode){this._calculateRGBAdvanced(i,100,50);}else{this._calculateRGB(i,100,100);}this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.$CPBox.css('background-color','rgb('+[this.RGB.r,this.RGB.g,this.RGB.b].join(",")+')');};
m.prototype._updateSelColorBackground=function(){this.$().find(".sapUiColorPicker-ColorPickerNewColor").css('background-color',this._getCSSColorString());};
m.prototype._parseColorString=function(C,d){var i;if(C.substr(0,1)==='#'){C=C.substr(1);}C=C.trim().toLowerCase();i=this._parseColorName(C);if(i){if(d){return true;}if(i.length===8){this.Color.a=this.Color.oldA=Number((parseInt(i.substr(6,2),16)/255).toFixed(2));i=i.substring(0,6);}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/.test(C)){if(d){return true;}if(C.length===3){i=C[0]+C[0]+C[1]+C[1]+C[2]+C[2];}else{i=C;}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(C.substr(0,3)==='rgb'){return this._parseRGB(C,d);}if(this._bHSLMode){return this._parseHSL(C,d);}else if(C.substr(0,3)==='hsv'){return this._parseHSV(C,d);}return false;};
m.prototype._parseHSV=function(C,d){var i=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),)(((\d{1,2})|(100)),)((\d{1,2})|(100))$/,p,t,S,v;C=C.substr(3).replace("(",'').replace(")",'').split(' ').join('');if(i.test(C)===true){if(d){return true;}p=C.split(",");t=parseInt(p[0]);S=parseInt(p[1]);v=parseInt(p[2]);this._calculateRGB(t,S,v);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=t;this.Color.s=S;this.Color.v=v;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;return true;}return false;};
m.prototype._parseHSL=function(C,d){var i,p=C.substr(0,4),t,u,S,v,A;if(p==="hsla"){t=true;}else if(p==="hsl("){t=false;}else{return false;}C=C.substr(t?4:3).replace("(",'').replace(")",'').split(' ').join('');i=C.split(",");u=parseInt(i[0]);S=parseFloat(i[1]);v=parseFloat(i[2]);if(t){A=parseFloat(i[3]);}else{if(i[3]&&parseFloat(i[3])>=0){return false;}A=1;}S=(S<1&&S>0)?S*100:S;v=(v<1&&v>0)?v*100:v;if((u>=0&&u<=360)&&(S>=0&&S<=100)&&(v>=0&&v<=100)&&(A>=0&&A<=1)){if(d){return true;}this._calculateRGB(u,S,v);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=u;this.Color.s=S;this.Color.l=v;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.oldA=A;this.Color.formatHSL=true;}else{return false;}return true;};
m.prototype._parseRGB=function(C,d){var v,i,p,t;i=C.substring(0,4);if(i==="rgba"){t=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),)([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1])$/;p=true;}else if(i.substring(0,3)==="rgb"){t=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])))$/;p=false;}else{return false;}C=C.substr(p?4:3).replace("(",'').replace(")",'').split(' ').join('');if(t.test(C)){if(d){return true;}v=C.split(",");this._calculateHEX(parseInt(v[0]),parseInt(v[1]),parseInt(v[2]));this._processHexChanges(this.sHexString);this.Color.old=this.Color.hex;if(p){this.Color.a=this.Color.oldA=parseFloat(v[3]);}return true;}if(this._bHSLMode){this.Color.formatHSL=false;}return false;};
m.prototype._parseColorName=function(C){return n.Colors[C];};
m.prototype.onAfterRendering=function(){var d=this._getCSSColorString(),p=this.getParent();this.$CPBox=this.oCPBox.$();this.$CPCur=this.oCPBox.getHandle();this.$().find(".sapUiColorPicker-ColorPickerNewColor").css('background-color',d);this.$().find(".sapUiColorPicker-ColorPickerOldColor").css('background-color',d);this._updateGradientBoxBackground(this.Color.h);this._iCPBoxSize=this.oCPBox.getWidth();this._updateCursorPosition();if(this._bHSLMode){this._updateAlphaBackground();}this.oSlider.iShiftGrip=Math.round(q(this.oSlider.oGrip).outerWidth()/2);this.oAlphaSlider.iShiftGrip=Math.round(q(this.oAlphaSlider.oGrip).outerWidth()/2);if(p&&p.getMetadata().getName()==="sap.m.Dialog"){p.addStyleClass("sapUiCPDialog");}this.addStyleClass("sapUiCPDisplayRGB");};
m.prototype.getRGB=function(){return{r:this.Color.r,g:this.Color.g,b:this.Color.b};};
m.prototype._getConstants=function(){return n;};
m.prototype._createCommonsColorPicker=function(d,i){d=new G({containerQuery:true,content:[this.oCPBox.setLayoutData(this.oCPBoxGD),new V({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED","R:"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN","G:"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE","B:"),this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","#:")],layoutData:this.icOne}),new V({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE","H:"),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","S:","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","L:","%").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","A:").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oAlphaField2,"COLORPICKER_ALPHA","A:").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE","V:").addStyleClass(n.HideForHSLClass)],layoutData:this.icTwo}).addStyleClass(n.LastColumnClass),new c({content:[new H({content:["<div id='",i,"-ocBox' class='",n.OldColorClass,"'></div>"].join("")}),new H({content:["<div id='",i,"-ncBox' class='",n.NewColorClass,"'></div>"].join("")})],layoutData:this.swatches}).addStyleClass(n.SwatchesClass),new c({content:[L.ColorPickerHelper.factory.createLabel({text:"Output:",labelFor:this.oRGBorHSLRBGroup}),this.oRGBorHSLRBGroup],layoutData:this.rbg}).addStyleClass(n.HideForHSVClass).addStyleClass(n.OutputSelectorRowClass),this.oSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})),this.oAlphaSlider.setLayoutData(new b({span:"L6 M6 S12"}))]}).addStyleClass(n.CPMatrixClass);return d;};
m.prototype._createUnifiedColorPicker=function(i){var t=this;this.oRbRGB=L.ColorPickerHelper.factory.createRadioButtonItem({tooltip:r.getText("COLORPICKER_SELECT_RGB_TOOLTIP")});this.oRbRGB.addStyleClass("sapUiCPRB");this.oRbHSLV=L.ColorPickerHelper.factory.createRadioButtonItem({tooltip:r.getText("COLORPICKER_SELECT_HSL_TOOLTIP")});this.oRbHSLV.addStyleClass("sapUiCPRB");this.oButton=L.ColorPickerHelper.factory.createButton(i+"-toggleMode",{type:D.system.phone?"Default":"Transparent",tooltip:r.getText("COLORPICKER_TOGGLE_BTN_TOOLTIP"),icon:"sap-icon://source-code",press:function(E){t.toggleStyleClass("sapUiCPDisplayRGB",t.bPressed);t.bPressed=!t.bPressed;}});this.setAggregation("_oButton",this.oButton,true);this.oRGBorHSLRBUnifiedGroup=L.ColorPickerHelper.factory.createRadioButtonGroup({select:this._handleRGBorHSLValueChange.bind(this),selectedIndex:(this.Color.formatHSL?1:0)});this.oRGBorHSLRBUnifiedGroup.addButton(this.oRbRGB);this.oRGBorHSLRBUnifiedGroup.addButton(this.oRbHSLV);this.setAggregation("_oRGBorHSLRBUnifiedGroup",this.oRGBorHSLRBUnifiedGroup,true);this.setAggregation("_oCPBox",this.oCPBox,true);this.setAggregation("_oHexField",this.oHexField,true);this.setAggregation("_oRedField",this.oRedField,true);this.setAggregation("_oGreenField",this.oGreenField,true);this.setAggregation("_oBlueField",this.oBlueField,true);this.setAggregation("_oHueField",this.oHueField,true);this.setAggregation("_oSatField",this.oSatField,true);this.setAggregation("_oLitField",this.oLitField,true);this.setAggregation("_oAlphaField",this.oAlphaField,true);this.setAggregation("_oAlphaField2",this.oAlphaField2,true);this.setAggregation("_oValField",this.oValField,true);this.setAggregation("_oSlider",this.oSlider,true);this.setAggregation("_oAlphaSlider",this.oAlphaSlider,true);};
return m;});
sap.ui.predefine('sap/ui/unified/ColorPickerPopover',['sap/ui/core/Control','sap/ui/Device','sap/m/Button','sap/m/ResponsivePopover','./ColorPicker','./library','sap/m/library'],function(C,D,B,R,a,l,L){"use strict";var P=L.PlacementType;var b=l.ColorPickerMode,c=l.ColorPickerDisplayMode;
var d=C.extend("sap.ui.unified.ColorPickerPopover",{
metadata:{library:"sap.ui.unified",publicMethods:["openBy","close"],properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.unified.ColorPickerMode",group:"Appearance",defaultValue:b.HSV},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:c.Default}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}},
renderer:{}
});
var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var F={COLOR_PICKER_PROPS:{colorString:"setColorString",mode:"setMode",displayMode:"setDisplayMode"},POPOVER_METHODS:{getDomRef:"",close:""}};
d.prototype.init=function(){this._oPopover=null;this._bPopoverDestroying=null;};
d.prototype.exit=function(){this._bPopoverDestroying=true;if(this._oPopover){this._oPopover.removeDelegate(this._oPopover._onAfterRenderingDelegate);this._oPopover.destroy();this._oPopover=null;}};
d.prototype.openBy=function(e){return R.prototype.openBy.apply(this._ensurePopover(),arguments);};
d.prototype._getColorPicker=function(){return this._ensurePopover().getContent()[0];};
d.prototype._ensurePopover=function(){if(!this._oPopover){this._oPopover=this._createPopover();}return this._oPopover;};
d.prototype._createPopover=function(){var p,e=this._createColorPicker(),f,t=this;p=new R(this.getId()+"-colorPickerPopover",{showHeader:D.system.phone,placement:P.VerticalPreferredBottom,showArrow:false,showCloseButton:false,beginButton:new B({text:o.getText("COLOR_PICKER_SUBMIT"),press:function(){t.fireChange(t._oLastChangeCPParams);p.close();}}),endButton:new B({text:o.getText("COLOR_PICKER_CANCEL"),press:function(){p.close();}}),title:o.getText("COLOR_PICKER_TITLE"),content:e});e.attachEvent("change",function(E){this._handleChange(E);}.bind(this));f={onAfterRendering:function(){var $=this.$();$.attr("aria-modal","true");$.attr("aria-label",this.getTitle());}};p.addEventDelegate(f,p);p._onAfterRenderingDelegate=f;return p;};
d.prototype._handleChange=function(e){var t={};this._oLastChangeCPParams=jQuery.extend(t,e.getParameters());delete this._oLastChangeCPParams.id;return this;};
d.prototype._createColorPicker=function(){var e=new a(this.getId()+"-color_picker");return e;};
d.prototype.setProperty=function(p,v,s){var t;if(F.COLOR_PICKER_PROPS[p]!==undefined){t=F.COLOR_PICKER_PROPS[p]||p;a.prototype[t].call(this._getColorPicker(),v);}return C.prototype.setProperty.apply(this,arguments);};
Object.keys(F.POPOVER_METHODS).forEach(function(s){var t=F.POPOVER_METHODS[s]||s;d.prototype[s]=function(){if(this._bPopoverDestroying){return null;}var p=this._ensurePopover();return p[t].apply(p,arguments);};});return d;});
sap.ui.predefine('sap/ui/unified/ColorPickerRenderer',['./ColorPickerDisplayMode',"sap/ui/Device"],function(C,D){"use strict";var a={};
a.render=function(r,c){var d=c.getDisplayMode(),R=c.bResponsive;r.write("<div");r.writeControlData(c);if(R){r.addClass("sapUiColorPicker-ColorPickerMatrix");r.addClass("sapUiColorPicker-"+d);r.addClass("sapUnifiedColorPicker");if(c._bHSLMode){r.addClass("sapUiColorPickerHSL");}}if(D.system.phone){r.addClass("sapUiCPPhone");}r.writeClasses();r.write(">");if(!R){r.renderControl(c.getAggregation("_grid"));}else{switch(d){case C.Default:this.renderDefaultColorPicker(r,c);break;case C.Large:this.renderLargeColorPicker(r,c);break;case C.Simplified:this.renderSimplifiedColorPicker(r,c);}}r.write("</div>");};
a.renderDefaultColorPicker=function(r,c){r.renderControl(c.getAggregation("_oCPBox"));if(D.system.phone){r.write("<div class='sapUiCPPhoneContent'>");r.write("<div class='sapUiCPSlidersPhone'>");r.renderControl(c.getAggregation("_oSlider"));r.renderControl(c.getAggregation("_oAlphaSlider"));r.write("</div>");this.renderMobileSwatches(r,c);r.write("</div>");}else{r.renderControl(c.getAggregation("_oSlider"));r.renderControl(c.getAggregation("_oAlphaSlider"));this.renderDesktopSwatchesAndHexFields(r,c);}r.write("<div class='sapUiCPDefaultWrapper'>");r.write("<div class='sapUiCPDefaultRGB'>");r.renderControl(c.getAggregation("_oRedField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oGreenField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oBlueField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oAlphaField"));r.write("</div>");r.write("<div class='sapUiCPDefaultHSLV'>");r.renderControl(c.getAggregation("_oHueField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oSatField"));r.write("<div class='sapUiCPPercentSymbol'>%</div>");r.renderControl(c.getAggregation("_oLitField"));r.renderControl(c.getAggregation("_oValField"));if(c.getMode()==="HSL"){r.write("<div class='sapUiCPPercentSymbol'>%</div>");}else{this.renderEmptyDiv(r);}r.renderControl(c.getAggregation("_oAlphaField2"));r.write("</div>");r.renderControl(c.getAggregation("_oButton"));this.renderRGBLabel(r,c);this.renderHSLVLabel(r,c);r.write("</div>");};
a.renderLargeColorPicker=function(r,c){r.renderControl(c.getAggregation("_oCPBox"));r.renderControl(c.getAggregation("_oSlider"));r.renderControl(c.getAggregation("_oAlphaSlider"));this.renderDesktopSwatchesAndHexFields(r,c);r.write("<div class='sapUiCPRGBA'>");r.renderControl(c.oRbRGB);r.renderControl(c.getAggregation("_oRedField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oGreenField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oBlueField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oAlphaField"));r.write("</div>");this.renderRGBLabel(r,c);r.write("<div class='sapUiCPHSLV'>");r.renderControl(c.oRbHSLV);r.renderControl(c.getAggregation("_oHueField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oSatField"));r.write("<div class='sapUiCPPercentSymbol'>%</div>");c.getMode()==="HSL"?this.renderLFirst(r,c):this.renderVFirst(r,c);r.write("</div>");this.renderHSLVLabel(r,c);};
a.renderSimplifiedColorPicker=function(r,c){r.renderControl(c.getAggregation("_oCPBox"));if(D.system.phone){r.write("<div class='sapUiCPPhoneContent'>");r.write("<div class='sapUiCPSlidersPhone'>");r.renderControl(c.getAggregation("_oSlider"));r.write("</div>");r.renderControl(c.getAggregation("_oHexField"));this.renderMobileSwatches(r,c);r.write("<div class='sapUiCPHexWrapper'>");r.write("<span class='sapUiCPHexText'>Hex</span>");r.write("</div>");r.write("</div>");}else{r.renderControl(c.getAggregation("_oSlider"));this.renderDesktopSwatchesAndHexFields(r,c);}};
a.renderDesktopSwatchesAndHexFields=function(r,c){r.write("<div class='sapUiCPComparisonWrapper'>");r.write("<div id='"+c.getId()+"-ocBox' class='sapUiColorPicker-ColorPickerOldColor'></div>");r.write("<div id='"+c.getId()+"-ncBox' class='sapUiColorPicker-ColorPickerNewColor'></div>");r.write("</div>");r.write("<div class='sapUiCPHexWrapper'>");r.write("<span class='sapUiCPHexText'>Hex</span>");r.write("</div>");r.renderControl(c.getAggregation("_oHexField"));};
a.renderMobileSwatches=function(r,c){r.write("<div class='sapUiCPComparisonWrapper sapUiCPComparisonWrapperPhone'>");r.write("<div id='"+c.getId()+"-ocBox' class='sapUiColorPicker-ColorPickerOldColor'></div>");r.write("<div id='"+c.getId()+"-ncBox' class='sapUiColorPicker-ColorPickerNewColor'></div>");r.write("</div >");};
a.renderLFirst=function(r,c){r.renderControl(c.getAggregation("_oLitField"));r.write("<div class='sapUiCPPercentSymbol'>%</div>");r.renderControl(c.getAggregation("_oValField"));};
a.renderVFirst=function(r,c){r.renderControl(c.getAggregation("_oValField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oLitField"));};
a.renderEmptyDiv=function(r){r.write("<div class='sapUiCPEmptyDiv'></div>");};
a.renderRGBLabel=function(r,c){r.write("<div class='sapUiCPRGBText'>");r.write("<span class='sapUiCPText'>R</span>");this.renderEmptyDiv(r);r.write("<span class='sapUiCPText'>G</span>");this.renderEmptyDiv(r);r.write("<span class='sapUiCPText'>B</span>");this.renderEmptyDiv(r);if(c.getDisplayMode()==="Default"){r.write("<span class='sapUiCPText'>A</span>");}else{r.write("<span class='sapUiCPText'></span>");}r.write("</div>");};
a.renderHSLVLabel=function(r,c){r.write("<div class='sapUiCPHSLVText'>");r.write("<span class='sapUiCPText'>H</span>");this.renderEmptyDiv(r);r.write("<span class='sapUiCPText'>S</span>");this.renderEmptyDiv(r);c.getMode()==="HSL"?r.write("<span class='sapUiCPText'>L</span>"):r.write("<span class='sapUiCPText'>V</span>");this.renderEmptyDiv(r);r.write("<span class='sapUiCPText'>A</span>");r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/ui/unified/ContentSwitcher',['sap/ui/core/Control','./library',"./ContentSwitcherRenderer","sap/base/Log"],function(C,l,a,L){"use strict";var b=l.ContentSwitcherAnimation;
var c=C.extend("sap.ui.unified.ContentSwitcher",{metadata:{deprecated:true,library:"sap.ui.unified",properties:{animation:{type:"string",group:"Appearance",defaultValue:'None'},activeContent:{type:"int",group:"Behavior",defaultValue:1}},aggregations:{content1:{type:"sap.ui.core.Control",multiple:true,singularName:"content1"},content2:{type:"sap.ui.core.Control",multiple:true,singularName:"content2"}}}});
(function(w){
c.prototype.init=function(){};
c.prototype.switchContent=function(){this.setActiveContent(this.getActiveContent()==1?2:1);return this;};
c.prototype.onAfterRendering=function(){this._$Contents=[this.$("content1"),this.$("content2")];};
c.prototype._showActiveContent=function(n){if(this._$Contents){this._$Contents[0].toggleClass("sapUiUfdCSwitcherVisible",n===1);this._$Contents[1].toggleClass("sapUiUfdCSwitcherVisible",n===2);}};
c.prototype.setActiveContent=function(n){n=parseInt(n);if(isNaN(n)||n<1){n=1;L.warning("setActiveContent argument must be either 1 or 2. Active content set to 1.");}else if(n>2){n=2;L.warning("setActiveContent argument must be either 1 or 2. Active content set to 2.");}this.setProperty("activeContent",n,true);this._showActiveContent(n);return this;};
c.prototype.setAnimation=function(A,s){if(typeof(A)!=="string"){A=b.None;L.warning("setAnimation argument must be a string. Animation was set to \""+b.None+"\".");}A=A.replace(/[^a-zA-Z0-9]/g,"");var d=this.getProperty("animation");if(A===d){return this;}var D=this.$();if(D[0]){D.toggleClass("sapUiUfdCSwitcherAnimation"+d,false);D.toggleClass("sapUiUfdCSwitcherAnimation"+A,true);}return this.setProperty("animation",A,s);};
})(window);return c;});
sap.ui.predefine('sap/ui/unified/ContentSwitcherRenderer',['sap/ui/unified/library',"sap/base/security/encodeXML"],function(l,e){"use strict";var C=l.ContentSwitcherAnimation;var a={};
a.render=function(r,c){var i=c.getId();var A=c.getAnimation();if(!sap.ui.getCore().getConfiguration().getAnimation()){A=C.None;}var b=c.getActiveContent();r.write("<div");r.writeControlData(c);r.addClass("sapUiUfdCSwitcher");r.addClass("sapUiUfdCSwitcherAnimation"+e(A));r.writeClasses();r.write(">");r.write("<section id=\""+i+"-content1\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent1"+(b==1?" sapUiUfdCSwitcherVisible":"")+"\">");this.renderContent(r,c.getContent1());r.write("</section>");r.write("<section id=\""+i+"-content2\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent2"+(b==2?" sapUiUfdCSwitcherVisible":"")+"\">");this.renderContent(r,c.getContent2());r.write("</section>");r.write("</div>");};
a.renderContent=function(r,c){for(var i=0;i<c.length;++i){r.renderControl(c[i]);}};
return a;},true);
sap.ui.predefine('sap/ui/unified/Currency',['sap/ui/core/Control','sap/ui/core/format/NumberFormat',"./CurrencyRenderer","sap/ui/thirdparty/jquery"],function(C,N,a,q){"use strict";
var b=C.extend("sap.ui.unified.Currency",{metadata:{library:"sap.ui.unified",properties:{value:{type:"float",group:"Appearance",defaultValue:0},stringValue:{type:"string",group:"Appearance",defaultValue:null},currency:{type:"string",group:"Appearance",defaultValue:null},maxPrecision:{type:"int",group:"Appearance",defaultValue:3},useSymbol:{type:"boolean",group:"Appearance",defaultValue:true}},designtime:"sap/ui/unified/designtime/Currency.designtime",dnd:{draggable:true,droppable:false}}});
b.FIGURE_SPACE='\u2007';b.PUNCTUATION_SPACE='\u2008';
b.prototype.init=function(){this._oFormat=N.getCurrencyInstance({showMeasure:false});};
b.prototype.exit=function(){this._oFormat=null;this._$Value=null;this._$Currency=null;this._sLastCurrency=null;this._iLastCurrencyDigits=null;this._bRenderNoValClass=null;};
b.prototype.onAfterRendering=function(){if(this.$()){this._$Value=this.$().find(".sapUiUfdCurrencyValue");this._$Currency=this.$().find(".sapUiUfdCurrencyCurrency");}};
b.prototype.setValue=function(v){if(this.isBound("value")){this._bRenderNoValClass=v==null;if(this.$()){this.$().toggleClass("sapUiUfdCurrencyNoVal",this._bRenderNoValClass);}}this.setProperty("value",v,true);this._renderValue();return this;};
b.prototype.unbindProperty=function(p){C.prototype.unbindProperty.apply(this,arguments);if(p==="value"){this._bRenderNoValClass=false;if(this.$()){this.$().toggleClass("sapUiUfdCurrencyNoVal",false);}}};
b.prototype.setCurrency=function(v){var c,r;this.setProperty("currency",v,true);this._renderCurrency();c=this._oFormat.oLocaleData.getCurrencyDigits(v);if(q.isNumeric(this._iLastCurrencyDigits)&&this._iLastCurrencyDigits!==c){r=true;}this._iLastCurrencyDigits=c;if(this._sLastCurrency==="*"||v==="*"){r=true;}this._sLastCurrency=v;if(r){this._renderValue();if(v==="*"&&this.$()){this._bRenderNoValClass=false;this.$().toggleClass("sapUiUfdCurrencyNoVal",false);}}return this;};
b.prototype.setUseSymbol=function(v){this.setProperty("useSymbol",v,true);this._renderCurrency();return this;};
b.prototype.setMaxPrecision=function(v){this.setProperty("maxPrecision",v,true);this._renderValue();return this;};
b.prototype._renderValue=function(){if(this._$Value){this._$Value.text(this.getFormattedValue());}};
b.prototype._renderCurrency=function(){if(this._$Currency){this._$Currency.text(this._getCurrency());}};
b.prototype._getCurrency=function(){return this.getUseSymbol()?this.getCurrencySymbol():this.getCurrency();};
b.prototype.getFormattedValue=function(){var c=this.getCurrency(),m,p,i,f;if(c==="*"){return"";}i=this._oFormat.oLocaleData.getCurrencyDigits(c);m=this.getMaxPrecision();m=(m<=0&&i>0?m-1:m);p=m-i;f=this._oFormat.format(this.getStringValue()||this.getValue(),c);if(p==m&&m>0){f+=b.PUNCTUATION_SPACE;}if(p>0){f=f.padEnd(f.length+p,b.FIGURE_SPACE);}else if(p<0){f=f.substr(0,f.length+p);}return f;};
b.prototype.getCurrencySymbol=function(){return this._oFormat.oLocaleData.getCurrencySymbol(this.getCurrency());};
b.prototype.getAccessibilityInfo=function(){if(this._bRenderNoValClass){return{};}return{description:(this.getFormattedValue()||"")+" "+(this.getCurrency()||"").trim()};};
return b;});
sap.ui.predefine('sap/ui/unified/CurrencyRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){var t=c.getTooltip_AsString();r.write("<div");r.writeControlData(c);if(t){r.writeAttributeEscaped("title",t);}r.addClass("sapUiUfdCurrency");if(c._bRenderNoValClass){r.addClass("sapUiUfdCurrencyNoVal");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiUfdCurrencyAlign");r.writeClasses();r.write(">");r.write("<span");r.writeAttribute("dir","ltr");r.addClass("sapUiUfdCurrencyValue");r.writeClasses();r.write(">");r.writeEscaped(c.getFormattedValue());r.write("</span>");r.write("<span");r.addClass("sapUiUfdCurrencyCurrency");r.writeClasses();r.write(">");r.writeEscaped(c._getCurrency());r.write("</span>");r.write("</div>");r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/DateRange',['sap/ui/core/Element','./library','sap/ui/unified/calendar/CalendarUtils'],function(E,l,C){"use strict";
var D=E.extend("sap.ui.unified.DateRange",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Misc",defaultValue:null},endDate:{type:"object",group:"Misc",defaultValue:null}}}});
D.prototype.setStartDate=function(d){if(d){C._checkJSDateObject(d);var y=d.getFullYear();C._checkYearInValidRange(y);}this.setProperty("startDate",d);return this;};
D.prototype.setEndDate=function(d){if(d){C._checkJSDateObject(d);var y=d.getFullYear();C._checkYearInValidRange(y);}this.setProperty("endDate",d);return this;};
return D;});
sap.ui.predefine('sap/ui/unified/DateTypeRange',['./DateRange','./library'],function(D,l){"use strict";var C=l.CalendarDayType;
var a=D.extend("sap.ui.unified.DateTypeRange",{metadata:{library:"sap.ui.unified",properties:{type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:C.Type01}}}});
return a;});
sap.ui.predefine('sap/ui/unified/FileUploader',['sap/ui/core/Control','./library','sap/ui/core/LabelEnablement','sap/ui/core/library','sap/ui/Device','./FileUploaderRenderer','sap/ui/dom/containsOrEquals','sap/ui/events/KeyCodes','sap/base/Log','sap/base/security/encodeXML',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/Aria'],function(C,a,L,c,D,F,b,K,d,f,q){"use strict";var V=c.ValueState;
var g=C.extend("sap.ui.unified.FileUploader",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.unified.IProcessableBlobs"],library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/FileUploader.designtime",properties:{value:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"sap.ui.core.URI",group:"Data",defaultValue:''},name:{type:"string",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:''},uploadOnChange:{type:"boolean",group:"Behavior",defaultValue:false},additionalData:{type:"string",group:"Data",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},buttonText:{type:"string",group:"Misc",defaultValue:null},fileType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},sendXHR:{type:"boolean",group:"Behavior",defaultValue:false},placeholder:{type:"string",group:"Appearance",defaultValue:null},style:{type:"string",group:"Appearance",defaultValue:null},buttonOnly:{type:"boolean",group:"Appearance",defaultValue:false},useMultipart:{type:"boolean",group:"Behavior",defaultValue:true},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconHovered:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconSelected:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},iconOnly:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{parameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"parameter"},headerParameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"headerParameter"},xhrSettings:{type:"sap.ui.unified.FileUploaderXHRSettings",multiple:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{newValue:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{fileName:{type:"string"},response:{type:"string"},readyStateXHR:{type:"string"},status:{type:"string"},responseRaw:{type:"string"},headers:{type:"object"},requestHeaders:{type:"object[]"}}},typeMissmatch:{parameters:{fileName:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"}}},fileSizeExceed:{parameters:{fileName:{type:"string"},fileSize:{type:"string"}}},fileAllowed:{},uploadProgress:{parameters:{lengthComputable:{type:"boolean"},loaded:{type:"float"},total:{type:"float"},fileName:{type:"string"},requestHeaders:{type:"object[]"}}},uploadAborted:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}},filenameLengthExceed:{parameters:{fileName:{type:"string"}}},uploadStart:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}}}}});
g.prototype.init=function(){var t=this;this.oFilePath=a.FileUploaderHelper.createTextField(this.getId()+"-fu_input").addEventDelegate({onAfterRendering:function(){if(t.getWidth()){t._resizeDomElements();}}});this.oBrowse=a.FileUploaderHelper.createButton();this.oFilePath.setParent(this);this.oBrowse.setParent(this);this.oFileUpload=null;this.bMobileLib=this.oBrowse.getMetadata().getName()=="sap.m.Button";if(!this.getIconOnly()){this.oBrowse.setText(this.getBrowseText());}else{this.oBrowse.setTooltip(this.getBrowseText());}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(!g.prototype._sAccText){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");g.prototype._sAccText=r.getText("FILEUPLOAD_ACC");}if(this.oBrowse.addAriaDescribedBy){this.oBrowse.addAriaDescribedBy(this.getId()+"-AccDescr");}}};
g.prototype.setButtonText=function(t){this.setProperty("buttonText",t,false);if(!this.getIconOnly()){this.oBrowse.setText(t||this.getBrowseText());}else{this.oBrowse.setTooltip(t||this.getBrowseText());}return this;};
g.prototype.setIcon=function(i){this.oBrowse.setIcon(i);this.setProperty("icon",i,false);return this;};
g.prototype.setIconHovered=function(i){this.setProperty("iconHovered",i,false);if(this.oBrowse.setIconHovered){this.oBrowse.setIconHovered(i);}return this;};
g.prototype.setIconSelected=function(i){this.setProperty("iconSelected",i,false);if(this.oBrowse.setIconSelected){this.oBrowse.setIconSelected(i);}else{this.oBrowse.setActiveIcon(i);}return this;};
g.prototype.setIconFirst=function(i){this.oBrowse.setIconFirst(i);this.setProperty("iconFirst",i,false);return this;};
g.prototype.setIconOnly=function(i){this.setProperty("iconOnly",i,false);if(i){this.oBrowse.setText("");this.oBrowse.setTooltip(this.getButtonText()||this.getBrowseText());}else{this.oBrowse.setText(this.getButtonText()||this.getBrowseText());this.oBrowse.setTooltip("");}return this;};
g.prototype.getIdForLabel=function(){return this.oBrowse.getId();};
g.prototype._ensureBackwardsReference=function(){var i=this.oBrowse,I=i.getAriaLabelledBy(),r=L.getReferencingLabels(this);if(I){r.forEach(function(l){if(I.indexOf(l)===-1){i.addAriaLabelledBy(l);}});}return this;};
g.prototype.setFileType=function(t){var T=this._convertTypesToArray(t);this.setProperty("fileType",T,false);return this;};
g.prototype.setMimeType=function(t){var T=this._convertTypesToArray(t);this.setProperty("mimeType",T,false);return this;};
g.prototype.setTooltip=function(t){var T,s;this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);this._updateAccDescription();if(this.oFileUpload){T=this.getTooltip_AsString();s=this.$().find(".sapUiFupInputMask")[0];if(T){this.oFileUpload.setAttribute("title",T);s&&s.setAttribute("title",T);}else{this.oFileUpload.removeAttribute("title");s&&s.removeAttribute("title");}}return this;};
g.prototype._generateAccDescriptionText=function(){var t=this.getTooltip_AsString(),p=this.getPlaceholder(),v=this.getValue(),A="";if(t){A+=t+" ";}if(v){A+=v+" ";}else if(p){A+=p+" ";}A+=this._sAccText;return A;};
g.prototype._updateAccDescription=function(){var A=document.getElementById(this.getId()+"-AccDescr"),n=this._generateAccDescriptionText();if(A){A.innerHTML=f(n);}};
g.prototype.setXhrSettings=function(x){this.setAggregation("xhrSettings",x,true);return this;};
g.prototype._convertTypesToArray=function(t){if(typeof t==="string"){if(t===""){return[];}else{return t.split(",").map(function(T){return T.trim();});}}return t;};
g.prototype.exit=function(){this.oFilePath.destroy();this.oBrowse.destroy();if(this.oIFrameRef){q(this.oIFrameRef).unbind();sap.ui.getCore().getStaticAreaRef().removeChild(this.oIFrameRef);this.oIFrameRef=null;}};
g.prototype.onBeforeRendering=function(){var s=sap.ui.getCore().getStaticAreaRef();q(this.oFileUpload).appendTo(s);q(this.oFileUpload).unbind();};
g.prototype.onAfterRendering=function(){this.prepareFileUploadAndIFrame();this._cacheDOMEls();this._addLabelFeaturesToBrowse();q(this.oFileUpload).change(q.proxy(this.handlechange,this));if(!this.bMobileLib){this.oFilePath.$().attr("tabindex","-1");}else{this.oFilePath.$().find('input').attr("tabindex","-1");}if((!!D.browser.internet_explorer&&D.browser.version==9)){this.oBrowse.$().attr("tabindex","-1");}if(L.isRequired(this)){this.oBrowse.$().attr("aria-required","true");}setTimeout(this._recalculateWidth.bind(this),0);this.oFilePath.$().find('input').removeAttr("role").attr("aria-live","polite");if(this.getValueState()==V.Error){this.oBrowse.$().attr("aria-invalid","true");}};
g.prototype._cacheDOMEls=function(){this.FUEl=this.getDomRef("fu");this.FUDataEl=this.getDomRef("fu_data");};
g.prototype.onfocusin=function(e){if(!this.oFilePath.shouldValueStateMessageBeOpened||this.oFilePath.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
g.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!b(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){this.closeValueStateMessage();}};
g.prototype._recalculateWidth=function(){if(this.getWidth()){if(this.getButtonOnly()&&this.oBrowse.getDomRef()){this.oBrowse.getDomRef().style.width=this.getWidth();}this._resizeDomElements();}};
g.prototype.getFocusDomRef=function(){return this.$("fu").get(0);};
g.prototype._resizeDomElements=function(){var i=this.getId();this._oBrowseDomRef=this.oBrowse.getDomRef();var $=q(this._oBrowseDomRef);var _=$.parent().outerWidth(true);this._oFilePathDomRef=this.oFilePath.getDomRef();var o=this._oFilePathDomRef;var w=this.getWidth();if(w.substr(-1)=="%"&&o){while(o.id!=i){o.style.width="100%";o=o.parentNode;}o.style.width=w;}else{if(o){o.style.width=w;var e=q(this._oFilePathDomRef);var h=e.outerWidth()-_;if(h<0){this.oFilePath.getDomRef().style.width="0px";if(this.oFileUpload&&!D.browser.internet_explorer){this.oFileUpload.style.width=$.outerWidth(true);}}else{this.oFilePath.getDomRef().style.width=h+"px";}}}};
g.prototype.onresize=function(){this._recalculateWidth();};
g.prototype.onThemeChanged=function(){this._recalculateWidth();};
g.prototype.setEnabled=function(e){var $=q(this.oFileUpload);this.setProperty("enabled",e,true);this.oFilePath.setEnabled(e);this.oBrowse.setEnabled(e);e?$.removeAttr('disabled'):$.attr('disabled','disabled');this.$().toggleClass("sapUiFupDisabled",!e);return this;};
g.prototype.setValueState=function(v){this.setProperty("valueState",v,true);if(this.oFilePath.setValueState){this.oFilePath.setValueState(v);}else{d.warning("Setting the valueState property with the combination of libraries used is not supported.",this);}if(this.oBrowse.getDomRef()){if(v==V.Error){this.oBrowse.$().attr("aria-invalid","true");}else{this.oBrowse.$().removeAttr("aria-invalid");}}if(b(this.getDomRef(),document.activeElement)){switch(v){case V.Error:case V.Warning:case V.Success:this.openValueStateMessage();break;default:this.closeValueStateMessage();}}return this;};
g.prototype.setValueStateText=function(v){if(this.oFilePath.setValueStateText){this.oFilePath.setValueStateText(v);}else{d.warning("Setting the valueStateText property with the combination of libraries used is not supported.",this);}return this.setProperty("valueStateText",v,true);};
g.prototype.setUploadUrl=function(v,e){this.setProperty("uploadUrl",v,true);var $=this.$("fu_form");$.attr("action",this.getUploadUrl());return this;};
g.prototype.setPlaceholder=function(p){this.setProperty("placeholder",p,true);this.oFilePath.setPlaceholder(p);this._updateAccDescription();return this;};
g.prototype.setStyle=function(s){this.setProperty("style",s,true);if(s){if(s=="Transparent"){if(this.oBrowse.setLite){this.oBrowse.setLite(true);}else{this.oBrowse.setType("Transparent");}}else{if(this.oBrowse.setType){this.oBrowse.setType(s);}else{if(s=="Emphasized"){s="Emph";}this.oBrowse.setStyle(s);}}}return this;};
g.prototype.setValue=function(v,e,s){var o=this.getValue();var h;if((o!=v)||this.getSameFilenameAllowed()){var u=this.getUploadOnChange()&&v;this.setProperty("value",v,u);if(this.oFilePath){this.oFilePath.setValue(v);if(this.oBrowse.getDomRef()&&!s&&b(this.getDomRef(),document.activeElement)){this.oBrowse.focus();}}var i=this.getDomRef("fu_form"),j=this.getDomRef("fu_input-inner");if(this.oFileUpload&&i&&!v){i.reset();this.getDomRef("fu_input").value="";if(j){j.value="";}q(this.FUDataEl).val(this.getAdditionalData());}if(e){if(window.File){h=this.FUEl.files;}if(!this.getSameFilenameAllowed()||v){this.fireChange({id:this.getId(),newValue:v,files:h});}}if(u){this.upload();}}return this;};
g.prototype.clear=function(){var u=this.getDomRef("fu_form");if(u){u.reset();}return this.setValue("",false,true);};
g.prototype.onmousedown=function(e){if(!this.bMobileLib){this.oBrowse.onmousedown(e);}};
g.prototype.onmouseup=function(e){if(!this.bMobileLib){this.oBrowse.onmouseup(e);}};
g.prototype.onmouseover=function(e){if(!this.bMobileLib){q(this.oBrowse.getDomRef()).addClass('sapUiBtnStdHover');this.oBrowse.onmouseover(e);}};
g.prototype.onmouseout=function(e){if(!this.bMobileLib){q(this.oBrowse.getDomRef()).removeClass('sapUiBtnStdHover');this.oBrowse.onmouseout(e);}};
g.prototype.setAdditionalData=function(A){this.setProperty("additionalData",A,true);var o=this.FUDataEl;if(o){A=this.getAdditionalData()||"";o.value=A;}return this;};
g.prototype.sendFiles=function(x,I){var t=this;var A=true;for(var i=0;i<x.length;i++){if(!x[i].bPosted){A=false;break;}}if(A){if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){t.setValue("",true);}return;}var X=x[I];var s=X.file.name?X.file.name:"MultipartFile";if((D.browser.edge||D.browser.internet_explorer)&&X.file.type&&X.xhr.readyState==1){var e=X.file.type;X.xhr.setRequestHeader("Content-Type",e);X.requestHeaders.push({name:"Content-Type",value:e});}var r=X.requestHeaders;var p=function(P){var o={lengthComputable:!!P.lengthComputable,loaded:P.loaded,total:P.total};t.fireUploadProgress({"lengthComputable":o.lengthComputable,"loaded":o.loaded,"total":o.total,"fileName":s,"requestHeaders":r});};X.xhr.upload.addEventListener("progress",p);X.xhr.onreadystatechange=function(){var R;var h;var H={};var P;var j;var k;var l;l=X.xhr.readyState;var S=X.xhr.status;if(X.xhr.readyState==4){if(X.xhr.responseXML){R=X.xhr.responseXML.documentElement.textContent;}h=X.xhr.response;P=X.xhr.getAllResponseHeaders();if(P){j=P.split("\u000d\u000a");for(var i=0;i<j.length;i++){if(j[i]){k=j[i].indexOf("\u003a\u0020");H[j[i].substring(0,k)]=j[i].substring(k+2);}}}t.fireUploadComplete({"fileName":s,"headers":H,"response":R,"responseRaw":h,"readyStateXHR":l,"status":S,"requestHeaders":r});}t._bUploading=false;};if(X.xhr.readyState===0||X.bPosted){I++;t.sendFiles(x,I);}else{X.xhr.send(X.file);X.bPosted=true;I++;t.sendFiles(x,I);}};
g.prototype.upload=function(p){if(!this.getEnabled()){return;}var u=this.getDomRef("fu_form");try{this._bUploading=true;if(this.getSendXHR()&&window.File){var e=this.FUEl.files;if(p){this._sendProcessedFilesWithXHR(e);}else{this._sendFilesWithXHR(e);}}else if(u){u.submit();this._resetValueAfterUploadStart();}}catch(E){d.error("File upload failed:\n"+E.message);}};
g.prototype.abort=function(h,H){if(!this.getUseMultipart()){var s=this._aXhr.length-1;for(var i=s;i>-1;i--){if(h&&H){for(var j=0;j<this._aXhr[i].requestHeaders.length;j++){var e=this._aXhr[i].requestHeaders[j].name;var v=this._aXhr[i].requestHeaders[j].value;if(e==h&&v==H){this._aXhr[i].xhr.abort();this.fireUploadAborted({"fileName":this._aXhr[i].fileName,"requestHeaders":this._aXhr[i].requestHeaders});this._aXhr.splice(i,1);d.info("File upload aborted.");break;}}}else{this._aXhr[i].xhr.abort();this.fireUploadAborted({"fileName":this._aXhr[i].fileName,"requestHeaders":this._aXhr[i].requestHeaders});this._aXhr.splice(i,1);d.info("File upload aborted.");}}}else if(this._uploadXHR&&this._uploadXHR.abort){this._uploadXHR.abort();this.fireUploadAborted({"fileName":null,"requestHeaders":null});d.info("File upload aborted.");}};
g.prototype.onkeypress=function(e){this.onkeydown(e);};
g.prototype.onclick=function(e){if(this.getSameFilenameAllowed()&&this.getEnabled()){this.setValue("",true);}if(this.oBrowse.getDomRef()&&b(this.getDomRef(),document.activeElement)){this.oBrowse.focus();}};
g.prototype.onkeydown=function(e){if(!this.getEnabled()){return;}if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){this.setValue("",true);}var k=e.keyCode,h=K;if(k==h.DELETE||k==h.BACKSPACE){if(this.oFileUpload){this.setValue("",true);}}else if(k==h.SPACE||k==h.ENTER){if(!(!!D.browser.internet_explorer&&D.browser.version<=9)&&this.oFileUpload){this.oFileUpload.click();e.preventDefault();e.stopPropagation();}}else if(k!=h.TAB&&k!=h.SHIFT&&k!=h.F6&&k!=h.PAGE_UP&&k!=h.PAGE_DOWN&&k!=h.ESCAPE&&k!=h.END&&k!=h.HOME&&k!=h.ARROW_LEFT&&k!=h.ARROW_UP&&k!=h.ARROW_RIGHT&&k!=h.ARROW_DOWN){e.preventDefault();e.stopPropagation();}};
g.prototype._isFilenameTooLong=function(s){var m=this.getMaximumFilenameLength();if(m!==0&&s.length>m){d.info("The filename of "+s+" ("+s.length+" characters)  is longer than the maximum of "+m+" characters.");return true;}return false;};
g.prototype.handlechange=function(e){if(this.oFileUpload&&this.getEnabled()){var h=this.getFileType();var s='';var w,n,i,j;var u=this.getDomRef("fu_form");if(window.File){var k=e.target.files;if(this._areFilesAllowed(k)){this.fireFileAllowed();s=this._generateInputValue(k);}else{u.reset();this.setValue("",true,true);return;}}else if(h&&h.length>0){w=true;n=this.oFileUpload.value||"";i=n.lastIndexOf(".");j=(i===-1)?"":n.substring(i+1);for(var l=0;l<h.length;l++){if(j==h[l]){w=false;}}if(w){d.info("File: "+n+" is of type "+j+". Allowed types are: "+h+".");this.fireTypeMissmatch({fileName:n,fileType:j});u.reset();this.setValue("",true,true);return;}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});u.reset();this.setValue("",true,true);return;}if(n){this.fireFileAllowed();}}var v=this.oFileUpload.value||"";var I=v.lastIndexOf("\\");if(I>=0){v=v.substring(I+1);}if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){v=s;}}if(v||D.browser.chrome){this.setValue(v,true);}}};
g.prototype._sendFilesWithXHR=function(e){var h,H,v,x,X=this.getXhrSettings();if(e.length>0){if(this.getUseMultipart()){h=1;}else{h=e.length;}this._aXhr=this._aXhr||[];for(var j=0;j<h;j++){this._uploadXHR=new window.XMLHttpRequest();x={xhr:this._uploadXHR,requestHeaders:[]};this._aXhr.push(x);x.xhr.open("POST",this.getUploadUrl(),true);if(X){x.xhr.withCredentials=X.getWithCredentials();}if(this.getHeaderParameters()){var n=this.getHeaderParameters();for(var i=0;i<n.length;i++){H=n[i].getName();v=n[i].getValue();x.requestHeaders.push({name:H,value:v});}}var s=e[j].name;var r=x.requestHeaders;x.fileName=s;x.file=e[j];this.fireUploadStart({"fileName":s,"requestHeaders":r});for(var k=0;k<r.length;k++){if(x.xhr.readyState===0){break;}H=r[k].name;v=r[k].value;x.xhr.setRequestHeader(H,v);}}if(this.getUseMultipart()){var o=new window.FormData();var p=this.FUEl.name;for(var l=0;l<e.length;l++){this._appendFileToFormData(o,p,e[l]);}o.append("_charset_","UTF-8");var t=this.FUDataEl.name;if(this.getAdditionalData()){var u=this.getAdditionalData();o.append(t,u);}else{o.append(t,"");}if(this.getParameters()){var P=this.getParameters();for(var m=0;m<P.length;m++){var N=P[m].getName();v=P[m].getValue();o.append(N,v);}}x.file=o;this.sendFiles(this._aXhr,0);}else{this.sendFiles(this._aXhr,0);}this._bUploading=false;this._resetValueAfterUploadStart();}return this;};
g.prototype._appendFileToFormData=function(o,s,e){if(e instanceof window.Blob&&e.name){o.append(s,e,e.name);}else{o.append(s,e);}};
g.prototype._sendProcessedFilesWithXHR=function(e){this.getProcessedBlobsFromArray(e).then(function(B){this._sendFilesWithXHR(B);}.bind(this)).catch(function(r){d.error("File upload failed: "+r&&r.message?r.message:"no details available");});return this;};
g.prototype._areFilesAllowed=function(e){var n,w,I,s,t,m=this.getMaximumFileSize(),M=this.getMimeType(),h=this.getFileType();for(var i=0;i<e.length;i++){n=e[i].name;t=e[i].type;if(!t){t="unknown";}var S=((e[i].size/1024)/1024);if(m&&(S>m)){d.info("File: "+n+" is of size "+S+" MB which exceeds the file size limit of "+m+" MB.");this.fireFileSizeExceed({fileName:n,fileSize:S});return false;}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});return false;}if(M&&M.length>0){var W=true;for(var j=0;j<M.length;j++){if(t==M[j]||M[j]=="*/*"||t.match(M[j])){W=false;}}if(W&&!(t==="unknown"&&(D.browser.edge||D.browser.msie))){d.info("File: "+n+" is of type "+t+". Allowed types are: "+M+".");this.fireTypeMissmatch({fileName:n,mimeType:t});return false;}}if(h&&h.length>0){w=true;I=n.lastIndexOf(".");s=(I===-1)?"":n.substring(I+1);for(var k=0;k<h.length;k++){if(s.toLowerCase()==h[k].toLowerCase()){w=false;}}if(w){d.info("File: "+n+" is of type "+s+". Allowed types are: "+h+".");this.fireTypeMissmatch({fileName:n,fileType:s});return false;}}}return true;};
g.prototype._sendFilesFromDragAndDrop=function(e){if(this._areFilesAllowed(e)){this._sendFilesWithXHR(e);}return this;};
g.prototype._generateInputValue=function(e){var s="";for(var i=0;i<e.length;i++){s=s+'"'+e[i].name+'" ';}return s;};
g.prototype.getBrowseText=function(){if(!g.prototype._sBrowseText){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");g.prototype._sBrowseText=r.getText("FILEUPLOAD_BROWSE");}return g.prototype._sBrowseText?g.prototype._sBrowseText:"Browse...";};
g.prototype.getShortenValue=function(){return this.getValue();};
g.prototype.prepareFileUploadAndIFrame=function(){if(!this.oFileUpload){var e=[];e.push('<input ');e.push('type="file" ');e.push('aria-hidden="true" ');if(this.getName()){if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){e.push('name="'+f(this.getName())+'[]" ');}}else{e.push('name="'+f(this.getName())+'" ');}}else{if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){e.push('name="'+this.getId()+'[]" ');}}else{e.push('name="'+this.getId()+'" ');}}e.push('id="'+this.getId()+'-fu" ');if(!(!!D.browser.internet_explorer&&D.browser.version==9)){e.push('tabindex="-1" ');}e.push('size="1" ');if(this.getTooltip_AsString()){e.push('title="'+f(this.getTooltip_AsString())+'" ');}else if(this.getValue()!==""){e.push('title="'+f(this.getValue())+'" ');}if(!this.getEnabled()){e.push('disabled="disabled" ');}if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){e.push('multiple ');}}if((this.getMimeType()||this.getFileType())&&window.File){var m=this.getMimeType()||[];var h=this.getFileType()||[];h=h.map(function(j){return j.indexOf(".")===0?j:"."+j;});var A=h.concat(m).join(",");e.push('accept="'+f(A)+'" ');}e.push('>');this.oFileUpload=q(e.join("")).prependTo(this.$().find(".sapUiFupInputMask")).get(0);}else{q(this.oFileUpload).prependTo(this.$().find(".sapUiFupInputMask"));}if(!this.oIFrameRef){var i=document.createElement("iframe");i.style.display="none";i.id=this.sId+"-frame";sap.ui.getCore().getStaticAreaRef().appendChild(i);i.contentWindow.name=this.sId+"-frame";var t=this;this._bUploading=false;q(i).load(function(E){if(t._bUploading){d.info("File uploaded to "+t.getUploadUrl());var r;try{r=t.oIFrameRef.contentWindow.document.body.innerHTML;}catch(j){}t.fireUploadComplete({"response":r});t._bUploading=false;}});this.oIFrameRef=i;}};
g.prototype.openValueStateMessage=function(){if(this.oFilePath.openValueStateMessage){this.oFilePath.openValueStateMessage();this.oBrowse.$().addAriaDescribedBy(this.oFilePath.getId()+"-message");}};
g.prototype.closeValueStateMessage=function(){if(this.oFilePath.closeValueStateMessage){this.oFilePath.closeValueStateMessage();this.oBrowse.$().removeAriaDescribedBy(this.oFilePath.getId()+"-message");}};
g.prototype._resetValueAfterUploadStart=function(){d.info("File uploading to "+this.getUploadUrl());if(this.getSameFilenameAllowed()&&this.getUploadOnChange()&&this.getUseMultipart()){this.setValue("",true);}};
g.prototype._addLabelFeaturesToBrowse=function(){var $;if(this.oBrowse&&this.oBrowse.$().length){$=this.oBrowse.$();$.attr("type', 'button");$.click(function(e){e.preventDefault();this.FUEl.click();}.bind(this));}};
g.prototype.getProcessedBlobsFromArray=function(B){return new Promise(function(r){r(B);});};
return g;});
sap.ui.predefine('sap/ui/unified/FileUploaderParameter',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var F=E.extend("sap.ui.unified.FileUploaderParameter",{metadata:{library:"sap.ui.unified",properties:{name:{type:"string",group:"Data",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}}}});
return F;});
sap.ui.predefine('sap/ui/unified/FileUploaderRenderer',['sap/ui/unified/library',"sap/ui/thirdparty/jquery"],function(l,q){"use strict";var F=function(){};
F.render=function(r,f){var e=f.getEnabled(),t=f.getTooltip_AsString();r.write('<div');r.writeControlData(f);r.addClass("sapUiFup");if(f.getButtonOnly()){r.addClass("sapUiFupButtonOnly");}var c=l.FileUploaderHelper.addFormClass();if(c){r.addClass(c);}if(!e){r.addClass("sapUiFupDisabled");}r.writeClasses();r.write('>');r.write('<form style="display:inline-block" enctype="multipart/form-data" method="post"');r.writeAttribute('id',f.getId()+'-fu_form');r.writeAttributeEscaped('action',f.getUploadUrl());r.writeAttribute('target',f.getId()+'-frame');r.write('>');r.write('<div ');if(!f.bMobileLib){r.write('class="sapUiFupInp"');}r.write('>');if(!f.getButtonOnly()){r.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div>');}else{r.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div style="display:none">');}r.renderControl(f.oFilePath);r.write('</div><div>');f._ensureBackwardsReference();r.renderControl(f.oBrowse);r.write('<span id="'+f.getId()+'-AccDescr" class="sapUiInvisibleText" aria-hidden="true">');r.writeEscaped(f._generateAccDescriptionText());r.write('</span>');r.write('</div></div></div>');var n=f.getName()||f.getId();r.write('<div class="sapUiFupInputMask"');if(t&&t.length){r.writeAttributeEscaped('title',t);}r.write('>');r.write('<input type="hidden" name="_charset_" aria-hidden="true">');r.write('<input type="hidden" id="'+f.getId()+'-fu_data" aria-hidden="true"');r.writeAttributeEscaped('name',n+'-data');r.writeAttributeEscaped('value',f.getAdditionalData()||"");r.write('>');q.each(f.getParameters(),function(i,p){r.write('<input type="hidden" aria-hidden="true" ');r.writeAttributeEscaped('name',p.getName()||"");r.writeAttributeEscaped('value',p.getValue()||"");r.write('>');});r.write('</div>');r.write('</div>');r.write('</form>');r.write('</div>');};
return F;},true);
sap.ui.predefine('sap/ui/unified/FileUploaderXHRSettings',['sap/ui/core/Element','./library'],function(E){"use strict";
var F=E.extend("sap.ui.unified.FileUploaderXHRSettings",{metadata:{library:"sap.ui.unified",properties:{withCredentials:{type:"boolean",group:"Data",defaultValue:false}}}});
return F;});
sap.ui.predefine('sap/ui/unified/Menu',['sap/ui/core/Element','sap/ui/core/Control','sap/ui/Device','sap/ui/core/Popup','./MenuItemBase','./library','sap/ui/core/library','sap/ui/unified/MenuRenderer',"sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/events/ControlEvents","sap/ui/events/PseudoEvents","sap/ui/events/checkMouseEnterOrLeave"],function(E,C,D,P,M,l,c,a,b,q,K,L,d,f,g){"use strict";var h=P.Dock;var O=c.OpenState;
var j=C.extend("sap.ui.unified.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},ariaDescription:{type:"string",group:"Accessibility",defaultValue:null},maxVisibleItems:{type:"int",group:"Behavior",defaultValue:0},pageSize:{type:"int",group:"Behavior",defaultValue:5}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.unified.MenuItemBase",multiple:true,singularName:"item"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{itemSelect:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
(function(w){j.prototype.bCozySupported=true;j._DELAY_SUBMENU_TIMER=300;j._DELAY_SUBMENU_TIMER_EXT=400;
j.prototype.init=function(){var t=this;this.bOpen=false;this.oOpenedSubMenu=null;this.oHoveredItem=null;this.oPopup=null;this._bOpenedAsContextMenu=false;this.fAnyEventHandlerProxy=q.proxy(function(e){var r=this.getRootMenu();if(r!=this||!this.bOpen||!this.getDomRef()||(e.type!="mousedown"&&e.type!="touchstart")){return;}r.handleOuterEvent(this.getId(),e);},this);this.fOrientationChangeHandler=function(){t.close();};this.bUseTopStyle=false;};
j.prototype._setCustomEnhanceAccStateFunction=function(e){this._fnCustomEnhanceAccStateFunction=e;};
j.prototype.enhanceAccessibilityState=function(e,A){var i=typeof this._fnCustomEnhanceAccStateFunction==="function";return i?this._fnCustomEnhanceAccStateFunction(e,A):A;};
j.prototype.exit=function(){if(this.oPopup){this.oPopup.detachClosed(this._menuClosed,this);this.oPopup.destroy();delete this.oPopup;}d.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).unbind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this._resetDelayedRerenderItems();this._detachResizeHandler();};
j.prototype.invalidate=function(o){if(o instanceof M&&this.getDomRef()){this._delayedRerenderItems();}else{C.prototype.invalidate.apply(this,arguments);}};
j.prototype.onBeforeRendering=function(){this._resetDelayedRerenderItems();this.$().unbind("mousemove");};
j.prototype.onAfterRendering=function(){if(this.$().parent().attr("id")!="sap-ui-static"){L.error("sap.ui.unified.Menu: The Menu is popup based and must not be rendered directly as content of the page.");this.close();this.$().remove();}var I=this.getItems();for(var i=0;i<I.length;i++){if(I[i].onAfterRendering&&I[i].getDomRef()){I[i].onAfterRendering();}}if(this.oHoveredItem){this.oHoveredItem.hover(true,this);}m(this);this.$().bind("mousemove",this._focusMenuItem.bind(this));};
j.prototype._focusMenuItem=function(e){if(!D.system.desktop){return;}var i=this.getItemByDomRef(e.target);if(!this.bOpen||!i){return;}if(this.oOpenedSubMenu&&b(this.oOpenedSubMenu.getDomRef(),e.target)){return;}this.setHoveredItem(i);i&&i.focus(this);this._openSubMenuDelayed(i);};
j.prototype.onThemeChanged=function(){if(this.getDomRef()&&this.getPopup().getOpenState()===O.OPEN){m(this);this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}};
j.prototype.setPageSize=function(S){return this.setProperty("pageSize",S,true);};
j.prototype.addItem=function(i){this.addAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.insertItem=function(i,e){this.insertAggregation("items",i,e,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.removeItem=function(i){this.removeAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return r;};
j.prototype.destroyItems=function(){this.destroyAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype._delayedRerenderItems=function(){if(!this.getDomRef()){return;}this._resetDelayedRerenderItems();this._discardOpenSubMenuDelayed();this._itemRerenderTimer=setTimeout(function(){var o=this.getDomRef();if(o){var r=sap.ui.getCore().createRenderManager();a.renderItems(r,this);r.flush(o);r.destroy();this.onAfterRendering();this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}}.bind(this),0);};
j.prototype._resetDelayedRerenderItems=function(){if(this._itemRerenderTimer){clearTimeout(this._itemRerenderTimer);delete this._itemRerenderTimer;}};
j.prototype._detachResizeHandler=function(){if(this._hasResizeListener){D.resize.detachHandler(this._handleResizeChange,this);this._hasResizeListener=false;}};
j.prototype.open=function(W,o,e,i,n,p,r){var N;if(this.bOpen){return;}s(this,true);this.oOpenerRef=o;this.bIgnoreOpenerDOMRef=false;this.getPopup().open(0,e,i,n,p||"0 0",r||"flipfit flipfit",function(t){var u=this.getPopup()._getOfDom(n);if(!u||!q(u).is(":visible")||!_(u)){this.close();}else{this.getPopup()._applyPosition(t.lastPosition);}}.bind(this));this.bOpen=true;D.resize.attachHandler(this._handleResizeChange,this);this._hasResizeListener=true;if(W||this.getRootMenu().getId()===this.getId()){N=this.getNextSelectableItem(-1);this.setHoveredItem(N);N&&N.focus(this);}d.bindAnyEvent(this.fAnyEventHandlerProxy);if(D.support.orientation&&this.getRootMenu()===this){q(w).bind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=true;}};
j.prototype._handleResizeChange=function(){this.getPopup()._applyPosition(this.getPopup()._oLastPosition);};
j.prototype.openAsContextMenu=function(e,o){var i,n,r,p,t;o=o instanceof E?o.getDomRef():o;if(e instanceof q.Event){t=q(o).offset();i=e.pageX-t.left;n=e.pageY-t.top;this._iX=e.clientX;this._iY=e.clientY;}else{i=e.offsetX||0;n=e.offsetY||0;this._iX=e.left||0;this._iY=e.top||0;}r=sap.ui.getCore().getConfiguration().getRTL();p=h;if(r){i=o.clientWidth-i;}this._bOpenedAsContextMenu=true;this.open(true,o,p.BeginTop,p.BeginTop,o,i+" "+n,'fit');};
j.prototype._handleOpened=function(){var $,W,i,e,r,B,R,n,o,p;if(!this._bOpenedAsContextMenu){return;}$=this.$();W=q(w);i=this._iX;e=this._iY;r=W.scrollLeft()+W.width();B=W.scrollTop()+W.height();R=sap.ui.getCore().getConfiguration().getRTL();n=false;o=$.width();p=$.height();if(e+p>B){e=e-p;n=true;}if(R){if((r-i)+o>r){i=r-(i+o);n=true;}else{i=r-i;n=true;}}else{if(i+o>r){i=i-o;n=true;}}this._bOpenedAsContextMenu=false;n&&this.oPopup.setPosition("begin top","begin top",W,i+" "+e,"flip");};
j.prototype.close=function(W){if(!this.bOpen||j._dbg){return;}this._discardOpenSubMenuDelayed();s(this,false);delete this._bFixed;d.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).unbind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this.bOpen=false;this.closeSubmenu();this.setHoveredItem();if(!W){this.bIgnoreOpenerDOMRef=true;}this.getPopup().close(0);this._detachResizeHandler();this._resetDelayedRerenderItems();this.$().remove();this.bOutput=false;if(this.isSubMenu()){this.getParent().getParent().oOpenedSubMenu=null;}};
j.prototype._menuClosed=function(){if(this.oOpenerRef){if(!this.bIgnoreOpenerDOMRef){try{this.oOpenerRef.focus();}catch(e){L.warning("Menu.close cannot restore the focus on opener "+this.oOpenerRef+", "+e);}}this.oOpenerRef=undefined;}};
j.prototype.onclick=function(e){this.selectItem(this.getItemByDomRef(e.target),false,!!(e.metaKey||e.ctrlKey));e.preventDefault();e.stopPropagation();};
j.prototype.onsapnext=function(e){var i,n,S=this.oHoveredItem?this.oHoveredItem.getSubmenu():undefined;if(e.keyCode!=K.ARROW_DOWN){if(S&&this.checkEnabled(this.oHoveredItem)){if(S.bOpen){n=S.getNextSelectableItem(-1);S.setHoveredItem(n);n&&n.focus(this);}else{this.openSubmenu(this.oHoveredItem,true);}}return;}if(S&&S.bOpen){this.closeSubmenu(false,true);}i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;n=this.getNextSelectableItem(i);this.setHoveredItem(n);n&&n.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsapnextmodifiers=j.prototype.onsapnext;
j.prototype.onsapprevious=function(e){var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,p=this.getPreviousSelectableItem(i),S=this.oHoveredItem?this.oHoveredItem.getSubmenu():null;if(e.keyCode!=K.ARROW_UP){if(this.isSubMenu()){this.close(true);}e.preventDefault();e.stopPropagation();return;}if(S&&S.bOpen){this.closeSubmenu(false,true);}this.setHoveredItem(p);p&&p.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsappreviousmodifiers=j.prototype.onsapprevious;
j.prototype.onsaphome=function(e){var n=this.getNextSelectableItem(-1);this.setHoveredItem(n);n&&n.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsapend=function(e){var p=this.getPreviousSelectableItem(this.getItems().length);this.setHoveredItem(p);p&&p.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsappagedown=function(e){var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,n;if(this.getPageSize()<1){this.onsapend(e);return;}i+=this.getPageSize();if(i>=this.getItems().length){this.onsapend(e);return;}n=this.getNextSelectableItem(i-1);this.setHoveredItem(n);n&&n.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsappageup=function(e){var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,p;if(this.getPageSize()<1){this.onsaphome(e);return;}i-=this.getPageSize();if(i<0){this.onsaphome(e);return;}p=this.getPreviousSelectableItem(i+1);this.setHoveredItem(p);p&&p.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsapselect=function(e){this._sapSelectOnKeyDown=true;e.preventDefault();e.stopPropagation();};
j.prototype.onkeyup=function(e){if(this.oHoveredItem&&(q(e.target).prop("tagName")!="INPUT")){var o=this.oHoveredItem.getDomRef();q(o).focus();}if(!this._sapSelectOnKeyDown){return;}else{this._sapSelectOnKeyDown=false;}if(!f.events.sapselect.fnCheck(e)){return;}this.selectItem(this.oHoveredItem,true,false);e.preventDefault();e.stopPropagation();};
j.prototype.onsapbackspace=function(e){if(q(e.target).prop("tagName")!="INPUT"){e.preventDefault();}};
j.prototype.onsapbackspacemodifiers=j.prototype.onsapbackspace;
j.prototype.onsapescape=function(e){this.close(true);e.preventDefault();e.stopPropagation();};
j.prototype.onsaptabnext=j.prototype.onsapescape;j.prototype.onsaptabprevious=j.prototype.onsapescape;
j.prototype._openSubMenuDelayed=function(i){if(!i){return;}this._discardOpenSubMenuDelayed();this._delayedSubMenuTimer=setTimeout(function(){this.checkEnabled(i)&&this.closeSubmenu(false,true);if(this.checkEnabled(i)&&i.getSubmenu()){this.setHoveredItem(i);i&&i.focus(this);this.openSubmenu(i,false,true);}}.bind(this),i.getSubmenu()&&this.checkEnabled(i)?j._DELAY_SUBMENU_TIMER:j._DELAY_SUBMENU_TIMER_EXT);};
j.prototype._discardOpenSubMenuDelayed=function(i){if(this._delayedSubMenuTimer){clearTimeout(this._delayedSubMenuTimer);this._delayedSubMenuTimer=null;}};
j.prototype.onmouseout=function(e){if(!D.system.desktop){return;}if(g(e,this.getDomRef())){if(!this.oOpenedSubMenu||!(this.oOpenedSubMenu.getParent()===this.oHoveredItem)){this.setHoveredItem(null);this.focus();}this._discardOpenSubMenuDelayed();}};
j.prototype.onsapfocusleave=function(e){if(this.oOpenedSubMenu||!this.bOpen){return;}this.getRootMenu().handleOuterEvent(this.getId(),e);};
j.prototype.handleOuterEvent=function(o,e){var i=false,t=D.support.touch||D.system.combi;this.bIgnoreOpenerDOMRef=false;if(e.type=="mousedown"||e.type=="touchstart"){if(t&&(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose"))){return;}var n=this;while(n&&!i){if(b(n.getDomRef(),e.target)){i=true;}n=n.oOpenedSubMenu;}}else if(e.type=="sapfocusleave"){if(t){return;}if(e.relatedControlId){var n=this;while(n&&!i){if((n.oOpenedSubMenu&&n.oOpenedSubMenu.getId()==e.relatedControlId)||b(n.getDomRef(),q(document.getElementById(e.relatedControlId)).get(0))){i=true;}n=n.oOpenedSubMenu;}}if(!i){this.bIgnoreOpenerDOMRef=true;}}if(!i){this.close();}};
j.prototype.getItemByDomRef=function(o){var I=this.getItems(),e=I.length;for(var i=0;i<e;i++){var n=I[i],p=n.getDomRef();if(b(p,o)){return n;}}return null;};
j.prototype.selectItem=function(i,W,e){if(!i||!(i instanceof M&&this.checkEnabled(i))){return;}var S=i.getSubmenu();if(!S){this.getRootMenu().close();}else{if(!D.system.desktop&&this.oOpenedSubMenu===S){this.closeSubmenu();}else{this.openSubmenu(i,W);}}i.fireSelect({item:i,ctrlKey:e});this.getRootMenu().fireItemSelect({item:i});};
j.prototype.isSubMenu=function(){return this.getParent()&&this.getParent().getParent&&this.getParent().getParent()instanceof j;};
j.prototype.getRootMenu=function(){var t=this;while(t.isSubMenu()){t=t.getParent().getParent();}return t;};
j.prototype.getMenuLevel=function(){var i=1;var t=this;while(t.isSubMenu()){t=t.getParent().getParent();i++;}return i;};
j.prototype.getPopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.setDurations(0,0);this.oPopup.attachClosed(this._menuClosed,this);this.oPopup.attachOpened(this._handleOpened,this);}return this.oPopup;};
j.prototype.setHoveredItem=function(i){if(this.oHoveredItem){this.oHoveredItem.hover(false,this);}if(!i){this.oHoveredItem=null;q(this.getDomRef()).removeAttr("aria-activedescendant");return;}this.oHoveredItem=i;i.hover(true,this);this._setActiveDescendant(this.oHoveredItem);this.scrollToItem(this.oHoveredItem);};
j.prototype._setActiveDescendant=function(i){if(sap.ui.getCore().getConfiguration().getAccessibility()&&i){var t=this;t.$().removeAttr("aria-activedescendant");setTimeout(function(){if(t.oHoveredItem===i){t.$().attr("aria-activedescendant",t.oHoveredItem.getId());}},10);}};
j.prototype.openSubmenu=function(i,W,e){var S=i.getSubmenu();if(!S){return;}if(this.oOpenedSubMenu&&this.oOpenedSubMenu!==S){this.closeSubmenu();}if(this.oOpenedSubMenu){this.oOpenedSubMenu._bFixed=(e&&this.oOpenedSubMenu._bFixed)||(!e&&!this.oOpenedSubMenu._bFixed);this.oOpenedSubMenu._bringToFront();}else{this.oOpenedSubMenu=S;var n=P.Dock;S.open(W,i,n.BeginTop,n.EndTop,i,"0 0");}};
j.prototype.closeSubmenu=function(i,I){if(this.oOpenedSubMenu){if(i&&this.oOpenedSubMenu._bFixed){return;}if(I){this.oOpenedSubMenu.bIgnoreOpenerDOMRef=true;}this.oOpenedSubMenu.close();this.oOpenedSubMenu=null;}};
j.prototype.scrollToItem=function(i){var o=this.getDomRef(),I=i?i.getDomRef():null;if(!I||!o){return;}var e=o.scrollTop,n=I.offsetTop,p=q(o).height(),r=q(I).height();if(e>n){o.scrollTop=n;}else if((n+r)>(e+p)){o.scrollTop=Math.ceil(n+r-p);}};
j.prototype._bringToFront=function(){q(document.getElementById(this.getPopup().getId())).mousedown();};
j.prototype.checkEnabled=function(i){return i&&i.getEnabled()&&this.getEnabled();};
j.prototype.getNextSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I+1;i<e.length;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=0;i<=I;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
j.prototype.getPreviousSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I-1;i>=0;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=e.length-1;i>=I;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
j.prototype.setRootMenuTopStyle=function(u){this.getRootMenu().bUseTopStyle=u;j.rerenderMenu(this.getRootMenu());};
j.rerenderMenu=function(o){var I=o.getItems();for(var i=0;i<I.length;i++){var S=I[i].getSubmenu();if(S){j.rerenderMenu(S);}}o.invalidate();o.rerender();};
j.prototype.focus=function(){if(this.bOpen){C.prototype.focus.apply(this,arguments);this._setActiveDescendant(this.oHoveredItem);}};
j.prototype.isCozy=function(){if(!this.bCozySupported){return false;}if(this.hasStyleClass("sapUiSizeCozy")){return true;}if(k(this.oOpenerRef)){return true;}if(k(this.getParent())){return true;}return false;};
function k(r){if(!r){return false;}r=r.$?r.$():q(r);return r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy").hasClass("sapUiSizeCozy");}
function s(o,e){var p=o.getParent();if(p&&p instanceof M){p.onSubmenuToggle(e);}}
function m(o){var e=o.getMaxVisibleItems(),n=document.documentElement.clientHeight-10,$=o.$();if(e>0){var I=o.getItems();for(var i=0;i<I.length;i++){if(I[i].getDomRef()){n=Math.min(n,I[i].$().outerHeight(true)*e);break;}}}if($.outerHeight(true)>n){$.css("max-height",n+"px").toggleClass("sapUiMnuScroll",true);}else{$.css("max-height","").toggleClass("sapUiMnuScroll",false);}}
function _(o){var r;if(!o){return false;}if(o instanceof q){o=o.get(0);}r=o.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=(w.innerHeight||document.documentElement.clientHeight)&&r.right<=(w.innerWidth||document.documentElement.clientWidth));}
})(window);return j;});
sap.ui.predefine('sap/ui/unified/MenuItem',['sap/ui/core/IconPool','./MenuItemBase','./library'],function(I,M,l){"use strict";
var a=M.extend("sap.ui.unified.MenuItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Appearance",defaultValue:''},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
I.insertFontFaceStyle();
a.prototype.render=function(r,i,m,o){var b=r;var s=i.getSubmenu();b.write("<li");if(i.getVisible()&&i.getEnabled()){b.writeAttribute("tabindex","0");}var c="sapUiMnuItm";if(o.iItemNo==1){c+=" sapUiMnuItmFirst";}else if(o.iItemNo==o.iTotalItems){c+=" sapUiMnuItmLast";}if(!m.checkEnabled(i)){c+=" sapUiMnuItmDsbl";}if(i.getStartsSection()){c+=" sapUiMnuItmSepBefore";}b.writeAttribute("class",c);if(i.getTooltip_AsString()){b.writeAttributeEscaped("title",i.getTooltip_AsString());}b.writeElementData(i);if(o.bAccessible){b.writeAccessibilityState(i,{role:"menuitem",disabled:!m.checkEnabled(i),posinset:o.iItemNo,setsize:o.iTotalItems,labelledby:{value:this.getId()+"-txt "+this.getId()+"-scuttxt",append:true}});if(s){b.writeAttribute("aria-haspopup",true);b.writeAttribute("aria-owns",s.getId());}}b.write("><div class=\"sapUiMnuItmL\"></div>");b.write("<div class=\"sapUiMnuItmIco\">");if(i.getIcon()){b.writeIcon(i.getIcon(),null,{title:null});}b.write("</div>");b.write("<div id=\""+this.getId()+"-txt\" class=\"sapUiMnuItmTxt\">");b.writeEscaped(i.getText());b.write("</div>");b.write("<div id=\""+this.getId()+"-scuttxt\" class=\"sapUiMnuItmSCut\"></div>");b.write("<div class=\"sapUiMnuItmSbMnu\">");if(s){b.write("<div class=\"sapUiIconMirrorInRTL\"></div>");}b.write("</div>");b.write("<div class=\"sapUiMnuItmR\"></div>");b.write("</li>");};
a.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);};
a.prototype.focus=function(m){if(this.getEnabled()&&this.getVisible()){this.$().focus();}else{m.focus();}};
return a;});
sap.ui.predefine('sap/ui/unified/MenuItemBase',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var M=E.extend("sap.ui.unified.MenuItemBase",{metadata:{library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"submenu",aggregations:{submenu:{type:"sap.ui.unified.Menu",multiple:false}},events:{select:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
M.prototype.init=function(){};
M.prototype.render=function(r,i,m){var a=r;a.write("<li");a.writeElementData(i);a.write("><div style=\"white-space:nowrap;display:inline-block;padding:1px;color:black;\" id=\""+this.getId()+"-txt\">");a.write(i.getId());if(this.getSubmenu()){a.write("&nbsp;&nbsp;->");}a.write("</div></li>");};
M.prototype.hover=function(h,m){this.$("txt").attr("style",h?"white-space:nowrap;display:inline-block;padding:1px;color:red;":"white-space:nowrap;display:inline-block;padding:1px;color:black;");};
M.prototype.focus=function(){};
M.prototype.onSubmenuToggle=function(o){this.$().toggleClass("sapUiMnuItmSubMnuOpen",o);};
M.prototype.onAfterRendering=function(){};
M.prototype.onmouseover=function(e){var p=this.getParent();if(p&&p instanceof sap.ui.unified.Menu&&this.getTooltip()instanceof sap.ui.core.TooltipBase){p.onmouseover(e);}};
M.prototype.onsapshow=function(e){if(this.getParent()&&this.getParent().close){this.getParent().close();}e.preventDefault();};
M.prototype.onsaphide=M.prototype.onsapshow;return M;});
sap.ui.predefine('sap/ui/unified/MenuRenderer',[],function(){"use strict";var M={};
M.render=function(r,m){var a=sap.ui.getCore().getConfiguration().getAccessibility(),R=m.getRootMenu();if(m.oHoveredItem&&m.indexOfItem(m.oHoveredItem)<0){m.oHoveredItem=null;}r.write("<div");r.writeAttribute("tabindex",-1);r.writeAttribute("hideFocus",true);if(m.getTooltip_AsString()){r.writeAttributeEscaped("title",m.getTooltip_AsString());}if(a){r.writeAccessibilityState(m,{disabled:null,labelledby:{value:m.getId()+"-label",append:true}});if(m.oHoveredItem){r.writeAttribute("aria-activedescendant",m.oHoveredItem.getId());}}r.addClass("sapUiMnu");if(R.bUseTopStyle){r.addClass("sapUiMnuTop");}if(R.isCozy()){r.addClass("sapUiSizeCozy");}if(m.bCozySupported){r.addClass("sapUiMnuCozySupport");}r.writeClasses();r.writeControlData(m);r.write(">");M.renderItems(r,m);if(a){r.write("<span id='"+m.getId()+"-label' class='sapUiInvisibleText' aria-hidden='true'>");r.writeEscaped(m.getAriaDescription()?m.getAriaDescription():"");r.write("</span>");}r.write("</div>");};
M.renderItems=function(r,m){var I=m.getItems(),a=sap.ui.getCore().getConfiguration().getAccessibility(),h=false,H=false,n=0,b=0,i,o;r.write("<ul");r.writeAttribute("role","menu");r.addClass("sapUiMnuLst");for(i=0;i<I.length;i++){if(I[i].getIcon&&I[i].getIcon()){h=true;}if(I[i].getSubmenu()){H=true;}}if(!h){r.addClass("sapUiMnuNoIco");}if(!H){r.addClass("sapUiMnuNoSbMnu");}r.writeClasses();r.write(">");n=0;for(i=0;i<I.length;i++){if(I[i].getVisible()&&I[i].render){n++;}}for(i=0;i<I.length;i++){o=I[i];if(o.getVisible()&&o.render){b++;if(o.getStartsSection()){r.write("<li");if(a){r.writeAttribute("role","separator");}r.addClass("sapUiMnuDiv");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiMnuDivL");r.writeClasses();r.write(">");r.write("</div>");r.write("<hr>");r.write("<div");r.addClass("sapUiMnuDivR");r.writeClasses();r.write(">");r.write("</div>");r.write("</li>");}o.render(r,o,m,{bAccessible:a,iItemNo:b,iTotalItems:n});}}r.write("</ul>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/MenuTextFieldItem',['sap/ui/core/ValueStateSupport','./MenuItemBase','./library','sap/ui/core/library','sap/ui/Device','sap/base/Log','sap/ui/events/PseudoEvents','sap/ui/dom/jquery/cursorPos'],function(V,M,l,c,D,L,P){"use strict";var a=c.ValueState;
var b=M.extend("sap.ui.unified.MenuTextFieldItem",{metadata:{library:"sap.ui.unified",properties:{label:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},value:{type:"string",group:"Misc",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:a.None}}}});
(function(){
b.prototype.render=function(r,i,m,I){var d=r,e=m.checkEnabled(i),f=i.getId();var C="sapUiMnuItm sapUiMnuTfItm";if(I.iItemNo==1){C+=" sapUiMnuItmFirst";}else if(I.iItemNo==I.iTotalItems){C+=" sapUiMnuItmLast";}if(!m.checkEnabled(i)){C+=" sapUiMnuItmDsbl";}if(i.getStartsSection()){C+=" sapUiMnuItmSepBefore";}d.write("<li ");d.writeAttribute("class",C);d.writeElementData(i);if(I.bAccessible){d.writeAttribute("role","menuitem");d.writeAttribute("aria-disabled",!e);}d.write("><div class=\"sapUiMnuItmL\"></div>");d.write("<div class=\"sapUiMnuItmIco\">");if(i.getIcon()){d.writeIcon(i.getIcon(),null,{title:null});}d.write("</div>");d.write("<div id=\""+f+"-txt\" class=\"sapUiMnuItmTxt\">");d.write("<label id=\""+f+"-lbl\" class=\"sapUiMnuTfItemLbl\">");d.writeEscaped(i.getLabel()||"");d.write("</label>");d.write("<div id=\""+f+"-str\" class=\"sapUiMnuTfItmStretch\"></div>");d.write("<div class=\"sapUiMnuTfItemWrppr\">");d.write("<input id=\""+f+"-tf\" tabindex=\"-1\"");d.writeAttributeEscaped("value",i.getValue()||"");d.writeAttribute("class",e?"sapUiMnuTfItemTf sapUiMnuTfItemTfEnbl":"sapUiMnuTfItemTf sapUiMnuTfItemTfDsbl");if(!e){d.writeAttribute("disabled","disabled");}if(I.bAccessible){d.writeAccessibilityState(i,{role:"textbox",disabled:!e,multiline:false,autocomplete:"none",posinset:I.iItemNo,setsize:I.iTotalItems,labelledby:{value:f+"-lbl",append:true}});}d.write("/></div></div>");d.write("<div class=\"sapUiMnuItmR\"></div>");d.write("</li>");};
b.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);if(h&&m.checkEnabled(this)){m.closeSubmenu(false,true);}};
b.prototype.focus=function(m){if(this.getEnabled()&&this.getVisible()){this.$("tf").focus();}else{m.focus();}};
b.prototype.onAfterRendering=function(){this._adaptSizes();this.setValueState(this.getValueState());};
b.prototype.onsapup=function(e){this.getParent().focus();this.getParent().onsapprevious(e);};
b.prototype.onsapdown=function(e){this.getParent().focus();this.getParent().onsapnext(e);};
b.prototype.onsaphome=function(e){if(this._checkCursorPosForNav(false)){this.getParent().focus();this.getParent().onsaphome(e);}};
b.prototype.onsapend=function(e){if(this._checkCursorPosForNav(true)){this.getParent().focus();this.getParent().onsapend(e);}};
b.prototype.onsappageup=function(e){this.getParent().focus();this.getParent().onsappageup(e);};
b.prototype.onsappagedown=function(e){this.getParent().focus();this.getParent().onsappagedown(e);};
b.prototype.onsapescape=function(e){this.getParent().onsapescape(e);};
b.prototype.onkeydown=function(e){e.stopPropagation();};
b.prototype.onclick=function(e){this.getParent().closeSubmenu(false,true);if(!D.system.desktop&&this.getParent().checkEnabled(this)){this.focus();}e.stopPropagation();};
b.prototype.onkeyup=function(e){if(!P.events.sapenter.fnCheck(e)){return;}var v=this.$("tf").val();this.setValue(v);this.getParent().selectItem(this);e.preventDefault();e.stopPropagation();};
b.prototype.setSubmenu=function(m){L.warning("The aggregation 'submenu' is not supported for this type of menu item.","","sap.ui.unified.MenuTextFieldItem");return this;};
b.prototype.setLabel=function(s){this.setProperty("label",s,true);this.$("lbl").text(s);this._adaptSizes();return this;};
b.prototype.setValue=function(v){this.setProperty("value",v,true);this.$("tf").val(v);return this;};
b.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var $=this.$("tf");$.toggleClass("sapUiMnuTfItemTfErr",v==a.Error);$.toggleClass("sapUiMnuTfItemTfWarn",v==a.Warning);var t=V.enrichTooltip(this,this.getTooltip_AsString());this.$().attr("title",t?t:"");return this;};
b.prototype.getFocusDomRef=function(){var f=this.$("tf");return f.length?f.get(0):null;};
b.prototype._adaptSizes=function(){var $=this.$("tf");var d=this.$("lbl");var o=d.length?d.get(0).offsetLeft:0;if(sap.ui.getCore().getConfiguration().getRTL()){$.parent().css({"width":"auto","right":(this.$().outerWidth(true)-o+(d.outerWidth(true)-d.outerWidth()))+"px"});}else{$.parent().css({"width":"auto","left":(o+d.outerWidth(true))+"px"});}};
b.prototype._checkCursorPosForNav=function(f){var r=sap.ui.getCore().getConfiguration().getRTL();var B=f?r:!r;var $=this.$("tf");var p=$.cursorPos();var i=$.val().length;if(r){p=i-p;}if((!B&&p!=i)||(B&&p!=0)){return false;}return true;};
}());return b;});
sap.ui.predefine('sap/ui/unified/Shell',['./ShellHeader','./ShellLayout','./library','./ShellRenderer'],function(S,a,l,b){"use strict";
var c=a.extend("sap.ui.unified.Shell",{metadata:{library:"sap.ui.unified",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},showCurtain:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},showCurtainPane:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},searchVisible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{curtainContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainContent"},curtainPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainPaneContent"},headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headItem",forwarding:{idSuffix:"-header",aggregation:"headItems"}},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headEndItem",forwarding:{idSuffix:"-header",aggregation:"headEndItems"}},search:{type:"sap.ui.core.Control",multiple:false,forwarding:{idSuffix:"-header",aggregation:"search"}},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false,forwarding:{idSuffix:"-header",aggregation:"user"}}}}});
c.prototype.init=function(){a.prototype.init.apply(this,arguments);this._header=new S(this.getId()+"-header");this.setHeader(this._header);};
c.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._header.destroy();delete this._header;};
c.prototype._getSearchWidth=function(){if(this._header===this.getHeader()&&this._header.getDomRef()){var s=this._header.$("hdr-center").children();if(s.length){return s.width();}}return-1;};
c.prototype.setIcon=function(i){this.setProperty("icon",i,true);this._header.setLogo(i);return this;};
c.prototype.getIcon=function(){return this._header.getLogo();};
c.prototype.setSearchVisible=function(s){this.setProperty("searchVisible",s,true);this._header.setSearchVisible(s);return this;};
c.prototype.getSearchVisible=function(){return this._header.getSearchVisible();};
c.prototype.setHeader=function(h){return a.prototype.setHeader.apply(this,[h?h:this._header]);};
c.prototype.destroyHeader=function(){if(this.getHeader()===this._header){return this;}return a.prototype.destroyHeader.apply(this,[]);};
return c;});
sap.ui.predefine('sap/ui/unified/ShellHeadItem',['sap/ui/core/Element','sap/ui/core/IconPool','./library',"sap/base/security/encodeXML","sap/ui/thirdparty/jquery"],function(E,I,l,e,q){"use strict";
var S=E.extend("sap.ui.unified.ShellHeadItem",{metadata:{library:"sap.ui.unified",properties:{startsSection:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},showSeparator:{type:"boolean",group:"Appearance",defaultValue:true},selected:{type:"boolean",group:"Appearance",defaultValue:false},toggleEnabled:{type:"boolean",group:"Appearance",defaultValue:true},showMarker:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
S.prototype.onclick=function(o){this.firePress();o.preventDefault();};
S.prototype.onsapspace=S.prototype.onclick;S.prototype.onsapenter=S.prototype.onclick;
S.prototype.setStartsSection=function(s){s=!!s;this.setProperty("startsSection",s,true);this.$().toggleClass("sapUiUfdShellHeadItmDelim",s);return this;};
S.prototype.setShowSeparator=function(s){s=!!s;this.setProperty("showSeparator",s,true);this.$().toggleClass("sapUiUfdShellHeadItmSep",s);return this;};
function _(){var t=this.$(),T=this.getToggleEnabled(),s=this.getSelected();if(!t.length){return;}if(T){t.toggleClass("sapUiUfdShellHeadItmSel",s);t.attr("aria-pressed",s);}else{t.removeClass("sapUiUfdShellHeadItmSel");t.removeAttr("aria-pressed");}}
S.prototype.setToggleEnabled=function(b){this.setProperty("toggleEnabled",!!b,true);_.apply(this);return this;};
S.prototype.setSelected=function(s){this.setProperty("selected",!!s,true);_.apply(this);return this;};
S.prototype.setVisible=function(v){this.setProperty("visible",!!v);return this;};
S.prototype.setShowMarker=function(m){m=!!m;this.setProperty("showMarker",m,true);this.$().toggleClass("sapUiUfdShellHeadItmMark",m);return this;};
S.prototype.setIcon=function(i){this.setProperty("icon",i,true);if(this.getDomRef()){this._refreshIcon();}return this;};
S.prototype._refreshIcon=function(){var i=q(this.$().children()[0]);var s=this.getIcon();if(I.isIconURI(s)){var o=I.getIconInfo(s);i.html("").css("style","");if(o){i.text(o.content).attr("role","presentation").attr("aria-label",o.text||o.name).css("font-family","'"+o.fontFamily+"'");}}else{var $=this.$("img-inner");if($.length==0||$.attr("src")!=s){i.css("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+e(s)+"'/>");}}};
return S;});
sap.ui.predefine('sap/ui/unified/ShellHeadUserItem',['sap/ui/core/Element','sap/ui/core/IconPool','./library',"sap/base/security/encodeXML"],function(E,I,l,e){"use strict";
var S=E.extend("sap.ui.unified.ShellHeadUserItem",{metadata:{library:"sap.ui.unified",properties:{username:{type:"string",group:"Appearance",defaultValue:''},showPopupIndicator:{type:"boolean",group:"Accessibility",defaultValue:true},image:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
I.insertFontFaceStyle();
S.prototype.onclick=function(o){this.firePress();o.preventDefault();};
S.prototype.onsapspace=S.prototype.onclick;S.prototype.onsapenter=S.prototype.onclick;
S.prototype.setImage=function(i){this.setProperty("image",i,true);if(this.getDomRef()){this._refreshImage();}return this;};
S.prototype._refreshImage=function(){var i=this.$("img");var s=this.getImage();if(!s){i.html("").css("style","").css("display","none");}else if(I.isIconURI(s)){var o=I.getIconInfo(s);i.html("").css("style","");if(o){i.text(o.content).attr("role","presentation").attr("aria-label",o.text||o.name).css("font-family","'"+o.fontFamily+"'");}}else{var $=this.$("img-inner");if($.length==0||$.attr("src")!=s){i.css("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+e(s)+"'/>");}}};
S.prototype._checkAndAdaptWidth=function(s){if(!this.getDomRef()){return false;}var r=this.$(),n=this.$("name");var b=r.width();r.toggleClass("sapUiUfdShellHeadUsrItmLimit",false);var m=240;if(s){m=Math.min(m,0.5*document.documentElement.clientWidth-225);}if(m<n.width()){r.toggleClass("sapUiUfdShellHeadUsrItmLimit",true);}return b!=r.width();};
return S;});
sap.ui.predefine('sap/ui/unified/ShellHeader',['./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/theming/Parameters',"sap/ui/thirdparty/jquery"],function(l,C,D,P,q){"use strict";
var S=C.extend("sap.ui.unified.ShellHeader",{
metadata:{properties:{logo:{type:"sap.ui.core.URI",defaultValue:""},searchVisible:{type:"boolean",defaultValue:true}},aggregations:{headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},search:{type:"sap.ui.core.Control",multiple:false},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false}}},
renderer:{render:function(r,h){var i=h.getId();r.write("<div");r.writeControlData(h);r.writeAttribute("class","sapUiUfdShellHeader");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","toolbar");}r.write(">");r.write("<div id='",i,"-hdr-begin' class='sapUiUfdShellHeadBegin'>");this.renderHeaderItems(r,h,true);r.write("</div>");r.write("<div id='",i,"-hdr-center' class='sapUiUfdShellHeadCenter'>");this.renderSearch(r,h);r.write("</div>");r.write("<div id='",i,"-hdr-end' class='sapUiUfdShellHeadEnd'>");this.renderHeaderItems(r,h,false);r.write("</div>");r.write("</div>");},renderSearch:function(r,h){var s=h.getSearch();r.write("<div id='",h.getId(),"-hdr-search'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","search");}r.writeAttribute("class","sapUiUfdShellSearch"+(h.getSearchVisible()?"":" sapUiUfdShellHidden"));r.write("><div>");if(s){r.renderControl(s);}r.write("</div></div>");},renderHeaderItems:function(r,h,b){r.write("<div class='sapUiUfdShellHeadContainer'>");var I=b?h.getHeadItems():h.getHeadEndItems();for(var i=0;i<I.length;i++){r.write("<div tabindex='0'");r.writeElementData(I[i]);r.addClass("sapUiUfdShellHeadItm");if(I[i].getStartsSection()){r.addClass("sapUiUfdShellHeadItmDelim");}if(I[i].getShowSeparator()){r.addClass("sapUiUfdShellHeadItmSep");}if(!I[i].getVisible()){r.addClass("sapUiUfdShellHidden");}if(I[i].getSelected()&&I[i].getToggleEnabled()){r.addClass("sapUiUfdShellHeadItmSel");}if(I[i].getShowMarker()){r.addClass("sapUiUfdShellHeadItmMark");}r.writeClasses();var t=I[i].getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(I[i],{role:"button",selected:null,pressed:I[i].getToggleEnabled()?I[i].getSelected():null});}r.write("><span></span><div class='sapUiUfdShellHeadItmMarker'><div></div></div></div>");}var u=h.getUser();if(!b&&u){r.write("<div tabindex='0'");r.writeElementData(u);r.addClass("sapUiUfdShellHeadUsrItm");if(!u.getShowPopupIndicator()){r.addClass("sapUiUfdShellHeadUsrItmWithoutPopup");}r.writeClasses();var t=u.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(u,{role:"button"});if(u.getShowPopupIndicator()){r.writeAttribute("aria-haspopup","true");}}r.write("><span id='",u.getId(),"-img' aria-hidden='true' class='sapUiUfdShellHeadUsrItmImg'></span>");r.write("<span id='"+u.getId()+"-name' class='sapUiUfdShellHeadUsrItmName'");var U=u.getUsername()||"";r.writeAttributeEscaped("title",U);r.write(">");r.writeEscaped(U);r.write("</span><span class='sapUiUfdShellHeadUsrItmExp' aria-hidden='true'></span></div>");}r.write("</div>");if(b){this._renderLogo(r,h);}},_renderLogo:function(r,h){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),L=a.getText("SHELL_LOGO_TOOLTIP"),i=h._getLogo();r.write("<div class='sapUiUfdShellIco'>");r.write("<img id='",h.getId(),"-icon'");r.writeAttributeEscaped("title",L);r.writeAttributeEscaped("alt",L);r.write("src='");r.writeEscaped(i);r.write("' style='",i?"":"display:none;","'/>");r.write("</div>");}}
});
S.prototype.init=function(){var t=this;this._rtl=sap.ui.getCore().getConfiguration().getRTL();this._handleMediaChange=function(p){if(!t.getDomRef()){return;}t._refresh();};D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);this._handleResizeChange=function(p){if(!t.getDomRef()||!t.getUser()){return;}var u=this.getUser();var c=u._checkAndAdaptWidth(!t.$("hdr-search").hasClass("sapUiUfdShellHidden")&&!!t.getSearch());if(c){t._refresh();}};D.resize.attachHandler(this._handleResizeChange,this);this.data("sap-ui-fastnavgroup","true",true);};
S.prototype.exit=function(){D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);delete this._handleMediaChange;D.resize.detachHandler(this._handleResizeChange,this);delete this._handleResizeChange;};
S.prototype.onAfterRendering=function(){this._refresh();this.$("hdr-center").toggleClass("sapUiUfdShellAnim",!this._noHeadCenterAnim);};
S.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};
S.prototype._getLogo=function(){var i=this.getLogo();if(!i){i=P._getThemeImage(null,true);}return i;};
S.prototype._refresh=function(){function u(I){for(var i=0;i<I.length;i++){I[i]._refreshIcon();}}u(this.getHeadItems());u(this.getHeadEndItems());var U=this.getUser(),a=q("html").hasClass("sapUiMedia-Std-Phone"),s=!this.$("hdr-search").hasClass("sapUiUfdShellHidden"),$=this.$("icon");if(U){U._refreshImage();U._checkAndAdaptWidth(s&&!!this.getSearch());}$.parent().toggleClass("sapUiUfdShellHidden",a&&s&&!!this.getSearch());var w=this.$("hdr-end").outerWidth(),b=this.$("hdr-begin").outerWidth(),c=Math.max(w,b),d=(a&&s?b:c)+"px",e=(a&&s?w:c)+"px";this.$("hdr-center").css({"left":this._rtl?e:d,"right":this._rtl?d:e});};
return S;});
sap.ui.predefine('sap/ui/unified/ShellLayout',['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/theming/Parameters','./SplitContainer','./library','./ShellLayoutRenderer','sap/ui/dom/containsOrEquals','sap/base/Log',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/Focusable'],function(D,C,P,a,S,l,b,c,L,q){"use strict";
var d=C.extend("sap.ui.unified.ShellLayout",{metadata:{library:"sap.ui.unified",properties:{showPane:{type:"boolean",group:"Appearance",defaultValue:false},headerHiding:{type:"boolean",group:"Appearance",defaultValue:false},headerVisible:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",forwarding:{idSuffix:"-container",aggregation:"content"}},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent",forwarding:{idSuffix:"-container",aggregation:"secondaryContent"}},header:{type:"sap.ui.core.Control",multiple:false},canvasSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"},curtainSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"}}}});
d._SIDEPANE_WIDTH_PHONE=208;d._SIDEPANE_WIDTH_TABLET=208;d._SIDEPANE_WIDTH_DESKTOP=240;d._HEADER_ALWAYS_VISIBLE=true;d._HEADER_AUTO_CLOSE=true;d._HEADER_TOUCH_TRESHOLD=15;if(D.browser.chrome&&D.browser.version<36){d._HEADER_TOUCH_TRESHOLD=10;}
d.prototype.init=function(){this._rtl=sap.ui.getCore().getConfiguration().getRTL();this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._showHeader=true;this._showCurtain=false;this._iHeaderHidingDelay=3000;this._useStrongBG=false;this._cont=new S(this.getId()+"-container");this._cont._bRootContent=true;if(sap.ui.getCore().getConfiguration().getAccessibility()){var t=this;this._cont.addEventDelegate({onAfterRendering:function(){t._cont.$("canvas").attr("role","main");t._cont.$("pane").attr("role","complementary");}});}this.setAggregation("canvasSplitContainer",this._cont,true);this._curtCont=new S(this.getId()+"-curt-container");this._curtCont._bRootContent=true;this.setAggregation("curtainSplitContainer",this._curtCont,true);this._setSidePaneWidth();D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);D.resize.attachHandler(this._handleResizeChange,this);};
d.prototype.exit=function(){D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);D.resize.detachHandler(this._handleResizeChange,this);delete this._cont;delete this._curtCont;};
d.prototype.onAfterRendering=function(){var t=this;function h(B){var e=q.event.fix(B);if(c(t.getDomRef("hdr"),e.target)){t._timedHideHeader(e.type==="focus");}}if(window.addEventListener&&!d._HEADER_ALWAYS_VISIBLE){var H=this.getDomRef("hdr");H.addEventListener("focus",h,true);H.addEventListener("blur",h,true);}this._refreshAfterRendering();};
d.prototype.onThemeChanged=function(){this._refreshAfterRendering();};
d.prototype.onfocusin=function(e){var i=this.getId();if(e.target.id===i+"-curt-focusDummyOut"&&this.$("hdrcntnt").firstFocusableDomRef()){this.$("hdrcntnt").firstFocusableDomRef().focus();}else if(e.target.id===i+"-main-focusDummyOut"&&this.$("curtcntnt").firstFocusableDomRef()){this.$("curtcntnt").firstFocusableDomRef().focus();}};
(function(){
function _(s){if(s._startY===undefined||s._currY===undefined){return;}var y=s._currY-s._startY;if(Math.abs(y)>d._HEADER_TOUCH_TRESHOLD){s._doShowHeader(y>0);s._startY=s._currY;}}
if(D.support.touch){d._HEADER_ALWAYS_VISIBLE=false;d.prototype.ontouchstart=function(e){this._startY=e.touches[0].pageY;if(this._startY>2*48){this._startY=undefined;}this._currY=this._startY;};d.prototype.ontouchend=function(e){_(this);this._startY=undefined;this._currY=undefined;};d.prototype.ontouchcancel=d.prototype.ontouchend;d.prototype.ontouchmove=function(e){this._currY=e.touches[0].pageY;_(this);};}})();
d.prototype.setHeaderHiding=function(e){e=!!e;return this._mod(function(r){return this.setProperty("headerHiding",e,r);},function(){this._doShowHeader(!e?true:this._showHeader);});};
d.prototype.setHeaderHidingDelay=function(i){this._iHeaderHidingDelay=i;return this;};
d.prototype.getHeaderHidingDelay=function(){return this._iHeaderHidingDelay;};
d.prototype.getShowPane=function(){return this._cont.getShowSecondaryContent();};
d.prototype.setShowPane=function(s){this._cont.setShowSecondaryContent(s);this.setProperty("showPane",!!s,true);return this;};
d.prototype.setShowCurtainPane=function(s){this._curtCont.setShowSecondaryContent(s);return this;};
d.prototype.getShowCurtainPane=function(){return this._curtCont.getShowSecondaryContent();};
d.prototype.setHeaderVisible=function(h){h=!!h;this.setProperty("headerVisible",h,true);this.$().toggleClass("sapUiUfdShellNoHead",!h);return this;};
d.prototype.setShowCurtain=function(s){s=!!s;return this._mod(function(r){this._showCurtain=s;return this;},function(){this.$("main-focusDummyOut").attr("tabindex",s?0:-1);this.$().toggleClass("sapUiUfdShellCurtainHidden",!s).toggleClass("sapUiUfdShellCurtainVisible",s);if(s){var z=P.getNextZIndex();this.$("curt").css("z-index",z+1);this.$("hdr").css("z-index",z+3);this.$("brand").css("z-index",z+7);this.$().toggleClass("sapUiUfdShellCurtainClosed",false);}this._timedCurtainClosed(s);this._doShowHeader(true);});};
d.prototype.getShowCurtain=function(){return this._showCurtain;};
d.prototype.setHeader=function(h){this.setAggregation("header",h,true);h=this.getHeader();if(this.getDomRef()){if(!h){this.$("hdrcntnt").html("");}else{var r=sap.ui.getCore().createRenderManager();r.renderControl(h);r.flush(this.getDomRef("hdrcntnt"));r.destroy();}}return this;};
d.prototype.destroyHeader=function(){this.destroyAggregation("header",true);this.$("hdrcntnt").html("");return this;};
d.prototype.getCurtainContent=function(){return this._curtCont.getContent();};
d.prototype.insertCurtainContent=function(o,i){this._curtCont.insertContent(o,i);return this;};
d.prototype.addCurtainContent=function(o){this._curtCont.addContent(o);return this;};
d.prototype.removeCurtainContent=function(i){return this._curtCont.removeContent(i);};
d.prototype.removeAllCurtainContent=function(){return this._curtCont.removeAllContent();};
d.prototype.destroyCurtainContent=function(){this._curtCont.destroyContent();return this;};
d.prototype.indexOfCurtainContent=function(o){return this._curtCont.indexOfCurtainContent(o);};
d.prototype.getCurtainPaneContent=function(){return this._curtCont.getSecondaryContent();};
d.prototype.insertCurtainPaneContent=function(o,i){this._curtCont.insertSecondaryContent(o,i);return this;};
d.prototype.addCurtainPaneContent=function(o){this._curtCont.addSecondaryContent(o);return this;};
d.prototype.removeCurtainPaneContent=function(i){return this._curtCont.removeSecondaryContent(i);};
d.prototype.removeAllCurtainPaneContent=function(){return this._curtCont.removeAllSecondaryContent();};
d.prototype.destroyCurtainPaneContent=function(){this._curtCont.destroySecondaryContent();return this;};
d.prototype.indexOfCurtainPaneContent=function(o){return this._curtCont.indexOfSecondaryContent(o);};
d.prototype._setStrongBackground=function(u){this._useStrongBG=!!u;this.$("strgbg").toggleClass("sapUiStrongBackgroundColor",this._useStrongBG);};
d.prototype._mod=function(m,o){var r=!!this.getDomRef();var e=m.apply(this,[r]);if(r&&o){if(o instanceof l._ContentRenderer){o.render();}else{o.apply(this);}}return e;};
d.prototype._doShowHeader=function(s){var w=this._showHeader;this._showHeader=this._isHeaderHidingActive()?!!s:true;this.$().toggleClass("sapUiUfdShellHeadHidden",!this._showHeader).toggleClass("sapUiUfdShellHeadVisible",this._showHeader);if(this._showHeader){this._timedHideHeader();}if(w!=this._showHeader&&this._isHeaderHidingActive()){setTimeout(function(){try{var r=document.createEvent("UIEvents");r.initUIEvent("resize",true,false,window,0);window.dispatchEvent(r);}catch(e){L.error(e);}},500);}};
d.prototype._timedHideHeader=function(e){if(this._headerHidingTimer){clearTimeout(this._headerHidingTimer);this._headerHidingTimer=null;}if(e||!d._HEADER_AUTO_CLOSE||!this._isHeaderHidingActive()||this._iHeaderHidingDelay<=0){return;}this._headerHidingTimer=setTimeout(function(){if(this._isHeaderHidingActive()&&this._iHeaderHidingDelay>0&&!c(this.getDomRef("hdr"),document.activeElement)){this._doShowHeader(false);}}.bind(this),this._iHeaderHidingDelay);};
d.prototype._timedCurtainClosed=function(e){if(this._curtainClosedTimer){clearTimeout(this._curtainClosedTimer);this._curtainClosedTimer=null;}if(e){return;}var f=parseInt(a.get("_sap_ui_unified_ShellLayout_AnimDuration"));if(!this._animation||(D.browser.internet_explorer&&D.browser.version<10)){f=0;}this._curtainClosedTimer=setTimeout(function(){this._curtainClosedTimer=null;this.$("curt").css("z-index","");this.$("hdr").css("z-index","");this.$("brand").css("z-index","");this.$().toggleClass("sapUiUfdShellCurtainClosed",true);}.bind(this),f);};
d.prototype._isHeaderHidingActive=function(){if(d._HEADER_ALWAYS_VISIBLE||this.getShowCurtain()||!this.getHeaderHiding()||l._iNumberOfOpenedShellOverlays>0||!this.getHeaderVisible()){return false;}return true;};
d.prototype._setSidePaneWidth=function(r){if(!r){r=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD).name;}var w=d["_SIDEPANE_WIDTH_"+r.toUpperCase()]+"px";this._cont.setSecondaryContentSize(w);this._curtCont.setSecondaryContentSize(w);};
d.prototype._handleMediaChange=function(p){if(!this.getDomRef()){return false;}this._setSidePaneWidth(p.name);};
d.prototype._handleResizeChange=function(p){};
d.prototype._refreshAfterRendering=function(){var o=this.getDomRef();if(!o){return false;}this._timedHideHeader();return true;};
d.prototype._getSearchWidth=function(){return-1;};
return d;});
sap.ui.predefine('sap/ui/unified/ShellLayoutRenderer',[],function(){"use strict";var S={};
S.render=function(r,s){var i=s.getId();r.write("<div");r.writeControlData(s);r.addClass("sapUiUfdShell");if(s._animation){r.addClass("sapUiUfdShellAnim");}if(!s.getHeaderVisible()){r.addClass("sapUiUfdShellNoHead");}r.addClass("sapUiUfdShellHead"+(s._showHeader?"Visible":"Hidden"));if(s.getShowCurtain()){r.addClass("sapUiUfdShellCurtainVisible");}else{r.addClass("sapUiUfdShellCurtainHidden");r.addClass("sapUiUfdShellCurtainClosed");}r.writeClasses();r.write(">");r.write("<hr id='",i,"-brand' class='sapUiUfdShellBrand'/>");r.write("<header id='",i,"-hdr'  class='sapUiUfdShellHead'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","banner");}r.write("><div><div id='",i,"-hdrcntnt' class='sapUiUfdShellCntnt'>");if(s.getHeader()){r.renderControl(s.getHeader());}r.write("</div>","</div>","</header>");r.write("<section id='",i,"-curt' class='sapUiUfdShellCntnt sapUiUfdShellCurtain'>");r.write("<div id='",i,"-curtcntnt' class='sapUiUfdShellCntnt'>");r.renderControl(s._curtCont);r.write("</div>");r.write("<span id='",i,"-curt-focusDummyOut' tabindex='0'></span>");r.write("</section>");r.write("<div id='",i,"-cntnt' class='sapUiUfdShellCntnt sapUiUfdShellCanvas sapUiGlobalBackgroundColor sapUiGlobalBackgroundColorForce'>");r.write("<div id='",i,"-strgbg' class='sapUiUfdShellBG"+(s._useStrongBG?" sapUiStrongBackgroundColor":"")+"'></div>");r.write("<div class='sapUiGlobalBackgroundImage sapUiGlobalBackgroundImageForce sapUiUfdShellBG'></div>");r.renderControl(s._cont);r.write("</div>");r.write("<span id='",i,"-main-focusDummyOut' tabindex='"+(s.getShowCurtain()?0:-1)+"'></span>");r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellOverlay',['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','./library','sap/ui/core/theming/Parameters','./ShellOverlayRenderer',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/rect','sap/ui/dom/jquery/Selectors'],function(D,C,P,l,a,S,q){"use strict";
var b=C.extend("sap.ui.unified.ShellOverlay",{metadata:{library:"sap.ui.unified",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},search:{type:"sap.ui.core.Control",multiple:false}},associations:{shell:{type:"sap.ui.unified.ShellLayout",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{closed:{}}}});
b.prototype.open=function(){if(this._getPopup().isOpen()){return;}this._opening=true;this._forceShellHeaderVisible();this._getPopup().setModal(true,P.blStack.length==0&&this._getAnimActive()?"sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp":"");this._getPopup().open(0,P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","none");var s=this.getSearch();if(s){s.focus();}this._opening=false;if(this._getAnimActive()){setTimeout(function(){q(document.getElementById("sap-ui-blocklayer-popup")).toggleClass("sapUiUfdShellOvrlyBlyTp",false);},50);}setTimeout(function(){this.$().toggleClass("sapUiUfdShellOvrlyOpening",false);}.bind(this),this._getAnimDuration(true));};
b.prototype.close=function(){if(!this._getPopup().isOpen()){return;}this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",true).toggleClass("sapUiUfdShellOvrlyClosing",true);this._setSearchWidth();setTimeout(function(){var B=q(document.getElementById("sap-ui-blocklayer-popup"));if(P.blStack.length==1&&this._getAnimActive()&&B.hasClass("sapUiUfdShellOvrlyBly")){B.toggleClass("sapUiUfdShellOvrlyBlyTp",true);}}.bind(this),Math.max(this._getAnimDuration(false)-this._getBLAnimDuration(),0));setTimeout(function(){this._getPopup().close(0);this.$().remove();this._forceShellHeaderVisible();this.fireClosed();}.bind(this),this._getAnimDuration(false));};
b.prototype.setShell=function(s){return this.setAssociation("shell",s,true);};
b.prototype.setSearch=function(s){this.setAggregation("search",s,true);if(!!this.getDomRef()){this._headRenderer.render();}return this;};
b.prototype.insertContent=function(c,i){var r=this.insertAggregation("content",c,i,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.addContent=function(c){var r=this.addAggregation("content",c,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.removeContent=function(i){var r=this.removeAggregation("content",i,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.removeAllContent=function(){var r=this.removeAllAggregation("content",true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.destroyContent=function(){var r=this.destroyAggregation("content",true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.init=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._opening=false;var t=this;this._headRenderer=new l._ContentRenderer(this,this.getId()+"-hdr-center",function(r){S.renderSearch(r,t);});this._contentRenderer=new l._ContentRenderer(this,this.getId()+"-cntnt",function(r){S.renderContent(r,t);});};
b.prototype.exit=function(){if(this._popup){this._popup.close(0);this._popup.destroy();this._popup=null;}this._getPopup=function(){return null;};this._headRenderer.destroy();delete this._headRenderer;this._contentRenderer.destroy();delete this._contentRenderer;};
b.prototype.onAfterRendering=function(){if(this._opening){this._setSearchWidth();}setTimeout(function(){this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",false);this.$("search").css("width","");}.bind(this),10);};
b.prototype.onclick=function(e){if(q(e.target).attr("id")===this.getId()+"-close"){this.close();e.preventDefault();}};
b.prototype.onsapspace=b.prototype.onclick;
b.prototype.onThemeChanged=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;};
b.prototype.onfocusin=function(e){var f,d;if(e.target.id==this.getId()+"-focfirst"){f=q(":sapTabbable",this.$("inner"));d=f.get(f.length-1);}else if(e.target.id==this.getId()+"-foclast"){f=q(":sapTabbable",this.$("inner"));d=f.get(0);}if(d){d.focus();}};
b.prototype._getAnimDurationThemeParam=function(p,c){var v=parseInt(a.get(p));if(!this._getAnimActive()&&c){v=0;}return v;};
b.prototype._getAnimDuration=function(o){if((o&&this._animOpenDuration==-1)||(!o&&this._animCloseDuration==-1)){var t=o?"Open":"Close";this["_anim"+t+"Duration"]=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_"+t+"AnimOverAll",true);}return o?this._animOpenDuration:this._animCloseDuration;};
b.prototype._getBLAnimDuration=function(){if(this._animBlockLayerDuration==-1){this._animBlockLayerDuration=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_BlockLayerAnimDuration",true);}return this._animBlockLayerDuration;};
b.prototype._getAnimActive=function(){if(!this._animation||(D.browser.internet_explorer&&D.browser.version<10)){return false;}return true;};
b.prototype._getPopup=function(){if(!this._popup){this._popup=new P(this,true,false,false);this._popup._applyPosition=function(p){this._$().css("left","0").css("top","0");this._oLastPosition=p;this._oLastOfRect=q(window).rect();};this._popup.attachOpened(function(){l._iNumberOfOpenedShellOverlays++;});this._popup.attachClosed(function(){l._iNumberOfOpenedShellOverlays--;});}return this._popup;};
b.prototype._getShell=function(){var i=this.getShell();if(!i){return;}var s=sap.ui.getCore().byId(i);if(!s||!(s instanceof sap.ui.unified.ShellLayout)){return;}return s;};
b.prototype._forceShellHeaderVisible=function(){var s=this._getShell();if(s){s._doShowHeader(true);}};
b.prototype._getSearchWidth=function(){var s=this._getShell();return s?s._getSearchWidth():-1;};
b.prototype._setSearchWidth=function(){var w=this._getSearchWidth();if(w<=0){return;}var W=w+"px";if(D.browser.safari){var t=this.$("hdr-center").width();if(t>w){W=Math.round((w*100)/t)+"%";}else{W="100%";}}this.$("search").css("width",W);};
return b;});
sap.ui.predefine('sap/ui/unified/ShellOverlayRenderer',[],function(){"use strict";var S={};
S.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiUfdShellOvrly");if(c._opening){r.addClass("sapUiUfdShellOvrlyCntntHidden");r.addClass("sapUiUfdShellOvrlyOpening");}if(c._getAnimActive()){r.addClass("sapUiUfdShellOvrlyAnim");}r.writeClasses();if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(c,{role:"dialog"});}r.write("><span id='",c.getId(),"-focfirst' tabindex='0'></span><div id='",c.getId(),"-inner'>");r.write("<header class='sapUiUfdShellOvrlyHead'>");r.write("<hr class='sapUiUfdShellOvrlyBrand'/>");r.write("<div class='sapUiUfdShellOvrlyHeadCntnt'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","toolbar");}r.write("><div id='"+c.getId()+"-hdr-center' class='sapUiUfdShellOvrlyHeadCenter'>");S.renderSearch(r,c);r.write("</div>");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),C=a.getText("SHELL_OVERLAY_CLOSE");r.write("<a tabindex='0' href='#' id='"+c.getId()+"-close' class='sapUiUfdShellOvrlyHeadClose'");r.writeAttributeEscaped("title",C);if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","button");}r.write(">");r.writeEscaped(C);r.write("</a></div></header>");r.write("<div id='"+c.getId()+"-cntnt' class='sapUiUfdShellOvrlyCntnt'>");S.renderContent(r,c);r.write("</div>");r.write("</div><span id='",c.getId(),"-foclast' tabindex='0'></span></div>");};
S.renderSearch=function(r,c){var w=c._getSearchWidth();var s="";if(w>0&&c._opening){s="style='width:"+w+"px'";}r.write("<div id='"+c.getId()+"-search' class='sapUiUfdShellOvrlySearch' "+s+"><div>");var o=c.getSearch();if(o){r.renderControl(o);}r.write("</div></div>");};
S.renderContent=function(r,c){r.write("<div>");var C=c.getContent();for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellRenderer',['sap/ui/core/Renderer','./ShellLayoutRenderer'],function(R,S){"use strict";var a=R.extend(S);return a;},true);
sap.ui.predefine('sap/ui/unified/SplitContainer',['sap/ui/core/Control','sap/ui/core/theming/Parameters','./library','sap/ui/core/library','./SplitContainerRenderer',"sap/base/Log"],function(C,P,l,c,S,L){"use strict";var O=c.Orientation;
var a=C.extend("sap.ui.unified.SplitContainer",{metadata:{library:"sap.ui.unified",properties:{showSecondaryContent:{type:"boolean",group:"Appearance",defaultValue:null},secondaryContentSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'250px'},secondaryContentWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'250px',deprecated:true},orientation:{type:"sap.ui.core.Orientation",group:"Appearance",defaultValue:O.Horizontal}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},secondaryContent:{type:"sap.ui.core.Control",multiple:true,singularName:"secondaryContent"}}}});
(function(w){
a.prototype.init=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this._paneRenderer=new l._ContentRenderer(this,this.getId()+"-panecntnt","secondaryContent");this._canvasRenderer=new l._ContentRenderer(this,this.getId()+"-canvascntnt","content");this._moveContent=true;};
a.prototype.exit=function(){this._paneRenderer.destroy();delete this._paneRenderer;this._canvasRenderer.destroy();delete this._canvasRenderer;if(this._closeContentDelayId){clearTimeout(this._closeContentDelayId);delete this._closeContentDelayId;}delete this._contentContainer;delete this._secondaryContentContainer;};
a.prototype.onAfterRendering=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this._contentContainer=this.$("canvas");this._secondaryContentContainer=this.$("pane");this._applySecondaryContentSize();};
a.prototype._applySecondaryContentSize=function(){if(this.getDomRef()){var v=this.getOrientation()==O.Vertical;var s,o;var d,b;var e=this.getSecondaryContentSize();var f=this.getShowSecondaryContent();if(v){s="height";o="width";d="top";b=this.bRtl?"right":"left";}else{s="width";o="height";d=this.bRtl?"right":"left";b="top";}if(this._closeContentDelayId){clearTimeout(this._closeContentDelayId);delete this._closeContentDelayId;}this._secondaryContentContainer.css(s,e);this._secondaryContentContainer.css(o,"");this._secondaryContentContainer.css(d,f?"0":"-"+e);this._secondaryContentContainer.css(b,"");if(this._moveContent){this._contentContainer.css(d,f?e:"0");}else{this._contentContainer.css(d,"0");}if(!f){var h=parseInt(P.get("_sap_ui_unified_SplitContainer_AnimationDuration"));this._closeContentDelayId=setTimeout(function(){this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",true);}.bind(this),h);}else{this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",false);}}};
a.prototype._mod=function(m,d){var r=!!this.getDomRef();var b=m.apply(this,[r]);if(r&&d){d.render();}return b;};
a.prototype.setShowSecondaryContent=function(s){var r=this.getDomRef();this.setProperty("showSecondaryContent",!!s,r);this._applySecondaryContentSize();return this;};
a.prototype.setSecondaryContentSize=function(s){this.setProperty("secondaryContentSize",s,true);this._applySecondaryContentSize();return this;};
a.prototype.getSecondaryContentWidth=function(){L.warning("SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use "+"\"SecondaryContentSize\" instead.");return this.getSecondaryContentSize.apply(this,arguments);};
a.prototype.setSecondaryContentWidth=function(){L.warning("SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use "+"\"SecondaryContentSize\" instead.");return this.setSecondaryContentSize.apply(this,arguments);};
a.prototype.insertContent=function(o,i){return this._mod(function(r){return this.insertAggregation("content",o,i,r);},this._canvasRenderer);};
a.prototype.addContent=function(o){return this._mod(function(r){return this.addAggregation("content",o,r);},this._canvasRenderer);};
a.prototype.removeContent=function(i){return this._mod(function(r){return this.removeAggregation("content",i,r);},this._canvasRenderer);};
a.prototype.removeAllContent=function(){return this._mod(function(r){return this.removeAllAggregation("content",r);},this._canvasRenderer);};
a.prototype.destroyContent=function(){return this._mod(function(r){return this.destroyAggregation("content",r);},this._canvasRenderer);};
a.prototype.insertSecondaryContent=function(o,i){return this._mod(function(r){return this.insertAggregation("secondaryContent",o,i,r);},this._paneRenderer);};
a.prototype.addSecondaryContent=function(o){return this._mod(function(r){return this.addAggregation("secondaryContent",o,r);},this._paneRenderer);};
a.prototype.removeSecondaryContent=function(i){return this._mod(function(r){return this.removeAggregation("secondaryContent",i,r);},this._paneRenderer);};
a.prototype.removeAllSecondaryContent=function(){return this._mod(function(r){return this.removeAllAggregation("secondaryContent",r);},this._paneRenderer);};
a.prototype.destroySecondaryContent=function(){return this._mod(function(r){return this.destroyAggregation("secondaryContent",r);},this._paneRenderer);};
})(window);return a;});
sap.ui.predefine('sap/ui/unified/SplitContainerRenderer',["sap/ui/core/library"],function(c){"use strict";var O=c.Orientation;var S={};
S.render=function(r,C){var i=C.getId();var v=C.getOrientation()==O.Vertical;r.write("<div");r.writeControlData(C);r.addClass("sapUiUfdSpltCont");r.addClass("sapUiUfdSpltCont"+(v?"V":"H"));if(sap.ui.getCore().getConfiguration().getAnimation()){r.addClass("sapUiUfdSpltContAnim");}if(!C.getShowSecondaryContent()){r.addClass("sapUiUfdSpltContPaneHidden");}r.writeClasses();r.write(">");var s=i+"-canvas";r.write("<section id='",s,"' class='sapUiUfdSpltContCanvas'>");this.renderContent(r,s,C.getContent(),C._bRootContent);r.write("</section>");var a=i+"-pane";var w=C.getShowSecondaryContent()?C.getSecondaryContentSize():"0";r.write("<aside id='",a,"' style='width:",w,"'");r.addClass("sapUiUfdSpltContPane");if(!C.getShowSecondaryContent()){r.addClass("sapUiUfdSplitContSecondClosed");}r.writeClasses();r.write(">");this.renderContent(r,a,C.getSecondaryContent(),C._bRootContent);r.write("</aside>");r.write("</div>");};
S.renderContent=function(r,I,C,R){r.write("<div id='",I,"cntnt' class='sapUiUfdSpltContCntnt'");if(R){r.writeAttribute("data-sap-ui-root-content","true");}r.write(">");for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/calendar/CalendarDate',['sap/ui/base/Object','sap/ui/core/date/UniversalDate',"sap/ui/thirdparty/jquery"],function(B,U,q){"use strict";
var C=B.extend("sap.ui.unified.calendar.CalendarDate",{constructor:function(){var A=arguments,j,n,s;switch(A.length){case 0:n=new Date();return this.constructor(n.getFullYear(),n.getMonth(),n.getDate());case 1:case 2:if(!(A[0]instanceof C)){throw"Invalid arguments: the first argument must be of type sap.ui.unified.calendar.CalendarDate.";}s=A[1]?A[1]:A[0]._oUDate.sCalendarType;j=new Date(A[0].valueOf());j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());j.setHours(j.getUTCHours(),j.getUTCMinutes(),j.getUTCSeconds(),j.getUTCMilliseconds());this._oUDate=c(j,s);break;case 3:case 4:d(A[0],"Invalid year: "+A[0]);d(A[1],"Invalid month: "+A[1]);d(A[2],"Invalid date: "+A[2]);j=new Date(0,0,1);j.setFullYear(A[0],A[1],A[2]);if(A[3]){s=A[3];}this._oUDate=c(j,s);break;default:throw"Invalid arguments. Accepted arguments are: 1) oCalendarDate, (optional)calendarType"+"or 2) year, month, date, (optional) calendarType"+A;}}});
C.prototype.getYear=function(){return this._oUDate.getUTCFullYear();};
C.prototype.setYear=function(y){d(y,"Invalid year: "+y);this._oUDate.setUTCFullYear(y);return this;};
C.prototype.getMonth=function(){return this._oUDate.getUTCMonth();};
C.prototype.setMonth=function(m,e){d(m,"Invalid month: "+m);if(e){d(e,"Invalid date: "+e);this._oUDate.setUTCMonth(m,e);}else{this._oUDate.setUTCMonth(m);}return this;};
C.prototype.getDate=function(){return this._oUDate.getUTCDate();};
C.prototype.setDate=function(e){d(e,"Invalid date: "+e);this._oUDate.setUTCDate(e);return this;};
C.prototype.getDay=function(){return this._oUDate.getUTCDay();};
C.prototype.getCalendarType=function(){return this._oUDate.sCalendarType;};
C.prototype.getEra=function(){return this._oUDate.getUTCEra();};
C.prototype.isBefore=function(o){b(o);return this.valueOf()<o.valueOf();};
C.prototype.isAfter=function(o){b(o);return this.valueOf()>o.valueOf();};
C.prototype.isSameOrBefore=function(o){b(o);return this.valueOf()<=o.valueOf();};
C.prototype.isSameOrAfter=function(o){b(o);return this.valueOf()>=o.valueOf();};
C.prototype.isSame=function(o){b(o);return this.valueOf()===o.valueOf();};
C.prototype.toLocalJSDate=function(){var l=new Date(this._oUDate.getTime());l.setFullYear(l.getUTCFullYear(),l.getUTCMonth(),l.getUTCDate());l.setHours(0,0,0,0);return l;};
C.prototype.toUTCJSDate=function(){var u=new Date(this._oUDate.getTime());u.setUTCHours(0,0,0,0);return u;};
C.prototype.toString=function(){return this._oUDate.sCalendarType+": "+this.getYear()+"/"+(this.getMonth()+1)+"/"+this.getDate();};
C.prototype.valueOf=function(){return this._oUDate.getTime();};
C.fromLocalJSDate=function(j,s){if(q.type(j)!=="date"){throw new Error("Date parameter must be a JavaScript Date object: ["+j+"].");}return new C(j.getFullYear(),j.getMonth(),j.getDate(),s);};
function c(D,s){if(s){return U.getInstance(a(D),s);}else{return new U(a(D).getTime());}}
function a(D){var u=new Date(Date.UTC(0,0,1));u.setUTCFullYear(D.getFullYear(),D.getMonth(),D.getDate());return u;}
function b(o){if(!(o instanceof C)){throw"Invalid calendar date: ["+o+"]. Expected: sap.ui.unified.calendar.CalendarDate";}}
function d(v,m){if(v==undefined||v===Infinity||isNaN(v)){throw m;}}
return C;});
sap.ui.predefine('sap/ui/unified/calendar/CalendarUtils',['sap/ui/core/date/UniversalDate','./CalendarDate','sap/ui/core/Locale','sap/ui/core/LocaleData',"sap/ui/thirdparty/jquery"],function(U,C,L,a,q){"use strict";var b={};b.MAX_MILLISECONDS=8640000000000000;b.HOURS24=1000*3600*24;
b._createLocalDate=function(d,t){var l;if(d){var m;if(d instanceof U){m=d.getJSDate();}else{m=d;}l=new Date(m.getUTCFullYear(),m.getUTCMonth(),m.getUTCDate());if(m.getFullYear()<1000){l.setFullYear(m.getFullYear());}if(t){l.setHours(m.getUTCHours());l.setMinutes(m.getUTCMinutes());l.setSeconds(m.getUTCSeconds());l.setMilliseconds(m.getUTCMilliseconds());}}return l;};
b._createUTCDate=function(d,t){var u;if(d){var m;if(d instanceof U){m=d.getJSDate();}else{m=d;}u=new Date(Date.UTC(m.getFullYear(),m.getMonth(),m.getDate()));if(m.getFullYear()<1000){u.setUTCFullYear(m.getFullYear());}if(t){u.setUTCHours(m.getHours());u.setUTCMinutes(m.getMinutes());u.setUTCSeconds(m.getSeconds());u.setUTCMilliseconds(m.getMilliseconds());}}return u;};
b._createUniversalUTCDate=function(d,c,t){var u;if(c){u=U.getInstance(this._createUTCDate(d,t),c);}else{u=new U(this._createUTCDate(d,t).getTime());}return u;};
b.calculateWeekNumber=function(d,y,l,o){var w=0;var W=0;var f=o.getFirstDayOfWeek();var c=new L(l);if(c&&(c.getLanguage()=='en'&&c.getRegion()=='US')){var j=new U(d.getTime());j.setUTCFullYear(y,0,1);W=j.getUTCDay();var e=new U(d.getTime());e.setUTCDate(e.getUTCDate()-e.getUTCDay()+W);w=Math.round((e.getTime()-j.getTime())/86400000/7)+1;}else{var t=new U(d.getTime());t.setUTCDate(t.getUTCDate()-f);W=t.getUTCDay();t.setUTCDate(t.getUTCDate()-W+4);var F=new U(t.getTime());F.setUTCMonth(0,1);W=F.getUTCDay();var A=0;if(W>4){A=7;}var g=new U(F.getTime());g.setUTCDate(1-W+4+A);w=Math.round((t.getTime()-g.getTime())/86400000/7)+1;}return w;};
b.getFirstDateOfWeek=function(d){var u=new U(d.getTime()),f,F,l=a.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),c=l.getFirstDayOfWeek(),w;w=U.getWeekByDate(u.getCalendarType(),u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate());f=U.getFirstDateOfWeek(u.getCalendarType(),w.year,w.week);F=new U(U.UTC(f.year,f.month,f.day));while(F.getUTCDay()!==c){F.setUTCDate(F.getUTCDate()-1);}return new U(U.UTC(F.getUTCFullYear(),F.getUTCMonth(),F.getUTCDate(),d.getUTCHours(),d.getUTCMinutes(),d.getUTCSeconds())).getJSDate();};
b.getFirstDateOfMonth=function(d){var n=new U(d.getTime());n.setUTCDate(1);return n;};
b._getNumberOfWeeksForYear=function(y){var l=sap.ui.getCore().getConfiguration().getFormatLocale(),o=a.getInstance(new L(l)),c=new Date(Date.UTC(y,0,1)),i=c.getUTCDay(),n=52;if(o.getFirstDayOfWeek()===0){if(i===5||i===6){n=53;}}else{if(i===3||i===4){n=53;}}return n;};
b.monthsDiffer=function(d,D){return(d.getMonth()!==D.getMonth()||d.getFullYear()!==D.getFullYear());};
b.isDateLastInMonth=function(d){var n=new Date(d.getTime()+24*60*60*1000);return n.getUTCDate()<d.getUTCDate();};
b._updateUTCDate=function(d,y,m,D,h,M,s,i){if(q.isNumeric(y)){d.setUTCFullYear(y);}if(q.isNumeric(m)){d.setUTCMonth(m);}if(q.isNumeric(D)){d.setUTCDate(D);}if(q.isNumeric(h)){d.setUTCHours(h);}if(q.isNumeric(M)){d.setUTCMinutes(M);}if(q.isNumeric(s)){d.setUTCSeconds(s);}if(q.isNumeric(i)){d.setUTCMilliseconds(i);}};
b._checkJSDateObject=function(d){if(q.type(d)!=="date"){throw new Error("Date must be a JavaScript date object.");}};
b._checkYearInValidRange=function(y){if(!q.isNumeric(y)||(y<1||y>9999)){throw new Error("Year must be in valid range (between year 0001 and year 9999).");}};
b._isNextMonth=function(d,D){return(d.getMonth()>D.getMonth()&&d.getFullYear()===D.getFullYear())||d.getFullYear()>D.getFullYear();};
b._daysInMonth=function(c){this._checkCalendarDate(c);c=new C(c);c.setDate(1);c.setMonth(c.getMonth()+1);c.setDate(0);return c.getDate();};
b._isLastDateInMonth=function(c){return c.getDate()===b._daysInMonth(c);};
b._getFirstDateOfWeek=function(c){this._checkCalendarDate(c);var j=b.getFirstDateOfWeek(c.toUTCJSDate());j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());return C.fromLocalJSDate(j,c.getCalendarType());};
b._getFirstDateOfMonth=function(c){this._checkCalendarDate(c);var j=b.getFirstDateOfMonth(c.toUTCJSDate()).getJSDate();j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());return C.fromLocalJSDate(j,c.getCalendarType());};
b._minDate=function(c){return new C(1,0,1,c);};
b._maxDate=function(c){var o=new C(9999,11,1,c);o.setDate(this._daysInMonth(o));return new C(o);};
b._isBetween=function(d,s,e,i){this._checkCalendarDate(d);this._checkCalendarDate(s);this._checkCalendarDate(e);if(i){return d.isSameOrAfter(s)&&d.isSameOrBefore(e);}else{return d.isAfter(s)&&d.isBefore(e);}};
b._daysBetween=function(f,s){this._checkCalendarDate(f);this._checkCalendarDate(s);return Math.ceil((f.valueOf()-s.valueOf())/(this.HOURS24));};
b._isOutside=function(c,s,e){return!this._isBetween(c,s,e,true);};
b._isSameMonthAndYear=function(c,o){this._checkCalendarDate(c);this._checkCalendarDate(o);return c.getEra()===o.getEra()&&c.getYear()===o.getYear()&&c.getMonth()===o.getMonth();};
b._checkCalendarDate=function(c){if(!c||!(c instanceof C)){throw"Invalid calendar date: ["+c+"]. Expected: sap.ui.unified.calendar.CalendarDate";}};
b._getWeek=function(c){this._checkCalendarDate(c);return U.getWeekByDate(c.getCalendarType(),c.getYear(),c.getMonth(),c.getDate());};
b._areCurrentMinutesLessThan=function(m){var c=new Date().getMinutes();return m>=c;};
b._areCurrentMinutesMoreThan=function(m){var c=new Date().getMinutes();return m<=c;};
b._minutesBetween=function(f,s){var m=(s.getTime()-f.getTime())/1000;m=m/60;return Math.abs(Math.round(m));};
b._isWeekend=function(c,l){var d=c.getDay();return d===l.getWeekendStart()||d===l.getWeekendEnd();};
return b;},true);
sap.ui.predefine('sap/ui/unified/calendar/CustomMonthPicker',["sap/ui/core/Renderer","sap/ui/unified/Calendar",'sap/ui/unified/CalendarRenderer',"sap/ui/unified/calendar/Header","sap/ui/unified/DateRange","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(R,C,a,H,D,c,q){"use strict";
var b=C.extend("sap.ui.unified.internal.CustomMonthPicker",{renderer:R.extend(a)});
b.prototype._initializeHeader=function(){var h=new H(this.getId()+"--Head",{visibleButton1:false});h.attachEvent("pressPrevious",this._handlePrevious,this);h.attachEvent("pressNext",this._handleNext,this);h.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",h);};
b.prototype._shouldFocusB2OnTabNext=function(e){return c(this.getDomRef("content"),e.target);};
b.prototype.onAfterRendering=function(){this._showMonthPicker();};
b.prototype._selectYear=function(){var y=this.getAggregation("yearPicker");var f=this._getFocusedDate();f.setYear(y.getYear());this._focusDate(f,true);this._showMonthPicker();};
b.prototype._selectMonth=function(){var m=this.getAggregation("monthPicker");var s=this.getSelectedDates()[0];var f=this._getFocusedDate();f.setMonth(m.getMonth());if(!s){s=new D();}s.setStartDate(f.toLocalJSDate());this.addSelectedDate(s);this.fireSelect();};
b.prototype.onsapescape=function(e){this.fireCancel();};
return b;},true);
sap.ui.predefine('sap/ui/unified/calendar/CustomYearPicker',["sap/ui/core/Renderer","sap/ui/unified/Calendar","sap/ui/unified/CalendarRenderer","sap/ui/unified/calendar/Header","sap/ui/unified/DateRange","sap/ui/thirdparty/jquery"],function(R,C,a,H,D,q){"use strict";
var b=C.extend("sap.ui.unified.internal.CustomYearPicker",{renderer:R.extend(a)});
b.prototype._initializeHeader=function(){var h=new H(this.getId()+"--Head",{visibleButton1:false});h.attachEvent("pressPrevious",this._handlePrevious,this);h.attachEvent("pressNext",this._handleNext,this);h.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",h);};
b.prototype.onAfterRendering=function(){C.prototype.onAfterRendering.apply(this,arguments);var h=this.getAggregation("header");h.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");this._showYearPicker();};
b.prototype.onThemeChanged=function(){C.prototype.onThemeChanged.apply(this,arguments);var h=this.getAggregation("header");h.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");};
b.prototype._selectYear=function(){var y=this.getAggregation("yearPicker");var d=this.getSelectedDates()[0];if(!d){d=new D();}d.setStartDate(y.getDate());this.addSelectedDate(d);this.fireSelect();};
b.prototype.onsapescape=function(e){this.fireCancel();};
b.prototype._shouldFocusB2OnTabPrevious=function(e){return false;};
return b;},true);
sap.ui.predefine('sap/ui/unified/calendar/DatesRow',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/Month','sap/ui/unified/library',"./DatesRowRenderer","sap/ui/thirdparty/jquery"],function(C,a,M,l,D,q){"use strict";
var b=M.extend("sap.ui.unified.calendar.DatesRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true}}}});
b.prototype.init=function(){M.prototype.init.apply(this,arguments);this._iColumns=1;this._aWeekNumbers=[];};
b.prototype._setAriaRole=function(r){this._ariaRole=r;return this;};
b.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell";};
b.prototype.setStartDate=function(s){C._checkJSDateObject(s);var y=s.getFullYear();C._checkYearInValidRange(y);this.setProperty("startDate",s,true);this._oStartDate=a.fromLocalJSDate(s,this.getPrimaryCalendarType());if(this.getDomRef()){var o=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(s);this._bNoRangeCheck=false;if(o&&this.checkDateFocusable(o)){this.displayDate(o);}}return this;};
b.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=a.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oStartDate;};
b.prototype.setDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.setDate.apply(this,arguments);return this;};
b.prototype.displayDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.displayDate.apply(this,arguments);return this;};
b.prototype._setTopPosition=function(t){this._iTopPosition=t;};
b.prototype.setPrimaryCalendarType=function(c){M.prototype.setPrimaryCalendarType.apply(this,arguments);if(this._oStartDate){this._oStartDate=new a(this._oStartDate,c);}return this;};
b.prototype.setFirstDayOfWeek=function(f){if(f==-1){return this.setProperty("firstDayOfWeek",f,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};
b.prototype._handleBorderReached=function(c){var e=c.getParameter("event");var d=this.getDays();var o=this._getDate();var f=new a(o,this.getPrimaryCalendarType());if(e.type){switch(e.type){case"sapnext":case"sapnextmodifiers":f.setDate(f.getDate()+1);break;case"sapprevious":case"sappreviousmodifiers":f.setDate(f.getDate()-1);break;case"sappagedown":f.setDate(f.getDate()+d);break;case"sappageup":f.setDate(f.getDate()-d);break;default:break;}this.fireFocus({date:f.toLocalJSDate(),otherMonth:true,_outsideBorder:true});}};
b.prototype.checkDateFocusable=function(d){C._checkJSDateObject(d);if(this._bNoRangeCheck){return false;}var s=this._getStartDate();var e=new a(s,this.getPrimaryCalendarType());e.setDate(e.getDate()+this.getDays());var c=a.fromLocalJSDate(d,this.getPrimaryCalendarType());return c.isSameOrAfter(s)&&c.isBefore(e);};
b.prototype._renderHeader=function(){var s=this._getStartDate();var S=s.getDay();var L=this._getLocaleData();var w=this.$("Names").children();var W=[];if(this._bLongWeekDays||!this._bNamesLengthChecked){W=L.getDaysStandAlone("abbreviated");}else{W=L.getDaysStandAlone("narrow");}var c=L.getDaysStandAlone("wide");var i=0;for(i=0;i<w.length;i++){var $=q(w[i]);$.text(W[(i+S)%7]);$.attr("aria-label",c[(i+S)%7]);}if(this._getShowHeader()){var d=this.$("Head");if(d.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(r,this,L,s);r.flush(d[0]);r.destroy();}}};
b.prototype._getFirstWeekDay=function(){return this._getStartDate().getDay();};
b.prototype.getWeekNumbers=function(){var d=this.getDays(),L=this._getLocale(),o=this._getLocaleData(),c=this.getPrimaryCalendarType(),s=this._getStartDate(),e=new a(s,c),E=new a(s,c).setDate(e.getDate()+d),f=[];while(e.isBefore(E)){f.push(new a(e,c));e.setDate(e.getDate()+1);}this._aWeekNumbers=f.reduce(function(w,g){var W=C.calculateWeekNumber(g.toUTCJSDate(),g.getYear(),L,o);if(!w.length||w[w.length-1].number!==W){w.push({len:0,number:W});}w[w.length-1].len++;return w;},[]);return this._aWeekNumbers;};
b.prototype._getCachedWeekNumbers=function(){return this._aWeekNumbers;};
return b;});
sap.ui.predefine('sap/ui/unified/calendar/DatesRowRenderer',['sap/ui/core/Renderer','sap/ui/unified/calendar/CalendarDate','./MonthRenderer'],function(R,C,M){"use strict";var D=R.extend(M);
D.getStartDate=function(d){return d._getStartDate();};
D.getClass=function(r,d){var c="sapUiCalDatesRow sapUiCalRow";if(!d.getShowDayNamesLine()){c=c+" sapUiCalNoNameLine";}return c;};
D.addWrapperAdditionalStyles=function(r,d){if(d._iTopPosition){r.addStyle("top",d._iTopPosition+"px");r.writeStyles();}};
D.renderMonth=function(r,d,o){M.renderMonth.apply(this,arguments);this.renderWeekNumbers(r,d);};
D.renderWeekNumbers=function(r,d){var o,i,a,w;if(d.getShowWeekNumbers()&&d.getPrimaryCalendarType()===sap.ui.core.CalendarType.Gregorian){o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");r.write("<div id=\""+d.getId()+"-weeks\"");r.addClass("sapUiCalRowWeekNumbers");r.writeClasses();r.write(">");i=d.getDays();a=100/i;w=d.getWeekNumbers();w.forEach(function(W){r.write("<div");r.addClass('sapUiCalRowWeekNumber');r.writeClasses();r.addStyle("width",W.len*a+"%");r.writeStyles();r.writeAttribute("data-sap-ui-week",W.number);r.write(">"+o.getText('CALENDAR_DATES_ROW_WEEK_NUMBER',[W.number])+"</div>");});r.write("</div>");}};
D.renderHeader=function(r,d,o){var l=d._getLocaleData();var i=d.getId();var a=d.getDays();var w="";if(d._getShowHeader()){r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,d,l,o);r.write("</div>");}w=(100/a)+"%";if(d.getShowDayNamesLine()){r.write("<div id=\""+i+"-Names\" style=\"display: inline;\">");this.renderDayNames(r,d,l,o.getDay(),a,false,w);r.write("</div>");}};
D.renderHeaderLine=function(r,d,l,o){var I=d.getId();var a=d.getDays();var b=new C(o,d.getPrimaryCalendarType());var w="";var m=0;var c=[];var i=0;for(i=0;i<a;i++){m=b.getMonth();if(c.length>0&&c[c.length-1].iMonth==m){c[c.length-1].iDays++;}else{c.push({iMonth:m,iDays:1});}b.setDate(b.getDate()+1);}var e=l.getMonthsStandAlone("wide");for(i=0;i<c.length;i++){var f=c[i];w=(100/a*f.iDays)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(e[f.iMonth]);r.write("</div>");}};
D.renderDays=function(r,d,o){var a=d.getDays();var w=(100/a)+"%";var s=d.getShowDayNamesLine();if(!o){o=d._getFocusedDate();}var h=this.getDayHelper(d,o);if(!s){if(d._bLongWeekDays||!d._bNamesLengthChecked){h.aWeekDays=h.oLocaleData.getDaysStandAlone("abbreviated");}else{h.aWeekDays=h.oLocaleData.getDaysStandAlone("narrow");}h.aWeekDaysWide=h.oLocaleData.getDaysStandAlone("wide");}var b=new C(o,d.getPrimaryCalendarType());for(var i=0;i<a;i++){this.renderDay(r,d,b,h,false,false,i,w,!s);b.setDate(b.getDate()+1);}};
return D;},true);
sap.ui.predefine('sap/ui/unified/calendar/Header',['sap/ui/core/Control','sap/ui/unified/library',"./HeaderRenderer","sap/ui/dom/containsOrEquals"],function(C,l,H,c){"use strict";
var a=C.extend("sap.ui.unified.calendar.Header",{metadata:{library:"sap.ui.unified",properties:{textButton0:{type:"string",group:"Appearance"},additionalTextButton0:{type:"string",group:"Appearance"},ariaLabelButton0:{type:"string",group:"Misc"},visibleButton0:{type:"boolean",group:"Appearance",defaultValue:false},textButton1:{type:"string",group:"Appearance"},additionalTextButton1:{type:"string",group:"Appearance"},ariaLabelButton1:{type:"string",group:"Misc"},visibleButton1:{type:"boolean",group:"Appearance",defaultValue:true},textButton2:{type:"string",group:"Appearance"},additionalTextButton2:{type:"string",group:"Appearance"},ariaLabelButton2:{type:"string",group:"Misc"},visibleButton2:{type:"boolean",group:"Appearance",defaultValue:true},enabledPrevious:{type:"boolean",group:"Behavior",defaultValue:true},enabledNext:{type:"boolean",group:"Behavior",defaultValue:true}},events:{pressPrevious:{},pressNext:{},pressButton0:{},pressButton1:{},pressButton2:{}}}});
a.prototype.setTextButton0=function(t){_.call(this,0,t);return this;};
a.prototype.setAdditionalTextButton0=function(t){b.call(this,0,t);return this;};
a.prototype.setAriaLabelButton0=function(t){d.call(this,0,t);return this;};
a.prototype.setTextButton1=function(t){_.call(this,1,t);return this;};
a.prototype.setAdditionalTextButton1=function(t){b.call(this,1,t);return this;};
a.prototype.setAriaLabelButton1=function(t){d.call(this,1,t);return this;};
a.prototype.setTextButton2=function(t){_.call(this,2,t);return this;};
a.prototype.setAdditionalTextButton2=function(t){b.call(this,2,t);return this;};
a.prototype.setAriaLabelButton2=function(t){d.call(this,2,t);return this;};
a.prototype._setVisibleButton3=function(v){this._visibleButton3=v;this.invalidate();return this;};
a.prototype._getVisibleButton3=function(){return this._visibleButton3;};
a.prototype._setTextButton3=function(t){e.call(this,3,t);return this;};
a.prototype._getTextButton3=function(){return this._textButton3;};
a.prototype._setAdditionalTextButton3=function(t){f.call(this,3,t);return this;};
a.prototype._getAdditionalTextButton3=function(){return this._additionalTextButton3;};
a.prototype._setAriaLabelButton3=function(t){g.call(this,3,t);return this;};
a.prototype._getAriaLabelButton3=function(){return this._ariaLabelButton3;};
a.prototype._setVisibleButton4=function(v){this._visibleButton4=v;this.invalidate();return this;};
a.prototype._getVisibleButton4=function(){return this._visibleButton4;};
a.prototype._setTextButton4=function(t){e.call(this,4,t);return this;};
a.prototype._getTextButton4=function(){return this._textButton4;};
a.prototype._setAdditionalTextButton4=function(t){f.call(this,4,t);return this;};
a.prototype._getAdditionalTextButton4=function(){return this._additionalTextButton4;};
a.prototype._setAriaLabelButton4=function(t){g.call(this,4,t);return this;};
a.prototype._getAriaLabelButton4=function(){return this._ariaLabelButton4;};
a.prototype.setEnabledPrevious=function(E){this.setProperty("enabledPrevious",E,true);if(this.getDomRef()){if(E){this.$("prev").toggleClass("sapUiCalDsbl",false).removeAttr("disabled");}else{this.$("prev").toggleClass("sapUiCalDsbl",true).attr("disabled","disabled");}}return this;};
a.prototype.setEnabledNext=function(E){this.setProperty("enabledNext",E,true);if(this.getDomRef()){if(E){this.$("next").toggleClass("sapUiCalDsbl",false).removeAttr("disabled");}else{this.$("next").toggleClass("sapUiCalDsbl",true).attr("disabled","disabled");}}return this;};
a.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(c(this.getDomRef("prev"),E.target)&&this.getEnabledPrevious()){this.firePressPrevious();}else if(c(this.getDomRef("next"),E.target)&&this.getEnabledNext()){this.firePressNext();}else if(c(this.getDomRef("B0"),E.target)){this.firePressButton0();}else if(c(this.getDomRef("B1"),E.target)){this.firePressButton1();}else if(c(this.getDomRef("B2"),E.target)){this.firePressButton2();}else if(c(this.getDomRef("B3"),E.target)){this.fireEvent("pressButton3");}else if(c(this.getDomRef("B4"),E.target)){this.fireEvent("pressButton4");}};
a.prototype.onsapnext=function(E){E.preventDefault();};
function _(B,t){this.setProperty("textButton"+B,t,true);if(this.getDomRef()&&this["getVisibleButton"+B]()){if(this.$("B"+B+"-Text").get(0)){this.$("B"+B+"-Text").text(t);}else{this.$("B"+B).text(t);}}}
function b(B,t){var r=false;var o=this["getAdditionalTextButton"+B]();if(o==t){return;}if((!o&&t)||(o&&!t)){r=true;}this.setProperty("additionalTextButton"+B,t,!r);if(!r&&this.getDomRef()&&this["getVisibleButton"+B]()){this.$("B"+B+"-AddText").text(t);}}
function d(B,t){this.setProperty("ariaLabelButton"+B,t,true);if(this.getDomRef()&&this["getVisibleButton"+B]()){if(t){this.$("B"+B).attr("aria-label",t);}else{this.$("B"+B).removeAttr("aria-label");}}}
function e(B,t){this["_textButton"+B]=t;if(this.isActive()&&this["_getVisibleButton"+B]()){if(this.$("B"+B+"-Text").get(0)){this.$("B"+B+"-Text").text(t);}else{this.$("B"+B).text(t);}}}
function f(B,t){var r=false;var o=this["_getAdditionalTextButton"+B]();if(o==t){return;}if((!o&&t)||(o&&!t)){r=true;}this["_additionalTextButton"+B]=t;if(!r&&this.isActive()&&this["_getVisibleButton"+B]()){this.$("B"+B+"-AddText").text(t);}if(r){this.invalidate();}}
function g(B,t){this["_ariaLabelButton"+B]=t;if(this.isActive()&&this["_getVisibleButton"+B]()){if(t){this.$("B"+B).attr("aria-label",t);}else{this.$("B"+B).removeAttr("aria-label");}}}
return a;});
sap.ui.predefine('sap/ui/unified/calendar/HeaderRenderer',["sap/base/security/encodeXML"],function(e){"use strict";var M=5;var H={};
H.render=function(r,h){var l=sap.ui.getCore().getConfiguration().getLocale().getLanguage();var t=h.getTooltip_AsString();var I=h.getId();var a={};var L=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_NEXT");var s=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_PREV");r.write("<div");r.writeControlData(h);r.addClass("sapUiCalHead");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(h);r.write(">");r.write("<button");r.writeAttributeEscaped('id',I+'-prev');r.writeAttributeEscaped("title",s);r.writeAccessibilityState(null,{label:s});r.addClass("sapUiCalHeadPrev");if(!h.getEnabledPrevious()){r.addClass("sapUiCalDsbl");r.writeAttribute('disabled',"disabled");}r.writeAttribute('tabindex',"-1");r.writeClasses();r.write(">");r.writeIcon("sap-icon://slim-arrow-left",null,{title:null});r.write("</button>");var f=-1;var b=-1;var i=0;var B;for(i=0;i<M;i++){if(this.getVisibleButton(h,i)){if(f<0){f=i;}b=i;}}for(i=0;i<M;i++){if(l.toLowerCase()==="ja"||l.toLowerCase()==="zh"){B=M-1-i;if(this._isTwoMonthsCalendar(h)){switch(i){case 0:B=2;break;case 2:B=4;break;case 1:B=1;break;case 3:B=3;break;}}}else{B=i;}if(this._isTwoMonthsCalendar(h)){f=2;b=3;}this.renderCalendarButtons(r,h,I,f,b,a,B);}r.write("<button");r.writeAttributeEscaped('id',I+'-next');r.writeAttributeEscaped("title",L);r.writeAccessibilityState(null,{label:L});r.addClass("sapUiCalHeadNext");if(!h.getEnabledNext()){r.addClass("sapUiCalDsbl");r.writeAttribute('disabled',"disabled");}r.writeAttribute('tabindex',"-1");r.writeClasses();r.write(">");r.writeIcon("sap-icon://slim-arrow-right",null,{title:null});r.write("</button>");r.write("</div>");};
H.renderCalendarButtons=function(r,h,I,f,l,a,i){if(this.getVisibleButton(h,i)){r.write("<button");r.writeAttributeEscaped('id',I+'-B'+i);r.addClass("sapUiCalHeadB");r.addClass("sapUiCalHeadB"+i);if(f==i){r.addClass("sapUiCalHeadBFirst");}if(l==i){r.addClass("sapUiCalHeadBLast");}r.writeAttribute('tabindex',"-1");r.writeClasses();if(this.getAriaLabelButton(h,i)){a["label"]=this.getAriaLabelButton(h,i);}r.writeAccessibilityState(null,a);a={};r.write(">");var t=this.getTextButton(h,i)||"";var A=this.getAdditionalTextButton(h,i)||"";if(A){r.write("<span");r.writeAttributeEscaped('id',I+'-B'+i+"-Text");r.addClass("sapUiCalHeadBText");r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</span>");r.write("<span");r.writeAttributeEscaped('id',I+'-B'+i+"-AddText");r.addClass("sapUiCalHeadBAddText");r.writeClasses();r.write(">");r.writeEscaped(A);r.write("</span>");}else{r.writeEscaped(t);}r.write("</button>");}};
H.getVisibleButton=function(h,b){var v=false;if(h["getVisibleButton"+b]){v=h["getVisibleButton"+b]();}else if(h["_getVisibleButton"+b]){v=h["_getVisibleButton"+b]();}return v;};
H.getAriaLabelButton=function(h,b){var a;if(h["getAriaLabelButton"+b]){a=h["getAriaLabelButton"+b]();}else if(h["_getAriaLabelButton"+b]){a=h["_getAriaLabelButton"+b]();}return a;};
H.getTextButton=function(h,b){var t;if(h["getTextButton"+b]){t=h["getTextButton"+b]();}else if(h["_getTextButton"+b]){t=h["_getTextButton"+b]();}return t;};
H.getAdditionalTextButton=function(h,b){var t;if(h["getAdditionalTextButton"+b]){t=h["getAdditionalTextButton"+b]();}else if(h["_getAdditionalTextButton"+b]){t=h["_getAdditionalTextButton"+b]();}return t;};
H._isTwoMonthsCalendar=function(h){return(h.getParent()instanceof sap.ui.unified.Calendar&&(h.getParent().getMonths()>=2));};
return H;},true);
sap.ui.predefine('sap/ui/unified/calendar/Month',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/DateRange','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./MonthRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,D,L,I,a,b,c,l,d,e,f,M,g,K,q){"use strict";var h=e.CalendarType;var j=l.CalendarDayType;
var k=C.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"},restoreOldDate:{type:"boolean"}}},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});
k.prototype.init=function(){var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._oFormatYyyymmdd=d.getInstance({pattern:"yyyyMMdd",calendarType:h.Gregorian});this._oFormatLong=d.getInstance({style:"long",calendarType:i});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._iColumns=7;this._aVisibleDays=[];};
k.prototype._getAriaRole=function(){return"gridcell";};
k.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}this._aVisibleDays=null;};
k.prototype.onAfterRendering=function(){_.call(this);u.call(this);};
k.prototype.onmouseover=function(E){var T=q(E.target),S=this.getSelectedDates()[0],i,v;if(!this._isMarkingUnfinishedRangeAllowed()){return;}if(!T.hasClass('sapUiCalItemText')&&!T.hasClass('sapUiCalItem')){return;}if(T.hasClass('sapUiCalItemText')){T=T.parent();}i=parseInt(this._oFormatYyyymmdd.format(S.getStartDate()));v=T.data("sapDay");if(this.hasListeners("datehovered")){this.fireEvent("datehovered",{date1:i,date2:v});}else{this._markDatesBetweenStartAndHoveredDate(i,v);}};
k.prototype._markDatesBetweenStartAndHoveredDate=function(v,w){var x,$,y,i;x=this.$().find(".sapUiCalItem");if(v>w){v=v+w;w=v-w;v=v-w;}for(i=0;i<x.length;i++){$=q(x[i]);y=$.data('sapDay');if(y>v&&y<w){$.addClass('sapUiCalItemSelBetween');}else{$.removeClass('sapUiCalItemSelBetween');}}};
k.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!g(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){this._unbindMousemove(true);var S=this._selectDay(this._getDate());if(!S&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;t.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;t.call(this);}}};
k.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
k.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
k.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
k.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
k.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("disabledDates");return R;};
k.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};
k.prototype.setDate=function(i){var v=b.fromLocalJSDate(i,this.getPrimaryCalendarType());o.call(this,v,false);return this;};
k.prototype._setDate=function(i){var v=i.toLocalJSDate();this.setProperty("date",v,true);this._oDate=i;};
k.prototype._getDate=function(){if(!this._oDate){this._oDate=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oDate;};
k.prototype.displayDate=function(i){var v=b.fromLocalJSDate(i,this.getPrimaryCalendarType());o.call(this,v,true);return this;};
k.prototype.setPrimaryCalendarType=function(i){this.setProperty("primaryCalendarType",i);this._oFormatLong=d.getInstance({style:"long",calendarType:i});if(this._oDate){this._oDate=new b(this._oDate,i);}return this;};
k.prototype.setSecondaryCalendarType=function(i){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",i);this.invalidate();this._oFormatSecondaryLong=d.getInstance({style:"long",calendarType:i});return this;};
k.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};
k.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
k.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var v=new f(i);this._oLocaleData=L.getInstance(v);}return this._oLocaleData;};
k.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var v=new f(i);this._oFormatLong=d.getInstance({style:"long",calendarType:this.getPrimaryCalendarType()},v);if(this._oFormatSecondaryLong){this._oFormatSecondaryLong=d.getInstance({style:"long",calendarType:this._getSecondaryCalendarType()},v);}}return this._oFormatLong;};
k.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
k.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
k.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
k.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
k.prototype.getDisabledDates=function(){var P=this.getParent();if(P&&P.getDisabledDates){return P.getDisabledDates();}else{return this.getAggregation("disabledDates",[]);}};
k.prototype.getPrimaryCalendarType=function(){var P=this.getParent();if(P&&P.getPrimaryCalendarType){return P.getPrimaryCalendarType();}return this.getProperty("primaryCalendarType");};
k.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowMonthHeader){return P._getShowMonthHeader();}else{return this.getProperty("showHeader");}};
k.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
k.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("legend",[]);}};
k.prototype._getFirstDayOfWeek=function(){var P=this.getParent();var F=0;if(P&&P.getFirstDayOfWeek){F=P.getFirstDayOfWeek();}else{F=this.getProperty("firstDayOfWeek");}if(F<0||F>6){var i=this._getLocaleData();F=i.getFirstDayOfWeek();}return F;};
k.prototype._getNonWorkingDays=function(){var P=this.getParent();var N;if(P&&P.getNonWorkingDays){N=P.getNonWorkingDays();}else{N=this.getProperty("nonWorkingDays");}if(N&&!Array.isArray(N)){N=[];}return N;};
k.prototype._checkDateSelected=function(v){a._checkCalendarDate(v);var S=0;var w=this.getSelectedDates();var T=v.toUTCJSDate().getTime();var x=this.getPrimaryCalendarType();for(var i=0;i<w.length;i++){var R=w[i];var y=R.getStartDate();var z=0;if(y){y=b.fromLocalJSDate(y,x);z=y.toUTCJSDate().getTime();}var E=R.getEndDate();var A=0;if(E){E=b.fromLocalJSDate(E,x);A=E.toUTCJSDate().getTime();}if(T==z&&!E){S=1;break;}else if(T==z&&E){S=2;if(E&&T==A){S=5;}break;}else if(E&&T==A){S=3;break;}else if(E&&T>z&&T<A){S=4;break;}if(this.getSingleSelection()){break;}}return S;};
k.prototype._getDateTypes=function(v){a._checkCalendarDate(v);var T,w,N,x=[];var S=this.getSpecialDates();var y=v.toUTCJSDate().getTime();var U=new Date(Date.UTC(0,0,1));for(var i=0;i<S.length;i++){var R=S[i];var z=R.getStartDate();var A=a.MAX_MILLISECONDS;if(z){U.setUTCFullYear(z.getFullYear(),z.getMonth(),z.getDate());A=U.getTime();}var E=R.getEndDate();var B=-a.MAX_MILLISECONDS;if(E){U.setUTCFullYear(E.getFullYear(),E.getMonth(),E.getDate());B=U.getTime();}N=R.getType()===j.NonWorking;if((y==A&&!E)||(y>=A&&y<=B)){if(!N&&!T){T={type:R.getType(),tooltip:R.getTooltip_AsString()};x.push(T);}else if(N&&!w){w={type:R.getType(),tooltip:R.getTooltip_AsString()};x.push(w);}if(T&&w){break;}}}return x;};
k.prototype._checkDateEnabled=function(v){a._checkCalendarDate(v);var E=true;var w=this.getDisabledDates();var T=v.toUTCJSDate().getTime();var x=this.getPrimaryCalendarType();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(T<P._oMinDate.valueOf()||T>P._oMaxDate.valueOf()){return false;}}for(var i=0;i<w.length;i++){var R=w[i];var S=R.getStartDate();var y=0;if(S){S=b.fromLocalJSDate(S,x);y=S.toUTCJSDate().getTime();}var z=R.getEndDate();var A=0;if(z){z=b.fromLocalJSDate(z,x);A=z.toUTCJSDate().getTime();}if(z){if(T>y&&T<A){E=false;break;}}else if(T==y){E=false;break;}}return E;};
k.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};
k.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){this._unbindMousemove(true);}var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(this._sLastTargetId&&this._sLastTargetId==T.attr("id")){return;}this._sLastTargetId=T.attr("id");if(T.hasClass("sapUiCalItem")){var O=this._getDate();if(!g(this.getDomRef(),E.target)){var S=this.getSelectedDates();if(S.length>0&&this.getSingleSelection()){var i=S[0].getStartDate();if(i){i=b.fromLocalJSDate(i,this.getPrimaryCalendarType());}var v=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(T.attr("data-sap-day")));if(v.isSameOrAfter(i)){r.call(this,i,v);}else{r.call(this,v,i);}}}else{var F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(T.attr("data-sap-day")),this.getPrimaryCalendarType());if(!F.isSame(O)){if(T.hasClass("sapUiCalItemOtherMonth")){this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}else{this._setDate(F);var w=this._selectDay(F,true);if(w){this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}this._bMoveChange=true;}}}}};
k.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};
k.prototype.onmouseup=function(E){var N=E.button!==2;if(this._bMouseMove){this._unbindMousemove(true);var F=this._getDate();var v=this._oItemNavigation.getItemDomRefs();for(var i=0;i<v.length;i++){var $=q(v[i]);if(!$.hasClass("sapUiCalItemOtherMonth")){if($.attr("data-sap-day")==this._oFormatYyyymmdd.format(F.toUTCJSDate(),true)){$.focus();break;}}}if(this._bMoveChange){var S=this._selectDay(F);if(!S&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;t.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;t.call(this);}else if(D.support.touch&&N&&this._areMouseEventCoordinatesInThreshold(E.clientX,E.clientY,10)){var w=E.target.classList,x=(w.contains("sapUiCalItemText")||w.contains("sapUiCalDayName")),y=w.contains("sapUiCalWeekNum"),z=this._getSelectedDateFromEvent(E);if(y&&this._isWeekSelectionAllowed()){this._handleWeekSelection(z,true);}else if(x&&E.shiftKey&&this._isConsecutiveDaysSelectionAllowed()){this._handleConsecutiveDaysSelection(z);}else if(x){this._selectDay(z,false,false);t.call(this);}}};
k.prototype.onsapselect=function(E){var S=this._selectDay(this._getSelectedDateFromEvent(E));if(S){t.call(this);}E.stopPropagation();E.preventDefault();};
k.prototype.onsapselectmodifiers=function(E){var S=this._getSelectedDateFromEvent(E),F;if(this._isWeekSelectionAllowed()&&E.shiftKey&&E.keyCode===K.SPACE){F=a._getFirstDateOfWeek(S);this._handleWeekSelection(F,false);}else if(this._isConsecutiveDaysSelectionAllowed()&&E.shiftKey&&E.keyCode===K.ENTER){this._handleConsecutiveDaysSelection(S);}E.preventDefault();};
k.prototype.onsappageupmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y-10);}else{F.setYear(y-1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};
k.prototype.onsappagedownmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y+10);}else{F.setYear(y+1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};
k.prototype._updateSelection=function(){var S=this.getSelectedDates();if(S.length>0){var i=this.getPrimaryCalendarType();var v=S.map(function(w){var x=w.getStartDate();if(x){return b.fromLocalJSDate(x,i);}});var E=S[0].getEndDate();if(E){E=b.fromLocalJSDate(E,i);}r.call(this,v,E);}};
k.prototype._isValueInThreshold=function(R,v,T){var i=R-T,U=R+T;return v>=i&&v<=U;};
k.prototype._areMouseEventCoordinatesInThreshold=function(i,v,T){return this._isValueInThreshold(this._oMousedownPosition.clientX,i,T)&&this._isValueInThreshold(this._oMousedownPosition.clientY,v,T);};
k.prototype._bindMousemove=function(F){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;if(F){this.fireEvent("_bindMousemove");}};
k.prototype._unbindMousemove=function(F){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;this._sLastTargetId=undefined;if(F){this.fireEvent("_unbindMousemove");}};
k.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var w=this.$().find(".sapUiCalWH");var v=this._getLocaleData();var S=this._getFirstWeekDay();var x=v.getDaysStandAlone("abbreviated",this.getPrimaryCalendarType());for(var i=0;i<w.length;i++){var W=w[i];q(W).text(x[(i+S)%7]);}u.call(this);};
k.prototype._handleBorderReached=function(i){var E=i.getParameter("event");var v=0;var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==K.ARROW_DOWN){F.setDate(F.getDate()+7);}else{F.setDate(F.getDate()+1);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==K.ARROW_UP){F.setDate(F.getDate()-7);}else{F.setDate(F.getDate()-1);}break;case"sappagedown":v=F.getMonth()+1;F.setMonth(v);if(v%12!=F.getMonth()){while(v!=F.getMonth()){F.setDate(F.getDate()-1);}}break;case"sappageup":v=F.getMonth()-1;F.setMonth(v);if(v<0){v=11;}if(v!=F.getMonth()){while(v!=F.getMonth()){F.setDate(F.getDate()-1);}}break;default:break;}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});if(this._isMarkingUnfinishedRangeAllowed()){var w=this.getSelectedDates()[0],P=parseInt(this._oFormatYyyymmdd.format(w.getStartDate())),x=parseInt(this._oFormatYyyymmdd.format(F.toLocalJSDate()));this._markDatesBetweenStartAndHoveredDate(P,x);}}};
k.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);var v=this._getDate();var w=b.fromLocalJSDate(i,this.getPrimaryCalendarType());return a._isSameMonthAndYear(w,v);};
k.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
k.prototype._renderHeader=function(){if(this._getShowHeader()){var i=this._getDate();var v=this._getLocaleData();var w=v.getMonthsStandAlone("wide",this.getPrimaryCalendarType());this.$("Head").text(w[i.getMonth()]);}};
k.prototype._getFirstWeekDay=function(){return this._getFirstDayOfWeek();};
k.prototype._isMonthNameLong=function(w){var i;var W;for(i=0;i<w.length;i++){W=w[i];if(Math.abs(W.clientWidth-W.scrollWidth)>1){return true;}}return false;};
k.prototype._getVisibleDays=function(S,i){var N,v,w,x,F,y,Y;if(!S){return this._aVisibleDays;}this._aVisibleDays=[];y=this._getFirstDayOfWeek();F=new b(S,this.getPrimaryCalendarType());F.setDate(1);x=F.getDay()-y;if(x<0){x=7+x;}if(x>0){F.setDate(1-x);}v=new b(F);N=(S.getMonth()+1)%12;do{Y=v.getYear();w=new b(v,this.getPrimaryCalendarType());if(i&&Y<1){w._bBeforeFirstYear=true;this._aVisibleDays.push(w);}else if(Y>0&&Y<10000){this._aVisibleDays.push(w);}v.setDate(v.getDate()+1);}while(v.getMonth()!==N||v.getDay()!==y);return this._aVisibleDays;};
k.prototype._handleMousedown=function(E,F){var w=E.target.classList.contains("sapUiCalWeekNum"),i=!E.button,S=this._getSelectedDateFromEvent(E);if(!i||D.support.touch){return this;}if(w){this._isWeekSelectionAllowed()&&this._handleWeekSelection(S,true);return this;}else if(E.shiftKey&&this._isConsecutiveDaysSelectionAllowed()){this._handleConsecutiveDaysSelection(S);return this;}var v=this._selectDay(F);if(v){this._bMousedownChange=true;}if(this._bMouseMove){this._unbindMousemove(true);this._bMoveChange=false;this._oMoveSelectedDate=undefined;}else if(v&&this.getIntervalSelection()&&this.$().is(":visible")){this._bindMousemove(true);this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}E.preventDefault();E.setMark("cancelAutoClose");};
k.prototype._getSelectedDateFromEvent=function(E){var $=q(E.target),i=$.attr("data-sap-day")||$.parent().attr("data-sap-day"),P=this._oFormatYyyymmdd.parse(i);return P?b.fromLocalJSDate(P,this.getPrimaryCalendarType()):null;};
k.prototype._handleWeekSelection=function(S,F){var i=a.calculateWeekNumber(S.toUTCJSDate(),S.getYear(),this._getLocale(),this._getLocaleData()),E=this._getLastWeekDate(S),v=this.getSingleSelection(),w=this.getIntervalSelection();if(!v&&!w){this._handleWeekSelectionByMultipleDays(i,S,E);}else if(v&&w){this._handleWeekSelectionBySingleInterval(i,S,E);}F&&this._focusDate(S);return this;};
k.prototype._handleConsecutiveDaysSelection=function(E){var S=this.getSelectedDates(),i=S.length&&S[S.length-1].getStartDate(),v=i?b.fromLocalJSDate(i):E,w;w=this._areAllDaysBetweenSelected(v,E);this._toggleDaysBetween(v,E,!w);return this;};
k.prototype._isWeekSelectionAllowed=function(){var S=this.getSingleSelection(),i=this.getIntervalSelection(),v=this.getPrimaryCalendarType(),w=this.getFirstDayOfWeek()!==-1,x=!S&&!i,y=S&&i,A=y||x;return v===h.Gregorian&&!w&&A;};
k.prototype._isConsecutiveDaysSelectionAllowed=function(){var S=this.getSingleSelection(),i=this.getIntervalSelection();return!S&&!i;};
k.prototype._isMarkingUnfinishedRangeAllowed=function(){var S=this.getSelectedDates()[0],v=!!(S&&S.getStartDate()&&!S.getEndDate());return(this.getIntervalSelection()&&v);};
k.prototype._handleWeekSelectionByMultipleDays=function(w,S,E){var i,v;if(this._areAllDaysBetweenSelected(S,E)){i=null;}else{i=new c({startDate:S.toLocalJSDate(),endDate:E.toLocalJSDate()});}v=this.fireWeekNumberSelect({weekNumber:w,weekDays:i});if(v){this._toggleDaysBetween(S,E,!!i);}return this;};
k.prototype._handleWeekSelectionBySingleInterval=function(w,S,E){var i=new c({startDate:S.toLocalJSDate(),endDate:E.toLocalJSDate()}),v=this.getParent(),A=this,x;if(v&&v.getSelectedDates){A=v;}if(this._isIntervalSelected(i)){i=null;}x=this.fireWeekNumberSelect({weekNumber:w,weekDays:i});if(x){A.removeAllSelectedDates();A.addSelectedDate(i);}return this;};
k.prototype._isIntervalSelected=function(i){var S=this.getSelectedDates(),v=S.length&&S[0],w=v&&v.getEndDate();return v&&v.getStartDate().getTime()===i.getStartDate().getTime()&&w&&v.getEndDate().getTime()===i.getEndDate().getTime();};
k.prototype._getLastWeekDate=function(w){return new b(w).setDate(w.getDate()+6);};
k.prototype._toggleDaysBetween=function(S,E,i){var A=this._arrangeStartAndEndDates(S,E),v=new b(A.startDate),w;do{w=this._checkDateSelected(v);if((!w&&i)||(w&&!i)){this._selectDay(v);t.call(this);}v.setDate(v.getDate()+1);}while(v.isSameOrBefore(A.endDate));return this;};
k.prototype._areAllDaysBetweenSelected=function(S,E){var A=this._arrangeStartAndEndDates(S,E),i=new b(A.startDate),v=true;do{if(!this._checkDateSelected(i)){v=false;break;}i.setDate(i.getDate()+1);}while(i.isSameOrBefore(A.endDate));return v;};
k.prototype._arrangeStartAndEndDates=function(S,E){var A=S.isSameOrBefore(E);return{startDate:A?S:E,endDate:A?E:S};};
k.prototype._selectDay=function(v,w){if(!this._checkDateEnabled(v)){return false;}var S=this.getSelectedDates();var x;var y=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var A=this;var z;var B=this.getPrimaryCalendarType();if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){x=S[0];z=x.getStartDate();if(z){z=b.fromLocalJSDate(z,B);}}else{x=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",x,true);}if(this.getIntervalSelection()&&(!x.getEndDate()||w)&&z){var E;if(v.isBefore(z)){E=z;z=v;if(!w){x.setProperty("startDate",z.toLocalJSDate(),true);x.setProperty("endDate",E.toLocalJSDate(),true);}}else if(v.isSameOrAfter(z)){E=v;if(!w){x.setProperty("endDate",E.toLocalJSDate(),true);}}r.call(this,z,E);}else{r.call(this,v);x.setProperty("startDate",v.toLocalJSDate(),true);x.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var F=this._checkDateSelected(v);if(F>0){for(i=0;i<S.length;i++){z=S[i].getStartDate();if(z&&v.isSame(b.fromLocalJSDate(z,B))){A.removeAggregation("selectedDates",i,true);break;}}}else{x=new sap.ui.unified.DateRange({startDate:v.toLocalJSDate()});A.addAggregation("selectedDates",x,true);}Y=this._oFormatYyyymmdd.format(v.toUTCJSDate(),true);for(i=0;i<y.length;i++){$=q(y[i]);if($.attr("data-sap-day")==Y){if(F>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;};
function _(){var y=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true);var v=0;var R=this.$("days").get(0);var w=this.$("days").find(".sapUiCalItem");for(var i=0;i<w.length;i++){var $=q(w[i]);if($.attr("data-sap-day")===y){v=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,m,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,n,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(this._iColumns>1){this._oItemNavigation.setHomeEndColumnMode(true,true);}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this._iColumns,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(w);this._oItemNavigation.setFocusedIndex(v);this._oItemNavigation.setPageSize(w.length);}
function m(v){var w=v.getParameter("index");var E=v.getParameter("event");if(!E){return;}var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());var x=false;var y=true;var z=this._oItemNavigation.getItemDomRefs();var i=0;var $=q(z[w]);var A;if($.hasClass("sapUiCalItemOtherMonth")){if(E.type=="saphomemodifiers"&&(E.metaKey||E.ctrlKey)){F.setDate(1);this._focusDate(F);}else if(E.type=="sapendmodifiers"&&(E.metaKey||E.ctrlKey)){for(i=z.length-1;i>0;i--){A=q(z[i]);if(!A.hasClass("sapUiCalItemOtherMonth")){F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(A.attr("data-sap-day")),this.getPrimaryCalendarType());break;}}this._focusDate(F);}else{x=true;F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),this.getPrimaryCalendarType());if(!F){F=new b(O);}this._focusDate(O);if(E.type=="mousedown"||(this._sTouchstartYyyyMMdd&&E.type=="focusin"&&this._sTouchstartYyyyMMdd==$.attr("data-sap-day"))){y=false;this.fireFocus({date:O.toLocalJSDate(),otherMonth:false,restoreOldDate:true});}if(E.originalEvent&&E.originalEvent.type=="touchstart"){this._sTouchstartYyyyMMdd=$.attr("data-sap-day");}else{this._sTouchstartYyyyMMdd=undefined;}}}else{if(q(E.target).hasClass("sapUiCalWeekNum")){this._focusDate(F);}else{F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),this.getPrimaryCalendarType());this._setDate(F);}this._sTouchstartYyyyMMdd=undefined;}if(E.type=="mousedown"&&this.getIntervalSelection()){this._sLastTargetId=$.attr("id");}if(y){this.fireFocus({date:F.toLocalJSDate(),otherMonth:x});}if(E.type=="mousedown"){this._handleMousedown(E,F,w);}if(E.type==="sapnext"||E.type==="sapprevious"){var S=this.getSelectedDates()[0],B,G;if(!this._isMarkingUnfinishedRangeAllowed()){return;}B=parseInt(this._oFormatYyyymmdd.format(S.getStartDate()));G=$.data("sapDay");this._markDatesBetweenStartAndHoveredDate(B,G);}}
function n(i){var v=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();if(this.getIntervalSelection()){var w=this._oItemNavigation.getItemDomRefs();this._sLastTargetId=w[v].id;}this._handleMousedown(E,F,v);}}
function o(i,N){a._checkCalendarDate(i);var y=i.getYear();a._checkYearInValidRange(y);var F=true;if(!this.getDate()||!i.isSame(b.fromLocalJSDate(this.getDate(),i.getCalendarType()))){var v=new b(i);F=this.checkDateFocusable(i.toLocalJSDate());this.setProperty("date",i.toLocalJSDate(),true);this._oDate=v;}if(this.getDomRef()){if(F){this._focusDate(this._oDate,true,N);}else{p.call(this,N);}}}
k.prototype._focusDate=function(v,S,w){if(!S){this.setDate(v.toLocalJSDate());}var y=this._oFormatYyyymmdd.format(v.toUTCJSDate(),true);var x=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<x.length;i++){$=q(x[i]);if($.attr("data-sap-day")==y){if(document.activeElement!=x[i]){if(w){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}};
function p(N){var v=this.getRenderer().getStartDate(this);var $=this.$("days");var w=this.$("weeks");var x;var y;var i=0;var z=0;if(this._sLastTargetId){x=this._oItemNavigation.getItemDomRefs();for(i=0;i<x.length;i++){y=q(x[i]);if(y.attr("id")==this._sLastTargetId){z=i;break;}}}if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderDays(R,this,v);R.flush($[0]);if(w.length){this.getRenderer().renderWeekNumbers(R,this);R.flush(w[0]);}R.destroy();}this._renderHeader();this.fireEvent("_renderMonth",{days:$.find(".sapUiCalItem").length});_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}if(this._sLastTargetId){x=this._oItemNavigation.getItemDomRefs();if(z<=x.length-1){y=q(x[z]);this._sLastTargetId=y.attr("id");}}}
function r(S,E){if(!Array.isArray(S)){S=[S];}var v=this._oItemNavigation.getItemDomRefs();var $;var i=0;var w=false;var x=false;if(!E){var y=S.map(function(A){return this._oFormatYyyymmdd.format(A.toUTCJSDate(),true);},this);for(i=0;i<v.length;i++){$=q(v[i]);w=false;x=false;if(y.indexOf($.attr("data-sap-day"))>-1){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");w=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}s.call(this,$,w,x);}}else{var z;for(i=0;i<v.length;i++){$=q(v[i]);w=false;x=false;z=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),h.Gregorian);if(z.isSame(S[0])){$.addClass("sapUiCalItemSelStart");w=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&z.isSame(E)){$.addClass("sapUiCalItemSelEnd");x=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&a._isBetween(z,S[0],E)){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&z.isSame(E)){$.addClass("sapUiCalItemSelEnd");x=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}s.call(this,$,w,x);}}}
function s($,S,E){if(!this.getIntervalSelection()){return;}var v="";var w=[];var x=this.getId();var y=false;v=$.attr("aria-describedby");if(v){w=v.split(" ");}var z=-1;var A=-1;for(var i=0;i<w.length;i++){var B=w[i];if(B==(x+"-Start")){z=i;}if(B==(x+"-End")){A=i;}}if(z>=0&&!S){w.splice(z,1);y=true;if(A>z){A--;}}if(A>=0&&!E){w.splice(A,1);y=true;}if(z<0&&S){w.push(x+"-Start");y=true;}if(A<0&&E){w.push(x+"-End");y=true;}if(y){v=w.join(" ");$.attr("aria-describedby",v);}}
function t(){if(this._bMouseMove){this._unbindMousemove(true);}this.fireSelect();}
function u(){if(!this._bNamesLengthChecked){var w;var W=this.$().find(".sapUiCalWH");var T=this._isMonthNameLong(W);var i=0;if(T){this._bLongWeekDays=false;var v=this._getLocaleData();var S=this._getFirstWeekDay();var x=v.getDaysStandAlone("narrow",this.getPrimaryCalendarType());for(i=0;i<W.length;i++){w=W[i];q(w).text(x[(i+S)%7]);}}else{this._bLongWeekDays=true;}this._bNamesLengthChecked=true;}}
return k;});
sap.ui.predefine('sap/ui/unified/calendar/MonthPicker',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/library','sap/ui/core/Locale',"./MonthPickerRenderer","sap/ui/thirdparty/jquery"],function(C,D,L,I,l,a,M,q){"use strict";
var c=C.extend("sap.ui.unified.calendar.MonthPicker",{metadata:{library:"sap.ui.unified",properties:{month:{type:"int",group:"Data",defaultValue:0},months:{type:"int",group:"Appearance",defaultValue:12},columns:{type:"int",group:"Appearance",defaultValue:3},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"}},events:{select:{},pageChange:{}}}});
c.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._iMinMonth=0;this._iMaxMonth=11;};
c.prototype.onAfterRendering=function(){_.call(this);j.call(this);};
c.prototype.setMonth=function(m){this.setProperty("month",m,true);m=this.getProperty("month");if(m<0||m>11){throw new Error("Property month must be between 0 and 11; "+this);}if(this.getDomRef()){if(this.getMonths()<12){var s=this.getStartMonth();if(m>=s&&m<=s+this.getMonths()-1){h.call(this,m,true);this._oItemNavigation.focusItem(m-s);}else{k.call(this,m);}}else{h.call(this,m,true);this._oItemNavigation.focusItem(m);}}return this;};
c.prototype._getLocale=function(){var p=this.getParent();if(p&&p._getLocale){return p._getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
c.prototype._getLocaleData=function(){var p=this.getParent();if(p&&p._getLocaleData){return p._getLocaleData();}else if(!this._oLocaleData){var s=this._getLocale();var o=new a(s);this._oLocaleData=L.getInstance(o);}return this._oLocaleData;};
c.prototype.onsapspace=function(E){E.preventDefault();};
c.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var m=i+this.getStartMonth();if(m>=this._iMinMonth&&m<=this._iMaxMonth){h.call(this,m);this.fireSelect();}};
c.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};
c.prototype.onmouseup=function(E){if(this._bMousedownChange){this._bMousedownChange=false;this.fireSelect();}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)){var i=this._oItemNavigation.getFocusedIndex();var m=i+this.getStartMonth();h.call(this,m);this.fireSelect();}};
c.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;var m=this._oItemNavigation.getItemDomRefs();this._bLongMonth=false;var o=this._getLocaleData();var b=o.getMonthsStandAlone("wide",this.getPrimaryCalendarType());for(var i=0;i<m.length;i++){var $=q(m[i]);$.text(b[i]);}j.call(this);};
c.prototype.nextPage=function(){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();m=m+b;if(m>11){m=11;}k.call(this,m);return this;};
c.prototype.previousPage=function(){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();m=m-b;if(m<0){m=0;}k.call(this,m);return this;};
c.prototype.setMinMax=function(m,b){if(m==this._iMinMonth&&b==this._iMaxMonth){return this;}m=parseInt(m);if(isNaN(m)||m<0||m>11){m=0;}b=parseInt(b);if(isNaN(b)||b<0||b>11){b=11;}if(m<=b){this._iMinMonth=m;this._iMaxMonth=b;}else{this._iMaxMonth=m;this._iMinMonth=b;}if(this.getDomRef()){var n=this._oItemNavigation.getItemDomRefs();var o=this.getId().length+2;for(var i=0;i<n.length;i++){var $=q(n[i]);var p=parseInt($.attr("id").slice(o));if(p<this._iMinMonth||p>this._iMaxMonth){$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}else{$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}}}return this;};
c.prototype.getStartMonth=function(){if(this.getMonths()<12){var F=this._oItemNavigation.getItemDomRefs()[0];return parseInt(F.id.slice(this.getId().length+2));}else{return 0;}};
c.prototype._isValueInThreshold=function(r,v,t){var i=r-t,u=r+t;return v>=i&&v<=u;};
function _(){var r=this.getDomRef();var b=this.$().find(".sapUiCalItem");var i=this.getColumns();var m=this.getMonths();var n=true;if(m<12){n=false;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,d,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,e,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,g,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(b);this._oItemNavigation.setCycling(n);this._oItemNavigation.setColumns(i,true);var o=this.getMonth()-this.getStartMonth();this._oItemNavigation.setFocusedIndex(o);this._oItemNavigation.setPageSize(b.length);}
function d(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){f.call(this,E,i);}}
function e(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){f.call(this,E,i);}}
function f(E,i){if(E.button||D.support.touch){return;}var m=i+this.getStartMonth();if(m>=this._iMinMonth&&m<=this._iMaxMonth){h.call(this,m);this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");}
function g(o){var E=o.getParameter("event");if(E.type){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();switch(E.type){case"sapnext":case"sapnextmodifiers":if(m<11){m++;k.call(this,m,true);}break;case"sapprevious":case"sappreviousmodifiers":if(m>0){m--;k.call(this,m,true);}break;case"sappagedown":if(m<12-b){m=m+b;k.call(this,m,true);}else if(b===12){this.firePageChange({offset:1});}break;case"sappageup":if(m>b){m=m-b;k.call(this,m,true);}else if(b===12){this.firePageChange({offset:-1});}break;default:break;}}}
function h(m,n){var b=this._oItemNavigation.getItemDomRefs();var $;var s=this.getId()+"-m"+m;for(var i=0;i<b.length;i++){$=q(b[i]);if($.attr("id")==s){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}}if(!n){this.setProperty("month",m,true);}}
function j(){if(!this._bNamesLengthChecked){var i=0;var m=this._oItemNavigation.getItemDomRefs();var t=false;var n=this.getMonths();var B=Math.ceil(12/n);var o=n-1;for(var b=0;b<B;b++){if(n<12){k.call(this,o);o=o+n;if(o>11){o=11;}}for(i=0;i<m.length;i++){var p=m[i];if(Math.abs(p.clientWidth-p.scrollWidth)>1){t=true;break;}}if(t){break;}}if(n<12){o=this.getMonth();k.call(this,o);}if(t){this._bLongMonth=false;var r=this._getLocaleData();var s=this.getPrimaryCalendarType();var u=r.getMonthsStandAlone("abbreviated",s);var v=r.getMonthsStandAlone("wide",s);for(i=0;i<m.length;i++){var $=q(m[i]);$.text(u[i]);$.attr("aria-label",v[i]);}}else{this._bLongMonth=true;}this._bNamesLengthChecked=true;}}
function k(m,F){var b=this._oItemNavigation.getItemDomRefs();if(b.length>11){return;}var n=b.length;var s=Math.floor(m/n)*n;if(s+n>12){s=12-n;}var o=this._getLocaleData();var p=[];var r=[];var t=this.getPrimaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){p=o.getMonthsStandAlone("wide",t);}else{p=o.getMonthsStandAlone("abbreviated",t);r=o.getMonthsStandAlone("wide",t);}var S=this.getMonth();for(var i=0;i<b.length;i++){var u=i+s;var $=q(b[i]);$.text(p[i+s]);$.attr("id",this.getId()+"-m"+(i+s));if(!this._bLongMonth){$.attr("aria-label",r[i+s]);}if(u==S){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if(u<this._iMinMonth||u>this._iMaxMonth){$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}else{$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}}this._oItemNavigation.focusItem(m-s);if(F){this.firePageChange();}}
return c;});
sap.ui.predefine('sap/ui/unified/calendar/MonthPickerRenderer',[],function(){"use strict";var M={};
M.render=function(r,m){var a=m.getMonth();var b=m.getMonths();var s=0;var c=m.getColumns();var t=m.getTooltip_AsString();var l=m._getLocaleData();var I=m.getId();var w="";var d=[];var e=[];var C=m.getPrimaryCalendarType();if(m._bLongMonth||!m._bNamesLengthChecked){d=l.getMonthsStandAlone("wide",C);}else{d=l.getMonthsStandAlone("abbreviated",C);e=l.getMonthsStandAlone("wide",C);}r.write("<div");r.writeControlData(m);r.addClass("sapUiCalMonthPicker");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:"false"});r.write(">");var A;if(b>12){b=12;}else if(b<12){s=Math.floor(a/b)*b;if(s+b>12){s=12-b;}}if(c>0){w=(100/c)+"%";}else{w=(100/b)+"%";}for(var i=0;i<b;i++){var f=i+s;A={role:"gridcell"};if(!m._bLongMonth&&m._bNamesLengthChecked){A["label"]=e[f];}if(c>0&&i%c==0){r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.write(">");}r.write("<div");r.writeAttribute("id",I+"-m"+(f));r.addClass("sapUiCalItem");if(f==a){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(f<m._iMinMonth||f>m._iMaxMonth){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.addStyle("width",w);r.writeClasses();r.writeStyles();r.writeAccessibilityState(null,A);r.write(">");r.write(d[f]);r.write("</div>");if(c>0&&((i+1)%c==0)){r.write("</div>");}}r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthRenderer',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegend','sap/ui/unified/CalendarLegendRenderer','sap/ui/core/library','sap/ui/unified/library',"sap/base/Log"],function(C,a,b,c,d,l,L){"use strict";var e=l.CalendarDayType;var f=d.CalendarType;var M={};
M.render=function(r,m){var D=this.getStartDate(m);var t=m.getTooltip_AsString();var g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var i=m.getId();var A={value:i+"-Descr",append:true};var w=m.getWidth();r.write("<div");r.writeControlData(m);r.addClass(this.getClass(r,m));if(m._getSecondaryCalendarType()){r.addClass("sapUiCalMonthSecType");}r.writeClasses();this.addWrapperAdditionalStyles(r,m);if(t){r.writeAttributeEscaped("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}if(w){r.addStyle("width",w);r.writeStyles();}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+g.getText("CALENDAR_DIALOG")+"</span>");if(m.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+g.getText("CALENDAR_START_DATE")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+g.getText("CALENDAR_END_DATE")+"</span>");}this.renderMonth(r,m,D);r.write("</div>");};
M.addWrapperAdditionalStyles=function(){};
M.getStartDate=function(m){return m._getDate();};
M.getClass=function(r,m){var s="sapUiCalMonthView",g=m.getPrimaryCalendarType(),S=m.getShowWeekNumbers();if(g==f.Islamic||!S){s=s+" sapUiCalNoWeekNum";}return s;};
M.renderMonth=function(r,m,D){var i=m.getId();this.renderHeader(r,m,D);r.write("<div id=\""+i+"-days\" class=\"sapUiCalItems\" role=\"row\">");this.renderDays(r,m,D);r.write("</div>");};
M.renderHeader=function(r,m,D){var o=m._getLocaleData();var F=m._getFirstDayOfWeek();var i=m.getId();var g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this.renderHeaderLine(r,m,o,D);r.write("<div");r.writeAttribute("id",i+"-CW");r.addStyle("display","none");r.writeStyles();r.writeAccessibilityState(null,{role:"columnheader"});r.write(">");r.write(g.getText("CALENDAR_WEEK"));r.write("</div>");r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.addStyle("overflow","hidden");r.writeStyles();r.write(">");this.renderDayNames(r,m,o,F,7,true,undefined);r.write("</div>");};
M.renderHeaderLine=function(r,m,o,D){C._checkCalendarDate(D);if(m._getShowHeader()){var i=m.getId();var s=m.getPrimaryCalendarType();var g=o.getMonthsStandAlone("wide",s);r.write("<div id=\""+i+"-Head\"class=\"sapUiCalHeadText\" >");r.write(g[D.getMonth()]);r.write("</div>");}};
M.renderDayNames=function(r,m,o,s,D,g,w){var F=m._getFirstDayOfWeek();var I=m.getId();var h="";var j=m.getPrimaryCalendarType();var W=[];if(m._bLongWeekDays||!m._bNamesLengthChecked){W=o.getDaysStandAlone("abbreviated",j);}else{W=o.getDaysStandAlone("narrow",j);}var k=o.getDaysStandAlone("wide",j);for(var i=0;i<D;i++){r.write("<div");r.addClass("sapUiCalWH");if(g){h=I+"-WH"+((i+F)%7);}else{h=I+"-WH"+i;}r.writeAttribute("id",h);if(i==0){r.addClass("sapUiCalFirstWDay");}if(w){r.addStyle("width",w);}r.writeAccessibilityState(null,{role:"columnheader",label:k[(i+s)%7]});r.writeClasses();r.writeStyles();r.write(">");r.write(W[(i+s)%7]);r.write("</div>");}};
M.renderDays=function(r,m,D){var w,g,h,H,i,t,s;C._checkCalendarDate(D);if(!D){D=m._getFocusedDate();}t=D.toUTCJSDate().getTime();if(!t&&t!==0){throw new Error("Date is invalid "+m);}H=this.getDayHelper(m,D);g=m._getVisibleDays(D,true);s=m.getShowWeekNumbers();w=m.getPrimaryCalendarType()!==f.Islamic&&s;h=g.length;for(i=0;i<h;i++){this.renderDay(r,m,g[i],H,true,w,-1);}};
M.getDayHelper=function(m,D){var o,s,g=m._getLocaleData(),h={sLocale:m._getLocale(),oLocaleData:g,iMonth:D.getMonth(),iYear:D.getYear(),iFirstDayOfWeek:m._getFirstDayOfWeek(),iWeekendStart:g.getWeekendStart(),iWeekendEnd:g.getWeekendEnd(),aNonWorkingDays:m._getNonWorkingDays(),sToday:g.getRelativeDay(0),oToday:a.fromLocalJSDate(new Date(),m.getPrimaryCalendarType()),sId:m.getId(),oFormatLong:m._getFormatLong(),sSecondaryCalendarType:m._getSecondaryCalendarType(),oLegend:undefined};s=m.getLegend();if(s&&typeof s==="string"){o=sap.ui.getCore().byId(s);if(o){if(!(o instanceof b)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+m);}h.oLegend=o;}else{L.warning("CalendarLegend "+s+" does not exist!",m);}}return h;};
M.renderDay=function(r,m,D,h,o,w,n,W,g){C._checkCalendarDate(D);var s=new a(D,h.sSecondaryCalendarType),A={role:m._getAriaRole(),selected:false,label:"",describedby:""},B=D._bBeforeFirstYear,j="";var y=m._oFormatYyyymmdd.format(D.toUTCJSDate(),true);var k=D.getDay();var S=m._checkDateSelected(D);var p=m._getDateTypes(D);var E=m._checkDateEnabled(D);var i=0;if(B){E=false;}var q=0;if(w){q=C.calculateWeekNumber(D.toUTCJSDate(),h.iYear,h.sLocale,h.oLocaleData);A["describedby"]=h.sId+"-CW"+" "+h.sId+"-WNum-"+q;}if(!g){var t="";if(n<0){t=h.sId+"-WH"+k;}else{t=h.sId+"-WH"+n;}A["describedby"]=A["describedby"]+" "+t;}r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");r.addClass("sapUiCalWDay"+k);if(W){r.addStyle("width",W);}if(k==h.iFirstDayOfWeek){r.addClass("sapUiCalFirstWDay");}if(o&&h.iMonth!=D.getMonth()){r.addClass("sapUiCalItemOtherMonth");A["disabled"]=true;}if(D.isSame(h.oToday)){r.addClass("sapUiCalItemNow");A["label"]=h.sToday+" ";}if(S>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(S==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(S==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(S==4){r.addClass("sapUiCalItemSelBetween");}else if(S==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}p.forEach(function(u){if(u.type!=e.None){if(u.type===e.NonWorking){r.addClass("sapUiCalItemWeekEnd");return;}r.addClass("sapUiCalItem"+u.type);j=u.type;if(u.tooltip){r.writeAttributeEscaped('title',u.tooltip);}}});if(m.getParent()&&m.getParent().getMetadata().getName()==="sap.ui.unified.CalendarOneMonthInterval"&&D.getMonth()!==m.getStartDate().getMonth()){r.addClass("sapUiCalItemOtherMonth");}if(!E){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}if(h.aNonWorkingDays){for(i=0;i<h.aNonWorkingDays.length;i++){if(k==h.aNonWorkingDays[i]){r.addClass("sapUiCalItemWeekEnd");break;}}}else if((k>=h.iWeekendStart&&k<=h.iWeekendEnd)||(h.iWeekendEnd<h.iWeekendStart&&(k>=h.iWeekendStart||k<=h.iWeekendEnd))){r.addClass("sapUiCalItemWeekEnd");}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-day",y);if(g){A["label"]=A["label"]+h.aWeekDaysWide[k]+" ";}A["label"]=A["label"]+h.oFormatLong.format(D.toUTCJSDate(),true);if(j!==""){c.addCalendarTypeAccInfo(A,j,h.oLegend);}if(h.sSecondaryCalendarType){A["label"]=A["label"]+" "+m._oFormatSecondaryLong.format(s.toUTCJSDate(),true);}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");if(!B){r.write(D.getDate());}r.write("</span>");if(w&&k==h.iFirstDayOfWeek){r.write("<span");r.writeAttribute("id",h.sId+"-WNum-"+q);r.addClass("sapUiCalWeekNum");r.writeClasses();r.writeAccessibilityState(null,{role:"rowheader",desribedby:h.sId+"-CW"});r.write(">");r.write(q);r.write("</span>");}if(g){r.write("<span");r.addClass("sapUiCalDayName");r.writeClasses();r.write(">");r.write(h.aWeekDays[k]);r.write("</span>");}if(h.sSecondaryCalendarType){r.write("<span");r.addClass("sapUiCalItemSecText");r.writeClasses();r.write(">");r.write(s.getDate());r.write("</span>");}r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthsRow',['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./MonthsRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(C,L,I,a,c,l,D,d,e,M,f,q){"use strict";var g=d.CalendarType;
var h=C.extend("sap.ui.unified.calendar.MonthsRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});
h.prototype.init=function(){this._oFormatYyyymm=D.getInstance({pattern:"yyyyMMdd",calendarType:g.Gregorian});this._oFormatLong=D.getInstance({pattern:"MMMM y"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};
h.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonths){clearTimeout(this._sInvalidateMonths);}};
h.prototype.onAfterRendering=function(){_.call(this);x.call(this);};
h.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!f(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){A.call(this,true);t.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;w.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this);}}};
h.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateMonths){if(this._bInvalidateSync){y.call(this);}else{this._sInvalidateMonths=setTimeout(y.bind(this),0);}}};
h.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
h.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("selectedDates");return b;};
h.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
h.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("specialDates");return b;};
h.prototype.setDate=function(b){o.call(this,c.fromLocalJSDate(b),false);return this;};
h.prototype._setDate=function(b){var i=b.toLocalJSDate();this.setProperty("date",i,true);this._oDate=b;};
h.prototype._getDate=function(){if(!this._oDate){this._oDate=new c();}return this._oDate;};
h.prototype.setStartDate=function(S){a._checkJSDateObject(S);var b,Y,O;Y=S.getFullYear();a._checkYearInValidRange(Y);b=c.fromLocalJSDate(S);this.setProperty("startDate",S,true);this._oStartDate=b;this._oStartDate.setDate(1);if(this.getDomRef()){O=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.setDate(O);}}return this;};
h.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=new c();this._oStartDate.setDate(1);}return this._oStartDate;};
h.prototype.displayDate=function(b){o.call(this,c.fromLocalJSDate(b),true);return this;};
h.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
h.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var b=this._getLocale();var i=new e(b);this._oLocaleData=L.getInstance(i);}return this._oLocaleData;};
h.prototype._getFormatLong=function(){var b=this._getLocale();if(this._oFormatLong.oLocale.toString()!=b){var i=new e(b);this._oFormatLong=D.getInstance({style:"long"},i);}return this._oFormatLong;};
h.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
h.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
h.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
h.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
h.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};
h.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
h.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};
h.prototype._setAriaRole=function(R){this._ariaRole=R;return this;};
h.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell";};
h.prototype._checkDateSelected=function(b){var R,S,E,T,B=0,F=0,G=0,i,H,J;a._checkCalendarDate(b);H=this.getSelectedDates();J=new c(b);J.setDate(1);T=J.toUTCJSDate().getTime();for(i=0;i<H.length;i++){R=H[i];S=R.getStartDate();B=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);B=S.toUTCJSDate().getTime();}E=R.getEndDate();F=0;if(E){E=c.fromLocalJSDate(E);E.setDate(1);F=E.toUTCJSDate().getTime();}if(T==B&&!E){G=1;break;}else if(T==B&&E){G=2;if(E&&T==F){G=5;}break;}else if(E&&T==F){G=3;break;}else if(E&&T>B&&T<F){G=4;break;}if(this.getSingleSelection()){break;}}return G;};
h.prototype._getDateType=function(b){a._checkCalendarDate(b);var T,R,i,S,B=0,E,F=0,G,H=this.getSpecialDates(),J=new c(b);J.setDate(1);G=J.toUTCJSDate().getTime();for(i=0;i<H.length;i++){R=H[i];S=R.getStartDate();B=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);B=S.toUTCJSDate().getTime();}E=R.getEndDate();F=0;if(E){E=c.fromLocalJSDate(E);E.setDate(a._daysInMonth(E));F=E.toUTCJSDate().getTime();}if((G==B&&!E)||(G>=B&&G<=F)){T={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return T;};
h.prototype._checkMonthEnabled=function(b){a._checkCalendarDate(b);var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(a._isOutside(b,P._oMinDate,P._oMaxDate)){return false;}}return true;};
h.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){A.call(this,true);}var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){var O=this._getDate();var F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);if(!F.isSame(O)){this._setDate(F);t.call(this,F,true);this._bMoveChange=true;}}};
h.prototype.onmouseup=function(E){if(this._bMouseMove){A.call(this,true);var F=this._getDate();var b=this._oItemNavigation.getItemDomRefs();for(var i=0;i<b.length;i++){var $=q(b[i]);if($.attr("data-sap-month")==this._oFormatYyyymm.format(F.toUTCJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);}t.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;w.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this);}};
h.prototype.onsapselect=function(E){var S=t.call(this,this._getDate());if(S){w.call(this);}E.stopPropagation();E.preventDefault();};
h.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
h.prototype.onsappageupmodifiers=function(E){var F=new c(this._getDate());var Y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(Y-10);}else{var i=this.getMonths();if(i<=12){F.setYear(Y-1);}else{F.setMonth(F.getMonth()-i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};
h.prototype.onsappagedownmodifiers=function(E){var F=new c(this._getDate());var Y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(Y+10);}else{var i=this.getMonths();if(i<=12){F.setYear(Y+1);}else{F.setMonth(F.getMonth()+i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};
h.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var b=this._getLocaleData();var B=b.getMonthsStandAlone("wide");var E=this.$("months").children();var F=this._getStartDate().getMonth();for(var i=0;i<E.length;i++){var $=q(q(E[i]).children(".sapUiCalItemText"));$.text(B[(i+F)%12]);}x.call(this);};
h.prototype.checkDateFocusable=function(b){a._checkJSDateObject(b);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new c(S);E.setDate(1);E.setMonth(E.getMonth()+this.getMonths());var i=c.fromLocalJSDate(b);return i.isSameOrAfter(S)&&i.isBefore(E);};
h.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
function _(){var b=this._getDate();var Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var B=0;var R=this.$("months").get(0);var E=this.$("months").children(".sapUiCalItem");for(var i=0;i<E.length;i++){var $=q(E[i]);if($.attr("data-sap-month")===Y){B=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,j,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,k,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,m,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(E);this._oItemNavigation.setFocusedIndex(B);this._oItemNavigation.setPageSize(E.length);}
function j(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}var O=this._getDate();var F=new c(O);var B=this._oItemNavigation.getItemDomRefs();var $=q(B[i]);F=c.fromLocalJSDate(this._oFormatYyyymm.parse($.attr("data-sap-month")));F.setDate(1);this._setDate(F);this.fireFocus({date:F.toLocalJSDate(),notVisible:false});if(E.type=="mousedown"){n.call(this,E,F,i);}}
function k(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();n.call(this,E,F,i);}}
function m(b){var E=b.getParameter("event");var i=this.getMonths();var O=this._getDate();var F=new c(O);if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setMonth(F.getMonth()+1);break;case"sapprevious":case"sappreviousmodifiers":F.setMonth(F.getMonth()-1);break;case"sappagedown":F.setMonth(F.getMonth()+i);break;case"sappageup":F.setMonth(F.getMonth()-i);break;default:break;}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});}}
function n(E,F,i){if(E.button){return;}var S=t.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){A.call(this,true);this._bMoveChange=false;}else if(S&&this.getIntervalSelection()&&this.$().is(":visible")){z.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}
function o(b,N){a._checkCalendarDate(b);var Y=b.getYear();a._checkYearInValidRange(Y);var F=true;if(!this.getDate()||!b.isSame(c.fromLocalJSDate(this.getDate()))){var i=new c(b);i.setDate(1);F=this.checkDateFocusable(b.toLocalJSDate());if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",b.toLocalJSDate(),true);this._oDate=i;}if(this.getDomRef()){if(F){p.call(this,this._oDate,N);}else{r.call(this,N);}}}
function p(b,N){var Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var B=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<B.length;i++){$=q(B[i]);if($.attr("data-sap-month")==Y){if(document.activeElement!=B[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}
function r(N){var b=this._getStartDate();var $=this.$("months");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderMonths(R,this,b);R.flush($[0]);R.destroy();}s.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}
function s(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var b=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,b,S);R.flush($[0]);R.destroy();}}}
function t(b,B){if(!this._checkMonthEnabled(b)){return false;}var S=this.getSelectedDates();var E;var F=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var G=this;var H;if(P&&P.getSelectedDates){G=P;}if(this.getSingleSelection()){if(S.length>0){E=S[0];H=E.getStartDate();if(H){H=c.fromLocalJSDate(H);H.setDate(1);}}else{E=new sap.ui.unified.DateRange();G.addAggregation("selectedDates",E,true);}if(this.getIntervalSelection()&&(!E.getEndDate()||B)&&H){var J;if(b.isBefore(H)){J=H;H=b;if(!B){E.setProperty("startDate",H.toLocalJSDate(),true);E.setProperty("endDate",J.toLocalJSDate(),true);}}else if(b.isSameOrAfter(H)){J=b;if(!B){E.setProperty("endDate",J.toLocalJSDate(),true);}}u.call(this,H,J);}else{u.call(this,b);E.setProperty("startDate",b.toLocalJSDate(),true);E.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var K=this._checkDateSelected(b);if(K>0){for(i=0;i<S.length;i++){H=S[i].getStartDate();if(H){H=c.fromLocalJSDate(H);H.setDate(1);if(b.isSame(H)){G.removeAggregation("selectedDates",i,true);break;}}}}else{E=new sap.ui.unified.DateRange({startDate:b.toLocalJSDate()});G.addAggregation("selectedDates",E,true);}Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);for(i=0;i<F.length;i++){$=q(F[i]);if($.attr("data-sap-month")==Y){if(K>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}
function u(S,E){var b=this._oItemNavigation.getItemDomRefs();var $;var i=0;var B=false;var F=false;if(!E){var Y=this._oFormatYyyymm.format(S.toUTCJSDate(),true);for(i=0;i<b.length;i++){$=q(b[i]);B=false;F=false;if($.attr("data-sap-month")==Y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");B=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}v.call(this,$,B,F);}}else{var G;for(i=0;i<b.length;i++){$=q(b[i]);B=false;F=false;G=c.fromLocalJSDate(this._oFormatYyyymm.parse($.attr("data-sap-month")));G.setDate(1);if(G.isSame(S)){$.addClass("sapUiCalItemSelStart");B=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&G.isSame(E)){$.addClass("sapUiCalItemSelEnd");F=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&a._isBetween(G,S,E)){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&G.isSame(E)){$.addClass("sapUiCalItemSelEnd");F=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}v.call(this,$,B,F);}}}
function v($,S,E){if(!this.getIntervalSelection()){return;}var b="";var B=[];var F=this.getId();var G=false;b=$.attr("aria-describedby");if(b){B=b.split(" ");}var H=-1;var J=-1;for(var i=0;i<B.length;i++){var K=B[i];if(K==(F+"-Start")){H=i;}if(K==(F+"-End")){J=i;}}if(H>=0&&!S){B.splice(H,1);G=true;if(J>H){J--;}}if(J>=0&&!E){B.splice(J,1);G=true;}if(H<0&&S){B.push(F+"-Start");G=true;}if(J<0&&E){B.push(F+"-End");G=true;}if(G){b=B.join(" ");$.attr("aria-describedby",b);}}
function w(){if(this._bMouseMove){A.call(this,true);}this.fireSelect();}
function x(){if(!this._bNamesLengthChecked){var i=0;var B=this.$("months").children();var T=false;var E=this.getMonths();var F=Math.ceil(12/E);var G=0;var H=this._getLocaleData();var J=H.getMonthsStandAlone("wide");var $;for(var b=0;b<F;b++){if(E<12){for(i=0;i<B.length;i++){$=q(q(B[i]).children(".sapUiCalItemText"));$.text(J[(i+G)%12]);}G=G+E;if(G>11){G=11;}}for(i=0;i<B.length;i++){var K=B[i];if(Math.abs(K.clientWidth-K.scrollWidth)>1){T=true;break;}}if(T){break;}}if(E<12){G=this._getStartDate().getMonth();for(i=0;i<B.length;i++){$=q(q(B[i]).children(".sapUiCalItemText"));$.text(J[(i+G)%12]);}}if(T){this._bLongMonth=false;var N=H.getMonthsStandAlone("abbreviated");G=this._getStartDate().getMonth();for(i=0;i<B.length;i++){$=q(q(B[i]).children(".sapUiCalItemText"));$.text(N[(i+G)%12]);}}else{this._bLongMonth=true;}this._bNamesLengthChecked=true;}}
function y(){this._sInvalidateMonths=undefined;r.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}
function z(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}
function A(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}
return h;});
sap.ui.predefine('sap/ui/unified/calendar/MonthsRowRenderer',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegendRenderer','sap/ui/unified/library',"sap/base/Log"],function(C,a,b,l,L){"use strict";var c=l.CalendarDayType;var M={};
M.render=function(r,m){var d=m._getStartDate();var t=m.getTooltip_AsString();var i=m.getId();var A={value:i+"-Descr",append:true};r.write("<div");r.writeControlData(m);r.addClass("sapUiCalMonthsRow");r.addClass("sapUiCalRow");r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+m._rb.getText("CALENDAR_DIALOG")+"</span>");if(m.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+m._rb.getText("CALENDAR_START_MONTH")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+m._rb.getText("CALENDAR_END_MONTH")+"</span>");}this.renderRow(r,m,d);r.write("</div>");};
M.renderRow=function(r,m,d){var i=m.getId();this.renderHeader(r,m,d);r.write("<div id=\""+i+"-months\" class=\"sapUiCalItems\" role=\"row\">");this.renderMonths(r,m,d);r.write("</div>");};
M.renderHeader=function(r,m,d){C._checkCalendarDate(d);if(m._getShowHeader()){var o=m._getLocaleData();var i=m.getId();r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,m,o,d);r.write("</div>");}};
M.renderHeaderLine=function(r,m,o,d){C._checkCalendarDate(d);var I=m.getId();var e=m.getMonths();var f=new a(d);var w="";var y=0;var Y=[];var i=0;for(i=0;i<e;i++){y=f.getYear();if(Y.length>0&&Y[Y.length-1].iYear==y){Y[Y.length-1].iMonths++;}else{Y.push({iYear:y,iMonths:1});}f.setMonth(f.getMonth()+1);}for(i=0;i<Y.length;i++){var g=Y[i];w=(100/e*g.iMonths)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(g.iYear);r.write("</div>");}};
M.renderMonths=function(r,m,d){var h=this.getHelper(m,d);var e=m.getMonths();var w=(100/e)+"%";var o=new a(d);o.setDate(1);for(var i=0;i<e;i++){this.renderMonth(r,m,o,h,w);o.setMonth(o.getMonth()+1);}};
M.getHelper=function(m,d){C._checkCalendarDate(d);var h={};h.sLocale=m._getLocale();h.oLocaleData=m._getLocaleData();h.oToday=new a();h.sCurrentMonth=m._rb.getText("CALENDAR_CURRENT_MONTH");h.sId=m.getId();h.oFormatLong=m._getFormatLong();if(m._bLongMonth||!m._bNamesLengthChecked){h.aMonthNames=h.oLocaleData.getMonthsStandAlone("wide");}else{h.aMonthNames=h.oLocaleData.getMonthsStandAlone("abbreviated");h.aMonthNamesWide=h.oLocaleData.getMonthsStandAlone("wide");}var s=m.getLegend();if(s){var o=sap.ui.getCore().byId(s);if(o){if(!(o instanceof sap.ui.unified.CalendarLegend)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+m);}h.oLegend=o;}else{L.warning("CalendarLegend "+s+" does not exist!",m);}}return h;};
M.renderMonth=function(r,m,d,h,w){C._checkCalendarDate(d);var A={role:m._getAriaRole(),selected:false,label:"",describedby:""};if(!m._bLongMonth&&m._bNamesLengthChecked){A["label"]=h.aMonthNamesWide[d.getMonth()];}var y=m._oFormatYyyymm.format(d.toUTCJSDate(),true);var s=m._checkDateSelected(d);var t=m._getDateType(d);var e=m._checkMonthEnabled(d);r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");if(w){r.addStyle("width",w);}if(C._isSameMonthAndYear(d,h.oToday)){r.addClass("sapUiCalItemNow");A["label"]=h.sCurrentMonth+" ";}if(s>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}if(s==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(s==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(s==4){r.addClass("sapUiCalItemSelBetween");}else if(s==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}if(t&&t.type!=c.None){r.addClass("sapUiCalItem"+t.type);if(t.tooltip){r.writeAttributeEscaped('title',t.tooltip);}}if(!e){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-month",y);A["label"]=A["label"]+h.oFormatLong.format(d.toUTCJSDate(),true);if(t&&t.type!=c.None){b.addCalendarTypeAccInfo(A,t.type,h.oLegend);}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");r.write(h.aMonthNames[d.getMonth()]);r.write("</span>");r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/OneMonthDatesRow',['sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library',"./OneMonthDatesRowRenderer"],function(D,C,a,l,O){"use strict";
var b=D.extend("sap.ui.unified.calendar.OneMonthDatesRow",{metadata:{library:"sap.ui.unified"}});
b.prototype.init=function(){D.prototype.init.apply(this,arguments);this.iMode=2;};
b.prototype.setMode=function(m){var s=this.getSelectedDates(),S,c=this.iMode!==m;this.iMode=m;if(c&&s.length){if(this.iMode<2){S=this.getStartDate();}s[0].setProperty('startDate',S,true);}return this;};
b.prototype.getMode=function(){return this.iMode;};
b.prototype.selectDate=function(d){if(this.iMode<2&&this.getSelectedDates().length){this.getSelectedDates()[0].setStartDate(d);}return this;};
b.prototype.setDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){return this;}D.prototype.setDate.apply(this,arguments);return this;};
b.prototype.displayDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){return this;}D.prototype.displayDate.apply(this,arguments);return this;};
b.prototype.onsaphome=function(e){var c=a.fromLocalJSDate(this.getStartDate());i(e);this._setDate(c);this._focusDate(c);this.fireFocus({date:c.toLocalJSDate(),otherMonth:false});};
b.prototype.onsapend=function(e){var s=this.getStartDate(),L;L=a.fromLocalJSDate(s);L.setDate(C._daysInMonth(L));i(e);this._setDate(L);this._focusDate(L);this.fireFocus({date:L.toLocalJSDate(),otherMonth:false});};
function i(e){e.stopPropagation();e.preventDefault();e.stopImmediatePropagation(true);}
return b;});
sap.ui.predefine('sap/ui/unified/calendar/OneMonthDatesRowRenderer',['sap/ui/core/Renderer','./MonthRenderer','./DatesRowRenderer'],function(R,M,D){"use strict";var O=R.extend(D);["getClass","renderMonth","renderDays","renderHeader"].forEach(function(h){O[h]=function(r,d){if(d.iMode<2){return M[h].apply(M,arguments);}else{return D[h].apply(D,arguments);}};});return O;},true);
sap.ui.predefine('sap/ui/unified/calendar/TimesRow',['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./TimesRowRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/thirdparty/jquery"],function(C,L,I,a,U,l,D,c,b,T,d,e,q){"use strict";var f=c.CalendarType;
var g=C.extend("sap.ui.unified.calendar.TimesRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});
g.prototype.init=function(){this._oFormatYyyyMMddHHmm=D.getInstance({pattern:"yyyyMMddHHmm",calendarType:f.Gregorian});this._oFormatLong=D.getDateTimeInstance({style:"long/short"});this._oFormatDate=D.getDateInstance({style:"medium"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};
g.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateTimes){clearTimeout(this._sInvalidateTimes);}};
g.prototype.onAfterRendering=function(){_.call(this);};
g.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!d(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){y.call(this,true);s.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;v.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;v.call(this);}}};
g.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateTimes){if(this._bInvalidateSync){w.call(this);}else{this._sInvalidateTimes=setTimeout(w.bind(this),0);}}};
g.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
g.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
g.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
g.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
g.prototype.setIntervalMinutes=function(M){if(M>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%M>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",M,false);this._oFormatTime=undefined;return this;};
g.prototype.setDate=function(i){n.call(this,i,false);return this;};
g.prototype._setDate=function(i){var z=a._createLocalDate(i,true);this.setProperty("date",z,true);this._oUTCDate=i;};
g.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date(),undefined,true);}return this._oUTCDate;};
g.prototype.setStartDate=function(S){a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);var i=a._createUniversalUTCDate(S,undefined,true);this.setProperty("startDate",S,true);this._oUTCStartDate=this._getIntervalStart(i);if(this.getDomRef()){var O=a._createLocalDate(this._getDate(),true);this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.displayDate(O);}}return this;};
g.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(new Date(),undefined,true);this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate);}return this._oUTCStartDate;};
g.prototype.displayDate=function(i){n.call(this,i,true);return this;};
g.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
g.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var z=new b(i);this._oLocaleData=L.getInstance(z);}return this._oLocaleData;};
g.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var z=new b(i);this._oFormatLong=D.getInstance({style:"long/short"},z);}return this._oFormatLong;};
g.prototype._getFormatTime=function(){var i=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=i){var z=new b(i);var A=this.getIntervalMinutes();var B=this._getLocaleData();var P;this._oFormatTimeAmPm=undefined;if(A%60==0){P=B.getPreferredHourSymbol();if(B.getTimePattern("short").search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},z);}}else{P=B.getTimePattern("short");P=P.replace("HH","H");P=P.replace("hh","h");if(P.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},z);P=P.replace("a","").trim();}}this._oFormatTime=D.getTimeInstance({pattern:P},z);}return this._oFormatTime;};
g.prototype._getFormatDate=function(){var i=this._getLocale();if(this._oFormatDate.oLocale.toString()!=i){var z=new b(i);this._oFormatDate=D.getDateInstance({style:"medium"},z);}return this._oFormatDate;};
g.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
g.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
g.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
g.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
g.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};
g.prototype.getIntervalMinutes=function(){var P=this.getParent();if(P&&P.getIntervalMinutes){return P.getIntervalMinutes();}else{return this.getProperty("intervalMinutes");}};
g.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
g.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};
g.prototype._checkDateSelected=function(z){if(!(z instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var S=0;var A=this.getSelectedDates();var M=new U(z.getTime());M=this._getIntervalStart(M);var B=M.getTime();for(var i=0;i<A.length;i++){var R=A[i];var E=R.getStartDate();var F=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);F=E.getTime();}var G=R.getEndDate();var H=0;if(G){G=a._createUniversalUTCDate(G,undefined,true);G=this._getIntervalStart(G);H=G.getTime();}if(B==F&&!G){S=1;break;}else if(B==F&&G){S=2;if(G&&B==H){S=5;}break;}else if(G&&B==H){S=3;break;}else if(G&&B>F&&B<H){S=4;break;}if(this.getSingleSelection()){break;}}return S;};
g.prototype._getDateType=function(z){if(!(z instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var A;var S=this.getSpecialDates();var M=new U(z.getTime());M=this._getIntervalStart(M);var B=M.getTime();for(var i=0;i<S.length;i++){var R=S[i];var E=R.getStartDate();var F=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);F=E.getTime();}var G=R.getEndDate();var H=0;if(G){G=a._createUniversalUTCDate(G,undefined,true);G=this._getIntervalStart(G);G.setUTCMinutes(G.getUTCMinutes()+this.getIntervalMinutes()-1);H=G.getTime();}else if(E.getUTCHours()==0&&E.getUTCMinutes()==0&&E.getUTCSeconds()==0&&E.getUTCMilliseconds()==0){G=new U(E.getTime());G.setUTCDate(G.getUTCDate()+1);H=G.getTime();}if((B==F&&!G)||(B>=F&&B<=H)){A={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return A;};
g.prototype._checkTimeEnabled=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var z=i.getTime();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(z<P._oMinDate.getTime()||z>P._oMaxDate.getTime()){return false;}}return true;};
g.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){y.call(this,true);}var $=q(E.target);if($.hasClass("sapUiCalItemText")){$=$.parent();}if($.hasClass("sapUiCalItem")){var O=this._getDate();var F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()!=O.getTime()){this._setDate(F);s.call(this,F,true);this._bMoveChange=true;}}};
g.prototype.onmouseup=function(E){if(this._bMouseMove){y.call(this,true);var F=this._getDate();var z=this._oItemNavigation.getItemDomRefs();for(var i=0;i<z.length;i++){var $=q(z[i]);if($.attr("data-sap-time")==this._oFormatYyyyMMddHHmm.format(F.getJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var A=q(E.target);if(A.hasClass("sapUiCalItemText")){A=A.parent();}if(A.hasClass("sapUiCalItem")){F=new U(this._oFormatYyyyMMddHHmm.parse(A.attr("data-sap-time"),true).getTime());}s.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;v.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;v.call(this);}};
g.prototype.onsapselect=function(E){var S=s.call(this,this._getDate());if(S){v.call(this);}E.stopPropagation();E.preventDefault();};
g.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
g.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i-7);}else{F.setUTCDate(i-1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};
g.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i+7);}else{F.setUTCDate(i+1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};
g.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new U(S.getTime());E.setUTCMinutes(E.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var z=a._createUniversalUTCDate(i,undefined,true);if(z.getTime()>=S.getTime()&&z.getTime()<E.getTime()){return true;}else{return false;}};
g.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
g.prototype._getIntervalStart=function(i){var z=i.getTime();var S=new U(i.getTime());S.setUTCHours(0);S.setUTCMinutes(0);S.setUTCSeconds(0);S.setUTCMilliseconds(0);var M=this.getIntervalMinutes();while(S.getTime()<=z){S.setUTCMinutes(S.getUTCMinutes()+M);}var A=new U(S.getTime());A.setUTCMinutes(A.getUTCMinutes()-M);return A;};
g.prototype._setAriaRole=function(R){this._ariaRole=R;return this;};
g.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell";};
function _(){var z=this._getDate();var Y=this._oFormatYyyyMMddHHmm.format(z.getJSDate(),true);var A=0;var R=this.$("times").get(0);var B=this.$("times").children(".sapUiCalItem");for(var i=0;i<B.length;i++){var $=q(B[i]);if($.attr("data-sap-time")===Y){A=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,h,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,j,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,k,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(B);this._oItemNavigation.setFocusedIndex(A);this._oItemNavigation.setPageSize(B.length);}
function h(i){var z=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}var O=this._getDate();var F=new U(O.getTime());var A=this._oItemNavigation.getItemDomRefs();var $=q(A[z]);F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());this._setDate(F);this.fireFocus({date:a._createLocalDate(F,true),notVisible:false});if(E.type=="mousedown"){m.call(this,E,F,z);}}
function j(i){var z=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();m.call(this,E,F,z);}}
function k(i){var E=i.getParameter("event");var z=this.getItems();var M=this.getIntervalMinutes();var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setUTCMinutes(F.getUTCMinutes()+M);break;case"sapprevious":case"sappreviousmodifiers":F.setUTCMinutes(F.getUTCMinutes()-M);break;case"sappagedown":F.setUTCMinutes(F.getUTCMinutes()+M*z);break;case"sappageup":F.setUTCMinutes(F.getUTCMinutes()-M*z);break;default:break;}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});}}
function m(E,F,i){if(E.button){return;}var S=s.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){y.call(this,true);this._bMoveChange=false;}else if(this.getIntervalSelection()&&this.$().is(":visible")){x.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}
function n(i,N){a._checkJSDateObject(i);var Y=i.getFullYear();a._checkYearInValidRange(Y);var F=true;if(!e(this.getDate(),i)){var z=a._createUniversalUTCDate(i,undefined,true);z=this._getIntervalStart(z);F=this.checkDateFocusable(i);if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",i,true);this._oUTCDate=z;}if(this.getDomRef()){if(F){o.call(this,this._oUTCDate,N);}else{p.call(this,N);}}}
function o(z,N){var Y=this._oFormatYyyyMMddHHmm.format(z.getJSDate(),true);var A=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<A.length;i++){$=q(A[i]);if($.attr("data-sap-time")==Y){if(document.activeElement!=A[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}
function p(N){var i=this._getStartDate();var $=this.$("times");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderTimes(R,this,i);R.flush($[0]);R.destroy();}r.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}
function r(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var i=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,i,S);R.flush($[0]);R.destroy();}}}
function s(z,M){if(!this._checkTimeEnabled(z)){return false;}var S=this.getSelectedDates();var A;var B=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var E=this;var F;if(P&&P.getSelectedDates){E=P;}if(this.getSingleSelection()){if(S.length>0){A=S[0];F=A.getStartDate();if(F){F=a._createUniversalUTCDate(F,undefined,true);F=this._getIntervalStart(F);}}else{A=new sap.ui.unified.DateRange();E.addAggregation("selectedDates",A,true);}if(this.getIntervalSelection()&&(!A.getEndDate()||M)&&F){var G;if(z.getTime()<F.getTime()){G=F;F=z;if(!M){A.setProperty("startDate",a._createLocalDate(new Date(F.getTime()),true),true);A.setProperty("endDate",a._createLocalDate(new Date(G.getTime()),true),true);}}else if(z.getTime()>=F.getTime()){G=z;if(!M){A.setProperty("endDate",a._createLocalDate(new Date(G.getTime()),true),true);}}t.call(this,F,G);}else{t.call(this,z);A.setProperty("startDate",a._createLocalDate(new Date(z.getTime()),true),true);A.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var H=this._checkDateSelected(z);if(H>0){for(i=0;i<S.length;i++){F=S[i].getStartDate();if(F){F=a._createUniversalUTCDate(F,undefined,true);F=this._getIntervalStart(F);if(z.getTime()==F.getTime()){E.removeAggregation("selectedDates",i,true);break;}}}}else{A=new sap.ui.unified.DateRange({startDate:a._createLocalDate(new Date(z.getTime()),true)});E.addAggregation("selectedDates",A,true);}Y=this._oFormatYyyyMMddHHmm.format(z.getJSDate(),true);for(i=0;i<B.length;i++){$=q(B[i]);if($.attr("data-sap-time")==Y){if(H>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}
function t(S,E){var z=this._oItemNavigation.getItemDomRefs();var $;var i=0;var A=false;var B=false;if(!E){var Y=this._oFormatYyyyMMddHHmm.format(S.getJSDate(),true);for(i=0;i<z.length;i++){$=q(z[i]);A=false;B=false;if($.attr("data-sap-time")==Y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");A=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}u.call(this,$,A,B);}}else{var F;for(i=0;i<z.length;i++){$=q(z[i]);A=false;B=false;F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()==S.getTime()){$.addClass("sapUiCalItemSelStart");A=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&F.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");B=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&F.getTime()>S.getTime()&&F.getTime()<E.getTime()){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&F.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");B=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}u.call(this,$,A,B);}}}
function u($,S,E){if(!this.getIntervalSelection()){return;}var z="";var A=[];var B=this.getId();var F=false;z=$.attr("aria-describedby");if(z){A=z.split(" ");}var G=-1;var H=-1;for(var i=0;i<A.length;i++){var J=A[i];if(J==(B+"-Start")){G=i;}if(J==(B+"-End")){H=i;}}if(G>=0&&!S){A.splice(G,1);F=true;if(H>G){H--;}}if(H>=0&&!E){A.splice(H,1);F=true;}if(G<0&&S){A.push(B+"-Start");F=true;}if(H<0&&E){A.push(B+"-End");F=true;}if(F){z=A.join(" ");$.attr("aria-describedby",z);}}
function v(){if(this._bMouseMove){y.call(this,true);}this.fireSelect();}
function w(){this._sInvalidateTimes=undefined;p.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}
function x(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}
function y(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}
return g;});
sap.ui.predefine('sap/ui/unified/calendar/TimesRowRenderer',['sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/CalendarLegendRenderer','sap/ui/unified/library',"sap/base/Log"],function(C,U,a,l,L){"use strict";var b=l.CalendarDayType;var T={};
T.render=function(r,t){var d=t._getStartDate();var s=t.getTooltip_AsString();var i=t.getId();var A={value:i+"-Descr",append:true};r.write("<div");r.writeControlData(t);r.addClass("sapUiCalTimesRow");r.addClass("sapUiCalRow");r.writeClasses();if(s){r.writeAttributeEscaped("title",s);}if(t._getShowHeader()){A.value=A.value+" "+i+"-Head";}r.writeAccessibilityState(t,{role:"grid",readonly:"true",multiselectable:!t.getSingleSelection()||t.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+t._rb.getText("CALENDAR_DIALOG")+"</span>");if(t.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+t._rb.getText("CALENDAR_START_TIME")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+t._rb.getText("CALENDAR_END_TIME")+"</span>");}this.renderRow(r,t,d);r.write("</div>");};
T.renderRow=function(r,t,d){var i=t.getId();this.renderHeader(r,t,d);r.write("<div id=\""+i+"-times\" class=\"sapUiCalItems\">");this.renderTimes(r,t,d);r.write("</div>");};
T.renderHeader=function(r,t,d){if(t._getShowHeader()){var o=t._getLocaleData();var i=t.getId();r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,t,o,d);r.write("</div>");}};
T.renderHeaderLine=function(r,t,o,d){var f=t._getFormatDate();var I=t.getId();var c=t.getItems();var e=t._getIntervalStart(d);var m=t.getIntervalMinutes();var w="";var D=0;var g=[];var i=0;for(i=0;i<c;i++){D=f.format(e,true);if(g.length>0&&g[g.length-1].sDay==D){g[g.length-1].iItems++;}else{g.push({sDay:D,iItems:1});}e.setUTCMinutes(e.getUTCMinutes()+m);}for(i=0;i<g.length;i++){var h=g[i];w=(100/c*h.iItems)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(h.sDay);r.write("</div>");}};
T.renderTimes=function(r,t,d){var h=this.getHelper(t,d);var I=t.getItems();var w=(100/I)+"%";var o=t._getIntervalStart(d);var O="";var A="";for(var i=0;i<I;i++){if(h.oFormatTimeAmPm){A=h.oFormatTimeAmPm.format(o,true);if(O==A){A="";}else{O=A;}}this.renderTime(r,t,o,h,w,A);o.setUTCMinutes(o.getUTCMinutes()+h.iMinutes);}};
T.getHelper=function(t,d){var h={};h.sLocale=t._getLocale();h.oLocaleData=t._getLocaleData();h.oNow=C._createUniversalUTCDate(new Date(),undefined,true);h.sCurrentTime=t._rb.getText("CALENDAR_CURRENT_TIME");h.sId=t.getId();h.oFormatLong=t._getFormatLong();h.oFormatTime=t._getFormatTime();h.oFormatTimeAmPm=t._oFormatTimeAmPm;h.iMinutes=t.getIntervalMinutes();var s=t.getLegend();if(s){var o=sap.ui.getCore().byId(s);if(o){if(!(o instanceof sap.ui.unified.CalendarLegend)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+t);}h.oLegend=o;}else{L.warning("CalendarLegend "+s+" does not exist!",t);}}return h;};
T.renderTime=function(r,t,d,h,w,A){var m={role:t._getAriaRole(),selected:false,label:"",describedby:""};var y=t._oFormatYyyyMMddHHmm.format(d.getJSDate(),true);var s=t._checkDateSelected(d);var o=t._getDateType(d);var e=t._checkTimeEnabled(d);r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");if(w){r.addStyle("width",w);}var n=new U(d.getTime());n.setUTCMinutes(n.getUTCMinutes()+h.iMinutes);if(d.getTime()<=h.oNow.getTime()&&n.getTime()>h.oNow.getTime()){r.addClass("sapUiCalItemNow");m["label"]=h.sCurrentTime+" ";}if(s>0){r.addClass("sapUiCalItemSel");m["selected"]=true;}if(s==2){r.addClass("sapUiCalItemSelStart");m["describedby"]=m["describedby"]+" "+h.sId+"-Start";}else if(s==3){r.addClass("sapUiCalItemSelEnd");m["describedby"]=m["describedby"]+" "+h.sId+"-End";}else if(s==4){r.addClass("sapUiCalItemSelBetween");}else if(s==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");m["describedby"]=m["describedby"]+" "+h.sId+"-Start";m["describedby"]=m["describedby"]+" "+h.sId+"-End";}if(o&&o.type!=b.None){r.addClass("sapUiCalItem"+o.type);if(o.tooltip){r.writeAttributeEscaped('title',o.tooltip);}}if(!e){r.addClass("sapUiCalItemDsbl");m["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-time",y);m["label"]=m["label"]+h.oFormatLong.format(d,true);if(o&&o.type!=b.None){a.addCalendarTypeAccInfo(m,o.type,h.oLegend);}r.writeAccessibilityState(null,m);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");r.write(h.oFormatTime.format(d,true));if(A){r.write("<span");r.addClass("sapUiCalItemTextAmPm");r.writeClasses();r.write(">");r.write(A);r.write("</span>");}r.write("</span>");r.write("</div>");};
return T;},true);
sap.ui.predefine('sap/ui/unified/calendar/YearPicker',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library',"./YearPickerRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,D,I,a,b,U,l,c,d,Y,K,q){"use strict";var e=d.CalendarType;
var f=C.extend("sap.ui.unified.calendar.YearPicker",{metadata:{library:"sap.ui.unified",properties:{year:{type:"int",group:"Data",defaultValue:2000},years:{type:"int",group:"Appearance",defaultValue:20},columns:{type:"int",group:"Appearance",defaultValue:4},date:{type:"object",group:"Data"},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"}},events:{select:{},pageChange:{}}}});
f.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._oYearFormat=c.getDateInstance({format:"y",calendarType:s});this._oFormatYyyymmdd=c.getInstance({pattern:"yyyyMMdd",calendarType:e.Gregorian});this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());};
f.prototype.onAfterRendering=function(){_.call(this);};
f.prototype.setYear=function(y){this.setProperty("year",y,true);y=this.getProperty("year");var i=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());i.setDate(1);i.setMonth(0);i.setYear(y);this.setDate(i.toLocalJSDate());return this;};
f.prototype.setDate=function(i){var p,y,r,F;i&&a._checkJSDateObject(i);y=i.getFullYear();a._checkYearInValidRange(y);p=b.fromLocalJSDate(i,this.getPrimaryCalendarType());p.setMonth(0);p.setDate(1);this.setProperty("date",i,true);this.setProperty("year",p.getYear(),true);this._oDate=p;if(this.getDomRef()){r=this.getYears();F=new b(this._oDate,this.getPrimaryCalendarType());F.setYear(F.getYear()-Math.floor(r/2));o.call(this,F,Math.floor(r/2));}return this;};
f.prototype._getDate=function(){if(!this._oDate){var y=this.getYear();this._oDate=new b(y,0,1,this.getPrimaryCalendarType());}return this._oDate;};
f.prototype.setPrimaryCalendarType=function(s){this.setProperty("primaryCalendarType",s);this._oYearFormat=c.getDateInstance({format:"y",calendarType:s});if(this._oDate){this._oDate=new b(this._oDate,s);this._oDate.setMonth(0);this._oDate.setDate(1);}this._oMinDate=new b(this._oMinDate,s);this._oMaxDate=new b(this._oMaxDate,s);return this;};
f.prototype.nextPage=function(){n.call(this,true,this._oItemNavigation.getFocusedIndex());return this;};
f.prototype.previousPage=function(){n.call(this,false,this._oItemNavigation.getFocusedIndex());return this;};
f.prototype.onsapspace=function(E){E.preventDefault();};
f.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var s=m.call(this,i);if(s){this.fireSelect();}};
f.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};
f.prototype.onmouseup=function(E){if(this._bMousedownChange){this._bMousedownChange=false;this.fireSelect();}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)){var i=this._oItemNavigation.getFocusedIndex();m.call(this,i);this.fireSelect();}};
f.prototype.getFirstRenderedDate=function(){var F;if(this.getDomRef()){var i=this._oItemNavigation.getItemDomRefs();F=this._oFormatYyyymmdd.parse(q(i[0]).attr("data-sap-year-start"));}return F;};
f.prototype._isValueInThreshold=function(r,v,t){var L=r-t,u=r+t;return v>=L&&v<=u;};
f.prototype._checkFirstDate=function(i){var y=this.getYears();var M=new b(this._oMaxDate,this.getPrimaryCalendarType());M.setYear(M.getYear()-y+1);if(i.isAfter(M)&&i.getYear()!=M.getYear()){i=new b(M,this.getPrimaryCalendarType());i.setMonth(0);i.setDate(1);}else if(i.isBefore(this._oMinDate)&&i.getYear()!=this._oMinDate.getYear()){i=new b(this._oMinDate,this.getPrimaryCalendarType());i.setMonth(0);i.setDate(1);}return i;};
f.prototype._checkDateEnabled=function(i){var E=true;if((i.isAfter(this._oMaxDate)&&i.getYear()!=this._oMaxDate.getYear())||(i.isBefore(this._oMinDate)&&i.getYear()!=this._oMinDate.getYear())){E=false;}return E;};
function _(){var y=this.getYears();var i=this._getDate().getYear();var M=this._oMinDate.getYear();var p=this._oMaxDate.getYear();var r=this.getDomRef();var s=this.$().find(".sapUiCalItem");var t=Math.floor(y/2);if(i>p-Math.floor(y/2)){t=t+i-p+Math.floor(y/2);}else if(i<=M+Math.floor(y/2)){t=i-M;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,g,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,h,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,k,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(s);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this.getColumns(),true);this._oItemNavigation.setFocusedIndex(t);this._oItemNavigation.setPageSize(s.length);}
function g(i){var p=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){j.call(this,E,p);}}
function h(i){var p=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){j.call(this,E,p);}}
function j(E,i){if(E.button||D.support.touch){return;}var s=m.call(this,i);if(s){this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");}
function k(i){var E=i.getParameter("event");if(E.type){var y=this.getYears();var p=this.getColumns();if(p==0){p=y;}switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==K.ARROW_DOWN&&p<y){n.call(this,true,this._oItemNavigation.getFocusedIndex()-y+p,true);}else{n.call(this,true,0,true);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==K.ARROW_UP&&p<y){n.call(this,false,y-p+this._oItemNavigation.getFocusedIndex(),true);}else{n.call(this,false,y-1,true);}break;case"sappagedown":n.call(this,true,this._oItemNavigation.getFocusedIndex(),true);break;case"sappageup":n.call(this,false,this._oItemNavigation.getFocusedIndex(),true);break;default:break;}}}
function m(p){var r=this._oItemNavigation.getItemDomRefs();var $=q(r[p]);if($.hasClass("sapUiCalItemDsbl")){return false;}var y=$.attr("data-sap-year-start");var s=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y));var t=this.getId()+"-y"+y;for(var i=0;i<r.length;i++){$=q(r[i]);if($.attr("id")==t){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}}this.setProperty("date",s.toLocalJSDate(),true);this.setProperty("year",s.getYear(),true);return true;}
function n(F,s,i){var p=this._oItemNavigation.getItemDomRefs();var r=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(q(p[0]).attr("data-sap-year-start")),this.getPrimaryCalendarType());var y=this.getYears();if(F){var M=new b(this._oMaxDate,this.getPrimaryCalendarType());M.setYear(M.getYear()-y+1);if(r.isBefore(M)){r.setYear(r.getYear()+y);if(r.isAfter(M)){s=s+(r.getYear()-M.getYear());if(s>y-1){s=y-1;}r=this._oMaxDate;r.setMonth(0);r.setDate(1);}}else{return;}}else{if(r.isAfter(this._oMinDate)){r.setYear(r.getYear()-y);if(r.isBefore(this._oMinDate)){s=s-(this._oMinDate.getYear()-r.getYear());if(s<0){s=0;}r=new b(this._oMinDate,this.getPrimaryCalendarType());}}else{return;}}o.call(this,r,s);if(i){this.firePageChange();}}
function o(F,s){var p=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true);var E=false;var r=this._checkFirstDate(F);var S;if(!r.isSame(F)){S=new b(F,this.getPrimaryCalendarType());S.setYear(S.getYear()+s);F=r;E=true;}var t=this._oItemNavigation.getItemDomRefs();var u=new b(F,this.getPrimaryCalendarType());for(var i=0;i<t.length;i++){var y=this._oFormatYyyymmdd.format(u.toUTCJSDate(),true);var $=q(t[i]);$.attr("id",this.getId()+"-y"+y);$.text(this._oYearFormat.format(U.getInstance(u.toUTCJSDate(),u.getCalendarType()),true));$.attr("data-sap-year-start",y);if($.hasClass("sapUiCalItemSel")&&y!=p){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else if(!$.hasClass("sapUiCalItemSel")&&y==p){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}var v=true;if(E){v=this._checkDateEnabled(u);if(u.isSame(S)){s=i;}}if(v){$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}else{$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}u.setYear(u.getYear()+1);}this._oItemNavigation.focusItem(s);}
return f;});
sap.ui.predefine('sap/ui/unified/calendar/YearPickerRenderer',['sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate'],function(C,U){"use strict";var Y={};
Y.render=function(r,y){var t=y.getTooltip_AsString();var I=y.getId();var c=y._getDate();var a=c.getYear();var b=y.getYears();var d=y.getColumns();var w="";r.write("<div");r.writeControlData(y);r.addClass("sapUiCalYearPicker");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(y,{role:"grid",readonly:"true",multiselectable:"false"});r.write(">");var D=new C(c,y.getPrimaryCalendarType());D.setYear(D.getYear()-Math.floor(b/2));var e=false;var f=y._checkFirstDate(D);if(!f.isSame(D)){D=f;e=true;}if(d>0){w=(100/d)+"%";}else{w=(100/b)+"%";}for(var i=0;i<b;i++){var s=y._oFormatYyyymmdd.format(D.toUTCJSDate(),true);var A={role:"gridcell"};var E=true;if(e){E=y._checkDateEnabled(D);}if(d>0&&i%d==0){r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.write(">");}r.write("<div");r.writeAttribute("id",I+"-y"+s);r.addClass("sapUiCalItem");if(D.getYear()==a){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(!E){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-year-start",s);r.addStyle("width",w);r.writeClasses();r.writeStyles();r.writeAccessibilityState(null,A);r.write(">");r.write(y._oYearFormat.format(U.getInstance(D.toUTCJSDate(),D.getCalendarType()),true));r.write("</div>");D.setYear(D.getYear()+1);if(d>0&&((i+1)%d==0)){r.write("</div>");}}r.write("</div>");};
return Y;},true);
sap.ui.predefine('sap/ui/unified/library',['sap/ui/core/Core','sap/ui/base/Object','sap/ui/core/library'],function(C,B){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.unified",version:"1.68.0",dependencies:["sap.ui.core"],designtime:"sap/ui/unified/designtime/library.designtime",types:["sap.ui.unified.CalendarAppointmentVisualization","sap.ui.unified.CalendarDayType","sap.ui.unified.CalendarIntervalType","sap.ui.unified.ColorPickerDisplayMode","sap.ui.unified.ColorPickerMode","sap.ui.unified.ContentSwitcherAnimation","sap.ui.unified.GroupAppointmentsMode","sap.ui.unified.StandardCalendarLegendItem"],interfaces:["sap.ui.unified.IProcessableBlobs"],controls:["sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.Header","sap.ui.unified.calendar.Month","sap.ui.unified.calendar.MonthPicker","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.YearPicker","sap.ui.unified.Calendar","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarWeekInterval","sap.ui.unified.CalendarMonthInterval","sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarLegend","sap.ui.unified.CalendarRow","sap.ui.unified.ContentSwitcher","sap.ui.unified.ColorPicker","sap.ui.unified.ColorPickerPopover","sap.ui.unified.Currency","sap.ui.unified.FileUploader","sap.ui.unified.Menu","sap.ui.unified.Shell","sap.ui.unified.ShellLayout","sap.ui.unified.ShellOverlay","sap.ui.unified.SplitContainer"],elements:["sap.ui.unified.CalendarAppointment","sap.ui.unified.CalendarLegendItem","sap.ui.unified.DateRange","sap.ui.unified.DateTypeRange","sap.ui.unified.FileUploaderParameter","sap.ui.unified.FileUploaderXHRSettings","sap.ui.unified.MenuItem","sap.ui.unified.MenuItemBase","sap.ui.unified.MenuTextFieldItem","sap.ui.unified.ShellHeadItem","sap.ui.unified.ShellHeadUserItem"],extensions:{"sap.ui.support":{publicRules:true}}});var t=sap.ui.unified;t.CalendarDayType={None:"None",NonWorking:"NonWorking",Type01:"Type01",Type02:"Type02",Type03:"Type03",Type04:"Type04",Type05:"Type05",Type06:"Type06",Type07:"Type07",Type08:"Type08",Type09:"Type09",Type10:"Type10",Type11:"Type11",Type12:"Type12",Type13:"Type13",Type14:"Type14",Type15:"Type15",Type16:"Type16",Type17:"Type17",Type18:"Type18",Type19:"Type19",Type20:"Type20"};t.StandardCalendarLegendItem={Today:"Today",WorkingDay:"WorkingDay",NonWorkingDay:"NonWorkingDay",Selected:"Selected"};t.CalendarIntervalType={Hour:"Hour",Day:"Day",Month:"Month",Week:"Week",OneMonth:"One Month"};t.GroupAppointmentsMode={Collapsed:"Collapsed",Expanded:"Expanded"};t.CalendarAppointmentVisualization={Standard:"Standard",Filled:"Filled"};t.ContentSwitcherAnimation={None:"None",Fade:"Fade",ZoomIn:"ZoomIn",ZoomOut:"ZoomOut",Rotate:"Rotate",SlideRight:"SlideRight",SlideOver:"SlideOver"};t.ColorPickerMode={HSV:"HSV",HSL:"HSL"};t.ColorPickerDisplayMode={Default:"Default",Large:"Large",Simplified:"Simplified"};t._ContentRenderer=B.extend("sap.ui.unified._ContentRenderer",{constructor:function(c,s,o,a){B.apply(this);this._id=s;this._cntnt=o;this._ctrl=c;this._rm=sap.ui.getCore().createRenderManager();this._cb=a||function(){};},destroy:function(){this._rm.destroy();delete this._rm;delete this._id;delete this._cntnt;delete this._cb;delete this._ctrl;if(this._rerenderTimer){clearTimeout(this._rerenderTimer);delete this._rerenderTimer;}B.prototype.destroy.apply(this,arguments);},render:function(){if(!this._rm){return;}if(this._rerenderTimer){clearTimeout(this._rerenderTimer);}this._rerenderTimer=setTimeout(function(){var c=document.getElementById(this._id);if(c){if(typeof(this._cntnt)==="string"){var a=this._ctrl.getAggregation(this._cntnt,[]);for(var i=0;i<a.length;i++){this._rm.renderControl(a[i]);}}else{this._cntnt(this._rm);}this._rm.flush(c);}this._cb(!!c);}.bind(this),0);}});t._iNumberOfOpenedShellOverlays=0;if(!t.ColorPickerHelper){t.ColorPickerHelper={isResponsive:function(){return false;},factory:{createLabel:function(){throw new Error("no Label control available");},createInput:function(){throw new Error("no Input control available");},createSlider:function(){throw new Error("no Slider control available");},createRadioButtonGroup:function(){throw new Error("no RadioButtonGroup control available");},createRadioButtonItem:function(){throw new Error("no RadioButtonItem control available");}},bFinal:false};}if(!t.FileUploaderHelper){t.FileUploaderHelper={createTextField:function(i){throw new Error("no TextField control available!");},setTextFieldContent:function(T,w){throw new Error("no TextField control available!");},createButton:function(){throw new Error("no Button control available!");},addFormClass:function(){return null;},bFinal:false};}t.calendar=t.calendar||{};return t;});
sap.ui.require.preload({
	"sap/ui/unified/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.unified","type":"library","embeds":[],"applicationVersion":{"version":"1.68.0"},"title":"Unified controls intended for both, mobile and desktop scenarios","description":"Unified controls intended for both, mobile and desktop scenarios","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.68","libs":{"sap.ui.core":{"minVersion":"1.68.0"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.Header","sap.ui.unified.calendar.Month","sap.ui.unified.calendar.MonthPicker","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.YearPicker","sap.ui.unified.Calendar","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarWeekInterval","sap.ui.unified.CalendarMonthInterval","sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarLegend","sap.ui.unified.CalendarRow","sap.ui.unified.ContentSwitcher","sap.ui.unified.ColorPicker","sap.ui.unified.ColorPickerPopover","sap.ui.unified.Currency","sap.ui.unified.FileUploader","sap.ui.unified.Menu","sap.ui.unified.Shell","sap.ui.unified.ShellLayout","sap.ui.unified.ShellOverlay","sap.ui.unified.SplitContainer"],"elements":["sap.ui.unified.CalendarAppointment","sap.ui.unified.CalendarLegendItem","sap.ui.unified.DateRange","sap.ui.unified.DateTypeRange","sap.ui.unified.FileUploaderParameter","sap.ui.unified.FileUploaderXHRSettings","sap.ui.unified.MenuItem","sap.ui.unified.MenuItemBase","sap.ui.unified.MenuTextFieldItem","sap.ui.unified.ShellHeadItem","sap.ui.unified.ShellHeadUserItem"],"types":["sap.ui.unified.CalendarAppointmentVisualization","sap.ui.unified.CalendarDayType","sap.ui.unified.CalendarIntervalType","sap.ui.unified.ColorPickerDisplayMode","sap.ui.unified.ColorPickerMode","sap.ui.unified.ContentSwitcherAnimation","sap.ui.unified.GroupAppointmentsMode","sap.ui.unified.StandardCalendarLegendItem"],"interfaces":["sap.ui.unified.IProcessableBlobs"]}}}}'
},"sap/ui/unified/library-preload"
);
//# sourceMappingURL=library-preload.js.map