/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/OverflowToolbarLayoutData","sap/ui/Device","sap/ui/core/theming/Parameters","sap/m/library"],function(O,D,P,l){"use strict";var a=l.OverflowToolbarPriority;var R=function(c){this._oControl=c;this._iREMSize=parseInt(jQuery("body").css("font-size"));this._iChildControlMargin=parseInt(P.get("_sap_f_ShellBar_ChildMargin"));this._iDoubleChildControlMargin=this._iChildControlMargin*2;this._iCoPilotWidth=parseInt(P.get("_sap_f_ShellBar_CoPilotWidth"))+this._iDoubleChildControlMargin;this._iHalfCoPilotWidth=this._iCoPilotWidth/2;this._oDelegate={onAfterRendering:this.onAfterRendering,onBeforeRendering:this.onBeforeRendering};this._oControl.addDelegate(this._oDelegate,false,this);this._fnResize=this._resize;this._oControl._oOverflowToolbar.attachEvent("_controlWidthChanged",this._handleResize,this);};R.prototype.onAfterRendering=function(){var p=D.media.getCurrentRange("Std",this._oControl.$().outerWidth(true)).name==="Phone";this._oButton=this._oControl._oMegaMenu&&this._oControl._oMegaMenu.getAggregation("_button");this._oDomRef=this._oControl.getDomRef();this.bIsMegaMenuConfigured=this._oControl._oTitleControl&&this._oControl._oTitleControl===this._oControl._oMegaMenu;if(this._oControl._oTitleControl){if(this.bIsMegaMenuConfigured&&this._oButton&&this._oButton._image){if(!this.bMenuButtonImageLoadAttached){this._oButton._image.attachEvent("load",this._updateMegaMenuWidth,this);this.bMenuButtonImageLoadAttached=true;}}if(!this.bIsMegaMenuConfigured){setTimeout(this._updateMegaMenuWidth.bind(this),0);}}if(this._oControl._oHomeIcon&&!this.bHomeIconLoadAttached){this._oControl._oHomeIcon.attachEvent("load",this._updateHomeIconWidth,this);this.bHomeIconLoadAttached=true;}if(this._oControl._oManagedSearch&&!this._bAttachedManagedSearchHandler){this._oControl._oManagedSearch.attachEvent("_updateVisualState",this._switchOpenStateOnSearch,this);this._bAttachedManagedSearchHandler=true;}if(p){this._transformTitleControlMobile();}this._initResize();this._handleResize();};R.prototype.exit=function(){if(this._oControl._oOverflowToolbar){this._oControl._oOverflowToolbar.detachEvent("_controlWidthChanged",this._handleResize,this);}if(this._oControl._oHomeIcon){this._oControl._oHomeIcon.detachEvent("load",this._updateHomeIconWidth,this);this.bHomeIconLoadAttached=false;}if(this._oButton){this._oButton.detachEvent("load",this._updateMegaMenuWidth,this);}if(this._oControl._oTitleControl&&this.bIsMegaMenuConfigured&&this._oButton&&this._oButton._image){this._oButton._image.detachEvent("load",this._updateMegaMenuWidth,this);this.bMenuButtonImageLoadAttached=false;}this._oControl.removeDelegate(this._oDelegate);};R.prototype._initResize=function(){this._iStaticWidth=0;this._iMBWidth=0;this._iStaticWidthForSearch=0;if(this._oControl._oTitleControl){this._iMBWidth=this.getTargetWidth(this._oControl._oTitleControl,true)+this._oControl._oTitleControl._iStaticWidth+this._iDoubleChildControlMargin;}this._iTitleWidth=this.getTargetWidth(this._oControl._oSecondTitle);if(this._oControl._oHomeIcon){this._iStaticWidth+=this._oControl._oHomeIcon.$().outerWidth(true);}if(this._oControl._oNavButton){this._iStaticWidth+=36+this._iDoubleChildControlMargin;}if(this._oControl._oMenuButton){this._iStaticWidth+=36+this._iChildControlMargin;}if(this._oControl._oAvatarButton){this._iStaticWidthForSearch+=36+this._iDoubleChildControlMargin;}if(this._oControl._oProductSwitcher||this._oControl._oNotifications||this._oControl.getAdditionalContent()){this._iStaticWidthForSearch+=36+this._iDoubleChildControlMargin;}if(this._oControl&&this._oControl._oCopilot){this._iStaticWidthForSearch+=this._iHalfCoPilotWidth;}};R.prototype._updateHomeIconWidth=function(){this._initResize();this._fnResize();};R.prototype._updateMegaMenuWidth=function(){this._initResize();this._fnResize();};R.prototype._handleResize=function(){if(!this._oDomRef){return;}var c=this._oControl.$(),w=c.outerWidth(),C=D.media.getCurrentRange("Std",w),p;if(C){p=C.name==="Phone";c.toggleClass("sapFShellBarSizeDesktop",C.name==="Desktop");c.toggleClass("sapFShellBarSizeTablet",C.name==="Tablet");c.toggleClass("sapFShellBarSizePhone",p);}if(this._iPreviousWidth===w){return;}this._iPreviousWidth=w;if(!this._oControl._oNavButton&&!this._oControl._oMenuButton&&!this._oControl._oHomeIcon&&!this._oControl._oMegaMenu&&!this._oControl._oSecondTitle&&!this._oControl._oCopilot){return;}if(p&&!this.bWasInPhoneRange){this._fnResize=this._resizeOnPhone;this._transformToPhoneState();}else if(!p&&this.bWasInPhoneRange){this._fnResize=this._resize;this._transformToRegularState();}setTimeout(this._fnResize.bind(this),0);};R.prototype._switchOpenStateOnSearch=function(){if(this.bWasInPhoneRange){this._transformToPhoneState();}else{this._transformToRegularState();}};R.prototype._transformToPhoneState=function(){var s=this._oControl._oManagedSearch;if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(false);}this._transformTitleControlMobile();if(!this._controlsLayoutDataCached){this._cacheControlsLayoutData();this._controlsLayoutDataCached=true;}this._oControl._aOverflowControls.forEach(function(c){c.setLayoutData(new O({priority:a.AlwaysOverflow}));});this.bWasInPhoneRange=true;if(s){s.setPhoneMode(true);if(s.getIsOpen()){this._toggleAllControlsExceptSearch(false);this._bSearchWasOpen=true;}else if(this._bSearchWasOpen){this._toggleAllControlsExceptSearch(true);this._oControl._oHomeIcon.setVisible(false);this._oControl._oSecondTitle.setVisible(false);this._bSearchWasOpen=false;}}this._oControl.invalidate();};R.prototype._transformToRegularState=function(){var s=this._oControl._oManagedSearch;this._toggleAllControlsExceptSearch(true);if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(true);}if(this._oControl._oHomeIcon){if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setWidth("auto").setText(this._oControl._sTitle).setIcon("");}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setWidth("auto").setText(this._oControl._sTitle);}if(this.bIsMegaMenuConfigured){this._oControl._oHomeIcon.setVisible(true);}}if(this._controlsLayoutDataCached){this._restoreControlsLayoutData();this._controlsLayoutDataCached=false;}this.bWasInPhoneRange=false;s&&s.setPhoneMode(false);this._oControl.invalidate();};R.prototype._transformTitleControlMobile=function(){if(this._oControl._oHomeIcon){if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setWidth("auto").setText("").setIcon(this._oControl.getHomeIcon());}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setWidth("0").setText("");}this._oControl._oHomeIcon.setVisible(!this.bIsMegaMenuConfigured);}};R.prototype._resizeOnPhone=function(){var w=this._oControl._getOverflowToolbar().$().width(),A;if(this._oControl._oCopilot){w-=this._iCoPilotWidth;A=(w/2)-this._iStaticWidth;}else{A=w-this._iStaticWidth-this._getWidthOfAllNonManagedControls();}if(!this._oControl._oHomeIcon&&this.bIsMegaMenuConfigured){if(this._iMBWidth>=A){this._oControl._oTitleControl.setWidth((A-this._iDoubleChildControlMargin)+"px");}else{this._oControl._oTitleControl.setWidth((this._iMBWidth-this._iDoubleChildControlMargin)+"px");}}if(this._oControl._oTitleControl){A-=this._oControl._oTitleControl.$().outerWidth(true);}if(A<0){A=0;}this._oControl._oCopilot&&this._oControl._oControlSpacer.setWidth(A+"px");};R.prototype._resize=function(){var w=this._oControl._getOverflowToolbar().$().width(),A,o,h=w/2;if(this._oControl._oManagedSearch&&this._oControl._oManagedSearch.getIsOpen()){this._adaptSearch(h);}if(!this._oControl._oCopilot){o=this._getWidthOfAllNonManagedControls();A=w-o-this._iStaticWidth-(8*this._iREMSize);this._adaptManagedWidthControls(A);return;}A=h-this._iHalfCoPilotWidth-this._iStaticWidth;this._adaptManagedWidthControls(A);};R.prototype._getWidthOfAllNonManagedControls=function(){var c=this._oControl._oOverflowToolbar.$().children(),o=0;c.filter(function(i,d){var C=jQuery(d),b=C.control(0);if(b===this._oControl._oNavButton){return false;}if(b===this._oControl._oMenuButton){return false;}if(b===this._oControl._oHomeIcon){return false;}if(b===this._oControl._oMegaMenu){return false;}if(b===this._oControl._oSecondTitle){return false;}if(b===this._oControl._oControlSpacer){return false;}if(b===this._oControl._oToolbarSpacer){return false;}o+=C.outerWidth(true);return true;}.bind(this));return o;};R.prototype._adaptSearch=function(A){A=A-this._iStaticWidthForSearch-this._iDoubleChildControlMargin;if(A>464){this._oControl._oManagedSearch.setWidth("464px");return;}if(A<192){this._toggleAllControlsExceptSearch(false);this._oControl._oManagedSearch.setWidth("100%");this._oControl._oManagedSearch.setPhoneMode(true);this._bSearchFullWidth=true;return;}if(this._bSearchFullWidth){this._toggleAllControlsExceptSearch(true);this._oControl._oManagedSearch.setPhoneMode(false);this._bSearchFullWidth=false;}this._oControl._oManagedSearch.setWidth(A+"px");};R.prototype._toggleAllControlsExceptSearch=function(s){this._oControl._oOverflowToolbar.getContent().forEach(function(o){if(o!==this._oControl._oManagedSearch){o.setVisible(s);}}.bind(this));};R.prototype._adaptManagedWidthControls=function(A){var h=!!this._oControl._oTitleControl,m=h?this._iMBWidth:0,t=this._iTitleWidth,c=m+t,s=this._oControl._oSecondTitle,C=this._oControl._oControlSpacer,S,M=80,i;if(A<=0){C&&C.setWidth("0px");s&&s.setWidth("0px");h&&this._oControl._oTitleControl.setWidth(M+"px");return;}if(c<0){c=0;}if(m<0){m=0;}if(m>=A){C&&C.setWidth("0px");s&&s.setWidth("0px");i=A-this._iDoubleChildControlMargin<=M?M:A-this._iDoubleChildControlMargin;h&&this._oControl._oTitleControl.setWidth(i+"px");return;}else{i=m-this._iDoubleChildControlMargin<=M?M:m-this._iDoubleChildControlMargin;h&&this._oControl._oTitleControl.setWidth(i+"px");}if(A>=m&&A<=c){S=A-m;if(S<0){S=0;}if(S>32){C&&C.setWidth("0px");s&&s.setWidth(S+"px");}else{C&&C.setWidth(S+"px");s&&s.setWidth("0px");}return;}else{s&&s.setWidth(t+"px");}if(A>c){C&&C.setWidth((A-c)+"px");}};R.prototype._cacheControlsLayoutData=function(){this._oCachedLayoutData={};this._oControl._aOverflowControls.forEach(function(c){this._oCachedLayoutData[c.getId()]=c.getLayoutData();}.bind(this));};R.prototype._restoreControlsLayoutData=function(){this._oControl._aOverflowControls.forEach(function(c){var L=this._oCachedLayoutData[c.getId()];if(L){c.setLayoutData(L);}}.bind(this));};R.prototype.getTargetWidth=function(c,b){if(!c){return 0;}var t=c.getText(),d=document.createElement("div"),T=document.createTextNode(t),s=sap.ui.getCore().getStaticAreaRef(),w;d.appendChild(T);d.style.setProperty("white-space","nowrap");d.style.setProperty("display","inline-block");d.style.setProperty("font-size",c._sFontSize);if(b){d.style.setProperty("font-weight","bold");}s.appendChild(d);if(d.getBoundingClientRect){w=d.getBoundingClientRect().width;}else{w=d.scrollWidth;}w+=1;s.removeChild(d);return w;};return R;});
