/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/Device','./Button','./ResponsivePopover','./ColorPalette','./library'],function(C,D,B,R,a,l){"use strict";var P=l.PlacementType;var b=C.extend("sap.m.ColorPalettePopover",{metadata:{library:"sap.m",publicMethods:["openBy","close"],properties:{defaultColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]},showDefaultColorButton:{type:"boolean",group:"Appearance",defaultValue:true},showMoreColorsButton:{type:"boolean",group:"Appearance",defaultValue:true}},events:{colorSelect:{parameters:{"value":{type:"sap.ui.core.CSSColor"},"defaultAction":{type:"boolean"}}}}},renderer:{}});var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");var F={COLOR_PALETTE_PROPS:{colors:"setColors",defaultColor:"_setDefaultColor",showDefaultColorButton:"_setShowDefaultColorButton",showMoreColorsButton:"_setShowMoreColorsButton"},POPOVER_METHODS:{getDomRef:"",close:""}};b.prototype.init=function(){this._oPopover=null;this._bPopoverDestroying=null;};b.prototype.exit=function(){this._bPopoverDestroying=true;if(this._oPopover){this._oPopover.removeDelegate(this._oPopover._onAfterRenderingDelegate);this._oPopover.destroy();this._oPopover=null;}};b.prototype.openBy=function(o){return R.prototype.openBy.apply(this._ensurePopover(),arguments);};b.prototype._getPalette=function(){return this._ensurePopover().getContent()[0];};b.prototype._ensurePopover=function(){if(!this._oPopover){this._oPopover=this._createPopover();}return this._oPopover;};b.prototype._createPopover=function(){var p,c=this._createColorPalette(),d;p=new R(this.getId()+"-colorPalettePopover",{showHeader:D.system.phone,placement:P.VerticalPreferredBottom,showArrow:false,showCloseButton:false,title:L.getText("COLOR_PALETTE_TITLE"),content:c,afterOpen:c._focusFirstElement.bind(c)}).addStyleClass("sapMColorPaletteContainer");if(D.system.phone){p.setEndButton(new B({text:L.getText("COLOR_PALETTE_CANCEL"),press:function(){p.close();}}));}c.attachEvent("_beforeOpenColorPicker",function(){p.close();});c.attachEvent("_colorNotSelected",function(e){this._handleNextOrPreviousUponPaletteClose(e);p.close();}.bind(this));c.attachEvent("colorSelect",function(e){this._handleNextOrPreviousUponPaletteClose(e);p.close();this.fireColorSelect({"value":e.getParameter("value"),"defaultAction":e.getParameter("defaultAction")});}.bind(this));d={onAfterRendering:function(){var $=this.$();$.attr("aria-modal","true");$.attr("aria-label",this.getTitle());}};p.addEventDelegate(d,p);p._onAfterRenderingDelegate=d;return p;};b.prototype._createColorPalette=function(){var c=new a(this.getId()+"-palette");c._setShowDefaultColorButton(this.getShowDefaultColorButton());c._setShowMoreColorsButton(this.getShowMoreColorsButton());return c;};b.prototype._handleNextOrPreviousUponPaletteClose=function(e){var o=e.getParameter("_originalEvent");if(!o){return;}if(o.type==="saptabnext"||o.type==="saptabprevious"){o.stopPropagation();o.preventDefault();}};b.prototype.setProperty=function(p,v,s){var t;if(F.COLOR_PALETTE_PROPS[p]!==undefined){t=F.COLOR_PALETTE_PROPS[p]||p;a.prototype[t].call(this._getPalette(),v);}return C.prototype.setProperty.apply(this,arguments);};Object.keys(F.POPOVER_METHODS).forEach(function(s){var t=F.COLOR_PALETTE_PROPS[s]||s;b.prototype[s]=function(){if(this._bPopoverDestroying){return null;}var p=this._ensurePopover();return p[t].apply(p,arguments);};});return b;});
