/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/DataType","sap/ui/events/KeyCodes","sap/ui/model/BindingMode","sap/ui/Device","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Icon","sap/ui/core/theming/Parameters","./library","./Button","./CheckBox","./RadioButton","./ListItemBaseRenderer","sap/base/strings/capitalize","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(D,K,B,a,c,C,I,b,T,l,d,e,R,L,f,q){"use strict";var g=l.ListKeyboardMode;var h=l.ListMode;var i=l.ListType;var j=l.ButtonType;var M=c.MessageType;var k=C.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:i.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null},highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}},designtime:"sap/m/designtime/ListItemBase.designtime"}});k.getAccessibilityText=function(o,m){if(!o||!o.getVisible||!o.getVisible()){return"";}var A;if(o.getAccessibilityInfo){A=o.getAccessibilityInfo();}if(!A||!o.getAccessibilityInfo){A=this.getDefaultAccessibilityInfo(o.getDomRef());}A=q.extend({type:"",description:"",children:[]},A);var n=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=A.type+" "+A.description+" ",s=o.getTooltip_AsString();if(A.enabled===false){t+=n.getText("CONTROL_DISABLED")+" ";}if(A.editable===false){t+=n.getText("CONTROL_READONLY")+" ";}if(!A.type&&s&&t.indexOf(s)==-1){t=s+" "+t;}A.children.forEach(function(p){t+=k.getAccessibilityText(p)+" ";});t=t.trim();if(m&&!t){t=n.getText("CONTROL_EMPTY");}return t;};k.getDefaultAccessibilityInfo=function(o){if(!o){return null;}var N=window.Node,m=window.NodeFilter,t=document.createTreeWalker(o,m.SHOW_TEXT+m.SHOW_ELEMENT,function(p){if(p.type===N.ELEMENT_NODE){if(p.classList.contains("sapUiInvisibleText")){return m.FILTER_SKIP;}if(p.getAttribute("aria-hidden")=="true"||p.style.visibility=="hidden"||p.style.display=="none"){return m.FILTER_REJECT;}return m.FILTER_SKIP;}return m.FILTER_ACCEPT;},false);var n=[];while(t.nextNode()){var p=t.currentNode;if(p.nodeType===N.TEXT_NODE){var s=(p.nodeValue||"").trim();if(s){n.push(s);}}}return{description:n.join(" ")};};k.prototype.DetailIconURI=I.getIconURI("edit");k.prototype.NavigationIconURI=I.getIconURI("slim-arrow-right");k.prototype.TagName="li";k.prototype.init=function(){this._active=false;this._bGroupHeader=false;this._bNeedsHighlight=false;};k.prototype.onAfterRendering=function(){this.informList("DOMUpdate",true);this._checkHighlight();};k.prototype.invalidate=function(){if(!this.bOutput){return;}C.prototype.invalidate.apply(this,arguments);};k.prototype.getBindingContextPath=function(m){var o=this.getList();if(o&&!m){m=(o.getBindingInfo("items")||{}).model;}var n=this.getBindingContext(m);if(n){return n.getPath();}};k.prototype.isSelectedBoundTwoWay=function(){var o=this.getBinding("selected");if(o&&o.getBindingMode()==B.TwoWay){return true;}};k.prototype.getList=function(){var p=this.getParent();if(p&&p.isA("sap.m.ListBase")){return p;}};k.prototype.getListProperty=function(p,F){var o=this.getList();if(o){p=f(p);return o["get"+p]();}return F;};k.prototype.informList=function(E,p,P){var o=this.getList();if(o){var m="onItem"+E;if(o[m]){o[m](this,p,P);}}};k.prototype.informSelectedChange=function(s){var o=this.getList();if(o){o.onItemSelectedChange(this,s);this.bSelectedDelayed=undefined;}else{this.bSelectedDelayed=s;}};k.prototype.getAccessibilityType=function(o){return o.getText("ACC_CTR_TYPE_OPTION");};k.prototype.getGroupAnnouncement=function(){return this.$().prevAll(".sapMGHLI:first").text();};k.prototype.getAccessibilityDescription=function(o){var O=[],t=this.getType(),H=this.getHighlight(),s=this.getTooltip_AsString();if(this.getSelected()){O.push(o.getText("LIST_ITEM_SELECTED"));}if(H!==M.None){var m=this.getHighlightText();if(H in M&&!m){m=o.getText("LIST_ITEM_STATE_"+H.toUpperCase());}O.push(m);}if(this.getUnread()&&this.getListProperty("showUnread")){O.push(o.getText("LIST_ITEM_UNREAD"));}if(this.getCounter()){O.push(o.getText("LIST_ITEM_COUNTER",this.getCounter()));}if(t==i.Navigation){O.push(o.getText("LIST_ITEM_NAVIGATION"));}else{if(t==i.Detail||t==i.DetailAndActive){O.push(o.getText("LIST_ITEM_DETAIL"));}if(t==i.Active||t==i.DetailAndActive){O.push(o.getText("LIST_ITEM_ACTIVE"));}}O.push(this.getGroupAnnouncement()||"");if(this.getContentAnnouncement){O.push((this.getContentAnnouncement(o)||"").trim());}if(s){O.push(s);}return O.join(" ");};k.prototype.getAccessibilityInfo=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{type:this.getAccessibilityType(o),description:this.getAccessibilityDescription(o),focusable:true};};k.prototype.getMode=function(){return this.getListProperty("mode","");};k.prototype.updateAccessibilityState=function(A){var t=this.$();if(!t.length){return;}var $=t.parent().children(".sapMLIB");t.attr(q.extend({"aria-setsize":$.length,"aria-posinset":$.index(t)+1},A));};k.prototype.getDeleteControl=function(m){if(!m||this._oDeleteControl){return this._oDeleteControl;}if(!this.DeleteIconURI){k.prototype.DeleteIconURI=I.getIconURI(T.get("_sap_m_ListItemBase_DeleteIcon"));}this._oDeleteControl=new d({id:this.getId()+"-imgDel",icon:this.DeleteIconURI,type:j.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_DELETE")}).addStyleClass("sapMLIBIconDel sapMLIBSelectD").setParent(this,null,true).attachPress(function(E){this.informList("Delete");},this);this._oDeleteControl._bExcludeFromTabChain=true;return this._oDeleteControl;};k.prototype.onThemeChanged=function(){k.prototype.DeleteIconURI=I.getIconURI(T.get("_sap_m_ListItemBase_DeleteIcon"));if(this._oDeleteControl){this._oDeleteControl.setIcon(this.DeleteIconURI);}};k.prototype.getDetailControl=function(m){if(!m||this._oDetailControl){return this._oDetailControl;}this._oDetailControl=new d({id:this.getId()+"-imgDet",icon:this.DetailIconURI,type:j.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_EDIT")}).addStyleClass("sapMLIBType sapMLIBIconDet").setParent(this,null,true).attachPress(function(){this.fireDetailTap();this.fireDetailPress();},this);this._oDetailControl._bExcludeFromTabChain=true;return this._oDetailControl;};k.prototype.getNavigationControl=function(m){if(!m||this._oNavigationControl){return this._oNavigationControl;}this._oNavigationControl=new b({id:this.getId()+"-imgNav",src:this.NavigationIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBType sapMLIBImgNav");return this._oNavigationControl;};k.prototype.getSingleSelectControl=function(m){if(!m||this._oSingleSelectControl){m&&this._oSingleSelectControl.setSelected(this.getSelected());return this._oSingleSelectControl;}this._oSingleSelectControl=new R({id:this.getId()+"-selectSingle",groupName:this.getListProperty("id")+"_selectGroup",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectS").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oSingleSelectControl;};k.prototype.getMultiSelectControl=function(m){if(!m||this._oMultiSelectControl){m&&this._oMultiSelectControl.setSelected(this.getSelected());return this._oMultiSelectControl;}this._oMultiSelectControl=new e({id:this.getId()+"-selectMulti",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oMultiSelectControl;};k.prototype.getModeControl=function(m){var s=this.getMode();if(!s||s==h.None){return;}if(s==h.Delete){return this.getDeleteControl(m);}if(s==h.MultiSelect){return this.getMultiSelectControl(m);}return this.getSingleSelectControl(m);};k.prototype.getTypeControl=function(m){var t=this.getType();if(t==i.Detail||t==i.DetailAndActive){return this.getDetailControl(m);}if(t==i.Navigation){return this.getNavigationControl(m);}};k.prototype.destroyControls=function(m){m.forEach(function(s){s="_o"+s+"Control";if(this[s]){this[s].destroy("KeepDom");this[s]=null;}},this);};k.prototype.isActionable=function(){return this.isIncludedIntoSelection()||(this.getType()!=i.Inactive&&this.getType()!=i.Detail);};k.prototype.exit=function(){this._oLastFocused=null;this._checkHighlight(false);this.setActive(false);this.destroyControls(["Delete","SingleSelect","MultiSelect","Detail","Navigation"]);};k.prototype.setHighlight=function(v){if(v==null){v=M.None;}else if(!D.getType("sap.ui.core.MessageType").isValid(v)&&!D.getType("sap.ui.core.IndicationColor").isValid(v)){throw new Error('"'+v+'" is not a value of the enums sap.ui.core.MessageType or sap.ui.core.IndicationColor for property "highlight" of '+this);}return this.setProperty("highlight",v);};k.prototype.isSelectable=function(){var m=this.getMode();return!(m==h.None||m==h.Delete);};k.prototype.getSelected=function(){if(this.isSelectable()){return this.getProperty("selected");}return false;};k.prototype.isSelected=k.prototype.getSelected;k.prototype.setSelected=function(s,m){s=this.validateProperty("selected",s);if(!this.isSelectable()||s==this.getSelected()){return this;}if(!m){this.informSelectedChange(s);}var S=this.getModeControl();if(S){S.setSelected(s);}this.updateSelectedDOM(s,this.$());this.setProperty("selected",s,true);return this;};k.prototype.updateSelectedDOM=function(s,t){t.toggleClass("sapMLIBSelected",s);t.attr("aria-selected",s);};k.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(!p){this._bGroupHeader=false;return;}this.informList("Inserted",this.bSelectedDelayed);return this;};k.prototype.setBindingContext=function(){C.prototype.setBindingContext.apply(this,arguments);this.informList("BindingContextSet");return this;};k.prototype.isGroupHeader=function(){return this._bGroupHeader;};k.prototype.isIncludedIntoSelection=function(){if(!this.isSelectable()){return false;}var m=this.getMode();return m==h.SingleSelectMaster||(this.getListProperty("includeItemInSelection")&&(m==h.SingleSelectLeft||m==h.SingleSelect||m==h.MultiSelect));};k.prototype._checkHighlight=function(n){if(n==undefined){n=(this.getVisible()&&this.getHighlight()!=M.None);}if(this._bNeedsHighlight!=n){this._bNeedsHighlight=n;this.informList("HighlightChange",n);}};k.prototype.hasActiveType=function(){var t=this.getType();return(t==i.Active||t==i.Navigation||t==i.DetailAndActive);};k.prototype.setActive=function(A){if(A==this._active){return this;}if(A&&this.getListProperty("activeItem")){return this;}var t=this.$();this._active=A;this._activeHandling(t);if(this.getType()==i.Navigation){this._activeHandlingNav(t);}if(A){this._activeHandlingInheritor(t);}else{this._inactiveHandlingInheritor(t);}this.informList("ActiveChange",A);};k.detectTextSelection=function(o){var s=window.getSelection(),t=s.toString().replace("\n","");return t&&q.contains(o,s.focusNode);};k.prototype.ontap=function(E){if(this._eventHandledByControl){return E.setMarked();}if(k.detectTextSelection(this.getDomRef())){return;}if(this.isIncludedIntoSelection()){if(this.getMode()==h.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}}else if(this.hasActiveType()){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);if(a.os.ios){this.focus();}setTimeout(function(){this.setActive(false);}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress();}.bind(this),0);}this.informList("Press",E.srcControl);};k.prototype.ontouchstart=function(E){this._eventHandledByControl=E.isMarked();var t=E.targetTouches[0];this._touchedY=t.clientY;this._touchedX=t.clientX;if(this._eventHandledByControl||E.touches.length!=1||!this.hasActiveType()){return;}this._timeoutIdStart=setTimeout(function(){this.setActive(true);}.bind(this),100);};k.prototype.ontouchmove=function(E){if((this._active||this._timeoutIdStart)&&(Math.abs(this._touchedY-E.targetTouches[0].clientY)>10||Math.abs(this._touchedX-E.targetTouches[0].clientX)>10)){clearTimeout(this._timeoutIdStart);this._timeoutIdStart=null;this._timeoutIdEnd=null;this.setActive(false);}};k.prototype.ontouchend=function(E){if(E.targetTouches.length==0&&this.hasActiveType()){this._timeoutIdEnd=setTimeout(function(){this.setActive(false);}.bind(this),100);}};k.prototype.ontouchcancel=k.prototype.ontouchend;k.prototype._activeHandlingNav=function(){};k.prototype._activeHandlingInheritor=function(){};k.prototype._inactiveHandlingInheritor=function(){};k.prototype._activeHandling=function(t){t.toggleClass("sapMLIBActive",this._active);if(a.system.desktop&&this.isActionable()){t.toggleClass("sapMLIBHoverable",!this._active);}};k.prototype.onsapspace=function(E){if(E.srcControl!==this){return;}E.preventDefault();if(E.isMarked()||!this.isSelectable()){return;}if(this.getMode()==h.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}E.setMarked();};k.prototype.onsapenter=function(E){var o=this.getList();if(E.isMarked()||!o){return;}if(E.srcControl!==this&&o.getKeyboardMode()==g.Edit){o.setKeyboardMode(g.Navigation);this._switchFocus(E);return;}if(E.srcControl!==this){return;}if(this.isIncludedIntoSelection()){this.onsapspace(E);}else if(this.hasActiveType()){E.setMarked();this.setActive(true);setTimeout(function(){this.setActive(false);}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress();}.bind(this),0);}o.onItemPress(this,E.srcControl);};k.prototype.onsapdelete=function(E){if(E.isMarked()||E.srcControl!==this||this.getMode()!=h.Delete){return;}this.informList("Delete");E.preventDefault();E.setMarked();};k.prototype._switchFocus=function(E){var o=this.getList();if(!o){return;}var t=this.getTabbables();if(E.srcControl!==this){o._iLastFocusPosOfItem=t.index(E.target);this.focus();}else if(t.length){var F=o._iLastFocusPosOfItem||0;F=t[F]?F:-1;t.eq(F).focus();}E.preventDefault();E.setMarked();};k.prototype.onkeydown=function(E){if(E.isMarked()){return;}if(E.which==K.F7){this._switchFocus(E);return;}if(E.which==K.F2){if(E.srcControl===this&&this.getType().indexOf("Detail")==0&&this.hasListeners("detailPress")||this.hasListeners("detailTap")){this.fireDetailTap();this.fireDetailPress();E.preventDefault();E.setMarked();}else{var o=this.getList();if(o){this.$().prop("tabIndex",-1);o.setKeyboardMode(o.getKeyboardMode()==g.Edit?g.Navigation:g.Edit);this._switchFocus(E);}}}};k.prototype.getTabbables=function(){return this.$().find(":sapTabbable");};k.prototype.onsaptabnext=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==g.Edit){return;}var m=this.getTabbables().get(-1)||this.getDomRef();if(E.target===m){o.forwardTab(true);E.setMarked();}};k.prototype.onsaptabprevious=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==g.Edit){return;}if(E.target===this.getDomRef()){o.forwardTab(false);E.setMarked();}};k.prototype.onfocusin=function(E){var o=this.getList();if(!o||E.isMarked()){return;}this.informList("FocusIn",E.srcControl);if(E.srcControl===this){return;}if(o.getKeyboardMode()==g.Edit||!q(E.target).is(":sapFocusable")){return;}setTimeout(o["setItemFocusable"].bind(o,this),0);E.setMarked();};k.prototype.onsapup=function(E){if(E.isMarked()||E.srcControl===this||this.getListProperty("keyboardMode")===g.Navigation){return;}this.informList("ArrowUpDown",E);};k.prototype.oncontextmenu=function(E){if(this._bGroupHeader){return;}if(q(document.activeElement).is(":focusable")&&document.activeElement!==this.getDomRef()&&E.srcControl!==this.getModeControl()){return;}this.informList("ContextMenu",E);};k.prototype.onsapdown=k.prototype.onsapup;return k;});
