/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectObserver','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/DateRange','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarRow','sap/ui/unified/CalendarRowRenderer','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarWeekInterval','sap/ui/unified/CalendarOneMonthInterval','sap/ui/unified/CalendarMonthInterval','sap/ui/unified/CalendarTimeInterval','sap/ui/Device','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo','sap/m/Select','sap/m/Button','sap/m/OverflowToolbar','sap/m/Toolbar','sap/m/Table','sap/m/Column','sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/m/StandardListItem','sap/m/StandardListItemRenderer','sap/m/PlanningCalendarRow','sap/m/PlanningCalendarRenderer','sap/m/PlanningCalendarView','sap/m/CheckBox','sap/m/library',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(C,M,a,u,b,c,D,d,e,f,g,h,k,l,m,n,E,R,o,I,p,q,r,S,B,O,T,s,t,v,w,x,y,P,z,A,F,G,H,L,Q){"use strict";var J=u.CalendarDayType;var K=G.ListMode;var N=G.ToolbarDesign;var U=G.ButtonType;var V=G.PlanningCalendarBuiltInView;var W=G.ScreenSize;var X=u.CalendarAppointmentVisualization;var Y=u.GroupAppointmentsMode;var Z=u.CalendarIntervalType;var $="DragDropConfig";var _="ResizeConfig";var a1="CreateConfig";var b1="-CLI";var c1=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:Z.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:Y.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:X.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent",forwarding:{getter:"_getTableHeaderToolbar",aggregation:"content"},forwardBinding:true},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{row:{type:"sap.m.PlanningCalendarRow"}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(i,j){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){j=i;}if(j&&typeof j.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=j.customAppointmentsSorterCallback;}}});var d1=["_oTimeInterval","_oDateInterval","_oMonthInterval","_oWeekInterval","_oOneMonthInterval"],e1={};e1[Z.Day]={sInstanceName:"_oDateInterval",sIdSuffix:"-DateInt",oClass:g};e1[Z.Week]={sInstanceName:"_oWeekInterval",sIdSuffix:"-WeekInt",oClass:h};e1[Z.OneMonth]={sInstanceName:"_oOneMonthInterval",sIdSuffix:"-OneMonthInt",oClass:k};var f1=W.Desktop;var g1=[V.Hour,V.Day,V.Month,V.Week,V.OneMonth];var h1={PHONE:"600",TABLET:"1024"};var i1=["sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarMonthInterval"];var j1=C.extend("CalendarHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addClass("sapMPlanCalHead");i.writeClasses();i.write(">");var L1=j.getToolbar();if(L1){i.renderControl(L1);}var M1=j.getAllCheckBox();if(M1){i.renderControl(M1);}i.write("</div>");}});c1.prototype.init=function(){this._iBreakPointTablet=n.media._predefinedRangeSets[n.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=n.media._predefinedRangeSets[n.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=n.media._predefinedRangeSets[n.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(n.system.phone||Q('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if(n.system.tablet||Q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=new S(i+"-IntType",{maxWidth:"15rem",ariaLabelledBy:i+"-SelDescr"});this._oIntervalTypeSelect.attachEvent("change",l1,this);this._oTodayButton=new B(i+"-Today",{text:this._oRB.getText("PLANNINGCALENDAR_TODAY"),type:U.Transparent});this._oTodayButton.attachEvent("press",this._handleTodayPress,this);this._oHeaderToolbar=new T(i+"-HeaderToolbar",{design:N.Transparent,content:[this._oIntervalTypeSelect,this._oTodayButton]});this._oCalendarHeader=new j1(i+"-CalHead",{toolbar:this._oHeaderToolbar});this._oInfoToolbar=new T(i+"-InfoToolbar",{height:"auto",design:N.Transparent,content:[this._oCalendarHeader,this._oTimeInterval]});var j=new O(this.getId()+"-Toolbar",{design:N.Transparent,visible:false});j._oPlanningCalendar=this;var L1=new s(i+"-Table",{sticky:[],infoToolbar:this._oInfoToolbar,headerToolbar:j,mode:K.SingleSelectMaster,columns:[new t({styleClass:"sapMPlanCalRowHead"}),new t({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:f1,demandPopin:true})],ariaLabelledBy:i+"-Descr"});L1.attachEvent("selectionChange",B1,this);L1.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=L1.$().find(".sapMPlanCalRowHead > div.sapMLIB").click(function(M1){var N1=Q(M1.currentTarget).control(0),O1=x1(N1.getParent());this.fireRowHeaderClick({row:O1});}.bind(this));}},false,this);this.setAggregation("table",L1,true);this.setStartDate(new Date());this._resizeProxy=Q.proxy(p1,this);this._fnCustomSortedAppointments=undefined;this.iWidth=0;};c1.prototype.exit=function(){if(this._sResizeListener){o.deregister(this._sResizeListener);this._sResizeListener=undefined;}n.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var i=this.getAggregation("table");i.removeAllItems();d1.forEach(function(L1){if(this[L1]){this[L1]._oPlanningCalendar=undefined;this[L1].destroy();this[L1]=undefined;}},this);if(this._oViews){for(var j in this._oViews){this._oViews[j].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};c1.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimeInterval&&!this._oDateInterval&&!this._oMonthInterval&&!this._oWeekInterval&&!this._oOneMonthInterval)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}E1.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updateTodayButtonState();n.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;};c1.prototype.attachEvent=function(i,j,L1,M1){C.prototype.attachEvent.call(this,i,j,L1,M1);if(this.hasListeners("intervalSelect")){d1.forEach(function(N1){if(this[N1]){this[N1]._setAriaRole("button");}},this);}return this;};c1.prototype.detachEvent=function(i,j,L1){C.prototype.detachEvent.call(this,i,j,L1);if(!this.hasListeners("intervalSelect")){d1.forEach(function(M1){if(this[M1]){this[M1]._setAriaRole("gridcell");}},this);}return this;};c1.prototype._setAriaRole=function(i){if(this.hasListeners("intervalSelect")){i._setAriaRole("button");}else{i._setAriaRole("gridcell");}};c1.prototype._updateTodayButtonState=function(){if(this._oTodayButton){this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));}};c1.prototype._dateMatchesVisibleRange=function(i,j){var L1=this._getView(j,!this._bBeforeRendering);if(!L1){return false;}var M1=L1.getIntervalType(),N1=e1[M1],O1=N1?this[N1.sInstanceName]:null,P1=false;if(O1&&O1._dateMatchesVisibleRange){P1=O1._dateMatchesVisibleRange(i);}return P1;};c1.prototype.onAfterRendering=function(i){i.size={width:this.getDomRef().offsetWidth};p1.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=o.register(this,this._resizeProxy);}if(n.system.phone&&this.getStickyHeader()){n.orientation.attachHandler(this._updateStickyHeader,this);}this._updateCurrentTimeVisualization(false);if(this.getHeight()){var j=this.getDomRef().querySelector("table");var L1=this.$().height()-this._oInfoToolbar.$().height()-this._getTableHeaderToolbar().$().height()+"px";j.style.height=L1;}};c1.prototype.addToolbarContent=function(i){this.addAggregation("toolbarContent",i);k1.call(this);return this;};c1.prototype.insertToolbarContent=function(i,j){this.insertAggregation("toolbarContent",i,j);k1.call(this);return this;};c1.prototype.removeToolbarContent=function(i){var j=this.removeAggregation("toolbarContent",i);k1.call(this);return j;};c1.prototype.removeAllToolbarContent=function(){var i=this.removeAllAggregation("toolbarContent");k1.call(this);return i;};c1.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent");k1.call(this);return i;};function k1(){this._getTableHeaderToolbar().setVisible(!!this.getToolbarContent().length);}c1.prototype.setStartDate=function(i){var j,L1,M1;if(!i){M1=new Date();}else{b._checkJSDateObject(i);M1=new Date(i.getTime());}if(this.getViewKey()===V.Week){j=b.getFirstDateOfWeek(b._createUniversalUTCDate(M1,undefined,true));M1.setTime(b._createLocalDate(j,true).getTime());}if(this.getViewKey()===V.OneMonth||this.getViewKey()===V.Month){L1=b.getFirstDateOfMonth(b._createUniversalUTCDate(M1,undefined,true));M1.setTime(b._createLocalDate(L1,true).getTime());}if(H(M1,this.getStartDate())){this._updateTodayButtonState();return this;}var N1=M1.getFullYear();b._checkYearInValidRange(N1);var O1=this.getMinDate();if(O1&&O1.getTime()>M1.getTime()){L.warning("StartDate < minDate -> StartDate set to minDate",this);M1=new Date(O1.getTime());}else{var P1=this.getMaxDate();if(P1&&P1.getTime()<M1.getTime()){L.warning("StartDate > maxDate -> StartDate set to minDate",this);if(O1){M1=new Date(O1.getTime());}else{M1=new Date(1,0,1);M1.setFullYear(1);}}}this.setProperty("startDate",M1,true);d1.forEach(function(Q1){if(this[Q1]){this[Q1].setStartDate(new Date(M1.getTime()));}},this);this._setRowsStartDate(new Date(M1.getTime()));if(this.getViewKey()===V.Week||this.getViewKey()===V.OneMonth){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);}return this;};c1.prototype.setMinDate=function(i){if(H(i,this.getMinDate())){return this;}var j=this.getMaxDate();if(i){b._checkJSDateObject(i);var L1=i.getFullYear();b._checkYearInValidRange(L1);this.setProperty("minDate",i,true);this._bNoStartDateChange=true;d1.forEach(function(O1){if(this[O1]){this[O1].setMinDate(new Date(i.getTime()));}},this);if(j&&j.getTime()<i.getTime()){L.warning("minDate > maxDate -> maxDate set to end of the month",this);j=new Date(i.getTime());j.setMonth(j.getMonth()+1,0);j.setHours(23);j.setMinutes(59);j.setSeconds(59);j.setMilliseconds(0);this.setMaxDate(j);}this._bNoStartDateChange=undefined;var M1=this.getStartDate();if(M1&&M1.getTime()<i.getTime()){L.warning("StartDate < minDate -> StartDate set to minDate",this);M1=new Date(i.getTime());this.setStartDate(M1);}}else{this.setProperty("minDate",undefined,true);d1.forEach(function(O1){if(this[O1]){this[O1].setMinDate();}},this);}var N1=new Date();if(i&&N1.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||N1.getTime()<j.getTime()){this._oTodayButton.setVisible(true);}return this;};c1.prototype.setMaxDate=function(i){if(H(i,this.getMaxDate())){return this;}var j=this.getMinDate();if(i){b._checkJSDateObject(i);var L1=i.getFullYear();b._checkYearInValidRange(L1);this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;d1.forEach(function(O1){if(this[O1]){this[O1].setMaxDate(new Date(i.getTime()));}},this);if(j&&j.getTime()>i.getTime()){L.warning("maxDate < minDate -> maxDate set to begin of the month",this);j=new Date(i.getTime());j.setDate(1);j.setHours(0);j.setMinutes(0);j.setSeconds(0);j.setMilliseconds(0);this.setMinDate(j);}this._bNoStartDateChange=undefined;var M1=this.getStartDate();if(M1&&M1.getTime()>i.getTime()){L.warning("StartDate > maxDate -> StartDate set to minDate",this);if(j){M1=new Date(j.getTime());}else{M1=new Date(1,0,1);M1.setFullYear(1);}this.setStartDate(M1);}}else{this.setProperty("maxDate",undefined,true);d1.forEach(function(O1){if(this[O1]){this[O1].setMaxDate();}},this);}var N1=new Date();if(i&&N1.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||N1.getTime()>j.getTime()){this._oTodayButton.setVisible(true);}return this;};c1.prototype.removeIntervalInstanceFromInfoToolbar=function(){var i=this._oInfoToolbar.getContent();i.forEach(function(j){if(j.isA(i1)){this._oInfoToolbar.removeContent(j);}}.bind(this));};c1.prototype.setViewKey=function(j){var L1,M1,N1,O1=this.getViewKey(),P1;this.setProperty("viewKey",j,true);this._oIntervalTypeSelect.setSelectedKey(j);this.removeIntervalInstanceFromInfoToolbar();if(j===V.Week||j===V.OneMonth||j===V.Month){M1=this.getStartDate();this.setStartDate(new Date(M1.getTime()));if(M1.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}var Q1=this.getStartDate();var R1=this.getMinDate();var S1=this.getMaxDate();var T1=this._getView(j,!this._bBeforeRendering);if(!T1){this._bCheckView=true;this.invalidate();}else{var U1=T1.getIntervalType();var V1=this._getIntervals(T1);this._bCheckView=false;switch(U1){case Z.Hour:if(!this._oTimeInterval){this._oTimeInterval=new m(this.getId()+"-TimeInt",{startDate:new Date(Q1.getTime()),items:V1,pickerPopup:true,legend:this.getLegend()});this._setAriaRole(this._oTimeInterval);this._oTimeInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oTimeInterval.attachEvent("select",this._handleCalendarSelect,this);this._oTimeInterval._oPlanningCalendar=this;this._oTimeInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(R1){this._oTimeInterval.setMinDate(new Date(R1.getTime()));}if(S1){this._oTimeInterval.setMaxDate(new Date(S1.getTime()));}}else if(this._oTimeInterval.getItems()!=V1){this._oTimeInterval.setItems(V1);}this._insertInterval(this._oTimeInterval);break;case Z.Day:case Z.Week:case Z.OneMonth:N1=e1[U1];L1=this[N1.sInstanceName];if(!L1){L1=new N1.oClass(this.getId()+N1.sIdSuffix,{startDate:new Date(Q1.getTime()),days:V1,showDayNamesLine:this.getShowDayNamesLine(),pickerPopup:true,legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers()});this._setAriaRole(L1);L1.attachEvent("startDateChange",this._handleStartDateChange,this);L1.attachEvent("select",this._handleCalendarSelect,this);if(j===V.OneMonth){L1._setRowsStartDate=this._setRowsStartDate.bind(this);}L1._oPlanningCalendar=this;L1.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(R1){L1.setMinDate(new Date(R1.getTime()));}if(S1){L1.setMaxDate(new Date(S1.getTime()));}}else if(L1.getDays()!==V1){L1.setDays(V1);}this._insertInterval(L1);this[N1.sInstanceName]=L1;break;case Z.Month:if(!this._oMonthInterval){this._oMonthInterval=new l(this.getId()+"-MonthInt",{startDate:new Date(Q1.getTime()),months:V1,pickerPopup:true,legend:this.getLegend()});this._setAriaRole(this._oMonthInterval);this._oMonthInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oMonthInterval.attachEvent("select",this._handleCalendarSelect,this);this._oMonthInterval._oPlanningCalendar=this;this._oMonthInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(R1){this._oMonthInterval.setMinDate(new Date(R1.getTime()));}if(S1){this._oMonthInterval.setMaxDate(new Date(S1.getTime()));}}else if(this._oMonthInterval.setMonths()!=V1){this._oMonthInterval.setMonths(V1);}this._insertInterval(this._oMonthInterval);break;default:throw new Error("Unknown IntervalType: "+U1+"; "+this);}var W1=this.getRows();for(var i=0;i<W1.length;i++){var X1=W1[i];var Y1=A1(X1);Y1.setIntervalType(U1);Y1.setIntervals(V1);Y1.setShowSubIntervals(T1.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);n1.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(j));o1.call(this,this.getShowDayNamesLine(),!!L1);}}if(this._oOneMonthInterval&&j===V.OneMonth){this._oOneMonthInterval._setDisplayMode(this._iSize);this._oOneMonthInterval._adjustSelectedDate(c.fromLocalJSDate(M1));if(this._iSize<2){this._setRowsStartDate(M1);}}else if(this._oOneMonthInterval&&O1===V.OneMonth&&this._oOneMonthInterval.getSelectedDates().length){P1=this._oOneMonthInterval.getSelectedDates()[0].getStartDate();if(P1){this.setStartDate(P1);}}this._updateTodayButtonState();return this;};c1.prototype._insertInterval=function(i){if(this._iSizeScreen>1){this._oInfoToolbar.addContent(i);}else{this._oInfoToolbar.insertContent(i,1);}};c1.prototype._viewAllowsWeekNumbers=function(i){var j=this._getView(i).getIntervalType(),L1=e1[j];return!!L1&&!!L1.oClass.prototype.setShowWeekNumbers;};c1.prototype._viewAllowsDayNamesLine=function(i){var j=this._getView(i).getIntervalType(),L1=e1[j];return!!L1&&!!L1.oClass.prototype.setShowDayNamesLine;};c1.prototype._getIntervalInstanceByViewKey=function(i){var j=this._getView(i).getIntervalType(),L1=e1[j],M1;if(L1){M1=this[L1.sInstanceName];}return M1;};c1.prototype.setShowWeekNumbers=function(i){this.setProperty("showWeekNumbers",i,true);this._getViews().forEach(function(j){var L1=j.getKey(),M1=this._viewAllowsWeekNumbers(L1),N1=this._getIntervalInstanceByViewKey(L1);if(N1&&M1){this._getIntervalInstanceByViewKey(L1).setShowWeekNumbers(i);}if(this.getDomRef()&&this.getViewKey()===L1){n1.call(this,i,M1);}},this);return this;};c1.prototype.setShowIntervalHeaders=function(j){this.setProperty("showIntervalHeaders",j,true);var L1=this.getRows();for(var i=0;i<L1.length;i++){var M1=L1[i];A1(M1).setShowIntervalHeaders(j);}return this;};c1.prototype.setShowEmptyIntervalHeaders=function(j){this.setProperty("showEmptyIntervalHeaders",j,true);var L1=this.getRows();for(var i=0;i<L1.length;i++){var M1=L1[i];A1(M1).setShowEmptyIntervalHeaders(j);}return this;};c1.prototype.setGroupAppointmentsMode=function(j){this.setProperty("groupAppointmentsMode",j,true);var L1=this.getRows();for(var i=0;i<L1.length;i++){var M1=L1[i];A1(M1).setGroupAppointmentsMode(j);}return this;};c1.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var L1=this.getRows();for(var i=0;i<L1.length;i++){var M1=L1[i];A1(M1).setAppointmentsReducedHeight(j);}return this;};c1.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var L1=this.getRows();for(var i=0;i<L1.length;i++){var M1=L1[i];A1(M1).setAppointmentsVisualization(j);}return this;};c1.prototype.setShowRowHeaders=function(i){this.setProperty("showRowHeaders",i,true);var j=this.getAggregation("table");j.getColumns()[0].setVisible(i);this._toggleAppointmentsColumnPopinState(i);this.$().toggleClass("sapMPlanCalNoHead",!i);I1.call(this);J1.call(this);return this;};c1.prototype.setShowDayNamesLine=function(i){var j,L1,M1,N1=!!this.getDomRef(),O1=this.getViewKey();for(j in e1){L1=e1[j].sInstanceName;if(this[L1]){M1=this[L1];M1.setShowDayNamesLine(i);if(N1&&j===O1){o1.call(this,i,true);}}}return this.setProperty("showDayNamesLine",i,false);};c1.prototype.setStickyHeader=function(i){if(this.getStickyHeader()===i){return this;}this.setProperty("stickyHeader",i,true);if(n.system.phone){if(i){n.orientation.attachHandler(this._updateStickyHeader,this);}else{n.orientation.detachHandler(this._updateStickyHeader,this);}}this._updateStickyHeader();return this;};c1.prototype._updateStickyHeader=function(){var i=[],j=this.getStickyHeader(),L1=this.getViewKey()===V.OneMonth&&this._iSize<2,M1=j&&!n.system.phone&&!L1,N1=j&&!(n.system.phone&&n.orientation.landscape)&&!L1;if(M1){i.push(sap.m.Sticky.HeaderToolbar);}if(this._oInfoToolbar&&N1){i.push(sap.m.Sticky.InfoToolbar);}this.getAggregation("table").setSticky(i);};c1.prototype.addRow=function(i){this.addAggregation("rows",i,true);this.getAggregation("table").addItem(this._createPlanningCalendarListItem(i));return this;};c1.prototype.insertRow=function(i,j){this.insertAggregation("rows",i,j);this.getAggregation("table").insertItem(this._createPlanningCalendarListItem(i),j,true);return this;};c1.prototype.removeRow=function(i){var j=this.removeAggregation("rows",i,true),L1=this.getAggregation("table");L1.removeItem(y1(j),true);this._handleRowRemoval(j);H1.call(this);J1.call(this);return j;};c1.prototype.removeAllRows=function(){var i=this.removeAllAggregation("rows",true),j=this.getAggregation("table");j.removeAllItems(true);i.forEach(this._handleRowRemoval,this);H1.call(this);J1.call(this);return i;};c1.prototype.destroyRows=function(){var i;var j=this.getAggregation("table");j.destroyItems(true);i=this.destroyAggregation("rows");H1.call(this);J1.call(this);return i;};c1.prototype.setSingleSelection=function(i){this.setProperty("singleSelection",i,true);I1.call(this);J1.call(this);if(i){this.selectAllRows(false);}else{H1.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!i);return this;};c1.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);var j=this.getAggregation("table");j.setNoDataText(i);return this;};c1.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var L1=this.getRows(),M1=this.getLegend()&&sap.ui.getCore().byId(this.getLegend()),N1;for(var i=0;i<L1.length;i++){var O1=L1[i];A1(O1).setLegend(j);}d1.forEach(function(P1){if(this[P1]){this[P1].setLegend(j);}},this);if(M1){N1=new a(function(P1){this.invalidate();}.bind(this));N1.observe(M1,{destroy:true});}return this;};c1.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.addAriaLabelledBy(i);return this;};c1.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.removeAriaLabelledBy(i);return this;};c1.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var i=this.getAggregation("table");i.removeAllAriaLabelledBy();i.addAriaLabelledBy(this.getId()+"-Descr");return this;};c1.prototype.invalidate=function(i){var j=i&&i instanceof D;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||j)){if(this.getDomRef()){var L1=this.getViewKey();var M1=this._getView(L1);var N1=M1.getIntervalType();switch(N1){case Z.Hour:if(this._oTimeInterval){this._oTimeInterval.invalidate(arguments);}break;case Z.Day:if(this._oDateInterval){this._oDateInterval.invalidate(arguments);}break;case Z.Month:if(this._oMonthInterval){this._oMonthInterval.invalidate(arguments);}break;case Z.OneMonth:if(this._oOneMonthInterval){this._oOneMonthInterval.invalidate(arguments);}break;case Z.Week:if(this._oWeekInterval){this._oWeekInterval.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+N1+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(i&&i instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};c1.prototype.addSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.addAggregation.call(this,"specialDates",i);};c1.prototype.insertSpecialDate=function(i,j){this._bDateRangeChanged=true;return C.prototype.insertAggregation.call(this,"specialDates",i,j);};c1.prototype.removeSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.removeAggregation.call(this,"specialDates",i);};c1.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;return this.removeAllAggregation("specialDates");};c1.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;return this.destroyAggregation("specialDates");};c1.prototype.removeAllViews=function(){this._bCheckView=true;var i=this.removeAllAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(g1[0]);}return i;};c1.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(g1[0]);}return i;};c1.prototype.getSelectedRows=function(){return this.getRows().filter(function(i){return i.getSelected();});};c1.prototype.selectAllRows=function(j){var L1=this.getRows();if(!(j&&this.getSingleSelection())){for(var i=0;i<L1.length;i++){var M1=L1[i];M1.setSelected(j);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(j);}}return this;};c1.prototype.onsaphomemodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var L1=j[0];var M1=new Q.Event("saphome");M1._bPlanningCalendar=true;A1(L1).onsaphome(M1);i.preventDefault();i.stopPropagation();}};c1.prototype.onsapendmodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var L1=j[j.length-1];var M1=new Q.Event("sapend");M1._bPlanningCalendar=true;A1(L1).onsapend(M1);i.preventDefault();i.stopPropagation();}};c1.prototype.setBuiltInViews=function(i){this.setProperty("builtInViews",i);this.setViewKey(this._getViews()[0].getKey());return this;};c1.prototype.removeView=function(i){var j=this.removeAggregation("views",i);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey());}return j;};c1.prototype._getIntervals=function(i){var j=0;switch(this._iSize){case 0:j=i.getIntervalsS();break;case 1:j=i.getIntervalsM();break;default:j=i.getIntervalsL();break;}return j;};c1.prototype._getView=function(j,L1){var M1=this._getViews();var N1;for(var i=0;i<M1.length;i++){N1=M1[i];if(N1.getKey()!=j){N1=undefined;}else{break;}}if(!N1&&!L1){throw new Error("PlanningCalendarView with key "+j+"not assigned "+this);}return N1;};c1.prototype._changeStartDate=function(i){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(i.getTime()));this.fireStartDateChange();};c1.prototype._updateCurrentTimeVisualization=function(j){if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(j){var L1=this.getRows();for(var i=0;i<L1.length;i++){var M1=L1[i];A1(M1).updateCurrentTimeVisualization();}}var N1=new Date();var O1=this.getStartDate();var P1=this.getViewKey();var Q1=this._getView(P1);var R1=Q1.getIntervalType();var S1=this._getIntervals(Q1);var T1=0;var U1=0;var V1=0;switch(R1){case Z.Hour:T1=60000;U1=O1.getTime()-3600000;V1=O1.getTime()+S1*3600000;break;case Z.Day:case Z.Week:case Z.OneMonth:T1=1800000;U1=O1.getTime()-3600000;V1=O1.getTime()+S1*86400000;break;default:T1=-1;break;}if(N1.getTime()<=V1&&N1.getTime()>=U1&&T1>0){this._sUpdateCurrentTime=setTimeout(this['_updateCurrentTimeVisualization'].bind(this,true),T1);}};function l1(i){this.setViewKey(i.getParameter("selectedItem").getKey());this.fireViewChange();}c1.prototype._handleTodayPress=function(i){var j=new Date(),L1,M1=this.getViewKey();if(M1===V.OneMonth){L1=b.getFirstDateOfMonth(b._createUniversalUTCDate(j,undefined,true));this._oOneMonthInterval._adjustSelectedDate(c.fromLocalJSDate(j),false);j=b._createLocalDate(L1,true);}if(M1===V.Week){L1=this.getStartDate();j.setHours(L1.getHours());j.setMinutes(L1.getMinutes());j.setSeconds(L1.getSeconds());}this.setStartDate(j);this.fireStartDateChange();};c1.prototype._handleStartDateChange=function(i){var j=i.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()!==Z.Hour){var L1=this.getStartDate();j.setHours(L1.getHours());j.setMinutes(L1.getMinutes());j.setSeconds(L1.getSeconds());}this._changeStartDate(j);};c1.prototype._handleCalendarSelect=function(i){var j=i.oSource.getSelectedDates();if(!j.length){return;}var L1=new Date(j[0].getStartDate());var M1=b._createUniversalUTCDate(L1,undefined,true);var N1=this.getViewKey();var O1=this._getView(N1);var P1=O1.getIntervalType();if(P1!==Z.OneMonth||this._iSize>1){j[0].setStartDate();}switch(P1){case Z.Hour:M1.setUTCHours(M1.getUTCHours()+1);break;case Z.Day:case Z.Week:M1.setUTCDate(M1.getUTCDate()+1);break;case Z.OneMonth:if(this._iSize<2){var Q1=new Date(L1.getTime());if(b.monthsDiffer(this.getStartDate(),L1)){this.setStartDate(L1);}this._setRowsStartDate(Q1);this._oOneMonthInterval.getAggregation('month')[0]._focusDate(c.fromLocalJSDate(Q1),true);}else if(b._isNextMonth(L1,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}M1.setUTCDate(M1.getUTCDate()+1);break;case Z.Month:M1.setUTCMonth(M1.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+P1+"; "+this);}M1.setUTCMilliseconds(M1.getUTCMilliseconds()-1);M1=b._createLocalDate(M1,true);this.fireIntervalSelect({startDate:L1,endDate:M1,subInterval:false,row:undefined});};function m1(i){var j=i.getParameter("startDate");var L1=this.getViewKey();var M1=this._getView(L1);var N1=M1.getIntervalType();if(N1===Z.OneMonth&&b._isNextMonth(j,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}var O1=i.getParameter("endDate");var P1=i.getParameter("subInterval");var Q1=x1(i.oSource.getParent());this.fireIntervalSelect({startDate:j,endDate:O1,subInterval:P1,row:Q1});}c1.prototype._applyContextualSettings=function(i){return C.prototype._applyContextualSettings.call(this,i||M._defaultContextualSettings);};c1.prototype._getTableHeaderToolbar=function(){return this.getAggregation("table").getHeaderToolbar();};function n1(i,j){this.$().toggleClass("sapMPlanCalWithWeekNumbers",i&&j);}function o1(i,j){this.$().toggleClass("sapMPlanCalWithDayNamesLine",i&&j);}function p1(j,L1){if(j.size.width<=0){return;}if(Math.abs(this.iWidth-j.size.width)<15){return;}this.iWidth=j.size.width;this._applyContextualSettings({contextualWidth:this.iWidth});var M1=this.getRows();var N1;var i=0;var O1=this._iSize;C1.call(this,j.size.width);if(O1!=this._iSize){D1.call(this,this._iSize);var P1=this.getViewKey();var Q1=this._getView(P1);var R1=Q1.getIntervalType();var S1=this._getIntervals(Q1);for(i=0;i<M1.length;i++){N1=M1[i];var T1=A1(N1);if(S1!=T1.getIntervals()){T1.setIntervals(S1);}else{T1.handleResize();}}switch(R1){case Z.Hour:if(this._oTimeInterval&&this._oTimeInterval.getItems()!=S1){this._oTimeInterval.setItems(S1);}break;case Z.Day:if(this._oDateInterval&&this._oDateInterval.getDays()!=S1){this._oDateInterval.setDays(S1);}break;case Z.Month:if(this._oMonthInterval&&this._oMonthInterval.getMonths()!=S1){this._oMonthInterval.setMonths(S1);}break;case Z.Week:if(this._oWeekInterval&&this._oWeekInterval.getDays()!=S1){this._oWeekInterval.setDays(S1);}break;case Z.OneMonth:if(this._oOneMonthInterval&&this._oOneMonthInterval.getDays()!=S1){this._oOneMonthInterval.setDays(S1);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+R1+"; "+this);}I1.call(this);}else if(!L1){for(i=0;i<M1.length;i++){N1=M1[i];A1(N1).handleResize();}}if(this._oOneMonthInterval){this._oOneMonthInterval._setDisplayMode(this._iSize);}if(this.getStickyHeader()){this._updateStickyHeader();}}function q1(L1){var M1=L1.getParameter("appointment"),N1=L1.getParameter("multiSelect"),O1=L1.getParameter("appointments"),P1=L1.getParameter("domRefId"),Q1,R1,S1,T1,U1,i,j;if(!N1){R1=this.getRows();for(i=0;i<R1.length;i++){S1=R1[i];if(L1.oSource!=A1(S1)){T1=S1.getAppointments();for(j=0;j<T1.length;j++){U1=T1[j];U1.setSelected(false);}}}}Q1={appointment:M1,appointments:O1,multiSelect:N1,domRefId:P1};this.fireAppointmentSelect(Q1);}c1.prototype._setRowsStartDate=function(j){var L1=this.getRows(),M1,i;for(i=0;i<L1.length;i++){M1=L1[i];A1(M1).setStartDate(j);}};c1.prototype._toggleAppointmentsColumnPopinState=function(i){var j=this.getAggregation("table"),L1=j.getColumns()[1];L1.setDemandPopin(i);L1.setMinScreenWidth(i?f1:"");};c1.prototype._getViews=function(){var i=this.getViews(),j=this.getBuiltInViews(),L1,M1=[],N1=V,O1=Z;if(!this._oViews){this._oViews={};}if(j.length){M1=j;}else{M1=i.length?[]:g1;}L1=M1.map(function(Q1){switch(Q1){case N1.Hour:return this._oViews[N1.Hour]||(this._oViews[N1.Hour]=new A(this.getId()+"-HourView",{key:N1.Hour,intervalType:O1.Hour,description:this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12}));case N1.Day:return this._oViews[N1.Day]||(this._oViews[N1.Day]=new A(this.getId()+"-DayView",{key:N1.Day,intervalType:O1.Day,description:this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14}));case N1.Month:return this._oViews[N1.Month]||(this._oViews[N1.Month]=new A(this.getId()+"-MonthView",{key:N1.Month,intervalType:O1.Month,description:this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12}));case N1.Week:return this._oViews[N1.Week]||(this._oViews[N1.Week]=new A(this.getId()+"-WeekView",{key:N1.Week,intervalType:O1.Week,description:this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7}));case N1.OneMonth:return this._oViews[N1.OneMonth]||(this._oViews[N1.OneMonth]=new A(this.getId()+"-OneMonthView",{key:N1.OneMonth,intervalType:O1.OneMonth,description:this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31}));default:L.error("Cannot get PlanningCalendar views. Invalid view key "+Q1);break;}},this);for(var P1 in this._oViews){if(M1.indexOf(P1)<0){this._oViews[P1].destroy();delete this._oViews[P1];}}if(i.length){L1=L1.concat(i);}return L1;};c1.prototype.getSelectedAppointments=function(){var i=[];this.getRows().filter(function(j){i.push.apply(i,A1(j).aSelectedAppointments);});return i;};c1.prototype.setCustomAppointmentsSorterCallback=function(i){if(typeof i==="function"||i===null||i===undefined){this.getRows().forEach(function(j){A1(j)._setCustomAppointmentsSorterCallback(i);});this._fnCustomSortedAppointments=i;}else{L.warning("Your custom sort function won't be used, but the old one will be preserved.",this);}return this;};c1.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments;};c1.prototype._onRowDeselectAppointment=function(){var L1=this.getRows();for(var i=0;i<L1.length;i++){var M1=A1(L1[i]).aSelectedAppointments;for(var j=0;j<M1.length;j++){var N1=sap.ui.getCore().byId(M1[j]);if(N1){N1.setProperty("selected",false,true);N1.$().removeClass("sapUiCalendarAppSel");}}A1(L1[i]).aSelectedAppointments=[];}};c1.prototype._updateRowTimeline=function(i){var j=A1(i),L1,M1,N1,O1,P1=this.getViewKey()===V.OneMonth&&this._iSize<2,Q1=this.getStartDate();j.setNonWorkingDays(i.getNonWorkingDays());j.setNonWorkingHours(i.getNonWorkingHours());if(P1&&this._oOneMonthInterval&&this._oOneMonthInterval.getSelectedDates().length){Q1=this._oOneMonthInterval.getSelectedDates()[0].getStartDate();}j.setStartDate(Q1);j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setGroupAppointmentsMode(this.getGroupAppointmentsMode());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.setLegend(this.getLegend());j.setAppointmentsVisualization(this.getAppointmentsVisualization());j.attachEvent("select",q1,this);j.attachEvent("startDateChange",this._handleStartDateChange,this);j.attachEvent("leaveRow",G1,this);j.attachEvent("intervalSelect",m1,this);H1.call(this);if(K1.call(this)){L1=this.getViewKey();M1=this._getView(L1);N1=M1.getIntervalType();O1=this._getIntervals(M1);j.setIntervalType(N1);j.setIntervals(O1);j.setShowSubIntervals(M1.getShowSubIntervals());}J1.call(this);if(this._fnCustomSortedAppointments){j._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments);}};c1.prototype._observeRowChanges=function(i){var j=y1(i),L1=z1(i),M1=A1(i);var N1={destroy:function(){j.destroy();},change:{title:function(O1){L1.setProperty(O1.name,O1.current);},icon:function(O1){L1.setProperty(O1.name,O1.current);},text:function(O1){M1.toggleStyleClass("sapMPlanCalRowLarge",!!O1.current);L1.setProperty("description",O1.current);},enableAppointmentsDragAndDrop:function(O1){this._enableAppointmentsDragAndDrop(i);}.bind(this),enableAppointmentsResize:function(O1){this._enableAppointmentsResize(i);}.bind(this),enableAppointmentsCreate:function(O1){this._enableAppointmentsCreate(i);}.bind(this),nonWorkingDays:function(O1){M1.setProperty(O1.name,O1.current);},nonWorkingHours:function(O1){M1.setProperty(O1.name,O1.current);},selected:function(O1){H1.call(this);j.setProperty(O1.name,O1.current);}.bind(this),tooltip:function(O1){if(O1.mutation==="insert"){L1.setTooltip(O1.child);}else if(O1.mutation==="remove"){L1.setTooltip();}},intervalHeaders:function(O1){M1.invalidate();},appointments:function(O1){M1.invalidate();}}};new a(function(O1){if(O1.type==="destroy"){N1.destroy();}else if(N1.change[O1.name]){N1.change[O1.name](O1);}}).observe(i,{properties:["icon","text","title","nonWorkingDays","nonWorkingHours","selected","enableAppointmentsDragAndDrop","enableAppointmentsResize","enableAppointmentsCreate"],aggregations:["tooltip","appointments","intervalHeaders","headerContent"],destroy:true});i.invalidate=function(O1){if(!O1||!(O1 instanceof d)){E.prototype.invalidate.apply(this,arguments);}else if(j){M1.invalidate(O1);}};i.applyFocusInfo=function(O1){M1.applyFocusInfo(O1);return this;};};c1.prototype._createPlanningCalendarListItem=function(i){var j,L1,M1;if(i.getHeaderContent().length||i.getBindingInfo("headerContent")){L1=i._getPlanningCalendarCustomRowHeader();}else{L1=new r1(i.getId()+"-Head",{icon:i.getIcon(),description:i.getText(),title:i.getTitle(),tooltip:i.getTooltip()});}M1=new t1(i.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false,ariaLabelledBy:L1.getId()});M1.getAppointments=function(){return i.getAppointments();};M1.getIntervalHeaders=function(){return i.getIntervalHeaders();};j=new v1(i.getId()+b1,{cells:[L1,M1]});this._updateRowTimeline(i);this._observeRowChanges(i);this._enableAppointmentsDragAndDrop(i);this._enableAppointmentsResize(i);this._enableAppointmentsCreate(i);return j;};c1.prototype._handleRowRemoval=function(i){var j=A1(i);j.detachEvent("select",q1,this);j.detachEvent("startDateChange",this._handleStartDateChange,this);j.detachEvent("leaveRow",G1,this);j.detachEvent("intervalSelect",m1,this);if(this._fnCustomSortedAppointments){j._fnCustomSortedAppointments=undefined;}y1(i).destroy();};var r1=x.extend("PlanningCalendarRowHeader",{renderer:R.extend(y)});PlanningCalendarRowHeaderRenderer.openItemTag=function(i,j){i.write("<div");};PlanningCalendarRowHeaderRenderer.closeItemTag=function(i,j){i.write("</div>");};PlanningCalendarRowHeaderRenderer.renderTabIndex=function(i,j){};PlanningCalendarRowHeaderRenderer.getAriaRole=function(i,j){};var s1=R.extend(f);s1.getLegendItems=function(i){var j=[],L1,M1=i.getLegend();if(M1){L1=sap.ui.getCore().byId(M1);if(L1){j=L1.getAppointmentItems?L1.getAppointmentItems():L1.getItems();}else{L.error("PlanningCalendarLegend with id '"+M1+"' does not exist!",i);}}return j;};s1.renderBeforeAppointments=function(j,L1){var M1=x1(L1.getParent()),N1;if(!M1.getEnableAppointmentsDragAndDrop()&&!M1.getEnableAppointmentsResize()&&!M1.getEnableAppointmentsCreate()||L1._isOneMonthIntervalOnSmallSizes()){return;}N1=L1.getAggregation("_intervalPlaceholders");j.write("<div class=\"sapUiCalendarRowAppsOverlay\">");if(N1){for(var i=0;i<N1.length;i++){var O1=N1[i];O1.setWidth(100/N1.length+"%");j.renderControl(O1);}}j.write("</div>");};s1.renderResizeHandle=function(i,j,L1){if(!x1(j.getParent()).getEnableAppointmentsResize()||j._isOneMonthIntervalOnSmallSizes()||(L1._aAppointments&&L1._aAppointments.length>0)){return;}i.write("<span");i.addClass("sapUiCalendarAppResizeHandle");i.writeClasses();i.write(">");i.write("</span>");};s1.writeCustomAttributes=function(i,j){if(x1(j.getParent()).getEnableAppointmentsCreate()){i.writeAttribute("draggable","true");}};s1.renderInterval=function(j,L1,M1,N1,O1,P1,Q1,R1,S1,T1,U1,V1,W1){var X1=L1.getIntervalType();if(X1===Z.Day||X1===Z.Week||X1===Z.OneMonth){var Y1=x1(L1.getParent()),Z1=Y1.getParent(),$1=function(i2){return i2.getType()===J.NonWorking;},_1=Y1.getSpecialDates().filter($1),a2=Z1.getSpecialDates().filter($1),b2=L1.getStartDate(),c2,d2,e2,f2;if(a2&&_1){c2=a2.concat(_1);}else if(_1){c2=_1;}if(c2&&c2.length){var g2=function(i2){return i2===d2.getDay();};d2=new Date(b2.getTime());d2.setHours(0,0,0);d2.setDate(b2.getDate()+M1);for(var i=0;i<c2.length;i++){if(c2[i].getStartDate()){e2=new Date(c2[i].getStartDate().getTime());}if(c2[i].getEndDate()){f2=new Date(c2[i].getEndDate().getTime());}else{f2=new Date(c2[i].getStartDate().getTime());f2.setHours(23,59,59);}if(d2.getTime()>=e2.getTime()&&d2.getTime()<=f2.getTime()){var h2=P1.some(g2);if(!h2){j.addClass("sapUiCalendarRowAppsNoWork");}}}}}f.renderInterval(j,L1,M1,N1,O1,P1,Q1,R1,S1,T1,U1,V1,W1);};var t1=e.extend("PlanningCalendarRowTimeline",{metadata:{aggregations:{intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true},_intervalPlaceholders:{type:"IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},dnd:true},renderer:s1});t1.prototype._updatePlaceholders=function(){var j=this.getProperty("intervals");if(this.getIntervalType()===Z.Hour){j*=2;}this.removeAllAggregation("_intervalPlaceholders");for(var i=0;i<j;i++){this.addAggregation("_intervalPlaceholders",new u1());}};t1.prototype.onBeforeRendering=function(){e.prototype.onBeforeRendering.call(this);this._updatePlaceholders();};t1.prototype.onmousedown=function(i){var j=i.target.classList;this._isResizeHandleMouseDownTarget=j.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=j.contains("sapUiCalendarRowAppsInt");};t1.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget;};t1.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget;};t1.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget;};var u1=C.extend("IntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addStyle("width",j.getWidth());i.writeStyles();i.addClass("sapUiCalendarRowAppsPlaceholder");i.writeClasses();i.write("></div>");}});var v1=v.extend("sap.m.internal.PlanningCalendarRowListItem",{metadata:{library:"sap.m"},renderer:w});v1.prototype.getHeader=function(){return this.getCells()[0];};v1.prototype.getTimeline=function(){return this.getCells()[1];};v1.prototype.getCustomData=function(){return x1(this).getCustomData();};c1.prototype._getSelectedDates=function(){var i=this.getViewKey(),j=this._getView(i),L1=j.getIntervalType(),M1=e1[L1];return this[M1.sInstanceName].getSelectedDates();};c1.prototype._enableAppointmentsDragAndDrop=function(i){var j=A1(i),L1;if(i.getEnableAppointmentsDragAndDrop()){L1=i.getDragDropConfig().some(function(M1){return M1.getGroupName()===$;});if(!L1){this._addDragDropInfo(i,A1(i));}}else{i.getDragDropConfig().forEach(function(M1){if(M1.getGroupName()===$){i.removeDragDropConfig(M1);}});j.getDragDropConfig().forEach(function(M1){if(M1.getGroupName()===$){j.removeDragDropConfig(M1);}});}};c1.prototype._enableAppointmentsResize=function(i){var j=i.getEnableAppointmentsResize(),L1=this._getConfigFromDragDropConfigAggregation(i.getAggregation("dragDropConfig"),_),M1=this._getResizeConfig(i);if(j&&!L1){i.addAggregation("dragDropConfig",M1,true);}if(!j){i.removeAggregation("dragDropConfig",L1,true);}};c1.prototype._enableAppointmentsCreate=function(i){var j=i.getEnableAppointmentsCreate(),L1=A1(i),M1=this._getConfigFromDragDropConfigAggregation(L1.getAggregation("dragDropConfig"),a1),N1=this._getAppointmentsCreateConfig(i);if(j&&!M1){L1.addAggregation("dragDropConfig",N1,true);}if(!j){L1.removeAggregation("dragDropConfig",M1,true);}};c1.prototype._addDragDropInfo=function(i,j){i.addDragDropConfig(new p({groupName:$,sourceAggregation:"appointments",dragStart:function(L1){var M1=function(){var N1=Q(".sapUiCalendarRowAppsOverlay");setTimeout(function(){N1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){N1.removeClass("sapUiCalendarRowAppsOverlayDragging");});};if(j._isOneMonthIntervalOnSmallSizes()||!j._isDraggingPerformed()){L1.preventDefault();return;}M1();}}));j.addDragDropConfig(new q({groupName:$,targetAggregation:"_intervalPlaceholders",dragEnter:function(L1){var M1=L1.getParameter("dragSession"),N1=M1.getDragControl(),O1=j.getIntervalType(),P1=j.getStartDate(),Q1=j.indexOfAggregation("_intervalPlaceholders",M1.getDropControl()),R1=j.getId(),S1,T1=function(){var V1=Q(M1.getIndicator()),W1=M1.getDropControl().getDomRef().getBoundingClientRect(),X1=sap.ui.getCore().byId(R1).getDomRef().getBoundingClientRect(),Y1=M1.getDragControl().$().outerWidth(),Z1=sap.ui.getCore().getConfiguration().getRTL(),$1=Z1?Math.ceil(W1.right)-X1.left:X1.right-Math.ceil(W1.left);V1.css("min-width",(Y1<$1)?Y1:$1).css(Z1?"border-left-width":"border-right-width",(Y1>$1)?"0":"").css("margin-left",Z1?-(V1.outerWidth()-parseFloat(V1.context.style.width)):"");};if(i.hasListeners("appointmentDragEnter")){if(O1===Z.Hour){S1=this._calcNewHoursAppPos(P1,N1.getStartDate(),N1.getEndDate(),Q1);}else if(O1===Z.Day||O1===Z.Week||(O1===Z.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){S1=this._calcNewDaysAppPos(P1,N1.getStartDate(),N1.getEndDate(),Q1);}else if(O1===Z.Month){S1=this._calcNewMonthsAppPos(P1,N1.getStartDate(),N1.getEndDate(),Q1);}var U1=i.fireAppointmentDragEnter({appointment:N1,startDate:S1.startDate,endDate:S1.endDate,calendarRow:x1(j.getParent())});if(!U1){L1.preventDefault();return;}}else if(A1(N1.getParent())!==j){L1.preventDefault();return;}if(j.getIntervalType()!==Z.Hour){return;}if(!M1.getIndicator()){setTimeout(T1,0);}else{T1();}}.bind(this),drop:function(L1){var M1=L1.getParameter("dragSession"),N1=M1.getDragControl(),O1=j.getIntervalType(),P1=j.getStartDate(),Q1=j.indexOfAggregation("_intervalPlaceholders",M1.getDropControl()),R1,S1=L1.getParameter("browserEvent"),T1=(S1.metaKey||S1.ctrlKey);if(O1===Z.Hour){R1=this._calcNewHoursAppPos(P1,N1.getStartDate(),N1.getEndDate(),Q1);}else if(O1===Z.Day||O1===Z.Week||(O1===Z.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){R1=this._calcNewDaysAppPos(P1,N1.getStartDate(),N1.getEndDate(),Q1);}else if(O1===Z.Month){R1=this._calcNewMonthsAppPos(P1,N1.getStartDate(),N1.getEndDate(),Q1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(N1.getStartDate().getTime()===R1.startDate.getTime()&&N1.getParent()===x1(j.getParent())){return;}i.fireAppointmentDrop({appointment:N1,startDate:R1.startDate,endDate:R1.endDate,calendarRow:x1(j.getParent()),copy:T1});}.bind(this)}));};c1.prototype._calcNewHoursAppPos=function(i,j,L1,M1){var N1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours());N1=new Date(N1.getTime()+(M1*30*60*1000));return{startDate:N1,endDate:new Date(N1.getTime()+L1.getTime()-j.getTime())};};c1.prototype._calcNewDaysAppPos=function(i,j,L1,M1){var N1=new Date(i);N1.setDate(N1.getDate()+M1);N1=new Date(N1.getFullYear(),N1.getMonth(),N1.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:N1,endDate:new Date(N1.getTime()+L1.getTime()-j.getTime())};};c1.prototype._calcNewMonthsAppPos=function(i,j,L1,M1){var N1=new Date(i);N1.setMonth(N1.getMonth()+M1);N1=new Date(N1.getFullYear(),N1.getMonth(),j.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:N1,endDate:new Date(N1.getTime()+L1.getTime()-j.getTime())};};c1.prototype._getResizeConfig=function(i){var j=A1(i),L1=new r({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:A1(i),dragStart:function(M1){if(!i.getEnableAppointmentsResize()||j._isOneMonthIntervalOnSmallSizes()||!j._isResizingPerformed()){M1.preventDefault();return;}var N1=M1.getParameter("dragSession"),O1=j.$().find(".sapUiCalendarRowAppsOverlay"),P1=Q(N1.getIndicator()),Q1=N1.getDragControl().$();P1.addClass("sapUiDnDIndicatorHide");setTimeout(function(){O1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){O1.removeClass("sapUiCalendarRowAppsOverlayDragging");P1.removeClass("sapUiDnDIndicatorHide");Q1.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});});if(!n.browser.msie&&!n.browser.edge){M1.getParameter("browserEvent").dataTransfer.setDragImage(w1(),0,0);}},dragEnter:function(M1){var N1=M1.getParameter("dragSession"),O1=this.getTargetElement(),P1=function(){var T1=Q(N1.getIndicator());T1.addClass("sapUiDnDIndicatorHide");},Q1=N1.getDropControl().getDomRef().getBoundingClientRect(),R1=sap.ui.getCore().byId(O1).getDomRef().getBoundingClientRect(),S1={width:Q1.left+Q1.width-(N1.getDragControl().$().position().left+R1.left),"min-width":Math.min(N1.getDragControl().$().outerWidth(),N1.getDropControl().$().outerWidth()),"z-index":1,opacity:0.8};N1.getDragControl().$().css(S1);if(!N1.getIndicator()){setTimeout(P1,0);}else{P1();}},drop:function(M1){var j=A1(i),N1=M1.getParameter("dragSession"),O1=N1.getDragControl(),P1=j.getIntervalType(),Q1=j.getStartDate(),R1=j.indexOfAggregation("_intervalPlaceholders",N1.getDropControl()),S1;if(P1===Z.Hour){S1=this._calcResizeNewHoursAppPos(Q1,O1.getStartDate(),O1.getEndDate(),R1);}else if(P1===Z.Day||P1===Z.Week||(P1===Z.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){S1=this._calcResizeNewDaysAppPos(Q1,O1.getStartDate(),O1.getEndDate(),R1);}else if(P1===Z.Month){S1=this._calcResizeNewMonthsAppPos(Q1,O1.getStartDate(),O1.getEndDate(),R1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");Q(N1.getIndicator()).removeClass("sapUiDnDIndicatorHide");O1.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(O1.getEndDate().getTime()===S1.endDate.getTime()){return;}i.fireAppointmentResize({appointment:O1,startDate:S1.startDate,endDate:S1.endDate,calendarRow:i});}.bind(this)});L1.setProperty("groupName",_);return L1;};c1.prototype._calcResizeNewHoursAppPos=function(i,j,L1,M1){var N1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours()),O1=30*60*1000;N1=new Date(N1.getTime()+((M1+1)*O1));if(N1.getTime()<=j.getTime()){N1=new Date(j.getTime()+O1);}return{startDate:j,endDate:N1};};c1.prototype._calcResizeNewDaysAppPos=function(i,j,L1,M1){var N1=new Date(i),O1=N1.getDate()+M1+1;if(O1<=j.getDate()){O1=j.getDate()+1;}N1.setDate(O1);N1=new Date(N1.getFullYear(),N1.getMonth(),N1.getDate());return{startDate:j,endDate:N1};};c1.prototype._calcResizeNewMonthsAppPos=function(i,j,L1,M1){var N1=new Date(i),O1=N1.getMonth()+M1+1;if(O1<=j.getMonth()){O1=j.getMonth()+1;}N1.setMonth(O1);N1=new Date(N1.getFullYear(),N1.getMonth(),1);return{startDate:j,endDate:N1};};c1.prototype._calcCreateNewAppHours=function(i,j,L1){var M1=30*60*1000,N1,O1;if(j<=L1){N1=new Date(i.getTime()+(j*M1));O1=new Date(i.getTime()+((L1+1)*M1));}else{N1=new Date(i.getTime()+(L1*M1));O1=new Date(i.getTime()+(j*M1));}return{startDate:N1,endDate:O1};};c1.prototype._calcCreateNewAppDays=function(i,j,L1){var M1=new Date(i),N1=new Date(i);if(j<=L1){M1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);N1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+L1+1);}else{M1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+L1);N1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);}return{startDate:M1,endDate:N1};};c1.prototype._calcCreateNewAppMonths=function(i,j,L1){var M1=new Date(i),N1=new Date(i);if(j<=L1){M1=new Date(i.getFullYear(),i.getMonth()+j,1);N1=new Date(i.getFullYear(),i.getMonth()+L1+1,1);}else{M1=new Date(i.getFullYear(),i.getMonth()+L1,1);N1=new Date(i.getFullYear(),i.getMonth()+j,1);}return{startDate:M1,endDate:N1};};c1.prototype._getConfigFromDragDropConfigAggregation=function(j,L1){var M1=j,N1=M1&&M1.length;for(var i=0;i<N1;i++){if(M1[i].getGroupName()===L1){return M1[i];}}return null;};c1.prototype._getAppointmentsCreateConfig=function(i){var j=A1(i),L1=new r({targetAggregation:"_intervalPlaceholders",dragStart:function(M1){if(!i.getEnableAppointmentsCreate()||j._isOneMonthIntervalOnSmallSizes()||!j._isCreatingPerformed()){M1.preventDefault();return;}var N1=M1.getParameter("dragSession"),O1=j.$().find(".sapUiCalendarRowAppsOverlay"),P1=Q(N1.getIndicator());setTimeout(function(){O1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){O1.removeClass("sapUiCalendarRowAppsOverlayDragging");P1.html("");P1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");});if(!n.browser.msie&&!n.browser.edge){M1.getParameter("browserEvent").dataTransfer.setDragImage(w1(),0,0);}},dragEnter:function(M1){var N1=M1.getParameter("dragSession"),O1=N1.getDropControl().getDomRef().getBoundingClientRect(),P1=function(){var R1=Q(N1.getIndicator());R1.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");};var Q1=N1.getData("text")?parseFloat(N1.getData("text").split("|")[0]):0;if(Q1){if(Q1<=O1.left){N1.setIndicatorConfig({left:Q1,width:Math.max((O1.left+O1.width-Q1),O1.width)});}else{N1.setIndicatorConfig({left:O1.left,width:Q1-O1.left});}}else{N1.setData("text",O1.left+"|"+j.indexOfAggregation("_intervalPlaceholders",N1.getDropControl()));}if(!N1.getIndicator()){setTimeout(P1,0);}else{P1();}},drop:function(M1){var N1=M1.getParameter("dragSession"),O1=Q(N1.getIndicator()),P1=j.getIntervalType(),Q1=A1(i).getStartDate(),R1=parseInt(N1.getData("text").split("|")[1]),S1=j.indexOfAggregation("_intervalPlaceholders",N1.getDropControl()),T1;if(P1===Z.Hour){T1=this._calcCreateNewAppHours(Q1,R1,S1);}else if(P1===Z.Day||P1===Z.Week||(P1===Z.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){T1=this._calcCreateNewAppDays(Q1,R1,S1);}else if(P1===Z.Month){T1=this._calcCreateNewAppMonths(Q1,R1,S1);}i.fireAppointmentCreate({startDate:T1.startDate,endDate:T1.endDate,calendarRow:i});O1.html("");O1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");}.bind(this)});L1.setProperty("groupName",a1);return L1;};function w1(){var i=Q("<span></span>").addClass("sapUiCalAppResizeGhost");i.appendTo(document.body);setTimeout(function(){i.remove();},0);return i.get(0);}function x1(i){var j=i.getId();return sap.ui.getCore().byId(j.substring(0,j.indexOf(b1)));}function y1(i){return sap.ui.getCore().byId(i.getId()+b1);}function z1(i){var j=y1(i);return j?j.getHeader():null;}function A1(i){var j=y1(i);return j?j.getTimeline():null;}function B1(j){var L1=[];var M1=this.getRows();for(var i=0;i<M1.length;i++){var N1=M1[i];var O1=y1(N1);var P1=O1.getSelected();if(N1.getSelected()!=P1){N1.setProperty("selected",P1,true);L1.push(N1);}}if(!this.getSingleSelection()){H1.call(this);}if(L1.length>0){this.fireRowSelectionChange({rows:L1});}}function C1(i){if(i<this._iBreakPointTablet){this._iSize=0;}else if(i<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(i<h1.PHONE){this._iSizeScreen=0;}else if(i<h1.TABLET){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function D1(j){var L1='sapMSize'+j,M1=this.$(),i,N1;if(M1){for(i=0;i<3;i++){N1='sapMSize'+i;if(N1===L1){M1.addClass(N1);}else{M1.removeClass(N1);}}}}function E1(){var j=this._getViews();this._oIntervalTypeSelect.destroyItems();var i;var L1;for(i=0;i<j.length;i++){var M1=j[i];L1=new I(this.getId()+"-"+i,{key:M1.getKey(),text:M1.getDescription(),tooltip:M1.getTooltip()});this._oIntervalTypeSelect.addItem(L1);}this._oIntervalTypeSelect.setVisible(!(j.length===1));}function F1(i){var j=i.getParameter("selected");var L1=this.getRows();if(j){L1=this.getRows().filter(function(M1){return!M1.getSelected();});}this.selectAllRows(j);this.fireRowSelectionChange({rows:L1});}function G1(j){var L1=j.oSource;var M1=j.getParameter("type");var N1=this.getRows();var O1;var P1;var Q1;var R1;var i=0;var S1=0;var T1;for(i=0;i<N1.length;i++){O1=N1[i];if(A1(O1)==L1){S1=i;break;}}switch(M1){case"sapup":Q1=L1.getFocusedAppointment();R1=Q1.getStartDate();if(S1>0){S1--;}P1=N1[S1];A1(P1).focusNearestAppointment(R1);break;case"sapdown":Q1=L1.getFocusedAppointment();R1=Q1.getStartDate();if(S1<N1.length-1){S1++;}P1=N1[S1];A1(P1).focusNearestAppointment(R1);break;case"saphome":if(S1>0){P1=N1[0];T1=new Q.Event(M1);T1._bPlanningCalendar=true;A1(P1).onsaphome(T1);}break;case"sapend":if(S1<N1.length-1){P1=N1[N1.length-1];T1=new Q.Event(M1);T1._bPlanningCalendar=true;A1(P1).onsapend(T1);}break;default:break;}}function H1(){if(this._oSelectAllCheckBox){var i=this.getRows();var j=this.getSelectedRows();if(i.length==j.length&&j.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function I1(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new F(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",F1,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}function J1(){var i=this.getAggregation("table");var j=i.getMode();var L1;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){L1=K.None;}else{L1=K.SingleSelectMaster;}}else{L1=K.MultiSelect;}if(j!=L1){i.setMode(L1);}}function K1(){return this._oTimeInterval||this._oDateInterval||this._oMonthInterval||this._oWeekInterval||this._oOneMonthInterval;}return c1;});
