/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Icon","./Input","./InputBase","./InputRenderer","sap/ui/core/Control","sap/ui/core/IconPool",'sap/ui/core/LabelEnablement','sap/ui/Device',"sap/ui/core/library","sap/ui/core/Renderer","sap/m/library","./StepInputRenderer","sap/ui/events/KeyCodes","sap/base/Log"],function(I,a,b,c,C,d,L,D,e,R,l,S,K,f){"use strict";var g=l.InputType;var T=e.TextAlign;var V=e.ValueState;var h=l.StepInputValidationMode;var j=l.StepInputStepModeType;var k=C.extend("sap.m.StepInput",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/StepInput.designtime",properties:{min:{type:"float",group:"Data"},max:{type:"float",group:"Data"},step:{type:"float",group:"Data",defaultValue:1},stepMode:{type:"sap.m.StepInputStepModeType",group:"Data",defaultValue:j.AdditionAndSubtraction},largerStep:{type:"float",group:"Data",defaultValue:2},value:{type:"float",group:"Data",defaultValue:0},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},required:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension"},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},enabled:{type:"boolean",group:"Behavior",defaultValue:true},displayValuePrecision:{type:"int",group:"Data",defaultValue:0},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.End},validationMode:{type:"sap.m.StepInputValidationMode",group:"Misc",defaultValue:h.FocusOut}},aggregations:{_input:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{change:{parameters:{value:{type:"string"}}}},dnd:{draggable:false,droppable:true}},constructor:function(i,s){C.prototype.constructor.apply(this,arguments);if(this.getEditable()){this._getOrCreateDecrementButton();this._getOrCreateIncrementButton();}if(typeof i!=="string"){s=i;}if(s&&s.value===undefined){this.setValue(this._getDefaultValue(undefined,s.max,s.min));}}});var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");k.STEP_INPUT_INCREASE_BTN_TOOLTIP=o.getText("STEP_INPUT_INCREASE_BTN");k.STEP_INPUT_DECREASE_BTN_TOOLTIP=o.getText("STEP_INPUT_DECREASE_BTN");k.INITIAL_WAIT_TIMEOUT=500;k.ACCELLERATION=0.8;k.MIN_WAIT_TIMEOUT=50;k.INITIAL_SPEED=120;k._TOLERANCE=10;var n={"min":"aria-valuemin","max":"aria-valuemax","value":"aria-valuenow"};var F=["enabled","editable","name","placeholder","required","valueStateText","description","fieldWidth","textAlign"];var N=R.extend(c);N.writeInnerAttributes=function(r,i){r.writeAttribute("type",i.getType().toLowerCase());if(sap.ui.getCore().getConfiguration().getRTL()){r.writeAttribute("dir","ltr");}};N.getAccessibilityState=function(i){var A=c.getAccessibilityState(i),s=i.getParent(),M=s.getMin(),q=s.getMax(),r=s.getValue(),t=s.getAriaLabelledBy(),u=L.getReferencingLabels(s),v=t.concat(u).join(" "),w=s.getAriaDescribedBy().join(" ");A["role"]="spinbutton";A["valuenow"]=r;if(typeof M==="number"){A["valuemin"]=M;}if(typeof q==="number"){A["valuemax"]=q;}if(w){A["describedby"]=w;}if(v){A["labelledby"]=v;}return A;};var m=a.extend("sap.m.internal.NumericInput",{metadata:{library:"sap.m"},constructor:function(i,s){return a.apply(this,arguments);},renderer:N});m.prototype.onBeforeRendering=function(){b.prototype.onBeforeRendering.call(this);this._deregisterEvents();};k.prototype.init=function(){this._iRealPrecision=0;this._attachChange();this._bPaste=false;this._onmousewheel=this._onmousewheel.bind(this);};k.prototype.onBeforeRendering=function(){var M=this.getMin(),i=this.getMax(),v=this.getValue();this._iRealPrecision=this._getRealValuePrecision();this._getInput().setValue(this._getFormatedValue(v));this._disableButtons(v,i,M);this.$().unbind(D.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);};k.prototype.onAfterRendering=function(){this.$().bind(D.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);};k.prototype.exit=function(){this.$().unbind(D.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);};k.prototype.setProperty=function(P,v,s){this._writeAccessibilityState(P,v);C.prototype.setProperty.call(this,P,v,s);if(F.indexOf(P)>-1){this._getInput().setProperty(P,this.getProperty(P),s);}return this;};k.prototype.setValidationMode=function(v){if(this.getValidationMode()!==v){switch(v){case sap.m.StepInputValidationMode.FocusOut:this._detachLiveChange();break;case sap.m.StepInputValidationMode.LiveChange:this._attachLiveChange();break;}this.setProperty("validationMode",v);}return this;};k.prototype.setMin=function(i){var r,v=this.getValue(),s=(v!==0&&!v);if(i===undefined){return this.setProperty("min",i,true);}if(!this._validateOptionalNumberProperty("min",i)){return this;}r=this.setProperty("min",i,s);this._disableButtons(v,this.getMax(),i);return r;};k.prototype.setMax=function(i){var r,v=this.getValue(),s=(v!==0&&!v);if(i===undefined){return this.setProperty("max",i,true);}if(!this._validateOptionalNumberProperty("max",i)){return this;}r=this.setProperty("max",i,s);this._disableButtons(this.getValue(),i,this.getMin());return r;};k.prototype._validateOptionalNumberProperty=function(i,v){if(this._isNumericLike(v)){return true;}f.error("The value of property '"+i+"' must be a number");return false;};k.prototype.setDisplayValuePrecision=function(i){var v,q=this.getValue(),s=(q!==0&&!q);if(p(i)){v=parseInt(i);}else{v=0;f.warning(this+": ValuePrecision ("+i+") is not correct. It should be a number between 0 and 20! Setting the default ValuePrecision:0.");}return this.setProperty("displayValuePrecision",v,s);};k.prototype.setTooltip=function(t){this._getInput().setTooltip(t);return this;};k.prototype._getIncrementButton=function(){var i=this._getInput().getAggregation("_endIcon");return i?i[0]:null;};k.prototype._getDecrementButton=function(){var i=this._getInput().getAggregation("_beginIcon");return i?i[0]:null;};k.prototype._createIncrementButton=function(){var t=this;var i=this._getInput().addEndIcon({src:d.getIconURI("add"),id:this.getId()+"-incrementBtn",noTabStop:true,press:this._handleButtonPress.bind(this,true),tooltip:k.STEP_INPUT_INCREASE_BTN_TOOLTIP});i.getEnabled=function(){return!this._shouldDisableIncrementButton(this.getValue(),this.getMax());}.bind(this);i.addEventDelegate({onAfterRendering:function(){i.$().attr("tabindex","-1");t._attachEvents(i,true);}});return i;};k.prototype._createDecrementButton=function(){var t=this;var i=this._getInput().addBeginIcon({src:d.getIconURI("less"),id:this.getId()+"-decrementBtn",noTabStop:true,press:this._handleButtonPress.bind(this,false),tooltip:k.STEP_INPUT_DECREASE_BTN_TOOLTIP});i.getEnabled=function(){return!this._shouldDisableDecrementButton(this.getValue(),this.getMin());}.bind(this);i.addEventDelegate({onAfterRendering:function(){i.$().attr("tabindex","-1");t._attachEvents(i,false);}});return i;};k.prototype._getInput=function(){if(!this.getAggregation("_input")){var i=new m({id:this.getId()+"-input",textAlign:this.getTextAlign(),type:g.Number,editable:this.getEditable(),enabled:this.getEnabled(),description:this.getDescription(),fieldWidth:this.getFieldWidth(),liveChange:this._inputLiveChangeHandler});this.setAggregation("_input",i);}return this.getAggregation("_input");};k.prototype._handleButtonPress=function(i){var q=this._calculateNewValue(1,i),M=this.getMin(),r=this.getMax();this._btndown=undefined;this._disableButtons(q.displayValue,r,M);this.setValue(q.value);if(this._sOldValue!==this.getValue()){this._verifyValue();this.fireChange({value:this.getValue()});}this.$().focus();return this;};k.prototype._disableButtons=function(v,M,i){if(!this._isNumericLike(v)){return;}var q=this._getIncrementButton(),r=this._getDecrementButton(),s=this._shouldDisableDecrementButton(v,i),t=this._shouldDisableIncrementButton(v,M);r&&r.toggleStyleClass("sapMStepInputIconDisabled",s);q&&q.toggleStyleClass("sapMStepInputIconDisabled",t);return this;};k.prototype._shouldDisableDecrementButton=function(v,M){var i=this._isNumericLike(M),E=this.getEnabled(),r=i&&M>=v;return E?r:true;};k.prototype._shouldDisableIncrementButton=function(v,M){var i=this._isNumericLike(M),E=this.getEnabled(),r=i&&M<=v;return E?r:true;};k.prototype._verifyValue=function(){var i=this.getMin(),q=this.getMax(),v=parseFloat(this._getInput().getValue());if(!this._isNumericLike(v)){return;}if((this._isNumericLike(q)&&v>q)||(this._isNumericLike(i)&&v<i)||(this._areFoldChangeRequirementsFulfilled()&&(v%this.getStep()!==0))){this.setValueState(V.Error);}else{this.setValueState(V.None);}};k.prototype.setValue=function(v){var r;if(v==undefined){v=0;}this._sOldValue=this.getValue();if(!this._validateOptionalNumberProperty("value",v)){return this;}this._getInput().setValue(this._getFormatedValue(v));this._disableButtons(v,this.getMax(),this.getMin());r=this.setProperty("value",parseFloat(v),true);this._iRealPrecision=this._getRealValuePrecision();return r;};k.prototype._getFormatedValue=function(v){var P=this.getDisplayValuePrecision(),i,s;if(v==undefined){v=this.getValue();}if(P<=0){return parseFloat(v).toFixed(0);}s=v.toString().split(".");if(s.length===2){i=s[1].length;if(i>P){return parseFloat(v).toFixed(P);}return s[0]+"."+this._padZeroesRight(s[1],P);}else{return v.toString()+"."+this._padZeroesRight("0",P);}};k.prototype._padZeroesRight=function(v,q){var r="",s=v.length;for(var i=s;i<q;i++){r=r+"0";}r=v+r;return r;};k.prototype.onsappageup=function(E){this._applyValue(this._calculateNewValue(this.getLargerStep(),true).displayValue);this._verifyValue();E.preventDefault();};k.prototype.onsappagedown=function(E){this._applyValue(this._calculateNewValue(this.getLargerStep(),false).displayValue);this._verifyValue();E.preventDefault();};k.prototype.onsappageupmodifiers=function(E){if(this._isNumericLike(this.getMax())&&!(E.ctrlKey||E.metaKey||E.altKey)&&E.shiftKey){this._applyValue(this.getMax());}};k.prototype.onsappagedownmodifiers=function(E){if(this._isNumericLike(this.getMin())&&!(E.ctrlKey||E.metaKey||E.altKey)&&E.shiftKey){this._applyValue(this.getMin());}};k.prototype.onsapup=function(E){E.preventDefault();this._applyValue(this._calculateNewValue(1,true).displayValue);this._verifyValue();};k.prototype.onsapdown=function(E){E.preventDefault();this._applyValue(this._calculateNewValue(1,false).displayValue);this._verifyValue();};k.prototype._onmousewheel=function(E){var i=this.getDomRef().contains(document.activeElement);if(i){E.preventDefault();var O=E.originalEvent,q=O.detail?(-O.detail>0):(O.wheelDelta>0);this._applyValue(this._calculateNewValue(1,q).displayValue);this._verifyValue();}};k.prototype.onkeydown=function(E){var v=false;this._bPaste=(E.ctrlKey||E.metaKey)&&(E.which===K.V);if(E.which===K.ARROW_UP&&!E.altKey&&E.shiftKey&&(E.ctrlKey||E.metaKey)){this._applyValue(this.getMax());v=true;}if(E.which===K.ARROW_DOWN&&!E.altKey&&E.shiftKey&&(E.ctrlKey||E.metaKey)){this._applyValue(this.getMin());v=true;}if(E.which===K.ARROW_UP&&!(E.ctrlKey||E.metaKey||E.altKey)&&E.shiftKey){E.preventDefault();this._applyValue(this._calculateNewValue(this.getLargerStep(),true).displayValue);v=true;}if(E.which===K.ARROW_DOWN&&!(E.ctrlKey||E.metaKey||E.altKey)&&E.shiftKey){E.preventDefault();this._applyValue(this._calculateNewValue(this.getLargerStep(),false).displayValue);v=true;}if(E.which===K.ARROW_UP&&(E.ctrlKey||E.metaKey)){E.preventDefault();this._applyValue(this._calculateNewValue(1,true).displayValue);v=true;}if(E.which===K.ARROW_DOWN&&(E.ctrlKey||E.metaKey)){E.preventDefault();this._applyValue(this._calculateNewValue(1,false).displayValue);v=true;}if(E.which===K.ARROW_UP&&E.altKey){E.preventDefault();this._applyValue(this._calculateNewValue(1,true).displayValue);v=true;}if(E.which===K.ARROW_DOWN&&E.altKey){E.preventDefault();this._applyValue(this._calculateNewValue(1,false).displayValue);v=true;}if(v){this._verifyValue();}};k.prototype.onsapescape=function(E){this._getInput().onsapescape(E);};k.prototype._attachLiveChange=function(){this._getInput().attachLiveChange(this._liveChange,this);};k.prototype._detachLiveChange=function(){this._getInput().detachLiveChange(this._liveChange,this);};k.prototype._attachChange=function(){this._getInput().attachChange(this._change,this);};k.prototype._liveChange=function(){this._verifyValue();this._disableButtons(this._getInput().getValue(),this.getMax(),this.getMin());};k.prototype._change=function(E){this._sOldValue=this.getValue();this.setValue(this._getDefaultValue(this._getInput().getValue(),this.getMax(),this.getMin()));if(this._sOldValue!==this.getValue()&&!this._isButtonFocused()){this._verifyValue();this.fireChange({value:this.getValue()});}};k.prototype._applyValue=function(i){if(!this.getEditable()||!this.getEnabled()){return;}this.getAggregation("_input")._$input.val(this._getFormatedValue(i));};k.prototype._calculateNewValue=function(s,i){var q=this.getStep(),M=this.getMax(),r=this.getMin(),t=this.getValue(),u=parseFloat(this._getDefaultValue(this._getInput().getValue(),M,r)),v=i?1:-1,w=Math.abs(q)*Math.abs(s),x=u+v*w,y,z,A=this.getDisplayValuePrecision();if(A>0){y=this._sumValues(u,w,v,A);}else{y=x;}if(this._areFoldChangeRequirementsFulfilled()){x=y=z=this._calculateClosestFoldValue(u,w,v);}else{z=this._sumValues(t,w,v,this._iRealPrecision);}if(this._isNumericLike(M)&&x>=M){z=M;y=M;}if(this._isNumericLike(r)&&x<=r){z=r;y=r;}return{value:z,displayValue:y};};k.prototype._getRealValuePrecision=function(){var s=this.getValue().toString().split("."),i=this.getStep().toString().split("."),q,r;q=(!s[1])?0:s[1].length;r=(!i[1])?0:i[1].length;return(q>r)?q:r;};k.prototype.setValueState=function(v){var E=false,w=false;switch(v){case V.Error:E=true;break;case V.Warning:w=true;break;case V.Success:case V.None:break;default:return this;}this._getInput().setValueState(v);setTimeout(function(){this.$().toggleClass("sapMStepInputError",E).toggleClass("sapMStepInputWarning",w);}.bind(this),0);this.setProperty("valueState",v,true);return this;};k.prototype.setEditable=function(i){var r=k.prototype.setProperty.call(this,"editable",i);this._getOrCreateDecrementButton().setVisible(i);this._getOrCreateIncrementButton().setVisible(i);return r;};k.prototype._getOrCreateDecrementButton=function(){return this._getDecrementButton()||this._createDecrementButton();};k.prototype._getOrCreateIncrementButton=function(){return this._getIncrementButton()||this._createIncrementButton();};k.prototype._inputLiveChangeHandler=function(E){var v=this.getParent()._restrictCharsWhenDecimal(E);this.setProperty("value",v?v:E.getParameter("newValue"),true);};k.prototype._restrictCharsWhenDecimal=function(E){var i=E.getParameter("value").indexOf("."),q=this.getDisplayValuePrecision(),v;if(i>0&&q>0){var s=E.getParameter("value"),r=s.split('.')[1],t=r?r.length:0,u=E.getSource().getProperty("value"),w=s.split('.')[0],x=u.substring(u.indexOf('.')+1,u.length);if(!this._bPaste){if(t>q){v=w+"."+x;this._showWrongValueVisualEffect();}}else{if(s.indexOf(".")){v=s.split('.')[0]+"."+r.substring(0,q);}this._bPaste=false;}}this._getInput().updateDomValue(v);return v;};k.prototype._showWrongValueVisualEffect=function(){var O=this.getValueState(),i=this._getInput();if(O===V.Error){return;}i.setValueState(V.Error);setTimeout(i["setValueState"].bind(i,O),1000);};k.prototype._getDefaultValue=function(v,i,q){if(v!==""&&v!==undefined){return this._getInput().getValue();}if(this._isNumericLike(q)&&q>0){return q;}else if(this._isNumericLike(i)&&i<0){return i;}else{return 0;}};k.prototype._isNumericLike=function(v){return!isNaN(v)&&v!==null&&v!=="";};k.prototype._isInteger=function(v){return v===parseInt(v);};k.prototype._writeAccessibilityState=function(P,v){var $=this._getInput().getDomRef("inner");if(!$){return;}if(P&&n[P]){$.setAttribute(n[P],v);}};k.prototype._isButtonFocused=function(){return document.activeElement===this._getIncrementButton().getDomRef()||document.activeElement===this._getDecrementButton().getDomRef();};k.prototype._sumValues=function(v,i,s,P){var q=Math.pow(10,P),r=parseInt((v*q).toFixed(10)),t=parseInt((i*q).toFixed(10));return(r+(s*t))/q;};k.prototype._areFoldChangeRequirementsFulfilled=function(){return this.getStepMode()===j.Multiple&&this.getDisplayValuePrecision()===0&&this._isInteger(this.getStep())&&this._isInteger(this.getLargerStep());};k.prototype._calculateClosestFoldValue=function(v,s,i){var r=Math.floor(v),q=s;do{r+=i;q--;}while(r%s!==0&&q);if(r%s!==0){f.error("Wrong next/previous value "+r+" for "+v+", step: "+s+" and sign: "+i,this);}return r;};function p(v){return(typeof(v)==='number')&&!isNaN(v)&&v>=0&&v<=20;}k.prototype._calcWaitTimeout=function(){this._speed*=k.ACCELLERATION;this._waitTimeout=((this._waitTimeout-this._speed)<k.MIN_WAIT_TIMEOUT?k.MIN_WAIT_TIMEOUT:(this._waitTimeout-this._speed));return this._waitTimeout;};k.prototype._spinValues=function(i){var t=this;if(this._btndown){this._spinTimeoutId=setTimeout(function(){if(t._btndown){var q=t._calculateNewValue(1,i);t.setValue(q.value);t._verifyValue();if(!t._getIncrementButton().getEnabled()||!t._getDecrementButton().getEnabled()){_.call(t);t.fireChange({value:t.getValue()});}t._spinValues(i);}},t._calcWaitTimeout());}};k.prototype._attachEvents=function(B,i){var t=this;var E={onmousedown:function(q){if(q.button===0&&!t._btndown){t._waitTimeout=k.INITIAL_WAIT_TIMEOUT;t._speed=k.INITIAL_SPEED;t._btndown=true;t._spinValues(i);}},onmouseup:function(q){if(t._btndown){_.call(t);}},onmouseout:function(q){if(t._btndown){_.call(t);t.fireChange({value:t.getValue()});}},oncontextmenu:function(q){q.stopImmediatePropagation(true);q.preventDefault();q.stopPropagation();}};B.addDelegate(E,true);};k.prototype.getIdForLabel=function(){return this.getAggregation("_input").getIdForLabel();};function _(){if(this._btndown){this._btndown=undefined;clearTimeout(this._spinTimeoutId);this._waitTimeout=500;this._speed=120;}}return k;});
