/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/InvisibleText','sap/ui/core/Control','sap/ui/Device','./TileRenderer',"sap/ui/thirdparty/jquery"],function(l,I,C,D,T,q){"use strict";var a=C.extend("sap.m.Tile",{metadata:{library:"sap.m",properties:{removable:{type:"boolean",group:"Misc",defaultValue:true}},events:{press:{}}}});a.prototype.init=function(){if(D.system.desktop){var o=q.proxy(function(e){if(e.srcControl===this&&!e.isMarked()){this.ontap();e.stopPropagation();}},this);this.onsapspace=o;this.onsapenter=o;}};a.prototype.onAfterRendering=function(){if(this._rendered&&!this._bIsDragged&&this.getParent()instanceof sap.m.TileContainer){this.setPos(this._posX,this._posY);}this._rendered=true;};a.prototype.setPos=function(x,y){this._posX=x=Math.floor(x);this._posY=y=Math.floor(y);if(!this._rendered){return;}var o=this.getDomRef();if("webkitTransform"in o.style){this.$().css('-webkit-transform','translate3d('+x+'px,'+y+'px,0)');}else if("transform"in o.style){this.$().css('transform','translate3d('+x+'px,'+y+'px,0)');}else if("msTransform"in o.style){this.$().css('msTransform','translate('+x+'px,'+y+'px)');}else if("MozTransform"in o.style){this.$().css('-moz-transform','translate3d('+x+'px,'+y+'px,0)');}if(this._invisible){this.$().css("visibility","");delete this._invisible;}};a.prototype.setSize=function(w,h){this._width=w;this._height=h;};a.prototype.isEditable=function(i){var o=this._bIsEditable;if(i===true||i===false){this._bIsEditable=i;}if(o!=i&&this.$()){this.$().attr("aria-describedBy",i?I.getStaticId("sap.m","TILE_REMOVE_BY_DEL_KEY"):null);}return this._bIsEditable;};a.prototype.isDragged=function(i){if(!this._bIsEditable){return;}if(i===true||i===false){var o=this.$();o.toggleClass("sapMTileDrag",i);this._bIsDragged=i;}return this._bIsDragged;};a.prototype.ontouchstart=function(e){if(!this.isEditable()&&!this._parentPreventsTapEvent){this.$().toggleClass("sapMTileActive sapMTileActive-CTX",true);this._clientX=e.clientX;this._clientY=e.clientY;}};a.prototype.ontouchend=function(){if(!this.isEditable()){this.$().toggleClass("sapMTileActive sapMTileActive-CTX",false);}};Object.defineProperty(a.prototype,"_parentPreventsTapEvent",{get:function(){var p=this.getParent();while(p){if(p._bAvoidChildTapEvent||(p instanceof a&&p.isEditable())){return true;}p=p.getParent();}return false;}});a.prototype.ontouchmove=function(e){if(!this.isEditable()&&!this._parentPreventsTapEvent){if(Math.abs(e.clientX-this._clientX)>30||Math.abs(e.clientY-this._clientY)>10){this.$().toggleClass("sapMTileActive sapMTileActive-CTX",false);}}};a.prototype.ontap=function(){if(!this.isEditable()&&!this._parentPreventsTapEvent){this.firePress({});}};a.prototype.setVisible=function(v){this.setProperty("visible",v);if(!v){this._rendered=false;}if(this.getParent()&&this.getParent()instanceof sap.m.TileContainer){this.getParent().invalidate();}return this;};a.prototype._setVisible=function(v){this._invisible=!v;return this;};return a;});
