/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/base/Log','sap/ui/dom/containsOrEquals','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/RenderManager','./DialogRenderer','sap/ui/core/library','sap/ui/core/ResizeHandler','sap/ui/dom/jquery/control','sap/ui/dom/jquery/Selectors'],function(q,L,c,l,C,P,R,D,a,b){"use strict";var O=a.OpenState;var A=a.AccessibleRole;var B=l.enums.BorderDesign;var d=C.extend("sap.ui.commons.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},scrollLeft:{type:"int",group:"Behavior",defaultValue:0},scrollTop:{type:"int",group:"Behavior",defaultValue:0},title:{type:"string",group:"Misc",defaultValue:''},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},showCloseButton:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentBorderDesign:{type:"sap.ui.commons.enums.BorderDesign",group:"Appearance",defaultValue:B.None},modal:{type:"boolean",group:"Misc",defaultValue:false},accessibleRole:{type:"sap.ui.core.AccessibleRole",group:"Accessibility",defaultValue:A.Dialog},keepInWindow:{type:"boolean",group:"Behavior",defaultValue:false},autoClose:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{buttons:{type:"sap.ui.core.Control",multiple:true,singularName:"button"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{defaultButton:{type:"sap.ui.commons.Button",multiple:false},initialFocus:{type:"sap.ui.core.Control",multiple:false}},events:{closed:{parameters:{width:{type:"int"},height:{type:"int"},top:{type:"int"},left:{type:"int"}}}}}});d.prototype.init=function(){this.oPopup=new P(this,true,true);this._minWidth=64;this._minHeight=48;this.allowTextSelection(false);this._mParameters={};this._mParameters.that=this;this._mParameters.firstFocusable=this.getId()+"-fhfe";this._mParameters.lastFocusable=this.getId()+"-fhee";this._fnOnResizeRecenter=q.proxy(this._onResize,this);};d.prototype.setInitialFocus=function(i){if(i&&typeof i!="string"){i=i.getId();}this.oPopup.setInitialFocusId(i);this.setAssociation("initialFocus",i,true);return this;};d.prototype.onAfterRendering=function(){var $=this.$("cont");var _=this.getMinSize();this._minWidth=_.width;this._minHeight=_.height;if(!this._isSizeSet(this.getWidth())&&!this._isSizeSet(this.getMaxWidth())){$.children().each(function(i,h){if(q.trim(this.style.width)=="100%"){this.style.width="auto";}});}if(!this._isSizeSet(this.getHeight())&&this._isSizeSet(this.getMinHeight())){var f=this.getDomRef("footer");var e=f.offsetTop+f.offsetHeight;var g=this.getDomRef().offsetHeight;if(e<g){this.$().removeClass("sapUiDlgFlexHeight");}}};d.prototype.onclick=function(e){var s=this.getId()+"-close";if(e.target.id===s){this.close();e.preventDefault();}return false;};d.prototype.open=function(){if(!this.oPopup){L.fatal("This dialog instance has been destroyed already");}else if(!this._bOpen){this._oPreviousFocus=P.getCurrentFocusInfo();this.oPopup.attachEvent("opened",this.handleOpened,this);this.oPopup.attachEvent("closed",this.handleClosed,this);this.oPopup.setModal(this.getModal());this.oPopup.setAutoClose(this.getAutoClose());this.oPopup.open(400);this._onResize();this._bOpen=true;this._registerContentResizeHandler();}};d.prototype.onThemeChanged=function(){this.invalidate();};d.prototype._handleOpened=function(){this.$().show();var i=this.getInitialFocus();var t;this._bInitialFocusSet=true;if(i){sap.ui.getCore().byId(i).focus();return;}i=this.getDefaultButton();t=q(":sapTabbable",this.$("cont"));if(i){sap.ui.getCore().byId(i).focus();}else if(this.getButtons().length){this.getButtons()[0].focus();}else if(this.getContent().length&&t.length){t[0].focus();}else{var f=document.getElementById(this._mParameters.firstFocusable);if(f){f.focus();}}};d.prototype.handleOpened=function(){this.oPopup.detachEvent("opened",this.handleOpened,this);this._handleOpened();};d.prototype.close=function(){if(!this._bOpen){return;}var r=this.$().rect();this._bOpen=false;this._bInitialFocusSet=false;if(this.oPopup.isOpen()){this.oPopup.close(400);}setTimeout(function(){this.restorePreviousFocus();}.bind(this),400);q.each(r,function(k,v){r[k]=parseInt(v);});this._oRect=r;};d.prototype.handleClosed=function(){this.oPopup.detachEvent("closed",this.handleClosed,this);this._deregisterContentResizeHandler();this.fireClosed(this._oRect);this.close();if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}};d.prototype.restorePreviousFocus=function(){P.applyFocusInfo(this._oPreviousFocus);};d.prototype.setTitle=function(t){this.setProperty("title",t,true);this.$("lbl").text(t);return this;};d.prototype.exit=function(){var w=this.isOpen();this.close();this.oPopup.detachEvent("opened",this.handleOpened,this);this.oPopup.detachEvent("closed",this.handleClosed,this);this._deregisterContentResizeHandler();this.oPopup.destroy();if(w){this.fireClosed(this._oRect);}this.oPopup=null;clearTimeout(this._sDelayedCall);this._sDelayedCall=null;delete this._mParameters;this._fnOnResizeRecenter=null;};d.prototype._isSizeSet=function(s){return!!(s&&s!=="auto"&&s!=="inherit");};d.prototype.onsapescape=function(e){this.close();e.preventDefault();e.stopPropagation();};d.prototype.onsapenter=function(e){var f,i=this.getDefaultButton();if(i&&(f=sap.ui.getCore().byId(i))&&q.contains(this.getDomRef(),f.getDomRef())){if(f instanceof sap.ui.commons.Button){f.onclick(e);}}e.preventDefault();e.stopPropagation();};d.prototype.onfocusin=function(e){this.sLastRelevantNavigation=null;if(!this._bInitialFocusSet){return;}this._mParameters.event=e;this._mParameters.$FocusablesContent=q(":sapTabbable",this.$("cont"));this._mParameters.$FocusablesFooter=q(":sapTabbable",this.$("footer"));this.oPopup.focusTabChain(this._mParameters);};d.prototype.restoreFocus=function(){if(this.oRestoreFocusInfo&&this.oPopup.bOpen){var o=sap.ui.getCore().byId(this.oRestoreFocusInfo.sFocusId);if(o){o.applyFocusInfo(this.oRestoreFocusInfo.oFocusInfo);}}};d.prototype.onselectstart=function(e){if(!c(this.getDomRef("cont"),e.target)){e.preventDefault();e.stopPropagation();}};d.prototype.getMinSize=function(){var e=36;var $=this.$();var f=this.$("hdr");var g=this.$("footer");var F=g.children("DIV").get(0);var w=F?F.offsetWidth:0;var h=g.css('display')!=='none';var i=0;var j;var k;i+=g.outerWidth(false)-g.width();i+=$.outerWidth(false)-$.width();if(i<=20){i=20;}w+=i;if(w<100){w=100;}j=f.outerHeight(false);k=g.outerHeight(false);return{width:w,height:j+k+(h?e:0)};};d.prototype.forceInvalidate=C.prototype.invalidate;d.prototype.invalidate=function(o){if(this.oPopup&&(this.oPopup.eOpenState!=="CLOSING"||this.isOpen())){this.forceInvalidate(o);}};d.prototype.isOpen=function(){return this.oPopup.isOpen();};d.prototype.getOpenState=function(){return this.oPopup.getOpenState();};d.prototype.getEnabled=function(){var e=this.getOpenState();return e===O.OPENING||e===O.OPEN;};d.prototype.ondragstart=function(e){if(this.sDragMode=="resize"||this.sDragMode=="move"){e.preventDefault();e.stopPropagation();}};d.prototype.onmousedown=function(e){var s=e.target,i=this.getId();this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();var o=this.getDomRef();if(c(this.getDomRef("hdr"),s)){if(s.id!=(i+"-close")){this.sDragMode="move";this._RootWidth=o.offsetWidth;this._RootHeight=o.offsetHeight;}}else if(s.id==i+"-grip"){this.sDragMode="resize";var w=o.offsetWidth+"px";var h=o.offsetHeight+"px";o.style.width=w;o.style.height=h;q(o).removeClass("sapUiDlgFlexHeight sapUiDlgFlexWidth");this.setProperty("width",w,true);this.setProperty("height",h,true);}if(!this.sDragMode){return;}var f=document.activeElement;if(f&&f.id){var g=q(f).control(0);if(g){this.oRestoreFocusInfo={sFocusId:g.getId(),oFocusInfo:g.getFocusInfo()};}}this.startDragX=e.screenX;this.startDragY=e.screenY;this.originalRectangle=this.$().rect();q(window.document).on("selectstart",q.proxy(this.ondragstart,this));q(window.document).on("mousemove",q.proxy(this.handleMove,this));q(window.document).on("mouseup",q.proxy(this.handleMouseUp,this));var j=this._findSameDomainParentWinDoc();if(j){q(j).on("selectstart",q.proxy(this.ondragstart,this));q(j).on("mousemove",q.proxy(this.handleMove,this));q(j).on("mouseup",q.proxy(this.handleMouseUp,this));}};d.prototype._findSameDomainParentWinDoc=function(){var o=null;try{var w=window;while(w.parent&&(w.parent!=w)){if(w.parent.document){o=w.parent.document;w=w.parent;}}}catch(e){}return o;};d.prototype.handleMove=function(e){if(!this.sDragMode){return;}e=e||window.event;this._deregisterContentResizeHandler();if(this.sDragMode=="resize"){var f=e.screenX-this.startDragX||0;var g=e.screenY-this.startDragY||0;var w=(this._bRtlMode?this.originalRectangle.width-f:this.originalRectangle.width+f)||0;var h=this.originalRectangle.height+g||0;w=Math.max(w,this._minWidth);h=Math.max(h,this._minHeight);var o=this.getDomRef();o.style.width=w+"px";o.style.height=h+"px";w=o.offsetWidth;h=o.offsetHeight;this.setProperty("width",w+"px",true);this.setProperty("height",h+"px",true);}else if(this.sDragMode=="move"){var i=this.originalRectangle.left+e.screenX-this.startDragX;var t=this.originalRectangle.top+e.screenY-this.startDragY;t=Math.max(t,window.pageYOffset);if(this._bRtlMode||this._keepInWindow()){i=Math.min(i,document.documentElement.clientWidth+window.pageXOffset-this._RootWidth);}if(!this._bRtlMode||this._keepInWindow()){i=Math.max(i,0);}if(this._keepInWindow()){t=Math.min(t,document.documentElement.clientHeight+window.pageYOffset-this._RootHeight);}this.oPopup.setPosition(P.Dock.LeftTop,{left:i,top:t});}e.cancelBubble=true;this._registerContentResizeHandler();return false;};d.prototype._keepInWindow=function(){return this.getKeepInWindow()||this.getModal();};d.prototype.handleMouseUp=function(e){if(this.sDragMode===null){return;}q(window.document).off("selectstart",this.ondragstart);q(window.document).off("mousemove",this.handleMove);q(window.document).off("mouseup",this.handleMouseUp);var o=this._findSameDomainParentWinDoc();if(o){q(o).off("selectstart",this.ondragstart);q(o).off("mousemove",this.handleMove);q(o).off("mouseup",this.handleMouseUp);}this.restoreFocus();this.sDragMode=null;};d.setAutoClose=function(e){this.oPopup.setAutoClose(e);};d.getAutoClose=function(){this.oPopup.getAutoClose();};d.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){b.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};d.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=b.register(this.getDomRef("cont"),this._fnOnResizeRecenter);}};d.prototype._onResize=function(){var e=P.Dock;if(this.oPopup){this.oPopup.setPosition(e.CenterCenter,e.CenterCenter,window);}};return d;});
