/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','sap/ui/core/theming/Parameters','./RatingIndicatorRenderer','sap/ui/Device','sap/ui/events/checkMouseEnterOrLeave'],function(q,l,C,P,R,D,c){"use strict";var a=l.RatingIndicatorVisualMode;var b=C.extend("sap.ui.commons.RatingIndicator",{metadata:{library:"sap.ui.commons",properties:{editable:{type:"boolean",group:"Behavior",defaultValue:true},maxValue:{type:"int",group:"Behavior",defaultValue:5},value:{type:"float",group:"Behavior",defaultValue:0,bindable:"bindable"},averageValue:{type:"float",group:"Behavior",defaultValue:0},iconSelected:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},iconUnselected:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},iconHovered:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},visualMode:{type:"sap.ui.commons.RatingIndicatorVisualMode",group:"Behavior",defaultValue:a.Half}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"int"}}}}}});b.NoValue=-9999;b.prototype.init=function(){this.iHoveredRating=-1;};b.prototype.exit=function(){};b.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate();}};b.prototype.ondragstart=function(e){e.preventDefault();};b.prototype._getDisplayValue=function(){var v=this.getValue();if(v==b.NoValue){return this.getAverageValue();}else{return v;}};b.prototype.onsapincrease=function(e){var n=this.iHoveredRating;if(n==-1){n=Math.round(this._getDisplayValue())-1;if(n==-1){n=0;}}if(n<this.getMaxValue()){n=n+1;}else{n=this.getMaxValue();}this.updateHoverState(e,n);};b.prototype.onsapdecrease=function(e){var n=this.iHoveredRating;if(n==-1&&Math.round(this._getDisplayValue())==0){return;}if(n==-1){n=Math.round(this._getDisplayValue())+1;}if(n>1){n=n-1;}else{n=1;}this.updateHoverState(e,n);};b.prototype.onsaphome=function(e){this.updateHoverState(e,1);};b.prototype.onsapend=function(e){this.updateHoverState(e,this.getMaxValue());};b.prototype.onsapselect=function(e){this.saveValue(e,true,this.iHoveredRating);};b.prototype.onsapescape=function(e){this.saveValue(e,true,-1);};b.prototype.onfocusout=function(e){if(D.browser.msie&&e.target!=this.getDomRef()){return;}this.saveValue(e,false,this.iHoveredRating);};b.prototype.onfocusin=function(e){if(D.browser.msie&&e.target!=this.getDomRef()){this.getDomRef().focus();}};b.prototype.onclick=function(e){this.saveValue(e,true,this.getSymbolValue(e));};b.prototype.onmouseover=function(e){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return;}this.iHoveredRating=-1;var s=this.getSymbolValue(e);if(s==-1){return;}for(var i=1;i<=s;i++){R.hoverRatingSymbol(i,this);}for(var i=s+1;i<=this.getMaxValue();i++){R.hoverRatingSymbol(i,this,true);}};b.prototype.onmouseout=function(e){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return;}if(c(e,this.getDomRef())){this.iHoveredRating=-1;for(var i=1;i<=this.getMaxValue();i++){R.unhoverRatingSymbol(i,this);}}};b.prototype.getSymbolValue=function(e){var s=q(e.target);if(s.hasClass("sapUiRatingItmImg")||s.hasClass("sapUiRatingItmOvrflw")){s=q(e.target.parentNode);}else if(s.hasClass("sapUiRatingItmOvrflwImg")){s=q(e.target.parentNode.parentNode);}var i=s.attr("itemvalue");if(i){return parseInt(i);}return-1;};b.prototype.updateKeyboardHoverState=function(s){for(var i=1;i<=this.getMaxValue();i++){R.unhoverRatingSymbol(i,this);if(i<=this.iHoveredRating){R.hoverRatingSymbol(i,this);}else if(!s){R.hoverRatingSymbol(i,this,true);}}this.setAriaState();};b.prototype.onAfterRendering=function(){this.setAriaState();};b.prototype.setAriaState=function(){var v=this.iHoveredRating==-1?this._getDisplayValue():this.iHoveredRating;this.$().attr("aria-valuenow",v).attr("aria-valuetext",this._getText("RATING_ARIA_VALUE",[v])).attr("aria-label",this._getText("RATING_ARIA_NAME"));};b.prototype._getText=function(k,A){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(r){return r.getText(k,A);}return k;};b.prototype.saveValue=function(e,d,n){if(d){e.preventDefault();}if(!this.getEditable()){return false;}this.iHoveredRating=-1;if(n!=-1&&n!=this.getValue()){this.setValue(n);this.fireChange({value:n});return true;}else{for(var i=1;i<=this.getMaxValue();i++){R.unhoverRatingSymbol(i,this);}this.setAriaState();return false;}};b.prototype.updateHoverState=function(e,n){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return;}this.iHoveredRating=n;this.updateKeyboardHoverState();};b.prototype.setMaxValue=function(m){if(m<1){m=1;}this.setProperty("maxValue",m);return this;};b.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");return{role:"slider",type:B.getText("ACC_CTR_TYPE_RATING"),description:B.getText("ACC_CTR_STATE_RATING",[this._getDisplayValue(),this.getMaxValue()]),focusable:true,editable:this.getEditable()};};return b;});
