/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/ResizeHandler','sap/ui/core/delegate/ItemNavigation','./SplitterRenderer','sap/ui/core/library','jquery.sap.events'],function(q,l,C,P,R,I,S,c){"use strict";var O=c.Orientation;var a=C.extend("sap.ui.commons.Splitter",{metadata:{library:"sap.ui.commons",properties:{splitterOrientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:O.Vertical},splitterPosition:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:'50%'},minSizeFirstPane:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:'0%'},minSizeSecondPane:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:'0%'},width:{type:"sap.ui.commons.SplitterSize",group:"Behavior",defaultValue:'100%'},height:{type:"sap.ui.commons.SplitterSize",group:"Behavior",defaultValue:'100%'},showScrollBars:{type:"boolean",group:"Behavior",defaultValue:true},splitterBarVisible:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{firstPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"firstPaneContent"},secondPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"secondPaneContent"}}}});a.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}if(this.sSpecialResizeListenerId){R.deregister(this.sSpecialResizeListenerId);this.sSpecialResizeListenerId=null;}};a.prototype.onAfterRendering=function(){this._recalculateInternals();this.sResizeListenerId=R.register(this.splitterDIV,q.proxy(this.onresize,this));};a.prototype._recalculateInternals=function(){this.splitterDIV=this.getDomRef();this.splitterBar=document.getElementById(this.getId()+'_SB');this.firstPane=document.getElementById(this.getId()+'_firstPane');this.secondPane=document.getElementById(this.getId()+'_secondPane');this.minSizeFP=this.getMinSizeFirstPane();this.minSizeSP=this.getMinSizeSecondPane();this.minSizeFP=this.minSizeFP.substring(0,(this.minSizeFP).length-1);this.minSizeFP=parseFloat(this.minSizeFP);this.minSizeSP=this.minSizeSP.substring(0,(this.minSizeSP).length-1);this.minSizeSP=parseFloat(this.minSizeSP);this.spOrientation=this.getSplitterOrientation();this.sBarPosition=this.getSplitterPosition();this.sBarPosition=this.sBarPosition.substring(0,this.sBarPosition.length-1);this.sBarPosition=parseFloat(this.sBarPosition);if(sap.ui.getCore().getConfiguration().getTheme()=="sap_hcb"){this.sbSize=6;}else{this.sbSize=4;}this.resizeSplitterElements();var s=q(this.splitterBar).height();if(this.spOrientation==O.Vertical){if(s<=0||s>q(this.splitterDIV).height()){this.fixHeight();}}else{if(s<=0||s!=this.sbSize){this.fixHeight();}}};a.prototype.onresize=function(e){this.resizeSplitterElements();};a.prototype.resizeSplitterElements=function(){var s,b,w,h,d,e;if(this.spOrientation==O.Vertical){w=q(this.splitterDIV).width();if(w==0){w=100;}s=(this.sbSize*100)/w;if(this.sBarPosition>=100||this.sBarPosition+s>100){this.sBarPosition=100-s;d=0;}else{d=100-s-this.sBarPosition;}q(this.firstPane).css("width",this.sBarPosition+"%");q(this.splitterBar).css("width",s+"%");q(this.secondPane).css("width",d+"%");}else{h=q(this.splitterDIV).height();if(h==0){h=100;}b=(this.sbSize*100)/h;if(this.sBarPosition>=100||this.sBarPosition+b>100){this.sBarPosition=100-b;e=0;}else{e=100-b-this.sBarPosition;}q(this.firstPane).css("height",this.sBarPosition+"%");q(this.splitterBar).css("height",b+"%");q(this.secondPane).css("height",e+"%");}this.setProperty("splitterPosition",this.sBarPosition+"%",true);if(q(this.splitterDIV).height()==0&&!this.splitterDIV.style.height){q(this.splitterDIV).css("height","100px");q(this.splitterBar).css("height","100px");}};a.prototype.setSplitterPosition=function(p){if(this.getDomRef()){this.setProperty("splitterPosition",p,true);this._recalculateInternals();}else{this.setProperty("splitterPosition",p);}return this;};a.prototype.setSplitterBarVisible=function(v){if(this.getDomRef()){this.setProperty("splitterBarVisible",v,true);var s=this.getSplitterOrientation()===O.Vertical?"sapUiVertical":"sapUiHorizontal";if(v){q(document.getElementById(this.getId()+"_SB")).removeClass(s+"SplitterBarHidden").addClass(s+"SplitterBar");}else{q(document.getElementById(this.getId()+"_SB")).removeClass(s+"SplitterBar").addClass(s+"SplitterBarHidden");}}else{this.setProperty("splitterBarVisible",v);}return this;};a.prototype.fixHeight=function(){var p=q(this.splitterDIV.parentNode).height();var s=q(this.splitterDIV).height();if(p>s){s=p;var b=this.getHeight();if(b&&b.toLowerCase().indexOf("px")!=-1){s=parseInt(b);}if(b&&b.toLowerCase().indexOf("%")!=-1){var d=parseInt(b);if(d<100){s=q(this.splitterDIV).height();}}if(s<=0){s=p;}}q(this.splitterDIV).css("height",s+"px");if(this.spOrientation==O.Vertical){q(this.splitterBar).css("height",s+"px");}var o=this.splitterDIV.parentNode;if(o){var h=q.proxy(this.onresizespecial,this);this.sSpecialResizeListenerId=R.register(o,h);}};a.prototype.exit=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}if(this.sSpecialResizeListenerId){R.deregister(this.sSpecialResizeListenerId);this.sSpecialResizeListenerId=null;}};a.prototype.onresizespecial=function(e){var s=q(this.splitterDIV);var o=s.height();s.css("height","0px");var d=this.getDomRef();if(d&&window.getComputedStyle){window.getComputedStyle(d);}var p=q(e.target).height();var b=s.height();if(b!=p){s.css("height",p+"px");if(this.spOrientation==O.Vertical){q(this.splitterBar).css("height",p+"px");}}if(p<=0){s.css("height",o+"px");if(this.spOrientation==O.Vertical){q(this.splitterBar).css("height",o+"px");}}};a.prototype.onmousedown=function(e){if(e.target!=this.splitterBar){return;}var j=q(document.body);j.bind("selectstart",q.proxy(this.splitterSelectStart,this));var o=q(this.splitterBar).offset();var h=q(this.splitterBar).height();var w=q(this.splitterBar).width();var b;if(this.spOrientation==O.Vertical){b="sapUiVSBGhost";}else{b="sapUiHSBGhost";}var z=P.getLastZIndex()+5;if(z<20){z=20;}q(document.body).append("<div id=\""+this.getId()+"_ghost\" class=\""+b+"\" style =\" height:"+h+"px; width:"+w+"px; left:"+o.left+"px; top:"+o.top+"px;z-index:"+z+"\"></div>");q(document.body).append("<div id=\""+this.getId()+"_overlay\" style =\"left: 0px;"+" right: 0px; bottom: 0px; top: 0px; position:fixed; z-index:"+z+"\" ></div>");q(document).bind("mouseup",q.proxy(this.onGhostMouseRelease,this));q(document).bind("mousemove",q.proxy(this.onGhostMouseMove,this));q(this.splitterBar).focus();e.preventDefault();e.stopPropagation();};a.prototype.splitterSelectStart=function(e){e.preventDefault();e.stopPropagation();return false;};a.prototype.onGhostMouseRelease=function(e){var n,s,b;var d=document.getElementById(this.getId()+"_ghost");var r=sap.ui.getCore().getConfiguration().getRTL();if(this.spOrientation==O.Vertical){if(!r){n=e.pageX-q(this.firstPane).offset().left;b=q(this.splitterDIV).width();n=(n*100)/b;}else{n=e.pageX-q(this.secondPane).offset().left;b=q(this.splitterDIV).width();n=((b-n)*100)/b;}}else{n=e.pageY-q(this.firstPane).offset().top;s=q(this.splitterDIV).height();n=(n*100)/s;}if(n<this.minSizeFP){n=this.minSizeFP;}else if((100-n)<this.minSizeSP){n=100-this.minSizeSP;}this.sBarPosition=n;this.resizeSplitterElements();q(d).remove();q(document.getElementById(this.getId()+"_overlay")).remove();var j=q(document.body);j.unbind("selectstart",this.splitterSelectStart);q(document).unbind("mouseup",this.onGhostMouseRelease);q(document).unbind("mousemove",this.onGhostMouseMove);};a.prototype.onGhostMouseMove=function(e){var s=document.getElementById(this.getId()+"_ghost");var m;var b;var r=sap.ui.getCore().getConfiguration().getRTL();var d=q(this.firstPane).offset().left;var w=q(this.splitterDIV).width();var f=q(this.secondPane).offset().left;if(this.getSplitterOrientation()==O.Vertical){if(!r){b=d+(w*this.minSizeFP)/100;m=d+(w*(100-this.minSizeSP))/100;if(e.pageX>b&&e.pageX<m){q(s).css("left",e.pageX+"px");}}else{b=f+(w*this.minSizeSP)/100;m=f+(w*(100-this.minSizeFP))/100;if(e.pageX>b&&e.pageX<m){q(s).css("left",e.pageX+"px");}}}else{var h=q(this.splitterDIV).height();b=q(this.firstPane).offset().top+(h*this.minSizeFP)/100;m=q(this.secondPane).offset().top+q(this.secondPane).height()-(h*this.minSizeSP)/100;if(e.pageY>b&&e.pageY<m){q(s).css("top",e.pageY+"px");}}};a.prototype.getCtrlKey=function(e){return!!(e.ctrlKey||e.metaKey);};a.prototype.checkModifierKey=function(e,b,A,s){return e.shiftKey==s&&e.altKey==A&&this.getCtrlKey(e)==b;};a.prototype.onsaphome=function(e){if(e.target==this.splitterBar){this.sBarPosition=this.minSizeFP;this.resizeSplitterElements();e.preventDefault();e.stopPropagation();}};a.prototype.onsapend=function(e){if(e.target==this.splitterBar){this.sBarPosition=100-this.minSizeSP;this.resizeSplitterElements();e.preventDefault();e.stopPropagation();}};a.prototype.onArrowKeys=function(e,i){var w,h,s,b,n;if(this.spOrientation==O.Vertical){w=q(this.splitterDIV).width();b=q(this.firstPane).width();b=(b*100)/w;s=(10*100)/w;}else{h=q(this.splitterDIV).height();b=q(this.firstPane).height();b=(b*100)/h;s=(10*100)/h;}if(i=="false"){n=b-s;}else if(i=="true"){n=b+s;}if(n<this.minSizeFP){n=this.minSizeFP;}else if((100-n)<this.minSizeSP){n=100-this.minSizeSP;}this.sBarPosition=n;this.resizeSplitterElements();};a.prototype.onsapupmodifiers=function(e){if(this.checkModifierKey(e,false,false,true)){if(e.target==this.splitterBar){if(this.spOrientation==O.Horizontal){this.onArrowKeys(e,"false");}else{this.onsapleftmodifiers(e);}}e.preventDefault();e.stopPropagation();}};a.prototype.onsapdownmodifiers=function(e){if(this.checkModifierKey(e,false,false,true)){if(e.target==this.splitterBar){if(this.spOrientation==O.Horizontal){this.onArrowKeys(e,"true");}else{this.onsaprightmodifiers(e);}}e.preventDefault();e.stopPropagation();}};a.prototype.onsapleftmodifiers=function(e){if(this.checkModifierKey(e,false,false,true)){if(e.target==this.splitterBar){if(this.spOrientation==O.Vertical){var r=sap.ui.getCore().getConfiguration().getRTL();if(r){this.onArrowKeys(e,"true");}else{this.onArrowKeys(e,"false");}}else{this.onsapupmodifiers(e);}}e.preventDefault();e.stopPropagation();}};a.prototype.onsaprightmodifiers=function(e){if(this.checkModifierKey(e,false,false,true)){if(e.target==this.splitterBar){if(this.spOrientation==O.Vertical){var r=sap.ui.getCore().getConfiguration().getRTL();if(r){this.onArrowKeys(e,"false");}else{this.onArrowKeys(e,"true");}}else{this.onsapdownmodifiers(e);}}e.preventDefault();e.stopPropagation();}};a.prototype.ondragstart=function(e){if(e.target!=this.splitterBar){return;}e.preventDefault();e.stopPropagation();};a.prototype.getText=function(k,A){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(r){return r.getText(k,A);}return k;};return a;});
