/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/base/EventProvider','sap/ui/base/ManagedObject','sap/ui/model/message/MessageModel','./Message','./ControlMessageProcessor','sap/ui/core/message/MessageProcessor',"sap/base/util/deepEqual","sap/base/Log"],function(q,E,M,c,d,C,e,f,L){"use strict";var g=E.extend("sap.ui.core.message.MessageManager",{constructor:function(){E.apply(this,arguments);this.mProcessors={};this.mObjects={};this.mMessages={};var h=sap.ui.getCore().getConfiguration().getHandleValidation();if(h){sap.ui.getCore().attachValidationSuccess(h,this._handleSuccess,this);sap.ui.getCore().attachValidationError(h,this._handleError,this);sap.ui.getCore().attachParseError(h,this._handleError,this);sap.ui.getCore().attachFormatError(h,this._handleError,this);}},metadata:{publicMethods:["addMessages","removeMessages","removeAllMessages","registerMessageProcessor","unregisterMessageProcessor","registerObject","unregisterObject","getMessageModel","destroy"]}});g.prototype._handleError=function(o,h){if(!this.oControlMessageProcessor){this.oControlMessageProcessor=new C();}if(h){var a=o.getParameter("element");var p=o.getParameter("property");var t=a.getId()+'/'+p;var P=this.oControlMessageProcessor.getId();var T=o.sId==="formatError";if(this.mMessages[P]&&this.mMessages[P][t]){this._removeMessages(this.mMessages[P][t],true);}var r={};r[a.getId()]={properties:{},fieldGroupIds:a.getFieldGroupIds?a.getFieldGroupIds():undefined};r[a.getId()].properties[p]=true;var m=new d({type:sap.ui.core.MessageType.Error,message:o.getParameter("message"),target:t,processor:this.oControlMessageProcessor,technical:T,references:r,validation:true});this.addMessages(m);}o.cancelBubble();};g.prototype._handleSuccess=function(o,h){if(!this.oControlMessageProcessor){this.oControlMessageProcessor=new C();}if(h){var a=o.getParameter("element");var p=o.getParameter("property");var t=a.getId()+'/'+p;var P=this.oControlMessageProcessor.getId();if(this.mMessages[P]&&this.mMessages[P][t]){this._removeMessages(this.mMessages[P][t],true);}}o.cancelBubble();};g.prototype.addMessages=function(m){var o=m,p=this.getAffectedProcessors(m);if(!m){return;}else if(Array.isArray(m)){for(var i=0;i<m.length;i++){o=m[i];this._importMessage(o);}}else{this._importMessage(m);}this._updateMessageModel(p);};g.prototype._importMessage=function(m){var s=m.getTarget(),p=m.getMessageProcessor(),P=p&&p.getId();if(!this.mMessages[P]){this.mMessages[P]={};}var a=this.mMessages[P][s]?this.mMessages[P][s]:[];a.push(m);this.mMessages[P][s]=a;};g.prototype._pushMessages=function(p){var t=this;q.each(p,function(i,P){var m=t.mMessages[i]?t.mMessages[i]:{};t._sortMessages(m);m=Object.keys(m).length===0?null:q.extend(true,{},m);P.setMessages(m);});};g.prototype._sortMessages=function(m){var s={'Error':0,'Warning':1,'Success':2,'Information':3};if(Array.isArray(m)){m={"ignored":m};}q.each(m,function(t,h){if(h.length>0){h.sort(function(a,b){return s[a.type]-s[b.type];});}});};g.prototype._updateMessageModel=function(p){var m=[],o=this.getMessageModel();q.each(this.mMessages,function(P,a){q.each(a,function(k,v){m=q.merge(m,v);});});this._pushMessages(p);o.setData(m);};g.prototype.removeAllMessages=function(){var p={};for(var P in this.mMessages){var F=Object.keys(this.mMessages[P])[0];var m=this.mMessages[P][F];q.extend(p,this.getAffectedProcessors(m));}this.aMessages=[];this.mMessages={};this._updateMessageModel(p);};g.prototype.removeMessages=function(m){return this._removeMessages.apply(this,arguments);};g.prototype._removeMessages=function(m,o){var t=this,p=this.getAffectedProcessors(m);if(!m||(Array.isArray(m)&&m.length==0)){return;}else if(Array.isArray(m)){var O=m.slice(0);for(var i=0;i<O.length;i++){if(!o||O[i].validation){t._removeMessage(O[i]);}}}else if(m instanceof d&&(!o||m.validation)){t._removeMessage(m);}else{q.each(m,function(T,a){t._removeMessages(a,o);});}this._updateMessageModel(p);};g.prototype._removeMessage=function(m){var p=m.getMessageProcessor(),P=p&&p.getId(),a=this.mMessages[P];if(!a){return;}var b=a[m.getTarget()];if(b){for(var i=0;i<b.length;i++){var o=b[i];if(f(o,m)){b.splice(i,1);--i;}}if(a[m.getTarget()].length===0){delete a[m.getTarget()];}}};g.prototype.onMessageChange=function(o){var O=o.getParameter('oldMessages');var n=o.getParameter('newMessages');this.removeMessages(O);this.addMessages(n);};g.prototype.registerMessageProcessor=function(p){var P=p.getId(),m={};if(!this.mProcessors[P]){this.mProcessors[P]=P;p.attachMessageChange(this.onMessageChange,this);if(P in this.mMessages){m[P]=p;this._pushMessages(m);}}};g.prototype.unregisterMessageProcessor=function(p){this.removeMessagesByProcessor(p.getId());delete this.mProcessors[p.getId()];p.detachMessageChange(this.onMessageChange,this);};g.prototype.registerObject=function(o,h){if(!o instanceof M){L.error(this+" : "+o.toString()+" is not an instance of sap.ui.base.ManagedObject");return;}o.attachValidationSuccess(h,this._handleSuccess,this);o.attachValidationError(h,this._handleError,this);o.attachParseError(h,this._handleError,this);o.attachFormatError(h,this._handleError,this);};g.prototype.unregisterObject=function(o){if(!o instanceof M){L.error(this+" : "+o.toString()+" is not an instance of sap.ui.base.ManagedObject");return;}o.detachValidationSuccess(this._handleSuccess);o.detachValidationError(this._handleError);o.detachParseError(this._handleError);o.detachFormatError(this._handleError);};g.prototype.destroy=function(){L.warning("Deprecated: Do not call destroy on a MessageManager");};g.prototype.getMessageModel=function(){if(!this.oMessageModel){this.oMessageModel=new c(this);this.oMessageModel.setData([]);}return this.oMessageModel;};g.prototype.getAffectedProcessors=function(m){var p,P,a={};if(m){if(!Array.isArray(m)){m=[m];}m.forEach(function(o){p=o.getMessageProcessor();if(p instanceof e){P=p.getId();a[P]=p;}});}return a;};g.prototype.removeMessagesByProcessor=function(p){delete this.mMessages[p];this._updateMessageModel({});};return g;});
