/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/model/json/JSONModel","sap/ui/thirdparty/URI"],function(q,B,C,J,U){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Code",{_aMockFiles:["products.json","supplier.json","img.json"],onInit:function(){this.oModel=new J();this.getView().setModel(this.oModel);this.router=this.getRouter();this.router.getRoute("code").attachPatternMatched(this.onRouteMatched,this);this.router.getRoute("codeFile").attachPatternMatched(this.onRouteMatched,this);this._codeCache={};this._aFilesAvailable=[];this._bFirstLoad=true;},onRouteMatched:function(e){var a=e.getParameter("arguments");this.showMasterSide();this._sId=a.sampleId;this._sEntityId=a.entityId;this._sFileName=decodeURIComponent(a.fileName);C.loadData().then(this._loadCode.bind(this));},_loadCode:function(d){var f=this._sFileName,s=d.samples[this._sId];if(!s||(s.contexts&&!s.contexts[this._sEntityId])){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}if(!this._oData||s.id!==this._oData.id){var c='sampleComp-'+this._sId;var a=this._sId;var o=sap.ui.component(c);if(!o){o=sap.ui.getCore().createComponent({id:c,name:a});}var m=o.getMetadata();var b=(m)?m.getConfig():null;this._oData={id:s.id,title:"Code: "+s.name,name:s.name,stretch:b.sample?b.sample.stretch:false,files:[],iframe:b.sample.iframe,fileName:f,includeInDownload:b.sample.additionalDownloadFiles};if(b&&b.sample&&b.sample.files){var r=sap.ui.require.toUrl((s.id).replace(/\./g,"/"));for(var i=0;i<b.sample.files.length;i++){var F=b.sample.files[i];var e=this.fetchSourceFile(r,F);this._oData.files.push({name:F,raw:e,code:this._convertCodeToHtml(e)});this._aFilesAvailable.push(F);}}}else{this._oData.fileName=f;}this.entityId=s.entityId;this.getAPIReferenceCheckPromise(s.entityId).then(function(h){this.getView().byId("apiRefButton").setVisible(h);}.bind(this));this.oModel.setData(this._oData);if(f==="undefined"){f=this._getInitialFileName();}if(this._aFilesAvailable.indexOf(f)===-1){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}this._updateCodeEditor(f);this._getTabHeader().setSelectedKey(f);var p=this.byId("page");p.scrollTo(0);},fetchSourceFile:function(r,f){var t=this;var u=r+"/"+f;var s=function(a){t._codeCache[u]=a;};var e=function(a){t._codeCache[u]="not found: '"+u+"'";};if(!(u in this._codeCache)){this._codeCache[u]="";q.ajax(u,{async:false,dataType:"text",success:s,error:e});}return t._codeCache[u];},onDownload:function(){sap.ui.require(["sap/ui/thirdparty/jszip","sap/ui/core/util/File"],function(a,F){var z=new a();var d=this.oModel.getData();for(var i=0;i<d.files.length;i++){var f=d.files[i],r=f.raw;if(f.name&&(f.name===d.iframe||f.name.split(".").pop()==="html")){r=this._changeIframeBootstrapToCloud(r);}z.file(f.name,r);for(var j=0;j<this._aMockFiles.length;j++){var m=this._aMockFiles[j];if(f.raw.indexOf(m)>-1){z.file("mockdata/"+m,this.downloadMockFile(m));}}}var R=sap.ui.require.toUrl((this._sId).replace(/\./g,"/")),e=d.includeInDownload||[],t=this,h;if(!d.iframe){d.files.forEach(function(f){h=f.name==="manifest.json";return;});z.file("Component.js",this.fetchSourceFile(R,"Component.js"));z.file("index.html",this._changeIframeBootstrapToCloud(this._createIndexHtmlFile(d,h)));if(!h){z.file("index.js",this._changeIframeBootstrapToCloud(this._createIndexJsFile(d)));}}e.forEach(function(s){z.file(s,t.fetchSourceFile(R,s));});
// add generic license and notice file
z.file("LICENSE.txt",this.fetchSourceFile(sap.ui.require.toUrl("sap/ui/documentation/sdk/tmpl/"),"LICENSE.txt"));z.file("NOTICE.txt",this.fetchSourceFile(sap.ui.require.toUrl("sap/ui/documentation/sdk/tmpl/"),"NOTICE.txt"));var c=z.generate({type:"blob"});F.save(c,this._sId,"zip","application/zip");}.bind(this));},_createIndexHtmlFile:function(d,h){var r=sap.ui.require.toUrl("sap/ui/documentation/sdk/tmpl"),f;f=this.fetchSourceFile(r,h?"indexevo.html.tmpl":"index.html.tmpl");f=f.replace(/{{TITLE}}/g,d.name).replace(/{{SAMPLE_ID}}/g,d.id);return f;},_createIndexJsFile:function(d){var r=sap.ui.require.toUrl("sap/ui/documentation/sdk/tmpl"),f=this.fetchSourceFile(r,"index.js.tmpl");f=f.replace(/{{TITLE}}/g,d.name).replace(/{{SAMPLE_ID}}/g,d.id).replace(/{{HEIGHT}}/g,d.stretch?'height : "100%", ':"").replace(/{{SCROLLING}}/g,!d.stretch);return f;},downloadMockFile:function(f){var r=sap.ui.require.toUrl("sap/ui/demo/mock");var w="test-resources/sap/ui/documentation/sdk/images/";var c="https://openui5.hana.ondemand.com/test-resources/sap/ui/documentation/sdk/images/";var R=new RegExp(w,"g");var m=this.fetchSourceFile(r,f);if(m){m=m.replace(R,c);}return m;},onAPIRefPress:function(){this.getRouter().navTo("apiId",{id:this.entityId});},onNavBack:function(){this.router.navTo("sample",{sampleId:this._sId,entityId:this._sEntityId},true);},_convertCodeToHtml:function(c){c=c.toString();c=c.replace(/^function.+{/,"");c=c.replace(/}[!}]*$/,"");c=c.replace(/^[\n\s\S]*\/\/\s*CODESNIP_START\n/,"");c=c.replace(/\/\/\s*CODESNIP_END[\n\s\S]*$/,"");c=c.replace(/\t/g,"  ");return c;},_changeIframeBootstrapToCloud:function(r){var a=/src=(?:"[^"]*\/sap-ui-core\.js"|'[^']*\/sap-ui-core\.js')/;var c=new U(window.location.href).search("");var R=new U(sap.ui.require.toUrl("")+"/sap-ui-core.js");var b=R.absoluteTo(c).toString();return r.replace(a,'src="'+b+'"');},handleTabSelectEvent:function(e){var f=e.getParameter("selectedKey");this._bFirstLoad=false;this.router.navTo("codeFile",{entityId:this._sEntityId,sampleId:this._sId,fileName:encodeURIComponent(f)},false);},_updateCodeEditor:function(f){var c=this._getCodeEditor(),a=c._getEditorInstance(),A=a.renderer;c.setValue(this._getCode(f));c.setType(this._getFileType(f));a.gotoLine(0,0,false);if(this._bFirstLoad){setTimeout(function(){A.onResize();},0);}},_getCode:function(f){var F=this.getModel().getData().files,c="";F.forEach(function(o){if(o.name===f){c=o.raw;return true;}});return c;},_getFileType:function(f){var F=f.split('.').pop();return F==="js"?"javascript":F;},_getInitialFileName:function(){return(this._oData&&this._oData.files&&this._oData.files.length>0&&this._oData.files[0].name)||null;},_getCodeEditor:function(){if(!this.oCodeEditor){this.oCodeEditor=this.byId("codeEditor");}return this.oCodeEditor;},_getTabHeader:function(){if(!this.oTabHeader){this.oTabHeader=this.byId("tabHeader");}return this.oTabHeader;}});});
