/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/dt/Overlay","sap/ui/dt/ControlObserver","sap/ui/dt/ManagedObjectObserver","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/dt/Util","sap/ui/core/Control","sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/merge"],function(O,C,M,E,a,D,U,b,q,L,i,m){"use strict";var S='sapUiDtOverlayScrollContainer';var c=O.extend("sap.ui.dt.ElementOverlay",{metadata:{library:"sap.ui.dt",associations:{editableByPlugins:{type:"any[]",multiple:true,singularName:"editableByPlugin"}},properties:{selected:{type:"boolean",defaultValue:false},selectable:{type:"boolean",defaultValue:false},movable:{type:"boolean",defaultValue:false},editable:{type:"boolean",defaultValue:false},relevantOverlays:{type:"any[]",defaultValue:[]},metadataScope:{type:"string"}},events:{selectionChange:{parameters:{selected:{type:"boolean"}}},movableChange:{parameters:{movable:{type:"boolean"}}},selectableChange:{parameters:{selectable:{type:"boolean"}}},editableChange:{parameters:{editable:{type:"boolean"}}},elementModified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},elementDestroyed:{parameters:{targetId:"string"}}}},constructor:function(){this._aMetadataEnhancers=[];O.apply(this,arguments);}});c.prototype.asyncInit=function(){return(this.getDesignTimeMetadata()?Promise.resolve():this._loadDesignTimeMetadata()).then(function(){this.attachEvent("elementModified",function(e){var p=e.getParameters();var n=p.name;if(p.type==="propertyChanged"){if(n==="visible"){this.setRelevantOverlays([]);}}else if(n){this.setRelevantOverlays([]);}},this);this._initMutationObserver();this._initControlObserver();}.bind(this));};c.prototype._initMutationObserver=function(){if(this.isRoot()){this._subscribeToMutationObserver();}this.attachEvent('isRootChanged',function(e){if(e.getParameter('value')){this._subscribeToMutationObserver();}else{this._unsubscribeFromMutationObserver();}},this);};c.prototype._subscribeToMutationObserver=function(){var o=O.getMutationObserver();var d=this.getAssociatedDomRef();this._sObservableNodeId=d&&d.get(0).id;if(this._sObservableNodeId){o.addToWhiteList(this._sObservableNodeId);o.attachDomChanged(this._onDomChanged,this);}else{throw U.createError('ElementOverlay#_subscribeToMutationObserver','Please provide a root control with proper domRef and id to ensure that DesignTime is working properly');}};c.prototype._unsubscribeFromMutationObserver=function(){if(this._sObservableNodeId){var o=O.getMutationObserver();o.removeFromWhiteList(this._sObservableNodeId);o.detachDomChanged(this._onDomChanged,this);delete this._sObservableNodeId;}};c.prototype._initControlObserver=function(){if(this.getElement()instanceof b){this._oObserver=new C({target:this.getElement(),aggregations:this.getAggregationNames()});}else{this._oObserver=new M({target:this.getElement(),aggregations:this.getAggregationNames()});}this._oObserver.attachModified(this._onElementModified,this);this._oObserver.attachDestroyed(this._onElementDestroyed,this);};c.prototype._destroyControlObserver=function(){if(this._oObserver){this._oObserver.destroy();}};c.prototype._getAttributes=function(){return m({},O.prototype._getAttributes.apply(this,arguments),{"data-sap-ui-dt-for":this.getElement().getId(),draggable:this.getMovable()});};c.prototype.render=function(){this.addStyleClass('sapUiDtElementOverlay');return O.prototype.render.apply(this,arguments);};c.prototype.exit=function(){if(this.isRoot()){this._unsubscribeFromMutationObserver();}this._destroyControlObserver();if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}O.prototype.exit.apply(this,arguments);};c.prototype._loadDesignTimeMetadata=function(){return this.getElement().getMetadata().loadDesignTime(this.getElement(),this.getMetadataScope()).then(function(d){var e=this.getElement();if(!e||e.bIsDestroyed){throw U.createError("ElementOverlay#loadDesignTimeMetadata","Can't set metadata to overlay which element has been destroyed already");}this.setDesignTimeMetadata(d);}.bind(this)).catch(function(e){throw U.propagateError(e,"ElementOverlay#loadDesignTimeMetadata",U.printf("Can't load designtime metadata data for overlay with id='{1}', element id='{2}': {3}",this.getId(),this.getAssociation('element'),U.wrapError(e).message));}.bind(this));};c.prototype._setPosition=function(t,g,p,f){O.prototype._setPosition.apply(this,arguments);this.getScrollContainers().forEach(function(s,I){var $=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),s.domRef)||q();var d=this.getScrollContainerById(I);if($.length){var o=$.get(0);var e=D.getGeometry(o);this._setSize(d,e);O.prototype._setPosition.call(this,d,e,this.$());this._handleOverflowScroll(e,d,this,f);this._setZIndex(e,d);}else{d.css("display","none");}},this);};c.prototype._applySizes=function(){var p=this.getChildren().filter(function(o){return o.isRendered();}).map(function(o){return new Promise(function(r){o.attachEventOnce('geometryChanged',r);});});O.prototype._applySizes.apply(this,arguments);Promise.all(p).then(function(){this._sortChildren(this.getChildrenDomRef());if(!this.bIsDestroyed){this.getScrollContainers().forEach(function(s,I){var $=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),s.domRef)||q();var d=this.getScrollContainerById(I);if($.length){this._sortChildren(d.get(0));}},this);}}.bind(this));};c.prototype._sortChildren=function(o){var f=function(g,h){var G=D.getGeometry(g);var j=D.getGeometry(h);var p=G&&G.position;var P=j&&j.position;if(p&&P){var B=p.top+G.size.height;var k=P.top+j.size.height;if(p.top<P.top){if(B>=k&&P.left<p.left){return 1;}return-1;}else if(p.top===P.top){if(p.left===P.left){if(G.size.height<j.size.height||G.size.width<j.size.width){return-1;}else if(G.size.height>j.size.height||G.size.width>j.size.width){return 1;}return 0;}else if(p.left<P.left){return-1;}return 1;}else if(B<=k&&P.left>p.left){return-1;}return 1;}return 0;};var d=q(o).find('>:not(.sapUiDtDummyScrollContainer)').toArray();var s=d.slice().sort(f);var e=d.some(function(g,I){return g!==s[I];});if(e){s.forEach(function(g){D.appendChild(o,g);});}};c.prototype.placeInOverlayContainer=function(){if(this._bInit){if(this.isRoot()){if(!this.isRendered()){O.getOverlayContainer().append(this.render());this.applyStyles();}else{L.error('sap.ui.dt.ElementOverlay: overlay is already rendered and can\'t be placed in overlay container. Isn\'t it already there?');}}else{L.error('sap.ui.dt.ElementOverlay: it\'s not possible to place overlay inside overlay container while it\'s part of some hierarchy');}}else{L.error('sap.ui.dt.ElementOverlay: overlay is not ready yet. Please wait until "init" event happens');}};c.prototype.setDesignTimeMetadata=function(d){var o=this.getDesignTimeMetadata();var e;if(q.isFunction(d)){if(!o){this._aMetadataEnhancers=this._aMetadataEnhancers.concat(d);}else{o.setData(d(m({},o.getData())));return;}}else if(d instanceof E){o=d;}else if(i(d)){e=d;var f;while(f=this._aMetadataEnhancers.shift()){e=f.call(this,e);}o=new E({data:e});}if(o){O.prototype.setDesignTimeMetadata.call(this,o);}};c.prototype.getScrollContainers=function(){return this.getDesignTimeMetadata().getScrollContainers(this.getElement());};c.prototype._renderChildren=function(){var d=O.prototype._renderChildren.apply(this,arguments);this.getScrollContainers().forEach(function(s,I){var $=q("<div/>",{"class":S,"data-sap-ui-dt-scrollContainerIndex":I});if(s.aggregations){U.intersection(s.aggregations,this.getAggregationNames()).forEach(function(A){var o=this.getAggregationOverlay(A);var e=d.indexOf(o.$());o.setScrollContainerId(I);$.append(d[e]);d.splice(e,1);},this);}d.push($);},this);return d;};c.prototype.getScrollContainerById=function(I){return q(this.getChildrenDomRef()).find('>.'+S+'[data-sap-ui-dt-scrollcontainerindex="'+I+'"]');};c.prototype.getAssociatedDomRef=function(){var d=this.getDesignTimeMetadata();var v=d.getDomRef();var o=d.getAssociatedDomRef(this.getElement(),v);if(!o){o=a.getDomRef(this.getElement());}if(o){return q(o);}return undefined;};c.prototype.setSelectable=function(s){s=!!s;if(s!==this.isSelectable()){if(!s){this.setSelected(false);}this.toggleStyleClass("sapUiDtOverlaySelectable",s);this.setProperty("selectable",s);this.fireSelectableChange({selectable:s});}this.setFocusable(s);return this;};c.prototype.setSelected=function(s){s=!!s;if(this.isSelectable()&&s!==this.isSelected()){this.setProperty("selected",s);this.toggleStyleClass("sapUiDtOverlaySelected",s);this.fireSelectionChange({selected:s});}return this;};c.prototype.setMovable=function(d){d=!!d;if(this.getMovable()!==d){this.toggleStyleClass("sapUiDtOverlayMovable",d);this.setProperty("movable",d);this.fireMovableChange({movable:d});this.$()[d?'attr':'removeAttr']('draggable',d);}return this;};c.prototype.setEditable=function(e){e=!!e;if(this.getEditable()!==e){this.toggleStyleClass("sapUiDtOverlayEditable",e);this.setProperty("editable",e);this.fireEditableChange({editable:e});}return this;};c.prototype.getAggregationNames=function(){var e=this.getElement();var d=this.getDesignTimeMetadata();var A=e.getMetadata().getAllAggregations();return[].concat(Object.keys(A),Object.keys(d.getAggregations())).filter(function(s,I,f){return(I===f.indexOf(s)&&!d.isAggregationIgnored(e,s));});};c.prototype._onChildAdded=function(e){var A=e.getSource();if(this.isRendered()&&!A.isRendered()){var t=(U.isInteger(A.getScrollContainerId())?this.getScrollContainerById(A.getScrollContainerId()):q(this.getChildrenDomRef()));t.append(A.render());}};c.prototype.addChild=function(A){A.detachChildAdded(this._onChildAdded,this);A.attachChildAdded(this._onChildAdded,this);O.prototype.addChild.apply(this,arguments);};c.prototype._onElementModified=function(e){this.fireElementModified(e.getParameters());};c.prototype._onDomChanged=function(){if(this.isReady()&&this.isRoot()){if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}this._iApplyStylesRequest=window.requestAnimationFrame(function(){this.applyStyles();delete this._iApplyStylesRequest;}.bind(this));}};c.prototype._onElementDestroyed=function(e){var s=e.getSource().getTarget();this.fireElementDestroyed({targetId:s});if(this._bInit){this.destroy();}else{this._bShouldBeDestroyed=true;}};c.prototype.getAggregationOverlays=function(){return this.getAggregation("children")||[];};c.prototype.getAggregationOverlay=function(A){return this.getChildren().filter(function(o){return o.getAggregationName()===A;}).pop();};c.prototype.getParentElementOverlay=function(){var p=this.getParentAggregationOverlay();if(p){return p.getParent();}};c.prototype.getParentAggregationOverlay=function(){var p=this.getParent();return p instanceof sap.ui.dt.AggregationOverlay?p:null;};c.prototype.isSelected=function(){return this.getSelected();};c.prototype.isSelectable=function(){return this.getSelectable();};c.prototype.isMovable=function(){return this.getMovable();};c.prototype.isEditable=function(){return this.getEditable();};c.prototype._getElementInstanceVisible=function(){var e=this.getElement();if(e){var g=this.getGeometry();return g&&g.visible;}return false;};c.prototype.getElementVisibility=function(){var e=this.getElement();if(e instanceof sap.ui.core.Control){return e.getVisible();}var d=this.getDesignTimeMetadata();var f=d&&d.getData().isVisible;if(!f){return undefined;}return f(this.getElement());};c.prototype.isElementVisible=function(){var e=this.getElement();var v=false;var d=this.getDesignTimeMetadata();var o=d.getData();if(d.isIgnored(e)){v=false;}else if(typeof o.isVisible==="function"){v=o.isVisible(e);}else{var g=this.getGeometry(true);if(g){v=g.visible;}else if(e instanceof b){v=!!e.getDomRef()&&e.getVisible();}}return v;};c.prototype.isVisible=function(){return(O.prototype.isVisible.apply(this,arguments)&&this.isElementVisible());};c.prototype.getRelevantContainer=function(f){var d=this.getDesignTimeMetadata();if(d&&d.getData().relevantContainer){return d.getData().relevantContainer;}else if(f){return this.getElement();}var p=this.getParentElementOverlay();return p?p.getElement():undefined;};c.prototype._hasSameSize=function(s,t){var d=this.getScrollContainers();var e;if(d.length){e=U.max(d.map(function(f,I){var g=D.getGeometry(this.getScrollContainerById(I).get(0));return g.size[t];},this));}else{e=this.getGeometry().size[t];}return s.size[t]===e;};return c;},true);
