/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ValueListType","./lib/_Helper","sap/base/assert","sap/base/Log","sap/base/util/ObjectPath","sap/ui/base/SyncPromise","sap/ui/model/BindingMode","sap/ui/model/ChangeReason","sap/ui/model/ClientListBinding","sap/ui/model/Context","sap/ui/model/ContextBinding","sap/ui/model/MetaModel","sap/ui/model/PropertyBinding","sap/ui/model/odata/OperationMode","sap/ui/model/odata/type/Boolean","sap/ui/model/odata/type/Byte","sap/ui/model/odata/type/Date","sap/ui/model/odata/type/DateTimeOffset","sap/ui/model/odata/type/Decimal","sap/ui/model/odata/type/Double","sap/ui/model/odata/type/Guid","sap/ui/model/odata/type/Int16","sap/ui/model/odata/type/Int32","sap/ui/model/odata/type/Int64","sap/ui/model/odata/type/Raw","sap/ui/model/odata/type/SByte","sap/ui/model/odata/type/Single","sap/ui/model/odata/type/Stream","sap/ui/model/odata/type/String","sap/ui/model/odata/type/TimeOfDay","sap/ui/thirdparty/jquery","sap/ui/thirdparty/URI"],function(V,_,a,L,O,S,B,C,b,c,d,M,P,f,g,h,E,D,j,k,G,I,l,m,R,p,q,r,s,T,Q,U){"use strict";var t,u=new Map(),v=L.Level.DEBUG,w=/^-?\d+$/,x,y,z="sap.ui.model.odata.v4.ODataMetaModel",A,F=new R(),H=new Map(),J={messageChange:true},K={"Edm.Boolean":{Type:g},"Edm.Byte":{Type:h},"Edm.Date":{Type:E},"Edm.DateTimeOffset":{constraints:{"$Precision":"precision"},Type:D},"Edm.Decimal":{constraints:{"@Org.OData.Validation.V1.Minimum/$Decimal":"minimum","@Org.OData.Validation.V1.Minimum@Org.OData.Validation.V1.Exclusive":"minimumExclusive","@Org.OData.Validation.V1.Maximum/$Decimal":"maximum","@Org.OData.Validation.V1.Maximum@Org.OData.Validation.V1.Exclusive":"maximumExclusive","$Precision":"precision","$Scale":"scale"},Type:j},"Edm.Double":{Type:k},"Edm.Guid":{Type:G},"Edm.Int16":{Type:I},"Edm.Int32":{Type:l},"Edm.Int64":{Type:m},"Edm.SByte":{Type:p},"Edm.Single":{Type:q},"Edm.Stream":{Type:r},"Edm.String":{constraints:{"@com.sap.vocabularies.Common.v1.IsDigitSequence":"isDigitSequence","$MaxLength":"maxLength"},Type:s},"Edm.TimeOfDay":{constraints:{"$Precision":"precision"},Type:T}},N={},W="@com.sap.vocabularies.Common.v1.ValueList",X="@com.sap.vocabularies.Common.v1.ValueListMapping",Y="@com.sap.vocabularies.Common.v1.ValueListReferences",Z="@com.sap.vocabularies.Common.v1.ValueListWithFixedValues",$=L.Level.WARNING;function a1(o,e,i,n){var j1,k1=o.mSchema2MetadataUrl[e];if(!k1){k1=o.mSchema2MetadataUrl[e]={};k1[i]=false;}else if(!(i in k1)){j1=Object.keys(k1)[0];if(k1[j1]){g1(o,"A schema cannot span more than one document: "+e+" - expected reference URI "+j1+" but instead saw "+i,n);}k1[i]=false;}}function b1(o,e,i,n){var j1,k1,l1,m1;function n1(o1){var p1,q1;if(!(i in o1)){n($,k1," does not contain ",i);return;}n(v,"Including ",i," from ",k1);for(q1 in o1){if(q1[0]!=="$"&&h1(q1)===i){p1=o1[q1];e[q1]=p1;f1(p1,e.$Annotations);}}}if(i in e){return e[i];}m1=o.mSchema2MetadataUrl[i];if(m1){l1=Object.keys(m1);if(l1.length>1){g1(o,"A schema cannot span more than one document: "+"schema is referenced by following URLs: "+l1.join(", "),i);}k1=l1[0];m1[k1]=true;n(v,"Namespace ",i," found in $Include of ",k1);j1=o.mMetadataUrl2Promise[k1];if(!j1){n(v,"Reading ",k1);j1=o.mMetadataUrl2Promise[k1]=S.resolve(o.oRequestor.read(k1)).then(o.validate.bind(o,k1));}j1=j1.then(n1);if(i in e){return e[i];}e[i]=j1;return j1;}}function c1(e,i){if(e===i){return"";}if(e.indexOf(i)===0&&e[i.length]==="#"&&e.indexOf("@",i.length)<0){return e.slice(i.length+1);}}function d1(e){var i=c1(e,X);return i!==undefined?i:c1(e,W);}function e1(n,o){return o.some(function(e){return e.$Parameter&&e.$Parameter.some(function(i){return i.$Name===n;});});}function f1(o,e,i){var n;function j1(k1,l1){var m1;for(m1 in l1){if(i||!(m1 in k1)){k1[m1]=l1[m1];}}}for(n in o.$Annotations){if(!(n in e)){e[n]={};}j1(e[n],o.$Annotations[n]);}delete o.$Annotations;}function g1(o,e,i){var n=new Error(i+": "+e);o.oModel.reportError(e,z,n);throw n;}function h1(e){return e.slice(0,e.lastIndexOf(".")+1);}x=d.extend("sap.ui.model.odata.v4.ODataMetaContextBinding",{constructor:function(o,e,i){a(!i||i.getModel()===o,"oContext must belong to this model");d.call(this,o,e,i);},initialize:function(){var e=this.oModel.createBindingContext(this.sPath,this.oContext);this.bInitial=false;if(e!==this.oElementContext){this.oElementContext=e;this._fireChange();}},setContext:function(o){a(!o||o.getModel()===this.oModel,"oContext must belong to this model");if(o!==this.oContext){this.oContext=o;if(!this.bInitial){this.initialize();}}}});y=b.extend("sap.ui.model.odata.v4.ODataMetaListBinding",{constructor:function(){b.apply(this,arguments);},_fireFilter:function(){},_fireSort:function(){},checkUpdate:function(e){var i=this.oList.length;this.update();if(e||this.oList.length!==i){this._fireChange({reason:C.Change});}},fetchContexts:function(){var i,e=this.oModel.resolve(this.sPath,this.oContext),n=this;if(!e){return S.resolve([]);}i=e.slice(-1)==="@";if(!i&&!e.endsWith("/")){e+="/";}return this.oModel.fetchObject(e).then(function(o){if(!o){return[];}if(i){e=e.slice(0,-1);}return Object.keys(o).filter(function(j1){return j1[0]!=="$"&&i!==(j1[0]!=="@");}).map(function(j1){return new c(n.oModel,e+j1);});});},getContexts:function(i,e){this.iCurrentStart=i||0;this.iCurrentLength=Math.min(e||Infinity,this.iLength-this.iCurrentStart,this.oModel.iSizeLimit);return this.getCurrentContexts();},getCurrentContexts:function(){var e=[],i,n=this.iCurrentStart+this.iCurrentLength;for(i=this.iCurrentStart;i<n;i+=1){e.push(this.oList[this.aIndices[i]]);}if(this.oList.dataRequested){e.dataRequested=true;}return e;},setContexts:function(e){this.oList=e;this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();},update:function(){var e=[],o=this.fetchContexts(),i=this;if(o.isFulfilled()){e=o.getResult();}else{o.then(function(e){i.setContexts(e);i._fireChange({reason:C.Change});});e.dataRequested=true;}this.setContexts(e);}});A=P.extend("sap.ui.model.odata.v4.ODataMetaPropertyBinding",{constructor:function(){P.apply(this,arguments);this.vValue=undefined;},checkUpdate:function(e,i){var o,n=this;function j1(k1){if(e||k1!==n.vValue){n.vValue=k1;n._fireChange({reason:i||C.Change});}return k1;}o=this.oModel.fetchObject(this.sPath,this.oContext,this.mParameters).then(j1);if(this.mParameters&&this.mParameters.$$valueAsPromise&&o.isPending()){j1(o.unwrap());}},getValue:function(){return this.vValue;},setContext:function(o){if(this.oContext!=o){this.oContext=o;if(this.bRelative){this.checkUpdate(false,C.Context);}}},setValue:function(){throw new Error("Unsupported operation: ODataMetaPropertyBinding#setValue");}});var i1=M.extend("sap.ui.model.odata.v4.ODataMetaModel",{constructor:function(o,e,i,n,j1){M.call(this);this.aAnnotationUris=i&&!Array.isArray(i)?[i]:i;this.sDefaultBindingMode=B.OneTime;this.mETags={};this.dLastModified=new Date(0);this.oMetadataPromise=null;this.oModel=n;this.mMetadataUrl2Promise={};this.oRequestor=o;this.mSchema2MetadataUrl={};this.mSupportedBindingModes={"OneTime":true,"OneWay":true};this.bSupportReferences=j1!==false;this.mUnsupportedFilterOperators={"All":true,"Any":true};this.sUrl=e;}});i1.prototype.$$valueAsPromise=true;i1.prototype._mergeAnnotations=function(e,n){var o=this;this.validate(this.sUrl,e);e.$Annotations={};Object.keys(e).forEach(function(i){if(e[i].$kind==="Schema"){a1(o,i,o.sUrl);f1(e[i],e.$Annotations);}});n.forEach(function(j1,i){var k1,l1;o.validate(o.aAnnotationUris[i],j1);for(l1 in j1){if(l1[0]!=="$"){if(l1 in e){g1(o,"A schema cannot span more than one document: "+l1,o.aAnnotationUris[i]);}k1=j1[l1];e[l1]=k1;if(k1.$kind==="Schema"){a1(o,l1,o.aAnnotationUris[i]);f1(k1,e.$Annotations,true);}}}});};i1.prototype.attachEvent=function(e){if(!(e in J)){throw new Error("Unsupported event '"+e+"': v4.ODataMetaModel#attachEvent");}return M.prototype.attachEvent.apply(this,arguments);};i1.prototype.bindContext=function(e,o){return new x(this,e,o);};i1.prototype.bindList=function(e,o,i,n){return new y(this,e,o,i,n);};i1.prototype.bindProperty=function(e,o,i){return new A(this,e,o,i);};i1.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#bindTree");};i1.prototype.fetchCanonicalPath=function(o){return this.fetchUpdateData("",o).then(function(e){if(!e.editUrl){throw new Error(o.getPath()+": No canonical path for transient entity");}if(e.propertyPath){throw new Error("Context "+o.getPath()+" does not point to an entity. It should be "+e.entityPath);}return"/"+e.editUrl;});};i1.prototype.fetchData=function(){return this.fetchEntityContainer().then(function(e){return JSON.parse(JSON.stringify(e));});};i1.prototype.fetchEntityContainer=function(e){var i,n=this;if(!this.oMetadataPromise){i=[S.resolve(this.oRequestor.read(this.sUrl,false,e))];if(this.aAnnotationUris){this.aAnnotationUris.forEach(function(o){i.push(S.resolve(n.oRequestor.read(o,true,e)));});}if(!e){this.oMetadataPromise=S.all(i).then(function(o){var j1=o[0];n._mergeAnnotations(j1,o.slice(1));return j1;});}}return this.oMetadataPromise;};i1.prototype.fetchObject=function(n,j1,k1){var l1=this.resolve(n,j1),m1=this;if(!l1){L.error("Invalid relative path w/o context",n,z);return S.resolve(null);}return this.fetchEntityContainer().then(function(n1){var o1,p1=false,q1,r1,s1=true,t1,u1,v1,w1=n1;function x1(e,i){var o,G1,H1,I1="",J1=i.slice(e.length);if(J1&&e1(e,w1)){r1=e;if(o1){H1=w1.filter(A1);if(H1.length!==1){return C1($,"Expected a single overload, but found "+H1.length);}if(o1!==N){I1=H1[0].$Parameter[0].$isCollection?"Collection("+o1+")":o1;}G1=v1+"("+I1+")/"+e;if(n1.$Annotations[G1]){if(J1==="@"){w1=n1.$Annotations[G1];o=n1.$Annotations[v1+"/"+e];if(o){w1=Object.assign({},o,w1);}return false;}if(n1.$Annotations[G1][J1]){v1=G1;return true;}}}v1+="/"+e;return true;}}function y1(i,n){var o,G1=i.indexOf("@",2);if(G1>-1){return C1($,"Unsupported path after ",i.slice(0,G1));}i=i.slice(2);o=i[0]==="."?O.get(i.slice(1),k1.scope):k1&&O.get(i,k1.scope)||(i==="requestCurrencyCodes"||i==="requestUnitsOfMeasure"?m1[i].bind(m1):O.get(i));if(typeof o!=="function"){return C1($,i," is not a function but: "+o);}try{w1=o(w1,{$$valueAsPromise:k1&&k1.$$valueAsPromise,context:new c(m1,n),schemaChildName:u1});}catch(e){C1($,"Error calling ",i,": ",e);}return true;}function z1(e,o){var i;if(e&&o.$Parameter){i=o.$Parameter.filter(function(G1){return G1.$Name===e;});if(i.length){w1=i[0];return true;}}return false;}function A1(o){return!o.$IsBound&&o1===N||o.$IsBound&&o1===o.$Parameter[0].$Type;}function B1(o){return o&&typeof o.then==="function";}function C1(i){var e;if(L.isLoggable(i,z)){e=Array.isArray(q1)?q1.join("/"):q1;L[i===v?"debug":"warning"](Array.prototype.slice.call(arguments,1).join("")+(e?" at /"+e:""),l1,z);}if(i===$){w1=undefined;}return false;}function D1(e,i){var o;function G1(){q1=q1||v1&&i&&v1+"/"+i;return C1.apply(this,arguments);}o1=w1&&w1.$Type;if(m1.bSupportReferences&&!(e in n1)){o=h1(e);w1=b1(m1,n1,o,G1);}if(e in n1){v1=r1=u1=e;w1=t1=n1[u1];if(!B1(w1)){return true;}}if(B1(w1)&&w1.isPending()){return G1(v,"Waiting for ",o);}return G1($,"Unknown qualified name ",e);}function E1(e,i,o){var G1,H1,I1;if(e==="$Annotations"){return C1($,"Invalid segment: $Annotations");}if(w1!==n1&&typeof w1==="object"&&e in w1){if(e[0]==="$"||w.test(e)){s1=false;}}else{H1=e.indexOf("@@");if(H1<0){if(e.length>11&&e.slice(-11)==="@sapui.name"){H1=e.length-11;}else{H1=e.indexOf("@");}}if(H1>0){if(!E1(e.slice(0,H1),i,o)){return false;}e=e.slice(H1);I1=true;}if(typeof w1==="string"&&!(I1&&(e==="@sapui.name"||e[1]==="@"))&&!F1(w1,o.slice(0,i))){return false;}if(s1){if(e[0]==="$"||w.test(e)){s1=false;}else if(!I1){if(e[0]!=="@"&&e.indexOf(".")>0){return D1(e);}else if(w1&&"$Type"in w1){if(!D1(w1.$Type,"$Type")){return false;}}else if(w1&&"$Action"in w1){if(!D1(w1.$Action,"$Action")){return false;}o1=N;}else if(w1&&"$Function"in w1){if(!D1(w1.$Function,"$Function")){return false;}o1=N;}else if(i===0){v1=r1=u1=u1||n1.$EntityContainer;w1=t1=t1||n1[u1];if(e&&e[0]!=="@"&&!(e in t1)){return C1($,"Unknown child ",e," of ",u1);}}if(Array.isArray(w1)){G1=x1(e,o[i]);if(G1!==undefined){return G1;}if(o1){w1=w1.filter(A1);}if(e==="@$ui5.overload"){return true;}if(w1.length!==1){return C1($,"Expected a single overload, but found "+w1.length);}if(z1(e,w1[0])){return true;}w1=w1[0].$ReturnType;v1=v1+"/0/$ReturnType";if(w1){if(e==="value"&&!(n1[w1.$Type]&&n1[w1.$Type].value)){r1=undefined;return true;}if(!D1(w1.$Type,"$Type")){return false;}}if(!e){return true;}}}}if(!e){return i+1>=o.length||C1($,"Invalid empty segment");}if(e[0]==="@"){if(e==="@sapui.name"){w1=r1;if(w1===undefined){C1($,"Unsupported path before @sapui.name");}else if(i+1<o.length){C1($,"Unsupported path after @sapui.name");}return false;}if(e[1]==="@"){if(i+1<o.length){return C1($,"Unsupported path after ",e);}return y1(e,[""].concat(o.slice(0,i),o[i].slice(0,H1)).join("/"));}}if(!w1||typeof w1!=="object"){w1=undefined;return!p1&&C1(v,"Invalid segment: ",e);}if(s1&&e[0]==="@"){w1=n1.$Annotations[v1]||{};p1=true;s1=false;}else if(e==="$"&&i+1<o.length){return C1($,"Unsupported path after $");}}if(e!=="@"&&e!=="$"){if(e[0]==="@"){p1=true;}r1=s1||e[0]==="@"?e:undefined;v1=s1?v1+"/"+e:undefined;w1=w1[e];}return true;}function F1(e,i){var o;if(q1){return C1($,"Invalid recursion");}q1=i;p1=false;s1=true;w1=n1;o=e.split("/").every(E1);q1=undefined;return o;}if(!F1(l1.slice(1))&&B1(w1)){w1=w1.then(function(){return m1.fetchObject(n,j1,k1);});}return w1;});};i1.prototype.fetchUI5Type=function(e){var o=this.getMetaContext(e),i=this;if(e.endsWith("/$count")){t=t||new m();return S.resolve(t);}return this.fetchObject(undefined,o).catch(function(){}).then(function(n){var j1=F,k1;if(!n){L.warning("No metadata for path '"+e+"', using "+j1.getName(),undefined,z);return j1;}if(n["$ui5.type"]){return n["$ui5.type"];}if(n.$isCollection){L.warning("Unsupported collection type, using "+j1.getName(),e,z);}else{k1=K[n.$Type];if(k1){j1=new k1.Type(undefined,i.getConstraints(n,o.getPath()));}else{L.warning("Unsupported type '"+n.$Type+"', using "+j1.getName(),e,z);}}n["$ui5.type"]=j1;return j1;});};i1.prototype.fetchUpdateData=function(e,o){var n=o.getModel(),j1=n.resolve(e,o),k1=this;function l1(i){var m1=new Error(j1+": "+i);n.reportError(i,z,m1);throw m1;}return this.fetchObject(this.getMetaPath(j1)).then(function(){return k1.fetchEntityContainer();}).then(function(m1){var n1,o1=m1[m1.$EntityContainer],p1,q1,r1,s1,t1,u1,v1,w1=false,x1;function y1(C1){var i=C1.indexOf("(");return i>=0?C1.slice(i):"";}function z1(i){n1.push({path:t1,prefix:i,type:x1});}function A1(C1){var i=C1.indexOf("(");return i>=0?C1.slice(0,i):C1;}function B1(i){if(i.includes("($uid=")){z1(A1(i));}else{n1.push(i);}}v1=j1.slice(1).split("/");s1=v1.shift();t1="/"+s1;p1=t1;r1=decodeURIComponent(A1(s1));q1=o1[r1];if(!q1){l1("Not an entity set: "+r1);}x1=m1[q1.$Type];e="";u1="";n1=[];B1(s1);v1.forEach(function(i){var C1,D1;t1+="/"+i;if(w.test(i)){z1(n1.pop());p1+="/"+i;}else{D1=decodeURIComponent(A1(i));u1=_.buildPath(u1,D1);C1=x1[D1];if(!C1){l1("Not a (navigation) property: "+D1);}x1=m1[C1.$Type];if(C1.$kind==="NavigationProperty"){if(q1.$NavigationPropertyBinding&&u1 in q1.$NavigationPropertyBinding){r1=q1.$NavigationPropertyBinding[u1];q1=o1[r1];u1="";n1=[encodeURIComponent(r1)+y1(i)];if(!C1.$isCollection){z1(n1.pop());}}else{B1(i);}p1=t1;e="";}else{e=_.buildPath(e,i);}}});return S.all(n1.map(function(i){if(typeof i==="string"){return i;}return o.fetchValue(i.path).then(function(C1){var D1;if(!C1){l1("No instance to calculate key predicate at "+i.path);}if(_.hasPrivateAnnotation(C1,"transient")){w1=true;return undefined;}D1=_.getPrivateAnnotation(C1,"predicate");if(!D1){l1("No key predicate known at "+i.path);}return i.prefix+D1;},function(C1){l1(C1.message+" at "+i.path);});})).then(function(i){return{editUrl:w1?undefined:i.join("/"),entityPath:p1,propertyPath:e};});});};i1.prototype.fetchValueListMappings=function(o,n,e){var i=this,j1=o.getMetaModel();return j1.fetchEntityContainer().then(function(k1){var l1,m1=k1.$Annotations,n1={},o1=i===j1,p1;p1=Object.keys(m1).filter(function(q1){if(_.namespace(q1)===n){if(typeof e==="string"?q1===e:i.getObject("/"+q1)===e){return true;}if(!o1){throw new Error("Unexpected annotation target '"+q1+"' with namespace of data service in "+o.sServiceUrl);}}return false;});if(!p1.length){throw new Error("No annotation '"+W.slice(1)+"' in "+o.sServiceUrl);}l1=m1[p1[0]];Object.keys(l1).forEach(function(q1){var r1=d1(q1);if(r1!==undefined){n1[r1]=l1[q1];["CollectionRoot","SearchSupported"].forEach(function(s1){if(s1 in l1[q1]){throw new Error("Property '"+s1+"' is not allowed in annotation '"+q1.slice(1)+"' for target '"+p1[0]+"' in "+o.sServiceUrl);}});}else if(!o1){throw new Error("Unexpected annotation '"+q1.slice(1)+"' for target '"+p1[0]+"' with namespace of data service in "+o.sServiceUrl);}});return n1;});};i1.prototype.fetchValueListType=function(e){var o=this.getMetaContext(e),i=this;return this.fetchObject(undefined,o).then(function(n){var j1,k1;if(!n){throw new Error("No metadata for "+e);}j1=i.getObject("@",o);if(j1[Z]){return V.Fixed;}for(k1 in j1){if(c1(k1,Y)!==undefined||c1(k1,X)!==undefined){return V.Standard;}if(c1(k1,W)!==undefined){return j1[k1].SearchSupported===false?V.Fixed:V.Standard;}}return V.None;});};i1.prototype.getAbsoluteServiceUrl=function(e){var i=new U(this.sUrl).absoluteTo(document.baseURI).pathname().toString();return new U(e).absoluteTo(i).filename("").toString();};i1.prototype.getAdapterFactoryModulePath=function(){return"sap/ui/mdc/experimental/adapter/odata/v4/ODataAdapterFactory";};i1.prototype.getConstraints=function(o,e){var i,n,j1,k1=K[o.$Type];function l1(m1,n1){if(n1!==undefined){n=n||{};n[m1]=n1;}}if(k1){j1=k1.constraints;for(i in j1){l1(j1[i],i[0]==="@"?this.getObject(e+i):o[i]);}if(o.$Nullable===false){l1("nullable",false);}}return n;};i1.prototype.getData=_.createGetMethod("fetchData");i1.prototype.getETags=function(){return this.mETags;};i1.prototype.getLastModified=function(){return this.dLastModified;};i1.prototype.getMetaContext=function(e){return new c(this,this.getMetaPath(e));};i1.prototype.getMetaPath=function(e){return _.getMetaPath(e);};i1.prototype.getObject=_.createGetMethod("fetchObject");i1.prototype.getOrCreateSharedModel=function(e,i,n){var o,j1;e=this.getAbsoluteServiceUrl(e);o=!!n+e;j1=H.get(o);if(!j1){j1=new this.oModel.constructor({autoExpandSelect:n,groupId:i,operationMode:f.Server,serviceUrl:e,synchronizationMode:"None"});j1.setDefaultBindingMode(B.OneWay);H.set(o,j1);j1.oRequestor.mHeaders["X-CSRF-Token"]=this.oModel.oRequestor.mHeaders["X-CSRF-Token"];}return j1;};i1.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#getOriginalProperty");};i1.prototype.getProperty=i1.prototype.getObject;i1.prototype.getUI5Type=_.createGetMethod("fetchUI5Type",true);i1.prototype.getUnitOrCurrencyPath=function(e){var i=this.getObject("@",this.getMetaContext(e)),o=i&&(i["@Org.OData.Measures.V1.Unit"]||i["@Org.OData.Measures.V1.ISOCurrency"]);return o&&o.$Path;};i1.prototype.getValueListType=_.createGetMethod("fetchValueListType",true);i1.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#isList");};i1.prototype.refresh=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#refresh");};i1.prototype.requestCodeList=function(i,n,o){var j1=this.fetchEntityContainer().getResult(),k1=j1[j1.$EntityContainer],l1=this;if(o&&o.context){if(o.context.getModel()!==this||o.context.getPath()!=="/"){throw new Error("Unsupported context: "+o.context);}}if(n!==undefined&&n!==k1){throw new Error("Unsupported raw value: "+n);}return this.requestObject("/@com.sap.vocabularies.CodeList.v1."+i).then(function(m1){var n1,o1,p1,q1,r1;if(!m1){return null;}n1=l1.getAbsoluteServiceUrl(m1.Url)+"#"+m1.CollectionPath;q1=u.get(n1);if(q1){return q1;}p1=l1.getOrCreateSharedModel(m1.Url,"$direct");o1=p1.getMetaModel();r1="/"+m1.CollectionPath+"/";q1=o1.requestObject(r1).then(function(s1){return new Promise(function(t1,u1){var v1=r1+"@Org.OData.Core.V1.AlternateKeys",w1=o1.getObject(v1),x1,y1=G1(s1.$Key),z1=r1+y1+"@com.sap.vocabularies.Common.v1.",A1,B1,C1=r1+y1+"@com.sap.vocabularies.CodeList.v1.StandardCode/$Path",D1,E1;function F1(e,H1){var I1=H1.getProperty(y1),J1={Text:H1.getProperty(E1),UnitSpecificScale:H1.getProperty(B1)};if(D1){J1.StandardCode=H1.getProperty(D1);}if(J1.UnitSpecificScale===null){L.error("Ignoring customizing w/o unit-specific scale for code "+I1+" from "+m1.CollectionPath,m1.Url,z);}else{e[I1]=J1;}return e;}function G1(e){var H1;if(e&&e.length===1){H1=e[0];}else{throw new Error("Single key expected: "+r1);}return typeof H1==="string"?H1:H1[Object.keys(H1)[0]];}if(w1){if(w1.length!==1){throw new Error("Single alternative expected: "+v1);}else if(w1[0].Key.length!==1){throw new Error("Single key expected: "+v1+"/0/Key");}y1=w1[0].Key[0].Name.$PropertyPath;}B1=o1.getObject(z1+"UnitSpecificScale/$Path");E1=o1.getObject(z1+"Text/$Path");A1=[y1,B1,E1];D1=o1.getObject(C1);if(D1){A1.push(D1);}x1=p1.bindList("/"+m1.CollectionPath,null,null,null,{$select:A1});x1.attachChange(function(){var H1;try{H1=x1.getContexts(0,Infinity);if(!H1.length){L.error("Customizing empty for ",p1.sServiceUrl+m1.CollectionPath,z);}t1(H1.reduce(F1,{}));}catch(e){u1(e);}});x1.attachDataReceived(function(e){var H1=e.getParameter("error");if(H1){u1(H1);}});x1.getContexts(0,Infinity);});});u.set(n1,q1);return q1;});};i1.prototype.requestCurrencyCodes=function(e,o){return this.requestCodeList("CurrencyCodes",e,o);};i1.prototype.requestData=_.createRequestMethod("fetchData");i1.prototype.requestObject=_.createRequestMethod("fetchObject");i1.prototype.requestUI5Type=_.createRequestMethod("fetchUI5Type");i1.prototype.requestUnitsOfMeasure=function(e,o){return this.requestCodeList("UnitsOfMeasure",e,o);};i1.prototype.requestValueListInfo=function(e,i){var n=this.getMetaPath(e),o=n.slice(0,n.lastIndexOf("/")),j1=o.slice(o.lastIndexOf("/")+1),k1=this;if(!j1.includes(".")){j1=undefined;}return Promise.all([j1||this.requestObject(o+"/@sapui.name"),this.requestObject(n),this.requestObject(n+"@"),this.requestObject(n+Z)]).then(function(l1){var m1=l1[2],n1=l1[3],o1={},p1=_.namespace(l1[0]),q1=l1[1],r1={};function s1(t1,u1,v1,w1){if(n1!==undefined&&"SearchSupported"in t1){throw new Error("Must not set 'SearchSupported' in annotation "+"'com.sap.vocabularies.Common.v1.ValueList' and annotation "+"'com.sap.vocabularies.Common.v1.ValueListWithFixedValues'");}if("CollectionRoot"in t1){w1=k1.getOrCreateSharedModel(t1.CollectionRoot,undefined,i);if(r1[u1]&&r1[u1].$model===w1){o1[u1]=undefined;}}if(o1[u1]){throw new Error("Annotations '"+W.slice(1)+"' with identical qualifier '"+u1+"' for property "+e+" in "+o1[u1]+" and "+v1);}o1[u1]=v1;t1=Q.extend(true,{$model:w1},t1);delete t1.CollectionRoot;delete t1.SearchSupported;r1[u1]=t1;}if(!q1){throw new Error("No metadata for "+e);}return Promise.all(Object.keys(m1).filter(function(t1){return c1(t1,Y)!==undefined;}).map(function(t1){var u1=m1[t1];return Promise.all(u1.map(function(v1){var w1=k1.getOrCreateSharedModel(v1,undefined,i);return k1.fetchValueListMappings(w1,p1,q1.$Name?j1+"/"+q1.$Name:q1).then(function(x1){Object.keys(x1).forEach(function(y1){s1(x1[y1],y1,v1,w1);});});}));})).then(function(){var t1;Object.keys(m1).filter(function(u1){return d1(u1)!==undefined;}).forEach(function(u1){s1(m1[u1],d1(u1),k1.sUrl,k1.oModel);});t1=Object.keys(r1);if(!t1.length){throw new Error("No annotation '"+Y.slice(1)+"' for "+e);}if(n1){if(t1.length>1){throw new Error("Annotation '"+Z.slice(1)+"' but multiple '"+W.slice(1)+"' for property "+e);}return{"":r1[t1[0]]};}return r1;});});};i1.prototype.requestValueListType=_.createRequestMethod("fetchValueListType");i1.prototype.resolve=function(e,o){var i,n;if(!e){return o?o.getPath():undefined;}n=e[0];if(n==="/"){return e;}if(!o){return undefined;}if(n==="."){if(e[1]!=="/"){throw new Error("Unsupported relative path: "+e);}e=e.slice(2);}i=o.getPath();return n==="@"||i.slice(-1)==="/"?i+e:i+"/"+e;};i1.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#setLegacySyntax");};i1.prototype.toString=function(){return z+": "+this.sUrl;};i1.prototype.validate=function(e,n){var i,o,j1,k1,l1,m1;if(!this.bSupportReferences){return n;}for(m1 in n.$Reference){l1=n.$Reference[m1];m1=new U(m1).absoluteTo(this.sUrl).toString();if("$IncludeAnnotations"in l1){g1(this,"Unsupported IncludeAnnotations",e);}for(i in l1.$Include){k1=l1.$Include[i];if(k1 in n){g1(this,"A schema cannot span more than one document: "+k1+" - is both included and defined",e);}a1(this,k1,m1,e);}}j1=n.$LastModified?new Date(n.$LastModified):null;this.mETags[e]=n.$ETag?n.$ETag:j1;o=n.$Date?new Date(n.$Date):new Date();j1=j1||o;if(this.dLastModified<j1){this.dLastModified=j1;}delete n.$Date;delete n.$ETag;delete n.$LastModified;return n;};return i1;});
