/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/format/NumberFormat','sap/ui/model/CompositeType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException',"sap/ui/thirdparty/jquery"],function(N,C,F,P,V,q){"use strict";var a=C.extend("sap.ui.model.type.Currency",{constructor:function(){C.apply(this,arguments);this.sName="Currency";this.bUseRawValues=true;}});a.prototype.formatValue=function(v,i){var b=v;if(v==undefined||v==null){return null;}if(this.oInputFormat){b=this.oInputFormat.parse(v);}if(!Array.isArray(b)){throw new F("Cannot format currency: "+v+" has the wrong format");}if(b[0]==undefined||b[0]==null){return null;}switch(this.getPrimitiveType(i)){case"string":return this.oOutputFormat.format(b);case"int":case"float":case"any":default:throw new F("Don't know how to format currency to "+i);}};a.prototype.parseValue=function(v,i){var r,b;switch(this.getPrimitiveType(i)){case"string":r=this.oOutputFormat.parse(v);if(!Array.isArray(r)||isNaN(r[0])){b=sap.ui.getCore().getLibraryResourceBundle();throw new P(b.getText("Currency.Invalid",[v]));}break;case"int":case"float":default:throw new P("Don't know how to parse Currency from "+i);}if(this.oInputFormat){r=this.oInputFormat.format(r);}return r;};a.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),c=[],m=[],d=v,i;if(this.oInputFormat){d=this.oInputFormat.parse(v);}i=d[0];q.each(this.oConstraints,function(n,o){switch(n){case"minimum":if(i<o){c.push("minimum");m.push(b.getText("Currency.Minimum",[o]));}break;case"maximum":if(i>o){c.push("maximum");m.push(b.getText("Currency.Maximum",[o]));}}});if(c.length>0){throw new V(this.combineMessages(m),c);}}};a.prototype.setFormatOptions=function(f){this.oFormatOptions=f;this._createFormats();};a.prototype._handleLocalizationChange=function(){this._createFormats();};a.prototype._createFormats=function(){var s=this.oFormatOptions.source;this.oOutputFormat=N.getCurrencyInstance(this.oFormatOptions);if(s){if(q.isEmptyObject(s)){s={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."};}this.oInputFormat=N.getCurrencyInstance(s);}};return a;});
