/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/mvc/Controller","sap/ui/rta/appVariant/manageApps/webapp/model/models","sap/ui/rta/appVariant/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/rta/appVariant/Feature","sap/ui/rta/RuntimeAuthoring","sap/ui/core/BusyIndicator","sap/ui/rta/appVariant/AppVariantUtils","sap/base/i18n/ResourceBundle"],function(C,M,A,a,R,b,c,B,d,e){"use strict";var _,f,m,i;return C.extend("sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps",{onInit:function(){_=this.getOwnerComponent().getIdRunningApp();f=this.getOwnerComponent().getIsOverviewForKeyUser();if(!i){this._createResourceBundle();}B.show();return A.getAppVariantOverview(_,f).then(function(g){B.hide();if(g.length){return this._arrangeOverviewDataAndBindToModel(g).then(function(g){return this._highlightNewCreatedAppVariant(g);}.bind(this));}d.closeOverviewDialog();return this._showMessageWhenNoAppVariantsExist();}.bind(this))["catch"](function(E){d.closeOverviewDialog();var o=d.buildErrorInfo("MSG_MANAGE_APPS_FAILED",E);o.overviewDialog=true;B.hide();return d.showRelevantDialog(o,false);});},_createResourceBundle:function(){m=sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")+"webapp";i=e.create({url:m+"/i18n/i18n.properties"});},_showMessageWhenNoAppVariantsExist:function(){return R._showMessageBox(a.Icon.INFORMATION,"TITLE_APP_VARIANT_OVERVIEW_SAP_DEVELOPER","MSG_APP_VARIANT_OVERVIEW_SAP_DEVELOPER");},_highlightNewCreatedAppVariant:function(g){var t=this.byId("Table1");g.forEach(function(o,h){if(o.currentStatus===i.getText("MAA_NEW_APP_VARIANT")||o.currentStatus===i.getText("MAA_OPERATION_IN_PROGRESS")){if(t.getItems().length>=h){t.getItems()[h].focus();}}});return Promise.resolve();},_arrangeOverviewDataAndBindToModel:function(g){var h=g.filter(function(n){return n.appId===_;});var o=h[0];if(o&&o.appVarStatus!=="R"){o.currentStatus=i.getText("MAA_CURRENTLY_ADAPTING");}g=g.filter(function(n){return n.appId!==_;});g.unshift(o);var r=g.filter(function(n){return n.isOriginal;});var j=r[0];g=g.filter(function(n){return!n.isOriginal;});g.unshift(j);var k={appVariants:g};var l=M.createModel(k);this.getView().setModel(l);return Promise.resolve(g);},formatRowHighlight:function(v){if(v===i.getText("MAA_CURRENTLY_ADAPTING")){return"Success";}else if(v===i.getText("MAA_NEW_APP_VARIANT")){return"Information";}else if(v===i.getText("MAA_OPERATION_IN_PROGRESS")){return"Warning";}return"None";},formatDelButtonTooltip:function(D,I){if(!D&&!I){return i.getText("TOOLTIP_DELETE_APP_VAR");}return undefined;},getModelProperty:function(s,g){return this.getView().getModel().getProperty(s,g);},onMenuAction:function(E){var I=E.getParameter("item"),s="";while(I instanceof sap.m.MenuItem){s=I.getText()+" > "+s;I=I.getParent();}s=s.substr(0,s.lastIndexOf(" > "));if(!i){this._createResourceBundle();}if(s===i.getText("MAA_DIALOG_ADAPT_UI")){return this.handleUiAdaptation(E);}else if(s===i.getText("MAA_DIALOG_COPY_ID")){return this.copyId(E);}else if(s===i.getText("MAA_DIALOG_DELETE_APPVAR")){return this.deleteAppVariant(E);}else if(s===i.getText("MAA_DIALOG_SAVE_AS_APP")){return this.saveAsAppVariant(E);}return undefined;},handleUiAdaptation:function(E){var n=sap.ushell.Container.getService("CrossApplicationNavigation");var s=this.getModelProperty("semanticObject",E.getSource().getBindingContext());var g=this.getModelProperty("action",E.getSource().getBindingContext());var p=this.getModelProperty("params",E.getSource().getBindingContext());var N;if(s&&g&&p){N={target:{semanticObject:s,action:g},params:p};c.enableRestart("CUSTOMER");n.toExternal(N);d.closeOverviewDialog();return true;}return false;},saveAsAppVariant:function(E){d.closeOverviewDialog();var D=this.getModelProperty("descriptorUrl",E.getSource().getBindingContext());B.show();return A.getDescriptor(D).then(function(o){B.hide();return b.onSaveAsFromOverviewDialog(o,false);});},copyId:function(E){var s=this.getModelProperty("appId",E.getSource().getBindingContext());d.copyId(s);},deleteAppVariant:function(E){var I={};if(!i){this._createResourceBundle();}var s=i.getText("MSG_APP_VARIANT_DELETE_CONFIRMATION");I.text=s;I.deleteAppVariant=true;var g=this.getModelProperty("appId",E.getSource().getBindingContext());var h=this.getModelProperty("currentStatus",E.getSource().getBindingContext());var j=h===i.getText("MAA_CURRENTLY_ADAPTING");return d.showRelevantDialog(I).then(function(){return b.onDeleteFromOverviewDialog(g,j);}).catch(function(){return true;});}});});
