/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/rta/command/BaseCommand","sap/ui/rta/ControlTreeModifier","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils","sap/base/Log","sap/base/util/merge","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI"],function(B,R,J,f,L,m,C,P){"use strict";var F=B.extend("sap.ui.rta.command.FlexCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string"},jsOnly:{type:"boolean"},selector:{type:"object"}},associations:{},events:{}}});F.prototype.getElementId=function(){var e=this.getElement();return e?e.getId():this.getSelector().id;};F.prototype.getAppComponent=function(){var e=this.getElement();return e?f.getAppComponentForControl(e):this.getSelector().appComponent;};F.prototype.prepare=function(a,v){var s;if(!this.getSelector()&&a&&a.templateSelector){s={id:a.templateSelector,appComponent:this.getAppComponent(),controlType:f.getControlType(sap.ui.getCore().byId(a.templateSelector))};this.setSelector(s);}else if(!this.getSelector()&&this.getElement()){s={id:this.getElement().getId(),appComponent:this.getAppComponent(),controlType:f.getControlType(this.getElement())};this.setSelector(s);}try{this._oPreparedChange=this._createChange(a,v);}catch(e){L.error(e.message||e.name);return false;}return true;};F.prototype.getPreparedChange=function(){return this._oPreparedChange;};F.prototype.execute=function(){var c=this.getPreparedChange();return this._applyChange(c);};F.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),selector:{id:this.getElementId()}};};F.prototype._createChange=function(a,v){return this._createChangeFromData(this._getChangeSpecificData(),a,v);};F.prototype._createChangeFromData=function(c,a,v){if(a){c=m({},c,a);}c.jsOnly=this.getJsOnly();var M=this.getAppComponent().getModel(f.VARIANT_MODEL_NAME);var V;if(M&&v){V=M.getCurrentVariantReference(v);}var b={variantManagementReference:v,variantReference:V};if(V){c=Object.assign({},c,b);}var o=C.create(c,this._validateControlForChange(a));if(a&&a.originalSelector){o.addDependentControl(a.originalSelector,"originalSelector",{modifier:J,appComponent:this.getAppComponent()});o.getDefinition().selector=J.getSelector(this.getSelector().id,this.getSelector().appComponent);o.setContent(Object.assign({},o.getContent(),a.content));}return o;};F.prototype.undo=function(){function e(M,c){var s=c.controlType?c.controlType:J.getControlType(c);var E="Undo is not possible for control type: "+s+". Reason: "+M;return E;}return Promise.resolve().then(function(){var c=this.getElement()||this.getSelector();var o=this.getPreparedChange();if(o.getRevertData()){var r=C.isChangeHandlerRevertible(o,c);if(!r){L.error(e("No revert change function available to handle revert data.",c));return;}return P.remove(o,{appComponent:this.getAppComponent(true),revert:true});}else if(this._aRecordedUndo){R.performUndo(this._aRecordedUndo);}else{L.error(e("Undo is not available.",c));}}.bind(this));};F.prototype._applyChange=function(c){var o=c.change||c;var a=this.getAppComponent();var s=R.bySelector(o.getSelector(),a);var b=C.getControlIfTemplateAffected(s,{modifier:J,appComponent:a,change:o});var r=C.isChangeHandlerRevertible(o,b.control);var p={modifier:r?J:R,appComponent:a,view:f.getViewForControl(s)};if(!r){R.startRecordingUndo();}return Promise.resolve().then(function(){return C.apply(o,s,p);}).then(function(d){if(!r){if(!o.getUndoOperations()){this._aRecordedUndo=R.stopRecordingUndo();}else{this._aRecordedUndo=o.getUndoOperations();o.resetUndoOperations();}}if(!d.success){return Promise.reject(d.error);}}.bind(this));};F.prototype._validateControlForChange=function(a){if(a&&a.originalSelector&&a.content&&a.content.boundAggregation){return{id:a.originalSelector,appComponent:this.getAppComponent(),controlType:f.getControlType(sap.ui.getCore().byId(a.originalSelector))};}return this.getElement()||this.getSelector();};return F;},true);
