/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/UIComponent","sap/ui/core/ComponentContainer","sap/ui/core/mvc/XMLView","sap/ui/rta/command/CommandFactory","sap/ui/dt/DesignTime","sap/ui/dt/DesignTimeStatus","sap/ui/dt/OverlayRegistry","sap/ui/fl/ChangePersistence","sap/ui/model/Model","sap/ui/fl/registry/Settings","sap/ui/rta/ControlTreeModifier","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/thirdparty/sinon-4","sap/ui/fl/library"],function(U,C,X,a,D,b,O,c,M,S,d,e,P,s){"use strict";var f=function(m,o){if(f._only&&(m.indexOf(f._only)<0)){return;}if(typeof o.xmlView==="string"){o.xmlView={viewContent:o.xmlView};}var g=s.sandbox.create();o.before=o.before||function(){};o.after=o.after||function(){};QUnit.module(m,function(){QUnit.test("When using the 'controlEnablingCheck' function to test if your control is ready for UI adaptation at runtime",function(p){p.ok(o.afterAction,"then you implement a function to check if your action has been successful: See the afterAction parameter.");p.ok(o.afterUndo,"then you implement a function to check if the undo has been successful: See the afterUndo parameter.");p.ok(o.afterRedo,"then you implement a function to check if the redo has been successful: See the afterRedo parameter.");p.ok(o.xmlView,"then you provide an XML view to test on: See the.xmlView parameter.");var x=new DOMParser().parseFromString(o.xmlView.viewContent,"application/xml").documentElement;p.ok(x.tagName.match("View$"),"then you use the sap.ui.core.mvc View tag as the first tag in your view");p.ok(o.action,"then you provide an action: See the action parameter.");p.ok(o.action.name,"then you provide an action name: See the action.name parameter.");p.ok(o.action.controlId,"then you provide the id of the control to operate the action on: See the action.controlId.");});});var h="sap.ui.rta.control.enabling.comp";var i=false;var A=true;var j=U.extend(h,{metadata:{manifest:{"sap.app":{id:h,type:"application"},getEntry:function(){return{type:"application"};}}},createContent:function(){var v=Object.assign({},o.xmlView);v.id=this.createId("view");if(v.async===undefined){v.async=this.getComponentData().async;}var V=new X(v);return V;}});function k(p){this.oUiComponent=new j({id:"comp",componentData:{async:p}});this.oUiComponentContainer=new C({component:this.oUiComponent});this.oUiComponentContainer.placeAt(o.placeAt||"qunit-fixture");this.oView=this.oUiComponent.getRootControl();if(o.model instanceof M){this.oView.setModel(o.model);}sap.ui.getCore().applyChanges();return Promise.all([this.oView.loaded(),o.model&&o.model.getMetaModel()&&o.model.getMetaModel().loaded()]);}function l(p){this.oControl=this.oView.byId(o.action.controlId);return this.oControl.getMetadata().loadDesignTime(this.oControl).then(function(){var q;if(o.action.parameter){if(typeof o.action.parameter==="function"){q=o.action.parameter(this.oView);}else{q=o.action.parameter;}}else{q={};}sap.ui.getCore().applyChanges();return new Promise(function(r){this.oDesignTime=new D({rootElements:[this.oView]});this.oDesignTime.attachEventOnce("synced",function(){this.oControlOverlay=O.getOverlay(this.oControl);var t=new a({flexSettings:{layer:o.layer||"CUSTOMER"}});var E=this.oControlOverlay.getDesignTimeMetadata();if(o.action.name==="move"){var u=O.getOverlay(q.movedElements[0].element);var R=u.getRelevantContainer();this.oControl=R;E=u.getParentAggregationOverlay().getDesignTimeMetadata();}else if(o.action.name==="addODataProperty"){var v=E.getActionDataFromAggregations("addODataProperty",this.oControl);p.equal(v.length,1,"there should be only one aggregation with the possibility to do addODataProperty action");var w=this.oControlOverlay.getAggregationOverlay(v[0].aggregation);E=w.getDesignTimeMetadata();}t.getCommandFor(this.oControl,o.action.name,q,E).then(function(x){this.oCommand=x;p.ok(x,"then the registration for action to change type, the registration for change and control type to change handler is available and "+o.action.name+" is a valid action");r();}.bind(this)).catch(function(x){throw new Error(x);});}.bind(this));}.bind(this));}.bind(this));}function n(p){var q=p.getPreparedChange();if(p.getAppComponent){return P.remove(q,{appComponent:p.getAppComponent()});}}if(!o.jsOnly){QUnit.module(m+" on async views",{before:function(p){this.hookContext={};return o.before.call(this.hookContext,p);},after:function(p){return o.after.call(this.hookContext,p);},beforeEach:function(){g.stub(S,"getInstance").resolves({_oSettings:{recordUndo:false}});},afterEach:function(){this.oUiComponentContainer.destroy();this.oDesignTime.destroy();this.oCommand.destroy();g.restore();}},function(){QUnit.test("When applying the change directly on the XMLView",function(p){var q=[];g.stub(c.prototype,"getChangesForComponent").resolves(q);g.stub(c.prototype,"getCacheKey").resolves("etag-123");return k.call(this,i).then(function(){return l.call(this,p);}.bind(this)).then(function(){var r=this.oCommand.getPreparedChange();q.push(r);this.oUiComponentContainer.destroy();return k.call(this,A);}.bind(this)).then(function(r){var v=r[0];return o.afterAction(this.oUiComponent,v,p);}.bind(this));});QUnit.test("When executing on XML and reverting the change in JS (e.g. variant switch)",function(p){var q=[];g.stub(c.prototype,"getChangesForComponent").resolves(q);g.stub(c.prototype,"getCacheKey").resolves("etag-123");return k.call(this,i).then(function(){return l.call(this,p);}.bind(this)).then(function(){var r=this.oCommand.getPreparedChange();q.push(r);this.oUiComponentContainer.destroy();return k.call(this,A);}.bind(this)).then(function(){return this.oCommand.undo();}.bind(this)).then(function(){return n(this.oCommand);}.bind(this)).then(function(){sap.ui.getCore().applyChanges();o.afterUndo(this.oUiComponent,this.oView,p);}.bind(this));});QUnit.test("When executing on XML, reverting the change in JS (e.g. variant switch) and applying again",function(p){var q=[];g.stub(c.prototype,"getChangesForComponent").resolves(q);g.stub(c.prototype,"getCacheKey").resolves("etag-123");return k.call(this,i).then(function(){return l.call(this,p);}.bind(this)).then(function(){var r=this.oCommand.getPreparedChange();q.push(r);this.oUiComponentContainer.destroy();return k.call(this,A);}.bind(this)).then(function(){return this.oCommand.undo();}.bind(this)).then(function(){return n(this.oCommand);}.bind(this)).then(function(){return this.oCommand.execute();}.bind(this)).then(function(){sap.ui.getCore().applyChanges();o.afterRedo(this.oUiComponent,this.oView,p);}.bind(this));});});}QUnit.module(m,{before:function(p){this.hookContext={};return o.before.call(this.hookContext,p);},after:function(p){return o.after.call(this.hookContext,p);},beforeEach:function(p){g.stub(c.prototype,"getChangesForComponent").returns(Promise.resolve([]));g.stub(c.prototype,"getCacheKey").returns(c.NOTAG);g.stub(S,"getInstance").returns(Promise.resolve({_oSettings:{recordUndo:false}}));return k.call(this,i).then(function(){return l.call(this,p);}.bind(this));},afterEach:function(){this.oDesignTime.destroy();this.oUiComponentContainer.destroy();this.oCommand.destroy();g.restore();}},function(){QUnit.test("When executing the underlying command on the control at runtime",function(p){return this.oCommand.execute().then(function(){return this.oDesignTime.getStatus()!==b.SYNCED?(new Promise(function(r){this.oDesignTime.attachEventOnce("synced",r);}.bind(this))):Promise.resolve();}.bind(this)).then(function(){sap.ui.getCore().applyChanges();return o.afterAction(this.oUiComponent,this.oView,p);}.bind(this));});QUnit.test("When executing and undoing the command",function(p){return this.oCommand.execute().then(function(){return this.oDesignTime.getStatus()!==b.SYNCED?(new Promise(function(r){this.oDesignTime.attachEventOnce("synced",r);}.bind(this))):Promise.resolve();}.bind(this)).then(this.oCommand.undo.bind(this.oCommand)).then(function(){return n(this.oCommand);}.bind(this)).then(function(){sap.ui.getCore().applyChanges();return o.afterUndo(this.oUiComponent,this.oView,p);}.bind(this));});QUnit.test("When executing, undoing and redoing the command",function(p){return this.oCommand.execute().then(function(){return this.oDesignTime.getStatus()!==b.SYNCED?(new Promise(function(r){this.oDesignTime.attachEventOnce("synced",r);}.bind(this))):Promise.resolve();}.bind(this)).then(this.oCommand.undo.bind(this.oCommand)).then(function(){return n(this.oCommand);}.bind(this)).then(this.oCommand.execute.bind(this.oCommand)).then(function(){sap.ui.getCore().applyChanges();return o.afterRedo(this.oUiComponent,this.oView,p);}.bind(this));});});};f.skip=function(){};f.only=function(m){f._only=m;};return f;});
