/*
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./SelectionPlugin","./SelectionModelPlugin","./BindingSelectionPlugin","../library","../TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool","sap/base/Log"],function(S,a,B,l,T,I,b,L){"use strict";var c=l.SelectionMode;var M=S.extend("sap.ui.table.plugins.MultiSelectionPlugin",{metadata:{properties:{limit:{type:"int",group:"Behavior",defaultValue:200},showHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:true}},events:{selectionChange:{parameters:{indices:{type:"int[]"},limitReached:{type:"boolean"}}}}}});M.prototype.init=function(){S.prototype.init.call(this);var i=new I({src:b.getIconURI(T.ThemeParameters.resetIcon),useIconTooltip:false});i.addStyleClass("sapUiTableSelectClear");this._bLimitReached=false;this._bLimitDisabled=this.getLimit()===0;this.oSelectionPlugin=null;this.oDeselectAllIcon=i;};M.prototype.exit=function(){if(this.oSelectionPlugin){this.oSelectionPlugin.destroy();this.oSelectionPlugin=null;}if(this.oDeselectAllIcon){this.oDeselectAllIcon.destroy();this.oDeselectAllIcon=null;}};M.prototype.getRenderConfig=function(){return{headerSelector:{type:this._bLimitDisabled?"toggle":"clear",icon:this.oDeselectAllIcon,visible:this.getShowHeaderSelector()}};};M.prototype.onHeaderSelectorPress=function(){if(this.getShowHeaderSelector()){if(this._bLimitDisabled&&this.getSelectableCount()>this.getSelectedCount()){this.selectAll();}else{this.clearSelection();}return true;}};M.prototype.onKeyboardShortcut=function(t){this.clearSelection();if(t==="toggle"){return true;}};M.prototype.setLimit=function(i){if(typeof i==="number"&&i<0){L.warning("The limit must be greater than or equal to 0",this);return this;}this.setProperty("limit",i);this._bLimitDisabled=i===0;return this;};M.prototype.isLimitReached=function(){return this._bLimitReached;};M.prototype.setLimitReached=function(f){this._bLimitReached=f;};M.prototype.selectAll=function(){if(this._bLimitDisabled){var i=this._getBinding().getLength()-1;this.addSelectionInterval(0,i);}};function p(m,i,f){var g=m.getLimit();var h=f-i+1;var o=m._getBinding();if(!m._bLimitDisabled){if(m.isIndexSelected(i)&&f>i){i++;}m.setLimitReached(false);if(h>g){f=i+g-1;h=g;m.setLimitReached(true);}}if(o&&i>=0&&h>0){return d(o,i,h).then(function(){return{indexFrom:i,indexTo:f};});}return Promise.resolve();}M.prototype.setSelectionInterval=function(i,f){p(this,i,f).then(function(m){if(m){this.oSelectionPlugin.setSelectionInterval(m.indexFrom,m.indexTo);}}.bind(this));};M.prototype.addSelectionInterval=function(i,f){p(this,i,f).then(function(m){if(m){this.oSelectionPlugin.addSelectionInterval(m.indexFrom,m.indexTo);}}.bind(this));};function d(o,s,i){return new Promise(function(r){e(o,s,i,r);});}function e(o,s,f,r){var C=o.getContexts(s,f);var g=false;for(var i=0;i<C.length;i++){if(!C[i]){g=true;break;}}if(!g&&!C.dataRequested){r(C);return;}o.attachEventOnce("dataReceived",function(){C=o.getContexts(s,f);if(C.length==f){r(C);}else{e(o,s,f,r);}});}M.prototype.clearSelection=function(){if(this.oSelectionPlugin){this.setLimitReached(false);this.oSelectionPlugin.clearSelection();}};M.prototype.getSelectedIndex=function(){if(this.oSelectionPlugin){return this.oSelectionPlugin.getSelectedIndex();}return-1;};M.prototype.getSelectedIndices=function(){if(this.oSelectionPlugin){return this.oSelectionPlugin.getSelectedIndices();}return[];};M.prototype.getSelectableCount=function(){if(this.oSelectionPlugin){return this.oSelectionPlugin.getSelectableCount();}return 0;};M.prototype.getSelectedCount=function(){if(this.oSelectionPlugin){return this.oSelectionPlugin.getSelectedCount();}return 0;};M.prototype.isIndexSelectable=function(i){if(this.oSelectionPlugin){return this.oSelectionPlugin.isIndexSelectable(i);}return false;};M.prototype.isIndexSelected=function(i){if(this.oSelectionPlugin){return this.oSelectionPlugin.isIndexSelected(i);}return false;};M.prototype.removeSelectionInterval=function(i,f){if(this.oSelectionPlugin){this.setLimitReached(false);this.oSelectionPlugin.removeSelectionInterval(i,f);}};M.prototype.setSelectedIndex=function(i){if(this.oSelectionPlugin){var t=this;this.setLimitReached(false);var o=this._getBinding();if(o&&i>=0){d(o,i,1).then(function(){t.oSelectionPlugin.setSelectedIndex(i);});}}};M.prototype.setParent=function(P){var r=S.prototype.setParent.apply(this,arguments);if(this.oSelectionPlugin){this.oSelectionPlugin.destroy();this.oSelectionPlugin=null;}if(P){this.oSelectionPlugin=new P._SelectionAdapterClass();this.oSelectionPlugin.attachSelectionChange(this._onSelectionChange,this);P.setSelectionMode(c.MultiToggle);}return r;};M.prototype._onSelectionChange=function(E){var r=E.getParameter("rowIndices");this.fireSelectionChange({rowIndices:r,limitReached:this.isLimitReached()});};M.prototype._getLastIndex=function(){if(this.oSelectionPlugin){return this.oSelectionPlugin._getLastIndex();}return 0;};M.prototype._getBinding=function(){if(this.oSelectionPlugin){return this.oSelectionPlugin._getBinding();}return null;};M.prototype._setBinding=function(o){if(this.oSelectionPlugin){return this.oSelectionPlugin._setBinding(o);}};M.prototype._onBindingChange=function(E){if(this.oSelectionPlugin){return this.oSelectionPlugin._onBindingChange(E);}};M.prototype.onThemeChanged=function(){this.oDeselectAllIcon.setSrc(b.getIconURI(T.ThemeParameters.resetIcon));};return M;});
