/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/Renderer','sap/ui/core/format/DateFormat','./calendar/CalendarUtils','./calendar/CustomYearPicker','./calendar/Header','./calendar/MonthsRow','./calendar/YearPicker','./calendar/CalendarDate','./CalendarMonthIntervalRenderer',"sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery"],function(D,C,L,a,R,b,c,d,H,M,Y,e,f,g,h,P,i,q){"use strict";var j=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});j.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=b.getDateInstance({format:"y"});this._oMinDate=c._minDate();this._oMaxDate=c._maxDate();this._initializeHeader();this._initializeMonthsRow();this._initilizeYearPicker();this._iDaysMonthsHead=15;};j.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};j.prototype.onBeforeRendering=function(){var K=this.getAggregation("monthsRow");var N=this._getFocusedDate();p.call(this);K.displayDate(N.toLocalJSDate());};j.prototype._setAriaRole=function(K){var N=this.getAggregation("monthsRow");N._setAriaRole(K);N.invalidate();return this;};j.prototype._initializeHeader=function(){var K=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});K.attachEvent("pressPrevious",this._handlePrevious,this);K.attachEvent("pressNext",this._handleNext,this);K.attachEvent("pressButton2",w,this);this.setAggregation("header",K);};j.prototype._initializeMonthsRow=function(){var K=new M(this.getId()+"--MonthsRow");K.attachEvent("focus",z,this);K.attachEvent("select",y,this);K._bNoThemeChange=true;this.setAggregation("monthsRow",K);};j.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};j.prototype._createYearPicker=function(){var K=new Y(this.getId()+"--YP",{columns:0,years:6});K.attachEvent("select",B,this);K.attachEvent("pageChange",J,this);K._oMinDate.setYear(this._oMinDate.getYear());K._oMaxDate.setYear(this._oMaxDate.getYear());return K;};j.prototype._getCalendarPicker=function(){var K=this.getAggregation("calendarPicker");if(!K){K=new d(this.getId()+"--Cal");K.setPopupMode(true);K.attachEvent("select",A,this);K.attachEvent("cancel",function(N){this._oPopup.close();var O=this.getAggregation("header").getDomRef("B2");if(O){O.focus();}},this);this.setAggregation("calendarPicker",K);}return K;};j.prototype.setStartDate=function(S){c._checkJSDateObject(S);if(h(this.getStartDate(),S)){return this;}var K=S.getFullYear();c._checkYearInValidRange(K);this.setProperty("startDate",S,true);this._oStartDate=e.fromLocalJSDate(S);this._oStartDate.setDate(1);var N=this.getAggregation("monthsRow");N.setStartDate(S);p.call(this);var O=this._getFocusedDate().toLocalJSDate();if(!N.checkDateFocusable(O)){this._setFocusedDate(this._oStartDate);N.displayDate(S);}return this;};j.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(E.bind(this),0);}};j.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var K=this.removeAllAggregation("selectedDates");return K;};j.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var K=this.destroyAggregation("selectedDates");return K;};j.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var K=this.removeAllAggregation("specialDates");return K;};j.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var K=this.destroyAggregation("specialDates");return K;};j.prototype.setLocale=function(K){if(this._sLocale!=K){this._sLocale=K;this._oLocaleData=undefined;this.invalidate();}return this;};j.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};j.prototype._getFocusedDate=function(){if(!this._oFocusedDate){m.call(this);}return this._oFocusedDate;};j.prototype._setFocusedDate=function(K){c._checkCalendarDate(K);this._oFocusedDate=new e(K);};j.prototype.focusDate=function(K){var N=false;var O=this.getAggregation("monthsRow");if(K&&!O.checkDateFocusable(K)){F.call(this,e.fromLocalJSDate(K));N=true;}v.call(this,K,false);if(N){this.fireStartDateChange();}return this;};j.prototype.displayDate=function(K){v.call(this,K,true);return this;};j.prototype.setMonths=function(K){this.setProperty("months",K,true);K=this._getMonths();var N=this.getAggregation("monthsRow");N.setMonths(K);if(!N.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=k.call(this);this._setFocusedDate(this._oStartDate);N.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var O=this.getAggregation("yearPicker");var Q=Math.floor(K/2);if(Q>20){Q=20;}O.setYears(Q);}p.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};j.prototype._getMonths=function(){var K=this.getMonths();if(D.system.phone&&K>6){return 6;}else{return K;}};j.prototype._getLocaleData=function(){if(!this._oLocaleData){var K=this.getLocale();var N=new L(K);this._oLocaleData=a.getInstance(N);}return this._oLocaleData;};j.prototype.setPickerPopup=function(K){var N;this.setProperty("pickerPopup",K,true);if(K){if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}N=this.getAggregation("yearPicker");N.setColumns(0);N.setYears(6);}return this;};j.prototype.setMinDate=function(K){if(h(K,this.getMinDate())){return this;}if(!K){this._oMinDate=c._minDate();}else{c._checkJSDateObject(K);this._oMinDate=e.fromLocalJSDate(K);this._oMinDate.setDate(1);var N=this._oMinDate.getYear();c._checkYearInValidRange(N);if(this._oMaxDate.isBefore(this._oMinDate)){i.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=e.fromLocalJSDate(K);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){i.warning("focused date < minDate -> minDate focused",this);this.focusDate(K);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){i.warning("start date < minDate -> minDate set as start date",this);_.call(this,new e(this._oMinDate),true,true);}}this.setProperty("minDate",K,false);if(this.getPickerPopup()){var O=this._getCalendarPicker();O.setMinDate(K);}else{var Q=this.getAggregation("yearPicker");Q._oMinDate.setYear(this._oMinDate.getYear());}return this;};j.prototype.setMaxDate=function(K){if(h(K,this.getMaxDate())){return this;}if(!K){this._oMaxDate=c._maxDate();}else{c._checkJSDateObject(K);this._oMaxDate=e.fromLocalJSDate(K);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));var N=this._oMaxDate.getYear();c._checkYearInValidRange(N);if(this._oMinDate.isAfter(this._oMaxDate)){i.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=e.fromLocalJSDate(K);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){i.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(K);}}if(this._oStartDate){var O=new e(this._oStartDate);O.setDate(1);O.setMonth(O.getMonth()+this._getMonths());O.setDate(0);if(O.isAfter(this._oMaxDate)){var S=new e(this._oMaxDate);S.setDate(1);S.setMonth(S.getMonth()-this._getMonths()+1);if(S.isSameOrAfter(this._oMinDate)){i.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,S,true,true);}}}}this.setProperty("maxDate",K,false);if(this.getPickerPopup()){var Q=this._getCalendarPicker();Q.setMaxDate(K);}else{var T=this.getAggregation("yearPicker");T._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};j.prototype.onclick=function(K){if(K.isMarked("delayedMouseEvent")){return;}if(K.target.id==this.getId()+"-cancel"){this.onsapescape(K);}};j.prototype.onmousedown=function(K){K.preventDefault();K.setMark("cancelAutoClose");};j.prototype.onsapescape=function(K){if(this.getPickerPopup()){x.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:o.call(this);break;}}};j.prototype.onsaptabnext=function(K){var N=this.getAggregation("header"),O,Q;if(g(this.getDomRef("content"),K.target)){if(N.getDomRef("B2")){N.getDomRef("B2").focus();}if(!this._bPoupupMode){Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){O=this.getAggregation("yearPicker");if(O.getDomRef()){q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}K.preventDefault();}};j.prototype.onsaptabprevious=function(K){var N=this.getAggregation("header"),O,Q;if(g(this.getDomRef("content"),K.target)){if(this._bPoupupMode){if(N.getDomRef("B2")){N.getDomRef("B2").focus();}K.preventDefault();}}else if(K.target.id==N.getId()+"-B2"){switch(this._iMode){case 0:O=this.getAggregation("monthsRow");O._oItemNavigation.focusItem(O._oItemNavigation.getFocusedIndex());break;case 1:if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");Q._oItemNavigation.focusItem(Q._oItemNavigation.getFocusedIndex());}break;}K.preventDefault();}};j.prototype.onfocusin=function(K){if(K.target.id==this.getId()+"-end"){var N=this.getAggregation("header"),O,Q;if(N.getDomRef("B2")){N.getDomRef("B2").focus();}if(!this._bPoupupMode){O=this.getAggregation("monthsRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");if(Q.getDomRef()){q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};j.prototype.onsapfocusleave=function(K){var N,O;if(!K.relatedControlId||!g(this.getDomRef(),sap.ui.getCore().byId(K.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){switch(this._iMode){case 0:N=this.getAggregation("monthsRow");q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:if(!this.getPickerPopup()){O=this.getAggregation("yearPicker");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};j.prototype._handlePrevious=function(K){var N,O,S,Q;switch(this._iMode){case 0:N=this._getFocusedDate();O=this._getMonths();S=new e(k.call(this));S.setMonth(S.getMonth()-O);N.setMonth(N.getMonth()-O);this._setFocusedDate(N);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");Q.previousPage();s.call(this);}break;}};j.prototype._handleNext=function(K){var N,O,S,Q;switch(this._iMode){case 0:N=this._getFocusedDate();O=this._getMonths();S=new e(k.call(this));S.setMonth(S.getMonth()+O);N.setMonth(N.getMonth()+O);this._setFocusedDate(N);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");Q.nextPage();s.call(this);}break;}};j.prototype._showOverlay=function(){this.$("contentOver").css("display","");};j.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};j.prototype._getShowItemHeader=function(){var K=this.getMonths();if(K>this._iDaysMonthsHead){return true;}else{return false;}};function _(S,K,N){var O=new e(this._oMaxDate);O.setDate(1);O.setMonth(O.getMonth()-this._getMonths()+1);if(O.isBefore(this._oMinDate)){O=new e(this._oMinDate);O.setMonth(O.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new e(this._oMinDate);}else if(S.isAfter(O)){S=O;}S.setDate(1);var Q=S.toLocalJSDate();this.setProperty("startDate",Q,true);this._oStartDate=S;var T=this.getAggregation("monthsRow");T.setStartDate(Q);p.call(this);if(K){var U=this._getFocusedDate().toLocalJSDate();if(!T.checkDateFocusable(U)){this._setFocusedDate(S);T.setDate(Q);}else{T.setDate(U);}}if(!N){this.fireStartDateChange();}}function k(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}function l(N){var K=this._getFocusedDate();var O=this.getAggregation("monthsRow");if(!N){O.setDate(K.toLocalJSDate());}else{O.displayDate(K.toLocalJSDate());}p.call(this);}function m(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=e.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new e();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new e(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new e(this._oMaxDate);}}function n(){var K=this._getFocusedDate();var N=this.getAggregation("yearPicker");if(N.getDomRef()){N.$().css("display","");}else{var O=sap.ui.getCore().createRenderManager();var $=this.$("content");O.renderControl(N);O.flush($[0],false,true);O.destroy();}this._showOverlay();N.setDate(K.toLocalJSDate());if(this._iMode==0){var Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}s.call(this);this._iMode=1;}function o(N){this._iMode=0;var K=this.getAggregation("yearPicker");K.$().css("display","none");this._hideOverlay();if(!N){l.call(this);var O=this.getAggregation("monthsRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function p(){t.call(this);r.call(this);}function r(){var K=new e(k.call(this));var N=this._getMonths();var O=K.getYear();var Q=this._oMaxDate.getYear();var S=this._oMinDate.getYear();var T=K.getMonth();var U=this._oMaxDate.getMonth();var V=this._oMinDate.getMonth();var W=this.getAggregation("header");if(O<S||(O==S&&T<=V)){W.setEnabledPrevious(false);}else{W.setEnabledPrevious(true);}K.setMonth(K.getMonth()+N-1);O=K.getYear();T=K.getMonth();if(O>Q||(O==Q&&T>=U)){W.setEnabledNext(false);}else{W.setEnabledNext(true);}}function s(){var K=this.getAggregation("yearPicker");var N=K.getYears();var O=e.fromLocalJSDate(K.getFirstRenderedDate());O.setYear(O.getYear()+Math.floor(N/2));var Q=this.getAggregation("header");var S=new e(this._oMaxDate);S.setYear(S.getYear()-Math.ceil(N/2));S.setMonth(11,31);var T=new e(this._oMinDate);T.setYear(T.getYear()+Math.floor(N/2)+1);T.setMonth(0,1);Q.setEnabledNext(!O.isAfter(S));Q.setEnabledPrevious(!O.isBefore(T));}function t(){var T;var S=k.call(this);var K=this._oYearFormat.format(S.toUTCJSDate(),true);var N=new e(S);N.setMonth(N.getMonth()+this._getMonths()-1);var O=this._oYearFormat.format(N.toUTCJSDate(),true);if(K!=O){var Q=this._getLocaleData();var U=Q.getIntervalPattern();T=U.replace(/\{0\}/,K).replace(/\{1\}/,O);}else{T=K;}var V=this.getAggregation("header");V.setTextButton2(T);}function u(K,N){var O;var Q=false;if(K.isBefore(this._oMinDate)){O=this._oMinDate;Q=true;}else if(K.isAfter(this._oMaxDate)){O=this._oMaxDate;Q=true;}else{O=K;}this._setFocusedDate(O);if(Q||N){F.call(this,O);l.call(this,false);this.fireStartDateChange();}}function v(K,S){if(!K){return;}var N=e.fromLocalJSDate(K);if(this._oFocusedDate&&this._oFocusedDate.isSame(N)){return;}var O=N.getYear();c._checkYearInValidRange(O);if(c._isOutside(N,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(N);if(this.getDomRef()&&this._iMode==0){l.call(this,S);}}function w(K){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){n.call(this);}else{o.call(this);}}}j.prototype._showCalendarPicker=function(){var K=this._getFocusedDate(true).toLocalJSDate();var N=this._getCalendarPicker();var S=new sap.ui.unified.DateRange({startDate:K});N.displayDate(K,false);N.removeAllSelectedDates();N.addSelectedDate(S);N.setMinDate(this.getMinDate());N.setMaxDate(this.getMaxDate());G.call(this,N);this._showOverlay();};function x(N){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!N){l.call(this);var K=this.getAggregation("monthsRow");q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function y(K){this.fireSelect();}function z(K){var N=e.fromLocalJSDate(K.getParameter("date"));var O=K.getParameter("notVisible");u.call(this,N,O);}function A(K){var N=new e(this._getFocusedDate());var O=this._getCalendarPicker();var S=O.getSelectedDates()[0].getStartDate();var Q=e.fromLocalJSDate(S);Q.setMonth(N.getMonth());Q.setDate(N.getDate());u.call(this,Q,true);x.call(this);}function B(K){var N=new e(this._getFocusedDate());var O=this.getAggregation("yearPicker");var Q=e.fromLocalJSDate(O.getDate());Q.setMonth(N.getMonth());Q.setDate(N.getDate());N=Q;u.call(this,N,true);o.call(this);}function E(){this._sInvalidateContent=undefined;var K=this.getAggregation("monthsRow");if(K){K._bDateRangeChanged=true;K._bInvalidateSync=true;K.invalidate();K._bInvalidateSync=undefined;}this._bDateRangeChanged=undefined;}function F(K){var N=this.getAggregation("monthsRow");var S=k.call(this);var O=N._oItemNavigation.getFocusedIndex();S=new e(K);S.setMonth(S.getMonth()-O);_.call(this,S,false,true);}function G(K){if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(I,this);this._oPopup.onsapescape=function(Q){this._oCalendar.onsapescape(Q);};}this._oPopup.setContent(K);var N=this.getAggregation("header");var O=P.Dock;this._oPopup.open(0,O.CenterTop,O.CenterTop,N,null,"flipfit",true);}function I(K){x.call(this);}function J(K){s.call(this);}return j;});
