/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(C,D,L,a,U,l,I,b,R,c,d,e,q){"use strict";var f=l.CalendarDayType;var g=l.CalendarAppointmentVisualization;var G=l.GroupAppointmentsMode;var h=l.CalendarIntervalType;var m=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:h.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:g.Standard}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});m.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatAria=b.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);this.aSelectedAppointments=[];this._fnCustomSortedAppointments=undefined;};m.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._fnCustomSortedAppointments=undefined;};m.prototype.onBeforeRendering=function(){p.call(this);t.call(this);x.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};m.prototype.onAfterRendering=function(){y.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}};m.prototype.onThemeChanged=function(j){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var k=this._aVisibleAppointments[i];k.level=-1;}this.handleResize(j);}};m.prototype.invalidate=function(O){if(O&&O instanceof sap.ui.unified.CalendarAppointment){var j=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==O){j=true;break;}}if(j){this._aVisibleAppointments=[];}this._updateSelectedAppointmentsArray(O);}C.prototype.invalidate.apply(this,arguments);};m.prototype.setStartDate=function(S){if(!S){S=new Date();}a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);this.setProperty("startDate",S);return this;};m.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};m.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};m.prototype.setGroupAppointmentsMode=function(i){this.setProperty("groupAppointmentsMode",i);this._aVisibleAppointments=[];return this;};m.prototype.setAppointmentsReducedHeight=function(i){this.setProperty("appointmentsReducedHeight",i);this._aVisibleAppointments=[];return this;};m.prototype._getAppointmentReducedHeight=function(i){var j=false;if(!D.system.phone&&this.getAppointmentsReducedHeight()&&!i.getText()){j=true;}return j;};m.prototype.onfocusin=function(j){if(q(j.target).hasClass("sapUiCalendarApp")){F.call(this,j.target.id);}else{var V=this._getVisibleAppointments();var k=false;var N;for(var i=0;i<V.length;i++){N=V[i].appointment;if(e(N.getDomRef(),j.target)){k=true;N.focus();break;}}if(!k){N=this.getFocusedAppointment();if(N){N.focus();}}}};m.prototype.applyFocusInfo=function(i){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};m.prototype.onsapleft=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){H.call(this,this._bRTL,1);}i.preventDefault();i.stopPropagation();};m.prototype.onsapright=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){H.call(this,!this._bRTL,1);}i.preventDefault();i.stopPropagation();};m.prototype.onsapup=function(i){this.fireLeaveRow({type:i.type});};m.prototype.onsapdown=function(i){this.fireLeaveRow({type:i.type});};m.prototype.onsaphome=function(i){J.call(this,i);i.preventDefault();i.stopPropagation();};m.prototype.onsapend=function(i){J.call(this,i);i.preventDefault();i.stopPropagation();};m.prototype.onsapselect=function(j){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var k=V[i].appointment;if(e(k.getDomRef(),j.target)){z.call(this,k,!(j.ctrlKey||j.metaKey));break;}}j.stopPropagation();j.preventDefault();};m.prototype.ontap=function(i){var j=this.$("Apps").children(".sapUiCalendarRowAppsInt");var k=0;var N=false;for(k=0;k<j.length;k++){var O=j[k];if(!this._isOneMonthIntervalOnSmallSizes()&&e(O,i.target)){N=true;break;}}if(N){K.call(this,k,i.target);}else{this.onsapselect(i);}};m.prototype.onsapselectmodifiers=function(i){this.onsapselect(i);};m.prototype.handleResize=function(i){if(i&&i.size&&i.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");y.call(this);return this;};m.prototype.updateCurrentTimeVisualization=function(){var N=this.$("Now");var i=a._createUniversalUTCDate(new Date(),undefined,true);var j=this.getIntervals();var k=this.getIntervalType();var S=this._getStartDate();var O=S.getTime();var P=this._oUTCEndDate;var Q=P.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=Q&&i.getTime()>=O){var T=v.call(this,k,j,S,P,O,i);var V=0;if(this._bRTL){N.css("right",T+"%");}else{N.css("left",T+"%");}N.css("display","");if(this.getUpdateCurrentTime()){switch(k){case h.Hour:V=60000;break;case h.Day:case h.Week:case h.OneMonth:V=1800000;break;default:V=-1;break;}if(V>0){this._sUpdateCurrentTime=setTimeout(this.updateCurrentTimeVisualization.bind(this),V);}}}else{N.css("display","none");}return this;};m.prototype.getFocusedAppointment=function(){var j=this._getAppointmentsSorted();var k=this.getAggregation("groupAppointments",[]);var N;var i=0;for(i=0;i<k.length;i++){if(k[i].getId()==this._sFocusedAppointmentId){N=k[i];break;}}if(!N){for(i=0;i<j.length;i++){if(j[i].getId()==this._sFocusedAppointmentId){N=j[i];break;}}}return N;};m.prototype.focusAppointment=function(i){if(!i||!(i instanceof sap.ui.unified.CalendarAppointment)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var j=i.getId();if(this._sFocusedAppointmentId!=j){F.call(this,j);}else{i.focus();}return this;};m.prototype.focusNearestAppointment=function(j){a._checkJSDateObject(j);var k=this._getAppointmentsSorted();var N;var P;var O;for(var i=0;i<k.length;i++){N=k[i];if(N.getStartDate()>j){if(i>0){P=k[i-1];}else{P=N;}break;}}if(N){if(P&&Math.abs(N.getStartDate()-j)>=Math.abs(P.getStartDate()-j)){O=P;}else{O=N;}this.focusAppointment(O);}return this;};m.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};m.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};m.prototype._getNonWorkingDays=function(){var N=this.getNonWorkingDays();if(!N){var j=o.call(this);var W=j.getWeekendStart();var k=j.getWeekendEnd();N=[];for(var i=0;i<=6;i++){if((W<=k&&i>=W&&i<=k)||(W>k&&(i>=W||i<=k))){N.push(i);}}}else if(!Array.isArray(N)){N=[];}return N;};m.prototype._isOneMonthIntervalOnSmallSizes=function(){return this.getIntervalType()===h.OneMonth&&this.getIntervals()===1;};m.prototype._getAppointmentsSorted=function(){var i=this.getAppointments(),j=M;i.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:j);return i;};m.prototype._setCustomAppointmentsSorterCallback=function(S){this._fnCustomSortedAppointments=S;this.invalidate();};m.prototype._calculateAppoitnmentVisualCue=function(i){if(_(this,i)){return{appTimeUnitsDifRowStart:0,appTimeUnitsDifRowEnd:0};}var j=i.getStartDate(),k=i.getEndDate(),N=new U(j.getFullYear(),j.getMonth(),j.getDate(),j.getHours(),j.getMinutes()),O=new U(k.getFullYear(),k.getMonth(),k.getDate(),k.getHours(),k.getMinutes()),P=this.getIntervalType(),T=this.getStartDate(),Q=P==="Hour"?new U(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours()):new U(T.getFullYear(),T.getMonth(),T.getDate()),S=this.getIntervals(),V;switch(P){case"Hour":V=new U(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours()+S);break;case"Day":case"Week":case"One Month":V=new U(T.getFullYear(),T.getMonth(),T.getDate()+S);break;case"Month":V=new U(T.getFullYear(),T.getMonth()+S,T.getDate());break;default:break;}return{appTimeUnitsDifRowStart:Q.getTime()-N.getTime(),appTimeUnitsDifRowEnd:O.getTime()-V.getTime()};};m.prototype._updateSelectedAppointmentsArray=function(i){if(i.getSelected()){if(this.aSelectedAppointments.indexOf(i.getId())===-1){this.aSelectedAppointments.push(i.getId());}}else{this.aSelectedAppointments=this.aSelectedAppointments.filter(function(j){return j!==i.getId();});}};function _(j,k){var N=j.getAggregation("groupAppointments",[]);var i;for(i=0;i<N.length;++i){if(k===N[i]){return true;}}return false;}function n(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}function o(){if(!this._oLocaleData){var i=n.call(this);var j=new c(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}function p(){var S=this.getStartDate();var i;var j=this.getIntervals();var k=this.getIntervalType();this._oUTCStartDate=r.call(this,S);switch(k){case h.Hour:i=new U(this._oUTCStartDate.getTime());i.setUTCHours(i.getUTCHours()+j);this._iMinDelta=this._iHoursMinDelta;break;case h.Day:case h.Week:case h.OneMonth:i=new U(this._oUTCStartDate.getTime());i.setUTCDate(i.getUTCDate()+j);this._iMinDelta=this._iDaysMinDelta;break;case h.Month:i=new U(this._oUTCStartDate.getTime());i.setUTCMonth(i.getUTCMonth()+j);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}i.setUTCMilliseconds(-1);this._iRowSize=i.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/j);this._oUTCEndDate=i;}function r(i){var j=this.getIntervalType();var k=a._createUniversalUTCDate(i,undefined,true);switch(j){case h.Hour:k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case h.Day:case h.Week:case h.OneMonth:k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case h.Month:k.setUTCDate(1);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+j+"; "+this);}return k;}function s(){return D.system.phone||(this.getGroupAppointmentsMode()===G.Collapsed);}function t(){var N=this._getAppointmentsSorted();var O;var P;var Q;var S=this.getIntervals();var T=this.getIntervalType();var V=this._getStartDate();var W=V.getTime();var X=this._oUTCEndDate;var Y=X.getTime();var Z=[];var $=false;var i=0;var j=0;var a1=s.call(this);this.destroyAggregation("groupAppointments",true);for(i=0;i<N.length;i++){O=N[i];var b1=a._createUniversalUTCDate(O.getStartDate(),undefined,true);b1.setUTCSeconds(0);b1.setUTCMilliseconds(0);var c1=O.getEndDate()?a._createUniversalUTCDate(O.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);c1.setUTCSeconds(0);c1.setUTCMilliseconds(0);var d1=false;if(b1.getTime()<W&&c1.getTime()>=W){b1=new U(W);d1=true;}if(c1.getTime()>Y&&b1.getTime()<=Y){c1=new U(Y);d1=true;}var e1=b1.getUTCHours()*60+b1.getUTCMinutes();b1.setUTCMinutes(b1.getUTCMinutes()-(e1%this._iMinDelta));var f1=(c1.getTime()-b1.getTime())/60000;if(d1&&f1==0){continue;}var g1=0;var h1=0;var i1=-1;P=undefined;Q=undefined;if(b1&&b1.getTime()<=Y&&c1&&c1.getTime()>=W){if(a1&&(T==h.Month)&&((c1.getTime()-b1.getTime())<604800000)){P=u.call(this,b1,O,T,S,V,X,W,Z);var j1=a._createUniversalUTCDate(P.getEndDate(),undefined,true);if(c1.getTime()>j1.getTime()){Q=u.call(this,c1,O,T,S,V,X,W,Z);}}g1=v.call(this,T,S,V,X,W,b1);h1=w.call(this,T,S,V,X,W,c1);if(P){P._iBegin=g1;P._iEnd=h1;P._iLevel=i1;if(Q){Q._iBegin=g1;Q._iEnd=h1;Q._iLevel=i1;}continue;}Z.push({appointment:O,begin:g1,end:h1,calculatedEnd:h1,level:i1});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==O.getId()){$=true;}}}var k1=this.getAggregation("groupAppointments",[]);if(k1.length>0){for(i=0;i<Z.length;i++){O=Z[i];if(O.appointment._aAppointments&&O.appointment._aAppointments.length<=1){P=O.appointment;var l1=false;if(P._aAppointments.length==0){l1=true;}else{for(j=0;j<Z.length;j++){if(Z[j].appointment==P._aAppointments[0]){l1=true;break;}}}if(!l1){for(j=0;j<k1.length;j++){Q=k1[j];if(P!=Q){for(var k=0;k<Q._aAppointments.length;k++){if(P._aAppointments[0]==Q._aAppointments[k]){Q._aAppointments.splice(k,1);if(Q._aAppointments.length==1){this.removeAggregation("groupAppointments",Q);Q.destroy();k1=this.getAggregation("groupAppointments",[]);}else{Q.setProperty("title",Q._aAppointments.length,true);}break;}}}}O.begin=P._iBegin;O.end=P._iEnd;O.calculatedEnd=P._iEnd;O.level=P._iLevel;O.appointment=P._aAppointments[0];}else{Z.splice(i,1);i--;}this.removeAggregation("groupAppointments",P);P.destroy();k1=this.getAggregation("groupAppointments",[]);}}}if(!$){if(Z.length>0){this._sFocusedAppointmentId=Z[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=Z;return this._aVisibleAppointments;}function u(i,k,N,O,S,P,Q,V){var T=this.getAggregation("groupAppointments",[]);var W;var X=o.call(this);var Y=X.getFirstDayOfWeek();var Z=i.getUTCDay();var $=new U(i.getTime());$.setUTCHours(0);$.setUTCMinutes(0);$.setUTCSeconds(0);$.setUTCMilliseconds(0);if(Y<=Z){$.setDate($.getDate()-(Z-Y));}else{$.setDate($.getDate()-(7-Z-Y));}for(var j=0;j<T.length;j++){W=T[j];var a1=a._createUniversalUTCDate(W.getStartDate(),undefined,true);if(a1.getTime()==$.getTime()){break;}W=undefined;}if(!W){var b1=new U($.getTime());b1.setDate(b1.getDate()+7);b1.setMilliseconds(-1);W=new sap.ui.unified.CalendarAppointment(this.getId()+"-Group"+T.length,{type:k.getType(),startDate:a._createLocalDate(new Date($.getTime()),true),endDate:a._createLocalDate(new Date(b1.getTime()),true)});W._aAppointments=[];this.addAggregation("groupAppointments",W,true);var c1=v.call(this,N,O,S,P,Q,$);var d1=w.call(this,N,O,S,P,Q,b1);V.push({appointment:W,begin:c1,end:d1,calculatedEnd:d1,level:-1});}W._aAppointments.push(k);if(W.getType()!=f.None&&W.getType()!=k.getType()){W.setType(f.None);}W.setProperty("title",W._aAppointments.length,true);return W;}function v(i,j,S,k,N,O){var P=0;if(i!=h.Month){P=100*(O.getTime()-N)/this._iRowSize;}else{var Q=new U(O.getTime());Q.setUTCDate(1);Q.setUTCHours(0);Q.setUTCMinutes(0);Q.setUTCSeconds(0);Q.setUTCMilliseconds(0);var T=new U(Q.getTime());T.setUTCMonth(T.getUTCMonth()+1);T.setMilliseconds(-1);var V=T.getTime()-Q.getTime();var W=(Q.getUTCFullYear()-S.getUTCFullYear())*12+Q.getUTCMonth()-S.getUTCMonth();P=(100*W/j)+(100*(O.getTime()-Q.getTime())/V)/j;}if(P<0){P=0;}P=Math.round(P*100000)/100000;return P;}function w(i,j,S,k,N,O){var P=0;if(i!=h.Month){P=100-(100*(O.getTime()-N)/this._iRowSize);}else{var Q=new U(O.getTime());Q.setUTCDate(1);Q.setUTCHours(0);Q.setUTCMinutes(0);Q.setUTCSeconds(0);Q.setUTCMilliseconds(0);var T=new U(Q.getTime());T.setUTCMonth(T.getUTCMonth()+1);T.setMilliseconds(-1);var V=T.getTime()-Q.getTime();var W=(Q.getUTCFullYear()-S.getUTCFullYear())*12+Q.getUTCMonth()-S.getUTCMonth();P=100-((100*W/j)+(100*(O.getTime()-Q.getTime())/V)/j);}if(P<0){P=0;}P=Math.round(P*100000)/100000;return P;}function x(){var V=[];if(this.getShowIntervalHeaders()){var k=this.getIntervalHeaders();var N;var O=this.getIntervals();var P=this.getIntervalType();var S=this._getStartDate();var Q=S.getTime();var T=this._oUTCEndDate;var W=T.getTime();var i=0;var j=0;for(i=0;i<k.length;i++){N=k[i];var X=a._createUniversalUTCDate(N.getStartDate(),undefined,true);X.setUTCSeconds(0);X.setUTCMilliseconds(0);var Y=N.getEndDate()?a._createUniversalUTCDate(N.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);Y.setUTCSeconds(0);Y.setUTCMilliseconds(0);if(X&&X.getTime()<=W&&Y&&Y.getTime()>=Q){var Z=new U(S.getTime());var $=new U(S.getTime());$.setUTCMinutes($.getUTCMinutes()-1);var a1=-1;var b1=-1;for(j=0;j<O;j++){switch(P){case h.Hour:$.setUTCHours($.getUTCHours()+1);if(j>0){Z.setUTCHours(Z.getUTCHours()+1);}break;case h.Day:case h.Week:case h.OneMonth:$.setUTCDate($.getUTCDate()+1);if(j>0){Z.setUTCDate(Z.getUTCDate()+1);}break;case h.Month:$.setUTCDate(1);$.setUTCMonth($.getUTCMonth()+2);$.setUTCDate(0);if(j>0){Z.setUTCMonth(Z.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+P+"; "+this);}if(X&&X.getTime()<=Z.getTime()&&Y&&Y.getTime()>=$.getTime()){if(a1<0){a1=j;}b1=j;}}if(a1>=0){V.push({interval:a1,appointment:N,last:b1});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}function y(){if(this._isOneMonthIntervalOnSmallSizes()){return;}var $=this.$("Apps");var k=$.innerWidth();if(k<=0){return;}var N=this.$("DummyApp");var O=N.outerHeight(true);if(O<=0){return;}var P=N.outerWidth();var Q=P/k*100;var S=Math.ceil(1000*Q)/1000;var T;var V;var W=0;var X=0;var i=0;var Y=!D.system.phone&&this.getAppointmentsReducedHeight();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){W=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);}for(i=0;i<this._aVisibleAppointments.length;i++){T=this._aVisibleAppointments[i];V=T.appointment.$();var Z=Math.floor(1000*(100-T.calculatedEnd-T.begin))/1000;var a1=false;if(Z<S){T.end=100-T.begin-Q;if(T.end<0){T.end=0;}T.level=-1;a1=true;V.addClass("sapUiCalendarAppSmall");}else if(V.hasClass("sapUiCalendarAppSmall")){T.end=T.calculatedEnd;a1=true;V.removeClass("sapUiCalendarAppSmall");}if(a1){if(this._bRTL){V.css("left",T.end+"%");}else{V.css("right",T.end+"%");}}}for(i=0;i<this._aVisibleAppointments.length;i++){T=this._aVisibleAppointments[i];V=T.appointment.$();var b1={};var c1=Y&&!this._getAppointmentReducedHeight(T.appointment);if(T.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var d1=this._aVisibleAppointments[j];if(T!=d1&&T.begin<(Math.floor(1000*(100-d1.end))/1000)&&(Math.floor(1000*(100-T.end))/1000)>d1.begin&&d1.level>=0){if(b1[d1.level]){b1[d1.level]++;}else{b1[d1.level]=1;}if(Y&&!this._getAppointmentReducedHeight(d1.appointment)){if(b1[d1.level+1]){b1[d1.level+1]++;}else{b1[d1.level+1]=1;}}}}T.level=0;while(b1[T.level]||(c1&&b1[T.level+1])){T.level++;}V.attr("data-sap-level",T.level);}V.css("top",(O*T.level+W)+"px");var e1=T.level;if(c1){e1++;}if(X<e1){X=e1;}}X++;O=O*X+W;if(!this.getHeight()){$.outerHeight(O);}else{var f1=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<f1.length;i++){var g1=q(f1[i]);g1.outerHeight(O);}}N.css("display","none");}function z(j,k){var i=0;var O;var N;var P;var Q;var S=I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");if(k){var T=this.getAppointments();var V=this.getAggregation("groupAppointments",[]);q.merge(T,V);for(i=0;i<T.length;i++){O=T[i];if(O.getId()!==j.getId()&&O.getSelected()){O.setProperty("selected",false,true);O.$().removeClass("sapUiCalendarAppSel");for(var i=0;i<this.aSelectedAppointments.length;i++){if(this.aSelectedAppointments[i]!==O.getId()){this.aSelectedAppointments.splice(i);}}N=O.$().attr("aria-labelledby");P=N?N.replace(S,""):"";O.$().attr("aria-labelledby",P);}}}if(j.getSelected()){j.setProperty("selected",false,true);j.$().removeClass("sapUiCalendarAppSel");B(this,k);}else{j.setProperty("selected",true,true);j.$().addClass("sapUiCalendarAppSel");B(this,k);}this._updateSelectedAppointmentsArray(j);Q=j.$().attr("aria-labelledby")+" "+S;j.$().attr("aria-labelledby",Q);if(j._aAppointments){for(i=0;i<j._aAppointments.length;i++){O=j._aAppointments[i];O.setProperty("selected",true,true);Q=O.$().attr("aria-labelledby")+" "+S;O.$().attr("aria-labelledby",Q);}this.fireSelect({appointments:j._aAppointments,multiSelect:!k,domRefId:j.getId()});}else{this.fireSelect({appointment:j,multiSelect:!k,domRefId:j.getId()});}}function A(i){var P=this._getPlanningCalendar();if(P){P["_onRow"+i]();}}m.prototype._getPlanningCalendar=function(){var P=this;while(P.getParent()!==null){if(P.getMetadata().getName()==="sap.m.PlanningCalendar"){return P;}P=P.getParent();}};function B(i,j){if(j){A.call(i,"DeselectAppointment");}}function E(k){var N=this.getAggregation("groupAppointments",[]);var O;var P=false;for(var i=0;i<N.length;i++){var Q=N[i]._aAppointments;for(var j=0;j<Q.length;j++){if(Q[j].getId()==k){O=N[i];P=true;break;}}if(P){break;}}return O;}function F(j){if(this._sFocusedAppointmentId!=j){var k=this._getAppointmentsSorted();var V=this._aVisibleAppointments;var N;var i=0;N=E.call(this,j);if(N){j=N.getId();N=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==j){N=V[i].appointment;break;}}if(N){var O=this.getFocusedAppointment().$();var $=N.$();this._sFocusedAppointmentId=N.getId();O.attr("tabindex","-1");$.attr("tabindex","0");$.focus();}else{for(i=0;i<k.length;i++){if(k[i].getId()==j){N=k[i];break;}}if(N){this._sFocusedAppointmentId=N.getId();var P=r.call(this,N.getStartDate());this.setStartDate(a._createLocalDate(P,true));if(!e(this.getDomRef(),document.activeElement)){setTimeout(function(){this.getFocusedAppointment().focus();}.bind(this),0);}this.fireStartDateChange();}}}}function H(j,S){var k=this._sFocusedAppointmentId;var N=this._getAppointmentsSorted();var O=this.getAggregation("groupAppointments",[]);var P;var Q=0;var i=0;for(i=0;i<O.length;i++){if(O[i].getId()==k){var T=O[i]._aAppointments;if(j){k=T[T.length-1].getId();}else{k=T[0].getId();}break;}}for(i=0;i<N.length;i++){if(N[i].getId()==k){Q=i;break;}}if(j){Q=Q+S;}else{Q=Q-S;}if(Q<0){Q=0;}else if(Q>=N.length){Q=N.length-1;}P=N[Q];F.call(this,P.getId());}function J(j){var k=this._getAppointmentsSorted();var N;var S=new U(this._getStartDate());var O=new U(this._oUTCEndDate);var P=this.getIntervalType();var Q;var T;S.setUTCHours(0);O.setUTCHours(0);O.setUTCMinutes(0);O.setUTCSeconds(0);switch(P){case h.Hour:O.setUTCDate(O.getUTCDate()+1);O.setUTCMilliseconds(-1);break;case h.Day:case h.Week:case h.OneMonth:S.setUTCDate(1);O.setUTCMonth(O.getUTCMonth()+1);O.setUTCDate(1);O.setUTCMilliseconds(-1);break;case h.Month:S.setUTCMonth(0);S.setUTCDate(1);O.setUTCFullYear(O.getUTCFullYear()+1);O.setUTCMonth(1);O.setUTCDate(1);O.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+P+"; "+this);}var V=a._createLocalDate(S,true);var W=a._createLocalDate(O,true);for(var i=0;i<k.length;i++){if(k[i].getStartDate()>=V&&k[i].getStartDate()<=W){N=k[i];Q=N.getId();if(j.type=="saphome"){break;}}else if(k[i].getStartDate()>W){break;}}T=E.call(this,Q);if(T){N=T;Q=N.getId();}if(Q&&Q!=this._sFocusedAppointmentId){F.call(this,Q);}else if(j._bPlanningCalendar&&N){N.focus();}else{this.fireLeaveRow({type:j.type});}}function K(i,j){var k=this.getIntervalType();var S=this._getStartDate();var N=new U(S.getTime());var O;var P=false;var Q=0;var T=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){P=true;var V=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");T=V.length;for(Q=0;Q<T;Q++){var W=V[Q];if(W==j){break;}}}switch(k){case h.Hour:N.setUTCHours(N.getUTCHours()+i);if(P){N.setUTCMinutes(N.getUTCMinutes()+Q*60/T);O=new U(N.getTime());O.setUTCMinutes(O.getUTCMinutes()+60/T);}else{O=new U(N.getTime());O.setUTCHours(O.getUTCHours()+1);}break;case h.Day:case h.Week:case h.OneMonth:N.setUTCDate(N.getUTCDate()+i);if(P){N.setUTCHours(N.getUTCHours()+Q*24/T);O=new U(N.getTime());O.setUTCHours(O.getUTCHours()+24/T);}else{O=new U(N.getTime());O.setUTCDate(O.getUTCDate()+1);}break;case h.Month:N.setUTCMonth(N.getUTCMonth()+i);if(P){N.setUTCDate(N.getUTCDate()+Q);O=new U(N.getTime());O.setUTCDate(O.getUTCDate()+1);}else{O=new U(N.getTime());O.setUTCMonth(O.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}O.setUTCMilliseconds(O.getUTCMilliseconds()-1);N=a._createLocalDate(N,true);O=a._createLocalDate(O,true);this.fireIntervalSelect({startDate:N,endDate:O,subInterval:P});}function M(i,j){var k=i.getStartDate()-j.getStartDate();if(k==0){k=j.getEndDate()-i.getEndDate();}return k;}return m;});
