/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/f/shellBar/SearchRenderer','sap/m/SearchField','sap/m/OverflowToolbarButton',"sap/m/OverflowToolbarLayoutData","sap/m/Button","sap/ui/events/KeyCodes","./Accessibility","sap/m/library"],function(C,S,a,O,b,B,K,A,l){"use strict";var c=l.ButtonType;var d=l.OverflowToolbarPriority;var e=C.extend("sap.f.shellBar.Search",{metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.f",properties:{isOpen:{type:"boolean",defaultValue:false},phoneMode:{type:"boolean",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{_searchField:{type:"sap.m.SearchField",multiple:false},_searchButton:{type:"sap.m.OverflowToolbarButton",multiple:false},_cancelButton:{type:"sap.m.Button",multiple:false}},events:{search:{parameters:{query:{type:"string"},clearButtonPressed:{type:"boolean"}}},liveChange:{parameters:{newValue:{type:"string"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}},renderer:S});e.prototype.init=function(){this._sOldValue="";this._shouldFocusSearch=false;this._layoutDataWhenOpen=new b({priority:d.NeverOverflow});this._layoutDataWhenClosed=new b({priority:d.Low});this._oAcc=new A();};e.prototype.onBeforeRendering=function(){this._switchOpenStateOnSearch();};e.prototype.onAfterRendering=function(){setTimeout(function(){if(this._shouldFocusSearch){this._getSearchField().getFocusDomRef().focus();this._shouldFocusSearch=false;}}.bind(this),0);};e.prototype.exit=function(){if(this._layoutDataWhenOpen){this._layoutDataWhenOpen.destroy();}if(this._layoutDataWhenClosed){this._layoutDataWhenClosed.destroy();}};e.prototype._getSearchField=function(){var s=this.getAggregation("_searchField");if(!s){s=new a({showSearchButton:false,search:this._onSearch.bind(this),liveChange:this._onLiveChange.bind(this),suggest:this._onSuggest.bind(this)});this.setAggregation("_searchField",s);}return s;};e.prototype._getSearchButton=function(){var s=this.getAggregation("_searchButton");if(!s){s=new O({text:"Search",icon:"sap-icon://search",type:c.Transparent,press:this._onPressSearchButtonHandler.bind(this),tooltip:this._oAcc.getEntityTooltip("SEARCH")});this.setAggregation("_searchButton",s);}return s;};e.prototype._getCancelButton=function(){var o=this.getAggregation("_cancelButton");if(!o){o=new B({text:"Cancel",type:c.Transparent,press:this._onPressCancelButtonHandler.bind(this)});o.addStyleClass("sapFShellBarSearchCancelButton");this.setAggregation("_cancelButton",o);}return o;};e.prototype.toggleVisibilityOfSearchField=function(){var i=this.getIsOpen();this.setIsOpen(!i);this._shouldFocusSearch=!i;this.fireEvent("_updateVisualState",{isOpen:!i});};e.prototype._switchOpenStateOnSearch=function(){var L=this.getIsOpen()?this._layoutDataWhenOpen:this._layoutDataWhenClosed;if(this.getLayoutData()===L){return;}this.setLayoutData(L);};e.prototype._onPressSearchButtonHandler=function(){var s=this._getSearchField();if(s.getValue()&&this.getIsOpen()){this.fireSearch({query:s.getValue(),clearButtonPressed:false});}else{this.toggleVisibilityOfSearchField();}};e.prototype._onPressCancelButtonHandler=function(){this.toggleVisibilityOfSearchField();};e.prototype._onSearch=function(E){var n=E.getParameters();n.id=this.getId();if(E.getParameter("clearButtonPressed")){this._shouldCloseOnNextEscape=false;}this.fireSearch(n);};e.prototype._onLiveChange=function(E){var n=E.getParameters();delete n.refreshButtonPressed;delete n.suggestionItem;n.id=this.getId();this._shouldCloseOnNextEscape=!n.newValue;this.fireLiveChange(n);};e.prototype._onSuggest=function(E){var n=E.getParameters();n.id=this.getId();this.fireSuggest(n);};e.prototype.onkeyup=function(E){var s=this._getSearchField();if(E.keyCode===K.ESCAPE){if(s._oSuggest&&s._oSuggest.isOpen()){return;}if(this._shouldCloseOnNextEscape){this._shouldCloseOnNextEscape=false;return;}this.toggleVisibilityOfSearchField();}};e.prototype._onBeforeEnterOverflow=function(){var s=this._getSearchButton();s._bInOverflow=true;s.addStyleClass("sapFShellBarSearchOverflowToolbar");};e.prototype._onAfterExitOverflow=function(){var s=this._getSearchButton();s._bInOverflow=false;s.removeStyleClass("sapFShellBarSearchOverflowToolbar");};e.prototype.getOverflowToolbarConfig=function(){var o={canOverflow:true};o.onBeforeEnterOverflow=this._onBeforeEnterOverflow.bind(this);o.onAfterExitOverflow=this._onAfterExitOverflow.bind(this);return o;};return e;});
