/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Bar','./InstanceManager','./AssociativeOverflowToolbar','./ToolbarSpacer','./Title','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Popup','sap/ui/core/delegate/ScrollEnablement','sap/ui/core/RenderManager','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/library','./TitlePropagationSupport','./DialogRenderer',"sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Configuration","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable"],function(B,I,A,T,a,l,C,b,P,S,R,c,d,D,M,f,g,h,L,q,j,k){"use strict";var O=f.OpenState;var m=l.DialogType;var n=l.DialogRoleType;var V=f.ValueState;var s=j.getConfiguration().getAnimationMode();var u=s!==k.AnimationMode.none&&s!==k.AnimationMode.minimal;var o=u?300:10;var p=17;var r=C.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:m.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false},escapeHandler:{type:"any",group:"Behavior",defaultValue:null},role:{type:"sap.m.DialogRoleType",group:"Data",defaultValue:n.Dialog,visibility:"hidden"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_title:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_valueState:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}},designtime:"sap/m/designtime/Dialog.designtime"}});g.call(r.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false;});r._bPaddingByDefault=(sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0);r._mIcons={};r._mIcons[V.Success]=b.getIconURI("message-success");r._mIcons[V.Warning]=b.getIconURI("message-warning");r._mIcons[V.Error]=b.getIconURI("message-error");r._mIcons[V.Information]=b.getIconURI("hint");r.prototype.init=function(){var e=this;this._externalIcon=undefined;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._scrollContentList=["sap.m.NavContainer","sap.m.Page","sap.m.ScrollContainer","sap.m.SplitContainer","sap.m.MultiInput","sap.m.SimpleFixFlex"];this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");if(D.os.ios&&D.system.phone&&!this._bMessageType){this.oPopup.setModal(true,"sapMDialogTransparentBlk");}else{this.oPopup.setModal(true,"sapMDialogBlockLayerInit");}this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this.oPopup._applyPosition=function(i,F){var v;var w;e._setDimensions();e._adjustScrollingPane();i.at={};if(e._oManuallySetPosition){i.at.left=e._oManuallySetPosition.x;i.at.top=e._oManuallySetPosition.y;}else{if(window.scrollY===undefined){v=window.pageYOffset;}else{v=window.scrollY;}if(D.os.ios||v<0){v=0;}i.at.top='calc(50% + '+v+'px)';if(e._bRTL){i.at.left='auto';}else{if(window.scrollX===undefined){w=window.pageXOffset;}else{w=window.scrollX;}if(D.os.ios||w<0){w=0;}i.at.left='calc(50% + '+w+'px)';}}e._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,i);e._registerContentResizeHandler();};if(r._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding");}this._initTitlePropagationSupport();};r.prototype.onBeforeRendering=function(){if(this._hasSingleScrollableContent()){this.setProperty("verticalScrolling",false);this.setProperty("horizontalScrolling",false);L.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()});}this._createToolbarButtons();if(sap.ui.getCore().getConfiguration().getAccessibility()&&this.getState()!=V.None){var v=new c({text:this.getValueStateString(this.getState())});this.setAggregation("_valueState",v);this.addAriaLabelledBy(v.getId());}};r.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus();}};r.prototype.exit=function(){I.removeDialogInstance(this);this._deregisterContentResizeHandler();this._deregisterResizeHandler();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._header){this._header.destroy();this._header=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._toolbarSpacer){this._toolbarSpacer.destroy();this._toolbarSpacer=null;}};r.prototype.open=function(){var e=this.oPopup;e.setInitialFocusId(this.getId());var i=e.getOpenState();switch(i){case O.OPEN:case O.OPENING:return this;case O.CLOSING:this._bOpenAfterClose=true;break;default:}this._oCloseTrigger=null;this.fireBeforeOpen();e.attachOpened(this._handleOpened,this);this._iLastWidthAndHeightWithScroll=null;e.setContent(this);e.open();this._registerResizeHandler();I.addDialogInstance(this);return this;};r.prototype.close=function(){this._bOpenAfterClose=false;this.$().removeClass('sapDialogDisableTransition');this._deregisterResizeHandler();var e=this.oPopup;var i=this.oPopup.getOpenState();if(!(i===O.CLOSED||i===O.CLOSING)){l.closeKeyboard();this.fireBeforeClose({origin:this._oCloseTrigger});e.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;e.close();this._deregisterContentResizeHandler();}return this;};r.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen();};r.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen();};r.prototype._handleClosed=function(){if(!this.oPopup){return;}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}I.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});if(this._bOpenAfterClose){this._bOpenAfterClose=false;this.open();}};r.prototype.onfocusin=function(e){var i=e.target;if(i.id===this.getId()+"-firstfe"){var v=this.$("footer").lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||(this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef());if(v){v.focus();}}else if(i.id===this.getId()+"-lastfe"){var F=(this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef())||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(F){F.focus();}}};r.prototype._getPromiseWrapper=function(){var e=this;return{reject:function(){e.currentPromise.reject();},resolve:function(){e.currentPromise.resolve();}};};r.prototype.onsapescape=function(e){var E=this.getEscapeHandler(),i={},v=this;if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}this._oCloseTrigger=null;if(typeof E==='function'){new window.Promise(function(w,x){i.resolve=w;i.reject=x;v.currentPromise=i;E(v._getPromiseWrapper());}).then(function(w){v.close();}).catch(function(){L.info("Disallow dialog closing");});}else{this.close();}e.stopPropagation();};r.prototype._openAnimation=function($,i,e){$.addClass("sapMDialogOpen");$.css("display","block");setTimeout(e,o);};r.prototype._closeAnimation=function($,i,e){$.removeClass("sapMDialogOpen");setTimeout(e,o);};r.prototype._setDimensions=function(){var $=this.$(),e=this.getStretch(),i=this.getStretchOnPhone()&&D.system.phone,v=this._bMessageType,w={};if(!e){if(!this._oManuallySetSize){w.width=this.getContentWidth()||undefined;w.height=this.getContentHeight()||undefined;}else{w.width=this._oManuallySetSize.width;w.height=this._oManuallySetSize.height;}}if(w.width=='auto'){w.width=undefined;}if(w.height=='auto'){w.height=undefined;}if((e&&!v)||(i)){this.$().addClass('sapMDialogStretched');}$.css(w);if(!e&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._applyCustomTranslate();}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){$.find('> footer').css({bottom:'0.001px'});}};r.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh();}};r.prototype._reposition=function(){};r.prototype._repositionAfterOpen=function(){};r.prototype._reapplyPosition=function(){this._adjustScrollingPane();};r.prototype._onResize=function(){var $=this.$(),e=this.$('cont'),i,v=this.getContentHeight(),w=this.getContentWidth(),x,y=Math.floor(window.innerWidth*0.9),z=2,E=D.browser,F=0;if(this._oManuallySetSize){e.css({width:'auto'});return;}if(!v||v=='auto'){i=e.scrollTop();e.css({height:'auto'});$.children().each(function(){F+=q(this).outerHeight(true);});if(this.getStretch()||F>$.innerHeight()){x=parseFloat($.height())+z;e.height(Math.round(x));}e.scrollTop(i);}if(D.system.desktop&&!E.chrome){var H=e[0].clientHeight<e[0].scrollHeight,G=e.width()+"x"+e.height(),J=$.css("min-width")!==$.css("width");if(G!==this._iLastWidthAndHeightWithScroll&&J){if(H&&(!w||w=='auto')&&!this.getStretch()&&e.width()<y){$.addClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":p});this._iLastWidthAndHeightWithScroll=G;}else{$.removeClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":""});this._iLastWidthAndHeightWithScroll=null;}}}if(!this.getStretch()&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._applyCustomTranslate();}};r.prototype._applyCustomTranslate=function(){if(D.browser.msie){return;}var $=this.$(),e,i,v=$.innerWidth(),w=$.innerHeight();if(D.system.desktop&&(v%2!==0||w%2!==0)){if(!this._bRTL){e='-'+Math.floor(v/2)+"px";}else{e=Math.floor(v/2)+"px";}i='-'+Math.floor(w/2)+"px";var x='translate('+e+','+i+') scale(1) ';$.css('transform',x);$.css('-webkit-transform',x+' translateZ(0px)');}else{$.css('transform','');$.css('-webkit-transform','');}};r.prototype._createHeader=function(){if(!this._header){this._header=new B(this.getId()+"-header");this._header._setRootAccessibilityRole("heading");this.setAggregation("_header",this._header,false);}};r.prototype._hasSingleScrollableContent=function(){var e=this.getContent();while(e.length===1&&e[0]instanceof C&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent();}if(e.length===1&&e[0]instanceof C&&e[0].isA(this._scrollContentList)){return true;}return false;};r.prototype._initBlockLayerAnimation=function(){this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};};r.prototype._clearBlockLayerAnimation=function(){if(D.os.ios&&D.system.phone&&!this._bMessageType){delete this.oPopup._showBlockLayer;this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};}};r.prototype._getFocusId=function(){return this.getInitialFocus()||this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElementId()||this._getFirstVisibleButtonId()||this.getId();};r.prototype._getFirstVisibleButtonId=function(){var e=this.getBeginButton(),E=this.getEndButton(),v=this.getButtons(),w="";if(e&&e.getVisible()){w=e.getId();}else if(E&&E.getVisible()){w=E.getId();}else if(v&&v.length>0){for(var i=0;i<v.length;i++){if(v[i].getVisible()){w=v[i].getId();break;}}}return w;};r.prototype._getFirstFocusableContentSubHeader=function(){var $=this.$().find('.sapMDialogSubHeader');var e;var F=$.firstFocusableDomRef();if(F){e=F.id;}return e;};r.prototype._getFirstFocusableContentElementId=function(){var e="";var $=this.$("cont");var F=$.firstFocusableDomRef();if(F){e=F.id;}return e;};r.prototype._setInitialFocus=function(){var F=this._getFocusId();var e=sap.ui.getCore().byId(F);var i;if(e){if(e.getVisible&&!e.getVisible()){this.focus();return;}i=e.getFocusDomRef();}i=i||((F?window.document.getElementById(F):null));if(!i){this.setInitialFocus("");i=sap.ui.getCore().byId(this._getFocusId());}if(!this.getInitialFocus()){this.setAssociation('initialFocus',i?i.id:this.getId(),true);}if(D.system.desktop||(i&&!/input|textarea|select/i.test(i.tagName))){if(i){i.focus();}}else{this.focus();}};r.prototype.getScrollDelegate=function(){return this._oScroller;};r.prototype._composeAggreNameInHeader=function(e){var H;if(e==="Begin"){H="contentLeft";}else if(e==="End"){H="contentRight";}else{H="content"+e;}return H;};r.prototype._isToolbarEmpty=function(){var e=this._oToolbar.getContent().filter(function(i){return i.getMetadata().getName()!=='sap.m.ToolbarSpacer';});return e.length===0;};r.prototype._setButton=function(e,i,v){return this;};r.prototype._getButton=function(e){var i=e.toLowerCase()+"Button",v="_o"+this._firstLetterUpperCase(e)+"Button";if(D.system.phone){return this.getAggregation(i,null,true);}else{return this[v];}};r.prototype._getButtonFromHeader=function(e){if(this._header){var H=this._composeAggreNameInHeader(this._firstLetterUpperCase(e)),i=this._header.getAggregation(H);return i&&i[0];}else{return null;}};r.prototype._firstLetterUpperCase=function(v){return v.charAt(0).toUpperCase()+v.slice(1);};r.prototype._getAnyHeader=function(){var e=this.getCustomHeader();if(e){return e._setRootAccessibilityRole("heading");}else{var i=this.getShowHeader();if(!i){return null;}this._createHeader();return this._header;}};r.prototype._deregisterResizeHandler=function(){if(this._resizeListenerId){d.deregister(this._resizeListenerId);this._resizeListenerId=null;}D.resize.detachHandler(this._onResize,this);};r.prototype._registerResizeHandler=function(){var _=this.$("scroll");this._resizeListenerId=d.register(_.get(0),q.proxy(this._onResize,this));D.resize.attachHandler(this._onResize,this);this._onResize();};r.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){d.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};r.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=d.register(this.getDomRef("scrollCont"),q.proxy(this._onResize,this));}this._onResize();};r.prototype._attachHandler=function(e){var i=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){i._oCloseTrigger=this;},onkeyup:function(){i._oCloseTrigger=this;},onkeydown:function(){i._oCloseTrigger=this;}};}if(e){e.addDelegate(this._oButtonDelegate,true,e);}};r.prototype._createToolbarButtons=function(){var e=this._getToolbar();var i=this.getButtons();var v=this.getBeginButton();var w=this.getEndButton(),x=this,y=[v,w];y.forEach(function(z){if(z&&x._oButtonDelegate){z.removeDelegate(x._oButtonDelegate);}});e.removeAllContent();if(!("_toolbarSpacer"in this)){this._toolbarSpacer=new T();}e.addContent(this._toolbarSpacer);y.forEach(function(z){x._attachHandler(z);});if(i&&i.length){i.forEach(function(z){e.addContent(z);});}else{if(v){e.addContent(v);}if(w){e.addContent(w);}}};r.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new A(this.getId()+"-footer").addStyleClass("sapMTBNoBorders");this._oToolbar.addDelegate({onAfterRendering:function(){if(this.getType()===m.Message){this.$("footer").removeClass("sapContrast sapContrastPlus");}}},false,this);this.setAggregation("_toolbar",this._oToolbar);}return this._oToolbar;};r.prototype.getValueStateString=function(v){var e=sap.ui.getCore().getLibraryResourceBundle("sap.m");switch(v){case(V.Success):return e.getText("LIST_ITEM_STATE_SUCCESS");case(V.Warning):return e.getText("LIST_ITEM_STATE_WARNING");case(V.Error):return e.getText("LIST_ITEM_STATE_ERROR");case(V.Information):return e.getText("LIST_ITEM_STATE_INFORMATION");default:return"";}};r.prototype.setSubHeader=function(e){this.setAggregation("subHeader",e);if(e){e.setVisible=function(i){this.$().toggleClass('sapMDialogWithSubHeader',i);e.setProperty("visible",i);}.bind(this);}return this;};r.prototype.setLeftButton=function(v){if(typeof v==="string"){v=sap.ui.getCore().byId(v);}this.setBeginButton(v);return this.setAssociation("leftButton",v);};r.prototype.setRightButton=function(v){if(typeof v==="string"){v=sap.ui.getCore().byId(v);}this.setEndButton(v);return this.setAssociation("rightButton",v);};r.prototype.getLeftButton=function(){var e=this.getBeginButton();return e?e.getId():null;};r.prototype.getRightButton=function(){var e=this.getEndButton();return e?e.getId():null;};r.prototype.setBeginButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogBeginButton");}return this.setAggregation("beginButton",e);};r.prototype.setEndButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogEndButton");}return this.setAggregation("endButton",e);};r.prototype.getAggregation=function(e,i,v){var w=C.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(e==='buttons'&&w.length===0){this.getBeginButton()&&w.push(this.getBeginButton());this.getEndButton()&&w.push(this.getEndButton());}return w;};r.prototype.getAriaLabelledBy=function(){var e=this._getAnyHeader(),i=this.getAssociation("ariaLabelledBy",[]).slice();var v=this.getSubHeader();if(v){i.unshift(v.getId());}if(e){var w=e.findAggregatedObjects(true,function(x){return x.isA("sap.m.Title");});if(w.length){i=w.map(function(x){return x.getId();}).concat(i);}else{i.unshift(e.getId());}}return i;};r.prototype.setTitle=function(e){this.setProperty("title",e,true);if(this._headerTitle){this._headerTitle.setText(e);}else{this._headerTitle=new a(this.getId()+"-title",{text:e,level:"H2"}).addStyleClass("sapMDialogTitle");this._createHeader();this._header.addContentMiddle(this._headerTitle);}return this;};r.prototype.setState=function(e){var F={},$=this.$(),N;F[e]=true;this.setProperty("state",e,true);for(N in h._mStateClasses){$.toggleClass(h._mStateClasses[N],!!F[N]);}this.setIcon(r._mIcons[e],true);return this;};r.prototype.setIcon=function(i,e){if(!e){this._externalIcon=i;}else{if(this._externalIcon){i=this._externalIcon;}}if(i){if(i!==this.getIcon()){if(this._iconImage){this._iconImage.setSrc(i);}else{this._iconImage=b.createControlByURI({id:this.getId()+"-icon",src:i,useIconTooltip:false},sap.m.Image).addStyleClass("sapMDialogIcon");this._createHeader();this._header.insertAggregation("contentMiddle",this._iconImage,0);}}}else{var v=this.getState();if(!e&&v!==V.None){if(this._iconImage){this._iconImage.setSrc(r._mIcons[v]);}}else{if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}}}this.setProperty("icon",i,true);return this;};r.prototype.setType=function(e){var i=this.getType();if(i===e){return this;}this._bMessageType=(e===m.Message);return this.setProperty("type",e,false);};r.prototype.setStretch=function(e){this._bStretchSet=true;return this.setProperty("stretch",e);};r.prototype.setStretchOnPhone=function(e){if(this._bStretchSet){L.warning("sap.m.Dialog: stretchOnPhone property is deprecated. Setting stretchOnPhone property is ignored when there's already stretch property set.");return this;}this.setProperty("stretchOnPhone",e);return this.setProperty("stretch",e&&D.system.phone);};r.prototype.setVerticalScrolling=function(v){var e=this.getVerticalScrolling(),H=this._hasSingleScrollableContent();if(H){L.warning("sap.m.Dialog: property verticalScrolling automatically reset to false. See documentation.");v=false;}if(e===v){return this;}this.$().toggleClass("sapMDialogVerScrollDisabled",!v);this.setProperty("verticalScrolling",v);if(this._oScroller){this._oScroller.setVertical(v);}return this;};r.prototype.setHorizontalScrolling=function(v){var e=this.getHorizontalScrolling(),H=this._hasSingleScrollableContent();if(H){L.warning("sap.m.Dialog: property horizontalScrolling automatically reset to false. See documentation.");v=false;}if(e===v){return this;}this.$().toggleClass("sapMDialogHorScrollDisabled",!v);this.setProperty("horizontalScrolling",v);if(this._oScroller){this._oScroller.setHorizontal(v);}return this;};r.prototype.setInitialFocus=function(i){return this.setAssociation("initialFocus",i,true);};r.prototype.forceInvalidate=C.prototype.invalidate;r.prototype.invalidate=function(e){if(this.isOpen()){this.forceInvalidate(e);}};function t(e){var $=q(e);var i=$.control(0);if($.parents('.sapMDialogSection').length){return false;}if(!i||i.getMetadata().getInterfaces().indexOf("sap.m.IBar")>-1){return true;}return $.hasClass('sapMDialogTitle');}if(D.system.desktop){r.prototype.ondblclick=function(e){if(t(e.target)){var $=this.$('cont');this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);this._$dialog.removeClass('sapMDialogTouched');$.css({height:'100%'});}};r.prototype.onmousedown=function(e){if(e.which===3){return;}if(this.getStretch()||(!this.getDraggable()&&!this.getResizable())){return;}var i;var v=this;var $=q(document);var w=q(e.target);var x=w.hasClass('sapMDialogResizeHandler')&&this.getResizable();var y=function(U){i=i?clearTimeout(i):setTimeout(function(){U();},0);};var z=window.innerWidth;var E=window.innerHeight;var F={x:e.pageX,y:e.pageY,width:v._$dialog.width(),height:v._$dialog.height(),outerHeight:v._$dialog.outerHeight(),offset:{x:e.offsetX?e.offsetX:e.originalEvent.layerX,y:e.offsetY?e.offsetY:e.originalEvent.layerY},position:{x:v._$dialog.offset().left,y:v._$dialog.offset().top}};function G(){var U=v.$(),W=v.$('cont'),X,Y;$.off("mouseup mousemove");if(x){v._$dialog.removeClass('sapMDialogResizing');X=parseInt(U[0].style.height)||parseInt(U.height());Y=parseInt(U.css("border-top-width"))+parseInt(U.css("border-bottom-width"));W.height(X+Y);}}if((t(e.target)&&this.getDraggable())||x){v._bDisableRepositioning=true;v._$dialog.addClass('sapDialogDisableTransition');v._$dialog.addClass('sapMDialogTouched');v._oManuallySetPosition={x:F.position.x,y:F.position.y};v._$dialog.css({left:Math.min(Math.max(0,v._oManuallySetPosition.x),z-F.width),top:Math.min(Math.max(0,v._oManuallySetPosition.y),E-F.height),width:F.width,height:F.height,transform:""});}if(t(e.target)&&this.getDraggable()){$.on("mousemove",function(U){if(U.buttons===0){G();return;}y(function(){v._bDisableRepositioning=true;v._oManuallySetPosition={x:U.pageX-e.pageX+F.position.x,y:U.pageY-e.pageY+F.position.y};v._$dialog.css({left:Math.min(Math.max(0,v._oManuallySetPosition.x),z-F.width),top:Math.min(Math.max(0,v._oManuallySetPosition.y),E-F.outerHeight),transform:""});});});}else if(x){v._$dialog.addClass('sapMDialogResizing');var H={};var J=parseInt(v._$dialog.css('min-width'));var K=F.x+F.width-J;var N=w.width()-e.offsetX;var Q=w.height()-e.offsetY;$.on("mousemove",function(U){y(function(){v._bDisableRepositioning=true;v.$('cont').height('').width('');if(U.pageY+Q>E){U.pageY=E-Q;}if(U.pageX+N>z){U.pageX=z-N;}v._oManuallySetSize={width:F.width+U.pageX-F.x,height:F.height+U.pageY-F.y};if(v._bRTL){H.left=Math.min(Math.max(U.pageX,0),K);H.transform="";v._oManuallySetSize.width=F.width+F.x-Math.max(U.pageX,0);}H.width=v._oManuallySetSize.width;H.height=v._oManuallySetSize.height;v._$dialog.css(H);});});}else{return;}$.on("mouseup",G);e.preventDefault();e.stopPropagation();};}r.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};return r;});
