/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/base/Log','./TextField','sap/ui/model/type/Date','sap/ui/core/date/UniversalDate','./library','./DatePickerRenderer','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/Device','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/Popup','sap/ui/dom/containsOrEquals','sap/ui/dom/jquery/cursorPos'],function(q,L,T,a,U,l,D,b,c,d,e,f,P,g){"use strict";var h=P.Dock;var C=c.CalendarType;var i=T.extend("sap.ui.commons.DatePicker",{metadata:{library:"sap.ui.commons",properties:{locale:{type:"string",group:"Misc",defaultValue:null},yyyymmdd:{type:"string",group:"Misc",defaultValue:null}}}});i.prototype.init=function(){T.prototype.init.apply(this,arguments);this._oFormatYyyymmdd=b.getInstance({pattern:"yyyyMMdd",strictParsing:true,calendarType:C.Gregorian});if(!d.system.desktop){this._bMobile=true;this._oFormatMobile=b.getInstance({pattern:"yyyy-MM-dd",strictParsing:true,calendarType:C.Gregorian});}this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,99);};i.prototype.exit=function(){this._oDate=undefined;this._oLocale=undefined;if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}};i.prototype.onAfterRendering=function(){T.prototype.onAfterRendering.apply(this,arguments);if(this._bMobile){if(this._oDate){var I=q(this.getInputDomRef());var O=this._oFormatMobile.format(this._oDate);I.val(O);}}};i.prototype.invalidate=function(O){if(!O||O!=this._oCalendar){T.prototype.invalidate.apply(this,arguments);}};i.prototype.onsapshow=function(E){var t=this;n(t);E.preventDefault();};i.prototype.onsaphide=i.prototype.onsapshow;i.prototype.onsappageup=function(E){var t=this;s(t,1,"day");E.preventDefault();};i.prototype.onsappageupmodifiers=function(E){var t=this;if(!E.ctrlKey&&E.shiftKey){s(t,1,"month");}else{s(t,1,"year");}E.preventDefault();};i.prototype.onsappagedown=function(E){var t=this;s(t,-1,"day");E.preventDefault();};i.prototype.onsappagedownmodifiers=function(E){var t=this;if(!E.ctrlKey&&E.shiftKey){s(t,-1,"month");}else{s(t,-1,"year");}E.preventDefault();};i.prototype.onkeypress=function(E){if(E.charCode){var t=this;var F=_(t);var u=String.fromCharCode(E.charCode);if(u&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(u)<0){E.preventDefault();}}};i.prototype.onclick=function(E){if(q(E.target).hasClass("sapUiTfDateIcon")&&!this._bMobile){var t=this;n(t);}};i.prototype.onsapfocusleave=function(E){if(this._oCalendar&&E.relatedControlId&&(g(this._oCalendar.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())||this.getId()==E.relatedControlId)){return;}T.prototype.onsapfocusleave.apply(this,arguments);};i.prototype.setValue=function(v){var O=this.getValue();if(v==O){return this;}var t=this;k(t);this.setProperty("value",v,true);this._bValueSet=true;if(v){this._oDate=this._parseValue(v);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;L.warning("Value can not be converted to a valid date",this);}}else{this._oDate=undefined;}var y="";if(this._oDate){y=this._oFormatYyyymmdd.format(this._oDate);}this.setProperty("yyyymmdd",y,true);if(this.getDomRef()){var u="";var I=q(this.getInputDomRef());if(this._bMobile&&this._oDate){u=this._oFormatMobile.format(this._oDate);}else{u=v;}I.val(u);}return this;};i.prototype.setYyyymmdd=function(y){var O=this.getYyyymmdd();if(y==O){return this;}this.setProperty("yyyymmdd",y,true);this._bValueSet=false;var v="";if(y){this._oDate=this._oFormatYyyymmdd.parse(y);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;L.warning("Value can not be converted to a valid date",this);}}else{this._oDate=undefined;}if(this._oDate){v=this._formatValue(this._oDate);}this.setProperty("value",v,true);if(this.getDomRef()){var t="";var I=q(this.getInputDomRef());if(this._bMobile&&this._oDate){t=this._oFormatMobile.format(this._oDate);}else{t=v;}I.val(t);}return this;};i.prototype.setLocale=function(t){var O=this.getLocale();if(t==O){return this;}this.setProperty("locale",t,true);var u=this;k(u);this._oLocale=new e(t);this._sUsedPattern=undefined;var v="";if(this._bValueSet){v=this.getValue();if(v){this._oDate=this._parseValue(v);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;L.warning("Value can not be converted to a valid date",this);}}else{this._oDate=undefined;}var y="";if(this._oDate){y=this._oFormatYyyymmdd.format(this._oDate);}this.setProperty("yyyymmdd",y,true);}else{if(this._oDate){v=this._formatValue(this._oDate);}this.setProperty("value",v,true);}if(this.getDomRef()){var w="";var I=q(this.getInputDomRef());if(this._bMobile&&this._oDate){w=this._oFormatMobile.format(this._oDate);}else{w=v;}I.val(w);}return this;};i.prototype.oninput=function(E){if(this._bMobile){var I=this.getInputDomRef();var N=I&&I.value;if(N){var t=this._oFormatMobile.parse(N);}if(!N||t){this._checkChange(E);}}else{T.prototype.oninput.apply(this,arguments);}};i.prototype._checkChange=function(E){var I=this.getInputDomRef();var N=I&&I.value;if(this._bMobile&&N!=""){this._oDate=this._oFormatMobile.parse(N);N=this._formatValue(this._oDate);}if(this.getEditable()&&this.getEnabled()&&N!=this.getValue()){var w=false;if(N!=""){if(!this._bMobile){this._oDate=this._parseValue(N);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;w=true;}else{N=this._formatValue(this._oDate);I.value=N;if(this._oPopup&&this._oPopup.isOpen()){this._oCalendar.focusDate(this._oDate);if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=this._oDate.getTime()){this._oDateRange.setStartDate(new Date(this._oDate.getTime()));}}}}}else{this._oDate=undefined;}this.setProperty("value",N,true);this._bValueSet=false;if(!w){var y="";if(this._oDate){y=this._oFormatYyyymmdd.format(this._oDate);}this.setProperty("yyyymmdd",y,true);}this.fireChange(w);}else if(this.getEditable()&&this.getEnabled()&&N==this.getYyyymmdd()){I.value=this.getValue();}};i.prototype.fireChange=function(I){this.fireEvent("change",{newValue:this.getValue(),newYyyymmdd:this.getYyyymmdd(),invalidValue:I});return this;};i.prototype._parseValue=function(v){var t=this;var F=_(t);var u=F.parse(v);return u;};i.prototype._formatValue=function(t){var u=this;var F=_(u);var v=F.format(t);return v;};i.prototype.getAccessibilityInfo=function(){var I=T.prototype.getAccessibilityInfo.apply(this,arguments);I.type=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_DATEINPUT");return I;};function _(t){var u="";var R=false;var B=t.getBinding("value");var v;var w;if(B&&B.oType&&(B.oType instanceof a)){u=B.oType.getOutputPattern();R=!!B.oType.oOutputFormat.oFormatOptions.relative;w=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(!u){v=j(t);var x=f.getInstance(v);u=x.getDatePattern("medium");w=sap.ui.getCore().getConfiguration().getCalendarType();}if(u!=t._sUsedPattern||w!=t._sUsedCalendarType){t._sUsedPattern=u;t._sUsedCalendarType=w;if(u=="short"||u=="medium"||u=="long"){t._oFormat=b.getInstance({style:u,strictParsing:true,relative:R,calendarType:w},v);}else{t._oFormat=b.getInstance({pattern:u,strictParsing:true,relative:R,calendarType:w},v);}}return t._oFormat;}function j(t){var u=t.getLocale();var v;if(u){v=t._oLocale;}else{v=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}return v;}function k(t){var B=t.getBinding("value");var u=t.getLocale();if(B&&B.oType&&(B.oType instanceof a)&&u){L.warning("DatePicker "+t.getId()+": Using a locale and Databinding at the same time is not supported");t._bIgnoreLocale=true;}}function m(t){if(!t._oPopup){t._oPopup=new P();t._oPopup.setAutoClose(true);t._oPopup.setDurations(0,0);t._oPopup.attachClosed(r,t);}if(!t._oCalendar){sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.require("sap/ui/unified/library");t._oCalendar=new sap.ui.unified.Calendar(t.getId()+"-cal");t._oDateRange=new sap.ui.unified.DateRange();t._oCalendar.addSelectedDate(t._oDateRange);t._oCalendar.attachSelect(o,t);t._oCalendar.attachCancel(p,t);t._oPopup.setContent(t._oCalendar);t._oCalendar.addStyleClass("sapUiSizeCompact");t._oCalendar.setPopupMode(true);t._oCalendar.setParent(t,undefined,true);}var v="";if(t._oDate){v=t._formatValue(t._oDate);}if(v!=t.$("input").val()){t._checkChange();}var u;var B=t.getBinding("value");if(B&&B.oType&&(B.oType instanceof a)){u=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(u){t._oCalendar.setPrimaryCalendarType(u);}var w=t._oDate;if(w){t._oCalendar.focusDate(w);if(!t._oDateRange.getStartDate()||t._oDateRange.getStartDate().getTime()!=w.getTime()){t._oDateRange.setStartDate(new Date(w.getTime()));}}else{t._oCalendar.focusDate(new Date());if(t._oDateRange.getStartDate()){t._oDateRange.setStartDate(undefined);}}if(!t._bIgnoreLocale){t._oCalendar.setLocale(t.getLocale());}t._oPopup.setAutoCloseAreas([t.getDomRef()]);t._oPopup.open(0,h.BeginTop,h.BeginBottom,t,null,null,true);}function n(t){if(t.getEditable()&&t.getEnabled()){if(!t._oPopup||!t._oPopup.isOpen()){m(t);}else{t._oPopup.close();t.focus();}}}function o(E){var S=this._oCalendar.getSelectedDates();var O="";if(S.length>0){this._oDate=S[0].getStartDate();O=this._formatValue(this._oDate);}this._oPopup.close();this.focus();var N=this._formatValue(this._oDate);this.setProperty("value",N,true);this._bValueSet=false;var y=this._oFormatYyyymmdd.format(this._oDate);this.setProperty("yyyymmdd",y,true);var I=this.$("input");if(I.val()!==O){I.val(O);this._curpos=O.length;I.cursorPos(this._curpos);}this.fireChange();}function p(E){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();this.focus();}}function r(E){if(!g(this.getDomRef(),document.activeElement)&&this.getRenderer().onblur){this.getRenderer().onblur(this);}}function s(t,N,u){var O=t._oDate;if(O&&t.getEditable()&&t.getEnabled()){var B=t.getBinding("value");var v;if(B&&B.oType&&(B.oType instanceof a)){v=B.oType.oOutputFormat.oFormatOptions.calendarType;}else{v=sap.ui.getCore().getConfiguration().getCalendarType();}var w=U.getInstance(new Date(O.getTime()),v);O=U.getInstance(new Date(O.getTime()),v);var I=q(t.getInputDomRef());var x=I.cursorPos();switch(u){case"day":w.setDate(w.getDate()+N);break;case"month":w.setMonth(w.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(w.getMonth()!=M){w.setDate(w.getDate()-1);}break;case"year":w.setFullYear(w.getFullYear()+N);while(w.getMonth()!=O.getMonth()){w.setDate(w.getDate()-1);}break;default:break;}if(w.getTime()<t._oMinDate.getTime()){w=new U(t._oMinDate.getTime());}else if(w.getTime()>t._oMaxDate.getTime()){w=new U(t._oMaxDate.getTime());}t._oDate=new Date(w.getTime());var y=t._formatValue(t._oDate);I.val(y);I.cursorPos(x);}}return i;});
