//@ui5-bundle sap/ui/commons/library-preload.js
/*!
 # * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/commons/Toolbar',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/delegate/ItemNavigation','./ToolbarRenderer','sap/base/assert','sap/ui/dom/containsOrEquals','sap/ui/core/ResizeHandler','sap/ui/core/Element','sap/ui/events/KeyCodes'],function(q,l,C,P,I,T,a,c,R,E,K){"use strict";var b=l.ToolbarDesign;
var d=C.extend("sap.ui.commons.Toolbar",{metadata:{interfaces:["sap.ui.core.Toolbar"],library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},design:{type:"sap.ui.commons.ToolbarDesign",group:"Appearance",defaultValue:b.Flat},standalone:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.commons.ToolbarItem",multiple:true,singularName:"item"},rightItems:{type:"sap.ui.commons.ToolbarItem",multiple:true,singularName:"rightItem"}}}});
d.prototype.init=function(){this.bOpen=false;this.oDomRef=null;this.oInnerRef=null;this.oOverflowDomRef=null;this._oOverflowPopup=null;this.sOriginalStylePropertyWidth=null;this.bHasRightItems=false;this._bRendering=false;this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this._detectVisibleItemCountChangeTimer=null;var t=this;this.oItemDelegate={onAfterRendering:q.proxy(t._itemRendered,t)};this.data("sap-ui-fastnavgroup","true",true);};
d.prototype.onBeforeRendering=function(){T.emptyOverflowPopup(this,false);this.cleanup();this.$("mn").unbind("keydown",this._handleKeyDown);this.bFirstTime=true;this._bRendering=true;};
d.prototype.onAfterRendering=function(){this._bRendering=false;this.oDomRef=this.getDomRef();this.oInnerRef=this.oDomRef.firstChild.firstChild;q(this.oInnerRef).css("visibility","visible");this.oOverflowDomRef=this.getDomRef("mn");if(!this.oItemNavigation){this.oItemNavigation=new I();this.addDelegate(this.oItemNavigation);}this.$("mn").bind("keydown",q.proxy(this._handleKeyDown,this));this.sResizeListenerId=R.register(this.oDomRef,q.proxy(this.ontoolbarresize,this));var i=this.getRightItems().length;this.bHasRightItems=i>0;if(this.bHasRightItems){this.sRightSideResizeListenerId=R.register(this.oDomRef.lastChild,q.proxy(this.onrightsideresize,this));this.updateAfterResize(true);this._observeVisibleItemCountChange(40);}else{this.updateAfterResize(true);this._observeVisibleItemCountChange(350);}};
d.prototype._handleKeyDown=function(o){if((o.keyCode==K.SPACE)&&(o.target.id===this.getId()+"-mn")){this.handleOverflowButtonTriggered();o.preventDefault();o.stopPropagation();}};
d.prototype.exit=function(){this.cleanup();if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation;}this.oItemDelegate=undefined;q(window).unbind("resize",this.onwindowresize);r.call(this);};
d.prototype.updateAfterResize=function(i){if(this._bRendering){return;}var v=this.getVisibleItemInfo();this._oLastVisibleItem=v.oLastVisibleItem;this._oFirstInvisibleItem=v.oFirstInvisibleItem;this._iLastVisibleItemTop=v.iLastVisibleItemTop;this.updateItemNavigation(v.iAllItemsBeforeBreak,i);this.updateOverflowIcon(v.bOverflow);if(this.sUpdateItemNavigationTimer){clearTimeout(this.sUpdateItemNavigationTimer);this.sUpdateItemNavigationTimer=null;}};
d.prototype._detectVisibleItemCountChange=function(){if(!this.getDomRef()){if(this._detectVisibleItemCountChangeTimer){clearTimeout(this._detectVisibleItemCountChangeTimer);this._detectVisibleItemCountChangeTimer=null;}return;}if(this._oLastVisibleItem&&this._oFirstInvisibleItem){var i=this._oLastVisibleItem.offsetLeft;var j=this._oFirstInvisibleItem.offsetLeft;var k=this._oLastVisibleItem.offsetTop;var m=this.bRtl?(j<i):(j>i);if((k!=this._iLastVisibleItemTop)||(!this.bOpen&&m)){if(this.bOpen){this.closePopup(true);}this.updateAfterResize(false);}}else if(this._oLastVisibleItem&&!this._oFirstInvisibleItem){if(this._oLastVisibleItem.offsetTop!=this._iLastVisibleItemTop){this.updateAfterResize(false);}}this._observeVisibleItemCountChange(350);if(this.bFirstTime&&this.bHasRightItems){this.onrightsideresize();this.bFirstTime=false;}};
d.prototype._observeVisibleItemCountChange=function(i){this._detectVisibleItemCountChangeTimer=setTimeout(function(){this._detectVisibleItemCountChange();}.bind(this),i);};
d.prototype.updateItemNavigation=function(A,j){this.oItemNavigation.setRootDomRef(this.oDomRef);var L=g.call(this);var k=[];for(var i=0;i<A;i++){var D=L[i].getFocusDomRef();if(D){k.push(D);}}k.push(this.oOverflowDomRef);this.iLeftItemDomRefCount=k.length;var m=this.getRightItems();for(var i=0;i<m.length;i++){var D=m[i].getFocusDomRef();if(D){k.push(D);}}this.oItemNavigation.setItemDomRefs(k);this.iItemDomRefCount=k.length;if(j){for(var i=A;i<L.length;i++){var D=L[i].getFocusDomRef();var $=q(D);if(D&&($.attr("tabindex")=="0")){$.attr("tabIndex",-1);}}}};
d.prototype.getVisibleItemInfo=function(j){var v=0;if(this.oInnerRef){var k=j?this.oInnerRef.childNodes:this.oInnerRef.parentNode.querySelectorAll("#"+this.oInnerRef.id+' > :not(.sapUiHiddenPlaceholder)');this.bRtl=sap.ui.getCore().getConfiguration().getRTL();var L,o,m=0,n,p,s=0,t=null,F=null,u,A,O=false;for(var i=1,w=k.length;i<w;i++){o=k[i];n=o.offsetLeft;if(i==1){p=k[0].offsetWidth;s=k[0].offsetLeft;}if(this.bRtl){m=o.offsetWidth;L=!f.call(this,o)&&(n+m>=s+p);}else{L=!f.call(this,o)&&(n<=s)&&(o.offsetTop>k[0].offsetTop);}if(L){v=i;t=k[i-1];F=o;u=t.offsetTop;O=true;break;}else if(f.call(this,o)){v=i;a(v===(w-1),"visible items ("+v+") must be one less than the items count ("+w+")");t=k[i-1];F=null;u=t.offsetTop;O=false;break;}else{s=n;p=m;}}A=h.call(this,t);}return{"count":v,"oLastVisibleItem":t,"oFirstInvisibleItem":F,"iLastVisibleItemTop":u,"iAllItemsBeforeBreak":A,"bOverflow":O};};
d.prototype.updateOverflowIcon=function(o){this.oOverflowDomRef.style.display=o||this.bOpen?"block":"none";};
d.prototype.onclick=function(o){if(o.target.id===this.getId()+"-mn"){this.handleOverflowButtonTriggered();o.preventDefault();o.stopPropagation();}};
d.prototype.onsapdown=function(o){if(o.target.id===this.getId()+"-mn"){if(!this.bOpen){this.handleOverflowButtonTriggered();o.preventDefault();o.stopImmediatePropagation();}}};
d.prototype.onsapup=function(o){if(o.target.id===this.getId()+"-mn"){if(this.bOpen){this.handleOverflowButtonTriggered();o.preventDefault();o.stopPropagation();}}};
d.prototype.handleOverflowButtonTriggered=function(){if(!this.bPopupInitialized){this._oOverflowPopup=new e(this);this.popup=new P(this._oOverflowPopup,false,true,true);this.popup.setAutoCloseAreas([this.getId()+"-mn"]);this.bPopupInitialized=true;}if(this.bOpen){this.closePopup(false);}else{this.openPopup();}};
d.prototype.openPopup=function(){this.getRenderer().setActive(this);var D=q(this.getDomRef());this.sOriginalStylePropertyWidth=D.prop('style').width;D.width(D.width());T.fillOverflowPopup(this);this.popup.attachEvent("opened",this.handlePopupOpened,this);this.popup.attachEvent("closed",this.handlePopupClosed,this);q(window).bind("resize",q.proxy(this.onwindowresize,this));var i=0;this.popup.open(i,P.Dock.EndTop,P.Dock.EndBottom,this.$("mn"),"","fit",true);};
d.prototype.handlePopupOpened=function(){var L=g.call(this);var A=this.getVisibleItemInfo().iAllItemsBeforeBreak;this.bOpen=true;var n=[];for(var i=A;i<L.length;i++){var D=L[i].getFocusDomRef();if(D){n.push(D);}}this.popup.getContent().initItemNavigation(n);};
d.prototype.closePopup=function(i){this._bResetFocus=i;this.popup.close();q(window).unbind("resize",this.onwindowresize);};
d.prototype.handlePopupClosed=function(){this.getRenderer().unsetActive(this);this.bOpen=false;T.emptyOverflowPopup(this);var A=this.getVisibleItemInfo().iAllItemsBeforeBreak;this.updateItemNavigation(A,true);if(this._bResetFocus){this.oItemNavigation.focusItem(this.iLeftItemDomRefCount-1);}this._bResetFocus=false;};
d.prototype.prepareFocusInfoRedirect=function(o){if(o&&!o._orig_getFocusInfo){var i=this.getId();o._orig_getFocusInfo=o.getFocusInfo;o.getFocusInfo=function(){return{id:i,childInfo:this._orig_getFocusInfo()};};var t=this;o._orig_applyFocusInfo=o.applyFocusInfo;o.applyFocusInfo=function(F){return t.applyFocusInfo(F.childInfo);};}return o;};
d.prototype.cleanupFocusInfoRedirect=function(o){if(o){o.getFocusInfo=o._orig_getFocusInfo;delete o._orig_getFocusInfo;delete o._orig_applyFocusInfo;}return o;};
d.prototype.insertItem=function(i,j){this.insertAggregation("items",this.prepareFocusInfoRedirect(i),j);i.addDelegate(this.oItemDelegate);return this;};
d.prototype.addItem=function(i){this.addAggregation("items",this.prepareFocusInfoRedirect(i));i.addDelegate(this.oItemDelegate);return this;};
d.prototype.removeItem=function(v){var t=this.removeAggregation("items",v);t.removeDelegate(this.oItemDelegate);return this.cleanupFocusInfoRedirect(t);};
d.prototype.removeAllItems=function(){var t=this.removeAllAggregation("items");for(var i=0,L=t.length;i<L;i++){t[i]=this.cleanupFocusInfoRedirect(t[i]);t[i].removeDelegate(this.oItemDelegate);}return t;};
d.prototype.insertRightItem=function(i,j){this.insertAggregation("rightItems",this.prepareFocusInfoRedirect(i),j);i.addDelegate(this.oItemDelegate);return this;};
d.prototype.addRightItem=function(i){this.addAggregation("rightItems",this.prepareFocusInfoRedirect(i));i.addDelegate(this.oItemDelegate);return this;};
d.prototype.removeRightItem=function(v){var t=this.removeAggregation("rightItems",v);t.removeDelegate(this.oItemDelegate);return this.cleanupFocusInfoRedirect(t);};
d.prototype.removeAllRightItems=function(){var t=this.removeAllAggregation("rightItems");for(var i=0,L=t.length;i<L;i++){t[i]=this.cleanupFocusInfoRedirect(t[i]);t[i].removeDelegate(this.oItemDelegate);}return t;};
d.prototype.getFocusInfo=function(){var i=this.getId();if(this.bOpen){return{id:i,childId:i};}else{return{id:i};}};
d.prototype.applyFocusInfo=function(F){if(F){var s=F.childId;if(this.bOpen&&s){if(s===this.getId()){return;}var o=sap.ui.getCore().byId(s);var i;if(o&&this.popup&&(i=this.popup.getContent())&&c(i.getDomRef(),o.getDomRef())){i.applyFocusInfo(F.childInfo);return;}}}this.focus();};
var e=E.extend("sap.ui.commons.ToolbarOverflowPopup",{
constructor:function(t){this.oToolbar=t;var i=t.getId()+"-pu";E.call(this,i);},
exit:function(){this.$().remove();},
initItemNavigation:function(n){if(!this.oItemNavigation){this.oItemNavigation=new I();this.addDelegate(this.oItemNavigation);}this.oItemNavigation.setRootDomRef(T.getPopupArea(this.oToolbar));this.oItemNavigation.setItemDomRefs(n);this.oItemNavigation.focusItem(0);},
getDomRef:function(){var p=T.getPopupArea(this.oToolbar);if(p){return p.parentNode;}else{return null;}},
isActive:function(){return T.getPopupArea(this.oToolbar)!=null;},
onsapescape:function(o){this.oToolbar.closePopup(true);},
onsaptabnext:function(o){this.oToolbar.closePopup(true);o.preventDefault();o.stopPropagation();},
onsaptabprevious:function(o){this.oToolbar.closePopup(true);o.preventDefault();o.stopPropagation();}
});
d.prototype._itemRendered=function(){if(this.oItemNavigation){this.updateAfterResize(true);}else{if(!this.sUpdateItemNavigationTimer){this.sUpdateItemNavigationTimer=setTimeout(function(){this.updateAfterResize(true);}.bind(this),0);}}};
d.prototype.onwindowresize=function(o){if(this.bOpen){this.closePopup(true);}};
d.prototype.ontoolbarresize=function(o){if(this.bOpen){this.closePopup(true);}};
d.prototype.onrightsideresize=function(){if(!this.getDomRef()){this.cleanup();return;}if(this.getRightItems().length>0){var o=this.oDomRef.lastChild;var i=o.offsetWidth;if(this.bRtl){q(this.oInnerRef).css("margin-left",(i+10)+"px");}else{q(this.oInnerRef).css("margin-right",(i+10)+"px");}var F=this.oDomRef.firstChild.firstChild.firstChild;var O=this.getDomRef("mn").offsetWidth;var m=F.offsetWidth+i+O+20;q(this.oDomRef).css("min-width",m+"px");q(this.oInnerRef).css("visibility","visible");}};
d.prototype.cleanup=function(){if(this._detectVisibleItemCountChangeTimer){clearTimeout(this._detectVisibleItemCountChangeTimer);this._detectVisibleItemCountChangeTimer=null;}if(this.sUpdateItemNavigationTimer){clearTimeout(this.sUpdateItemNavigationTimer);this.sUpdateItemNavigationTimer=null;}if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}if(this.sRightSideResizeListenerId){R.deregister(this.sRightSideResizeListenerId);this.sRightSideResizeListenerId=null;}};
function g(){var i=[];this.getItems().forEach(function(j){if(j instanceof sap.ui.commons.ToolbarSeparator||j.getVisible()){i.push(j);}});return i;}
function f(o){var O=this.getId()+"-mn";return o.id===O;}
function h(L){var A=0;var j=g.call(this);j.forEach(function(k,i){if(k.getDomRef()===L){A=i+1;return false;}});return A;}
return d;
function r(){if(this.bPopupInitialized){this._oOverflowPopup.destroy();this._oOverflowPopup=null;this.popup.detachOpened(this.handlePopupOpened,this);this.popup.detachClosed(this.handlePopupClosed,this);this.popup.destroy();this.popup=null;this.bPopupInitialized=false;}}
});
/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/commons/Accordion',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','./AccordionRenderer','sap/ui/dom/jquery/control','sap/ui/thirdparty/jqueryui/jquery-ui-core','sap/ui/thirdparty/jqueryui/jquery-ui-widget','sap/ui/thirdparty/jqueryui/jquery-ui-mouse','sap/ui/thirdparty/jqueryui/jquery-ui-sortable'],function(q,l,C,A){"use strict";
var a=C.extend("sap.ui.commons.Accordion",{metadata:{library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'200px'},openedSectionsId:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.ui.commons.AccordionSection",multiple:true,singularName:"section"}},events:{sectionOpen:{parameters:{openSectionId:{type:"string"},closeSectionIds:{type:"string[]"}}},sectionClose:{parameters:{closeSectionId:{type:"string"}}},sectionsReorder:{parameters:{movedSectionId:{type:"string"},newIndex:{type:"int"}}}}}});
a.CARD_1=1;a.CARD_0_1=2;a.aAccordions=[];
a.prototype.init=function(){this.bInitialRendering=true;this.activationMode=a.CARD_1;this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.aSectionTitles=[];a.aAccordions.push(this);};
a.prototype.onsapspace=function(e){this.onclick(e);};
a.prototype.onsappagedownmodifiers=function(e){var t=q(e.target);var p=t.parentsUntil('.sapUiAcd');var d=p[p.length-1];var n=q(d).next();while(!this.getCorrespondingSection(n[0]).getEnabled()){n=n.next();}n=n[0];this.openSection(n.id);var s=this.getSections();s[this.__idxOfSec(n.id)].focus();e.preventDefault();e.stopPropagation();};
a.prototype.onsappageupmodifiers=function(e){var t=q(e.target);var p=t.parentsUntil('.sapUiAcd');var s=p[p.length-1];var n=q(s).prev();while(!this.getCorrespondingSection(n[0]).getEnabled()){n=n.prev();}n=n[0];this.openSection(n.id);var S=this.getSections();S[this.__idxOfSec(n.id)].focus();e.preventDefault();e.stopPropagation();};
a.prototype.onsapupmodifiers=function(e){e.preventDefault();e.stopPropagation();var p=q(e.target).parentsUntil('.sapUiAcd');var d=p[p.length-1];if(this.__idxOfSec(d.id)===0){return;}var D=q(d).prev().first()[0];var i=false;if(this.__idxOfSec(D.id)===0){i=true;}this.dropSection(d,D,i);var s=this.getSections();s[this.__idxOfSec(d.id)].focus();};
a.prototype.onsapdownmodifiers=function(e){e.preventDefault();e.stopPropagation();var p=q(e.target).parentsUntil('.sapUiAcd');var d=p[p.length-1];if(this.__idxOfSec(d.id)==this.getSections().length-1){return;}var D=q(d).next().first()[0];this.dropSection(d,D,false);var s=this.getSections();s[this.__idxOfSec(d.id)].focus();};
a.prototype.onsapprevious=function(e){if(e.srcControl.getMetadata().getName()!="sap.ui.commons.AccordionSection"){return;}e.preventDefault();e.stopPropagation();var c=this.getCurrentSection(e.target),n=null;if(c.id==this.getSections()[0].getId()){n=q(c).find("div.sapUiAcdSectionHdr");if(n){n.focus();}}if(c){var p=q(c).prev();while(p&&q(p).hasClass("sapUiAcdSectionDis")){p=q(p).prev();}if(p){n=q(p).find("div.sapUiAcdSectionHdr");if(n){n.focus();}}}};
a.prototype.onsapnext=function(e){if(e.srcControl.getMetadata().getName()!="sap.ui.commons.AccordionSection"){return;}e.preventDefault();e.stopPropagation();var c=this.getCurrentSection(e.target);if(c){var n=q(c).next();while(n&&q(n).hasClass("sapUiAcdSectionDis")){n=q(n).next();}if(n){var N=q(n).find("div.sapUiAcdSectionHdr");if(N){N.focus();}}}};
a.prototype.onsaphome=function(e){e.preventDefault();e.stopPropagation();var f=this.getSections()[0].getDomRef();if(q(f).hasClass("sapUiAcdSectionDis")){f=q(f).next();while(f&&q(f).hasClass("sapUiAcdSectionDis")){f=q(f).next();}}if(f){var n=q(f).find("div.sapUiAcdSectionHdr");if(n){n.focus();}}};
a.prototype.onsapend=function(e){e.preventDefault();e.stopPropagation();var n=this.getSections().length;var f=this.getSections()[n-1].getDomRef();if(q(f).hasClass("sapUiAcdSectionDis")){f=q(f).prev();while(f&&q(f).hasClass("sapUiAcdSectionDis")){f=q(f).prev();}}if(f){var N=q(f).find("div.sapUiAcdSectionHdr");if(N){N.focus();}}};
a.prototype.getCurrentSection=function(d){var c=d;while(!q(c).hasClass("sapUiAcdSection")){c=q(c).parent();}return c[0];};
a.prototype.dropSection=function(d,D,b){var o=q(d).parent()[0];var c=q(o).children(".sapUiAcdSection").toArray();var i=q.inArray(D,c);if(b){i-=1;}this.moveSection(d.id,i);};
a.prototype.moveSection=function(s,t){var o=this.__idxOfSec(s);if(t==o){return;}var S=this.aSectionTitles[o];this.aSectionTitles.splice(o,1);var b=this.getSections();var c=b[o];this.removeSection(o,true);if(t!=-1){this.aSectionTitles.splice(t,0,S);}else{this.aSectionTitles.splice(0,0,S);}this.insertSection(c,t,true);this.fireSectionsReorder({movedSectionId:s,newIndex:t});};
a.prototype._onSortChange=function(e,u){e.preventDefault();e.stopPropagation();var d=u.item[0];var S=u.item[0].getAttribute("Id");var D=q(d).parent()[0];var c=q(D).children(".sapUiAcdSection").toArray();var i=q.inArray(d,c);this.moveSection(S,i);};
a.prototype.onclick=function(e){if(e.srcControl.getId()==this.getId()){return;}var t=q(e.target);if(t.hasClass("sapUiAcdSectionCont")){return;}if(!(q(e.target).control(0)instanceof sap.ui.commons.AccordionSection)){return;}var d=e.srcControl.getDomRef();var s=this.getCorrespondingSection(d);if(s&&!s.getEnabled()){return;}if(e.srcControl.getCollapsed()){this.openSection(d.id);}else{this.closeSection(d.id);}e.preventDefault();e.stopPropagation();var S=this.getSections();S[this.__idxOfSec(d.id)].focus();};
a.prototype.openSection=function(s){var i=this.__idxOfSec(s);var S=this.getSections(),c=[];if(this.activationMode==a.CARD_0_1||this.activationMode==a.CARD_1){c=this.closeOpenedSections();}S[i]._setCollapsed(false);this.fireSectionOpen({openSectionId:s,closeSectionIds:c});};
a.prototype.closeSection=function(s){var i=this.__idxOfSec(s);var S=this.getSections();S[i]._setCollapsed(true);this.fireSectionClose({closeSectionId:s});};
a.prototype.closeOpenedSections=function(){var c=[];var s=this.getSections();for(var i=0;i<s.length;i++){if(!s[i].getCollapsed()){s[i]._setCollapsed(true);c.push(s[i].getId());}}return c;};
a.prototype.openDefaultSections=function(){var s=this.getSections();var d=this.getOpenedSectionsId().split(",");for(var i=0;i<d.length;i++){var o=s[this.__idxOfSec(d[i])];o._setCollapsed(false);}};
a.prototype.getNumberOfOpenedSections=function(){var o=0;var s=this.getSections();for(var i=0;i<s.length;i++){if(s[i].getCollapsed()==false){o++;}}return o;};
a.prototype.addSection=function(s){this.addAggregation("sections",s);if((this.getOpenedSectionsId()==null||this.getOpenedSectionsId()=="")&&s.getEnabled()){this.setOpenedSectionsId(s.getId());}this.aSectionTitles.push(s.getTitle());return this;};
a.prototype.__idxOfSec=function(s){if(typeof(s)=="string"){s=sap.ui.getCore().byId(s);}return this.indexOfSection(s);};
a.prototype.setOpenedSectionsId=function(o){var s=this.getSections();var d=o.split(",");if(d.length==1){if(this.__idxOfSec(o)<0){this.setProperty("openedSectionsId",o);return this;}if(s[this.__idxOfSec(o)].getEnabled()){this.setProperty("openedSectionsId",o);}else{for(var i=0;i<s.length;i++){if(s[i].getEnabled()){this.setProperty("openedSectionsId",s[i].getId());return this;}}}}else if(d.length==0){return this;}else{var c;for(var i=0;i<d.length;i++){if(s[this.__idxOfSec(d[i])].getEnabled()){if(c){c+=","+d[i];}else{c=d[i];}}}if(c){this.setProperty("openedSectionsId",c);}}return this;};
a.prototype.getCorrespondingSection=function(d){if(q(d).hasClass("sapUiAcdSection")){var b=q(d).parent();var o=b[0];var s=q(o).children();var i=s.index(d);var c=this.getSections();return c[i-1];}};
a.prototype.isLastSection=function(s){var S=this.getSections();return(q.inArray(s,S)===S.length-1);};
a.prototype.onAfterRendering=function(){var c=sap.ui.getCore(),t=this;function b(){var d=t.getDomRef();d.style.height=d.clientHeight-7+"px";}if(c.isThemeApplied()){b();}else{c.attachThemeChanged(b,this);}this.$().sortable({handle:"> div.sapUiAcdSectionHdr > div",stop:q.proxy(this._onSortChange,this)});};
return a;});
sap.ui.predefine('sap/ui/commons/AccordionRenderer',['./AccordionSection','sap/ui/Device'],function(A,D){"use strict";var a={};
a.render=function(r,o){r.write("<div");r.writeControlData(o);if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute('role','tablist');}r.addClass("sapUiAcd");r.addStyle("width",o.getWidth());r.writeClasses();r.writeStyles();r.write(">");r.write("<div id='"+o.getId()+"-dropTarget"+"' style='width:"+o.getWidth()+"' tabindex='-1' class='sapUiAcd-droptarget'></div>");var s=o.getSections();var d=o.getOpenedSectionsId().split(",");for(var i=0;i<s.length;i++){if(o.bInitialRendering){if(d.indexOf(s[i].getId())!=-1){s[i]._setCollapsed(false);}else{s[i]._setCollapsed(true);}}a.renderSection(r,s[i]);}r.write('<span id="'+o.getId()+'-Descr" style="visibility: hidden; display: none;">');r.write(o.rb.getText("ACCORDION_DSC"));r.write('</span>');r.write("</div>");o.bInitialRendering=false;};
a.renderSection=function(r,c){var b=sap.ui.getCore().getConfiguration().getAccessibility();var h=A._isSizeSet(c.getMaxHeight());var w=A._isSizeSet(c.getParent().getWidth());r.write("<div");r.writeElementData(c);r.addClass("sapUiAcdSection");if(c.getParent().isLastSection(c)){r.addClass("sapUiAcdSectionLast");}r.addStyle("width",c.getParent().getWidth());if(!c.getCollapsed()){r.addStyle("height",c.getMaxHeight());}else{r.addClass("sapUiAcdSectionColl");}r.addClass("sapUiAcdSectionArea");if(!h){r.addClass("sapUiAcdSectionFlexHeight");}if(!c.getEnabled()){r.addClass("sapUiAcdSectionDis");}r.writeClasses();r.writeStyles();r.write("><div class='sapUiAcdSectionHdr'");if(c.getEnabled()){r.write(" tabindex='0'");}r.writeAttribute("id",c.getId()+"-hdr");if(b){r.writeAttribute('role','tab');r.writeAttribute("aria-labelledby",c.getId()+"-lbl");r.writeAttribute("aria-describedby",c.getParent().getId()+"-Descr");if(c.getEnabled()){if(c.getCollapsed()){r.writeAttribute("aria-expanded","false");}else{r.writeAttribute("aria-expanded","true");}}}r.write(">");r.write("<div ");r.writeAttribute("id",c.getId()+"-trgt");r.write(">");r.write("<span id='"+c.getId()+"-hdrL'>");if(c.getEnabled()){r.write("<a id='"+c.getId()+"-minL' class='sapUiAcdSectionMinArrow' href='# title='Collapse/Expand'");}else{r.write("<a id='"+c.getId()+"-minL' class='sapUiAcdSectionMinArrow sapUiAcdCursorText' href='#' title='Collapse/Expand'");}r.write(" tabindex='-1' ");if(b){r.writeAttribute("aria-labelledby",c.getId()+"-lbl");if(c.getCollapsed()){r.writeAttribute("aria-selected","false");}else{r.writeAttribute("aria-selected","true");}if(c.getEnabled()){r.writeAttribute("aria-disabled","false");if(!D.browser.msie){r.writeAttribute("aria-grabbed","false");}}else{r.writeAttribute("aria-disabled","true");if(!D.browser.msie){r.writeAttribute("aria-grabbed","");}}}r.write("></a>");r.write("<span tabindex='-1' id='"+c.getId()+"-lbl' class='sapUiAcdSectionLabel'");if(c.getCollapsed()){r.writeAttribute("aria-selected","false");r.addStyle("font-weight","normal");r.writeStyles();}else{r.writeAttribute("aria-selected","true");r.addStyle("font-weight","bold");r.writeStyles();}if(b){r.writeAttribute("role","heading");if(c.getEnabled()){r.writeAttribute("aria-disabled","false");}else{r.writeAttribute("aria-disabled","true");}}r.write(">");r.writeEscaped(c.getTitle());r.write("</span>");r.write("</span>");r.write("</div></div>");if(!c.getCollapsed()){r.write("<div class='sapUiAcdSectionCont' tabindex='-1' id='"+c.getId()+"-cont'");if(h&&w){r.write(" style='position:absolute;'");}else{r.write(" style='position:relative;top:0px;'");}if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute('role','tabpanel');}r.write(">");var C=c.getContent(),l=C.length;for(var i=0;i<l;i++){r.renderControl(C[i]);}r.write("</div>");}r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/ui/commons/AccordionSection',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var A=E.extend("sap.ui.commons.AccordionSection",{metadata:{library:"sap.ui.commons",properties:{maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},collapsed:{type:"boolean",group:"Behavior",defaultValue:false},title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{scroll:{parameters:{left:{type:"int"},top:{type:"int"}}}}}});
A.prototype.init=function(){this.oScrollDomRef=null;this.data("sap-ui-fastnavgroup","true",true);};
A.prototype.focusFirstControl=function(){var c=this.getContent();if(c[0]){c[0].focus();}};
A.prototype.focus=function(){var h=this.getDomRef("hdr");h.focus();};
A.prototype.onThemeChanged=function(){var h=this.getDomRef("hdrL");if(h){h.style.width="auto";this.onAfterRendering();}};
A.prototype.onAfterRendering=function(){this.oScrollDomRef=this.getDomRef("cont");var c=this.oScrollDomRef,r=this.getDomRef(),a=this.getParent().getDomRef(),d=this.getDomRef("lbl");if(!A._isSizeSet(this.getParent().getWidth())&&A._isSizeSet(this.getMaxHeight())){if(c){var b=c.offsetTop;var t=(r.offsetHeight-b);c.style.height=t+"px";var e=c.offsetHeight;if(e>t){c.style.height=t-(e-t)+"px";}}}d.style.width=a.offsetWidth-30+"px";var s=this.__scrollproxy__;if(!s){s=this.__scrollproxy__=typeof this.onscroll==="function"?this.onscroll.bind(this):undefined;}this.$("cont").bind("scroll",s);};
A.prototype.onBeforeRendering=function(){var s=this.__scrollproxy__;if(s){this.$("cont").unbind("scroll",s);}};
A.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);var r=this.getDomRef();if(r){if(e){this.$().removeClass("sapUiAcdSectionDis");}else{this.$().addClass("sapUiAcdSectionDis");}}return this;};
A.prototype._setCollapsed=function(c){this.setProperty("collapsed",c,true);this._setCollapsedState(c);};
A.prototype.setCollapsed=function(c){if(this.getParent()){if(!c){this.getParent().openSection(this.getId());}else{this.getParent().closeSection(this.getId());}}else{this._setCollapsed(c);}return this;};
A.prototype._setCollapsedState=function(c){var t=this.getDomRef("tb"),a=this.getDomRef("cont"),b=sap.ui.getCore().getConfiguration().getAccessibility();if(this.getDomRef()){if(c){if(!this.getParent().getWidth()){this.getDomRef().style.width=this.getDomRef().offsetWidth+"px";}this.$().addClass("sapUiAcdSectionColl");if(t){t.style.display="none";}if(a){a.style.display="none";}if(b){a.setAttribute("aria-expanded","false");a.setAttribute("aria-hidden","true");}this.invalidate();}else{if(!a){this.invalidate();}else{this.$().removeClass("sapUiAcdSectionColl");if(t){t.style.display="block";}a.style.display="block";if(b){a.setAttribute("aria-expanded","true");}if(this.getMaxHeight()){this.getDomRef().style.height=this.getMaxHeight();}}}}};
A._isSizeSet=function(c){return(c&&!(c==="auto")&&!(c==="inherit"));};
A.prototype._handleTrigger=function(e){if((e.target.id===this.getId()+"-minL")||(e.target.id===this.getId()+"-minR")){var c=!this.getProperty("collapsed");this._setCollapsed(c);e.preventDefault();e.stopPropagation();}};
return A;});
sap.ui.predefine('sap/ui/commons/ApplicationHeader',['./library','sap/ui/core/Control','./Image','./TextView','./Button','./ApplicationHeaderRenderer','sap/ui/core/library'],function(l,C,I,T,B,A,c){"use strict";var a=c.AccessibleRole;
var b=C.extend("sap.ui.commons.ApplicationHeader",{metadata:{library:"sap.ui.commons",properties:{logoSrc:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},logoText:{type:"string",group:"Misc",defaultValue:null},displayLogoff:{type:"boolean",group:"Misc",defaultValue:true},userName:{type:"string",group:"Misc",defaultValue:null},displayWelcome:{type:"boolean",group:"Misc",defaultValue:true}},events:{logoff:{}}}});
b.prototype.init=function(){this.initializationDone=false;};
b.prototype.exit=function(){this.oLogo&&this.oLogo.destroy();this.oLogoText&&this.oLogoText.destroy();this.oLogoffBtn&&this.oLogoffBtn.destroy();};
b.prototype.initControls=function(){var d=this.getId();var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.oLogo&&this.oLogo.destroy();this.oLogo=new I(d+"-logoImg");this.oLogo.setTooltip(r.getText("APPHDR_LOGO_TOOLTIP"));this.oLogo.setParent(this);this.oLogoText&&this.oLogoText.destroy();this.oLogoText=new T(d+"-logoText");this.oLogoText.setAccessibleRole(a.Heading);this.oLogoText.setParent(this);this.oLogoffBtn&&this.oLogoffBtn.destroy();this.oLogoffBtn=new B(d+"-logoffBtn");var L=r.getText("APPHDR_LOGOFF");this.oLogoffBtn.setText(L);this.oLogoffBtn.setTooltip(L);this.oLogoffBtn.attachPress(this.logoff,this);this.oLogoffBtn.setParent(this);this.oLogoffBtn.setLite(true);};
b.prototype.logoff=function(e){this.fireLogoff();};
b.prototype.setLogoSrc=function(L){this.initializationDone=false;this.setProperty("logoSrc",L);return this;};
b.prototype.setLogoText=function(L){this.initializationDone=false;this.setProperty("logoText",L);return this;};
b.prototype.setUserName=function(u){this.initializationDone=false;this.setProperty("userName",u);return this;};
b.prototype.setDisplayWelcome=function(d){this.initializationDone=false;this.setProperty("displayWelcome",d);return this;};
b.prototype.setDisplayLogoff=function(d){this.initializationDone=false;this.setProperty("displayLogoff",d);return this;};
return b;});
sap.ui.predefine('sap/ui/commons/ApplicationHeaderRenderer',['sap/ui/core/theming/Parameters'],function(P){"use strict";var A={};
A.render=function(r,a){if(!a.initializationDone){a.initControls();a.initializationDone=true;}var b=a.getId();r.write("<header");r.writeControlData(a);r.addClass("sapUiAppHdr");r.writeClasses();r.write(">");r.write("<div id=\""+b+"-appHeaderWelcomeLogoffAreas\" class=\"sapUiAppHdrWelcomeLogoffArea sapUiInverted-CTX\">");this.renderWelcomeAndLogoffAreas(r,a);r.write("</div>");r.write("<div id=\""+b+"-logoArea\" class=\"sapUiAppHdrLogo\">");this.renderLogoArea(r,a);r.write("</div>");r.write("</header>");};
A.renderLogoArea=function(r,a){var s=a.getLogoSrc();if(!s){s=P._getThemeImage();}if(!s){s=sap.ui.resource("sap.ui.commons","themes/"+sap.ui.getCore().getConfiguration().getTheme()+"/img/applicationheader/SAPLogo.png");}a.oLogo.setSrc(s);r.renderControl(a.oLogo);if(a.getLogoText()!=""){a.oLogoText.setText(a.getLogoText());a.oLogoText.setTooltip(a.getLogoText());r.renderControl(a.oLogoText);}};
A.renderWelcomeAndLogoffAreas=function(r,a){var b=a.getId();if(a.getDisplayWelcome()){var c=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var p=sap.ui.getCore().getConfiguration().getRTL()?"padding-left":"padding-right";if(a.getUserName()!=""){r.write("<label class=\"sapUiLbl sapUiLblEmph\" style=\"text-align: left;\" id=\""+b+"-welcomeLabel\">"+c.getText("APPHDR_WELCOME_USER")+":</label>");r.write("&nbsp;");r.write("<label class=\"sapUiLbl\" style=\"text-align: left;",p,":15px;\" id=\"",b,"-userLabel\">");r.writeEscaped(a.getUserName());r.write("</label>");}else{r.write("<label class=\"sapUiLbl sapUiLblEmph\" style=\"text-align: left;"+p+":15px;\" id=\""+b+"-welcomeLabel\">"+c.getText("APPHDR_WELCOME")+"</label>");}}if(a.getDisplayLogoff()){if(a.getDisplayWelcome()){r.write("<span role=\"separator\" class=\"sapUiTbSeparator\"></span>");}r.renderControl(a.oLogoffBtn);}};
return A;},true);
sap.ui.predefine('sap/ui/commons/Area',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Element','sap/ui/dom/jquery/control'],function(q,l,E){"use strict";
var A=E.extend("sap.ui.commons.Area",{metadata:{library:"sap.ui.commons",properties:{shape:{type:"string",group:"Misc",defaultValue:null},coords:{type:"string",group:"Misc",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},alt:{type:"string",group:"Misc",defaultValue:null}}}});
A.prototype.onclick=function(e){var o=q(e.target).control(0);this.getParent().firePress({areaId:o.getId()});};
return A;});
sap.ui.predefine('sap/ui/commons/AutoComplete',['sap/ui/thirdparty/jquery','./ComboBox','./library','./AutoCompleteRenderer','./TextField','sap/ui/events/KeyCodes','jquery.sap.strings'],function(q,C,l,A,T,K){"use strict";
var a=C.extend("sap.ui.commons.AutoComplete",{metadata:{interfaces:["sap.ui.commons.ToolbarItem"],library:"sap.ui.commons",properties:{enableScrolling:{type:"boolean",group:"Misc",defaultValue:true}},events:{suggest:{parameters:{suggestValue:{type:"string"}}}}}});
a._DEFAULTFILTER=function(v,i){if(this._skipFilter){return true;}return q.sap.startsWithIgnoreCase(i.getText(),v);};
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.mobile=false;this._filter=a._DEFAULTFILTER;};
a.prototype.exit=function(){if(this._oListBox){this._oListBox.removeAllItems();}C.prototype.exit.apply(this,arguments);};
a.prototype.setFilterFunction=function(f){if(typeof(f)=="function"){this._filter=f;}else{this._filter=a._DEFAULTFILTER;}};
a.prototype.onkeypress=function(e){var k=e.which||e.keyCode;if(k===K.ESCAPE){T.prototype.onkeypress.apply(this,arguments);q(this.getInputDomRef()).removeAttr("aria-posinset");}};
a.prototype.onfocusin=function(e){if(!this.$().hasClass("sapUiTfFoc")){C.prototype.onfocusin.apply(this,arguments);}};
(function(){
function g(o,I){var d=o.getAriaDescribedBy();var D="";for(var i=0;i<d.length;i++){D+=d[i];if(i<d.length-1){D+=" ";}}if(I){D+=" "+o.getId()+"-ariaLbl";}return D;}
function u(o){var $=q(o.getInputDomRef());var d=g(o,false);if(d.length>0){$.attr("aria-describedby",d);}else{$.removeAttr("aria-describedby");}$.removeAttr("aria-posinset");$.removeAttr("aria-setsize");}
a.prototype._close=function(){u(this);C.prototype._close.apply(this,arguments);};
a.prototype._handleClosed=function(){u(this);C.prototype._handleClosed.apply(this,arguments);};
a.prototype.onAfterRendering=function(){C.prototype.onAfterRendering.apply(this,arguments);q(this.getInputDomRef()).removeAttr("aria-setsize");};
a.prototype._prepareOpen=function(L){var $=q(this.getInputDomRef());var d=g(this,true);$.attr("aria-describedby",d);$.removeAttr("aria-posinset");};
a.prototype._fireLiveChange=function(e){var f=false;var k;if(!this.getEnabled()||!this.getEditable()){this._close();}else{this._sTypedChars=q(this.getInputDomRef()).val();switch(e.type){case"keyup":case"sapup":case"sapdown":case"saphome":case"sapend":if(!C._isHotKey(e)){f=true;}else{break;}case"sapescape":this._close();break;case"keypress":k=e.which||e.keyCode;if(k===K.ESCAPE){this._close();break;}default:r(this);f=true;}}if(f){this.fireSuggest({suggestValue:this._sTypedChars});}C.prototype._fireLiveChange.apply(this,arguments);};
a.prototype._doTypeAhead=function(){this._sTypeAhead=null;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;this._sTypedChars=q(this.getInputDomRef()).val();r(this);};
a.prototype.refreshItems=function(R){var b=this.getBinding("items");if(R=="filter"&&b){b.getContexts();}else{a.prototype.updateItems.apply(this,arguments);}};
a.prototype._handleItemsChanged=function(e,d){if(d){this._sHandleItemsChanged=null;this._bNoItemCheck=undefined;}if(this._bNoItemCheck){return;}var i=[];if(this._getExistingListBox()){i=this._getListBox().getItems();}var D=this.getDomRef();if(D){q(this.getInputDomRef()).attr("aria-setsize",i.length);}};
a.prototype.getItems=function(){return this.getAggregation("items",[]);};
a.prototype.insertItem=function(i,I){this.insertAggregation("items",I,i,true);r(this);return this;};
a.prototype.addItem=function(i){this.addAggregation("items",i,true);r(this);return this;};
a.prototype.removeItem=function(i){var b=this.removeAggregation("items",i,true);r(this);return b;};
a.prototype.removeAllItems=function(){var b=this.removeAllAggregation("items");r(this);return b;};
a.prototype.indexOfItem=function(i){return this.indexOfAggregation("items",i);};
a.prototype.destroyItems=function(){this.destroyAggregation("items",true);r(this);return this;};
a.prototype.setEnableScrolling=function(e){this.setProperty("enableScrolling",e,true);if(this.oPopup&&this.oPopup.isOpen()){r(this);}return this;};
function r(o){if(!o.getDomRef()||!o.$().hasClass("sapUiTfFoc")){return false;}var I,b=o.getItems(),f=o._sTypedChars&&o._sTypedChars.length>0,L=o._getListBox(),m=o.getMaxPopupItems(),s=o.getEnableScrolling(),h=[];if(!f){o._close();return;}L.removeAllItems();L.clearSelection();for(var i=0;i<b.length;i++){I=b[i];if(!I.__CLONE){I.__CLONE=I.clone(I.getId()+"-CLONE",null,{cloneBindings:false});I.__origexit=I.exit;I.exit=function(){this.__CLONE.destroy();delete this.__CLONE;this.exit=this.__origexit;delete this.__origexit;if(typeof this.exit==="function"){this.exit.apply(this,arguments);}};}if((!f||o._filter(o._sTypedChars,I))&&(s||(!s&&h.length<m))){h.push(I.__CLONE);}}var c=h.length;if(c>0){if(o._sort){h.sort(function(d,e){if(d.getText()>e.getText()){return 1;}if(d.getText()<e.getText()){return-1;}return 0;});}for(var i=0;i<c;i++){L.addItem(h[i]);}L.setVisibleItems(m<c?m:c);if(!o.oPopup||!o.oPopup.isOpen()){o._open();}}else{o._close();}}
})();
a.prototype.setListBox=function(){return this;};
a.prototype.setSelectedKey=function(){return this;};
a.prototype.setSelectedItemId=function(){return this;};
return a;});
sap.ui.predefine('sap/ui/commons/AutoCompleteRenderer',['./ComboBoxRenderer','sap/ui/core/Renderer','sap/ui/core/library'],function(C,R,c){"use strict";var V=c.ValueState;var A=R.extend(C);
A.renderExpander=function(r,o){if(!o.__sARIATXT){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");o.__sARIATXT=a.getText("AUTOCOMPLETE_ARIA_SUGGEST");}r.write("<span id=\"",o.getId(),"-ariaLbl\" style=\"display:none;\">",o.__sARIATXT,"</span>");};
A.renderOuterAttributes=function(r,o){r.addClass("sapUiTfAutoComp");C.renderOuterAttributes.apply(this,arguments);};
A.renderComboARIAInfo=function(r,o){var p={role:"textbox",owns:o.getId()+"-input "+o._getListBox().getId()};if(!o.getEnabled()){p["disabled"]=true;}r.writeAccessibilityState(null,p);};
A.renderARIAInfo=function(r,o){var p={autocomplete:"list",live:"polite",relevant:"all",setsize:o._getListBox().getItems().length};if(o.getValueState()==V.Error){p["invalid"]=true;}r.writeAccessibilityState(o,p);};
return A;},true);
sap.ui.predefine('sap/ui/commons/Button',['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','./ButtonRenderer','sap/ui/Device'],function(l,C,E,I,B,D){"use strict";var a=l.ButtonStyle;
var b=C.extend("sap.ui.commons.Button",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.IFormContent"],library:"sap.ui.commons",properties:{text:{type:"string",group:"Appearance",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},helpId:{type:"string",group:"Behavior",defaultValue:''},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconHovered:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconSelected:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},styled:{type:"boolean",group:"Appearance",defaultValue:true},lite:{type:"boolean",group:"Appearance",defaultValue:false},style:{type:"sap.ui.commons.ButtonStyle",group:"Appearance",defaultValue:a.Default}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
E.call(b.prototype);
b.prototype.onclick=function(e){if(this.getEnabled()&&this.getVisible()){this.firePress({});}e.preventDefault();e.stopPropagation();};
b.prototype.onsapenter=function(e){e.stopPropagation();};
b.prototype.onmousedown=function(e){this.handleMouseDown(e,true);};
b.prototype.handleMouseDown=function(e,f){if(this.getEnabled()&&this.getRenderer().onactive){this.getRenderer().onactive(this);}if(f&&(D.browser.webkit||(D.browser.firefox&&navigator.platform.indexOf("Mac")===0))){if(D.browser.mobile&&D.browser.webkit){this.focus();}setTimeout(function(){this.focus();}.bind(this),0);}};
b.prototype.onmouseup=function(e){if(this.getEnabled()&&this.getRenderer().ondeactive){this.getRenderer().ondeactive(this);}};
b.prototype.onmouseout=function(e){if(this.getEnabled()&&this.getRenderer().onmouseout){this.getRenderer().onmouseout(this);}};
b.prototype.onmouseover=function(e){if(this.getEnabled()&&this.getRenderer().onmouseover){this.getRenderer().onmouseover(this);}};
b.prototype.onfocusout=function(e){if(this.getEnabled()&&this.getRenderer().onblur){this.getRenderer().onblur(this);}};
b.prototype.onfocusin=function(e){if(this.getEnabled()&&this.getRenderer().onfocus){this.getRenderer().onfocus(this);}};
b.prototype.setIcon=function(i){this._setIcon(i,"icon");return this;};
b.prototype.setIconHovered=function(i){this._setIcon(i,"iconHovered");return this;};
b.prototype.setIconSelected=function(i){this._setIcon(i,"iconSelected");return this;};
b.prototype._setIcon=function(i,p){var s=this.getProperty(p);if(s==i){return;}var u=false;if(I.isIconURI(s)){u=true;}var U=false;if(I.isIconURI(i)){U=true;}var S=true;if((!s&&i)||(s&&!i)||(u!=U)){S=false;}this.setProperty(p,i,S);if(S==true&&this.getDomRef()&&this.getRenderer().changeIcon){this.getRenderer().changeIcon(this);}};
b.prototype.getAccessibilityInfo=function(){var d=this.getText()||this.getTooltip_AsString();if(!d&&this.getIcon()){var i=I.getIconInfo(this.getIcon());if(i){d=i.text||i.name;}}return{role:"button",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_BUTTON"),description:d,focusable:this.getEnabled(),enabled:this.getEnabled()};};
return b;});
sap.ui.predefine('sap/ui/commons/ButtonRenderer',['sap/ui/commons/library','sap/ui/core/IconPool','sap/ui/Device','sap/base/security/encodeXML'],function(l,I,D,e){"use strict";var B=l.ButtonStyle;var a={};
a.render=function(r,o){r.addClass("sapUiBtn");r.write("<button type=\"button\"");r.writeControlData(o);if(o.getTooltip_AsString()){r.writeAttributeEscaped("title",o.getTooltip_AsString());}if(o.getStyled()){r.addClass("sapUiBtnS");}if(o.getLite()){r.addClass("sapUiBtnLite");}else{r.addClass("sapUiBtnNorm");}var s=o.getStyle();if(s!=""&&s!=B.Default){r.addClass("sapUiBtn"+e(s));}r.writeAccessibilityState(o,{role:'button',disabled:!o.getEnabled()});if(!o.getEnabled()){r.write(" tabindex=\"-1\"");r.addClass("sapUiBtnDsbl");}else{r.write(" tabindex=\"0\"");r.addClass("sapUiBtnStd");}var i=false;if(!o.getText()&&o.getIcon()){r.addClass("sapUiBtnIconOnly");i=true;var c=I.getIconInfo(o.getIcon()),t=o.getTooltip_AsString();if(t||(c&&c.name)){r.writeAttributeEscaped("title",t||c.name);}}if(o.getIcon()&&o.getText()){r.addClass("sapUiBtnIconAndText");}if(o.getWidth()&&o.getWidth()!=''){r.addStyle("width",o.getWidth());r.addClass("sapUiBtnFixedWidth");}if(o.getHeight()&&o.getHeight()!=''){r.addStyle("height",o.getHeight());}r.writeStyles();if(this.renderButtonAttributes){this.renderButtonAttributes(r,o);}if(D.browser.msie&&(!document.documentMode||document.documentMode<10)){r.addClass("sapUiBtnNoGradient");}r.writeClasses();r.write(">");if(this.renderButtonContentBefore){this.renderButtonContentBefore(r,o);}var u=false;if(I.isIconURI(o.getIcon())){u=true;}if(o.getIconFirst()){if(u){this.writeIconHtml(r,o);}else if(this._getIconForState(o,"base")){this.writeImgHtml(r,o,i);}}if(o.getText()){if(!o.getIcon()&&!this.renderButtonContentBefore&&!this.renderButtonContentAfter){r.writeEscaped(o.getText());}else{r.write("<span class=\"sapUiBtnTxt\">");r.writeEscaped(o.getText());r.write("</span>");}}if(!o.getIconFirst()){if(u){this.writeIconHtml(r,o);}else if(this._getIconForState(o,"base")){this.writeImgHtml(r,o,i);}}if(this.renderButtonContentAfter){this.renderButtonContentAfter(r,o);}r.write("</button>");};
a.onactive=function(o){o.$().addClass("sapUiBtnAct").removeClass("sapUiBtnStd");o.$("img").attr("src",this._getIconForState(o,"active"));};
a.ondeactive=function(o){o.$().addClass("sapUiBtnStd").removeClass("sapUiBtnAct");o.$("img").attr("src",this._getIconForState(o,"deactive"));};
a.onblur=function(o){o.$().removeClass("sapUiBtnFoc");o.$("img").attr("src",this._getIconForState(o,"blur"));if(D.browser.msie){a.onmouseout(o);}};
a.onfocus=function(o){o.$().addClass("sapUiBtnFoc");o.$("img").attr("src",this._getIconForState(o,"focus"));};
a.onmouseout=function(o){o.$().removeClass("sapUiBtnAct");o.$().addClass("sapUiBtnStd");o.$("img").attr("src",this._getIconForState(o,"mouseout"));};
a.onmouseover=function(o){o.$("img").attr("src",this._getIconForState(o,"mouseover"));};
a._getIconForState=function(o,s){if(!o.getEnabled()){s="disabled";}switch(s){case"focus":case"blur":case"base":if(o.$().hasClass("sapUiBtnAct")){var i=o.getIconSelected()||o.getIconHovered();return i?i:o.getIcon();}else if(o.$().hasClass("sapUiBtnFoc")){return o.getIcon();}return o.getIcon();case"mouseout":if(o.$().hasClass("sapUiBtnFoc")){return o.getIcon();}return o.getIcon();case"active":var i=o.getIconSelected()||o.getIconHovered();return i?i:o.getIcon();case"mouseover":case"deactive":var i=o.getIconHovered();return i?i:o.getIcon();}return o.getIcon();};
a.writeImgHtml=function(r,o,i){var c=this._getIconForState(o,"base");r.write("<img");r.writeAttribute("id",o.getId()+"-img");r.writeAttributeEscaped("src",c);if(o.getTooltip_AsString()&&!o.getText()){r.writeAttributeEscaped("alt",o.getTooltip_AsString());}else{r.writeAttribute("alt","");}if(!i){r.writeAttribute("role","presentation");}r.addClass("sapUiBtnIco");if(o.getText()){r.addClass(o.getIconFirst()?"sapUiBtnIcoL":"sapUiBtnIcoR");}r.writeClasses();r.write("/>");};
a.writeIconHtml=function(r,o){var c=[];var A=b(o);c.push("sapUiBtnIco");if(o.getText()){c.push(o.getIconFirst()?"sapUiBtnIcoL":"sapUiBtnIcoR");}r.writeIcon(o.getIcon(),c,A);};
a.changeIcon=function(o){if(I.isIconURI(o.getIcon())){var i=I.getIconInfo(o.getIcon());var c=o.$("icon");c.attr("data-sap-ui-icon-content",i.content);if(!i.skipMirroring){c.addClass("sapUiIconMirrorInRTL");}else{c.removeClass("sapUiIconMirrorInRTL");}}else if(o.$().hasClass("sapUiBtnAct")){o.$("img").attr("src",this._getIconForState(o,"active"));}else if(o.$().hasClass("sapUiBtnFoc")){o.$("img").attr("src",this._getIconForState(o,"focus"));}else if(o.$().hasClass("sapUiBtnStd")){o.$("img").attr("src",this._getIconForState(o,"base"));}};
function b(o){var A={},t=o.getTooltip_AsString();A["id"]=o.getId()+"-icon";if(t){A["title"]=null;A["aria-label"]=null;A["aria-hidden"]=true;}return A;}
return a;},true);
sap.ui.predefine('sap/ui/commons/Callout',['./CalloutBase','./library','./CalloutRenderer'],function(C,l,a){"use strict";
var b=C.extend("sap.ui.commons.Callout",{metadata:{library:"sap.ui.commons",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
return b;});
sap.ui.predefine('sap/ui/commons/CalloutBase',['sap/ui/thirdparty/jquery','./library','sap/ui/core/TooltipBase','./CalloutBaseRenderer','sap/ui/core/Popup','sap/ui/events/ControlEvents','sap/ui/events/KeyCodes','sap/ui/dom/jquery/control','sap/ui/dom/jquery/Focusable'],function(q,l,T,C,P,a,K){"use strict";var D=P.Dock;
var b=T.extend("sap.ui.commons.CalloutBase",{metadata:{library:"sap.ui.commons",events:{open:{parameters:{parent:{type:"sap.ui.core.Control"}}},close:{},beforeOpen:{allowPreventDefault:true,parameters:{parent:{type:"sap.ui.core.Control"}}},opened:{}}}});
b.prototype.init=function(){this.oPopup=new P();this.oPopup.setShadow(true);this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.setPosition(D.BeginBottom,D.BeginTop);this.fAnyEventHandlerProxy=q.proxy(this.onAnyEvent,this);var t=this;this.oPopup._applyPosition=function(p){P.prototype._applyPosition.call(this,p);t.setTip();};this.oPopup.setFollowOf(P.CLOSE_ON_SCROLL);};
b.prototype.exit=function(){this.oPopup.close();this.oPopup.detachEvent("opened",this.handleOpened,this);this.oPopup.detachEvent("closed",this.handleClosed,this);this.oPopup.destroy();delete this.oPopup;delete this.oRb;a.unbindAnyEvent(this.fAnyEventHandlerProxy);};
b.prototype._getPopup=function(){return this.oPopup;};
b.prototype.hasChild=function(d){return d&&!!(q(d).closest(this.getDomRef()).length);};
b.prototype.isPopupElement=function(d){if(!d){return false;}if(this.hasChild(d)){return true;}var s=sap.ui.getCore().getStaticAreaRef();var t=parseInt(q(d).closest(q(s).children()).css("z-index"));var c=parseInt(this.$().css("z-index"));return t&&c&&t>=c;};
b.prototype.setTip=function(){if(!this.oPopup||!this.oPopup.isOpen()){return;}var $=this._currentControl.$(),c=this.$(),d=this.$("arrow"),e=c.offset(),g=$.offset(),s=true,h={},t={l:e.left,r:e.left+c.outerWidth(),w:c.outerWidth(),t:e.top,b:e.top+c.outerHeight(),h:c.outerHeight()},p={l:g.left,r:g.left+$.outerWidth(),w:$.outerWidth(),t:g.top,b:g.top+$.outerHeight(),h:$.outerHeight()},i=(c.outerWidth()-c.innerWidth())/2,j=d.outerWidth()*1.4,k=d.outerWidth()/5,m=k-i-8,n=this.getMyPosition();if(t.r<p.l-m){h.x="right";}else if(t.l-m>p.r){h.x="left";}if(t.t>p.b-m){h.y="top";}else if(t.b<p.t+m){h.y="bottom";}if(h.x){var v=0;if(n.indexOf("top")>-1){v=20;}else if(n.indexOf("bottom")>-1){v=t.h-20-j;}else{v=(t.h-j)/2;}var o=t.t+v+j/2+i;if((o<p.t)||(o>p.b)||(p.t>t.t&&p.b<t.b)){v=(Math.max(t.t,p.t)+Math.min(t.b,p.b))/2-t.t-j/2;}d.css(h.x,m+"px");d.css("top",v);if(v<0||v>t.h-j){s=false;}}if(h.y){var r=sap.ui.getCore().getConfiguration().getRTL();if(r){n.replace("begin","right").replace("end","left");}var u=0;if((n.indexOf("begin")>-1)||(n.indexOf("left")>-1)){u=20;}else if((n.indexOf("right")>-1)||(n.indexOf("end")>-1)){u=t.w-20-j;}else{u=(t.w-j)/2;}var w=t.l+u+j/2+i;if((w<p.l)||(w>p.r)){u=(Math.max(t.l,p.l)+Math.min(t.r,p.r))/2-t.l-j/2;}d.css(h.y,m+"px");d.css("left",u+"px");if(u<0||u>t.w-j){s=false;}}if(h.x&&h.y||!h.x&&!h.y){s=false;}d.toggle(s);};
b.prototype.adjustPosition=function(){function _(){if(this.oPopup){var p=this._currentControl.getDomRef();this.oPopup.setPosition(this.getMyPosition(),this.getAtPosition(),p,this.getOffset(),this.getCollision());}}setTimeout(q.proxy(_,this),0);};
b.prototype.focus=function(){if(this.oPopup&&this.oPopup.isOpen()){var c=this.$("cont");f(c.firstFocusableDomRef()||c.get(0));}};
b.prototype.openPopup=function(s){if(!this.oPopup||this.oPopup.isOpen()){return;}if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);T.sOpenTimeout=undefined;}if(!this.fireEvent("beforeOpen",{parent:this._currentControl},true,false)){if(!this.sCloseNowTimeout){T.sOpenTimeout=setTimeout(function(){this.openPopup(this._currentControl);}.bind(this),200);}return;}this.oParentFocusInfo=s.getFocusInfo();this.oPopup.attachEvent("opened",this.handleOpened,this);T.prototype.openPopup.call(this,s);this.adjustPosition();this.fireOpen({parent:this._currentControl});};
b.prototype.close=function(){if(this.oPopup&&this.oPopup.isOpen()&&!this.sCloseNowTimeout){if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);T.sOpenTimeout=undefined;}this.closePopup();}};
b.prototype.closePopup=function(){var w=this.oPopup!==undefined&&this.oPopup.isOpen();if(this.fAnyEventHandlerProxy){a.unbindAnyEvent(this.onAnyEvent);}T.prototype.closePopup.call(this);if(w&&this._currentControl&&this.bFocused){this._currentControl.applyFocusInfo(this.oParentFocusInfo);this.bFocused=false;}this.fireClose();};
b.prototype.handleClosed=function(){if(this.oPopup){this.oPopup.detachEvent("closed",this.handleClosed,this);this.fireClosed();}};
b.prototype.onkeydown=function(e){var c=e.ctrlKey&&e.which==K.I;var E=e.which==K.ESCAPE;if(!c&&!E){if(q(e.target).control(0)===this._currentControl){this.close();}return;}if(c){if(this.oPopup&&this.oPopup.isOpen()){return;}this.bDoFocus=true;}T.prototype.onkeydown.call(this,e);};
b.prototype.handleOpened=function(){this.oPopup.detachEvent("opened",this.handleOpened,this);if(this.bDoFocus){this.focus();this.bDoFocus=false;this.bFocused=true;}this.$().css("display:","");this.fireOpened();a.bindAnyEvent(this.fAnyEventHandlerProxy);};
b.prototype.onfocusin=function(e){this.bFocused=true;var s=e.target;if(s.id===this.getId()+"-fhfe"){f(this.$("cont").lastFocusableDomRef());}else if(s.id===this.getId()+"-fhee"){f(this.$("cont").firstFocusableDomRef());}};
b.prototype.onfocusout=function(e){return;};
b.prototype.onmouseover=function(e){if(this.oPopup&&(this.oPopup.isOpen()&&this.oPopup.getContent()==this)){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}return;}else{T.prototype.onmouseover.call(this,e);}};
b.prototype.onmouseout=function(e){if(this.oPopup&&(this.oPopup.isOpen()&&this.isPopupElement(e.relatedTarget))){return;}T.prototype.onmouseout.call(this,e);};
b.prototype.onmousedown=function(e){if(q(e.target).control(0)===this._currentControl){this.close();this.removeStandardTooltips();}};
b.prototype.onAnyEvent=function(e){if((this.oPopup&&!this.oPopup.isOpen())||e.type!="mouseover"||this.hasChild(e.target)){return;}var d=this.isPopupElement(e.target)||q(e.target).control(0)===this._currentControl;if(!d&&!this.sCloseNowTimeout&&!T.sOpenTimeout){this.sCloseNowTimeout=setTimeout(function(){this.closePopup();}.bind(this),400);}if(d&&this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}};
b.prototype.setPosition=function(m,c){var d=m||D.BeginBottom;var e=c||D.BeginTop;var g=0,h=0,i=0,j=0,k=5;if((d.indexOf("begin")>-1)||(d.indexOf("left")>-1)){g=-1;}else if((d.indexOf("right")>-1)||(d.indexOf("end")>-1)){g=1;}if((e.indexOf("begin")>-1)||(e.indexOf("left")>-1)){i=-1;}else if((e.indexOf("right")>-1)||(e.indexOf("end")>-1)){i=1;}if(d.indexOf("top")>-1){h=-1;}else if(d.indexOf("bottom")>-1){h=1;}if(e.indexOf("top")>-1){j=-1;}else if(e.indexOf("bottom")>-1){j=1;}var o=((g-i)*g*i*k)+" "+((h-j)*h*j*k);this.setMyPosition(d);this.setAtPosition(e);this.setOffset(o);return this;};
function f(e){if(e){e.focus();}}
return b;});
sap.ui.predefine('sap/ui/commons/CalloutBaseRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){var a=sap.ui.getCore().getConfiguration().getAccessibility();var i=c.getId();r.write("<div");r.writeControlData(c);r.addClass("sapUiCltBase");if(this.addRootClasses){this.addRootClasses(r,c);}r.writeClasses();if(a){r.writeAttribute("role","dialog");var A=c.oRb.getText('CALLOUT_ARIA_NAME');if(A){r.writeAttributeEscaped("aria-label",A);}}if(c.getTooltip_AsString()){r.writeAttributeEscaped("title",c.getTooltip_AsString());}r.addStyle("display","none");r.writeStyles();r.write(">");r.write("<span id=\""+i+"-fhfe\" tabindex=\"0\"></span>");r.write("<div");r.writeAttribute("id",i+"-cont");r.addClass("sapUiCltBaseCont");if(this.addContentClasses){this.addContentClasses(r,c);}r.writeClasses();r.writeAttribute("tabindex","-1");r.write(">");if(this.renderContent){this.renderContent(r,c);}r.write("</div>");r.write("<div");r.writeAttribute("id",i+"-arrow");if(a){r.writeAttribute("role","presentation");}r.addClass("sapUiCltBaseArr");if(this.addArrowClasses){this.addArrowClasses(r,c);}r.writeClasses();r.write("></div>");r.write("<span id=\""+i+"-fhee\" tabindex=\"0\"></span>");r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/commons/CalloutRenderer',['./CalloutBaseRenderer','sap/ui/core/Renderer'],function(C,R){"use strict";var a=R.extend(C);
a.renderContent=function(r,c){var b=c.getContent();for(var i=0;i<b.length;i++){r.renderControl(b[i]);}};
a.addRootClasses=function(r,c){r.addClass("sapUiClt");};
a.addContentClasses=function(r,c){r.addClass("sapUiCltCont");};
a.addArrowClasses=function(r,c){r.addClass("sapUiCltArr");};
return a;},true);
sap.ui.predefine('sap/ui/commons/CarouselRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){var R=sap.ui.getCore().getConfiguration().getRTL();r.write("<div");r.addClass("sapUiCrsl");if(c.getWidth()!=""){r.addStyle("width",c.getWidth());}if(c.getHeight()!=""){r.addStyle("height",c.getHeight());}r.writeStyles();r.writeClasses();r.writeControlData(c);r.write(">");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");r.write("<div");r.writeAttribute("id",c.getId()+"-prevbutton");r.writeAttribute("title",a.getText("CAROUSEL_SHOW_PREV"));r.addClass("sapUiCrslPrevBtn");r.writeClasses();if(c.getHandleSize()!=22){if(c.getOrientation()=="vertical"){r.addStyle("height",c.getHandleSize()+"px");}else{r.addStyle("width",c.getHandleSize()+"px");}r.writeStyles();}r.write(">");if(c.getOrientation()=="vertical"){r.write("&#9650");}else{if(R){r.write("&#9658");}else{r.write("&#9668");}}r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-nextbutton");r.writeAttribute("title",a.getText("CAROUSEL_SHOW_NEXT"));r.addClass("sapUiCrslNextBtn");r.writeClasses();if(c.getHandleSize()!=22){if(c.getOrientation()=="vertical"){r.addStyle("height",c.getHandleSize()+"px");}else{r.addStyle("width",c.getHandleSize()+"px");}r.writeStyles();}r.write(">");if(c.getOrientation()=="vertical"){r.write("&#9660");}else{if(R){r.write("&#9668");}else{r.write("&#9658");}}r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-contentarea");r.addClass("sapUiCrslCnt");r.writeClasses();r.write(">");var b=c.getContent();r.write("<ul");r.writeAttribute("id",c.getId()+"-scrolllist");r.writeAttribute("role","listbox");r.writeAttribute("aria-describedby",c.getId()+"-navigate");r.addClass("sapUiCrslScl");r.writeClasses();r.write(">");for(var i=0;i<b.length;i++){var o=b[i];r.write("<li");r.writeAttribute("id",c.getId()+"-item-"+o.getId());r.writeAccessibilityState(c,{role:"option",posinset:i+1,setsize:b.length,labelledby:c.getId()+"-toggleaction"});r.writeAttribute("tabindex","-1");r.addClass("sapUiCrslItm");r.writeClasses();r.write(">");r.renderControl(o);r.write("</li>");}r.write("</ul>");r.write("</div>");r.write("<div");r.writeAttribute("tabindex","0");r.addClass("sapUiCrslBefore");r.writeClasses();r.write("></div>");r.write("<div");r.writeAttribute("tabindex","0");r.addClass("sapUiCrslAfter");r.writeClasses();r.write("></div>");r.write("<span");r.writeAttribute("id",c.getId()+"-toggleaction");r.addStyle("position","absolute");r.addStyle("top","-20000px");r.writeStyles();r.write(">");r.write(a.getText("CAROUSEL_ACTION_MODE"));r.write("</span>");r.write("<span");r.writeAttribute("id",c.getId()+"-navigate");r.addStyle("position","absolute");r.addStyle("top","-20000px");r.writeStyles();r.write(">");r.write(a.getText("CAROUSEL_NAV"));r.write("</span>");r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/commons/CheckBox',['./library','sap/ui/core/Control','./CheckBoxRenderer','sap/ui/core/library','sap/ui/Device'],function(l,C,a,c,D){"use strict";var T=c.TextDirection;var V=c.ValueState;
var b=C.extend("sap.ui.commons.CheckBox",{metadata:{library:"sap.ui.commons",properties:{checked:{type:"boolean",group:"Data",defaultValue:false,bindable:"bindable"},text:{type:"string",group:"Appearance",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},name:{type:"string",group:"Misc",defaultValue:null}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{checked:{type:"boolean"}}}}}});
b.prototype.onclick=function(e){if(D.browser.msie&&!this.getEnabled()){this.$().attr("tabindex",0).addClass("sapUiCbFoc");}this.userToggle(e);};
b.prototype.onfocusout=function(e){if(D.browser.msie&&!this.getEnabled()){this.$().attr("tabindex",-1).removeClass("sapUiCbFoc");}};
b.prototype.onsapspace=function(e){this.userToggle(e);};
b.prototype.userToggle=function(e){e.preventDefault();if(this.getEnabled()&&this.getEditable()){this.toggle();this.fireChange({checked:this.getChecked()});}else{this.getDomRef().focus();}};
b.prototype.toggle=function(){this.setChecked(!this.getChecked());return this;};
b.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");return{role:"checkbox",type:B.getText("ACC_CTR_TYPE_CHECKBOX"),description:(this.getText()||"")+(this.getChecked()?(" "+B.getText("ACC_CTR_STATE_CHECKED")):""),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEditable()};};
return b;});
sap.ui.predefine('sap/ui/commons/CheckBoxRenderer',['sap/ui/core/ValueStateSupport','sap/ui/core/library'],function(V,c){"use strict";var T=c.TextDirection;var a=c.ValueState;var A=c.AccessibleRole;var C={};
C.render=function(r,o){r.addClass("sapUiCb");r.write("<span");r.writeControlData(o);r.writeAccessibilityState(o,{"role":A.Checkbox.toLowerCase()});r.writeAttributeEscaped("aria-labelledby",o.getId()+"-label");var e=o.getEnabled()!=null&&o.getEnabled();var b=o.getEditable()!=null&&o.getEditable();var i=false;var d=false;if(o.getValueState()!=null){i=a.Error==o.getValueState();d=a.Warning==o.getValueState();}if(o.getChecked()){r.addClass("sapUiCbChk");}var m=0;if(!b){r.addClass("sapUiCbRo");m=0;}if(!e){r.addClass("sapUiCbDis");m=-1;}if(i){r.addClass("sapUiCbErr");r.writeAttribute("aria-invalid","true");}else if(d){r.addClass("sapUiCbWarn");}if(e&&b&&!i&&!d){r.addClass("sapUiCbStd");}if(e&&b){r.addClass("sapUiCbInteractive");}r.writeClasses();if(o.getWidth()&&o.getWidth()!=''){r.writeAttribute("style","width:"+o.getWidth()+";");}r.writeAttribute("tabindex",m);r.write(">");r.write("<input type='CheckBox' tabindex='-1' id='");r.write(o.getId());r.write("-CB'");if(o.getName()){r.writeAttributeEscaped('name',o.getName());}if(o.getChecked()){r.write(" checked='checked'");}if(!e){r.write(" disabled='disabled'");}var t=V.enrichTooltip(o,o.getTooltip_AsString());if(t){r.writeAttributeEscaped("title",t);}if(!b){r.write(" disabled='disabled'");}r.write(" />");r.write("<label");r.writeAttributeEscaped("id",o.getId()+"-label");if(t){r.writeAttributeEscaped("title",t);}r.writeAttribute("for",o.getId()+"-CB");if(!o.getText()){r.write(" class='sapUiCbNoText'");}r.write(">");if(o.getText()){this.renderText(r,o.getText(),o.getTextDirection());}r.write("</label>");r.write("</span>");};
C.renderText=function(r,t,e){if(!e||e==T.Inherit){r.writeEscaped(t);}else{r.write("<span style=\"direction:"+e.toLowerCase()+";\">");r.writeEscaped(t);r.write("</span>");}};
return C;},true);
sap.ui.predefine('sap/ui/commons/ColorPicker',['./library','sap/ui/unified/ColorPicker',"sap/base/Log"],function(l,U,L){"use strict";
var C=U.extend("sap.ui.commons.ColorPicker",{
metadata:{deprecated:true,library:"sap.ui.commons"},
renderer:"sap.ui.unified.ColorPickerRenderer"
});
try{sap.ui.getCore().loadLibrary("sap.ui.unified");}catch(e){L.error("The control 'sap.ui.commons.ColorPicker' needs library 'sap.ui.unified'.");throw(e);}return C;});
sap.ui.predefine('sap/ui/commons/ComboBox',['sap/ui/thirdparty/jquery','./TextField','./library','sap/ui/core/Popup','./ComboBoxRenderer','sap/ui/core/library','sap/ui/Device','./ListBox','sap/ui/base/Event','sap/ui/dom/containsOrEquals','sap/ui/events/KeyCodes','sap/ui/events/jquery/EventExtension','sap/ui/dom/jquery/rect','sap/ui/dom/jquery/selectText','jquery.sap.strings'],function(q,T,a,P,C,c,D,L,E,b,K,d){"use strict";var A=c.AccessibleRole;
var e=T.extend("sap.ui.commons.ComboBox",{metadata:{interfaces:["sap.ui.commons.ToolbarItem"],library:"sap.ui.commons",properties:{maxPopupItems:{type:"int",group:"Behavior",defaultValue:10},displaySecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:null},selectedItemId:{type:"string",group:"Data",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.ListItem",multiple:true,singularName:"item",bindable:"bindable"},myListBox:{type:"sap.ui.commons.ListBox",multiple:false,visibility:"hidden"}},associations:{listBox:{type:"sap.ui.commons.ListBox",multiple:false}}}});
e.prototype.init=function(){T.prototype.init.apply(this,arguments);this._iClosedUpDownIdx=-1;this._sCloseId=null;this.setAccessibleRole(A.Combobox);if(!D.system.desktop){this.mobile=true;}};
e.prototype.exit=function(){if(this._oListBox){if(this._oListBoxDelegate){this._oListBox.removeDelegate(this._oListBoxDelegate);}if(this.getAggregation("myListBox")){this.destroyAggregation("myListBox",true);}else{this._oListBox.destroy();}this._oListBox=null;}else if(this.getListBox()){var l=sap.ui.getCore().byId(this.getListBox());if(l){l.detachEvent("itemsChanged",this._handleItemsChanged,this);l.detachEvent("itemInvalidated",this._handleItemInvalidated,this);}}this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;if(this._sHandleItemsChanged){clearTimeout(this._sHandleItemsChanged);this._sHandleItemsChanged=null;this._bNoItemCheck=undefined;}};
e.prototype.onclick=function(o){if(this.getEnabled&&this.getEnabled()&&this.getEditable()&&o.target===this.getF4ButtonDomRef()){if(this.oPopup&&this.oPopup.isOpen()){this._close();}else if(!this._F4ForClose){this._open();}this.focus();}this._F4ForClose=false;};
e.prototype.onmousedown=function(o){var f=this.getF4ButtonDomRef();if(o.target!==f||!this.getEnabled()||!this.getEditable()){if(this.oPopup&&this.oPopup.isOpen()){o.stopPropagation();}return;}else if(o.target==f&&q(this.getFocusDomRef()).data("sap.INItem")){o.stopPropagation();this.focus();}if(this.oPopup&&this.oPopup.isOpen()){this._F4ForClose=true;}else{this._F4ForOpen=true;}};
e.prototype.onsapshow=function(o){if(this.mobile){return;}if(this.oPopup&&this.oPopup.isOpen()){this._close();}else{this._open();}o.preventDefault();o.stopImmediatePropagation();};
e.prototype.onsapnextmodifiers=function(o){T.prototype.onsapnextmodifiers.apply(this,arguments);if(o.keyCode==K.ARROW_DOWN&&o.altKey){this.onsapshow(o);o.stopPropagation();}};
e.prototype.onsaphide=function(o){if(this.mobile){return;}this._close();o.stopPropagation();};
e.prototype.onsapescape=function(o){if(this.oPopup&&this.oPopup.isOpen()){this._close();o.stopPropagation();}T.prototype.onsapescape.apply(this,arguments);var i=this.getSelectedItemId();if(i){var I=sap.ui.getCore().byId(i);this._iClosedUpDownIdx=this.indexOfItem(I);var l=this._getListBox();l.setSelectedIndex(this._iClosedUpDownIdx);this._updatePosInSet(null,this._iClosedUpDownIdx+1,(I.getAdditionalText?I.getAdditionalText():""));}else{this._updatePosInSet(null,-1,null);this._iClosedUpDownIdx=-1;}};
e.prototype.onsapenter=function(o){this._close();this._checkChange(o);};
e.prototype.onsapfocusleave=function(o){var l=this._getListBox();if((o.relatedControlId&&b(l.getFocusDomRef(),sap.ui.getCore().byId(o.relatedControlId).getFocusDomRef()))||this._bOpening){this.focus();}else{T.prototype.onsapfocusleave.apply(this,arguments);}};
e.prototype._checkChange=function(o,I){var f=this.getInputDomRef();if(!f){return;}var n=q(f).val(),O=this.getValue();if(!this._F4ForOpen&&(this.getEditable()&&this.getEnabled())){var g=this.getItems(),h=null,t,k,s,j;if(O!=n){this.setValue(n,true);for(var i=0,l=g.length;i<l;i++){t=g[i].getText();if(t===n){if(i==this._iClosedUpDownIdx){h=g[i];k=h.getKey();s=h.getId();j=i;break;}else if(!j){h=g[i];k=h.getKey();s=h.getId();j=i;}}}this.setProperty("selectedKey",k,true);this.setProperty("selectedItemId",s,true);if(s){this._iClosedUpDownIdx=j;}else{this._iClosedUpDownIdx=-1;}if(this.mobile){if(!s){this._addDummyOption(n);}else{this._removeDummyOption();this.getDomRef("select").selectedIndex=j;}}}else{var m=this.getSelectedItemId();var N;j=this._iClosedUpDownIdx;if(j>=0){h=g[j];if(h.getText()==n){N=h.getId();}}if(N&&N!=m){this.setSelectedItemId(N,true);}else{return;}}this.fireChange({newValue:n,selectedItem:h});}};
e.prototype.onkeypress=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}if(this._sTypeAhead){clearTimeout(this._sTypeAhead);}if(e._isHotKey(o)||o.keyCode===K.F4&&o.which===0){return;}var k=o.which||o.keyCode;if(k!==K.DELETE&&k!==K.BACKSPACE&&k!==K.ESCAPE){this._sTypeAhead=setTimeout(function(){this._doTypeAhead();}.bind(this),200);}else{T.prototype.onkeypress.apply(this,arguments);if(k!==K.ESCAPE){this._updatePosInSet(null,-1,null);}}};
e.prototype.onsapup=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}if(q(this.getFocusDomRef()).data("sap.InNavArea")){return;}var l=this._getListBox(),I=l.getItems(),f=this.getInputDomRef(),v=q(f).val();var i=this._prepareUpDown(I,v);i=this._updateIdx(I,f,i-1,i,o);o.preventDefault();o.stopPropagation();};
e.prototype.onsapdown=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}if(q(this.getFocusDomRef()).data("sap.InNavArea")){return;}var l=this._getListBox(),I=l.getItems(),f=this.getInputDomRef(),v=q(f).val();var i=this._prepareUpDown(I,v);i=this._updateIdx(I,f,i+1,i,o);o.preventDefault();o.stopPropagation();};
e.prototype.onsaphome=function(o){T.prototype.onsaphome.apply(this,arguments);if(o.target.id==this.getId()+"-select"){return;}if(!this.getEditable()||!this.getEnabled()||!this.oPopup||!this.oPopup.isOpen()){return;}var l=this._getListBox(),i=l.getItems(),f=this.getInputDomRef();this._updateIdx(i,f,0,undefined,o);o.preventDefault();o.stopPropagation();};
e.prototype.onsapend=function(o){T.prototype.onsapend.apply(this,arguments);if(o.target.id==this.getId()+"-select"){return;}if(!this.getEditable()||!this.getEnabled()||!this.oPopup||!this.oPopup.isOpen()){return;}var l=this._getListBox(),I=l.getItems(),f=this.getInputDomRef();var i=I.length-1;i=this._updateIdx(I,f,i,undefined,o);o.preventDefault();o.stopPropagation();};
e.prototype._doTypeAhead=function(){this._sTypeAhead=null;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;var o=this._getListBox(),I=o.getItems(),f,t,r=q(this.getInputDomRef()),v=r.val(),s=q.sap.startsWithIgnoreCase;this._sTypedChars=v;var F=false;var i=0;for(var l=I.length;i<l;i++){f=I[i];t=""+f.getText();if(s(t,v)&&f.getEnabled()){this._updatePosInSet(r,i+1,(f.getAdditionalText?f.getAdditionalText():""));r.val(t);this._doSelect(v.length,t.length);o.setSelectedIndex(i);o.scrollToIndex(i,true);F=true;if(this.mobile){this._removeDummyOption();this.getDomRef("select").selectedIndex=i;}return;}}o.clearSelection();o.scrollToIndex(i,true);if(!F){this._updatePosInSet(r,-1,null);if(this.mobile){this._addDummyOption(v);}}};
e.prototype._prepareUpDown=function(I,v){var t;if(this._iClosedUpDownIdx>=0&&I[this._iClosedUpDownIdx]&&I[this._iClosedUpDownIdx].getText()!==v){this._iClosedUpDownIdx=-1;}if(this._iClosedUpDownIdx===-1){for(var i=0,l=I.length;i<l;i++){t=I[i].getText();if(t===v){this._iClosedUpDownIdx=i;break;}}}return this._iClosedUpDownIdx;};
e.prototype._updateIdx=function(I,o,n,f,g){var l=I.length,F=n===0&&f===undefined,h=f!==undefined&&f<n||F,i,r=q(o);if(n<0){i=0;}else if(n<l){i=n;}else{i=l-1;}var j,v=false;do{n=h?i++:i--;j=I[n];v=j&&j.getEnabled()&&!(j instanceof sap.ui.core.SeparatorItem)&&j.getId()!==this.getId()+"_shi";}while(!v&&i<l&&i>=0);if(v){var t=j.getText();var p=n+1;if(this._determinePosinset){p=this._determinePosinset(I,n);}this._updatePosInSet(r,p,(j.getAdditionalText?j.getAdditionalText():""));r.val(t);this._doSelect();this._fireLiveChange(g);var k=this._getListBox();k.setSelectedIndex(n);k.scrollToIndex(n,true);}else{n=f;}this._iClosedUpDownIdx=n;return n;};
e.prototype._doSelect=function(s,i){var o=this.getInputDomRef();if(o){var r=q(o);o.focus();r.selectText(s?s:0,i?i:r.val().length);}return this;};
e.prototype.getF4ButtonDomRef=function(){return this.getDomRef("icon");};
e.prototype._getPrivateListBox=function(){if(this._oListBox){return this._oListBox;}this._oListBox=new L(this.getId()+"-lb",{allowMultiSelect:false});this.setAggregation("myListBox",this._oListBox,true);this._oListBox.attachEvent("itemsChanged",this._handleItemsChanged,this);this._oListBox.attachEvent("itemInvalidated",this._handleItemInvalidated,this);if(this.getDomRef()){this.$().attr("aria-owns",this.getId()+"-input "+this._oListBox.getId());}return this._oListBox;};
e.prototype._getExistingListBox=function(){var l=this.getListBox(),o;if(l){o=sap.ui.getCore().byId(l);}else if(this._oListBox){o=this._getPrivateListBox();}return o;};
e.prototype._getListBox=function(u){var l=this._getExistingListBox();if(!l){l=this._getPrivateListBox();}if(u){l.setAllowMultiSelect(false);l.setDisplaySecondaryValues(this.getDisplaySecondaryValues());var o=this.getDomRef();if(o){l.setMinWidth(q(o).rect().width+"px");}}return l;};
e.prototype._open=function(i){if(this.mobile){return;}if(i===undefined){i=-1;}if(!this.getEditable()||!this.getEnabled()){return;}if(!this.oPopup){this.oPopup=new P();}this._F4ForOpen=false;var l=this._getListBox(!this.oPopup.isOpen());var p=this.oPopup;this._prepareOpen(l);if(!this._oListBoxDelegate){this._oListBoxDelegate={oCombo:this,onclick:function(o){var g=q(o.target).closest("li").attr("id");if(g){var n=new E("_internalSelect",this.oCombo,{selectedId:g});this.oCombo._handleSelect(n);}}};}l.addDelegate(this._oListBoxDelegate);p.setContent(l);p.setAutoClose(true);p.setAutoCloseAreas([this.getDomRef()]);p.setDurations(0,0);p.setInitialFocusId(this.getId()+'-input');var s=this._rerenderListBox(l);if(s){return;}p.attachOpened(this._handleOpened,this);var f=P.Dock;p.open(i,f.BeginTop,f.BeginBottom,this,null,null,P.CLOSE_ON_SCROLL);q(l.getFocusDomRef()).attr("tabindex","-1");q(this.getDomRef()).attr("aria-expanded",true);};
e.prototype._rerenderListBox=function(l){sap.ui.getCore().applyChanges();return false;};
e.prototype._prepareOpen=function(o){this._bOpening=true;var r=q(this.getInputDomRef()),v=r.val(),n,I=o.getItems(),t,s=q.sap.startsWithIgnoreCase,f=v==="",S=this.getSelectedItemId(),g;var i=0;var h=-1;for(var l=I.length;i<l;i++){g=I[i];if(!g.getEnabled()){continue;}t=""+g.getText();if(f||s(t,v)){if(t==v&&i==this._iClosedUpDownIdx){h=i;n=t;break;}else if(this._iClosedUpDownIdx<0&&t==v&&g.getId()==S){h=i;n=t;break;}else if(h<0){h=i;n=t;}}}if(h>=0){this._iClosedUpDownIdx=h;this._updatePosInSet(r,h+1,(g.getAdditionalText?g.getAdditionalText():""));r.val(n);this._doSelect();var j=new q.Event("sapshow");j.which=K.F4;this._fireLiveChange(j);}var k=o.getItems().length;var m=this.getMaxPopupItems();o.setVisibleItems(m<k?m:-1);o.setSelectedIndex(h);};
e.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);var l=this._getListBox();l.scrollToIndex(this._iClosedUpDownIdx,true);l.attachSelect(this._handleSelect,this);this.oPopup.attachClosed(this._handleClosed,this);if(D.browser.msie){setTimeout(function(){q(this.getInputDomRef()).focus();}.bind(this),0);}if(q(this.getFocusDomRef()).data("sap.InNavArea")){q(this.getFocusDomRef()).data("sap.InNavArea",false);}this._bOpening=false;};
e.prototype._close=function(o){if(this.oPopup){this.oPopup.close(0);}};
e.prototype._handleClosed=function(){this.oPopup.detachClosed(this._handleClosed,this);var l=this._getListBox();l.removeDelegate(this._oListBoxDelegate);l.detachSelect(this._handleSelect,this);q(this.getDomRef()).attr("aria-expanded",false);if(this._cleanupClose){this._cleanupClose(l);}};
e.prototype._handleSelect=function(o){var s=o.getParameter("selectedIndex"),S=o.getParameter("selectedId"),i=o.getParameter("selectedItem");if(!i&&S){i=sap.ui.getCore().byId(S);if(i.getParent()!==this._getListBox(false)){i=null;}s=q.inArray(i,this._getListBox().getItems());}if(i&&i.getEnabled()){var n=i.getText();this._iClosedUpDownIdx=s;this._close();this._updatePosInSet(null,this._getListBox().getSelectedIndex()+1,(i.getAdditionalText?i.getAdditionalText():""));var O=this.getValue();var f=this.getSelectedKey();var N=i.getKey();var g=this.getSelectedItemId();var h=i.getId();this._sTypedChars=n;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;if(O!=n||f!=N||g!=h){this.setValue(n,true);this.setProperty("selectedKey",N,true);this.setProperty("selectedItemId",h,true);this.fireChange({newValue:n,selectedItem:i});}else if(n!=q(this.getInputDomRef()).val()){q(this.getInputDomRef()).val(n);}}this._doSelect();return i;};
e.prototype.getItems=function(){var l=this._getExistingListBox();return l?l.getItems():[];};
e.prototype.insertItem=function(i,I){i=this.validateAggregation("items",i,true);this._getListBox().insertItem(i,I);return this;};
e.prototype.addItem=function(i){i=this.validateAggregation("items",i,true);this._getListBox().addItem(i);return this;};
e.prototype.removeItem=function(v){return this._getListBox().removeItem(v);};
e.prototype.removeAllItems=function(){var l=this._getExistingListBox();return l?l.removeAllItems():[];};
e.prototype.indexOfItem=function(i){return this._getListBox().indexOfItem(i);};
e.prototype.destroyItems=function(){var l=this._getExistingListBox();if(l){this._getListBox().destroyItems();}return this;};
e.prototype.updateItems=function(){this._bNoItemCheck=true;this.updateAggregation("items");if(!this._sHandleItemsChanged){this._sHandleItemsChanged=setTimeout(function(){this._handleItemsChanged(null,true);}.bind(this),0);}};
e.prototype.setListBox=function(l){var o=sap.ui.getCore().byId(this.getListBox());if(o){o.detachEvent("itemsChanged",this._handleItemsChanged,this);o.detachEvent("itemInvalidated",this._handleItemInvalidated,this);if(this._bListBoxDependentSet){this.removeDependent(o);this._bListBoxDependentSet=false;}}if(this._oListBox&&l){this._oListBox.detachEvent("itemsChanged",this._handleItemsChanged,this);this._oListBox.detachEvent("itemInvalidated",this._handleItemInvalidated,this);if(this.getAggregation("myListBox")){this.destroyAggregation("myListBox",true);}else{this._oListBox.destroy();}this._oListBox=null;}this.setAssociation("listBox",l);var f=typeof l==="string"?sap.ui.getCore().byId(l):l;if(f&&f.attachEvent){f.attachEvent("itemsChanged",this._handleItemsChanged,this);f.attachEvent("itemInvalidated",this._handleItemInvalidated,this);}if(f&&!f.getParent()){this.addDependent(f);this._bListBoxDependentSet=true;}if(this.getDomRef()&&f){this.$().attr("aria-owns",this.getId()+"-input "+f.getId());}return this;};
e.prototype._handleItemsChanged=function(o,f){if(f){this._sHandleItemsChanged=null;this._bNoItemCheck=undefined;}if(this._bNoItemCheck){return;}var I=[];if(this._getExistingListBox()){I=this._getListBox().getItems();}var s=this.getSelectedKey();var S=this.getSelectedItemId();var n,N,g,h;var v=this.getValue();var j=-1;var F=false;var k=false;var l=false;this._iClosedUpDownIdx=-1;var B=!!this.getBinding("value");var m=!!this.getBinding("selectedKey");if(B&&m){B=false;}var i=0;var p;for(i=0;i<I.length;i++){p=I[i];if((this._sWantedSelectedKey||this._sWantedSelectedItemId)&&(p.getKey()==this._sWantedSelectedKey||p.getId()==this._sWantedSelectedItemId)&&p.getEnabled()){n=p.getKey();N=p.getId();g=p.getText();h=(p.getAdditionalText?p.getAdditionalText():"");j=i;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;break;}else if(s&&p.getKey()==s&&p.getEnabled()&&!(l&&B)){F=true;n=s;N=p.getId();g=p.getText();h=(p.getAdditionalText?p.getAdditionalText():"");j=i;if(g==v&&N==S&&!this._sWantedSelectedKey&&!this._sWantedSelectedItemId){break;}if(m&&!this._sWantedSelectedKey&&!this._sWantedSelectedItemId){break;}}else if(S&&p.getId()==S&&p.getEnabled()&&!F&&!(l&&B)){k=true;n=p.getKey();N=S;g=p.getText();h=(p.getAdditionalText?p.getAdditionalText():"");j=i;}else if(p.getText()==v&&p.getEnabled()&&!(F&&!B)&&!(k&&!B)&&!l){l=true;n=p.getKey();N=p.getId();g=v;h=(p.getAdditionalText?p.getAdditionalText():"");j=i;if(B&&!this._sWantedSelectedKey&&!this._sWantedSelectedItemId){break;}}}this._iClosedUpDownIdx=j;if(v!=g&&j>=0){this.setProperty("value",g,true);q(this.getInputDomRef()).val(g);}this.setProperty("selectedKey",n,true);this.setProperty("selectedItemId",N,true);var r=this.getDomRef();if(r){q(this.getInputDomRef()).attr("aria-setsize",I.length);if(N){this._updatePosInSet(null,j+1,h);}else{this._updatePosInSet(null,-1,null);}if(this.mobile){var t=this.getDomRef("select");while(t.length>0){t.remove(0);}for(i=0;i<I.length;i++){p=I[i];var O=document.createElement("option");O.text=p.getText();O.id=this.getId()+"-"+p.getId();if(!p.getEnabled()){O.disabled="disabled";}t.add(O,null);}t.selectedIndex=j;}}};
e.prototype._handleItemInvalidated=function(o){if(this._bNoItemCheck){return;}var i=o.getParameter("item");if(i.getId()==this.getSelectedItemId()){if(i.getKey()!=this.getSelectedKey()){this.setProperty("selectedKey",i.getKey(),true);}if(i.getText()!=this.getValue()){T.prototype.setValue.apply(this,[i.getText()]);}}if(!this._sHandleItemsChanged){this._handleItemsChanged(o);}};
e.prototype.onAfterRendering=function(o){T.prototype.onAfterRendering.apply(this,arguments);var l=this.getListBox();if(l){var f=sap.ui.getCore().byId(l);if(f.getDomRef()){f.$().appendTo(sap.ui.getCore().getStaticAreaRef());}}if(this.mobile){var t=this;this.$("select").bind("change",function(){var n=t.$("select").val();var g=t.getItems();var h=true;var O=0;var s=t.getValue();for(var i=0;i<g.length;i++){if(g[i].getText()==n){h=g[i].getEnabled();}if(g[i].getText()==s){O=i;}}if(h){t.setValue(n);t.fireChange({newValue:n,selectedItem:sap.ui.getCore().byId(t.getSelectedItemId())});}else{t.getDomRef("select").selectedIndex=O;}});if(this.getSelectedItemId()){for(var i=0;i<this.getItems().length;i++){var I=this.getItems()[i];if(this.getSelectedItemId()==I.getId()){this.getDomRef("select").selectedIndex=i;break;}}}else{this._addDummyOption(this.getValue());}}};
e._isHotKey=function(o){if(o.altKey||o.ctrlKey||o.metaKey){return true;}var k=o.keyCode||o.which;switch(k){case K.ENTER:case K.SHIFT:case K.TAB:case K.ALT:case K.CONTROL:return true;case K.END:case K.HOME:case K.ARROW_LEFT:case K.ARROW_UP:case K.ARROW_RIGHT:case K.ARROW_DOWN:case K.F1:case K.F2:case K.F3:case K.F4:case K.F5:case K.F6:case K.F7:case K.F8:case K.F9:case K.F10:case K.F11:case K.F12:if(o.type=="keypress"){return o.which===0;}else{return true;}default:return false;}};
e.prototype.setSelectedKey=function(s){if(this.getSelectedKey()==s){return this;}if(!s&&this._isSetEmptySelectedKeyAllowed()){return this;}var I=this.getItems();var n=true;var S;var f;var g;for(var i=0;i<I.length;i++){if(I[i].getKey()==s&&I[i].getEnabled()){var o=I[i];S=o.getId();var v=o.getText();g=(o.getAdditionalText?o.getAdditionalText():"");this.setValue(v,true);this._sTypedChars=v;f=i;n=false;break;}}if(!n){this.setProperty("selectedKey",s,true);this.setProperty("selectedItemId",S,true);var h=this.getDomRef();if(h){this._updatePosInSet(null,f+1,g);if(this.mobile){this._removeDummyOption();this.getDomRef("select").selectedIndex=f;}}this._sWantedSelectedKey=undefined;this._iClosedUpDownIdx=f;}else{this._sWantedSelectedKey=s;this._iClosedUpDownIdx=-1;}this._sWantedSelectedItemId=undefined;return this;};
e.prototype._isSetEmptySelectedKeyAllowed=function(){this.setProperty("selectedKey","",true);this.setProperty("selectedItemId","",true);this.setValue("",true);return true;};
e.prototype.setSelectedItemId=function(s){if(this.getSelectedItemId()==s){return this;}if(!s&&this._isSetEmptySelectedKeyAllowed()){return this;}var I=this.getItems();var n=true;var k;var f;var g;for(var i=0;i<I.length;i++){if(I[i].getId()==s&&I[i].getEnabled()){var S=I[i];k=S.getKey();var v=S.getText();g=(S.getAdditionalText?S.getAdditionalText():"");this.setValue(v,true);this._sTypedChars=v;f=i;n=false;break;}}if(!n){this.setProperty("selectedItemId",s,true);this.setProperty("selectedKey",k,true);var o=this.getDomRef();if(o){this._updatePosInSet(null,f+1,g);if(this.mobile){this._removeDummyOption();this.getDomRef("select").selectedIndex=f;}}this._sWantedSelectedItemId=undefined;this._iClosedUpDownIdx=f;}else{this._sWantedSelectedItemId=s;this._iClosedUpDownIdx=-1;}this._sWantedSelectedKey=undefined;return this;};
e.prototype.setValue=function(v,n){if(!n){var I=this.getItems();var k;var s;var f;var g;this._iClosedUpDownIdx=-1;for(var i=0;i<I.length;i++){if(I[i].getText()==v&&I[i].getEnabled()){var S=I[i];s=S.getId();k=S.getKey();g=(S.getAdditionalText?S.getAdditionalText():"");f=i;this._iClosedUpDownIdx=f;break;}}this.setProperty("selectedKey",k,true);this.setProperty("selectedItemId",s,true);var o=this.getDomRef();if(o){if(s){this._updatePosInSet(null,f+1,g);}else{this._updatePosInSet(null,-1,null);}if(this.mobile){if(!s){this._addDummyOption(v);}else{this._removeDummyOption();this.getDomRef("select").selectedIndex=f;}}}}T.prototype.setValue.apply(this,[v]);this._sTypedChars=this.getValue();this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;return this;};
e.prototype.invalidate=function(o){if(!o||!(o instanceof L)||o!=this._getListBox()){T.prototype.invalidate.apply(this,arguments);}else{if(this.getUIArea()&&o.getDomRef()){this.getUIArea().addInvalidatedControl(o);}}};
e.prototype.clone=function(i){var o=T.prototype.clone.apply(this,arguments),l=this.getAggregation("myListBox"),f;if(l&&!o._oListBox){l.detachEvent("itemsChanged",this._handleItemsChanged,this);l.detachEvent("itemInvalidated",this._handleItemInvalidated,this);f=l.clone(i);f.attachEvent("itemsChanged",o._handleItemsChanged,o);f.attachEvent("itemInvalidated",o._handleItemInvalidated,o);o.setAggregation("myListBox",f,true);o._oListBox=f;l.attachEvent("itemsChanged",this._handleItemsChanged,this);l.attachEvent("itemInvalidated",this._handleItemInvalidated,this);}return o;};
e.prototype._addDummyOption=function(v){var o=this.getDomRef("dummyOption");if(!o){var i=this.getItems();o=document.createElement("option");o.text=v;o.id=this.getId()+"-dummyOption";if(i.length>0){this.getDomRef("select").add(o,document.getElementById(this.getId()+"-"+i[0].getId()));}else{this.getDomRef("select").add(o,null);}}else{o.text=v;}this.getDomRef("select").selectedIndex=0;};
e.prototype._removeDummyOption=function(){var o=this.getDomRef("dummyOption");if(o){this.getDomRef("select").remove(0);}};
e.prototype.getFocusDomRef=function(){if(this.mobile){return this.getDomRef("select")||null;}else{return this.getDomRef("input")||null;}};
e.prototype._updatePosInSet=function(i,I,s){if(!i){i=this.$("input");}if(I>=0){i.attr("aria-posinset",I);if(this.getDisplaySecondaryValues()){this.$("SecVal").text(s);}}else{i.removeAttr("aria-posinset");if(this.getDisplaySecondaryValues()){this.$("SecVal").text("");}}};
e.prototype.getAccessibilityInfo=function(){var i=T.prototype.getAccessibilityInfo.apply(this,arguments);i.role="combobox";i.type=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_COMBO");return i;};
return e;});
sap.ui.predefine('sap/ui/commons/ComboBoxRenderer',['./TextFieldRenderer','sap/ui/core/Renderer','sap/ui/core/library'],function(T,R,c){"use strict";var V=c.ValueState;var C=R.extend(T);
C.renderOuterAttributes=function(r,o){r.addClass("sapUiTfCombo");this.renderComboARIAInfo(r,o);};
C.renderOuterContentBefore=function(r,o){this.renderExpander(r,o);this.renderSelectBox(r,o,'-1');};
C.renderExpander=function(r,o){r.write("<div");r.writeAttributeEscaped('id',o.getId()+'-icon');r.writeAttribute('unselectable','on');if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","presentation");}r.addClass("sapUiTfComboIcon");r.writeClasses();r.write(">&#9660;</div>");};
C.renderSelectBox=function(r,o,t){if(o.mobile){r.write("<select");r.writeAttributeEscaped('id',o.getId()+'-select');r.writeAttribute('tabindex',t);if(!o.getEnabled()||!o.getEditable()){r.writeAttribute('disabled','disabled');}r.write(">");for(var i=0;i<o.getItems().length;i++){var I=o.getItems()[i];r.write("<option");r.writeAttributeEscaped('id',o.getId()+"-"+I.getId());if(!I.getEnabled()){r.writeAttribute("disabled","disabled");}r.write(">");r.writeEscaped(I.getText());r.write("</option>");}r.write("</select>");}};
C.renderOuterContent=function(r,o){if(o.getDisplaySecondaryValues()){r.write("<span id=\""+o.getId()+"-SecVal\" style=\"display: none;\"></span>");}};
C.renderInnerAttributes=function(r,o){if(o.mobile){r.writeAttribute('autocapitalize','off');r.writeAttribute('autocorrect','off');}};
C.renderComboARIAInfo=function(r,o){var l=o.getListBox();if(!l&&o._oListBox){l=o._oListBox.getId();}var p={role:"combobox",owns:o.getId()+"-input "+l};if(!o.getEnabled()){p["disabled"]=true;}r.writeAccessibilityState(null,p);};
C.renderARIAInfo=function(r,o){var p=-1;if(o.getSelectedItemId()){for(var i=0;i<o.getItems().length;i++){var I=o.getItems()[i];if(I.getId()==o.getSelectedItemId()){p=i+1;break;}}}var P={autocomplete:"inline",live:"polite",setsize:o.getItems().length,posinset:(p>=0)?p:undefined};if(o.getValueState()==V.Error){P["invalid"]=true;}if(o.getDisplaySecondaryValues()){P["describedby"]={value:o.getId()+"-SecVal",append:true};}r.writeAccessibilityState(o,P);};
C.setEditable=function(o,e){if(o.mobile){var s=o.$("select");if(e&&o.getEnabled()){s.removeAttr("disabled");}else{s.attr("disabled","disabled");}}T.setEditable.apply(this,arguments);};
C.setEnabled=function(o,e){if(o.mobile){var s=o.$("select");if(e&&o.getEditable()){s.removeAttr("disabled");}else{s.attr("disabled","disabled");}}T.setEnabled.apply(this,arguments);};
return C;},true);
sap.ui.predefine('sap/ui/commons/DatePicker',['sap/ui/thirdparty/jquery','sap/base/Log','./TextField','sap/ui/model/type/Date','sap/ui/core/date/UniversalDate','./library','./DatePickerRenderer','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/Device','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/Popup','sap/ui/dom/containsOrEquals','sap/ui/dom/jquery/cursorPos'],function(q,L,T,a,U,l,D,b,c,d,e,f,P,g){"use strict";var h=P.Dock;var C=c.CalendarType;
var i=T.extend("sap.ui.commons.DatePicker",{metadata:{library:"sap.ui.commons",properties:{locale:{type:"string",group:"Misc",defaultValue:null},yyyymmdd:{type:"string",group:"Misc",defaultValue:null}}}});
i.prototype.init=function(){T.prototype.init.apply(this,arguments);this._oFormatYyyymmdd=b.getInstance({pattern:"yyyyMMdd",strictParsing:true,calendarType:C.Gregorian});if(!d.system.desktop){this._bMobile=true;this._oFormatMobile=b.getInstance({pattern:"yyyy-MM-dd",strictParsing:true,calendarType:C.Gregorian});}this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,99);};
i.prototype.exit=function(){this._oDate=undefined;this._oLocale=undefined;if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}};
i.prototype.onAfterRendering=function(){T.prototype.onAfterRendering.apply(this,arguments);if(this._bMobile){if(this._oDate){var I=q(this.getInputDomRef());var O=this._oFormatMobile.format(this._oDate);I.val(O);}}};
i.prototype.invalidate=function(O){if(!O||O!=this._oCalendar){T.prototype.invalidate.apply(this,arguments);}};
i.prototype.onsapshow=function(E){var t=this;n(t);E.preventDefault();};
i.prototype.onsaphide=i.prototype.onsapshow;
i.prototype.onsappageup=function(E){var t=this;s(t,1,"day");E.preventDefault();};
i.prototype.onsappageupmodifiers=function(E){var t=this;if(!E.ctrlKey&&E.shiftKey){s(t,1,"month");}else{s(t,1,"year");}E.preventDefault();};
i.prototype.onsappagedown=function(E){var t=this;s(t,-1,"day");E.preventDefault();};
i.prototype.onsappagedownmodifiers=function(E){var t=this;if(!E.ctrlKey&&E.shiftKey){s(t,-1,"month");}else{s(t,-1,"year");}E.preventDefault();};
i.prototype.onkeypress=function(E){if(E.charCode){var t=this;var F=_(t);var u=String.fromCharCode(E.charCode);if(u&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(u)<0){E.preventDefault();}}};
i.prototype.onclick=function(E){if(q(E.target).hasClass("sapUiTfDateIcon")&&!this._bMobile){var t=this;n(t);}};
i.prototype.onsapfocusleave=function(E){if(this._oCalendar&&E.relatedControlId&&(g(this._oCalendar.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())||this.getId()==E.relatedControlId)){return;}T.prototype.onsapfocusleave.apply(this,arguments);};
i.prototype.setValue=function(v){var O=this.getValue();if(v==O){return this;}var t=this;k(t);this.setProperty("value",v,true);this._bValueSet=true;if(v){this._oDate=this._parseValue(v);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;L.warning("Value can not be converted to a valid date",this);}}else{this._oDate=undefined;}var y="";if(this._oDate){y=this._oFormatYyyymmdd.format(this._oDate);}this.setProperty("yyyymmdd",y,true);if(this.getDomRef()){var u="";var I=q(this.getInputDomRef());if(this._bMobile&&this._oDate){u=this._oFormatMobile.format(this._oDate);}else{u=v;}I.val(u);}return this;};
i.prototype.setYyyymmdd=function(y){var O=this.getYyyymmdd();if(y==O){return this;}this.setProperty("yyyymmdd",y,true);this._bValueSet=false;var v="";if(y){this._oDate=this._oFormatYyyymmdd.parse(y);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;L.warning("Value can not be converted to a valid date",this);}}else{this._oDate=undefined;}if(this._oDate){v=this._formatValue(this._oDate);}this.setProperty("value",v,true);if(this.getDomRef()){var t="";var I=q(this.getInputDomRef());if(this._bMobile&&this._oDate){t=this._oFormatMobile.format(this._oDate);}else{t=v;}I.val(t);}return this;};
i.prototype.setLocale=function(t){var O=this.getLocale();if(t==O){return this;}this.setProperty("locale",t,true);var u=this;k(u);this._oLocale=new e(t);this._sUsedPattern=undefined;var v="";if(this._bValueSet){v=this.getValue();if(v){this._oDate=this._parseValue(v);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;L.warning("Value can not be converted to a valid date",this);}}else{this._oDate=undefined;}var y="";if(this._oDate){y=this._oFormatYyyymmdd.format(this._oDate);}this.setProperty("yyyymmdd",y,true);}else{if(this._oDate){v=this._formatValue(this._oDate);}this.setProperty("value",v,true);}if(this.getDomRef()){var w="";var I=q(this.getInputDomRef());if(this._bMobile&&this._oDate){w=this._oFormatMobile.format(this._oDate);}else{w=v;}I.val(w);}return this;};
i.prototype.oninput=function(E){if(this._bMobile){var I=this.getInputDomRef();var N=I&&I.value;if(N){var t=this._oFormatMobile.parse(N);}if(!N||t){this._checkChange(E);}}else{T.prototype.oninput.apply(this,arguments);}};
i.prototype._checkChange=function(E){var I=this.getInputDomRef();var N=I&&I.value;if(this._bMobile&&N!=""){this._oDate=this._oFormatMobile.parse(N);N=this._formatValue(this._oDate);}if(this.getEditable()&&this.getEnabled()&&N!=this.getValue()){var w=false;if(N!=""){if(!this._bMobile){this._oDate=this._parseValue(N);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;w=true;}else{N=this._formatValue(this._oDate);I.value=N;if(this._oPopup&&this._oPopup.isOpen()){this._oCalendar.focusDate(this._oDate);if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=this._oDate.getTime()){this._oDateRange.setStartDate(new Date(this._oDate.getTime()));}}}}}else{this._oDate=undefined;}this.setProperty("value",N,true);this._bValueSet=false;if(!w){var y="";if(this._oDate){y=this._oFormatYyyymmdd.format(this._oDate);}this.setProperty("yyyymmdd",y,true);}this.fireChange(w);}else if(this.getEditable()&&this.getEnabled()&&N==this.getYyyymmdd()){I.value=this.getValue();}};
i.prototype.fireChange=function(I){this.fireEvent("change",{newValue:this.getValue(),newYyyymmdd:this.getYyyymmdd(),invalidValue:I});return this;};
i.prototype._parseValue=function(v){var t=this;var F=_(t);var u=F.parse(v);return u;};
i.prototype._formatValue=function(t){var u=this;var F=_(u);var v=F.format(t);return v;};
i.prototype.getAccessibilityInfo=function(){var I=T.prototype.getAccessibilityInfo.apply(this,arguments);I.type=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_DATEINPUT");return I;};
function _(t){var u="";var R=false;var B=t.getBinding("value");var v;var w;if(B&&B.oType&&(B.oType instanceof a)){u=B.oType.getOutputPattern();R=!!B.oType.oOutputFormat.oFormatOptions.relative;w=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(!u){v=j(t);var x=f.getInstance(v);u=x.getDatePattern("medium");w=sap.ui.getCore().getConfiguration().getCalendarType();}if(u!=t._sUsedPattern||w!=t._sUsedCalendarType){t._sUsedPattern=u;t._sUsedCalendarType=w;if(u=="short"||u=="medium"||u=="long"){t._oFormat=b.getInstance({style:u,strictParsing:true,relative:R,calendarType:w},v);}else{t._oFormat=b.getInstance({pattern:u,strictParsing:true,relative:R,calendarType:w},v);}}return t._oFormat;}
function j(t){var u=t.getLocale();var v;if(u){v=t._oLocale;}else{v=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}return v;}
function k(t){var B=t.getBinding("value");var u=t.getLocale();if(B&&B.oType&&(B.oType instanceof a)&&u){L.warning("DatePicker "+t.getId()+": Using a locale and Databinding at the same time is not supported");t._bIgnoreLocale=true;}}
function m(t){if(!t._oPopup){t._oPopup=new P();t._oPopup.setAutoClose(true);t._oPopup.setDurations(0,0);t._oPopup.attachClosed(r,t);}if(!t._oCalendar){sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.require("sap/ui/unified/library");t._oCalendar=new sap.ui.unified.Calendar(t.getId()+"-cal");t._oDateRange=new sap.ui.unified.DateRange();t._oCalendar.addSelectedDate(t._oDateRange);t._oCalendar.attachSelect(o,t);t._oCalendar.attachCancel(p,t);t._oPopup.setContent(t._oCalendar);t._oCalendar.addStyleClass("sapUiSizeCompact");t._oCalendar.setPopupMode(true);t._oCalendar.setParent(t,undefined,true);}var v="";if(t._oDate){v=t._formatValue(t._oDate);}if(v!=t.$("input").val()){t._checkChange();}var u;var B=t.getBinding("value");if(B&&B.oType&&(B.oType instanceof a)){u=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(u){t._oCalendar.setPrimaryCalendarType(u);}var w=t._oDate;if(w){t._oCalendar.focusDate(w);if(!t._oDateRange.getStartDate()||t._oDateRange.getStartDate().getTime()!=w.getTime()){t._oDateRange.setStartDate(new Date(w.getTime()));}}else{t._oCalendar.focusDate(new Date());if(t._oDateRange.getStartDate()){t._oDateRange.setStartDate(undefined);}}if(!t._bIgnoreLocale){t._oCalendar.setLocale(t.getLocale());}t._oPopup.setAutoCloseAreas([t.getDomRef()]);t._oPopup.open(0,h.BeginTop,h.BeginBottom,t,null,null,true);}
function n(t){if(t.getEditable()&&t.getEnabled()){if(!t._oPopup||!t._oPopup.isOpen()){m(t);}else{t._oPopup.close();t.focus();}}}
function o(E){var S=this._oCalendar.getSelectedDates();var O="";if(S.length>0){this._oDate=S[0].getStartDate();O=this._formatValue(this._oDate);}this._oPopup.close();this.focus();var N=this._formatValue(this._oDate);this.setProperty("value",N,true);this._bValueSet=false;var y=this._oFormatYyyymmdd.format(this._oDate);this.setProperty("yyyymmdd",y,true);var I=this.$("input");if(I.val()!==O){I.val(O);this._curpos=O.length;I.cursorPos(this._curpos);}this.fireChange();}
function p(E){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();this.focus();}}
function r(E){if(!g(this.getDomRef(),document.activeElement)&&this.getRenderer().onblur){this.getRenderer().onblur(this);}}
function s(t,N,u){var O=t._oDate;if(O&&t.getEditable()&&t.getEnabled()){var B=t.getBinding("value");var v;if(B&&B.oType&&(B.oType instanceof a)){v=B.oType.oOutputFormat.oFormatOptions.calendarType;}else{v=sap.ui.getCore().getConfiguration().getCalendarType();}var w=U.getInstance(new Date(O.getTime()),v);O=U.getInstance(new Date(O.getTime()),v);var I=q(t.getInputDomRef());var x=I.cursorPos();switch(u){case"day":w.setDate(w.getDate()+N);break;case"month":w.setMonth(w.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(w.getMonth()!=M){w.setDate(w.getDate()-1);}break;case"year":w.setFullYear(w.getFullYear()+N);while(w.getMonth()!=O.getMonth()){w.setDate(w.getDate()-1);}break;default:break;}if(w.getTime()<t._oMinDate.getTime()){w=new U(t._oMinDate.getTime());}else if(w.getTime()>t._oMaxDate.getTime()){w=new U(t._oMaxDate.getTime());}t._oDate=new Date(w.getTime());var y=t._formatValue(t._oDate);I.val(y);I.cursorPos(x);}}
return i;});
sap.ui.predefine('sap/ui/commons/DatePickerRenderer',['./TextFieldRenderer','sap/ui/core/Renderer','sap/ui/core/ValueStateSupport','sap/ui/core/library'],function(T,R,V,c){"use strict";var a=c.ValueState;var D=R.extend(T);
D.renderOuterAttributes=function(r,C){r.addClass("sapUiTfCombo");this.renderDatePickerARIAInfo(r,C);};
D.renderOuterContentBefore=function(r,C){r.write("<div");r.writeAttribute('id',C.getId()+'-icon');r.writeAttribute('tabindex','-1');r.addClass("sapUiTfDateIcon");r.writeClasses();r.write("></div>");var b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var t=b.getText("DATEPICKER_DATE_TYPE");var s=V.enrichTooltip(C,C.getTooltip_AsString());if(s){t=t+". "+s;}r.write('<span id="'+C.getId()+'-Descr" style="visibility: hidden; display: none;">');r.writeEscaped(t);r.write('</span>');};
D.renderInnerAttributes=function(r,d){if(d._bMobile){r.writeAttribute('type','date');r.addStyle('position','absolute');}};
D.renderDatePickerARIAInfo=function(r,C){};
D.renderARIAInfo=function(r,d){var p={role:d.getAccessibleRole().toLowerCase(),multiline:false,autocomplete:"none",haspopup:true,describedby:{value:d.getId()+"-Descr",append:true}};if(d.getValueState()==a.Error){p["invalid"]=true;}r.writeAccessibilityState(d,p);};
D.convertPlaceholder=function(d){var p=d.getPlaceholder();if(p.length==8&&!isNaN(p)){var o=d._oFormatYyyymmdd.parse(p);if(o){p=d._formatValue(o);}}return p;};
return D;},true);
sap.ui.predefine('sap/ui/commons/Dialog',['sap/ui/thirdparty/jquery','sap/base/Log','sap/ui/dom/containsOrEquals','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/RenderManager','./DialogRenderer','sap/ui/core/library','sap/ui/core/ResizeHandler',"sap/ui/dom/jquery/rect",'sap/ui/dom/jquery/control','sap/ui/dom/jquery/Selectors'],function(q,L,c,l,C,P,R,D,a,b){"use strict";var O=a.OpenState;var A=a.AccessibleRole;var B=l.enums.BorderDesign;
var d=C.extend("sap.ui.commons.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},scrollLeft:{type:"int",group:"Behavior",defaultValue:0},scrollTop:{type:"int",group:"Behavior",defaultValue:0},title:{type:"string",group:"Misc",defaultValue:''},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},showCloseButton:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentBorderDesign:{type:"sap.ui.commons.enums.BorderDesign",group:"Appearance",defaultValue:B.None},modal:{type:"boolean",group:"Misc",defaultValue:false},accessibleRole:{type:"sap.ui.core.AccessibleRole",group:"Accessibility",defaultValue:A.Dialog},keepInWindow:{type:"boolean",group:"Behavior",defaultValue:false},autoClose:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{buttons:{type:"sap.ui.core.Control",multiple:true,singularName:"button"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{defaultButton:{type:"sap.ui.commons.Button",multiple:false},initialFocus:{type:"sap.ui.core.Control",multiple:false}},events:{closed:{parameters:{width:{type:"int"},height:{type:"int"},top:{type:"int"},left:{type:"int"}}}}}});
d.prototype.init=function(){this.oPopup=new P(this,true,true);this._minWidth=64;this._minHeight=48;this.allowTextSelection(false);this._mParameters={};this._mParameters.that=this;this._mParameters.firstFocusable=this.getId()+"-fhfe";this._mParameters.lastFocusable=this.getId()+"-fhee";this._fnOnResizeRecenter=q.proxy(this._onResize,this);};
d.prototype.setInitialFocus=function(i){if(i&&typeof i!="string"){i=i.getId();}this.oPopup.setInitialFocusId(i);this.setAssociation("initialFocus",i,true);return this;};
d.prototype.onAfterRendering=function(){var $=this.$("cont");var _=this.getMinSize();this._minWidth=_.width;this._minHeight=_.height;if(!this._isSizeSet(this.getWidth())&&!this._isSizeSet(this.getMaxWidth())){$.children().each(function(i,h){if(q.trim(this.style.width)=="100%"){this.style.width="auto";}});}if(!this._isSizeSet(this.getHeight())&&this._isSizeSet(this.getMinHeight())){var f=this.getDomRef("footer");var e=f.offsetTop+f.offsetHeight;var g=this.getDomRef().offsetHeight;if(e<g){this.$().removeClass("sapUiDlgFlexHeight");}}};
d.prototype.onclick=function(e){var s=this.getId()+"-close";if(e.target.id===s){this.close();e.preventDefault();}return false;};
d.prototype.open=function(){if(!this.oPopup){L.fatal("This dialog instance has been destroyed already");}else if(!this._bOpen){this._oPreviousFocus=P.getCurrentFocusInfo();this.oPopup.attachEvent("opened",this.handleOpened,this);this.oPopup.attachEvent("closed",this.handleClosed,this);this.oPopup.setModal(this.getModal());this.oPopup.setAutoClose(this.getAutoClose());this.oPopup.open(400);this._onResize();this._bOpen=true;this._registerContentResizeHandler();}};
d.prototype.onThemeChanged=function(){this.invalidate();};
d.prototype._handleOpened=function(){this.$().show();var i=this.getInitialFocus();var t;this._bInitialFocusSet=true;if(i){sap.ui.getCore().byId(i).focus();return;}i=this.getDefaultButton();t=q(":sapTabbable",this.$("cont"));if(i){sap.ui.getCore().byId(i).focus();}else if(this.getButtons().length){this.getButtons()[0].focus();}else if(this.getContent().length&&t.length){t[0].focus();}else{var f=document.getElementById(this._mParameters.firstFocusable);if(f){f.focus();}}};
d.prototype.handleOpened=function(){this.oPopup.detachEvent("opened",this.handleOpened,this);this._handleOpened();};
d.prototype.close=function(){if(!this._bOpen){return;}var r=this.$().rect();this._bOpen=false;this._bInitialFocusSet=false;if(this.oPopup.isOpen()){this.oPopup.close(400);}setTimeout(function(){this.restorePreviousFocus();}.bind(this),400);q.each(r,function(k,v){r[k]=parseInt(v);});this._oRect=r;};
d.prototype.handleClosed=function(){this.oPopup.detachEvent("closed",this.handleClosed,this);this._deregisterContentResizeHandler();this.fireClosed(this._oRect);this.close();if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}};
d.prototype.restorePreviousFocus=function(){P.applyFocusInfo(this._oPreviousFocus);};
d.prototype.setTitle=function(t){this.setProperty("title",t,true);this.$("lbl").text(t);return this;};
d.prototype.exit=function(){var w=this.isOpen();this.close();this.oPopup.detachEvent("opened",this.handleOpened,this);this.oPopup.detachEvent("closed",this.handleClosed,this);this._deregisterContentResizeHandler();this.oPopup.destroy();if(w){this.fireClosed(this._oRect);}this.oPopup=null;clearTimeout(this._sDelayedCall);this._sDelayedCall=null;delete this._mParameters;this._fnOnResizeRecenter=null;};
d.prototype._isSizeSet=function(s){return!!(s&&s!=="auto"&&s!=="inherit");};
d.prototype.onsapescape=function(e){this.close();e.preventDefault();e.stopPropagation();};
d.prototype.onsapenter=function(e){var f,i=this.getDefaultButton();if(i&&(f=sap.ui.getCore().byId(i))&&q.contains(this.getDomRef(),f.getDomRef())){if(f instanceof sap.ui.commons.Button){f.onclick(e);}}e.preventDefault();e.stopPropagation();};
d.prototype.onfocusin=function(e){this.sLastRelevantNavigation=null;if(!this._bInitialFocusSet){return;}this._mParameters.event=e;this._mParameters.$FocusablesContent=q(":sapTabbable",this.$("cont"));this._mParameters.$FocusablesFooter=q(":sapTabbable",this.$("footer"));this.oPopup.focusTabChain(this._mParameters);};
d.prototype.restoreFocus=function(){if(this.oRestoreFocusInfo&&this.oPopup.bOpen){var o=sap.ui.getCore().byId(this.oRestoreFocusInfo.sFocusId);if(o){o.applyFocusInfo(this.oRestoreFocusInfo.oFocusInfo);}}};
d.prototype.onselectstart=function(e){if(!c(this.getDomRef("cont"),e.target)){e.preventDefault();e.stopPropagation();}};
d.prototype.getMinSize=function(){var e=36;var $=this.$();var f=this.$("hdr");var g=this.$("footer");var F=g.children("DIV").get(0);var w=F?F.offsetWidth:0;var h=g.css('display')!=='none';var i=0;var j;var k;i+=g.outerWidth(false)-g.width();i+=$.outerWidth(false)-$.width();if(i<=20){i=20;}w+=i;if(w<100){w=100;}j=f.outerHeight(false);k=g.outerHeight(false);return{width:w,height:j+k+(h?e:0)};};
d.prototype.forceInvalidate=C.prototype.invalidate;
d.prototype.invalidate=function(o){if(this.oPopup&&(this.oPopup.eOpenState!=="CLOSING"||this.isOpen())){this.forceInvalidate(o);}};
d.prototype.isOpen=function(){return this.oPopup.isOpen();};
d.prototype.getOpenState=function(){return this.oPopup.getOpenState();};
d.prototype.getEnabled=function(){var e=this.getOpenState();return e===O.OPENING||e===O.OPEN;};
d.prototype.ondragstart=function(e){if(this.sDragMode=="resize"||this.sDragMode=="move"){e.preventDefault();e.stopPropagation();}};
d.prototype.onmousedown=function(e){var s=e.target,i=this.getId();this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();var o=this.getDomRef();if(c(this.getDomRef("hdr"),s)){if(s.id!=(i+"-close")){this.sDragMode="move";this._RootWidth=o.offsetWidth;this._RootHeight=o.offsetHeight;}}else if(s.id==i+"-grip"){this.sDragMode="resize";var w=o.offsetWidth+"px";var h=o.offsetHeight+"px";o.style.width=w;o.style.height=h;q(o).removeClass("sapUiDlgFlexHeight sapUiDlgFlexWidth");this.setProperty("width",w,true);this.setProperty("height",h,true);}if(!this.sDragMode){return;}var f=document.activeElement;if(f&&f.id){var g=q(f).control(0);if(g){this.oRestoreFocusInfo={sFocusId:g.getId(),oFocusInfo:g.getFocusInfo()};}}this.startDragX=e.screenX;this.startDragY=e.screenY;this.originalRectangle=this.$().rect();q(window.document).on("selectstart",q.proxy(this.ondragstart,this));q(window.document).on("mousemove",q.proxy(this.handleMove,this));q(window.document).on("mouseup",q.proxy(this.handleMouseUp,this));var j=this._findSameDomainParentWinDoc();if(j){q(j).on("selectstart",q.proxy(this.ondragstart,this));q(j).on("mousemove",q.proxy(this.handleMove,this));q(j).on("mouseup",q.proxy(this.handleMouseUp,this));}};
d.prototype._findSameDomainParentWinDoc=function(){var o=null;try{var w=window;while(w.parent&&(w.parent!=w)){if(w.parent.document){o=w.parent.document;w=w.parent;}}}catch(e){}return o;};
d.prototype.handleMove=function(e){if(!this.sDragMode){return;}e=e||window.event;this._deregisterContentResizeHandler();if(this.sDragMode=="resize"){var f=e.screenX-this.startDragX||0;var g=e.screenY-this.startDragY||0;var w=(this._bRtlMode?this.originalRectangle.width-f:this.originalRectangle.width+f)||0;var h=this.originalRectangle.height+g||0;w=Math.max(w,this._minWidth);h=Math.max(h,this._minHeight);var o=this.getDomRef();o.style.width=w+"px";o.style.height=h+"px";w=o.offsetWidth;h=o.offsetHeight;this.setProperty("width",w+"px",true);this.setProperty("height",h+"px",true);}else if(this.sDragMode=="move"){var i=this.originalRectangle.left+e.screenX-this.startDragX;var t=this.originalRectangle.top+e.screenY-this.startDragY;t=Math.max(t,window.pageYOffset);if(this._bRtlMode||this._keepInWindow()){i=Math.min(i,document.documentElement.clientWidth+window.pageXOffset-this._RootWidth);}if(!this._bRtlMode||this._keepInWindow()){i=Math.max(i,0);}if(this._keepInWindow()){t=Math.min(t,document.documentElement.clientHeight+window.pageYOffset-this._RootHeight);}this.oPopup.setPosition(P.Dock.LeftTop,{left:i,top:t});}e.cancelBubble=true;this._registerContentResizeHandler();return false;};
d.prototype._keepInWindow=function(){return this.getKeepInWindow()||this.getModal();};
d.prototype.handleMouseUp=function(e){if(this.sDragMode===null){return;}q(window.document).off("selectstart",this.ondragstart);q(window.document).off("mousemove",this.handleMove);q(window.document).off("mouseup",this.handleMouseUp);var o=this._findSameDomainParentWinDoc();if(o){q(o).off("selectstart",this.ondragstart);q(o).off("mousemove",this.handleMove);q(o).off("mouseup",this.handleMouseUp);}this.restoreFocus();this.sDragMode=null;};
d.setAutoClose=function(e){this.oPopup.setAutoClose(e);};
d.getAutoClose=function(){this.oPopup.getAutoClose();};
d.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){b.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};
d.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=b.register(this.getDomRef("cont"),this._fnOnResizeRecenter);}};
d.prototype._onResize=function(){var e=P.Dock;if(this.oPopup){this.oPopup.setPosition(e.CenterCenter,e.CenterCenter,window);}};
return d;});
sap.ui.predefine('sap/ui/commons/DialogRenderer',[],function(){"use strict";var D={};
D.render=function(r,c){var h=c._isSizeSet(c.getHeight());var w=c._isSizeSet(c.getWidth());var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");c.getScrollTop();c.getScrollLeft();var b=c.getButtons();var B=b.length;r.write("<div");r.writeControlData(c);r.addClass("sapUiDlg");if(c.getModal()){r.addClass("sapUiDlgModal");}r.addClass("sapUiDlgContentBorderDesign"+c.getContentBorderDesign());r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.addStyle("min-width",c.getMinWidth());r.addStyle("min-height",c.getMinHeight());r.addStyle("max-width",c.getMaxWidth());r.addStyle("max-height",c.getMaxHeight());r.addStyle("display","none");if(!h){r.addClass("sapUiDlgFlexHeight");}if(!w){r.addClass("sapUiDlgFlexWidth");}if(B==0){r.addClass("sapUiDlgNoButtons");}if(!c.getApplyContentPadding()){r.addClass("sapUiDlgNoPad");}r.writeClasses();r.writeStyles();r.writeAttribute("aria-labelledby",c.getId()+"-lbl "+c.getId()+"-acc");r.writeAttribute("role",c.getAccessibleRole().toLowerCase());r.writeAttribute("tabindex","-1");r.write("><span style='display:none;' id='",c.getId(),"-acc'>",a.getText("DIALOG_CLOSE_HELP"),"</span>");r.write("<span id='"+c.getId()+"-fhfe' tabindex='0'></span><div id='"+c.getId()+"-hdr' class='sapUiDlgHdr'>");r.write("<span class='sapUiDlgHdrLeft' id='"+c.getId()+"-hdrL'>");var t=c.getTitle();r.write("<span id='"+c.getId()+"-lbl' class='sapUiDlgLabel'");r.writeAttribute("role","heading");r.writeAttribute("aria-level","1");if(t){r.writeAttributeEscaped("title",t);}r.write(">");if(!t){r.write("&nbsp;");}else{r.writeEscaped(t);}r.write("</span></span>");r.write("<span id='",c.getId(),"-hdrR' class='sapUiDlgHdrBtns'>");if(c.getShowCloseButton()){r.write("<a id='",c.getId(),"-close' class='sapUiDlgCloseBtn' href='#'");r.write(" tabindex='-1'");r.writeAttribute("role","button");r.writeAttributeEscaped("aria-label",a.getText("DIALOG_CLOSE_HELP"));r.writeAttributeEscaped("title",a.getText("DIALOG_CLOSE_TEXT"));r.write("></a>");}r.write("</span></div>");r.write('<div class="sapUiDlgHdrSep"></div>');r.write("<div class='sapUiDlgCont' id='",c.getId(),"-cont' tabindex=\"-1\">");var C=c.getContent();for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");if(B>0){r.write('<div class="sapUiDlgFooterSep"></div>');}r.write("<div id='");r.write(c.getId());r.write("-footer' class='sapUiDlgFooter'>");r.write("<div class='sapUiDlgBtns'>");for(var i=0;i<B;i++){r.renderControl(b[i]);}r.write("</div><div class='sapUiDlgWave'></div></div>");if(c.getResizable()){r.write("<span id='");r.write(c.getId());r.write("-grip' class='sapUiDlgGrip'>&#916;</span>");}r.write("<span id='"+c.getId()+"-fhee' tabindex='0'></span></div>");};
return D;},true);
sap.ui.predefine('sap/ui/commons/DropdownBox',['sap/ui/thirdparty/jquery','sap/base/Log','./ComboBox','./library','sap/ui/core/History','sap/ui/core/SeparatorItem','./DropdownBoxRenderer','sap/ui/Device','./TextField','sap/ui/core/ListItem','sap/ui/dom/containsOrEquals','sap/ui/events/jquery/EventExtension','sap/ui/events/KeyCodes','sap/ui/dom/jquery/cursorPos','sap/ui/dom/jquery/selectText'],function(q,L,C,a,H,S,D,b,T,c,d,E,K){"use strict";
var e=C.extend("sap.ui.commons.DropdownBox",{metadata:{library:"sap.ui.commons",properties:{searchHelpEnabled:{type:"boolean",group:"Behavior",defaultValue:false},searchHelpText:{type:"string",group:"Appearance",defaultValue:null},searchHelpAdditionalText:{type:"string",group:"Appearance",defaultValue:null},searchHelpIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},maxHistoryItems:{type:"int",group:"Behavior",defaultValue:0}},events:{searchHelp:{parameters:{value:{type:"string"}}}}}});
e.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oValueBeforePaste=null;this._oValueBeforeOpen=null;this.__aItems=null;this._iCursorPosBeforeBackspace=null;this._searchHelpItem=null;this._iItemsForHistory=10;this._oHistory=new H(this.getId());};
e.prototype.exit=function(){var I=this.getId()+"-h-";if(this._searchHelpItem){this._searchHelpItem[0].destroy();this._searchHelpItem[1].destroy();this._searchHelpItem=null;}C.prototype.exit.apply(this,arguments);function r(f){var o=sap.ui.getCore().byId(f);if(o){o.destroy();}}for(var i=0;i<this.getMaxHistoryItems();i++){r(I+i);}if(this.__oSeparator){this.__oSeparator.destroy();this.__oSeparator=null;}this._oHistory=null;this.__aItems=null;this._sWantedValue=undefined;};
e.prototype.onAfterRendering=function(o){C.prototype.onAfterRendering.apply(this,arguments);if(!this._sHandleItemsChanged){this.checkValueInItems();}};
e.prototype.getItems=function(){if(this.oPopup&&this.oPopup.isOpen()){return this.__aItems;}else{return C.prototype.getItems.apply(this,arguments);}};
e.prototype.insertItem=function(i,I){if(this.oPopup&&this.oPopup.isOpen()){this.__aItems.splice(I,0,i);if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().insertItem(i,I);}if(!this._bNoItemCheck){var r=q(this.getInputDomRef());var f=r.cursorPos();this._doTypeAhead(r.val().substr(0,f),"");}return this;}else{return C.prototype.insertItem.apply(this,arguments);}};
e.prototype.addItem=function(i){if(this.oPopup&&this.oPopup.isOpen()){this.__aItems.push(i);if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().addItem(i);}if(!this._bNoItemCheck){var r=q(this.getInputDomRef());var f=r.cursorPos();this._doTypeAhead(r.val().substr(0,f),"");}return this;}else{return C.prototype.addItem.apply(this,arguments);}};
e.prototype.removeItem=function(v){if(this.oPopup&&this.oPopup.isOpen()){var I=null;var o=v;if(typeof(v)=="string"){v=sap.ui.getCore().byId(v);}if(typeof(v)=="object"){for(var i=0;i<this.__aItems.length;i++){if(this.__aItems[i]==v){v=i;break;}}}if(typeof(v)=="number"){if(v<0||v>=this.__aItems.length){L.warning("Element.removeAggregation called with invalid index: Items, "+v);}else{I=this.__aItems[v];this.__aItems.splice(v,1);}}if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().removeItem(o);}if(!this._bNoItemCheck){var r=q(this.getInputDomRef());var f=r.cursorPos();this._doTypeAhead(r.val().substr(0,f),"");}return I;}else{return C.prototype.removeItem.apply(this,arguments);}};
e.prototype.removeAllItems=function(){if(this.oPopup&&this.oPopup.isOpen()){var i=this.__aItems;if(!i){return[];}C.prototype.removeAllItems.apply(this,arguments);this.__aItems=[];return i;}else{return C.prototype.removeAllItems.apply(this,arguments);}};
e.prototype.indexOfItem=function(I){if(this.oPopup&&this.oPopup.isOpen()){if(this.__aItems){if(this.__aItems.length==undefined){return-2;}for(var i=0;i<this.__aItems.length;i++){if(this.__aItems[i]==I){return i;}}}return-1;}else{return C.prototype.indexOfItem.apply(this,arguments);}};
e.prototype.destroyItems=function(){if(this.oPopup&&this.oPopup.isOpen()){if(!this.__aItems){return this;}this._getListBox().removeAllItems();for(var i=0;i<this.__aItems.length;i++){if(this.__aItems[i]){this.__aItems[i].destroy();}}this.__aItems=[];return this;}else{return C.prototype.destroyItems.apply(this,arguments);}};
e.prototype.updateItems=function(){C.prototype.updateItems.apply(this,arguments);if(this.oPopup&&this.oPopup.isOpen()){var r=q(this.getInputDomRef());var i=r.cursorPos();this._doTypeAhead(r.val().substr(0,i),"");}};
e.prototype._handleItemsChanged=function(o,f){if(f){this._sHandleItemsChanged=null;this._bNoItemCheck=undefined;}if(this._bNoItemCheck){return;}if(this.__aItems&&(!this.oPopup||!this.oPopup.isOpen())){throw new Error("DropdownBox "+this.getId()+" : this.__aItems is not empty!");}if(this.getListBox()&&this.oPopup&&this.oPopup.isOpen()){if(this.__aItems.length>this._iItemsForHistory||this._searchHelpItem){var I;var i=0;switch(o.getParameter("event")){case"destroyItems":for(i=0;i<this.__aItems.length;i++){I=this.__aItems[i];if(!I.bIsDestroyed){I.destroy();}}this.__aItems=[];if(this.getSearchHelpEnabled()){this._searchHelpItem=null;this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),this.getSearchHelpIcon());}break;case"removeAllItems":this.__aItems=[];break;case"removeItem":I=o.getParameter("item");for(i=0;i<this.__aItems.length;i++){if(this.__aItems[i]==I){this.__aItems.splice(i,1);break;}}if(this.__aItems.length<=this._iItemsForHistory){this._getListBox().setItems(this.__aItems,false,true);}break;case"insertItem":this.__aItems.splice(o.getParameter("index"),0,o.getParameter("item"));break;case"addItem":this.__aItems.push(o.getParameter("item"));break;case"setItems":this.__aItems=o.getParameter("items");break;case"updateItems":for(i=0;i<this.__aItems.length;i++){I=this.__aItems[i];if(!I.bIsDestroyed){I.destroy();}}if(this.getSearchHelpEnabled()){this._searchHelpItem=null;this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),this.getSearchHelpIcon());}this.__aItems=this._getListBox().getItems();break;default:break;}}else{this.__aItems=this._getListBox().getItems();}var r=q(this.getInputDomRef());var g=r.cursorPos();this._doTypeAhead(r.val().substr(0,g),"");}C.prototype._handleItemsChanged.apply(this,arguments);this.checkValueInItems();};
e.prototype.onclick=function(o){if(!this.mobile&&this.getEnabled&&this.getEnabled()&&this.getEditable()){if(this.oPopup&&this.oPopup.isOpen()){this._close();this._doSelect();}else if(!this._F4ForClose){this._open();}this.focus();}this._F4ForClose=false;};
e.prototype.onmousedown=function(o){if(!this.getEnabled()||!this.getEditable()){return;}if(this.oPopup&&this.oPopup.isOpen()){this._F4ForClose=true;}else{this._F4ForOpen=true;}C.prototype.onmousedown.apply(this,arguments);};
e.prototype.onsapshow=function(o){if(this.mobile){return;}if(!this.getEnabled()||!this.getEditable()){o.preventDefault();o.stopImmediatePropagation();return;}if(o.which===K.F4&&this._searchHelpItem){this._close();this.fireSearchHelp({value:q(this.getInputDomRef()).val()});o.preventDefault();o.stopImmediatePropagation();return;}if(this.oPopup&&this.oPopup.isOpen()){this._close();}else{this._open();var l=this._getListBox();l.scrollToIndex(l.getSelectedIndex());this._doSelect();}o.preventDefault();o.stopImmediatePropagation();};
e.prototype.onkeydown=function(o){if(o.target.id==this.getId()+"-select"){return;}if(b.browser.webkit&&(o.which==K.DELETE||o.which==K.BACKSPACE)){this.onkeypress(o);}if(!b.browser.msie||o.which!==K.BACKSPACE){return;}this._iCursorPosBeforeBackspace=q(this.getInputDomRef()).cursorPos();};
e.prototype.onpaste=function(o){if(o.target.id==this.getId()+"-select"){return;}if(this._oValueBeforePaste===null){this._oValueBeforePaste=q(this.getInputDomRef()).val();}};
e.prototype.oncut=e.prototype.onpaste;
e.prototype.oninput=function(o){if(this.mobile){return;}if(!this._realOninput(o)){return;}var r=q(this.getInputDomRef());var v=r.val();if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined;}var V=this._doTypeAhead(v,"");if(!V&&this._oValueBeforePaste){this._doTypeAhead("",this._oValueBeforePaste);}this._oValueBeforePaste=null;this._fireLiveChange(o);};
e.prototype.onkeyup=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var k=o.which;T.prototype.onkeyup.apply(this,arguments);if(!(b.browser.msie&&k===K.BACKSPACE)&&this._oValueBeforePaste===null||k===K.TAB){return;}if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined;}var r=q(this.getInputDomRef()),v=false;if(k===K.BACKSPACE&&this._iCursorPosBeforeBackspace!==null){var i=r.cursorPos();if(this._iCursorPosBeforeBackspace!==i){i++;}this._iCursorPosBeforeBackspace=null;v=this._doTypeAhead(r.val().substr(0,i-1),"");}else if(!(v=this._doTypeAhead("",r.val()))){r.val(this._oValueBeforePaste);}if(v){this._getListBox().rerender();}this._oValueBeforePaste=null;};
e.prototype.onsaphome=function(o){if(o.target.id==this.getId()+"-select"){return;}if((!this.oPopup||!this.oPopup.isOpen())&&this.getEditable()&&this.getEnabled()){T.prototype.onsaphome.apply(this,arguments);var r=q(this.getInputDomRef());r.cursorPos(0);this._updateSelection();o.preventDefault();}else{C.prototype.onsaphome.apply(this,arguments);}};
e.prototype.onsapdelete=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.oPopup||!this.oPopup.isOpen()){return;}var l=this._getListBox(),i=l.getSelectedItem(),m=i.getId().match(/\-h\-([0-4])/),I=l.getSelectedIndex();if(m&&m.length===2){this._oHistory.remove(i.getText());l.removeItem(I);var f=this._oHistory.get().length;if(f===0){l.removeItem(0);}l.rerender();var n=I+(this._searchHelpItem?2:0);if(n==f){n++;}l.setSelectedIndex(n);this.setValue(l.getSelectedItem().getText());}};
e.prototype.onkeypress=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var k=o.which,i=o.keyCode;if((C._isHotKey(o)||(b.browser.firefox&&i===K.HOME)||i===K.F4&&o.which===0)&&!(o.ctrlKey&&o.which==120)){return;}else if(i==K.ESCAPE){var v=this.getProperty("value");var I=this.getInputDomRef();if(I&&I.value!==v){q(I).val(v);}return;}var n=String.fromCharCode(k),r=q(this.getInputDomRef()),f=r.cursorPos(),V=r.val();if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined;}if(k===K.BACKSPACE){this._doTypeAhead(V.substr(0,f-1),"");}else{this._doTypeAhead(V.substr(0,f),n);}if(V!=r.val()){this._fireLiveChange(o);}this._bFocusByOpen=undefined;o.preventDefault();};
e.prototype.onsapright=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){this._updateSelection(1);}else{this._updateSelection(-1);}o.preventDefault();};
e.prototype.onsapleft=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){this._updateSelection(-1);}else{this._updateSelection(1);}o.preventDefault();};
e.prototype.onfocusin=function(o){if(!this.oPopup||!this.oPopup.isOpen()||this._bFocusByOpen){var r=q(this.getInputDomRef()),l=r.val().length;if(l>0&&!this.mobile){this._callDoSelectAfterFocusIn(0,l);}this._bFocusByOpen=undefined;}C.prototype.onfocusin.apply(this,arguments);};
e.prototype._callDoSelectAfterFocusIn=function(s,i){if(!b.browser.msie){this._doSelect(s,i);}else{if(!this._eDoSelectAfterFocusIn||this._eDoSelectAfterFocusIn!=="_doSelect"){this._eDoSelectAfterFocusIn="onfocusin";this._doSelect(s,i);}else{this._eDoSelectAfterFocusIn=undefined;}}};
e.prototype.onselect=function(o){var t=new Date().getTime();if(this._bIgnoreSelect){this._bIgnoreSelect=false;this.iOldTimestamp=t;return;}if(this.iOldTimestamp&&t-this.iOldTimestamp<50){return;}this.iOldTimestamp=undefined;if(!this.getEnabled()||!this.getEditable()){return;}var r=q(this.getInputDomRef()),n=r.cursorPos(),v=r.val();if(v.length>0&&n>0){this._doTypeAhead(v.substr(0,n),"");if(!this.oPopup||!this.oPopup.isOpen()){this._cleanupClose(this._getListBox());}}o.preventDefault();};
e.prototype._determinePosinset=function(i,n){var p=n+1;if(this.oPopup&&this.oPopup.isOpen()){this.dontSetPoisinset=undefined;var I=i[n];var h=i[0].getId().search(this.getId()+"-h-")!=-1;if(I.getId().search(this.getId()+"-h-")==-1){if(h){p=p-1;}if(this._searchHelpItem){p=p-2;}}}return p;};
e.prototype._doSelect=function(s,i){this._bIgnoreSelect=true;var o=this.getInputDomRef();if(o){var r=q(o);r.selectText(s?s:0,i?i:r.val().length);}return this;};
e.prototype._updateSelection=function(m){var r=q(this.getInputDomRef()),n=r.cursorPos()+(m||0),v=r.val();this._doTypeAhead(v.substr(0,n),"");if(!this.oPopup||!this.oPopup.isOpen()){this._cleanupClose(this._getListBox());}else{this._getListBox().rerender();}};
e.prototype._doTypeAhead=function(v,n,N,I){if(this.__doTypeAhead===true){return;}this.__doTypeAhead=true;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;this._sWantedValue=undefined;var l=this._getListBox(),m=this.getMaxPopupItems(),f=this.__aItems||l.getItems(),V=f.length,h=this.getMaxHistoryItems()>0&&f.length>this._iItemsForHistory,F=!N&&h,o=v+n,s=new RegExp("[.*+?|()\\[\\]{}\\\\]","g"),r=o.toLowerCase().replace(s,"\\$&"),g=RegExp("^"+r+".*$"),M=n&&n.length||0,R=q(this.getInputDomRef());this.__aItems=f;if(V<=0){this.__doTypeAhead=false;return false;}var j,k=this._getFilteredItems(f,g),p=k.length>0;if(!p){F=false;}if(F){j=k;}else{j=f.slice(0);}var t=[];if(h){t=this._addHistoryItems(j,F&&g);l.setItems(j,false,true);V=j.length;}l.setVisibleItems(m<V?m:-1);var u,w=t.length;var i=0;if(I>=0){u=f[I];}if(!F&&w>0&&p){t=this._getFilteredItems(t,g);u=t[0];}if(F){u=k[0];}else if(!u){if(k.length>0){u=k[0];}else{var O=R.val();var x=0;for(i=0;i<j.length;i++){var y=j[i];if(y.getEnabled()){if(!x){x=i;}if(y.getText()==O){u=y;break;}}}if(!u){u=j[x];}}}var z=this._searchHelpItem;if(z){j.splice(w++,0,z[0],z[1]);l.setItems(j,false,true);}i=l.indexOfItem(u);var A=u.getText();var P=i+1;var B=j.length;if(t.length>0){B=B-1;}if(z){B=B-2;}if(P>t.length){if(t.length>0){P=P-1;}if(z){P=P-2;}}this._updatePosInSet(R,P,(u.getAdditionalText?u.getAdditionalText():""));R.attr("aria-setsize",B);R.val(A);this._sTypedChars=o;this._doSelect(v.length+M,A.length);l.setSelectedIndex(i);if(z&&i==2){l.scrollToIndex(0);}else{l.scrollToIndex(i);}this._iClosedUpDownIdx=i;if(!p){R=this.$();R.addClass("sapUiTfErr");setTimeout(function(){R.removeClass("sapUiTfErr");},300);R.cursorPos(v.length);this._doSelect(v.length,A.length);}this.__doTypeAhead=false;return p;};
e.prototype._prepareOpen=function(l,p){this._oValueBeforeOpen=q(this.getInputDomRef()).val();this._bOpening=true;if(!this.noTypeAheadByOpen){var i;if(this._iClosedUpDownIdx>=0){i=this._iClosedUpDownIdx;}else if(this.getSelectedItemId()){i=this.indexOfItem(sap.ui.getCore().byId(this.getSelectedItemId()));}this._doTypeAhead("",q(this.getInputDomRef()).val(),true,i);this._doSelect();}return this;};
e.prototype._handleOpened=function(){C.prototype._handleOpened.apply(this,arguments);if(!b.browser.msie){q(this.getInputDomRef()).focus();}else{this._bFocusByOpen=true;}};
e.prototype._cleanupClose=function(l){if(this.__aItems){var s=l.getSelectedItem();l.setItems(this.__aItems,false,true);this._iClosedUpDownIdx=l.indexOfItem(s);l.setSelectedIndex(this._iClosedUpDownIdx);this.__aItems=undefined;}this._oValueBeforeOpen=null;this._bOpening=undefined;return this;};
e.prototype._getFilteredItems=function(I,r){var t=I.slice(0),o;for(var i=t.length-1;i>=0;i--){o=t[i];if(!r.test(o.getText().toLowerCase())||!o.getEnabled()){t.splice(i,1);}}return t;};
e.prototype._addHistoryItems=function(I,r){var s=this.getId()+"-h-",o,h=this._oHistory.get(),l=h.length,n=[];for(var i=0,j=0;j<this.getMaxHistoryItems()&&i<l;i++){if(!r||r.test(h[i])){o=(o=sap.ui.getCore().byId(s+j))&&o.setText(h[i])||new c(s+j,{text:h[i]});n.push(o);j++;}}if(n.length>0){var f=s+"separator",g=this._getSeparator(f);n.push(g);}I.unshift.apply(I,n);return n;};
e.prototype._getSeparator=function(s){if(!this.__oSeparator&&s){this.__oSeparator=sap.ui.getCore().byId(s)||new S(s);}return this.__oSeparator||null;};
e.prototype.fireChange=function(A){this.fireEvent("change",A);if(A.newValue&&(this.getMaxHistoryItems()>0)){this._oHistory.add(A.newValue);}this._sWantedValue=undefined;return this;};
e.prototype.setValue=function(v,n){v=(v===undefined||v===null||v==="")?"":v;var I=this.getItems(),t,V=false,f;for(var i=0,l=I.length;i<l&&!V;i++){var o=I[i];var g=o.getEnabled();t=o.getText();if(g&&!f){f=t;}V=t===v&&g;}if(V){C.prototype.setValue.call(this,v,n);this._sWantedValue=undefined;}else if(v===""&&I.length>0){C.prototype.setValue.call(this,f,n);}else{this._sWantedValue=v;}return this;};
e.prototype.applyFocusInfo=function(f){C.prototype.applyFocusInfo.apply(this,arguments);if(!this._bOpening&&(!this.oPopup||!this.oPopup.isOpen())){this._cleanupClose(this._getListBox());}return this;};
e.prototype._focusAfterListBoxClick=function(){if(!b.browser.webkit){this.focus();}else{var l=this._getListBox();l.addDelegate({onclick:function(){l.removeDelegate(this);this.focus();}.bind(this)});}};
e.prototype.onsapfocusleave=function(o){var l=this._getListBox();if(o.relatedControlId&&d(l.getFocusDomRef(),sap.ui.getCore().byId(o.relatedControlId).getFocusDomRef())){this._focusAfterListBoxClick();}else{if(this.oPopup&&this.oPopup.isOpen()){this._close();}T.prototype.onsapfocusleave.apply(this,arguments);}};
e.prototype.getTooltip_AsString=function(){var t=C.prototype.getTooltip_AsString.apply(this,arguments);if(!this._searchHelpItem){return t;}else{var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var s=r.getText("DDBX_SHI_ARIA");s=s==="DDBX_SHI_ARIA"?"Open search help via {0}":s;var A=this._searchHelpItem[0]&&this._searchHelpItem[0].getAdditionalText()||r.getText("DDBX_SHIF4");A=A==="DDBX_SHIF4"?"F4":A;s=s.replace("{0}",A);return(t?t+" - ":"")+s;}};
e.prototype._handleSelect=function(o){if(this._searchHelpItem&&o.getParameter("selectedItem")===this._searchHelpItem[0]){var f=new q.Event("sapshow");f.which=K.F4;this.onsapshow(f);}else{var i=o.getParameter("selectedItem");if(!i){i=sap.ui.getCore().byId(o.getParameter("selectedId"));}if(i.getId().search(this.getId()+"-h-")!=-1){var l=this._getListBox(),I=l.getItems();var g=this._oHistory.get().length;if(g>this.getMaxHistoryItems()){g=Math.max(this.getMaxHistoryItems(),0);}for(var h=g;h<I.length;h++){if(I[h].getText()==i.getText()&&I[h].getEnabled()){o.mParameters.selectedIndex=h;if(!o.getParameter("selectedIndices")){o.mParameters.selectedIndices=new Array(1);o.mParameters.aSelectedIndices=new Array(1);}o.mParameters.selectedIndices[0]=h;o.mParameters.aSelectedIndices[0]=h;o.mParameters.selectedItem=I[h];break;}}}this._sWantedValue=undefined;return C.prototype._handleSelect.apply(this,arguments);}};
e.prototype.setSearchHelpEnabled=function(f,t,A,i){this.setProperty("searchHelpEnabled",f);if(t){this.setProperty("searchHelpText",t);}else{t=this.getSearchHelpText();}if(A){this.setProperty("searchHelpAdditionalText",A);}else{A=this.getSearchHelpAdditionalText();}if(i){this.setProperty("searchHelpIcon",i);}else{i=this.getSearchHelpIcon();}if(f){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(r){t=t||r.getText("DDBX_SHI");t=t==="DDBX_SHI"?"Search Help":t;A=A||r.getText("DDBX_SHIF4");A=A==="DDBX_SHIF4"?"F4":A;}i=i||sap.ui.require.toUrl("sap/ui/commons/images/dropdown/ico12_f4.gif");if(!this._searchHelpItem){this._searchHelpItem=[new c(this.getId()+"_shi",{text:t,additionalText:A,enabled:true,icon:i}),new S()];}else{this._searchHelpItem[0].setText(t).setAdditionalText(A).setIcon(i);}}else{if(this._searchHelpItem){this._searchHelpItem[0].destroy();this._searchHelpItem[1].destroy();this._searchHelpItem=null;}}return this;};
e.prototype.setSearchHelpText=function(s){this.setProperty("searchHelpText",s);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),s,this.getSearchHelpAdditionalText(),this.getSearchHelpIcon());return this;};
e.prototype.setSearchHelpAdditionalText=function(s){this.setProperty("searchHelpAdditionalText",s);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),s,this.getSearchHelpIcon());return this;};
e.prototype.setSearchHelpIcon=function(s){this.setProperty("searchHelpIcon",s);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),s);return this;};
e.prototype.checkValueInItems=function(){var v=this.getValue();var I=C.prototype.getItems.apply(this);var w=this._sWantedSelectedKey;var W=this._sWantedSelectedItemId;if(I&&I.length>0){var V=false;var f;var i=0,l=0;var o;var g=false;var t="";if(this._sWantedValue){for(i=0,l=I.length;i<l&&!V;i++){o=I[i];g=o.getEnabled();t=o.getText();if(g&&!f){f=t;}V=t===this._sWantedValue&&g;}if(V){v=this._sWantedValue;this._sWantedValue=undefined;w=undefined;W=undefined;C.prototype.setValue.call(this,v);}}if(!V){for(i=0,l=I.length;i<l&&!V;i++){o=I[i];g=o.getEnabled();t=o.getText();if(g&&!f){f=t;}V=t===v&&g;}}if(!V){v=f;C.prototype.setValue.call(this,v);}}else{v="";C.prototype.setValue.call(this,v);}this._sWantedSelectedKey=w;this._sWantedSelectedItemId=W;return v;};
e.prototype.setMaxHistoryItems=function(m){var o=this.getMaxHistoryItems();var I=this.getId()+"-h-";var f;this.setProperty('maxHistoryItems',m,true);if(m<o){var l=this._getListBox();for(var i=Math.max(m,0);i<o;i++){f=sap.ui.getCore().byId(I+i);if(f){l.removeItem(f);f.destroy();}}if(m<=0&&this.__oSeparator){l.removeItem(this.__oSeparator);}}return this;};
e.prototype.clearHistory=function(){this._oHistory.clear();var I=this.getId()+"-h-";var l=this._getListBox();var o;for(var i=0;i<this.getMaxHistoryItems();i++){o=sap.ui.getCore().byId(I+i);if(o){l.removeItem(o);o.destroy();}}if(this.__oSeparator){l.removeItem(this.__oSeparator);}};
e.prototype.ondrop=function(o){o.preventDefault();};
e.prototype._isSetEmptySelectedKeyAllowed=function(){return false;};
return e;});
sap.ui.predefine('sap/ui/commons/DropdownBoxRenderer',['./ComboBoxRenderer','sap/ui/core/Renderer','sap/ui/core/library'],function(C,R,c){"use strict";var V=c.ValueState;var D=R.extend(C);
D.renderOuterContentBefore=function(r,d){this.renderExpander(r,d);};
D.renderOuterContent=function(r,d){this.renderSelectBox(r,d,'0');if(d.getDisplaySecondaryValues()){r.write("<span id=\""+d.getId()+"-SecVal\" style=\"display: none;\"></span>");}};
D.renderTextFieldEnabled=function(r,d){if(d.mobile){r.writeAttribute('tabindex','-1');}else if(!d.getEnabled()){r.writeAttribute('disabled','disabled');r.writeAttribute('tabindex','-1');}else if(!d.getEditable()){r.writeAttribute('tabindex','0');}else{r.writeAttribute('tabindex','0');}};
D.renderARIAInfo=function(r,d){var p=-1;if(d.getSelectedItemId()){for(var i=0;i<d.getItems().length;i++){var I=d.getItems()[i];if(I.getId()==d.getSelectedItemId()){p=i+1;break;}}}var P={autocomplete:"list",live:"polite",setsize:d.getItems().length,posinset:(p>=0)?p:undefined};if(d.getValueState()==V.Error){P["invalid"]=true;}if(d.getDisplaySecondaryValues()){P["describedby"]={value:d.getId()+"-SecVal",append:true};}r.writeAccessibilityState(d,P);};
return D;},true);
sap.ui.predefine('sap/ui/commons/FileUploader',['sap/base/Log','./library','sap/ui/unified/FileUploader','./FileUploaderRenderer','sap/ui/core/Core'],function(L,l,U,F,C){"use strict";
var a=U.extend("sap.ui.commons.FileUploader",{metadata:{deprecated:true,library:"sap.ui.commons"}});
try{sap.ui.getCore().loadLibrary("sap.ui.unified");}catch(e){L.error("The control 'sap.ui.commons.FileUploader' needs library 'sap.ui.unified'.");throw(e);}return a;});
sap.ui.predefine('sap/ui/commons/FileUploaderParameter',['sap/base/Log','./library','sap/ui/unified/FileUploaderParameter'],function(L,l,U){"use strict";
var F=U.extend("sap.ui.commons.FileUploaderParameter",{metadata:{deprecated:true,library:"sap.ui.commons"}});
try{sap.ui.getCore().loadLibrary("sap.ui.unified");}catch(e){L.error("The element 'sap.ui.commons.FileUploaderParameter' needs library 'sap.ui.unified'.");throw(e);}return F;});
sap.ui.predefine('sap/ui/commons/FileUploaderRenderer',['sap/ui/core/Renderer','sap/ui/unified/FileUploaderRenderer'],function(R,U){"use strict";var F=R.extend(U);return F;},true);
sap.ui.predefine('sap/ui/commons/FormattedTextView',['sap/base/Log','./library','sap/ui/core/Control','./FormattedTextViewRenderer','sap/ui/core/library','sap/base/security/sanitizeHTML'],function(L,l,C,F,c,s){"use strict";var A=c.AccessibleRole;
var a=C.extend("sap.ui.commons.FormattedTextView",{metadata:{library:"sap.ui.commons",properties:{accessibleRole:{type:"sap.ui.core.AccessibleRole",group:"Accessibility",defaultValue:A.Document},htmlText:{type:"string",group:"Misc",defaultValue:""}},aggregations:{controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control"}}}});
a.prototype.init=function(){this._renderingRules={};this._renderingRules.ATTRIBS={'span::class':1,'div::class':1,'div::id':1,'span::id':1,'embed::data-index':1};this._renderingRules.ELEMENTS={'abbr':1,'acronym':1,'address':1,'blockquote':1,'br':1,'cite':1,'code':1,'dfn':1,'div':1,'em':1,'h1':1,'h2':1,'h3':1,'h4':1,'h5':1,'h6':1,'kbd':1,'p':1,'pre':1,'q':1,'samp':1,'strong':1,'span':1,'var':1,'dl':1,'dt':1,'dd':1,'ol':1,'ul':1,'li':1,'embed':1};};
a.prototype.exit=function(){delete this._renderingRules;};
a.prototype.hasControls=function(){var b=this.getAggregation("controls");return!!(b&&b.length>0);};
var S=function(t,b){var d=/^[0-9]*$/;for(var i=0;i<b.length;i+=2){var e=t+"::"+b[i];if(this._renderingRules.ATTRIBS[e]){if(t==="embed"&&!(b[i+1].match(d))){return null;}}else{var w='<'+t+'> with attribute ['+b[i]+'="'+b[i+1]+'"] is not allowed and cut';L.warning(w,this);b[i+1]=null;}}return b;};var p=function(t,b){if(this._renderingRules.ELEMENTS[t]){return S.call(this,t,b);}else{var w='<'+t+'> is not allowed';L.warning(w,this);}};
a.prototype.setHtmlText=function(t){var b=s(t,{tagPolicy:p.bind(this)});this.setProperty("htmlText",b);return this;};
var f=function(b){if(this.hasControls()){this.removeAllAggregation("controls");}var I=Array.isArray(b);if(I&&b.length>0){for(var i=0;i<b.length;i++){this.addAggregation("controls",b[i],true);}this.invalidate();}};
a.prototype.setContent=function(h,b){this.setHtmlText(h);f.call(this,b);};
return a;});
sap.ui.predefine('sap/ui/commons/FormattedTextViewRenderer',["sap/base/Log"],function(L){"use strict";var F={};
F.render=function(r,c){var a=/<embed\s+data-index="([0-9]+)"\s*\/?>/gim;var h=c.getHtmlText();var i=c.getControls().slice();var t=i.length;var l=0;var m=[];r.write("<span");r.writeControlData(c);r.addClass("sapUiFTV");r.writeClasses();if(c.getTooltip_AsString()){r.writeAttributeEscaped("title",c.getTooltip_AsString());}r.write(">");while((m=a.exec(h))!==null){r.write(h.slice(l,m.index));if(this._renderReplacement(r,m[1],i)){t--;}else{L.warning("Could not find matching control to placeholder #"+m[1]);}l=a.lastIndex;}r.write(h.slice(l,h.length));if(t>0){L.warning('There are leftover controls in the aggregation that have not been used in the formatted text',c);}r.write("</span>");};
F._renderReplacement=function(r,c,C){if(C[c]){r.renderControl(C[c]);C[c]=null;return true;}else{return false;}};
return F;},true);
sap.ui.predefine('sap/ui/commons/HorizontalDivider',['./library','sap/ui/core/Control','./HorizontalDividerRenderer'],function(l,C,H){"use strict";var a=l.HorizontalDividerHeight;var b=l.HorizontalDividerType;
var c=C.extend("sap.ui.commons.HorizontalDivider",{metadata:{library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},type:{type:"sap.ui.commons.HorizontalDividerType",group:"Appearance",defaultValue:b.Area},height:{type:"sap.ui.commons.HorizontalDividerHeight",group:"Appearance",defaultValue:a.Medium}}}});
return c;});
sap.ui.predefine('sap/ui/commons/HorizontalDividerRenderer',[],function(){"use strict";var H={};
H.render=function(r,c){r.write("<hr");r.writeControlData(c);r.writeAttribute("role","separator");if(c.getWidth()){r.writeAttribute("style","width:"+c.getWidth()+";");}r.addClass("sapUiCommonsHoriDiv");r.addClass(c.getType()=="Page"?"sapUiCommonsHoriDivTypePage":"sapUiCommonsHoriDivTypeArea");switch(c.getHeight()){case"Ruleheight":r.addClass("sapUiCommonsHoriDivHeightR");break;case"Small":r.addClass("sapUiCommonsHoriDivHeightS");break;case"Large":r.addClass("sapUiCommonsHoriDivHeightL");break;default:r.addClass("sapUiCommonsHoriDivHeightM");}r.writeClasses();r.write("/>");};
return H;},true);
sap.ui.predefine('sap/ui/commons/Image',['./library','sap/ui/core/Control','./ImageRenderer'],function(l,C,I){"use strict";
var a=C.extend("sap.ui.commons.Image",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.commons.FormattedTextViewControl","sap.ui.core.IFormContent"],library:"sap.ui.commons",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},useMap:{type:"string",group:"Misc",defaultValue:null}},events:{press:{}}}});
a.prototype.onclick=function(e){this.firePress({});};
a.prototype.onsapenter=a.prototype.onclick;
a.prototype.getFormDoNotAdjustWidth=function(){return true;};
return a;});
sap.ui.predefine('sap/ui/commons/ImageMap',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./ImageMapRenderer','./Area','sap/ui/Device'],function(q,l,C,I,a,A,D){"use strict";
var b=C.extend("sap.ui.commons.ImageMap",{metadata:{library:"sap.ui.commons",properties:{name:{type:"string",group:"Misc",defaultValue:null}},aggregations:{areas:{type:"sap.ui.commons.Area",multiple:true,singularName:"area"}},events:{press:{parameters:{areaId:{type:"string"}}}}}});
b.prototype.createArea=function(){var o=new A();for(var i=0;i<arguments.length;i++){var c=arguments[i];var o;if(c instanceof A){o=c;}else{o=new A(c);}this.addArea(o);}return this;};
b.prototype.onAfterRendering=function(){this.oDomRef=this.getDomRef();if(!this.oItemNavigation){this.oItemNavigation=new I();}if(D.browser.msie){var t=this;var c=[];this.oItemNavigation.setTabIndex0();var $=q("img[usemap='#"+this.getName()+"']");$.each(function(i,f){var g=f.getAttribute("id");var h=sap.ui.getCore().byId(g);h.addDelegate(t.oItemNavigation);t.oItemNavigation.setRootDomRef(f);c.push(h);});this.aImageControls=c;}else{this.addDelegate(this.oItemNavigation);this.oItemNavigation.setRootDomRef(this.oDomRef);}var d=[];var e=this.getAreas();for(var i=0;i<e.length;i++){var o=e[i].getFocusDomRef();if(o){d.push(o);}}this.oItemNavigation.setItemDomRefs(d);this.oItemNavigation.setCycling(true);this.oItemNavigation.setSelectedIndex(-1);this.oItemNavigation.setFocusedIndex(-1);};
b.prototype.exit=function(){if(this.oItemNavigation){if(D.browser.msie){for(var i=0;i<this.aImageControls.length;i++){this.aImageControls[i].removeDelegate(this.oItemNavigation);}}else{this.removeDelegate(this.oItemNavigation);}this.oItemNavigation.destroy();delete this.oItemNavigation;}};
return b;});
sap.ui.predefine('sap/ui/commons/ImageMapRenderer',[],function(){"use strict";var I={};
I.render=function(r,i){var a=sap.ui.getCore().getConfiguration().getAccessibility();var b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");r.write('<span id="'+i.getId()+'-Descr" style="visibility: hidden; display: none; outline: none;">');r.writeEscaped(b.getText("IMAGEMAP_DSC"));r.write('</span>');r.write("<map tabindex='-1'");r.writeControlData(i);r.writeAttributeEscaped("name",i.getName());if(i.getTooltip_AsString()){r.writeAttributeEscaped("title",i.getTooltip_AsString());}r.write(">");var A=i.getAreas();for(var c=0,l=A.length;c<l;c++){r.write("<area ");r.writeElementData(A[c]);r.write(' style="display: inline;"');if(a){r.writeAttribute("aria-describedby",i.getId()+"-Descr");}var s=A[c].getShape();var C=A[c].getCoords();var h=A[c].getHref();var d=A[c].getAlt();var t=A[c].getTooltip_AsString();if((s==="rect")||(s==="circle")||(s==="poly")){r.writeAttribute("shape",s);}else{r.writeAttribute("shape","default");}if(C){r.writeAttributeEscaped("coords",C);}if(h){r.writeAttributeEscaped("href",h);}if(d){r.writeAttributeEscaped("alt",d);}if(t){r.writeAttributeEscaped("title",t);}r.writeAttribute("tabindex",0);r.write(">");}r.write("</map>");};
return I;},true);
sap.ui.predefine('sap/ui/commons/ImageRenderer',[],function(){"use strict";var I={};
I.render=function(r,i){r.write("<img");r.writeControlData(i);r.writeAttributeEscaped("src",i.getSrc()||sap.ui.require.toUrl('sap/ui/commons/img/1x1.gif'));r.addClass("sapUiImg");if(i.hasListeners("press")){r.addClass("sapUiImgWithHandler");}if(!i.getSrc()){r.addClass("sapUiImgNoSource");}r.writeClasses();var t=i.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}var u=i.getUseMap();if(u){if(!(u.startsWith("#"))){u="#"+u;}r.writeAttributeEscaped("usemap",u);}var m=0;if((i.getDecorative()&&(!u))){m=-1;r.writeAttribute("role","presentation");r.write(" alt=''");}else{if(i.getAlt()){r.writeAttributeEscaped("alt",i.getAlt()||t);}else if(t){r.writeAttributeEscaped("alt",t);}}r.writeAttribute("tabindex",m);var a="";if(i.getWidth()&&i.getWidth()!=''){a+="width:"+i.getWidth()+";";}if(i.getHeight()&&i.getHeight()!=''){a+="height:"+i.getHeight()+";";}if(a!=""){r.writeAttribute("style",a);}r.write("/>");};
return I;},true);
sap.ui.predefine('sap/ui/commons/InPlaceEdit',['./TextField','./TextView','./library','sap/ui/core/Control','sap/ui/core/ValueStateSupport','sap/ui/core/theming/Parameters','./InPlaceEditRenderer','sap/ui/core/library','sap/ui/Device','./Button','sap/ui/dom/containsOrEquals','sap/ui/events/KeyCodes'],function(T,a,l,C,V,P,I,c,D,B,b,K){"use strict";var d=l.TextViewDesign;var e=c.ValueState;
var f=C.extend("sap.ui.commons.InPlaceEdit",{metadata:{library:"sap.ui.commons",properties:{valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:e.None},undoEnabled:{type:"boolean",group:"Misc",defaultValue:true},design:{type:"sap.ui.commons.TextViewDesign",group:"Data",defaultValue:d.Standard}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},events:{change:{parameters:{newValue:{type:"string"}}},liveChange:{parameters:{liveValue:{type:"string"}}}}}});
f.prototype.init=function(){this._bEditMode=false;};
f.prototype.exit=function(){this._bEditMode=undefined;this._oDisplayControl=undefined;this._oEditControl=undefined;this._sOldText=undefined;this._sOldTextAvailable=undefined;this._bUseEditButton=undefined;this._iHeight=undefined;if(this._oTextView){this._oTextView.destroy();delete this._oTextView;}if(this._oTextField){this._oTextField.destroy();delete this._oTextField;}if(this._oUndoButton){this._oUndoButton.destroy();delete this._oUndoButton;}if(this._oEditButton){this._oEditButton.destroy();delete this._oEditButton;}var x=this.getContent();if(x){x.detachEvent("_change",w,this);if(x instanceof T){x.detachEvent("change",t,this);x.detachEvent("liveChange",v,this);}}};
f.prototype.onBeforeRendering=function(){var x=this;u(x);j(x);var y=this.getTooltip();if(y instanceof sap.ui.core.TooltipBase){if(this._bEditMode){y._currentControl=this._oEditControl;}else{y._currentControl=this._oDisplayControl;}}};
f.prototype.onAfterRendering=function(){if(!this._bEditMode&&this.getEditable()&&this._oTextView&&this._oTextView.getDomRef()){this._oTextView.$().attr("tabindex","0");}var $=this.$();var x;var O;if(this._bEditMode){this._oEditControl.$().css("width","100%");if(this._iHeight>0){O=$.height();var y=this._iHeight-O;var M=$.outerHeight(true)-$.outerHeight(false);y=y+M;var z=Math.floor(y/2);var A=y-z;$.css("margin-top",z+"px").css("margin-bottom",A+"px");}}else if(this._oDisplayControl.getMetadata().getName()=="sap.ui.commons.Link"){this._oDisplayControl.$().css("width","auto").css("max-width","100%");}else{var E=this._oDisplayControl.$();E.css("width","100%");if(!this._iHeight&&this._iHeight!=0&&this.getDesign()!=d.Standard){x=E.outerHeight(true);O=$.innerHeight();if(O<x){var F=$.outerHeight()-$.innerHeight();this._iHeight=x+F;}else{this._iHeight=0;}}if(this._iHeight>0){$.css("height",this._iHeight+"px");}}if(this._sOldTextAvailable&&this._oUndoButton&&this._oUndoButton.getDomRef()){this._oUndoButton.$().attr("tabindex","-1");}if(this._oEditButton&&this._oEditButton.getDomRef()){this._oEditButton.$().attr("tabindex","-1");}if(this._delayedCallId){clearTimeout(this._delayedCallId);this._delayedCallId=null;}if(this.getValueState()==e.Success){this._delayedCallId=setTimeout(function(){this.removeValidVisualization();}.bind(this),3000);}};
f.prototype.removeValidVisualization=function(){var x=this.$();if(x){x.removeClass("sapUiIpeSucc");}};
f.prototype.clearOldText=function(){if(!this.getUndoEnabled()){return;}if(this._bEditMode){this._sOldText=this._oEditControl.getValue();this._sOldTextAvailable=true;}else{this._sOldText=undefined;this._sOldTextAvailable=false;}this.rerender();};
f.prototype.getRequired=function(){if(this.getContent()&&this.getContent().getRequired){return this.getContent().getRequired();}else{return false;}};
f.prototype.getEditable=function(){var x=this.getContent();if(!x||(x.getEditable&&!x.getEditable())||(x.getEnabled&&!x.getEnabled())){return false;}else{return true;}};
f.prototype.onsapescape=function(E){if(this.getUndoEnabled()){if(!D.browser.firefox){var x=this;n(x);}else{this._bEsc=true;}if(this.$().hasClass("sapUiIpeUndo")){E.stopPropagation();}this._oEditControl._bEsc=undefined;this._oEditControl._sValue=undefined;}};
f.prototype.onkeypress=function(E){if(this._bEsc){var x=this;this._bEsc=undefined;n(x);}};
f.prototype.onkeydown=function(E){if(E.keyCode==K.F2&&!this._bEditMode){var x=this;s(x);this.$().addClass("sapUiIpeFocus");}};
f.prototype.onfocusin=function(E){if(!this._bEditMode){if(!this._bUseEditButton&&E.target.id!=this.getId()+"--X"){var x=this;s(x);}this.$().addClass("sapUiIpeFocus");}else if(this._focusDelay){clearTimeout(this._focusDelay);this._focusDelay=null;}};
f.prototype.ontap=function(E){if(D.os.name=="iOS"){this.onfocusin(E);}};
f.prototype.onfocusout=function(E){if(this._focusDelay){clearTimeout(this._focusDelay);this._focusDelay=null;}this._focusDelay=setTimeout(function(){this._handleFocusOut(E);}.bind(this),200);};
f.prototype._handleFocusOut=function(E){var F=document.activeElement;if(!b(this.getDomRef(),F)){if(!this._bEditMode){this.$().removeClass("sapUiIpeFocus");}var x=this;h(x);}this._focusDelay=undefined;};
f.prototype.setContent=function(x){var O=this.getContent();if(O){O.detachEvent("_change",w,this);if(O instanceof T){O.detachEvent("change",t,this);O.detachEvent("liveChange",v,this);O._propagateEsc=undefined;}}this._sOldText=undefined;this._sOldTextAvailable=false;this._oDisplayControl=undefined;this._oEditControl=undefined;this.setAggregation("content",x);if(x){x.attachEvent("_change",w,this);if(x instanceof T){x.attachEvent("change",t,this);x.attachEvent("liveChange",v,this);x._propagateEsc=true;}}var y=this;u(y);return this;};
f.prototype.setValueState=function(x){var y=this.getContent();if(y&&y.setValueState){y.setValueState(x);}else if(this._oEditControl&&this._oEditControl.setValueState){this._oEditControl.setValueState(x);w.call(this);}else{this.setProperty("valueState",x);}return this;};
f.prototype.getValueState=function(){var x=this.getContent();if(x&&x.getValueState){return x.getValueState();}else if(this._oEditControl&&this._oEditControl.getValueState){return this._oEditControl.getValueState();}else{return this.getProperty("valueState");}};
f.prototype.setTooltip=function(x){var y=this.getContent();if(y){y.setTooltip(x);}else{this._refreshTooltipBaseDelegate(x);this.setAggregation("tooltip",x);}return this;};
f.prototype.getTooltip=function(){var x=this.getContent();if(x){return x.getTooltip();}else{return this.getAggregation("tooltip");}};
f.prototype.setDesign=function(x){this.setProperty("design",x);this._iHeight=undefined;return this;};
f.prototype.clone=function(){var x=this.getContent();if(x){x.detachEvent("_change",w,this);if(x instanceof T){x.detachEvent("change",t,this);x.detachEvent("liveChange",v,this);}}var y=C.prototype.clone.apply(this,arguments);if(x){x.attachEvent("_change",w,this);if(x instanceof T){x.attachEvent("change",t,this);x.attachEvent("liveChange",v,this);}}return y;};
f.prototype.getFocusDomRef=function(){if(!this.getDomRef()){return undefined;}if(this._bEditMode){return this._oEditControl.getFocusDomRef();}else{return this._oDisplayControl.getFocusDomRef();}};
f.prototype.getIdForLabel=function(){if(this._oDisplayControl&&this._oDisplayControl.getMetadata().getName()=="sap.ui.commons.Link"){return this._oDisplayControl.getId();}else if(this._oEditControl){return this._oEditControl.getId();}else{return this.getId();}};
f.prototype.onThemeChanged=function(E){var x=this;k(x);p(x);this._iHeight=undefined;if(this.getDomRef()&&!this._bEditMode){this.rerender();}};
f.prototype.getAccessibilityInfo=function(){var x=this.getContent();return x&&x.getAccessibilityInfo?x.getAccessibilityInfo():null;};
var g={onAfterRendering:function(){this.onAfterRendering();}};
function u(x){var y=x.getContent();if(!y){return;}var z=y.getTooltip();switch(y.getMetadata().getName()){case"sap.ui.commons.TextField":case"sap.ui.commons.ComboBox":case"sap.ui.commons.DropdownBox":if(!x._oTextView){x._oTextView=new a(x.getId()+"--TV",{wrapping:false});x._oTextView.setParent(x);x._oTextView.removeDelegate(g);x._oTextView.addDelegate(g,x);x._oTextView.getTooltip=function(){return this.getParent().getTooltip();};}x._oTextView.setText(y.getValue());x._oTextView.setEnabled(y.getEnabled());x._oTextView.setTextDirection(y.getTextDirection());x._oTextView.setVisible(y.getVisible());x._oTextView.setWidth("100%");x._oTextView.setTextAlign(y.getTextAlign());x._oTextView.setDesign(x.getDesign());x._oTextView.setHelpId(y.getHelpId());x._oTextView.setAccessibleRole(y.getAccessibleRole());if(x._oTextView._oTooltip&&x._oTextView._oTooltip!=z){x._oTextView.removeDelegate(x._oTextView._oTooltip);x._oTextView._oTooltip=undefined;}if(z instanceof sap.ui.core.TooltipBase){if(!x._oTextView._oTooltip||x._oTextView._oTooltip!=z){x._oTextView.addDelegate(z);x._oTextView._oTooltip=z;}}x._oDisplayControl=x._oTextView;x._oEditControl=y;x._bUseEditButton=false;break;case"sap.ui.commons.Link":x._oDisplayControl=y;x._oDisplayControl.removeDelegate(g);x._oDisplayControl.addDelegate(g,x);if(x._oTextField){x._oTextField.setValue(y.getText());x._oTextField.setWidth("100%");x._oEditControl=x._oTextField;if(x._oTextField._oTooltip&&x._oTextField._oTooltip!=z){x._oTextField.removeDelegate(x._oTextField._oTooltip);x._oTextField._oTooltip=undefined;}if(z instanceof sap.ui.core.TooltipBase){if(!x._oTextField._oTooltip||x._oTextField._oTooltip!=z){x._oTextField.addDelegate(z);x._oTextField._oTooltip=z;}}}o(x);x._bUseEditButton=true;break;default:throw new Error("Control not supported for InPlaceEdit");}}
function s(x){if(!x._bEditMode&&x.getEditable()){if(!x._oEditControl&&x.getContent().getMetadata().getName()=="sap.ui.commons.Link"){var y=x.getValueState();x._oTextField=new T(x.getId()+"--input",{valueState:y});x._oTextField.setParent(x);x._oTextField.attachEvent('change',r,x);x._oTextField.attachEvent('liveChange',v,x);x._oTextField._propagateEsc=true;x._oTextField.getTooltip=function(){return this.getParent().getTooltip();};}if(!x._sOldTextAvailable&&x.getUndoEnabled()){x._sOldText=i(x);x._sOldTextAvailable=true;}x._bEditMode=true;x.rerender();x._oEditControl.focus();}}
function h(x){if(x._bEditMode&&x.getEditable()){x._bEditMode=false;if(x._sOldText==i(x)){x._sOldText=undefined;x._sOldTextAvailable=false;}x.rerender();}}
function i(x){var y=x.getContent();if(!y){return undefined;}if(y.getValue){return y.getValue();}else if(y.getText){return y.getText();}}
function j(x){if(!x._oUndoButton&&x.getUndoEnabled()){x._oUndoButton=new B(x.getId()+"--X",{lite:true}).setParent(x);k(x);x._oUndoButton.attachEvent('press',m,x);}if(x._oUndoButton){x._oUndoButton.setEnabled(x.getEditable());}}
function k(x){if(x._oUndoButton){var y=P._getThemeImage('_sap_ui_commons_InPlaceEdit_UndoImageURL');var z=P._getThemeImage('_sap_ui_commons_InPlaceEdit_UndoImageDownURL');if(!y){y="sap-icon://decline";}x._oUndoButton.setIcon(y);x._oUndoButton.setIconHovered(z);}}
function m(E){var x=this;n(x);if(this._bEditMode){this._oEditControl.focus();this.$().removeClass("sapUiIpeUndo");}}
function n(x){if(x.getUndoEnabled()&&x._sOldTextAvailable){var y=x.getContent();if(!y){return;}if(y.setValue){y.setValue(x._sOldText);}else if(y.setText){y.setText(x._sOldText);}if(x._bEditMode){x._oEditControl.setValue(x._sOldText);x._oEditControl.fireChange({newValue:x._sOldText});}else if(y.fireChange){y.fireChange({newValue:x._sOldText});}else{x.fireChange({newValue:x._sOldText});}if(!x._bEditMode){x._sOldText=undefined;x._sOldTextAvailable=false;}}}
function o(x){if(!x._oEditButton){x._oEditButton=new B(x.getId()+"--Edit",{lite:true}).setParent(x);x._oEditButton.addStyleClass("sapUiIpeEBtn");p(x);x._oEditButton.attachEvent('press',q,x);}}
function p(x){if(x._oEditButton){var y=P._getThemeImage('_sap_ui_commons_InPlaceEdit_EditImageURL');var z=P._getThemeImage('_sap_ui_commons_InPlaceEdit_EditImageDownURL');if(!y){y="sap-icon://edit";}x._oEditButton.setIcon(y);x._oEditButton.setIconHovered(z);}}
function q(E){var x=this;s(x);this.$().addClass("sapUiIpeFocus");}
function r(E){var x=this.getContent();if(x.setText){var N=E.getParameter("newValue");x.setText(N);t.apply(this,arguments);}}
function t(E){if(this._sOldText!=E.getParameter("newValue")&&this.getUndoEnabled()){this.$().addClass("sapUiIpeUndo");}else{this.$().removeClass("sapUiIpeUndo");}this.fireChange(E.getParameters());}
function v(E){if(this._sOldText!=E.getParameter("liveValue")&&this.getUndoEnabled()){this.$().addClass("sapUiIpeUndo");}else{this.$().removeClass("sapUiIpeUndo");}this.fireLiveChange({liveValue:E.getParameter("liveValue")});}
function w(){if(!this._bEditMode){this.invalidate();}else{switch(this.getValueState()){case(e.Error):if(!this.$().hasClass('sapUiIpeErr')){this.$().addClass('sapUiIpeErr');this.$().removeClass('sapUiIpeWarn');this.$().removeClass('sapUiIpeSucc');}break;case(e.Success):if(!this.$().hasClass('sapUiIpeSucc')){this.$().addClass('sapUiIpeSucc');this.$().removeClass('sapUiIpeErr');this.$().removeClass('sapUiIpeWarn');}break;case(e.Warning):if(!this.$().hasClass('sapUiIpeWarn')){this.$().addClass('sapUiIpeWarn');this.$().removeClass('sapUiIpeErr');this.$().removeClass('sapUiIpeSucc');}break;default:this.$().removeClass('sapUiIpeWarn');this.$().removeClass('sapUiIpeErr');this.$().removeClass('sapUiIpeSucc');break;}}}
return f;});
sap.ui.predefine('sap/ui/commons/InPlaceEditRenderer',['sap/base/Log','sap/ui/core/library','sap/ui/core/ValueStateSupport'],function(L,c,V){"use strict";var a=c.ValueState;var I={};
I.render=function(r,i){var C=i.getContent();var w;if(C){if(C.getWidth){w=C.getWidth();}if(C.getVisible&&!C.getVisible()){L.warning("Content is not visivle - nothing is rendered",this);return;}}else{L.warning("No content provided - nothing is rendered",this);return;}r.write("<div");r.writeControlData(i);r.addClass("sapUiIpe");if(!i.getEditable()){r.addClass("sapUiIpeRo");}else if(!i._bEditMode){r.writeAttribute("tabindex","-1");if(!i._sOldTextAvailable){if(C.getMetadata().getName()=="sap.ui.commons.ComboBox"||C.getMetadata().getName()=="sap.ui.commons.DropdownBox"){r.addClass("sapUiIpeCombo");}}if(C.getMetadata().getName()=="sap.ui.commons.Link"){r.addClass("sapUiIpeLink");}}else{r.addClass("sapUiIpeEdit");}if(w){r.addStyle("width",w);}if(i.getUndoEnabled()&&i._sOldTextAvailable&&(!i._bEditMode||(i._bEditMode&&i._oEditControl.getValue()!=i._sOldText))){r.addClass("sapUiIpeUndo");}switch(i.getValueState()){case a.Error:r.addClass('sapUiIpeErr');break;case a.Success:r.addClass('sapUiIpeSucc');break;case a.Warning:r.addClass('sapUiIpeWarn');break;default:break;}var t=V.enrichTooltip(i,i.getTooltip_AsString());if(t){r.writeAttributeEscaped('title',t);}r.writeClasses();r.writeStyles();r.write(">");if(i._sOldTextAvailable||C.getMetadata().getName()=="sap.ui.commons.Link"){r.write("<div");r.addClass("sapUiIpeCont");if(C.getMetadata().getName()=="sap.ui.commons.ComboBox"||C.getMetadata().getName()=="sap.ui.commons.DropdownBox"){r.addClass("sapUiIpeCombo");}r.writeClasses();r.write(">");}if(i._bEditMode){this.renderEditContent(r,i);}else{this.renderDisplayContent(r,i);}if(i._sOldTextAvailable||C.getMetadata().getName()=="sap.ui.commons.Link"){r.write("</div>");if(i.getUndoEnabled()&&i._sOldTextAvailable){r.renderControl(i._oUndoButton);}}r.write("</div>");};
I.renderDisplayContent=function(r,i){if(i._oDisplayControl){r.renderControl(i._oDisplayControl);if(i.getEditable()&&i._oDisplayControl.getMetadata().getName()=="sap.ui.commons.Link"){r.renderControl(i._oEditButton);}}};
I.renderEditContent=function(r,i){if(i._oEditControl){r.renderControl(i._oEditControl);}};
return I;},true);
sap.ui.predefine('sap/ui/commons/Label',['./library','sap/ui/core/Control','sap/ui/core/LabelEnablement','./LabelRenderer','sap/ui/core/library'],function(l,C,L,a,c){"use strict";var T=c.TextAlign;var b=c.TextDirection;var d=l.LabelDesign;
var e=C.extend("sap.ui.commons.Label",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.Label"],library:"sap.ui.commons",properties:{design:{type:"sap.ui.commons.LabelDesign",group:"Appearance",defaultValue:d.Standard},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},text:{type:"string",group:"Misc",defaultValue:''},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},required:{type:"boolean",group:"Appearance",defaultValue:false},requiredAtBegin:{type:"boolean",group:"Misc",defaultValue:null}},associations:{labelFor:{type:"sap.ui.core.Control",multiple:false}}}});
e.prototype.onAfterRendering=function(){var f=this._getLabeledControl();if(f){if(this.getTooltip_AsString()==""||!(this.getTooltip()instanceof sap.ui.core.TooltipBase)){if(f.getTooltip()instanceof sap.ui.core.TooltipBase){this.oForTooltip=f.getTooltip();this.addDelegate(this.oForTooltip);}}this._oFor=f;}};
e.prototype.onBeforeRendering=function(){if(this.oForTooltip){this.removeDelegate(this.oForTooltip);this.oForTooltip=null;}if(this._oFor){this._oFor=undefined;}};
e.prototype.exit=function(){if(this.oForTooltip){this.removeDelegate(this.oForTooltip);this.oForTooltip=null;}if(this._oFor){this._oFor=undefined;}};
e.prototype.setReqiuredAtBegin=function(r){return this.setRequiredAtBegin(r);};
e.prototype.getReqiuredAtBegin=function(){return this.getRequiredAtBegin();};
e.prototype._getLabeledControl=function(){var i=this.getLabelForRendering();if(!i){return null;}return sap.ui.getCore().byId(i);};
e.prototype.getAccessibilityInfo=function(){return{description:this.getText()};};
L.enrich(e.prototype);return e;});
sap.ui.predefine('sap/ui/commons/LabelRenderer',['sap/ui/core/Renderer','sap/ui/core/LabelEnablement','sap/ui/commons/library','sap/ui/core/library'],function(R,L,l,c){"use strict";var T=c.TextDirection;var a=l.LabelDesign;var b={};
b.render=function(r,o){r.write("<label");r.writeControlData(o);L.writeLabelForAttribute(r,o);var f=o._getLabeledControl();var t=o.getTooltip_AsString();if((!t||t=="")&&f&&f.getTooltip_AsString()&&f.getTooltip_AsString()!=""){t=f.getTooltip_AsString();}if(o.isRequired()){r.addClass('sapUiLblReq');if(o.getRequiredAtBegin()){r.addClass('sapUiLblReqBeg');}else{r.addClass('sapUiLblReqEnd');}}if(t){r.writeAttributeEscaped('title',t);}r.addClass("sapUiLbl");if(o.getDesign()==a.Bold){r.addClass("sapUiLblEmph");}var s=o.getTextDirection();if(s){r.addStyle("direction",s.toLowerCase());}var d=b.getTextAlign(o.getTextAlign(),s);if(d){r.addStyle("text-align",d);}var w=o.getWidth();if(w){r.addStyle("width",w);}if(!o.isWrapping()){r.addClass("sapUiLblNowrap");}r.writeStyles();r.writeClasses();r.write(">");if(o.getIcon()){this.writeImgHtml(r,o);}if(o.getText()){r.writeEscaped(o.getText());}r.write("</label>");};
b.writeImgHtml=function(r,o){var i=o.getIcon();var C=r.getConfiguration();var d=[];var A={"title":null};d.push("sapUiLblIco");if((o.getTextDirection()==T.RTL&&!C.getRTL())||(o.getTextDirection()==T.LTR&&C.getRTL())){d.push("sapUiLblIcoR");}else{d.push("sapUiLblIcoL");}r.writeIcon(i,d,A);};
b.getTextAlign=R.getTextAlign;return b;},true);
sap.ui.predefine('sap/ui/commons/Link',['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/LabelEnablement','./LinkRenderer'],function(l,C,E,L,a){"use strict";
var b=C.extend("sap.ui.commons.Link",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.commons.FormattedTextViewControl","sap.ui.core.IFormContent"],library:"sap.ui.commons",properties:{text:{type:"string",group:"Appearance",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},helpId:{type:"string",group:"Behavior",defaultValue:''},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{allowPreventDefault:true}}}});
E.call(b.prototype);
b.prototype.onBeforeRendering=function(){this.removeAssociation("ariaLabelledBy",this.getId(),true);if(this.getAriaLabelledBy().length>0||L.getReferencingLabels(this).length>0){this.addAssociation("ariaLabelledBy",this.getId(),true);}};
b.prototype.onsapspace=function(e){b.prototype.onclick.apply(this,arguments);};
b.prototype.onclick=function(e){if(this.getEnabled()){if(!this.firePress()||!this.getHref()){e.preventDefault();}}else{e.preventDefault();}};
b.prototype.onsapenter=function(e){e.stopPropagation();};
b.prototype.getAccessibilityInfo=function(){return{role:"link",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_LINK"),description:this.getText()||this.getHref()||"",focusable:this.getEnabled(),enabled:this.getEnabled()};};
return b;});
sap.ui.predefine('sap/ui/commons/LinkRenderer',[],function(){"use strict";var L={};
L.render=function(r,l){r.write("<a");r.writeControlData(l);r.writeAccessibilityState(l);if(!l.getEnabled()){r.addClass("sapUiLnkDsbl");r.writeAttribute("disabled","true");}else{r.addClass("sapUiLnk");}r.writeClasses();if(l.getTooltip_AsString()){r.writeAttributeEscaped("title",l.getTooltip_AsString());}if(l.getHref()){r.writeAttributeEscaped("href",l.getHref());}else{r.writeAttribute("href","#");}if(l.getTarget()){r.writeAttributeEscaped("target",l.getTarget());}if(!l.getEnabled()){r.writeAttribute("tabindex","-1");}else{r.writeAttribute("tabindex","0");}if(l.getWidth()){r.addStyle("width",l.getWidth());}r.writeStyles();r.write(">");if(l.getText()){r.writeEscaped(l.getText());}r.write("</a>");};
return L;},true);
sap.ui.predefine('sap/ui/commons/ListBox',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./ListBoxRenderer','sap/ui/core/library','sap/ui/Device'],function(q,a,C,I,L,c,D){"use strict";var T=c.TextAlign;
var b=C.extend("sap.ui.commons.ListBox",{metadata:{library:"sap.ui.commons",properties:{editable:{type:"boolean",group:"Behavior",defaultValue:true},enabled:{type:"boolean",group:"Behavior",defaultValue:true},allowMultiSelect:{type:"boolean",group:"Behavior",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},scrollTop:{type:"int",group:"Behavior",defaultValue:-1},displayIcons:{type:"boolean",group:"Behavior",defaultValue:false},displaySecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},valueTextAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},secondaryValueTextAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},visibleItems:{type:"int",group:"Dimension",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{id:{type:"string"},selectedIndex:{type:"int"},selectedItem:{type:"sap.ui.core.Item"},selectedIndices:{type:"int[]"}}}}}});
b.prototype.init=function(){this.allowTextSelection(false);if(!this._bHeightInItems){this._bHeightInItems=false;this._iVisibleItems=-1;}this._sTotalHeight=null;if(b._fItemHeight===undefined){b._fItemHeight=-1;}if(b._iBordersAndStuff===undefined){b._iBordersAndStuff=-1;}this._aSelectionMap=[];this._iLastDirectlySelectedIndex=-1;this._aActiveItems=null;};
b.prototype.onThemeChanged=function(){this._sTotalHeight=null;if(!this._bHeightInItems){this._iVisibleItems=-1;}this._skipStoreScrollTop=true;if(this.getDomRef()){this.invalidate();}};
b.prototype.onBeforeRendering=function(){if(this._skipStoreScrollTop){delete this._skipStoreScrollTop;return;}this.getScrollTop();};
b.prototype.onAfterRendering=function(){var d=this.getDomRef();if(b._fItemHeight<=0){var s=sap.ui.getCore().getStaticAreaRef();var e=document.createElement("div");e.id="sap-ui-commons-ListBox-sizeDummy";e.innerHTML='<div class="sapUiLbx sapUiLbxFlexWidth sapUiLbxStd"><ul><li class="sapUiLbxI"><span class="sapUiLbxITxt">&nbsp;</span></li></ul></div>';if(D.browser.safari){s.insertBefore(e,s.firstChild);}else{s.appendChild(e);}var o=e.firstChild.firstChild.firstChild;b._fItemHeight=o.offsetHeight;if(D.browser.msie&&(document.documentMode==9||document.documentMode==10)){var f=document.defaultView.getComputedStyle(o.firstChild,"");var h=parseFloat(f.getPropertyValue("height").split("px")[0]);if(!(typeof h==="number")||!(h>0)){h=q(o.firstChild).height();}var p=parseFloat(f.getPropertyValue("padding-top").split("px")[0]);var g=parseFloat(f.getPropertyValue("padding-bottom").split("px")[0]);var j=parseFloat(f.getPropertyValue("border-top-width").split("px")[0]);var k=parseFloat(f.getPropertyValue("border-bottom-width").split("px")[0]);b._fItemHeight=h+p+g+j+k;}s.removeChild(e);}if(b._iBordersAndStuff==-1){var $=q(this.getDomRef());var l=$.outerHeight();var m=$.height();b._iBordersAndStuff=l-m;}if(this._bHeightInItems){if(this._sTotalHeight==null){this._calcTotalHeight();d.style.height=this._sTotalHeight;}}if(this._iVisibleItems==-1){this._updatePageSize();}var F=this.getFocusDomRef(),r=F.childNodes,n=[],t=this.getItems();this._aActiveItems=[];var A=this._aActiveItems;for(var i=0;i<r.length;i++){if(!(t[i]instanceof sap.ui.core.SeparatorItem)){A[n.length]=i;n.push(r[i]);}}if(!this.oItemNavigation){var N=(!this.getEnabled()||!this.getEditable());this.oItemNavigation=new I(null,null,N);this.oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleAfterFocus,this);this.addDelegate(this.oItemNavigation);}this.oItemNavigation.setRootDomRef(F);this.oItemNavigation.setItemDomRefs(n);this.oItemNavigation.setCycling(false);this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(this.getSelectedIndex()));this.oItemNavigation.setPageSize(this._iVisibleItems);if(this.oScrollToIndexRequest){this.scrollToIndex(this.oScrollToIndexRequest.iIndex,this.oScrollToIndexRequest.bLazy);}else{var u=this.getProperty("scrollTop");if(u>-1){d.scrollTop=u;}}var v=this;window.setTimeout(function(){if(v.oScrollToIndexRequest){v.scrollToIndex(v.oScrollToIndexRequest.iIndex,v.oScrollToIndexRequest.bLazy);v.oScrollToIndexRequest=null;}else{var u=v.getProperty("scrollTop");if(u>-1){d.scrollTop=u;}}},0);};
b.prototype._getNavigationIndexForRealIndex=function(d){var e=this.getItems();var n=d;for(var i=0;i<d;i++){if(e[i]instanceof sap.ui.core.SeparatorItem){n--;}}return n;};
b.prototype._updatePageSize=function(){var d=this.getDomRef();if(d){if(b._fItemHeight>0){this._iVisibleItems=Math.floor(d.clientHeight/b._fItemHeight);}}};
b.prototype.scrollToIndex=function(i,l){var d=this.getDomRef();if(d){var o=this.$("list").children("li[data-sap-ui-lbx-index="+i+"]");o=o.get(0);if(o){var s=o.offsetTop;if(!l){this.setScrollTop(s);}else{var e=d.scrollTop;var v=q(d).height();if(e>=s){this.setScrollTop(s);}else if((s+b._fItemHeight)>(e+v)){this.setScrollTop(Math.ceil(s+b._fItemHeight-v));}}}this.getScrollTop();}else{this.oScrollToIndexRequest={iIndex:i,bLazy:l};}return this;};
b.prototype.getVisibleItems=function(){return this._iVisibleItems;};
b.prototype.setVisibleItems=function(i){this.setProperty("visibleItems",i,true);this._iVisibleItems=i;if(i<0){this._bHeightInItems=false;}else{this._bHeightInItems=true;}this._sTotalHeight=null;var d=this.getDomRef();if(d){if(this._bHeightInItems){var f=d.firstChild?d.firstChild.firstChild:null;if(f||((b._fItemHeight>0)&&(b._iBordersAndStuff>0))){d.style.height=this._calcTotalHeight();}else{this.invalidate();}}else{d.style.height=this.getHeight();this._updatePageSize();if(this.oItemNavigation){this.oItemNavigation.setPageSize(this._iVisibleItems);}}}return this;};
b.prototype._calcTotalHeight=function(){var d=this._iVisibleItems*b._fItemHeight;this._sTotalHeight=(d+b._iBordersAndStuff)+"px";return this._sTotalHeight;};
b.prototype.setHeight=function(h){this.validateProperty("height",h);if(this.getHeight()===h){return this;}this._bHeightInItems=false;this._iVisibleItems=-1;var d=this.getDomRef();if(d){d.style.height=h;this._updatePageSize();if(this.oItemNavigation){this.oItemNavigation.setPageSize(this._iVisibleItems);}}return this.setProperty("height",h,true);};
b.prototype.setWidth=function(w){var d=this.getDomRef();if(d){d.style.width=w;}this.setProperty("width",w,true);return this;};
b.prototype.setScrollTop=function(s){s=Math.round(s);var d=this.getDomRef();this.oScrollToIndexRequest=null;if(d){d.scrollTop=s;}this.setProperty("scrollTop",s,true);return this;};
b.prototype.getScrollTop=function(){var s=this.getDomRef();if(s){var d=Math.round(s.scrollTop);this.setProperty("scrollTop",d,true);return d;}else{return this.getProperty("scrollTop");}};
b.prototype.onmousedown=function(e){if(D.browser.webkit&&e.target&&e.target.id===this.getId()){var i=document.activeElement?document.activeElement.id:this.getId();var t=this;setTimeout(function(){var s=t.getDomRef().scrollTop;var f=i?document.getElementById(i):null;if(f){f.focus();}t.getDomRef().scrollTop=s;},0);}};
b.prototype.onclick=function(e){this._handleUserActivation(e);};
b.prototype.ontouchmove=function(e){e.setMarked();};
b.prototype.onsapspace=function(e){this._handleUserActivation(e);};
b.prototype.onsapspacemodifiers=b.prototype.onsapspace;b.prototype.onsapenter=b.prototype.onsapspace;b.prototype.onsapentermodifiers=b.prototype.onsapspace;
b.prototype._handleUserActivation=function(e){if(!this.getEnabled()||!this.getEditable()){return;}var s=e.target;if(s.id===""||(s.id&&s.id.endsWith("-txt"))){s=s.parentNode;if(s.id===""){s=s.parentNode;}}var d=q(s).attr("data-sap-ui-lbx-index");if(typeof d=="string"&&d.length>0){var i=parseInt(d);var f=this.getItems();var o=f[i];if(f.length<=i){i=f.length-1;}if(i>=0&&i<f.length){if(o.getEnabled()&&!(o instanceof sap.ui.core.SeparatorItem)){if(e.ctrlKey||e.metaKey){this._handleUserActivationCtrl(i,o);}else if(e.shiftKey){this.setSelectedIndices(this._getUserSelectionRange(i));this.fireSelect({id:this.getId(),selectedIndex:i,selectedIndices:this.getSelectedIndices(),selectedItem:o,sId:this.getId(),aSelectedIndices:this.getSelectedIndices()});this._iLastDirectlySelectedIndex=i;}else{this._handleUserActivationPlain(i,o);}}}e.preventDefault();e.stopPropagation();}};
b.prototype._handleUserActivationPlain=function(i,o){this._iLastDirectlySelectedIndex=i;this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(i));if(this.getSelectedIndex()!=i||this.getSelectedIndices().length>1){this.setSelectedIndex(i);this.fireSelect({id:this.getId(),selectedIndex:i,selectedIndices:this.getSelectedIndices(),selectedItem:o,sId:this.getId(),aSelectedIndices:this.getSelectedIndices()});}};
b.prototype._handleUserActivationCtrl=function(i,o){this._iLastDirectlySelectedIndex=i;this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(i));if(this.isIndexSelected(i)){this.removeSelectedIndex(i);}else{this.addSelectedIndex(i);}this.fireSelect({id:this.getId(),selectedIndex:i,selectedIndices:this.getSelectedIndices(),selectedItem:o,sId:this.getId(),aSelectedIndices:this.getSelectedIndices()});};
b.prototype._getUserSelectionRange=function(d){if(this._iLastDirectlySelectedIndex==-1){return[];}var e=this.getItems();var r=[];var i;if(this._iLastDirectlySelectedIndex<=d){for(i=this._iLastDirectlySelectedIndex;i<=d;i++){if((i>-1)&&(e[i].getEnabled()&&!(e[i]instanceof sap.ui.core.SeparatorItem))){r.push(i);}}}else{for(i=d;i<=this._iLastDirectlySelectedIndex;i++){if((i>-1)&&(e[i].getEnabled()&&!(e[i]instanceof sap.ui.core.SeparatorItem))){r.push(i);}}}return r;};
b.prototype.getSelectedIndex=function(){for(var i=0;i<this._aSelectionMap.length;i++){if(this._aSelectionMap[i]){return i;}}return-1;};
b.prototype.setSelectedIndex=function(s){if((s<-1)||(s>this._aSelectionMap.length-1)){return this;}var d=this.getItems();if((s>-1)&&(!d[s].getEnabled()||(d[s]instanceof sap.ui.core.SeparatorItem))){return this;}for(var i=0;i<this._aSelectionMap.length;i++){this._aSelectionMap[i]=false;}this._aSelectionMap[s]=true;if(this.oItemNavigation){this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(s));}this.getRenderer().handleSelectionChanged(this);return this;};
b.prototype.addSelectedIndex=function(s){if(!this.getAllowMultiSelect()){this.setSelectedIndex(s);}if((s<-1)||(s>this._aSelectionMap.length-1)){return this;}var i=this.getItems();if((s>-1)&&(!i[s].getEnabled()||(i[s]instanceof sap.ui.core.SeparatorItem))){return this;}if(this._aSelectionMap[s]){return this;}this._aSelectionMap[s]=true;this.getRenderer().handleSelectionChanged(this);return this;};
b.prototype.removeSelectedIndex=function(i){if((i<0)||(i>this._aSelectionMap.length-1)){return this;}if(!this._aSelectionMap[i]){return this;}this._aSelectionMap[i]=false;this.getRenderer().handleSelectionChanged(this);return this;};
b.prototype.clearSelection=function(){for(var i=0;i<this._aSelectionMap.length;i++){if(this._aSelectionMap[i]){this._aSelectionMap[i]=false;}}this._iLastDirectlySelectedIndex=-1;if(this.oItemNavigation){this.oItemNavigation.setSelectedIndex(-1);}this.getRenderer().handleSelectionChanged(this);return this;};
b.prototype.getSelectedIndices=function(){var r=[];for(var i=0;i<this._aSelectionMap.length;i++){if(this._aSelectionMap[i]){r.push(i);}}return r;};
b.prototype.setSelectedIndices=function(s){var d=[];var e=this.getItems();var i;for(i=0;i<s.length;i++){if((s[i]>-1)&&(s[i]<this._aSelectionMap.length)){if(e[s[i]].getEnabled()&&!(e[s[i]]instanceof sap.ui.core.SeparatorItem)){d.push(s[i]);}}}if(d.length>0){if(!this.getAllowMultiSelect()){d=[d[0]];}}for(i=0;i<this._aSelectionMap.length;i++){this._aSelectionMap[i]=false;}for(i=0;i<d.length;i++){this._aSelectionMap[d[i]]=true;}this.getRenderer().handleSelectionChanged(this);return this;};
b.prototype.addSelectedIndices=function(s){var d=[];var e=this.getItems();var i;for(i=0;i<s.length;i++){if((s[i]>-1)&&(s[i]<this._aSelectionMap.length)){if(e[s[i]].getEnabled()&&!(e[s[i]]instanceof sap.ui.core.SeparatorItem)){d.push(s[i]);}}}if(d.length>0){if(!this.getAllowMultiSelect()){d=[d[0]];}for(i=0;i<d.length;i++){this._aSelectionMap[d[i]]=true;}this.getRenderer().handleSelectionChanged(this);}return this;};
b.prototype.isIndexSelected=function(i){if((i<-1)||(i>this._aSelectionMap.length-1)){return false;}return this._aSelectionMap[i];};
b.prototype.setSelectedKeys=function(s){var d=this.getItems();var k={};for(var i=0;i<s.length;i++){k[s[i]]=true;}var e=[];for(var j=0;j<d.length;j++){if(k[d[j].getKey()]){e.push(j);}}return this.setSelectedIndices(e);};
b.prototype.getSelectedKeys=function(){var d=this.getItems();var r=[];for(var i=0;i<this._aSelectionMap.length;i++){if(this._aSelectionMap[i]){r.push(d[i].getKey());}}return r;};
b.prototype.getSelectedItem=function(){var i=this.getSelectedIndex();if((i<0)||(i>=this._aSelectionMap.length)){return null;}return this.getItems()[i];};
b.prototype.getSelectedItems=function(){var d=this.getItems();var r=[];for(var i=0;i<this._aSelectionMap.length;i++){if(this._aSelectionMap[i]){r.push(d[i]);}}return r;};
b.prototype.setAllowMultiSelect=function(A){this.setProperty("allowMultiSelect",A);var o=false;var t=false;if(!A&&this._aSelectionMap){for(var i=0;i<this._aSelectionMap.length;i++){if(this._aSelectionMap[i]){if(!o){o=true;}else{this._aSelectionMap[i]=false;t=true;}}}}if(t){this.getRenderer().handleSelectionChanged(this);}return this;};
b.prototype._handleAfterFocus=function(o){var i=o.getParameter("index");i=((i!==undefined&&i>=0)?this._aActiveItems[i]:0);this.getRenderer().handleARIAActivedescendant(this,i);};
b.prototype.setItems=function(d,e,n){this._bNoItemsChangeEvent=true;if(e){this.destroyItems();}else{this.removeAllItems();}for(var i=0,l=d.length;i<l;i++){this.addItem(d[i]);}this._bNoItemsChangeEvent=undefined;if(!n){this.fireEvent("itemsChanged",{event:"setItems",items:d});}return this;};
b.prototype.addItem=function(i){this._bNoItemInvalidateEvent=true;this.addAggregation("items",i);this._bNoItemInvalidateEvent=false;if(!this._aSelectionMap){this._aSelectionMap=[];}this._aSelectionMap.push(false);if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"addItem",item:i});}i.attachEvent("_change",this._handleItemChanged,this);return this;};
b.prototype.insertItem=function(i,d){if((d<0)||(d>this._aSelectionMap.length)){return this;}this._bNoItemInvalidateEvent=true;this.insertAggregation("items",i,d);this._bNoItemInvalidateEvent=false;this._aSelectionMap.splice(d,0,false);this.invalidate();if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"insertItems",item:i,index:d});}i.attachEvent("_change",this._handleItemChanged,this);return this;};
b.prototype.removeItem=function(e){var i=e;if(typeof(e)=="string"){e=sap.ui.getCore().byId(e);}if(typeof(e)=="object"){i=this.indexOfItem(e);}if((i<0)||(i>this._aSelectionMap.length-1)){if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"removeItem",item:e});}return undefined;}this._bNoItemInvalidateEvent=true;var r=this.removeAggregation("items",i);this._bNoItemInvalidateEvent=false;this._aSelectionMap.splice(i,1);this.invalidate();if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"removeItem",item:r});}r.detachEvent("_change",this._handleItemChanged,this);return r;};
b.prototype.removeAllItems=function(){this._bNoItemInvalidateEvent=true;var r=this.removeAllAggregation("items");this._bNoItemInvalidateEvent=false;this._aSelectionMap=[];this.invalidate();if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"removeAllItems"});}for(var i=0;i<r.length;i++){r[i].detachEvent("_change",this._handleItemChanged,this);}return r;};
b.prototype.destroyItems=function(){var d=this.getItems();for(var i=0;i<d.length;i++){d[i].detachEvent("_change",this._handleItemChanged,this);}this._bNoItemInvalidateEvent=true;var e=this.destroyAggregation("items");this._bNoItemInvalidateEvent=false;this._aSelectionMap=[];this.invalidate();if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"destroyItems"});}return e;};
b.prototype.updateItems=function(){this._bNoItemsChangeEvent=true;this.updateAggregation("items");this._bNoItemInvalidateEvent=true;if(!this._bItemsChangedAfterUpdate){this._bItemsChangedAfterUpdate=setTimeout(function(){this._itemsChangedAfterUpdate();}.bind(this),0);}};
b.prototype._itemsChangedAfterUpdate=function(){this._bNoItemsChangeEvent=undefined;this._bItemsChangedAfterUpdate=undefined;this._bNoItemInvalidateEvent=undefined;this.fireEvent("itemsChanged",{event:"updateItems"});};
b.prototype.exit=function(){if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation;}if(this._bItemsChangedAfterUpdate){clearTimeout(this._bItemsChangedAfterUpdate);this._bItemsChangedAfterUpdate=undefined;this._bNoItemsChangeEvent=undefined;this._bNoItemInvalidateEvent=undefined;}};
b.prototype.getFocusDomRef=function(){return this.getDomRef("list");};
b.prototype.getIdForLabel=function(){return this.getId()+'-list';};
b.prototype._handleItemChanged=function(e){if(!this._bNoItemInvalidateEvent){this.fireEvent("itemInvalidated",{item:e.oSource});}};
return b;});
sap.ui.predefine('sap/ui/commons/ListBoxRenderer',['sap/ui/thirdparty/jquery','sap/base/security/encodeXML','sap/ui/core/Renderer','sap/ui/core/IconPool','sap/ui/Device'],function(q,e,R,I,D){"use strict";var L={};
L.render=function(r,l){if(L.borderWidths===undefined){if(D.browser.msie){var f=document.createElement("div");var s=sap.ui.getCore().getStaticAreaRef();s.appendChild(f);f.className="sapUiLbx";var $=q(f);$.css("width","50px");$.css("min-width","100px");L.borderWidths=f.offsetWidth-100;s.removeChild(f);}else{L.borderWidths=0;}}r.addClass("sapUiLbx");var S=true;if(!l.getEditable()){r.addClass("sapUiLbxRo");S=false;}if(!l.getEnabled()){r.addClass("sapUiLbxDis");S=false;}if(S){r.addClass("sapUiLbxStd");}r.write("<div");r.writeControlData(l);r.writeAttribute("tabindex","-1");var w=l.getWidth();if(w){r.addStyle("width",w);var d=l.getDisplaySecondaryValues();var b=l.getDisplayIcons();if(!d&&!b){r.addClass("sapUiLbxFixed");}}if(!w||(w=="auto")||(w=="inherit")){r.addClass("sapUiLbxFlexWidth");}r.writeClasses();var m=l.getMinWidth();var M=l.getMaxWidth();if(D.browser.msie){m=L.fixWidth(m);M=L.fixWidth(M);}if(m){r.addStyle("min-width",m);}if(M){r.addStyle("max-width",M);}if(l._bHeightInItems){if(l._sTotalHeight!=null){r.addStyle("height",l._sTotalHeight);}}else{var h=l.getHeight();if(h){r.addStyle("height",h);}}r.writeStyles();var t=l.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");this.renderItemList(l,r);r.write("</div>");};
L.renderItemList=function(l,r){r.write("<ul id='"+l.getId()+"-list'");r.writeAttribute("tabindex",this.getTabIndex(l));r.writeAccessibilityState(l,{role:"listbox",multiselectable:l.getAllowMultiSelect()});r.write(">");var a=l.getItems(),b=0,c=0;var i;for(i=0;i<a.length;i++){if(!(a[i]instanceof sap.ui.core.SeparatorItem)){c++;}}var d=l.getDisplaySecondaryValues();for(i=0;i<a.length;i++){var f=a[i];if(f instanceof sap.ui.core.SeparatorItem){r.write("<div id='",f.getId(),"' class='sapUiLbxSep' role='separator'><hr/>");if(l.getDisplayIcons()){r.write("<hr/>");}if(d){r.write("<hr/>");}r.write("</div>");}else{r.write("<li");r.writeElementData(f);r.writeAttribute("data-sap-ui-lbx-index",i);r.addClass("sapUiLbxI");if(!f.getEnabled()){r.addClass("sapUiLbxIDis");}r.writeAttribute("tabindex","-1");if(l.isIndexSelected(i)){r.addClass("sapUiLbxISel");}r.writeClasses();var t=f.getText();var s=f.getAdditionalText?f.getAdditionalText():"";if(f.getTooltip_AsString()){r.writeAttributeEscaped("title",f.getTooltip_AsString());}else{r.writeAttributeEscaped("title",t+((d&&s)?"  --  "+s:""));}r.writeAccessibilityState(f,{role:"option",selected:(i===l.getSelectedIndex()),setsize:c,posinset:b+1});r.write(">");if(l.getDisplayIcons()){var g;if(f.getIcon){g=f.getIcon();}r.write("<span");if(I.isIconURI(g)){r.addClass("sapUiLbxIIco");r.addClass("sapUiLbxIIcoFont");var o=I.getIconInfo(g);r.addStyle("font-family","'"+e(o.fontFamily)+"'");if(o&&!o.skipMirroring){r.addClass("sapUiIconMirrorInRTL");}r.writeClasses();r.writeStyles();r.write(">");r.writeEscaped(o.content);}else{r.write(" class='sapUiLbxIIco'><img src='");if(g){r.writeEscaped(g);}else{r.write(sap.ui.resource('sap.ui.commons','img/1x1.gif'));}r.write("'/>");}r.write("</span>");}r.write("<span class='sapUiLbxITxt");r.write("'");r.writeAttribute("id",f.getId()+"-txt");var v=L.getTextAlign(l.getValueTextAlign(),null);if(v){r.write("style='text-align:"+v+"'");}r.write(">");if(t===""||t===null){r.write("&nbsp;");}else{r.writeEscaped(t);}if(d){r.write("</span><span class='sapUiLbxISec");r.write("'");var S=L.getTextAlign(l.getSecondaryValueTextAlign(),null);if(S){r.write("style='text-align:"+S+"'");}r.write(">");r.writeEscaped(s);}r.write("</span></li>");b++;}}r.write("</ul>");};
L.fixWidth=function(c){if(L.borderWidths>0){if(/px$/i.test(c)){var w=parseInt(c.substr(0,c.length-2));var n=w-L.borderWidths;if(n>=0){return n+"px";}}}return c;};
L.getTabIndex=function(l){if(l.getEnabled()&&l.getEditable()){return 0;}else{return-1;}};
L.handleSelectionChanged=function(o){if(o.getDomRef()){var a=o.getItems();for(var i=0,l=a.length;i<l;i++){if(o.isIndexSelected(i)){a[i].$().addClass("sapUiLbxISel").attr("aria-selected","true");}else{a[i].$().removeClass("sapUiLbxISel").attr("aria-selected","false");}}}};
L.handleARIAActivedescendant=function(l,i){var $=l.$("list");if($.length>0){var a=$.children("li[data-sap-ui-lbx-index="+i+"]");$.attr("aria-activedescendant",a.attr("id"));}};
L.getTextAlign=R.getTextAlign;return L;},true);
sap.ui.predefine('sap/ui/commons/Menu',['./MenuItemBase','./library','sap/ui/unified/Menu','./MenuRenderer'],function(M,l,U,a){"use strict";
var b=U.extend("sap.ui.commons.Menu",{metadata:{deprecated:true,library:"sap.ui.commons"}});
b.prototype.bCozySupported=false;return b;});
sap.ui.predefine('sap/ui/commons/MenuBar',['sap/ui/thirdparty/jquery','./Menu','./MenuItem','./MenuItemBase','./library','sap/ui/core/Control','./MenuBarRenderer','sap/ui/core/ResizeHandler','sap/ui/core/Popup','sap/ui/events/checkMouseEnterOrLeave','sap/ui/events/KeyCodes'],function(q,M,a,b,l,C,c,R,P,d,K){"use strict";var D=P.Dock;var e=l.MenuBarDesign;
var f=C.extend("sap.ui.commons.MenuBar",{metadata:{library:"sap.ui.commons",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},design:{type:"sap.ui.commons.MenuBarDesign",group:"Appearance",defaultValue:e.Standard}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.unified.MenuItem",multiple:true,singularName:"item"}}}});
var _=a.extend("sap.ui.commons._DelegatorMenuItem",{
constructor:function(A){a.apply(this);this.oAlterEgoItm=A;this.bNoSubMenu=true;var s=this.oAlterEgoItm.getSubmenu();if(s){var t=this;s.getRootMenu=function(){return t.getParent();};this.bNoSubMenu=false;}},
exit:function(){if(!this.bNoSubMenu){this.oAlterEgoItm.getSubmenu().getRootMenu=M.prototype.getRootMenu;}this.bNoSubMenu=true;this.oAlterEgoItm=null;},
getText:function(){return this.oAlterEgoItm.getText();},
getIcon:function(){return this.oAlterEgoItm.getIcon();},
getEnabled:function(){return this.oAlterEgoItm.getEnabled();},
getVisible:function(){return this.oAlterEgoItm.getVisible();},
getSubmenu:function(){return this.oAlterEgoItm.getSubmenu();}
});
f.prototype.init=function(){this.oOvrFlwMnu=null;this.sCurrentFocusedItemRefId=null;this.data("sap-ui-fastnavgroup","true",true);};
f.prototype.exit=function(){if(this.oOvrFlwMnu){this.oOvrFlwMnu.destroy();}this.oOvrFlwMnu=null;if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
f.prototype.doBeforeRendering=function(){var I=this.getItems();for(var i=0;i<I.length;i++){var m=I[i].getSubmenu();if(m){m.setRootMenuTopStyle(this.getDesign()==e.Header);}}if(this.oOvrFlwMnu){this.oOvrFlwMnu.setRootMenuTopStyle(this.getDesign()==e.Header);}if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
f.prototype.onAfterRendering=function(){this.sResizeListenerId=R.register(this.getDomRef(),q.proxy(this.onresize,this));this.onresize();};
f.prototype.onresize=function(E){u(this);};
f.prototype.onfocusin=function(E){var i=this.getId();var t=q(E.target);var T=t.attr("id");if(!T||T==i||T==i+"-area"){var I=this.$("area").children();this.sCurrentFocusedItemRefId=I.length==0?null:q(I.get(0)).attr("id");}else{this.sCurrentFocusedItemRefId=T;}var F=this.sCurrentFocusedItemRefId?document.getElementById(this.sCurrentFocusedItemRefId):null;if(F){F.focus();}this.$().attr("tabindex","-1");};
f.prototype.onfocusout=function(E){this.$().attr("tabindex","0");};
f.prototype.onmousedown=function(E){var m=h(this,E);if(m==="ovrflw"){this._bOvrFlwMnuSkipOpen=this.oOvrFlwMnu&&this.oOvrFlwMnu.bOpen;}else if(m){var i=m.getSubmenu();m._bSkipOpen=i&&i.bOpen;}};
f.prototype.onmouseout=function(E){var m=h(this,E);if(m==="ovrflw"){var r=g(this,E);if(this._bOvrFlwMnuSkipOpen&&d(E,r[0])){this._bOvrFlwMnuSkipOpen=false;}}else if(m){var r=g(this,E);if(m._bSkipOpen&&d(E,r[0])){m._bSkipOpen=false;}}};
f.prototype.onclick=function(E){o(this,E,false);};
f.prototype.onsapselect=function(E){o(this,E,true);};
f.prototype.onsapdown=function(E){o(this,E,true);};
f.prototype.onsapdownmodifiers=function(E){if(E.altKey){o(this,E,true);}};
f.prototype.onsapprevious=function(E){if(E.keyCode!=K.ARROW_UP){k(this,E,"prev");}};
f.prototype.onsapnext=function(E){if(E.keyCode!=K.ARROW_DOWN){k(this,E,"next");}};
f.prototype.onsaphome=function(E){k(this,E,"first");};
f.prototype.onsapend=function(E){k(this,E,"last");};
var o=function(t,E,w){E.preventDefault();E.stopPropagation();if(t.getEnabled()){var m=h(t,E);if(m==="ovrflw"){var r=g(t,E);if(t.oOvrFlwMnu&&!t._bOvrFlwMnuSkipOpen){var n=D;t.oOvrFlwMnu.open(w,r.get(0),n.EndTop,n.EndBottom,r.get(0));}}else if(m){if(m.getEnabled()){var r=g(t,E);var p=m.getSubmenu();if(p&&!m._bSkipOpen){var n=D;p.open(w,r.get(0),n.BeginTop,n.BeginBottom,r.get(0));}else if(!p){m.fireSelect({item:m});}}}}t._bOvrFlwMnuSkipOpen=false;var I=t.getItems();for(var i=0;i<I.length;i++){I[i]._bSkipOpen=false;}};var g=function(t,E){var r=q(E.target);if(!r.attr("itemidx")){r=r.parent();}return r.attr("itemidx")?r:null;};var h=function(t,E){var r=g(t,E);if(r){var i=r.attr("itemidx");if(i){if(i=="ovrflw"){return"ovrflw";}else{var I=parseInt(i);var m=t.getItems()[I];return m;}}}return null;};var j=function(t){var v=0;var A=t.$("area");var i=A.children();var r=sap.ui.getCore().getConfiguration().getRTL();var m=(r?100000:0);i.each(function(I){if(I==0){return true;}var n=this.offsetLeft;var L=(r?(n>=m):(n<=m));if(L){v=I;return false;}else if(q(this).attr("id")==t.getId()+"-ovrflw"){v=I;return false;}else{m=n;return true;}});return v;};var u=function(t){var v=j(t);var m=v;var A=t.$("area");var I=A.children();var O=t.$("ovrflw");var U=false;if(v<I.length-1){O.attr("style","display:block;");if(!t.oOvrFlwMnu){t.oOvrFlwMnu=new M(t.getId()+"-ovrflwmnu");t.oOvrFlwMnu.bUseTopStyle=t.getDesign()==e.Header;t.oOvrFlwMnu.attachItemSelect(function(E){var p=E.getParameter("item");if(!(p instanceof _)){var r=M.prototype.getRootMenu.apply(p.getParent());r.fireItemSelect({item:p});}else if(p.bNoSubMenu&&p instanceof _){p.oAlterEgoItm.fireSelect({item:p.oAlterEgoItm});}});}t.oOvrFlwMnu.destroyItems();var n=t.getItems();for(var i=0;i<n.length;i++){var p=n[i];if(v!=0){if(p.getVisible()){v--;}if(v==0){t.sLastVisibleItemId=p.getId();}}else{t.oOvrFlwMnu.addItem(new _(p));if(p.getId()==t.sCurrentFocusedItemRefId){U=true;}}}if(sap.ui.getCore().getConfiguration().getAccessibility()){I.attr("aria-setsize",m+1);O.attr("aria-posinset",m+1);}}else{O.attr("style","display:none;");if(t.oOvrFlwMnu){t.oOvrFlwMnu.destroyItems();}t.sLastVisibleItemId=null;if(sap.ui.getCore().getConfiguration().getAccessibility()){I.attr("aria-setsize",m);O.attr("aria-posinset",0);}}A.scrollTop(0);if(U){t.sCurrentFocusedItemRefId=t.sLastVisibleItemId;document.getElementById(t.sLastVisibleItemId).focus();}};var k=function(t,E,s){E.stopPropagation();E.preventDefault();if(!t.sCurrentFocusedItemRefId){return;}var F=null;if(t.sLastVisibleItemId&&((t.sCurrentFocusedItemRefId==t.sLastVisibleItemId&&s=="next")||s=="last")){F=t.getId()+"-ovrflw";}else if(t.sLastVisibleItemId&&t.sCurrentFocusedItemRefId==t.getId()+"-ovrflw"&&s=="prev"){F=t.sLastVisibleItemId;}else{var i=s+"All";var I=false;if(s=="first"){i="prevAll";I=true;}else if(s=="last"){i="nextAll";I=true;}var m=q(document.getElementById(t.sCurrentFocusedItemRefId));var n=m[i](":visible");F=q(n.get(I?n.length-1:0)).attr("id");}if(F){t.sCurrentFocusedItemRefId=F;document.getElementById(F).focus();}};return f;});
sap.ui.predefine('sap/ui/commons/MenuBarRenderer',['sap/ui/commons/library'],function(l){"use strict";var M=l.MenuBarDesign;var a={};
a.render=function(r,m){m.doBeforeRendering();r.write("<div");r.writeControlData(m);r.addClass("sapUiMnuBar");if(m.getDesign()==M.Header){r.addClass("sapUiMnuBarHeader");}var I=!m.getEnabled();if(I){r.addClass("sapUiMnuBarDsbl");}r.addStyle("width",m.getWidth());r.writeStyles();r.writeClasses();r.writeAttribute("tabindex","0");var t=m.getTooltip_AsString();a.writeAria(r,"menubar",t,I);r.write("><ul");r.writeAttribute("id",m.getId()+"-area");r.writeAttribute("class","sapUiMnuBarArea");r.write(">");var v=0;var b=m.getItems();for(var i=0;i<b.length;i++){var o=b[i];if(o.getVisible()){v++;r.write("<li");r.writeElementData(o);r.addClass("sapUiMnuBarItm");var d=!o.getEnabled()||I;if(d){r.addClass("sapUiMnuBarItmDsbl");}r.writeClasses();r.writeAttribute("itemidx",""+i);var t=o.getTooltip_AsString();a.writeAria(r,"menuitem",t,d,v,!!o.getSubmenu());r.writeAttribute("tabindex","-1");r.write("><span>");r.writeEscaped(o.getText());r.write("</span></li>");}}r.write("<li");r.writeAttribute("id",m.getId()+"-ovrflw");r.writeAttribute("itemidx","ovrflw");r.writeAttribute("style","display:none;");r.writeAttribute("tabindex","-1");r.addClass("sapUiMnuBarItm");r.addClass("sapUiMnuBarOvrFlw");if(d){r.addClass("sapUiMnuBarItmDsbl");}r.writeClasses();var c=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var O;if(c){O=c.getText("MNUBAR_OVRFLW");}a.writeAria(r,"menuitem",O,false,0,true);r.write("><span></span></li></ul></div>");};
a.writeAria=function(r,R,t,d,i,h){if(t){r.writeAttributeEscaped("title",t);}if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}r.writeAttribute("role",R);if(R=="menuitem"){if(h){r.writeAttribute("aria-haspopup",true);}r.writeAttribute("aria-posinset",i);}if(d){r.writeAttribute("aria-disabled",true);}};
return a;},true);
sap.ui.predefine('sap/ui/commons/MenuButton',['./Button','./Menu','./MenuItemBase','./library','./MenuButtonRenderer','sap/ui/core/Popup','sap/ui/events/checkMouseEnterOrLeave'],function(B,M,a,l,b,P,c){"use strict";var D=P.Dock;
var d=B.extend("sap.ui.commons.MenuButton",{metadata:{library:"sap.ui.commons",properties:{dockButton:{type:"string",group:"Misc",defaultValue:null},dockMenu:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"menu",aggregations:{menu:{type:"sap.ui.unified.Menu",multiple:false}},events:{itemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
d.prototype.init=function(){this.addStyleClass("sapUiMenuButton");this.bWithKeyboard=false;};
d.prototype.onclick=function(e){if(this.getEnabled()&&!this._bSkipOpen){var t=this.getTooltip();if(t&&t instanceof sap.ui.core.TooltipBase){t._closeOrPreventOpen();}var s=this.getDockButton()?this.getDockButton():D.BeginBottom;var f=this.getDockMenu()?this.getDockMenu():D.BeginTop;this.getMenu().open(this.bWithKeyboard,this,f,s,this);}this.bWithKeyboard=false;this._bSkipOpen=false;e.preventDefault();e.stopPropagation();};
d.prototype.onmousedown=function(e){this.handleMouseDown(e,false);this._bSkipOpen=this.getMenu()&&this.getMenu().bOpen;};
d.prototype.onmouseout=function(e){if(B.prototype.onmouseout){B.prototype.onmouseout.apply(this,arguments);}if(this._bSkipOpen&&c(e,this.getDomRef())){this._bSkipOpen=false;}};
d.prototype.onsapenter=function(e){this.bWithKeyboard=true;};
d.prototype.onsapspace=function(e){this.bWithKeyboard=true;};
d.prototype.onsapdownmodifiers=function(e){if(e.altKey){this.bWithKeyboard=true;this.onclick(e);}};
d.prototype.clone=function(i,L){u(this);var C=B.prototype.clone.apply(this,arguments);u(this,this.getMenu());return C;};
d.prototype.setMenu=function(m){u(this,m);this.setAggregation("menu",m);return this;};
d.prototype.destroyMenu=function(){u(this,null);this.destroyAggregation("menu");return this;};
var u=function(t,n){var m=t.getMenu();if(m){m.detachItemSelect(t._fItemSelectHandler);}t._fItemSelectHandler=o.bind(t);if(n){n.attachItemSelect(t._fItemSelectHandler);}};var o=function(e){var i=e.getParameter("item");this.fireItemSelected({itemId:i.getId(),item:i});this.firePress({itemId:i.getId(),item:i});};return d;});
sap.ui.predefine('sap/ui/commons/MenuButtonRenderer',['./ButtonRenderer','sap/ui/core/Renderer'],function(B,R){"use strict";var M=R.extend(B);
M.renderButtonAttributes=function(r,c){if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("aria-haspopup","true");}};
M.renderButtonContentAfter=function(r,c){r.write("<span class=\"sapUiMenuButtonIco\"></span>");};
return M;},true);
sap.ui.predefine('sap/ui/commons/MenuItem',['./MenuItemBase','./library','sap/ui/unified/MenuItem'],function(M,l,U){"use strict";
var a=U.extend("sap.ui.commons.MenuItem",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return a;});
sap.ui.predefine('sap/ui/commons/MenuItemBase',['sap/base/Log','sap/ui/core/Core'],function(L,C){"use strict";try{sap.ui.getCore().loadLibrary("sap.ui.unified");}catch(e){L.error("The controls/elements 'sap.ui.commons.Menu*' needs library 'sap.ui.unified'.");throw(e);}jQuery.sap.require("sap.ui.unified.MenuItemBase");return sap.ui.require("sap/ui/unified/MenuItemBase");},true);
sap.ui.predefine('sap/ui/commons/MenuRenderer',['sap/ui/core/Renderer','sap/ui/unified/MenuRenderer'],function(R,U){"use strict";var M=R.extend(U);return M;},true);
sap.ui.predefine('sap/ui/commons/MenuTextFieldItem',['./MenuItemBase','./library','sap/ui/unified/MenuTextFieldItem'],function(M,l,U){"use strict";
var a=U.extend("sap.ui.commons.MenuTextFieldItem",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return a;});
sap.ui.predefine('sap/ui/commons/Message',['sap/ui/thirdparty/jquery','./Dialog','./library','sap/ui/core/Control','./MessageRenderer','./Button','sap/ui/dom/jquery/rect'],function(q,D,l,C,M,B){"use strict";
var a=C.extend("sap.ui.commons.Message",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{type:{type:"sap.ui.commons.MessageType",group:"Behavior",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},associatedElementId:{type:"string",group:"Data",defaultValue:null},design:{type:"string",group:"Misc",defaultValue:null}}}});
a.prototype.init=function(){this.isRTL=sap.ui.getCore().getConfiguration().getRTL();this.fnCallBack=null;this.oLink=null;this.oContainer=null;this.oDetails=null;this.oBtnOK=null;};
a.prototype.exit=function(){if(this.oLink){this.oLink.destroy();this.oLink=null;}if(this.oDetails){this.oDetails.destroy();this.oDetails=null;}if(this.oContainer){this.oContainer.destroy();this.oContainer=null;}if(this.oBtnOK){this.oBtnOK.destroy();this.oBtnOK=null;}};
a.closeDetails=function(c){c.getSource().getParent().close();};
a.prototype.closeDetails=function(){if(this.oContainer){this.oContainer.close();}};
a.prototype.openDetails=function(){if(!this.oContainer){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var O=r.getText("MSGBAR_DETAILS_DIALOG_CLOSE");var t=r.getText("MSGBAR_DETAILS_DIALOG_TITLE");var h=this.fnCallBack(this.getId());this.oDetails=new a({type:this.getType(),text:h});this.oBtnOK=new B({text:O,press:a.closeDetails});this.oContainer=new D();this.oContainer.addContent(this.oDetails);this.oContainer.setTitle(t);this.oContainer.addButton(this.oBtnOK);}var c=this.oContainer.getId();var o=0;var b=q('.sapUiDlg');for(var i=b.length-1;i>=0;i--){if(q(b[i]).css('visibility')!="visible"){b.splice(i,1);}else if(b[i].id==c){b.splice(i,1);}else{o=Math.max(o,q(b[i]).css('zIndex'));}}var w=this.oContainer.isOpen();this.oContainer.open();var j=this.oContainer.$();var d=j.rect();if(b.length==0){if(this.isRTL){d.left=Number(j.css('right').replace("px",""));}this.setLastOffsets(d);return;}if(w){if(o>j.css('zIndex')){j.css('zIndex',o+1);}return;}var n=this.getNextOffsets();j.css('top',(n.top-a.TOP_INCR)+"px");if(this.isRTL){j.css('right',(n.left-a.LEFT_INCR)+"px");}else{j.css('left',(n.left-a.LEFT_INCR)+"px");}var d=j.rect();var s=q(window).scrollTop();var e=q(window).scrollLeft();var f=-e;if((q(window).height()+s)<(n.top+d.height)){n.top=s;this.setLastOffsets(n);}if(this.isRTL){if((q(window).width()+f)<(n.left+d.width)){n.left=f;this.setLastOffsets(n);}j.animate({top:n.top+"px",right:n.left+"px"},200);}else{if((q(window).width()+e)<(n.left+d.width)){n.left=e;this.setLastOffsets(n);}j.animate({top:n.top+"px",left:n.left+"px"},200);}};
a.TOP_INCR=20;a.LEFT_INCR=10;var L=null;
a.setLastOffsets=function(o){L=o;};
a.prototype.setLastOffsets=function(o){a.setLastOffsets(o);};
a.getNextOffsets=function(){L.top+=a.TOP_INCR;L.left+=a.LEFT_INCR;return L;};
a.prototype.getNextOffsets=function(){return a.getNextOffsets();};
a.prototype.bindDetails=function(c){this.fnCallBack=c;};
return a;});
sap.ui.predefine('sap/ui/commons/MessageBar',['sap/ui/thirdparty/jquery','sap/base/Log','./library','sap/ui/core/Control','sap/ui/core/Popup','./MessageToast','./MessageList','./MessageBarRenderer','sap/ui/dom/jquery/rect'],function(q,L,l,C,P,M,a,b){"use strict";var c=l.MessageType;
var d=C.extend("sap.ui.commons.MessageBar",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{anchorID:{type:"string",group:"Appearance",defaultValue:''},visible:{type:"boolean",group:"Behavior",defaultValue:true},maxToasted:{type:"int",group:"Misc",defaultValue:3},maxListed:{type:"int",group:"Misc",defaultValue:7},anchorSnapPoint:{type:"string",group:"Misc",defaultValue:"begin top"}}}});
d.prototype.init=function(){this.aErrors=[];this.aWarnings=[];this.aSuccesses=[];this.aToasts=[];this.maxToastsReached=false;this.oPopup=new P(this,false,true,false);this.oList=null;var i=this.getId();this.oToast=new M(i+"__Toast",{anchorId:i+"__sums"});var t=this;this.oToast.attachNext(function(){t.checkForToast();});this.snapPoint=null;this.oHomePosition=null;this.oDropPosition=null;this.bToggleListBackAfterDrag=null;};
d.prototype.exit=function(){this.onmouseup();this.close();this.oPopup.destroy();this.oPopup=null;this.oToast.destroy();this.oToast=null;if(this.oList){this.oList.destroy();this.oList=null;}};
d.prototype.ondragstart=function(e){e.preventDefault();e.stopPropagation();};
d.prototype.onmousedown=function(e){var s=e.target;var S=q(s);if(S.css('cursor')!="move"){return;}this.sDragMode="move";this.oMsgBarDragStartPosition=this.$().rect();this.oMsgBarDragStartPosition.right=Number(this.$().css('right').replace("px",""));if(!this.oHomePosition){this.oHomePosition=this.oMsgBarDragStartPosition;}this.mouseDragStartPositionX=e.screenX;this.mouseDragStartPositionY=e.screenY;var D=q(window.document);D.bind("mousemove",q.proxy(this.handleMove,this));if(window.parent){q(window.parent.document).bind("mousemove",q.proxy(this.handleMove,this),true);}D.bind("selectstart",q.proxy(this.ondragstart,this),true);};
d.prototype.handleMove=function(e){if(!this.sDragMode){return;}if(this.bToggleListBackAfterDrag==null&&this.oList){this.bToggleListBackAfterDrag=this.oList.getVisible();if(this.bToggleListBackAfterDrag){this.toggleList();}}e=e||window.event;var t=this.oMsgBarDragStartPosition.top+e.screenY-this.mouseDragStartPositionY;var i=this.oMsgBarDragStartPosition.left+e.screenX-this.mouseDragStartPositionX;var r=this.oMsgBarDragStartPosition.right-e.screenX+this.mouseDragStartPositionX;this.oPopup._$().css('top',t);if(this.snapPoint.indexOf("right")!=-1){this.oPopup._$().css('right',r);}else{this.oPopup._$().css('left',i);}this.oDropPosition={top:t,left:i,right:r};e.cancelBubble=true;return false;};
d.prototype.onmouseup=function(e){if(!this.sDragMode){return;}if(this.oDropPosition){this.addStyleClass("sapUiMsgBarMoved");}if(this.bToggleListBackAfterDrag){this.toggleList();}this.bToggleListBackAfterDrag=null;var D=q(window.document);D.unbind("mousemove",q.proxy(this.handleMove,this));if(window.parent){q(window.parent.document).unbind("mousemove",q.proxy(this.handleMove,this));}D.unbind("selectstart",q.proxy(this.ondragstart,this));this.sDragMode=null;this.checkForToast();};
d.prototype.onclick=function(e){var s=e.target;var S=q(s);if(S.css('cursor')!="pointer"){return;}if(S.hasClass("sapUiMsgBarToggle")){this.toggleList();}else if(S.hasClass("sapUiMsgBarHome")){this.backHome();}else{L.debug("Warning: MessageBar unsupported click on "+S.attr('className'));}};
d.prototype.checkForToast=function(){if(this.maxToastsReached){return;}if(this.aToasts==null||this.aToasts.length==0){return;}var m=this.getMaxToasted();if(m==0){return;}if(this.sDragMode){return;}var n=null;var e="";if(this.aToasts.length>this.getMaxToasted()){this.aToasts=[];this.maxToastsReached=true;e=this.getId()+"__arrowImg";}else{if(!this.oToast.isIdle()){return;}n=this.aToasts.splice(0,1)[0];e=this.getId()+"__"+n.getType()+"Img";}this.oToast.toast(n,e);};
d.prototype.addToasts=function(m){for(var i=0,e=m.length;i<e;i++){var n=m[i];var f=false;for(var j=this.aToasts.length;j>=0;j--){if(n==this.aToasts[j]){f=true;break;}}if(!f){this.aToasts.push(n);}}};
d.prototype.deleteToast=function(i){if(!this.aToasts){return;}for(var j=0,e=this.aToasts.length;j<e;j++){if(this.aToasts[j].getId()==i){this.aToasts.splice(j,1);return;}}};
d.prototype.deleteOneMessage=function(i){if(!i){return;}for(var j=0,e=this.aErrors.length;j<e;j++){if(this.aErrors[j].getId()==i){this.aErrors[j].closeDetails();this.aErrors.splice(j,1);return;}}for(var j=0,e=this.aWarnings.length;j<e;j++){if(this.aWarnings[j].getId()==i){this.aWarnings[j].closeDetails();this.aWarnings.splice(j,1);return;}}for(var j=0,e=this.aSuccesses.length;j<e;j++){if(this.aSuccesses[j].getId()==i){this.aSuccesses[j].closeDetails();this.aSuccesses.splice(j,1);return;}}};
d.prototype.getSnapPoint=function(){if(!this.snapPoint){this.snapPoint=this.getAnchorSnapPoint();if(sap.ui.getCore().getConfiguration().getRTL()){this.snapPoint=this.snapPoint.replace("begin","right").replace("end","left");}else{this.snapPoint=this.snapPoint.replace("begin","left").replace("end","right");}}return this.snapPoint;};
d.prototype.open=function(){var e=0;var s=this.getSnapPoint();var f=null;var g=this.getAnchorID();if(g){f=document.getElementById(g);}if(!f){f=document.body;}this.oPopup.open(e,s,s,f,"0 0");if(this.oDropPosition){this.oPopup._$().css('top',this.oDropPosition.top);if(s.indexOf("right")!=-1){this.oPopup._$().css('right',this.oDropPosition.right);}else{this.oPopup._$().css('left',this.oDropPosition.left);}}if(this.hasStyleClass("sapUiMsgBarOpen")){this.oList.setVisible(true);}};
d.prototype.close=function(){if(this.oList&&this.oList.getVisible()){this.oList.setVisible(false);}var e=0;this.oPopup.close(e);this.maxToastsReached=false;};
d.prototype.updateCountersAndVisibility=function(){if(!this.getProperty("visible")){return;}var i=this.getId();var o=document.getElementById(i+"__ErrorCount");if(!o){this.open();o=document.getElementById(i+"__ErrorCount");}var e=this.aErrors.length;var f=o.innerHTML;var n="("+e+")";var I=null;var j=null;if(n!=f){o.innerHTML=n;if(n=="(0)"){I=q(document.getElementById(i+"__ErrorImg"));j=q(document.getElementById(i+"__ErrorCount"));I.addClass("sapUiMsgBarZeroCount");j.addClass("sapUiMsgBarZeroCount");}else if(f=="(0)"){I=q(document.getElementById(i+"__ErrorImg"));j=q(document.getElementById(i+"__ErrorCount"));I.removeClass("sapUiMsgBarZeroCount");j.removeClass("sapUiMsgBarZeroCount");}}o=document.getElementById(i+"__WarningCount");e=this.aWarnings.length;f=o.innerHTML;n="("+e+")";I=null;j=null;if(n!=f){o.innerHTML=n;if(n=="(0)"){I=q(document.getElementById(i+"__WarningImg"));j=q(document.getElementById(i+"__WarningCount"));I.addClass("sapUiMsgBarZeroCount");j.addClass("sapUiMsgBarZeroCount");}else if(f=="(0)"){I=q(document.getElementById(i+"__WarningImg"));j=q(document.getElementById(i+"__WarningCount"));I.removeClass("sapUiMsgBarZeroCount");j.removeClass("sapUiMsgBarZeroCount");}}o=document.getElementById(i+"__SuccessCount");e=this.aSuccesses.length;f=o.innerHTML;n="("+e+")";I=null;j=null;if(n!=f){o.innerHTML=n;if(n=="(0)"){I=q(document.getElementById(i+"__SuccessImg"));j=q(document.getElementById(i+"__SuccessCount"));I.addClass("sapUiMsgBarZeroCount");j.addClass("sapUiMsgBarZeroCount");}else if(f=="(0)"){I=q(document.getElementById(i+"__SuccessImg"));j=q(document.getElementById(i+"__SuccessCount"));I.removeClass("sapUiMsgBarZeroCount");j.removeClass("sapUiMsgBarZeroCount");}}if(this.aErrors.length==0&&this.aWarnings.length==0&&this.aSuccesses.length==0){this.close();return;}else{this.open();}if(this.oList&&this.oList.getVisible()){this.oList.setMessages(this.aSuccesses.concat(this.aWarnings).concat(this.aErrors));}this.checkForToast();};
d.prototype.toggleList=function(){if(!this.oList){var e=this.getId()+"__List";this.oList=new a(e,{anchorId:this.getId(),maxListed:this.getMaxListed()});}var v=this.oList.getVisible();if(!v){this.oList.setMessages(this.aSuccesses.concat(this.aWarnings).concat(this.aErrors));this.addStyleClass("sapUiMsgBarOpen");}else{this.removeStyleClass("sapUiMsgBarOpen");}this.oList.setVisible(!v);};
d.prototype.backHome=function(){var p=this.oPopup._$();if(this.oList&&this.oList.getVisible()){this.toggleList();var t=this;if(this.snapPoint.indexOf("right")!=-1){p.animate({right:this.oHomePosition.right+"px",top:this.oHomePosition.top+"px"},200,function(){t.toggleList();});}else{p.animate({left:this.oHomePosition.left+"px",top:this.oHomePosition.top+"px"},200,function(){t.toggleList();});}}else{if(this.snapPoint.indexOf("right")!=-1){p.animate({right:this.oHomePosition.right+"px",top:this.oHomePosition.top+"px"},200);}else{p.animate({left:this.oHomePosition.left+"px",top:this.oHomePosition.top+"px"},200);}}this.oDropPosition=null;this.removeStyleClass("sapUiMsgBarMoved");};
d.prototype.addMessages=function(m){if(!m){return;}for(var i=0,e=m.length;i<e;i++){this.deleteOneMessage(m[i].getId());switch(m[i].getType()){case c.Error:this.aErrors.push(m[i]);break;case c.Warning:this.aWarnings.push(m[i]);break;case c.Success:this.aSuccesses.push(m[i]);break;default:L.debug("ERROR: MessageBar supplied messageType="+m[i].getType());}}this.addToasts(m);this.updateCountersAndVisibility();return this;};
d.prototype.deleteMessages=function(I){if(!I){return;}for(var i=0,e=I.length;i<e;i++){this.deleteOneMessage(I[i]);this.deleteToast(I[i]);}this.updateCountersAndVisibility();return this;};
d.prototype.deleteAllMessages=function(){for(var j=this.aErrors.length-1;j>=0;j--){this.aErrors[j].closeDetails();}for(var j=this.aWarnings.length-1;j>=0;j--){this.aWarnings[j].closeDetails();}for(var j=this.aSuccesses.length-1;j>=0;j--){this.aSuccesses[j].closeDetails();}this.aErrors=[];this.aWarnings=[];this.aSuccesses=[];this.aToasts=[];this.updateCountersAndVisibility();return this;};
d.prototype.setVisible=function(v){this.setProperty("visible",v);if(v){this.updateCountersAndVisibility();}else{this.close();}return this;};
return d;});
sap.ui.predefine('sap/ui/commons/MessageBarRenderer',['sap/ui/core/Popup'],function(P){"use strict";var M={};
M.render=function(r,c){var i=c.getId();r.write('<div draggable="true"');r.writeControlData(c);r.addClass("sapUiMsgBar");if(this.oDropPosition){r.addClass("sapUiMsgBarMoved");}r.writeClasses();r.write(">");r.write('<div id="'+i+'__sums" class="sapUiMsgBarSums">');r.write('<div id="'+i+'__arrowImg" class="sapUiMsgBarToggle"></div>');r.write('<div id="'+i+'__ErrorImg" class="sapUiMsgIcon sapUiMsgIconError sapUiMsgBarZeroCount"></div>');r.write('<span id="'+i+'__ErrorCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');r.write('<div id="'+i+'__WarningImg" class="sapUiMsgIcon sapUiMsgIconWarning sapUiMsgBarZeroCount"></div>');r.write('<span id="'+i+'__WarningCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');r.write('<div id="'+i+'__SuccessImg" class="sapUiMsgIcon sapUiMsgIconSuccess sapUiMsgBarZeroCount"></div>');r.write('<span id="'+i+'__SuccessCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');r.write("</div>");r.write('<div class="sapUiMsgBarHome"></div>');r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/commons/MessageBox',["sap/ui/thirdparty/jquery",'sap/ui/core/library','sap/ui/core/ElementMetadata','sap/ui/core/Control','./library','./Button','./Dialog','./Image','./TextView','./layout/MatrixLayout','./layout/MatrixLayoutCell'],function(q,c,E,C,a,B,D,I,T,M,b){"use strict";var d={};d.Action={OK:"OK",CANCEL:"CANCEL",YES:"YES",NO:"NO",ABORT:"ABORT",RETRY:"RETRY",IGNORE:"IGNORE",CLOSE:"CLOSE"};d.Icon={NONE:"NONE",INFORMATION:"INFORMATION",WARNING:"WARNING",ERROR:"ERROR",CRITICAL:"CRITICAL",SUCCESS:"SUCCESS",QUESTION:"QUESTION"};var A=c.AccessibleRole,e=d.Action,f=d.Icon,P=a.layout.Padding,V=a.layout.VAlign;var i={INFORMATION:"sapUiMboxInfo",CRITICAL:"sapUiMboxCritical",ERROR:"sapUiMboxError",WARNING:"sapUiMboxWarning",SUCCESS:"sapUiMboxSuccess",QUESTION:"sapUiMboxQuestion"};
d.show=function(m,o,t,v,g,h,s){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons"),j,R,k,l,n;if(typeof v!=="undefined"&&!Array.isArray(v)){v=[v];}if(!v||v.length===0){v=[e.OK];}s=s||E.uid("mbox");function p(y){var z=r&&r.getText("MSGBOX_"+y),F=new B({id:s+"--btn-"+y,text:z||y,press:function(){R=y;j.close();}});if(y===h){n=F;}return F;}function u(k){return new b({padding:P.None,vAlign:V.Top,content:k});}function w(o){var y=new I({id:s+"--icon",tooltip:r&&r.getText("MSGBOX_ICON_"+o),decorative:true});y.addStyleClass("sapUiMboxIcon");y.addStyleClass(i[o]);return y;}function x(){if(typeof g==="function"){g(R||e.CLOSE);}j.detachClosed(x);j.destroy();}k=new M({id:s+"--lyt",layoutFixed:false}).addStyleClass("sapUiMboxCont");if(typeof(m)==="string"){l=new T({id:s+"--msg"}).setText(m).addStyleClass("sapUiMboxText");}else if(m instanceof C){l=m.addStyleClass("sapUiMboxText");}if(o!==d.Icon.NONE){k.createRow(u(w(o)),u(l));}else{k.createRow(u(l));}j=new D({id:s,applyContentPadding:false,accessibleRole:A.AlertDialog,resizable:false,modal:true,buttons:q.map(v,p),content:k,defaultButton:n,closed:x}).setTitle(t);j.open();};
d.alert=function(m,g,t,s){return d.show(m,f.NONE,t,e.OK,function(o){if(typeof g==="function"){g();}},e.OK,s||E.uid("alert"));};
d.confirm=function(m,g,t,s){return d.show(m,f.QUESTION,t,[e.OK,e.CANCEL],function(o){if(typeof g==="function"){g(o===e.OK);}},undefined,s||E.uid("confirm"));};
return d;},true);
sap.ui.predefine('sap/ui/commons/MessageList',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','sap/ui/core/Popup','./MessageListRenderer'],function(q,l,C,P,M){"use strict";
var a=C.extend("sap.ui.commons.MessageList",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{visible:{type:"boolean",group:"Behavior",defaultValue:false},anchorId:{type:"string",group:"Appearance",defaultValue:null},maxListed:{type:"string",group:"Misc",defaultValue:'7'}}}});
a.prototype.init=function(){this.aMessages=[];this.iItemHeight=0;this.oPopup=new P(this,false,true,false);};
a.prototype.exit=function(){this.close();this.oPopup.destroy();this.oPopup=null;};
a.prototype.onThemeChanged=function(){this.iItemHeight=0;};
a.prototype.onAfterRendering=function(){var L=this.getDomRef();var j=q(L);var m=this.getMaxListed();var b=this.aMessages.length;if(b<=m){j.height("auto");return;}if(this.iItemHeight==0){var i=L.firstChild;var I=q(i);this.iItemHeight=I.height();}L.style.overflowY="scroll";L.style.overflowX="hidden";var d=(m*this.iItemHeight)+"px";j.height(d);};
a.prototype.open=function(){var r=sap.ui.getCore().getConfiguration().getRTL();var b=200;var m=r?P.Dock.RightTop:P.Dock.LeftTop;var c=r?P.Dock.RightBottom:P.Dock.LeftBottom;var d="0 0";var e=null;var f=this.getAnchorId();if(f){e=document.getElementById(f);}if(!e){e=document.body;}this.oPopup.open(b,m,c,e,d);};
a.prototype.close=function(){var b=200;this.oPopup.close(b);};
a.prototype.setMessages=function(m){this.aMessages=m;if(this.getVisible()){sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);}return this;};
a.prototype.setVisible=function(v){this.setProperty("visible",v);if(v){sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);this.open();}else{this.close();}return this;};
return a;});
sap.ui.predefine('sap/ui/commons/MessageListRenderer',[],function(){"use strict";var M={};
M.render=function(r,c){r.write('<ul class="sapUiMsgList"');r.writeControlData(c);r.write(">");for(var i=c.aMessages.length-1;i>=0;i--){r.write('<li class="sapUiMsgListLi">');r.renderControl(c.aMessages[i]);r.write("</li>");}r.write("</ul>");};
return M;},true);
sap.ui.predefine('sap/ui/commons/MessageRenderer',['./Link'],function(L){"use strict";var M={};
M.render=function(r,c){r.write('<div class="sapUiMsg" tabindex="0"');r.writeControlData(c);r.write('>');r.write('<div class="sapUiMsgIcon sapUiMsgIcon'+c.getType()+'"></div>');if(typeof c.fnCallBack==="function"){r.write('<span class="sapUiMsgLnk">');if(!c.oLink){c.oLink=new L();var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");c.oLink.setText(a.getText("MSGLIST_DETAILS"));c.oLink.attachPress(function(){c.openDetails();});}r.renderControl(c.oLink);r.write(' - </span>');}r.write('<span class="sapUiMsgTxt">');r.writeEscaped(c.getText());r.write('</span>');r.write('</div>');};
return M;},true);
sap.ui.predefine('sap/ui/commons/MessageToast',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','./MessageToastRenderer','sap/ui/core/Popup','sap/ui/thirdparty/jqueryui/jquery-ui-core','sap/ui/thirdparty/jqueryui/jquery-ui-position'],function(q,l,C,M,P){"use strict";var D=P.Dock;
var a=C.extend("sap.ui.commons.MessageToast",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{anchorId:{type:"string",group:"Misc",defaultValue:null}},events:{next:{}}}});
a.prototype.init=function(){this.oMessage=null;this.sAnchorId="";this.bIdle=true;this.sLeftOffset="";this.oPopup=new P(this,false,false,false);this.oPopup.attachClosed(this.next,this);};
a.prototype.exit=function(){if(!this.bIdle){this.close();}this.oPopup.destroy();this.oPopup=null;};
a.prototype.onAfterRendering=function(){var r=sap.ui.getCore().getConfiguration().getRTL();var i=q(this.sAnchorId?document.getElementById(this.sAnchorId):null);var b=i.position();var B=q(this.getAnchorId()?document.getElementById(this.getAnchorId()):null);var c=B.outerWidth();if(b){var t=r?b.left+i.outerWidth():c-b.left;var T=this.$();var d=T.width();var e=Math.max(d,c);var f=c-d;if(f>0){T.css('minWidth',c);}var m=r?(e-t+2)+"px":(e-t-2)+"px";if(e>=t){var A=q(document.getElementById(this.getId()+"Arrow"));if(sap.ui.getCore().getConfiguration().getRTL()){A.css('marginRight',m);}else{A.css('marginLeft',m);}this.sLeftOffset="0";}}};
a.prototype.next=function(){this.bIdle=true;this.fireNext();};
a.prototype.open=function(d){if(!this.bIdle){this.oPopup.close(0);}this.bIdle=false;var r=sap.ui.getCore().getConfiguration().getRTL();var p=r?D.LeftBottom:D.RightBottom;var b=r?D.LeftTop:D.RightTop;var c=this.sLeftOffset+" 5";var e=null;var f=this.getAnchorId();if(f){e=document.getElementById(f);}if(!e){e=document.body;}this.oPopup.open(d,p,b,e,c);};
a.prototype.close=function(d){this.oPopup.close(d);};
a.prototype.getClasses=function(){var c="sapUiMsgToast";if(this.oMessage&&this.oMessage.getType()){c+=" sapUiMsgT"+this.oMessage.getType();}return c;};
a.prototype.toast=function(m,A){this.oMessage=m;this.sAnchorId=A;sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);this.open(750);this.close(2250);return this;};
a.prototype.isIdle=function(){return this.bIdle;};
return a;});
sap.ui.predefine('sap/ui/commons/MessageToastRenderer',[],function(){"use strict";var M={};
M.render=function(r,c){r.write('<div class="'+c.getClasses()+'"');r.writeControlData(c);r.write('>');r.write('<div class="sapUiMsgToastMsg sapUiShd">');if(c.oMessage){r.renderControl(c.oMessage);}else{var m=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("MSGTOAST_MULTI_MSGS");r.write('<div class="sapUiMsg" tabindex="0"><span class="sapUiMsgTxt">'+m+'</span></div>');}r.write("</div>");r.write('<div id="'+c.getId()+'Arrow" class="sapUiMsgToastArrow"></div>');r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/commons/Paginator',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','./PaginatorRenderer',"sap/ui/dom/jquery/Selectors"],function(q,l,C,P){"use strict";var a=l.PaginatorEvent;
var b=C.extend("sap.ui.commons.Paginator",{metadata:{library:"sap.ui.commons",properties:{currentPage:{type:"int",group:"Misc",defaultValue:1},numberOfPages:{type:"int",group:"Misc",defaultValue:null}},events:{page:{parameters:{srcPage:{type:"int"},targetPage:{type:"int"},type:{type:"sap.ui.commons.PaginatorEvent"}}}}}});
b.MAX_NUMBER_PAGES=5;
b.prototype.init=function(){this.bShowAnimation=true;};
b.prototype.onclick=function(e){this._handleSelect(e);};
b.prototype.setCurrentPage=function(t,s){this.setProperty("currentPage",t,s);if(this.getDomRef()){P.updateBackAndForward(this);}return this;};
b.prototype.triggerPaginatorAnimation=function(){var I=[];var c=[];var d=this.$("pages").children();var n=this._calculatePagesRange();var o;if(this._oOldRange){o=this._oOldRange;}else{o={};var p=d[0].id.split("--");o.firstPage=parseInt(p[p.length-1]);p=d[d.length-1].id.split("--");o.lastPage=parseInt(p[p.length-1]);}var i;for(i=n.firstPage;i<=n.lastPage;i++){if(i<o.firstPage||i>o.lastPage){c.push(i);}}var e={firstPage:c[0],lastPage:c[c.length-1]};for(i=o.firstPage;i<=o.lastPage;i++){if(i<n.firstPage||i>n.lastPage){I.push(i);}}var f=P.getPagesHtml(this.getId(),o,this.getCurrentPage(),true);var g=P.getPagesHtml(this.getId(),e,this.getCurrentPage(),false);if(o.firstPage<e.firstPage){g=f+g;}else{g=g+f;}var h=document.activeElement;var j=h?h.id:undefined;this.getDomRef("pages").innerHTML=g;if(j){h=document.getElementById(j);}else{h=document.getElementById("testPaginator-a--"+this.getCurrentPage());}if(h){h.focus();}var k="li--";this._oOldRange=n;function r(){var m=document.getElementById(this.id);if(m){m.parentNode.removeChild(m);}}for(i=0;i<I.length;i++){this.$(k+I[i]).hide(400,r);}for(i=0;i<c.length;i++){this.$(k+c[i]).show(400);}};
b.prototype._calculatePagesRange=function(){var f=1;var L=this.getNumberOfPages();var c=this.getCurrentPage();var n=this.getNumberOfPages();if(c<4){f=1;if(L>b.MAX_NUMBER_PAGES){L=b.MAX_NUMBER_PAGES;}}else if(c==L){if(n<5){f=1;}else{f=L-4;}}else if(L-c<3){f=L-4;}else{f=c-2;L=c+2;}return{firstPage:f,lastPage:L};};
b.prototype.onkeydown=function(e){var E=e.getPseudoTypes();if(E.indexOf("saptabnext")!=-1){this.triggerTabbingNavigation(e,false);}else if(E.indexOf("saptabprevious")!=-1){this.triggerTabbingNavigation(e,true);}else if(E.indexOf("sapincrease")!=-1){this.triggerInternalNavigation(e,"next");}else if(E.indexOf("sapdecrease")!=-1){this.triggerInternalNavigation(e,"previous");}else if(E.indexOf("sapenter")!=-1){this._handleSelect(e);}};
b.prototype.triggerInternalNavigation=function(e,d){var f=this.$().find(":sapFocusable");var c=q(f).index(e.target);var n,N;if(d=="next"){n=c+1;if(q(e.target).hasClass("sapUiPagCurrentPage")){n=n+1;}N=f[n];if(N){q(N).focus();e.preventDefault();e.stopPropagation();}}else if(d=="previous"&&f[c-1]){n=c-1;N=f[n];if(N&&q(N).hasClass("sapUiPagCurrentPage")){N=f[n-1];}if(N){q(N).focus();e.preventDefault();e.stopPropagation();}}};
b.prototype.triggerTabbingNavigation=function(e,s){var f=this.$().find(":sapFocusable");if(!s){q(f[f.length-1]).focus();}else{var c=q(f).index(e.target);if(c!=0){q(f[0]).focus();}}};
b.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return C.prototype.getFocusInfo.apply(this,arguments);}};
b.prototype.applyFocusInfo=function(f){if(f&&f.customId){this.$().find("#"+f.customId).focus();}else{C.prototype.getFocusInfo.apply(this,arguments);}return this;};
b.prototype._handleSelect=function(e){if(e&&e.target){e.preventDefault();var t=e.target;if(!t.id){t=t.parentNode;}if(t.id&&t.id!=this.getId()+"-pages"){var A=t.id.split("--");if(A.length>1){var c=A[A.length-1];var E=null;var s=this.getCurrentPage();var T=s;if(c.match(/^\d+$/)){E=a.Goto;T=parseInt(c);}else if(c=="firstPageLink"){E=a.First;T=1;}else if(c=="backLink"){E=a.Previous;T=Math.max(s-1,1);}else if(c=="forwardLink"){E=a.Next;T=Math.min(s+1,this.getNumberOfPages());}else if(c=="lastPageLink"){E=a.Last;T=this.getNumberOfPages();}if(T!=s){if(this.bShowAnimation){this.setCurrentPage(T,true);this.triggerPaginatorAnimation();}else{this.setCurrentPage(T);}this.firePage({srcPage:s,targetPage:T,type:E});}}}}};
return b;});
sap.ui.predefine('sap/ui/commons/PaginatorRenderer',["sap/base/security/encodeXML","sap/ui/thirdparty/jquery"],function(e,q){"use strict";var P={};
P.render=function(r,p){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");r.write("<div");r.writeControlData(p);r.writeAccessibilityState(p,{role:"toolbar",labelledby:p.getId()+"-accDesc"});r.addClass("sapUiPag");r.writeClasses();r.write(">");r.write("<span class='sapUiPagAccDesc' id='"+p.getId()+"-accDesc'>");r.writeEscaped(a.getText("PAGINATOR"));r.write("</span>");this.renderPaginator(r,p);r.write("</div>");};
P.renderPaginator=function(r,p){if(p.getNumberOfPages()<=1){return;}var a=p.getId();var c=p.getCurrentPage();var b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var l=(c==1)?"sapUiLnkDsbl":"sapUiLnk";var d=(c==1)?" aria-disabled='true'":"";if(p.getNumberOfPages()>5){r.write("<a id='"+a+"--firstPageLink' href='#;' title='");r.writeEscaped(b.getText("FIRST_PAGE"));r.write("' class='sapUiPagBtn sapUiPagFirst "+l+"' "+d+"><span class='sapUiPagText'>");r.writeEscaped(b.getText("PAGINATOR_OTHER_PAGE",[1]));r.write("</span></a>");}r.write("<a id='"+a+"--backLink' href='#' title='");r.writeEscaped(b.getText("PREVIOUS_PAGE"));r.write("' class='sapUiPagBtn sapUiPagBack "+l+"' "+d+"><span class='sapUiPagText'>");r.writeEscaped(b.getText("BACK"));r.write("</span></a>");r.write("<ul id='"+a+"-pages' role='presentation'>");r.write(P.getPagesHtml(a,p._calculatePagesRange(),p.getCurrentPage(),true));r.write("</ul>");l=(c===p.getNumberOfPages())?"sapUiLnkDsbl":"sapUiLnk";d=(c===p.getNumberOfPages())?" aria-disabled='true'":"";r.write("<a id='"+a+"--forwardLink' href='#' title='");r.writeEscaped(b.getText("NEXT_PAGE"));r.write("' class='sapUiPagBtn sapUiPagForward "+l+"' "+d+"><span class='sapUiPagText'>");r.writeEscaped(b.getText("FORWARD"));r.write("</span></a>");if(p.getNumberOfPages()>5){r.write("<a id='"+a+"--lastPageLink' href='#' title='");r.writeEscaped(b.getText("LAST_PAGE"));r.write("' class='sapUiPagBtn sapUiPagLast "+l+"' "+d+"><span class='sapUiPagText'>");r.writeEscaped(b.getText("PAGINATOR_OTHER_PAGE",[p.getNumberOfPages()]));r.write("</span></a>");}};
P.getPagesHtml=function(p,r,c,v){var h=[];var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");for(var i=r.firstPage;i<=r.lastPage;i++){h.push("<li id='"+p+"-li--"+i+"' class='sapUiPagPage");h.push((i==c)?" sapUiPagCurrentPage'":"'");if(!v){h.push(" style='display:none'");}h.push(">");h.push("<a id='"+p+"-a--"+i+"' title='");if(i==c){h.push(e(a.getText("PAGINATOR_CURRENT_PAGE",[i])));}else{h.push(e(a.getText("PAGINATOR_OTHER_PAGE",[i])));}h.push("' href='#'");if(i==c){h.push(" tabindex='0' class='sapUiLnkDsbl'");}else{h.push(" class='sapUiLnk'");}h.push(">"+i+"</a>");h.push("</li>");}return h.join("");};
P.updateBackAndForward=function(p){var a=p.getCurrentPage();var i=p.getId();var b=(a==1);var c=(a==p.getNumberOfPages());var f=q(document.getElementById(i+"--firstPageLink")).toggleClass("sapUiLnk",!b).toggleClass("sapUiLnkDsbl",b);var d=q(document.getElementById(i+"--backLink")).toggleClass("sapUiLnk",!b).toggleClass("sapUiLnkDsbl",b);var g=q(document.getElementById(i+"--forwardLink")).toggleClass("sapUiLnk",!c).toggleClass("sapUiLnkDsbl",c);var l=q(document.getElementById(i+"--lastPageLink")).toggleClass("sapUiLnk",!c).toggleClass("sapUiLnkDsbl",c);if(b){f.attr("aria-disabled","true");d.attr("aria-disabled","true");g.removeAttr("aria-disabled");l.removeAttr("aria-disabled");}else if(c){f.removeAttr("aria-disabled");d.removeAttr("aria-disabled");g.attr("aria-disabled","true");l.attr("aria-disabled","true");}else{f.removeAttr("aria-disabled");d.removeAttr("aria-disabled");g.removeAttr("aria-disabled");l.removeAttr("aria-disabled");}};
return P;},true);
sap.ui.predefine('sap/ui/commons/Panel',['sap/ui/thirdparty/jquery','sap/base/assert','./library','sap/ui/core/Control','./PanelRenderer','sap/ui/core/ResizeHandler','sap/ui/core/Title',"sap/ui/dom/jquery/scrollLeftRTL"],function(q,a,l,C,P,R,T){"use strict";var B=l.enums.BorderDesign;var A=l.enums.AreaDesign;
var b=C.extend("sap.ui.commons.Panel",{metadata:{library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},scrollLeft:{type:"int",group:"Behavior",defaultValue:0},scrollTop:{type:"int",group:"Behavior",defaultValue:0},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},collapsed:{type:"boolean",group:"Behavior",defaultValue:false},areaDesign:{type:"sap.ui.commons.enums.AreaDesign",group:"Appearance",defaultValue:A.Fill},borderDesign:{type:"sap.ui.commons.enums.BorderDesign",group:"Appearance",defaultValue:B.Box},showCollapseIcon:{type:"boolean",group:"Behavior",defaultValue:true},text:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},title:{type:"sap.ui.core.Title",multiple:false},buttons:{type:"sap.ui.commons.Button",multiple:true,singularName:"button"}}}});
b.prototype.init=function(){this._oScrollDomRef=null;this._iMaxTbBtnWidth=-1;this._iTbMarginsAndBorders=0;this._iMinTitleWidth=30;this._iOptTitleWidth=30;this._iTitleMargin=0;this._bFocusCollapseIcon=false;this._resizeDelayTimer=null;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.data("sap-ui-fastnavgroup","true",true);};
b.prototype.exit=function(){this._rb=undefined;};
b.prototype.onThemeChanged=function(){if(this.getDomRef()&&this._oTitleDomRef){this.getDomRef().style.minWidth="auto";if(this._oToolbarDomRef){this._oToolbarDomRef.style.width="auto";}this._oTitleDomRef.style.width="auto";this._initializeSizes();}};
b.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
b.prototype.onAfterRendering=function(){this._oScrollDomRef=this.getDomRef("cont");if(!this._oScrollDomRef){return;}this._oHeaderDomRef=this.getDomRef("hdr");this._oTitleDomRef=this.getDomRef("title");this._oToolbarDomRef=this.getDomRef("tb");if(this._bFocusCollapseIcon){this._bFocusCollapseIcon=false;var $=this.$("collArrow");if($.is(":visible")&&($.css("visibility")=="visible"||$.css("visibility")=="inherit")){$.focus();}else{var c=this.$("collIco");if(c.is(":visible")&&(c.css("visibility")=="visible"||c.css("visibility")=="inherit")){c.focus();}}}this._initializeSizes();if(b._isSizeSet(this.getHeight())&&(this._hasIcon()||(this.getButtons().length>0))){this._handleResizeNow();this.sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._handleResizeSoon,this));}};
b.prototype.getFocusInfo=function(){var c=null;var i=this.getId();if(this._bFocusCollapseIcon){var $=this.$("collArrow");if($.is(":visible")&&($.css("visibility")=="visible"||$.css("visibility")=="inherit")){c=$[0].id;}else{var d=this.$("collIco");if(d.is(":visible")&&(d.css("visibility")=="visible"||d.css("visibility")=="inherit")){c=d[0].id;}}}return{id:(c?c:i)};};
b.prototype.applyFocusInfo=function(f){var d;if(f&&f.id&&(d=q(document.getElementById(f.id)))&&(d.length>0)){d.focus();}else{this.focus();}return this;};
b.prototype._initializeSizes=function(){var r=sap.ui.getCore().getConfiguration().getRTL();var c=this.getButtons();if(c&&c.length>0){var m=0;q(this._oToolbarDomRef).children().each(function(){var w=this.offsetWidth;if(w>m){m=w;}});this._iMaxTbBtnWidth=m;if(this._oToolbarDomRef){this._oToolbarDomRef.style.minWidth=m+"px";var $=q(this._oToolbarDomRef);this._iTbMarginsAndBorders=$.outerWidth(true)-$.width();}}var d=this._oTitleDomRef.offsetLeft;var t=this.getDomRef().offsetWidth;if(r){d=t-(d+this._oTitleDomRef.offsetWidth);}var e=q(this._oTitleDomRef);this._iOptTitleWidth=e.width()+1;this._iTitleMargin=e.outerWidth(true)-e.outerWidth();var f=10000;q(this._oHeaderDomRef).children(".sapUiPanelHdrRightItem").each(function(){var i=this.offsetLeft;if(r){i=t-(i+this.offsetWidth);}if((i<f)&&(i>0)){f=i;}});var g=d;g+=this._iMinTitleWidth;g+=this._iMaxTbBtnWidth+1;g+=(f==10000)?10:(t-f);this.getDomRef().style.minWidth=g+10+"px";if(this._oScrollDomRef){var s=this.getProperty("scrollTop");if(s>0){this._oScrollDomRef.scrollTop=s;}var h=this.getProperty("scrollLeft");if(h>0){this._oScrollDomRef.scrollLeft=h;}}};
b.prototype._fixContentHeight=function(){if(b._isSizeSet(this.getHeight())&&(this._hasIcon()||(this.getButtons().length>0))){this._iContTop=this._oHeaderDomRef.offsetHeight;if(this._oScrollDomRef){this._oScrollDomRef.style.top=this._iContTop+"px";}}};
b.prototype._handleResizeSoon=function(){if(this._resizeDelayTimer){clearTimeout(this._resizeDelayTimer);}this._resizeDelayTimer=setTimeout(function(){this._handleResizeNow();this._resizeDelayTimer=null;}.bind(this),200);};
b.prototype._handleResizeNow=function(){this._fixContentHeight();};
b.prototype._hasIcon=function(){return(this.getTitle()&&this.getTitle().getIcon());};
b.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);q(this.getDomRef()).toggleClass("sapUiPanelDis",!e);return this;};
b.prototype.setApplyContentPadding=function(p){this.setProperty("applyContentPadding",p,true);q(this.getDomRef()).toggleClass("sapUiPanelWithPadding",p);return this;};
b.prototype.setCollapsed=function(c){this.setProperty("collapsed",c,true);this._setCollapsedState(c);return this;};
b.prototype._setCollapsedState=function(c){var d=this.getDomRef();if(d){var e=sap.ui.getCore().getConfiguration().getAccessibility();if(c){if(!this.getWidth()){d.style.width=this.getDomRef().offsetWidth+"px";}q(d).addClass("sapUiPanelColl");if(e){d.setAttribute("aria-expanded","false");}if(this.getHeight()){d.style.height="auto";}var E=this._rb.getText("PANEL_EXPAND");this.$("collArrow").attr("title",E);this.$("collIco").attr("title",E);}else{if(!this.getDomRef("cont")){this._bFocusCollapseIcon=true;this.rerender();}else{q(d).removeClass("sapUiPanelColl");if(e){d.setAttribute("aria-expanded","true");}if(!this.getWidth()){d.style.width="auto";}if(this.getHeight()){d.style.height=this.getHeight();}var s=this._rb.getText("PANEL_COLLAPSE");this.$("collArrow").attr("title",s);this.$("collIco").attr("title",s);}}}};
b._isSizeSet=function(c){return(c&&!(c=="auto")&&!(c=="inherit"));};
b.prototype.setTitle=function(t){var o=this.getTitle();this.setAggregation("title",t);if(o&&o!==t&&o.getId()===this.getId()+"-tit"){o.destroy();}return this;};
b.prototype.setText=function(t){if(!this.getTitle()){this.setTitle(new T(this.getId()+"-tit",{text:t}));}else{this.getTitle().setText(t);}return this;};
b.prototype.getText=function(){if(!this.getTitle()){return"";}else{return this.getTitle().getText();}};
b.prototype.getScrollLeft=function(){var s=0;if(this._oScrollDomRef){if(sap.ui.getCore().getConfiguration().getRTL()){s=q(this._oScrollDomRef).scrollLeftRTL();}else{s=q(this._oScrollDomRef).scrollLeft();}a(typeof s=="number","scrollLeft read from DOM should be a number");this.setProperty("scrollLeft",s,true);}return s;};
b.prototype.setScrollLeft=function(p){this.setProperty("scrollLeft",p,true);if(this._oScrollDomRef){if(sap.ui.getCore().getConfiguration().getRTL()){q(this._oScrollDomRef).scrollLeftRTL(p);}else{q(this._oScrollDomRef).scrollLeft(p);}}return this;};
b.prototype.getScrollTop=function(){var s=0;if(this._oScrollDomRef){s=Math.ceil(this._oScrollDomRef.scrollTop);this.setProperty("scrollTop",s,true);}return s;};
b.prototype.setScrollTop=function(p){this.setProperty("scrollTop",p,true);if(this._oScrollDomRef){this._oScrollDomRef.scrollTop=p;}return this;};
b.prototype.setDimensions=function(w,h){a(typeof w=="string"&&typeof h=="string","sWidth and sHeight must be strings");this.setWidth(w);this.setHeight(h);return this;};
b.prototype.setWidth=function(w){this.setProperty("width",w,true);var d=this.getDomRef();if(d){d.style.width=w;}return this;};
b.prototype.setHeight=function(h){this.setProperty("height",h,true);var d=this.getDomRef();if(d){d.style.height=h;}return this;};
b.prototype.onclick=function(e){this._handleTrigger(e);};
b.prototype.onsapspace=function(e){this._handleTrigger(e);};
b.prototype._handleTrigger=function(e){var i=this.getId();if((e.target.id===i+"-collArrow")||(e.target.id===i+"-collIco")||(e.target.id===i&&e.type==="sapspace"&&this.getShowCollapseIcon())){this.setCollapsed(!this.getProperty("collapsed"));e.preventDefault();e.stopPropagation();this.fireEvent("collapsedToggled");}};
return b;});
sap.ui.predefine('sap/ui/commons/PanelRenderer',['sap/base/security/encodeXML','sap/ui/core/library'],function(e,c){"use strict";var T=c.TitleLevel;var P=function(){};
P.render=function(r,C){var b=C.getId();var d=sap.ui.getCore().getConfiguration().getAccessibility();var h=a(C.getHeight());var w=a(C.getWidth());C.getScrollTop();C.getScrollLeft();r.write("<section");r.writeControlData(C);r.addClass("sapUiPanel");r.addStyle("width",C.getWidth());if(!C.getCollapsed()){r.addStyle("height",C.getHeight());}else{r.addClass("sapUiPanelColl");r.addStyle("height","auto");}if(h){r.addClass("sapUiPanelHeightSet");}if(w){r.addClass("sapUiPanelWidthSet");}if(C.getApplyContentPadding()){r.addClass("sapUiPanelWithPadding");}if(!C.getEnabled()){r.addClass("sapUiPanelDis");}if(C.getShowCollapseIcon()){r.addClass("sapUiPanelWithCollapseIcon");}r.addClass("sapUiPanelBorderDesign"+C.getBorderDesign());r.addClass("sapUiPanelAreaDesign"+C.getAreaDesign());r.writeClasses();r.writeStyles();if(d){r.writeAttribute("aria-labelledby",b+"-title ");r.writeAttribute("aria-describedby",b+"-acc");r.writeAttribute("role","region");if(C.getCollapsed()){r.writeAttribute("aria-expanded","false");}else{r.writeAttribute("aria-expanded","true");}r.writeAttribute("tabindex","0");}var t=C.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write("><header id='"+b+"-hdr'");r.addClass("sapUiPanelHdr");var o=C.getTitle();var s;var l=T.H5;var E=true;if(o){s=o.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}if(o.getLevel()!=T.Auto){l=o.getLevel();E=o.getEmphasized();}}if(E){r.addClass("sapUiPanelHdrEmph");}r.writeClasses();r.write(">");if(C.getShowCollapseIcon()&&d){r.write("<span id=\""+b+"-acc\" style=\"display:none;\">");r.writeEscaped(C._rb.getText("PANEL_HEAD_ACC"));r.write("</span>");}var f=C._rb.getText(C.getCollapsed()?"PANEL_EXPAND":"PANEL_COLLAPSE");if(C.getShowCollapseIcon()){r.write("<a id='"+b+"-collArrow' class='sapUiPanelHdrItem sapUiPanelCollArrow' href='#' tabindex='0' title='"+f+"'");if(d){r.writeAttribute("role","button");}r.write(">&nbsp;</a>");}if(o&&o.getIcon()){var I=o.getIcon();var g=[];var A={};A["id"]=b+"-ico";A["title"]=null;g.push("sapUiPanelIco");g.push("sapUiPanelHdrItem");g.push("sapUiTv"+l);r.writeIcon(I,g,A);}var j=e(C.getText());if(!j){j="&nbsp;";}r.write("<"+l+" ");r.addClass("sapUiTv"+l);r.write(" id='"+b+"-title' ");r.addClass("sapUiPanelHdrItem");r.addClass("sapUiPanelTitle");r.writeClasses();if(d){r.writeAttribute("role","heading");}r.write(">");r.write(j);r.write("</"+l+">");var B=C.getButtons();if(B&&(B.length>0)){r.write("<div id='"+b+"-tb' class='sapUiPanelHdrItem sapUiPanelTb sapUiTbDesignFlat'>");for(var i=0;i<B.length;i++){r.renderControl(B[i]);}r.write("</div>");}if(C.getShowCollapseIcon()){r.write("<a id='"+b+"-collIco' class='sapUiPanelHdrRightItem sapUiPanelCollIco' href='#' tabindex='0' title='"+f+"'");if(d){r.writeAttribute("role","button");}r.write(">&nbsp;</a>");}r.write("</header>");if(!C.getCollapsed()){r.write("<div class='sapUiPanelCont' id='",b,"-cont'>");var k=C.getContent(),L=k.length;for(var i=0;i<L;i++){r.renderControl(k[i]);}r.write("</div>");}r.write("</section>");};
function a(C){return C&&C!=="auto"&&C!=="inherit";}
return P;},true);
sap.ui.predefine('sap/ui/commons/PasswordField',['sap/ui/thirdparty/jquery','./TextField','./library','./PasswordFieldRenderer','sap/ui/Device'],function(q,T,l,P,D){"use strict";
var a=T.extend("sap.ui.commons.PasswordField",{metadata:{library:"sap.ui.commons"}});
a.prototype.onfocusin=function(e){T.prototype.onfocusin.apply(this,arguments);if(!D.support.input.placeholder&&this.getPlaceholder()){q(this.getInputDomRef()).attr("type","password");}};
a.prototype.onsapfocusleave=function(e){if(!D.support.input.placeholder&&this.getPlaceholder()){var i=q(this.getInputDomRef());if(!i.val()){i.removeAttr("type");}}T.prototype.onsapfocusleave.apply(this,arguments);};
return a;});
sap.ui.predefine('sap/ui/commons/PasswordFieldRenderer',['./TextFieldRenderer','sap/ui/core/Renderer','sap/ui/Device'],function(T,R,D){"use strict";var P=R.extend(T);
P.renderInnerAttributes=function(r,p){if(D.support.input.placeholder||p.getValue()||!p.getPlaceholder()){r.writeAttribute('type','password');}};
P.renderTextFieldEnabled=function(r,p){if(!p.getEnabled()&&!p.getEditable()){r.writeAttribute('readonly','readonly');r.writeAttribute('tabindex','-1');}else{r.writeAttribute('tabindex','0');}};
P.setEnabled=function(p,e){var t=p.$();if(e){if(p.getEditable()){t.removeClass('sapUiTfDsbl').addClass('sapUiTfStd');t.removeAttr('readonly').attr('tabindex','0');}else{t.removeClass('sapUiTfDsbl').addClass('sapUiTfRo');t.attr('tabindex','0');}}else{if(p.getEditable()){t.removeClass('sapUiTfStd').addClass('sapUiTfDsbl');t.attr('readonly','readonly').attr('tabindex','-1');}else{t.removeClass('sapUiTfRo').addClass('sapUiTfDsbl');t.attr('tabindex','-1');}}};
return P;},true);
sap.ui.predefine('sap/ui/commons/ProgressIndicator',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','./ProgressIndicatorRenderer','sap/ui/core/library'],function(q,l,C,P,c){"use strict";var B=c.BarColor;
var a=C.extend("sap.ui.commons.ProgressIndicator",{metadata:{library:"sap.ui.commons",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},barColor:{type:"sap.ui.core.BarColor",group:"Appearance",defaultValue:B.NEUTRAL},displayValue:{type:"string",group:"Appearance",defaultValue:'0%'},percentValue:{type:"int",group:"Data",defaultValue:0},showValue:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'}}}});
a.prototype.onclick=function(e){this.focus();};
a.prototype.onselectstart=function(e){return false;};
a.prototype.setEndBar=function(){var w=this.getPercentValue();var b;var s=this.getBarColor();var t;this.oBar=this.getDomRef("bar");this.oEnd=this.getDomRef("end");this.oBox=this.getDomRef("box");q(this.oEnd).removeClass('sapUiProgIndEndHidden');q(this.oEnd).addClass(this._getProgIndTypeClass(s));if(w>100){b=(10000/w)+'%';}else{b='100%';}if(w>100){t=(w-100)*20;}else{t=(100-w)*20;}q(this.oBox).animate({width:b},0,'linear');if(this.bRtl){q(this.oEnd).animate({right:b},t,'linear');}else{q(this.oEnd).animate({left:b},t,'linear');}q(this.oBar).animate({width:w+'%'},t,'linear');if(!this.oThis){this.oThis=this.$();}this.oThis.attr('aria-valuenow',w+'%');};
a.prototype.setEndBarGoesBack=function(p){var w=this.getPercentValue();var b;var s=this.getBarColor();var t;this.oBar=this.getDomRef("bar");this.oEnd=this.getDomRef("end");this.oBox=this.getDomRef("box");if(p>100){b=(10000/p)+'%';}else{b='100%';}q(this.oEnd).removeClass(this._getProgIndTypeClass(s));q(this.oEnd).addClass('sapUiProgIndEndHidden');if(w>100){t=(w-100)*20;}else{t=(100-w)*20;}q(this.oBox).animate({width:b},0,'linear');if(this.bRtl){q(this.oEnd).animate({right:b},t,'linear');}else{q(this.oEnd).animate({left:b},t,'linear');}q(this.oBar).animate({width:w+'%'},t,'linear');if(!this.oThis){this.oThis=this.$();}this.oThis.attr('aria-valuenow',w+'%');};
a.prototype.setPercentValue=function(p){var w=this.getPercentValue();var b;this.oBar=this.getDomRef("bar");this.oEnd=this.getDomRef("end");this.oBox=this.getDomRef("box");var t=this;var d;if(p<0){p=0;}if(p>100){b=(10000/p)+'%';}else{b='100%';}if(!this.oBar){d=p*20;this.setProperty('percentValue',p,true);q(this.oBar).animate({width:p+'%'},d,'linear');return this;}if(p>100&&w<=100){d=(100-w)*20;this.setProperty('percentValue',p,true);q(this.oBar).animate({width:'100%'},d,'linear',function(){t.setEndBar();});}else if(p<=100&&w>100){d=(w-100)*20;this.setProperty('percentValue',p,true);q(this.oBar).animate({width:'100%'},d,'linear',function(){t.setEndBarGoesBack();});}else if(p>100&&w>100){if(p>w){d=(p-w)*20;}else{d=(w-p)*20;}b=(10000/p)+'%';this.setProperty('percentValue',p,true);q(this.oBox).animate({width:b},0,'linear');if(this.bRtl){q(this.oEnd).animate({right:b},d,'linear');}else{q(this.oEnd).animate({left:b},d,'linear');}q(this.oBar).animate({width:p+'%'},d,'linear',function(){});if(!this.oThis){this.oThis=this.$();}this.oThis.attr('aria-valuenow',p+'%');}else{if(p>w){d=(p-w)*20;}else{d=(w-p)*20;}this.setProperty('percentValue',p,true);q(this.oBar).animate({width:p+'%'},d,'linear');if(!this.oThis){this.oThis=this.$();}this.oThis.attr('aria-valuenow',p+'%');}return this;};
a.prototype._getProgIndTypeClass=function(b){switch(b){case"POSITIVE":return'sapUiProgIndPosEnd';case"NEGATIVE":return'sapUiProgIndNegEnd';case"CRITICAL":return'sapUiProgIndCritEnd';case"NEUTRAL":return'sapUiProgIndEnd';default:return'sapUiProgIndEnd';}};
a.prototype.getAccessibilityInfo=function(){var b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");return{role:"progressbar",type:b.getText("ACC_CTR_TYPE_PROGRESS"),description:b.getText("ACC_CTR_STATE_PROGRESS",[this.getPercentValue()]),focusable:this.getEnabled(),enabled:this.getEnabled()};};
return a;});
sap.ui.predefine('sap/ui/commons/ProgressIndicatorRenderer',[],function(){"use strict";var P={};
P.render=function(r,p){var w=p.getWidth(),a=p.getPercentValue(),t=p.getTooltip_AsString(),d=p.getDisplayValue(),b;p.bRtl=sap.ui.getCore().getConfiguration().getRTL();if(a>100){b=(10000/a)+'%';}else{b='100%';}r.write('<div');r.writeControlData(p);r.writeAttribute('tabindex','0');if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(p,{role:'progressbar',valuemin:'0%',valuenow:a+'%',valuemax:'100%'});}if(d){r.writeAttributeEscaped('aria-valuetext',d);}if(t){r.writeAttributeEscaped('title',t);}if(p.getWidth()&&p.getWidth()!==''){r.writeAttribute('style','height: 16px; width:'+w+';');}r.addClass('sapUiProgInd');r.writeClasses();r.write('>');r.write('<div');r.writeAttribute('id',p.getId()+'-box');if(p.getWidth()&&p.getWidth()!==''){r.writeAttribute('style','height: 16px; width:'+b+';');}r.addClass('sapUiProgIndBorder');r.writeClasses();r.write('>');r.write('<div');r.writeAttribute('id',p.getId()+'-bar');r.writeAttribute('style','height: 14px; width:'+p.getPercentValue()+'%;');var B=p.getBarColor();switch(B){case"POSITIVE":r.addClass('sapUiProgIndBarPos');break;case"NEGATIVE":r.addClass('sapUiProgIndBarNeg');break;case"CRITICAL":r.addClass('sapUiProgIndBarCrit');break;case"NEUTRAL":r.addClass('sapUiProgIndBar');break;default:r.addClass('sapUiProgIndBar');break;}r.writeClasses();r.write('>');r.write('<div');r.writeAttribute('id',p.getId()+'-end');if(a>100){r.addClass(p._getProgIndTypeClass(B));}else{r.addClass('sapUiProgIndEndHidden');}r.writeClasses();if(p.bRtl){r.writeAttribute('style','position: relative; right:'+b);}else{r.writeAttribute('style','position: relative; left:'+b);}r.write('>');r.write('</div>');r.write('<span');r.addClass('sapUiProgIndFont');r.writeClasses();r.write('>');if(p.getShowValue()&&p.getShowValue()){if(p.getDisplayValue()&&p.getDisplayValue()!==''){r.writeEscaped(p.getDisplayValue());}}r.write('</span>');r.write('</div>');r.write('</div>');r.write('</div>');};
return P;},true);
sap.ui.predefine('sap/ui/commons/RadioButton',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','./RadioButtonRenderer','sap/ui/core/library','sap/ui/Device',"sap/ui/dom/jquery/Selectors"],function(q,l,C,R,c,D){"use strict";var T=c.TextDirection;var V=c.ValueState;
var a=C.extend("sap.ui.commons.RadioButton",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.commons",properties:{text:{type:"string",group:"Data",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},selected:{type:"boolean",group:"Data",defaultValue:false},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},groupName:{type:"string",group:"Behavior",defaultValue:'sapUiRbDefaultGroup'},key:{type:"string",group:"Data",defaultValue:null}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{}}}});
a.prototype.init=function(){this._changeGroupName(this.getGroupName());};
a.prototype.exit=function(){var g=this.getGroupName(),G=this._groupNames[g];G.splice(G.indexOf(this),1);};
a.prototype.onclick=function(e){if(this.getEnabled()&&e.target.id==(this.getId()+"-RB")){this.focus();}if(D.browser.msie&&(!this.getEnabled())){this.$().attr("tabindex",0).toggleClass("sapUiRbFoc");}this.userSelect(e);};
a.prototype._groupNames={};
a.prototype.onsapspace=function(e){if(this.getEnabled()&&e.target.id==(this.getId()+"-RB")){this.focus();}this.userSelect(e);};
a.prototype.onsaptabnext=function(e){if(D.browser.msie){this.bTabPressed=true;var t=this;window.setTimeout(function(){t.bTabPressed=false;},100);}};
a.prototype.onfocusin=function(e){if(this.getEnabled()&&e.target.id==(this.getId()+"-RB")){if(this.bTabPressed){var f=q(":sapFocusable"),F=false;for(var i=0;i<f.length;i++){if(F&&f[i].parentNode!=e.target&&f[i].tabIndex!="-1"){f[i].focus();e.preventDefault();break;}if(e.target==f[i]){F=true;}}}else{this.focus();}}};
a.prototype.onfocusout=function(e){if(D.browser.msie&&(!this.getEnabled())){this.$().attr("tabindex",-1).toggleClass("sapUiRbFoc");}};
a.prototype.userSelect=function(e){if(this.getEnabled()&&this.getEditable()){var s=this.getSelected();if(!s){this.setSelected(true);this.fireSelect({});}}else{e.preventDefault();}};
a.prototype.setSelected=function(s){var o,S=this.getSelected(),g=this.getGroupName(),b=this._groupNames[g],L=b&&b.length;this.setProperty("selected",s,true);if(s&&g&&g!==""){for(var i=0;i<L;i++){o=b[i];if(o instanceof a&&o!==this&&o.getSelected()){o.setSelected(false);}}}if((S!=s)&&this.getDomRef()&&this.getRenderer().setSelected){this.getRenderer().setSelected(this,s);}return this;};
a.prototype.setGroupName=function(g){g=this.validateProperty("groupName",g);this._changeGroupName(g,this.getGroupName());return this.setProperty("groupName",g,false);};
a.prototype.getTooltipDomRefs=function(){return this.getDomRef().children;};
a.prototype._changeGroupName=function(n,o){var N=this._groupNames[n],O=this._groupNames[o];if(!N){N=this._groupNames[n]=[];}if(N.indexOf(this)===-1){N.push(this);}if(O&&O.indexOf(this)!==-1){O.splice(O.indexOf(this),1);}};
return a;});
sap.ui.predefine('sap/ui/commons/RadioButtonGroup',['sap/base/Log','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./RadioButton','./RadioButtonGroupRenderer','sap/ui/core/library'],function(L,l,C,I,R,a,c){"use strict";var V=c.ValueState;
var b=C.extend("sap.ui.commons.RadioButtonGroup",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},columns:{type:"int",group:"Appearance",defaultValue:1},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},selectedIndex:{type:"int",group:"Data",defaultValue:0},enabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selectedIndex:{type:"int"}}}}}});
b.prototype.exit=function(){this.destroyItems();if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation;}};
b.prototype.onBeforeRendering=function(){if(this.getSelectedIndex()>this.getItems().length){L.warning("Invalid index, set to 0");this.setSelectedIndex(0);}};
b.prototype.onAfterRendering=function(){this.initItemNavigation();for(var i=0;i<this.aRBs.length;i++){this.aRBs[i].getDomRef().setAttribute("aria-posinset",i+1);this.aRBs[i].getDomRef().setAttribute("aria-setsize",this.aRBs.length);}};
b.prototype.initItemNavigation=function(){var d=[];this._aActiveItems=[];var A=this._aActiveItems;var e=false;for(var i=0;i<this.aRBs.length;i++){A[d.length]=i;d.push(this.aRBs[i].getDomRef());if(!e&&this.aRBs[i].getEnabled()){e=true;}}if(e){e=this.getEnabled();}if(!e){if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation;}return;}if(!this.oItemNavigation){this.oItemNavigation=new I();this.oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleAfterFocus,this);this.addDelegate(this.oItemNavigation);}this.oItemNavigation.setRootDomRef(this.getDomRef());this.oItemNavigation.setItemDomRefs(d);this.oItemNavigation.setCycling(true);this.oItemNavigation.setColumns(this.getColumns());this.oItemNavigation.setSelectedIndex(this.getSelectedIndex());this.oItemNavigation.setFocusedIndex(this.getSelectedIndex());};
b.prototype.setSelectedIndex=function(s){var i=this.getSelectedIndex();if(s<0){L.warning("Invalid index, will not be changed");return this;}this.setProperty("selectedIndex",s,true);if(!isNaN(i)&&this.aRBs&&this.aRBs[i]){this.aRBs[i].setSelected(false);}if(this.aRBs&&this.aRBs[s]){this.aRBs[s].setSelected(true);}if(this.oItemNavigation){this.oItemNavigation.setSelectedIndex(s);this.oItemNavigation.setFocusedIndex(s);}return this;};
b.prototype.setSelectedItem=function(s){for(var i=0;i<this.getItems().length;i++){if(s.getId()==this.getItems()[i].getId()){this.setSelectedIndex(i);break;}}};
b.prototype.getSelectedItem=function(){return this.getItems()[this.getSelectedIndex()];};
b.prototype.addItem=function(i){this.myChange=true;this.addAggregation("items",i);i.attachEvent("_change",this._handleItemChanged,this);this.myChange=undefined;if(!this._bUpdateItems){if(this.getSelectedIndex()===undefined){this.setSelectedIndex(0);}}if(!this.aRBs){this.aRBs=[];}var d=this.aRBs.length;this.aRBs[d]=this.createRadioButton(i,d);return this;};
b.prototype.insertItem=function(o,d){this.myChange=true;this.insertAggregation("items",o,d);o.attachEvent("_change",this._handleItemChanged,this);this.myChange=undefined;if(!this.aRBs){this.aRBs=[];}var e=this.aRBs.length;if(!this._bUpdateItems){if(this.getSelectedIndex()===undefined||e==0){this.setSelectedIndex(0);}else if(this.getSelectedIndex()>=d){this.setProperty("selectedIndex",this.getSelectedIndex()+1,true);}}if(d>=e){this.aRBs[d]=this.createRadioButton(o,d);}else{for(var i=(e);i>d;i--){this.aRBs[i]=this.aRBs[i-1];if((i-1)==d){this.aRBs[i-1]=this.createRadioButton(o,d);}}}return this;};
b.prototype.createRadioButton=function(i,d){if(this.iIDCount==undefined){this.iIDCount=0;}else{this.iIDCount++;}var r=new R(this.getId()+"-"+this.iIDCount);r.setText(i.getText());r.setTooltip(i.getTooltip());if(this.getEnabled()){r.setEnabled(i.getEnabled());}else{r.setEnabled(false);}r.setKey(i.getKey());r.setTextDirection(i.getTextDirection());r.setEditable(this.getEditable());r.setGroupName(this.getId());r.setValueState(this.getValueState());r.setParent(this);if(d==this.getSelectedIndex()){r.setSelected(true);}r.attachEvent('select',this.handleRBSelect,this);return r;};
b.prototype.removeItem=function(e){var i=e;if(typeof(e)=="string"){e=sap.ui.getCore().byId(e);}if(typeof(e)=="object"){i=this.indexOfItem(e);}this.myChange=true;var o=this.removeAggregation("items",i);o.detachEvent("_change",this._handleItemChanged,this);this.myChange=undefined;if(!this.aRBs){this.aRBs=[];}if(!this.aRBs[i]){return null;}this.aRBs[i].destroy();this.aRBs.splice(i,1);if(!this._bUpdateItems){if(this.aRBs.length==0){this.setSelectedIndex(undefined);}else if(this.getSelectedIndex()==i){this.setSelectedIndex(0);}else if(this.getSelectedIndex()>i){this.setProperty("selectedIndex",this.getSelectedIndex()-1,true);}}return o;};
b.prototype.removeAllItems=function(){this.myChange=true;var d=this.removeAllAggregation("items");for(var i=0;i<d.length;i++){d[i].detachEvent("_change",this._handleItemChanged,this);}this.myChange=undefined;if(!this._bUpdateItems){this.setSelectedIndex(undefined);}if(this.aRBs){while(this.aRBs.length>0){this.aRBs[0].destroy();this.aRBs.splice(0,1);}return d;}else{return null;}};
b.prototype.destroyItems=function(){this.myChange=true;var d=this.getItems();for(var i=0;i<d.length;i++){d[i].detachEvent("_change",this._handleItemChanged,this);}this.destroyAggregation("items");this.myChange=undefined;if(!this._bUpdateItems){this.setSelectedIndex(undefined);}if(this.aRBs){while(this.aRBs.length>0){this.aRBs[0].destroy();this.aRBs.splice(0,1);}}return this;};
b.prototype.updateItems=function(){var s=this.getSelectedIndex();this._bUpdateItems=true;this.updateAggregation("items");this._bUpdateItems=undefined;var i=this.getItems();if(s===undefined&&i.length>0){this.setSelectedIndex(0);}else if(s>=0&&i.length==0){this.setSelectedIndex(undefined);}else if(s>=i.length){this.setSelectedIndex(i.length-1);}};
b.prototype.clone=function(){var d=this.getItems();var i=0;for(i=0;i<d.length;i++){d[i].detachEvent("_change",this._handleItemChanged,this);}var o=C.prototype.clone.apply(this,arguments);for(i=0;i<d.length;i++){d[i].attachEvent("_change",this._handleItemChanged,this);}return o;};
b.prototype.handleRBSelect=function(o){for(var i=0;i<this.aRBs.length;i++){if(this.aRBs[i].getId()==o.getParameter("id")){this.setSelectedIndex(i);this.oItemNavigation.setSelectedIndex(i);this.oItemNavigation.setFocusedIndex(i);this.fireSelect({selectedIndex:i});break;}}};
b.prototype.setEditable=function(e){this.setProperty("editable",e,false);if(this.aRBs){for(var i=0;i<this.aRBs.length;i++){this.aRBs[i].setEditable(e);}}return this;};
b.prototype.setEnabled=function(e){this.setProperty("enabled",e,false);if(this.aRBs){for(var i=0;i<this.aRBs.length;i++){this.aRBs[i].setEnabled(e);}}return this;};
b.prototype.setValueState=function(v){this.setProperty("valueState",v,false);if(this.aRBs){for(var i=0;i<this.aRBs.length;i++){this.aRBs[i].setValueState(v);}}return this;};
b.prototype._handleAfterFocus=function(o){var i=o.getParameter("index");var e=o.getParameter("event");if(i!=this.getSelectedIndex()&&!(e.ctrlKey||e.metaKey)&&this.aRBs[i].getEditable()&&this.aRBs[i].getEnabled()){this.setSelectedIndex(i);this.oItemNavigation.setSelectedIndex(i);this.fireSelect({selectedIndex:i});}};
b.prototype._handleItemChanged=function(e){var o=e.oSource;var p=e.getParameter("name");var s=e.getParameter("newValue");var d=this.getItems();var r;for(var i=0;i<d.length;i++){if(d[i]==o){if(this.aRBs[i]){r=this.aRBs[i];}break;}}switch(p){case"text":r.setText(s);break;case"tooltip":r.setTooltip(s);break;case"enabled":if(this.getEnabled()){r.setEnabled(s);}break;case"key":r.setKey(s);break;case"textDirection":r.setTextDirection(s);break;default:break;}};
return b;});
sap.ui.predefine('sap/ui/commons/RadioButtonGroupRenderer',["sap/ui/core/library"],function(a){"use strict";var V=a.ValueState;var R={};
R.render=function(r,o){if(!o.aRBs){return;}var C=o.getColumns();var e=o.getEnabled();if(e){var I=o.getItems();e=false;for(var i=0;i<I.length;i++){if(I[i].getEnabled()){e=true;break;}}}r.write("<div");r.writeControlData(o);r.addClass("sapUiRbG");if(C>1){if(C==o.aRBs.length){r.addClass("sapUiRbG1Row");}else{r.addClass("sapUiRbGTab");if(o.getWidth()&&o.getWidth()!=''){r.addClass("sapUiRbGTabFlex");}}}if(o.getWidth()&&o.getWidth()!=''){r.addStyle("width",o.getWidth());}if(o.getTooltip_AsString()){r.writeAttributeEscaped("title",o.getTooltip_AsString());}if(e){r.writeAttribute('tabindex','0');}else{r.writeAttribute('tabindex','-1');}r.writeAccessibilityState(o,{role:"radiogroup",invalid:o.getValueState()==V.Error,disabled:!o.getEditable()});r.writeClasses();r.writeStyles();r.write(">");for(var c=0;c<C;c++){if(C>1&&C!=o.aRBs.length){r.write("<div");r.addClass("sapUiRbGCol");r.writeClasses();r.write(">");}for(var i=c;i<o.aRBs.length;i=i+C){r.renderControl(o.aRBs[i]);}if(C>1&&C!=o.aRBs.length){r.write("</div>");}}if(C>1&&C!=o.aRBs.length){r.write('<div class="sapUiRbGDummy"> </DIV>');}r.write("</div>");};
return R;},true);
sap.ui.predefine('sap/ui/commons/RadioButtonRenderer',['sap/ui/core/ValueStateSupport','sap/ui/core/library'],function(V,c){"use strict";var T=c.TextDirection;var a=c.ValueState;var R={};
R.render=function(r,o){var i=o.getId();var t=o.getTooltip_AsString();r.addClass("sapUiRb");r.write("<span");r.writeControlData(o);r.writeAccessibilityState(o,{role:"radio",checked:o.getSelected()===true,invalid:o.getValueState()==a.Error,disabled:!o.getEditable(),labelledby:i+"-label",describedby:t?i+"-Descr":undefined});var e=o.getEnabled()!=null&&o.getEnabled();var b=o.getEditable()!=null&&o.getEditable();var d=false;var f=false;if(o.getValueState()!=null){d=a.Error==o.getValueState();f=a.Warning==o.getValueState();}if(o.getSelected()){r.addClass("sapUiRbSel");}var m=0;var g=false;if(!e){m=-1;g=true;r.addClass("sapUiRbDis");}if(!b){g=true;r.addClass("sapUiRbRo");}if(d){r.addClass("sapUiRbErr");}else if(f){r.addClass("sapUiRbWarn");}if(e&&b&&!d&&!f){r.addClass("sapUiRbStd");}if(e&&b){r.addClass("sapUiRbInteractive");}r.writeClasses();if(o.getWidth()&&o.getWidth()!=''){r.writeAttribute("style","width:"+o.getWidth()+";");}r.writeAttribute("tabindex",m);var h=V.enrichTooltip(o,t?t:o.getText());if(h){r.writeAttributeEscaped("title",h);}r.write(">");r.write("<input type='radio' tabindex='-1' id='");r.write(i);r.write("-RB' name=\"");r.writeEscaped(o.getGroupName());r.write("\" ");if(o.getSelected()){r.write(" checked='checked'");}if(!e){r.write(" disabled='disabled'");}if(g){r.write(" readonly='readonly'");r.write(" disabled='disabled'");}if(o.getKey()){r.writeAttributeEscaped("value",o.getKey());}r.write(" />");r.write("<label id=\""+i+"-label\"");r.writeAttribute("for",i+"-RB");if(!o.getText()){r.write(" class=\"sapUiRbNoText\"");}r.write(">");if(o.getText()){this.renderText(r,o.getText(),o.getTextDirection());}r.write("</label>");if(t){r.write("<span id=\""+i+"-Descr\" style=\"visibility: hidden; display: none;\">");r.writeEscaped(t);r.write("</span>");}r.write("</span>");};
R.renderText=function(r,t,e){if(!e||e==T.Inherit){r.writeEscaped(t);}else{r.write("<span style=\"direction:"+e.toLowerCase()+";\">");r.writeEscaped(t);r.write("</span>");}};
R.setSelected=function(r,s){r.$().toggleClass('sapUiRbSel',s).attr('aria-checked',s);var d=r.getDomRef("RB");if(s){d.checked=true;d.setAttribute('checked','checked');}else{d.checked=false;d.removeAttribute('checked');}};
return R;},true);
sap.ui.predefine('sap/ui/commons/RangeSlider',['./Slider','./library','./RangeSliderRenderer'],function(S,l,R){"use strict";
var a=S.extend("sap.ui.commons.RangeSlider",{metadata:{library:"sap.ui.commons",properties:{value2:{type:"float",group:"Appearance",defaultValue:80}}}});
a.prototype.onAfterRendering=function(){this.oGrip2=this.getDomRef("grip2");S.prototype.onAfterRendering.apply(this);var v=this.getValue();var V=this.getValue2();if(V>=this.getMax()){V=this.getMax();}else if(V<v){V=v;}var n=(V-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl||this.getVertical()){n=this.getBarWidth()-n;}this.changeGrip(V,n,this.oGrip2);};
a.prototype.onresize=function(e){var n=this.getValue2();var N=(n-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl||this.getVertical()){N=this.getBarWidth()-N;}this.changeGrip(n,N,this.oGrip2);S.prototype.onresize.apply(this,arguments);};
a.prototype.onfocusin=function(e){this.oMovingGrip=e.target;};
a.prototype.onsaphome=function(e){if(this.getEditable()&&this.getEnabled()){var n=0;var N=0;if(this.oMovingGrip==this.oGrip){n=this.getMin();if(this.getVertical()||(this.bRtl&&!this.getVertical())){N=this.getBarWidth();}}else if(this.oMovingGrip==this.oGrip2){n=this.getValue();N=this.getOffsetLeft(this.oGrip)+this.iShiftGrip;}this.changeGrip(n,N,this.oMovingGrip);this.handleFireChange();}e.preventDefault();e.stopPropagation();};
a.prototype.onsapend=function(e){if(this.getEditable()&&this.getEnabled()){var n=0;var N=0;if(this.oMovingGrip==this.oGrip){n=this.getValue2();N=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip;}else if(this.oMovingGrip==this.oGrip2){n=this.getMax();if(this.getVertical()||(this.bRtl&&!this.getVertical())){N=0;}else{N=this.getBarWidth();}}this.changeGrip(n,N,this.oMovingGrip);this.handleFireChange();}e.preventDefault();e.stopPropagation();};
a.prototype.fireLiveChangeForGrip=function(g,n,o){if(g==this.oGrip){if(o!=n){this.fireLiveChange({value:n,value2:this.getValue2()});}}else if(g==this.oGrip2){if(o!=n){this.fireLiveChange({value2:n,value:this.getValue()});}}};
a.prototype.adjustHighlightBar=function(n,g){if(n<0||isNaN(n)){n=0;}var p=this.getOffsetLeft(this.oGrip)+this.iShiftGrip;var P=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip;var w;if(this.getVertical()){this.setLeft(P,this.oHiLi);this.setRight(this.getBarWidth()-p,this.oHiLi);w=Math.round(p-P);}else{if(this.bRtl){this.setLeft(P,this.oHiLi);this.setRight(this.getBarWidth()-p,this.oHiLi);}else{this.setLeft(p,this.oHiLi);this.setRight(this.getBarWidth()-P,this.oHiLi);}w=Math.abs(Math.round(P-p));}if(w<0){w=0;}this.setObjectWidth(w+'px',this.oHiLi);};
a.prototype.setRight=function(n,o){if(o==undefined){return;}if(this.getVertical()){o.style.bottom=n+'px';}else{o.style.right=n+'px';}};
a.prototype.updateValueProperty=function(n,g){if(g==this.oGrip){this.setProperty('value',n,true);}else{this.setProperty('value2',n,true);}};
a.prototype.setValue=function(v){this.setProperty('value',v,true);this._oldValue1=v;if(isNaN(v)){return this;}if(!this.oBar){return this;}var n=parseFloat(v);var N;if(n>=this.getValue2()){n=this.getValue2();N=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip;if(this.bRtl&&!this.getVertical()){N=this.getBarWidth()-N;}}else if(n<=this.getMin()){n=this.getMin();if(this.getVertical()){N=this.getBarWidth();}else{N=0;}}else{N=(n-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();}if(this.bRtl&&!this.getVertical()){N=this.getBarWidth()-N;}this.changeGrip(n,N,this.oGrip);this._oldValue1=n;return this;};
a.prototype.setValue2=function(v){this.setProperty('value2',v,true);this._oldValue2=v;if(isNaN(v)){return this;}if(!this.oBar){return this;}var n=parseFloat(v);var N;if(n>=this.getMax()){n=this.getMax();if(this.getVertical()){N=0;}else{N=this.getBarWidth();}}else if(n<=this.getValue()){n=this.getValue();N=this.getOffsetLeft(this.oGrip)+this.iShiftGrip;if(this.bRtl&&!this.getVertical()){N=this.getBarWidth()-N;}}else{N=(n-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();}if(this.bRtl&&!this.getVertical()){N=this.getBarWidth()-N;}this.changeGrip(n,N,this.oGrip2);this._oldValue2=n;return this;};
a.prototype.getLeftGrip=function(){return this.oGrip;};
a.prototype.getRightGrip=function(){return this.oGrip2;};
a.prototype.getValueForGrip=function(g){if(g==this.oGrip){return this.getValue();}else{return this.getValue2();}};
a.prototype.validateNewPosition=function(n,N,g,m){if(!this.bRtl&&!this.getVertical()){if(g==this.oGrip){if(m){if(n<=this.getMin()||N<=0){n=this.getMin();N=0;}}else{if(n>=this.getValue2()){n=this.getValue2();N=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip;}}}else{if(m){if(n<=this.getValue()){n=this.getValue();N=this.getOffsetLeft(this.oGrip)+this.iShiftGrip;}}else{if(n>=this.getMax()||N>=this.getBarWidth()){n=this.getMax();N=this.getBarWidth();}}}}else{if(g==this.oGrip){if(m){if(n<=this.getMin()||N>=this.getBarWidth()){n=this.getMin();N=this.getBarWidth();}}else{if(n>=this.getValue2()){n=this.getValue2();N=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip;}}}else{if(m){if(n<=this.getValue()){n=this.getValue();N=this.getOffsetLeft(this.oGrip)+this.iShiftGrip;}}else{if(n>=this.getMax()||N<=0){n=this.getMax();N=0;}}}}this.oGrip.setAttribute('aria-valuemax',this.getValue2());this.oGrip2.setAttribute('aria-valuemin',this.getValue());return{fNewValue:n,iNewPos:N};};
a.prototype.handleMove=function(e){var d=Math.abs(this.getOffsetLeft(this.oGrip2)-this.getOffsetLeft(this.oGrip));if(!this.bRtl){if(this.oMovingGrip==this.oGrip2&&this.getValue2()==this.getMax()&&(d<2)){this.oMovingGrip=this.oGrip;this.oGrip.focus();}else if(this.oMovingGrip==this.oGrip&&this.getValue()==this.getMin()&&(d<2)){this.oMovingGrip=this.oGrip2;this.oGrip2.focus();}}else{if(this.oMovingGrip==this.oGrip&&this.getValue2()==this.getMin()&&(d<2)){this.oMovingGrip=this.oGrip2;this.oGrip2.focus();}else if(this.oMovingGrip==this.oGrip2&&this.getValue()==this.getMax()&&(d<2)){this.oMovingGrip=this.oGrip;this.oGrip.focus();}}S.prototype.handleMove.apply(this,[e]);};
a.prototype.handleFireChange=function(n){var v=this.getValue();var V=this.getValue2();if(v!==this._oldValue1||V!==this._oldValue2){this._oldValue1=v;this._oldValue2=V;this.fireChange({value2:V,value:v});if(!n){this.fireLiveChange({value:v,value2:V});}}};
a.prototype.getNearestGrip=function(o){var m;var d=0;var D=0;if(this.getVertical()){d=Math.abs(o-this.getOffsetLeft(this.oGrip2));D=Math.abs(this.getOffsetLeft(this.oGrip)-o);if(d==D){if(o>D){m=this.oGrip;}else{m=this.oGrip2;}}else if(d>=D){m=this.oGrip;}else{m=this.oGrip2;}}else{d=Math.abs(o-this.getOffsetLeft(this.oGrip));D=Math.abs(this.getOffsetLeft(this.oGrip2)-o);if(d==D){if((o>D&&!this.bRtl)||(o<D&&this.bRtl)){m=this.oGrip2;}else{m=this.oGrip;}}else if(d<=D){m=this.oGrip;}else{m=this.oGrip2;}}return m;};
a.prototype.setObjectWidth=function(n,o){if(this.getVertical()){o.style.height=n;}else{o.style.width=n;}};
a.prototype.targetIsGrip=function(m){if(m==this.oGrip.id||m==this.oGrip2.id){return true;}return false;};
a.prototype.setAriaState=function(){S.prototype.setAriaState.apply(this);var v=this.getValue2();if(this.bTextLabels){v=this.getNearestLabel(v);}this.oGrip2.setAttribute('aria-valuenow',v);};
return a;});
sap.ui.predefine('sap/ui/commons/RangeSliderRenderer',['./SliderRenderer','sap/ui/core/Renderer'],function(S,R){"use strict";var a=R.extend(S);
a.renderGrip=function(r,s){r.write('<div');r.writeAttribute('id',s.getId()+'-grip');if(s.getEnabled()){r.writeAttribute('tabindex','0');}else{r.writeAttribute('tabindex','-1');}r.writeAttribute('class','sapUiSliGrip');r.writeAttribute('title',s.getValue());r.writeAccessibilityState(s,{role:'slider',controls:s.getId()+'-grip2',orientation:'horizontal',valuemin:s.getMin(),valuemax:s.getValue2(),live:'assertive',disabled:!s.getEditable()||!s.getEnabled(),describedby:s.getTooltip_AsString()?(s.getId()+'-Descr '+s.getAriaDescribedBy().join(" ")):undefined});r.write('>&#9650;</div>');r.write('<div');r.writeAttribute('id',s.getId()+'-grip2');if(s.getEnabled()){r.writeAttribute('tabindex','0');}else{r.writeAttribute('tabindex','-1');}r.writeAttribute('class','sapUiSliGrip');r.writeAttribute('title',s.getValue2());var o='horizontal';if(s.getVertical()){o='vertical';}r.writeAccessibilityState(s,{role:'slider',controls:s.getId()+'-grip',orientation:o,valuemin:s.getValue(),valuemax:s.getMax(),disabled:!s.getEditable()||!s.getEnabled(),describedby:s.getTooltip_AsString()?(s.getId()+'-Descr '+s.getAriaDescribedBy().join(" ")):undefined});r.write('>&#9650;</div>');};
a.controlAdditionalCode=function(r,s){r.addClass('sapUiRSli');};
return a;},true);
sap.ui.predefine('sap/ui/commons/RatingIndicator',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','sap/ui/core/theming/Parameters','./RatingIndicatorRenderer','sap/ui/Device','sap/ui/events/checkMouseEnterOrLeave'],function(q,l,C,P,R,D,c){"use strict";var a=l.RatingIndicatorVisualMode;
var b=C.extend("sap.ui.commons.RatingIndicator",{metadata:{library:"sap.ui.commons",properties:{editable:{type:"boolean",group:"Behavior",defaultValue:true},maxValue:{type:"int",group:"Behavior",defaultValue:5},value:{type:"float",group:"Behavior",defaultValue:0,bindable:"bindable"},averageValue:{type:"float",group:"Behavior",defaultValue:0},iconSelected:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},iconUnselected:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},iconHovered:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},visualMode:{type:"sap.ui.commons.RatingIndicatorVisualMode",group:"Behavior",defaultValue:a.Half}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"int"}}}}}});
b.NoValue=-9999;
b.prototype.init=function(){this.iHoveredRating=-1;};
b.prototype.exit=function(){};
b.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate();}};
b.prototype.ondragstart=function(e){e.preventDefault();};
b.prototype._getDisplayValue=function(){var v=this.getValue();if(v==b.NoValue){return this.getAverageValue();}else{return v;}};
b.prototype.onsapincrease=function(e){var n=this.iHoveredRating;if(n==-1){n=Math.round(this._getDisplayValue())-1;if(n==-1){n=0;}}if(n<this.getMaxValue()){n=n+1;}else{n=this.getMaxValue();}this.updateHoverState(e,n);};
b.prototype.onsapdecrease=function(e){var n=this.iHoveredRating;if(n==-1&&Math.round(this._getDisplayValue())==0){return;}if(n==-1){n=Math.round(this._getDisplayValue())+1;}if(n>1){n=n-1;}else{n=1;}this.updateHoverState(e,n);};
b.prototype.onsaphome=function(e){this.updateHoverState(e,1);};
b.prototype.onsapend=function(e){this.updateHoverState(e,this.getMaxValue());};
b.prototype.onsapselect=function(e){this.saveValue(e,true,this.iHoveredRating);};
b.prototype.onsapescape=function(e){this.saveValue(e,true,-1);};
b.prototype.onfocusout=function(e){if(D.browser.msie&&e.target!=this.getDomRef()){return;}this.saveValue(e,false,this.iHoveredRating);};
b.prototype.onfocusin=function(e){if(D.browser.msie&&e.target!=this.getDomRef()){this.getDomRef().focus();}};
b.prototype.onclick=function(e){this.saveValue(e,true,this.getSymbolValue(e));};
b.prototype.onmouseover=function(e){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return;}this.iHoveredRating=-1;var s=this.getSymbolValue(e);if(s==-1){return;}for(var i=1;i<=s;i++){R.hoverRatingSymbol(i,this);}for(var i=s+1;i<=this.getMaxValue();i++){R.hoverRatingSymbol(i,this,true);}};
b.prototype.onmouseout=function(e){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return;}if(c(e,this.getDomRef())){this.iHoveredRating=-1;for(var i=1;i<=this.getMaxValue();i++){R.unhoverRatingSymbol(i,this);}}};
b.prototype.getSymbolValue=function(e){var s=q(e.target);if(s.hasClass("sapUiRatingItmImg")||s.hasClass("sapUiRatingItmOvrflw")){s=q(e.target.parentNode);}else if(s.hasClass("sapUiRatingItmOvrflwImg")){s=q(e.target.parentNode.parentNode);}var i=s.attr("itemvalue");if(i){return parseInt(i);}return-1;};
b.prototype.updateKeyboardHoverState=function(s){for(var i=1;i<=this.getMaxValue();i++){R.unhoverRatingSymbol(i,this);if(i<=this.iHoveredRating){R.hoverRatingSymbol(i,this);}else if(!s){R.hoverRatingSymbol(i,this,true);}}this.setAriaState();};
b.prototype.onAfterRendering=function(){this.setAriaState();};
b.prototype.setAriaState=function(){var v=this.iHoveredRating==-1?this._getDisplayValue():this.iHoveredRating;this.$().attr("aria-valuenow",v).attr("aria-valuetext",this._getText("RATING_ARIA_VALUE",[v])).attr("aria-label",this._getText("RATING_ARIA_NAME"));};
b.prototype._getText=function(k,A){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(r){return r.getText(k,A);}return k;};
b.prototype.saveValue=function(e,d,n){if(d){e.preventDefault();}if(!this.getEditable()){return false;}this.iHoveredRating=-1;if(n!=-1&&n!=this.getValue()){this.setValue(n);this.fireChange({value:n});return true;}else{for(var i=1;i<=this.getMaxValue();i++){R.unhoverRatingSymbol(i,this);}this.setAriaState();return false;}};
b.prototype.updateHoverState=function(e,n){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return;}this.iHoveredRating=n;this.updateKeyboardHoverState();};
b.prototype.setMaxValue=function(m){if(m<1){m=1;}this.setProperty("maxValue",m);return this;};
b.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");return{role:"slider",type:B.getText("ACC_CTR_TYPE_RATING"),description:B.getText("ACC_CTR_STATE_RATING",[this._getDisplayValue(),this.getMaxValue()]),focusable:true,editable:this.getEditable()};};
return b;});
sap.ui.predefine('sap/ui/commons/RatingIndicatorRenderer',['sap/ui/core/theming/Parameters'],function(P){"use strict";var R=function(){};
R.render=function(r,o){var n=o.getMaxValue();r.write("<div");r.writeControlData(o);r.addClass("sapUiRating");if(o.getEditable()){r.addClass("sapUiRatingEdit");}r.writeClasses();r.writeAttribute("tabindex","0");if(o.getTooltip()&&o.getTooltip_AsString()){r.writeAttributeEscaped("title",o.getTooltip_AsString());}else if(!o.getEditable()){r.writeAttribute("title",o._getDisplayValue());}r.writeAccessibilityState(o,{"role":"slider","orientation":"horizontal","valuemin":1,"valuemax":n,"disabled":!o.getEditable(),"live":"assertive"});r.write(">");for(var i=0;i<n;i++){R.renderItem(r,o,i,o._getDisplayValue());}r.write("</div>");};
R.renderItem=function(r,o,i,v){var a=i+1;r.write("<div");r.writeAttribute("id",o.getId()+"-itm-"+a);r.writeAttribute("itemvalue",a);r.writeAttribute("class","sapUiRatingItm");r.writeAttribute("style","line-height:0px;");if(!o.getTooltip()&&o.getEditable()){r.writeAttributeEscaped("title",o._getText("RATING_TOOLTIP",[a,o.getMaxValue()]));}r.write(">");r.write("<img");r.writeAttribute("class","sapUiRatingItmImg");var I=R.getThemeSymbol("selected",o);r.writeAttributeEscaped("src",I);r.write("/>");r.write("<div");r.writeAttribute("class","sapUiRatingItmOvrflw");var b=o.getVisualMode();if(b=="Full"){v=Math.round(v);}var s;if(v>=a){s="width:0%;";}else if(v<i){s="width:100%;";}else{var d=v-i;if(b=="Half"){var w=50;if(d<0.25){w=100;}if(d>=0.75){w=0;}s="width:"+w+"%;";}else{s="width:"+(100-Math.round(d*100))+"%;";}}r.writeAttribute("style",s);r.write(">");r.write("<img");r.writeAttribute("class","sapUiRatingItmOvrflwImg");I=R.getThemeSymbol("unselected",o);r.writeAttributeEscaped("src",I);r.write("/>");r.write("</div>");r.write("</div>");};
R.hoverRatingSymbol=function(c,r,a){var s=r.$("itm-"+c);s.addClass("sapUiRatingItmHov");var S=s.children("img");var i=R.getThemeSymbol(a?"unselected":"hover",r);S.attr("src",i);};
R.unhoverRatingSymbol=function(c,r){var s=r.$("itm-"+c);s.removeClass("sapUiRatingItmHov");var S=s.children("img");var i=R.getThemeSymbol("selected",r);S.attr("src",i);};
R.getThemeSymbol=function(t,r){var i,p;if(t=="selected"){i=r.getIconSelected();p="_sap_ui_commons_RatingIndicator_SymbolSelected";}else if(t=="unselected"){i=r.getIconUnselected();p="_sap_ui_commons_RatingIndicator_SymbolUnselected";}else{i=r.getIconHovered();p="_sap_ui_commons_RatingIndicator_SymbolHovered";}if(!i){i=P._getThemeImage(p);}return i;};
return R;},true);
sap.ui.predefine('sap/ui/commons/ResponsiveContainer',['./library','sap/ui/core/Control','sap/ui/core/ResizeHandler','./ResponsiveContainerRenderer'],function(l,C,R,a){"use strict";
var b=C.extend("sap.ui.commons.ResponsiveContainer",{metadata:{library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'}},aggregations:{ranges:{type:"sap.ui.commons.ResponsiveContainerRange",multiple:true,singularName:"range"},content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{defaultContent:{type:"sap.ui.core.Control",multiple:false}},events:{rangeSwitch:{parameters:{currentRange:{type:"sap.ui.commons.ResponsiveContainerRange"}}}}}});
b.prototype.init=function(){this.oCurrentRange=null;};
b.prototype.exit=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
b.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}if(!this.getAggregation("content")){var d=sap.ui.getCore().byId(this.getDefaultContent());this.setAggregation("content",d);}};
b.prototype.onAfterRendering=function(){var r=this.onresize.bind(this);this.sResizeListenerId=R.register(this.getDomRef(),r);this.refreshRangeDimensions();if(!this.oCurrentRange){setTimeout(r,0);}};
b.prototype.onresize=function(e){var r=this.findMatchingRange(),c=r&&r.getContent(),n;if(this.oCurrentRange!=r){this.oCurrentRange=r;if(!r){c=this.getDefaultContent();}n=sap.ui.getCore().byId(c);this.setAggregation("content",n);this.fireRangeSwitch({currentRange:this.oCurrentRange});}};
b.prototype.refreshRangeDimensions=function(){var r=this.getRanges(),c=[],$;r.forEach(function(o){$=o.$();c.push({range:o,width:$.width(),height:$.height()});});this.aRangeDimensions=c;};
b.prototype.findMatchingRange=function(){var c=this.$(),w=c.width(),h=c.height(),r,i,d=this.aRangeDimensions,m=null;d.forEach(function(o){r=o.width||w;i=o.height||h;if(r<=w&&i<=h){o.area=r*i;if(!m||m.area<o.area){m=o;}}});return m&&m.range;};
return b;});
sap.ui.predefine('sap/ui/commons/ResponsiveContainerRange',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var R=E.extend("sap.ui.commons.ResponsiveContainerRange",{metadata:{library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},key:{type:"string",group:"Misc",defaultValue:''}},associations:{content:{type:"sap.ui.core.Control",multiple:false}}}});
return R;});
sap.ui.predefine('sap/ui/commons/ResponsiveContainerRenderer',[],function(){"use strict";var R=function(){};
R.render=function(r,c){var C=c.getAggregation("content");r.write("<div ");r.writeControlData(c);r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeStyles();r.write(">");if(C){r.renderControl(C);}r.write("<div ");r.addStyle("width","0px");r.addStyle("height","0px");r.addStyle("overflow","hidden");r.writeStyles();r.write(">");c.getRanges().forEach(function(o){r.write("<div ");r.writeElementData(o);r.addStyle("width",o.getWidth());r.addStyle("height",o.getHeight());r.writeStyles();r.write("></div>");});r.write("</div>");r.write("</div>");};
return R;},true);
sap.ui.predefine('sap/ui/commons/RichTooltip',['sap/ui/thirdparty/jquery','./library','sap/ui/core/TooltipBase','./RichTooltipRenderer','./FormattedTextView','sap/ui/dom/jquery/control'],function(q,l,T,R,F){"use strict";
var a=T.extend("sap.ui.commons.RichTooltip",{metadata:{library:"sap.ui.commons",properties:{title:{type:"string",group:"Misc",defaultValue:null},imageSrc:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},valueStateText:{type:"string",group:"Misc",defaultValue:null},imageAltText:{type:"string",group:"Misc",defaultValue:null}},aggregations:{formattedText:{type:"sap.ui.commons.FormattedTextView",multiple:false,visibility:"hidden"},individualStateText:{type:"sap.ui.commons.FormattedTextView",multiple:false,visibility:"hidden"}}}});
a.prototype.onAfterRendering=function(){var t=this.getAggregation("formattedText");if(t&&t.getDomRef()){t.$().attr("role","tooltip");if(this.getImageSrc()!==""){this.$().addClass("sapUiRttContentWide");}}};
a.prototype.setValueStateText=function(t){var v=this.getAggregation("individualStateText");if(t){if(v){v.setHtmlText(t);}else{v=new F(this.getId()+"-valueStateText",{htmlText:t}).addStyleClass("sapUiRttValueStateText").addStyleClass("individual");this.setAggregation("individualStateText",v);this.setProperty("valueStateText",t,true);}}else{if(v){this.setAggregation("individualStateText",v);}}return this;};
a.prototype.getValueStateText=function(){var v=this.getAggregation("individualStateText");if(v){return v.getHtmlText();}return"";};
a.prototype.setText=function(t){if(t){t=t.replace(/(\r\n|\n|\r)/g,"<br />");}var o=this.getAggregation("formattedText");if(o){o.setHtmlText(t);}else{o=new F(this.getId()+"-txt");o.setHtmlText(t);o.addStyleClass("sapUiRttText");this.setAggregation("formattedText",o);this.setProperty("text",t,true);}return this;};
a.prototype.getText=function(){var t=this.getAggregation("formattedText");if(t){return t.getHtmlText();}return"";};
a.prototype.onfocusin=function(e){T.prototype.onfocusin.apply(this,arguments);var s=q(e.target).control(0);if(s!=null){var i=this.getId();var I="";if(this.getTitle()!==""){I+=i+"-title ";}var $=this.$("valueStateText");if($.length>0){I+=i+"-valueStateText ";}if(this.getImageSrc()!==""){I+=i+"-image ";}if(this.getText()!==""){I+=i+"-txt";}var d=s.getFocusDomRef();d.setAttribute("aria-describedby",I);}};
return a;});
sap.ui.predefine('sap/ui/commons/RichTooltipRenderer',['sap/ui/core/ValueStateSupport','sap/ui/core/library'],function(V,c){"use strict";var a=c.ValueState;var R={};
R.render=function(r,o){var i=o.getId();r.write("<div ");r.writeControlData(o);r.addClass("sapUiRtt");r.writeClasses();r.write(" ><div><div>");r.write("<div class='sapUiRttTopL'></div><div class='sapUiRttTopR'></div>");r.write("<div class='sapUiRttCL'>");r.write("<div class='sapUiRttCR'>");r.write("<div class='sapUiRttContent'>");var t=o.getTitle();if(t){r.write("<div id='"+i+"-title' role='tooltip' class='sapUiRttTitle'>");r.writeEscaped(t);r.write("</div>");r.write("<div class='sapUiRttSep'></div>");}var v=V.getAdditionalText(o.getParent());var I=o.getAggregation("individualStateText");if(v||I){r.write('<div class="sapUiRttValueStateContainer">');if(v){var s=o.getParent().getValueState();var b=s!==a.None?"ValueState_"+s+".png":"";if(b!==""){b=sap.ui.require.toUrl("sap/ui/commons/themes/"+sap.ui.getCore().getConfiguration().getTheme()+"/img/richtooltip/"+b);r.write('<img id="'+i+'-valueStateImage" class="sapUiRttValueStateImage" src="');r.writeEscaped(b);r.write('"/>');}}if(I){r.renderControl(I);}else{r.write('<div id="'+i+'-valueStateText" class="sapUiRttValueStateText">');r.writeEscaped(v);r.write('</div>');}r.write('</div>');r.write("<div class='sapUiRttSep'></div>");}r.write('<div class="sapUiRttContentContainer">');var d=o.getImageSrc();if(d){var A=o.getImageAltText();r.write('<img id="'+i+'-image" class="sapUiRttImage"');r.writeAttributeEscaped('alt',A);r.writeAttributeEscaped('src',d);r.write('"/>');}var T=o.getAggregation("formattedText");if(T){r.renderControl(T);}r.write('</div>');r.write("</div></div></div>");r.write("<div class='sapUiRttBotL'></div>");r.write("<div class='sapUiRttBotR'></div>");r.write("</div></div></div>");};
return R;},true);
sap.ui.predefine('sap/ui/commons/RoadMap',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','./RoadMapRenderer','sap/ui/core/ResizeHandler','sap/ui/Device'],function(q,l,C,R,a,D){"use strict";
var b=C.extend("sap.ui.commons.RoadMap",{metadata:{library:"sap.ui.commons",properties:{numberOfVisibleSteps:{type:"int",group:"Misc",defaultValue:null},firstVisibleStep:{type:"string",group:"Misc",defaultValue:null},selectedStep:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'}},defaultAggregation:"steps",aggregations:{steps:{type:"sap.ui.commons.RoadMapStep",multiple:true,singularName:"step"}},events:{stepSelected:{parameters:{stepId:{type:"string"}}},stepExpanded:{parameters:{stepId:{type:"string"}}}}}});
(function(){
b.prototype.init=function(){this.iStepWidth=-1;this.sCurrentFocusedStepRefId=null;};
b.prototype.exit=function(){if(this.sResizeListenerId){a.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
b.prototype.setNumberOfVisibleSteps=function(n){var i=this.getDomRef()?true:false;this.setProperty("numberOfVisibleSteps",n,i);if(i){R.updateScrollArea(this,true);}return this;};
b.prototype.setFirstVisibleStep=function(F){var i=this.getDomRef()?true:false;if(i){if(F){var S=sap.ui.getCore().byId(F);if(S&&S.getParent()&&(S.getParent()===this||S.getParent().getParent()===this)&&S.getVisible()){this.setProperty("firstVisibleStep",F,true);R.updateScrollArea(this);}}else{this.setProperty("firstVisibleStep","",true);R.updateScrollArea(this);}}else{this.setProperty("firstVisibleStep",F);}return this;};
b.prototype.setWidth=function(w){var i=this.getDomRef()?true:false;this.setProperty("width",w,i);if(i){R.setRoadMapWidth(this,w);R.updateScrollArea(this,true);}return this;};
b.prototype.setSelectedStep=function(S){var i=this.getDomRef()?true:false;if(i){if(S){var o=sap.ui.getCore().byId(S);if(o&&o.getParent()&&(o.getParent()===this||o.getParent().getParent()===this)&&o.getEnabled()&&o.getVisible()){R.selectStepWithId(this,S);this.setProperty("selectedStep",S,true);}}else{R.selectStepWithId(this,"");this.setProperty("selectedStep","",true);}}else{this.setProperty("selectedStep",S);}return this;};
b.prototype.onThemeChanged=function(e){this.iStepWidth=-1;if(this.getDomRef()){this.invalidate();}};
b.prototype.doBeforeRendering=function(){var I=false;var c=false;var S=this.getSteps();for(var i=0;i<S.length;i++){var o=S[i];if(o.getSubSteps().length==0||!o.getEnabled()){o.setProperty("expanded",false,true);}if(!o.getEnabled()&&!o.getVisible()&&this.getSelectedStep()==o.getId()){this.setProperty("selectedStep","",true);}else if(o.getEnabled()&&o.getVisible()&&this.getSelectedStep()==o.getId()){I=true;}if(o.getVisible()&&this.getFirstVisibleStep()==o.getId()){c=true;}var d=o.getSubSteps();for(var j=0;j<d.length;j++){var e=d[j];e.setProperty("expanded",false,true);if(!e.getEnabled()&&!e.getVisible()&&this.getSelectedStep()==e.getId()){this.setProperty("selectedStep","",true);}else if(e.getEnabled()&&e.getVisible()&&this.getSelectedStep()==e.getId()){I=true;}if(e.getVisible()&&this.getFirstVisibleStep()==e.getId()){c=true;}}}if(!I){this.setProperty("selectedStep","",true);}if(!c){this.setProperty("firstVisibleStep","",true);}if(this.sResizeListenerId){a.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
b.prototype.onAfterRendering=function(){var S=this.getSteps();if(this.iStepWidth==-1&&S.length>0){var c=S[0].$();this.iStepWidth=c.outerWidth();}for(var i=0;i<S.length;i++){var o=S[i];R.addEllipses(o);var d=o.getSubSteps();for(var j=0;j<d.length;j++){R.addEllipses(d[j]);}}R.updateScrollArea(this);this.sResizeListenerId=a.register(this.getDomRef(),q.proxy(this.onresize,this));};
b.prototype.onresize=function(e){var d=function(){if(this.getDomRef()){R.updateScrollArea(this,true);r(this,"prev");this.sResizeInProgress=null;}}.bind(this);if(D.browser.firefox){d();}else{if(!this.sResizeInProgress){this.sResizeInProgress=setTimeout(d,300);}}};
b.prototype.onclick=function(e){h(this,e);};
b.prototype.onsapselect=function(e){h(this,e);};
b.prototype.onfocusin=function(e){var t=q(e.target);var T=t.attr("id");if(T&&T.endsWith("-box")){this.sCurrentFocusedStepRefId=T.slice(0,-4);}else if(T&&(T.endsWith("-Start")||T.endsWith("-End"))){}else{this.sCurrentFocusedStepRefId=R.getFirstVisibleRef(this).attr("id");r(this);}this.$().attr("tabindex","-1");};
b.prototype.onfocusout=function(e){this.$().attr("tabindex","0");};
b.prototype.onsapprevious=function(e){f(e,this,"prev");};
b.prototype.onsapnext=function(e){f(e,this,"next");};
b.prototype.onsaphome=function(e){f(e,this,"first");};
b.prototype.onsapend=function(e){f(e,this,"last");};
var h=function(t,e){e.stopPropagation();e.preventDefault();var T=q(e.target);var c=T.attr("id");if(!c){return;}var i=c.lastIndexOf("-expandend");if(i!=-1){var S=sap.ui.getCore().byId(c.substring(0,i));if(S&&t.indexOfStep(S)>=0){S.handleSelect(e,true);return;}}if(c==t.getId()+"-Start"){if(T.hasClass("sapUiRoadMapStartScroll")){s(t,"prev",true);}else{r(t);}}else if(c==t.getId()+"-End"){if(T.hasClass("sapUiRoadMapEndScroll")){s(t,"next",true);}else{r(t);}}};var s=function(t,d,u){R.scrollToNextStep(t,d,function(F){var i=F.lastIndexOf("-expandend");if(i!=-1){F=F.substring(0,i);}t.setProperty("firstVisibleStep",F,true);if(u){r(t,d);}});};var f=function(e,t,d){if(e){e.stopPropagation();e.preventDefault();}if(!t.sCurrentFocusedStepRefId){return;}var F=d+"All";var i=false;if(d=="first"){F="prevAll";i=true;}else if(d=="last"){F="nextAll";i=true;}var c=q(document.getElementById(t.sCurrentFocusedStepRefId));var j=c[F](":visible");var g=q(j.get(i?j.length-1:0)).attr("id");if(g){if(!R.isVisibleRef(t,g)){s(t,d);}document.getElementById(g+"-box").focus();}};var r=function(t,d){if(!t.sCurrentFocusedStepRefId){return;}if(d&&!R.isVisibleRef(t,t.sCurrentFocusedStepRefId)){f(null,t,d);}else{document.getElementById(t.sCurrentFocusedStepRefId+"-box").focus();}};}());return b;});
sap.ui.predefine('sap/ui/commons/RoadMapRenderer',['sap/ui/thirdparty/jquery','sap/ui/Device','sap/base/security/encodeXML','sap/ui/thirdparty/jqueryui/jquery-ui-position'],function(q,D,e){"use strict";var R={};
R.render=function(j,l){l.doBeforeRendering();j.write("<div");j.writeControlData(l);j.addClass("sapUiRoadMap");j.writeClasses();j.writeAttribute("tabindex","0");var T=l.getTooltip_AsString();if(T){j.writeAttributeEscaped("title",T);}j.writeAttribute("style","width:"+(l.getWidth()?l.getWidth():"100%")+";");j.write(">");r(j,l,true);j.write("<ul");j.writeAttribute("id",l.getId()+"-steparea");j.addClass("sapUiRoadMapStepArea");j.writeClasses();if(sap.ui.getCore().getConfiguration().getAccessibility()){j.writeAttribute("role","group");j.writeAttributeEscaped("aria-label",m("RDMP_DEFAULT_TOOLTIP",[]));if(T){j.writeAttributeEscaped("title",T);}}j.write(">");var S=l.getSteps();for(var i=0;i<S.length;i++){var x=S[i];if(x.getSubSteps().length>0){h(j,l,x);}else{a(j,l,x);}}j.write("</ul>");r(j,l,false);j.write("</div>");};
R.selectStepWithId=function(i,I){var C=i.getSelectedStep();if(C){Q(C).removeClass("sapUiRoadMapSelected");}if(I){Q(I).addClass("sapUiRoadMapSelected");}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(C){Q(C+"-box").removeAttr("aria-checked");}if(I){Q(I+"-box").attr("aria-checked",true);}}};
R.selectStep=function(j,S,I,l,E,x){if(!x){R.selectStepWithId(j,S.getId());}if(!I&&S.getSubSteps().length>0){var y=S.getSubSteps();var z=S.$();var A=z.hasClass("sapUiRoadMapExpanded");var C=1;var B=function(){C--;if(C>0){return;}if(E){E(!A?"expanded":"collapsed");}R.updateStepArea(j);};var F=function(H,O,J){var K=Q(H);if(!q.fx.off&&!l){K.width(O?"0px":j.iStepWidth);var L=Q(H+"-label");L.addClass("sapUiRoadMapHidden");if(O){K.toggleClass("sapUiRoadMapHidden");}K.animate({width:O?j.iStepWidth:"0px"},"fast",function(){if(!O){K.toggleClass("sapUiRoadMapHidden");}K.width("");L.removeClass("sapUiRoadMapHidden");if(J){J();}});}else{K.toggleClass("sapUiRoadMapHidden");if(J){J();}}};z.toggleClass("sapUiRoadMapExpanded");if(sap.ui.getCore().getConfiguration().getAccessibility()){var G=z.hasClass("sapUiRoadMapExpanded");S.$("box").attr("aria-expanded",G);S.$("expandend-box").attr("aria-expanded",G);}for(var i=0;i<y.length;i++){if(y[i].getVisible()){C++;F(y[i].getId(),!A,B);}}F(S.getId()+"-expandend",!A,B);}else{if(E){E("selected");}}};
R.updateStepArea=function(i){if(i.iStepWidth!=-1){var S=i.$("steparea");var j=i.$("Start");var E=i.$("End");var l=i.$();var x=S.scrollLeft();var A=l.width()-j.outerWidth(true)-E.outerWidth(true);var M=i.getNumberOfVisibleSteps();var C=n(i);if(M<1){M=C;}else{M=Math.min(M,C);}var P=Math.floor(A/i.iStepWidth);var N=Math.min(M,P);S.width(N*i.iStepWidth).scrollLeft(x);u(i);}};
R.updateScrollArea=function(i,S){R.updateStepArea(i);if(!S){var j=i.$("steparea");var P=t(i,false);if(i.getFirstVisibleStep()){var l=Q(i.getFirstVisibleStep());if(l.length){P=o(j,l);}}v(i,P+p()*j.scrollLeft(),true);}};
R.isVisibleRef=function(j,I){var S=j.$("steparea");var l=S.children(":visible");for(var i=0;i<l.length;i++){var C=q(l.get(i));if(C.attr("id")==I){var P=o(S,C);return P>=0&&P<S.width();}}return false;};
R.getFirstVisibleRef=function(j){var S=j.$("steparea");var l=S.children(":visible");for(var i=0;i<l.length;i++){var C=q(l.get(i));if(o(S,C)==0){return C;}}return null;};
R.setStepLabel=function(S,L){var l=L?e(L):"";S.$("label").html(l);S.$("expandend-label").html(l);if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}S.$("box").attr("aria-label",c(S,L));S.$("expandend-box").attr("aria-label",c(S,L));};
R.setStepEnabled=function(i,S,E){var j=S.$();var l=S.$("expandend");if(E){j.removeClass("sapUiRoadMapDisabled");l.removeClass("sapUiRoadMapDisabled");if(sap.ui.getCore().getConfiguration().getAccessibility()){S.$("box").removeAttr("aria-disabled");S.$("expandend-box").removeAttr("aria-disabled");}return false;}else{var x=i.getSelectedStep()==S.getId();if(x){j.removeClass("sapUiRoadMapSelected");}j.addClass("sapUiRoadMapDisabled");l.addClass("sapUiRoadMapDisabled");if(sap.ui.getCore().getConfiguration().getAccessibility()){var y=S.$("box");y.attr("aria-disabled",true);if(x){y.removeAttr("aria-checked");}S.$("expandend-box").attr("aria-disabled",true);}return x;}};
R.setStepVisible=function(j,S,I,V){var l=S.$();var x=S.$("expandend");var y=j.getSelectedStep()==S.getId();var P=S.getParent();if(I){if(P.getEnabled()&&P.getVisible()&&P.getExpanded()){if(V){l.removeClass("sapUiRoadMapHidden");}else{l.addClass("sapUiRoadMapHidden");}}}else{if(V){l.removeClass("sapUiRoadMapHidden");}else{l.addClass("sapUiRoadMapHidden");}var z=S.getSubSteps();if(z.length>0&&S.getExpanded()){if(V){x.removeClass("sapUiRoadMapHidden");}else{x.addClass("sapUiRoadMapHidden");}for(var i=0;i<z.length;i++){if(z[i].getVisible()){var A=z[i].$();if(j.getSelectedStep()==z[i].getId()){y=true;A.removeClass("sapUiRoadMapSelected");z[i].$("box").removeAttr("aria-checked");}if(V){A.removeClass("sapUiRoadMapHidden");}else{A.addClass("sapUiRoadMapHidden");}}}}}return y;};
R.setRoadMapWidth=function(i,W){var j=i.$();j.attr("style","width:"+(W?W:"100%")+";");};
R.scrollToNextStep=function(i,j,E){var P=j;if(j=="first"||j=="last"){P=t(i,j=="last");}v(i,P,false,E);};
R.addEllipses=function(S){if(!S){return;}var j=S.$("label");var O=S.getLabel();var T=O+"";var C=q("<label class=\"sapUiRoadMapTitle\" style=\"display:none;position:absolute;overflow:visible;font-weight:bold;height:auto\">"+T+"</label>");C.width(j.width());q(sap.ui.getCore().getStaticAreaRef()).append(C);var i=false;while(T.length>0&&C.height()>j.height()){T=T.substr(0,T.length-1);C.html(e(T+"..."));i=true;}if(i){j.html("<span>"+e(T)+"</span>");j.attr("title",S.getLabel());}else{j.attr("title",g(S));}C.remove();};
R.updateStepAria=function(S){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}var I=S.getParent()instanceof sap.ui.commons.RoadMap;var j=S.getParent()[I?"getSteps":"getSubSteps"]();for(var i=0;i<j.length;i++){var P=d(j[i]);var l=f(j[i]);var x=j[i].$("box");x.attr("aria-posinset",P);x.attr("aria-setsize",l);if(I&&j[i].getSubSteps().length>0){x=j[i].$("expandend-box");x.attr("aria-posinset",P);x.attr("aria-setsize",l);}}};
var Q=function(i){return q(i?document.getElementById(i):null);};var r=function(i,j,S){var T=S?"Start":"End";i.write("<div");i.writeAttribute("id",j.getId()+"-"+T);i.writeAttribute("tabindex","-1");var l=true;i.addClass(l?"sapUiRoadMap"+T+"Scroll":"sapUiRoadMap"+T+"Fixed");i.addClass("sapUiRoadMapDelim");i.addClass("sapUiRoadMapContent");i.writeClasses();i.write("></div>");};var a=function(j,l,S,A,x,I){j.write("<li");if(I){j.writeAttribute("id",I);}else{j.writeElementData(S);}var y=k(l,S);S.__stepName=y;var T=g(S);j.addClass("sapUiRoadMapContent");j.addClass("sapUiRoadMapStep");if(!S.getVisible()){j.addClass("sapUiRoadMapHidden");}if(S.getEnabled()){if(l.getSelectedStep()==S.getId()){j.addClass("sapUiRoadMapSelected");}}else{j.addClass("sapUiRoadMapDisabled");}if(A){for(var i=0;i<A.length;i++){j.addClass(A[i]);}}j.writeClasses();j.write(">");b(j,I?I:S.getId(),1);j.write("<div");j.writeAttribute("id",(I?I:S.getId())+"-box");j.writeAttribute("tabindex","-1");j.addClass("sapUiRoadMapStepBox");j.writeClasses();j.writeAttributeEscaped("title",T);w(j,l,S,x?true:false);j.write("><span>");j.write(y);j.write("</span>");if(x){x(j,l,S);}j.write("</div>");j.write("<label");j.writeAttribute("id",(I?I:S.getId())+"-label");j.addClass("sapUiRoadMapTitle");j.writeAttributeEscaped("title",T);j.writeClasses();j.write(">");var L=S.getLabel();if(L){j.writeEscaped(L);}j.write("</label>");b(j,I?I:S.getId(),2);j.write("</li>");};var g=function(S){var T=S.getTooltip_AsString();if(!T&&!S.getTooltip()&&sap.ui.getCore().getConfiguration().getAccessibility()){T=m("RDMP_DEFAULT_STEP_TOOLTIP",[S.__stepName]);}return T||"";};var b=function(i,I,j){i.write("<div");i.writeAttribute("id",I+"-add"+j);i.addClass("sapUiRoadMapStepAdd"+j);i.writeClasses();i.write("></div>");};var w=function(i,j,S,I){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}i.writeAttribute("role","treeitem");if(S.getEnabled()){i.writeAttribute("aria-checked",j.getSelectedStep()==S.getId());}else{i.writeAttribute("aria-disabled",true);}i.writeAttribute("aria-haspopup",I);i.writeAttribute("aria-level",S.getParent()instanceof sap.ui.commons.RoadMap?1:2);i.writeAttribute("aria-posinset",d(S));i.writeAttribute("aria-setsize",f(S));i.writeAttributeEscaped("aria-label",c(S,S.getLabel()));if(!I){return;}i.writeAttribute("aria-expanded",S.getExpanded());};var c=function(S,l){var i=S.getParent()instanceof sap.ui.commons.RoadMap&&S.getSubSteps().length>0;var j=l||"";if(S.getEnabled()){j=m(i?"RDMP_ARIA_EXPANDABLE_STEP":"RDMP_ARIA_STANDARD_STEP",[j]);}return j;};var d=function(S){var I=S.getParent()instanceof sap.ui.commons.RoadMap;var j=S.getParent()[I?"indexOfStep":"indexOfSubStep"](S);var C=0;var l=S.getParent()[I?"getSteps":"getSubSteps"]();for(var i=0;i<j;i++){if(!l[i].getVisible()){C++;}}return j+1-C;};var f=function(S){var I=S.getParent()instanceof sap.ui.commons.RoadMap;var j=S.getParent()[I?"getSteps":"getSubSteps"]();var C=j.length;for(var i=0;i<j.length;i++){if(!j[i].getVisible()){C--;}}return C;};var h=function(j,l,S){var C=function(j,l,z,A,B){j.write("<div");j.writeAttribute("id",z+"-ico");j.addClass("sapUiRoadMapStepIco");if(B){j.addClass(B);}j.writeClasses();j.write("></div>");};var I=S.getExpanded();a(j,l,S,I?["sapUiRoadMapExpanded"]:null,function(j,l,S){C(j,l,S.getId(),I?"roundtripstart.gif":"roundtrip.gif");});var x=S.getSubSteps();for(var i=0;i<x.length;i++){var y=["sapUiRoadMapSubStep"];if(!I&&x[i].getVisible()){y.push("sapUiRoadMapHidden");}a(j,l,x[i],y);}y=["sapUiRoadMapExpanded","sapUiRoadMapStepEnd"];if(!I){y.push("sapUiRoadMapHidden");}a(j,l,S,y,function(j,l,S){C(j,l,S.getId()+"-expandend","roundtripend.gif");},S.getId()+"-expandend");};var k=function(i,S){var P=S.getParent();if(P===i){return P.indexOfStep(S)+1;}var I=P.indexOfSubStep(S);if(I<26){return String.fromCharCode(97+I);}var j=Math.floor(I/26)-1;var l=I%26;return String.fromCharCode(97+j,97+l);};var u=function(i){var j=p();var S=i.$("steparea");var l=s(S);var x=i.$("Start");x.removeClass("sapUiRoadMapStartScroll").removeClass("sapUiRoadMapStartFixed");x.addClass(j*l>=i.iStepWidth?"sapUiRoadMapStartScroll":"sapUiRoadMapStartFixed");var E=i.$("End");E.removeClass("sapUiRoadMapEndScroll").removeClass("sapUiRoadMapEndFixed");var y=S.get(0).scrollWidth-j*l-S.width()<i.iStepWidth;E.addClass(y?"sapUiRoadMapEndFixed":"sapUiRoadMapEndScroll");};var m=function(K,A){var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(i){return i.getText(K,A);}return K;};var n=function(l){var x=0;var S=l.getSteps();for(var i=0;i<S.length;i++){if(S[i].getVisible()){x++;if(S[i].getExpanded()){x++;var y=S[i].getSubSteps();for(var j=0;j<y.length;j++){if(y[j].getVisible()){x++;}}}}}return x;};var o=function(S,j){var P=j.position().left;if(sap.ui.getCore().getConfiguration().getRTL()){P=S.width()-P-j.outerWidth();}return P;};var p=function(){return sap.ui.getCore().getConfiguration().getRTL()&&!D.browser.msie?-1:1;};var s=function(S){if(sap.ui.getCore().getConfiguration().getRTL()&&D.browser.webkit){return(-1)*(S.get(0).scrollWidth-S.scrollLeft()-S.width());}return S.scrollLeft();};var t=function(i,l){var S=i.$("steparea").get(0).scrollWidth;if(sap.ui.getCore().getConfiguration().getRTL()&&D.browser.webkit){return l?0:(-1)*S;}return l?S:0;};var v=function(i,N,S,E){var j=i.$("steparea");j.stop(false,true);if(N=="next"){N=j.scrollLeft()+i.iStepWidth*p();}else if(N=="prev"){N=j.scrollLeft()-i.iStepWidth*p();}else if(N=="keep"){N=j.scrollLeft();}else{N=N*p();}var l=function(){u(i);if(E){var F=R.getFirstVisibleRef(i);E(F.attr("id"));}};if(!q.fx.off&&!S){j.animate({scrollLeft:N},"fast",l);}else{j.scrollLeft(N);l();}};return R;},true);
sap.ui.predefine('sap/ui/commons/RoadMapStep',['sap/ui/dom/containsOrEquals','./library','sap/ui/core/Element','./RoadMapRenderer'],function(c,l,E,R){"use strict";
var a=E.extend("sap.ui.commons.RoadMapStep",{metadata:{library:"sap.ui.commons",properties:{label:{type:"string",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"subSteps",aggregations:{subSteps:{type:"sap.ui.commons.RoadMapStep",multiple:true,singularName:"subStep",deprecated:true}}}});
a.prototype.setLabel=function(L){s(this,"label",L,function(){R.setStepLabel(this,L);this.setProperty("label",L,true);R.addEllipses(this);return true;});return this;};
a.prototype.setEnabled=function(e){var o=this.getEnabled();if((e&&o)||(!e&&!o)){return this;}s(this,"enabled",e,function(){var r=g(this);var w=R.setStepEnabled(r,this,e);if(w){r.setProperty("selectedStep","",true);}if(!e){this.setExpanded(false);}return false;});return this;};
a.prototype.setExpanded=function(e){var o=this.getExpanded();if((e&&o)||(!e&&!o)){return this;}s(this,"expanded",e,function(){if(i(this)||this.getSubSteps().length==0||!this.getEnabled()||!e){this.setProperty("expanded",false,true);if(!i(this)&&this.getSubSteps().length>0&&this.getEnabled()){R.selectStep(g(this),this,false,true,null,true);}}else{this.setProperty("expanded",true,true);R.selectStep(g(this),this,false,true,null,true);}return true;});return this;};
a.prototype.setVisible=function(v){var o=this.getVisible();if((v&&o)||(!v&&!o)){return this;}s(this,"visible",v,function(){var r=g(this);var w=R.setStepVisible(r,this,i(this),v);if(w){r.setProperty("selectedStep","",true);}this.setProperty("visible",v,true);R.updateStepArea(r);R.updateStepAria(this);return true;});return this;};
a.prototype.getFocusDomRef=function(){return this.getFocusInfo().id?document.getElementById(this.getFocusInfo().id):null;};
a.prototype.getFocusInfo=function(){return{id:this.getId()+"-box"};};
a.prototype.onclick=function(e){this.handleSelect(e);};
a.prototype.onsapselect=function(e){this.handleSelect(e);};
a.prototype.handleSelect=function(e,I){e.stopPropagation();e.preventDefault();if(!I&&!c(this.getDomRef(),e.target)){return;}if(this.getEnabled()){var r=g(this);var t=this;R.selectStep(r,this,i(this),false,function(T){var w=r.getSelectedStep()==t.getId();r.setProperty("selectedStep",t.getId(),true);t.focus();if(T!="selected"){t.setProperty("expanded",T=="expanded",true);r.fireStepExpanded({stepId:t.getId()});}if(!w){r.fireStepSelected({stepId:t.getId()});}});}else{this.focus();}};
var g=function(t){var r=t.getParent();if(i(t)){r=r.getParent();}return r;};var i=function(t){return!(t.getParent()instanceof sap.ui.commons.RoadMap);};var s=function(t,n,v,d){if(!t.getDomRef()){t.setProperty(n,v);return;}var S=d.apply(t,[]);if(!S){t.setProperty(n,v,true);}};return a;});
sap.ui.predefine('sap/ui/commons/RowRepeater',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','./RowRepeaterRenderer','./Toolbar','./Paginator','./Button','sap/ui/model/FilterType'],function(q,a,C,R,T,P,B,F){"use strict";var b=a.PaginatorEvent;var c=a.ToolbarDesign;var d=a.RowRepeaterDesign;
var e=C.extend("sap.ui.commons.RowRepeater",{metadata:{library:"sap.ui.commons",properties:{numberOfRows:{type:"int",group:"Dimension",defaultValue:5},currentPage:{type:"int",group:"Data",defaultValue:1},showMoreSteps:{type:"int",group:"Behavior",defaultValue:0},fixedRowHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:''},design:{type:"sap.ui.commons.RowRepeaterDesign",group:"Appearance",defaultValue:d.Standard},threshold:{type:"int",defaultValue:null}},defaultAggregation:"rows",aggregations:{rows:{type:"sap.ui.core.Control",multiple:true,singularName:"row",bindable:"bindable"},title:{type:"sap.ui.core.Title",multiple:false},filters:{type:"sap.ui.commons.RowRepeaterFilter",multiple:true,singularName:"filter"},sorters:{type:"sap.ui.commons.RowRepeaterSorter",multiple:true,singularName:"sorter"},noData:{type:"sap.ui.core.Control",multiple:false},filterToolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"},sorterToolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"},headerShowMoreButton:{type:"sap.ui.commons.Button",multiple:false,visibility:"hidden"},footerShowMoreButton:{type:"sap.ui.commons.Button",multiple:false,visibility:"hidden"},footerPager:{type:"sap.ui.commons.Paginator",multiple:false,visibility:"hidden"}},events:{filter:{parameters:{filterId:{type:"string"}}},sort:{parameters:{sorterId:{type:"string"}}},page:{parameters:{currentPage:{type:"int"},previousPage:{type:"int"}}},resize:{parameters:{numberOfRows:{type:"int"},previousNumberOfRows:{type:"int"}}}}}});
e.prototype.bPagingMode=true;e.prototype.bShowAnimation=true;e.SHOW_MORE="show_more";e.RESIZE="resize";e.FIRST_PAGE="first_page";e.LAST_PAGE="last_page";e.PREVIOUS_PAGE="previous_page";e.NEXT_PAGE="next_page";e.GOTO_PAGE="goto_page";
e.prototype.init=function(){var i=this.getId();this.oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.sCurrentAnimation=null;this.aAnimationQueue=[];this.aRemoveBuffer=[];this.iPreviousPage=this.getCurrentPage();this.iPreviousNumberOfRows=this.getNumberOfRows();this.setAggregation("filterToolbar",new T(i+"-ftb",{standalone:false,design:c.Transparent}));this.setAggregation("sorterToolbar",new T(i+"-stb",{standalone:false}));var p=new P(i+"-fp",{page:[this.paging,this]});this.setAggregation("footerPager",p);var s=this.oResourceBundle.getText("SHOW_MORE");this.setAggregation("headerShowMoreButton",new B(i+"-hsm",{text:s,tooltip:s,press:[this.triggerShowMore,this]}));this.setAggregation("footerShowMoreButton",new B(i+"-fsm",{text:s,tooltip:s,press:[this.triggerShowMore,this]}));this._bSecondPage=false;};
e.prototype.triggerShowMore=function(){if(this.getShowMoreSteps()<=0){return this;}var s=this.getShowMoreSteps();var n=this.getNumberOfRows();var N=Math.min(this._getRowCount(),n+s);if(n===N){return this;}if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.SHOW_MORE,animationFunction:this.triggerShowMore,args:arguments});return this;}else{this.sCurrentAnimation=e.SHOW_MORE;}this.iPreviousNumberOfRows=n;this.setProperty("numberOfRows",N,true);this.startResizeAnimation();}else{this.setNumberOfRows(N);}this.fireResize({numberOfRows:N,previousNumberOfRows:n});return this;};
e.prototype.resize=function(n){if(this.getShowMoreSteps()<=0){return this;}var N=this.getNumberOfRows();if(n<=0||n>this._getRowCount()||n===N){return this;}if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.RESIZE,animationFunction:this.resize,args:arguments});return this;}else{this.sCurrentAnimation=e.RESIZE;}this.iPreviousNumberOfRows=N;this.setProperty("numberOfRows",n,true);this.startResizeAnimation();}else{this.setNumberOfRows(n);}this.fireResize({numberOfRows:n,previousNumberOfRows:N});return this;};
e.prototype.applyFilter=function(i){var f=this.getFilters();var l=this.getBinding("rows");var o,n;if(f.length===0||l===null){return this;}for(n=0;n<f.length;n++){if(f[n].getId()===i){o=f[n];break;}}if(o){l.filter(o.getFilters(),F.Control);this.fireFilter({filterId:i});this.firstPage();}return this;};
e.prototype.triggerSort=function(i){var s=this.getSorters();var l=this.getBinding("rows");var S,n;if(s.length===0||l===null){return this;}for(n=0;n<s.length;n++){if(s[n].getId()===i){S=s[n];break;}}if(S){l.sort(S.getSorter());this.fireSort({sorterId:i});this.firstPage();}return this;};
e.prototype.firstPage=function(){if(this.getShowMoreSteps()>0){return this;}var i=this.getCurrentPage();if(i===1){return this;}this.getAggregation("footerPager").setCurrentPage(1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.FIRST_PAGE,animationFunction:this.firstPage,args:arguments});return this;}else{this.sCurrentAnimation=e.FIRST_PAGE;}this.iPreviousPage=i;this.setProperty("currentPage",1,true);this.startPagingAnimation();}else{this.setCurrentPage(1);}this.firePage({currentPage:1,previousPage:i});return this;};
e.prototype.lastPage=function(){if(this.getShowMoreSteps()>0){return this;}var i=this.getCurrentPage();var l=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(i===l){return this;}this.getAggregation("footerPager").setCurrentPage(l);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.LAST_PAGE,animationFunction:this.lastPage,args:arguments});return this;}else{this.sCurrentAnimation=e.LAST_PAGE;}this.iPreviousPage=i;this.setProperty("currentPage",l,true);this.startPagingAnimation();}else{this.setCurrentPage(l);}this.firePage({currentPage:l,previousPage:i});return this;};
e.prototype.previousPage=function(){if(this.getShowMoreSteps()>0){return this;}var i=this.getCurrentPage();if(i<=1){return this;}this.getAggregation("footerPager").setCurrentPage(i-1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.PREVIOUS_PAGE,animationFunction:this.previousPage,args:arguments});return this;}else{this.sCurrentAnimation=e.PREVIOUS_PAGE;}this.iPreviousPage=i;this.setProperty("currentPage",i-1,true);this.startPagingAnimation();}else{this.setCurrentPage(i-1);}this.firePage({currentPage:i-1,previousPage:i});return this;};
e.prototype.nextPage=function(){if(this.getShowMoreSteps()>0){return this;}var i=this.getCurrentPage();var l=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(i>=l){return this;}this.getAggregation("footerPager").setCurrentPage(i+1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.NEXT_PAGE,animationFunction:this.nextPage,args:arguments});return this;}else{this.sCurrentAnimation=e.NEXT_PAGE;}this.iPreviousPage=i;this.setProperty("currentPage",i+1,true);this.startPagingAnimation();}else{this.setCurrentPage(i+1);}this.firePage({currentPage:i+1,previousPage:i});return this;};
e.prototype.gotoPage=function(p){if(this.getShowMoreSteps()>0){return this;}var i=this.getCurrentPage();var l=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(p<1||p>l||i===p){return this;}this.getAggregation("footerPager").setCurrentPage(p);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.GOTO_PAGE,animationFunction:this.gotoPage,args:arguments});return this;}else{this.sCurrentAnimation=e.GOTO_PAGE;}this.iPreviousPage=i;this.setProperty("currentPage",p,true);this.startPagingAnimation();}else{this.setCurrentPage(p);}this.firePage({currentPage:p,previousPage:i});return this;};
e.prototype.setNumberOfRows=function(n){this.setProperty("numberOfRows",n);if(this.getBinding("rows")){this.updateRows(true);}this.updateChildControls();return this;};
e.prototype.setCurrentPage=function(i){if(this.getCurrentPage()!=i){this.setProperty("currentPage",i);if(this.getBinding("rows")){this.updateRows(true);}this.updateChildControls();}return this;};
e.prototype.setShowMoreSteps=function(s){var n=s>0?false:true,o=this.getBinding("rows");if(n!==this.bPagingMode){this.bPagingMode=n;this.setCurrentPage(1);}this.setProperty("showMoreSteps",s);if(o){this._bSecondPage=false;this.updateRows(true);}return this;};
e.prototype.insertRow=function(r,i){this.insertAggregation("rows",r,i);this.updateChildControls();return this;};
e.prototype.addRow=function(r){this.addAggregation("rows",r);this.updateChildControls();return this;};
e.prototype.removeRow=function(E){this.removeAggregation("rows",E);this.updateChildControls();return this;};
e.prototype.removeAllRows=function(){this.removeAllAggregation("rows");this.updateChildControls();return this;};
e.prototype.destroyRows=function(){this.destroyAggregation("rows");this.updateChildControls();return this;};
e.prototype.setThreshhold=function(t){this.setProperty("threshold",t,true);return this;};
e.prototype.insertFilter=function(f,i){var t=this.getAggregation("filterToolbar");var s=f.getId();var o=new B({text:f.getText(),icon:f.getIcon(),tooltip:f.getTooltip(),press:[function(){this.applyFilter(s);},this]});t.insertItem(o,i);this.insertAggregation("filters",f,i);return this;};
e.prototype.addFilter=function(f){var t=this.getAggregation("filterToolbar");var s=f.getId();var o=new B({text:f.getText(),icon:f.getIcon(),tooltip:f.getTooltip(),press:[function(){this.applyFilter(s);},this]});t.addItem(o);this.addAggregation("filters",f);return this;};
e.prototype.removeFilter=function(E){var t=this.getAggregation("filterToolbar");t.removeItem(E);return this.removeAggregation("filters",E);};
e.prototype.removeAllFilters=function(){var t=this.getAggregation("filterToolbar");t.removeAllItems();return this.removeAllAggregation("filters");};
e.prototype.destroyFilters=function(){var t=this.getAggregation("filterToolbar");t.removeAllItems();this.destroyAggregation("filters");return this;};
e.prototype.insertSorter=function(s,i){var t=this.getAggregation("sorterToolbar");var S=s.getId();var o=new B({text:s.getText(),icon:s.getIcon(),tooltip:s.getTooltip(),press:[function(){this.triggerSort(S);},this]});t.insertItem(o,i);this.insertAggregation("sorters",s,i);return this;};
e.prototype.addSorter=function(s){var t=this.getAggregation("sorterToolbar");var S=s.getId();var o=new B({text:s.getText(),icon:s.getIcon(),tooltip:s.getTooltip(),press:[function(){this.triggerSort(S);},this]});t.addItem(o);this.addAggregation("sorters",s);return this;};
e.prototype.removeSorter=function(E){var t=this.getAggregation("sorterToolbar");t.removeItem(E);return this.removeAggregation("sorters",E);};
e.prototype.removeAllSorters=function(){var t=this.getAggregation("sorterToolbar");t.removeAllItems();return this.removeAllAggregation("sorters");};
e.prototype.destroySorters=function(){var t=this.getAggregation("sorterToolbar");t.removeAllItems();this.destroyAggregation("sorters");return this;};
e.prototype.startPagingAnimation=function(){var o=sap.ui.getCore(),r=o.getRenderManager(),i=this.getId(),p=this.iPreviousPage,f=this.getCurrentPage(),N=this.getNumberOfRows(),s=(f-1)*N,g=this.getRows(),h=this._getRowCount()>N*f?N:this._getRowCount()-N*(f-1),n,j=this.getBinding("rows");var D,J=this.$("page_"+p),k=this.getDomRef("body"),l=q(k);l.css("height",l.outerHeight());var m;if(sap.ui.getCore()&&sap.ui.getCore().getConfiguration()&&sap.ui.getCore().getConfiguration().getRTL()){m=(f<p)?"left":"right";}else{m=(f<p)?"right":"left";}if(j){this._bSecondPage=!this._bSecondPage;this.updateRows(true);g=this.getRows();s=(this._bSecondPage?1:0)*N;}var S="\"top:-"+J.outerHeight(true)+"px;"+m+":"+J.outerWidth(true)+"px;\"";q("<ul id=\""+i+"-page_"+f+"\" class=\"sapUiRrPage\" style="+S+"/>").appendTo(k);var t=k.lastChild;var u=q(t);for(n=s;n<s+h;n++){q("<li id=\""+i+"-row_"+n+"\" class=\"sapUiRrRow\"/>").appendTo(t);D=t.lastChild;r.render(g[n],D);}if(m==="right"){J.animate({right:-J.outerWidth(true)},"slow");u.animate({right:0},"slow");}else{J.animate({left:-J.outerWidth(true)},"slow");u.animate({left:0},"slow");}l.animate({height:u.outerHeight(true)},"slow",q.proxy(this.endPagingAnimation,this));};
e.prototype.endPagingAnimation=function(){var D=this.getDomRef("body");var o=this.getDomRef("page_"+this.iPreviousPage);var f=this.getDomRef("page_"+this.getCurrentPage());var j=q(f);q(D).css("height","");q(o).remove();var s;if(sap.ui.getCore()&&sap.ui.getCore().getConfiguration()&&sap.ui.getCore().getConfiguration().getRTL()){s=(this.getCurrentPage()<this.iPreviousPage)?"left":"right";}else{s=(this.getCurrentPage()<this.iPreviousPage)?"right":"left";}j.css("top","");j.css(s,"");this.sCurrentAnimation=null;this.nextQueuedAnimation();};
e.prototype.startResizeAnimation=function(){var r=sap.ui.getCore().getRenderManager(),N=this.getNumberOfRows(),o=this.iPreviousNumberOfRows,i=this.getId(),s=0,f,g=this.getBinding("rows");var D,h=this.getDomRef("body"),j=q(h),k=this.getDomRef("page_"+this.getCurrentPage());j.css("height",j.outerHeight());if(g){this.updateRows(true);}f=this.getRows();if(N>o){for(var n=o;n<N;n++){q("<li id=\""+i+"-row_"+n+"\" class=\"sapUiRrRow\"/>").appendTo(k);D=k.lastChild;r.render(f[n],D);}}else{for(var n=N;n<o;n++){D=this.getDomRef("row_"+n);s-=q(D).outerHeight(true);this.aRemoveBuffer.push(D);}}j.animate({height:q(k).outerHeight(true)+s},"slow",q.proxy(this.endResizeAnimation,this));};
e.prototype.endResizeAnimation=function(){var D=this.getDomRef("body");while(this.aRemoveBuffer.length>0){q(this.aRemoveBuffer.pop()).remove();}q(D).css("height","");this.sCurrentAnimation=null;this.nextQueuedAnimation();};
e.prototype.nextQueuedAnimation=function(){var n,l;var i=1;var Q=this.aAnimationQueue;var p,N;if(Q.length>0){n=Q.shift();}if(n&&Q.length>0){while(Q[0]&&Q[0].name===n.name){i++;l=Q.shift();}if(i>0){switch(n.name){case e.SHOW_MORE:N=Math.min(this._getRowCount(),this.getNumberOfRows()+this.getShowMoreSteps()*i);n={name:e.RESIZE,animationFunction:this.resize,args:[N]};break;case e.RESIZE:n=l;break;case e.FIRST_PAGE:break;case e.LAST_PAGE:break;case e.PREVIOUS_PAGE:p=Math.max(1,this.getCurrentPage()-i);n={name:e.GOTO_PAGE,animationFunction:this.gotoPage,args:[p]};break;case e.NEXT_PAGE:p=Math.min(Math.ceil(this._getRowCount()/this.getNumberOfRows()),this.getCurrentPage()+i);n={name:e.GOTO_PAGE,animationFunction:this.gotoPage,args:[p]};break;case e.GOTO_PAGE:n=l;break;}}}if(n){n.animationFunction.apply(this,n.args);}};
e.prototype.paging=function(E){switch(E.getParameter("type")){case b.First:this.firstPage();break;case b.Last:this.lastPage();break;case b.Previous:this.previousPage();break;case b.Next:this.nextPage();break;case b.Goto:this.gotoPage(E.getParameter("targetPage"));break;}};
e.prototype.updateChildControls=function(){var s,p;var S;if(this.bPagingMode){var i=this.getCurrentPage();var l=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(this._getRowCount()==0){l=1;}p=this.getAggregation("footerPager");if(p){p.setCurrentPage(i);p.setNumberOfPages(l);}}else{S=this._getRowCount()>this.getNumberOfRows();s=this.getAggregation("headerShowMoreButton");if(s){s.setEnabled(S);}s=this.getAggregation("footerShowMoreButton");if(s){s.setEnabled(S);}}};
e.prototype.isBound=function(n){return C.prototype.isBound.call(this,n||"rows");};
e.prototype._getRowCount=function(){var o=this.getBinding("rows");if(o){return o.getLength();}else{return this.getRows().length;}};
e.prototype.unbindAggregation=function(n){C.prototype.unbindAggregation.apply(this,arguments);if(n==="rows"){this.destroyRows();}return this;};
e.prototype.refreshRows=function(){var o=this.getBindingInfo("rows"),f=o.binding,r=this._getRowCount(),n=this.getNumberOfRows(),N=Math.min(r,n),t=this.getThreshold();this.setProperty("currentPage",1,true);f.getContexts(0,N,t);};
e.prototype.updateRows=function(v){var o=this.getBindingInfo("rows"),f=o.factory,g=o.binding,s=this.getShowMoreSteps(),S=s>0,h=this.getCurrentPage(),r=this._getRowCount(),n=this.getNumberOfRows(),N=Math.min(r,n),L=Math.ceil(r/n)||1;if(h>L){h=L;this.setProperty("currentPage",h);this._bSecondPage=false;}var j=S?0:(h-1)*N,k=(this._bSecondPage?1:0)*N,t=this.getThreshold(),m=g?g.getContexts(j,N,t):[];if(v!==true){this._bSecondPage=false;this.destroyRows();for(var i=0,l=N;i<l;i++){var I=this.getId()+"-"+i,p=f(I,m[i]);p.setBindingContext(m[i],o.model);this.addRow(p);}}else{this._bSuppressInvalidate=true;for(var i=0,l=N;i<l;i++){var u=k+i;var w=this.getRows()[u];if(!S){if(w){this.removeAggregation("rows",w,true);w.destroy();}w=undefined;}if(!w){var I=this.getId()+"-"+u;w=f(I,m[i]);w.setBindingContext(m[i],o.model);this.insertAggregation("rows",w,u,true);}else{w.setBindingContext(m[i],o.model);}}this._bSuppressInvalidate=false;}this.updateChildControls();};
e.prototype.invalidate=function(o){if(this._bSuppressInvalidate){return;}C.prototype.invalidate.apply(this,arguments);};
return e;});
sap.ui.predefine('sap/ui/commons/RowRepeaterFilter',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var R=E.extend("sap.ui.commons.RowRepeaterFilter",{metadata:{library:"sap.ui.commons",properties:{text:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"string",group:"Appearance",defaultValue:null},filters:{type:"object",group:"Data",defaultValue:null}}}});
return R;});
sap.ui.predefine('sap/ui/commons/RowRepeaterRenderer',['./Button','./Paginator','./Toolbar','./library'],function(B,P,T,l){"use strict";var R=l.RowRepeaterDesign;var a={};
a.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiRrDesign"+c.getDesign());r.writeClasses();r.write(">");if(c.getDesign()!==R.BareShell){this.renderHeader(r,c);}this.renderBody(r,c);if(c.getDesign()!==R.BareShell){this.renderFooter(r,c);}r.write("</div>");};
a.renderHeader=function(r,c){this.renderPrimaryToolbar(r,c);if(c.getSorters().length>1&&c.isBound()){this.renderSecondaryToolbar(r,c);}};
a.renderPrimaryToolbar=function(r,c){r.write("<div");r.addClass("sapUiRrPtb");r.writeClasses();r.write(">");if(c.getTitle()!==null){this.renderTitle(r,c);}this.renderFilterToolbar(r,c);this.renderController(r,c);r.write("</div>");};
a.renderTitle=function(r,c){var t=c.getTitle();var s=t.getTooltip_AsString();if(t.getIcon()){r.write("<div");r.addClass("sapUiRrLogo");r.writeClasses();if(s!==undefined){r.writeAttributeEscaped("title",s);}r.write(">");if(t.getIcon()){r.write("<img");r.writeAttributeEscaped("src",t.getIcon());r.write("/>");}r.write("</div>");}if(t.getText()){r.write("<div");r.addClass("sapUiRrTitle");r.writeClasses();r.writeAttribute("role","heading");r.write(">");r.writeEscaped(t.getText());r.write("</div>");}};
a.renderFilterToolbar=function(r,c){var f=c.getFilters();if(f.length>0){r.write("<div");r.addClass("sapUiRrFilters");r.writeClasses();r.write(">");if(f.length>1&&c.isBound()){r.renderControl(c.getAggregation("filterToolbar"));}r.write("</div>");}};
a.renderController=function(r,c){if(!c.bPagingMode){r.write("<div");r.addClass("sapUiRrCtrl");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("headerShowMoreButton"));r.write("</div>");}};
a.renderSecondaryToolbar=function(r,c){r.write("<div");r.addClass("sapUiRrStb");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiRrSortBy");r.writeClasses();r.write(">");r.writeEscaped(c.oResourceBundle.getText("SORT_BY")+":");r.write("</div>");r.write("<div");r.addClass("sapUiRrSorters");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("sorterToolbar"));r.write("</div>");r.write("</div>");};
a.renderBody=function(r,c){var i=c.getId();var s=c.getShowMoreSteps();var C=c.getCurrentPage();var n=c.getNumberOfRows();var S=(C-1)*n;var b=c.getRows();var d=c._getRowCount();var m=d-S;var e=c._getRowCount()>n?n:m;var L=Math.ceil(d/n);var f;e=Math.min(e,m);if(s>0){S=0;}r.write("<div");r.writeAttribute("id",i+"-body");r.addClass("sapUiRrBody");r.writeClasses();r.write(">");r.write("<ul");r.writeAttribute("id",i+"-page_"+C);r.addClass("sapUiRrPage");r.writeClasses();r.write(">");if(b.length===0||L<C){r.write("<li");r.addClass("sapUiRrNoData");r.writeClasses();r.write(">");var N=c.getNoData();if(N){r.renderControl(N);}else{r.writeEscaped(c.oResourceBundle.getText("NO_DATA"));}r.write("</li>");}else{var g;if(c.getFixedRowHeight()!==""){g="height:"+c.getFixedRowHeight()+";overflow:hidden;";}if(c.getBinding("rows")){S=c._bSecondPage?n:0;}for(f=S;f<S+e;f++){r.write("<li");r.writeAttribute("id",i+"-row_"+f);if(g){r.writeAttribute("style",g);}r.addClass("sapUiRrRow");r.writeClasses();r.write(">");r.renderControl(b[f]);r.write("</li>");}}r.write("</ul>");r.write("</div>");};
a.renderFooter=function(r,c){r.write("<div");r.addClass("sapUiRrFtr");r.writeClasses();r.write(">");if(c.bPagingMode){r.renderControl(c.getAggregation("footerPager"));}else{r.renderControl(c.getAggregation("footerShowMoreButton"));}r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/ui/commons/RowRepeaterSorter',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var R=E.extend("sap.ui.commons.RowRepeaterSorter",{metadata:{library:"sap.ui.commons",properties:{text:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"string",group:"Appearance",defaultValue:null},sorter:{type:"object",group:"Data",defaultValue:null}}}});
return R;});
sap.ui.predefine('sap/ui/commons/SearchField',['sap/ui/thirdparty/jquery','./ComboBox','./ComboBoxRenderer','./ListBox','./TextField','./TextFieldRenderer','./library','sap/ui/core/Control','sap/ui/core/History','sap/ui/core/Renderer','./SearchFieldRenderer','sap/ui/core/library','./Button','sap/ui/Device','sap/ui/core/SeparatorItem','sap/ui/core/ListItem','sap/ui/events/KeyCodes','sap/ui/dom/containsOrEquals','sap/ui/dom/jquery/rect','sap/ui/dom/jquery/getSelectedText'],function(q,C,a,L,T,b,l,c,H,R,S,d,B,D,e,f,K,g){"use strict";var h=d.TextAlign;var V=d.ValueState;
var j=c.extend("sap.ui.commons.SearchField",{metadata:{interfaces:["sap.ui.commons.ToolbarItem"],library:"sap.ui.commons",properties:{enableListSuggest:{type:"boolean",group:"Behavior",defaultValue:true},showListExpander:{type:"boolean",group:"Behavior",defaultValue:true},enableClear:{type:"boolean",group:"Behavior",defaultValue:false},showExternalButton:{type:"boolean",group:"Behavior",defaultValue:false},enableCache:{type:"boolean",group:"Behavior",defaultValue:true},enableFilterMode:{type:"boolean",group:"Behavior",defaultValue:false},value:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxLength:{type:"int",group:"Behavior",defaultValue:0},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},placeholder:{type:"string",group:"Appearance",defaultValue:""},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:h.Begin},visibleItemCount:{type:"int",group:"Behavior",defaultValue:20},startSuggestion:{type:"int",group:"Behavior",defaultValue:3},maxSuggestionItems:{type:"int",group:"Behavior",defaultValue:10},maxHistoryItems:{type:"int",group:"Behavior",defaultValue:0}},aggregations:{searchProvider:{type:"sap.ui.core.search.SearchProvider",multiple:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{search:{parameters:{query:{type:"string"}}},suggest:{parameters:{value:{type:"string"}}}}}});
var _=20;
j.prototype.init=function(){o(this,this.getEnableListSuggest());this._oHistory=new H(this.getId());this._clearTooltipText=p("SEARCHFIELD_CLEAR_TOOLTIP");};
j.prototype.exit=function(){if(this._ctrl){this._ctrl.destroy();}if(this._lb){this._lb.destroy();}if(this._btn){this._btn.destroy();}this._ctrl=null;this._lb=null;this._btn=null;this._oHistory=null;};
j.prototype.onThemeChanged=function(E){if(this.getDomRef()){this.invalidate();}};
j.prototype.onAfterRendering=function(){if(this.getShowExternalButton()){var i=this._btn.$().outerWidth(true);this._ctrl.$().css(sap.ui.getCore().getConfiguration().getRTL()?"left":"right",i+"px");}k(this);};
j.prototype.getFocusDomRef=function(){return this._ctrl.getFocusDomRef();};
j.prototype.getIdForLabel=function(){return this._ctrl.getId()+'-input';};
j.prototype.onpaste=function(E){var t=this;setTimeout(function(){t._ctrl._triggerValueHelp=true;t._ctrl.onkeyup();},0);};
j.prototype.oncut=j.prototype.onpaste;
j.prototype.fireSearch=function(A){var v=q(this._ctrl.getInputDomRef()).val();if(!this.getEditable()||!this.getEnabled()){return this;}this.setValue(v);if(!v&&!this.getEnableFilterMode()){return this;}if(!A){A={};}if(!A.noFocus){v=this.getValue();this.focus();if(v&&(this.getMaxHistoryItems()>0)){this._oHistory.add(v);}this.fireEvent("search",{query:v});}return this;};
j.prototype.hasListExpander=function(){return r()?false:this.getShowListExpander();};
j.prototype.clearHistory=function(){this._oHistory.clear();};
j.prototype.suggest=function(i,t){if(!this.getEnableListSuggest()||!i||!t){return;}this._ctrl.updateSuggestions(i,t);};
j.prototype.setEnableListSuggest=function(E){if((this.getEnableListSuggest()&&E)||(!this.getEnableListSuggest()&&!E)){return this;}o(this,E);this.setProperty("enableListSuggest",E);return this;};
j.prototype.getValue=function(){return n(this,"Value");};
j.prototype.setValue=function(v){var i=m(this,"Value",v,!!this.getDomRef(),true);if(this.getEnableClear()&&this.getDomRef()){this.$().toggleClass("sapUiSearchFieldVal",!!v);k(this);}return i;};
j.prototype.setEnableCache=function(E){return this.setProperty("enableCache",E,true);};
j.prototype.getEnabled=function(){return n(this,"Enabled");};
j.prototype.setEnabled=function(E){if(this._btn){this._btn.setEnabled(E&&this.getEditable());}return m(this,"Enabled",E,false,true);};
j.prototype.getEditable=function(){return n(this,"Editable");};
j.prototype.setEditable=function(E){if(this._btn){this._btn.setEnabled(E&&this.getEnabled());}return m(this,"Editable",E,false,true);};
j.prototype.getMaxLength=function(){return n(this,"MaxLength");};
j.prototype.setMaxLength=function(M){return m(this,"MaxLength",M,false,true);};
j.prototype.getValueState=function(){return n(this,"ValueState");};
j.prototype.setValueState=function(v){return m(this,"ValueState",v,false,true);};
j.prototype.getPlaceholder=function(){return n(this,"Placeholder");};
j.prototype.setPlaceholder=function(t){return m(this,"Placeholder",t,false,true);};
j.prototype.getTextAlign=function(){return n(this,"TextAlign");};
j.prototype.setTextAlign=function(t){return m(this,"TextAlign",t,false,true);};
j.prototype.getTooltip=function(){return n(this,"Tooltip");};
j.prototype.setTooltip=function(t){return m(this,"Tooltip",t,true,false);};
j.prototype.getVisibleItemCount=function(){return n(this,"MaxPopupItems");};
j.prototype.setVisibleItemCount=function(v){return m(this,"MaxPopupItems",v,false,true);};
j.prototype.setShowExternalButton=function(i){if(!this._btn){var t=this;this._btn=new B(this.getId()+"-btn",{text:p("SEARCHFIELD_BUTTONTEXT"),enabled:this.getEditable()&&this.getEnabled(),press:function(){t.fireSearch();}});this._btn.setParent(this);}this.setProperty("showExternalButton",i);return this;};
j.prototype.getAriaDescribedBy=function(){return this._ctrl.getAriaDescribedBy();};
j.prototype.getAriaLabelledBy=function(){return this._ctrl.getAriaLabelledBy();};
j.prototype.removeAllAriaDescribedBy=function(){return this._ctrl.removeAllAriaDescribedBy();};
j.prototype.removeAllAriaLabelledBy=function(){return this._ctrl.removeAllAriaLabelledBy();};
j.prototype.removeAriaDescribedBy=function(v){return this._ctrl.removeAriaDescribedBy(v);};
j.prototype.removeAriaLabelledBy=function(v){return this._ctrl.removeAriaLabelledBy(v);};
j.prototype.addAriaDescribedBy=function(v){this._ctrl.addAriaDescribedBy(v);return this;};
j.prototype.addAriaLabelledBy=function(v){this._ctrl.addAriaLabelledBy(v);return this;};
var k=function(t){var $=t.$(),i=t._ctrl.$("searchico");if($.hasClass("sapUiSearchFieldClear")&&$.hasClass("sapUiSearchFieldVal")){i.attr("title",t._clearTooltipText);}else{i.removeAttr("title");}};var m=function(t,M,v,i,u){var O=n(t,M);t._ctrl["set"+M](v);if(!i){t.invalidate();}if(u){t.updateModelProperty(M.toLowerCase(),v,O);}return t;};var n=function(t,G){return t._ctrl["get"+G]();};var o=function(t,E){if(!t._lb){t._lb=new L(t.getId()+"-lb");}var O=t._ctrl;var N=null;if(E){N=new j.CB(t.getId()+"-cb",{listBox:t._lb,maxPopupItems:_});N.addDependent(t._lb);}else{N=new j.TF(t.getId()+"-tf");}N.setParent(t);N.addEventDelegate({onAfterRendering:function(){k(t);var F=q(N.getFocusDomRef());var u=F.attr("aria-labelledby")||"";if(u){u=" "+u;}F.attr("aria-labelledby",t.getId()+"-label"+u);}});if(O){N.setValue(O.getValue());N.setEnabled(O.getEnabled());N.setEditable(O.getEditable());N.setMaxLength(O.getMaxLength());N.setValueState(O.getValueState());N.setPlaceholder(O.getPlaceholder());N.setTextAlign(O.getTextAlign());N.setTooltip(O.getTooltip());N.setMaxPopupItems(O.getMaxPopupItems());var A=O.getAriaDescribedBy();for(var i=0;i<A.length;i++){N.addAriaDescribedBy(A[i]);}O.removeAllAriaDescribedBy();A=O.getAriaLabelledBy();for(var i=0;i<A.length;i++){N.addAriaLabelledBy(A[i]);}O.removeAllAriaLabelledBy();O.removeAllDependents();O.destroy();}t._ctrl=N;};var p=function(i,A){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(t){return t.getText(i,A);}return i;};var r=function(){return D.browser.mobile&&!D.system.desktop;};var s=function(i,t){i.write("<div");i.writeAttributeEscaped('id',t.getId()+'-searchico');i.writeAttribute('unselectable','on');if(sap.ui.getCore().getConfiguration().getAccessibility()){i.writeAttribute("role","presentation");}i.addClass("sapUiSearchFieldIco");i.writeClasses();i.write("></div>");};
T.extend("sap.ui.commons.SearchField.TF",{
metadata:{visibility:"hidden"},
constructor:function(i,t){T.apply(this,arguments);},
getInputDomRef:function(){return this.getDomRef("input");},
onkeyup:function(E){j.CB.prototype.onkeyup.apply(this,arguments);},
_triggerSuggest:function(i){this._sSuggest=null;if((i&&i.length>=this.getParent().getStartSuggestion())||(!i&&this.getParent().getStartSuggestion()==0)){this.getParent().fireSuggest({value:i});}},
_checkChange:function(E,i){this.getParent().fireSearch({noFocus:i});},
onsapfocusleave:function(E){if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onblur&&E.relatedControlId!=this.getId()){this.getRenderer().onblur(this);}this._checkChange(E,true);},
onclick:function(E){if(E.target===this.getDomRef("searchico")){if(this.oPopup&&this.oPopup.isOpen()){this.oPopup.close();}if(this.getEditable()&&this.getEnabled()){this.focus();}if(!this.getParent().getEnableClear()){this._checkChange(E);}else{if(!q(this.getInputDomRef()).val()||!this.getEditable()||!this.getEnabled()){return;}this.setValue("");this._triggerValueHelp=true;this.onkeyup();if(this.getParent().getEnableFilterMode()){q(this.getInputDomRef()).val("");this.getParent().fireSearch();}}}},
getMaxPopupItems:function(){return this._iVisibleItemCount?this._iVisibleItemCount:_;},
setMaxPopupItems:function(M){this._iVisibleItemCount=M;},
renderer:{renderOuterContentBefore:s,renderOuterAttributes:function(i,t){i.addClass("sapUiSearchFieldTf");},renderInnerAttributes:function(i,t){if(!D.os.ios){i.writeAttribute("type","search");}if(r()){i.writeAttribute('autocapitalize','off');i.writeAttribute('autocorrect','off');}}}
});
j.TF.prototype.getFocusDomRef=j.TF.prototype.getInputDomRef;
C.extend("sap.ui.commons.SearchField.CB",{
metadata:{visibility:"hidden"},
constructor:function(i,t){C.apply(this,arguments);this._mSuggestions={};this._aSuggestValues=[];this.mobile=false;},
updateSuggestions:function(i,t){this._mSuggestions[i]=t;if(this.getInputDomRef()&&q(this.getInputDomRef()).val()===i&&this._hasSuggestValue(i)){this._doUpdateList(i);}},
applyFocusInfo:function(F){q(this.getInputDomRef()).val(F.sTypedChars);return this;},
_getListBox:function(){return this.getParent()._lb;},
_hasSuggestValue:function(i){return this._aSuggestValues.length>0&&i==this._aSuggestValues[this._aSuggestValues.length-1];},
_doUpdateList:function(i,t){var E=this._updateList(i);this._aSuggestValues=[i];if((!this.oPopup||!this.oPopup.isOpen())&&!t&&!E){this._open();}else if(this.oPopup&&this.oPopup.isOpen()&&E){this._close();}if(!E&&!this._lastKeyIsDel&&i===q(this.getInputDomRef()).val()){this._doTypeAhead();}},
onclick:function(E){C.prototype.onclick.apply(this,arguments);if(E.target===this.getDomRef("searchico")){if(this.oPopup&&this.oPopup.isOpen()){this.oPopup.close();}if(!this.getParent().getEnableClear()){this.getParent().fireSearch();}else if(q(this.getInputDomRef()).val()&&this.getEditable()&&this.getEnabled()){this.setValue("");this._triggerValueHelp=true;this.onkeyup();this._aSuggestValues=[];if(this.getParent().getEnableFilterMode()){q(this.getInputDomRef()).val("");this.getParent().fireSearch();}}if(this.getEditable()&&this.getEnabled()){this.focus();}}else if(g(this.getDomRef("providerico"),E.target)){if(this.getEditable()&&this.getEnabled()){this.focus();}}},
onkeypress:j.TF.prototype.onkeypress,
onkeyup:function(E){var i=q(this.getInputDomRef());var v=i.val();this.getParent().$().toggleClass("sapUiSearchFieldVal",!!v);k(this.getParent());if(E){if(E.keyCode===K.F2){var F=q(this.getFocusDomRef());var t=F.data("sap.InNavArea");if(typeof t==="boolean"){F.data("sap.InNavArea",!t);}}if(C._isHotKey(E)||E.keyCode===K.F4&&E.which===0){return;}if(v&&v==i.getSelectedText()){return;}var u=E.which||E.keyCode;if(u!==K.ESCAPE||this instanceof j.TF){this._triggerValueHelp=true;this._lastKeyIsDel=u==K.DELETE||u==K.BACKSPACE;}}if(this._triggerValueHelp){this._triggerValueHelp=false;if(this._sSuggest){clearTimeout(this._sSuggest);this._sSuggest=null;}var w=q(this.getInputDomRef()).val();if((w&&w.length>=this.getParent().getStartSuggestion())||(!w&&this.getParent().getStartSuggestion()==0)){this._sSuggest=setTimeout(function(){this._triggerSuggest(w);}.bind(this),200);}else if(this._doUpdateList){this._doUpdateList(w,true);}}},
_triggerSuggest:function(i){this._sSuggest=null;if(!this._mSuggestions[i]||!this.getParent().getEnableCache()){this._aSuggestValues.push(i);var t=this.getParent().getSearchProvider();if(t){var u=this.getParent();t.suggest(i,function(v,w){if(u){u.suggest(v,w);}});}else{this.getParent().fireSuggest({value:i});}}else{this._doUpdateList(i);}},
_updateList:function(t){var E=false;var u=this._getListBox();u.destroyAggregation("items",true);var v=function(u,y,z,A){y=y?y:[];var F=Math.min(y.length,z);if(A&&F>0){u.addItem(new e());}for(var i=0;i<F;i++){u.addItem(new f({text:y[i]}));}return F;};var w=v(u,this.getParent()._oHistory.get(t),this.getParent().getMaxHistoryItems(),false);var x=v(u,t&&t.length>=this.getParent().getStartSuggestion()?this._mSuggestions[t]:[],this.getParent().getMaxSuggestionItems(),w>0);if(w<=0&&x==0){u.addItem(new f({text:p("SEARCHFIELD_NO_ITEMS"),enabled:false}));E=true;}var I=u.getItems().length;var M=this.getMaxPopupItems();u.setVisibleItems(M<I?M:I);u.setSelectedIndex(-1);u.setMinWidth(q(this.getDomRef()).rect().width+"px");u.rerender();return E;},
_prepareOpen:function(){},
_open:function(){C.prototype._open.apply(this,[0]);},
_rerenderListBox:function(){return this._updateList(this._aSuggestValues.length>0?this._aSuggestValues[this._aSuggestValues.length-1]:null)&&!this._forceOpen;},
_checkChange:function(E,i,t){this.getParent().fireSearch({noFocus:t});},
onsapfocusleave:function(E){if(E.relatedControlId===this._getListBox().getId()){this.focus();return;}this._checkChange(E,true,true);},
onfocusout:function(E){if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onblur){this.getRenderer().onblur(this);}this._checkChange(E,true,true);},
onsapshow:function(E){if(this.getParent().hasListExpander()){C.prototype.onsapshow.apply(this,arguments);}else{E.preventDefault();E.stopImmediatePropagation();}},
_handleSelect:function(i){var I=C.prototype._handleSelect.apply(this,arguments);if(I&&I.getEnabled()){this.getParent().fireSearch();}},
renderer:{renderOuterContentBefore:function(i,t){if(t.getParent().hasListExpander()){a.renderOuterContentBefore.apply(this,arguments);}s.apply(this,arguments);if(t.getParent().getSearchProvider()&&t.getParent().getSearchProvider().getIcon()){i.write("<div");i.writeAttributeEscaped('id',t.getId()+'-providerico');i.writeAttribute('unselectable','on');if(sap.ui.getCore().getConfiguration().getAccessibility()){i.writeAttribute("role","presentation");}i.addClass("sapUiSearchFieldProvIco");i.writeClasses();i.write("><img src=\""+t.getParent().getSearchProvider().getIcon()+"\"/></div>");}},renderOuterAttributes:function(i,t){a.renderOuterAttributes.apply(this,arguments);i.addClass("sapUiSearchFieldCb");if(t.getParent().getSearchProvider()&&t.getParent().getSearchProvider().getIcon()){i.addClass("sapUiSearchFieldCbProv");}},renderInnerAttributes:function(i,t){if(!D.os.ios){i.writeAttribute("type","search");}if(r()){i.writeAttribute('autocapitalize','off');i.writeAttribute('autocorrect','off');}}}
});
return j;});
sap.ui.predefine('sap/ui/commons/SearchFieldRenderer',[],function(){"use strict";var S={};
S.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiSearchField");if(!c.getEditable()||!c.getEnabled()){r.addClass("sapUiSearchFieldDsbl");}if(!c.hasListExpander()){r.addClass("sapUiSearchFieldNoExp");}if(c.getEnableClear()){r.addClass("sapUiSearchFieldClear");}if(c.getWidth()){r.addStyle("width",c.getWidth());}if(c.getValue()){r.addClass("sapUiSearchFieldVal");}r.writeClasses();r.writeStyles();r.write(">");r.renderControl(c._ctrl);if(c.getShowExternalButton()){r.renderControl(c._btn);}var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");r.write("<span id='",c.getId(),"-label' style='display:none;' aria-hidden='true'>");r.writeEscaped(a.getText("SEARCHFIELD_BUTTONTEXT"));r.write("</span>");r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/commons/SearchProvider',['./library','sap/ui/core/search/OpenSearchProvider'],function(l,O){"use strict";
var S=O.extend("sap.ui.commons.SearchProvider",{metadata:{deprecated:true,library:"sap.ui.commons"}});
S.prototype._doSuggest=function(s,a){this.suggest(a,function(v,b){if(s&&s.suggest){s.suggest(v,b);}});};
return S;});
sap.ui.predefine('sap/ui/commons/SegmentedButton',['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./SegmentedButtonRenderer'],function(q,C,I,S){"use strict";
var a=C.extend("sap.ui.commons.SegmentedButton",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.IFormContent"],library:"sap.ui.commons",properties:{enabled:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{buttons:{type:"sap.ui.commons.Button",multiple:true,singularName:"button"}},associations:{selectedButton:{type:"sap.ui.commons.Button",multiple:false}},events:{select:{parameters:{selectedButtonId:{type:"string"}}}}}});
a.prototype.init=function(){if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation);}this._oButtonDelegate={oSegmentedButton:this,onAfterRendering:this._buttonOnAfterRendering};};
a.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
a.prototype.onAfterRendering=function(){this._setItemNavigation(true);};
a.prototype._buttonSelected=function(e){var o=sap.ui.getCore().byId(this.getSelectedButton()),n=e.getSource();if(n!==o){this.setSelectedButton(n);this.fireSelect({selectedButtonId:n.getId()});}};
a.prototype._setItemNavigation=function(A){var b,B,c=[];if(!this.getEnabled()){return;}if(this.getDomRef()){this._oItemNavigation.setRootDomRef(this.getDomRef("radiogroup"));B=this.getButtons();for(var i=0;i<B.length;i++){b=B[i];c.push(b.getDomRef());this._setAriaInfo(b,i+1);if(A){b.removeDelegate(this._oButtonDelegate);b.addDelegate(this._oButtonDelegate);}}this._oItemNavigation.setItemDomRefs(c);}};
a.prototype._setAriaInfo=function(b,i){var $=q(b.getDomRef()),l=this.getButtons().length;$.attr("aria-posinset",i);$.attr("aria-setsize",l);$.attr("role","radio");if(b.getId()===this.getSelectedButton()){$.attr("aria-checked","true");$.removeAttr("aria-describedby");}else{$.removeAttr("aria-checked");$.attr("aria-describedby",this.getId()+"-label");}};
a.prototype._buttonOnAfterRendering=function(){this.oSegmentedButton._setItemNavigation();};
a.prototype._rerenderButtons=function(){var $=this.$();if($.length>0){var r=sap.ui.getCore().createRenderManager();S.renderButtons(r,this);r.flush($[0]);r.destroy();}};
a.prototype.addButton=function(b){this.addAggregation("buttons",b,true);b.attachPress(this._buttonSelected,this);this._rerenderButtons();return this;};
a.prototype.insertButton=function(b,i){this.insertAggregation("buttons",b,i,true);b.attachPress(this._buttonSelected,this);this._rerenderButtons();return this;};
a.prototype.removeButton=function(b){var r=this.removeAggregation("buttons",b,true);if(r){r.detachPress(this._buttonSelected,this);r.removeDelegate(this._oButtonDelegate);this._rerenderButtons();}return r;};
a.prototype.removeAllButtons=function(){var r=this.removeAllAggregation("buttons",true);q.each(r,function(i,b){b.detachPress(this._buttonSelected,this);b.removeDelegate(this._oButtonDelegate);});this._rerenderButtons();return r;};
a.prototype.setSelectedButton=function(b){var B,o=sap.ui.getCore().byId(this.getSelectedButton());this.setAssociation("selectedButton",b,true);B=sap.ui.getCore().byId(this.getSelectedButton());this._setItemNavigation();var c=this.getButtons();for(var i=0;i<c.length;i++){if(c[i]===B){this._oItemNavigation.setFocusedIndex(i);break;}}if(o){o.removeStyleClass("sapUiSegButtonSelected");o.$().blur();}if(o&&o._icon){o.setIcon(o._icon);o._icon=null;}if(B){if(B.getIconHovered()){B._icon=B.getIcon();B.setIcon(B.getIconHovered());}B.addStyleClass("sapUiSegButtonSelected");}return this;};
a.prototype.setEnabled=function(e){q.each(this.getButtons(),function(i,b){b.setEnabled(e);});if(this._oItemNavigation&&!e){this.removeDelegate(this._oItemNavigation);}else{this.addDelegate(this._oItemNavigation);}this.setProperty("enabled",e);return this;};
a.prototype.clone=function(s){var b=this.getButtons(),B,i=0;for(;i<b.length;i++){B=b[i];B.detachPress(this._buttonSelected,this);}var c=C.prototype.clone.apply(this,arguments);for(i=0;i<b.length;i++){B=b[i];B.attachPress(this._buttonSelected,this);}return c;};
a.prototype.getFocusDomRef=function(){return this.getDomRef("radiogroup")||null;};
return a;});
sap.ui.predefine('sap/ui/commons/SegmentedButtonRenderer',[],function(){"use strict";var S={};
S.render=function(r,c){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons"),t=a.getText("SEGMENTEDBUTTON_ARIA_SELECT");r.write("<span");r.writeControlData(c);r.addClass("sapUiSegmentedButton");r.writeClasses();r.write(">");r.write('<span id="'+c.getId()+'-radiogroup"');r.writeAccessibilityState(c,{role:"radiogroup",disabled:!c.getEnabled()});if(c.getEnabled()){r.writeAttribute("tabindex","0");}else{r.writeAttribute("tabindex","-1");}r.write(">");this.renderButtons(r,c);r.write("</span>");r.write('<span id="'+c.getId()+'-label" style="visibility: hidden; display: none;">');r.writeEscaped(t);r.write('</span>');r.write("</span>");};
S.renderButtons=function(r,c){c.getButtons().forEach(function(b){r.renderControl(b);});};
return S;},true);
sap.ui.predefine('sap/ui/commons/Slider',['sap/ui/thirdparty/jquery','sap/base/Log','sap/ui/dom/containsOrEquals','sap/ui/events/ControlEvents','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/ResizeHandler','./SliderRenderer'],function(q,L,c,C,l,a,E,R,S){"use strict";
var b=a.extend("sap.ui.commons.Slider",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},min:{type:"float",group:"Appearance",defaultValue:0},max:{type:"float",group:"Appearance",defaultValue:100},value:{type:"float",group:"Appearance",defaultValue:50},smallStepWidth:{type:"float",group:"Appearance",defaultValue:null},totalUnits:{type:"int",group:"Appearance",defaultValue:null},stepLabels:{type:"boolean",group:"Appearance",defaultValue:false},editable:{type:"boolean",group:"Behavior",defaultValue:true},enabled:{type:"boolean",group:"Behavior",defaultValue:true},labels:{type:"string[]",group:"Misc",defaultValue:null},vertical:{type:"boolean",group:"Appearance",defaultValue:false},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"float"}}},liveChange:{parameters:{value:{type:"float"}}}}}});
E.call(b.prototype);
b.prototype.exit=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
b.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}var m=this.getMin();var M=this.getMax();if(m>M){L.warning('Property wrong: Min:'+m+' > Max:'+M+'; values switched',this);this.setMin(M);this.setMax(m);M=m;m=this.getMin();}};
b.prototype.onAfterRendering=function(){this.oGrip=this.getDomRef("grip");this.oBar=this.getDomRef("bar");this.oHiLi=this.getDomRef("hili");this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this.bAcc=sap.ui.getCore().getConfiguration().getAccessibility();this.bTextLabels=(this.getLabels()&&this.getLabels().length>0);this.oMovingGrip=this.oGrip;if(this.bTextLabels&&(this.getLabels().length-1)!=this.getTotalUnits()){L.warning('label count should be one more than total units',this);}this.iDecimalFactor=this.calcDecimalFactor(this.getSmallStepWidth());this.iShiftGrip=Math.round(this.getOffsetWidth(this.oGrip)/2);var v=this.getValue();var m=this.getMin();var M=this.getMax();if(v>M){L.warning('Property wrong: value:'+v+' > Max:'+M+'; value set to Max',this);v=M;}else if(v<m){L.warning('Property wrong: value:'+v+' < Min:'+m+'; value set to Min',this);v=m;}var n=(v-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl||this.getVertical()){n=this.getBarWidth()-n;}this.changeGrip(v,n,this.oGrip);this.repositionTicksAndLabels();this.allowTextSelection(false);this.oDomRef=this.getDomRef();this.sResizeListenerId=R.register(this.oDomRef,q.proxy(this.onresize,this));};
b.prototype.onclick=function(e){var m=this.oMovingGrip;if(this.getEditable()&&this.getEnabled()){var M;var s=e.target.getAttribute('ID');var n=this.getValue();var N=this.getOffsetLeft(this.oGrip)+this.iShiftGrip;var t=0;var o=0;var O=0;switch(s){case(this.oBar.id):case(this.oHiLi.id):if(this.getVertical()){M=this.getBarWidth()-this.getOffsetX(e);}else{M=this.getOffsetX(e);}if(s==this.oHiLi.id){if(this.getVertical()){M-=this.getOffsetLeft(this.oHiLi);}else{M+=this.getOffsetLeft(this.oHiLi);}}n=this.convertRtlValue(this.getMin()+(((this.getMax()-this.getMin())/this.getBarWidth())*M));N=this.getOffsetX(e);if(s==this.oHiLi.id){N+=this.getOffsetLeft(this.oHiLi);}if(this.oStartTarget&&this.targetIsGrip(this.oStartTarget.id)){m=this.oStartTarget;}else if(this.targetIsGrip(s)){m=e.target;}else{m=this.getNearestGrip(N);}break;case(this.getId()+'-left'):N=0;if(this.getVertical()){n=this.getMax();m=this.getRightGrip();}else{n=this.getMin();m=this.getLeftGrip();}break;case(this.getId()+'-right'):N=this.getBarWidth();if(!this.getVertical()){n=this.getMax();m=this.getRightGrip();}else{n=this.getMin();m=this.getLeftGrip();}break;default:if(this.targetIsGrip(s)){return;}t=s.search('-tick');if(t>=0){var T=parseInt(s.slice(this.getId().length+5));N=this.fTickDist*T;var i;if(this.bTextLabels){i=this.getLabels().length-1;}else{i=this.getTotalUnits();}n=this.convertRtlValue(this.getMin()+(((this.getMax()-this.getMin())/i)*T));if(this.oStartTarget&&this.targetIsGrip(this.oStartTarget.id)){m=this.oStartTarget;}else if(this.targetIsGrip(s)){m=e.target;}else{m=this.getNearestGrip(N);}break;}o=q(this.oBar).offset();O=q(e.target).offset();if(this.getVertical()){N=this.getOffsetX(e)-(o.top-O.top);}else{N=this.getOffsetX(e)-(o.left-O.left);}if(N<=0){N=0;if(this.getVertical()){n=this.getMax();}else{n=this.getMin();}}else{if(N>=this.getBarWidth()){N=this.getBarWidth();if(this.getVertical()){n=this.getMin();}else{n=this.getMax();}}else{if(this.getVertical()){M=this.getBarWidth()-N;}else{M=N;}n=this.getMin()+(((this.getMax()-this.getMin())/this.getBarWidth())*M);}}n=this.convertRtlValue(n);if(this.oStartTarget&&this.targetIsGrip(this.oStartTarget.id)){m=this.oStartTarget;}else if(this.targetIsGrip(s)){m=e.target;}else{m=this.getNearestGrip(N);}break;}var v=this.validateNewPosition(n,N,m,(this.getValueForGrip(m)>n));n=v.fNewValue;N=v.iNewPos;this.changeGrip(n,N,m);this.handleFireChange();}m.focus();this.oMovingGrip=m;this.oStartTarget=null;};
b.prototype.onmousedown=function(e){if(this.getEditable()&&this.getEnabled()&&!this._cancelMousedown){var m=e.target.getAttribute('ID');if(this.targetIsGrip(m)){this.bGripMousedown=true;if(e.targetTouches){this.iStartDragX=e.targetTouches[0].pageX;this.iStartDragY=e.targetTouches[0].pageY;}else{this.iStartDragX=e.pageX;this.iStartDragY=e.pageY;}this.iStartLeft=this.getOffsetLeft(e.target)+this.iShiftGrip;this.oMovingGrip=e.target;var t=this;this.handleMoveCall=function(f){t.handleMove(f);};this.preventSelect=function(f){return false;};if(!e.targetTouches){q(window.document).bind('mousemove',this.handleMoveCall);q(window.document).bind('selectstart',this.preventSelect);C.bindAnyEvent(q.proxy(this.onAnyEvent,this));}}this.oStartTarget=null;}};
function d(e){return(e.originalEvent&&e.originalEvent.type&&e.originalEvent.type.startsWith("mouse"))||(e.handleObj&&e.handleObj.origType&&e.handleObj.origType.startsWith("mouse"));}
b.prototype.ontouchstart=function(e){if(d(e)){return;}this._cancelMousedown=false;this.onmousedown(e);this._cancelMousedown=true;};
b.prototype.onmouseup=function(e){if(this.getEditable()&&this.getEnabled()){this.bGripMousedown=false;if(this.handleMoveCall){q(window.document).unbind('mousemove',this.handleMoveCall);q(window.document).unbind('selectstart',this.preventSelect);C.unbindAnyEvent(this.onAnyEvent);if(this.iStartLeft!=(this.getOffsetLeft(this.oMovingGrip)+this.iShiftGrip)){this.handleFireChange(true);}this.handleMoveCall=null;this.iStartDragX=null;this.iStartDragY=null;this.iStartLeft=null;}}};
b.prototype.ontouchend=function(e){if(d(e)){return;}this.onmouseup(e);};
b.prototype.handleMove=function(e){if(this.getEditable()&&this.getEnabled()&&this.bGripMousedown){e=e||window.event;var p,P;if(e.targetTouches){p=e.targetTouches[0].pageX;P=e.targetTouches[0].pageY;}else{p=e.pageX;P=e.pageY;}var n;var N;if(this.getVertical()){n=this.iStartLeft+P-this.iStartDragY;}else{n=this.iStartLeft+p-this.iStartDragX;}if(n<=0){n=0;if(this.getVertical()){N=this.getMax();}else{N=this.getMin();}}else{if(n>=this.getBarWidth()){n=this.getBarWidth();if(this.getVertical()){N=this.getMin();}else{N=this.getMax();}}else{var m;if(this.getVertical()){m=this.getBarWidth()-n;}else{m=n;}N=this.getMin()+(((this.getMax()-this.getMin())/this.getBarWidth())*m);}}N=this.convertRtlValue(N);var o=this.getValueForGrip(this.oMovingGrip);var v=this.validateNewPosition(N,n,this.oMovingGrip,(o>N));N=v.fNewValue;n=v.iNewPos;this.changeGrip(N,n,this.oMovingGrip);N=this.getValueForGrip(this.oMovingGrip);this.fireLiveChangeForGrip(this.oMovingGrip,N,o);this.oStartTarget=this.oMovingGrip;}e.cancelBubble=true;return false;};
b.prototype.ontouchmove=function(e){if(d(e)){return;}this.handleMove(e);e.preventDefault();};
b.prototype.fireLiveChangeForGrip=function(g,n,o){if(g==this.oGrip){if(o!=n){this.fireLiveChange({value:n});}}};
b.prototype.onAnyEvent=function(e){L.debug('onAnyEvent fired: "'+e.type+'"');if((!this.getEditable())||(!this.getEnabled())||!this.bGripMousedown){return;}var s=e.target;if((!c(this.oDomRef,s)||s.tagName=="BODY")&&e.type=='mouseup'){this.onmouseup(e);}};
b.prototype.onsapright=function(e){if(this.getEditable()&&this.getEnabled()){var n=this.convertRtlValue(this.getValueForGrip(this.oMovingGrip));var N=this.getOffsetLeft(this.oMovingGrip)+this.iShiftGrip;if(this.getSmallStepWidth()>0){var s=this.getBarWidth()/(this.getMax()-this.getMin())*this.getSmallStepWidth();if(s>1){n=n+this.getSmallStepWidth();if(this.getVertical()){N=N-s;}else{N=N+s;}}else{n=n+(1/s*this.getSmallStepWidth());if(this.getVertical()){N=N-1;}else{N=N+1;}}}else{n=n+((this.getMax()-this.getMin())/this.getBarWidth());if(this.getVertical()){N=N-1;}else{N=N+1;}}n=this.convertRtlValue(n);var v=this.validateNewPosition(n,N,this.oMovingGrip,!this.getVertical()&&this.bRtl);n=v.fNewValue;N=v.iNewPos;this.changeGrip(n,N,this.oMovingGrip);this.handleFireChange();}e.preventDefault();e.stopPropagation();};
b.prototype.onsapleft=function(e){if(this.getEditable()&&this.getEnabled()){var n=this.convertRtlValue(this.getValueForGrip(this.oMovingGrip));var N=this.getOffsetLeft(this.oMovingGrip)+this.iShiftGrip;if(this.getSmallStepWidth()>0){var s=this.getBarWidth()/(this.getMax()-this.getMin())*this.getSmallStepWidth();if(s>1){n=n-this.getSmallStepWidth();if(this.getVertical()){N=N+s;}else{N=N-s;}}else{n=n-(1/s*this.getSmallStepWidth());if(this.getVertical()){N=N+1;}else{N=N-1;}}}else{n=n-((this.getMax()-this.getMin())/this.getBarWidth());if(this.getVertical()){N=N+1;}else{N=N-1;}}n=this.convertRtlValue(n);var v=this.validateNewPosition(n,N,this.oMovingGrip,this.getVertical()||!this.bRtl);n=v.fNewValue;N=v.iNewPos;this.changeGrip(n,N,this.oMovingGrip);this.handleFireChange();}e.preventDefault();e.stopPropagation();};
b.prototype.onsapup=function(e){if(this.bRtl&&!this.getVertical()){this.onsapleft(e);}else{this.onsapright(e);}};
b.prototype.onsapdown=function(e){if(this.bRtl&&!this.getVertical()){this.onsapright(e);}else{this.onsapleft(e);}};
b.prototype.onsapexpand=function(e){if(!this.bRtl){this.onsapright(e);}else{this.onsapleft(e);}};
b.prototype.onsapcollapse=function(e){if(!this.bRtl){this.onsapleft(e);}else{this.onsapright(e);}};
b.prototype.onsaphome=function(e){if(this.getEditable()&&this.getEnabled()){var n=0;if(this.getVertical()||(this.bRtl&&!this.getVertical())){n=this.getBarWidth();}this.changeGrip(this.getMin(),n,this.oMovingGrip);this.handleFireChange();}e.preventDefault();e.stopPropagation();};
b.prototype.onsapend=function(e){if(this.getEditable()&&this.getEnabled()){var n=this.getBarWidth();if(this.getVertical()||(this.bRtl&&!this.getVertical())){n=0;}this.changeGrip(this.getMax(),n,this.oMovingGrip);this.handleFireChange();}e.preventDefault();e.stopPropagation();};
b.prototype.onsaprightmodifiers=function(e){if(this.getEditable()&&this.getEnabled()){if(!this.fPageSize){if(this.getTotalUnits()>0){this.fPageSize=(this.getMax()-this.getMin())/this.getTotalUnits();}else{this.fPageSize=(this.getMax()-this.getMin())/10;}}var n;if(!this.bRtl||this.getVertical()){n=this.getValueForGrip(this.oMovingGrip)+this.fPageSize;}else{n=this.getValueForGrip(this.oMovingGrip)-this.fPageSize;}var N=(n-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl&&!this.getVertical()){N=this.getBarWidth()-N;}if(this.getVertical()){if(N>this.getBarWidth()){N=this.getBarWidth();}N=this.getBarWidth()-N;}var v=this.validateNewPosition(n,N,this.oMovingGrip,!this.getVertical()&&this.bRtl);n=v.fNewValue;N=v.iNewPos;this.changeGrip(n,N,this.oMovingGrip);this.handleFireChange();}e.preventDefault();e.stopPropagation();};
b.prototype.onsapleftmodifiers=function(e){if(this.getEditable()&&this.getEnabled()){if(!this.fPageSize){if(this.getTotalUnits()>0){this.fPageSize=(this.getMax()-this.getMin())/this.getTotalUnits();}else{this.fPageSize=(this.getMax()-this.getMin())/10;}}var n;if(!this.bRtl||this.getVertical()){n=this.getValueForGrip(this.oMovingGrip)-this.fPageSize;}else{n=this.getValueForGrip(this.oMovingGrip)+this.fPageSize;}var N=(n-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl&&!this.getVertical()){N=this.getBarWidth()-N;}if(this.getVertical()){if(N<0){N=0;}N=this.getBarWidth()-N;}var v=this.validateNewPosition(n,N,this.oMovingGrip,this.getVertical()||!this.bRtl);n=v.fNewValue;N=v.iNewPos;this.changeGrip(n,N,this.oMovingGrip);this.handleFireChange();}e.preventDefault();e.stopPropagation();};
b.prototype.onsapdownmodifiers=function(e){if(this.bRtl&&!this.getVertical()){this.onsaprightmodifiers(e);}else{this.onsapleftmodifiers(e);}};
b.prototype.onsapupmodifiers=function(e){if(this.bRtl&&!this.getVertical()){this.onsapleftmodifiers(e);}else{this.onsaprightmodifiers(e);}};
b.prototype.onresize=function(e){if(!this.getDomRef()){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}return;}var n=this.getValue();var N=(n-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.getVertical()||this.bRtl){N=this.getBarWidth()-N;}this.changeGrip(n,N,this.oGrip);this.repositionTicksAndLabels();};
b.prototype.repositionTicksAndLabels=function(){var t;if(this.bTextLabels){t=this.getLabels().length-1;}else{t=this.getTotalUnits();}if(t>0){var T=null;var o=null;this.fTickDist=this.getBarWidth()/t;for(var i=0;i<=t;i++){T=this.getDomRef('tick'+i);var e=0;if(!this.bRtl||this.getVertical()){e=Math.round(this.fTickDist*i)-Math.ceil(this.getOffsetWidth(T)/2);}else{e=Math.round(this.fTickDist*i)-Math.floor(this.getOffsetWidth(T)/2);}if(this.getVertical()){e=this.getBarWidth()-e-this.getOffsetWidth(T);}this.setLeft(e,T);if(this.getStepLabels()&&i>0&&i<t){o=this.getDomRef('text'+i);if(this.getSmallStepWidth()>0&&this.iDecimalFactor>0&&!this.bTextLabels){q(o).text(Math.round(parseFloat(q(o).text())*this.iDecimalFactor)/this.iDecimalFactor);}if(!this.bRtl||this.getVertical()){e=Math.round((this.fTickDist*i))-Math.round((this.getOffsetWidth(o)/2));}else{e=Math.round((this.fTickDist*(t-i)))-Math.round((this.getOffsetWidth(o)/2));}if(this.getVertical()){e=this.getBarWidth()-e-this.getOffsetWidth(o);}this.setLeft(e,o);}}}};
b.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.iShiftGrip=Math.round(this.getOffsetWidth(this.oGrip)/2);this.onresize();}};
b.prototype.changeGrip=function(n,N,g){if(N!=(this.getOffsetLeft(g)+this.iShiftGrip)){if(this.getSmallStepWidth()>0){var s=parseInt((n-this.getMin())/this.getSmallStepWidth());var f=(s*this.getSmallStepWidth())+this.getMin();var r=((s+1)*this.getSmallStepWidth())+this.getMin();if(r>this.getMax()){r=this.getMax();}var e=this.getBarWidth()/(this.getMax()-this.getMin())*this.getSmallStepWidth();if((n-f)<(r-n)){n=f;N=s*e;}else{n=r;N=(s+1)*e;if(N>this.getBarWidth()){N=this.getBarWidth();}}if(this.getVertical()||this.bRtl){N=this.getBarWidth()-N;}n=Math.round(n*this.iDecimalFactor)/this.iDecimalFactor;}var i=Math.round(N-this.iShiftGrip);if(isNaN(i)){return;}L.debug("iNewPos: "+N+" - iLeft: "+i+" - iShiftGrip: "+this.iShiftGrip);this.updateValueProperty(n,g);if(this.bTextLabels){g.title=this.getNearestLabel(n);}else{g.title=n;}this.setLeft(i,g);this.adjustHighlightBar(N,g);if(this.bAcc){this.setAriaState();}}};
b.prototype.updateValueProperty=function(n,g){this.setProperty('value',n,true);};
b.prototype.adjustHighlightBar=function(n,g){if(this.bRtl){if(this.getVertical()){this.oHiLi.style.height=this.getBarWidth()-Math.round(n)+'px';}else{this.oHiLi.style.width=this.getBarWidth()-Math.round(n)+'px';}}else{if(this.getVertical()){this.oHiLi.style.height=this.getBarWidth()-Math.round(n)+'px';}else{this.oHiLi.style.width=Math.round(n)+'px';}}};
b.prototype.calcDecimalFactor=function(V){var f=1;if(!(V>0)){return f;}var m=String(V);var M=0;if(m.indexOf('.')>=0){M=m.length-m.indexOf('.')-1;}else{if(m.indexOf('e-')>=0){M=m.slice(m.indexOf('e-')+2);}else{return f;}}for(var i=1;i<=M;i++){f=f*10;}return f;};
b.prototype.setEditable=function(e){this.setProperty('editable',e,true);if(this.oDomRef&&this.getEnabled()){if(e){q(this.oDomRef).removeClass('sapUiSliRo').addClass('sapUiSliStd');if(this.bAcc){q(this.oGrip).attr('aria-disabled',false).attr('aria-readonly',false);}}else{q(this.oDomRef).removeClass('sapUiSliStd').addClass('sapUiSliRo');if(this.bAcc){q(this.oGrip).attr('aria-disabled',true).attr('aria-readonly',true);}}}return this;};
b.prototype.setEnabled=function(e){this.setProperty('enabled',e,true);if(this.oDomRef){q(this.oDomRef).toggleClass('sapUiSliDsbl',!e);if(e){q(this.oGrip).attr('tabindex','0');if(this.getEditable()){q(this.oDomRef).addClass('sapUiSliStd');if(this.bAcc){q(this.oGrip).attr('aria-disabled',false);}}else{q(this.oDomRef).addClass('sapUiSliRo');if(this.bAcc){q(this.oGrip).attr('aria-disabled',true);}}}else{q(this.oGrip).attr('tabindex','-1').attr('aria-disabled',true);if(this.getEditable()){q(this.oDomRef).removeClass('sapUiSliStd');}else{q(this.oDomRef).removeClass('sapUiSliRo');}}}return this;};
b.prototype.setTotalUnits=function(t){this.setProperty('totalUnits',t,false);this.fPageSize=false;return this;};
b.prototype.setValue=function(v){var n,m,M,B,i,N=parseFloat(v);this.setProperty('value',v,true);this._lastValue=v;if(!this.oBar||isNaN(v)){return this;}m=this.getMin();M=this.getMax();B=this.getBarWidth();i=this.getVertical();if(N>M){N=M;n=B;}else if(N<m){N=m;n=0;}else{n=((N-m)/(M-m))*B;}if(this.bRtl||i){n=B-n;}this.changeGrip(N,n,this.oGrip);this._lastValue=N;return this;};
b.prototype.handleFireChange=function(n){var v=this.getValue();if(v!==this._lastValue){this.fireChange({value:v});if(!n){this.fireLiveChange({value:v});}this._lastValue=v;}};
b.prototype.setAriaState=function(){var v=this.getValue();if(this.bTextLabels){v=this.getNearestLabel(v);}this.oGrip.setAttribute('aria-valuenow',v);};
b.prototype.getValueForGrip=function(g){return this.getValue();};
b.prototype.validateNewPosition=function(n,N,g,m){if(!this.bRtl||this.getVertical()){if(m){if(n<=this.getMin()||N<=0){n=this.getMin();if(this.getVertical()){N=this.getBarWidth();}else{N=0;}}}else{if(n>=this.getMax()||N>this.getBarWidth()){n=this.getMax();if(!this.getVertical()){N=this.getBarWidth();}else{N=0;}}}}else{if(m){if(n<=this.getMin()||N>this.getBarWidth()){n=this.getMin();N=this.getBarWidth();}}else{if(n>=this.getMax()||N<=0){n=this.getMax();N=0;}}}return{fNewValue:n,iNewPos:N};};
b.prototype.getNearestLabel=function(v){var p=Math.round((this.getLabels().length-1)/(this.getMax()-this.getMin())*(v-this.getMin()));if(this.bRtl){p=this.getLabels().length-1-p;}return this.getLabels()[p];};
b.prototype.getNearestGrip=function(o){return this.oGrip;};
b.prototype.getLeftGrip=function(){return this.oGrip;};
b.prototype.getRightGrip=function(){return this.oGrip;};
b.prototype.setLeft=function(n,o){if(o==undefined){return;}if(this.getVertical()){o.style.top=n+'px';}else{o.style.left=n+'px';}};
b.prototype.getOffsetWidth=function(o){if(this.getVertical()){return o.offsetHeight;}else{return o.offsetWidth;}};
b.prototype.getBarWidth=function(){if(this.getVertical()){return this.oBar.clientHeight;}else{return this.oBar.clientWidth;}};
b.prototype.getOffsetLeft=function(o){if(this.getVertical()){return o.offsetTop;}else{return o.offsetLeft;}};
b.prototype.getOffsetX=function(e){if(this.getVertical()){return e.getOffsetY();}else{if(this.bRtl){return e.getOffsetX();}else{return e.getOffsetX();}}};
b.prototype.convertRtlValue=function(n){if(this.bRtl&&!this.getVertical()){n=this.getMax()-n+this.getMin();}return n;};
b.prototype.targetIsGrip=function(m){if(m==this.oGrip.id){return true;}return false;};
b.prototype.getFocusDomRef=function(){return this.oGrip;};
b.prototype.getIdForLabel=function(){return this.getId()+'-grip';};
return b;});
sap.ui.predefine('sap/ui/commons/SliderRenderer',[],function(){"use strict";var S={};
S.render=function(r,s){r.write('<div');r.writeControlData(s);r.addClass('sapUiSli');this.controlAdditionalCode(r,s);if(s.getTooltip_AsString()){r.writeAttributeEscaped('title',s.getTooltip_AsString());}if(!s.getVertical()&&s.getWidth()){r.writeAttribute('style','width:'+s.getWidth()+';');}else{r.writeAttribute('style','height:'+s.getHeight()+';');}if(!s.getEnabled()){r.addClass('sapUiSliDsbl');}else{if(!s.getEditable()){r.addClass('sapUiSliRo');}else{r.addClass('sapUiSliStd');}}if(s.getVertical()){r.addClass('sapUiSliVert');}else{r.addClass('sapUiSliHori');}r.writeClasses();if(s.getTooltip_AsString()){r.write('><span id="'+s.getId()+'-Descr" style="visibility: hidden; display: none;">');r.writeEscaped(s.getTooltip_AsString());r.write('</span');}r.write('><div');r.writeAttribute('id',s.getId()+'-right');r.write('class="sapUiSliR" > <DIV');r.writeAttribute('id',s.getId()+'-left');r.write('class="sapUiSliL" > <DIV');r.writeAttribute('id',s.getId()+'-bar');r.write('class="sapUiSliBar" >');var u=false;if(s.getLabels()&&s.getLabels().length>0){u=true;}if(s.getTotalUnits()>0||u){var t=s.getTotalUnits();if(u){t=s.getLabels().length-1;}var f=(s.getMax()-s.getMin())/t;for(var i=0;i<=t;i++){r.write('<div');r.writeAttribute('id',s.getId()+'-tick'+i);r.write('class="sapUiSliTick" ');r.write('></div>');if(s.getStepLabels()){r.write('<div');r.writeAttribute('id',s.getId()+'-text'+i);switch(i){case(0):r.write('class="sapUiSliText sapUiSliTextLeft" >');break;case(t):r.write('class="sapUiSliText sapUiSliTextRight" >');break;default:r.write('class="sapUiSliText" >');break;}if(u){r.writeEscaped(s.getLabels()[i]);}else{r.write(s.getMin()+i*f);}r.write('</div>');}}}r.write('<div');r.writeAttribute('id',s.getId()+'-hili');r.write('class="sapUiSliHiLi"></DIV>');this.renderGrip(r,s);r.write('</div></div></div></div>');};
S.renderGrip=function(r,s){r.write('<div');r.writeAttribute('id',s.getId()+'-grip');if(s.getEnabled()){r.writeAttribute('tabindex','0');}else{r.writeAttribute('tabindex','-1');}r.writeAttribute('class','sapUiSliGrip');r.writeAttribute('title',s.getValue());var o='horizontal';if(s.getVertical()){o='vertical';}r.writeAccessibilityState(s,{role:'slider',orientation:o,valuemin:s.getMin(),valuemax:s.getMax(),disabled:!s.getEditable()||!s.getEnabled(),describedby:s.getTooltip_AsString()?(s.getId()+'-Descr '+s.getAriaDescribedBy().join(" ")):undefined});if(s.getVertical()){r.write('>&#9668;</div>');}else{r.write('>&#9650;</div>');}};
S.controlAdditionalCode=function(r,s){};
return S;},true);
sap.ui.predefine('sap/ui/commons/Splitter',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/ResizeHandler','sap/ui/core/delegate/ItemNavigation','./SplitterRenderer','sap/ui/core/library'],function(q,l,C,P,R,I,S,c){"use strict";var O=c.Orientation;
var a=C.extend("sap.ui.commons.Splitter",{metadata:{library:"sap.ui.commons",properties:{splitterOrientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:O.Vertical},splitterPosition:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:'50%'},minSizeFirstPane:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:'0%'},minSizeSecondPane:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:'0%'},width:{type:"sap.ui.commons.SplitterSize",group:"Behavior",defaultValue:'100%'},height:{type:"sap.ui.commons.SplitterSize",group:"Behavior",defaultValue:'100%'},showScrollBars:{type:"boolean",group:"Behavior",defaultValue:true},splitterBarVisible:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{firstPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"firstPaneContent"},secondPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"secondPaneContent"}}}});
a.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}if(this.sSpecialResizeListenerId){R.deregister(this.sSpecialResizeListenerId);this.sSpecialResizeListenerId=null;}};
a.prototype.onAfterRendering=function(){this._recalculateInternals();this.sResizeListenerId=R.register(this.splitterDIV,q.proxy(this.onresize,this));};
a.prototype._recalculateInternals=function(){this.splitterDIV=this.getDomRef();this.splitterBar=document.getElementById(this.getId()+'_SB');this.firstPane=document.getElementById(this.getId()+'_firstPane');this.secondPane=document.getElementById(this.getId()+'_secondPane');this.minSizeFP=this.getMinSizeFirstPane();this.minSizeSP=this.getMinSizeSecondPane();this.minSizeFP=this.minSizeFP.substring(0,(this.minSizeFP).length-1);this.minSizeFP=parseFloat(this.minSizeFP);this.minSizeSP=this.minSizeSP.substring(0,(this.minSizeSP).length-1);this.minSizeSP=parseFloat(this.minSizeSP);this.spOrientation=this.getSplitterOrientation();this.sBarPosition=this.getSplitterPosition();this.sBarPosition=this.sBarPosition.substring(0,this.sBarPosition.length-1);this.sBarPosition=parseFloat(this.sBarPosition);if(sap.ui.getCore().getConfiguration().getTheme()=="sap_hcb"){this.sbSize=6;}else{this.sbSize=4;}this.resizeSplitterElements();var s=q(this.splitterBar).height();if(this.spOrientation==O.Vertical){if(s<=0||s>q(this.splitterDIV).height()){this.fixHeight();}}else{if(s<=0||s!=this.sbSize){this.fixHeight();}}};
a.prototype.onresize=function(e){this.resizeSplitterElements();};
a.prototype.resizeSplitterElements=function(){var s,b,w,h,d,e;if(this.spOrientation==O.Vertical){w=q(this.splitterDIV).width();if(w==0){w=100;}s=(this.sbSize*100)/w;if(this.sBarPosition>=100||this.sBarPosition+s>100){this.sBarPosition=100-s;d=0;}else{d=100-s-this.sBarPosition;}q(this.firstPane).css("width",this.sBarPosition+"%");q(this.splitterBar).css("width",s+"%");q(this.secondPane).css("width",d+"%");}else{h=q(this.splitterDIV).height();if(h==0){h=100;}b=(this.sbSize*100)/h;if(this.sBarPosition>=100||this.sBarPosition+b>100){this.sBarPosition=100-b;e=0;}else{e=100-b-this.sBarPosition;}q(this.firstPane).css("height",this.sBarPosition+"%");q(this.splitterBar).css("height",b+"%");q(this.secondPane).css("height",e+"%");}this.setProperty("splitterPosition",this.sBarPosition+"%",true);if(q(this.splitterDIV).height()==0&&!this.splitterDIV.style.height){q(this.splitterDIV).css("height","100px");q(this.splitterBar).css("height","100px");}};
a.prototype.setSplitterPosition=function(p){if(this.getDomRef()){this.setProperty("splitterPosition",p,true);this._recalculateInternals();}else{this.setProperty("splitterPosition",p);}return this;};
a.prototype.setSplitterBarVisible=function(v){if(this.getDomRef()){this.setProperty("splitterBarVisible",v,true);var s=this.getSplitterOrientation()===O.Vertical?"sapUiVertical":"sapUiHorizontal";if(v){q(document.getElementById(this.getId()+"_SB")).removeClass(s+"SplitterBarHidden").addClass(s+"SplitterBar");}else{q(document.getElementById(this.getId()+"_SB")).removeClass(s+"SplitterBar").addClass(s+"SplitterBarHidden");}}else{this.setProperty("splitterBarVisible",v);}return this;};
a.prototype.fixHeight=function(){var p=q(this.splitterDIV.parentNode).height();var s=q(this.splitterDIV).height();if(p>s){s=p;var b=this.getHeight();if(b&&b.toLowerCase().indexOf("px")!=-1){s=parseInt(b);}if(b&&b.toLowerCase().indexOf("%")!=-1){var d=parseInt(b);if(d<100){s=q(this.splitterDIV).height();}}if(s<=0){s=p;}}q(this.splitterDIV).css("height",s+"px");if(this.spOrientation==O.Vertical){q(this.splitterBar).css("height",s+"px");}var o=this.splitterDIV.parentNode;if(o){var h=q.proxy(this.onresizespecial,this);this.sSpecialResizeListenerId=R.register(o,h);}};
a.prototype.exit=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}if(this.sSpecialResizeListenerId){R.deregister(this.sSpecialResizeListenerId);this.sSpecialResizeListenerId=null;}};
a.prototype.onresizespecial=function(e){var s=q(this.splitterDIV);var o=s.height();s.css("height","0px");var d=this.getDomRef();if(d&&window.getComputedStyle){window.getComputedStyle(d);}var p=q(e.target).height();var b=s.height();if(b!=p){s.css("height",p+"px");if(this.spOrientation==O.Vertical){q(this.splitterBar).css("height",p+"px");}}if(p<=0){s.css("height",o+"px");if(this.spOrientation==O.Vertical){q(this.splitterBar).css("height",o+"px");}}};
a.prototype.onmousedown=function(e){if(e.target!=this.splitterBar){return;}var j=q(document.body);j.bind("selectstart",q.proxy(this.splitterSelectStart,this));var o=q(this.splitterBar).offset();var h=q(this.splitterBar).height();var w=q(this.splitterBar).width();var b;if(this.spOrientation==O.Vertical){b="sapUiVSBGhost";}else{b="sapUiHSBGhost";}var z=P.getLastZIndex()+5;if(z<20){z=20;}q(document.body).append("<div id=\""+this.getId()+"_ghost\" class=\""+b+"\" style =\" height:"+h+"px; width:"+w+"px; left:"+o.left+"px; top:"+o.top+"px;z-index:"+z+"\"></div>");q(document.body).append("<div id=\""+this.getId()+"_overlay\" style =\"left: 0px;"+" right: 0px; bottom: 0px; top: 0px; position:fixed; z-index:"+z+"\" ></div>");q(document).bind("mouseup",q.proxy(this.onGhostMouseRelease,this));q(document).bind("mousemove",q.proxy(this.onGhostMouseMove,this));q(this.splitterBar).focus();e.preventDefault();e.stopPropagation();};
a.prototype.splitterSelectStart=function(e){e.preventDefault();e.stopPropagation();return false;};
a.prototype.onGhostMouseRelease=function(e){var n,s,b;var d=document.getElementById(this.getId()+"_ghost");var r=sap.ui.getCore().getConfiguration().getRTL();if(this.spOrientation==O.Vertical){if(!r){n=e.pageX-q(this.firstPane).offset().left;b=q(this.splitterDIV).width();n=(n*100)/b;}else{n=e.pageX-q(this.secondPane).offset().left;b=q(this.splitterDIV).width();n=((b-n)*100)/b;}}else{n=e.pageY-q(this.firstPane).offset().top;s=q(this.splitterDIV).height();n=(n*100)/s;}if(n<this.minSizeFP){n=this.minSizeFP;}else if((100-n)<this.minSizeSP){n=100-this.minSizeSP;}this.sBarPosition=n;this.resizeSplitterElements();q(d).remove();q(document.getElementById(this.getId()+"_overlay")).remove();var j=q(document.body);j.unbind("selectstart",this.splitterSelectStart);q(document).unbind("mouseup",this.onGhostMouseRelease);q(document).unbind("mousemove",this.onGhostMouseMove);};
a.prototype.onGhostMouseMove=function(e){var s=document.getElementById(this.getId()+"_ghost");var m;var b;var r=sap.ui.getCore().getConfiguration().getRTL();var d=q(this.firstPane).offset().left;var w=q(this.splitterDIV).width();var f=q(this.secondPane).offset().left;if(this.getSplitterOrientation()==O.Vertical){if(!r){b=d+(w*this.minSizeFP)/100;m=d+(w*(100-this.minSizeSP))/100;if(e.pageX>b&&e.pageX<m){q(s).css("left",e.pageX+"px");}}else{b=f+(w*this.minSizeSP)/100;m=f+(w*(100-this.minSizeFP))/100;if(e.pageX>b&&e.pageX<m){q(s).css("left",e.pageX+"px");}}}else{var h=q(this.splitterDIV).height();b=q(this.firstPane).offset().top+(h*this.minSizeFP)/100;m=q(this.secondPane).offset().top+q(this.secondPane).height()-(h*this.minSizeSP)/100;if(e.pageY>b&&e.pageY<m){q(s).css("top",e.pageY+"px");}}};
a.prototype.getCtrlKey=function(e){return!!(e.ctrlKey||e.metaKey);};
a.prototype.checkModifierKey=function(e,b,A,s){return e.shiftKey==s&&e.altKey==A&&this.getCtrlKey(e)==b;};
a.prototype.onsaphome=function(e){if(e.target==this.splitterBar){this.sBarPosition=this.minSizeFP;this.resizeSplitterElements();e.preventDefault();e.stopPropagation();}};
a.prototype.onsapend=function(e){if(e.target==this.splitterBar){this.sBarPosition=100-this.minSizeSP;this.resizeSplitterElements();e.preventDefault();e.stopPropagation();}};
a.prototype.onArrowKeys=function(e,i){var w,h,s,b,n;if(this.spOrientation==O.Vertical){w=q(this.splitterDIV).width();b=q(this.firstPane).width();b=(b*100)/w;s=(10*100)/w;}else{h=q(this.splitterDIV).height();b=q(this.firstPane).height();b=(b*100)/h;s=(10*100)/h;}if(i=="false"){n=b-s;}else if(i=="true"){n=b+s;}if(n<this.minSizeFP){n=this.minSizeFP;}else if((100-n)<this.minSizeSP){n=100-this.minSizeSP;}this.sBarPosition=n;this.resizeSplitterElements();};
a.prototype.onsapupmodifiers=function(e){if(this.checkModifierKey(e,false,false,true)){if(e.target==this.splitterBar){if(this.spOrientation==O.Horizontal){this.onArrowKeys(e,"false");}else{this.onsapleftmodifiers(e);}}e.preventDefault();e.stopPropagation();}};
a.prototype.onsapdownmodifiers=function(e){if(this.checkModifierKey(e,false,false,true)){if(e.target==this.splitterBar){if(this.spOrientation==O.Horizontal){this.onArrowKeys(e,"true");}else{this.onsaprightmodifiers(e);}}e.preventDefault();e.stopPropagation();}};
a.prototype.onsapleftmodifiers=function(e){if(this.checkModifierKey(e,false,false,true)){if(e.target==this.splitterBar){if(this.spOrientation==O.Vertical){var r=sap.ui.getCore().getConfiguration().getRTL();if(r){this.onArrowKeys(e,"true");}else{this.onArrowKeys(e,"false");}}else{this.onsapupmodifiers(e);}}e.preventDefault();e.stopPropagation();}};
a.prototype.onsaprightmodifiers=function(e){if(this.checkModifierKey(e,false,false,true)){if(e.target==this.splitterBar){if(this.spOrientation==O.Vertical){var r=sap.ui.getCore().getConfiguration().getRTL();if(r){this.onArrowKeys(e,"false");}else{this.onArrowKeys(e,"true");}}else{this.onsapdownmodifiers(e);}}e.preventDefault();e.stopPropagation();}};
a.prototype.ondragstart=function(e){if(e.target!=this.splitterBar){return;}e.preventDefault();e.stopPropagation();};
a.prototype.getText=function(k,A){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(r){return r.getText(k,A);}return k;};
return a;});
sap.ui.predefine('sap/ui/commons/SplitterRenderer',['sap/ui/core/library'],function(c){"use strict";var O=c.Orientation;var S={};
S.render=function(r,C){var o=C.getSplitterOrientation();var p=C.getSplitterPosition();var d;var a;var l;var i;p=p.substring(0,p.length-1);d=100-p;r.write("<div ");r.writeControlData(C);r.addClass("sapUiSplitter");r.addStyle("width",C.getWidth());r.addStyle("height",C.getHeight());r.writeStyles();r.writeClasses();r.write(">");r.write("<div id=\""+C.getId()+"_firstPane\" ");if(C.getShowScrollBars()){r.addStyle("overflow","auto");}else{r.addStyle("overflow","hidden");}if(o==O.Vertical){r.addClass("sapUiVSplitterFirstPane");r.addStyle("width",p+"%");}else if(o==O.Horizontal){r.addClass("sapUiHSplitterFirstPane");r.addStyle("height",p+"%");}r.writeClasses();r.writeStyles();r.write(">");a=C.getFirstPaneContent();l=a.length;for(i=0;i<l;i++){r.renderControl(a[i]);}r.write("</div>");r.write("<div  id=\""+C.getId()+"_SB\" tabIndex=\"0\" role=\"separator\" title=\""+C.getText("SPLITTER_MOVE")+"\"");if(o==O.Vertical){if(C.getSplitterBarVisible()){r.addClass("sapUiVerticalSplitterBar");}else{r.addClass("sapUiVerticalSplitterBarHidden");}r.addStyle("width",0+"%");}else if(o==O.Horizontal){if(C.getSplitterBarVisible()){r.addClass("sapUiHorizontalSplitterBar");}else{r.addClass("sapUiHorizontalSplitterBarHidden");}r.addStyle("height",0+"%");}r.writeClasses();r.writeStyles();r.write(">");r.write("</div>");r.write("<div id=\""+C.getId()+"_secondPane\" ");if(C.getShowScrollBars()){r.addStyle("overflow","auto");}else{r.addStyle("overflow","hidden");}if(o==O.Vertical){r.addClass("sapUiVSplitterSecondPane");r.addStyle("width",d+'%');}else if(o==O.Horizontal){r.addClass("sapUiHSplitterSecondPane");r.addStyle("height",d+'%');}r.writeClasses();r.writeStyles();r.write(">");a=C.getSecondPaneContent();l=a.length;for(i=0;i<l;i++){r.renderControl(a[i]);}r.write("</div>");r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/commons/Tab',['./Panel','./library','sap/ui/core/library'],function(P,l,c){"use strict";var S=c.Scrolling;
var T=P.extend("sap.ui.commons.Tab",{metadata:{library:"sap.ui.commons",properties:{verticalScrolling:{type:"sap.ui.core.Scrolling",group:"Behavior",defaultValue:S.None},horizontalScrolling:{type:"sap.ui.core.Scrolling",group:"Behavior",defaultValue:S.None},closable:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:true}}}});
T.prototype.init=function(){this.oScrollDomRef=null;};
T.prototype.rerender=function(){var p=this.getParent();if(p){p.rerender();}};
T.prototype.invalidate=function(){var p=this.getParent();if(p){p.invalidate();}};
T.prototype.onAfterRendering=function(){this.oScrollDomRef=this.getDomRef("panel");if(this.oScrollDomRef){var s=this.getProperty("scrollTop")||0;this.oScrollDomRef.scrollTop=s;var a=this.getProperty("scrollLeft")||0;this.oScrollDomRef.scrollLeft=a;}};
T.prototype.getScrollLeft=function(){var s=0;if(this.oScrollDomRef){s=this.oScrollDomRef.scrollLeft;this.setProperty("scrollLeft",s,true);}return s;};
T.prototype.setScrollLeft=function(p){this.setProperty("scrollLeft",p,true);if(this.oScrollDomRef){this.bIgnoreScrollEvent=true;this.oScrollDomRef.scrollLeft=p;}return this;};
T.prototype.getScrollTop=function(){var s=0;if(this.oScrollDomRef){s=this.oScrollDomRef.scrollTop;this.setProperty("scrollTop",s,true);}return s;};
T.prototype.setScrollTop=function(p){this.setProperty("scrollTop",p,true);if(this.oScrollDomRef){this.bIgnoreScrollEvent=true;this.oScrollDomRef.scrollTop=p;}return this;};
T.prototype.setEnabled=function(e){if(e==this.getEnabled()){return this;}var d=this.getDomRef();var p=this.getParent();if(!d||(!e&&this.$().hasClass("sapUiTabSel"))||(e&&p&&p.getSelectedIndex&&p.getSelectedIndex()<0)){this.setProperty("enabled",e,false);if(p&&p._getActualSelectedIndex){var i=p._getActualSelectedIndex();p.setProperty('selectedIndex',i,true);}}else{this.setProperty("enabled",e,true);this.$().toggleClass("sapUiTab",e).toggleClass("sapUiTabDsbl",!e).attr("aria-disabled",!e);}return this;};
T.prototype.setWidth=function(w){this.setProperty("width",w,true);return this;};
T.prototype.setApplyContentPadding=function(p){this.setProperty("applyContentPadding",p,true);return this;};
T.prototype._handleTrigger=function(e){};
return T;});
sap.ui.predefine('sap/ui/commons/TabStrip',['sap/ui/thirdparty/jquery','sap/base/Log','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/Icon','sap/ui/core/delegate/ScrollEnablement','sap/ui/Device','./TabStripRenderer','sap/ui/core/ResizeHandler','sap/ui/core/Title','./Tab','sap/ui/events/KeyCodes','sap/ui/dom/jquery/parentByAttribute','sap/ui/dom/jquery/zIndex','sap/ui/thirdparty/jqueryui/jquery-ui-position'],function(q,L,l,C,I,a,S,D,T,R,b,c,K){"use strict";
var d=C.extend("sap.ui.commons.TabStrip",{metadata:{library:"sap.ui.commons",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},selectedIndex:{type:"int",group:"Misc",defaultValue:0},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"tabs",aggregations:{tabs:{type:"sap.ui.commons.Tab",multiple:true,singularName:"tab"},_leftArrowControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_rightArrowControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{select:{parameters:{index:{type:"int"}}},close:{parameters:{index:{type:"int"}}}}}});
d.SCROLL_SIZE=320;d.ANIMATION_DURATION=sap.ui.getCore().getConfiguration().getAnimation()?200:0;d.SCROLL_ANIMATION_DURATION=sap.ui.getCore().getConfiguration().getAnimation()?500:0;
d.prototype.init=function(){this._bInitialized=true;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._iCurrentScrollLeft=0;this._iMaxOffsetLeft=null;this._scrollable=null;this._oScroller=new S(this,this.getId()+"-tablist",{horizontal:!this.getEnableTabReordering(),vertical:false,nonTouchScrolling:true});this.data("sap-ui-fastnavgroup","true",true);};
d.prototype.setEnableTabReordering=function(v){this.setProperty("enableTabReordering",v,true);if(this._oScroller){this._oScroller.setHorizontal(!v);}return this;};
d.prototype.onBeforeRendering=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}};
d.prototype.onAfterRendering=function(){if(this._oScroller){this._oScroller.setIconTabBar(this,q.proxy(this._updateScrollingAppearance,this),null);}this._initItemNavigation();this._updateScrollingAppearance();this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._updateScrollingAppearance,this));var t=this.getTabs();var s=this.getSelectedIndex();var o=t[s];if(this._oScroller&&o&&o.$().length>0){if(!this._oScroller._$Container){this._oScroller.onAfterRendering();}this._scrollIntoView(o.$(),d.SCROLL_ANIMATION_DURATION);}for(var i=0;i<t.length;i++){t[i].onAfterRendering();}};
d.prototype.createTab=function(t,o){var e=new b({text:t}),f=new c();f.setTitle(e);f.addContent(o);this.addTab(f);return f;};
d.prototype.selectTabByDomRef=function(o){var i=this.getItemIndex(o);if(i>-1){if((i!=this.getSelectedIndex())&&(this.getTabs()[i].getEnabled())){var O=this.getSelectedIndex();this.setProperty('selectedIndex',i,true);this.rerenderPanel(O,true);this.oItemNavigation.setSelectedIndex(this.oItemNavigation.getFocusedIndex());}}};
d.prototype.onsapspace=function(e){var s=e.target;this.selectTabByDomRef(s);};
d.prototype.onsapspacemodifiers=d.prototype.onsapspace;d.prototype.onsapenter=d.prototype.onsapspace;d.prototype.onsapentermodifiers=d.prototype.onsapspace;
d.prototype.onsapdelete=function(e){var s=e.target;var i=this.getItemIndex(s);if(i>-1&&this.getTabs()[i].getClosable()){this.fireClose({index:i});}};
d.prototype.getFocusDomRef=function(){return this.getDomRef().firstChild;};
d.prototype.exit=function(){this._bInitialized=false;this._iCurrentScrollLeft=null;this._iMaxOffsetLeft=null;this._scrollable=null;if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation;}};
d.prototype.getItemIndex=function(o){var i;if(!o.id||o.id.search("-close")!=-1){var e=q(o).parentByAttribute("id");i=e.id;}else{i=o.id;}for(var f=0,t=this.getTabs();f<t.length;f++){if(i==t[f].getId()){return f;}}return-1;};
d.prototype.removeTab=function(e){var i=e;if(typeof(e)=="string"){e=sap.ui.getCore().byId(e);}if(typeof(e)=="object"){i=this.indexOfTab(e);}var t=this.getTabs()[i];if(t.getVisible()){t.setProperty("visible",false,true);this.hideTab(i);t.setProperty("visible",true,true);}if(this.getSelectedIndex()>i){this.setProperty('selectedIndex',this.getSelectedIndex()-1,true);}return this.removeAggregation("tabs",i,true);};
d.prototype.setSelectedIndex=function(s){var o=this.getSelectedIndex();if(s==o){return this;}var t=this.getTabs();var e=t[s];if(this._oScroller&&e&&e.$().length>0){this._scrollIntoView(e.$(),d.SCROLL_ANIMATION_DURATION);}if(!e&&!this.getDomRef()){this.setProperty('selectedIndex',s,false);}else if(e&&e.getEnabled()&&e.getVisible()){this.setProperty('selectedIndex',s,true);if(this.getDomRef()&&!this.invalidated){this.rerenderPanel(o);if(this.oItemNavigation){var v=0;var f=-1;for(var i=0;i<t.length;i++){e=t[i];if(e.getVisible()===false){continue;}if(i==s){f=v;break;}v++;}this.oItemNavigation.setSelectedIndex(f);}}}else{this._warningInvalidSelectedIndex(s,e);}return this;};
d.prototype.closeTab=function(i){var t=this.getTabs()[i];if(!t||!t.getClosable()||!t.getVisible()){return;}t.setProperty("visible",false,true);this.hideTab(i);};
d.prototype.hideTab=function(e){var t=this.getTabs()[e];if(!this.getDomRef()){return;}var f=this.oItemNavigation.getFocusedIndex();var v=parseInt(t.$().attr("aria-posinset"))-1;var F=sap.ui.getCore().getCurrentFocusedControlId();t.$().remove();if(this.iVisibleTabs==1){this.setProperty('selectedIndex',-1,true);t.$("panel").remove();}else if(e==this.getSelectedIndex()){var n=e+1;while(n<this.getTabs().length&&(!this.getTabs()[n].getEnabled()||!this.getTabs()[n].getVisible())){n++;}if(n==this.getTabs().length){n=e-1;while(n>=0&&(!this.getTabs()[n].getEnabled()||!this.getTabs()[n].getVisible())){n--;}}this.setProperty('selectedIndex',n,true);this.rerenderPanel(e);}else{this.toggleTabClasses(this.getSelectedIndex(),this.getSelectedIndex());}this.iVisibleTabs--;var v=0;var g=[];var s=-1;var h=false;for(var i=0;i<this.getTabs().length;i++){var t=this.getTabs()[i];if(F==t.getId()){h=true;}if(t.getVisible()===false){continue;}if(i==this.getSelectedIndex()){s=v;}v++;t.$().attr("aria-posinset",v).attr("aria-setsize",this.iVisibleTabs);g.push(t.getDomRef());}if(v<=f){f--;}this.oItemNavigation.setItemDomRefs(g);this.oItemNavigation.setSelectedIndex(s);this.oItemNavigation.setFocusedIndex(f);if(h){this.oItemNavigation.focusItem(f);}this._updateScrollingAppearance();};
d.prototype.rerenderPanel=function(o,f){var t=this.getTabs();var n=this.getSelectedIndex();var e=t[n];var O=t[o];setTimeout(function(){if(!this._bInitialized){return;}var $=this.$().find('.sapUiTabPanel');if(e){if($.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderTabContents(r,e);r.flush($[0]);r.destroy();}var N=e.getId();$.attr("id",N+"-panel").attr("aria-labelledby",N);}else{$.empty();}O.setProperty("scrollTop",$.scrollTop(),true);O.setProperty("scrollLeft",$.scrollLeft(),true);if(e){e.onAfterRendering();}if(f){this.fireSelect({index:n});}}.bind(this),0);if(e){this.toggleTabClasses(o,n);}};
d.prototype.toggleTabClasses=function(o,n){var t=this.getTabs();var e=t[o];if(e){e.$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",false);}var B=o-1;while(B>=0&&!t[B].getVisible()){B--;}if(B>=0){t[B].$().removeClass("sapUiTabBeforeSel");}var A=o+1;while(A<t.length&&!t[A].getVisible()){A++;}if(A<t.length){t[A].$().removeClass("sapUiTabAfterSel");}e=t[n];if(e){e.$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",true);}B=n-1;while(B>=0&&!t[B].getVisible()){B--;}if(B>=0){t[B].$().addClass("sapUiTabBeforeSel");}A=n+1;while(A<t.length&&!t[A].getVisible()){A++;}if(A<t.length){t[A].$().addClass("sapUiTabAfterSel");}};
d.prototype._originalInvalidate=d.prototype.invalidate;
d.prototype.invalidate=function(){this.invalidated=true;d.prototype._originalInvalidate.apply(this,arguments);};
d.prototype._warningInvalidSelectedIndex=function(s,t){var e="";if(!t){e="Tab not exists";}else if(!t.getEnabled()){e="Tab disabled";}else if(!t.getVisible()){e="Tab not visible";}L.warning("SelectedIndex "+s+" can not be set",e,"sap.ui.commons.TabStrip");};
d.prototype.onkeydown=function(e){if(e.which===K.ESCAPE){this._stopMoving();}};
d.prototype.onclick=function(e){var s=e.target;var $=q(s);if(s.className=="sapUiTabClose"){var i=this.getItemIndex($.parentByAttribute("id"));if(i>-1){this.fireClose({index:i});}}};
d.prototype.onmousedown=function(e){var f=!e.button;var i=this._isTouchMode(e);if(!i&&!f){return;}var s=e.target;var $=q(s);if(s.className=="sapUiTabClose"){e.preventDefault();e.stopPropagation();e.target=null;return;}this.selectTabByDomRef(s);if(!this.getEnableTabReordering()){return;}var g=$.closest(".sapUiTab, .sapUiTabSel, .sapUiTabDsbl");if(g.length===1){this._onTabMoveStart(g,e,i);}};
d.prototype._onTabMoveStart=function($,e,i){this._disableTextSelection();e.preventDefault();$.zIndex(this.$().zIndex()+10);var f=this.getItemIndex(e.target);var t=this.getTabs()[f];var g=this.$().find('.sapUiTabBarCnt').children();var h=q.inArray($[0],g);var w=$.outerWidth();this._dragContext={index:h,tabIndex:f,isTouchMode:i,startX:i?e.originalEvent.targetTouches[0].pageX:e.pageX,tab:t,tabWidth:w,tabCenter:$.position().left+w/2};this._aMovedTabIndexes=[];var j=q(document);if(i){j.bind("touchmove",q.proxy(this._onTabMove,this));j.bind("touchend",q.proxy(this._onTabMoved,this));}else{j.mousemove(q.proxy(this._onTabMove,this));j.mouseup(q.proxy(this._onTabMoved,this));}};
d.prototype._onTabMove=function(e){var o=this._dragContext;if(!o){return;}var f=this._isTouchMode(e);if(f){e.preventDefault();}var p=f?e.targetTouches[0].pageX:e.pageX;var g=p-o.startX;o.tab.$().css({left:g});var $,x,O,r,h=this.$().find('.sapUiTabBarCnt').children(),m=this._aMovedTabIndexes,j=sap.ui.getCore().getConfiguration().getRTL();for(var i=0;i<h.length;i++){if(i==o.index){continue;}$=q(h[i]);x=$.position().left;O=parseFloat($.css('left'));if(!isNaN(O)){x-=O;}if(i<o.index!=j){r=x+$.outerWidth()>o.tabCenter+g;this._onAnimateTab($,o.tabWidth,r,m,i);}else{r=x<o.tabCenter+g;this._onAnimateTab($,-o.tabWidth,r,m,i);}}};
d.prototype._onAnimateTab=function($,i,r,m,e){var f=q.inArray(e,m);var g=f!=-1;if(r&&!g){$.stop(true,true);$.animate({left:i},d.ANIMATION_DURATION);m.push(e);}else if(!r&&g){$.stop(true,true);$.animate({left:0},d.ANIMATION_DURATION);m.splice(f,1);}};
d.prototype._onTabMoved=function(e){var o=this._dragContext;if(!o){return;}this._stopMoving();var m=this._aMovedTabIndexes;if(m.length==0){return;}var $=o.tab.$(),f,g=this.$().find('.sapUiTabBarCnt').children();var n=m[m.length-1],s=n,N=this.getItemIndex(g[n]);this.removeAggregation('tabs',o.tab,true);this.insertAggregation('tabs',o.tab,N,true);if(n>o.index){$.insertAfter(q(g[n]));}else{$.insertBefore(q(g[n]));}g=this.$().find('.sapUiTabBarCnt').children();if(!o.tab.getEnabled()){for(var i=0;i<g.length;i++){f=q(g[i]);if(f.hasClass('sapUiTabSel')){s=i;N=this.getItemIndex(f[0]);break;}}}this.setProperty('selectedIndex',N,true);g.removeClass('sapUiTabAfterSel');g.removeClass('sapUiTabBeforeSel');for(var i=0;i<g.length;i++){f=q(g[i]);f.attr("aria-posinset",i+1);if(i==s-1){f.addClass('sapUiTabBeforeSel');}else if(i==s+1){f.addClass('sapUiTabAfterSel');}}$.focus();this._initItemNavigation();};
d.prototype._stopMoving=function(){var o=this._dragContext;if(!o){return;}var $=o.tab.$();$.css('z-index','');var e=this.$().find('.sapUiTabBarCnt').children();e.stop(true,true);e.css('left','');this._dragContext=null;var f=q(document);if(o.isTouchMode){f.unbind("touchmove",this._onTabMove);f.unbind("touchend",this._onTabMoved);}else{f.unbind("mousemove",this._onTabMove);f.unbind("mouseup",this._onTabMoved);}this._enableTextSelection();};
d.prototype._isTouchMode=function(e){return!!e.originalEvent["touches"];};
d.prototype._initItemNavigation=function(){var f=this.getDomRef('tablist'),t=f.childNodes,e=[],s=-1;for(var i=0;i<t.length;i++){e.push(t[i]);if(q(t[i]).hasClass("sapUiTabSel")){s=i;}}if(!this.oItemNavigation){this.oItemNavigation=new I();this.oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.oItemNavigation.setCycling(false);this.addDelegate(this.oItemNavigation);}this.oItemNavigation.setRootDomRef(f);this.oItemNavigation.setItemDomRefs(e);this.oItemNavigation.setSelectedIndex(s);};
d.prototype._disableTextSelection=function(e){q(e||document.body).attr("unselectable","on").addClass('sapUiTabStripNoSelection').bind("selectstart",function(E){E.preventDefault();return false;});};
d.prototype._enableTextSelection=function(e){q(e||document.body).attr("unselectable","off").removeClass('sapUiTabStripNoSelection').unbind("selectstart");};
d.prototype._getActualSelectedIndex=function(){var s=Math.max(0,this.getSelectedIndex());var t=this.getTabs();var o=t[s];if(o&&o.getVisible()&&o.getEnabled()){return s;}for(var i=0;i<t.length;i++){var e=t[i];if(e.getVisible()&&e.getEnabled()){return i;}}return 0;};
d.prototype._getLeftArrowControl=function(){var i=this.getAggregation('_leftArrowControl');var t=this;if(!i){i=new a({src:'sap-icon://navigation-left-arrow',noTabStop:true,useIconTooltip:false,tooltip:'',press:function(e){t._scroll(-d.SCROLL_SIZE,d.SCROLL_ANIMATION_DURATION);}}).addStyleClass('sapUiTabStripScrollIcon sapUiTabStripLeftScrollIcon');this.setAggregation("_leftArrowControl",i,true);}return i;};
d.prototype._getRightArrowControl=function(){var i=this.getAggregation('_rightArrowControl');var t=this;if(!i){i=new a({src:'sap-icon://navigation-right-arrow',noTabStop:true,useIconTooltip:false,tooltip:'',press:function(e){t._scroll(d.SCROLL_SIZE,d.SCROLL_ANIMATION_DURATION);}}).addStyleClass('sapUiTabStripScrollIcon sapUiTabStripRightScrollIcon');this.setAggregation("_rightArrowControl",i,true);}return i;};
d.prototype._scroll=function(i,e){var s=this.getDomRef("scrollCont").scrollLeft,f;if(this._bRtl&&D.browser.firefox){f=s-i;if(f<-this._iMaxOffsetLeft){f=-this._iMaxOffsetLeft;}if(f>0){f=0;}}else{f=s+i;if(f<0){f=0;}if(f>this._iMaxOffsetLeft){f=this._iMaxOffsetLeft;}}if(this._oScroller){this._oScroller.scrollTo(f,0,e);}this._iCurrentScrollLeft=f;};
d.prototype._scrollIntoView=function($,i){var e=this.$("tablist"),t=e.innerWidth()-e.width(),f=$.outerWidth(true),g=$.position().left-t/2,s=this.getDomRef("scrollCont"),h=s.scrollLeft,j=this.$("scrollCont").width(),n=h;if(g<0||g>j-f){if(this._bRtl&&D.browser.firefox){if(g<0){n+=g+f-j;}else{n+=g;}}else{if(g<0){n+=g;}else{n+=g+f-j;}}this._iCurrentScrollLeft=n;if(this._oScroller){this._oScroller.scrollTo(n,0,i);}}};
d.prototype._hasScrolling=function(){var t=this.getDomRef("tablist"),s=this.getDomRef("scrollCont"),e=t&&(t.scrollWidth>s.clientWidth);this.$().toggleClass("sapUiTabStripScrollable",e);return e;};
d.prototype._updateScrollingAppearance=function(){var t=this.getDomRef("tablist"),s=this.getDomRef("scrollCont"),i,r,e,f=false,g=false;if(this._hasScrolling()&&t&&s){if(this._bRtl&&D.browser.firefox){i=-s.scrollLeft;}else{i=s.scrollLeft;}r=t.scrollWidth;e=s.clientWidth;if(Math.abs(r-e)===1){r=e;}if(i>0){f=true;}if((r>e)&&(i+e<r)){g=true;}}this.$().toggleClass("sapUiTabStripScrollBack",f).toggleClass("sapUiTabStripScrollForward",g);this._iMaxOffsetLeft=Math.abs(q(s).width()-q(t).width());};
d.prototype._onItemNavigationAfterFocus=function(e){var i=e.getParameter("index"),$=e.getParameter('event');if(!$){return;}var f=q($.target);if(!f||$.keyCode===undefined){return;}if(i!==null&&i!==undefined){var n=q(f.parent().children()[i]);if(n&&n.length){this._scrollIntoView(n,0);}}};
return d;});
sap.ui.predefine('sap/ui/commons/TabStripRenderer',["sap/base/Log"],function(L){"use strict";var T=function(){};
T.render=function(r,c){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var C=c.getId();r.write("<div role='presentation'");r.addClass("sapUiTabStrip");r.addStyle("height",c.getHeight());r.addStyle("width",c.getWidth());r.writeClasses();r.writeStyles();r.writeControlData(c);r.write('><div class="sapUiTabBar"');if(c.getTooltip_AsString()){r.writeAttributeEscaped('title',c.getTooltip_AsString());}r.write("><div class=\"sapUiTabMenu\"></div>");r.renderControl(c._getLeftArrowControl());r.write('<div id="'+C+'-scrollCont" class="sapUiTabStripScrollContainer">');r.write('<ul id="'+C+'-tablist" class="sapUiTabBarCnt" role="tablist">');var t=c.getTabs();var w=false;var s=c.getSelectedIndex();if(s<0){s=0;c.setProperty('selectedIndex',0,true);}var S=t[s];if(!S||!S.getVisible()||!S.getEnabled()){c._warningInvalidSelectedIndex(s,S);w=true;}c.iVisibleTabs=0;for(var i=0;i<t.length;i++){var o=t[i];if(o.getVisible()===false){continue;}c.iVisibleTabs++;}var v=0;for(var i=0;i<t.length;i++){var o=t[i];if(o.getVisible()===false){continue;}if(w&&o.getEnabled()){c.setProperty('selectedIndex',i,true);s=i;w=false;}r.write("<li");if(o.getEnabled()==false){r.addClass("sapUiTabDsbl");}else if(i==s){r.addClass("sapUiTabSel");}else{r.addClass("sapUiTab");}if(i==s-1){r.addClass("sapUiTabBeforeSel");}else if(i==s+1){r.addClass("sapUiTabAfterSel");}r.writeControlData(o);r.writeAttribute("tabidx",i);v++;r.writeAttribute("tabindex","-1");r.writeAttribute("role","tab");r.writeAccessibilityState(o,{selected:i==s,controls:o.getId()+"-panel",disabled:!o.getEnabled(),posinset:v,setsize:c.iVisibleTabs});if(o.getClosable()){r.writeAccessibilityState(o,{describedby:o.getId()+"-close"});}r.writeClasses();var b=o.getTitle();if(b&&b.getTooltip_AsString()){r.writeAttributeEscaped('title',b.getTooltip_AsString());}else if(o.getTooltip_AsString()){r.writeAttributeEscaped('title',o.getTooltip_AsString());}r.write(">");if(b){var I=b.getIcon();if(I){var d=[];var A={"title":null};d.push("sapUiTabIco");r.writeIcon(I,d,A);}r.writeEscaped(b.getText());}else{L.warning("No title configured for "+o+". Either set a string as 'text' property or an sap.ui.core.Title as 'title' aggregation.");}if(o.getClosable()){r.write("<button id='"+o.getId()+"-close' type=\"button\" tabindex= \"-1\" class=\"sapUiTabClose\" title=\""+a.getText("TAB_CLOSE_TEXT")+"\"></button>");}r.write("</li>");}r.write("</ul></div>");r.renderControl(c._getRightArrowControl());r.write("</div>");if(w){c.setProperty('selectedIndex',-1,true);s=-1;r.write("<div id=\""+C+"-panel"+"\" role=\"tabpanel\"");r.addClass("sapUiTabPanel");if(c.getHeight()){r.addClass("sapUiTabPanelHeight");}r.writeClasses();r.write("></div>");}else{for(var i=0;i<t.length;i++){var o=t[i];if(i!=s||o.getVisible()===false){continue;}r.write("<div id=\""+o.getId()+"-panel"+"\" role=\"tabpanel\" aria-labelledby=\""+o.getId()+"\"");r.addClass("sapUiTabPanel");if(c.getHeight()){r.addClass("sapUiTabPanelHeight");}r.writeClasses();r.write(">");T.renderTabContents(r,o);r.write("</div>");}}r.write("</div>");c.invalidated=false;};
T.renderTabContents=function(r,c){var C=c.getContent(),l=C.length;for(var i=0;i<l;i++){r.renderControl(C[i]);}};
return T;},true);
sap.ui.predefine('sap/ui/commons/TextArea',['sap/ui/thirdparty/jquery','./TextField','./library','./TextAreaRenderer','sap/ui/Device','sap/ui/events/KeyCodes','sap/ui/dom/jquery/cursorPos','sap/ui/dom/jquery/selectText'],function(q,T,l,a,D,K){"use strict";
var b=T.extend("sap.ui.commons.TextArea",{metadata:{library:"sap.ui.commons",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},cols:{type:"int",group:"Dimension",defaultValue:null},rows:{type:"int",group:"Dimension",defaultValue:null},wrapping:{type:"sap.ui.core.Wrapping",group:"Appearance",defaultValue:null},cursorPos:{type:"int",group:"Appearance",defaultValue:null},explanation:{type:"string",group:"Misc",defaultValue:null},labeledBy:{type:"string",group:"Identification",defaultValue:null,deprecated:true}}}});
b.prototype.exit=function(){this._detachEventHandler();};
b.prototype.onBeforeRendering=function(){this._detachEventHandler();};
b.prototype.onAfterRendering=function(){T.prototype.onAfterRendering.apply(this,arguments);this._attachEventHandler();};
b.prototype._attachEventHandler=function(){var $=this.$();this.proChHandlerId=$.bind('propertychange',q.proxy(this.oninput,this));};
b.prototype._detachEventHandler=function(){var $=this.$();if(this.proChHandlerId){$.unbind('propertychange',this.oninput);this.proChHandlerId=null;}};
b.prototype.onfocusin=function(e){T.prototype.onfocusin.apply(this,arguments);this.bFocus=true;e.preventDefault();};
b.prototype.onsapfocusleave=function(e){T.prototype.onsapfocusleave.apply(this,arguments);var f=this.getFocusDomRef();if(f&&D.browser.firefox){if(f.selectionStart!=f.selectionEnd){q(f).selectText(f.selectionStart,f.selectionStart);}}this.bFocus=false;e.preventDefault();e.stopPropagation();};
b.prototype.applyFocusInfo=function(f){T.prototype.applyFocusInfo.apply(this,arguments);return this;};
b.prototype.onkeypress=function(e){T.prototype.onkeypress.apply(this,arguments);if(!this.getEditable()||!this.getEnabled()||this.getMaxLength()<=0){return;}var k=e.which||e.keyCode;var d=this.getDomRef();if(document.selection){var s=document.selection.createRange();if(s.text.length>0){return;}}else{if(d.selectionStart!=d.selectionEnd){return;}}if(d.value.length>=this.getMaxLength()&&(k>K.DELETE||k==K.ENTER||k==K.SPACE)&&!e.ctrlKey){e.preventDefault();e.stopPropagation();}};
b.prototype.onkeyup=function(e){var d=this.getDomRef();this.setProperty('cursorPos',q(d).cursorPos(),true);T.prototype.onkeyup.apply(this,arguments);};
b.prototype.onsapenter=function(e){e.stopPropagation();};
b.prototype.onsapnext=function(e){if(q(this.getFocusDomRef()).data("sap.InNavArea")&&e.keyCode!=K.END){e.preventDefault();return;}this._checkCursorPosForNav(e,true);};
b.prototype.onsapprevious=function(e){if(q(this.getFocusDomRef()).data("sap.InNavArea")&&e.keyCode!=K.HOME){e.preventDefault();return;}this._checkCursorPosForNav(e,false);};
b.prototype.onsapnextmodifiers=b.prototype.onsapnext;b.prototype.onsappreviousmodifiers=b.prototype.onsapprevious;b.prototype.onsapend=b.prototype.onsapnext;b.prototype.onsaphome=b.prototype.onsapprevious;
b.prototype.onmouseup=function(e){var d=this.getDomRef();this.setProperty('cursorPos',q(d).cursorPos(),true);};
b.prototype.onpaste=function(e){if(!this.getEditable()||!this.getEnabled()||this.getMaxLength()<=0){return;}var d=this.getDomRef();if(d.value.length>=this.getMaxLength()&&d.selectionStart==d.selectionEnd){e.preventDefault();e.stopPropagation();}};
b.prototype.oninput=function(e){if(e.originalEvent&&e.originalEvent.propertyName&&e.originalEvent.propertyName.toLowerCase()!="value"){return;}if(this.getEditable()&&this.getEnabled()&&this.getMaxLength()>0){var d=this.getDomRef();if(d.value.length>this.getMaxLength()){d.value=d.value.substring(0,this.getMaxLength());}}T.prototype.oninput.apply(this,arguments);var o=this.getDomRef();this.setProperty('cursorPos',q(o).cursorPos(),true);};
b.prototype.setMaxLength=function(m){this.setProperty('maxLength',m,true);var d=this.getDomRef();if(d&&d.value.length>m&&m>0){d.value=d.value.substring(0,m);}var v=this.getValue();if(v.length>m&&m>0){this.setProperty('value',v.substring(0,m));}return this;};
b.prototype.setCursorPos=function(c){this.setProperty('cursorPos',c,true);if(this.bFocus){q(this.getDomRef()).cursorPos(c);}return this;};
return b;});
sap.ui.predefine('sap/ui/commons/TextAreaRenderer',['./TextFieldRenderer','sap/ui/core/Renderer','sap/ui/core/library','sap/ui/Device'],function(T,R,c,D){"use strict";var V=c.ValueState;var W=c.Wrapping;var a=R.extend(T);
a.getInnerTagName=function(){return('textarea');};
a.renderInnerAttributes=function(r,t){r.addClass("sapUiTxtA");r.addStyle('overflow','auto');if(t.getWidth()&&t.getWidth()!=''){}else{if(t.getCols()&&t.getCols()!=''){r.writeAttribute('cols',t.getCols());}}if(t.getHeight()&&t.getHeight()!=''){r.addStyle('height',t.getHeight());r.addStyle('margin-top','0');r.addStyle('margin-bottom','0');}else{if(t.getRows()&&t.getRows()!=''){r.writeAttribute('rows',t.getRows());}}switch(t.getWrapping()){case(W.Soft):r.writeAttribute('wrap','soft');break;case(W.Hard):r.writeAttribute('wrap','hard');break;case(W.Off):r.writeAttribute('wrap','off');break;}};
a.renderARIAInfo=function(r,t){r.writeAccessibilityState(t,{role:t.getAccessibleRole().toLowerCase()||'textbox',labelledby:t.getLabeledBy()?(t.getLabeledBy()+" "+t.getAriaDescribedBy().join(" ")):undefined,required:t.getRequired(),readonly:!t.getEditable(),multiline:true,autocomplete:"none",invalid:t.getValueState()==V.Error});};
a.renderInnerContent=function(r,t){var v=t.getValue();var p=t.getPlaceholder();if(v.length>t.getMaxLength()&&t.getMaxLength()>0){v=v.substring(0,t.getMaxLength());}if(!D.support.input.placeholder&&p&&!v){r.writeEscaped(p);}else{r.writeEscaped(v);}};
return a;},true);
sap.ui.predefine('sap/ui/commons/TextField',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','sap/ui/core/ValueStateSupport','./TextFieldRenderer','sap/ui/core/library','sap/ui/Device','sap/ui/events/KeyCodes','sap/ui/dom/jquery/cursorPos','sap/ui/dom/jquery/selectText'],function(q,l,C,V,T,c,D,K){"use strict";var A=c.AccessibleRole;var a=c.Design;var I=c.ImeMode;var b=c.TextAlign;var d=c.ValueState;var e=c.TextDirection;
var f=C.extend("sap.ui.commons.TextField",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.IFormContent"],library:"sap.ui.commons",properties:{value:{type:"string",group:"Data",defaultValue:'',bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:e.Inherit},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},required:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxLength:{type:"int",group:"Behavior",defaultValue:0},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:d.None},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:b.Begin},imeMode:{type:"sap.ui.core.ImeMode",group:"Behavior",defaultValue:I.Auto},design:{type:"sap.ui.core.Design",group:"Appearance",defaultValue:a.Standard},helpId:{type:"string",group:"Behavior",defaultValue:''},accessibleRole:{type:"sap.ui.core.AccessibleRole",group:"Accessibility",defaultValue:A.Textbox},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Appearance",defaultValue:null}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{newValue:{type:"string"}}},liveChange:{parameters:{liveValue:{type:"string"}}}}}});
f.prototype.init=function(){};
f.prototype.onAfterRendering=function(){if(D.browser.msie){var $=q(this.getInputDomRef());this._sRenderedValue=$.val();}};
f.prototype.onfocusin=function(E){if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onfocus){this.getRenderer().onfocus(this);}};
f.prototype.onsapfocusleave=function(E){this._doOnEscape(E);this._checkChange(E);if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onblur){this.getRenderer().onblur(this);}var F=q(this.getFocusDomRef());if(F.data("sap.InNavArea")===false){F.data("sap.InNavArea",true);}};
f.prototype.onsapenter=function(E){this._checkChange(E);};
f.prototype._checkChange=function(E){var i=this.getInputDomRef(),n=i&&i.value,o=this.getValue();if(this.getEditable()&&this.getEnabled()&&(o!=n)){this.setProperty("value",n,true);this.fireChange({newValue:n});}};
f.prototype.onselectstart=function(E){if(!this.getEnabled()){E.preventDefault();E.stopPropagation();}};
f.prototype._checkCursorPosForNav=function(E,F){var r=sap.ui.getCore().getConfiguration().getRTL();var B=F?r:!r;var $=q(this.getInputDomRef());var p=$.cursorPos();var L=$.val().length;if(r){p=L-p;}if((!B&&p!=L)||(B&&p!=0)){E.stopPropagation();}};
f.prototype.onsapnext=function(E){if(E.keyCode!=K.ARROW_DOWN){if(q(this.getFocusDomRef()).data("sap.InNavArea")&&E.keyCode!=K.END){E.preventDefault();return;}this._checkCursorPosForNav(E,true);}};
f.prototype.onsapprevious=function(E){if(E.keyCode!=K.ARROW_UP){if(q(this.getFocusDomRef()).data("sap.InNavArea")&&E.keyCode!=K.HOME){E.preventDefault();return;}this._checkCursorPosForNav(E,false);}};
f.prototype.onsapnextmodifiers=f.prototype.onsapnext;f.prototype.onsappreviousmodifiers=f.prototype.onsapprevious;f.prototype.onsapend=f.prototype.onsapnext;f.prototype.onsaphome=f.prototype.onsapprevious;
f.prototype.onsapexpand=function(E){var i=q(this.getFocusDomRef()).data("sap.InNavArea");if(i||i===false){E.stopPropagation();return;}};
f.prototype.onsapcollapse=f.prototype.onsapexpand;
f.prototype.onsapescape=function(E){var v=this.getProperty("value");this._bEsc=true;this._sValue=v;var i=this.getInputDomRef();if(i&&i.value!==v&&!this._propagateEsc){E.stopPropagation();}if(!D.browser.firefox){this._doOnEscape(E);}};
f.prototype.onkeydown=function(E){if(E.which==K.Z&&E.ctrlKey&&!E.altKey){E.preventDefault();}};
f.prototype.onkeypress=function(E){this._doOnEscape(E);var k=E.which;if(k>0&&k!==K.ESCAPE){var F=q(this.getFocusDomRef());if(F.data("sap.InNavArea")){F.data("sap.InNavArea",false);}}};
f.prototype._doOnEscape=function(E){if(this._bEsc){var i=this.getInputDomRef();if(i){if(i.value!==this._sValue){q(i).val(this._sValue);}var F=q(this.getFocusDomRef());if(F.data("sap.InNavArea")===false){F.data("sap.InNavArea",true);}}this._fireLiveChange(E);this._bEsc=undefined;this._sValue=undefined;}};
f.prototype.onkeyup=function(E){if(E.keyCode==K.F2){var F=q(this.getFocusDomRef());if(F.data("sap.InNavArea")){F.data("sap.InNavArea",false);}else if(F.data("sap.InNavArea")===false){F.data("sap.InNavArea",true);}}else if((D.browser.msie&&D.browser.version<10)&&(E.which===K.DELETE||E.which===K.BACKSPACE)){this._fireLiveChange(E);}};
f.prototype.oninput=function(E){if(!this._realOninput(E)){return;}this._fireLiveChange(E);};
if(D.browser.msie){f.prototype.onpaste=function(E){var g,p,m;g=E.clipboardData||window.clipboardData;p=g.getData('Text');if(p){m=p.replace(/(?:\r\n|\r|\n)/g,' ').replace(/\s+$/,"");g.setData("Text",m);}};}
f.prototype._realOninput=function(E){if(D.browser.msie){var $=q(this.getInputDomRef());var r=this._sRenderedValue;this._sRenderedValue=undefined;if(r==$.val()){return false;}}return true;};
f.prototype._fireLiveChange=function(E){if(this.getEnabled()&&this.getEditable()){var L=q(this.getInputDomRef()).val();this.fireLiveChange({liveValue:L});}};
f.prototype.setValueState=function(v){var o=this.getValueState();this.setProperty("valueState",v,true);v=this.getValueState();if(o==v){return this;}if(!this.getDomRef()){return this;}if(this.getRenderer().setValueState){this.getRenderer().setValueState(this,o,v);}if(this.delayedCallId){clearTimeout(this.delayedCallId);this.delayedCallId=null;}if(d.Success==v){this.delayedCallId=setTimeout(function(){this.removeValidVisualization();}.bind(this),3000);}return this;};
f.prototype.removeValidVisualization=function(){if(this.getRenderer().removeValidVisualization){this.getRenderer().removeValidVisualization(this);}};
f.prototype.setEditable=function(E){var o=this.getEditable();this.setProperty('editable',E,true);E=this.getEditable();if(o!=E){if(this.getDomRef()&&this.getRenderer().setEditable){this.getRenderer().setEditable(this,E);}}return this;};
f.prototype.setEnabled=function(E){var o=this.getEnabled();this.setProperty('enabled',E,true);E=this.getEnabled();if(o!=E){if(this.getDomRef()&&this.getRenderer().setEnabled){this.getRenderer().setEnabled(this,E);}}return this;};
f.prototype.setRequired=function(r){var o=this.getRequired();this.setProperty('required',r,true);r=this.getRequired();if(o!=r){if(this.getDomRef()){if(this.getRenderer().setRequired){this.getRenderer().setRequired(this,r);}}this.fireEvent("requiredChanged",{required:r});}return this;};
f.prototype.setDesign=function(s){var o=this.getDesign();this.setProperty('design',s,true);s=this.getDesign();if(o!=s){if(this.getDomRef()){if(this.getRenderer().setDesign){this.getRenderer().setDesign(this,s);}}}return this;};
f.prototype.setValue=function(v){var n=v;if(n&&n.length>this.getMaxLength()&&this.getMaxLength()>0){n=n.substring(0,this.getMaxLength());}this.setProperty("value",n,true);n=this.getValue();var i=this.getInputDomRef();if(i&&i.value!==n){if(!D.support.input.placeholder){if(n){this.$().removeClass('sapUiTfPlace');i.value=n;}else if(document.activeElement!==i){this.$().addClass('sapUiTfPlace');var p=this.getPlaceholder();if(this.getRenderer().convertPlaceholder){p=this.getRenderer().convertPlaceholder(this);}i.value=p;}else{i.value="";}}else{i.value=n;}this._sRenderedValue=n;}return this;};
f.prototype.setTooltip=function(t){this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);var i=this.getInputDomRef();if(i){var s=V.enrichTooltip(this,this.getTooltip_AsString());q(i).attr("title",s||"");if(this._getRenderOuter()){q(this.getDomRef()).attr("title",s||"");}}return this;};
f.prototype.getInputDomRef=function(){if(!this._getRenderOuter()){return this.getDomRef()||null;}else{return this.getDomRef("input")||null;}};
f.prototype.applyFocusInfo=function(F){this.focus();this._restoreUnsavedUserInput(F.userinput);return this;};
f.prototype.getFocusInfo=function(){return{id:this.getId(),userinput:this._getUnsavedUserInputInfo()};};
f.prototype.getLiveValue=function(){var i=this.getInputDomRef();if(i){return q(i).val();}else{return this.getValue();}};
f.prototype.ondrop=function(E){if(D.browser.firefox){this.focus();}};
f.prototype._getRenderOuter=function(){if(this.bRenderOuter==undefined){var r=this.getRenderer();if(r.renderOuterAttributes||r.renderOuterContentBefore||r.renderOuterContent){this.bRenderOuter=true;}else{this.bRenderOuter=false;}}return this.bRenderOuter;};
f.prototype.getIdForLabel=function(){if(!this._getRenderOuter()){return this.getId();}else{return this.getId()+'-input';}};
f.prototype.getFocusDomRef=function(){return this.getInputDomRef();};
f.prototype._getUnsavedUserInputInfo=function(){var $=this.$();if($.length&&$.hasClass("sapUiTfFoc")&&!$.hasClass("sapUiTfPlace")&&this.getEnabled()&&this.getEditable()){var g=q(this.getInputDomRef());var v=g.val();var s=this.getValue();var S=0;var i=0;if(typeof(g.get(0).selectionStart)==="number"){S=g.get(0).selectionStart;i=g.get(0).selectionEnd;}return{userinput:v,value:s,cursorPos:g.cursorPos(),selStart:S,selEnd:i};}return null;};
f.prototype._restoreUnsavedUserInput=function(u){if(u&&this.getEnabled()&&this.getEditable()&&this.getValue()==u.value){var v=u.userinput;if(v&&v.length>this.getMaxLength()&&this.getMaxLength()>0){v=v.substring(0,this.getMaxLength());}var $=q(this.getInputDomRef());if(v!=u.value){$.val(v);}$.cursorPos(u.cursorPos);if(u.selStart!=u.selEnd){$.selectText(u.selStart,u.selEnd);}}};
f.prototype.getAccessibilityInfo=function(){return{role:"textbox",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_INPUT"),description:this.getValue()||"",focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()};};
return f;});
sap.ui.predefine('sap/ui/commons/TextFieldRenderer',['sap/ui/core/Renderer','sap/ui/core/ValueStateSupport','sap/ui/core/library','sap/ui/Device'],function(R,V,c,D){"use strict";var a=c.ValueState;var b=c.Design;var I=c.ImeMode;var T={};
T.render=function(r,t){var w=t.getWidth();var d=V.enrichTooltip(t,t.getTooltip_AsString());var e=t._getRenderOuter();if(e){r.write("<div");r.writeControlData(t);r.addClass("sapUiTfBack");this.renderStyles(r,t);if(d){r.writeAttributeEscaped('title',d);}var s;if(w&&w!=''){s='width: '+w+';';}if(this.renderOuterAttributes){this.renderOuterAttributes(r,t);}if(s){r.writeAttribute('style',s);}r.writeStyles();r.writeClasses();r.write(">");if(this.renderOuterContentBefore){this.renderOuterContentBefore(r,t);}}if(this.getInnerTagName){r.write('<'+this.getInnerTagName());}else{r.write("<input");}r.addClass("sapUiTf");if(!e){r.writeControlData(t);r.addClass("sapUiTfBack");this.renderStyles(r,t);if(w&&w!=''){r.addStyle("width",w);}}else{r.writeAttribute('id',t.getId()+'-input');r.addClass("sapUiTfInner");r.addStyle("width",'100%');}if(d){r.writeAttributeEscaped('title',d);}if(t.getName()){r.writeAttributeEscaped('name',t.getName());}if(!t.getEditable()&&t.getEnabled()){r.writeAttribute('readonly','readonly');}if(this.renderTextFieldEnabled){this.renderTextFieldEnabled(r,t);}else if(!t.getEnabled()){r.writeAttribute('disabled','disabled');r.writeAttribute('tabindex','-1');}else if(!t.getEditable()){r.writeAttribute('tabindex','0');}else{r.writeAttribute('tabindex','0');}var f=t.getTextDirection();if(f){r.addStyle("direction",f.toLowerCase());}var g=T.getTextAlign(t.getTextAlign(),f);if(g){r.addStyle("text-align",g);}switch(t.getImeMode()){case I.Inactive:r.addStyle('ime-mode','inactive');break;case I.Active:r.addStyle('ime-mode','active');break;case I.Disabled:r.addStyle('ime-mode','disabled');break;}if(t.getDesign()==b.Monospace){r.addClass('sapUiTfMono');}if(t.getMaxLength()){r.writeAttribute("maxlength",t.getMaxLength());}if(this.renderInnerAttributes){this.renderInnerAttributes(r,t);}if(this.renderARIAInfo){this.renderARIAInfo(r,t);}var p=t.getPlaceholder();if(p){if(this.convertPlaceholder){p=this.convertPlaceholder(t);}if(D.support.input.placeholder){r.writeAttributeEscaped('placeholder',p);}}r.writeStyles();r.writeClasses();if(this.getInnerTagName){r.write(">");}else{r.write(" value=\"");if(!D.support.input.placeholder&&p&&!t.getValue()){r.writeEscaped(p);}else{r.writeEscaped(t.getValue());}r.write("\"");r.write("/>");}if(this.getInnerTagName){if(this.renderInnerContent){this.renderInnerContent(r,t);}r.write('</'+this.getInnerTagName()+'>');}if(e){if(this.renderOuterContent){this.renderOuterContent(r,t);}r.write("</div>");}};
T.renderStyles=function(r,t){r.addClass('sapUiTfBrd');if(t.getEnabled()){if(!t.getEditable()){r.addClass("sapUiTfRo");}else{r.addClass("sapUiTfStd");}}else{r.addClass("sapUiTfDsbl");}switch(t.getValueState()){case(a.Error):r.addClass('sapUiTfErr');break;case(a.Success):r.addClass('sapUiTfSucc');break;case(a.Warning):r.addClass('sapUiTfWarn');break;}if(t.getRequired()){r.addClass('sapUiTfReq');}if(t.getPlaceholder()&&!D.support.input.placeholder){r.addClass('sapUiTfPlace');}};
T.onfocus=function(t){var o=t.$();var d;o.addClass("sapUiTfFoc");if(!D.support.input.placeholder&&!t.getValue()&&t.getPlaceholder()){if(t._getRenderOuter()){d=t.$("input");}else{d=o;}o.removeClass("sapUiTfPlace");d.val("");}};
T.onblur=function(t){var o=t.$();var d;o.removeClass("sapUiTfFoc");var p=t.getPlaceholder();if(!D.support.input.placeholder){if(t._getRenderOuter()){d=t.$("input");}else{d=o;}if(!d.val()&&p){o.addClass("sapUiTfPlace");if(this.convertPlaceholder){p=this.convertPlaceholder(t);}d.val(p);}}};
T.setValueState=function(t,o,n){var d=t.$();var e;var r=t._getRenderOuter();if(r){e=t.$("input");}else{e=d;}switch(o){case(a.Error):d.removeClass('sapUiTfErr');e.removeAttr('aria-invalid');break;case(a.Success):d.removeClass('sapUiTfSucc');break;case(a.Warning):d.removeClass('sapUiTfWarn');break;}switch(n){case(a.Error):d.addClass('sapUiTfErr');e.attr('aria-invalid',true);break;case(a.Success):d.addClass('sapUiTfSucc');break;case(a.Warning):d.addClass('sapUiTfWarn');break;}var f=V.enrichTooltip(t,t.getTooltip_AsString());if(f){d.attr('title',f);if(r){t.$("input").attr('title',f);}}else{d.removeAttr('title');if(r){t.$("input").removeAttr('title');}}};
T.setEditable=function(t,e){if(!t.getEnabled()){return;}var o=t.$();var d;if(t._getRenderOuter()){d=t.$("input");}else{d=o;}if(e){o.removeClass('sapUiTfRo').addClass('sapUiTfStd');d.removeAttr('readonly');d.removeAttr('aria-readonly');}else{o.removeClass('sapUiTfStd').addClass('sapUiTfRo');d.attr('readonly','readonly');d.attr('aria-readonly',true);}};
T.setEnabled=function(t,e){var o=t.$();var d;if(t._getRenderOuter()){d=t.$("input");}else{d=o;}if(e){if(t.getEditable()){o.removeClass('sapUiTfDsbl').addClass('sapUiTfStd').removeAttr('aria-disabled');d.removeAttr('disabled').removeAttr('aria-disabled').attr('tabindex','0');}else{o.removeClass('sapUiTfDsbl').addClass('sapUiTfRo').removeAttr('aria-disabled');d.removeAttr('disabled').removeAttr('aria-disabled').attr('tabindex','0').attr('readonly','readonly').attr('aria-readonly',true);}}else{if(t.getEditable()){o.removeClass('sapUiTfStd').addClass('sapUiTfDsbl').attr('aria-disabled','true');d.attr('disabled','disabled').attr('aria-disabled','true').attr('tabindex','-1');}else{o.removeClass('sapUiTfRo').addClass('sapUiTfDsbl').attr('aria-disabled','true');d.removeAttr('readonly').removeAttr('aria-readonly').attr('disabled','disabled').attr('aria-disabled','true').attr('tabindex','-1');}}};
T.removeValidVisualization=function(t){var o=t.$();if(o){o.removeClass("sapUiTfSucc");}else{setTimeout(function(){T.removeValidVisualization(t);},1000);}};
T.setDesign=function(t,d){t.$().toggleClass('sapUiTfMono',(d==b.Monospace));};
T.setRequired=function(t,r){var o;if(t._getRenderOuter()){o=t.$("input");}else{o=t.$();}t.$().toggleClass('sapUiTfReq',r);if(r){o.attr("aria-required",true);}else{o.removeAttr("aria-required");}};
T.renderARIAInfo=function(r,t){var p={role:t.getAccessibleRole().toLowerCase(),multiline:false,autocomplete:'none'};if(t.getValueState()==a.Error){p["invalid"]=true;}r.writeAccessibilityState(t,p);};
T.getTextAlign=R.getTextAlign;return T;},true);
sap.ui.predefine('sap/ui/commons/TextView',['./library','sap/ui/core/Control','./TextViewRenderer','sap/ui/core/library','sap/base/security/encodeXML'],function(l,C,T,c,e){"use strict";var a=c.TextAlign;var b=l.TextViewColor;var d=l.TextViewDesign;var f=c.TextDirection;
var g=C.extend("sap.ui.commons.TextView",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.IFormContent"],library:"sap.ui.commons",properties:{text:{type:"string",defaultValue:'',bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:f.Inherit},enabled:{type:"boolean",group:"Behavior",defaultValue:true},helpId:{type:"string",group:"Behavior",defaultValue:''},accessibleRole:{type:"sap.ui.core.AccessibleRole",group:"Accessibility"},design:{type:"sap.ui.commons.TextViewDesign",group:"Data",defaultValue:d.Standard},wrapping:{type:"boolean",group:"Appearance",defaultValue:true},semanticColor:{type:"sap.ui.commons.TextViewColor",group:"Appearance",defaultValue:b.Default},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:a.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
g.prototype.setText=function(t){this.setProperty("text",t,true);var D=this.getDomRef();if(D){t=this.getText();D.innerHTML=e(t).replace(/&#xa;/g,"<br>");if(!this.getTooltip_AsString()){D.title=t;}}return this;};
g.prototype.getAccessibilityInfo=function(){return{description:this.getText()};};
return g;});
sap.ui.predefine('sap/ui/commons/TextViewRenderer',['sap/ui/core/Renderer','sap/ui/commons/library'],function(R,l){"use strict";var T=l.TextViewDesign;var a=l.TextViewColor;var b={};
b.render=function(r,t){this.applyEnabledStyles(r,t);this.applyTextDesign(r,t);if(!t.getWrapping()){r.addClass("sapUiTvWrap");}if(t.getWidth()){r.addStyle("width",t.getWidth());}r.write("<span");r.writeControlData(t);r.addClass("sapUiTv");if(t.getTooltip_AsString()){r.writeAttributeEscaped("title",t.getTooltip_AsString());}else if(t.getText()){r.writeAttributeEscaped("title",t.getText());}var s=t.getTextDirection();if(s){r.addStyle("direction",s.toLowerCase());}var A=b.getTextAlign(t.getTextAlign(),s);if(A){A=A.charAt(0).toUpperCase()+A.substring(1);r.addClass("sapUiTvAlign"+A);}r.writeAttribute('tabindex','-1');r.writeAccessibilityState(t,{role:t.getAccessibleRole()?t.getAccessibleRole().toLowerCase():undefined,invalid:t.getSemanticColor()==a.Negative,disabled:!t.getEnabled()});r.writeClasses();r.writeStyles();r.write(">");r.writeEscaped(t.getText(),true);r.write("</span>");};
b.applyTextDesign=function(r,t){var d=t.getDesign();if(d==T.Standard){return;}switch(d){case(T.Bold):r.addClass("sapUiTvEmph");break;case(T.H1):r.addClass("sapUiTvH1");break;case(T.H2):r.addClass("sapUiTvH2");break;case(T.H3):r.addClass("sapUiTvH3");break;case(T.H4):r.addClass("sapUiTvH4");break;case(T.H5):r.addClass("sapUiTvH5");break;case(T.H6):r.addClass("sapUiTvH6");break;case(T.Italic):r.addClass("sapUiTvItalic");break;case(T.Small):r.addClass("sapUiTvSmall");break;case(T.Monospace):r.addClass("sapUiTvMono");break;case(T.Underline):r.addClass("sapUiTvULine");break;default:break;}};
b.applyEnabledStyles=function(r,t){if(!t.getEnabled()){r.addClass("sapUiTvDsbl");t.allowTextSelection(false);}else{switch(t.getSemanticColor()){case(a.Negative):r.addClass('sapUiTvErr');break;case(a.Positive):r.addClass('sapUiTvSucc');break;case(a.Critical):r.addClass('sapUiTvWarn');break;}}};
b.getTextAlign=R.getTextAlign;return b;},true);
sap.ui.predefine('sap/ui/commons/Title',['./library','sap/ui/core/Title'],function(l,C){"use strict";
var T=C.extend("sap.ui.commons.Title",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return T;});
sap.ui.predefine('sap/ui/commons/ToggleButton',['./Button','./ToggleButtonRenderer'],function(B,T){"use strict";
var a=B.extend("sap.ui.commons.ToggleButton",{metadata:{library:"sap.ui.commons",properties:{pressed:{type:"boolean",group:"Data",defaultValue:false}}}});
a.prototype.onclick=function(e){if(this.getEnabled()){this.setPressed(!this.getPressed());if(this.$().is(":visible")){this.firePress({pressed:this.getPressed()});}}e.preventDefault();e.stopPropagation();};
a.prototype.setPressed=function(p){var r;if(p!==this.getProperty("pressed")){r=this.getRenderer();this.setProperty("pressed",p,true);if(!this.getPressed()){r.ondeactivePressed(this);}else{r.onactivePressed(this);}r.updateImage(this);}return this;};
a.prototype.onAfterRendering=function(){var r=this.getRenderer();if(!this.getPressed()){r.ondeactivePressed(this);}else{r.onactivePressed(this);}};
a.prototype.getAccessibilityInfo=function(){var i=B.prototype.getAccessibilityInfo.apply(this,arguments);if(this.getPressed()){i.description=((i.description||"")+" "+sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_STATE_PRESSED")).trim();}return i;};
return a;});
sap.ui.predefine('sap/ui/commons/ToggleButtonRenderer',['./ButtonRenderer','sap/ui/core/Renderer'],function(B,R){"use strict";var T=R.extend(B);
T.renderButtonAttributes=function(r,t){r.addClass("sapUiToggleBtn");if(t.getPressed()){r.addClass("sapUiToggleBtnPressed");r.writeAttribute('aria-pressed',true);}else{r.writeAttribute('aria-pressed',false);}};
T.onactivePressed=function(t){t.$().addClass("sapUiToggleBtnPressed").attr('aria-pressed',true);};
T.ondeactivePressed=function(t){t.$().removeClass("sapUiToggleBtnPressed").attr('aria-pressed',false);};
T.updateImage=function(t){t.$("img").attr('src',this._getIconForState(t,"base"));};
T._getIconForState=function(b,s){var i;switch(s){case"mouseout":case"focus":case"blur":case"base":return b.getPressed()&&b.getIconSelected()?b.getIconSelected():b.getIcon();case"active":i=b.getIconSelected();return i?i:b.getIcon();case"mouseover":case"deactive":i=b.getIconHovered();if(i){return i;}else if(b.getPressed()&&b.getIconSelected()){return b.getIconSelected();}else{return b.getIcon();}}return b.getIcon();};
return T;},true);
sap.ui.predefine('sap/ui/commons/ToolbarRenderer',['sap/ui/thirdparty/jquery','sap/base/Log','sap/base/assert','./library','./ToolbarSeparator'],function(q,L,a,l,T){"use strict";var b=l.ToolbarSeparatorDesign;var c={};
c.render=function(r,t){var d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");a(t&&t.isA("sap.ui.commons.Toolbar"),"ToolbarRenderer.render: oToolbar must be a toolbar");r.write("<div role='toolbar' tabindex='0'");r.writeControlData(t);if(t.getWidth()){r.addStyle("width",t.getWidth());}var s=t.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}r.addClass("sapUiTb");r.addClass("sapUiTbDesign"+t.getDesign());if(t.getStandalone()){r.addClass("sapUiTbStandalone");}r.writeStyles();r.writeClasses();r.write(">");var R=t.getRightItems();var e=R.length;var h=e>0;var I="<div class='sapUiTbInner' id='"+t.getId()+"-inner"+"'>";if(h){r.write("<div class='sapUiTbCont sapUiTbContLeft'>"+I);}else{r.write("<div class='sapUiTbCont'>"+I);}var f=t.getItems();var g=f.length;for(var i=0;i<g;i++){var o=f[i];if(o){a(o.getMetadata().isInstanceOf("sap.ui.commons.ToolbarItem"),"ToolbarRenderer.render: oToolbarItem must be a ToolbarItem");if(o instanceof T){c.renderSeparator(r,o);}else{r.renderControl(o);}}}r.write("<div id='");r.write(t.getId());r.write("-mn' class='sapUiTbOB' role='button' aria-haspopup='true' title='"+d.getText("TOOLBAR_OVERFLOW")+"' tabindex='-1'></div></div></div>");if(h){r.write("<div class='sapUiTbInnerRight' >");for(var i=0;i<e;i++){var o=R[i];if(o){a(o.getMetadata().isInstanceOf("sap.ui.commons.ToolbarItem"),"ToolbarRenderer.render: oToolbarItem must be a ToolbarItem");if(o instanceof T){c.renderSeparator(r,o);}else{r.renderControl(o);}}}r.write("</div>");}r.write("</div>");};
c.renderSeparator=function(r,t){if(t.getDisplayVisualSeparator()){r.write("<span ");r.writeElementData(t);if(t.getDesign()===b.FullHeight){r.write(" class='sapUiTbSeparator sapUiTbSepFullHeight' role='separator'></span>");}else{r.write(" class='sapUiTbSeparator' role='separator'></span>");}}else{r.write("<span ");r.writeElementData(t);r.write(" class='sapUiTbSpacer' role='separator'></span>");}};
c.fillOverflowPopup=function(t){var p=t.getDomRef("pu");if(!p){p=c.initOverflowPopup(t).firstChild;}var $=q(p.parentNode),v=t.getVisibleItemInfo(true).count,o=t.getDomRef().firstChild.firstChild,P=0,C=o.firstChild,O=t.getId()+"-mn",i=$.width(),B=0;while(C){var n=C.nextSibling;if(P>=v){if(C.id===O){break;}B=B<q(C).outerWidth(true)?q(C).outerWidth(true):B;p.appendChild(C);}C=n;P++;}if(B>i){var d=12;$.width(B+d);}};
c.initOverflowPopup=function(t){var s=sap.ui.getCore().getStaticAreaRef();var p=document.createElement("div");p.className="sapUiTbDD sapUiTbDesignFlat";p.innerHTML="<div id='"+t.getId()+"-pu' data-sap-ui="+t.getId()+" tabindex='0' role='menu'></div>";s.appendChild(p);return p;};
c.emptyOverflowPopup=function(t,m){var p=t.getDomRef("pu"),d=t.getDomRef(),C=null,M='',A=[];if(m===undefined){m=true;}if(p){if(m&&d){C=d.firstChild.firstChild;M='insertBefore';A=[t.getDomRef("mn")];}else if(!m){C=p;M='removeChild';}else{L.error("The renderer 'sap.ui.commons.ToolbarRenderer' cannot empty the toolbar overflow popup.");return;}while(p.hasChildNodes()){var e=[p.firstChild].concat(A);C[M].apply(C,e);}if(d&&t.sOriginalStylePropertyWidth){q(d).width(t.sOriginalStylePropertyWidth);t.sOriginalStylePropertyWidth=null;}}};
c.getPopupArea=function(t){return t.getDomRef("pu");};
c.setActive=function(t){t.$("mn").addClass("sapUiTbOBAct");};
c.unsetActive=function(t){t.$("mn").removeClass("sapUiTbOBAct");};
return c;},true);
sap.ui.predefine('sap/ui/commons/ToolbarSeparator',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var T=E.extend("sap.ui.commons.ToolbarSeparator",{metadata:{interfaces:["sap.ui.commons.ToolbarItem"],library:"sap.ui.commons",properties:{displayVisualSeparator:{type:"boolean",group:"Appearance",defaultValue:true},design:{type:"sap.ui.commons.ToolbarSeparatorDesign",group:"Misc",defaultValue:null}}}});
T.prototype.getFocusDomRef=function(){return undefined;};
return T;});
sap.ui.predefine('sap/ui/commons/Tree',['sap/ui/thirdparty/jquery','sap/base/Log','./library','sap/ui/core/Control','./TreeRenderer','./Button'],function(q,L,l,C,T,B){"use strict";var a=l.TreeSelectionMode;
var b=C.extend("sap.ui.commons.Tree",{metadata:{library:"sap.ui.commons",properties:{title:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'},showHeader:{type:"boolean",group:"Misc",defaultValue:true},showHeaderIcons:{type:"boolean",group:"Misc",defaultValue:true},showHorizontalScrollbar:{type:"boolean",group:"Misc",defaultValue:false},minWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},selectionMode:{type:"sap.ui.commons.TreeSelectionMode",group:"Behavior",defaultValue:a.Legacy}},defaultAggregation:"nodes",aggregations:{nodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"node",bindable:"bindable"}},events:{select:{allowPreventDefault:true,parameters:{node:{type:"sap.ui.commons.TreeNode"},nodeContext:{type:"object"}}},selectionChange:{parameters:{nodes:{type:"sap.ui.commons.TreeNode[]"},nodeContexts:{type:"object[]"}}}}}});
b.prototype.resizeListenerId;
b.prototype.init=function(){this.bAllCollapsed=false;this.allowTextSelection(false);this.iOldScrollTop=null;this.mSelectedNodes={};this.mSelectedContexts={};this.aLeadSelection=null;var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.oCollapseAllButton=new B(this.getId()+"-CollapseAll",{icon:this.getIconPrefix()+"CollapseAll.png",tooltip:R.getText("TREE_COLLAPSE_ALL"),lite:true});this.oExpandAllButton=new B(this.getId()+"-ExpandAll",{icon:this.getIconPrefix()+"ExpandAll.png",tooltip:R.getText("TREE_EXPAND_ALL"),lite:true});this.oCollapseAllButton.attachPress(this.onCollapseAll,this);this.oExpandAllButton.attachPress(this.onExpandAll,this);this.oCollapseAllButton.addStyleClass("sapUiTreeCol");this.oExpandAllButton.addStyleClass("sapUiTreeExp");};
b.prototype.exit=function(){if(this.oCollapseAllButton){this.oCollapseAllButton.destroy();this.oCollapseAllButton=null;}if(this.oExpandAllButton){this.oExpandAllButton.destroy();this.oExpandAllButton=null;}};
b.SelectionType={Select:"Select",Toggle:"Toggle",Range:"Range"};
b.prototype.onThemeChanged=function(){if(this.oCollapseAllButton&&this.oExpandAllButton){this.oCollapseAllButton.setIcon(this.getIconPrefix()+"CollapseAll.png");this.oExpandAllButton.setIcon(this.getIconPrefix()+"ExpandAll.png");}};
b.prototype.onExpandAll=function(){this.expandAll();};
b.prototype.onCollapseAll=function(){this.collapseAll();};
b.prototype.expandAll=function(){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].expand(true,true);this._adjustSelectionOnExpanding(n[i]);}};
b.prototype.collapseAll=function(){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].collapse(true,true);this._adjustSelectionOnCollapsing(n[i]);}this._adjustFocus();};
b.prototype.onsapdown=function(e){this.moveFocus(false);e.preventDefault();};
b.prototype.onsapup=function(e){this.moveFocus(true);e.preventDefault();};
b.prototype.onsaphome=function(e){this.placeFocus(this.getFirstSibling(e.target));e.preventDefault();};
b.prototype.onsaphomemodifiers=function(e){this.placeFocus(this.getFirst());e.preventDefault();};
b.prototype.onsapend=function(e){this.placeFocus(this.getLastSibling(e.target));e.preventDefault();};
b.prototype.onsapendmodifiers=function(e){this.placeFocus(this.getLast());e.preventDefault();};
b.prototype.onsapcollapseall=function(e){if(this.bAllCollapsed){this.expandAll();}else{this.collapseAll();}this.bAllCollapsed=!this.bAllCollapsed;};
b.prototype.getIconPrefix=function(){var i="themes/"+sap.ui.getCore().getConfiguration().getTheme()+"/";if(!sap.ui.getCore().getConfiguration().getRTL()){i+="img/tree/";}else{i+="img-RTL/tree/";}return sap.ui.resource("sap.ui.commons",i);};
b.prototype.getFirstSibling=function(d){var D=q(d).siblings(".sapUiTreeNode:visible").first();if(D.length){return D[0];}return null;};
b.prototype.getLastSibling=function(d){var D=q(d).siblings(".sapUiTreeNode:visible").last();if(D.length){return D[0];}return null;};
b.prototype.getFirst=function(){var d=this.$().find(".sapUiTreeNode:visible").first();if(d.length){return d[0];}return null;};
b.prototype.getLast=function(){var d=this.$().find(".sapUiTreeNode:visible").last();if(d.length){return d[0];}return null;};
b.prototype.moveFocus=function(m){var d=q(".sapUiTreeNode:focus");if(d.length){var o=sap.ui.getCore().byId(d[0].id);var D=this.$().find(".sapUiTreeNode:visible");var e=D.index(d[0]);var n=e;if(m){n--;}else{n++;}if(n>=0&&n<D.length){var f=D.eq(n);var N=sap.ui.getCore().byId(f[0].id);o.blur();N.focus();}}};
b.prototype._adjustFocus=function(){var f=this.$().find('.sapUiTreeNode[tabIndex="0"]');if(!f.is(':visible')){var d=this.$().find(".sapUiTreeNode");var e=d.index(f[0]);var D=d.filter(":lt("+e+")");var g=D.filter(":visible");var n=g[g.length-1];if(n){n.setAttribute("tabindex","0");if(q(".sapUiTreeNode:focus").is(":not(:visible)")){n.focus();}}}};
b.prototype.placeFocus=function(d){if(!d){return;}var D=this.$().find(".sapUiTreeNode[tabIndex='0']");if(D.length){D[0].setAttribute("tabindex","-1");}d.setAttribute("tabindex","0");var t=sap.ui.getCore().byId(d.id);t.focus();};
b.prototype._adjustSelectionOnExpanding=function(e){if(!e){return;}var E=[];if(e.getSelectedForNodes().length){E.push(e);}r(e,E,null);var $=e.$();if($&&$.hasClass('sapUiTreeNodeSelectedParent')){$.removeClass('sapUiTreeNodeSelectedParent');}var s=e.$('children').find('.sapUiTreeNodeExpanded.sapUiTreeNodeSelectedParent');s.removeClass('sapUiTreeNodeSelectedParent');};
function r(n,e,f){var I=n.getExpanded(),N=false,d=I&&!!n.getSelectedForNodes().length,F=(f||I)?f:n,i;for(i=0;i<e.length;i++){if(e[i].getSelectedForNodes().indexOf(n.getId())!==-1){N=true;e[i].removeAssociation("selectedForNodes",n,true);}}if(F&&N&&F!==n){if(F.getSelectedForNodes().indexOf(n.getId())===-1){F.addAssociation("selectedForNodes",n,true);}F.$().addClass('sapUiTreeNodeSelectedParent');}if(d){e.push(n);}var g=n._getNodes();for(i=0;i<g.length;i++){r(g[i],e,F);}if(d){e.pop(n);}}
function c(n,R){var N=n._getNodes(),o;for(var i=0;i<N.length;i++){o=N[i];if(o.getIsSelected()){R.addAssociation("selectedForNodes",o,true);}c(o,R);}}
b.prototype._adjustSelectionOnCollapsing=function(o){if(!o){return;}c(o,o);if(o.getSelectedForNodes().length){var $=o.$();if($&&!$.hasClass('sapUiTreeNodeSelectedParent')){$.addClass('sapUiTreeNodeSelectedParent');}}};
b.prototype.isTreeBinding=function(n){return(n=="nodes");};
b.prototype.updateNodes=function(R){var n,N,k,d,i;if(R==="filter"){n=this.getAggregation("nodes");d=n.length;for(i=0;i<d;i++){n[i].destroy();}this.mSelectedNodes={};}this.updateAggregation("nodes");for(k in this.mSelectedContexts){N=this.getNodeByContext(this.mSelectedContexts[k]);if(N){N.setIsSelected(true);}else{this.mSelectedContexts=this._removeItemFromObject(this.mSelectedContexts,k);}}};
b.prototype._removeItemFromObject=function(o,k){var K,R={};for(K in o){if(K!==k){R[K]=o[K];}}return R;};
b.prototype.getNodeContext=function(n){var o=this.getBindingInfo("nodes"),m=o&&o.model;return n.getBindingContext(m);};
b.prototype.getNodeByContext=function(o){var d=this.getBindingInfo("nodes"),m=d&&d.model;return this.findNode(this,function(n){var e=n.getBindingContext(m);return(o&&e&&o.getPath()===e.getPath());});};
b.prototype.findNode=function(n,m){var f,t=this;if(m(n)){return n;}q.each(n._getNodes(),function(i,n){f=t.findNode(n,m);if(f){return false;}});return f;};
b.prototype.setSelectionMode=function(m){m=this.validateProperty("selectionMode",m);if(this.getSelectionMode()!=m){this.setProperty("selectionMode",m);this._delSelection();}return this;};
b.prototype.getSelection=function(){for(var i in this.mSelectedNodes){return this.mSelectedNodes[i];}return null;};
b.prototype.setSelection=function(n,s,t){var d=true;if(!s){d=this.fireSelect({node:n,nodeContext:this.getNodeContext(n)});}if(d){switch(this.getSelectionMode()){case a.Legacy:case a.Single:this._setSelectedNode(n,s);break;case a.Multi:if(t==b.SelectionType.Range){this._setSelectedNodeMapRange(n,s);}else if(t==b.SelectionType.Toggle){this._setSelectedNodeMapToggle(n,s);}else{this._setSelectedNode(n,s);}break;case a.None:break;}}};
b.prototype.onAfterRendering=function(){if(this.iOldScrollTop){this.$("TreeCont").scrollTop(this.iOldScrollTop);}};
b.prototype.invalidate=function(){var t=this;C.prototype.invalidate.apply(this,arguments);if(this.iSelectionUpdateTimer){return;}this.iSelectionUpdateTimer=setTimeout(function(){t.mSelectedNodes={};t.mSelectedContexts=[];t.updateSelection(t,true);t.iSelectionUpdateTimer=null;},0);};
b.prototype._addSelectedNodeContext=function(o){var p;if(o&&o.sPath){p=o.sPath;if(this.getSelectionMode()===a.Multi){if(!(p in this.mSelectedContexts)){this.mSelectedContexts[p]=o;}}else{this.mSelectedContexts={};this.mSelectedContexts[p]=o;}}};
b.prototype.updateSelection=function(n,e){var t=this;q.each(n._getNodes(),function(i,n){if(n.getIsSelected()){switch(t.getSelectionMode()){case a.None:L.warning("Added selected nodes in a tree with disabled selection");n.setIsSelected(false);break;case a.Legacy:if(q.isEmptyObject(t.mSelectedNodes)){t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;case a.Single:if(q.isEmptyObject(t.mSelectedNodes)==false){L.warning("Added multiple selected nodes in single select tree");n.setIsSelected(false);}else{t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;case a.Multi:if(!e){L.warning("Added selected node inside collapsed node in multi select tree");n.setIsSelected(false);}else{t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;}}t.updateSelection(n,e&&n.getExpanded());});};
b.prototype.onBeforeRendering=function(){this.iOldScrollTop=this.$("TreeCont").scrollTop();};
b.prototype._setSelectedNode=function(n,s){var t=this,o=this.getNodeContext(n);q.each(this.mSelectedNodes,function(i,n){t._delMultiSelection(n,s);});n._select(s,true);this.mSelectedNodes[n.getId()]=n;this._addSelectedNodeContext(o);this.oLeadSelection=n;if(!s){this.fireSelectionChange({nodes:[n],nodeContexts:[o]});}};
b.prototype._setSelectedNodeMapToggle=function(n,s){this._setNodeSelection(n,!n.getIsSelected(),s);};
b.prototype._setSelectedNodeMapRange=function(n,s){var S,d=[],e=[],f,E,F,t;if(this.mSelectedNodes[n.getId()]==n){return;}else{if(this._getNodes().length>0){S=this._getSelectableNodes();f=S.indexOf(this.oLeadSelection);E=S.indexOf(n);F=f<E?f:E;t=f<E?E:f;for(var i=F;i<=t;i++){this._setMultiSelection(S[i],s);}}}if(!s){q.map(this.mSelectedNodes,function(n){d.push(n);});q.map(this.mSelectedContexts,function(o){e.push(o);});this.fireSelectionChange({nodes:d,nodeContexts:e});}};
b.prototype._getSelectableNodes=function(n){var s=[];function d(n){q.each(n,function(i,N){if(N.getSelectable()){s.push(N);}if(N.getExpanded()){d(N._getNodes());}});}d(this._getNodes());return s;};
b.prototype._setNodeSelection=function(n,i,s){var S=[],d=[],v;if(this.getSelectionMode()==a.Single){if(i){var o=this.getSelection();this._setSelectedNode(n,s);if(!n.isVisible()){v=this._getVisibleNode(n);this._adjustSelectionOnCollapsing(v);}if(o&&!o.isVisible()){v=this._getVisibleNode(o);this._adjustSelectionOnExpanding(v);}return;}else{this._delMultiSelection(n,s);if(!n.isVisible()){v=this._getVisibleNode(n);this._adjustSelectionOnExpanding(v);}}}if(i){this._setMultiSelection(n,s);this.oLeadSelection=n;}else{this._delMultiSelection(n,s);this.oLeadSelection=n;}if(!s){q.map(this.mSelectedNodes,function(n){S.push(n);});q.map(this.mSelectedContexts,function(e){d.push(e);});this.fireSelectionChange({nodes:S,nodeContexts:d});}};
b.prototype._setMultiSelection=function(s,S){if(!s){return;}s._select(S);this.mSelectedNodes[s.getId()]=s;this._addSelectedNodeContext(this.getNodeContext(s));};
b.prototype._delMultiSelection=function(s){var o;if(!s){return;}s._deselect();this.mSelectedNodes=this._removeItemFromObject(this.mSelectedNodes,s.getId());o=s.getBindingContext();if(o&&o.sPath){if(o.sPath in this.mSelectedContexts){this.mSelectedContexts=this._removeItemFromObject(this.mSelectedContexts,o.sPath);}}};
b.prototype._delSelection=function(){var t=this;if(this.oSelectedNode){this.oSelectedNode._deselect();}if(q.isEmptyObject(this.mSelectedNodes)==false){q.each(this.mSelectedNodes,function(i,n){t._delMultiSelection(n);});}};
b.prototype._getNodes=function(){return this.mAggregations.nodes||[];};
b.prototype._getVisibleNode=function(n){var p=n.getParent();if(p.isVisible()){var v=p;}else{v=this._getVisibleNode(p);}return v;};
return b;});
sap.ui.predefine('sap/ui/commons/TreeNode',['sap/ui/thirdparty/jquery','./library','sap/ui/core/CustomStyleClassSupport','sap/ui/core/Element','./Tree'],function(q,l,C,E,T){"use strict";var a=l.TreeSelectionMode;
var b=E.extend("sap.ui.commons.TreeNode",{metadata:{library:"sap.ui.commons",properties:{text:{type:"string",group:"Misc",defaultValue:null},expanded:{type:"boolean",group:"Misc",defaultValue:true},hasExpander:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},isSelected:{type:"boolean",group:"Misc",defaultValue:false},selectable:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"nodes",aggregations:{nodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"node"}},associations:{selectedForNodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"selectedForNode",visibility:"hidden"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{toggleOpenState:{parameters:{opened:{type:"boolean"}}},selected:{}}}});
b.prototype.getSelectedForNodes=function(){return this.getAssociation("selectedForNodes",[]);};
b.ANIMATION_DURATION=600;C.apply(b.prototype);
b.prototype.expand=function(d,D){this.setProperty("expanded",true,true);var f=null;if(!D){f=e.bind(this);}var o=this.$();if(o.hasClass("sapUiTreeNodeCollapsed")){o.toggleClass("sapUiTreeNodeCollapsed");o.toggleClass("sapUiTreeNodeExpanded");o.attr("aria-expanded","true");var g=this.$("children");if(g){if(d){g.show();}else{g.stop(true,true);g.show(b.ANIMATION_DURATION,f);}g.css({display:'block'});}this.fireToggleOpenState({opened:true});}if(d){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].expand(d,true);}f&&f();}};
b.prototype.collapse=function(d,D){this.setProperty("expanded",false,true);var f=null;if(!D){f=c.bind(this);}var o=this.$();if(o.hasClass("sapUiTreeNodeExpanded")){o.toggleClass("sapUiTreeNodeCollapsed");o.toggleClass("sapUiTreeNodeExpanded");o.attr("aria-expanded","false");var g=this.$("children");if(g){if(d){g.hide();}else{g.stop(true,true);g.hide(b.ANIMATION_DURATION,f);}}this.fireToggleOpenState({opened:false});}if(d){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].collapse(d,true);}f&&f();}};
b.prototype.select=function(s){var t=this.getTree();if(t){t.setSelection(this,s);}else{this._select();}};
function e(){var t=this.getTree();if(t){t._adjustSelectionOnExpanding(this);}}
function c(){var t=this.getTree();if(t){t._adjustSelectionOnCollapsing(this);t._adjustFocus();}}
b.prototype._select=function(s){this.setProperty("isSelected",true,true);if(!s){this.fireSelected();}if(this.getDomRef()){this.$().closest(".sapUiTreeNode").addClass("sapUiTreeNodeSelected").attr("aria-selected","true");this.scrollIntoView();}};
b.prototype._deselect=function(s){this.setProperty("isSelected",false,true);if(this.getDomRef()){this.$().removeClass("sapUiTreeNodeSelected").removeAttr("aria-selected");}};
b.prototype._getNodes=function(){return this.mAggregations.nodes||[];};
b.prototype.hasSelectedHiddenChild=function(){var n=this._getNodes();for(var i=0;i<n.length;i++){if((!n[i].isVisible()&&n[i].getIsSelected())||n[i].hasSelectedHiddenChild()){return true;}}return false;};
b.prototype.setIsSelected=function(i){var t=this.getTree();if(!this.getSelectable()){return this;}if(i==this.getProperty("isSelected")){return this;}if(t){t._setNodeSelection(this,i,true);}else{this.setProperty("isSelected",i,true);}return this;};
b.prototype.setSelectable=function(s){if(!s&&this.getIsSelected()){this.setIsSelected(false);}this.setProperty("selectable",s);return this;};
b.prototype.onclick=function(o){var d=o.target,t=this.getTree();if(q(d).is(".sapUiTreeNode")||q(d).is(".sapUiTreeNodeNotSelectable")){if(q(d).is(".sapUiTreeNodeNotSelectable")){d=q(d).closest(".sapUiTreeNode")[0];}if(q(d).hasClass("sapUiTreeNodeExpanded")){this.collapse();}else{this.expand();}t.placeFocus(d);d.focus();}else if(q(d).is(".sapUiTreeNodeContent")||q(d).is(".sapUiTreeIcon")){var s=T.SelectionType.Select;if(t.getSelectionMode()==a.Multi){if(o.shiftKey){s=T.SelectionType.Range;}if(o.metaKey||o.ctrlKey){s=T.SelectionType.Toggle;}}t.setSelection(this,false,s);d=q(d).closest(".sapUiTreeNode")[0];t.placeFocus(d);d.focus();}};
b.prototype.onsapselect=function(o){if(this.getSelectable()){this.getTree().setSelection(this);}else if(this.getExpanded()){this.collapse();}else{this.expand();}};
b.prototype.onsapexpand=function(o){this.expand();};
b.prototype.onsapcollapse=function(o){this.collapse();};
b.prototype.onsapleft=function(o){if(sap.ui.getCore().getConfiguration().getRTL()){this.expand();}else{this.collapse();}o.preventDefault();};
b.prototype.onsapright=function(o){if(sap.ui.getCore().getConfiguration().getRTL()){this.collapse();}else{this.expand();}o.preventDefault();};
b.prototype.focus=function(){var d=this.getFocusDomRef();if(d){d.setAttribute("tabindex","0");d.focus();}};
b.prototype.blur=function(){var d=this.getFocusDomRef();if(d){d.setAttribute("tabindex","-1");}};
b.prototype.getTree=function(){var p=this.getParent();while(p instanceof b){p=p.getParent();}return p;};
b.prototype.hasChildren=function(){var s=this._getNodes();if(s.length){return true;}return false;};
b.prototype.isVisible=function(){var p=this.getParent();while(p instanceof b){if(!p.getExpanded()){return false;}p=p.getParent();}return true;};
b.prototype.scrollIntoView=function(){var n=this.$(),t=this.getTree().$(),$=t.find(".sapUiTreeCont"),o=n[0].offsetTop,s=$.scrollTop(),h=$.height(),N,O=n[0].offsetLeft,S=$.scrollLeft(),w=$.width(),i;if(o>s+h||o<s){N=o-Math.floor(h*0.5);N=Math.max(N,0);}if(O>S+w||O<S){i=O-Math.floor(w*0.5);i=Math.max(i,0);}if(N!==undefined||i!==undefined){var m={};if(N!==undefined){m.scrollTop=N;}if(i!==undefined){m.scrollLeft=i;}$.stop(true,true).animate(m);}};
b.prototype.getTooltip_AsString=function(){var t;var o=this.getTooltip();if(typeof o==="string"||o instanceof String){t=o;}if(!t){t=this.getText();}return t;};
return b;});
sap.ui.predefine('sap/ui/commons/TreeRenderer',[],function(){"use strict";var T={};
T.render=function(r,t){T.bFirstNodeRendered=false;r.write("<div");r.writeControlData(t);r.addClass("sapUiTree");if(t.getHeight()!=""&&t.getHeight()!="auto"){r.addClass("sapUiTreeFixedHeight");}if(!t.getShowHeader()){r.addClass("sapUiTreeTransparent");}r.writeClasses();r.addStyle("width",t.getWidth()||"auto");r.addStyle("height",t.getHeight());r.addStyle("min-width",t.getMinWidth());r.writeStyles();r.writeAttribute('role','tree');r.write(">");if(t.getShowHeader()){r.write("<div id=\""+t.getId()+"-Header\" class=\"sapUiTreeHeader\"");r.writeAttribute('role','heading');r.write(">");r.write("<div class='sapUiTreeTitle'");if(t.getTooltip_AsString()){r.writeAttributeEscaped("title",t.getTooltip_AsString());}r.write(">");r.writeEscaped(t.getTitle());r.write("</div>");if(t.getShowHeaderIcons()){r.write("<div id='"+t.getId()+"-TBCont' class='sapUiTreeTbCont'");r.writeAttribute('role','toolbar');r.write(">");r.renderControl(t.oCollapseAllButton);r.renderControl(t.oExpandAllButton);r.write("</div>");}r.write("</div>");}r.write("<div id=\""+t.getId()+"-TreeCont\"");r.addClass("sapUiTreeCont");var s=t.getShowHorizontalScrollbar();if(s){r.addClass("sapUiTreeContScroll");}else{r.addClass("sapUiTreeContNoScroll");}r.writeClasses();r.write(">");r.write("<ul class=\"sapUiTreeList\">");var n=t.getNodes();for(var i=0;i<n.length;i++){T.renderNode(r,n[i],1,n.length,i+1);}r.write("</ul>");r.write("</div>");r.write("</div>");};
T.renderNode=function(r,n,l,s,p){var e;r.write("<li");r.writeElementData(n);r.addClass("sapUiTreeNode");if(n.getExpanded()&&(n.getHasExpander()||n.hasChildren())){r.addClass("sapUiTreeNodeExpanded");e=true;}else if(!n.getExpanded()&&(n.getHasExpander()||n.hasChildren())){r.addClass("sapUiTreeNodeCollapsed");e=false;}if(n.getSelectable()&&n.getIsSelected()){r.addClass("sapUiTreeNodeSelected");r.writeAttribute('aria-selected','true');}if(!e&&n.hasSelectedHiddenChild()){r.addClass("sapUiTreeNodeSelectedParent");r.writeAttribute('aria-selected','true');}r.writeClasses(n);var P={role:'treeitem',level:l,setsize:s,posinset:p};if(e){P["expanded"]=true;}else{if(n.getHasExpander()){P["expanded"]=false;}}r.writeAccessibilityState(n,P);r.writeAttributeEscaped("title",n.getTooltip_AsString());if(!T.bFirstNodeRendered){r.write("tabindex='0'");T.bFirstNodeRendered=true;}r.write(">");r.write("<span");r.addClass("sapUiTreeNodeContent");if(!n.getSelectable()){r.addClass("sapUiTreeNodeNotSelectable");}r.writeClasses();r.write(">");if(n.getIcon()){r.writeIcon(n.getIcon(),"sapUiTreeIcon",{"title":null});}r.writeEscaped(n.getText());r.write("</span>");r.write("</li>");if(n.getNodes()){var S=n.getNodes();r.write("<ul");r.writeAttribute("id",n.getId()+"-children");r.addClass("sapUiTreeChildrenNodes");if(!e){r.addClass("sapUiTreeHiddenChildrenNodes");}else{r.writeAttribute("style","display: block;");}r.writeClasses();r.write(">");l++;for(var i=0;i<S.length;i++){T.renderNode(r,S[i],l,S.length,i+1);}r.write("</ul>");}};
return T;},true);
sap.ui.predefine('sap/ui/commons/TriStateCheckBox',['./library','sap/ui/core/Control','./TriStateCheckBoxRenderer','sap/ui/core/library','sap/ui/Device'],function(l,C,T,c,D){"use strict";var a=c.TextDirection;var V=c.ValueState;var b=l.TriStateCheckBoxState;
var d=C.extend("sap.ui.commons.TriStateCheckBox",{metadata:{library:"sap.ui.commons",properties:{selectionState:{type:"sap.ui.commons.TriStateCheckBoxState",group:"Data",defaultValue:b.Unchecked},text:{type:"string",group:"Appearance",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:a.Inherit}},events:{change:{parameters:{selectionState:{type:"string"}}}}}});
d.prototype.onclick=function(e){if(D.browser.msie&&!this.getEnabled()){this.$().attr("tabindex",0).addClass("sapUiTriCbFoc");}this.userToggle(e);};
d.prototype.onfocusout=function(e){if(D.browser.msie&&!this.getEnabled()){this.$().attr("tabindex",-1).removeClass("sapUiTriCbFoc");}};
d.prototype.onsapspace=function(e){e.preventDefault();this.userToggle(e);};
d.prototype.userToggle=function(e){if(this.getEnabled()&&this.getEditable()){if(this.getSelectionState()==='Mixed'||this.getSelectionState()==="Unchecked"){this.toggle("Checked");}else{this.toggle("Unchecked");}this.fireChange({selectionState:this.getSelectionState()});}else{this.getDomRef().focus();}};
d.prototype.toggle=function(e){if(e in b){this.setSelectionState(e);}};
return d;});
sap.ui.predefine('sap/ui/commons/TriStateCheckBoxRenderer',['sap/ui/core/ValueStateSupport','sap/ui/core/library'],function(V,c){"use strict";var T=c.TextDirection;var A=c.AccessibleRole;var a=c.ValueState;var b={};
b.render=function(r,C){var m=0;var R=false;var e=!!C.getEnabled();var d=!!C.getEditable();var i=false;var f=false;var s=C.getSelectionState();var g=s.toLowerCase();if(g=="checked"){g=true;}else if(g=="unchecked"){g=false;}var t=V.enrichTooltip(C,C.getTooltip_AsString());var h="sapUiAriaLabel"+C.getIdForLabel();if(C.getValueState()!=null){i=a.Error==C.getValueState();f=a.Warning==C.getValueState();}r.write("<span");r.writeControlData(C);r.addClass("sapUiTriCb");if(C.getWidth()){r.writeAttribute("style","width:"+C.getWidth()+";");}r.writeAccessibilityState(C,{"role":A.Checkbox.toLowerCase(),"checked":g});r.writeClasses();if(!e){m=-1;}r.writeAttribute("tabindex",m);r.write(">");r.write("<span");r.writeAccessibilityState(C,{"labelledby":h});if(t){r.writeAttributeEscaped("title",t);}if(!e){R=true;m=-1;r.write(" disabled='disabled'");}if(!d){R=true;}if(R){r.write(" readOnly='readOnly'");}r.addClass("sapUiTriCbInner");if(!e){r.addClass("sapUiTriCbDis");}if(!d){r.addClass("sapUiTriCbRo");}if(i){r.addClass("sapUiTriCbErr");}else if(f){r.addClass("sapUiTriCbWarn");}if(s==="Checked"){r.addClass("sapUiTriCbCheck");}else if(s==="Mixed"){r.addClass("sapUiTriCbMix");}r.writeClasses();r.write(">");r.write("</span>");if(C.getText()){this.renderText(h,r,C.getText(),C.getTextDirection());}r.write("</span>");};
b.renderText=function(l,r,t,e){r.write("<span id="+l+" class=\"sapUiTriCbLbl\"");if(!e||e==T.Inherit){r.write(">");r.writeEscaped(t);}else{r.write(" style=\"direction:"+e.toLowerCase()+";\">");r.writeEscaped(t);}r.write("</span>");};
return b;},true);
sap.ui.predefine('sap/ui/commons/ValueHelpField',['./TextField','./library','sap/ui/core/IconPool','sap/ui/core/theming/Parameters','./ValueHelpFieldRenderer'],function(T,l,I,P,V){"use strict";
var a=T.extend("sap.ui.commons.ValueHelpField",{metadata:{library:"sap.ui.commons",properties:{iconURL:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},iconHoverURL:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},iconDisabledURL:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null}},events:{valueHelpRequest:{}}}});
a.prototype.onBeforeRendering=function(){this.sIconDsblUrl="sap-icon://value-help";this.sIconRegularUrl="sap-icon://value-help";this.sIconHoverUrl="sap-icon://value-help";};
a.prototype.onmouseover=function(e){if(e.target.id==this.getId()+'-icon'&&this.getEnabled()&&this.getEditable()&&!this.bIsIconURI){if(this.getIconHoverURL()){this.sIconHoverUrl=this.getIconHoverURL();}else if(this.getIconURL()){this.sIconHoverUrl=this.sIconRegularUrl;}else{this.sIconHoverUrl="sap-icon://value-help";}e.target.setAttribute('src',this.sIconHoverUrl);}};
a.prototype.onmouseout=function(e){if(e.target.id==this.getId()+'-icon'&&this.getEnabled()&&this.getEditable()&&!this.bIsIconURI){e.target.setAttribute('src',this.sIconRegularUrl);}};
a.prototype.onclick=function(e){if(e.target.id==this.getId()+'-icon'&&this.getEnabled()&&this.getEditable()){this.fireValueHelpRequest({});}};
a.prototype.setEnabled=function(e){var o=this.getEnabled();T.prototype.setEnabled.apply(this,arguments);if(this.getDomRef()&&o!=e&&!this.bIsIconURI){var i=this.$("icon");if(e){i.attr('src',this.sIconRegularUrl);i.removeClass('sapUiTfValueHelpDsblIcon');i.addClass('sapUiTfValueHelpRegularIcon');}else{i.attr('src',this.sIconRegularUrl);i.removeClass('sapUiTfValueHelpRegularIcon');i.addClass('sapUiTfValueHelpDsblIcon');}}return this;};
a.prototype.setEditable=function(e){var o=this.getEditable();T.prototype.setEditable.apply(this,arguments);if(this.getDomRef()&&o!=e&&!this.bIsIconURI){var i=this.$("icon");if(e){i.removeClass('sapUiTfValueHelpDsblIcon');i.addClass('sapUiTfValueHelpRegularIcon');}else{i.removeClass('sapUiTfValueHelpRegularIcon');i.addClass('sapUiTfValueHelpDsblIcon');}}return this;};
a.prototype.onsapshow=function(e){this._checkChange(e);this.fireValueHelpRequest({});e.preventDefault();e.stopPropagation();};
a.prototype.getTooltip_AsString=function(){var t=T.prototype.getTooltip_AsString.apply(this,arguments);if(this.getEnabled()&&this.getEditable()){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var s=r.getText("VHF_TOOLTIP");return(t?t+" - ":"")+s;}else{return t;}};
a.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate();}};
a.prototype.exit=function(){this.sIconRegularUrl=undefined;this.sIconHoverUrl=undefined;this.sIconDsblUrl=undefined;};
return a;});
sap.ui.predefine('sap/ui/commons/ValueHelpFieldRenderer',['./TextFieldRenderer','sap/ui/core/Renderer','sap/ui/core/IconPool'],function(T,R,I){"use strict";var V=R.extend(T);
V.renderOuterAttributes=function(r,c){r.addClass("sapUiTfCombo");r.writeAttribute("aria-owns",c.getId()+'-input '+c.getId()+'-icon');};
V.renderOuterContent=function(r,c){var i=c.getIconURL();var C=[];var a={};a["id"]=c.getId()+"-icon";a["role"]="button";C.push("sapUiTfValueHelpIcon");if(i&&I.isIconURI(i)){c.bIsIconURI=true;a.title=c.getTooltip_AsString();}else{c.bIsIconURI=false;if(c.getEnabled()&&c.getEditable()){C.push("sapUiTfValueHelpRegularIcon");}i=this.renderIcon(r,c,C);}r.writeIcon(i,C,a);};
V.renderIcon=function(r,c,C){var i="";if(!c.getEnabled()){if(c.getIconDisabledURL()){c.sIconDsblUrl=c.getIconDisabledURL();}else if(c.getIconURL()){c.sIconDsblUrl=c.getIconURL();C.push('sapUiTfValueHelpDsblIcon');}i=c.sIconDsblUrl;}else{if(c.getIconURL()){c.sIconRegularUrl=c.getIconURL();}i=c.sIconRegularUrl;}return i;};
return V;},true);
sap.ui.predefine('sap/ui/commons/form/Form',['sap/ui/commons/library','sap/ui/layout/form/Form','./FormRenderer'],function(l,L,F){"use strict";
var a=L.extend("sap.ui.commons.form.Form",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return a;});
sap.ui.predefine('sap/ui/commons/form/FormContainer',['sap/ui/commons/library','sap/ui/layout/form/FormContainer'],function(l,L){"use strict";
var F=L.extend("sap.ui.commons.form.FormContainer",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return F;});
sap.ui.predefine('sap/ui/commons/form/FormElement',['sap/ui/commons/library','sap/ui/layout/form/FormElement'],function(l,L){"use strict";
var F=L.extend("sap.ui.commons.form.FormElement",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return F;});
sap.ui.predefine('sap/ui/commons/form/FormLayout',['sap/ui/commons/library','sap/ui/layout/form/FormLayout','./FormLayoutRenderer'],function(l,L,F){"use strict";
var a=L.extend("sap.ui.commons.form.FormLayout",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return a;});
sap.ui.predefine('sap/ui/commons/form/FormLayoutRenderer',['sap/ui/core/Renderer','sap/ui/layout/form/FormLayoutRenderer'],function(R,L){"use strict";var F=R.extend(L);return F;},true);
sap.ui.predefine('sap/ui/commons/form/FormRenderer',['sap/ui/core/Renderer','sap/ui/layout/form/FormRenderer'],function(R,L){"use strict";var F=R.extend(L);return F;},true);
sap.ui.predefine('sap/ui/commons/form/GridContainerData',['sap/ui/commons/library','sap/ui/layout/form/GridContainerData'],function(l,L){"use strict";
var G=L.extend("sap.ui.commons.form.GridContainerData",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return G;});
sap.ui.predefine('sap/ui/commons/form/GridElementData',['sap/ui/commons/library','sap/ui/layout/form/GridElementData'],function(l,L){"use strict";
var G=L.extend("sap.ui.commons.form.GridElementData",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return G;});
sap.ui.predefine('sap/ui/commons/form/GridLayout',['sap/ui/commons/library','sap/ui/layout/form/GridLayout','./GridLayoutRenderer'],function(l,L,G){"use strict";
var a=L.extend("sap.ui.commons.form.GridLayout",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return a;});
sap.ui.predefine('sap/ui/commons/form/GridLayoutRenderer',['sap/ui/core/Renderer','sap/ui/layout/form/GridLayoutRenderer'],function(R,L){"use strict";var G=R.extend(L);return G;},true);
sap.ui.predefine('sap/ui/commons/form/ResponsiveLayout',['sap/ui/commons/library','sap/ui/layout/form/ResponsiveLayout','./ResponsiveLayoutRenderer'],function(l,L,R){"use strict";
var a=L.extend("sap.ui.commons.form.ResponsiveLayout",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return a;});
sap.ui.predefine('sap/ui/commons/form/ResponsiveLayoutRenderer',['sap/ui/core/Renderer','sap/ui/layout/form/ResponsiveLayoutRenderer'],function(R,L){"use strict";var a=R.extend(L);return a;},true);
sap.ui.predefine('sap/ui/commons/form/SimpleForm',['sap/ui/commons/library','sap/ui/layout/form/SimpleForm','./SimpleFormRenderer'],function(l,L,S){"use strict";
var a=L.extend("sap.ui.commons.form.SimpleForm",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return a;});
sap.ui.predefine('sap/ui/commons/form/SimpleFormRenderer',['sap/ui/core/Renderer','sap/ui/layout/form/SimpleFormRenderer'],function(R,L){"use strict";var S=R.extend(L);return S;},true);
sap.ui.predefine('sap/ui/commons/layout/AbsoluteLayout',['sap/ui/thirdparty/jquery','./PositionContainer','sap/ui/commons/library','sap/ui/core/Control','./AbsoluteLayoutRenderer','sap/ui/core/library'],function(q,P,l,C,A,c){"use strict";var S=c.Scrolling;
var a=C.extend("sap.ui.commons.layout.AbsoluteLayout",{metadata:{library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},verticalScrolling:{type:"sap.ui.core.Scrolling",group:"Behavior",defaultValue:S.Hidden},horizontalScrolling:{type:"sap.ui.core.Scrolling",group:"Behavior",defaultValue:S.Hidden}},defaultAggregation:"positions",aggregations:{positions:{type:"sap.ui.commons.layout.PositionContainer",multiple:true,singularName:"position"}}}});
a.prototype.setWidth=function(w){return s(this,"width",w,"LYT_SIZE");};
a.prototype.setHeight=function(h){return s(this,"height",h,"LYT_SIZE");};
a.prototype.setVerticalScrolling=function(v){return s(this,"verticalScrolling",v,"LYT_SCROLL");};
a.prototype.setHorizontalScrolling=function(h){return s(this,"horizontalScrolling",h,"LYT_SCROLL");};
a.prototype.insertPosition=function(p,i){var h=!!this.getDomRef();this.insertAggregation("positions",p,i,h);if(h&&p&&p.getControl()){this.contentChanged(p,"CTRL_ADD");}return this;};
a.prototype.addPosition=function(p){var h=!!this.getDomRef();this.addAggregation("positions",p,h);if(h&&p&&p.getControl()){this.contentChanged(p,"CTRL_ADD");}return this;};
a.prototype.removePosition=function(p){var h=!!this.getDomRef();var r=this.removeAggregation("positions",p,h);if(r){d([r]);this.contentChanged(r,"CTRL_REMOVE");}return r;};
a.prototype.removeAllPositions=function(){d(this.getPositions());var h=!!this.getDomRef();var r=this.removeAllAggregation("positions",h);if(h){this.contentChanged(r,"CTRL_REMOVE_ALL");}return r;};
a.prototype.destroyPositions=function(){d(this.getPositions());var h=!!this.getDomRef();this.destroyAggregation("positions",h);if(h){this.contentChanged(null,"CTRL_REMOVE_ALL");}return this;};
a.prototype.getContent=function(){var g=[];var p=this.getPositions();for(var i=0;i<p.length;i++){g.push(p[i].getControl());}return g;};
a.prototype.addContent=function(o,p){var g=P.createPosition(o,p);this.addPosition(g);return this;};
a.prototype.insertContent=function(o,i,p){var g=P.createPosition(o,p);this.insertPosition(g,i);return this;};
a.prototype.removeContent=function(v){var i=v;if(typeof(v)=="string"){v=sap.ui.getCore().byId(v);}if(typeof(v)=="object"){i=this.indexOfContent(v);}if(i>=0&&i<this.getContent().length){this.removePosition(i);return v;}return null;};
a.prototype.removeAllContent=function(){var g=this.getContent();this.removeAllPositions();return g;};
a.prototype.indexOfContent=function(o){var g=this.getContent();for(var i=0;i<g.length;i++){if(o===g[i]){return i;}}return-1;};
a.prototype.destroyContent=function(){this.destroyPositions();return this;};
a.prototype.setPositionOfChild=function(o,p){var i=this.indexOfContent(o);if(i>=0){var g=this.getPositions()[i];g.updatePosition(p);return true;}return false;};
a.prototype.getPositionOfChild=function(o){var i=this.indexOfContent(o);if(i>=0){var p=this.getPositions()[i];return p.getComputedPosition();}return{};};
a.prototype.exit=function(){d(this.getPositions());};
a.prototype.doBeforeRendering=function(){var p=this.getPositions();if(!p||p.length==0){return;}for(var i=0;i<p.length;i++){var o=p[i];o.reinitializeEventHandlers(true);e(o,true);}};
a.prototype.onAfterRendering=function(){var p=this.getPositions();if(!p||p.length==0){return;}for(var i=0;i<p.length;i++){p[i].reinitializeEventHandlers();}};
a.cleanUpControl=function(o){if(o&&o[b]){o.removeDelegate(o[b]);o[b]=undefined;}};
a.prototype.contentChanged=function(p,g){switch(g){case"CTRL_POS":A.updatePositionStyles(p);e(p);p.reinitializeEventHandlers();break;case"CTRL_CHANGE":e(p,true);A.updatePositionedControl(p);p.reinitializeEventHandlers();break;case"CTRL_REMOVE":A.removePosition(p);p.reinitializeEventHandlers(true);break;case"CTRL_REMOVE_ALL":A.removeAllPositions(this);var h=p;if(h){for(var i=0;i<h.length;i++){h[i].reinitializeEventHandlers(true);}}break;case"CTRL_ADD":e(p,true);A.insertPosition(this,p);p.reinitializeEventHandlers();break;case"LYT_SCROLL":A.updateLayoutScolling(this);break;case"LYT_SIZE":A.updateLayoutSize(this);break;}};
var b="__absolutelayout__delegator";var d=function(p){for(var i=0;i<p.length;i++){var o=p[i];var g=o.getControl();if(g){a.cleanUpControl(g);}}};var e=function(p,r){var o=p.getControl();if(o){a.cleanUpControl(o);if(!r){f(o);}var D=(function(g){return{onAfterRendering:function(){f(g);}};}(o));o[b]=D;o.addDelegate(D,true);}};var f=function(o){var g=false;if(o.getParent()&&o.getParent().getComputedPosition){var p=o.getParent().getComputedPosition();if(p.top&&p.bottom||p.height){q(o.getDomRef()).css("height","100%");g=true;}if(p.left&&p.right||p.width){q(o.getDomRef()).css("width","100%");g=true;}if(g){A.updatePositionStyles(o.getParent());}}return g;};var s=function(t,p,v,g){var h=!!t.getDomRef();t.setProperty(p,v,h);if(h){t.contentChanged(null,g);}return t;};P.cleanUpControl=a.cleanUpControl;return a;});
sap.ui.predefine('sap/ui/commons/layout/AbsoluteLayoutRenderer',['sap/ui/core/library'],function(c){"use strict";var S=c.Scrolling;var A={};
A.render=function(r,C){C.doBeforeRendering();r.write("<div");r.writeControlData(C);r.addClass("sapUiLayoutAbs");r.addClass("sapUiLayoutAbsOvrflwY"+C.getVerticalScrolling());r.addClass("sapUiLayoutAbsOvrflwX"+C.getHorizontalScrolling());r.writeClasses();var s="width:"+C.getWidth()+";height:"+C.getHeight()+";";r.writeAttribute("style",s);var t=C.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");var p=C.getPositions();if(p&&p.length>0){for(var i=0;i<p.length;i++){var P=p[i];var o=P.getControl();if(o){r.write("<div");r.writeElementData(P);r.writeAttribute("class","sapUiLayoutAbsPos");r.writeAttribute("style",g(P));t=P.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");r.renderControl(o);r.write("</div>");}}}r.write("</div>");};
A.updateLayoutSize=function(l){l.$().css("width",l.getWidth()).css("height",l.getHeight());};
A.updateLayoutScolling=function(l){var L=l.$();for(var s in S){L.removeClass("sapUiLayoutAbsOvrflwY"+s).removeClass("sapUiLayoutAbsOvrflwX"+s);}L.addClass("sapUiLayoutAbsOvrflwY"+l.getVerticalScrolling()).addClass("sapUiLayoutAbsOvrflwX"+l.getHorizontalScrolling());};
A.updatePositionStyles=function(p){p.$().attr("style",g(p));};
A.removePosition=function(p){p.$().remove();};
A.removeAllPositions=function(l){l.$().html("");};
A.updatePositionedControl=function(p){A.updatePositionStyles(p);var r=sap.ui.getCore().createRenderManager();r.renderControl(p.getControl());r.flush(p.getDomRef());r.destroy();};
A.insertPosition=function(l,p){var i=l.indexOfPosition(p);var P=l.getPositions();var o=null;while(i>0){i--;if(P[i].getDomRef()){o=P[i];break;}}var h="<div id=\""+p.getId()+"\" data-sap-ui=\""+p.getId()+"\" class=\"sapUiLayoutAbsPos\"></div>";if(!o){l.$().prepend(h);}else{o.$().after(h);}A.updatePositionedControl(p);};
var g=function(p){var P=p.getComputedPosition();var a=function(p,b,s,v){if(v){b.push(s+":"+v+";");}};var b=[];a(p,b,"top",P.top);a(p,b,"bottom",P.bottom);a(p,b,"left",P.left);a(p,b,"right",P.right);a(p,b,"width",P.width);a(p,b,"height",P.height);return b.join("");};return A;},true);
sap.ui.predefine('sap/ui/commons/layout/BorderLayout',['sap/base/assert','sap/ui/commons/library','sap/ui/core/Control','./BorderLayoutRenderer','./BorderLayoutArea'],function(a,l,C,B,b){"use strict";var c=l.layout.BorderLayoutAreaTypes;
var d=C.extend("sap.ui.commons.layout.BorderLayout",{metadata:{library:"sap.ui.commons",properties:{rtl:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'}},aggregations:{top:{type:"sap.ui.commons.layout.BorderLayoutArea",multiple:false},begin:{type:"sap.ui.commons.layout.BorderLayoutArea",multiple:false},center:{type:"sap.ui.commons.layout.BorderLayoutArea",multiple:false},end:{type:"sap.ui.commons.layout.BorderLayoutArea",multiple:false},bottom:{type:"sap.ui.commons.layout.BorderLayoutArea",multiple:false}}}});
d.prototype._getOrCreateArea=function(A,e){var T=c,t=this,o;function f(m){var g;if(e){g=new b({id:t.getId()+"--"+A,areaId:A,content:e});t[m](g);}return g;}if(!T.hasOwnProperty(A)){throw new Error("Invalid Area Id '"+A+"'");}switch(A){case T.top:o=this.getTop()||f("setTop");break;case T.begin:o=this.getBegin()||f("setBegin");break;case T.center:o=this.getCenter()||f("setCenter");break;case T.end:o=this.getEnd()||f("setEnd");break;case T.bottom:o=this.getBottom()||f("setBottom");break;default:a(false,"default case must not be reached");break;}return o;};
d.prototype.getArea=function(A,e){return this._getOrCreateArea(A,e?[]:null);};
d.prototype.createArea=function(A,o){return this._getOrCreateArea(A,Array.prototype.slice.call(arguments,1));};
d.prototype.getAreaById=function(A){return this._getOrCreateArea(A,[]);};
d.prototype.getAreaData=function(A){var o=this.getAreaById(A);return o?{size:o.getSize(),visible:o.getVisible(),overflowX:o.getOverflowX(),overflowY:o.getOverflowY(),contentAlign:o.getContentAlign()}:{};};
d.prototype.setAreaData=function(A,D){this.getArea(A,true).applySettings(D);return this;};
d.prototype.addContent=function(A){var o=this.getArea(A,true),i;for(var i=1;i<arguments.length;i++){o.addContent(arguments[i]);}return this;};
d.prototype.insertContent=function(A,I){var o=this.getArea(A,true),i;for(i=2;i<arguments.length;i++){o.insertContent(arguments[i],I++);}return this;};
d.prototype.removeContent=function(A,e){var o=this.getAreaById(A);if(o){o.removeContent(e);}return this;};
d.prototype.removeAllContent=function(A){var o=this.getAreaById(A);if(o){o.removeAllContent();}return this;};
d.prototype.getContent=function(A){var o=this.getAreaById(A);return o?o.getContent():[];};
d.prototype.indexOfContent=function(A,o){var e=this.getAreaById(A);return e?e.indexOfContent(o):-1;};
d.prototype.destroyContent=function(A){this.getAreaById(A,true).destroyContent();return this;};
return d;});
sap.ui.predefine('sap/ui/commons/layout/BorderLayoutArea',['sap/ui/commons/library','sap/ui/core/CustomStyleClassSupport','sap/ui/core/Element'],function(l,C,E){"use strict";var B=l.layout.BorderLayoutAreaTypes;
var a=E.extend("sap.ui.commons.layout.BorderLayoutArea",{metadata:{library:"sap.ui.commons",properties:{areaId:{type:"sap.ui.commons.layout.BorderLayoutAreaTypes",group:"Identification",defaultValue:B.top,deprecated:true},overflowX:{type:"string",group:"Misc",defaultValue:'auto'},overflowY:{type:"string",group:"Misc",defaultValue:'auto'},contentAlign:{type:"string",group:"Misc",defaultValue:'left'},size:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100px'},visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
C.apply(a.prototype);
a.prototype.getAreaId=function(){var p=this.getParent();return(p&&p instanceof sap.ui.commons.layout.BorderLayout)?this.sParentAggregationName:undefined;};
a.prototype.setVisible=function(v,b){var A=this.getAreaId();if(A==="center"||!b){this.setProperty("visible",v);return this;}this.setProperty("visible",v,true);this.getParent().getMetadata().getRenderer().animate(this,v);return this;};
return a;});
sap.ui.predefine('sap/ui/commons/layout/BorderLayoutRenderer',["sap/ui/thirdparty/jquery","sap/base/assert","sap/base/security/encodeXML"],function(q,a,e){"use strict";var B={};
B.render=function(R,c){var A={top:c.getTop(),begin:c.getBegin(),center:c.getCenter(),end:c.getEnd(),bottom:c.getBottom()};var m={top:s(A.top),begin:s(A.begin),center:s(A.center),end:s(A.end),bottom:s(A.bottom)};var b=sap.ui.getCore().getConfiguration().getRTL();R.write("<div");R.writeControlData(c);R.addClass("sapUiBorderLayout");R.addStyle("width",c.getWidth());R.addStyle("height",c.getHeight());R.writeClasses();R.writeStyles();R.write(">");if(A.top){r(R,"top",A.top,m,b);}if(A.begin){r(R,"begin",A.begin,m,b);}if(A.center&&A.center.getVisible()){r(R,"center",A.center,m,b);}if(A.end){r(R,"end",A.end,m,b);}if(A.bottom){r(R,"bottom",A.bottom,m,b);}R.write("</div>");};
B.animate=function(A,v){var R=sap.ui.getCore().getConfiguration().getRTL();var b=v?A.getSize():"0";switch(A.getAreaId()){case"top":$(A,"top").animate({height:b});$(A,"begin").animate({top:b});$(A,"center").animate({top:b});$(A,"end").animate({top:b});break;case"begin":$(A,"begin").animate({width:b});$(A,"center").animate(R?{right:b}:{left:b});break;case"end":$(A,"center").animate(R?{left:b}:{right:b});$(A,"end").animate({width:b});break;case"bottom":$(A,"begin").animate({bottom:b});$(A,"center").animate({bottom:b});$(A,"end").animate({bottom:b});$(A,"bottom").animate({height:b});break;default:break;}};
function s(A){var S=A&&A.getVisible()&&A.getSize();return S||"0";}
function r(R,A,o,m,b){var c=o.getContent();var l=c.length;R.write("<div");R.writeAttribute("id",o.getId());switch(A){case"top":R.addClass("sapUiBorderLayoutTop");R.addStyle("height",m.top);break;case"begin":R.addClass("sapUiBorderLayoutBegin");R.addStyle("width",m.begin);R.addStyle("top",m.top);R.addStyle("bottom",m.bottom);break;case"center":R.addClass("sapUiBorderLayoutCenter");R.addStyle("top",m.top);R.addStyle("right",b?m.begin:m.end);R.addStyle("bottom",m.bottom);R.addStyle("left",b?m.end:m.begin);break;case"end":R.addClass("sapUiBorderLayoutEnd");R.addStyle("width",m.end);R.addStyle("top",m.top);R.addStyle("bottom",m.bottom);break;case"bottom":R.addClass("sapUiBorderLayoutBottom");R.addStyle("height",m.bottom);break;default:a("default branch must not be reached");break;}R.addStyle("overflow-x",e(o.getOverflowX()||""));R.addStyle("overflow-y",e(o.getOverflowY()||""));var d=o.getContentAlign();if(b){if(d==="right"){d="left";}else if(d==="left"){d="right";}}R.addStyle("text-align",e(d||""));R.writeClasses(o);R.writeStyles();R.write(">");for(var i=0;i<l;i++){R.renderControl(c[i]);}R.write("</div>");}
function $(A,b){var o=A.getParent().getArea(b);return o?o.$():q();}
return B;},true);
sap.ui.predefine('sap/ui/commons/layout/HorizontalLayout',['sap/ui/commons/library','sap/ui/layout/HorizontalLayout','./HorizontalLayoutRenderer'],function(l,L,H){"use strict";
var a=L.extend("sap.ui.commons.layout.HorizontalLayout",{metadata:{library:"sap.ui.commons"}});
return a;});
sap.ui.predefine('sap/ui/commons/layout/HorizontalLayoutRenderer',['sap/ui/core/Renderer','sap/ui/layout/HorizontalLayoutRenderer'],function(R,L){"use strict";var H=R.extend(L);return H;},true);
sap.ui.predefine('sap/ui/commons/layout/MatrixLayout',['sap/ui/thirdparty/jquery','./MatrixLayoutCell','./MatrixLayoutRow','sap/ui/commons/library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','./MatrixLayoutRenderer','sap/ui/commons/TextView'],function(q,M,a,l,C,E,b,T){"use strict";
var c=C.extend("sap.ui.commons.layout.MatrixLayout",{metadata:{library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},layoutFixed:{type:"boolean",group:"Appearance",defaultValue:true},columns:{type:"int",group:"Appearance",defaultValue:null},widths:{type:"sap.ui.core.CSSSize[]",group:"Appearance",defaultValue:null}},defaultAggregation:"rows",aggregations:{rows:{type:"sap.ui.commons.layout.MatrixLayoutRow",multiple:true,singularName:"row"}}}});
E.call(c.prototype,true,true);
c.prototype.createRow=function(){var r=new a();this.addRow(r);for(var i=0;i<arguments.length;i++){var o=arguments[i];var d;if(o instanceof M){d=o;}else if(o instanceof C){d=new M({content:o});}else if(o instanceof Object&&o.height){r.setHeight(o.height);}else{var t=o?o.toString():"";d=new M({content:new T({text:t})});}r.addCell(d);}return this;};
c.prototype.setWidths=function(w){var s;if(!Array.isArray(w)){s=q.makeArray(arguments);}else{s=w;}for(var i=0;i<s.length;i++){if(s[i]==""||!s[i]){s[i]="auto";}}this.setProperty("widths",s);return this;};
return c;});
sap.ui.predefine('sap/ui/commons/layout/MatrixLayoutCell',['sap/ui/commons/library','sap/ui/core/CustomStyleClassSupport','sap/ui/core/Element'],function(l,C,E){"use strict";
var M=E.extend("sap.ui.commons.layout.MatrixLayoutCell",{metadata:{library:"sap.ui.commons",aggregatingType:"MatrixLayoutRow",properties:{backgroundDesign:{type:"sap.ui.commons.layout.BackgroundDesign",defaultValue:'Transparent'},colSpan:{type:"int",defaultValue:1},hAlign:{type:"sap.ui.commons.layout.HAlign",defaultValue:'Begin'},padding:{type:"sap.ui.commons.layout.Padding",defaultValue:'End'},rowSpan:{type:"int",defaultValue:1},separation:{type:"sap.ui.commons.layout.Separation",defaultValue:'None'},vAlign:{type:"sap.ui.commons.layout.VAlign",defaultValue:'Middle'}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
C.apply(M.prototype);return M;});
sap.ui.predefine('sap/ui/commons/layout/MatrixLayoutRenderer',['sap/base/assert','sap/ui/Device','sap/ui/commons/library'],function(a,D,c){"use strict";var S=c.layout.Separation;var P=c.layout.Padding;var B=c.layout.BackgroundDesign;var V=c.layout.VAlign;var H=c.layout.HAlign;var M={};
M.render=function(r,m){var R=sap.ui.getCore().getConfiguration().getRTL();var i=0;var j=0;var b=0;var l=0;var o;var C;var d;var e;var f;var s;var v;var g;r.write("<table role=\"presentation\"");r.writeControlData(m);r.write(" cellpadding=\"0\" cellspacing=\"0\"");r.addStyle("border-collapse","collapse");var h=m.getWidth();if(h){r.addStyle("width",h);}var k=m.getHeight();if(k&&k!='auto'){r.addStyle("height",k);e=M.getValueUnit(k);}if(m.getLayoutFixed()){r.addStyle("table-layout","fixed");if(!h){r.addStyle("width","100%");}}r.addClass("sapUiMlt");r.writeStyles();r.writeClasses();if(m.getTooltip_AsString()){r.writeAttributeEscaped('title',m.getTooltip_AsString());}r.write('>');var n=m.getRows();var p=m.getColumns();if(p<1){for(i=0;i<n.length;i++){o=n[i];C=o.getCells();if(p<C.length){p=C.length;}}}if(p>0){var w=m.getWidths();r.write("<colgroup>");for(j=0;j<p;j++){r.write("<col");if(w&&w[j]&&w[j]!="auto"){r.addStyle('width',w[j]);r.writeStyles();}r.write(">");}r.write("</colgroup>");}var q=true;var t=false;r.write('<tbody style="width: 100%; height: 100%">');for(i=0;i<n.length;i++){o=n[i];var u=o.getHeight();if(u=="auto"){u="";}if(u&&e){f=M.getValueUnit(u);if(f.Unit=='%'&&e.Unit!='%'){u=(e.Value*f.Value/100)+e.Unit;}}r.write("<tr");r.writeElementData(o);r.writeClasses(o);if(o.getTooltip_AsString()){r.writeAttributeEscaped('title',o.getTooltip_AsString());}g=D.browser.edge||D.browser.msie&&D.browser.version>=9;if(g&&u){r.addStyle("height",u);r.writeStyles();}r.write(">");C=o.getCells();var y=p;if(p<1){y=C.length;}t=false;var z=0;if(!o.RowSpanCells){o.RowSpanCells=0;}else{t=true;}for(j=0;j<y;j++){if(j>=(y-z-o.RowSpanCells)){break;}var A=C[j];r.write("<td");if(u&&(!A||A.getRowSpan()==1)){r.addStyle("height",u);}if(A){r.writeElementData(A);if(A.getTooltip_AsString()){r.writeAttributeEscaped('title',A.getTooltip_AsString());}if(m.getLayoutFixed()&&A.getContent().length>0){r.addStyle("overflow","hidden");}var E=M.getHAlignClass(A.getHAlign(),R);if(E){r.addClass(E);}v=M.getVAlign(A.getVAlign());if(v){r.addStyle("vertical-align",v);}if(A.getColSpan()>1){r.writeAttribute("colspan",A.getColSpan());z=z+A.getColSpan()-1;t=true;}if(A.getRowSpan()>1){r.writeAttribute("rowspan",A.getRowSpan());var F=0;var U="";for(var x=0;x<A.getRowSpan();x++){var G=n[i+x];if(!G){U=false;break;}if(!G.RowSpanCells){G.RowSpanCells=0;}if(x>0){G.RowSpanCells=G.RowSpanCells+A.getColSpan();}var I=G.getHeight();if(!I||I=="auto"){U=false;}else{var J=M.getValueUnit(I);if(J.Unit=='%'&&e.Unit!='%'){J.Value=(e.Value*f.Value/100);J.Unit=e.Unit;}if(U==""){U=J.Unit;}else if(U!=J.Unit){U=false;}F=F+J.Value;}}if(U!=false){s=F+U;r.addStyle("height",s);}}r.addClass(M.getBackgroundClass(A.getBackgroundDesign()));r.addClass(M.getSeparationClass(A.getSeparation()));if(!m.getLayoutFixed()||!u){r.addClass(M.getPaddingClass(A.getPadding()));r.addClass("sapUiMltCell");}else{r.addStyle("white-space","nowrap");}r.writeClasses(A);}r.writeStyles();r.write(">");if(A){if(m.getLayoutFixed()&&u){r.write('<div');if(A.getRowSpan()!=1&&s&&s.search('%')==-1){r.addStyle("height",s);}else if(u.search('%')!=-1||(A.getRowSpan()!=1&&!s)){r.addStyle("height",'100%');}else{r.addStyle("height",u);}r.addStyle("display","inline-block");if(v){r.addStyle("vertical-align",v);}r.writeStyles();r.writeClasses(false);r.write("></div>");r.write('<div');r.addStyle("display","inline-block");if(v){r.addStyle("vertical-align",v);}if(A.getRowSpan()!=1&&s&&s.search('%')==-1){r.addStyle("max-height",s);}else if(u.search('%')!=-1||(A.getRowSpan()!=1&&!s)){r.addStyle("max-height",'100%');}else{r.addStyle("max-height",u);}var K="0";var L="";var N="0";d=A.getContent();for(b=0,l=d.length;b<l;b++){if(d[b].getHeight&&d[b].getHeight()!=""){var O=M.getValueUnit(d[b].getHeight());if(O){if(L==""){L=O.Unit;}if(L!=O.Unit){L="%";K="100";break;}if(O.Unit=="%"){if(parseFloat(K)<parseFloat(O.Value)){K=O.Value;if(K!="100"){N=10000/parseFloat(K);}}}}}}if(K!="0"){r.addStyle("height",K+L);}r.addStyle("white-space","normal");r.addStyle("width","100%");r.writeStyles();r.writeClasses(false);r.write("><div");r.addStyle("overflow","hidden");r.addStyle("text-overflow","inherit");if(K!="0"){if(N!="0"){r.addStyle("height",N+"%");}else{r.addStyle("height","100%");}}r.addClass("sapUiMltCell");r.addClass(M.getPaddingClass(A.getPadding()));r.writeStyles();r.writeClasses(false);r.write(">");}d=A.getContent();for(b=0,l=d.length;b<l;b++){r.renderControl(d[b]);}if(m.getLayoutFixed()&&u){r.write("</div></div>");}}r.write("</td>");}r.write("</tr>");o.RowSpanCells=undefined;if(!t){q=false;}}if(q&&D.browser.msie&&D.browser.version>=9){r.write("<tr style='height:0;'>");for(i=0;i<p;i++){r.write("<td></td>");}r.write("</tr>");}r.write("</tbody></table>");};
M.getHAlignClass=function(h,r){var C="sapUiMltCellHAlign";switch(h){case H.Begin:return null;case H.Center:return C+"Center";case H.End:return C+(r?"Left":"Right");case H.Left:return r?C+"Left":null;case H.Right:return r?null:C+"Right";default:a(false,"MatrixLayoutRenderer.getHAlign: oHAlign must be a known value");return null;}};
M.getVAlign=function(v){switch(v){case V.Bottom:return"bottom";case V.Middle:return"middle";case V.Top:return"top";default:a(false,"MatrixLayoutRenderer.getVAlign: oVAlign must be a known value");return null;}};
M.getBackgroundClass=function(b){switch(b){case B.Border:return"sapUiMltBgBorder";case B.Fill1:return"sapUiMltBgFill1";case B.Fill2:return"sapUiMltBgFill2";case B.Fill3:return"sapUiMltBgFill3";case B.Header:return"sapUiMltBgHeader";case B.Plain:return"sapUiMltBgPlain";case B.Transparent:return null;default:a(false,"MatrixLayoutRenderer.getBackgroundClass: oBackgroundDesign must be a known value");return null;}};
M.getPaddingClass=function(p){switch(p){case P.None:return"sapUiMltPadNone";case P.Begin:return"sapUiMltPadLeft";case P.End:return"sapUiMltPadRight";case P.Both:return"sapUiMltPadBoth";case P.Neither:return"sapUiMltPadNeither";default:a(false,"MatrixLayoutRenderer.getPaddingClass: oPadding must be a known value");return null;}};
M.getSeparationClass=function(s){switch(s){case S.None:return null;case S.Small:return"sapUiMltSepS";case S.SmallWithLine:return"sapUiMltSepSWL";case S.Medium:return"sapUiMltSepM";case S.MediumWithLine:return"sapUiMltSepMWL";case S.Large:return"sapUiMltSepL";case S.LargeWithLine:return"sapUiMltSepLWL";default:a(false,"MatrixLayoutRenderer.getSeparationClass: oSeparation must be a known value");return null;}};
M.getValueUnit=function(s){var v=0;var u="";var p=s.search('px');if(p>-1){u="px";v=parseInt(s.slice(0,p));return({Value:v,Unit:u});}p=s.search('pt');if(p>-1){u="pt";v=parseFloat(s.slice(0,p));return({Value:v,Unit:u});}p=s.search('in');if(p>-1){u="in";v=parseFloat(s.slice(0,p));return({Value:v,Unit:u});}p=s.search('mm');if(p>-1){u="mm";v=parseFloat(s.slice(0,p));return({Value:v,Unit:u});}p=s.search('cm');if(p>-1){u="cm";v=parseFloat(s.slice(0,p));return({Value:v,Unit:u});}p=s.search('em');if(p>-1){u="em";v=parseFloat(s.slice(0,p));return({Value:v,Unit:u});}p=s.search('ex');if(p>-1){u="ex";v=parseFloat(s.slice(0,p));return({Value:v,Unit:u});}p=s.search('%');if(p>-1){u="%";v=parseFloat(s.slice(0,p));return({Value:v,Unit:u});}};
return M;},true);
sap.ui.predefine('sap/ui/commons/layout/MatrixLayoutRow',['sap/ui/commons/library','sap/ui/core/CustomStyleClassSupport','sap/ui/core/Element'],function(l,C,E){"use strict";
var M=E.extend("sap.ui.commons.layout.MatrixLayoutRow",{metadata:{library:"sap.ui.commons",aggregatingType:"MatrixLayout",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null}},defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.commons.layout.MatrixLayoutCell",multiple:true,singularName:"cell"}}}});
C.apply(M.prototype);return M;});
sap.ui.predefine('sap/ui/commons/layout/PositionContainer',['sap/base/Log','sap/ui/commons/library','sap/ui/core/Element','sap/ui/core/ResizeHandler'],function(L,l,E,R){"use strict";
var P=E.extend("sap.ui.commons.layout.PositionContainer",{metadata:{library:"sap.ui.commons",properties:{top:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},bottom:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},left:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},right:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},centerHorizontally:{type:"boolean",group:"Dimension",defaultValue:false},centerVertically:{type:"boolean",group:"Dimension",defaultValue:false}},defaultAggregation:"control",aggregations:{control:{type:"sap.ui.core.Control",multiple:false}}}});
P.prototype.setControl=function(C){c(this);if(this.getDomRef()){this.setAggregation("control",C,true);n(this,C?"CTRL_CHANGE":"CTRL_REMOVE");}else{if(this.getParent()&&this.getParent().getDomRef()){this.setAggregation("control",C,true);if(C){n(this,"CTRL_ADD");}}else{this.setAggregation("control",C);}}if(C){C.attachEvent("_change",o,this);}return this;};
P.prototype.destroyControl=function(){c(this);var S=!!this.getDomRef();this.destroyAggregation("control",S);if(S){n(this,"CTRL_REMOVE");}return this;};
P.prototype.setTop=function(t){s(this,"top",t,true);return this;};
P.prototype.setBottom=function(B){s(this,"bottom",B,true);return this;};
P.prototype.setLeft=function(d){s(this,"left",d,true);return this;};
P.prototype.setRight=function(r){s(this,"right",r,true);return this;};
P.prototype.setCenterHorizontally=function(C){s(this,"centerHorizontally",C,true);return this;};
P.prototype.setCenterVertically=function(C){s(this,"centerVertically",C,true);return this;};
P.prototype.updatePosition=function(p){if(!p){p={};}s(this,"centerHorizontally",p.centerHorizontally?p.centerHorizontally:null);s(this,"centerVertically",p.centerVertically?p.centerVertically:null);s(this,"left",p.left?p.left:null);s(this,"right",p.right?p.right:null);s(this,"top",p.top?p.top:null);var N=s(this,"bottom",p.bottom?p.bottom:null);if(N){n(this,"CTRL_POS");}};
P.prototype.getComputedPosition=function(){var t=this.getTop();var B=this.getBottom();var d=this.getLeft();var r=this.getRight();var w=null;var h=null;var C=this.getControl();if(C){if(this.getCenterHorizontally()){d="50%";r=null;}else{if(!a(this,C,"width","left",d,"right",r)){r=undefined;}if(!d&&!r){d="0px";}}if(this.getCenterVertically()){t="50%";B=null;}else{if(!a(this,C,"height","top",t,"bottom",B)){B=undefined;}if(!t&&!B){t="0px";}}w=b(C,"width");h=b(C,"height");}return{top:t,bottom:B,left:d,right:r,width:w,height:h};};
P.createPosition=function(C,p){var d=new P();d.setControl(C);if(p){if(p.left){d.setLeft(p.left);}if(p.right){d.setRight(p.right);}if(p.top){d.setTop(p.top);}if(p.bottom){d.setBottom(p.bottom);}if(p.centerHorizontally){d.setCenterHorizontally(p.centerHorizontally);}if(p.centerVertically){d.setCenterVertically(p.centerVertically);}}return d;};
P.cleanUpControl=function(C){};
P.prototype.reinitializeEventHandlers=function(C){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(!C&&this.getDomRef()&&(this.getCenterHorizontally()||this.getCenterVertically())){var t=this;var d=function(){var r=t.$();if(t.getCenterHorizontally()){r.css("margin-left","-"+r.children().outerWidth()/2+"px");}if(t.getCenterVertically()){r.css("margin-top","-"+r.children().outerHeight()/2+"px");}};this._sResizeListenerId=R.register(this.getDomRef(),d);d();}};
P.prototype.exit=function(p){this.reinitializeEventHandlers(true);};
P.prototype.init=function(){this._disableWidthCheck=true;this._disableHeightCheck=false;};
var s=function(t,p,v,N){var S=!!t.getDomRef();t.setProperty(p,v,S);if(S&&N){n(t,"CTRL_POS");}return S;};var n=function(t,C){var d=t.getParent();if(d){d.contentChanged(t,C);}};var c=function(t){var C=t.getControl();if(C){P.cleanUpControl(C);C.detachEvent("_change",o,t);}};var a=function(p,C,d,e,v,f,V){if(v&&V){var h=p.getParent();var i=g(C,d);if(i){var j=C[i._sGetter]();if(!(!j||j==""||j=="auto"||j=="inherit")){L.warning("Position "+f+"="+V+" ignored, because child control "+C.getId()+" has fixed "+d+" ("+j+").","","AbsoluteLayout '"+(h?h.getId():"_undefined")+"'");return false;}}else{if((d==="width"&&!p._disableWidthCheck)||(d==="height"&&!p._disableHeightCheck)){L.warning("Position "+f+"="+V+" ignored, because child control "+C.getId()+" not resizable.","","AbsoluteLayout '"+(h?h.getId():"_undefined")+"'");return false;}}}return true;};var g=function(C,p){var d=C.getMetadata().getProperty(p);if(d&&d.type==='sap.ui.core.CSSSize'){return d;}return null;};var b=function(C,d){var p=g(C,d);if(p){var v=C[p._sGetter]();if(v&&v.endsWith("%")){return v;}}return null;};var o=function(e){var p=e.getParameter("name");var d=this.getParent();if((p==="width"||p==="height")&&d&&d.getDomRef()){n(this,"CTRL_POS");}};return P;});
sap.ui.predefine('sap/ui/commons/layout/ResponsiveFlowLayout',['sap/ui/commons/library','sap/ui/layout/ResponsiveFlowLayout','./ResponsiveFlowLayoutRenderer'],function(l,L,R){"use strict";
var a=L.extend("sap.ui.commons.layout.ResponsiveFlowLayout",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return a;});
sap.ui.predefine('sap/ui/commons/layout/ResponsiveFlowLayoutData',['sap/ui/commons/library','sap/ui/layout/ResponsiveFlowLayoutData'],function(l,L){"use strict";
var R=L.extend("sap.ui.commons.layout.ResponsiveFlowLayoutData",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return R;});
sap.ui.predefine('sap/ui/commons/layout/ResponsiveFlowLayoutRenderer',['sap/ui/core/Renderer','sap/ui/layout/ResponsiveFlowLayoutRenderer'],function(R,L){"use strict";var a=R.extend(L);return a;},true);
sap.ui.predefine('sap/ui/commons/layout/VerticalLayout',['sap/ui/commons/library','sap/ui/layout/VerticalLayout','./VerticalLayoutRenderer'],function(l,L,V){"use strict";
var a=L.extend("sap.ui.commons.layout.VerticalLayout",{metadata:{deprecated:true,library:"sap.ui.commons"}});
return a;});
sap.ui.predefine('sap/ui/commons/layout/VerticalLayoutRenderer',['sap/ui/core/Renderer','sap/ui/layout/VerticalLayoutRenderer'],function(R,L){"use strict";var V=R.extend(L);return V;},true);
sap.ui.predefine('sap/ui/commons/library',['sap/ui/base/DataType','sap/base/util/ObjectPath','sap/ui/core/library','sap/ui/layout/library','sap/ui/unified/library'],function(D,O){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.commons",version:"1.70.0",dependencies:["sap.ui.core","sap.ui.layout","sap.ui.unified"],types:["sap.ui.commons.ButtonStyle","sap.ui.commons.HorizontalDividerHeight","sap.ui.commons.HorizontalDividerType","sap.ui.commons.LabelDesign","sap.ui.commons.MenuBarDesign","sap.ui.commons.MessageType","sap.ui.commons.PaginatorEvent","sap.ui.commons.RatingIndicatorVisualMode","sap.ui.commons.RowRepeaterDesign","sap.ui.commons.SplitterSize","sap.ui.commons.TextViewColor","sap.ui.commons.TextViewDesign","sap.ui.commons.TitleLevel","sap.ui.commons.ToolbarDesign","sap.ui.commons.ToolbarSeparatorDesign","sap.ui.commons.TreeSelectionMode","sap.ui.commons.TriStateCheckBoxState","sap.ui.commons.enums.AreaDesign","sap.ui.commons.enums.BorderDesign","sap.ui.commons.enums.Orientation","sap.ui.commons.form.GridElementCells","sap.ui.commons.form.SimpleFormLayout","sap.ui.commons.layout.BackgroundDesign","sap.ui.commons.layout.BorderLayoutAreaTypes","sap.ui.commons.layout.HAlign","sap.ui.commons.layout.Padding","sap.ui.commons.layout.Separation","sap.ui.commons.layout.VAlign","sap.ui.commons.ColorPickerMode"],interfaces:["sap.ui.commons.FormattedTextViewControl","sap.ui.commons.ToolbarItem"],controls:["sap.ui.commons.Accordion","sap.ui.commons.ApplicationHeader","sap.ui.commons.AutoComplete","sap.ui.commons.Button","sap.ui.commons.Callout","sap.ui.commons.CalloutBase","sap.ui.commons.Carousel","sap.ui.commons.CheckBox","sap.ui.commons.ColorPicker","sap.ui.commons.ComboBox","sap.ui.commons.DatePicker","sap.ui.commons.Dialog","sap.ui.commons.DropdownBox","sap.ui.commons.FileUploader","sap.ui.commons.FormattedTextView","sap.ui.commons.HorizontalDivider","sap.ui.commons.Image","sap.ui.commons.ImageMap","sap.ui.commons.InPlaceEdit","sap.ui.commons.Label","sap.ui.commons.Link","sap.ui.commons.ListBox","sap.ui.commons.Menu","sap.ui.commons.MenuBar","sap.ui.commons.MenuButton","sap.ui.commons.Message","sap.ui.commons.MessageBar","sap.ui.commons.MessageList","sap.ui.commons.MessageToast","sap.ui.commons.Paginator","sap.ui.commons.Panel","sap.ui.commons.PasswordField","sap.ui.commons.ProgressIndicator","sap.ui.commons.RadioButton","sap.ui.commons.RadioButtonGroup","sap.ui.commons.RangeSlider","sap.ui.commons.RatingIndicator","sap.ui.commons.ResponsiveContainer","sap.ui.commons.RichTooltip","sap.ui.commons.RoadMap","sap.ui.commons.RowRepeater","sap.ui.commons.SearchField","sap.ui.commons.SegmentedButton","sap.ui.commons.Slider","sap.ui.commons.Splitter","sap.ui.commons.Tab","sap.ui.commons.TabStrip","sap.ui.commons.TextArea","sap.ui.commons.TextField","sap.ui.commons.TextView","sap.ui.commons.ToggleButton","sap.ui.commons.Toolbar","sap.ui.commons.Tree","sap.ui.commons.TriStateCheckBox","sap.ui.commons.ValueHelpField","sap.ui.commons.form.Form","sap.ui.commons.form.FormLayout","sap.ui.commons.form.GridLayout","sap.ui.commons.form.ResponsiveLayout","sap.ui.commons.form.SimpleForm","sap.ui.commons.layout.AbsoluteLayout","sap.ui.commons.layout.BorderLayout","sap.ui.commons.layout.HorizontalLayout","sap.ui.commons.layout.MatrixLayout","sap.ui.commons.layout.ResponsiveFlowLayout","sap.ui.commons.layout.VerticalLayout"],elements:["sap.ui.commons.AccordionSection","sap.ui.commons.Area","sap.ui.commons.FileUploaderParameter","sap.ui.commons.MenuItem","sap.ui.commons.MenuItemBase","sap.ui.commons.MenuTextFieldItem","sap.ui.commons.ResponsiveContainerRange","sap.ui.commons.RoadMapStep","sap.ui.commons.RowRepeaterFilter","sap.ui.commons.RowRepeaterSorter","sap.ui.commons.SearchProvider","sap.ui.commons.Title","sap.ui.commons.ToolbarSeparator","sap.ui.commons.TreeNode","sap.ui.commons.form.FormContainer","sap.ui.commons.form.FormElement","sap.ui.commons.form.GridContainerData","sap.ui.commons.form.GridElementData","sap.ui.commons.layout.BorderLayoutArea","sap.ui.commons.layout.MatrixLayoutCell","sap.ui.commons.layout.MatrixLayoutRow","sap.ui.commons.layout.PositionContainer","sap.ui.commons.layout.ResponsiveFlowLayoutData"]});sap.ui.commons.ButtonStyle={Emph:"Emph",Accept:"Accept",Reject:"Reject",Default:"Default"};sap.ui.commons.ColorPickerMode=sap.ui.unified.ColorPickerMode;sap.ui.commons.HorizontalDividerHeight={Ruleheight:"Ruleheight",Small:"Small",Medium:"Medium",Large:"Large"};sap.ui.commons.HorizontalDividerType={Area:"Area",Page:"Page"};sap.ui.commons.LabelDesign={Bold:"Bold",Standard:"Standard"};sap.ui.commons.MenuBarDesign={Standard:"Standard",Header:"Header"};sap.ui.commons.MessageType={Error:"Error",Warning:"Warning",Success:"Success"};sap.ui.commons.PaginatorEvent={First:"First",Previous:"Previous",Goto:"Goto",Next:"Next",Last:"Last"};sap.ui.commons.RatingIndicatorVisualMode={Full:"Full",Half:"Half",Continuous:"Continuous"};sap.ui.commons.RowRepeaterDesign={Standard:"Standard",Transparent:"Transparent",BareShell:"BareShell"};sap.ui.commons.SplitterSize=D.createType('sap.ui.commons.SplitterSize',{isValid:function(v){return/^((0*|([0-9]+|[0-9]*\.[0-9]+)([pP][xX]|%)))$/.test(v);}},D.getType('string'));sap.ui.commons.TextViewColor={Default:"Default",Positive:"Positive",Negative:"Negative",Critical:"Critical"};sap.ui.commons.TextViewDesign={Standard:"Standard",Bold:"Bold",H1:"H1",H2:"H2",H3:"H3",H4:"H4",H5:"H5",H6:"H6",Italic:"Italic",Small:"Small",Monospace:"Monospace",Underline:"Underline"};sap.ui.commons.TitleLevel=sap.ui.core.TitleLevel;sap.ui.commons.ToolbarDesign={Standard:"Standard",Transparent:"Transparent",Flat:"Flat"};sap.ui.commons.ToolbarSeparatorDesign={Standard:"Standard",FullHeight:"FullHeight"};sap.ui.commons.TreeSelectionMode={Multi:"Multi",Single:"Single",None:"None",Legacy:"Legacy"};sap.ui.commons.TriStateCheckBoxState={Unchecked:"Unchecked",Mixed:"Mixed",Checked:"Checked"};sap.ui.commons.enums=sap.ui.commons.enums||{};sap.ui.commons.enums.AreaDesign={Plain:"Plain",Fill:"Fill",Transparent:"Transparent"};sap.ui.commons.enums.BorderDesign={Box:"Box",None:"None"};sap.ui.commons.enums.Orientation={horizontal:"horizontal",vertical:"vertical"};sap.ui.commons.form=sap.ui.commons.form||{};sap.ui.commons.form.GridElementCells=sap.ui.layout.form.GridElementCells;sap.ui.commons.form.SimpleFormLayout=sap.ui.layout.form.SimpleFormLayout;sap.ui.commons.layout=sap.ui.commons.layout||{};sap.ui.commons.layout.BackgroundDesign={Border:"Border",Fill1:"Fill1",Fill2:"Fill2",Fill3:"Fill3",Header:"Header",Plain:"Plain",Transparent:"Transparent"};sap.ui.commons.layout.BorderLayoutAreaTypes={top:"top",begin:"begin",center:"center",end:"end",bottom:"bottom"};sap.ui.commons.layout.HAlign={Begin:"Begin",Center:"Center",End:"End",Left:"Left",Right:"Right"};sap.ui.commons.layout.Padding={None:"None",Begin:"Begin",End:"End",Both:"Both",Neither:"Neither"};sap.ui.commons.layout.Separation={None:"None",Small:"Small",SmallWithLine:"SmallWithLine",Medium:"Medium",MediumWithLine:"MediumWithLine",Large:"Large",LargeWithLine:"LargeWithLine"};sap.ui.commons.layout.VAlign={Bottom:"Bottom",Middle:"Middle",Top:"Top"};sap.ui.lazyRequire("sap.ui.commons.MessageBox","alert confirm show");sap.ui.lazyRequire("sap.ui.commons.MenuItemBase","new extend getMetadata");sap.ui.commons.Orientation={"Vertical":sap.ui.core.Orientation.Vertical,"Horizontal":sap.ui.core.Orientation.Horizontal,"vertical":sap.ui.core.Orientation.Vertical,"horizontal":sap.ui.core.Orientation.Horizontal};if(!sap.ui.unified.ColorPickerHelper||!sap.ui.unified.ColorPickerHelper.bFinal){sap.ui.unified.ColorPickerHelper={isResponsive:function(){return false;},factory:{createLabel:function(c){return new sap.ui.commons.Label(c);},createInput:function(i,c){return new sap.ui.commons.TextField(i,c);},createSlider:function(i,c){if(c&&c.step){c.smallStepWidth=c.step;delete c.step;}return new sap.ui.commons.Slider(i,c);},createRadioButtonGroup:function(c){if(c&&c.buttons){c.items=c.buttons;delete c.buttons;}return new sap.ui.commons.RadioButtonGroup(c);},createRadioButtonItem:function(c){return new sap.ui.core.Item(c);}},bFinal:false};}if(!sap.ui.layout.form.FormHelper||!sap.ui.layout.form.FormHelper.bFinal){sap.ui.layout.form.FormHelper={createLabel:function(T,i){return new sap.ui.commons.Label(i,{text:T});},createButton:function(i,p,c){var a=this;var _=function(B){var o=new B(i,{lite:true});o.attachEvent('press',p,a);c.call(a,o);};var b=sap.ui.require("sap/ui/commons/Button");if(b){_(b);}else{sap.ui.require(["sap/ui/commons/Button"],_);}},setButtonContent:function(b,T,s,i,I){b.setText(T);b.setTooltip(s);b.setIcon(i);b.setIconHovered(I);},addFormClass:function(){return null;},setToolbar:function(T){return T;},bArrowKeySupport:true,bFinal:false};}if(!sap.ui.unified.FileUploaderHelper||!sap.ui.unified.FileUploaderHelper.bFinal){sap.ui.unified.FileUploaderHelper={createTextField:function(i){var T=new sap.ui.commons.TextField(i);return T;},setTextFieldContent:function(T,w){T.setWidth(w);},createButton:function(){var b=new sap.ui.commons.Button();return b;},addFormClass:function(){return"sapUiCFUM";},bFinal:false};}var t=O.get("sap.ui.table.TableHelper");if(!t||!t.bFinal){O.set("sap.ui.table.TableHelper",{createLabel:function(c){return new sap.ui.commons.Label(c);},createTextView:function(c){if(c&&!c.wrapping){c.wrapping=false;}return new sap.ui.commons.TextView(c);},addTableClass:function(){return"sapUiTableCommons";},bFinal:false});}if(!sap.ui.layout.GridHelper||!sap.ui.layout.GridHelper.bFinal){sap.ui.layout.GridHelper={getLibrarySpecificClass:function(){return"sapUiRespGridOverflowHidden";},bFinal:false};}return sap.ui.commons;});
sap.ui.predefine('sap/ui/commons/Carousel',['sap/ui/thirdparty/jquery','sap/base/Log','sap/base/strings/capitalize','sap/ui/dom/containsOrEquals','./library','sap/ui/core/Control','sap/ui/core/ResizeHandler','sap/ui/core/delegate/ItemNavigation','./CarouselRenderer','sap/ui/Device','sap/ui/events/KeyCodes',"sap/ui/dom/jquery/Selectors","sap/ui/dom/jquery/Focusable"],function(q,L,c,a,b,C,R,I,d,D,K){"use strict";var O=b.enums.Orientation;
var f=C.extend("sap.ui.commons.Carousel",{metadata:{library:"sap.ui.commons",properties:{orientation:{type:"sap.ui.commons.enums.Orientation",group:"Misc",defaultValue:O.horizontal},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},defaultItemHeight:{type:"int",group:"Misc",defaultValue:150},defaultItemWidth:{type:"int",group:"Misc",defaultValue:150},animationDuration:{type:"int",group:"Misc",defaultValue:500},visibleItems:{type:"int",group:"Misc",defaultValue:null},handleSize:{type:"int",group:"Misc",defaultValue:22},firstVisibleIndex:{type:"int",group:"Appearance",defaultValue:0}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}}});
f.prototype.init=function(){this._visibleItems=0;this.data("sap-ui-fastnavgroup","true",true);};
f.prototype.exit=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}this._destroyItemNavigation();};
f.prototype.onclick=function(e){switch(e.target){case this.getDomRef('prevbutton'):this.showPrevious();break;case this.getDomRef('nextbutton'):this.showNext();break;default:return;}};
f.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
f.prototype.onAfterRendering=function(){if(this.getOrientation()=="vertical"){this._sAnimationAttribute='margin-top';}else{if(sap.ui.getCore().getConfiguration().getRTL()){this._sAnimationAttribute='margin-right';}else{this._sAnimationAttribute='margin-left';}}this.showElementWithId(this._getItemIdByIndex(this.getFirstVisibleIndex()));this.calculateAndSetSize();this.oDomRef=this.getDomRef();this.sResizeListenerId=R.register(this.oDomRef,q.proxy(this.onresize,this));this._initItemNavigation();};
f.prototype._initItemNavigation=function(){var $=this.$("scrolllist");if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.AfterFocus,function(e){var g=this.$("contentarea"),s=this.$("scrolllist");var o=e.getParameter("event");if(o&&o.type=="mousedown"){var h=false;for(var i=0;i<s.children().length;i++){var j=s.children()[i];if(o.target.id==j.id){h=true;break;}}if(!h){o.target.focus();}}if(sap.ui.getCore().getConfiguration().getRTL()){g.scrollLeft(s.width()-g.width());}else{g.scrollLeft(0);}},this);}this._oItemNavigation.setRootDomRef($[0]);this._oItemNavigation.setItemDomRefs($.children());};
f.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this._oItemNavigation.destroy();this._oItemNavigation=undefined;}};
f.prototype.onThemeChanged=function(e){this.calculateAndSetSize();};
f.prototype.onfocusin=function(e){var $=q(e.target);if(!this._bIgnoreFocusIn&&($.hasClass("sapUiCrslBefore")||$.hasClass("sapUiCrslAfter"))){this._leaveActionMode();q(this._oItemNavigation.getFocusedDomRef()||this._oItemNavigation.getRootDomRef()).focus();}};
f.prototype.onsaptabnext=function(e){var $=this.$();if(this._bActionMode){if($.find(".sapUiCrslScl").lastFocusableDomRef()===e.target){$.find(".sapUiCrslScl").firstFocusableDomRef().focus();e.preventDefault();e.stopPropagation();}}else{if(this._oItemNavigation.getFocusedDomRef()===e.target){this._bIgnoreFocusIn=true;$.find(".sapUiCrslAfter").focus();this._bIgnoreFocusIn=false;}}};
f.prototype.onsaptabprevious=function(e){var $=this.$();if(this._bActionMode){if($.find(".sapUiCrslScl").firstFocusableDomRef()===e.target){$.find(".sapUiCrslScl").lastFocusableDomRef().focus();e.preventDefault();e.stopPropagation();}}else{if(this._oItemNavigation.getFocusedDomRef()===e.target&&a($.find(".sapUiCrslScl").get(0),e.target)){this._bIgnoreFocusIn=true;$.find(".sapUiCrslBefore").focus();this._bIgnoreFocusIn=false;}}};
f.prototype.onsapescape=function(e){this._leaveActionMode(e);};
f.prototype.onsapnext=function(e){var $=q(e.target);var s=this.$("scrolllist");s.stop(true,true);if($.hasClass('sapUiCrslItm')&&$.nextAll(':visible').length<2){this.showNext();e.preventDefault();}};
f.prototype.onsapprevious=function(e){var $=q(e.target);var s=this.$("scrolllist");s.stop(true,true);if($.hasClass('sapUiCrslItm')&&$.prevAll(':visible').length<2){this.showPrevious();e.preventDefault();}};
f.prototype.onkeydown=function(e){var $=this.$();if(!this._bActionMode&&e.keyCode==K.F2||e.keyCode==K.ENTER){if($.find(".sapUiCrslScl li:focus").length>0){this._enterActionMode($.find(".sapUiCrslScl li:focus :sapFocusable").get(0));e.preventDefault();e.stopPropagation();}}else if(this._bActionMode&&e.keyCode==K.F2){this._leaveActionMode(e);}};
f.prototype.onmouseup=function(e){if(this.$().find(".sapUiCrslScl li :focus").length>0){this._enterActionMode(this.$().find(".sapUiCrslScl li :focus").get(0));}else{this._leaveActionMode(e);}};
if(D.support.touch){f.prototype.onswipeleft=function(e){this.showNext();};f.prototype.onswiperight=function(e){this.showPrevious();};}
f.prototype._enterActionMode=function(o){if(o&&!this._bActionMode){this._bActionMode=true;this.removeDelegate(this._oItemNavigation);q(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","-1");this.$("scrolllist").attr("aria-activedescendant",q(this._oItemNavigation.getFocusedDomRef()).attr("id"));q(o).focus();}};
f.prototype._leaveActionMode=function(e){if(this._bActionMode){this._bActionMode=false;this.addDelegate(this._oItemNavigation);q(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","0");this.$("scrolllist").removeAttr("aria-activedescendant");if(e){if(q(e.target).closest("li[tabindex=-1]").length>0){var i=q(this._oItemNavigation.aItemDomRefs).index(q(e.target).closest("li[tabindex=-1]").get(0));this._oItemNavigation.focusItem(i,null);}else{if(a(this.$().find(".sapUiCrslScl").get(0),e.target)){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null);}}}else{this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null);}}};
f.prototype.onresize=function(e){if(!this.getDomRef()){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}return;}this.calculateAndSetSize();};
f.prototype.showPrevious=function(){var t=this,A={},s=this.$("scrolllist");var $,e;A[this._sAnimationAttribute]=0;if(s.children('li').length<2){return;}s.stop(true,true);s.css(this._sAnimationAttribute,-this._iMaxWidth);$=s.children('li:last');e=s.children('li:first');this._showAllItems();$.insertBefore(e);s.append($.sapExtendedClone(true));s.animate(A,this.getAnimationDuration(),function(){s.children('li:last').remove();t.setProperty("firstVisibleIndex",t._getContentIndex(s.children('li:first').attr('id')),true);t._hideInvisibleItems();});};
f.prototype.showNext=function(){var t=this,A={},s=this._sAnimationAttribute,S=this.$("scrolllist");var $;A[this._sAnimationAttribute]=-this._iMaxWidth;if(S.children('li').length<2){return;}S.stop(true,true);this._showAllItems();$=S.children('li:first');$.appendTo(S);$.sapExtendedClone(true).insertBefore(S.children('li:first'));S.animate(A,this.getAnimationDuration(),function(){S.children('li:first').remove();q(this).css(s,'0px');t.setProperty("firstVisibleIndex",t._getContentIndex(S.children('li:first').attr('id')),true);t._hideInvisibleItems();});};
f.prototype.showElementWithId=function(e){this._showAllItems();var s=this.$("scrolllist"),i;i=s.children('li').index(this.getDomRef("item-"+e));s.children('li:lt('+i+')').appendTo(s);this._hideInvisibleItems();};
f.prototype.calculateAndSetSize=function(){var o=this._getDimensions();var m=o.maxWidth;var e=o.maxHeight;var g;var v=this.getVisibleItems();var M=this.$();var n=this.$('nextbutton');var p=this.$('prevbutton');var $=this.$('contentarea');this._showAllItems();if(this.getContent().length<=0){return;}if(this.getWidth()&&this.getOrientation()=="vertical"){m=M.width();}if(this.getHeight()&&this.getOrientation()=="horizontal"){e=M.height();}this.$().addClass('sapUiCrsl'+c(this.getOrientation()));if(this.getOrientation()=="horizontal"){g=M.width()-this.getHandleSize()*2-1;$.css('left',this.getHandleSize()+"px").css('right',this.getHandleSize()+"px");if(v==0){v=Math.floor(g/m);}m=g/v;this._iMaxWidth=m;var h=e+"px";$.find('.sapUiCrslItm').css("width",m+"px").css("height",e+"px").css("display","inline-block");p.css("height",e).css("line-height",h);n.css("height",e).css("line-height",h);$.height(e);M.height(e);var V=this.getContent().length<v?this.getContent().length:v;if(this.getWidth()){M.width(this.getWidth());}else{var i=M.width()-(m*V+(this.getHandleSize()*2-1));if(i>5){M.width(m*V+(this.getHandleSize()*2-1));}}}else{g=M.height()-this.getHandleSize()*2-1;$.css('top',this.getHandleSize()+"px").css('bottom',this.getHandleSize()+"px");if(v==0){v=Math.floor(g/e);}e=g/v;this._iMaxWidth=e;$.find('.sapUiCrslItm').css("width",m+"px").css("height",e+"px").css("display","block");p.width(m).after($);n.width(m);$.width(m);M.width(m);}this._visibleItems=v;this._hideInvisibleItems();};
f.prototype._getDimensions=function(){var g=this.getContent();var m=0;var h=0;for(var i=0;i<g.length;i++){var j,k;try{j=g[i].getWidth();if(j.substr(-1)=="%"){j=this.getDefaultItemWidth();}}catch(e){j=this.getDefaultItemWidth();}try{k=g[i].getHeight();if(k.substr(-1)=="%"){k=this.getDefaultItemHeight();}}catch(e){k=this.getDefaultItemHeight();}m=Math.max(m,parseInt(j));h=Math.max(h,parseInt(k));}if(m==0||isNaN(m)){m=this.getDefaultItemWidth();}if(h==0||isNaN(h)){h=this.getDefaultItemHeight();}return{maxWidth:m,maxHeight:h};};
f.prototype.getFocusDomRef=function(){return this.$("scrolllist");};
f.prototype._showAllItems=function(){var $=this.$("contentarea");$.find('.sapUiCrslItm').show().css("display","inline-block");};
f.prototype._hideInvisibleItems=function(){var $=this.$("contentarea");$.find('.sapUiCrslItm:gt('+(this._visibleItems-1)+')').hide();};
f.prototype._getContentIndex=function(i){var e=i.split("-item-");return q.inArray(sap.ui.getCore().byId(e[1]),this.getContent());};
f.prototype._getItemIdByIndex=function(i){var o=this.getContent()[i];if(!o){return null;}return o.getId();};
f.prototype.setFirstVisibleIndex=function(F){if(F>this.getContent().length-1){L.warning("The index is invalid. There are less items available in the carousel.");return this;}this.setProperty("firstVisibleIndex",F,true);this.showElementWithId(this._getItemIdByIndex(F));if(this._oItemNavigation){this._oItemNavigation.focusItem(F);}return this;};
//Licensed under the terms of the MIT source code license

(function(o){
q.fn.sapExtendedClone=function(){var r=o.apply(this,arguments);var m=this.find('textarea').add(this.filter('textarea'));var e=r.find('textarea').add(r.filter('textarea'));var g=this.find('select').add(this.filter('select'));var h=r.find('select').add(r.filter('select'));for(var i=0,l=m.length;i<l;++i){q(e[i]).val(q(m[i]).val());}for(var i=0,l=g.length;i<l;++i){h[i].selectedIndex=g[i].selectedIndex;}return r;};
})(q.fn.clone);return f;});
sap.ui.require.preload({
	"sap/ui/commons/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.commons","type":"library","embeds":[],"applicationVersion":{"version":"1.70.0"},"title":"Common basic controls, mainly intended for desktop scenarios","description":"Common basic controls, mainly intended for desktop scenarios","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.70","libs":{"sap.ui.core":{"minVersion":"1.70.0"},"sap.ui.layout":{"minVersion":"1.70.0"},"sap.ui.unified":{"minVersion":"1.70.0"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.ui.commons.Accordion","sap.ui.commons.ApplicationHeader","sap.ui.commons.AutoComplete","sap.ui.commons.Button","sap.ui.commons.Callout","sap.ui.commons.CalloutBase","sap.ui.commons.Carousel","sap.ui.commons.CheckBox","sap.ui.commons.ColorPicker","sap.ui.commons.ComboBox","sap.ui.commons.DatePicker","sap.ui.commons.Dialog","sap.ui.commons.DropdownBox","sap.ui.commons.FileUploader","sap.ui.commons.FormattedTextView","sap.ui.commons.HorizontalDivider","sap.ui.commons.Image","sap.ui.commons.ImageMap","sap.ui.commons.InPlaceEdit","sap.ui.commons.Label","sap.ui.commons.Link","sap.ui.commons.ListBox","sap.ui.commons.Menu","sap.ui.commons.MenuBar","sap.ui.commons.MenuButton","sap.ui.commons.Message","sap.ui.commons.MessageBar","sap.ui.commons.MessageList","sap.ui.commons.MessageToast","sap.ui.commons.Paginator","sap.ui.commons.Panel","sap.ui.commons.PasswordField","sap.ui.commons.ProgressIndicator","sap.ui.commons.RadioButton","sap.ui.commons.RadioButtonGroup","sap.ui.commons.RangeSlider","sap.ui.commons.RatingIndicator","sap.ui.commons.ResponsiveContainer","sap.ui.commons.RichTooltip","sap.ui.commons.RoadMap","sap.ui.commons.RowRepeater","sap.ui.commons.SearchField","sap.ui.commons.SegmentedButton","sap.ui.commons.Slider","sap.ui.commons.Splitter","sap.ui.commons.Tab","sap.ui.commons.TabStrip","sap.ui.commons.TextArea","sap.ui.commons.TextField","sap.ui.commons.TextView","sap.ui.commons.ToggleButton","sap.ui.commons.Toolbar","sap.ui.commons.Tree","sap.ui.commons.TriStateCheckBox","sap.ui.commons.ValueHelpField","sap.ui.commons.form.Form","sap.ui.commons.form.FormLayout","sap.ui.commons.form.GridLayout","sap.ui.commons.form.ResponsiveLayout","sap.ui.commons.form.SimpleForm","sap.ui.commons.layout.AbsoluteLayout","sap.ui.commons.layout.BorderLayout","sap.ui.commons.layout.HorizontalLayout","sap.ui.commons.layout.MatrixLayout","sap.ui.commons.layout.ResponsiveFlowLayout","sap.ui.commons.layout.VerticalLayout"],"elements":["sap.ui.commons.AccordionSection","sap.ui.commons.Area","sap.ui.commons.FileUploaderParameter","sap.ui.commons.MenuItem","sap.ui.commons.MenuItemBase","sap.ui.commons.MenuTextFieldItem","sap.ui.commons.ResponsiveContainerRange","sap.ui.commons.RoadMapStep","sap.ui.commons.RowRepeaterFilter","sap.ui.commons.RowRepeaterSorter","sap.ui.commons.SearchProvider","sap.ui.commons.Title","sap.ui.commons.ToolbarSeparator","sap.ui.commons.TreeNode","sap.ui.commons.form.FormContainer","sap.ui.commons.form.FormElement","sap.ui.commons.form.GridContainerData","sap.ui.commons.form.GridElementData","sap.ui.commons.layout.BorderLayoutArea","sap.ui.commons.layout.MatrixLayoutCell","sap.ui.commons.layout.MatrixLayoutRow","sap.ui.commons.layout.PositionContainer","sap.ui.commons.layout.ResponsiveFlowLayoutData"],"types":["sap.ui.commons.ButtonStyle","sap.ui.commons.HorizontalDividerHeight","sap.ui.commons.HorizontalDividerType","sap.ui.commons.LabelDesign","sap.ui.commons.MenuBarDesign","sap.ui.commons.MessageType","sap.ui.commons.PaginatorEvent","sap.ui.commons.RatingIndicatorVisualMode","sap.ui.commons.RowRepeaterDesign","sap.ui.commons.SplitterSize","sap.ui.commons.TextViewColor","sap.ui.commons.TextViewDesign","sap.ui.commons.TitleLevel","sap.ui.commons.ToolbarDesign","sap.ui.commons.ToolbarSeparatorDesign","sap.ui.commons.TreeSelectionMode","sap.ui.commons.TriStateCheckBoxState","sap.ui.commons.enums.AreaDesign","sap.ui.commons.enums.BorderDesign","sap.ui.commons.enums.Orientation","sap.ui.commons.form.GridElementCells","sap.ui.commons.form.SimpleFormLayout","sap.ui.commons.layout.BackgroundDesign","sap.ui.commons.layout.BorderLayoutAreaTypes","sap.ui.commons.layout.HAlign","sap.ui.commons.layout.Padding","sap.ui.commons.layout.Separation","sap.ui.commons.layout.VAlign","sap.ui.commons.ColorPickerMode"],"interfaces":["sap.ui.commons.FormattedTextViewControl","sap.ui.commons.ToolbarItem"]}}}}'
},"sap/ui/commons/library-preload"
);
//# sourceMappingURL=library-preload.js.map