/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject','sap/ui/core/IconPool','sap/m/library','sap/m/Popover','sap/m/Text','sap/ui/layout/form/SimpleForm','sap/m/Button','sap/m/Label','sap/m/Link','sap/ui/core/HTML','sap/ui/core/Title',"sap/ui/thirdparty/jquery"],function(M,I,m,P,T,S,B,L,a,H,b,q){'use strict';var c=m.PlacementType;var d=M.extend("sap.ui.core.support.controls.InteractionTree",{constructor:function(){this.start=0;this.end=1;}});d.expandIcon='sap-icon://navigation-right-arrow';d.collapseIcon='sap-icon://navigation-down-arrow';d.headerIcon='<img class="sapUiInteractionSvgImage" src="HeaderIcon.svg">';d.prototype.setInteractions=function(i){this.interactions=i;this.start=0;this.end=1;this.updateRanges();};d.prototype.setRange=function(s,e){this.start=s;this.end=e;this.updateRanges();this.update();};d.prototype.updateRanges=function(){var i=this.interactions;if(!i||!i.length){return;}this.startTime=i[0].start;this.endTime=i[i.length-1].end;var r=this.endTime-this.startTime;this.actualStartTime=this.startTime+this.start*r;this.actualEndTime=this.startTime+this.end*r;this.timeRange=this.actualEndTime-this.actualStartTime;};d.prototype.update=function(){if(!this.parent){return;}q(this.parent).find('#'+this.getId()).remove();this.renderAt(this.parent);};d.prototype.renderAt=function(p){this.parent=p;var r=sap.ui.getCore().createRenderManager();this.render(r);r.flush(p);r.destroy();this.attachEvents();this.attachInteractionDetailsPopover();this.attachRequestDetailsPopover();};d.prototype.render=function(r){r.write('<div id="'+this.getId()+'" class="sapUiInteractionTreeContainer sapUiSizeCompact">');r.write('<div class="sapUiInteractionGridLinesContainer"></div>');r.write('<ul');r.addClass("sapUiInteractionTree");r.writeClasses();r.write(">");this.renderHeaders(r);var e,f=this.interactions;if(!f||!f.length){return;}for(var i=0;i<f.length;i++){e=f[i];this.renderInteraction(r,e,i);}r.write("</ul>");r.write("</div>");};d.prototype.attachEvents=function(){var t=this,i=q('.sapUiInteractionTreeContainer .sapUiInteractionTree');this.gridContainer=q('.sapUiInteractionTreeContainer .sapUiInteractionGridLinesContainer');this.gridContainerWidth=0;i.bind('click',function(e){var $=q(e.target);if($.hasClass('sapUiInteractionLeft')){t.handleInteractionClick($);}});this.gridContainer.resize(function(e){t.updateGridLines();});q(window).resize(function(e){t.updateGridLines();});t.updateGridLines();};d.prototype.updateGridLines=function(){var g=this.gridContainer,r=this.timeRange,w=this.gridContainer.width();if(this.gridContainerWidth==w){return;}g.empty();g.append('<div style="left:'+(this.getPosition(w,r,0)+6)+'px" class="sapUiInteractionGridLineIntervalText">'+this.formatGridLineDuration(0)+'</div>');var e=this.calculateInterval(w,r);for(var i=e;i<r;i+=e){var p=this.getPosition(w,r,i);if(i+e<r){g.append('<div style="left:'+(p+6)+'px" class="sapUiInteractionGridLineIntervalText">'+this.formatGridLineDuration(i)+'</div>');}g.append('<div style="left:'+p+'px" class="sapUiInteractionGridLine"></div>');}this.gridContainerWidth=w;};d.prototype.calculateInterval=function(w,r){var e=4;var f=Math.max(w*e/200.0,1.0);var g=r/f;var h=Math.pow(10,Math.floor(Math.log(g)/Math.LN10));var j=[10,5,2,1];for(var i=0;i<j.length;i++){var k=j[i];var l=h*k;if(f<(r/l)){break;}g=l;}return g;};d.prototype.getPosition=function(w,r,v){var p=w/r*v;return p;};d.prototype.handleInteractionClick=function($){var e=$.find('.sapUiInteractionTreeIcon');if(!e.length){return;}var f=e.attr('expanded')=='true';var g=e.parent();e.remove();var i=this.getIconHTML(!f);g.children().eq(0).after(i);var h=g.parent().parent();h.toggleClass('sapUiInteractionItemExpanded');var j=parseInt(h.attr('data-interaction-index'));this.interactions[j].isExpanded=!f;var k=h.find('ul');var l=f?'slideUp':'slideDown';k.stop(true,true)[l]('fast',function(){k.toggleClass('sapUiHiddenUiInteractionItems');});};d.prototype.renderHeaders=function(r){r.write('<li>');r.write('<div');r.addClass("sapUiInteractionTreeItem");r.addClass("sapUiInteractionItemDiv");r.addClass("sapUiInteractionHeader");r.writeClasses();r.write(">");r.write('<div class="sapUiInteractionTreeItemLeft">');r.write("<div>");r.write('<span class="sapUiInteractionItemComponentText">');r.writeEscaped('Component');r.write('</span>');r.write("<br/>");r.write('<span class="sapUiInteractionItemTriggerText">');r.writeEscaped('Trigger');r.write('</span>');r.write("</div>");r.write('</div>');r.write('<div class="sapUiInteractionTreeItemRight">');r.write('</div>');r.write("</div>");r.write("</li>");};d.prototype.isInteractionVisible=function(i){var s=i.start;var e=i.end;if(this.actualStartTime>e||this.actualEndTime<s){return false;}if(this.actualStartTime<s+i.duration&&this.actualEndTime>s){return true;}return this.hasVisibleRequests(i);};d.prototype.hasVisibleRequests=function(e){var r,s,f,g=e.requests;for(var i=0;i<g.length;i++){r=g[i];s=r.fetchStartOffset+r.startTime;f=r.fetchStartOffset+r.startTime+this.getRequestDuration(r);if(this.actualStartTime<f&&this.actualEndTime>s){return true;}}return false;};d.prototype.renderInteraction=function(r,e,f){var g,h=e.requests;if(!this.isInteractionVisible(e)){return;}r.write('<li data-interaction-index="'+f+'"');if(e.isExpanded){r.addClass('sapUiInteractionItemExpanded');r.writeClasses();}r.write('>');this.renderInteractionDiv(r,e);r.write("<ul");r.addClass("sapUiInteractionItem");if(!e.isExpanded){r.addClass("sapUiHiddenUiInteractionItems");}r.writeClasses();r.write(">");for(var i=0;i<h.length;i++){g=h[i];this.renderRequest(r,e,g,i);}r.write("</ul>");r.write("</li>");};d.prototype.renderInteractionDiv=function(r,i){r.write('<div');r.addClass("sapUiInteractionTreeItem");r.addClass("sapUiInteractionItemDiv");r.writeClasses();r.write(">");r.write('<div class="sapUiInteractionLeft sapUiInteractionTreeItemLeft">');r.write("<div>");r.write('<span class="sapUiInteractionItemComponentText">');r.writeEscaped((i.component!=="undetermined")?i.component:'Initial Loading');r.write('</span>');r.write("<br/>");r.write('<span class="sapUiInteractionItemTriggerText">');r.writeEscaped(i.trigger+" / "+i.event);r.write('</span>');r.write("</div>");if(i.requests.length){this.renderIcon(r,i.isExpanded);}if(i.sapStatistics.length&&i.requests.length){r.write('<div class="sapUiInteractionHeaderIcon">'+d.headerIcon+'</div>');}r.write('</div>');r.write('<div class="sapUiInteractionTreeItemRight">');var e=Math.round(i.start+i.duration);this.renderInteractionPart(r,i.start,e,'sapUiInteractionBlue');r.write('</div>');r.write("</div>");};d.prototype.renderInteractionPart=function(r,s,e,f){if(this.actualStartTime>e||this.actualEndTime<s){return;}e=Math.min(e,this.actualEndTime);s=Math.max(s,this.actualStartTime);var l=100/this.timeRange*(s-this.actualStartTime);var g=100/this.timeRange*(e-this.actualStartTime);var w=g-l;r.write('<span style="margin-left: '+l+'%; width: '+w+'%" class="sapUiInteractionTimeframe sapUiInteractionTimeInteractionFrame '+f+'"></span>');};d.prototype.renderRequest=function(r,i,e,f){var g=e.fetchStartOffset;var s=g+e.startTime;var h=g+e.startTime+this.getRequestDuration(e);if(this.actualStartTime>h||this.actualEndTime<s){return;}r.write('<li data-request-index="'+f+'"');r.addClass("sapUiInteractionTreeItem");r.addClass("sapUiInteractionRequest");r.writeClasses();r.write(">");r.write('<div class="sapUiInteractionTreeItemLeft sapUiInteractionRequestLeft">');var j=e.initiatorType||e.entryType;var k=this.getRequestColorClass(j);r.write('<span class="sapUiInteractionRequestIcon '+k+'"></span>');r.write('<span class="sapUiInteractionItemEntryTypeText">');r.writeEscaped(j);r.write('</span>');if(this.getRequestSapStatistics(i,e)){r.write('<div class="sapUiInteractionRequestHeaderIcon">'+d.headerIcon+'</div>');}r.write('</div>');r.write('<div class="sapUiInteractionTreeItemRight"');r.write('>');var l=this.getRequestRequestStart(e)+g;var n=this.getRequestResponseStart(e)+g;this.renderRequestPart(r,s,l,k+'70');this.renderRequestPart(r,l,n,k);this.renderRequestPart(r,n,h,k+'70');r.write('</div>');r.write("</li>");};d.prototype.getRequestSapStatistics=function(i,r){var s,e=i.sapStatistics;for(var j=0;j<e.length;j++){if(e[j].timing&&r.startTime===e[j].timing.startTime){s=e[j];return s;}}return false;};d.prototype.getRequestColorClass=function(r){var e;switch(r){case'xmlhttprequest':e='sapUiPurple';break;case'OData':e='sapUiRed';break;case'link':case'css':e='sapUiAccent1';break;default:e='sapUiAccent8';break;}return e;};d.prototype.attachRequestDetailsPopover=function(){var s,e,p,f,g,h,n,j,k,l,o,t,r,u,v,w,x;var y=this;var z=q('.sapUiInteractionRequest.sapUiInteractionTreeItem .sapUiInteractionTreeItemRight');if(z.length){var A=F();for(var i=0;i<z.length;i++){z[i].addEventListener('click',function(J){E.call(this);D.call(this);C.call(this);var K=q(this).children()[0];A.openBy(K);});}}function C(){var $=q(this);var J=$.parents('li[data-request-index]');var K=$.parents('li[data-interaction-index]');var N=parseInt(K.attr('data-interaction-index'));var O=parseInt(J.attr('data-request-index'));var Q=y.interactions[N];var R=Q.requests[O];if(!Q||!R){return;}var U=y.getRequestSapStatistics(Q,R);if(U){if(!o.getParent()){s.addContent(o);s.addContent(t);s.addContent(r);s.addContent(u);s.addContent(v);s.addContent(w);s.addContent(x);}var V=U.statistics;r.setText(y.formatDuration(parseFloat(V.substring(V.indexOf("total=")+"total=".length,V.indexOf(",")))));V=V.substring(V.indexOf(",")+1);v.setText(y.formatDuration(parseFloat(V.substring(V.indexOf("fw=")+"fw=".length,V.indexOf(",")))));V=V.substring(V.indexOf(",")+1);x.setText(y.formatDuration(parseFloat(V.substring(V.indexOf("app=")+"app=".length,V.indexOf(",")))));}else if(o.getParent()){s.removeContent(o);s.removeContent(t);s.removeContent(r);s.removeContent(u);s.removeContent(v);s.removeContent(w);s.removeContent(x);}}function D(){var J=y.getRequestFromElement(q(this));g.setText(J.initiatorType||'');h.setText(J.entryType||'');n.setText(J.name);n.setHref(J.name);var K=y.getRequestDuration(J);var N=J.fetchStartOffset+J.startTime;var O=N+K;j.setText(y.formatTime(N));k.setText(y.formatTime(O));l.setText(y.formatDuration(K));}function E(){var J=y.getRequestFromElement(q(this));var K=J.fetchStartOffset;var N=y.getRequestDuration(J);var O=K+J.startTime;var Q=O+N;var R=y.getRequestRequestStart(J)+K;var U=y.getRequestResponseStart(J)+K;var V=R-O;var W=U-R;var X=Q-U;var Y=Math.floor(100*W/N);var Z=Math.floor(100*X/N);var $=Math.floor(100*V/N);var _='<span class="sapUiInteractionTitleSection"><div class="sapUiInteractionTitleText">{Title}</div><div class="sapUiInteractionTitleSubText">{Subtitle}</div></span>';var a1='<div class="sapUiInteractionTitle">';a1+=_.replace('{Title}','PREPROCESSING').replace('{Subtitle}',y.formatDuration(V));a1+=_.replace('{Title}','SERVER').replace('{Subtitle}',y.formatDuration(W));a1+=_.replace('{Title}','CLIENT').replace('{Subtitle}',y.formatDuration(X));a1+='</div>';e.setContent(a1);var b1=J.initiatorType||J.entryType;var c1=y.getRequestColorClass(b1);var d1=c1+'70';var e1="<span class='sapUiSupportIntProgressBar "+d1+"'' style=\"width:calc("+$+"% - 1px)\"></span><span class='sapUiSupportIntProgressBarSeparator'></span>";var f1="<span class='sapUiSupportIntProgressBar "+c1+"' style=\"width:calc("+Y+"% - 1px)\"></span>"+"<span class='sapUiSupportIntProgressBarSeparator'></span>";var g1="<span class='sapUiSupportIntProgressBar "+d1+"'' style=\"width:calc("+Z+"% - 1px)\"></span>";var h1="<div class='sapUiSupportIntProgressBarParent'>"+e1+f1+g1+"</div>";p.setContent(h1);}function F(){var A=new P({placement:c.Auto,contentWidth:"400px",showHeader:false,showArrow:true,verticalScrolling:true,horizontalScrolling:false,content:[G()]}).addStyleClass('sapUiSupportPopover');A.attachAfterOpen(function(J){J.getSource().$().focus();});return A;}function G(){e=new H();p=new H();f=new B({icon:I.getIconURI("decline"),type:"Transparent",press:function(){A.close();}}).addStyleClass("sapUiSupportReqPopoverCloseButton");f.setTooltip("Close");g=new T().addStyleClass("sapUiSupportIntRequestText");h=new T().addStyleClass("sapUiSupportIntRequestText");n=new a({target:"_blank",wrapping:true}).addStyleClass("sapUiSupportIntRequestLink");j=new T().addStyleClass("sapUiSupportIntRequestText");k=new T().addStyleClass("sapUiSupportIntRequestText");l=new T().addStyleClass("sapUiSupportIntRequestText");o=new b({text:"SAP STATISTICS FOR ODATA CALLS"});t=new L({text:"Gateway Total"}).addStyleClass("sapUiSupportIntRequestLabel");r=new T().addStyleClass("sapUiSupportIntRequestText");u=new L({text:"Framework"}).addStyleClass("sapUiSupportIntRequestLabel");v=new T().addStyleClass("sapUiSupportIntRequestText");w=new L({text:"Application"}).addStyleClass("sapUiSupportIntRequestLabel");x=new T().addStyleClass("sapUiSupportIntRequestText");s=new S({maxContainerCols:2,minWidth:400,labelMinWidth:100,editable:false,layout:"ResponsiveGridLayout",labelSpanM:3,emptySpanM:0,columnsM:1,breakpointM:0,content:[new b({text:"REQUEST DATA"}),new L({text:"Initiator Type"}).addStyleClass("sapUiSupportIntRequestLabel"),g,new L({text:"Entry Type"}).addStyleClass("sapUiSupportIntRequestLabel"),h,new L({text:"Name"}).addStyleClass("sapUiSupportIntRequestLabel"),n,new L({text:"Start Time"}).addStyleClass("sapUiSupportIntRequestLabel"),j,new L({text:"End Time"}).addStyleClass("sapUiSupportIntRequestLabel"),k,new L({text:"Duration"}).addStyleClass("sapUiSupportIntRequestLabel"),l]});return[e,p,f,s];}};d.prototype.getRequestFromElement=function($){var e=$.parents('li[data-request-index]');var f=$.parents('li[data-interaction-index]');var i=parseInt(f.attr('data-interaction-index'));var r=parseInt(e.attr('data-request-index'));var g=this.interactions[i].requests[r];return g;};d.prototype.attachInteractionDetailsPopover=function(){var s,e,f,p,r,g,h,j,k;var t=this;var l=q('.sapUiInteractionItemDiv.sapUiInteractionTreeItem .sapUiInteractionTreeItemRight');if(l.length){var o=u();for(var i=0;i<l.length;i++){l[i].addEventListener('click',function(w){n.call(this);var x=q(this).children()[0];o.openBy(x);});}}function n(){var $=q(this).parent().parent();var w=parseInt($.attr('data-interaction-index'));var x=t.interactions[w];if(!x){return;}f.setText(t.formatDuration(x.duration));p.setText(t.formatDuration(x.duration-x.roundtrip));r.setText(t.formatDuration(x.requestTime));g.setText(t.formatDuration(x.roundtrip));h.setText(x.bytesReceived);j.setText(x.requests.length);k.setText(t.formatTime(x.start));}function u(){var o=new P({placement:c.Auto,contentWidth:"350px",showHeader:false,showArrow:true,verticalScrolling:true,horizontalScrolling:false,content:[v()]}).addStyleClass('sapUiSupportPopover');o.attachAfterOpen(function(E){E.getSource().$().focus();});return o;}function v(){e=new B({icon:I.getIconURI("decline"),type:"Transparent",press:function(){o.close();}}).addStyleClass("sapUiSupportIntPopoverCloseButton");e.setTooltip("Close");f=new T().addStyleClass("sapUiSupportIntRequestText");p=new T().addStyleClass("sapUiSupportIntRequestText");r=new T().addStyleClass("sapUiSupportIntRequestText");g=new T().addStyleClass("sapUiSupportIntRequestText");h=new T().addStyleClass("sapUiSupportIntRequestText");j=new T().addStyleClass("sapUiSupportIntRequestText");k=new T().addStyleClass("sapUiSupportIntRequestText");s=new S({maxContainerCols:2,minWidth:400,labelMinWidth:100,editable:false,layout:"ResponsiveGridLayout",labelSpanM:7,emptySpanM:0,columnsM:1,breakpointM:0,content:[new b({text:"INTERACTION DATA"}),new L({text:"Duration"}).addStyleClass("sapUiSupportIntRequestLabel"),f,new L({text:"Client Processing Duration"}).addStyleClass("sapUiSupportIntRequestLabel"),p,new L({text:"Total Requests Duration"}).addStyleClass("sapUiSupportIntRequestLabel"),r,new L({text:"Roundtrip Duration"}).addStyleClass("sapUiSupportIntRequestLabel"),g,new L({text:"Bytes Received"}).addStyleClass("sapUiSupportIntRequestLabel"),h,new L({text:"Request Count"}).addStyleClass("sapUiSupportIntRequestLabel"),j,new L({text:"Start Time"}).addStyleClass("sapUiSupportIntRequestLabel"),k]}).addStyleClass("sapUiSupportIntPopoverForm");return[e,s];}};d.prototype.renderRequestPart=function(r,s,e,f){if(this.actualStartTime>e||this.actualEndTime<s){return;}e=Math.min(e,this.actualEndTime);s=Math.max(s,this.actualStartTime);var l=100/this.timeRange*(s-this.actualStartTime);var g=100/this.timeRange*(e-this.actualStartTime);var w=g-l;r.write('<span style="margin-left: '+l+'%; width: '+w+'%" class="sapUiInteractionTimeframe sapUiInteractionTimeRequestFrame '+f+'"></span>');};d.prototype.getRequestDuration=function(r){if(r.duration>0){return r.duration;}var e=r.responseStart||r.requestStart||r.fetchStart;return e-r.startTime;};d.prototype.getRequestRequestStart=function(r){if(r.requestStart>0){return r.requestStart;}return r.fetchStart||r.startTime;};d.prototype.getRequestResponseStart=function(r){if(r.responseStart>0){return r.responseStart;}return r.requestStart||r.fetchStart||r.startTime;};d.prototype.pad0=function(i,w){return("000"+String(i)).slice(-w);};d.prototype.formatGridLineDuration=function(e){var o=this.actualStartTime-this.startTime;e+=o;return e>100?(e/1000).toFixed(2)+' s':e.toFixed(0)+' ms';};d.prototype.formatDuration=function(e){e=Math.max(e,0);if(e<3){return e.toFixed(2)+' ms';}return e>=1000?(e/1000).toFixed(3)+' s':e.toFixed(0)+' ms';};d.prototype.formatTime=function(n){var N=new Date(n);return this.pad0(N.getHours(),2)+":"+this.pad0(N.getMinutes(),2)+":"+this.pad0(N.getSeconds(),2)+"."+this.pad0(N.getMilliseconds(),3);};d.prototype.renderIcon=function(r,e){var h=this.getIconHTML(e);r.write(h);};d.prototype.getIconHTML=function(e){var i=e?d.collapseIcon:d.expandIcon;var f="sapUiIcon sapUiInteractionTreeIcon";if(g&&!g.suppressMirroring){f+=" sapUiIconMirrorInRTL";}var h='<span aria-hidden="true" expanded="'+e+'" class="'+f+'" ';var g=I.getIconInfo(i);if(g){h+='data-sap-ui-icon-content="'+g.content+'"';h+=' style="font-family:\'SAP-icons\'"';}h+="></span>";return h;};return d;});
